//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `FileServer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef ICEPATCH2_API_EXPORTS
#   define ICEPATCH2_API_EXPORTS
#endif
#include <IcePatch2/FileServer.h>
#include <IceUtil/PushDisableWarnings.h>
#include <Ice/LocalException.h>
#include <Ice/ValueFactory.h>
#include <Ice/OutgoingAsync.h>
#include <Ice/InputStream.h>
#include <Ice/OutputStream.h>
#include <Ice/LocalException.h>
#include <IceUtil/PopDisableWarnings.h>

#if defined(_MSC_VER)
#   pragma warning(disable:4458) // declaration of ... hides class member
#elif defined(__clang__)
#   pragma clang diagnostic ignored "-Wshadow"
#elif defined(__GNUC__)
#   pragma GCC diagnostic ignored "-Wshadow"
#endif

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit<::IcePatch2::PartitionOutOfRangeException> iceC_IcePatch2_PartitionOutOfRangeException_init("::IcePatch2::PartitionOutOfRangeException");

const ::IceInternal::DefaultUserExceptionFactoryInit<::IcePatch2::FileAccessException> iceC_IcePatch2_FileAccessException_init("::IcePatch2::FileAccessException");

const ::IceInternal::DefaultUserExceptionFactoryInit<::IcePatch2::FileSizeRangeException> iceC_IcePatch2_FileSizeRangeException_init("::IcePatch2::FileSizeRangeException");

const ::std::string iceC_IcePatch2_FileServer_ids[2] =
{
    "::Ice::Object",
    "::IcePatch2::FileServer"
};
const ::std::string iceC_IcePatch2_FileServer_ops[] =
{
    "getChecksum",
    "getChecksumSeq",
    "getFileCompressed",
    "getFileInfoSeq",
    "getLargeFileCompressed",
    "getLargeFileInfoSeq",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_IcePatch2_FileServer_getFileInfoSeq_name = "getFileInfoSeq";
const ::std::string iceC_IcePatch2_FileServer_getLargeFileInfoSeq_name = "getLargeFileInfoSeq";
const ::std::string iceC_IcePatch2_FileServer_getChecksumSeq_name = "getChecksumSeq";
const ::std::string iceC_IcePatch2_FileServer_getChecksum_name = "getChecksum";
const ::std::string iceC_IcePatch2_FileServer_getFileCompressed_name = "getFileCompressed";
const ::std::string iceC_IcePatch2_FileServer_getLargeFileCompressed_name = "getLargeFileCompressed";

}

IcePatch2::PartitionOutOfRangeException::~PartitionOutOfRangeException()
{
}

const ::std::string&
IcePatch2::PartitionOutOfRangeException::ice_staticId()
{
    static const ::std::string typeId = "::IcePatch2::PartitionOutOfRangeException";
    return typeId;
}

IcePatch2::FileAccessException::~FileAccessException()
{
}

const ::std::string&
IcePatch2::FileAccessException::ice_staticId()
{
    static const ::std::string typeId = "::IcePatch2::FileAccessException";
    return typeId;
}

IcePatch2::FileSizeRangeException::~FileSizeRangeException()
{
}

const ::std::string&
IcePatch2::FileSizeRangeException::ice_staticId()
{
    static const ::std::string typeId = "::IcePatch2::FileSizeRangeException";
    return typeId;
}

bool
IcePatch2::FileServer::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IcePatch2_FileServer_ids, iceC_IcePatch2_FileServer_ids + 2, s);
}

::std::vector<::std::string>
IcePatch2::FileServer::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IcePatch2_FileServer_ids[0], &iceC_IcePatch2_FileServer_ids[2]);
}

::std::string
IcePatch2::FileServer::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IcePatch2::FileServer::ice_staticId()
{
    static const ::std::string typeId = "::IcePatch2::FileServer";
    return typeId;
}

/// \cond INTERNAL
bool
IcePatch2::FileServer::_iceD_getFileInfoSeq(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    int iceP_partition;
    istr->readAll(iceP_partition);
    inS.endReadParams();
    FileInfoSeq ret = this->getFileInfoSeq(iceP_partition, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IcePatch2::FileServer::_iceD_getLargeFileInfoSeq(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    int iceP_partition;
    istr->readAll(iceP_partition);
    inS.endReadParams();
    LargeFileInfoSeq ret = this->getLargeFileInfoSeq(iceP_partition, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IcePatch2::FileServer::_iceD_getChecksumSeq(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ByteSeqSeq ret = this->getChecksumSeq(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IcePatch2::FileServer::_iceD_getChecksum(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::ByteSeq ret = this->getChecksum(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IcePatch2::FileServer::_iceD_getFileCompressed(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_path;
    int iceP_pos;
    int iceP_num;
    istr->readAll(iceP_path, iceP_pos, iceP_num);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    auto responseCB = [inA](const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>& ret)
    {
        auto ostr = inA->startWriteParams();
        ostr->writeAll(ret);
        inA->endWriteParams();
        inA->completed();
    };
    this->getFileCompressedAsync(::std::move(iceP_path), iceP_pos, iceP_num, responseCB, inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IcePatch2::FileServer::_iceD_getLargeFileCompressed(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_path;
    long long int iceP_pos;
    int iceP_num;
    istr->readAll(iceP_path, iceP_pos, iceP_num);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    auto responseCB = [inA](const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>& ret)
    {
        auto ostr = inA->startWriteParams();
        ostr->writeAll(ret);
        inA->endWriteParams();
        inA->completed();
    };
    this->getLargeFileCompressedAsync(::std::move(iceP_path), iceP_pos, iceP_num, responseCB, inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IcePatch2::FileServer::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IcePatch2_FileServer_ops, iceC_IcePatch2_FileServer_ops + 10, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IcePatch2_FileServer_ops)
    {
        case 0:
        {
            return _iceD_getChecksum(in, current);
        }
        case 1:
        {
            return _iceD_getChecksumSeq(in, current);
        }
        case 2:
        {
            return _iceD_getFileCompressed(in, current);
        }
        case 3:
        {
            return _iceD_getFileInfoSeq(in, current);
        }
        case 4:
        {
            return _iceD_getLargeFileCompressed(in, current);
        }
        case 5:
        {
            return _iceD_getLargeFileInfoSeq(in, current);
        }
        case 6:
        {
            return _iceD_ice_id(in, current);
        }
        case 7:
        {
            return _iceD_ice_ids(in, current);
        }
        case 8:
        {
            return _iceD_ice_isA(in, current);
        }
        case 9:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond INTERNAL
void
IcePatch2::FileServerPrx::_iceI_getFileInfoSeq(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IcePatch2::FileInfoSeq>>& outAsync, int iceP_partition, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IcePatch2_FileServer_getFileInfoSeq_name);
    outAsync->invoke(iceC_IcePatch2_FileServer_getFileInfoSeq_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_partition);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const FileSizeRangeException&)
            {
                throw;
            }
            catch(const PartitionOutOfRangeException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IcePatch2::FileServerPrx::_iceI_getLargeFileInfoSeq(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IcePatch2::LargeFileInfoSeq>>& outAsync, int iceP_partition, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IcePatch2_FileServer_getLargeFileInfoSeq_name);
    outAsync->invoke(iceC_IcePatch2_FileServer_getLargeFileInfoSeq_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_partition);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const PartitionOutOfRangeException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IcePatch2::FileServerPrx::_iceI_getChecksumSeq(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IcePatch2::ByteSeqSeq>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IcePatch2_FileServer_getChecksumSeq_name);
    outAsync->invoke(iceC_IcePatch2_FileServer_getChecksumSeq_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IcePatch2::FileServerPrx::_iceI_getChecksum(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ByteSeq>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IcePatch2_FileServer_getChecksum_name);
    outAsync->invoke(iceC_IcePatch2_FileServer_getChecksum_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

::std::function<void()>
IcePatch2::FileServerPrx::getFileCompressedAsync(const ::std::string& iceP_path, int iceP_pos, int iceP_num,
                                                 ::std::function<void (::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>)> response,
                                                 ::std::function<void(::std::exception_ptr)> ex,
                                                 ::std::function<void(bool)> sent,
                                                 const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IcePatch2_FileServer_getFileCompressed_name);
    ::std::function<void(::Ice::InputStream*)> read;
    if(response)
    {
        read = [response](::Ice::InputStream* istr)
        {
            istr->startEncapsulation();
            ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*> ret;
            istr->readAll(ret);
            istr->endEncapsulation();
            try
            {
                response(ret);
            }
            catch(...)
            {
                throw ::std::current_exception();
            }
        };
    }
    auto outAsync = ::std::make_shared<::IceInternal::CustomLambdaOutgoing>(shared_from_this(), read, ex, sent);

    outAsync->invoke(iceC_IcePatch2_FileServer_getFileCompressed_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_path, iceP_pos, iceP_num);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const FileSizeRangeException&)
            {
                throw;
            }
            catch(const FileAccessException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
    return [outAsync]() { outAsync->cancel(); };
}

/// \cond INTERNAL
void
IcePatch2::FileServerPrx::_iceI_getFileCompressed(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ByteSeq>>& outAsync, const ::std::string& iceP_path, int iceP_pos, int iceP_num, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IcePatch2_FileServer_getFileCompressed_name);
    outAsync->invoke(iceC_IcePatch2_FileServer_getFileCompressed_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_path, iceP_pos, iceP_num);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const FileSizeRangeException&)
            {
                throw;
            }
            catch(const FileAccessException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

::std::function<void()>
IcePatch2::FileServerPrx::getLargeFileCompressedAsync(const ::std::string& iceP_path, long long int iceP_pos, int iceP_num,
                                                      ::std::function<void (::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>)> response,
                                                      ::std::function<void(::std::exception_ptr)> ex,
                                                      ::std::function<void(bool)> sent,
                                                      const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IcePatch2_FileServer_getLargeFileCompressed_name);
    ::std::function<void(::Ice::InputStream*)> read;
    if(response)
    {
        read = [response](::Ice::InputStream* istr)
        {
            istr->startEncapsulation();
            ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*> ret;
            istr->readAll(ret);
            istr->endEncapsulation();
            try
            {
                response(ret);
            }
            catch(...)
            {
                throw ::std::current_exception();
            }
        };
    }
    auto outAsync = ::std::make_shared<::IceInternal::CustomLambdaOutgoing>(shared_from_this(), read, ex, sent);

    outAsync->invoke(iceC_IcePatch2_FileServer_getLargeFileCompressed_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_path, iceP_pos, iceP_num);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const FileAccessException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
    return [outAsync]() { outAsync->cancel(); };
}

/// \cond INTERNAL
void
IcePatch2::FileServerPrx::_iceI_getLargeFileCompressed(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ByteSeq>>& outAsync, const ::std::string& iceP_path, long long int iceP_pos, int iceP_num, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IcePatch2_FileServer_getLargeFileCompressed_name);
    outAsync->invoke(iceC_IcePatch2_FileServer_getLargeFileCompressed_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_path, iceP_pos, iceP_num);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const FileAccessException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IcePatch2::FileServerPrx::_newInstance() const
{
    return ::IceInternal::createProxy<FileServerPrx>();
}
/// \endcond

const ::std::string&
IcePatch2::FileServerPrx::ice_staticId()
{
    return FileServer::ice_staticId();
}

#else // C++98 mapping

namespace
{

const ::std::string iceC_IcePatch2_FileServer_getFileInfoSeq_name = "getFileInfoSeq";

const ::std::string iceC_IcePatch2_FileServer_getLargeFileInfoSeq_name = "getLargeFileInfoSeq";

const ::std::string iceC_IcePatch2_FileServer_getChecksumSeq_name = "getChecksumSeq";

const ::std::string iceC_IcePatch2_FileServer_getChecksum_name = "getChecksum";

const ::std::string iceC_IcePatch2_FileServer_getFileCompressed_name = "getFileCompressed";

const ::std::string iceC_IcePatch2_FileServer_getLargeFileCompressed_name = "getLargeFileCompressed";

}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IcePatch2::PartitionOutOfRangeException> iceC_IcePatch2_PartitionOutOfRangeException_init("::IcePatch2::PartitionOutOfRangeException");

}

#ifdef ICE_CPP11_COMPILER
IcePatch2::PartitionOutOfRangeException::~PartitionOutOfRangeException()
{
}
#else
IcePatch2::PartitionOutOfRangeException::~PartitionOutOfRangeException() throw()
{
}
#endif

::std::string
IcePatch2::PartitionOutOfRangeException::ice_id() const
{
    return "::IcePatch2::PartitionOutOfRangeException";
}

IcePatch2::PartitionOutOfRangeException*
IcePatch2::PartitionOutOfRangeException::ice_clone() const
{
    return new PartitionOutOfRangeException(*this);
}

void
IcePatch2::PartitionOutOfRangeException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IcePatch2::PartitionOutOfRangeException::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IcePatch2::PartitionOutOfRangeException", -1, true);
    ::Ice::StreamWriter< PartitionOutOfRangeException, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IcePatch2::PartitionOutOfRangeException::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< PartitionOutOfRangeException, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IcePatch2::FileAccessException> iceC_IcePatch2_FileAccessException_init("::IcePatch2::FileAccessException");

}

IcePatch2::FileAccessException::FileAccessException(const ::std::string& reason) :
    ::Ice::UserException(),
    reason(reason)
{
}

#ifdef ICE_CPP11_COMPILER
IcePatch2::FileAccessException::~FileAccessException()
{
}
#else
IcePatch2::FileAccessException::~FileAccessException() throw()
{
}
#endif

::std::string
IcePatch2::FileAccessException::ice_id() const
{
    return "::IcePatch2::FileAccessException";
}

IcePatch2::FileAccessException*
IcePatch2::FileAccessException::ice_clone() const
{
    return new FileAccessException(*this);
}

void
IcePatch2::FileAccessException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IcePatch2::FileAccessException::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IcePatch2::FileAccessException", -1, true);
    ::Ice::StreamWriter< FileAccessException, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IcePatch2::FileAccessException::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< FileAccessException, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IcePatch2::FileSizeRangeException> iceC_IcePatch2_FileSizeRangeException_init("::IcePatch2::FileSizeRangeException");

}

IcePatch2::FileSizeRangeException::FileSizeRangeException(const ::std::string& reason) :
    FileAccessException(reason)
{
}

#ifdef ICE_CPP11_COMPILER
IcePatch2::FileSizeRangeException::~FileSizeRangeException()
{
}
#else
IcePatch2::FileSizeRangeException::~FileSizeRangeException() throw()
{
}
#endif

::std::string
IcePatch2::FileSizeRangeException::ice_id() const
{
    return "::IcePatch2::FileSizeRangeException";
}

IcePatch2::FileSizeRangeException*
IcePatch2::FileSizeRangeException::ice_clone() const
{
    return new FileSizeRangeException(*this);
}

void
IcePatch2::FileSizeRangeException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IcePatch2::FileSizeRangeException::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IcePatch2::FileSizeRangeException", -1, false);
    ::Ice::StreamWriter< FileSizeRangeException, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
    FileAccessException::_writeImpl(ostr);
}

void
IcePatch2::FileSizeRangeException::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< FileSizeRangeException, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
    FileAccessException::_readImpl(istr);
}
/// \endcond

IcePatch2::AMD_FileServer_getFileCompressed::~AMD_FileServer_getFileCompressed()
{
}

IcePatch2::AMD_FileServer_getLargeFileCompressed::~AMD_FileServer_getLargeFileCompressed()
{
}

/// \cond INTERNAL
IceAsync::IcePatch2::AMD_FileServer_getFileCompressed::AMD_FileServer_getFileCompressed(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IcePatch2::AMD_FileServer_getFileCompressed::ice_response(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>& ret)
{
    ::Ice::OutputStream* ostr = startWriteParams();
    ostr->write(ret);
    endWriteParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::IcePatch2::AMD_FileServer_getLargeFileCompressed::AMD_FileServer_getLargeFileCompressed(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IcePatch2::AMD_FileServer_getLargeFileCompressed::ice_response(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>& ret)
{
    ::Ice::OutputStream* ostr = startWriteParams();
    ostr->write(ret);
    endWriteParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
ICEPATCH2_API ::IceProxy::Ice::Object* ::IceProxy::IcePatch2::upCast(FileServer* p) { return p; }

void
::IceProxy::IcePatch2::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< FileServer>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new FileServer;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IcePatch2::FileServer::_iceI_begin_getFileInfoSeq(::Ice::Int iceP_partition, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IcePatch2_FileServer_getFileInfoSeq_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IcePatch2_FileServer_getFileInfoSeq_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IcePatch2_FileServer_getFileInfoSeq_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_partition);
        result->endWriteParams();
        result->invoke(iceC_IcePatch2_FileServer_getFileInfoSeq_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IcePatch2::FileInfoSeq
IceProxy::IcePatch2::FileServer::end_getFileInfoSeq(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IcePatch2_FileServer_getFileInfoSeq_name);
    ::IcePatch2::FileInfoSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IcePatch2::FileSizeRangeException&)
        {
            throw;
        }
        catch(const ::IcePatch2::PartitionOutOfRangeException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IcePatch2::FileServer::_iceI_begin_getLargeFileInfoSeq(::Ice::Int iceP_partition, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IcePatch2_FileServer_getLargeFileInfoSeq_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IcePatch2_FileServer_getLargeFileInfoSeq_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IcePatch2_FileServer_getLargeFileInfoSeq_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_partition);
        result->endWriteParams();
        result->invoke(iceC_IcePatch2_FileServer_getLargeFileInfoSeq_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IcePatch2::LargeFileInfoSeq
IceProxy::IcePatch2::FileServer::end_getLargeFileInfoSeq(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IcePatch2_FileServer_getLargeFileInfoSeq_name);
    ::IcePatch2::LargeFileInfoSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IcePatch2::PartitionOutOfRangeException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IcePatch2::FileServer::_iceI_begin_getChecksumSeq(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IcePatch2_FileServer_getChecksumSeq_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IcePatch2_FileServer_getChecksumSeq_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IcePatch2_FileServer_getChecksumSeq_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IcePatch2_FileServer_getChecksumSeq_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IcePatch2::ByteSeqSeq
IceProxy::IcePatch2::FileServer::end_getChecksumSeq(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IcePatch2_FileServer_getChecksumSeq_name);
    ::IcePatch2::ByteSeqSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IcePatch2::FileServer::_iceI_begin_getChecksum(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IcePatch2_FileServer_getChecksum_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IcePatch2_FileServer_getChecksum_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IcePatch2_FileServer_getChecksum_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IcePatch2_FileServer_getChecksum_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ByteSeq
IceProxy::IcePatch2::FileServer::end_getChecksum(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IcePatch2_FileServer_getChecksum_name);
    ::Ice::ByteSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IcePatch2::FileServer::_iceI_begin_getFileCompressed(const ::std::string& iceP_path, ::Ice::Int iceP_pos, ::Ice::Int iceP_num, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IcePatch2_FileServer_getFileCompressed_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IcePatch2_FileServer_getFileCompressed_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IcePatch2_FileServer_getFileCompressed_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_path);
        ostr->write(iceP_pos);
        ostr->write(iceP_num);
        result->endWriteParams();
        result->invoke(iceC_IcePatch2_FileServer_getFileCompressed_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ByteSeq
IceProxy::IcePatch2::FileServer::end_getFileCompressed(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IcePatch2_FileServer_getFileCompressed_name);
    ::Ice::ByteSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IcePatch2::FileSizeRangeException&)
        {
            throw;
        }
        catch(const ::IcePatch2::FileAccessException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

void IceProxy::IcePatch2::FileServer::_iceI_end_getFileCompressed(::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>& ret, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IcePatch2_FileServer_getFileCompressed_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IcePatch2::FileSizeRangeException&)
        {
            throw;
        }
        catch(const ::IcePatch2::FileAccessException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
}

::Ice::AsyncResultPtr
IceProxy::IcePatch2::FileServer::_iceI_begin_getLargeFileCompressed(const ::std::string& iceP_path, ::Ice::Long iceP_pos, ::Ice::Int iceP_num, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IcePatch2_FileServer_getLargeFileCompressed_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IcePatch2_FileServer_getLargeFileCompressed_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IcePatch2_FileServer_getLargeFileCompressed_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_path);
        ostr->write(iceP_pos);
        ostr->write(iceP_num);
        result->endWriteParams();
        result->invoke(iceC_IcePatch2_FileServer_getLargeFileCompressed_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ByteSeq
IceProxy::IcePatch2::FileServer::end_getLargeFileCompressed(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IcePatch2_FileServer_getLargeFileCompressed_name);
    ::Ice::ByteSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IcePatch2::FileAccessException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

void IceProxy::IcePatch2::FileServer::_iceI_end_getLargeFileCompressed(::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>& ret, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IcePatch2_FileServer_getLargeFileCompressed_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IcePatch2::FileAccessException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IcePatch2::FileServer::_newInstance() const
{
    return new FileServer;
}
/// \endcond

const ::std::string&
IceProxy::IcePatch2::FileServer::ice_staticId()
{
    return ::IcePatch2::FileServer::ice_staticId();
}

IcePatch2::FileServer::~FileServer()
{
}

/// \cond INTERNAL
ICEPATCH2_API ::Ice::Object* IcePatch2::upCast(FileServer* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IcePatch2_FileServer_ids[2] =
{
    "::Ice::Object",
    "::IcePatch2::FileServer"
};

}

bool
IcePatch2::FileServer::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IcePatch2_FileServer_ids, iceC_IcePatch2_FileServer_ids + 2, s);
}

::std::vector< ::std::string>
IcePatch2::FileServer::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IcePatch2_FileServer_ids[0], &iceC_IcePatch2_FileServer_ids[2]);
}

const ::std::string&
IcePatch2::FileServer::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IcePatch2::FileServer::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IcePatch2::FileServer";
    return typeId;
#else
    return iceC_IcePatch2_FileServer_ids[1];
#endif
}

/// \cond INTERNAL
bool
IcePatch2::FileServer::_iceD_getFileInfoSeq(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::Int iceP_partition;
    istr->read(iceP_partition);
    inS.endReadParams();
    FileInfoSeq ret = this->getFileInfoSeq(iceP_partition, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IcePatch2::FileServer::_iceD_getLargeFileInfoSeq(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::Int iceP_partition;
    istr->read(iceP_partition);
    inS.endReadParams();
    LargeFileInfoSeq ret = this->getLargeFileInfoSeq(iceP_partition, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IcePatch2::FileServer::_iceD_getChecksumSeq(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ByteSeqSeq ret = this->getChecksumSeq(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IcePatch2::FileServer::_iceD_getChecksum(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::ByteSeq ret = this->getChecksum(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IcePatch2::FileServer::_iceD_getFileCompressed(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_path;
    ::Ice::Int iceP_pos;
    ::Ice::Int iceP_num;
    istr->read(iceP_path);
    istr->read(iceP_pos);
    istr->read(iceP_num);
    inS.endReadParams();
    this->getFileCompressed_async(new IceAsync::IcePatch2::AMD_FileServer_getFileCompressed(inS), iceP_path, iceP_pos, iceP_num, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IcePatch2::FileServer::_iceD_getLargeFileCompressed(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_path;
    ::Ice::Long iceP_pos;
    ::Ice::Int iceP_num;
    istr->read(iceP_path);
    istr->read(iceP_pos);
    istr->read(iceP_num);
    inS.endReadParams();
    this->getLargeFileCompressed_async(new IceAsync::IcePatch2::AMD_FileServer_getLargeFileCompressed(inS), iceP_path, iceP_pos, iceP_num, current);
    return false;
}
/// \endcond

namespace
{
const ::std::string iceC_IcePatch2_FileServer_all[] =
{
    "getChecksum",
    "getChecksumSeq",
    "getFileCompressed",
    "getFileInfoSeq",
    "getLargeFileCompressed",
    "getLargeFileInfoSeq",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
IcePatch2::FileServer::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IcePatch2_FileServer_all, iceC_IcePatch2_FileServer_all + 10, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IcePatch2_FileServer_all)
    {
        case 0:
        {
            return _iceD_getChecksum(in, current);
        }
        case 1:
        {
            return _iceD_getChecksumSeq(in, current);
        }
        case 2:
        {
            return _iceD_getFileCompressed(in, current);
        }
        case 3:
        {
            return _iceD_getFileInfoSeq(in, current);
        }
        case 4:
        {
            return _iceD_getLargeFileCompressed(in, current);
        }
        case 5:
        {
            return _iceD_getLargeFileInfoSeq(in, current);
        }
        case 6:
        {
            return _iceD_ice_id(in, current);
        }
        case 7:
        {
            return _iceD_ice_ids(in, current);
        }
        case 8:
        {
            return _iceD_ice_isA(in, current);
        }
        case 9:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IcePatch2::FileServer::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< FileServer, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IcePatch2::FileServer::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< FileServer, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IcePatch2::_icePatchObjectPtr(FileServerPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = FileServerPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(FileServer::ice_staticId(), v);
    }
}
/// \endcond

namespace Ice
{
}

#endif
