/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIntegrityPolicyViolationReportBody.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsIntegrityPolicyViolationReportBodyPrototypeFunction_toJSON);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsIntegrityPolicyViolationReportBody_documentURL);
static JSC_DECLARE_CUSTOM_GETTER(jsIntegrityPolicyViolationReportBody_blockedURL);
static JSC_DECLARE_CUSTOM_GETTER(jsIntegrityPolicyViolationReportBody_destination);
static JSC_DECLARE_CUSTOM_GETTER(jsIntegrityPolicyViolationReportBody_reportOnly);

class JSIntegrityPolicyViolationReportBodyPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIntegrityPolicyViolationReportBodyPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIntegrityPolicyViolationReportBodyPrototype* ptr = new (NotNull, JSC::allocateCell<JSIntegrityPolicyViolationReportBodyPrototype>(vm)) JSIntegrityPolicyViolationReportBodyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIntegrityPolicyViolationReportBodyPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIntegrityPolicyViolationReportBodyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIntegrityPolicyViolationReportBodyPrototype, JSIntegrityPolicyViolationReportBodyPrototype::Base);

/* Hash table for prototype */

static const std::array<HashTableValue, 5> JSIntegrityPolicyViolationReportBodyPrototypeTableValues {
    HashTableValue { "documentURL"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIntegrityPolicyViolationReportBody_documentURL, 0 } },
    HashTableValue { "blockedURL"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIntegrityPolicyViolationReportBody_blockedURL, 0 } },
    HashTableValue { "destination"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIntegrityPolicyViolationReportBody_destination, 0 } },
    HashTableValue { "reportOnly"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIntegrityPolicyViolationReportBody_reportOnly, 0 } },
    HashTableValue { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIntegrityPolicyViolationReportBodyPrototypeFunction_toJSON, 0 } },
};

const ClassInfo JSIntegrityPolicyViolationReportBodyPrototype::s_info = { "IntegrityPolicyViolationReportBody"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIntegrityPolicyViolationReportBodyPrototype) };

void JSIntegrityPolicyViolationReportBodyPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIntegrityPolicyViolationReportBody::info(), JSIntegrityPolicyViolationReportBodyPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSIntegrityPolicyViolationReportBody::s_info = { "IntegrityPolicyViolationReportBody"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIntegrityPolicyViolationReportBody) };

JSIntegrityPolicyViolationReportBody::JSIntegrityPolicyViolationReportBody(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IntegrityPolicyViolationReportBody>&& impl)
    : JSReportBody(structure, globalObject, WTFMove(impl))
{
}

Ref<IntegrityPolicyViolationReportBody> JSIntegrityPolicyViolationReportBody::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, IntegrityPolicyViolationReportBody>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSIntegrityPolicyViolationReportBody::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSIntegrityPolicyViolationReportBodyPrototype::createStructure(vm, &globalObject, JSReportBody::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSIntegrityPolicyViolationReportBodyPrototype::create(vm, &globalObject, structure);
}

JSObject* JSIntegrityPolicyViolationReportBody::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIntegrityPolicyViolationReportBody>(vm, globalObject);
}

static inline JSValue jsIntegrityPolicyViolationReportBody_documentURLGetter(JSGlobalObject& lexicalGlobalObject, JSIntegrityPolicyViolationReportBody& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.documentURL())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIntegrityPolicyViolationReportBody_documentURL, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIntegrityPolicyViolationReportBody>::get<jsIntegrityPolicyViolationReportBody_documentURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIntegrityPolicyViolationReportBody_blockedURLGetter(JSGlobalObject& lexicalGlobalObject, JSIntegrityPolicyViolationReportBody& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.blockedURL())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIntegrityPolicyViolationReportBody_blockedURL, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIntegrityPolicyViolationReportBody>::get<jsIntegrityPolicyViolationReportBody_blockedURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIntegrityPolicyViolationReportBody_destinationGetter(JSGlobalObject& lexicalGlobalObject, JSIntegrityPolicyViolationReportBody& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.destination())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIntegrityPolicyViolationReportBody_destination, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIntegrityPolicyViolationReportBody>::get<jsIntegrityPolicyViolationReportBody_destinationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIntegrityPolicyViolationReportBody_reportOnlyGetter(JSGlobalObject& lexicalGlobalObject, JSIntegrityPolicyViolationReportBody& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.reportOnly())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIntegrityPolicyViolationReportBody_reportOnly, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIntegrityPolicyViolationReportBody>::get<jsIntegrityPolicyViolationReportBody_reportOnlyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline EncodedJSValue jsIntegrityPolicyViolationReportBodyPrototypeFunction_toJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSIntegrityPolicyViolationReportBody* castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto* result = constructEmptyObject(lexicalGlobalObject);
    auto documentURLValue = toJS<IDLUSVString>(*lexicalGlobalObject, throwScope, impl.documentURL());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "documentURL"_s), documentURLValue);
    auto blockedURLValue = toJS<IDLUSVString>(*lexicalGlobalObject, throwScope, impl.blockedURL());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "blockedURL"_s), blockedURLValue);
    auto destinationValue = toJS<IDLUSVString>(*lexicalGlobalObject, throwScope, impl.destination());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "destination"_s), destinationValue);
    auto reportOnlyValue = toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.reportOnly());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "reportOnly"_s), reportOnlyValue);
    return JSValue::encode(result);
}

JSC_DEFINE_HOST_FUNCTION(jsIntegrityPolicyViolationReportBodyPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIntegrityPolicyViolationReportBody>::call<jsIntegrityPolicyViolationReportBodyPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

JSC::GCClient::IsoSubspace* JSIntegrityPolicyViolationReportBody::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSIntegrityPolicyViolationReportBody, UseCustomHeapCellType::No>(vm, "JSIntegrityPolicyViolationReportBody"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForIntegrityPolicyViolationReportBody.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForIntegrityPolicyViolationReportBody = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForIntegrityPolicyViolationReportBody.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForIntegrityPolicyViolationReportBody = std::forward<decltype(space)>(space); }
    );
}

void JSIntegrityPolicyViolationReportBody::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIntegrityPolicyViolationReportBody*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
