/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIDBKeyRange.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertIndexedDB.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSIDBKeyRange.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsIDBKeyRangeConstructorFunction_only);
static JSC_DECLARE_HOST_FUNCTION(jsIDBKeyRangeConstructorFunction_lowerBound);
static JSC_DECLARE_HOST_FUNCTION(jsIDBKeyRangeConstructorFunction_upperBound);
static JSC_DECLARE_HOST_FUNCTION(jsIDBKeyRangeConstructorFunction_bound);
static JSC_DECLARE_HOST_FUNCTION(jsIDBKeyRangePrototypeFunction_includes);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsIDBKeyRangeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBKeyRange_lower);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBKeyRange_upper);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBKeyRange_lowerOpen);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBKeyRange_upperOpen);

class JSIDBKeyRangePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIDBKeyRangePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBKeyRangePrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBKeyRangePrototype>(vm)) JSIDBKeyRangePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBKeyRangePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBKeyRangePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBKeyRangePrototype, JSIDBKeyRangePrototype::Base);

using JSIDBKeyRangeDOMConstructor = JSDOMConstructorNotConstructable<JSIDBKeyRange>;

/* Hash table for constructor */

static const std::array<HashTableValue, 4> JSIDBKeyRangeConstructorTableValues {
    HashTableValue { "only"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBKeyRangeConstructorFunction_only, 1 } },
    HashTableValue { "lowerBound"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBKeyRangeConstructorFunction_lowerBound, 1 } },
    HashTableValue { "upperBound"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBKeyRangeConstructorFunction_upperBound, 1 } },
    HashTableValue { "bound"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBKeyRangeConstructorFunction_bound, 2 } },
};

template<> const ClassInfo JSIDBKeyRangeDOMConstructor::s_info = { "IDBKeyRange"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBKeyRangeDOMConstructor) };

template<> JSValue JSIDBKeyRangeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIDBKeyRangeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "IDBKeyRange"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSIDBKeyRange::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSIDBKeyRange::info(), JSIDBKeyRangeConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 6> JSIDBKeyRangePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBKeyRangeConstructor, 0 } },
    HashTableValue { "lower"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBKeyRange_lower, 0 } },
    HashTableValue { "upper"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBKeyRange_upper, 0 } },
    HashTableValue { "lowerOpen"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBKeyRange_lowerOpen, 0 } },
    HashTableValue { "upperOpen"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBKeyRange_upperOpen, 0 } },
    HashTableValue { "includes"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBKeyRangePrototypeFunction_includes, 1 } },
};

const ClassInfo JSIDBKeyRangePrototype::s_info = { "IDBKeyRange"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBKeyRangePrototype) };

void JSIDBKeyRangePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBKeyRange::info(), JSIDBKeyRangePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSIDBKeyRange::s_info = { "IDBKeyRange"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBKeyRange) };

JSIDBKeyRange::JSIDBKeyRange(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBKeyRange>&& impl)
    : JSDOMWrapper<IDBKeyRange>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, IDBKeyRange>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSIDBKeyRange::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSIDBKeyRangePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSIDBKeyRangePrototype::create(vm, &globalObject, structure);
}

JSObject* JSIDBKeyRange::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIDBKeyRange>(vm, globalObject);
}

JSValue JSIDBKeyRange::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBKeyRangeDOMConstructor, DOMConstructorID::IDBKeyRange>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIDBKeyRange::destroy(JSC::JSCell* cell)
{
    JSIDBKeyRange* thisObject = static_cast<JSIDBKeyRange*>(cell);
    thisObject->JSIDBKeyRange::~JSIDBKeyRange();
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBKeyRangeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBKeyRangePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIDBKeyRange::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsIDBKeyRange_lowerGetter(JSGlobalObject& lexicalGlobalObject, JSIDBKeyRange& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLIDBKey>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.lower())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBKeyRange_lower, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBKeyRange>::get<jsIDBKeyRange_lowerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBKeyRange_upperGetter(JSGlobalObject& lexicalGlobalObject, JSIDBKeyRange& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLIDBKey>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.upper())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBKeyRange_upper, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBKeyRange>::get<jsIDBKeyRange_upperGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBKeyRange_lowerOpenGetter(JSGlobalObject& lexicalGlobalObject, JSIDBKeyRange& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.lowerOpen())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBKeyRange_lowerOpen, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBKeyRange>::get<jsIDBKeyRange_lowerOpenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBKeyRange_upperOpenGetter(JSGlobalObject& lexicalGlobalObject, JSIDBKeyRange& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.upperOpen())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBKeyRange_upperOpen, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBKeyRange>::get<jsIDBKeyRange_upperOpenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsIDBKeyRangeConstructorFunction_onlyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBKeyRange>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, IDBKeyRange::only(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBKeyRangeConstructorFunction_only, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBKeyRange>::callStatic<jsIDBKeyRangeConstructorFunction_onlyBody>(*lexicalGlobalObject, *callFrame, "only");
}

static inline JSC::EncodedJSValue jsIDBKeyRangeConstructorFunction_lowerBoundBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto lowerConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (lowerConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto openConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    if (openConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBKeyRange>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, IDBKeyRange::lowerBound(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), lowerConversionResult.releaseReturnValue(), openConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBKeyRangeConstructorFunction_lowerBound, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBKeyRange>::callStatic<jsIDBKeyRangeConstructorFunction_lowerBoundBody>(*lexicalGlobalObject, *callFrame, "lowerBound");
}

static inline JSC::EncodedJSValue jsIDBKeyRangeConstructorFunction_upperBoundBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto upperConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (upperConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto openConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    if (openConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBKeyRange>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, IDBKeyRange::upperBound(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), upperConversionResult.releaseReturnValue(), openConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBKeyRangeConstructorFunction_upperBound, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBKeyRange>::callStatic<jsIDBKeyRangeConstructorFunction_upperBoundBody>(*lexicalGlobalObject, *callFrame, "upperBound");
}

static inline JSC::EncodedJSValue jsIDBKeyRangeConstructorFunction_boundBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto lowerConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (lowerConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto upperConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument1.value());
    if (upperConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto lowerOpenConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument2.value());
    if (lowerOpenConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto upperOpenConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument3.value());
    if (upperOpenConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBKeyRange>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, IDBKeyRange::bound(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), lowerConversionResult.releaseReturnValue(), upperConversionResult.releaseReturnValue(), lowerOpenConversionResult.releaseReturnValue(), upperOpenConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBKeyRangeConstructorFunction_bound, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBKeyRange>::callStatic<jsIDBKeyRangeConstructorFunction_boundBody>(*lexicalGlobalObject, *callFrame, "bound");
}

static inline JSC::EncodedJSValue jsIDBKeyRangePrototypeFunction_includesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBKeyRange>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto keyConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (keyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.includes(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), keyConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBKeyRangePrototypeFunction_includes, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBKeyRange>::call<jsIDBKeyRangePrototypeFunction_includesBody>(*lexicalGlobalObject, *callFrame, "includes");
}

JSC::GCClient::IsoSubspace* JSIDBKeyRange::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSIDBKeyRange, UseCustomHeapCellType::No>(vm, "JSIDBKeyRange"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForIDBKeyRange.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForIDBKeyRange = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForIDBKeyRange.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForIDBKeyRange = std::forward<decltype(space)>(space); }
    );
}

void JSIDBKeyRange::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIDBKeyRange*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSIDBKeyRangeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSIDBKeyRangeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBKeyRange = static_cast<JSIDBKeyRange*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsIDBKeyRange->protectedWrapped().ptr(), jsIDBKeyRange);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7IDBKeyRange@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11IDBKeyRangeE[]; }
#endif
template<std::same_as<IDBKeyRange> T>
static inline void verifyVTable(IDBKeyRange* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7IDBKeyRange@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore11IDBKeyRangeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // IDBKeyRange has subclasses. If IDBKeyRange has subclasses that get passed
        // to toJS() we currently require IDBKeyRange you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IDBKeyRange>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<IDBKeyRange>(impl.ptr());
#endif
    return createWrapper<IDBKeyRange>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IDBKeyRange& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IDBKeyRange* JSIDBKeyRange::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBKeyRange*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
