/* DbusInterfaces.c generated by valac 0.56.17, the Vala compiler
 * generated from DbusInterfaces.vala, do not modify */

/*
 * Copyright (c) 2011-2017 elementary LLC. (http://launchpad.net/wingpanel)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "session.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_USER_INFO (user_info_get_type ())
typedef struct _UserInfo UserInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SESSION_INTERFACE (session_interface_get_type ())
#define SESSION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SESSION_INTERFACE, SessionInterface))
#define IS_SESSION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SESSION_INTERFACE))
#define SESSION_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SESSION_INTERFACE, SessionInterfaceIface))

typedef struct _SessionInterface SessionInterface;
typedef struct _SessionInterfaceIface SessionInterfaceIface;

#define TYPE_SESSION_INTERFACE_PROXY (session_interface_proxy_get_type ())
typedef GDBusProxy SessionInterfaceProxy;
typedef GDBusProxyClass SessionInterfaceProxyClass;
typedef struct _SessionInterfaceLogoutReadyData SessionInterfaceLogoutReadyData;
typedef struct _SessionInterfaceRebootReadyData SessionInterfaceRebootReadyData;
typedef struct _SessionInterfaceShutdownReadyData SessionInterfaceShutdownReadyData;

#define TYPE_LOCK_INTERFACE (lock_interface_get_type ())
#define LOCK_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCK_INTERFACE, LockInterface))
#define IS_LOCK_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCK_INTERFACE))
#define LOCK_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_LOCK_INTERFACE, LockInterfaceIface))

typedef struct _LockInterface LockInterface;
typedef struct _LockInterfaceIface LockInterfaceIface;

#define TYPE_LOCK_INTERFACE_PROXY (lock_interface_proxy_get_type ())
typedef GDBusProxy LockInterfaceProxy;
typedef GDBusProxyClass LockInterfaceProxyClass;

#define TYPE_SYSTEM_INTERFACE (system_interface_get_type ())
#define SYSTEM_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_INTERFACE, SystemInterface))
#define IS_SYSTEM_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_INTERFACE))
#define SYSTEM_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SYSTEM_INTERFACE, SystemInterfaceIface))

typedef struct _SystemInterface SystemInterface;
typedef struct _SystemInterfaceIface SystemInterfaceIface;

#define TYPE_SYSTEM_INTERFACE_PROXY (system_interface_proxy_get_type ())
typedef GDBusProxy SystemInterfaceProxy;
typedef GDBusProxyClass SystemInterfaceProxyClass;

#define TYPE_USER_INTERFACE (user_interface_get_type ())
#define USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INTERFACE, UserInterface))
#define IS_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INTERFACE))
#define USER_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_USER_INTERFACE, UserInterfaceIface))

typedef struct _UserInterface UserInterface;
typedef struct _UserInterfaceIface UserInterfaceIface;

#define TYPE_USER_INTERFACE_PROXY (user_interface_proxy_get_type ())
typedef GDBusProxy UserInterfaceProxy;
typedef GDBusProxyClass UserInterfaceProxyClass;

#define TYPE_SEAT_INTERFACE (seat_interface_get_type ())
#define SEAT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEAT_INTERFACE, SeatInterface))
#define IS_SEAT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEAT_INTERFACE))
#define SEAT_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SEAT_INTERFACE, SeatInterfaceIface))

typedef struct _SeatInterface SeatInterface;
typedef struct _SeatInterfaceIface SeatInterfaceIface;

#define TYPE_SEAT_INTERFACE_PROXY (seat_interface_proxy_get_type ())
typedef GDBusProxy SeatInterfaceProxy;
typedef GDBusProxyClass SeatInterfaceProxyClass;

struct _UserInfo {
	guint32 uid;
	gchar* user_name;
	char* user_object;
};

struct _SessionInterfaceIface {
	GTypeInterface parent_iface;
	void (*logout) (SessionInterface* self, guint type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*logout_finish) (SessionInterface* self, GAsyncResult* _res_, GError** error);
	void (*reboot) (SessionInterface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*reboot_finish) (SessionInterface* self, GAsyncResult* _res_, GError** error);
	void (*shutdown) (SessionInterface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*shutdown_finish) (SessionInterface* self, GAsyncResult* _res_, GError** error);
};

struct _SessionInterfaceLogoutReadyData {
	GDBusMethodInvocation* _invocation_;
	guint type;
};

struct _SessionInterfaceRebootReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _SessionInterfaceShutdownReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _LockInterfaceIface {
	GTypeInterface parent_iface;
	void (*lock) (LockInterface* self, GError** error);
};

struct _SystemInterfaceIface {
	GTypeInterface parent_iface;
	void (*suspend) (SystemInterface* self, gboolean interactive, GError** error);
	void (*reboot) (SystemInterface* self, gboolean interactive, GError** error);
	void (*power_off) (SystemInterface* self, gboolean interactive, GError** error);
	UserInfo* (*list_users) (SystemInterface* self, gint* result_length1, GError** error);
};

struct _UserInterfaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_state) (UserInterface* self);
};

struct _SeatInterfaceIface {
	GTypeInterface parent_iface;
	void (*switch_to_guest) (SeatInterface* self, const gchar* session_name, GError** error);
	void (*switch_to_user) (SeatInterface* self, const gchar* username, const gchar* session_name, GError** error);
	gboolean (*get_has_guest_account) (SeatInterface* self);
};

VALA_EXTERN GType user_info_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UserInfo* user_info_dup (const UserInfo* self);
VALA_EXTERN void user_info_free (UserInfo* self);
VALA_EXTERN void user_info_copy (const UserInfo* self,
                     UserInfo* dest);
VALA_EXTERN void user_info_destroy (UserInfo* self);
VALA_EXTERN GType session_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint session_interface_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
VALA_EXTERN GType session_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void session_interface_logout (SessionInterface* self,
                               guint type,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN void session_interface_logout_finish (SessionInterface* self,
                                      GAsyncResult* _res_,
                                      GError** error);
VALA_EXTERN void session_interface_reboot (SessionInterface* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN void session_interface_reboot_finish (SessionInterface* self,
                                      GAsyncResult* _res_,
                                      GError** error);
VALA_EXTERN void session_interface_shutdown (SessionInterface* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void session_interface_shutdown_finish (SessionInterface* self,
                                        GAsyncResult* _res_,
                                        GError** error);
static GType session_interface_get_type_once (void);
static void session_interface_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void session_interface_proxy_logout_async (SessionInterface* self,
                                           guint type,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void session_interface_proxy_logout_finish (SessionInterface* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void session_interface_proxy_reboot_async (SessionInterface* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void session_interface_proxy_reboot_finish (SessionInterface* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void session_interface_proxy_shutdown_async (SessionInterface* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void session_interface_proxy_shutdown_finish (SessionInterface* self,
                                              GAsyncResult* _res_,
                                              GError** error);
static void session_interface_proxy_session_interface_interface_init (SessionInterfaceIface* iface);
static void _dbus_session_interface_logout (SessionInterface* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void _dbus_session_interface_logout_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_);
static void _dbus_session_interface_reboot (SessionInterface* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void _dbus_session_interface_reboot_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_);
static void _dbus_session_interface_shutdown (SessionInterface* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void _dbus_session_interface_shutdown_ready (GObject * source_object,
                                             GAsyncResult * _res_,
                                             gpointer _user_data_);
static void session_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data);
static GVariant* session_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GError** error,
                                                         gpointer user_data);
static gboolean session_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data);
static void _session_interface_unregister_object (gpointer user_data);
VALA_EXTERN GType lock_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint lock_interface_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
VALA_EXTERN GType lock_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void lock_interface_lock (LockInterface* self,
                          GError** error);
static GType lock_interface_get_type_once (void);
static void lock_interface_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters);
static void lock_interface_proxy_lock (LockInterface* self,
                                GError** error);
static void lock_interface_proxy_lock_interface_interface_init (LockInterfaceIface* iface);
static void _dbus_lock_interface_lock (LockInterface* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation);
static void lock_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data);
static GVariant* lock_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data);
static gboolean lock_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data);
static void _lock_interface_unregister_object (gpointer user_data);
VALA_EXTERN GType system_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint system_interface_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType system_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void system_interface_suspend (SystemInterface* self,
                               gboolean interactive,
                               GError** error);
VALA_EXTERN void system_interface_reboot (SystemInterface* self,
                              gboolean interactive,
                              GError** error);
VALA_EXTERN void system_interface_power_off (SystemInterface* self,
                                 gboolean interactive,
                                 GError** error);
VALA_EXTERN UserInfo* system_interface_list_users (SystemInterface* self,
                                       gint* result_length1,
                                       GError** error);
static GType system_interface_get_type_once (void);
static void system_interface_proxy_g_signal (GDBusProxy* proxy,
                                      const gchar* sender_name,
                                      const gchar* signal_name,
                                      GVariant* parameters);
static void system_interface_proxy_suspend (SystemInterface* self,
                                     gboolean interactive,
                                     GError** error);
static void system_interface_proxy_reboot (SystemInterface* self,
                                    gboolean interactive,
                                    GError** error);
static void system_interface_proxy_power_off (SystemInterface* self,
                                       gboolean interactive,
                                       GError** error);
static UserInfo* system_interface_proxy_list_users (SystemInterface* self,
                                             gint* result_length1,
                                             GError** error);
static void system_interface_proxy_system_interface_interface_init (SystemInterfaceIface* iface);
static void _dbus_system_interface_suspend (SystemInterface* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void _dbus_system_interface_reboot (SystemInterface* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation);
static void _dbus_system_interface_power_off (SystemInterface* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void _vala_UserInfo_array_free (UserInfo * array,
                                gssize array_length);
static void _dbus_system_interface_list_users (SystemInterface* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void system_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data);
static GVariant* system_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data);
static gboolean system_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data);
static void _system_interface_unregister_object (gpointer user_data);
VALA_EXTERN GType user_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType user_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint user_interface_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
VALA_EXTERN gchar* user_interface_get_state (UserInterface* self);
static GType user_interface_get_type_once (void);
static void user_interface_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters);
static gchar* user_interface_dbus_proxy_get_state (UserInterface* self);
static void user_interface_proxy_user_interface_interface_init (UserInterfaceIface* iface);
static void user_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data);
static GVariant* user_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data);
static GVariant* _dbus_user_interface_get_state (UserInterface* self);
static gboolean user_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data);
static void _user_interface_unregister_object (gpointer user_data);
VALA_EXTERN GType seat_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint seat_interface_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
VALA_EXTERN GType seat_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void seat_interface_switch_to_guest (SeatInterface* self,
                                     const gchar* session_name,
                                     GError** error);
VALA_EXTERN void seat_interface_switch_to_user (SeatInterface* self,
                                    const gchar* username,
                                    const gchar* session_name,
                                    GError** error);
VALA_EXTERN gboolean seat_interface_get_has_guest_account (SeatInterface* self);
static GType seat_interface_get_type_once (void);
static void seat_interface_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters);
static void seat_interface_proxy_switch_to_guest (SeatInterface* self,
                                           const gchar* session_name,
                                           GError** error);
static void seat_interface_proxy_switch_to_user (SeatInterface* self,
                                          const gchar* username,
                                          const gchar* session_name,
                                          GError** error);
static gboolean seat_interface_dbus_proxy_get_has_guest_account (SeatInterface* self);
static void seat_interface_proxy_seat_interface_interface_init (SeatInterfaceIface* iface);
static void _dbus_seat_interface_switch_to_guest (SeatInterface* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_seat_interface_switch_to_user (SeatInterface* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void seat_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data);
static GVariant* seat_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data);
static GVariant* _dbus_seat_interface_get_has_guest_account (SeatInterface* self);
static gboolean seat_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data);
static void _seat_interface_unregister_object (gpointer user_data);

static const GDBusArgInfo _session_interface_dbus_arg_info_logout_type = {-1, "type", "u", NULL};
static const GDBusArgInfo * const _session_interface_dbus_arg_info_logout_in[] = {&_session_interface_dbus_arg_info_logout_type, NULL};
static const GDBusArgInfo * const _session_interface_dbus_arg_info_logout_out[] = {NULL};
static const GDBusMethodInfo _session_interface_dbus_method_info_logout = {-1, "Logout", (GDBusArgInfo **) (&_session_interface_dbus_arg_info_logout_in), (GDBusArgInfo **) (&_session_interface_dbus_arg_info_logout_out), NULL};
static const GDBusArgInfo * const _session_interface_dbus_arg_info_reboot_in[] = {NULL};
static const GDBusArgInfo * const _session_interface_dbus_arg_info_reboot_out[] = {NULL};
static const GDBusMethodInfo _session_interface_dbus_method_info_reboot = {-1, "Reboot", (GDBusArgInfo **) (&_session_interface_dbus_arg_info_reboot_in), (GDBusArgInfo **) (&_session_interface_dbus_arg_info_reboot_out), NULL};
static const GDBusArgInfo * const _session_interface_dbus_arg_info_shutdown_in[] = {NULL};
static const GDBusArgInfo * const _session_interface_dbus_arg_info_shutdown_out[] = {NULL};
static const GDBusMethodInfo _session_interface_dbus_method_info_shutdown = {-1, "Shutdown", (GDBusArgInfo **) (&_session_interface_dbus_arg_info_shutdown_in), (GDBusArgInfo **) (&_session_interface_dbus_arg_info_shutdown_out), NULL};
static const GDBusMethodInfo * const _session_interface_dbus_method_info[] = {&_session_interface_dbus_method_info_logout, &_session_interface_dbus_method_info_reboot, &_session_interface_dbus_method_info_shutdown, NULL};
static const GDBusSignalInfo * const _session_interface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _session_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _session_interface_dbus_interface_info = {-1, "org.gnome.SessionManager", (GDBusMethodInfo **) (&_session_interface_dbus_method_info), (GDBusSignalInfo **) (&_session_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_session_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _session_interface_dbus_interface_vtable = {session_interface_dbus_interface_method_call, session_interface_dbus_interface_get_property, session_interface_dbus_interface_set_property};
static const GDBusArgInfo * const _lock_interface_dbus_arg_info_lock_in[] = {NULL};
static const GDBusArgInfo * const _lock_interface_dbus_arg_info_lock_out[] = {NULL};
static const GDBusMethodInfo _lock_interface_dbus_method_info_lock = {-1, "Lock", (GDBusArgInfo **) (&_lock_interface_dbus_arg_info_lock_in), (GDBusArgInfo **) (&_lock_interface_dbus_arg_info_lock_out), NULL};
static const GDBusMethodInfo * const _lock_interface_dbus_method_info[] = {&_lock_interface_dbus_method_info_lock, NULL};
static const GDBusSignalInfo * const _lock_interface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _lock_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _lock_interface_dbus_interface_info = {-1, "org.gnome.ScreenSaver", (GDBusMethodInfo **) (&_lock_interface_dbus_method_info), (GDBusSignalInfo **) (&_lock_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_lock_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _lock_interface_dbus_interface_vtable = {lock_interface_dbus_interface_method_call, lock_interface_dbus_interface_get_property, lock_interface_dbus_interface_set_property};
static const GDBusArgInfo _system_interface_dbus_arg_info_suspend_interactive = {-1, "interactive", "b", NULL};
static const GDBusArgInfo * const _system_interface_dbus_arg_info_suspend_in[] = {&_system_interface_dbus_arg_info_suspend_interactive, NULL};
static const GDBusArgInfo * const _system_interface_dbus_arg_info_suspend_out[] = {NULL};
static const GDBusMethodInfo _system_interface_dbus_method_info_suspend = {-1, "Suspend", (GDBusArgInfo **) (&_system_interface_dbus_arg_info_suspend_in), (GDBusArgInfo **) (&_system_interface_dbus_arg_info_suspend_out), NULL};
static const GDBusArgInfo _system_interface_dbus_arg_info_reboot_interactive = {-1, "interactive", "b", NULL};
static const GDBusArgInfo * const _system_interface_dbus_arg_info_reboot_in[] = {&_system_interface_dbus_arg_info_reboot_interactive, NULL};
static const GDBusArgInfo * const _system_interface_dbus_arg_info_reboot_out[] = {NULL};
static const GDBusMethodInfo _system_interface_dbus_method_info_reboot = {-1, "Reboot", (GDBusArgInfo **) (&_system_interface_dbus_arg_info_reboot_in), (GDBusArgInfo **) (&_system_interface_dbus_arg_info_reboot_out), NULL};
static const GDBusArgInfo _system_interface_dbus_arg_info_power_off_interactive = {-1, "interactive", "b", NULL};
static const GDBusArgInfo * const _system_interface_dbus_arg_info_power_off_in[] = {&_system_interface_dbus_arg_info_power_off_interactive, NULL};
static const GDBusArgInfo * const _system_interface_dbus_arg_info_power_off_out[] = {NULL};
static const GDBusMethodInfo _system_interface_dbus_method_info_power_off = {-1, "PowerOff", (GDBusArgInfo **) (&_system_interface_dbus_arg_info_power_off_in), (GDBusArgInfo **) (&_system_interface_dbus_arg_info_power_off_out), NULL};
static const GDBusArgInfo _system_interface_dbus_arg_info_list_users_result = {-1, "result", "a(uso)", NULL};
static const GDBusArgInfo * const _system_interface_dbus_arg_info_list_users_in[] = {NULL};
static const GDBusArgInfo * const _system_interface_dbus_arg_info_list_users_out[] = {&_system_interface_dbus_arg_info_list_users_result, NULL};
static const GDBusMethodInfo _system_interface_dbus_method_info_list_users = {-1, "ListUsers", (GDBusArgInfo **) (&_system_interface_dbus_arg_info_list_users_in), (GDBusArgInfo **) (&_system_interface_dbus_arg_info_list_users_out), NULL};
static const GDBusMethodInfo * const _system_interface_dbus_method_info[] = {&_system_interface_dbus_method_info_suspend, &_system_interface_dbus_method_info_reboot, &_system_interface_dbus_method_info_power_off, &_system_interface_dbus_method_info_list_users, NULL};
static const GDBusSignalInfo * const _system_interface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _system_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _system_interface_dbus_interface_info = {-1, "org.freedesktop.login1.Manager", (GDBusMethodInfo **) (&_system_interface_dbus_method_info), (GDBusSignalInfo **) (&_system_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_system_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _system_interface_dbus_interface_vtable = {system_interface_dbus_interface_method_call, system_interface_dbus_interface_get_property, system_interface_dbus_interface_set_property};
static const GDBusMethodInfo * const _user_interface_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _user_interface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _user_interface_dbus_property_info_state = {-1, "State", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _user_interface_dbus_property_info[] = {&_user_interface_dbus_property_info_state, NULL};
static const GDBusInterfaceInfo _user_interface_dbus_interface_info = {-1, "org.freedesktop.login1.User", (GDBusMethodInfo **) (&_user_interface_dbus_method_info), (GDBusSignalInfo **) (&_user_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_user_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _user_interface_dbus_interface_vtable = {user_interface_dbus_interface_method_call, user_interface_dbus_interface_get_property, user_interface_dbus_interface_set_property};
static const GDBusArgInfo _seat_interface_dbus_arg_info_switch_to_guest_session_name = {-1, "session_name", "s", NULL};
static const GDBusArgInfo * const _seat_interface_dbus_arg_info_switch_to_guest_in[] = {&_seat_interface_dbus_arg_info_switch_to_guest_session_name, NULL};
static const GDBusArgInfo * const _seat_interface_dbus_arg_info_switch_to_guest_out[] = {NULL};
static const GDBusMethodInfo _seat_interface_dbus_method_info_switch_to_guest = {-1, "SwitchToGuest", (GDBusArgInfo **) (&_seat_interface_dbus_arg_info_switch_to_guest_in), (GDBusArgInfo **) (&_seat_interface_dbus_arg_info_switch_to_guest_out), NULL};
static const GDBusArgInfo _seat_interface_dbus_arg_info_switch_to_user_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _seat_interface_dbus_arg_info_switch_to_user_session_name = {-1, "session_name", "s", NULL};
static const GDBusArgInfo * const _seat_interface_dbus_arg_info_switch_to_user_in[] = {&_seat_interface_dbus_arg_info_switch_to_user_username, &_seat_interface_dbus_arg_info_switch_to_user_session_name, NULL};
static const GDBusArgInfo * const _seat_interface_dbus_arg_info_switch_to_user_out[] = {NULL};
static const GDBusMethodInfo _seat_interface_dbus_method_info_switch_to_user = {-1, "SwitchToUser", (GDBusArgInfo **) (&_seat_interface_dbus_arg_info_switch_to_user_in), (GDBusArgInfo **) (&_seat_interface_dbus_arg_info_switch_to_user_out), NULL};
static const GDBusMethodInfo * const _seat_interface_dbus_method_info[] = {&_seat_interface_dbus_method_info_switch_to_guest, &_seat_interface_dbus_method_info_switch_to_user, NULL};
static const GDBusSignalInfo * const _seat_interface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _seat_interface_dbus_property_info_has_guest_account = {-1, "HasGuestAccount", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _seat_interface_dbus_property_info[] = {&_seat_interface_dbus_property_info_has_guest_account, NULL};
static const GDBusInterfaceInfo _seat_interface_dbus_interface_info = {-1, "org.freedesktop.DisplayManager.Seat", (GDBusMethodInfo **) (&_seat_interface_dbus_method_info), (GDBusSignalInfo **) (&_seat_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_seat_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _seat_interface_dbus_interface_vtable = {seat_interface_dbus_interface_method_call, seat_interface_dbus_interface_get_property, seat_interface_dbus_interface_set_property};

void
user_info_copy (const UserInfo* self,
                UserInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const char* _tmp2_;
	char* _tmp3_;
	(*dest).uid = (*self).uid;
	_tmp0_ = (*self).user_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).user_name);
	(*dest).user_name = _tmp1_;
	_tmp2_ = (*self).user_object;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).user_object);
	(*dest).user_object = _tmp3_;
}

void
user_info_destroy (UserInfo* self)
{
	_g_free0 ((*self).user_name);
	_g_free0 ((*self).user_object);
}

UserInfo*
user_info_dup (const UserInfo* self)
{
	UserInfo* dup;
	dup = g_new0 (UserInfo, 1);
	user_info_copy (self, dup);
	return dup;
}

void
user_info_free (UserInfo* self)
{
	user_info_destroy (self);
	g_free (self);
}

static GType
user_info_get_type_once (void)
{
	GType user_info_type_id;
	user_info_type_id = g_boxed_type_register_static ("UserInfo", (GBoxedCopyFunc) user_info_dup, (GBoxedFreeFunc) user_info_free);
	return user_info_type_id;
}

GType
user_info_get_type (void)
{
	static volatile gsize user_info_type_id__once = 0;
	if (g_once_init_enter (&user_info_type_id__once)) {
		GType user_info_type_id;
		user_info_type_id = user_info_get_type_once ();
		g_once_init_leave (&user_info_type_id__once, user_info_type_id);
	}
	return user_info_type_id__once;
}

void
session_interface_logout (SessionInterface* self,
                          guint type,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	SessionInterfaceIface* _iface_;
	_iface_ = SESSION_INTERFACE_GET_INTERFACE (self);
	if (_iface_->logout) {
		_iface_->logout (self, type, _callback_, _user_data_);
	}
}

void
session_interface_logout_finish (SessionInterface* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	SessionInterfaceIface* _iface_;
	_iface_ = SESSION_INTERFACE_GET_INTERFACE (self);
	if (_iface_->logout_finish) {
		_iface_->logout_finish (self, _res_, error);
	}
}

void
session_interface_reboot (SessionInterface* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	SessionInterfaceIface* _iface_;
	_iface_ = SESSION_INTERFACE_GET_INTERFACE (self);
	if (_iface_->reboot) {
		_iface_->reboot (self, _callback_, _user_data_);
	}
}

void
session_interface_reboot_finish (SessionInterface* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	SessionInterfaceIface* _iface_;
	_iface_ = SESSION_INTERFACE_GET_INTERFACE (self);
	if (_iface_->reboot_finish) {
		_iface_->reboot_finish (self, _res_, error);
	}
}

void
session_interface_shutdown (SessionInterface* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	SessionInterfaceIface* _iface_;
	_iface_ = SESSION_INTERFACE_GET_INTERFACE (self);
	if (_iface_->shutdown) {
		_iface_->shutdown (self, _callback_, _user_data_);
	}
}

void
session_interface_shutdown_finish (SessionInterface* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	SessionInterfaceIface* _iface_;
	_iface_ = SESSION_INTERFACE_GET_INTERFACE (self);
	if (_iface_->shutdown_finish) {
		_iface_->shutdown_finish (self, _res_, error);
	}
}

static void
session_interface_default_init (SessionInterfaceIface * iface,
                                gpointer iface_data)
{
}

static GType
session_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SessionInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) session_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType session_interface_type_id;
	session_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "SessionInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (session_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (session_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) session_interface_proxy_get_type);
	g_type_set_qdata (session_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager");
	g_type_set_qdata (session_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_session_interface_dbus_interface_info));
	g_type_set_qdata (session_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) session_interface_register_object);
	return session_interface_type_id;
}

GType
session_interface_get_type (void)
{
	static volatile gsize session_interface_type_id__once = 0;
	if (g_once_init_enter (&session_interface_type_id__once)) {
		GType session_interface_type_id;
		session_interface_type_id = session_interface_get_type_once ();
		g_once_init_leave (&session_interface_type_id__once, session_interface_type_id);
	}
	return session_interface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (SessionInterfaceProxy, session_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_SESSION_INTERFACE, session_interface_proxy_session_interface_interface_init) )
static void
session_interface_proxy_class_init (SessionInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = session_interface_proxy_g_signal;
}

static void
session_interface_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters)
{
}

static void
session_interface_proxy_init (SessionInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_session_interface_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
session_interface_proxy_logout_async (SessionInterface* self,
                                      guint type,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "Logout");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
session_interface_proxy_logout_finish (SessionInterface* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
session_interface_proxy_reboot_async (SessionInterface* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "Reboot");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
session_interface_proxy_reboot_finish (SessionInterface* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
session_interface_proxy_shutdown_async (SessionInterface* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "Shutdown");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
session_interface_proxy_shutdown_finish (SessionInterface* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
session_interface_proxy_session_interface_interface_init (SessionInterfaceIface* iface)
{
	iface->logout = session_interface_proxy_logout_async;
	iface->logout_finish = session_interface_proxy_logout_finish;
	iface->reboot = session_interface_proxy_reboot_async;
	iface->reboot_finish = session_interface_proxy_reboot_finish;
	iface->shutdown = session_interface_proxy_shutdown_async;
	iface->shutdown_finish = session_interface_proxy_shutdown_finish;
}

static void
_dbus_session_interface_logout (SessionInterface* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SessionInterfaceLogoutReadyData* _ready_data;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SessionInterfaceLogoutReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->type = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	session_interface_logout (self, _ready_data->type, (GAsyncReadyCallback) _dbus_session_interface_logout_ready, _ready_data);
}

static void
_dbus_session_interface_logout_ready (GObject * source_object,
                                      GAsyncResult * _res_,
                                      gpointer _user_data_)
{
	SessionInterfaceLogoutReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	session_interface_logout_finish ((SessionInterface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (SessionInterfaceLogoutReadyData, _ready_data);
}

static void
_dbus_session_interface_reboot (SessionInterface* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SessionInterfaceRebootReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SessionInterfaceRebootReadyData);
	_ready_data->_invocation_ = invocation;
	session_interface_reboot (self, (GAsyncReadyCallback) _dbus_session_interface_reboot_ready, _ready_data);
}

static void
_dbus_session_interface_reboot_ready (GObject * source_object,
                                      GAsyncResult * _res_,
                                      gpointer _user_data_)
{
	SessionInterfaceRebootReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	session_interface_reboot_finish ((SessionInterface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (SessionInterfaceRebootReadyData, _ready_data);
}

static void
_dbus_session_interface_shutdown (SessionInterface* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SessionInterfaceShutdownReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SessionInterfaceShutdownReadyData);
	_ready_data->_invocation_ = invocation;
	session_interface_shutdown (self, (GAsyncReadyCallback) _dbus_session_interface_shutdown_ready, _ready_data);
}

static void
_dbus_session_interface_shutdown_ready (GObject * source_object,
                                        GAsyncResult * _res_,
                                        gpointer _user_data_)
{
	SessionInterfaceShutdownReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	session_interface_shutdown_finish ((SessionInterface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (SessionInterfaceShutdownReadyData, _ready_data);
}

static void
session_interface_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Logout") == 0) {
		_dbus_session_interface_logout (object, parameters, invocation);
	} else if (strcmp (method_name, "Reboot") == 0) {
		_dbus_session_interface_reboot (object, parameters, invocation);
	} else if (strcmp (method_name, "Shutdown") == 0) {
		_dbus_session_interface_shutdown (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
session_interface_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
session_interface_dbus_interface_set_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GVariant* value,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
session_interface_register_object (gpointer object,
                                   GDBusConnection* connection,
                                   const gchar* path,
                                   GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_session_interface_dbus_interface_info), &_session_interface_dbus_interface_vtable, data, _session_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_session_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
lock_interface_lock (LockInterface* self,
                     GError** error)
{
	LockInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = LOCK_INTERFACE_GET_INTERFACE (self);
	if (_iface_->lock) {
		_iface_->lock (self, error);
	}
}

static void
lock_interface_default_init (LockInterfaceIface * iface,
                             gpointer iface_data)
{
}

static GType
lock_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LockInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lock_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType lock_interface_type_id;
	lock_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "LockInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (lock_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (lock_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) lock_interface_proxy_get_type);
	g_type_set_qdata (lock_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.ScreenSaver");
	g_type_set_qdata (lock_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_lock_interface_dbus_interface_info));
	g_type_set_qdata (lock_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) lock_interface_register_object);
	return lock_interface_type_id;
}

GType
lock_interface_get_type (void)
{
	static volatile gsize lock_interface_type_id__once = 0;
	if (g_once_init_enter (&lock_interface_type_id__once)) {
		GType lock_interface_type_id;
		lock_interface_type_id = lock_interface_get_type_once ();
		g_once_init_leave (&lock_interface_type_id__once, lock_interface_type_id);
	}
	return lock_interface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (LockInterfaceProxy, lock_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_LOCK_INTERFACE, lock_interface_proxy_lock_interface_interface_init) )
static void
lock_interface_proxy_class_init (LockInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = lock_interface_proxy_g_signal;
}

static void
lock_interface_proxy_g_signal (GDBusProxy* proxy,
                               const gchar* sender_name,
                               const gchar* signal_name,
                               GVariant* parameters)
{
}

static void
lock_interface_proxy_init (LockInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_lock_interface_dbus_interface_info));
}

static void
lock_interface_proxy_lock (LockInterface* self,
                           GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.ScreenSaver", "Lock");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
lock_interface_proxy_lock_interface_interface_init (LockInterfaceIface* iface)
{
	iface->lock = lock_interface_proxy_lock;
}

static void
_dbus_lock_interface_lock (LockInterface* self,
                           GVariant* _parameters_,
                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	lock_interface_lock (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
lock_interface_dbus_interface_method_call (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* method_name,
                                           GVariant* parameters,
                                           GDBusMethodInvocation* invocation,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Lock") == 0) {
		_dbus_lock_interface_lock (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
lock_interface_dbus_interface_get_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
lock_interface_dbus_interface_set_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GVariant* value,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
lock_interface_register_object (gpointer object,
                                GDBusConnection* connection,
                                const gchar* path,
                                GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_lock_interface_dbus_interface_info), &_lock_interface_dbus_interface_vtable, data, _lock_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_lock_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
system_interface_suspend (SystemInterface* self,
                          gboolean interactive,
                          GError** error)
{
	SystemInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SYSTEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->suspend) {
		_iface_->suspend (self, interactive, error);
	}
}

void
system_interface_reboot (SystemInterface* self,
                         gboolean interactive,
                         GError** error)
{
	SystemInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SYSTEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->reboot) {
		_iface_->reboot (self, interactive, error);
	}
}

void
system_interface_power_off (SystemInterface* self,
                            gboolean interactive,
                            GError** error)
{
	SystemInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SYSTEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->power_off) {
		_iface_->power_off (self, interactive, error);
	}
}

UserInfo*
system_interface_list_users (SystemInterface* self,
                             gint* result_length1,
                             GError** error)
{
	SystemInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SYSTEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->list_users) {
		return _iface_->list_users (self, result_length1, error);
	}
	return NULL;
}

static void
system_interface_default_init (SystemInterfaceIface * iface,
                               gpointer iface_data)
{
}

static GType
system_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SystemInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) system_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType system_interface_type_id;
	system_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "SystemInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (system_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (system_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) system_interface_proxy_get_type);
	g_type_set_qdata (system_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.login1.Manager");
	g_type_set_qdata (system_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_system_interface_dbus_interface_info));
	g_type_set_qdata (system_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) system_interface_register_object);
	return system_interface_type_id;
}

GType
system_interface_get_type (void)
{
	static volatile gsize system_interface_type_id__once = 0;
	if (g_once_init_enter (&system_interface_type_id__once)) {
		GType system_interface_type_id;
		system_interface_type_id = system_interface_get_type_once ();
		g_once_init_leave (&system_interface_type_id__once, system_interface_type_id);
	}
	return system_interface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (SystemInterfaceProxy, system_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_SYSTEM_INTERFACE, system_interface_proxy_system_interface_interface_init) )
static void
system_interface_proxy_class_init (SystemInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = system_interface_proxy_g_signal;
}

static void
system_interface_proxy_g_signal (GDBusProxy* proxy,
                                 const gchar* sender_name,
                                 const gchar* signal_name,
                                 GVariant* parameters)
{
}

static void
system_interface_proxy_init (SystemInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_system_interface_dbus_interface_info));
}

static void
system_interface_proxy_suspend (SystemInterface* self,
                                gboolean interactive,
                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Manager", "Suspend");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (interactive));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
system_interface_proxy_reboot (SystemInterface* self,
                               gboolean interactive,
                               GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Manager", "Reboot");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (interactive));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
system_interface_proxy_power_off (SystemInterface* self,
                                  gboolean interactive,
                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Manager", "PowerOff");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (interactive));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static UserInfo*
system_interface_proxy_list_users (SystemInterface* self,
                                   gint* result_length1,
                                   GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	UserInfo* _result = NULL;
	gint _result_length1;
	GVariant* _tmp1_;
	UserInfo* _tmp2_;
	gint _tmp2__length;
	gint _tmp2__size;
	gint _tmp2__length1;
	GVariantIter _tmp3_;
	GVariant* _tmp4_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Manager", "ListUsers");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp1_ = g_variant_iter_next_value (&_reply_iter);
	_tmp2_ = g_new (UserInfo, 5);
	_tmp2__length = 0;
	_tmp2__size = 4;
	_tmp2__length1 = 0;
	g_variant_iter_init (&_tmp3_, _tmp1_);
	for (; (_tmp4_ = g_variant_iter_next_value (&_tmp3_)) != NULL; _tmp2__length1++) {
		UserInfo _tmp5_;
		GVariantIter _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		if (_tmp2__size == _tmp2__length) {
			_tmp2__size = 2 * _tmp2__size;
			_tmp2_ = g_renew (UserInfo, _tmp2_, _tmp2__size + 1);
		}
		g_variant_iter_init (&_tmp6_, _tmp4_);
		_tmp7_ = g_variant_iter_next_value (&_tmp6_);
		_tmp5_.uid = g_variant_get_uint32 (_tmp7_);
		g_variant_unref (_tmp7_);
		_tmp8_ = g_variant_iter_next_value (&_tmp6_);
		_tmp5_.user_name = g_variant_dup_string (_tmp8_, NULL);
		g_variant_unref (_tmp8_);
		_tmp9_ = g_variant_iter_next_value (&_tmp6_);
		_tmp5_.user_object = g_variant_dup_string (_tmp9_, NULL);
		g_variant_unref (_tmp9_);
		_tmp2_[_tmp2__length++] = _tmp5_;
		g_variant_unref (_tmp4_);
	}
	_result_length1 = _tmp2__length1;
	_result = _tmp2_;
	g_variant_unref (_tmp1_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static void
system_interface_proxy_system_interface_interface_init (SystemInterfaceIface* iface)
{
	iface->suspend = system_interface_proxy_suspend;
	iface->reboot = system_interface_proxy_reboot;
	iface->power_off = system_interface_proxy_power_off;
	iface->list_users = system_interface_proxy_list_users;
}

static void
_dbus_system_interface_suspend (SystemInterface* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean interactive = FALSE;
	GVariant* _tmp10_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	interactive = g_variant_get_boolean (_tmp10_);
	g_variant_unref (_tmp10_);
	system_interface_suspend (self, interactive, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_system_interface_reboot (SystemInterface* self,
                               GVariant* _parameters_,
                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean interactive = FALSE;
	GVariant* _tmp11_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	interactive = g_variant_get_boolean (_tmp11_);
	g_variant_unref (_tmp11_);
	system_interface_reboot (self, interactive, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_system_interface_power_off (SystemInterface* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean interactive = FALSE;
	GVariant* _tmp12_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	interactive = g_variant_get_boolean (_tmp12_);
	g_variant_unref (_tmp12_);
	system_interface_power_off (self, interactive, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_vala_UserInfo_array_free (UserInfo * array,
                           gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			user_info_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_system_interface_list_users (SystemInterface* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	UserInfo* result;
	gint result_length1 = 0;
	UserInfo* _tmp13_;
	GVariantBuilder _tmp14_;
	gint _tmp15_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = system_interface_list_users (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp13_ = result;
	g_variant_builder_init (&_tmp14_, G_VARIANT_TYPE ("a(uso)"));
	for (_tmp15_ = 0; _tmp15_ < result_length1; _tmp15_++) {
		GVariantBuilder _tmp16_;
		g_variant_builder_init (&_tmp16_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp16_, g_variant_new_uint32 ((*_tmp13_).uid));
		g_variant_builder_add_value (&_tmp16_, g_variant_new_string ((*_tmp13_).user_name));
		g_variant_builder_add_value (&_tmp16_, g_variant_new_object_path ((*_tmp13_).user_object));
		g_variant_builder_add_value (&_tmp14_, g_variant_builder_end (&_tmp16_));
		_tmp13_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp14_));
	result = (_vala_UserInfo_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
system_interface_dbus_interface_method_call (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* method_name,
                                             GVariant* parameters,
                                             GDBusMethodInvocation* invocation,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Suspend") == 0) {
		_dbus_system_interface_suspend (object, parameters, invocation);
	} else if (strcmp (method_name, "Reboot") == 0) {
		_dbus_system_interface_reboot (object, parameters, invocation);
	} else if (strcmp (method_name, "PowerOff") == 0) {
		_dbus_system_interface_power_off (object, parameters, invocation);
	} else if (strcmp (method_name, "ListUsers") == 0) {
		_dbus_system_interface_list_users (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
system_interface_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
system_interface_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
system_interface_register_object (gpointer object,
                                  GDBusConnection* connection,
                                  const gchar* path,
                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_system_interface_dbus_interface_info), &_system_interface_dbus_interface_vtable, data, _system_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_system_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

gchar*
user_interface_get_state (UserInterface* self)
{
	UserInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = USER_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_state) {
		return _iface_->get_state (self);
	}
	return NULL;
}

static void
user_interface_default_init (UserInterfaceIface * iface,
                             gpointer iface_data)
{
}

static GType
user_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UserInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType user_interface_type_id;
	user_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "UserInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (user_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (user_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) user_interface_proxy_get_type);
	g_type_set_qdata (user_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.login1.User");
	g_type_set_qdata (user_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_user_interface_dbus_interface_info));
	g_type_set_qdata (user_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) user_interface_register_object);
	return user_interface_type_id;
}

GType
user_interface_get_type (void)
{
	static volatile gsize user_interface_type_id__once = 0;
	if (g_once_init_enter (&user_interface_type_id__once)) {
		GType user_interface_type_id;
		user_interface_type_id = user_interface_get_type_once ();
		g_once_init_leave (&user_interface_type_id__once, user_interface_type_id);
	}
	return user_interface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (UserInterfaceProxy, user_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_USER_INTERFACE, user_interface_proxy_user_interface_interface_init) )
static void
user_interface_proxy_class_init (UserInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = user_interface_proxy_g_signal;
}

static void
user_interface_proxy_g_signal (GDBusProxy* proxy,
                               const gchar* sender_name,
                               const gchar* signal_name,
                               GVariant* parameters)
{
}

static void
user_interface_proxy_init (UserInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_user_interface_dbus_interface_info));
}

static gchar*
user_interface_dbus_proxy_get_state (UserInterface* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "State");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.login1.User"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("State"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
user_interface_proxy_user_interface_interface_init (UserInterfaceIface* iface)
{
	iface->get_state = user_interface_dbus_proxy_get_state;
}

static void
user_interface_dbus_interface_method_call (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* method_name,
                                           GVariant* parameters,
                                           GDBusMethodInvocation* invocation,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_user_interface_get_state (UserInterface* self)
{
	gchar* result;
	GVariant* _reply;
	result = user_interface_get_state (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
user_interface_dbus_interface_get_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "State") == 0) {
		return _dbus_user_interface_get_state (object);
	}
	return NULL;
}

static gboolean
user_interface_dbus_interface_set_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GVariant* value,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
user_interface_register_object (gpointer object,
                                GDBusConnection* connection,
                                const gchar* path,
                                GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_user_interface_dbus_interface_info), &_user_interface_dbus_interface_vtable, data, _user_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_user_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
seat_interface_switch_to_guest (SeatInterface* self,
                                const gchar* session_name,
                                GError** error)
{
	SeatInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SEAT_INTERFACE_GET_INTERFACE (self);
	if (_iface_->switch_to_guest) {
		_iface_->switch_to_guest (self, session_name, error);
	}
}

void
seat_interface_switch_to_user (SeatInterface* self,
                               const gchar* username,
                               const gchar* session_name,
                               GError** error)
{
	SeatInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SEAT_INTERFACE_GET_INTERFACE (self);
	if (_iface_->switch_to_user) {
		_iface_->switch_to_user (self, username, session_name, error);
	}
}

gboolean
seat_interface_get_has_guest_account (SeatInterface* self)
{
	SeatInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SEAT_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_has_guest_account) {
		return _iface_->get_has_guest_account (self);
	}
	return FALSE;
}

static void
seat_interface_default_init (SeatInterfaceIface * iface,
                             gpointer iface_data)
{
}

static GType
seat_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeatInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seat_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType seat_interface_type_id;
	seat_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "SeatInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (seat_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (seat_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) seat_interface_proxy_get_type);
	g_type_set_qdata (seat_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DisplayManager.Seat");
	g_type_set_qdata (seat_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_seat_interface_dbus_interface_info));
	g_type_set_qdata (seat_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) seat_interface_register_object);
	return seat_interface_type_id;
}

GType
seat_interface_get_type (void)
{
	static volatile gsize seat_interface_type_id__once = 0;
	if (g_once_init_enter (&seat_interface_type_id__once)) {
		GType seat_interface_type_id;
		seat_interface_type_id = seat_interface_get_type_once ();
		g_once_init_leave (&seat_interface_type_id__once, seat_interface_type_id);
	}
	return seat_interface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (SeatInterfaceProxy, seat_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_SEAT_INTERFACE, seat_interface_proxy_seat_interface_interface_init) )
static void
seat_interface_proxy_class_init (SeatInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = seat_interface_proxy_g_signal;
}

static void
seat_interface_proxy_g_signal (GDBusProxy* proxy,
                               const gchar* sender_name,
                               const gchar* signal_name,
                               GVariant* parameters)
{
}

static void
seat_interface_proxy_init (SeatInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_seat_interface_dbus_interface_info));
}

static void
seat_interface_proxy_switch_to_guest (SeatInterface* self,
                                      const gchar* session_name,
                                      GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DisplayManager.Seat", "SwitchToGuest");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (session_name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
seat_interface_proxy_switch_to_user (SeatInterface* self,
                                     const gchar* username,
                                     const gchar* session_name,
                                     GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DisplayManager.Seat", "SwitchToUser");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (username));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (session_name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gboolean
seat_interface_dbus_proxy_get_has_guest_account (SeatInterface* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "HasGuestAccount");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.DisplayManager.Seat"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("HasGuestAccount"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp17_ = FALSE;
			return _tmp17_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
seat_interface_proxy_seat_interface_interface_init (SeatInterfaceIface* iface)
{
	iface->switch_to_guest = seat_interface_proxy_switch_to_guest;
	iface->switch_to_user = seat_interface_proxy_switch_to_user;
	iface->get_has_guest_account = seat_interface_dbus_proxy_get_has_guest_account;
}

static void
_dbus_seat_interface_switch_to_guest (SeatInterface* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* session_name = NULL;
	GVariant* _tmp18_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	session_name = g_variant_dup_string (_tmp18_, NULL);
	g_variant_unref (_tmp18_);
	seat_interface_switch_to_guest (self, session_name, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (session_name);
	;
}

static void
_dbus_seat_interface_switch_to_user (SeatInterface* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp19_;
	gchar* session_name = NULL;
	GVariant* _tmp20_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp19_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp19_, NULL);
	g_variant_unref (_tmp19_);
	_tmp20_ = g_variant_iter_next_value (&_arguments_iter);
	session_name = g_variant_dup_string (_tmp20_, NULL);
	g_variant_unref (_tmp20_);
	seat_interface_switch_to_user (self, username, session_name, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	_g_free0 (session_name);
	;
}

static void
seat_interface_dbus_interface_method_call (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* method_name,
                                           GVariant* parameters,
                                           GDBusMethodInvocation* invocation,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SwitchToGuest") == 0) {
		_dbus_seat_interface_switch_to_guest (object, parameters, invocation);
	} else if (strcmp (method_name, "SwitchToUser") == 0) {
		_dbus_seat_interface_switch_to_user (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_seat_interface_get_has_guest_account (SeatInterface* self)
{
	gboolean result;
	GVariant* _reply;
	result = seat_interface_get_has_guest_account (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
seat_interface_dbus_interface_get_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "HasGuestAccount") == 0) {
		return _dbus_seat_interface_get_has_guest_account (object);
	}
	return NULL;
}

static gboolean
seat_interface_dbus_interface_set_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GVariant* value,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
seat_interface_register_object (gpointer object,
                                GDBusConnection* connection,
                                const gchar* path,
                                GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_seat_interface_dbus_interface_info), &_seat_interface_dbus_interface_vtable, data, _seat_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_seat_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

