/* Notification.c generated by valac 0.56.17, the Vala compiler
 * generated from Notification.vala, do not modify */

/*-
 * Copyright (c) 2015 Wingpanel Developers (http://launchpad.net/wingpanel)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "notifications.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gdesktopappinfo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define NOTIFICATIONS_NOTIFICATION_X_CANONICAL_PRIVATE_KEY "x-canonical-private-synchronous"
#define NOTIFICATIONS_NOTIFICATION_DESKTOP_ENTRY_KEY "desktop-entry"
#define NOTIFICATIONS_NOTIFICATION_FALLBACK_DESKTOP_ID "gala-other" NOTIFICATIONS_NOTIFICATION_DESKTOP_ID_EXT
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NOTIFICATIONS_NOTIFICATION_0_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_INTERNAL_ID_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_IMAGE_PATH_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_SERVER_ID_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_BADGE_ICON_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_NUM_PROPERTIES
};
static GParamSpec* notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_NUM_PROPERTIES];
typedef enum  {
	NOTIFICATIONS_NOTIFICATION_COLUMN_APP_NAME = 0,
	NOTIFICATIONS_NOTIFICATION_COLUMN_REPLACES_ID,
	NOTIFICATIONS_NOTIFICATION_COLUMN_APP_ICON,
	NOTIFICATIONS_NOTIFICATION_COLUMN_SUMMARY,
	NOTIFICATIONS_NOTIFICATION_COLUMN_BODY,
	NOTIFICATIONS_NOTIFICATION_COLUMN_ACTIONS,
	NOTIFICATIONS_NOTIFICATION_COLUMN_HINTS,
	NOTIFICATIONS_NOTIFICATION_COLUMN_EXPIRE_TIMEOUT,
	NOTIFICATIONS_NOTIFICATION_COLUMN_COUNT
} NotificationsNotificationColumn;

#define NOTIFICATIONS_NOTIFICATION_TYPE_COLUMN (notifications_notification_column_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _NotificationsNotificationPrivate {
	gchar* _internal_id;
	gchar* _image_path;
	gchar* _default_action;
	guint32 _server_id;
	GIcon* _badge_icon;
};

static gint NotificationsNotification_private_offset;
static gpointer notifications_notification_parent_class = NULL;

static GType notifications_notification_column_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void notifications_notification_set_image_path (NotificationsNotification* self,
                                                const gchar* value);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static GList* notifications_notification_validate_actions (NotificationsNotification* self,
                                                    gchar** actions,
                                                    gint actions_length1);
static gchar* notifications_notification_get_string (NotificationsNotification* self,
                                              GVariant* tuple,
                                              gint column);
static guint32 notifications_notification_get_uint32 (NotificationsNotification* self,
                                               GVariant* tuple,
                                               gint column);
static gchar* notifications_notification_lookup_string (NotificationsNotification* self,
                                                 GVariant* tuple,
                                                 const gchar* key);
static GdkPixbuf* notifications_notification_lookup_pixbuf (NotificationsNotification* self,
                                                     GVariant* tuple,
                                                     const gchar* key);
static void notifications_notification_set_default_action (NotificationsNotification* self,
                                                    const gchar* value);
static gchar* notifications_notification_make_temp_file (NotificationsNotification* self,
                                                  const gchar* tmpl);
static void notifications_notification_finalize (GObject * obj);
static GType notifications_notification_get_type_once (void);
static void _vala_notifications_notification_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_notifications_notification_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
notifications_notification_get_instance_private (NotificationsNotification* self)
{
	return G_STRUCT_MEMBER_P (self, NotificationsNotification_private_offset);
}

static GType
notifications_notification_close_reason_get_type_once (void)
{
	static const GEnumValue values[] = {{NOTIFICATIONS_NOTIFICATION_CLOSE_REASON_EXPIRED, "NOTIFICATIONS_NOTIFICATION_CLOSE_REASON_EXPIRED", "expired"}, {NOTIFICATIONS_NOTIFICATION_CLOSE_REASON_DISMISSED, "NOTIFICATIONS_NOTIFICATION_CLOSE_REASON_DISMISSED", "dismissed"}, {NOTIFICATIONS_NOTIFICATION_CLOSE_REASON_CLOSE_NOTIFICATION_CALL, "NOTIFICATIONS_NOTIFICATION_CLOSE_REASON_CLOSE_NOTIFICATION_CALL", "close-notification-call"}, {NOTIFICATIONS_NOTIFICATION_CLOSE_REASON_UNDEFINED, "NOTIFICATIONS_NOTIFICATION_CLOSE_REASON_UNDEFINED", "undefined"}, {0, NULL, NULL}};
	GType notifications_notification_close_reason_type_id;
	notifications_notification_close_reason_type_id = g_enum_register_static ("NotificationsNotificationCloseReason", values);
	return notifications_notification_close_reason_type_id;
}

GType
notifications_notification_close_reason_get_type (void)
{
	static volatile gsize notifications_notification_close_reason_type_id__once = 0;
	if (g_once_init_enter (&notifications_notification_close_reason_type_id__once)) {
		GType notifications_notification_close_reason_type_id;
		notifications_notification_close_reason_type_id = notifications_notification_close_reason_get_type_once ();
		g_once_init_leave (&notifications_notification_close_reason_type_id__once, notifications_notification_close_reason_type_id);
	}
	return notifications_notification_close_reason_type_id__once;
}

static GType
notifications_notification_column_get_type_once (void)
{
	static const GEnumValue values[] = {{NOTIFICATIONS_NOTIFICATION_COLUMN_APP_NAME, "NOTIFICATIONS_NOTIFICATION_COLUMN_APP_NAME", "app-name"}, {NOTIFICATIONS_NOTIFICATION_COLUMN_REPLACES_ID, "NOTIFICATIONS_NOTIFICATION_COLUMN_REPLACES_ID", "replaces-id"}, {NOTIFICATIONS_NOTIFICATION_COLUMN_APP_ICON, "NOTIFICATIONS_NOTIFICATION_COLUMN_APP_ICON", "app-icon"}, {NOTIFICATIONS_NOTIFICATION_COLUMN_SUMMARY, "NOTIFICATIONS_NOTIFICATION_COLUMN_SUMMARY", "summary"}, {NOTIFICATIONS_NOTIFICATION_COLUMN_BODY, "NOTIFICATIONS_NOTIFICATION_COLUMN_BODY", "body"}, {NOTIFICATIONS_NOTIFICATION_COLUMN_ACTIONS, "NOTIFICATIONS_NOTIFICATION_COLUMN_ACTIONS", "actions"}, {NOTIFICATIONS_NOTIFICATION_COLUMN_HINTS, "NOTIFICATIONS_NOTIFICATION_COLUMN_HINTS", "hints"}, {NOTIFICATIONS_NOTIFICATION_COLUMN_EXPIRE_TIMEOUT, "NOTIFICATIONS_NOTIFICATION_COLUMN_EXPIRE_TIMEOUT", "expire-timeout"}, {NOTIFICATIONS_NOTIFICATION_COLUMN_COUNT, "NOTIFICATIONS_NOTIFICATION_COLUMN_COUNT", "count"}, {0, NULL, NULL}};
	GType notifications_notification_column_type_id;
	notifications_notification_column_type_id = g_enum_register_static ("NotificationsNotificationColumn", values);
	return notifications_notification_column_type_id;
}

static GType
notifications_notification_column_get_type (void)
{
	static volatile gsize notifications_notification_column_type_id__once = 0;
	if (g_once_init_enter (&notifications_notification_column_type_id__once)) {
		GType notifications_notification_column_type_id;
		notifications_notification_column_type_id = notifications_notification_column_get_type_once ();
		g_once_init_leave (&notifications_notification_column_type_id__once, notifications_notification_column_type_id);
	}
	return notifications_notification_column_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

NotificationsNotification*
notifications_notification_construct (GType object_type,
                                      const gchar* _internal_id,
                                      const gchar* _app_name,
                                      const gchar* _app_icon,
                                      const gchar* _summary,
                                      const gchar* _message_body,
                                      const gchar* _image_path,
                                      gchar** _actions,
                                      gint _actions_length1,
                                      const gchar* _desktop_id,
                                      gint64 _unix_time,
                                      guint64 _replaces_id,
                                      const gchar* _sender,
                                      gboolean _has_temp_file)
{
	NotificationsNotification * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GList* _tmp7_;
	GDateTime* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GDesktopAppInfo* _tmp11_;
	g_return_val_if_fail (_internal_id != NULL, NULL);
	g_return_val_if_fail (_app_name != NULL, NULL);
	g_return_val_if_fail (_app_icon != NULL, NULL);
	g_return_val_if_fail (_summary != NULL, NULL);
	g_return_val_if_fail (_message_body != NULL, NULL);
	g_return_val_if_fail (_image_path != NULL, NULL);
	g_return_val_if_fail (_desktop_id != NULL, NULL);
	g_return_val_if_fail (_sender != NULL, NULL);
	self = (NotificationsNotification*) g_object_new (object_type, NULL);
	notifications_notification_set_internal_id (self, _internal_id);
	_tmp0_ = g_strdup (_app_name);
	_g_free0 (self->app_name);
	self->app_name = _tmp0_;
	_tmp1_ = g_strdup (_app_icon);
	_g_free0 (self->app_icon);
	self->app_icon = _tmp1_;
	_tmp2_ = g_strdup (_summary);
	_g_free0 (self->summary);
	self->summary = _tmp2_;
	_tmp3_ = g_strdup (_message_body);
	_g_free0 (self->message_body);
	self->message_body = _tmp3_;
	notifications_notification_set_image_path (self, _image_path);
	self->replaces_id = (guint32) _replaces_id;
	_tmp4_ = g_strdup (_sender);
	_g_free0 (self->sender);
	self->sender = _tmp4_;
	_tmp5_ = (_actions != NULL) ? _vala_array_dup1 (_actions, _actions_length1) : _actions;
	_tmp5__length1 = _actions_length1;
	self->actions = (_vala_array_free (self->actions, self->actions_length1, (GDestroyNotify) g_free), NULL);
	self->actions = _tmp5_;
	self->actions_length1 = _tmp5__length1;
	_tmp6_ = self->actions;
	_tmp6__length1 = self->actions_length1;
	_tmp7_ = notifications_notification_validate_actions (self, _tmp6_, (gint) _tmp6__length1);
	(self->buttons == NULL) ? NULL : (self->buttons = (_g_list_free__g_object_unref0_ (self->buttons), NULL));
	self->buttons = _tmp7_;
	_tmp8_ = g_date_time_new_from_unix_local (_unix_time);
	_g_date_time_unref0 (self->timestamp);
	self->timestamp = _tmp8_;
	_tmp9_ = g_strdup (_desktop_id);
	_g_free0 (self->desktop_id);
	self->desktop_id = _tmp9_;
	_tmp10_ = self->desktop_id;
	_tmp11_ = g_desktop_app_info_new (_tmp10_);
	_g_object_unref0 (self->app_info);
	self->app_info = _tmp11_;
	self->has_temp_file = _has_temp_file;
	return self;
}

NotificationsNotification*
notifications_notification_new (const gchar* _internal_id,
                                const gchar* _app_name,
                                const gchar* _app_icon,
                                const gchar* _summary,
                                const gchar* _message_body,
                                const gchar* _image_path,
                                gchar** _actions,
                                gint _actions_length1,
                                const gchar* _desktop_id,
                                gint64 _unix_time,
                                guint64 _replaces_id,
                                const gchar* _sender,
                                gboolean _has_temp_file)
{
	return notifications_notification_construct (NOTIFICATIONS_TYPE_NOTIFICATION, _internal_id, _app_name, _app_icon, _summary, _message_body, _image_path, _actions, _actions_length1, _desktop_id, _unix_time, _replaces_id, _sender, _has_temp_file);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

NotificationsNotification*
notifications_notification_construct_from_message (GType object_type,
                                                   GDBusMessage* message,
                                                   guint32 _id)
{
	NotificationsNotification * self = NULL;
	GVariant* body = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gchar* _tmp3_;
	GVariant* _tmp4_;
	gchar* _tmp5_;
	GVariant* _tmp6_;
	gchar* _tmp7_;
	GVariant* hints = NULL;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	gsize _tmp16_ = 0;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GList* _tmp19_;
	GDateTime* _tmp20_;
	GDateTime* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	guint32 _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GVariant* _tmp31_;
	gchar* _tmp32_;
	gboolean _tmp33_ = FALSE;
	const gchar* _tmp34_;
	GVariant* _tmp41_;
	gchar* _tmp42_;
	gboolean _tmp43_ = FALSE;
	const gchar* _tmp44_;
	gboolean _tmp49_ = FALSE;
	GVariant* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gboolean _tmp53_;
	GdkPixbuf* buf = NULL;
	gboolean _tmp73_ = FALSE;
	gboolean _tmp74_ = FALSE;
	GVariant* _tmp75_;
	GdkPixbuf* _tmp76_;
	GdkPixbuf* _tmp77_;
	GDesktopAppInfo* _tmp88_;
	g_return_val_if_fail (message != NULL, NULL);
	self = (NotificationsNotification*) g_object_new (object_type, NULL);
	_tmp0_ = g_dbus_message_get_body (message);
	_tmp1_ = _g_variant_ref0 (_tmp0_);
	body = _tmp1_;
	_tmp2_ = body;
	_tmp3_ = notifications_notification_get_string (self, _tmp2_, (gint) NOTIFICATIONS_NOTIFICATION_COLUMN_APP_NAME);
	_g_free0 (self->app_name);
	self->app_name = _tmp3_;
	_tmp4_ = body;
	_tmp5_ = notifications_notification_get_string (self, _tmp4_, (gint) NOTIFICATIONS_NOTIFICATION_COLUMN_SUMMARY);
	_g_free0 (self->summary);
	self->summary = _tmp5_;
	_tmp6_ = body;
	_tmp7_ = notifications_notification_get_string (self, _tmp6_, (gint) NOTIFICATIONS_NOTIFICATION_COLUMN_BODY);
	_g_free0 (self->message_body);
	self->message_body = _tmp7_;
	_tmp8_ = body;
	_tmp9_ = g_variant_get_child_value (_tmp8_, (gsize) NOTIFICATIONS_NOTIFICATION_COLUMN_HINTS);
	hints = _tmp9_;
	_tmp10_ = body;
	self->replaces_id = notifications_notification_get_uint32 (self, _tmp10_, (gint) NOTIFICATIONS_NOTIFICATION_COLUMN_REPLACES_ID);
	notifications_notification_set_server_id (self, _id);
	_tmp11_ = g_dbus_message_get_sender (message);
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (self->sender);
	self->sender = _tmp12_;
	_tmp13_ = body;
	_tmp14_ = g_variant_get_child_value (_tmp13_, (gsize) NOTIFICATIONS_NOTIFICATION_COLUMN_ACTIONS);
	_tmp15_ = _tmp14_;
	_tmp17_ = g_variant_dup_strv (_tmp15_, &_tmp16_);
	self->actions = (_vala_array_free (self->actions, self->actions_length1, (GDestroyNotify) g_free), NULL);
	self->actions = _tmp17_;
	self->actions_length1 = _tmp16_;
	_g_variant_unref0 (_tmp15_);
	_tmp18_ = self->actions;
	_tmp18__length1 = self->actions_length1;
	_tmp19_ = notifications_notification_validate_actions (self, _tmp18_, (gint) _tmp18__length1);
	(self->buttons == NULL) ? NULL : (self->buttons = (_g_list_free__g_object_unref0_ (self->buttons), NULL));
	self->buttons = _tmp19_;
	_tmp20_ = g_date_time_new_now_local ();
	_g_date_time_unref0 (self->timestamp);
	self->timestamp = _tmp20_;
	_tmp21_ = self->timestamp;
	_tmp22_ = g_strdup_printf ("%" G_GINT64_FORMAT, g_date_time_to_unix (_tmp21_));
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp23_, ".", NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = self->priv->_server_id;
	_tmp27_ = g_strdup_printf ("%u", _tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat (_tmp25_, _tmp28_, NULL);
	_tmp30_ = _tmp29_;
	notifications_notification_set_internal_id (self, _tmp30_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_tmp31_ = hints;
	_tmp32_ = notifications_notification_lookup_string (self, _tmp31_, NOTIFICATIONS_NOTIFICATION_DESKTOP_ENTRY_KEY);
	_g_free0 (self->desktop_id);
	self->desktop_id = _tmp32_;
	_tmp34_ = self->desktop_id;
	if (_tmp34_ != NULL) {
		const gchar* _tmp35_;
		_tmp35_ = self->desktop_id;
		_tmp33_ = g_strcmp0 (_tmp35_, "") != 0;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		const gchar* _tmp36_;
		const gchar* _tmp39_;
		GDesktopAppInfo* _tmp40_;
		_tmp36_ = self->desktop_id;
		if (!g_str_has_suffix (_tmp36_, NOTIFICATIONS_NOTIFICATION_DESKTOP_ID_EXT)) {
			const gchar* _tmp37_;
			gchar* _tmp38_;
			_tmp37_ = self->desktop_id;
			_tmp38_ = g_strconcat (_tmp37_, NOTIFICATIONS_NOTIFICATION_DESKTOP_ID_EXT, NULL);
			_g_free0 (self->desktop_id);
			self->desktop_id = _tmp38_;
		}
		_tmp39_ = self->desktop_id;
		_tmp40_ = g_desktop_app_info_new (_tmp39_);
		_g_object_unref0 (self->app_info);
		self->app_info = _tmp40_;
	}
	_tmp41_ = body;
	_tmp42_ = notifications_notification_get_string (self, _tmp41_, (gint) NOTIFICATIONS_NOTIFICATION_COLUMN_APP_ICON);
	_g_free0 (self->app_icon);
	self->app_icon = _tmp42_;
	_tmp44_ = self->app_icon;
	if (g_strcmp0 (_tmp44_, "") == 0) {
		GDesktopAppInfo* _tmp45_;
		_tmp45_ = self->app_info;
		_tmp43_ = _tmp45_ != NULL;
	} else {
		_tmp43_ = FALSE;
	}
	if (_tmp43_) {
		GDesktopAppInfo* _tmp46_;
		GIcon* _tmp47_;
		gchar* _tmp48_;
		_tmp46_ = self->app_info;
		_tmp47_ = g_app_info_get_icon ((GAppInfo*) _tmp46_);
		_tmp48_ = g_icon_to_string (_tmp47_);
		_g_free0 (self->app_icon);
		self->app_icon = _tmp48_;
	}
	_tmp50_ = hints;
	_tmp51_ = notifications_notification_lookup_string (self, _tmp50_, "image-path");
	_tmp52_ = _tmp51_;
	notifications_notification_set_image_path (self, _tmp52_);
	_tmp53_ = g_strcmp0 (_tmp52_, "") != 0;
	_g_free0 (_tmp52_);
	if (_tmp53_) {
		_tmp49_ = TRUE;
	} else {
		GVariant* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		_tmp54_ = hints;
		_tmp55_ = notifications_notification_lookup_string (self, _tmp54_, "image_path");
		_tmp56_ = _tmp55_;
		notifications_notification_set_image_path (self, _tmp56_);
		_tmp49_ = g_strcmp0 (_tmp56_, "") != 0;
		_g_free0 (_tmp56_);
	}
	if (_tmp49_) {
		const gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gboolean _tmp60_ = FALSE;
		GtkIconTheme* _tmp61_;
		const gchar* _tmp62_;
		gboolean _tmp68_ = FALSE;
		const gchar* _tmp69_;
		gboolean is_a_path = FALSE;
		gboolean _tmp71_ = FALSE;
		GIcon* _tmp72_;
		_tmp57_ = self->priv->_image_path;
		_tmp58_ = string_replace (_tmp57_, "-symbolic", "");
		_tmp59_ = _tmp58_;
		notifications_notification_set_image_path (self, _tmp59_);
		_g_free0 (_tmp59_);
		_tmp61_ = gtk_icon_theme_get_default ();
		_tmp62_ = self->priv->_image_path;
		if (gtk_icon_theme_has_icon (_tmp61_, _tmp62_)) {
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			_tmp63_ = self->priv->_image_path;
			_tmp64_ = self->app_icon;
			_tmp60_ = g_strcmp0 (_tmp63_, _tmp64_) != 0;
		} else {
			_tmp60_ = FALSE;
		}
		if (_tmp60_) {
			const gchar* _tmp65_;
			GThemedIcon* _tmp66_;
			GThemedIcon* _tmp67_;
			_tmp65_ = self->priv->_image_path;
			_tmp66_ = (GThemedIcon*) g_themed_icon_new (_tmp65_);
			_tmp67_ = _tmp66_;
			notifications_notification_set_badge_icon (self, (GIcon*) _tmp67_);
			_g_object_unref0 (_tmp67_);
		}
		_tmp69_ = self->priv->_image_path;
		if (g_str_has_prefix (_tmp69_, "/")) {
			_tmp68_ = TRUE;
		} else {
			const gchar* _tmp70_;
			_tmp70_ = self->priv->_image_path;
			_tmp68_ = g_str_has_prefix (_tmp70_, "file://");
		}
		is_a_path = _tmp68_;
		_tmp72_ = self->priv->_badge_icon;
		if (_tmp72_ != NULL) {
			_tmp71_ = TRUE;
		} else {
			_tmp71_ = !is_a_path;
		}
		if (_tmp71_) {
			notifications_notification_set_image_path (self, "");
		}
	}
	buf = NULL;
	_tmp75_ = hints;
	_tmp76_ = notifications_notification_lookup_pixbuf (self, _tmp75_, "image-data");
	_g_object_unref0 (buf);
	buf = _tmp76_;
	_tmp77_ = buf;
	if (_tmp77_ != NULL) {
		_tmp74_ = TRUE;
	} else {
		GVariant* _tmp78_;
		GdkPixbuf* _tmp79_;
		GdkPixbuf* _tmp80_;
		_tmp78_ = hints;
		_tmp79_ = notifications_notification_lookup_pixbuf (self, _tmp78_, "image_data");
		_g_object_unref0 (buf);
		buf = _tmp79_;
		_tmp80_ = buf;
		_tmp74_ = _tmp80_ != NULL;
	}
	if (_tmp74_) {
		_tmp73_ = TRUE;
	} else {
		GVariant* _tmp81_;
		GdkPixbuf* _tmp82_;
		GdkPixbuf* _tmp83_;
		_tmp81_ = hints;
		_tmp82_ = notifications_notification_lookup_pixbuf (self, _tmp81_, "icon_data");
		_g_object_unref0 (buf);
		buf = _tmp82_;
		_tmp83_ = buf;
		_tmp73_ = _tmp83_ != NULL;
	}
	if (_tmp73_) {
		gchar* tmpfile = NULL;
		GdkPixbuf* _tmp84_;
		gchar* _tmp85_;
		const gchar* _tmp86_;
		_tmp84_ = buf;
		_tmp85_ = notifications_notification_store_pixbuf (self, _tmp84_);
		tmpfile = _tmp85_;
		_tmp86_ = tmpfile;
		if (_tmp86_ != NULL) {
			const gchar* _tmp87_;
			_tmp87_ = tmpfile;
			notifications_notification_set_image_path (self, _tmp87_);
			self->has_temp_file = TRUE;
		}
		_g_free0 (tmpfile);
	}
	_tmp88_ = self->app_info;
	if (_tmp88_ == NULL) {
		gchar* _tmp89_;
		const gchar* _tmp90_;
		GDesktopAppInfo* _tmp91_;
		_tmp89_ = g_strdup (NOTIFICATIONS_NOTIFICATION_FALLBACK_DESKTOP_ID);
		_g_free0 (self->desktop_id);
		self->desktop_id = _tmp89_;
		_tmp90_ = self->desktop_id;
		_tmp91_ = g_desktop_app_info_new (_tmp90_);
		_g_object_unref0 (self->app_info);
		self->app_info = _tmp91_;
	}
	_g_object_unref0 (buf);
	_g_variant_unref0 (hints);
	_g_variant_unref0 (body);
	return self;
}

NotificationsNotification*
notifications_notification_new_from_message (GDBusMessage* message,
                                             guint32 _id)
{
	return notifications_notification_construct_from_message (NOTIFICATIONS_TYPE_NOTIFICATION, message, _id);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GList*
notifications_notification_validate_actions (NotificationsNotification* self,
                                             gchar** actions,
                                             gint actions_length1)
{
	GList* list = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp1_;
				gchar* label = NULL;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				const gchar* _tmp11_;
				GtkButton* button = NULL;
				const gchar* _tmp13_;
				guint32 _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				GtkButton* _tmp23_ = NULL;
				GtkButton* _tmp24_;
				GtkButton* _tmp25_;
				GtkButton* _tmp26_;
				if (!_tmp0_) {
					i += 2;
				}
				_tmp0_ = FALSE;
				if (!(i < actions_length1)) {
					break;
				}
				_tmp1_ = actions[i];
				if (g_strcmp0 (_tmp1_, NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION) == 0) {
					guint32 _tmp2_;
					gchar* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp2_ = self->priv->_server_id;
					_tmp3_ = g_strdup_printf ("%u", _tmp2_);
					_tmp4_ = _tmp3_;
					_tmp5_ = g_strconcat (_tmp4_, ".", NULL);
					_tmp6_ = _tmp5_;
					_tmp7_ = g_strconcat (_tmp6_, NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION, NULL);
					_tmp8_ = _tmp7_;
					notifications_notification_set_default_action (self, _tmp8_);
					_g_free0 (_tmp8_);
					_g_free0 (_tmp6_);
					_g_free0 (_tmp4_);
					continue;
				}
				_tmp9_ = actions[i + 1];
				_tmp10_ = string_strip (_tmp9_);
				label = _tmp10_;
				_tmp11_ = label;
				if (g_strcmp0 (_tmp11_, "") == 0) {
					const gchar* _tmp12_;
					_tmp12_ = actions[i];
					g_warning ("Notification.vala:163: Action '%s' sent without label, skipping…", _tmp12_);
					_g_free0 (label);
					continue;
				}
				_tmp13_ = label;
				_tmp14_ = self->priv->_server_id;
				_tmp15_ = g_strdup_printf ("%u", _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strconcat (NOTIFICATIONS_NOTIFICATIONS_LIST_ACTION_PREFIX, _tmp16_, NULL);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strconcat (_tmp18_, ".", NULL);
				_tmp20_ = _tmp19_;
				_tmp21_ = actions[i];
				_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
				_tmp23_ = (GtkButton*) gtk_button_new_with_label (_tmp13_);
				gtk_actionable_set_action_name ((GtkActionable*) _tmp23_, _tmp22_);
				_g_free0 (_tmp22_);
				g_object_set ((GtkWidget*) _tmp23_, "width-request", 86, NULL);
				g_object_ref_sink (_tmp23_);
				_tmp24_ = _tmp23_;
				_g_free0 (_tmp20_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp16_);
				button = _tmp24_;
				_tmp25_ = button;
				_tmp26_ = _g_object_ref0 (_tmp25_);
				list = g_list_append (list, _tmp26_);
				_g_object_unref0 (button);
				_g_free0 (label);
			}
		}
	}
	result = list;
	return result;
}

static gchar*
notifications_notification_get_string (NotificationsNotification* self,
                                       GVariant* tuple,
                                       gint column)
{
	GVariant* child = NULL;
	GVariant* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tuple != NULL, NULL);
	_tmp0_ = g_variant_get_child_value (tuple, (gsize) column);
	child = _tmp0_;
	_tmp1_ = g_variant_dup_string (child, NULL);
	result = _tmp1_;
	_g_variant_unref0 (child);
	return result;
}

static guint32
notifications_notification_get_uint32 (NotificationsNotification* self,
                                       GVariant* tuple,
                                       gint column)
{
	GVariant* child = NULL;
	GVariant* _tmp0_;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (tuple != NULL, 0U);
	_tmp0_ = g_variant_get_child_value (tuple, (gsize) column);
	child = _tmp0_;
	result = g_variant_get_uint32 (child);
	_g_variant_unref0 (child);
	return result;
}

static gchar*
notifications_notification_lookup_string (NotificationsNotification* self,
                                          GVariant* tuple,
                                          const gchar* key)
{
	GVariant* child = NULL;
	GVariant* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GVariant* _tmp2_;
	GVariant* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tuple != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = g_variant_lookup_value (tuple, key, NULL);
	child = _tmp0_;
	_tmp2_ = child;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		GVariant* _tmp3_;
		const GVariantType* _tmp4_;
		_tmp3_ = child;
		_tmp4_ = G_VARIANT_TYPE_STRING;
		_tmp1_ = !g_variant_is_of_type (_tmp3_, _tmp4_);
	}
	if (_tmp1_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		result = _tmp5_;
		_g_variant_unref0 (child);
		return result;
	}
	_tmp6_ = child;
	_tmp7_ = g_variant_dup_string (_tmp6_, NULL);
	result = _tmp7_;
	_g_variant_unref0 (child);
	return result;
}

static GdkPixbuf*
notifications_notification_lookup_pixbuf (NotificationsNotification* self,
                                          GVariant* tuple,
                                          const gchar* key)
{
	GVariant* img = NULL;
	GVariant* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GVariant* _tmp2_;
	gint width = 0;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	gint _tmp8_;
	gint height = 0;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	gint _tmp12_;
	gint rowstride = 0;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	gint _tmp16_;
	gboolean has_alpha = FALSE;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	gboolean _tmp20_;
	gint bits_per_sample = 0;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	gint _tmp24_;
	guint8* raw = NULL;
	GVariant* _tmp25_;
	GVariant* _tmp26_;
	GVariant* _tmp27_;
	void* _tmp28_;
	guint8* _tmp29_;
	gint _tmp29__length1;
	gint raw_length1;
	gint _raw_size_;
	GdkPixbuf* pixbuf = NULL;
	guint8* _tmp30_;
	gint _tmp30__length1;
	GdkPixbuf* _tmp31_;
	GdkPixbuf* _tmp32_;
	GdkPixbuf* _tmp33_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tuple != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = g_variant_lookup_value (tuple, key, NULL);
	img = _tmp0_;
	_tmp2_ = img;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		GVariant* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = img;
		_tmp4_ = g_variant_get_type_string (_tmp3_);
		_tmp1_ = g_strcmp0 (_tmp4_, "(iiibiiay)") != 0;
	}
	if (_tmp1_) {
		result = NULL;
		_g_variant_unref0 (img);
		return result;
	}
	_tmp5_ = img;
	_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 0);
	_tmp7_ = _tmp6_;
	_tmp8_ = (gint) g_variant_get_int32 (_tmp7_);
	_g_variant_unref0 (_tmp7_);
	width = _tmp8_;
	_tmp9_ = img;
	_tmp10_ = g_variant_get_child_value (_tmp9_, (gsize) 1);
	_tmp11_ = _tmp10_;
	_tmp12_ = (gint) g_variant_get_int32 (_tmp11_);
	_g_variant_unref0 (_tmp11_);
	height = _tmp12_;
	_tmp13_ = img;
	_tmp14_ = g_variant_get_child_value (_tmp13_, (gsize) 2);
	_tmp15_ = _tmp14_;
	_tmp16_ = (gint) g_variant_get_int32 (_tmp15_);
	_g_variant_unref0 (_tmp15_);
	rowstride = _tmp16_;
	_tmp17_ = img;
	_tmp18_ = g_variant_get_child_value (_tmp17_, (gsize) 3);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_variant_get_boolean (_tmp19_);
	_g_variant_unref0 (_tmp19_);
	has_alpha = _tmp20_;
	_tmp21_ = img;
	_tmp22_ = g_variant_get_child_value (_tmp21_, (gsize) 4);
	_tmp23_ = _tmp22_;
	_tmp24_ = (gint) g_variant_get_int32 (_tmp23_);
	_g_variant_unref0 (_tmp23_);
	bits_per_sample = _tmp24_;
	_tmp25_ = img;
	_tmp26_ = g_variant_get_child_value (_tmp25_, (gsize) 6);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_variant_get_data (_tmp27_);
	_tmp29_ = (guint8*) _tmp28_;
	_tmp29__length1 = -1;
	_g_variant_unref0 (_tmp27_);
	raw = _tmp29_;
	raw_length1 = _tmp29__length1;
	_raw_size_ = raw_length1;
	_tmp30_ = raw;
	_tmp30__length1 = raw_length1;
	_tmp31_ = gdk_pixbuf_new_from_data (_tmp30_, GDK_COLORSPACE_RGB, has_alpha, bits_per_sample, width, height, rowstride, (GdkPixbufDestroyNotify) NULL, NULL);
	pixbuf = _tmp31_;
	_tmp32_ = pixbuf;
	_tmp33_ = gdk_pixbuf_copy (_tmp32_);
	result = _tmp33_;
	_g_object_unref0 (pixbuf);
	_g_variant_unref0 (img);
	return result;
}

static gchar*
notifications_notification_make_temp_file (NotificationsNotification* self,
                                           const gchar* tmpl)
{
	GFileIOStream* iostream = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tmpl != NULL, NULL);
	{
		GFile* file = NULL;
		GFileIOStream* _tmp0_ = NULL;
		GFile* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_file_new_tmp (tmpl, &_tmp0_, &_inner_error0_);
		_g_object_unref0 (iostream);
		iostream = _tmp0_;
		file = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_file_get_path (file);
		result = _tmp2_;
		_g_object_unref0 (file);
		_g_object_unref0 (iostream);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_object_unref0 (iostream);
		return result;
	}
	__finally0:
	_g_object_unref0 (iostream);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
notifications_notification_store_pixbuf (NotificationsNotification* self,
                                         GdkPixbuf* pixbuf)
{
	gchar* tmpfile = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pixbuf != NULL, NULL);
	_tmp0_ = notifications_notification_make_temp_file (self, "wingpanel-XXXXXX.png");
	tmpfile = _tmp0_;
	_tmp1_ = tmpfile;
	if (_tmp1_ != NULL) {
		{
			gboolean _tmp2_ = FALSE;
			const gchar* _tmp3_;
			_tmp3_ = tmpfile;
			_tmp2_ = gdk_pixbuf_save (pixbuf, _tmp3_, "png", &_inner_error0_, NULL, NULL);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (_tmp2_) {
				result = tmpfile;
				return result;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			GFile* file = NULL;
			const gchar* _tmp6_;
			GFile* _tmp7_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_critical ("Notification.vala:236: Unable to cache image: %s", _tmp5_);
			_tmp6_ = tmpfile;
			_tmp7_ = g_file_new_for_path (_tmp6_);
			file = _tmp7_;
			{
				GFile* _tmp8_;
				_tmp8_ = file;
				g_file_delete (_tmp8_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				const gchar* _tmp9_;
				g_clear_error (&_inner_error0_);
				_tmp9_ = tmpfile;
				g_critical ("Notification.vala:241: Unable to delete tmpfile: %s", _tmp9_);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_error_free0 (e);
				_g_free0 (tmpfile);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_object_unref0 (file);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (tmpfile);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = NULL;
	_g_free0 (tmpfile);
	return result;
}

const gchar*
notifications_notification_get_internal_id (NotificationsNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_internal_id;
	result = _tmp0_;
	return result;
}

void
notifications_notification_set_internal_id (NotificationsNotification* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_internal_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_internal_id);
		self->priv->_internal_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_INTERNAL_ID_PROPERTY]);
	}
}

const gchar*
notifications_notification_get_image_path (NotificationsNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_image_path;
	result = _tmp0_;
	return result;
}

static void
notifications_notification_set_image_path (NotificationsNotification* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_image_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_image_path);
		self->priv->_image_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_IMAGE_PATH_PROPERTY]);
	}
}

const gchar*
notifications_notification_get_default_action (NotificationsNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_action;
	result = _tmp0_;
	return result;
}

static void
notifications_notification_set_default_action (NotificationsNotification* self,
                                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_default_action (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_default_action);
		self->priv->_default_action = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_PROPERTY]);
	}
}

guint32
notifications_notification_get_server_id (NotificationsNotification* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_server_id;
	return result;
}

void
notifications_notification_set_server_id (NotificationsNotification* self,
                                          guint32 value)
{
	guint32 old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_server_id (self);
	if (old_value != value) {
		self->priv->_server_id = value;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_SERVER_ID_PROPERTY]);
	}
}

GIcon*
notifications_notification_get_badge_icon (NotificationsNotification* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_badge_icon;
	result = _tmp0_;
	return result;
}

void
notifications_notification_set_badge_icon (NotificationsNotification* self,
                                           GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_badge_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_badge_icon);
		self->priv->_badge_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_BADGE_ICON_PROPERTY]);
	}
}

static void
notifications_notification_class_init (NotificationsNotificationClass * klass,
                                       gpointer klass_data)
{
	notifications_notification_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NotificationsNotification_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_notifications_notification_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_notifications_notification_set_property;
	G_OBJECT_CLASS (klass)->finalize = notifications_notification_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_INTERNAL_ID_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_INTERNAL_ID_PROPERTY] = g_param_spec_string ("internal-id", "internal-id", "internal-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_IMAGE_PATH_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_IMAGE_PATH_PROPERTY] = g_param_spec_string ("image-path", "image-path", "image-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_PROPERTY] = g_param_spec_string ("default-action", "default-action", "default-action", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_SERVER_ID_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_SERVER_ID_PROPERTY] = g_param_spec_uint ("server-id", "server-id", "server-id", 0, G_MAXUINT, (guint32) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_BADGE_ICON_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_BADGE_ICON_PROPERTY] = g_param_spec_object ("badge-icon", "badge-icon", "badge-icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
notifications_notification_instance_init (NotificationsNotification * self,
                                          gpointer klass)
{
	gchar* _tmp0_;
	self->priv = notifications_notification_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_image_path = _tmp0_;
	self->priv->_default_action = NULL;
	self->priv->_server_id = (guint32) 0;
	self->app_info = NULL;
}

static void
notifications_notification_finalize (GObject * obj)
{
	NotificationsNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotification);
	_g_free0 (self->priv->_internal_id);
	_g_free0 (self->app_name);
	_g_free0 (self->summary);
	_g_free0 (self->message_body);
	_g_free0 (self->priv->_image_path);
	_g_free0 (self->app_icon);
	_g_free0 (self->sender);
	self->actions = (_vala_array_free (self->actions, self->actions_length1, (GDestroyNotify) g_free), NULL);
	(self->buttons == NULL) ? NULL : (self->buttons = (_g_list_free__g_object_unref0_ (self->buttons), NULL));
	_g_free0 (self->priv->_default_action);
	_g_date_time_unref0 (self->timestamp);
	_g_object_unref0 (self->priv->_badge_icon);
	_g_free0 (self->desktop_id);
	_g_object_unref0 (self->app_info);
	G_OBJECT_CLASS (notifications_notification_parent_class)->finalize (obj);
}

static GType
notifications_notification_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsNotificationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_notification_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsNotification), 0, (GInstanceInitFunc) notifications_notification_instance_init, NULL };
	GType notifications_notification_type_id;
	notifications_notification_type_id = g_type_register_static (G_TYPE_OBJECT, "NotificationsNotification", &g_define_type_info, 0);
	NotificationsNotification_private_offset = g_type_add_instance_private (notifications_notification_type_id, sizeof (NotificationsNotificationPrivate));
	return notifications_notification_type_id;
}

GType
notifications_notification_get_type (void)
{
	static volatile gsize notifications_notification_type_id__once = 0;
	if (g_once_init_enter (&notifications_notification_type_id__once)) {
		GType notifications_notification_type_id;
		notifications_notification_type_id = notifications_notification_get_type_once ();
		g_once_init_leave (&notifications_notification_type_id__once, notifications_notification_type_id);
	}
	return notifications_notification_type_id__once;
}

static void
_vala_notifications_notification_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	NotificationsNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotification);
	switch (property_id) {
		case NOTIFICATIONS_NOTIFICATION_INTERNAL_ID_PROPERTY:
		g_value_set_string (value, notifications_notification_get_internal_id (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_IMAGE_PATH_PROPERTY:
		g_value_set_string (value, notifications_notification_get_image_path (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_PROPERTY:
		g_value_set_string (value, notifications_notification_get_default_action (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_SERVER_ID_PROPERTY:
		g_value_set_uint (value, notifications_notification_get_server_id (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_BADGE_ICON_PROPERTY:
		g_value_set_object (value, notifications_notification_get_badge_icon (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_notifications_notification_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	NotificationsNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotification);
	switch (property_id) {
		case NOTIFICATIONS_NOTIFICATION_INTERNAL_ID_PROPERTY:
		notifications_notification_set_internal_id (self, g_value_get_string (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_IMAGE_PATH_PROPERTY:
		notifications_notification_set_image_path (self, g_value_get_string (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_PROPERTY:
		notifications_notification_set_default_action (self, g_value_get_string (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_SERVER_ID_PROPERTY:
		notifications_notification_set_server_id (self, g_value_get_uint (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_BADGE_ICON_PROPERTY:
		notifications_notification_set_badge_icon (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

