/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	dynamic "github.com/traefik/traefik/v3/pkg/config/dynamic"
)

// RouteApplyConfiguration represents a declarative configuration of the Route type for use
// with apply.
type RouteApplyConfiguration struct {
	Match         *string                            `json:"match,omitempty"`
	Kind          *string                            `json:"kind,omitempty"`
	Priority      *int                               `json:"priority,omitempty"`
	Syntax        *string                            `json:"syntax,omitempty"`
	Services      []ServiceApplyConfiguration        `json:"services,omitempty"`
	Middlewares   []MiddlewareRefApplyConfiguration  `json:"middlewares,omitempty"`
	Observability *dynamic.RouterObservabilityConfig `json:"observability,omitempty"`
}

// RouteApplyConfiguration constructs a declarative configuration of the Route type for use with
// apply.
func Route() *RouteApplyConfiguration {
	return &RouteApplyConfiguration{}
}

// WithMatch sets the Match field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Match field is set to the value of the last call.
func (b *RouteApplyConfiguration) WithMatch(value string) *RouteApplyConfiguration {
	b.Match = &value
	return b
}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *RouteApplyConfiguration) WithKind(value string) *RouteApplyConfiguration {
	b.Kind = &value
	return b
}

// WithPriority sets the Priority field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Priority field is set to the value of the last call.
func (b *RouteApplyConfiguration) WithPriority(value int) *RouteApplyConfiguration {
	b.Priority = &value
	return b
}

// WithSyntax sets the Syntax field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Syntax field is set to the value of the last call.
func (b *RouteApplyConfiguration) WithSyntax(value string) *RouteApplyConfiguration {
	b.Syntax = &value
	return b
}

// WithServices adds the given value to the Services field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Services field.
func (b *RouteApplyConfiguration) WithServices(values ...*ServiceApplyConfiguration) *RouteApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithServices")
		}
		b.Services = append(b.Services, *values[i])
	}
	return b
}

// WithMiddlewares adds the given value to the Middlewares field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Middlewares field.
func (b *RouteApplyConfiguration) WithMiddlewares(values ...*MiddlewareRefApplyConfiguration) *RouteApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithMiddlewares")
		}
		b.Middlewares = append(b.Middlewares, *values[i])
	}
	return b
}

// WithObservability sets the Observability field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Observability field is set to the value of the last call.
func (b *RouteApplyConfiguration) WithObservability(value dynamic.RouterObservabilityConfig) *RouteApplyConfiguration {
	b.Observability = &value
	return b
}
