const char metrics_tarantool_replicas_lua[] =
"local utils = require('metrics.utils')\n"
"\n"
"local collectors_list = {}\n"
"\n"
"local function update_replicas_metrics()\n"
"    if not utils.box_is_configured() then\n"
"        return\n"
"    end\n"
"\n"
"    local current_box_info = box.info()\n"
"\n"
"    if box.cfg.read_only then\n"
"        for k, v in pairs(current_box_info.vclock) do\n"
"            local replication_info = current_box_info.replication[k]\n"
"            if replication_info then\n"
"                local lsn = replication_info.lsn\n"
"                collectors_list.replication_lsn =\n"
"                    utils.set_gauge('replication_lsn', 'lsn for instance',\n"
"                        lsn - v, {type = 'replica', id = k}, nil, {default = true})\n"
"            end\n"
"        end\n"
"    else\n"
"        for k, v in pairs(current_box_info.replication) do\n"
"            if v.downstream ~= nil and v.downstream.vclock ~= nil then\n"
"                local lsn = v.downstream.vclock[current_box_info.id]\n"
"                if lsn ~= nil and current_box_info.lsn ~= nil then\n"
"                    collectors_list.replication_lsn = utils.set_gauge(\n"
"                        'replication_lsn',\n"
"                        'lsn for instance',\n"
"                        current_box_info.lsn - lsn,\n"
"                        {type = 'master', id = k},\n"
"                        nil,\n"
"                        {default = true}\n"
"                    )\n"
"                end\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"return {\n"
"    update = update_replicas_metrics,\n"
"    list = collectors_list,\n"
"}\n"
""
;
