const char metrics_http_middleware_lua[] =
"local export = {}\n"
"local log = require('log')\n"
"\n"
"local metrics_api = require('metrics.api')\n"
"\n"
"local collector_type = {\n"
"    histogram = require('metrics.collectors.histogram'),\n"
"    summary = require('metrics.collectors.summary'),\n"
"}\n"
"\n"
"export.DEFAULT_HISTOGRAM_BUCKETS = {\n"
"    0.001,  0.0025, 0.005,  0.0075,\n"
"    0.01,   0.025,  0.05,   0.075,\n"
"    0.1,    0.25,   0.5,    0.75,\n"
"    1.0,    2.5,    5.0,    7.5,\n"
"    10.0,\n"
"}\n"
"\n"
"export.DEFAULT_QUANTILES = {\n"
"    [0.5] = 0.01,\n"
"    [0.9] = 0.01,\n"
"    [0.99] = 0.01,\n"
"}\n"
"\n"
"export.DEFAULT_SUMMARY_PARAMS = {\n"
"    max_age_time = 60,\n"
"    age_buckets_count = 5,\n"
"}\n"
"\n"
"--- Build default histogram collector\n"
"--\n"
"-- @string[opt='histogram'] type_name `histogram` or `summary`\n"
"-- @string[opt='http_server_requests'] name\n"
"-- @string[opt='HTTP Server Requests'] help\n"
"-- @return collector\n"
"function export.build_default_collector(type_name, name, help)\n"
"    type_name = type_name or 'histogram'\n"
"    name = name or 'http_server_request_latency'\n"
"    help = help or 'HTTP Server Request Latency'\n"
"    local extra = {}\n"
"    if type_name == 'histogram' then\n"
"        extra = {export.DEFAULT_HISTOGRAM_BUCKETS}\n"
"    elseif type_name == 'summary' then\n"
"        extra = {export.DEFAULT_QUANTILES, export.DEFAULT_SUMMARY_PARAMS}\n"
"    else\n"
"        error('Unknown collector type_name: ' .. tostring(type_name))\n"
"    end\n"
"    return metrics_api.registry:register(collector_type[type_name]:new(name, help, unpack(extra)))\n"
"end\n"
"\n"
"function export.get_default_collector()\n"
"    if not export.default_collector then\n"
"        export.default_collector = export.build_default_collector()\n"
"    end\n"
"    return export.default_collector\n"
"end\n"
"\n"
"--- Set default collector for all middlewares\n"
"--\n"
"-- @tab collector object with `:collect` method.\n"
"function export.set_default_collector(collector)\n"
"    export.default_collector = collector\n"
"end\n"
"\n"
"--- Build collector and set it as default\n"
"--\n"
"-- @see build_default_collector\n"
"function export.configure_default_collector(...)\n"
"    export.set_default_collector(export.build_default_collector(...))\n"
"end\n"
"\n"
"--- Measure latency and invoke collector with labels from given route\n"
"--\n"
"-- @tab collector\n"
"-- @tab route\n"
"-- @string route.path\n"
"-- @string route.method\n"
"-- ... arguments for pcall to instrument\n"
"-- @return value from observable function\n"
"function export.observe(collector, route, handler, ...)\n"
"    return collector:observe_latency(function(ok, result)\n"
"        if ok ~= true then\n"
"            log.error('http handler returned %q', result)\n"
"        end\n"
"        if type(result) ~= 'table' then\n"
"            error(('incorrect http handler for %s %s: expecting return response object'):\n"
"                format(route.method, route.path), 0)\n"
"        end\n"
"        return {\n"
"            path = route.path,\n"
"            method = route.method,\n"
"            status = (not ok and 500) or result.status or 200,\n"
"        }\n"
"    end, handler, ...)\n"
"end\n"
"\n"
"--- Apply instrumentation middleware for http request handler\n"
"--\n"
"-- @func handler original\n"
"-- @func[opt] collector custom histogram-like collector\n"
"-- @return new handler\n"
"-- @usage httpd:route({method = 'GET', path = '/...'}, http_middleware.v1(request_handler))\n"
"function export.v1(handler, collector)\n"
"    collector = collector or export.get_default_collector()\n"
"    return function(req)\n"
"        return export.observe(collector, req.endpoint, handler, req)\n"
"    end\n"
"end\n"
"\n"
"return export\n"
""
;
