/* controller.c generated by valac 0.56.17, the Vala compiler
 * generated from controller.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 * Copyright (C) 2010 Alberto Aldegheri <albyrock87+dev@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Alberto Aldegheri <albyrock87+dev@gmail.com>
 *
 */

#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <synapse-core.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtkimmodule.h>
#include <glib/gi18n-lib.h>

#define SYNAPSE_GUI_ICONTROLLER_RESULTS_PER_PAGE 5
#define SYNAPSE_GUI_ICONTROLLER_PARTIAL_RESULT_TIMEOUT 120
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SYNAPSE_GUI_TYPE_ICONTROLLER (synapse_gui_icontroller_get_type ())
#define SYNAPSE_GUI_ICONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_TYPE_ICONTROLLER, SynapseGuiIController))
#define SYNAPSE_GUI_IS_ICONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_TYPE_ICONTROLLER))
#define SYNAPSE_GUI_ICONTROLLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_GUI_TYPE_ICONTROLLER, SynapseGuiIControllerIface))

typedef struct _SynapseGuiIController SynapseGuiIController;
typedef struct _SynapseGuiIControllerIface SynapseGuiIControllerIface;

#define SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG (synapse_gui_key_combo_config_get_type ())
#define SYNAPSE_GUI_KEY_COMBO_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG, SynapseGuiKeyComboConfig))
#define SYNAPSE_GUI_KEY_COMBO_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG, SynapseGuiKeyComboConfigClass))
#define SYNAPSE_GUI_IS_KEY_COMBO_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG))
#define SYNAPSE_GUI_IS_KEY_COMBO_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG))
#define SYNAPSE_GUI_KEY_COMBO_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG, SynapseGuiKeyComboConfigClass))

typedef struct _SynapseGuiKeyComboConfig SynapseGuiKeyComboConfig;
typedef struct _SynapseGuiKeyComboConfigClass SynapseGuiKeyComboConfigClass;

#define SYNAPSE_GUI_TYPE_CATEGORY_CONFIG (synapse_gui_category_config_get_type ())
#define SYNAPSE_GUI_CATEGORY_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_TYPE_CATEGORY_CONFIG, SynapseGuiCategoryConfig))
#define SYNAPSE_GUI_CATEGORY_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_TYPE_CATEGORY_CONFIG, SynapseGuiCategoryConfigClass))
#define SYNAPSE_GUI_IS_CATEGORY_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_TYPE_CATEGORY_CONFIG))
#define SYNAPSE_GUI_IS_CATEGORY_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_TYPE_CATEGORY_CONFIG))
#define SYNAPSE_GUI_CATEGORY_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_TYPE_CATEGORY_CONFIG, SynapseGuiCategoryConfigClass))

typedef struct _SynapseGuiCategoryConfig SynapseGuiCategoryConfig;
typedef struct _SynapseGuiCategoryConfigClass SynapseGuiCategoryConfigClass;

#define SYNAPSE_GUI_TYPE_CONTROLLER (synapse_gui_controller_get_type ())
#define SYNAPSE_GUI_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_TYPE_CONTROLLER, SynapseGuiController))
#define SYNAPSE_GUI_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_TYPE_CONTROLLER, SynapseGuiControllerClass))
#define SYNAPSE_GUI_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_TYPE_CONTROLLER))
#define SYNAPSE_GUI_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_TYPE_CONTROLLER))
#define SYNAPSE_GUI_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_TYPE_CONTROLLER, SynapseGuiControllerClass))

typedef struct _SynapseGuiController SynapseGuiController;
typedef struct _SynapseGuiControllerClass SynapseGuiControllerClass;
typedef struct _SynapseGuiControllerPrivate SynapseGuiControllerPrivate;
typedef enum  {
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_ACTIVATE,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_INVALID_COMMAND,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_SEARCH_DELETE_CHAR,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_SEARCH_DELETE_WORD,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_NEXT_RESULT,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_PREV_RESULT,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_NEXT_CATEGORY,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_PREV_CATEGORY,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_NEXT_PANE,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_PREV_PANE,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_EXECUTE,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_EXECUTE_WITHOUT_HIDE,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_NEXT_PAGE,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_PREV_PAGE,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_FIRST_RESULT,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_LAST_RESULT,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_CLEAR_SEARCH_OR_HIDE,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_PASTE,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_PASTE_SELECTION,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_EXIT_SYNAPSE,
	SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_TOTAL_COMMANDS
} SynapseGuiKeyComboConfigCommands;

#define SYNAPSE_GUI_KEY_COMBO_CONFIG_TYPE_COMMANDS (synapse_gui_key_combo_config_commands_get_type ())

#define SYNAPSE_GUI_TYPE_MODEL (synapse_gui_model_get_type ())
#define SYNAPSE_GUI_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_TYPE_MODEL, SynapseGuiModel))
#define SYNAPSE_GUI_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_TYPE_MODEL, SynapseGuiModelClass))
#define SYNAPSE_GUI_IS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_TYPE_MODEL))
#define SYNAPSE_GUI_IS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_TYPE_MODEL))
#define SYNAPSE_GUI_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_TYPE_MODEL, SynapseGuiModelClass))

typedef struct _SynapseGuiModel SynapseGuiModel;
typedef struct _SynapseGuiModelClass SynapseGuiModelClass;

#define SYNAPSE_GUI_TYPE_IVIEW (synapse_gui_iview_get_type ())
#define SYNAPSE_GUI_IVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_TYPE_IVIEW, SynapseGuiIView))
#define SYNAPSE_GUI_IS_IVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_TYPE_IVIEW))
#define SYNAPSE_GUI_IVIEW_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_GUI_TYPE_IVIEW, SynapseGuiIViewIface))

typedef struct _SynapseGuiIView SynapseGuiIView;
typedef struct _SynapseGuiIViewIface SynapseGuiIViewIface;

#define SYNAPSE_GUI_TYPE_ENTRY (synapse_gui_entry_get_type ())
#define SYNAPSE_GUI_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_TYPE_ENTRY, SynapseGuiEntry))
#define SYNAPSE_GUI_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_TYPE_ENTRY, SynapseGuiEntryClass))
#define SYNAPSE_GUI_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_TYPE_ENTRY))
#define SYNAPSE_GUI_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_TYPE_ENTRY))
#define SYNAPSE_GUI_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_TYPE_ENTRY, SynapseGuiEntryClass))

typedef struct _SynapseGuiEntry SynapseGuiEntry;
typedef struct _SynapseGuiEntryClass SynapseGuiEntryClass;
enum  {
	SYNAPSE_GUI_CONTROLLER_0_PROPERTY,
	SYNAPSE_GUI_CONTROLLER_DATA_SINK_PROPERTY,
	SYNAPSE_GUI_CONTROLLER_KEY_COMBO_CONFIG_PROPERTY,
	SYNAPSE_GUI_CONTROLLER_CATEGORY_CONFIG_PROPERTY,
	SYNAPSE_GUI_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* synapse_gui_controller_properties[SYNAPSE_GUI_CONTROLLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE (synapse_gui_icon_cache_service_get_type ())
#define SYNAPSE_GUI_ICON_CACHE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE, SynapseGuiIconCacheService))
#define SYNAPSE_GUI_ICON_CACHE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE, SynapseGuiIconCacheServiceClass))
#define SYNAPSE_GUI_IS_ICON_CACHE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE))
#define SYNAPSE_GUI_IS_ICON_CACHE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE))
#define SYNAPSE_GUI_ICON_CACHE_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE, SynapseGuiIconCacheServiceClass))

typedef struct _SynapseGuiIconCacheService SynapseGuiIconCacheService;
typedef struct _SynapseGuiIconCacheServiceClass SynapseGuiIconCacheServiceClass;

#define SYNAPSE_GUI_CATEGORY_CONFIG_TYPE_CATEGORY (synapse_gui_category_config_category_get_type ())
#define SYNAPSE_GUI_CATEGORY_CONFIG_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_CATEGORY_CONFIG_TYPE_CATEGORY, SynapseGuiCategoryConfigCategory))
#define SYNAPSE_GUI_CATEGORY_CONFIG_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_CATEGORY_CONFIG_TYPE_CATEGORY, SynapseGuiCategoryConfigCategoryClass))
#define SYNAPSE_GUI_CATEGORY_CONFIG_IS_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_CATEGORY_CONFIG_TYPE_CATEGORY))
#define SYNAPSE_GUI_CATEGORY_CONFIG_IS_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_CATEGORY_CONFIG_TYPE_CATEGORY))
#define SYNAPSE_GUI_CATEGORY_CONFIG_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_CATEGORY_CONFIG_TYPE_CATEGORY, SynapseGuiCategoryConfigCategoryClass))

typedef struct _SynapseGuiCategoryConfigCategory SynapseGuiCategoryConfigCategory;
typedef struct _SynapseGuiCategoryConfigCategoryClass SynapseGuiCategoryConfigCategoryClass;
typedef struct _SynapseGuiModelPrivate SynapseGuiModelPrivate;
typedef enum  {
	SYNAPSE_GUI_SEARCHING_FOR_SOURCES,
	SYNAPSE_GUI_SEARCHING_FOR_ACTIONS,
	SYNAPSE_GUI_SEARCHING_FOR_TARGETS,
	SYNAPSE_GUI_SEARCHING_FOR_COUNT
} SynapseGuiSearchingFor;

#define SYNAPSE_GUI_TYPE_SEARCHING_FOR (synapse_gui_searching_for_get_type ())
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;

struct _SynapseGuiIControllerIface {
	GTypeInterface parent_iface;
	void (*key_press_event) (SynapseGuiIController* self, GdkEventKey* event);
	void (*category_changed_event) (SynapseGuiIController* self, gint category_index);
	void (*fire_focus_context_switch_event) (SynapseGuiIController* self);
	void (*fire_focus) (SynapseGuiIController* self);
	void (*selected_index_changed_event) (SynapseGuiIController* self, gint focus_index);
	void (*set_view) (SynapseGuiIController* self, GType view_type);
	void (*summon_or_vanish) (SynapseGuiIController* self);
	gboolean (*is_in_initial_state) (SynapseGuiIController* self);
	gboolean (*searched_for_recent) (SynapseGuiIController* self);
	SynapseDataSink* (*get_data_sink) (SynapseGuiIController* self);
	void (*set_data_sink) (SynapseGuiIController* self, SynapseDataSink* value);
	SynapseGuiKeyComboConfig* (*get_key_combo_config) (SynapseGuiIController* self);
	void (*set_key_combo_config) (SynapseGuiIController* self, SynapseGuiKeyComboConfig* value);
	SynapseGuiCategoryConfig* (*get_category_config) (SynapseGuiIController* self);
	void (*set_category_config) (SynapseGuiIController* self, SynapseGuiCategoryConfig* value);
};

struct _SynapseGuiIViewIface {
	GTypeInterface parent_iface;
	void (*summon) (SynapseGuiIView* self);
	void (*vanish) (SynapseGuiIView* self);
	void (*summon_or_vanish) (SynapseGuiIView* self);
	void (*update_focused_source) (SynapseGuiIView* self, SynapseGuiEntry* m);
	void (*update_focused_action) (SynapseGuiIView* self, SynapseGuiEntry* m);
	void (*update_focused_target) (SynapseGuiIView* self, SynapseGuiEntry* m);
	void (*update_sources) (SynapseGuiIView* self, GeeList* list);
	void (*update_actions) (SynapseGuiIView* self, GeeList* list);
	void (*update_targets) (SynapseGuiIView* self, GeeList* list);
	void (*update_selected_category) (SynapseGuiIView* self);
	void (*update_searching_for) (SynapseGuiIView* self);
	gboolean (*is_list_visible) (SynapseGuiIView* self);
	void (*set_list_visible) (SynapseGuiIView* self, gboolean visible);
	void (*set_throbber_visible) (SynapseGuiIView* self, gboolean visible);
	SynapseGuiModel* (*get_controller_model) (SynapseGuiIView* self);
	void (*set_controller_model) (SynapseGuiIView* self, SynapseGuiModel* value);
	SynapseGuiIController* (*get_controller) (SynapseGuiIView* self);
	void (*set_controller) (SynapseGuiIView* self, SynapseGuiIController* value);
};

struct _SynapseGuiController {
	GObject parent_instance;
	SynapseGuiControllerPrivate * priv;
	SynapseGuiModel* model;
	SynapseGuiIView* view;
	GtkIMMulticontext* im_context;
};

struct _SynapseGuiControllerClass {
	GObjectClass parent_class;
	void (*clear_search_or_hide_pressed) (SynapseGuiController* self);
	gboolean (*fetch_command) (SynapseGuiController* self, SynapseGuiKeyComboConfigCommands command);
};

struct _SynapseGuiControllerPrivate {
	SynapseDataSink* _data_sink;
	SynapseGuiKeyComboConfig* _key_combo_config;
	SynapseGuiCategoryConfig* _category_config;
	gboolean search_recent_activities;
	gboolean handle_empty;
	SynapseQueryFlags qf;
	GCancellable* current_cancellable[3];
	guint tid[3];
	gboolean partial_result_sent[3];
	gboolean searching[3];
	SynapseResultSet* last_result_set;
};

struct _SynapseGuiModel {
	GObject parent_instance;
	SynapseGuiModelPrivate * priv;
	gchar** query;
	gint query_length1;
	GeeList** results;
	gint results_length1;
	SynapseGuiEntry** focus;
	gint focus_length1;
	gint selected_category;
	SynapseGuiSearchingFor searching_for;
};

struct _SynapseGuiModelClass {
	GObjectClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	SynapseGuiController* self;
	SynapseMatch* source;
	SynapseMatch* action;
	SynapseMatch* target;
};

struct _Block4Data {
	int _ref_count_;
	SynapseGuiController* self;
	SynapseGuiSearchingFor what;
};

static gint SynapseGuiController_private_offset;
static gpointer synapse_gui_controller_parent_class = NULL;
VALA_EXTERN guint synapse_gui_key_combo_config_mod_normalize_mask;
VALA_EXTERN gchar* synapse_gui_icontroller_DOWN_TO_SEE_RECENT;
VALA_EXTERN gchar* synapse_gui_icontroller_SEARCHING;
VALA_EXTERN gchar* synapse_gui_icontroller_NO_RESULTS;
VALA_EXTERN gchar* synapse_gui_icontroller_NO_RECENT_ACTIVITIES;
VALA_EXTERN gchar* synapse_gui_icontroller_TYPE_TO_SEARCH;
static SynapseGuiIControllerIface * synapse_gui_controller_synapse_gui_icontroller_parent_iface = NULL;

VALA_EXTERN GType synapse_gui_key_combo_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiKeyComboConfig, g_object_unref)
VALA_EXTERN GType synapse_gui_category_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiCategoryConfig, g_object_unref)
VALA_EXTERN GType synapse_gui_icontroller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiIController, g_object_unref)
VALA_EXTERN GType synapse_gui_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiController, g_object_unref)
VALA_EXTERN GType synapse_gui_key_combo_config_commands_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType synapse_gui_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiModel, g_object_unref)
VALA_EXTERN gpointer synapse_gui_entry_ref (gpointer instance);
VALA_EXTERN void synapse_gui_entry_unref (gpointer instance);
VALA_EXTERN GParamSpec* synapse_gui_param_spec_entry (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void synapse_gui_value_set_entry (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void synapse_gui_value_take_entry (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer synapse_gui_value_get_entry (const GValue* value);
VALA_EXTERN GType synapse_gui_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiEntry, synapse_gui_entry_unref)
VALA_EXTERN GType synapse_gui_iview_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiIView, g_object_unref)
VALA_EXTERN void synapse_gui_controller_clear_search_or_hide_pressed (SynapseGuiController* self);
VALA_EXTERN gboolean synapse_gui_controller_fetch_command (SynapseGuiController* self,
                                               SynapseGuiKeyComboConfigCommands command);
static void synapse_gui_controller_real_set_view (SynapseGuiIController* base,
                                           GType view_type);
VALA_EXTERN void synapse_gui_iview_vanish (SynapseGuiIView* self);
VALA_EXTERN GType synapse_gui_icon_cache_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiIconCacheService, g_object_unref)
VALA_EXTERN SynapseGuiIconCacheService* synapse_gui_icon_cache_service_get_default (void);
VALA_EXTERN void synapse_gui_icon_cache_service_clear_cache (SynapseGuiIconCacheService* self);
VALA_EXTERN void synapse_gui_controller_reset_search (SynapseGuiController* self,
                                          gboolean notify,
                                          gboolean reset_flags);
static gboolean ___lambda33_ (SynapseGuiController* self);
static gboolean ____lambda33__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                  GdkEventFocus* event,
                                                  gpointer self);
static gboolean ___lambda34_ (SynapseGuiController* self);
static gboolean ____lambda34__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                   GdkEventFocus* event,
                                                   gpointer self);
static void __lambda35_ (SynapseGuiController* self,
                  SynapseGuiIView* view);
static void ___lambda35__synapse_gui_iview_summoned (SynapseGuiIView* _sender,
                                              gpointer self);
static void __lambda36_ (SynapseGuiController* self);
static void ___lambda36__synapse_gui_iview_vanished (SynapseGuiIView* _sender,
                                              gpointer self);
static void synapse_gui_controller_real_key_press_event (SynapseGuiIController* base,
                                                  GdkEventKey* event);
VALA_EXTERN SynapseGuiKeyComboConfig* synapse_gui_icontroller_get_key_combo_config (SynapseGuiIController* self);
VALA_EXTERN SynapseGuiKeyComboConfigCommands synapse_gui_key_combo_config_get_command_from_eventkey (SynapseGuiKeyComboConfig* self,
                                                                                         GdkEventKey* event);
static void synapse_gui_controller_real_category_changed_event (SynapseGuiIController* base,
                                                         gint category_index);
VALA_EXTERN SynapseGuiCategoryConfig* synapse_gui_icontroller_get_category_config (SynapseGuiIController* self);
VALA_EXTERN GType synapse_gui_category_config_category_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiCategoryConfigCategory, g_object_unref)
VALA_EXTERN GeeList* synapse_gui_category_config_get_categories (SynapseGuiCategoryConfig* self);
VALA_EXTERN void synapse_gui_iview_update_selected_category (SynapseGuiIView* self);
VALA_EXTERN GType synapse_gui_searching_for_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void synapse_gui_iview_update_searching_for (SynapseGuiIView* self);
VALA_EXTERN SynapseQueryFlags synapse_gui_category_config_category_get_flags (SynapseGuiCategoryConfigCategory* self);
static void synapse_gui_controller_search_for_matches (SynapseGuiController* self,
                                                SynapseGuiSearchingFor what,
                                                gboolean search_with_empty,
                                                SynapseSearchProvider* search_provider);
static void synapse_gui_controller_real_fire_focus (SynapseGuiIController* base);
VALA_EXTERN void synapse_gui_controller_execute (SynapseGuiController* self,
                                     gboolean hide);
static void synapse_gui_controller_real_fire_focus_context_switch_event (SynapseGuiIController* base);
static void synapse_gui_controller_real_selected_index_changed_event (SynapseGuiIController* base,
                                                               gint focus_index);
VALA_EXTERN gboolean synapse_gui_model_has_results (SynapseGuiModel* self);
VALA_EXTERN gconstpointer synapse_gui_entry_get_key (SynapseGuiEntry* self);
VALA_EXTERN void synapse_gui_model_set_actual_focus (SynapseGuiModel* self,
                                         gint i);
VALA_EXTERN void synapse_gui_model_clear_searching_for (SynapseGuiModel* self,
                                            SynapseGuiSearchingFor i,
                                            gboolean clear_query);
static void synapse_gui_controller_search_for_actions (SynapseGuiController* self);
VALA_EXTERN void synapse_gui_iview_update_focused_source (SynapseGuiIView* self,
                                              SynapseGuiEntry* m);
VALA_EXTERN void synapse_gui_iview_update_targets (SynapseGuiIView* self,
                                       GeeList* list);
VALA_EXTERN void synapse_gui_iview_update_focused_target (SynapseGuiIView* self,
                                              SynapseGuiEntry* m);
VALA_EXTERN gconstpointer synapse_gui_entry_get_value (SynapseGuiEntry* self);
VALA_EXTERN void synapse_gui_iview_update_focused_action (SynapseGuiIView* self,
                                              SynapseGuiEntry* m);
static void synapse_gui_controller_real_summon_or_vanish (SynapseGuiIController* base);
VALA_EXTERN void synapse_gui_iview_summon_or_vanish (SynapseGuiIView* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN void synapse_gui_iview_update_sources (SynapseGuiIView* self,
                                       GeeList* list);
static gboolean __lambda39_ (Block3Data* _data3_);
static gboolean ___lambda39__gsource_func (gpointer self);
VALA_EXTERN void synapse_gui_iview_set_list_visible (SynapseGuiIView* self,
                                         gboolean visible);
VALA_EXTERN void synapse_gui_controller_search_delete_word (SynapseGuiController* self);
static void synapse_gui_controller_search (SynapseGuiController* self,
                                    SynapseGuiSearchingFor mode);
VALA_EXTERN void synapse_gui_controller_search_add_delete_char (SynapseGuiController* self,
                                                    const gchar* newchar);
static void synapse_gui_controller_real_clear_search_or_hide_pressed (SynapseGuiController* self);
static gboolean synapse_gui_controller_real_fetch_command (SynapseGuiController* self,
                                                    SynapseGuiKeyComboConfigCommands command);
VALA_EXTERN void synapse_gui_icontroller_category_changed_event (SynapseGuiIController* self,
                                                     gint category_index);
VALA_EXTERN gboolean synapse_gui_iview_is_list_visible (SynapseGuiIView* self);
VALA_EXTERN void synapse_gui_icontroller_selected_index_changed_event (SynapseGuiIController* self,
                                                           gint focus_index);
VALA_EXTERN gboolean synapse_gui_icontroller_is_in_initial_state (SynapseGuiIController* self);
static gboolean synapse_gui_controller_real_is_in_initial_state (SynapseGuiIController* base);
static gboolean synapse_gui_controller_real_searched_for_recent (SynapseGuiIController* base);
static void synapse_gui_controller_init_search (SynapseGuiController* self);
VALA_EXTERN void synapse_gui_model_clear (SynapseGuiModel* self,
                              gint default_category);
VALA_EXTERN gint synapse_gui_category_config_get_default_category_index (SynapseGuiCategoryConfig* self);
VALA_EXTERN SynapseDataSink* synapse_gui_icontroller_get_data_sink (SynapseGuiIController* self);
static void synapse_gui_controller_update_handle_empty (SynapseGuiController* self);
static void _synapse_gui_controller_update_handle_empty_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
VALA_EXTERN void synapse_gui_iview_set_throbber_visible (SynapseGuiIView* self,
                                             gboolean visible);
VALA_EXTERN void synapse_gui_iview_update_actions (SynapseGuiIView* self,
                                       GeeList* list);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean ___lambda37_ (Block4Data* _data4_);
static void synapse_gui_controller_send_partial_results (SynapseGuiController* self,
                                                  SynapseGuiSearchingFor what,
                                                  SynapseResultSet* rs);
static gboolean ____lambda37__gsource_func (gpointer self);
static void __lambda38_ (Block4Data* _data4_,
                  GObject* obj,
                  GAsyncResult* res);
static void synapse_gui_controller_search_ready (SynapseGuiController* self,
                                          SynapseGuiSearchingFor what,
                                          GeeList* res);
static void ___lambda38__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void synapse_gui_entry_set_key (SynapseGuiEntry* self,
                                gconstpointer value);
VALA_EXTERN void synapse_gui_entry_set_value (SynapseGuiEntry* self,
                                  gconstpointer value);
VALA_EXTERN SynapseGuiController* synapse_gui_controller_new (void);
VALA_EXTERN SynapseGuiController* synapse_gui_controller_construct (GType object_type);
static GObject * synapse_gui_controller_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN SynapseGuiModel* synapse_gui_model_new (void);
VALA_EXTERN SynapseGuiModel* synapse_gui_model_construct (GType object_type);
static void _synapse_gui_controller_search_add_delete_char_gtk_im_context_commit (GtkIMContext* _sender,
                                                                           const gchar* str,
                                                                           gpointer self);
VALA_EXTERN void synapse_gui_icontroller_set_view (SynapseGuiIController* self,
                                       GType view_type);
VALA_EXTERN void synapse_gui_icontroller_key_press_event (SynapseGuiIController* self,
                                              GdkEventKey* event);
VALA_EXTERN void synapse_gui_icontroller_fire_focus (SynapseGuiIController* self);
VALA_EXTERN void synapse_gui_icontroller_fire_focus_context_switch_event (SynapseGuiIController* self);
VALA_EXTERN void synapse_gui_icontroller_summon_or_vanish (SynapseGuiIController* self);
VALA_EXTERN gboolean synapse_gui_icontroller_searched_for_recent (SynapseGuiIController* self);
VALA_EXTERN void synapse_gui_icontroller_set_data_sink (SynapseGuiIController* self,
                                            SynapseDataSink* value);
VALA_EXTERN void synapse_gui_icontroller_set_key_combo_config (SynapseGuiIController* self,
                                                   SynapseGuiKeyComboConfig* value);
VALA_EXTERN void synapse_gui_icontroller_set_category_config (SynapseGuiIController* self,
                                                  SynapseGuiCategoryConfig* value);
static void synapse_gui_controller_finalize (GObject * obj);
static GType synapse_gui_controller_get_type_once (void);
static void _vala_synapse_gui_controller_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_synapse_gui_controller_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
synapse_gui_controller_get_instance_private (SynapseGuiController* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseGuiController_private_offset);
}

static gboolean
___lambda33_ (SynapseGuiController* self)
{
	GtkIMMulticontext* _tmp0_;
	GtkIMMulticontext* _tmp1_;
	gboolean result;
#line 59 "controller.vala"
	_tmp0_ = self->im_context;
#line 59 "controller.vala"
	gtk_im_context_reset ((GtkIMContext*) _tmp0_);
#line 60 "controller.vala"
	_tmp1_ = self->im_context;
#line 60 "controller.vala"
	gtk_im_context_focus_in ((GtkIMContext*) _tmp1_);
#line 61 "controller.vala"
	result = FALSE;
#line 61 "controller.vala"
	return result;
#line 522 "controller.c"
}

static gboolean
____lambda33__gtk_widget_focus_in_event (GtkWidget* _sender,
                                         GdkEventFocus* event,
                                         gpointer self)
{
	gboolean result;
	result = ___lambda33_ ((SynapseGuiController*) self);
#line 58 "controller.vala"
	return result;
#line 534 "controller.c"
}

static gboolean
___lambda34_ (SynapseGuiController* self)
{
	GtkIMMulticontext* _tmp0_;
	gboolean result;
#line 65 "controller.vala"
	_tmp0_ = self->im_context;
#line 65 "controller.vala"
	gtk_im_context_focus_out ((GtkIMContext*) _tmp0_);
#line 66 "controller.vala"
	result = FALSE;
#line 66 "controller.vala"
	return result;
#line 550 "controller.c"
}

static gboolean
____lambda34__gtk_widget_focus_out_event (GtkWidget* _sender,
                                          GdkEventFocus* event,
                                          gpointer self)
{
	gboolean result;
	result = ___lambda34_ ((SynapseGuiController*) self);
#line 64 "controller.vala"
	return result;
#line 562 "controller.c"
}

static void
__lambda35_ (SynapseGuiController* self,
             SynapseGuiIView* view)
{
	GtkWindow* window = NULL;
	GtkIMMulticontext* _tmp0_;
	GdkWindow* _tmp1_;
#line 70 "controller.vala"
	g_return_if_fail (view != NULL);
#line 71 "controller.vala"
	window = G_TYPE_CHECK_INSTANCE_TYPE (view, gtk_window_get_type ()) ? ((GtkWindow*) view) : NULL;
#line 72 "controller.vala"
	g_warn_if_fail (window != NULL);
#line 73 "controller.vala"
	_tmp0_ = self->im_context;
#line 73 "controller.vala"
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) window);
#line 73 "controller.vala"
	gtk_im_context_set_client_window ((GtkIMContext*) _tmp0_, _tmp1_);
#line 74 "controller.vala"
	synapse_gui_controller_reset_search (self, TRUE, TRUE);
#line 586 "controller.c"
}

static void
___lambda35__synapse_gui_iview_summoned (SynapseGuiIView* _sender,
                                         gpointer self)
{
#line 70 "controller.vala"
	__lambda35_ ((SynapseGuiController*) self, _sender);
#line 595 "controller.c"
}

static void
__lambda36_ (SynapseGuiController* self)
{
	GtkIMMulticontext* _tmp0_;
#line 78 "controller.vala"
	_tmp0_ = self->im_context;
#line 78 "controller.vala"
	gtk_im_context_set_client_window ((GtkIMContext*) _tmp0_, NULL);
#line 79 "controller.vala"
	synapse_gui_controller_reset_search (self, TRUE, TRUE);
#line 608 "controller.c"
}

static void
___lambda36__synapse_gui_iview_vanished (SynapseGuiIView* _sender,
                                         gpointer self)
{
#line 77 "controller.vala"
	__lambda36_ ((SynapseGuiController*) self);
#line 617 "controller.c"
}

static void
synapse_gui_controller_real_set_view (SynapseGuiIController* base,
                                      GType view_type)
{
	SynapseGuiController * self;
	SynapseGuiIView* _tmp0_;
	SynapseGuiIconCacheService* _tmp2_;
	SynapseGuiIconCacheService* _tmp3_;
	SynapseGuiModel* _tmp4_;
	GObject* _tmp5_;
	GObject* _tmp6_;
	GtkWindow* v = NULL;
	SynapseGuiIView* _tmp7_;
	GtkWindow* _tmp8_;
	SynapseGuiIView* _tmp13_;
	SynapseGuiIView* _tmp14_;
#line 43 "controller.vala"
	self = (SynapseGuiController*) base;
#line 45 "controller.vala"
	if (!g_type_is_a (view_type, SYNAPSE_GUI_TYPE_IVIEW)) {
#line 45 "controller.vala"
		return;
#line 642 "controller.c"
	}
#line 46 "controller.vala"
	_tmp0_ = self->view;
#line 46 "controller.vala"
	if (_tmp0_ != NULL) {
#line 648 "controller.c"
		SynapseGuiIView* _tmp1_;
#line 46 "controller.vala"
		_tmp1_ = self->view;
#line 46 "controller.vala"
		synapse_gui_iview_vanish (_tmp1_);
#line 654 "controller.c"
	}
#line 47 "controller.vala"
	_tmp2_ = synapse_gui_icon_cache_service_get_default ();
#line 47 "controller.vala"
	_tmp3_ = _tmp2_;
#line 47 "controller.vala"
	synapse_gui_icon_cache_service_clear_cache (_tmp3_);
#line 47 "controller.vala"
	_g_object_unref0 (_tmp3_);
#line 48 "controller.vala"
	_tmp4_ = self->model;
#line 48 "controller.vala"
	_tmp5_ = g_object_new (view_type, "controller-model", _tmp4_, "controller", self, NULL);
#line 48 "controller.vala"
	_tmp6_ = G_IS_INITIALLY_UNOWNED (_tmp5_) ? g_object_ref_sink (_tmp5_) : _tmp5_;
#line 48 "controller.vala"
	_g_object_unref0 (self->view);
#line 48 "controller.vala"
	self->view = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, SYNAPSE_GUI_TYPE_IVIEW, SynapseGuiIView);
#line 50 "controller.vala"
	synapse_gui_controller_reset_search (self, TRUE, TRUE);
#line 53 "controller.vala"
	_tmp7_ = self->view;
#line 53 "controller.vala"
	v = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp7_) : NULL;
#line 54 "controller.vala"
	_tmp8_ = v;
#line 54 "controller.vala"
	if (_tmp8_ != NULL) {
#line 684 "controller.c"
		GtkIMMulticontext* _tmp9_;
		const gchar* _tmp10_;
		GtkWindow* _tmp11_;
		GtkWindow* _tmp12_;
#line 56 "controller.vala"
		_tmp9_ = self->im_context;
#line 56 "controller.vala"
		_tmp10_ = gtk_im_multicontext_get_context_id (_tmp9_);
#line 56 "controller.vala"
		g_message ("controller.vala:56: Using %s input method.", _tmp10_);
#line 58 "controller.vala"
		_tmp11_ = v;
#line 58 "controller.vala"
		g_signal_connect_object ((GtkWidget*) _tmp11_, "focus-in-event", (GCallback) ____lambda33__gtk_widget_focus_in_event, self, 0);
#line 64 "controller.vala"
		_tmp12_ = v;
#line 64 "controller.vala"
		g_signal_connect_object ((GtkWidget*) _tmp12_, "focus-out-event", (GCallback) ____lambda34__gtk_widget_focus_out_event, self, 0);
#line 703 "controller.c"
	}
#line 70 "controller.vala"
	_tmp13_ = self->view;
#line 70 "controller.vala"
	g_signal_connect_object (_tmp13_, "summoned", (GCallback) ___lambda35__synapse_gui_iview_summoned, self, 0);
#line 77 "controller.vala"
	_tmp14_ = self->view;
#line 77 "controller.vala"
	g_signal_connect_object (_tmp14_, "vanished", (GCallback) ___lambda36__synapse_gui_iview_vanished, self, 0);
#line 713 "controller.c"
}

static void
synapse_gui_controller_real_key_press_event (SynapseGuiIController* base,
                                             GdkEventKey* event)
{
	SynapseGuiController * self;
	gboolean filtered = FALSE;
	GtkIMMulticontext* _tmp0_;
	gboolean _tmp1_ = FALSE;
	SynapseGuiKeyComboConfigCommands command = 0;
	SynapseGuiKeyComboConfig* _tmp2_;
	SynapseGuiKeyComboConfig* _tmp3_;
#line 86 "controller.vala"
	self = (SynapseGuiController*) base;
#line 86 "controller.vala"
	g_return_if_fail (event != NULL);
#line 88 "controller.vala"
	filtered = FALSE;
#line 90 "controller.vala"
	_tmp0_ = self->im_context;
#line 90 "controller.vala"
	filtered = gtk_im_context_filter_keypress ((GtkIMContext*) _tmp0_, event);
#line 92 "controller.vala"
	if (filtered) {
#line 92 "controller.vala"
		_tmp1_ = (event->state & synapse_gui_key_combo_config_mod_normalize_mask) == 0;
#line 741 "controller.c"
	} else {
#line 92 "controller.vala"
		_tmp1_ = FALSE;
#line 745 "controller.c"
	}
#line 92 "controller.vala"
	if (_tmp1_) {
#line 92 "controller.vala"
		return;
#line 751 "controller.c"
	}
#line 95 "controller.vala"
	_tmp2_ = synapse_gui_icontroller_get_key_combo_config ((SynapseGuiIController*) self);
#line 95 "controller.vala"
	_tmp3_ = _tmp2_;
#line 95 "controller.vala"
	command = synapse_gui_key_combo_config_get_command_from_eventkey (_tmp3_, event);
#line 98 "controller.vala"
	if (command != SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_INVALID_COMMAND) {
#line 761 "controller.c"
		GtkIMMulticontext* _tmp4_;
#line 100 "controller.vala"
		_tmp4_ = self->im_context;
#line 100 "controller.vala"
		gtk_im_context_reset ((GtkIMContext*) _tmp4_);
#line 101 "controller.vala"
		synapse_gui_controller_fetch_command (self, command);
#line 769 "controller.c"
	}
}

static void
synapse_gui_controller_real_category_changed_event (SynapseGuiIController* base,
                                                    gint category_index)
{
	SynapseGuiController * self;
	gboolean _tmp0_ = FALSE;
	SynapseGuiModel* _tmp8_;
	SynapseGuiModel* _tmp9_;
	SynapseGuiModel* _tmp10_;
	SynapseGuiIView* _tmp11_;
	SynapseGuiIView* _tmp12_;
	SynapseGuiCategoryConfig* _tmp13_;
	SynapseGuiCategoryConfig* _tmp14_;
	GeeList* _tmp15_;
	GeeList* _tmp16_;
	gpointer _tmp17_;
	SynapseGuiCategoryConfigCategory* _tmp18_;
	SynapseQueryFlags _tmp19_;
	SynapseQueryFlags _tmp20_;
	gboolean _tmp21_ = FALSE;
	SynapseGuiModel* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
#line 106 "controller.vala"
	self = (SynapseGuiController*) base;
#line 108 "controller.vala"
	if (category_index < 0) {
#line 108 "controller.vala"
		_tmp0_ = TRUE;
#line 803 "controller.c"
	} else {
		SynapseGuiCategoryConfig* _tmp1_;
		SynapseGuiCategoryConfig* _tmp2_;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
#line 108 "controller.vala"
		_tmp1_ = synapse_gui_icontroller_get_category_config ((SynapseGuiIController*) self);
#line 108 "controller.vala"
		_tmp2_ = _tmp1_;
#line 108 "controller.vala"
		_tmp3_ = synapse_gui_category_config_get_categories (_tmp2_);
#line 108 "controller.vala"
		_tmp4_ = _tmp3_;
#line 108 "controller.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 108 "controller.vala"
		_tmp6_ = _tmp5_;
#line 108 "controller.vala"
		_tmp0_ = category_index >= _tmp6_;
#line 825 "controller.c"
	}
#line 108 "controller.vala"
	if (_tmp0_) {
#line 829 "controller.c"
		SynapseGuiIView* _tmp7_;
#line 111 "controller.vala"
		_tmp7_ = self->view;
#line 111 "controller.vala"
		synapse_gui_iview_update_selected_category (_tmp7_);
#line 112 "controller.vala"
		return;
#line 837 "controller.c"
	}
#line 115 "controller.vala"
	_tmp8_ = self->model;
#line 115 "controller.vala"
	if (category_index == _tmp8_->selected_category) {
#line 115 "controller.vala"
		return;
#line 845 "controller.c"
	}
#line 117 "controller.vala"
	_tmp9_ = self->model;
#line 117 "controller.vala"
	_tmp9_->selected_category = category_index;
#line 118 "controller.vala"
	_tmp10_ = self->model;
#line 118 "controller.vala"
	_tmp10_->searching_for = SYNAPSE_GUI_SEARCHING_FOR_SOURCES;
#line 120 "controller.vala"
	_tmp11_ = self->view;
#line 120 "controller.vala"
	synapse_gui_iview_update_selected_category (_tmp11_);
#line 121 "controller.vala"
	_tmp12_ = self->view;
#line 121 "controller.vala"
	synapse_gui_iview_update_searching_for (_tmp12_);
#line 123 "controller.vala"
	_tmp13_ = synapse_gui_icontroller_get_category_config ((SynapseGuiIController*) self);
#line 123 "controller.vala"
	_tmp14_ = _tmp13_;
#line 123 "controller.vala"
	_tmp15_ = synapse_gui_category_config_get_categories (_tmp14_);
#line 123 "controller.vala"
	_tmp16_ = _tmp15_;
#line 123 "controller.vala"
	_tmp17_ = gee_list_get (_tmp16_, category_index);
#line 123 "controller.vala"
	_tmp18_ = (SynapseGuiCategoryConfigCategory*) _tmp17_;
#line 123 "controller.vala"
	_tmp19_ = synapse_gui_category_config_category_get_flags (_tmp18_);
#line 123 "controller.vala"
	_tmp20_ = _tmp19_;
#line 123 "controller.vala"
	self->priv->qf = _tmp20_;
#line 123 "controller.vala"
	_g_object_unref0 (_tmp18_);
#line 125 "controller.vala"
	_tmp22_ = self->model;
#line 125 "controller.vala"
	_tmp23_ = _tmp22_->query;
#line 125 "controller.vala"
	_tmp23__length1 = _tmp22_->query_length1;
#line 125 "controller.vala"
	_tmp24_ = _tmp23_[SYNAPSE_GUI_SEARCHING_FOR_SOURCES];
#line 125 "controller.vala"
	if (g_strcmp0 (_tmp24_, "") != 0) {
#line 125 "controller.vala"
		_tmp21_ = TRUE;
#line 895 "controller.c"
	} else {
#line 125 "controller.vala"
		_tmp21_ = self->priv->search_recent_activities;
#line 899 "controller.c"
	}
#line 125 "controller.vala"
	if (_tmp21_) {
#line 126 "controller.vala"
		synapse_gui_controller_search_for_matches (self, SYNAPSE_GUI_SEARCHING_FOR_SOURCES, self->priv->search_recent_activities, NULL);
#line 905 "controller.c"
	}
}

static void
synapse_gui_controller_real_fire_focus (SynapseGuiIController* base)
{
	SynapseGuiController * self;
#line 129 "controller.vala"
	self = (SynapseGuiController*) base;
#line 131 "controller.vala"
	synapse_gui_controller_execute (self, TRUE);
#line 917 "controller.c"
}

static void
synapse_gui_controller_real_fire_focus_context_switch_event (SynapseGuiIController* base)
{
	SynapseGuiController * self;
#line 134 "controller.vala"
	self = (SynapseGuiController*) base;
#line 136 "controller.vala"
	synapse_gui_controller_fetch_command (self, SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_NEXT_PANE);
#line 928 "controller.c"
}

static void
synapse_gui_controller_real_selected_index_changed_event (SynapseGuiIController* base,
                                                          gint focus_index)
{
	SynapseGuiController * self;
	SynapseGuiModel* _tmp0_;
	SynapseGuiModel* _tmp1_;
	GeeList** _tmp2_;
	gint _tmp2__length1;
	SynapseGuiModel* _tmp3_;
	GeeList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	SynapseGuiModel* _tmp13_;
	SynapseGuiEntry** _tmp14_;
	gint _tmp14__length1;
	SynapseGuiModel* _tmp15_;
	SynapseGuiEntry* _tmp16_;
	gconstpointer _tmp17_;
	gconstpointer _tmp18_;
	SynapseGuiModel* _tmp19_;
	SynapseGuiModel* _tmp20_;
#line 141 "controller.vala"
	self = (SynapseGuiController*) base;
#line 143 "controller.vala"
	_tmp0_ = self->model;
#line 143 "controller.vala"
	if (!synapse_gui_model_has_results (_tmp0_)) {
#line 143 "controller.vala"
		return;
#line 961 "controller.c"
	}
#line 144 "controller.vala"
	if (focus_index < 0) {
#line 144 "controller.vala"
		focus_index = 0;
#line 967 "controller.c"
	}
#line 145 "controller.vala"
	_tmp1_ = self->model;
#line 145 "controller.vala"
	_tmp2_ = _tmp1_->results;
#line 145 "controller.vala"
	_tmp2__length1 = _tmp1_->results_length1;
#line 145 "controller.vala"
	_tmp3_ = self->model;
#line 145 "controller.vala"
	_tmp4_ = _tmp2_[_tmp3_->searching_for];
#line 145 "controller.vala"
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 145 "controller.vala"
	_tmp6_ = _tmp5_;
#line 145 "controller.vala"
	if (focus_index >= _tmp6_) {
#line 985 "controller.c"
		SynapseGuiModel* _tmp7_;
		GeeList** _tmp8_;
		gint _tmp8__length1;
		SynapseGuiModel* _tmp9_;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
#line 146 "controller.vala"
		_tmp7_ = self->model;
#line 146 "controller.vala"
		_tmp8_ = _tmp7_->results;
#line 146 "controller.vala"
		_tmp8__length1 = _tmp7_->results_length1;
#line 146 "controller.vala"
		_tmp9_ = self->model;
#line 146 "controller.vala"
		_tmp10_ = _tmp8_[_tmp9_->searching_for];
#line 146 "controller.vala"
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
#line 146 "controller.vala"
		_tmp12_ = _tmp11_;
#line 146 "controller.vala"
		focus_index = _tmp12_ - 1;
#line 1009 "controller.c"
	}
#line 148 "controller.vala"
	_tmp13_ = self->model;
#line 148 "controller.vala"
	_tmp14_ = _tmp13_->focus;
#line 148 "controller.vala"
	_tmp14__length1 = _tmp13_->focus_length1;
#line 148 "controller.vala"
	_tmp15_ = self->model;
#line 148 "controller.vala"
	_tmp16_ = _tmp14_[_tmp15_->searching_for];
#line 148 "controller.vala"
	_tmp17_ = synapse_gui_entry_get_key (_tmp16_);
#line 148 "controller.vala"
	_tmp18_ = _tmp17_;
#line 148 "controller.vala"
	if (focus_index == ((gint) ((gintptr) _tmp18_))) {
#line 148 "controller.vala"
		return;
#line 1029 "controller.c"
	}
#line 150 "controller.vala"
	_tmp19_ = self->model;
#line 150 "controller.vala"
	synapse_gui_model_set_actual_focus (_tmp19_, focus_index);
#line 151 "controller.vala"
	_tmp20_ = self->model;
#line 151 "controller.vala"
	switch (_tmp20_->searching_for) {
#line 151 "controller.vala"
		case SYNAPSE_GUI_SEARCHING_FOR_SOURCES:
#line 1041 "controller.c"
		{
			SynapseGuiModel* _tmp21_;
			SynapseGuiIView* _tmp22_;
			SynapseGuiModel* _tmp23_;
			SynapseGuiEntry** _tmp24_;
			gint _tmp24__length1;
			SynapseGuiModel* _tmp25_;
			SynapseGuiEntry* _tmp26_;
#line 154 "controller.vala"
			_tmp21_ = self->model;
#line 154 "controller.vala"
			synapse_gui_model_clear_searching_for (_tmp21_, SYNAPSE_GUI_SEARCHING_FOR_ACTIONS, TRUE);
#line 155 "controller.vala"
			synapse_gui_controller_search_for_actions (self);
#line 157 "controller.vala"
			_tmp22_ = self->view;
#line 157 "controller.vala"
			_tmp23_ = self->model;
#line 157 "controller.vala"
			_tmp24_ = _tmp23_->focus;
#line 157 "controller.vala"
			_tmp24__length1 = _tmp23_->focus_length1;
#line 157 "controller.vala"
			_tmp25_ = self->model;
#line 157 "controller.vala"
			_tmp26_ = _tmp24_[_tmp25_->searching_for];
#line 157 "controller.vala"
			synapse_gui_iview_update_focused_source (_tmp22_, _tmp26_);
#line 158 "controller.vala"
			break;
#line 1072 "controller.c"
		}
#line 151 "controller.vala"
		case SYNAPSE_GUI_SEARCHING_FOR_ACTIONS:
#line 1076 "controller.c"
		{
			SynapseGuiModel* _tmp27_;
			GeeList** _tmp28_;
			gint _tmp28__length1;
			GeeList* _tmp29_;
			SynapseGuiModel* _tmp36_;
			SynapseGuiEntry** _tmp37_;
			gint _tmp37__length1;
			SynapseGuiEntry* _tmp38_;
			gconstpointer _tmp39_;
			gconstpointer _tmp40_;
			SynapseGuiIView* _tmp41_;
			SynapseGuiModel* _tmp42_;
			SynapseGuiEntry** _tmp43_;
			gint _tmp43__length1;
			SynapseGuiModel* _tmp44_;
			SynapseGuiEntry* _tmp45_;
#line 160 "controller.vala"
			_tmp27_ = self->model;
#line 160 "controller.vala"
			_tmp28_ = _tmp27_->results;
#line 160 "controller.vala"
			_tmp28__length1 = _tmp27_->results_length1;
#line 160 "controller.vala"
			_tmp29_ = _tmp28_[SYNAPSE_GUI_SEARCHING_FOR_TARGETS];
#line 160 "controller.vala"
			if (_tmp29_ != NULL) {
#line 1104 "controller.c"
				SynapseGuiModel* _tmp30_;
				SynapseGuiIView* _tmp31_;
				SynapseGuiIView* _tmp32_;
				SynapseGuiModel* _tmp33_;
				SynapseGuiEntry** _tmp34_;
				gint _tmp34__length1;
				SynapseGuiEntry* _tmp35_;
#line 162 "controller.vala"
				_tmp30_ = self->model;
#line 162 "controller.vala"
				synapse_gui_model_clear_searching_for (_tmp30_, SYNAPSE_GUI_SEARCHING_FOR_TARGETS, TRUE);
#line 163 "controller.vala"
				_tmp31_ = self->view;
#line 163 "controller.vala"
				synapse_gui_iview_update_targets (_tmp31_, NULL);
#line 164 "controller.vala"
				_tmp32_ = self->view;
#line 164 "controller.vala"
				_tmp33_ = self->model;
#line 164 "controller.vala"
				_tmp34_ = _tmp33_->focus;
#line 164 "controller.vala"
				_tmp34__length1 = _tmp33_->focus_length1;
#line 164 "controller.vala"
				_tmp35_ = _tmp34_[SYNAPSE_GUI_SEARCHING_FOR_TARGETS];
#line 164 "controller.vala"
				synapse_gui_iview_update_focused_target (_tmp32_, _tmp35_);
#line 1132 "controller.c"
			}
#line 166 "controller.vala"
			_tmp36_ = self->model;
#line 166 "controller.vala"
			_tmp37_ = _tmp36_->focus;
#line 166 "controller.vala"
			_tmp37__length1 = _tmp36_->focus_length1;
#line 166 "controller.vala"
			_tmp38_ = _tmp37_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 166 "controller.vala"
			_tmp39_ = synapse_gui_entry_get_value (_tmp38_);
#line 166 "controller.vala"
			_tmp40_ = _tmp39_;
#line 166 "controller.vala"
			if (synapse_match_needs_target ((SynapseMatch*) _tmp40_)) {
#line 167 "controller.vala"
				synapse_gui_controller_search_for_matches (self, SYNAPSE_GUI_SEARCHING_FOR_TARGETS, TRUE, NULL);
#line 1150 "controller.c"
			}
#line 169 "controller.vala"
			_tmp41_ = self->view;
#line 169 "controller.vala"
			_tmp42_ = self->model;
#line 169 "controller.vala"
			_tmp43_ = _tmp42_->focus;
#line 169 "controller.vala"
			_tmp43__length1 = _tmp42_->focus_length1;
#line 169 "controller.vala"
			_tmp44_ = self->model;
#line 169 "controller.vala"
			_tmp45_ = _tmp43_[_tmp44_->searching_for];
#line 169 "controller.vala"
			synapse_gui_iview_update_focused_action (_tmp41_, _tmp45_);
#line 170 "controller.vala"
			break;
#line 1168 "controller.c"
		}
		default:
		{
			SynapseGuiIView* _tmp46_;
			SynapseGuiModel* _tmp47_;
			SynapseGuiEntry** _tmp48_;
			gint _tmp48__length1;
			SynapseGuiModel* _tmp49_;
			SynapseGuiEntry* _tmp50_;
#line 172 "controller.vala"
			_tmp46_ = self->view;
#line 172 "controller.vala"
			_tmp47_ = self->model;
#line 172 "controller.vala"
			_tmp48_ = _tmp47_->focus;
#line 172 "controller.vala"
			_tmp48__length1 = _tmp47_->focus_length1;
#line 172 "controller.vala"
			_tmp49_ = self->model;
#line 172 "controller.vala"
			_tmp50_ = _tmp48_[_tmp49_->searching_for];
#line 172 "controller.vala"
			synapse_gui_iview_update_focused_target (_tmp46_, _tmp50_);
#line 173 "controller.vala"
			break;
#line 1194 "controller.c"
		}
	}
}

static void
synapse_gui_controller_real_summon_or_vanish (SynapseGuiIController* base)
{
	SynapseGuiController * self;
	SynapseGuiIView* _tmp0_;
	SynapseGuiIView* _tmp1_;
#line 180 "controller.vala"
	self = (SynapseGuiController*) base;
#line 182 "controller.vala"
	_tmp0_ = self->view;
#line 182 "controller.vala"
	if (_tmp0_ == NULL) {
#line 182 "controller.vala"
		return;
#line 1213 "controller.c"
	}
#line 183 "controller.vala"
	_tmp1_ = self->view;
#line 183 "controller.vala"
	synapse_gui_iview_summon_or_vanish (_tmp1_);
#line 1219 "controller.c"
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 201 "controller.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 201 "controller.vala"
	return _data3_;
#line 1229 "controller.c"
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 201 "controller.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1239 "controller.c"
		SynapseGuiController* self;
#line 201 "controller.vala"
		self = _data3_->self;
#line 201 "controller.vala"
		_g_object_unref0 (_data3_->target);
#line 201 "controller.vala"
		_g_object_unref0 (_data3_->action);
#line 201 "controller.vala"
		_g_object_unref0 (_data3_->source);
#line 201 "controller.vala"
		_g_object_unref0 (self);
#line 201 "controller.vala"
		g_slice_free (Block3Data, _data3_);
#line 1253 "controller.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 206 "controller.vala"
	return self ? g_object_ref (self) : NULL;
#line 1262 "controller.c"
}

static gboolean
__lambda39_ (Block3Data* _data3_)
{
	SynapseGuiController* self;
	SynapseMatch* _tmp0_;
	SynapseMatch* _tmp1_;
	SynapseMatch* _tmp2_;
	gboolean result;
#line 227 "controller.vala"
	self = _data3_->self;
#line 228 "controller.vala"
	_tmp0_ = _data3_->action;
#line 228 "controller.vala"
	_tmp1_ = _data3_->source;
#line 228 "controller.vala"
	_tmp2_ = _data3_->target;
#line 228 "controller.vala"
	synapse_match_execute_with_target (_tmp0_, _tmp1_, _tmp2_);
#line 229 "controller.vala"
	result = FALSE;
#line 229 "controller.vala"
	return result;
#line 1287 "controller.c"
}

static gboolean
___lambda39__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda39_ (self);
#line 227 "controller.vala"
	return result;
#line 1297 "controller.c"
}

void
synapse_gui_controller_execute (SynapseGuiController* self,
                                gboolean hide)
{
	Block3Data* _data3_;
	SynapseGuiModel* _tmp0_;
	SynapseGuiEntry** _tmp1_;
	gint _tmp1__length1;
	SynapseGuiEntry* _tmp2_;
	gconstpointer _tmp3_;
	gconstpointer _tmp4_;
	SynapseGuiModel* _tmp5_;
	SynapseGuiEntry** _tmp6_;
	gint _tmp6__length1;
	SynapseGuiEntry* _tmp7_;
	gconstpointer _tmp8_;
	gconstpointer _tmp9_;
	SynapseGuiModel* _tmp10_;
	SynapseGuiEntry** _tmp11_;
	gint _tmp11__length1;
	SynapseGuiEntry* _tmp12_;
	gconstpointer _tmp13_;
	gconstpointer _tmp14_;
	SynapseMatch* _tmp15_;
	SynapseGuiModel* _tmp16_;
	SynapseGuiEntry** _tmp17_;
	gint _tmp17__length1;
	SynapseGuiEntry* _tmp18_;
	gconstpointer _tmp19_;
	gconstpointer _tmp20_;
	SynapseMatch* _tmp21_;
	SynapseGuiModel* _tmp22_;
	SynapseGuiEntry** _tmp23_;
	gint _tmp23__length1;
	SynapseGuiEntry* _tmp24_;
	gconstpointer _tmp25_;
	gconstpointer _tmp26_;
	SynapseMatch* _tmp27_;
	SynapseMatch* _tmp28_;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	SynapseMatch* _tmp40_;
#line 201 "controller.vala"
	g_return_if_fail (self != NULL);
#line 201 "controller.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 201 "controller.vala"
	_data3_->_ref_count_ = 1;
#line 201 "controller.vala"
	_data3_->self = g_object_ref (self);
#line 203 "controller.vala"
	_tmp0_ = self->model;
#line 203 "controller.vala"
	_tmp1_ = _tmp0_->focus;
#line 203 "controller.vala"
	_tmp1__length1 = _tmp0_->focus_length1;
#line 203 "controller.vala"
	_tmp2_ = _tmp1_[SYNAPSE_GUI_SEARCHING_FOR_SOURCES];
#line 203 "controller.vala"
	_tmp3_ = synapse_gui_entry_get_value (_tmp2_);
#line 203 "controller.vala"
	_tmp4_ = _tmp3_;
#line 203 "controller.vala"
	if (((SynapseMatch*) _tmp4_) == NULL) {
#line 203 "controller.vala"
		block3_data_unref (_data3_);
#line 203 "controller.vala"
		_data3_ = NULL;
#line 203 "controller.vala"
		return;
#line 1370 "controller.c"
	}
#line 204 "controller.vala"
	_tmp5_ = self->model;
#line 204 "controller.vala"
	_tmp6_ = _tmp5_->focus;
#line 204 "controller.vala"
	_tmp6__length1 = _tmp5_->focus_length1;
#line 204 "controller.vala"
	_tmp7_ = _tmp6_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 204 "controller.vala"
	_tmp8_ = synapse_gui_entry_get_value (_tmp7_);
#line 204 "controller.vala"
	_tmp9_ = _tmp8_;
#line 204 "controller.vala"
	if (((SynapseMatch*) _tmp9_) == NULL) {
#line 204 "controller.vala"
		block3_data_unref (_data3_);
#line 204 "controller.vala"
		_data3_ = NULL;
#line 204 "controller.vala"
		return;
#line 1392 "controller.c"
	}
#line 206 "controller.vala"
	_tmp10_ = self->model;
#line 206 "controller.vala"
	_tmp11_ = _tmp10_->focus;
#line 206 "controller.vala"
	_tmp11__length1 = _tmp10_->focus_length1;
#line 206 "controller.vala"
	_tmp12_ = _tmp11_[SYNAPSE_GUI_SEARCHING_FOR_SOURCES];
#line 206 "controller.vala"
	_tmp13_ = synapse_gui_entry_get_value (_tmp12_);
#line 206 "controller.vala"
	_tmp14_ = _tmp13_;
#line 206 "controller.vala"
	_tmp15_ = _g_object_ref0 ((SynapseMatch*) _tmp14_);
#line 206 "controller.vala"
	_data3_->source = _tmp15_;
#line 207 "controller.vala"
	_tmp16_ = self->model;
#line 207 "controller.vala"
	_tmp17_ = _tmp16_->focus;
#line 207 "controller.vala"
	_tmp17__length1 = _tmp16_->focus_length1;
#line 207 "controller.vala"
	_tmp18_ = _tmp17_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 207 "controller.vala"
	_tmp19_ = synapse_gui_entry_get_value (_tmp18_);
#line 207 "controller.vala"
	_tmp20_ = _tmp19_;
#line 207 "controller.vala"
	_tmp21_ = _g_object_ref0 ((SynapseMatch*) _tmp20_);
#line 207 "controller.vala"
	_data3_->action = _tmp21_;
#line 208 "controller.vala"
	_tmp22_ = self->model;
#line 208 "controller.vala"
	_tmp23_ = _tmp22_->focus;
#line 208 "controller.vala"
	_tmp23__length1 = _tmp22_->focus_length1;
#line 208 "controller.vala"
	_tmp24_ = _tmp23_[SYNAPSE_GUI_SEARCHING_FOR_TARGETS];
#line 208 "controller.vala"
	_tmp25_ = synapse_gui_entry_get_value (_tmp24_);
#line 208 "controller.vala"
	_tmp26_ = _tmp25_;
#line 208 "controller.vala"
	_tmp27_ = _g_object_ref0 ((SynapseMatch*) _tmp26_);
#line 208 "controller.vala"
	_data3_->target = _tmp27_;
#line 210 "controller.vala"
	_tmp28_ = _data3_->action;
#line 210 "controller.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, SYNAPSE_TYPE_SEARCH_MATCH)) {
#line 1446 "controller.c"
		SynapseSearchMatch* sm = NULL;
		SynapseMatch* _tmp29_;
		SynapseSearchMatch* _tmp30_;
		SynapseSearchMatch* _tmp31_;
		SynapseMatch* _tmp32_;
		SynapseGuiModel* _tmp33_;
		SynapseGuiIView* _tmp34_;
		SynapseSearchMatch* _tmp35_;
		SynapseGuiModel* _tmp36_;
		SynapseGuiIView* _tmp37_;
#line 212 "controller.vala"
		_tmp29_ = _data3_->action;
#line 212 "controller.vala"
		_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, SYNAPSE_TYPE_SEARCH_MATCH) ? ((SynapseSearchMatch*) _tmp29_) : NULL);
#line 212 "controller.vala"
		sm = _tmp30_;
#line 213 "controller.vala"
		_tmp31_ = sm;
#line 213 "controller.vala"
		_tmp32_ = _data3_->source;
#line 213 "controller.vala"
		synapse_search_match_set_search_source (_tmp31_, _tmp32_);
#line 215 "controller.vala"
		_tmp33_ = self->model;
#line 215 "controller.vala"
		_tmp33_->searching_for = SYNAPSE_GUI_SEARCHING_FOR_SOURCES;
#line 216 "controller.vala"
		_tmp34_ = self->view;
#line 216 "controller.vala"
		synapse_gui_iview_update_searching_for (_tmp34_);
#line 217 "controller.vala"
		_tmp35_ = sm;
#line 217 "controller.vala"
		synapse_gui_controller_search_for_matches (self, SYNAPSE_GUI_SEARCHING_FOR_SOURCES, TRUE, (SynapseSearchProvider*) _tmp35_);
#line 218 "controller.vala"
		_tmp36_ = self->model;
#line 218 "controller.vala"
		synapse_gui_model_clear_searching_for (_tmp36_, SYNAPSE_GUI_SEARCHING_FOR_SOURCES, FALSE);
#line 219 "controller.vala"
		_tmp37_ = self->view;
#line 219 "controller.vala"
		synapse_gui_iview_update_sources (_tmp37_, NULL);
#line 220 "controller.vala"
		_g_object_unref0 (sm);
#line 220 "controller.vala"
		block3_data_unref (_data3_);
#line 220 "controller.vala"
		_data3_ = NULL;
#line 220 "controller.vala"
		return;
#line 1497 "controller.c"
	}
#line 223 "controller.vala"
	_tmp40_ = _data3_->action;
#line 223 "controller.vala"
	if (synapse_match_needs_target (_tmp40_)) {
#line 1503 "controller.c"
		SynapseMatch* _tmp41_;
#line 223 "controller.vala"
		_tmp41_ = _data3_->target;
#line 223 "controller.vala"
		_tmp39_ = _tmp41_ == NULL;
#line 1509 "controller.c"
	} else {
#line 223 "controller.vala"
		_tmp39_ = FALSE;
#line 1513 "controller.c"
	}
#line 223 "controller.vala"
	if (_tmp39_) {
#line 223 "controller.vala"
		_tmp38_ = TRUE;
#line 1519 "controller.c"
	} else {
		gboolean _tmp42_ = FALSE;
		SynapseMatch* _tmp43_;
#line 224 "controller.vala"
		_tmp43_ = _data3_->action;
#line 224 "controller.vala"
		if (!synapse_match_needs_target (_tmp43_)) {
#line 1527 "controller.c"
			SynapseMatch* _tmp44_;
#line 224 "controller.vala"
			_tmp44_ = _data3_->target;
#line 224 "controller.vala"
			_tmp42_ = _tmp44_ != NULL;
#line 1533 "controller.c"
		} else {
#line 224 "controller.vala"
			_tmp42_ = FALSE;
#line 1537 "controller.c"
		}
#line 224 "controller.vala"
		_tmp38_ = _tmp42_;
#line 1541 "controller.c"
	}
#line 223 "controller.vala"
	if (_tmp38_) {
#line 225 "controller.vala"
		block3_data_unref (_data3_);
#line 225 "controller.vala"
		_data3_ = NULL;
#line 225 "controller.vala"
		return;
#line 1551 "controller.c"
	}
#line 227 "controller.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 20, ___lambda39__gsource_func, block3_data_ref (_data3_), block3_data_unref);
#line 232 "controller.vala"
	if (hide) {
#line 1557 "controller.c"
		SynapseGuiIView* _tmp45_;
		SynapseGuiIView* _tmp46_;
#line 234 "controller.vala"
		_tmp45_ = self->view;
#line 234 "controller.vala"
		synapse_gui_iview_vanish (_tmp45_);
#line 235 "controller.vala"
		_tmp46_ = self->view;
#line 235 "controller.vala"
		synapse_gui_iview_set_list_visible (_tmp46_, FALSE);
#line 236 "controller.vala"
		synapse_gui_controller_reset_search (self, TRUE, TRUE);
#line 1570 "controller.c"
	} else {
	}
#line 201 "controller.vala"
	block3_data_unref (_data3_);
#line 201 "controller.vala"
	_data3_ = NULL;
#line 1577 "controller.c"
}

void
synapse_gui_controller_search_delete_word (SynapseGuiController* self)
{
	SynapseGuiSearchingFor mode = 0;
	SynapseGuiModel* _tmp0_;
	const gchar* needle = NULL;
	SynapseGuiModel* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	SynapseGuiModel* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar* _tmp8_;
#line 244 "controller.vala"
	g_return_if_fail (self != NULL);
#line 246 "controller.vala"
	_tmp0_ = self->model;
#line 246 "controller.vala"
	mode = _tmp0_->searching_for;
#line 247 "controller.vala"
	_tmp1_ = self->model;
#line 247 "controller.vala"
	_tmp2_ = _tmp1_->query;
#line 247 "controller.vala"
	_tmp2__length1 = _tmp1_->query_length1;
#line 247 "controller.vala"
	_tmp3_ = _tmp2_[mode];
#line 247 "controller.vala"
	needle = _tmp3_;
#line 249 "controller.vala"
	_tmp4_ = needle;
#line 249 "controller.vala"
	if (g_strcmp0 (_tmp4_, "") == 0) {
#line 249 "controller.vala"
		return;
#line 1618 "controller.c"
	}
#line 250 "controller.vala"
	_tmp5_ = self->model;
#line 250 "controller.vala"
	_tmp6_ = _tmp5_->query;
#line 250 "controller.vala"
	_tmp6__length1 = _tmp5_->query_length1;
#line 250 "controller.vala"
	_tmp7_ = needle;
#line 250 "controller.vala"
	_tmp8_ = synapse_utils_remove_last_word (_tmp7_);
#line 250 "controller.vala"
	_g_free0 (_tmp6_[mode]);
#line 250 "controller.vala"
	_tmp6_[mode] = _tmp8_;
#line 252 "controller.vala"
	synapse_gui_controller_search (self, mode);
#line 1636 "controller.c"
}

void
synapse_gui_controller_search_add_delete_char (SynapseGuiController* self,
                                               const gchar* newchar)
{
	SynapseGuiSearchingFor mode = 0;
	SynapseGuiModel* _tmp0_;
	const gchar* needle = NULL;
	SynapseGuiModel* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
#line 255 "controller.vala"
	g_return_if_fail (self != NULL);
#line 257 "controller.vala"
	_tmp0_ = self->model;
#line 257 "controller.vala"
	mode = _tmp0_->searching_for;
#line 258 "controller.vala"
	_tmp1_ = self->model;
#line 258 "controller.vala"
	_tmp2_ = _tmp1_->query;
#line 258 "controller.vala"
	_tmp2__length1 = _tmp1_->query_length1;
#line 258 "controller.vala"
	_tmp3_ = _tmp2_[mode];
#line 258 "controller.vala"
	needle = _tmp3_;
#line 260 "controller.vala"
	if (newchar == NULL) {
#line 1668 "controller.c"
		const gchar* _tmp4_;
		SynapseGuiModel* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar* _tmp8_;
#line 263 "controller.vala"
		_tmp4_ = needle;
#line 263 "controller.vala"
		if (g_strcmp0 (_tmp4_, "") == 0) {
#line 263 "controller.vala"
			return;
#line 1681 "controller.c"
		}
#line 264 "controller.vala"
		_tmp5_ = self->model;
#line 264 "controller.vala"
		_tmp6_ = _tmp5_->query;
#line 264 "controller.vala"
		_tmp6__length1 = _tmp5_->query_length1;
#line 264 "controller.vala"
		_tmp7_ = needle;
#line 264 "controller.vala"
		_tmp8_ = synapse_utils_remove_last_unichar (_tmp7_);
#line 264 "controller.vala"
		_g_free0 (_tmp6_[mode]);
#line 264 "controller.vala"
		_tmp6_[mode] = _tmp8_;
#line 1697 "controller.c"
	} else {
		SynapseGuiModel* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		gchar* _tmp12_;
#line 269 "controller.vala"
		_tmp9_ = self->model;
#line 269 "controller.vala"
		_tmp10_ = _tmp9_->query;
#line 269 "controller.vala"
		_tmp10__length1 = _tmp9_->query_length1;
#line 269 "controller.vala"
		_tmp11_ = needle;
#line 269 "controller.vala"
		_tmp12_ = g_strconcat (_tmp11_, newchar, NULL);
#line 269 "controller.vala"
		_g_free0 (_tmp10_[mode]);
#line 269 "controller.vala"
		_tmp10_[mode] = _tmp12_;
#line 1718 "controller.c"
	}
#line 272 "controller.vala"
	synapse_gui_controller_search (self, mode);
#line 1722 "controller.c"
}

static void
synapse_gui_controller_search (SynapseGuiController* self,
                               SynapseGuiSearchingFor mode)
{
#line 275 "controller.vala"
	g_return_if_fail (self != NULL);
#line 277 "controller.vala"
	switch (mode) {
#line 277 "controller.vala"
		case SYNAPSE_GUI_SEARCHING_FOR_SOURCES:
#line 1735 "controller.c"
		{
#line 280 "controller.vala"
			synapse_gui_controller_search_for_matches (self, SYNAPSE_GUI_SEARCHING_FOR_SOURCES, FALSE, NULL);
#line 281 "controller.vala"
			self->priv->search_recent_activities = FALSE;
#line 282 "controller.vala"
			break;
#line 1743 "controller.c"
		}
#line 277 "controller.vala"
		case SYNAPSE_GUI_SEARCHING_FOR_ACTIONS:
#line 1747 "controller.c"
		{
#line 284 "controller.vala"
			synapse_gui_controller_search_for_actions (self);
#line 285 "controller.vala"
			break;
#line 1753 "controller.c"
		}
		default:
		{
#line 287 "controller.vala"
			synapse_gui_controller_search_for_matches (self, SYNAPSE_GUI_SEARCHING_FOR_TARGETS, TRUE, NULL);
#line 288 "controller.vala"
			break;
#line 1761 "controller.c"
		}
	}
}

static void
synapse_gui_controller_real_clear_search_or_hide_pressed (SynapseGuiController* self)
{
	SynapseGuiModel* _tmp0_;
#line 294 "controller.vala"
	_tmp0_ = self->model;
#line 294 "controller.vala"
	if (_tmp0_->searching_for != SYNAPSE_GUI_SEARCHING_FOR_SOURCES) {
#line 1774 "controller.c"
		SynapseGuiModel* _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar* _tmp3_;
		SynapseGuiModel* _tmp4_;
		SynapseGuiIView* _tmp5_;
#line 296 "controller.vala"
		_tmp1_ = self->model;
#line 296 "controller.vala"
		_tmp2_ = _tmp1_->query;
#line 296 "controller.vala"
		_tmp2__length1 = _tmp1_->query_length1;
#line 296 "controller.vala"
		_tmp3_ = g_strdup ("");
#line 296 "controller.vala"
		_g_free0 (_tmp2_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS]);
#line 296 "controller.vala"
		_tmp2_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS] = _tmp3_;
#line 297 "controller.vala"
		_tmp4_ = self->model;
#line 297 "controller.vala"
		_tmp4_->searching_for = SYNAPSE_GUI_SEARCHING_FOR_SOURCES;
#line 298 "controller.vala"
		synapse_gui_controller_search_for_actions (self);
#line 299 "controller.vala"
		_tmp5_ = self->view;
#line 299 "controller.vala"
		synapse_gui_iview_update_searching_for (_tmp5_);
#line 1803 "controller.c"
	} else {
		gboolean _tmp6_ = FALSE;
		SynapseGuiModel* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
#line 301 "controller.vala"
		_tmp7_ = self->model;
#line 301 "controller.vala"
		_tmp8_ = _tmp7_->query;
#line 301 "controller.vala"
		_tmp8__length1 = _tmp7_->query_length1;
#line 301 "controller.vala"
		_tmp9_ = _tmp8_[SYNAPSE_GUI_SEARCHING_FOR_SOURCES];
#line 301 "controller.vala"
		if (g_strcmp0 (_tmp9_, "") != 0) {
#line 301 "controller.vala"
			_tmp6_ = TRUE;
#line 1822 "controller.c"
		} else {
#line 302 "controller.vala"
			_tmp6_ = self->priv->search_recent_activities;
#line 1826 "controller.c"
		}
#line 301 "controller.vala"
		if (_tmp6_) {
#line 1830 "controller.c"
			SynapseGuiIView* _tmp10_;
#line 304 "controller.vala"
			synapse_gui_controller_reset_search (self, TRUE, FALSE);
#line 305 "controller.vala"
			_tmp10_ = self->view;
#line 305 "controller.vala"
			synapse_gui_iview_set_list_visible (_tmp10_, FALSE);
#line 1838 "controller.c"
		} else {
			SynapseGuiIView* _tmp11_;
			SynapseGuiIView* _tmp12_;
#line 309 "controller.vala"
			_tmp11_ = self->view;
#line 309 "controller.vala"
			synapse_gui_iview_vanish (_tmp11_);
#line 310 "controller.vala"
			synapse_gui_controller_reset_search (self, TRUE, TRUE);
#line 311 "controller.vala"
			_tmp12_ = self->view;
#line 311 "controller.vala"
			synapse_gui_iview_set_list_visible (_tmp12_, FALSE);
#line 1852 "controller.c"
		}
	}
}

void
synapse_gui_controller_clear_search_or_hide_pressed (SynapseGuiController* self)
{
	SynapseGuiControllerClass* _klass_;
#line 292 "controller.vala"
	g_return_if_fail (self != NULL);
#line 292 "controller.vala"
	_klass_ = SYNAPSE_GUI_CONTROLLER_GET_CLASS (self);
#line 292 "controller.vala"
	if (_klass_->clear_search_or_hide_pressed) {
#line 292 "controller.vala"
		_klass_->clear_search_or_hide_pressed (self);
#line 1869 "controller.c"
	}
}

static gboolean
synapse_gui_controller_real_fetch_command (SynapseGuiController* self,
                                           SynapseGuiKeyComboConfigCommands command)
{
	gboolean result;
#line 317 "controller.vala"
	if (command != SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_INVALID_COMMAND) {
#line 319 "controller.vala"
		switch (command) {
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_EXECUTE_WITHOUT_HIDE:
#line 1884 "controller.c"
			{
#line 322 "controller.vala"
				synapse_gui_controller_execute (self, FALSE);
#line 323 "controller.vala"
				break;
#line 1890 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_EXECUTE:
#line 1894 "controller.c"
			{
#line 325 "controller.vala"
				synapse_gui_controller_execute (self, TRUE);
#line 326 "controller.vala"
				break;
#line 1900 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_SEARCH_DELETE_CHAR:
#line 1904 "controller.c"
			{
#line 328 "controller.vala"
				synapse_gui_controller_search_add_delete_char (self, NULL);
#line 329 "controller.vala"
				break;
#line 1910 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_SEARCH_DELETE_WORD:
#line 1914 "controller.c"
			{
#line 331 "controller.vala"
				synapse_gui_controller_search_delete_word (self);
#line 332 "controller.vala"
				break;
#line 1920 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_CLEAR_SEARCH_OR_HIDE:
#line 1924 "controller.c"
			{
#line 334 "controller.vala"
				synapse_gui_controller_clear_search_or_hide_pressed (self);
#line 335 "controller.vala"
				break;
#line 1930 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_PREV_CATEGORY:
#line 1934 "controller.c"
			{
				SynapseGuiModel* _tmp0_;
				SynapseGuiModel* _tmp1_;
#line 337 "controller.vala"
				_tmp0_ = self->model;
#line 337 "controller.vala"
				if (_tmp0_->searching_for == SYNAPSE_GUI_SEARCHING_FOR_TARGETS) {
#line 337 "controller.vala"
					break;
#line 1944 "controller.c"
				}
#line 338 "controller.vala"
				_tmp1_ = self->model;
#line 338 "controller.vala"
				synapse_gui_icontroller_category_changed_event ((SynapseGuiIController*) self, _tmp1_->selected_category - 1);
#line 339 "controller.vala"
				break;
#line 1952 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_NEXT_CATEGORY:
#line 1956 "controller.c"
			{
				SynapseGuiModel* _tmp2_;
				SynapseGuiModel* _tmp3_;
#line 341 "controller.vala"
				_tmp2_ = self->model;
#line 341 "controller.vala"
				if (_tmp2_->searching_for == SYNAPSE_GUI_SEARCHING_FOR_TARGETS) {
#line 341 "controller.vala"
					break;
#line 1966 "controller.c"
				}
#line 342 "controller.vala"
				_tmp3_ = self->model;
#line 342 "controller.vala"
				synapse_gui_icontroller_category_changed_event ((SynapseGuiIController*) self, _tmp3_->selected_category + 1);
#line 343 "controller.vala"
				break;
#line 1974 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_FIRST_RESULT:
#line 1978 "controller.c"
			{
				gboolean _tmp4_ = FALSE;
				SynapseGuiIView* _tmp5_;
#line 345 "controller.vala"
				_tmp5_ = self->view;
#line 345 "controller.vala"
				if (synapse_gui_iview_is_list_visible (_tmp5_)) {
#line 1986 "controller.c"
					SynapseGuiModel* _tmp6_;
					SynapseGuiEntry** _tmp7_;
					gint _tmp7__length1;
					SynapseGuiModel* _tmp8_;
					SynapseGuiEntry* _tmp9_;
					gconstpointer _tmp10_;
					gconstpointer _tmp11_;
#line 345 "controller.vala"
					_tmp6_ = self->model;
#line 345 "controller.vala"
					_tmp7_ = _tmp6_->focus;
#line 345 "controller.vala"
					_tmp7__length1 = _tmp6_->focus_length1;
#line 345 "controller.vala"
					_tmp8_ = self->model;
#line 345 "controller.vala"
					_tmp9_ = _tmp7_[_tmp8_->searching_for];
#line 345 "controller.vala"
					_tmp10_ = synapse_gui_entry_get_key (_tmp9_);
#line 345 "controller.vala"
					_tmp11_ = _tmp10_;
#line 345 "controller.vala"
					_tmp4_ = ((gint) ((gintptr) _tmp11_)) == 0;
#line 2010 "controller.c"
				} else {
#line 345 "controller.vala"
					_tmp4_ = FALSE;
#line 2014 "controller.c"
				}
#line 345 "controller.vala"
				if (_tmp4_) {
#line 2018 "controller.c"
					SynapseGuiIView* _tmp12_;
#line 347 "controller.vala"
					_tmp12_ = self->view;
#line 347 "controller.vala"
					synapse_gui_iview_set_list_visible (_tmp12_, FALSE);
#line 348 "controller.vala"
					break;
#line 2026 "controller.c"
				}
#line 350 "controller.vala"
				synapse_gui_icontroller_selected_index_changed_event ((SynapseGuiIController*) self, 0);
#line 351 "controller.vala"
				break;
#line 2032 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_LAST_RESULT:
#line 2036 "controller.c"
			{
				SynapseGuiIView* _tmp13_;
				SynapseGuiModel* _tmp15_;
#line 353 "controller.vala"
				_tmp13_ = self->view;
#line 353 "controller.vala"
				if (!synapse_gui_iview_is_list_visible (_tmp13_)) {
#line 2044 "controller.c"
					SynapseGuiIView* _tmp14_;
#line 355 "controller.vala"
					_tmp14_ = self->view;
#line 355 "controller.vala"
					synapse_gui_iview_set_list_visible (_tmp14_, TRUE);
#line 2050 "controller.c"
				}
#line 357 "controller.vala"
				_tmp15_ = self->model;
#line 357 "controller.vala"
				if (synapse_gui_model_has_results (_tmp15_)) {
#line 2056 "controller.c"
					SynapseGuiModel* _tmp16_;
					GeeList** _tmp17_;
					gint _tmp17__length1;
					SynapseGuiModel* _tmp18_;
					GeeList* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
#line 358 "controller.vala"
					_tmp16_ = self->model;
#line 358 "controller.vala"
					_tmp17_ = _tmp16_->results;
#line 358 "controller.vala"
					_tmp17__length1 = _tmp16_->results_length1;
#line 358 "controller.vala"
					_tmp18_ = self->model;
#line 358 "controller.vala"
					_tmp19_ = _tmp17_[_tmp18_->searching_for];
#line 358 "controller.vala"
					_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
#line 358 "controller.vala"
					_tmp21_ = _tmp20_;
#line 358 "controller.vala"
					synapse_gui_icontroller_selected_index_changed_event ((SynapseGuiIController*) self, _tmp21_ - 1);
#line 2080 "controller.c"
				}
#line 359 "controller.vala"
				break;
#line 2084 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_PREV_RESULT:
#line 2088 "controller.c"
			{
				gboolean _tmp22_ = FALSE;
				SynapseGuiIView* _tmp23_;
				SynapseGuiModel* _tmp31_;
				SynapseGuiEntry** _tmp32_;
				gint _tmp32__length1;
				SynapseGuiModel* _tmp33_;
				SynapseGuiEntry* _tmp34_;
				gconstpointer _tmp35_;
				gconstpointer _tmp36_;
#line 361 "controller.vala"
				_tmp23_ = self->view;
#line 361 "controller.vala"
				if (synapse_gui_iview_is_list_visible (_tmp23_)) {
#line 2103 "controller.c"
					SynapseGuiModel* _tmp24_;
					SynapseGuiEntry** _tmp25_;
					gint _tmp25__length1;
					SynapseGuiModel* _tmp26_;
					SynapseGuiEntry* _tmp27_;
					gconstpointer _tmp28_;
					gconstpointer _tmp29_;
#line 361 "controller.vala"
					_tmp24_ = self->model;
#line 361 "controller.vala"
					_tmp25_ = _tmp24_->focus;
#line 361 "controller.vala"
					_tmp25__length1 = _tmp24_->focus_length1;
#line 361 "controller.vala"
					_tmp26_ = self->model;
#line 361 "controller.vala"
					_tmp27_ = _tmp25_[_tmp26_->searching_for];
#line 361 "controller.vala"
					_tmp28_ = synapse_gui_entry_get_key (_tmp27_);
#line 361 "controller.vala"
					_tmp29_ = _tmp28_;
#line 361 "controller.vala"
					_tmp22_ = ((gint) ((gintptr) _tmp29_)) == 0;
#line 2127 "controller.c"
				} else {
#line 361 "controller.vala"
					_tmp22_ = FALSE;
#line 2131 "controller.c"
				}
#line 361 "controller.vala"
				if (_tmp22_) {
#line 2135 "controller.c"
					SynapseGuiIView* _tmp30_;
#line 363 "controller.vala"
					_tmp30_ = self->view;
#line 363 "controller.vala"
					synapse_gui_iview_set_list_visible (_tmp30_, FALSE);
#line 364 "controller.vala"
					break;
#line 2143 "controller.c"
				}
#line 366 "controller.vala"
				_tmp31_ = self->model;
#line 366 "controller.vala"
				_tmp32_ = _tmp31_->focus;
#line 366 "controller.vala"
				_tmp32__length1 = _tmp31_->focus_length1;
#line 366 "controller.vala"
				_tmp33_ = self->model;
#line 366 "controller.vala"
				_tmp34_ = _tmp32_[_tmp33_->searching_for];
#line 366 "controller.vala"
				_tmp35_ = synapse_gui_entry_get_key (_tmp34_);
#line 366 "controller.vala"
				_tmp36_ = _tmp35_;
#line 366 "controller.vala"
				synapse_gui_icontroller_selected_index_changed_event ((SynapseGuiIController*) self, ((gint) ((gintptr) _tmp36_)) - 1);
#line 367 "controller.vala"
				break;
#line 2163 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_PREV_PAGE:
#line 2167 "controller.c"
			{
				gboolean _tmp37_ = FALSE;
				SynapseGuiIView* _tmp38_;
				SynapseGuiModel* _tmp46_;
				SynapseGuiEntry** _tmp47_;
				gint _tmp47__length1;
				SynapseGuiModel* _tmp48_;
				SynapseGuiEntry* _tmp49_;
				gconstpointer _tmp50_;
				gconstpointer _tmp51_;
#line 369 "controller.vala"
				_tmp38_ = self->view;
#line 369 "controller.vala"
				if (synapse_gui_iview_is_list_visible (_tmp38_)) {
#line 2182 "controller.c"
					SynapseGuiModel* _tmp39_;
					SynapseGuiEntry** _tmp40_;
					gint _tmp40__length1;
					SynapseGuiModel* _tmp41_;
					SynapseGuiEntry* _tmp42_;
					gconstpointer _tmp43_;
					gconstpointer _tmp44_;
#line 369 "controller.vala"
					_tmp39_ = self->model;
#line 369 "controller.vala"
					_tmp40_ = _tmp39_->focus;
#line 369 "controller.vala"
					_tmp40__length1 = _tmp39_->focus_length1;
#line 369 "controller.vala"
					_tmp41_ = self->model;
#line 369 "controller.vala"
					_tmp42_ = _tmp40_[_tmp41_->searching_for];
#line 369 "controller.vala"
					_tmp43_ = synapse_gui_entry_get_key (_tmp42_);
#line 369 "controller.vala"
					_tmp44_ = _tmp43_;
#line 369 "controller.vala"
					_tmp37_ = ((gint) ((gintptr) _tmp44_)) == 0;
#line 2206 "controller.c"
				} else {
#line 369 "controller.vala"
					_tmp37_ = FALSE;
#line 2210 "controller.c"
				}
#line 369 "controller.vala"
				if (_tmp37_) {
#line 2214 "controller.c"
					SynapseGuiIView* _tmp45_;
#line 371 "controller.vala"
					_tmp45_ = self->view;
#line 371 "controller.vala"
					synapse_gui_iview_set_list_visible (_tmp45_, FALSE);
#line 372 "controller.vala"
					break;
#line 2222 "controller.c"
				}
#line 374 "controller.vala"
				_tmp46_ = self->model;
#line 374 "controller.vala"
				_tmp47_ = _tmp46_->focus;
#line 374 "controller.vala"
				_tmp47__length1 = _tmp46_->focus_length1;
#line 374 "controller.vala"
				_tmp48_ = self->model;
#line 374 "controller.vala"
				_tmp49_ = _tmp47_[_tmp48_->searching_for];
#line 374 "controller.vala"
				_tmp50_ = synapse_gui_entry_get_key (_tmp49_);
#line 374 "controller.vala"
				_tmp51_ = _tmp50_;
#line 374 "controller.vala"
				synapse_gui_icontroller_selected_index_changed_event ((SynapseGuiIController*) self, ((gint) ((gintptr) _tmp51_)) - SYNAPSE_GUI_ICONTROLLER_RESULTS_PER_PAGE);
#line 375 "controller.vala"
				break;
#line 2242 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_NEXT_RESULT:
#line 2246 "controller.c"
			{
				gboolean _tmp52_ = FALSE;
				SynapseGuiIView* _tmp54_;
				SynapseGuiModel* _tmp56_;
				SynapseGuiEntry** _tmp57_;
				gint _tmp57__length1;
				SynapseGuiModel* _tmp58_;
				SynapseGuiEntry* _tmp59_;
				gconstpointer _tmp60_;
				gconstpointer _tmp61_;
#line 377 "controller.vala"
				if (synapse_gui_icontroller_is_in_initial_state ((SynapseGuiIController*) self)) {
#line 377 "controller.vala"
					_tmp52_ = self->priv->handle_empty;
#line 2261 "controller.c"
				} else {
#line 377 "controller.vala"
					_tmp52_ = FALSE;
#line 2265 "controller.c"
				}
#line 377 "controller.vala"
				if (_tmp52_) {
#line 2269 "controller.c"
					SynapseGuiIView* _tmp53_;
#line 379 "controller.vala"
					self->priv->search_recent_activities = TRUE;
#line 380 "controller.vala"
					synapse_gui_controller_search_for_matches (self, SYNAPSE_GUI_SEARCHING_FOR_SOURCES, TRUE, NULL);
#line 381 "controller.vala"
					_tmp53_ = self->view;
#line 381 "controller.vala"
					synapse_gui_iview_set_list_visible (_tmp53_, TRUE);
#line 382 "controller.vala"
					break;
#line 2281 "controller.c"
				}
#line 384 "controller.vala"
				_tmp54_ = self->view;
#line 384 "controller.vala"
				if (!synapse_gui_iview_is_list_visible (_tmp54_)) {
#line 2287 "controller.c"
					SynapseGuiIView* _tmp55_;
#line 386 "controller.vala"
					_tmp55_ = self->view;
#line 386 "controller.vala"
					synapse_gui_iview_set_list_visible (_tmp55_, TRUE);
#line 387 "controller.vala"
					break;
#line 2295 "controller.c"
				}
#line 389 "controller.vala"
				_tmp56_ = self->model;
#line 389 "controller.vala"
				_tmp57_ = _tmp56_->focus;
#line 389 "controller.vala"
				_tmp57__length1 = _tmp56_->focus_length1;
#line 389 "controller.vala"
				_tmp58_ = self->model;
#line 389 "controller.vala"
				_tmp59_ = _tmp57_[_tmp58_->searching_for];
#line 389 "controller.vala"
				_tmp60_ = synapse_gui_entry_get_key (_tmp59_);
#line 389 "controller.vala"
				_tmp61_ = _tmp60_;
#line 389 "controller.vala"
				synapse_gui_icontroller_selected_index_changed_event ((SynapseGuiIController*) self, ((gint) ((gintptr) _tmp61_)) + 1);
#line 390 "controller.vala"
				break;
#line 2315 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_NEXT_PAGE:
#line 2319 "controller.c"
			{
				SynapseGuiIView* _tmp62_;
				SynapseGuiModel* _tmp64_;
				SynapseGuiEntry** _tmp65_;
				gint _tmp65__length1;
				SynapseGuiModel* _tmp66_;
				SynapseGuiEntry* _tmp67_;
				gconstpointer _tmp68_;
				gconstpointer _tmp69_;
#line 392 "controller.vala"
				_tmp62_ = self->view;
#line 392 "controller.vala"
				if (!synapse_gui_iview_is_list_visible (_tmp62_)) {
#line 2333 "controller.c"
					SynapseGuiIView* _tmp63_;
#line 394 "controller.vala"
					_tmp63_ = self->view;
#line 394 "controller.vala"
					synapse_gui_iview_set_list_visible (_tmp63_, TRUE);
#line 395 "controller.vala"
					break;
#line 2341 "controller.c"
				}
#line 397 "controller.vala"
				_tmp64_ = self->model;
#line 397 "controller.vala"
				_tmp65_ = _tmp64_->focus;
#line 397 "controller.vala"
				_tmp65__length1 = _tmp64_->focus_length1;
#line 397 "controller.vala"
				_tmp66_ = self->model;
#line 397 "controller.vala"
				_tmp67_ = _tmp65_[_tmp66_->searching_for];
#line 397 "controller.vala"
				_tmp68_ = synapse_gui_entry_get_key (_tmp67_);
#line 397 "controller.vala"
				_tmp69_ = _tmp68_;
#line 397 "controller.vala"
				synapse_gui_icontroller_selected_index_changed_event ((SynapseGuiIController*) self, ((gint) ((gintptr) _tmp69_)) + SYNAPSE_GUI_ICONTROLLER_RESULTS_PER_PAGE);
#line 398 "controller.vala"
				break;
#line 2361 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_NEXT_PANE:
#line 2365 "controller.c"
			{
				SynapseGuiModel* _tmp70_;
#line 400 "controller.vala"
				_tmp70_ = self->model;
#line 400 "controller.vala"
				switch (_tmp70_->searching_for) {
#line 400 "controller.vala"
					case SYNAPSE_GUI_SEARCHING_FOR_SOURCES:
#line 2374 "controller.c"
					{
						SynapseGuiModel* _tmp71_;
						SynapseGuiEntry** _tmp72_;
						gint _tmp72__length1;
						SynapseGuiEntry* _tmp73_;
						gconstpointer _tmp74_;
						gconstpointer _tmp75_;
#line 403 "controller.vala"
						_tmp71_ = self->model;
#line 403 "controller.vala"
						_tmp72_ = _tmp71_->focus;
#line 403 "controller.vala"
						_tmp72__length1 = _tmp71_->focus_length1;
#line 403 "controller.vala"
						_tmp73_ = _tmp72_[SYNAPSE_GUI_SEARCHING_FOR_SOURCES];
#line 403 "controller.vala"
						_tmp74_ = synapse_gui_entry_get_value (_tmp73_);
#line 403 "controller.vala"
						_tmp75_ = _tmp74_;
#line 403 "controller.vala"
						if (((SynapseMatch*) _tmp75_) != NULL) {
#line 2396 "controller.c"
							SynapseGuiModel* _tmp76_;
							SynapseGuiIView* _tmp77_;
#line 405 "controller.vala"
							_tmp76_ = self->model;
#line 405 "controller.vala"
							_tmp76_->searching_for = SYNAPSE_GUI_SEARCHING_FOR_ACTIONS;
#line 406 "controller.vala"
							_tmp77_ = self->view;
#line 406 "controller.vala"
							synapse_gui_iview_update_searching_for (_tmp77_);
#line 2407 "controller.c"
						}
#line 408 "controller.vala"
						break;
#line 2411 "controller.c"
					}
#line 400 "controller.vala"
					case SYNAPSE_GUI_SEARCHING_FOR_ACTIONS:
#line 2415 "controller.c"
					{
						gboolean _tmp78_ = FALSE;
						SynapseGuiModel* _tmp79_;
						SynapseGuiEntry** _tmp80_;
						gint _tmp80__length1;
						SynapseGuiEntry* _tmp81_;
						gconstpointer _tmp82_;
						gconstpointer _tmp83_;
						SynapseGuiIView* _tmp91_;
#line 410 "controller.vala"
						_tmp79_ = self->model;
#line 410 "controller.vala"
						_tmp80_ = _tmp79_->focus;
#line 410 "controller.vala"
						_tmp80__length1 = _tmp79_->focus_length1;
#line 410 "controller.vala"
						_tmp81_ = _tmp80_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 410 "controller.vala"
						_tmp82_ = synapse_gui_entry_get_value (_tmp81_);
#line 410 "controller.vala"
						_tmp83_ = _tmp82_;
#line 410 "controller.vala"
						if (((SynapseMatch*) _tmp83_) != NULL) {
#line 2439 "controller.c"
							SynapseGuiModel* _tmp84_;
							SynapseGuiEntry** _tmp85_;
							gint _tmp85__length1;
							SynapseGuiEntry* _tmp86_;
							gconstpointer _tmp87_;
							gconstpointer _tmp88_;
#line 411 "controller.vala"
							_tmp84_ = self->model;
#line 411 "controller.vala"
							_tmp85_ = _tmp84_->focus;
#line 411 "controller.vala"
							_tmp85__length1 = _tmp84_->focus_length1;
#line 411 "controller.vala"
							_tmp86_ = _tmp85_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 411 "controller.vala"
							_tmp87_ = synapse_gui_entry_get_value (_tmp86_);
#line 411 "controller.vala"
							_tmp88_ = _tmp87_;
#line 411 "controller.vala"
							_tmp78_ = synapse_match_needs_target ((SynapseMatch*) _tmp88_);
#line 2460 "controller.c"
						} else {
#line 410 "controller.vala"
							_tmp78_ = FALSE;
#line 2464 "controller.c"
						}
#line 410 "controller.vala"
						if (_tmp78_) {
#line 2468 "controller.c"
							SynapseGuiModel* _tmp89_;
#line 413 "controller.vala"
							_tmp89_ = self->model;
#line 413 "controller.vala"
							_tmp89_->searching_for = SYNAPSE_GUI_SEARCHING_FOR_TARGETS;
#line 2474 "controller.c"
						} else {
							SynapseGuiModel* _tmp90_;
#line 417 "controller.vala"
							_tmp90_ = self->model;
#line 417 "controller.vala"
							_tmp90_->searching_for = SYNAPSE_GUI_SEARCHING_FOR_SOURCES;
#line 2481 "controller.c"
						}
#line 419 "controller.vala"
						_tmp91_ = self->view;
#line 419 "controller.vala"
						synapse_gui_iview_update_searching_for (_tmp91_);
#line 420 "controller.vala"
						break;
#line 2489 "controller.c"
					}
					default:
					{
						SynapseGuiModel* _tmp92_;
						SynapseGuiIView* _tmp93_;
#line 422 "controller.vala"
						_tmp92_ = self->model;
#line 422 "controller.vala"
						_tmp92_->searching_for = SYNAPSE_GUI_SEARCHING_FOR_ACTIONS;
#line 423 "controller.vala"
						_tmp93_ = self->view;
#line 423 "controller.vala"
						synapse_gui_iview_update_searching_for (_tmp93_);
#line 424 "controller.vala"
						break;
#line 2505 "controller.c"
					}
				}
#line 426 "controller.vala"
				break;
#line 2510 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_PREV_PANE:
#line 2514 "controller.c"
			{
				SynapseGuiModel* _tmp94_;
#line 428 "controller.vala"
				_tmp94_ = self->model;
#line 428 "controller.vala"
				switch (_tmp94_->searching_for) {
#line 428 "controller.vala"
					case SYNAPSE_GUI_SEARCHING_FOR_ACTIONS:
#line 2523 "controller.c"
					{
						SynapseGuiModel* _tmp95_;
						SynapseGuiIView* _tmp96_;
#line 431 "controller.vala"
						_tmp95_ = self->model;
#line 431 "controller.vala"
						_tmp95_->searching_for = SYNAPSE_GUI_SEARCHING_FOR_SOURCES;
#line 432 "controller.vala"
						_tmp96_ = self->view;
#line 432 "controller.vala"
						synapse_gui_iview_update_searching_for (_tmp96_);
#line 433 "controller.vala"
						break;
#line 2537 "controller.c"
					}
#line 428 "controller.vala"
					case SYNAPSE_GUI_SEARCHING_FOR_TARGETS:
#line 2541 "controller.c"
					{
						SynapseGuiModel* _tmp97_;
						SynapseGuiIView* _tmp98_;
#line 435 "controller.vala"
						_tmp97_ = self->model;
#line 435 "controller.vala"
						_tmp97_->searching_for = SYNAPSE_GUI_SEARCHING_FOR_ACTIONS;
#line 436 "controller.vala"
						_tmp98_ = self->view;
#line 436 "controller.vala"
						synapse_gui_iview_update_searching_for (_tmp98_);
#line 437 "controller.vala"
						break;
#line 2555 "controller.c"
					}
					default:
					{
#line 440 "controller.vala"
						break;
#line 2561 "controller.c"
					}
				}
#line 442 "controller.vala"
				break;
#line 2566 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_ACTIVATE:
#line 2570 "controller.c"
			{
				SynapseGuiIView* _tmp99_;
				SynapseGuiIView* _tmp100_;
#line 444 "controller.vala"
				_tmp99_ = self->view;
#line 444 "controller.vala"
				synapse_gui_iview_vanish (_tmp99_);
#line 445 "controller.vala"
				synapse_gui_controller_reset_search (self, TRUE, TRUE);
#line 446 "controller.vala"
				_tmp100_ = self->view;
#line 446 "controller.vala"
				synapse_gui_iview_set_list_visible (_tmp100_, FALSE);
#line 447 "controller.vala"
				break;
#line 2586 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_EXIT_SYNAPSE:
#line 2590 "controller.c"
			{
#line 449 "controller.vala"
				gtk_main_quit ();
#line 450 "controller.vala"
				break;
#line 2596 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_PASTE:
#line 2600 "controller.c"
			{
				GdkDisplay* display = NULL;
				SynapseGuiIView* _tmp101_;
				GdkDisplay* _tmp105_;
				GtkClipboard* clipboard = NULL;
				GdkDisplay* _tmp109_;
				GtkClipboard* _tmp110_;
				GtkClipboard* _tmp111_;
				gchar* text = NULL;
				GtkClipboard* _tmp112_;
				gchar* _tmp113_;
				gboolean _tmp114_ = FALSE;
				const gchar* _tmp115_;
#line 452 "controller.vala"
				display = NULL;
#line 453 "controller.vala"
				_tmp101_ = self->view;
#line 453 "controller.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, gtk_widget_get_type ())) {
#line 2620 "controller.c"
					SynapseGuiIView* _tmp102_;
					GdkDisplay* _tmp103_;
					GdkDisplay* _tmp104_;
#line 455 "controller.vala"
					_tmp102_ = self->view;
#line 455 "controller.vala"
					_tmp103_ = gtk_widget_get_display (G_TYPE_CHECK_INSTANCE_TYPE (_tmp102_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp102_) : NULL);
#line 455 "controller.vala"
					_tmp104_ = _g_object_ref0 (_tmp103_);
#line 455 "controller.vala"
					_g_object_unref0 (display);
#line 455 "controller.vala"
					display = _tmp104_;
#line 2634 "controller.c"
				}
#line 457 "controller.vala"
				_tmp105_ = display;
#line 457 "controller.vala"
				if (_tmp105_ == NULL) {
#line 2640 "controller.c"
					GdkScreen* _tmp106_;
					GdkDisplay* _tmp107_;
					GdkDisplay* _tmp108_;
#line 459 "controller.vala"
					_tmp106_ = gdk_screen_get_default ();
#line 459 "controller.vala"
					_tmp107_ = gdk_screen_get_display (_tmp106_);
#line 459 "controller.vala"
					_tmp108_ = _g_object_ref0 (_tmp107_);
#line 459 "controller.vala"
					_g_object_unref0 (display);
#line 459 "controller.vala"
					display = _tmp108_;
#line 2654 "controller.c"
				}
#line 461 "controller.vala"
				_tmp109_ = display;
#line 461 "controller.vala"
				_tmp110_ = gtk_clipboard_get_for_display (_tmp109_, GDK_SELECTION_CLIPBOARD);
#line 461 "controller.vala"
				_tmp111_ = _g_object_ref0 (_tmp110_);
#line 461 "controller.vala"
				clipboard = _tmp111_;
#line 464 "controller.vala"
				_tmp112_ = clipboard;
#line 464 "controller.vala"
				_tmp113_ = gtk_clipboard_wait_for_text (_tmp112_);
#line 464 "controller.vala"
				text = _tmp113_;
#line 465 "controller.vala"
				_tmp115_ = text;
#line 465 "controller.vala"
				if (_tmp115_ != NULL) {
#line 2674 "controller.c"
					const gchar* _tmp116_;
#line 465 "controller.vala"
					_tmp116_ = text;
#line 465 "controller.vala"
					_tmp114_ = g_strcmp0 (_tmp116_, "") != 0;
#line 2680 "controller.c"
				} else {
#line 465 "controller.vala"
					_tmp114_ = FALSE;
#line 2684 "controller.c"
				}
#line 465 "controller.vala"
				if (_tmp114_) {
#line 2688 "controller.c"
					const gchar* _tmp117_;
#line 467 "controller.vala"
					_tmp117_ = text;
#line 467 "controller.vala"
					synapse_gui_controller_search_add_delete_char (self, _tmp117_);
#line 2694 "controller.c"
				}
#line 469 "controller.vala"
				_g_free0 (text);
#line 469 "controller.vala"
				_g_object_unref0 (clipboard);
#line 469 "controller.vala"
				_g_object_unref0 (display);
#line 469 "controller.vala"
				break;
#line 2704 "controller.c"
			}
#line 319 "controller.vala"
			case SYNAPSE_GUI_KEY_COMBO_CONFIG_COMMANDS_PASTE_SELECTION:
#line 2708 "controller.c"
			{
				GdkDisplay* display = NULL;
				SynapseGuiIView* _tmp118_;
				GdkDisplay* _tmp122_;
				GtkClipboard* clipboard = NULL;
				GdkDisplay* _tmp126_;
				GtkClipboard* _tmp127_;
				GtkClipboard* _tmp128_;
				gchar* text = NULL;
				GtkClipboard* _tmp129_;
				gchar* _tmp130_;
				gboolean _tmp131_ = FALSE;
				const gchar* _tmp132_;
#line 471 "controller.vala"
				display = NULL;
#line 472 "controller.vala"
				_tmp118_ = self->view;
#line 472 "controller.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp118_, gtk_widget_get_type ())) {
#line 2728 "controller.c"
					SynapseGuiIView* _tmp119_;
					GdkDisplay* _tmp120_;
					GdkDisplay* _tmp121_;
#line 474 "controller.vala"
					_tmp119_ = self->view;
#line 474 "controller.vala"
					_tmp120_ = gtk_widget_get_display (G_TYPE_CHECK_INSTANCE_TYPE (_tmp119_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp119_) : NULL);
#line 474 "controller.vala"
					_tmp121_ = _g_object_ref0 (_tmp120_);
#line 474 "controller.vala"
					_g_object_unref0 (display);
#line 474 "controller.vala"
					display = _tmp121_;
#line 2742 "controller.c"
				}
#line 476 "controller.vala"
				_tmp122_ = display;
#line 476 "controller.vala"
				if (_tmp122_ == NULL) {
#line 2748 "controller.c"
					GdkScreen* _tmp123_;
					GdkDisplay* _tmp124_;
					GdkDisplay* _tmp125_;
#line 478 "controller.vala"
					_tmp123_ = gdk_screen_get_default ();
#line 478 "controller.vala"
					_tmp124_ = gdk_screen_get_display (_tmp123_);
#line 478 "controller.vala"
					_tmp125_ = _g_object_ref0 (_tmp124_);
#line 478 "controller.vala"
					_g_object_unref0 (display);
#line 478 "controller.vala"
					display = _tmp125_;
#line 2762 "controller.c"
				}
#line 480 "controller.vala"
				_tmp126_ = display;
#line 480 "controller.vala"
				_tmp127_ = gtk_clipboard_get_for_display (_tmp126_, GDK_SELECTION_PRIMARY);
#line 480 "controller.vala"
				_tmp128_ = _g_object_ref0 (_tmp127_);
#line 480 "controller.vala"
				clipboard = _tmp128_;
#line 483 "controller.vala"
				_tmp129_ = clipboard;
#line 483 "controller.vala"
				_tmp130_ = gtk_clipboard_wait_for_text (_tmp129_);
#line 483 "controller.vala"
				text = _tmp130_;
#line 484 "controller.vala"
				_tmp132_ = text;
#line 484 "controller.vala"
				if (_tmp132_ != NULL) {
#line 2782 "controller.c"
					const gchar* _tmp133_;
#line 484 "controller.vala"
					_tmp133_ = text;
#line 484 "controller.vala"
					_tmp131_ = g_strcmp0 (_tmp133_, "") != 0;
#line 2788 "controller.c"
				} else {
#line 484 "controller.vala"
					_tmp131_ = FALSE;
#line 2792 "controller.c"
				}
#line 484 "controller.vala"
				if (_tmp131_) {
#line 2796 "controller.c"
					const gchar* _tmp134_;
#line 486 "controller.vala"
					_tmp134_ = text;
#line 486 "controller.vala"
					synapse_gui_controller_search_add_delete_char (self, _tmp134_);
#line 2802 "controller.c"
				}
#line 488 "controller.vala"
				_g_free0 (text);
#line 488 "controller.vala"
				_g_object_unref0 (clipboard);
#line 488 "controller.vala"
				_g_object_unref0 (display);
#line 488 "controller.vala"
				break;
#line 2812 "controller.c"
			}
			default:
#line 319 "controller.vala"
			break;
#line 2817 "controller.c"
		}
#line 490 "controller.vala"
		result = TRUE;
#line 490 "controller.vala"
		return result;
#line 2823 "controller.c"
	}
#line 492 "controller.vala"
	result = FALSE;
#line 492 "controller.vala"
	return result;
#line 2829 "controller.c"
}

gboolean
synapse_gui_controller_fetch_command (SynapseGuiController* self,
                                      SynapseGuiKeyComboConfigCommands command)
{
	SynapseGuiControllerClass* _klass_;
#line 315 "controller.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 315 "controller.vala"
	_klass_ = SYNAPSE_GUI_CONTROLLER_GET_CLASS (self);
#line 315 "controller.vala"
	if (_klass_->fetch_command) {
#line 315 "controller.vala"
		return _klass_->fetch_command (self, command);
#line 2845 "controller.c"
	}
#line 315 "controller.vala"
	return FALSE;
#line 2849 "controller.c"
}

static gboolean
synapse_gui_controller_real_is_in_initial_state (SynapseGuiIController* base)
{
	SynapseGuiController * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	SynapseGuiModel* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gboolean result;
#line 496 "controller.vala"
	self = (SynapseGuiController*) base;
#line 498 "controller.vala"
	_tmp2_ = self->model;
#line 498 "controller.vala"
	_tmp3_ = _tmp2_->query;
#line 498 "controller.vala"
	_tmp3__length1 = _tmp2_->query_length1;
#line 498 "controller.vala"
	_tmp4_ = _tmp3_[SYNAPSE_GUI_SEARCHING_FOR_SOURCES];
#line 498 "controller.vala"
	if (g_strcmp0 (_tmp4_, "") == 0) {
#line 2875 "controller.c"
		SynapseGuiModel* _tmp5_;
		SynapseGuiEntry** _tmp6_;
		gint _tmp6__length1;
		SynapseGuiEntry* _tmp7_;
		gconstpointer _tmp8_;
		gconstpointer _tmp9_;
#line 499 "controller.vala"
		_tmp5_ = self->model;
#line 499 "controller.vala"
		_tmp6_ = _tmp5_->focus;
#line 499 "controller.vala"
		_tmp6__length1 = _tmp5_->focus_length1;
#line 499 "controller.vala"
		_tmp7_ = _tmp6_[SYNAPSE_GUI_SEARCHING_FOR_SOURCES];
#line 499 "controller.vala"
		_tmp8_ = synapse_gui_entry_get_value (_tmp7_);
#line 499 "controller.vala"
		_tmp9_ = _tmp8_;
#line 499 "controller.vala"
		_tmp1_ = ((SynapseMatch*) _tmp9_) == NULL;
#line 2896 "controller.c"
	} else {
#line 498 "controller.vala"
		_tmp1_ = FALSE;
#line 2900 "controller.c"
	}
#line 498 "controller.vala"
	if (_tmp1_) {
#line 500 "controller.vala"
		_tmp0_ = !self->priv->search_recent_activities;
#line 2906 "controller.c"
	} else {
#line 498 "controller.vala"
		_tmp0_ = FALSE;
#line 2910 "controller.c"
	}
#line 498 "controller.vala"
	result = _tmp0_;
#line 498 "controller.vala"
	return result;
#line 2916 "controller.c"
}

static gboolean
synapse_gui_controller_real_searched_for_recent (SynapseGuiIController* base)
{
	SynapseGuiController * self;
	SynapseGuiModel* _tmp0_;
	gboolean _tmp1_;
	SynapseGuiModel* _tmp2_;
	gboolean result;
#line 504 "controller.vala"
	self = (SynapseGuiController*) base;
#line 506 "controller.vala"
	_tmp0_ = self->model;
#line 506 "controller.vala"
	_tmp1_ = self->priv->searching[_tmp0_->searching_for];
#line 506 "controller.vala"
	if (_tmp1_) {
#line 506 "controller.vala"
		result = FALSE;
#line 506 "controller.vala"
		return result;
#line 2939 "controller.c"
	}
#line 507 "controller.vala"
	_tmp2_ = self->model;
#line 507 "controller.vala"
	switch (_tmp2_->searching_for) {
#line 507 "controller.vala"
		case SYNAPSE_GUI_SEARCHING_FOR_SOURCES:
#line 2947 "controller.c"
		{
#line 509 "controller.vala"
			result = self->priv->search_recent_activities;
#line 509 "controller.vala"
			return result;
#line 2953 "controller.c"
		}
#line 507 "controller.vala"
		case SYNAPSE_GUI_SEARCHING_FOR_ACTIONS:
#line 2957 "controller.c"
		{
#line 510 "controller.vala"
			result = FALSE;
#line 510 "controller.vala"
			return result;
#line 2963 "controller.c"
		}
		default:
		{
			SynapseGuiModel* _tmp3_;
			gchar** _tmp4_;
			gint _tmp4__length1;
			const gchar* _tmp5_;
#line 511 "controller.vala"
			_tmp3_ = self->model;
#line 511 "controller.vala"
			_tmp4_ = _tmp3_->query;
#line 511 "controller.vala"
			_tmp4__length1 = _tmp3_->query_length1;
#line 511 "controller.vala"
			_tmp5_ = _tmp4_[SYNAPSE_GUI_SEARCHING_FOR_TARGETS];
#line 511 "controller.vala"
			result = g_strcmp0 (_tmp5_, "") == 0;
#line 511 "controller.vala"
			return result;
#line 2983 "controller.c"
		}
	}
}

static void
_synapse_gui_controller_update_handle_empty_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
#line 541 "controller.vala"
	synapse_gui_controller_update_handle_empty ((SynapseGuiController*) self);
#line 2995 "controller.c"
}

static void
synapse_gui_controller_init_search (SynapseGuiController* self)
{
	SynapseGuiModel* _tmp3_;
	SynapseGuiCategoryConfig* _tmp4_;
	SynapseGuiCategoryConfig* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	SynapseGuiCategoryConfig* _tmp8_;
	SynapseGuiCategoryConfig* _tmp9_;
	GeeList* _tmp10_;
	GeeList* _tmp11_;
	SynapseGuiCategoryConfig* _tmp12_;
	SynapseGuiCategoryConfig* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gpointer _tmp16_;
	SynapseGuiCategoryConfigCategory* _tmp17_;
	SynapseQueryFlags _tmp18_;
	SynapseQueryFlags _tmp19_;
	SynapseDataSink* _tmp20_;
	SynapseDataSink* _tmp21_;
#line 527 "controller.vala"
	g_return_if_fail (self != NULL);
#line 3022 "controller.c"
	{
		gint i = 0;
#line 529 "controller.vala"
		i = 0;
#line 3027 "controller.c"
		{
			gboolean _tmp0_ = FALSE;
#line 529 "controller.vala"
			_tmp0_ = TRUE;
#line 529 "controller.vala"
			while (TRUE) {
#line 3034 "controller.c"
				GCancellable* _tmp2_;
#line 529 "controller.vala"
				if (!_tmp0_) {
#line 3038 "controller.c"
					gint _tmp1_;
#line 529 "controller.vala"
					_tmp1_ = i;
#line 529 "controller.vala"
					i = _tmp1_ + 1;
#line 3044 "controller.c"
				}
#line 529 "controller.vala"
				_tmp0_ = FALSE;
#line 529 "controller.vala"
				if (!(i < ((gint) SYNAPSE_GUI_SEARCHING_FOR_COUNT))) {
#line 529 "controller.vala"
					break;
#line 3052 "controller.c"
				}
#line 531 "controller.vala"
				_tmp2_ = g_cancellable_new ();
#line 531 "controller.vala"
				_g_object_unref0 (self->priv->current_cancellable[i]);
#line 531 "controller.vala"
				self->priv->current_cancellable[i] = _tmp2_;
#line 532 "controller.vala"
				self->priv->tid[i] = (guint) 0;
#line 533 "controller.vala"
				self->priv->partial_result_sent[i] = FALSE;
#line 534 "controller.vala"
				self->priv->searching[i] = FALSE;
#line 3066 "controller.c"
			}
		}
	}
#line 536 "controller.vala"
	_tmp3_ = self->model;
#line 536 "controller.vala"
	_tmp4_ = synapse_gui_icontroller_get_category_config ((SynapseGuiIController*) self);
#line 536 "controller.vala"
	_tmp5_ = _tmp4_;
#line 536 "controller.vala"
	_tmp6_ = synapse_gui_category_config_get_default_category_index (_tmp5_);
#line 536 "controller.vala"
	_tmp7_ = _tmp6_;
#line 536 "controller.vala"
	synapse_gui_model_clear (_tmp3_, _tmp7_);
#line 538 "controller.vala"
	_tmp8_ = synapse_gui_icontroller_get_category_config ((SynapseGuiIController*) self);
#line 538 "controller.vala"
	_tmp9_ = _tmp8_;
#line 538 "controller.vala"
	_tmp10_ = synapse_gui_category_config_get_categories (_tmp9_);
#line 538 "controller.vala"
	_tmp11_ = _tmp10_;
#line 538 "controller.vala"
	_tmp12_ = synapse_gui_icontroller_get_category_config ((SynapseGuiIController*) self);
#line 538 "controller.vala"
	_tmp13_ = _tmp12_;
#line 538 "controller.vala"
	_tmp14_ = synapse_gui_category_config_get_default_category_index (_tmp13_);
#line 538 "controller.vala"
	_tmp15_ = _tmp14_;
#line 538 "controller.vala"
	_tmp16_ = gee_list_get (_tmp11_, _tmp15_);
#line 538 "controller.vala"
	_tmp17_ = (SynapseGuiCategoryConfigCategory*) _tmp16_;
#line 538 "controller.vala"
	_tmp18_ = synapse_gui_category_config_category_get_flags (_tmp17_);
#line 538 "controller.vala"
	_tmp19_ = _tmp18_;
#line 538 "controller.vala"
	self->priv->qf = _tmp19_;
#line 538 "controller.vala"
	_g_object_unref0 (_tmp17_);
#line 539 "controller.vala"
	_g_object_unref0 (self->priv->last_result_set);
#line 539 "controller.vala"
	self->priv->last_result_set = NULL;
#line 541 "controller.vala"
	_tmp20_ = synapse_gui_icontroller_get_data_sink ((SynapseGuiIController*) self);
#line 541 "controller.vala"
	_tmp21_ = _tmp20_;
#line 541 "controller.vala"
	g_signal_connect_object ((GObject*) _tmp21_, "notify::has-empty-handlers", (GCallback) _synapse_gui_controller_update_handle_empty_g_object_notify, self, 0);
#line 542 "controller.vala"
	synapse_gui_controller_update_handle_empty (self);
#line 3122 "controller.c"
}

static void
synapse_gui_controller_update_handle_empty (SynapseGuiController* self)
{
	SynapseDataSink* _tmp0_;
	SynapseDataSink* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	SynapseGuiIView* _tmp6_;
#line 545 "controller.vala"
	g_return_if_fail (self != NULL);
#line 547 "controller.vala"
	_tmp0_ = synapse_gui_icontroller_get_data_sink ((SynapseGuiIController*) self);
#line 547 "controller.vala"
	_tmp1_ = _tmp0_;
#line 547 "controller.vala"
	_tmp2_ = synapse_data_sink_get_has_empty_handlers (_tmp1_);
#line 547 "controller.vala"
	_tmp3_ = _tmp2_;
#line 547 "controller.vala"
	self->priv->handle_empty = _tmp3_;
#line 548 "controller.vala"
	if (self->priv->handle_empty) {
#line 548 "controller.vala"
		_tmp4_ = _ ("...or press down key to browse recent activities");
#line 3151 "controller.c"
	} else {
#line 548 "controller.vala"
		_tmp4_ = "";
#line 3155 "controller.c"
	}
#line 548 "controller.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 548 "controller.vala"
	_g_free0 (synapse_gui_icontroller_DOWN_TO_SEE_RECENT);
#line 548 "controller.vala"
	synapse_gui_icontroller_DOWN_TO_SEE_RECENT = _tmp5_;
#line 549 "controller.vala"
	_tmp6_ = self->view;
#line 549 "controller.vala"
	if (_tmp6_ != NULL) {
#line 3167 "controller.c"
		SynapseGuiIView* _tmp7_;
		SynapseGuiModel* _tmp8_;
		SynapseGuiEntry** _tmp9_;
		gint _tmp9__length1;
		SynapseGuiEntry* _tmp10_;
#line 549 "controller.vala"
		_tmp7_ = self->view;
#line 549 "controller.vala"
		_tmp8_ = self->model;
#line 549 "controller.vala"
		_tmp9_ = _tmp8_->focus;
#line 549 "controller.vala"
		_tmp9__length1 = _tmp8_->focus_length1;
#line 549 "controller.vala"
		_tmp10_ = _tmp9_[SYNAPSE_GUI_SEARCHING_FOR_SOURCES];
#line 549 "controller.vala"
		synapse_gui_iview_update_focused_source (_tmp7_, _tmp10_);
#line 3185 "controller.c"
	}
#line 550 "controller.vala"
	g_signal_emit_by_name ((SynapseGuiIController*) self, "handle-recent-activities", self->priv->handle_empty);
#line 3189 "controller.c"
}

/**
     * This method can be called to reset the search.
     * @param notify if true, visual update matches and actions in the UI
     * @param reset_flags, if true, resets query flags to default (All)
     */
void
synapse_gui_controller_reset_search (SynapseGuiController* self,
                                     gboolean notify,
                                     gboolean reset_flags)
{
	SynapseGuiModel* _tmp6_;
	gboolean _tmp23_ = FALSE;
#line 558 "controller.vala"
	g_return_if_fail (self != NULL);
#line 3206 "controller.c"
	{
		gint i = 0;
#line 561 "controller.vala"
		i = 0;
#line 3211 "controller.c"
		{
			gboolean _tmp0_ = FALSE;
#line 561 "controller.vala"
			_tmp0_ = TRUE;
#line 561 "controller.vala"
			while (TRUE) {
#line 3218 "controller.c"
				GCancellable* _tmp2_;
				GCancellable* _tmp3_;
				guint _tmp4_;
#line 561 "controller.vala"
				if (!_tmp0_) {
#line 3224 "controller.c"
					gint _tmp1_;
#line 561 "controller.vala"
					_tmp1_ = i;
#line 561 "controller.vala"
					i = _tmp1_ + 1;
#line 3230 "controller.c"
				}
#line 561 "controller.vala"
				_tmp0_ = FALSE;
#line 561 "controller.vala"
				if (!(i < ((gint) SYNAPSE_GUI_SEARCHING_FOR_COUNT))) {
#line 561 "controller.vala"
					break;
#line 3238 "controller.c"
				}
#line 563 "controller.vala"
				_tmp2_ = self->priv->current_cancellable[i];
#line 563 "controller.vala"
				g_cancellable_cancel (_tmp2_);
#line 564 "controller.vala"
				_tmp3_ = g_cancellable_new ();
#line 564 "controller.vala"
				_g_object_unref0 (self->priv->current_cancellable[i]);
#line 564 "controller.vala"
				self->priv->current_cancellable[i] = _tmp3_;
#line 565 "controller.vala"
				_tmp4_ = self->priv->tid[i];
#line 565 "controller.vala"
				if (_tmp4_ != ((guint) 0)) {
#line 3254 "controller.c"
					guint _tmp5_;
#line 567 "controller.vala"
					_tmp5_ = self->priv->tid[i];
#line 567 "controller.vala"
					g_source_remove (_tmp5_);
#line 568 "controller.vala"
					self->priv->tid[i] = (guint) 0;
#line 3262 "controller.c"
				}
#line 570 "controller.vala"
				self->priv->partial_result_sent[i] = FALSE;
#line 571 "controller.vala"
				self->priv->searching[i] = FALSE;
#line 3268 "controller.c"
			}
		}
	}
#line 573 "controller.vala"
	self->priv->search_recent_activities = FALSE;
#line 574 "controller.vala"
	_tmp6_ = self->model;
#line 574 "controller.vala"
	synapse_gui_model_clear (_tmp6_, -1);
#line 575 "controller.vala"
	if (reset_flags) {
#line 3280 "controller.c"
		SynapseGuiModel* _tmp7_;
		SynapseGuiCategoryConfig* _tmp8_;
		SynapseGuiCategoryConfig* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		SynapseGuiCategoryConfig* _tmp12_;
		SynapseGuiCategoryConfig* _tmp13_;
		GeeList* _tmp14_;
		GeeList* _tmp15_;
		SynapseGuiModel* _tmp16_;
		gpointer _tmp17_;
		SynapseGuiCategoryConfigCategory* _tmp18_;
		SynapseQueryFlags _tmp19_;
		SynapseQueryFlags _tmp20_;
		SynapseGuiIView* _tmp21_;
		SynapseGuiIView* _tmp22_;
#line 577 "controller.vala"
		_tmp7_ = self->model;
#line 577 "controller.vala"
		_tmp8_ = synapse_gui_icontroller_get_category_config ((SynapseGuiIController*) self);
#line 577 "controller.vala"
		_tmp9_ = _tmp8_;
#line 577 "controller.vala"
		_tmp10_ = synapse_gui_category_config_get_default_category_index (_tmp9_);
#line 577 "controller.vala"
		_tmp11_ = _tmp10_;
#line 577 "controller.vala"
		_tmp7_->selected_category = _tmp11_;
#line 578 "controller.vala"
		_tmp12_ = synapse_gui_icontroller_get_category_config ((SynapseGuiIController*) self);
#line 578 "controller.vala"
		_tmp13_ = _tmp12_;
#line 578 "controller.vala"
		_tmp14_ = synapse_gui_category_config_get_categories (_tmp13_);
#line 578 "controller.vala"
		_tmp15_ = _tmp14_;
#line 578 "controller.vala"
		_tmp16_ = self->model;
#line 578 "controller.vala"
		_tmp17_ = gee_list_get (_tmp15_, _tmp16_->selected_category);
#line 578 "controller.vala"
		_tmp18_ = (SynapseGuiCategoryConfigCategory*) _tmp17_;
#line 578 "controller.vala"
		_tmp19_ = synapse_gui_category_config_category_get_flags (_tmp18_);
#line 578 "controller.vala"
		_tmp20_ = _tmp19_;
#line 578 "controller.vala"
		self->priv->qf = _tmp20_;
#line 578 "controller.vala"
		_g_object_unref0 (_tmp18_);
#line 579 "controller.vala"
		_tmp21_ = self->view;
#line 579 "controller.vala"
		if (_tmp21_ == NULL) {
#line 579 "controller.vala"
			return;
#line 3337 "controller.c"
		}
#line 580 "controller.vala"
		_tmp22_ = self->view;
#line 580 "controller.vala"
		synapse_gui_iview_update_selected_category (_tmp22_);
#line 3343 "controller.c"
	}
#line 582 "controller.vala"
	if (notify) {
#line 3347 "controller.c"
		SynapseGuiIView* _tmp24_;
#line 582 "controller.vala"
		_tmp24_ = self->view;
#line 582 "controller.vala"
		_tmp23_ = _tmp24_ != NULL;
#line 3353 "controller.c"
	} else {
#line 582 "controller.vala"
		_tmp23_ = FALSE;
#line 3357 "controller.c"
	}
#line 582 "controller.vala"
	if (_tmp23_) {
#line 3361 "controller.c"
		SynapseGuiIView* _tmp25_;
		SynapseGuiIView* _tmp26_;
		SynapseGuiIView* _tmp27_;
		SynapseGuiIView* _tmp28_;
		SynapseGuiIView* _tmp29_;
		SynapseGuiModel* _tmp30_;
		SynapseGuiEntry** _tmp31_;
		gint _tmp31__length1;
		SynapseGuiEntry* _tmp32_;
		SynapseGuiIView* _tmp33_;
		SynapseGuiModel* _tmp34_;
		SynapseGuiEntry** _tmp35_;
		gint _tmp35__length1;
		SynapseGuiEntry* _tmp36_;
		SynapseGuiIView* _tmp37_;
		SynapseGuiModel* _tmp38_;
		SynapseGuiEntry** _tmp39_;
		gint _tmp39__length1;
		SynapseGuiEntry* _tmp40_;
		SynapseGuiIView* _tmp41_;
#line 584 "controller.vala"
		_tmp25_ = self->view;
#line 584 "controller.vala"
		synapse_gui_iview_set_throbber_visible (_tmp25_, FALSE);
#line 585 "controller.vala"
		_tmp26_ = self->view;
#line 585 "controller.vala"
		synapse_gui_iview_update_sources (_tmp26_, NULL);
#line 586 "controller.vala"
		_tmp27_ = self->view;
#line 586 "controller.vala"
		synapse_gui_iview_update_actions (_tmp27_, NULL);
#line 587 "controller.vala"
		_tmp28_ = self->view;
#line 587 "controller.vala"
		synapse_gui_iview_update_targets (_tmp28_, NULL);
#line 588 "controller.vala"
		_tmp29_ = self->view;
#line 588 "controller.vala"
		_tmp30_ = self->model;
#line 588 "controller.vala"
		_tmp31_ = _tmp30_->focus;
#line 588 "controller.vala"
		_tmp31__length1 = _tmp30_->focus_length1;
#line 588 "controller.vala"
		_tmp32_ = _tmp31_[SYNAPSE_GUI_SEARCHING_FOR_SOURCES];
#line 588 "controller.vala"
		synapse_gui_iview_update_focused_source (_tmp29_, _tmp32_);
#line 589 "controller.vala"
		_tmp33_ = self->view;
#line 589 "controller.vala"
		_tmp34_ = self->model;
#line 589 "controller.vala"
		_tmp35_ = _tmp34_->focus;
#line 589 "controller.vala"
		_tmp35__length1 = _tmp34_->focus_length1;
#line 589 "controller.vala"
		_tmp36_ = _tmp35_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 589 "controller.vala"
		synapse_gui_iview_update_focused_action (_tmp33_, _tmp36_);
#line 590 "controller.vala"
		_tmp37_ = self->view;
#line 590 "controller.vala"
		_tmp38_ = self->model;
#line 590 "controller.vala"
		_tmp39_ = _tmp38_->focus;
#line 590 "controller.vala"
		_tmp39__length1 = _tmp38_->focus_length1;
#line 590 "controller.vala"
		_tmp40_ = _tmp39_[SYNAPSE_GUI_SEARCHING_FOR_TARGETS];
#line 590 "controller.vala"
		synapse_gui_iview_update_focused_target (_tmp37_, _tmp40_);
#line 591 "controller.vala"
		_tmp41_ = self->view;
#line 591 "controller.vala"
		synapse_gui_iview_update_searching_for (_tmp41_);
#line 3438 "controller.c"
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
#line 595 "controller.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 595 "controller.vala"
	return _data4_;
#line 3449 "controller.c"
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 595 "controller.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 3459 "controller.c"
		SynapseGuiController* self;
#line 595 "controller.vala"
		self = _data4_->self;
#line 595 "controller.vala"
		_g_object_unref0 (self);
#line 595 "controller.vala"
		g_slice_free (Block4Data, _data4_);
#line 3467 "controller.c"
	}
}

static gboolean
___lambda37_ (Block4Data* _data4_)
{
	SynapseGuiController* self;
	SynapseResultSet* _tmp0_;
	gboolean result;
#line 634 "controller.vala"
	self = _data4_->self;
#line 635 "controller.vala"
	self->priv->tid[_data4_->what] = (guint) 0;
#line 636 "controller.vala"
	_tmp0_ = self->priv->last_result_set;
#line 636 "controller.vala"
	synapse_gui_controller_send_partial_results (self, _data4_->what, _tmp0_);
#line 637 "controller.vala"
	result = FALSE;
#line 637 "controller.vala"
	return result;
#line 3489 "controller.c"
}

static gboolean
____lambda37__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda37_ (self);
#line 634 "controller.vala"
	return result;
#line 3499 "controller.c"
}

static void
__lambda38_ (Block4Data* _data4_,
             GObject* obj,
             GAsyncResult* res)
{
	SynapseGuiController* self;
	GError* _inner_error0_ = NULL;
#line 647 "controller.vala"
	self = _data4_->self;
#line 647 "controller.vala"
	g_return_if_fail (res != NULL);
#line 3513 "controller.c"
	{
		GeeList* rs = NULL;
		GeeList* _tmp0_;
#line 650 "controller.vala"
		_tmp0_ = synapse_search_provider_search_finish (G_TYPE_CHECK_INSTANCE_TYPE (obj, SYNAPSE_TYPE_SEARCH_PROVIDER) ? ((SynapseSearchProvider*) obj) : NULL, res, &_inner_error0_);
#line 650 "controller.vala"
		rs = _tmp0_;
#line 650 "controller.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3523 "controller.c"
			goto __catch0_g_error;
		}
#line 651 "controller.vala"
		synapse_gui_controller_search_ready (self, _data4_->what, rs);
#line 648 "controller.vala"
		_g_object_unref0 (rs);
#line 3530 "controller.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 648 "controller.vala"
		g_clear_error (&_inner_error0_);
#line 3537 "controller.c"
	}
	__finally0:
#line 648 "controller.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 648 "controller.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 648 "controller.vala"
		g_clear_error (&_inner_error0_);
#line 648 "controller.vala"
		return;
#line 3548 "controller.c"
	}
}

static void
___lambda38__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 643 "controller.vala"
	__lambda38_ (self, source_object, res);
#line 643 "controller.vala"
	block4_data_unref (self);
#line 3561 "controller.c"
}

static void
synapse_gui_controller_search_for_matches (SynapseGuiController* self,
                                           SynapseGuiSearchingFor what,
                                           gboolean search_with_empty,
                                           SynapseSearchProvider* search_provider)
{
	Block4Data* _data4_;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	SynapseResultSet* _tmp18_;
	guint _tmp19_;
	SynapseQueryFlags _tmp20_ = 0U;
	SynapseGuiModel* _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	SynapseResultSet* _tmp29_;
	GCancellable* _tmp30_;
#line 595 "controller.vala"
	g_return_if_fail (self != NULL);
#line 595 "controller.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 595 "controller.vala"
	_data4_->_ref_count_ = 1;
#line 595 "controller.vala"
	_data4_->self = g_object_ref (self);
#line 595 "controller.vala"
	_data4_->what = what;
#line 599 "controller.vala"
	_tmp0_ = self->priv->current_cancellable[_data4_->what];
#line 599 "controller.vala"
	g_cancellable_cancel (_tmp0_);
#line 600 "controller.vala"
	_tmp1_ = g_cancellable_new ();
#line 600 "controller.vala"
	_g_object_unref0 (self->priv->current_cancellable[_data4_->what]);
#line 600 "controller.vala"
	self->priv->current_cancellable[_data4_->what] = _tmp1_;
#line 602 "controller.vala"
	if (search_provider == NULL) {
#line 3606 "controller.c"
		SynapseDataSink* _tmp2_;
		SynapseDataSink* _tmp3_;
#line 602 "controller.vala"
		_tmp2_ = synapse_gui_icontroller_get_data_sink ((SynapseGuiIController*) self);
#line 602 "controller.vala"
		_tmp3_ = _tmp2_;
#line 602 "controller.vala"
		search_provider = (SynapseSearchProvider*) _tmp3_;
#line 3615 "controller.c"
	}
#line 604 "controller.vala"
	if (_data4_->what == SYNAPSE_GUI_SEARCHING_FOR_SOURCES) {
#line 3619 "controller.c"
		GCancellable* _tmp4_;
		GCancellable* _tmp5_;
		guint _tmp6_;
#line 607 "controller.vala"
		_tmp4_ = self->priv->current_cancellable[SYNAPSE_GUI_SEARCHING_FOR_TARGETS];
#line 607 "controller.vala"
		g_cancellable_cancel (_tmp4_);
#line 608 "controller.vala"
		_tmp5_ = g_cancellable_new ();
#line 608 "controller.vala"
		_g_object_unref0 (self->priv->current_cancellable[SYNAPSE_GUI_SEARCHING_FOR_TARGETS]);
#line 608 "controller.vala"
		self->priv->current_cancellable[SYNAPSE_GUI_SEARCHING_FOR_TARGETS] = _tmp5_;
#line 609 "controller.vala"
		self->priv->partial_result_sent[SYNAPSE_GUI_SEARCHING_FOR_TARGETS] = FALSE;
#line 610 "controller.vala"
		_tmp6_ = self->priv->tid[SYNAPSE_GUI_SEARCHING_FOR_TARGETS];
#line 610 "controller.vala"
		if (_tmp6_ != ((guint) 0)) {
#line 3639 "controller.c"
			guint _tmp7_;
#line 612 "controller.vala"
			_tmp7_ = self->priv->tid[SYNAPSE_GUI_SEARCHING_FOR_TARGETS];
#line 612 "controller.vala"
			g_source_remove (_tmp7_);
#line 613 "controller.vala"
			self->priv->tid[SYNAPSE_GUI_SEARCHING_FOR_TARGETS] = (guint) 0;
#line 3647 "controller.c"
		}
	} else {
		SynapseGuiModel* _tmp8_;
		SynapseGuiEntry** _tmp9_;
		gint _tmp9__length1;
		SynapseGuiEntry* _tmp10_;
		gconstpointer _tmp11_;
		gconstpointer _tmp12_;
#line 619 "controller.vala"
		_tmp8_ = self->model;
#line 619 "controller.vala"
		_tmp9_ = _tmp8_->focus;
#line 619 "controller.vala"
		_tmp9__length1 = _tmp8_->focus_length1;
#line 619 "controller.vala"
		_tmp10_ = _tmp9_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 619 "controller.vala"
		_tmp11_ = synapse_gui_entry_get_value (_tmp10_);
#line 619 "controller.vala"
		_tmp12_ = _tmp11_;
#line 619 "controller.vala"
		g_return_if_fail (((SynapseMatch*) _tmp12_) != NULL);
#line 3670 "controller.c"
	}
#line 623 "controller.vala"
	if (_data4_->what == SYNAPSE_GUI_SEARCHING_FOR_SOURCES) {
#line 623 "controller.vala"
		_tmp14_ = !search_with_empty;
#line 3676 "controller.c"
	} else {
#line 623 "controller.vala"
		_tmp14_ = FALSE;
#line 3680 "controller.c"
	}
#line 623 "controller.vala"
	if (_tmp14_) {
#line 3684 "controller.c"
		SynapseGuiModel* _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		const gchar* _tmp17_;
#line 623 "controller.vala"
		_tmp15_ = self->model;
#line 623 "controller.vala"
		_tmp16_ = _tmp15_->query;
#line 623 "controller.vala"
		_tmp16__length1 = _tmp15_->query_length1;
#line 623 "controller.vala"
		_tmp17_ = _tmp16_[_data4_->what];
#line 623 "controller.vala"
		_tmp13_ = g_strcmp0 (_tmp17_, "") == 0;
#line 3699 "controller.c"
	} else {
#line 623 "controller.vala"
		_tmp13_ = FALSE;
#line 3703 "controller.c"
	}
#line 623 "controller.vala"
	if (_tmp13_) {
#line 625 "controller.vala"
		synapse_gui_controller_reset_search (self, TRUE, FALSE);
#line 626 "controller.vala"
		block4_data_unref (_data4_);
#line 626 "controller.vala"
		_data4_ = NULL;
#line 626 "controller.vala"
		return;
#line 3715 "controller.c"
	}
#line 629 "controller.vala"
	self->priv->partial_result_sent[_data4_->what] = FALSE;
#line 631 "controller.vala"
	_tmp18_ = synapse_result_set_new ();
#line 631 "controller.vala"
	_g_object_unref0 (self->priv->last_result_set);
#line 631 "controller.vala"
	self->priv->last_result_set = _tmp18_;
#line 632 "controller.vala"
	_tmp19_ = self->priv->tid[_data4_->what];
#line 632 "controller.vala"
	if (_tmp19_ == ((guint) 0)) {
#line 634 "controller.vala"
		self->priv->tid[_data4_->what] = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) SYNAPSE_GUI_ICONTROLLER_PARTIAL_RESULT_TIMEOUT, ____lambda37__gsource_func, block4_data_ref (_data4_), block4_data_unref);
#line 3731 "controller.c"
	}
#line 641 "controller.vala"
	self->priv->searching[_data4_->what] = TRUE;
#line 644 "controller.vala"
	if (_data4_->what == SYNAPSE_GUI_SEARCHING_FOR_SOURCES) {
#line 644 "controller.vala"
		_tmp20_ = self->priv->qf;
#line 3739 "controller.c"
	} else {
		SynapseGuiModel* _tmp21_;
		SynapseGuiEntry** _tmp22_;
		gint _tmp22__length1;
		SynapseGuiEntry* _tmp23_;
		gconstpointer _tmp24_;
		gconstpointer _tmp25_;
#line 644 "controller.vala"
		_tmp21_ = self->model;
#line 644 "controller.vala"
		_tmp22_ = _tmp21_->focus;
#line 644 "controller.vala"
		_tmp22__length1 = _tmp21_->focus_length1;
#line 644 "controller.vala"
		_tmp23_ = _tmp22_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 644 "controller.vala"
		_tmp24_ = synapse_gui_entry_get_value (_tmp23_);
#line 644 "controller.vala"
		_tmp25_ = _tmp24_;
#line 644 "controller.vala"
		_tmp20_ = synapse_match_target_flags ((SynapseMatch*) _tmp25_);
#line 3761 "controller.c"
	}
#line 643 "controller.vala"
	_tmp26_ = self->model;
#line 643 "controller.vala"
	_tmp27_ = _tmp26_->query;
#line 643 "controller.vala"
	_tmp27__length1 = _tmp26_->query_length1;
#line 643 "controller.vala"
	_tmp28_ = _tmp27_[_data4_->what];
#line 643 "controller.vala"
	_tmp29_ = self->priv->last_result_set;
#line 643 "controller.vala"
	_tmp30_ = self->priv->current_cancellable[_data4_->what];
#line 643 "controller.vala"
	synapse_search_provider_search (search_provider, _tmp28_, _tmp20_, _tmp29_, _tmp30_, ___lambda38__gasync_ready_callback, block4_data_ref (_data4_));
#line 595 "controller.vala"
	block4_data_unref (_data4_);
#line 595 "controller.vala"
	_data4_ = NULL;
#line 3781 "controller.c"
}

static void
synapse_gui_controller_send_partial_results (SynapseGuiController* self,
                                             SynapseGuiSearchingFor what,
                                             SynapseResultSet* rs)
{
	SynapseGuiIView* _tmp0_;
	gboolean _tmp1_ = FALSE;
	SynapseGuiModel* _tmp2_;
	SynapseGuiEntry** _tmp3_;
	gint _tmp3__length1;
	SynapseGuiEntry* _tmp4_;
	gconstpointer _tmp5_;
	gconstpointer _tmp6_;
	SynapseGuiModel* _tmp39_;
	SynapseGuiEntry** _tmp40_;
	gint _tmp40__length1;
	SynapseGuiEntry* _tmp41_;
	SynapseGuiModel* _tmp42_;
	GeeList** _tmp43_;
	gint _tmp43__length1;
	GeeList* _tmp44_;
	SynapseGuiModel* _tmp45_;
	GeeList** _tmp46_;
	gint _tmp46__length1;
	GeeList* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
#line 659 "controller.vala"
	g_return_if_fail (self != NULL);
#line 659 "controller.vala"
	g_return_if_fail (rs != NULL);
#line 663 "controller.vala"
	_tmp0_ = self->view;
#line 663 "controller.vala"
	synapse_gui_iview_set_throbber_visible (_tmp0_, TRUE);
#line 664 "controller.vala"
	self->priv->partial_result_sent[what] = TRUE;
#line 668 "controller.vala"
	_tmp2_ = self->model;
#line 668 "controller.vala"
	_tmp3_ = _tmp2_->focus;
#line 668 "controller.vala"
	_tmp3__length1 = _tmp2_->focus_length1;
#line 668 "controller.vala"
	_tmp4_ = _tmp3_[what];
#line 668 "controller.vala"
	_tmp5_ = synapse_gui_entry_get_value (_tmp4_);
#line 668 "controller.vala"
	_tmp6_ = _tmp5_;
#line 668 "controller.vala"
	if (((SynapseMatch*) _tmp6_) != NULL) {
#line 3835 "controller.c"
		gint _tmp7_;
		gint _tmp8_;
#line 668 "controller.vala"
		_tmp7_ = synapse_result_set_get_size (rs);
#line 668 "controller.vala"
		_tmp8_ = _tmp7_;
#line 668 "controller.vala"
		_tmp1_ = _tmp8_ == 0;
#line 3844 "controller.c"
	} else {
#line 668 "controller.vala"
		_tmp1_ = FALSE;
#line 3848 "controller.c"
	}
#line 668 "controller.vala"
	if (_tmp1_) {
#line 3852 "controller.c"
		GeeList* matchers = NULL;
		SynapseGuiModel* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		GeeList* _tmp12_;
#line 670 "controller.vala"
		_tmp9_ = self->model;
#line 670 "controller.vala"
		_tmp10_ = _tmp9_->query;
#line 670 "controller.vala"
		_tmp10__length1 = _tmp9_->query_length1;
#line 670 "controller.vala"
		_tmp11_ = _tmp10_[what];
#line 670 "controller.vala"
		_tmp12_ = synapse_query_get_matchers_for_query (_tmp11_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 670 "controller.vala"
		matchers = _tmp12_;
#line 3871 "controller.c"
		{
			GeeList* _matcher_list = NULL;
			GeeList* _tmp13_;
			gint _matcher_size = 0;
			GeeList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _matcher_index = 0;
#line 672 "controller.vala"
			_tmp13_ = matchers;
#line 672 "controller.vala"
			_matcher_list = _tmp13_;
#line 672 "controller.vala"
			_tmp14_ = _matcher_list;
#line 672 "controller.vala"
			_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
#line 672 "controller.vala"
			_tmp16_ = _tmp15_;
#line 672 "controller.vala"
			_matcher_size = _tmp16_;
#line 672 "controller.vala"
			_matcher_index = -1;
#line 672 "controller.vala"
			while (TRUE) {
#line 3896 "controller.c"
				gint _tmp17_;
				gint _tmp18_;
				GeeMapEntry* matcher = NULL;
				GeeList* _tmp19_;
				gpointer _tmp20_;
				GeeMapEntry* _tmp21_;
				gconstpointer _tmp22_;
				gconstpointer _tmp23_;
				SynapseGuiModel* _tmp24_;
				SynapseGuiEntry** _tmp25_;
				gint _tmp25__length1;
				SynapseGuiEntry* _tmp26_;
				gconstpointer _tmp27_;
				gconstpointer _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
#line 672 "controller.vala"
				_matcher_index = _matcher_index + 1;
#line 672 "controller.vala"
				_tmp17_ = _matcher_index;
#line 672 "controller.vala"
				_tmp18_ = _matcher_size;
#line 672 "controller.vala"
				if (!(_tmp17_ < _tmp18_)) {
#line 672 "controller.vala"
					break;
#line 3923 "controller.c"
				}
#line 672 "controller.vala"
				_tmp19_ = _matcher_list;
#line 672 "controller.vala"
				_tmp20_ = gee_list_get (_tmp19_, _matcher_index);
#line 672 "controller.vala"
				matcher = (GeeMapEntry*) _tmp20_;
#line 674 "controller.vala"
				_tmp21_ = matcher;
#line 674 "controller.vala"
				_tmp22_ = gee_map_entry_get_key (_tmp21_);
#line 674 "controller.vala"
				_tmp23_ = _tmp22_;
#line 674 "controller.vala"
				_tmp24_ = self->model;
#line 674 "controller.vala"
				_tmp25_ = _tmp24_->focus;
#line 674 "controller.vala"
				_tmp25__length1 = _tmp24_->focus_length1;
#line 674 "controller.vala"
				_tmp26_ = _tmp25_[what];
#line 674 "controller.vala"
				_tmp27_ = synapse_gui_entry_get_value (_tmp26_);
#line 674 "controller.vala"
				_tmp28_ = _tmp27_;
#line 674 "controller.vala"
				_tmp29_ = synapse_match_get_title ((SynapseMatch*) _tmp28_);
#line 674 "controller.vala"
				_tmp30_ = _tmp29_;
#line 674 "controller.vala"
				if (g_regex_match ((GRegex*) _tmp23_, _tmp30_, 0, NULL)) {
#line 676 "controller.vala"
					if (what == SYNAPSE_GUI_SEARCHING_FOR_SOURCES) {
#line 3957 "controller.c"
						SynapseGuiIView* _tmp31_;
						SynapseGuiModel* _tmp32_;
						SynapseGuiEntry** _tmp33_;
						gint _tmp33__length1;
						SynapseGuiEntry* _tmp34_;
#line 677 "controller.vala"
						_tmp31_ = self->view;
#line 677 "controller.vala"
						_tmp32_ = self->model;
#line 677 "controller.vala"
						_tmp33_ = _tmp32_->focus;
#line 677 "controller.vala"
						_tmp33__length1 = _tmp32_->focus_length1;
#line 677 "controller.vala"
						_tmp34_ = _tmp33_[what];
#line 677 "controller.vala"
						synapse_gui_iview_update_focused_source (_tmp31_, _tmp34_);
#line 3975 "controller.c"
					} else {
						SynapseGuiIView* _tmp35_;
						SynapseGuiModel* _tmp36_;
						SynapseGuiEntry** _tmp37_;
						gint _tmp37__length1;
						SynapseGuiEntry* _tmp38_;
#line 679 "controller.vala"
						_tmp35_ = self->view;
#line 679 "controller.vala"
						_tmp36_ = self->model;
#line 679 "controller.vala"
						_tmp37_ = _tmp36_->focus;
#line 679 "controller.vala"
						_tmp37__length1 = _tmp36_->focus_length1;
#line 679 "controller.vala"
						_tmp38_ = _tmp37_[what];
#line 679 "controller.vala"
						synapse_gui_iview_update_focused_target (_tmp35_, _tmp38_);
#line 3994 "controller.c"
					}
#line 680 "controller.vala"
					_g_object_unref0 (matcher);
#line 680 "controller.vala"
					_g_object_unref0 (matchers);
#line 680 "controller.vala"
					return;
#line 4002 "controller.c"
				}
#line 672 "controller.vala"
				_g_object_unref0 (matcher);
#line 4006 "controller.c"
			}
		}
#line 668 "controller.vala"
		_g_object_unref0 (matchers);
#line 4011 "controller.c"
	}
#line 685 "controller.vala"
	_tmp39_ = self->model;
#line 685 "controller.vala"
	_tmp40_ = _tmp39_->focus;
#line 685 "controller.vala"
	_tmp40__length1 = _tmp39_->focus_length1;
#line 685 "controller.vala"
	_tmp41_ = _tmp40_[what];
#line 685 "controller.vala"
	synapse_gui_entry_set_key (_tmp41_, (gpointer) ((gintptr) 0));
#line 686 "controller.vala"
	_tmp42_ = self->model;
#line 686 "controller.vala"
	_tmp43_ = _tmp42_->results;
#line 686 "controller.vala"
	_tmp43__length1 = _tmp42_->results_length1;
#line 686 "controller.vala"
	_tmp44_ = synapse_result_set_get_sorted_list (rs);
#line 686 "controller.vala"
	_g_object_unref0 (_tmp43_[what]);
#line 686 "controller.vala"
	_tmp43_[what] = _tmp44_;
#line 687 "controller.vala"
	_tmp45_ = self->model;
#line 687 "controller.vala"
	_tmp46_ = _tmp45_->results;
#line 687 "controller.vala"
	_tmp46__length1 = _tmp45_->results_length1;
#line 687 "controller.vala"
	_tmp47_ = _tmp46_[what];
#line 687 "controller.vala"
	_tmp48_ = gee_collection_get_size ((GeeCollection*) _tmp47_);
#line 687 "controller.vala"
	_tmp49_ = _tmp48_;
#line 687 "controller.vala"
	if (_tmp49_ > 0) {
#line 4049 "controller.c"
		SynapseGuiModel* _tmp50_;
		SynapseGuiEntry** _tmp51_;
		gint _tmp51__length1;
		SynapseGuiEntry* _tmp52_;
		SynapseGuiModel* _tmp53_;
		GeeList** _tmp54_;
		gint _tmp54__length1;
		GeeList* _tmp55_;
		gpointer _tmp56_;
		SynapseMatch* _tmp57_;
#line 689 "controller.vala"
		_tmp50_ = self->model;
#line 689 "controller.vala"
		_tmp51_ = _tmp50_->focus;
#line 689 "controller.vala"
		_tmp51__length1 = _tmp50_->focus_length1;
#line 689 "controller.vala"
		_tmp52_ = _tmp51_[what];
#line 689 "controller.vala"
		_tmp53_ = self->model;
#line 689 "controller.vala"
		_tmp54_ = _tmp53_->results;
#line 689 "controller.vala"
		_tmp54__length1 = _tmp53_->results_length1;
#line 689 "controller.vala"
		_tmp55_ = _tmp54_[what];
#line 689 "controller.vala"
		_tmp56_ = gee_list_first (_tmp55_);
#line 689 "controller.vala"
		_tmp57_ = (SynapseMatch*) _tmp56_;
#line 689 "controller.vala"
		synapse_gui_entry_set_value (_tmp52_, _tmp57_);
#line 689 "controller.vala"
		_g_object_unref0 (_tmp57_);
#line 4084 "controller.c"
	} else {
		SynapseGuiModel* _tmp58_;
		SynapseGuiEntry** _tmp59_;
		gint _tmp59__length1;
		SynapseGuiEntry* _tmp60_;
#line 693 "controller.vala"
		_tmp58_ = self->model;
#line 693 "controller.vala"
		_tmp59_ = _tmp58_->focus;
#line 693 "controller.vala"
		_tmp59__length1 = _tmp58_->focus_length1;
#line 693 "controller.vala"
		_tmp60_ = _tmp59_[what];
#line 693 "controller.vala"
		synapse_gui_entry_set_value (_tmp60_, NULL);
#line 4100 "controller.c"
	}
#line 696 "controller.vala"
	if (what == SYNAPSE_GUI_SEARCHING_FOR_SOURCES) {
#line 4104 "controller.c"
		SynapseGuiModel* _tmp61_;
		SynapseGuiIView* _tmp62_;
		SynapseGuiModel* _tmp63_;
		GeeList** _tmp64_;
		gint _tmp64__length1;
		GeeList* _tmp65_;
		SynapseGuiIView* _tmp66_;
		SynapseGuiModel* _tmp67_;
		SynapseGuiEntry** _tmp68_;
		gint _tmp68__length1;
		SynapseGuiEntry* _tmp69_;
#line 699 "controller.vala"
		_tmp61_ = self->model;
#line 699 "controller.vala"
		synapse_gui_model_clear_searching_for (_tmp61_, SYNAPSE_GUI_SEARCHING_FOR_ACTIONS, TRUE);
#line 700 "controller.vala"
		synapse_gui_controller_search_for_actions (self);
#line 702 "controller.vala"
		_tmp62_ = self->view;
#line 702 "controller.vala"
		_tmp63_ = self->model;
#line 702 "controller.vala"
		_tmp64_ = _tmp63_->results;
#line 702 "controller.vala"
		_tmp64__length1 = _tmp63_->results_length1;
#line 702 "controller.vala"
		_tmp65_ = _tmp64_[what];
#line 702 "controller.vala"
		synapse_gui_iview_update_sources (_tmp62_, _tmp65_);
#line 703 "controller.vala"
		_tmp66_ = self->view;
#line 703 "controller.vala"
		_tmp67_ = self->model;
#line 703 "controller.vala"
		_tmp68_ = _tmp67_->focus;
#line 703 "controller.vala"
		_tmp68__length1 = _tmp67_->focus_length1;
#line 703 "controller.vala"
		_tmp69_ = _tmp68_[what];
#line 703 "controller.vala"
		synapse_gui_iview_update_focused_source (_tmp66_, _tmp69_);
#line 4146 "controller.c"
	} else {
		SynapseGuiIView* _tmp70_;
		SynapseGuiModel* _tmp71_;
		GeeList** _tmp72_;
		gint _tmp72__length1;
		GeeList* _tmp73_;
		SynapseGuiIView* _tmp74_;
		SynapseGuiModel* _tmp75_;
		SynapseGuiEntry** _tmp76_;
		gint _tmp76__length1;
		SynapseGuiEntry* _tmp77_;
#line 707 "controller.vala"
		_tmp70_ = self->view;
#line 707 "controller.vala"
		_tmp71_ = self->model;
#line 707 "controller.vala"
		_tmp72_ = _tmp71_->results;
#line 707 "controller.vala"
		_tmp72__length1 = _tmp71_->results_length1;
#line 707 "controller.vala"
		_tmp73_ = _tmp72_[what];
#line 707 "controller.vala"
		synapse_gui_iview_update_targets (_tmp70_, _tmp73_);
#line 708 "controller.vala"
		_tmp74_ = self->view;
#line 708 "controller.vala"
		_tmp75_ = self->model;
#line 708 "controller.vala"
		_tmp76_ = _tmp75_->focus;
#line 708 "controller.vala"
		_tmp76__length1 = _tmp75_->focus_length1;
#line 708 "controller.vala"
		_tmp77_ = _tmp76_[what];
#line 708 "controller.vala"
		synapse_gui_iview_update_focused_target (_tmp74_, _tmp77_);
#line 4182 "controller.c"
	}
}

static void
synapse_gui_controller_search_ready (SynapseGuiController* self,
                                     SynapseGuiSearchingFor what,
                                     GeeList* res)
{
	gboolean _tmp0_;
	SynapseGuiModel* _tmp7_;
	GeeList** _tmp8_;
	gint _tmp8__length1;
	GeeList* _tmp9_;
	guint _tmp10_;
	gboolean _tmp12_ = FALSE;
	guint _tmp13_;
	SynapseGuiModel* _tmp16_;
	GeeList** _tmp17_;
	gint _tmp17__length1;
	GeeList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
#line 712 "controller.vala"
	g_return_if_fail (self != NULL);
#line 712 "controller.vala"
	g_return_if_fail (res != NULL);
#line 715 "controller.vala"
	_tmp0_ = self->priv->partial_result_sent[what];
#line 715 "controller.vala"
	if (!_tmp0_) {
#line 4213 "controller.c"
		SynapseGuiModel* _tmp1_;
		SynapseGuiEntry** _tmp2_;
		gint _tmp2__length1;
		SynapseGuiEntry* _tmp3_;
		SynapseGuiModel* _tmp4_;
		SynapseGuiEntry** _tmp5_;
		gint _tmp5__length1;
		SynapseGuiEntry* _tmp6_;
#line 718 "controller.vala"
		_tmp1_ = self->model;
#line 718 "controller.vala"
		_tmp2_ = _tmp1_->focus;
#line 718 "controller.vala"
		_tmp2__length1 = _tmp1_->focus_length1;
#line 718 "controller.vala"
		_tmp3_ = _tmp2_[what];
#line 718 "controller.vala"
		synapse_gui_entry_set_value (_tmp3_, NULL);
#line 719 "controller.vala"
		_tmp4_ = self->model;
#line 719 "controller.vala"
		_tmp5_ = _tmp4_->focus;
#line 719 "controller.vala"
		_tmp5__length1 = _tmp4_->focus_length1;
#line 719 "controller.vala"
		_tmp6_ = _tmp5_[what];
#line 719 "controller.vala"
		synapse_gui_entry_set_key (_tmp6_, (gpointer) ((gintptr) 0));
#line 4242 "controller.c"
	}
#line 721 "controller.vala"
	_tmp7_ = self->model;
#line 721 "controller.vala"
	_tmp8_ = _tmp7_->results;
#line 721 "controller.vala"
	_tmp8__length1 = _tmp7_->results_length1;
#line 721 "controller.vala"
	_tmp9_ = _g_object_ref0 (res);
#line 721 "controller.vala"
	_g_object_unref0 (_tmp8_[what]);
#line 721 "controller.vala"
	_tmp8_[what] = _tmp9_;
#line 724 "controller.vala"
	_tmp10_ = self->priv->tid[what];
#line 724 "controller.vala"
	if (_tmp10_ != ((guint) 0)) {
#line 4260 "controller.c"
		guint _tmp11_;
#line 726 "controller.vala"
		_tmp11_ = self->priv->tid[what];
#line 726 "controller.vala"
		g_source_remove (_tmp11_);
#line 727 "controller.vala"
		self->priv->tid[what] = (guint) 0;
#line 4268 "controller.c"
	}
#line 730 "controller.vala"
	self->priv->searching[what] = FALSE;
#line 732 "controller.vala"
	_tmp13_ = self->priv->tid[SYNAPSE_GUI_SEARCHING_FOR_SOURCES];
#line 732 "controller.vala"
	if (_tmp13_ == ((guint) 0)) {
#line 4276 "controller.c"
		guint _tmp14_;
#line 732 "controller.vala"
		_tmp14_ = self->priv->tid[SYNAPSE_GUI_SEARCHING_FOR_TARGETS];
#line 732 "controller.vala"
		_tmp12_ = _tmp14_ == ((guint) 0);
#line 4282 "controller.c"
	} else {
#line 732 "controller.vala"
		_tmp12_ = FALSE;
#line 4286 "controller.c"
	}
#line 732 "controller.vala"
	if (_tmp12_) {
#line 4290 "controller.c"
		SynapseGuiIView* _tmp15_;
#line 734 "controller.vala"
		_tmp15_ = self->view;
#line 734 "controller.vala"
		synapse_gui_iview_set_throbber_visible (_tmp15_, FALSE);
#line 4296 "controller.c"
	}
#line 737 "controller.vala"
	_tmp16_ = self->model;
#line 737 "controller.vala"
	_tmp17_ = _tmp16_->results;
#line 737 "controller.vala"
	_tmp17__length1 = _tmp16_->results_length1;
#line 737 "controller.vala"
	_tmp18_ = _tmp17_[what];
#line 737 "controller.vala"
	_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
#line 737 "controller.vala"
	_tmp20_ = _tmp19_;
#line 737 "controller.vala"
	if (_tmp20_ > 0) {
#line 4312 "controller.c"
		SynapseGuiModel* _tmp21_;
		SynapseGuiEntry** _tmp22_;
		gint _tmp22__length1;
		SynapseGuiEntry* _tmp23_;
		gconstpointer _tmp24_;
		gconstpointer _tmp25_;
#line 739 "controller.vala"
		_tmp21_ = self->model;
#line 739 "controller.vala"
		_tmp22_ = _tmp21_->focus;
#line 739 "controller.vala"
		_tmp22__length1 = _tmp21_->focus_length1;
#line 739 "controller.vala"
		_tmp23_ = _tmp22_[what];
#line 739 "controller.vala"
		_tmp24_ = synapse_gui_entry_get_value (_tmp23_);
#line 739 "controller.vala"
		_tmp25_ = _tmp24_;
#line 739 "controller.vala"
		if (((SynapseMatch*) _tmp25_) != NULL) {
#line 4333 "controller.c"
			gint i = 0;
			SynapseGuiModel* _tmp26_;
			GeeList** _tmp27_;
			gint _tmp27__length1;
			GeeList* _tmp28_;
			SynapseGuiModel* _tmp29_;
			SynapseGuiEntry** _tmp30_;
			gint _tmp30__length1;
			SynapseGuiEntry* _tmp31_;
			gconstpointer _tmp32_;
			gconstpointer _tmp33_;
#line 743 "controller.vala"
			_tmp26_ = self->model;
#line 743 "controller.vala"
			_tmp27_ = _tmp26_->results;
#line 743 "controller.vala"
			_tmp27__length1 = _tmp26_->results_length1;
#line 743 "controller.vala"
			_tmp28_ = _tmp27_[what];
#line 743 "controller.vala"
			_tmp29_ = self->model;
#line 743 "controller.vala"
			_tmp30_ = _tmp29_->focus;
#line 743 "controller.vala"
			_tmp30__length1 = _tmp29_->focus_length1;
#line 743 "controller.vala"
			_tmp31_ = _tmp30_[what];
#line 743 "controller.vala"
			_tmp32_ = synapse_gui_entry_get_value (_tmp31_);
#line 743 "controller.vala"
			_tmp33_ = _tmp32_;
#line 743 "controller.vala"
			i = gee_list_index_of (_tmp28_, (SynapseMatch*) _tmp33_);
#line 744 "controller.vala"
			if (i >= 0) {
#line 4369 "controller.c"
				SynapseGuiModel* _tmp34_;
				SynapseGuiEntry** _tmp35_;
				gint _tmp35__length1;
				SynapseGuiEntry* _tmp36_;
#line 746 "controller.vala"
				_tmp34_ = self->model;
#line 746 "controller.vala"
				_tmp35_ = _tmp34_->focus;
#line 746 "controller.vala"
				_tmp35__length1 = _tmp34_->focus_length1;
#line 746 "controller.vala"
				_tmp36_ = _tmp35_[what];
#line 746 "controller.vala"
				synapse_gui_entry_set_key (_tmp36_, (gpointer) ((gintptr) i));
#line 4384 "controller.c"
			} else {
				SynapseGuiModel* _tmp37_;
				SynapseGuiEntry** _tmp38_;
				gint _tmp38__length1;
				SynapseGuiEntry* _tmp39_;
				SynapseGuiModel* _tmp40_;
				SynapseGuiEntry** _tmp41_;
				gint _tmp41__length1;
				SynapseGuiEntry* _tmp42_;
				SynapseGuiModel* _tmp43_;
				GeeList** _tmp44_;
				gint _tmp44__length1;
				GeeList* _tmp45_;
				gpointer _tmp46_;
				SynapseMatch* _tmp47_;
#line 751 "controller.vala"
				_tmp37_ = self->model;
#line 751 "controller.vala"
				_tmp38_ = _tmp37_->focus;
#line 751 "controller.vala"
				_tmp38__length1 = _tmp37_->focus_length1;
#line 751 "controller.vala"
				_tmp39_ = _tmp38_[what];
#line 751 "controller.vala"
				synapse_gui_entry_set_key (_tmp39_, (gpointer) ((gintptr) 0));
#line 752 "controller.vala"
				_tmp40_ = self->model;
#line 752 "controller.vala"
				_tmp41_ = _tmp40_->focus;
#line 752 "controller.vala"
				_tmp41__length1 = _tmp40_->focus_length1;
#line 752 "controller.vala"
				_tmp42_ = _tmp41_[what];
#line 752 "controller.vala"
				_tmp43_ = self->model;
#line 752 "controller.vala"
				_tmp44_ = _tmp43_->results;
#line 752 "controller.vala"
				_tmp44__length1 = _tmp43_->results_length1;
#line 752 "controller.vala"
				_tmp45_ = _tmp44_[what];
#line 752 "controller.vala"
				_tmp46_ = gee_list_first (_tmp45_);
#line 752 "controller.vala"
				_tmp47_ = (SynapseMatch*) _tmp46_;
#line 752 "controller.vala"
				synapse_gui_entry_set_value (_tmp42_, _tmp47_);
#line 752 "controller.vala"
				_g_object_unref0 (_tmp47_);
#line 4434 "controller.c"
			}
		} else {
			SynapseGuiModel* _tmp48_;
			SynapseGuiEntry** _tmp49_;
			gint _tmp49__length1;
			SynapseGuiEntry* _tmp50_;
			SynapseGuiModel* _tmp51_;
			GeeList** _tmp52_;
			gint _tmp52__length1;
			GeeList* _tmp53_;
			SynapseGuiModel* _tmp54_;
			SynapseGuiEntry** _tmp55_;
			gint _tmp55__length1;
			SynapseGuiEntry* _tmp56_;
			gconstpointer _tmp57_;
			gconstpointer _tmp58_;
			gpointer _tmp59_;
			SynapseMatch* _tmp60_;
#line 757 "controller.vala"
			_tmp48_ = self->model;
#line 757 "controller.vala"
			_tmp49_ = _tmp48_->focus;
#line 757 "controller.vala"
			_tmp49__length1 = _tmp48_->focus_length1;
#line 757 "controller.vala"
			_tmp50_ = _tmp49_[what];
#line 757 "controller.vala"
			_tmp51_ = self->model;
#line 757 "controller.vala"
			_tmp52_ = _tmp51_->results;
#line 757 "controller.vala"
			_tmp52__length1 = _tmp51_->results_length1;
#line 757 "controller.vala"
			_tmp53_ = _tmp52_[what];
#line 757 "controller.vala"
			_tmp54_ = self->model;
#line 757 "controller.vala"
			_tmp55_ = _tmp54_->focus;
#line 757 "controller.vala"
			_tmp55__length1 = _tmp54_->focus_length1;
#line 757 "controller.vala"
			_tmp56_ = _tmp55_[what];
#line 757 "controller.vala"
			_tmp57_ = synapse_gui_entry_get_key (_tmp56_);
#line 757 "controller.vala"
			_tmp58_ = _tmp57_;
#line 757 "controller.vala"
			_tmp59_ = gee_list_get (_tmp53_, (gint) ((gintptr) _tmp58_));
#line 757 "controller.vala"
			_tmp60_ = (SynapseMatch*) _tmp59_;
#line 757 "controller.vala"
			synapse_gui_entry_set_value (_tmp50_, _tmp60_);
#line 757 "controller.vala"
			_g_object_unref0 (_tmp60_);
#line 4489 "controller.c"
		}
	} else {
		SynapseGuiModel* _tmp61_;
		SynapseGuiEntry** _tmp62_;
		gint _tmp62__length1;
		SynapseGuiEntry* _tmp63_;
		SynapseGuiModel* _tmp64_;
		SynapseGuiEntry** _tmp65_;
		gint _tmp65__length1;
		SynapseGuiEntry* _tmp66_;
		SynapseGuiModel* _tmp67_;
		GeeList** _tmp68_;
		gint _tmp68__length1;
#line 762 "controller.vala"
		_tmp61_ = self->model;
#line 762 "controller.vala"
		_tmp62_ = _tmp61_->focus;
#line 762 "controller.vala"
		_tmp62__length1 = _tmp61_->focus_length1;
#line 762 "controller.vala"
		_tmp63_ = _tmp62_[what];
#line 762 "controller.vala"
		synapse_gui_entry_set_value (_tmp63_, NULL);
#line 763 "controller.vala"
		_tmp64_ = self->model;
#line 763 "controller.vala"
		_tmp65_ = _tmp64_->focus;
#line 763 "controller.vala"
		_tmp65__length1 = _tmp64_->focus_length1;
#line 763 "controller.vala"
		_tmp66_ = _tmp65_[what];
#line 763 "controller.vala"
		synapse_gui_entry_set_key (_tmp66_, (gpointer) ((gintptr) 0));
#line 764 "controller.vala"
		_tmp67_ = self->model;
#line 764 "controller.vala"
		_tmp68_ = _tmp67_->results;
#line 764 "controller.vala"
		_tmp68__length1 = _tmp67_->results_length1;
#line 764 "controller.vala"
		_g_object_unref0 (_tmp68_[what]);
#line 764 "controller.vala"
		_tmp68_[what] = NULL;
#line 4533 "controller.c"
	}
#line 767 "controller.vala"
	if (what == SYNAPSE_GUI_SEARCHING_FOR_SOURCES) {
#line 4537 "controller.c"
		SynapseGuiModel* _tmp69_;
		SynapseGuiIView* _tmp70_;
		SynapseGuiModel* _tmp71_;
		GeeList** _tmp72_;
		gint _tmp72__length1;
		GeeList* _tmp73_;
		SynapseGuiIView* _tmp74_;
		SynapseGuiModel* _tmp75_;
		SynapseGuiEntry** _tmp76_;
		gint _tmp76__length1;
		SynapseGuiEntry* _tmp77_;
#line 770 "controller.vala"
		_tmp69_ = self->model;
#line 770 "controller.vala"
		synapse_gui_model_clear_searching_for (_tmp69_, SYNAPSE_GUI_SEARCHING_FOR_ACTIONS, TRUE);
#line 771 "controller.vala"
		synapse_gui_controller_search_for_actions (self);
#line 773 "controller.vala"
		_tmp70_ = self->view;
#line 773 "controller.vala"
		_tmp71_ = self->model;
#line 773 "controller.vala"
		_tmp72_ = _tmp71_->results;
#line 773 "controller.vala"
		_tmp72__length1 = _tmp71_->results_length1;
#line 773 "controller.vala"
		_tmp73_ = _tmp72_[what];
#line 773 "controller.vala"
		synapse_gui_iview_update_sources (_tmp70_, _tmp73_);
#line 774 "controller.vala"
		_tmp74_ = self->view;
#line 774 "controller.vala"
		_tmp75_ = self->model;
#line 774 "controller.vala"
		_tmp76_ = _tmp75_->focus;
#line 774 "controller.vala"
		_tmp76__length1 = _tmp75_->focus_length1;
#line 774 "controller.vala"
		_tmp77_ = _tmp76_[what];
#line 774 "controller.vala"
		synapse_gui_iview_update_focused_source (_tmp74_, _tmp77_);
#line 4579 "controller.c"
	} else {
		SynapseGuiIView* _tmp78_;
		SynapseGuiModel* _tmp79_;
		GeeList** _tmp80_;
		gint _tmp80__length1;
		GeeList* _tmp81_;
		SynapseGuiIView* _tmp82_;
		SynapseGuiModel* _tmp83_;
		SynapseGuiEntry** _tmp84_;
		gint _tmp84__length1;
		SynapseGuiEntry* _tmp85_;
#line 778 "controller.vala"
		_tmp78_ = self->view;
#line 778 "controller.vala"
		_tmp79_ = self->model;
#line 778 "controller.vala"
		_tmp80_ = _tmp79_->results;
#line 778 "controller.vala"
		_tmp80__length1 = _tmp79_->results_length1;
#line 778 "controller.vala"
		_tmp81_ = _tmp80_[what];
#line 778 "controller.vala"
		synapse_gui_iview_update_targets (_tmp78_, _tmp81_);
#line 779 "controller.vala"
		_tmp82_ = self->view;
#line 779 "controller.vala"
		_tmp83_ = self->model;
#line 779 "controller.vala"
		_tmp84_ = _tmp83_->focus;
#line 779 "controller.vala"
		_tmp84__length1 = _tmp83_->focus_length1;
#line 779 "controller.vala"
		_tmp85_ = _tmp84_[what];
#line 779 "controller.vala"
		synapse_gui_iview_update_focused_target (_tmp82_, _tmp85_);
#line 4615 "controller.c"
	}
}

static void
synapse_gui_controller_search_for_actions (SynapseGuiController* self)
{
	SynapseGuiModel* _tmp0_;
	GeeList** _tmp1_;
	gint _tmp1__length1;
	GeeList* _tmp2_;
	SynapseGuiModel* _tmp12_;
	SynapseGuiEntry** _tmp13_;
	gint _tmp13__length1;
	SynapseGuiEntry* _tmp14_;
	gconstpointer _tmp15_;
	gconstpointer _tmp16_;
	SynapseGuiModel* _tmp26_;
	GeeList** _tmp27_;
	gint _tmp27__length1;
	SynapseDataSink* _tmp28_;
	SynapseDataSink* _tmp29_;
	SynapseGuiModel* _tmp30_;
	SynapseGuiEntry** _tmp31_;
	gint _tmp31__length1;
	SynapseGuiEntry* _tmp32_;
	gconstpointer _tmp33_;
	gconstpointer _tmp34_;
	SynapseGuiModel* _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	const gchar* _tmp37_;
	GeeList* _tmp38_;
	SynapseGuiModel* _tmp39_;
	GeeList** _tmp40_;
	gint _tmp40__length1;
	GeeList* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	SynapseGuiModel* _tmp55_;
	SynapseGuiEntry** _tmp56_;
	gint _tmp56__length1;
	SynapseGuiEntry* _tmp57_;
	SynapseGuiIView* _tmp58_;
	SynapseGuiModel* _tmp59_;
	GeeList** _tmp60_;
	gint _tmp60__length1;
	GeeList* _tmp61_;
	SynapseGuiIView* _tmp62_;
	SynapseGuiModel* _tmp63_;
	SynapseGuiEntry** _tmp64_;
	gint _tmp64__length1;
	SynapseGuiEntry* _tmp65_;
#line 783 "controller.vala"
	g_return_if_fail (self != NULL);
#line 787 "controller.vala"
	_tmp0_ = self->model;
#line 787 "controller.vala"
	_tmp1_ = _tmp0_->results;
#line 787 "controller.vala"
	_tmp1__length1 = _tmp0_->results_length1;
#line 787 "controller.vala"
	_tmp2_ = _tmp1_[SYNAPSE_GUI_SEARCHING_FOR_TARGETS];
#line 787 "controller.vala"
	if (_tmp2_ != NULL) {
#line 4680 "controller.c"
		SynapseGuiModel* _tmp3_;
		SynapseGuiIView* _tmp4_;
		SynapseGuiModel* _tmp5_;
		GeeList** _tmp6_;
		gint _tmp6__length1;
		GeeList* _tmp7_;
		SynapseGuiIView* _tmp8_;
		SynapseGuiModel* _tmp9_;
		SynapseGuiEntry** _tmp10_;
		gint _tmp10__length1;
		SynapseGuiEntry* _tmp11_;
#line 789 "controller.vala"
		_tmp3_ = self->model;
#line 789 "controller.vala"
		synapse_gui_model_clear_searching_for (_tmp3_, SYNAPSE_GUI_SEARCHING_FOR_TARGETS, TRUE);
#line 790 "controller.vala"
		_tmp4_ = self->view;
#line 790 "controller.vala"
		_tmp5_ = self->model;
#line 790 "controller.vala"
		_tmp6_ = _tmp5_->results;
#line 790 "controller.vala"
		_tmp6__length1 = _tmp5_->results_length1;
#line 790 "controller.vala"
		_tmp7_ = _tmp6_[SYNAPSE_GUI_SEARCHING_FOR_TARGETS];
#line 790 "controller.vala"
		synapse_gui_iview_update_targets (_tmp4_, _tmp7_);
#line 791 "controller.vala"
		_tmp8_ = self->view;
#line 791 "controller.vala"
		_tmp9_ = self->model;
#line 791 "controller.vala"
		_tmp10_ = _tmp9_->focus;
#line 791 "controller.vala"
		_tmp10__length1 = _tmp9_->focus_length1;
#line 791 "controller.vala"
		_tmp11_ = _tmp10_[SYNAPSE_GUI_SEARCHING_FOR_TARGETS];
#line 791 "controller.vala"
		synapse_gui_iview_update_focused_target (_tmp8_, _tmp11_);
#line 4720 "controller.c"
	}
#line 795 "controller.vala"
	_tmp12_ = self->model;
#line 795 "controller.vala"
	_tmp13_ = _tmp12_->focus;
#line 795 "controller.vala"
	_tmp13__length1 = _tmp12_->focus_length1;
#line 795 "controller.vala"
	_tmp14_ = _tmp13_[SYNAPSE_GUI_SEARCHING_FOR_SOURCES];
#line 795 "controller.vala"
	_tmp15_ = synapse_gui_entry_get_value (_tmp14_);
#line 795 "controller.vala"
	_tmp16_ = _tmp15_;
#line 795 "controller.vala"
	if (((SynapseMatch*) _tmp16_) == NULL) {
#line 4736 "controller.c"
		SynapseGuiModel* _tmp17_;
		SynapseGuiIView* _tmp18_;
		SynapseGuiModel* _tmp19_;
		GeeList** _tmp20_;
		gint _tmp20__length1;
		GeeList* _tmp21_;
		SynapseGuiIView* _tmp22_;
		SynapseGuiModel* _tmp23_;
		SynapseGuiEntry** _tmp24_;
		gint _tmp24__length1;
		SynapseGuiEntry* _tmp25_;
#line 797 "controller.vala"
		_tmp17_ = self->model;
#line 797 "controller.vala"
		synapse_gui_model_clear_searching_for (_tmp17_, SYNAPSE_GUI_SEARCHING_FOR_ACTIONS, TRUE);
#line 798 "controller.vala"
		_tmp18_ = self->view;
#line 798 "controller.vala"
		_tmp19_ = self->model;
#line 798 "controller.vala"
		_tmp20_ = _tmp19_->results;
#line 798 "controller.vala"
		_tmp20__length1 = _tmp19_->results_length1;
#line 798 "controller.vala"
		_tmp21_ = _tmp20_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 798 "controller.vala"
		synapse_gui_iview_update_actions (_tmp18_, _tmp21_);
#line 799 "controller.vala"
		_tmp22_ = self->view;
#line 799 "controller.vala"
		_tmp23_ = self->model;
#line 799 "controller.vala"
		_tmp24_ = _tmp23_->focus;
#line 799 "controller.vala"
		_tmp24__length1 = _tmp23_->focus_length1;
#line 799 "controller.vala"
		_tmp25_ = _tmp24_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 799 "controller.vala"
		synapse_gui_iview_update_focused_action (_tmp22_, _tmp25_);
#line 800 "controller.vala"
		return;
#line 4778 "controller.c"
	}
#line 803 "controller.vala"
	_tmp26_ = self->model;
#line 803 "controller.vala"
	_tmp27_ = _tmp26_->results;
#line 803 "controller.vala"
	_tmp27__length1 = _tmp26_->results_length1;
#line 803 "controller.vala"
	_tmp28_ = synapse_gui_icontroller_get_data_sink ((SynapseGuiIController*) self);
#line 803 "controller.vala"
	_tmp29_ = _tmp28_;
#line 803 "controller.vala"
	_tmp30_ = self->model;
#line 803 "controller.vala"
	_tmp31_ = _tmp30_->focus;
#line 803 "controller.vala"
	_tmp31__length1 = _tmp30_->focus_length1;
#line 803 "controller.vala"
	_tmp32_ = _tmp31_[SYNAPSE_GUI_SEARCHING_FOR_SOURCES];
#line 803 "controller.vala"
	_tmp33_ = synapse_gui_entry_get_value (_tmp32_);
#line 803 "controller.vala"
	_tmp34_ = _tmp33_;
#line 803 "controller.vala"
	_tmp35_ = self->model;
#line 803 "controller.vala"
	_tmp36_ = _tmp35_->query;
#line 803 "controller.vala"
	_tmp36__length1 = _tmp35_->query_length1;
#line 803 "controller.vala"
	_tmp37_ = _tmp36_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 803 "controller.vala"
	_tmp38_ = synapse_data_sink_find_actions_for_match (_tmp29_, (SynapseMatch*) _tmp34_, _tmp37_, self->priv->qf);
#line 803 "controller.vala"
	_g_object_unref0 (_tmp27_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS]);
#line 803 "controller.vala"
	_tmp27_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS] = _tmp38_;
#line 805 "controller.vala"
	_tmp39_ = self->model;
#line 805 "controller.vala"
	_tmp40_ = _tmp39_->results;
#line 805 "controller.vala"
	_tmp40__length1 = _tmp39_->results_length1;
#line 805 "controller.vala"
	_tmp41_ = _tmp40_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 805 "controller.vala"
	_tmp42_ = gee_collection_get_size ((GeeCollection*) _tmp41_);
#line 805 "controller.vala"
	_tmp43_ = _tmp42_;
#line 805 "controller.vala"
	if (_tmp43_ > 0) {
#line 4830 "controller.c"
		SynapseGuiModel* _tmp44_;
		SynapseGuiEntry** _tmp45_;
		gint _tmp45__length1;
		SynapseGuiEntry* _tmp46_;
		SynapseGuiModel* _tmp47_;
		GeeList** _tmp48_;
		gint _tmp48__length1;
		GeeList* _tmp49_;
		gpointer _tmp50_;
		SynapseMatch* _tmp51_;
#line 807 "controller.vala"
		_tmp44_ = self->model;
#line 807 "controller.vala"
		_tmp45_ = _tmp44_->focus;
#line 807 "controller.vala"
		_tmp45__length1 = _tmp44_->focus_length1;
#line 807 "controller.vala"
		_tmp46_ = _tmp45_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 807 "controller.vala"
		_tmp47_ = self->model;
#line 807 "controller.vala"
		_tmp48_ = _tmp47_->results;
#line 807 "controller.vala"
		_tmp48__length1 = _tmp47_->results_length1;
#line 807 "controller.vala"
		_tmp49_ = _tmp48_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 807 "controller.vala"
		_tmp50_ = gee_list_first (_tmp49_);
#line 807 "controller.vala"
		_tmp51_ = (SynapseMatch*) _tmp50_;
#line 807 "controller.vala"
		synapse_gui_entry_set_value (_tmp46_, _tmp51_);
#line 807 "controller.vala"
		_g_object_unref0 (_tmp51_);
#line 4865 "controller.c"
	} else {
		SynapseGuiModel* _tmp52_;
		SynapseGuiEntry** _tmp53_;
		gint _tmp53__length1;
		SynapseGuiEntry* _tmp54_;
#line 812 "controller.vala"
		_tmp52_ = self->model;
#line 812 "controller.vala"
		_tmp53_ = _tmp52_->focus;
#line 812 "controller.vala"
		_tmp53__length1 = _tmp52_->focus_length1;
#line 812 "controller.vala"
		_tmp54_ = _tmp53_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 812 "controller.vala"
		synapse_gui_entry_set_value (_tmp54_, NULL);
#line 4881 "controller.c"
	}
#line 814 "controller.vala"
	_tmp55_ = self->model;
#line 814 "controller.vala"
	_tmp56_ = _tmp55_->focus;
#line 814 "controller.vala"
	_tmp56__length1 = _tmp55_->focus_length1;
#line 814 "controller.vala"
	_tmp57_ = _tmp56_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 814 "controller.vala"
	synapse_gui_entry_set_key (_tmp57_, (gpointer) ((gintptr) 0));
#line 816 "controller.vala"
	_tmp58_ = self->view;
#line 816 "controller.vala"
	_tmp59_ = self->model;
#line 816 "controller.vala"
	_tmp60_ = _tmp59_->results;
#line 816 "controller.vala"
	_tmp60__length1 = _tmp59_->results_length1;
#line 816 "controller.vala"
	_tmp61_ = _tmp60_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 816 "controller.vala"
	synapse_gui_iview_update_actions (_tmp58_, _tmp61_);
#line 817 "controller.vala"
	_tmp62_ = self->view;
#line 817 "controller.vala"
	_tmp63_ = self->model;
#line 817 "controller.vala"
	_tmp64_ = _tmp63_->focus;
#line 817 "controller.vala"
	_tmp64__length1 = _tmp63_->focus_length1;
#line 817 "controller.vala"
	_tmp65_ = _tmp64_[SYNAPSE_GUI_SEARCHING_FOR_ACTIONS];
#line 817 "controller.vala"
	synapse_gui_iview_update_focused_action (_tmp62_, _tmp65_);
#line 4917 "controller.c"
}

SynapseGuiController*
synapse_gui_controller_construct (GType object_type)
{
	SynapseGuiController * self = NULL;
#line 24 "controller.vala"
	self = (SynapseGuiController*) g_object_new (object_type, NULL);
#line 24 "controller.vala"
	return self;
#line 4928 "controller.c"
}

SynapseGuiController*
synapse_gui_controller_new (void)
{
#line 24 "controller.vala"
	return synapse_gui_controller_construct (SYNAPSE_GUI_TYPE_CONTROLLER);
#line 4936 "controller.c"
}

static SynapseDataSink*
synapse_gui_controller_real_get_data_sink (SynapseGuiIController* base)
{
	SynapseDataSink* result;
	SynapseGuiController* self;
	SynapseDataSink* _tmp0_;
#line 36 "controller.vala"
	self = (SynapseGuiController*) base;
#line 36 "controller.vala"
	_tmp0_ = self->priv->_data_sink;
#line 36 "controller.vala"
	result = _tmp0_;
#line 36 "controller.vala"
	return result;
#line 4953 "controller.c"
}

static void
synapse_gui_controller_real_set_data_sink (SynapseGuiIController* base,
                                           SynapseDataSink* value)
{
	SynapseGuiController* self;
	SynapseDataSink* old_value;
#line 36 "controller.vala"
	self = (SynapseGuiController*) base;
#line 36 "controller.vala"
	old_value = synapse_gui_controller_real_get_data_sink (base);
#line 36 "controller.vala"
	if (old_value != value) {
#line 4968 "controller.c"
		SynapseDataSink* _tmp0_;
#line 36 "controller.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 36 "controller.vala"
		_g_object_unref0 (self->priv->_data_sink);
#line 36 "controller.vala"
		self->priv->_data_sink = _tmp0_;
#line 36 "controller.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_gui_controller_properties[SYNAPSE_GUI_CONTROLLER_DATA_SINK_PROPERTY]);
#line 4978 "controller.c"
	}
}

static SynapseGuiKeyComboConfig*
synapse_gui_controller_real_get_key_combo_config (SynapseGuiIController* base)
{
	SynapseGuiKeyComboConfig* result;
	SynapseGuiController* self;
	SynapseGuiKeyComboConfig* _tmp0_;
#line 37 "controller.vala"
	self = (SynapseGuiController*) base;
#line 37 "controller.vala"
	_tmp0_ = self->priv->_key_combo_config;
#line 37 "controller.vala"
	result = _tmp0_;
#line 37 "controller.vala"
	return result;
#line 4996 "controller.c"
}

static void
synapse_gui_controller_real_set_key_combo_config (SynapseGuiIController* base,
                                                  SynapseGuiKeyComboConfig* value)
{
	SynapseGuiController* self;
	SynapseGuiKeyComboConfig* old_value;
#line 37 "controller.vala"
	self = (SynapseGuiController*) base;
#line 37 "controller.vala"
	old_value = synapse_gui_controller_real_get_key_combo_config (base);
#line 37 "controller.vala"
	if (old_value != value) {
#line 5011 "controller.c"
		SynapseGuiKeyComboConfig* _tmp0_;
#line 37 "controller.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 37 "controller.vala"
		_g_object_unref0 (self->priv->_key_combo_config);
#line 37 "controller.vala"
		self->priv->_key_combo_config = _tmp0_;
#line 37 "controller.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_gui_controller_properties[SYNAPSE_GUI_CONTROLLER_KEY_COMBO_CONFIG_PROPERTY]);
#line 5021 "controller.c"
	}
}

static SynapseGuiCategoryConfig*
synapse_gui_controller_real_get_category_config (SynapseGuiIController* base)
{
	SynapseGuiCategoryConfig* result;
	SynapseGuiController* self;
	SynapseGuiCategoryConfig* _tmp0_;
#line 38 "controller.vala"
	self = (SynapseGuiController*) base;
#line 38 "controller.vala"
	_tmp0_ = self->priv->_category_config;
#line 38 "controller.vala"
	result = _tmp0_;
#line 38 "controller.vala"
	return result;
#line 5039 "controller.c"
}

static void
synapse_gui_controller_real_set_category_config (SynapseGuiIController* base,
                                                 SynapseGuiCategoryConfig* value)
{
	SynapseGuiController* self;
	SynapseGuiCategoryConfig* old_value;
#line 38 "controller.vala"
	self = (SynapseGuiController*) base;
#line 38 "controller.vala"
	old_value = synapse_gui_controller_real_get_category_config (base);
#line 38 "controller.vala"
	if (old_value != value) {
#line 5054 "controller.c"
		SynapseGuiCategoryConfig* _tmp0_;
#line 38 "controller.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 38 "controller.vala"
		_g_object_unref0 (self->priv->_category_config);
#line 38 "controller.vala"
		self->priv->_category_config = _tmp0_;
#line 38 "controller.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_gui_controller_properties[SYNAPSE_GUI_CONTROLLER_CATEGORY_CONFIG_PROPERTY]);
#line 5064 "controller.c"
	}
}

static void
_synapse_gui_controller_search_add_delete_char_gtk_im_context_commit (GtkIMContext* _sender,
                                                                      const gchar* str,
                                                                      gpointer self)
{
#line 198 "controller.vala"
	synapse_gui_controller_search_add_delete_char ((SynapseGuiController*) self, str);
#line 5075 "controller.c"
}

static GObject *
synapse_gui_controller_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseGuiController * self;
	SynapseGuiModel* _tmp0_;
	GtkIMMulticontext* _tmp1_;
	GtkIMMulticontext* _tmp2_;
	GtkIMMulticontext* _tmp3_;
#line 189 "controller.vala"
	parent_class = G_OBJECT_CLASS (synapse_gui_controller_parent_class);
#line 189 "controller.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 189 "controller.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_GUI_TYPE_CONTROLLER, SynapseGuiController);
#line 192 "controller.vala"
	_tmp0_ = synapse_gui_model_new ();
#line 192 "controller.vala"
	_g_object_unref0 (self->model);
#line 192 "controller.vala"
	self->model = _tmp0_;
#line 193 "controller.vala"
	synapse_gui_controller_init_search (self);
#line 196 "controller.vala"
	_tmp1_ = (GtkIMMulticontext*) gtk_im_multicontext_new ();
#line 196 "controller.vala"
	_g_object_unref0 (self->im_context);
#line 196 "controller.vala"
	self->im_context = _tmp1_;
#line 197 "controller.vala"
	_tmp2_ = self->im_context;
#line 197 "controller.vala"
	gtk_im_context_set_use_preedit ((GtkIMContext*) _tmp2_, FALSE);
#line 198 "controller.vala"
	_tmp3_ = self->im_context;
#line 198 "controller.vala"
	g_signal_connect_object ((GtkIMContext*) _tmp3_, "commit", (GCallback) _synapse_gui_controller_search_add_delete_char_gtk_im_context_commit, self, 0);
#line 189 "controller.vala"
	return obj;
#line 5120 "controller.c"
}

static void
synapse_gui_controller_class_init (SynapseGuiControllerClass * klass,
                                   gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 24 "controller.vala"
	synapse_gui_controller_parent_class = g_type_class_peek_parent (klass);
#line 24 "controller.vala"
	g_type_class_adjust_private_offset (klass, &SynapseGuiController_private_offset);
#line 24 "controller.vala"
	((SynapseGuiControllerClass *) klass)->clear_search_or_hide_pressed = (void (*) (SynapseGuiController*)) synapse_gui_controller_real_clear_search_or_hide_pressed;
#line 24 "controller.vala"
	((SynapseGuiControllerClass *) klass)->fetch_command = (gboolean (*) (SynapseGuiController*, SynapseGuiKeyComboConfigCommands)) synapse_gui_controller_real_fetch_command;
#line 24 "controller.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_gui_controller_get_property;
#line 24 "controller.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_gui_controller_set_property;
#line 24 "controller.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_gui_controller_constructor;
#line 24 "controller.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_gui_controller_finalize;
#line 24 "controller.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_GUI_CONTROLLER_DATA_SINK_PROPERTY, synapse_gui_controller_properties[SYNAPSE_GUI_CONTROLLER_DATA_SINK_PROPERTY] = g_param_spec_object ("data-sink", "data-sink", "data-sink", SYNAPSE_TYPE_DATA_SINK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 24 "controller.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_GUI_CONTROLLER_KEY_COMBO_CONFIG_PROPERTY, synapse_gui_controller_properties[SYNAPSE_GUI_CONTROLLER_KEY_COMBO_CONFIG_PROPERTY] = g_param_spec_object ("key-combo-config", "key-combo-config", "key-combo-config", SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 24 "controller.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_GUI_CONTROLLER_CATEGORY_CONFIG_PROPERTY, synapse_gui_controller_properties[SYNAPSE_GUI_CONTROLLER_CATEGORY_CONFIG_PROPERTY] = g_param_spec_object ("category-config", "category-config", "category-config", SYNAPSE_GUI_TYPE_CATEGORY_CONFIG, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 28 "controller.vala"
	_tmp0_ = g_strdup (_ ("Searching..."));
#line 28 "controller.vala"
	_g_free0 (synapse_gui_icontroller_SEARCHING);
#line 28 "controller.vala"
	synapse_gui_icontroller_SEARCHING = _tmp0_;
#line 29 "controller.vala"
	_tmp1_ = g_strdup (_ ("No results found."));
#line 29 "controller.vala"
	_g_free0 (synapse_gui_icontroller_NO_RESULTS);
#line 29 "controller.vala"
	synapse_gui_icontroller_NO_RESULTS = _tmp1_;
#line 30 "controller.vala"
	_tmp2_ = g_strdup (_ ("No recent activities found."));
#line 30 "controller.vala"
	_g_free0 (synapse_gui_icontroller_NO_RECENT_ACTIVITIES);
#line 30 "controller.vala"
	synapse_gui_icontroller_NO_RECENT_ACTIVITIES = _tmp2_;
#line 31 "controller.vala"
	_tmp3_ = g_strdup (_ ("Type to search..."));
#line 31 "controller.vala"
	_g_free0 (synapse_gui_icontroller_TYPE_TO_SEARCH);
#line 31 "controller.vala"
	synapse_gui_icontroller_TYPE_TO_SEARCH = _tmp3_;
#line 32 "controller.vala"
	_tmp4_ = g_strdup ("");
#line 32 "controller.vala"
	_g_free0 (synapse_gui_icontroller_DOWN_TO_SEE_RECENT);
#line 32 "controller.vala"
	synapse_gui_icontroller_DOWN_TO_SEE_RECENT = _tmp4_;
#line 5184 "controller.c"
}

static void
synapse_gui_controller_synapse_gui_icontroller_interface_init (SynapseGuiIControllerIface * iface,
                                                               gpointer iface_data)
{
#line 43 "controller.vala"
	synapse_gui_controller_synapse_gui_icontroller_parent_iface = g_type_interface_peek_parent (iface);
#line 43 "controller.vala"
	iface->set_view = (void (*) (SynapseGuiIController*, GType)) synapse_gui_controller_real_set_view;
#line 43 "controller.vala"
	iface->key_press_event = (void (*) (SynapseGuiIController*, GdkEventKey*)) synapse_gui_controller_real_key_press_event;
#line 43 "controller.vala"
	iface->category_changed_event = (void (*) (SynapseGuiIController*, gint)) synapse_gui_controller_real_category_changed_event;
#line 43 "controller.vala"
	iface->fire_focus = (void (*) (SynapseGuiIController*)) synapse_gui_controller_real_fire_focus;
#line 43 "controller.vala"
	iface->fire_focus_context_switch_event = (void (*) (SynapseGuiIController*)) synapse_gui_controller_real_fire_focus_context_switch_event;
#line 43 "controller.vala"
	iface->selected_index_changed_event = (void (*) (SynapseGuiIController*, gint)) synapse_gui_controller_real_selected_index_changed_event;
#line 43 "controller.vala"
	iface->summon_or_vanish = (void (*) (SynapseGuiIController*)) synapse_gui_controller_real_summon_or_vanish;
#line 43 "controller.vala"
	iface->is_in_initial_state = (gboolean (*) (SynapseGuiIController*)) synapse_gui_controller_real_is_in_initial_state;
#line 43 "controller.vala"
	iface->searched_for_recent = (gboolean (*) (SynapseGuiIController*)) synapse_gui_controller_real_searched_for_recent;
#line 43 "controller.vala"
	iface->get_data_sink = synapse_gui_controller_real_get_data_sink;
#line 43 "controller.vala"
	iface->set_data_sink = synapse_gui_controller_real_set_data_sink;
#line 43 "controller.vala"
	iface->get_key_combo_config = synapse_gui_controller_real_get_key_combo_config;
#line 43 "controller.vala"
	iface->set_key_combo_config = synapse_gui_controller_real_set_key_combo_config;
#line 43 "controller.vala"
	iface->get_category_config = synapse_gui_controller_real_get_category_config;
#line 43 "controller.vala"
	iface->set_category_config = synapse_gui_controller_real_set_category_config;
#line 5223 "controller.c"
}

static void
synapse_gui_controller_instance_init (SynapseGuiController * self,
                                      gpointer klass)
{
#line 24 "controller.vala"
	self->priv = synapse_gui_controller_get_instance_private (self);
#line 41 "controller.vala"
	self->view = NULL;
#line 516 "controller.vala"
	self->priv->search_recent_activities = FALSE;
#line 517 "controller.vala"
	self->priv->handle_empty = FALSE;
#line 5238 "controller.c"
}

static void
synapse_gui_controller_finalize (GObject * obj)
{
	SynapseGuiController * self;
#line 24 "controller.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_GUI_TYPE_CONTROLLER, SynapseGuiController);
#line 36 "controller.vala"
	_g_object_unref0 (self->priv->_data_sink);
#line 37 "controller.vala"
	_g_object_unref0 (self->priv->_key_combo_config);
#line 38 "controller.vala"
	_g_object_unref0 (self->priv->_category_config);
#line 40 "controller.vala"
	_g_object_unref0 (self->model);
#line 41 "controller.vala"
	_g_object_unref0 (self->view);
#line 187 "controller.vala"
	_g_object_unref0 (self->im_context);
#line 520 "controller.vala"
	_vala_array_destroy (self->priv->current_cancellable, 3, (GDestroyNotify) g_object_unref);
#line 525 "controller.vala"
	_g_object_unref0 (self->priv->last_result_set);
#line 43 "controller.vala"
	G_OBJECT_CLASS (synapse_gui_controller_parent_class)->finalize (obj);
#line 5265 "controller.c"
}

static GType
synapse_gui_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseGuiControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_gui_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseGuiController), 0, (GInstanceInitFunc) synapse_gui_controller_instance_init, NULL };
	static const GInterfaceInfo synapse_gui_icontroller_info = { (GInterfaceInitFunc) synapse_gui_controller_synapse_gui_icontroller_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_gui_controller_type_id;
	synapse_gui_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseGuiController", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_gui_controller_type_id, SYNAPSE_GUI_TYPE_ICONTROLLER, &synapse_gui_icontroller_info);
	SynapseGuiController_private_offset = g_type_add_instance_private (synapse_gui_controller_type_id, sizeof (SynapseGuiControllerPrivate));
	return synapse_gui_controller_type_id;
}

GType
synapse_gui_controller_get_type (void)
{
	static volatile gsize synapse_gui_controller_type_id__once = 0;
	if (g_once_init_enter (&synapse_gui_controller_type_id__once)) {
		GType synapse_gui_controller_type_id;
		synapse_gui_controller_type_id = synapse_gui_controller_get_type_once ();
		g_once_init_leave (&synapse_gui_controller_type_id__once, synapse_gui_controller_type_id);
	}
	return synapse_gui_controller_type_id__once;
}

static void
_vala_synapse_gui_controller_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SynapseGuiController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_GUI_TYPE_CONTROLLER, SynapseGuiController);
#line 24 "controller.vala"
	switch (property_id) {
#line 24 "controller.vala"
		case SYNAPSE_GUI_CONTROLLER_DATA_SINK_PROPERTY:
#line 24 "controller.vala"
		g_value_set_object (value, synapse_gui_icontroller_get_data_sink ((SynapseGuiIController*) self));
#line 24 "controller.vala"
		break;
#line 24 "controller.vala"
		case SYNAPSE_GUI_CONTROLLER_KEY_COMBO_CONFIG_PROPERTY:
#line 24 "controller.vala"
		g_value_set_object (value, synapse_gui_icontroller_get_key_combo_config ((SynapseGuiIController*) self));
#line 24 "controller.vala"
		break;
#line 24 "controller.vala"
		case SYNAPSE_GUI_CONTROLLER_CATEGORY_CONFIG_PROPERTY:
#line 24 "controller.vala"
		g_value_set_object (value, synapse_gui_icontroller_get_category_config ((SynapseGuiIController*) self));
#line 24 "controller.vala"
		break;
#line 5320 "controller.c"
		default:
#line 24 "controller.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "controller.vala"
		break;
#line 5326 "controller.c"
	}
}

static void
_vala_synapse_gui_controller_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SynapseGuiController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_GUI_TYPE_CONTROLLER, SynapseGuiController);
#line 24 "controller.vala"
	switch (property_id) {
#line 24 "controller.vala"
		case SYNAPSE_GUI_CONTROLLER_DATA_SINK_PROPERTY:
#line 24 "controller.vala"
		synapse_gui_icontroller_set_data_sink ((SynapseGuiIController*) self, g_value_get_object (value));
#line 24 "controller.vala"
		break;
#line 24 "controller.vala"
		case SYNAPSE_GUI_CONTROLLER_KEY_COMBO_CONFIG_PROPERTY:
#line 24 "controller.vala"
		synapse_gui_icontroller_set_key_combo_config ((SynapseGuiIController*) self, g_value_get_object (value));
#line 24 "controller.vala"
		break;
#line 24 "controller.vala"
		case SYNAPSE_GUI_CONTROLLER_CATEGORY_CONFIG_PROPERTY:
#line 24 "controller.vala"
		synapse_gui_icontroller_set_category_config ((SynapseGuiIController*) self, g_value_get_object (value));
#line 24 "controller.vala"
		break;
#line 5358 "controller.c"
		default:
#line 24 "controller.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "controller.vala"
		break;
#line 5364 "controller.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
#line 24 "controller.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 5375 "controller.c"
		gssize i;
#line 24 "controller.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 24 "controller.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 24 "controller.vala"
				destroy_func (((gpointer*) array)[i]);
#line 5383 "controller.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
#line 24 "controller.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 24 "controller.vala"
	g_free (array);
#line 5398 "controller.c"
}

