/* MainView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MainView.vala, do not modify */

/*
 * Copyright 2011–2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include "power.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <granite-7.h>
#include <switchboard.h>

#define POWER_MAIN_VIEW_BRIGHTNESS_STEP 4.0
#define POWER_MAIN_VIEW_SETTINGS_DAEMON_NAME "org.gnome.SettingsDaemon.Power"
#define POWER_MAIN_VIEW_SETTINGS_DAEMON_PATH "/org/gnome/SettingsDaemon/Power"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define POWER_TYPE_POWER_SETTINGS (power_power_settings_get_type ())
#define POWER_POWER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POWER_TYPE_POWER_SETTINGS, PowerPowerSettings))
#define POWER_IS_POWER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POWER_TYPE_POWER_SETTINGS))
#define POWER_POWER_SETTINGS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), POWER_TYPE_POWER_SETTINGS, PowerPowerSettingsIface))

typedef struct _PowerPowerSettings PowerPowerSettings;
typedef struct _PowerPowerSettingsIface PowerPowerSettingsIface;

#define POWER_TYPE_POWER_SETTINGS_PROXY (power_power_settings_proxy_get_type ())
enum  {
	POWER_MAIN_VIEW_0_PROPERTY,
	POWER_MAIN_VIEW_STACK_PROPERTY,
	POWER_MAIN_VIEW_NATURAL_SCROLL_TOUCHPAD_PROPERTY,
	POWER_MAIN_VIEW_NATURAL_SCROLL_MOUSE_PROPERTY,
	POWER_MAIN_VIEW_NUM_PROPERTIES
};
static GParamSpec* power_main_view_properties[POWER_MAIN_VIEW_NUM_PROPERTIES];
typedef enum  {
	POWER_MAIN_VIEW_POWER_ACTION_TYPE_BLANK,
	POWER_MAIN_VIEW_POWER_ACTION_TYPE_SUSPEND,
	POWER_MAIN_VIEW_POWER_ACTION_TYPE_SHUTDOWN,
	POWER_MAIN_VIEW_POWER_ACTION_TYPE_HIBERNATE,
	POWER_MAIN_VIEW_POWER_ACTION_TYPE_INTERACTIVE,
	POWER_MAIN_VIEW_POWER_ACTION_TYPE_NOTHING,
	POWER_MAIN_VIEW_POWER_ACTION_TYPE_LOGOUT
} PowerMainViewPowerActionType;

#define POWER_MAIN_VIEW_TYPE_POWER_ACTION_TYPE (power_main_view_power_action_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define POWER_TYPE_LID_CLOSE_ACTION_COMBO_BOX (power_lid_close_action_combo_box_get_type ())
#define POWER_LID_CLOSE_ACTION_COMBO_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POWER_TYPE_LID_CLOSE_ACTION_COMBO_BOX, PowerLidCloseActionComboBox))
#define POWER_LID_CLOSE_ACTION_COMBO_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POWER_TYPE_LID_CLOSE_ACTION_COMBO_BOX, PowerLidCloseActionComboBoxClass))
#define POWER_IS_LID_CLOSE_ACTION_COMBO_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POWER_TYPE_LID_CLOSE_ACTION_COMBO_BOX))
#define POWER_IS_LID_CLOSE_ACTION_COMBO_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POWER_TYPE_LID_CLOSE_ACTION_COMBO_BOX))
#define POWER_LID_CLOSE_ACTION_COMBO_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POWER_TYPE_LID_CLOSE_ACTION_COMBO_BOX, PowerLidCloseActionComboBoxClass))

typedef struct _PowerLidCloseActionComboBox PowerLidCloseActionComboBox;
typedef struct _PowerLidCloseActionComboBoxClass PowerLidCloseActionComboBoxClass;

#define POWER_TYPE_TIMEOUT_COMBO_BOX (power_timeout_combo_box_get_type ())
#define POWER_TIMEOUT_COMBO_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POWER_TYPE_TIMEOUT_COMBO_BOX, PowerTimeoutComboBox))
#define POWER_TIMEOUT_COMBO_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POWER_TYPE_TIMEOUT_COMBO_BOX, PowerTimeoutComboBoxClass))
#define POWER_IS_TIMEOUT_COMBO_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POWER_TYPE_TIMEOUT_COMBO_BOX))
#define POWER_IS_TIMEOUT_COMBO_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POWER_TYPE_TIMEOUT_COMBO_BOX))
#define POWER_TIMEOUT_COMBO_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POWER_TYPE_TIMEOUT_COMBO_BOX, PowerTimeoutComboBoxClass))

typedef struct _PowerTimeoutComboBox PowerTimeoutComboBox;
typedef struct _PowerTimeoutComboBoxClass PowerTimeoutComboBoxClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PowerPowerSettingsIface {
	GTypeInterface parent_iface;
	gint (*get_brightness) (PowerPowerSettings* self);
	void (*set_brightness) (PowerPowerSettings* self, gint value);
};

struct _PowerMainViewPrivate {
	GtkStack* _stack;
	gboolean _natural_scroll_touchpad;
	gboolean _natural_scroll_mouse;
	gdouble total_x_delta;
	gdouble total_y_delta;
	GtkDropDown* powerbutton_dropdown;
	GtkScale* scale;
	PowerPowerSettings* screen;
};

struct _Block1Data {
	int _ref_count_;
	PowerMainView* self;
	GtkInfoBar* infobar;
};

static gint PowerMainView_private_offset;
static gpointer power_main_view_parent_class = NULL;
VALA_EXTERN GSettings* power_settings;

VALA_EXTERN GType power_power_settings_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType power_power_settings_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint power_power_settings_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
static GType power_main_view_power_action_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void power_main_view_on_scale_value_changed (PowerMainView* self);
static void power_main_view_on_screen_properties_changed (PowerMainView* self,
                                                   GVariant* changed_properties,
                                                   gchar** invalidated_properties,
                                                   gint invalidated_properties_length1);
static void _power_main_view_on_screen_properties_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                      GVariant* changed_properties,
                                                                                      gchar** invalidated_properties,
                                                                                      gpointer self);
VALA_EXTERN void power_power_settings_set_brightness (PowerPowerSettings* self,
                                          gint value);
VALA_EXTERN gint power_power_settings_get_brightness (PowerPowerSettings* self);
static void _power_main_view_on_scale_value_changed_gtk_range_value_changed (GtkRange* _sender,
                                                                      gpointer self);
static gboolean power_main_view_handle_scroll_event (PowerMainView* self,
                                              GdkScrollEvent* e,
                                              gdouble* dir);
static void power_main_view_update_powerbutton_dropdown (PowerMainView* self);
static void power_main_view_set_stack (PowerMainView* self,
                                GtkStack* value);
static GObject * power_main_view_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static gboolean _power_main_view____lambda9_ (PowerMainView* self,
                                       GdkEvent* e);
static gboolean __power_main_view____lambda9__gtk_event_controller_legacy_event (GtkEventControllerLegacy* _sender,
                                                                          GdkEvent* event,
                                                                          gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN GType power_lid_close_action_combo_box_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PowerLidCloseActionComboBox* power_lid_close_action_combo_box_new (gboolean dock);
VALA_EXTERN PowerLidCloseActionComboBox* power_lid_close_action_combo_box_construct (GType object_type,
                                                                         gboolean dock);
static void _power_main_view_____lambda11_ (Block1Data* _data1_);
static void __power_main_view_____lambda11__power_logind_helper_iface_changed (PowerLogindHelperIface* _sender,
                                                                        gpointer self);
VALA_EXTERN GType power_timeout_combo_box_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PowerTimeoutComboBox* power_timeout_combo_box_new (GSettings* schema,
                                                   const gchar* key);
VALA_EXTERN PowerTimeoutComboBox* power_timeout_combo_box_construct (GType object_type,
                                                         GSettings* schema,
                                                         const gchar* key);
VALA_EXTERN void power_timeout_combo_box_set_enum_property (PowerTimeoutComboBox* self,
                                                const gchar* value);
VALA_EXTERN void power_timeout_combo_box_set_enum_never_value (PowerTimeoutComboBox* self,
                                                   gint value);
VALA_EXTERN void power_timeout_combo_box_set_enum_normal_value (PowerTimeoutComboBox* self,
                                                    gint value);
static void _power_main_view_update_powerbutton_dropdown_g_settings_changed (GSettings* _sender,
                                                                      const gchar* key,
                                                                      gpointer self);
static void _power_main_view___lambda15_ (PowerMainView* self);
static void __power_main_view___lambda15__g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void power_main_view_finalize (GObject * obj);
static GType power_main_view_get_type_once (void);
static void _vala_power_main_view_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_power_main_view_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
power_main_view_get_instance_private (PowerMainView* self)
{
	return G_STRUCT_MEMBER_P (self, PowerMainView_private_offset);
}

static GType
power_main_view_power_action_type_get_type_once (void)
{
	static const GEnumValue values[] = {{POWER_MAIN_VIEW_POWER_ACTION_TYPE_BLANK, "POWER_MAIN_VIEW_POWER_ACTION_TYPE_BLANK", "blank"}, {POWER_MAIN_VIEW_POWER_ACTION_TYPE_SUSPEND, "POWER_MAIN_VIEW_POWER_ACTION_TYPE_SUSPEND", "suspend"}, {POWER_MAIN_VIEW_POWER_ACTION_TYPE_SHUTDOWN, "POWER_MAIN_VIEW_POWER_ACTION_TYPE_SHUTDOWN", "shutdown"}, {POWER_MAIN_VIEW_POWER_ACTION_TYPE_HIBERNATE, "POWER_MAIN_VIEW_POWER_ACTION_TYPE_HIBERNATE", "hibernate"}, {POWER_MAIN_VIEW_POWER_ACTION_TYPE_INTERACTIVE, "POWER_MAIN_VIEW_POWER_ACTION_TYPE_INTERACTIVE", "interactive"}, {POWER_MAIN_VIEW_POWER_ACTION_TYPE_NOTHING, "POWER_MAIN_VIEW_POWER_ACTION_TYPE_NOTHING", "nothing"}, {POWER_MAIN_VIEW_POWER_ACTION_TYPE_LOGOUT, "POWER_MAIN_VIEW_POWER_ACTION_TYPE_LOGOUT", "logout"}, {0, NULL, NULL}};
	GType power_main_view_power_action_type_type_id;
	power_main_view_power_action_type_type_id = g_enum_register_static ("PowerMainViewPowerActionType", values);
	return power_main_view_power_action_type_type_id;
}

static GType
power_main_view_power_action_type_get_type (void)
{
	static volatile gsize power_main_view_power_action_type_type_id__once = 0;
	if (g_once_init_enter (&power_main_view_power_action_type_type_id__once)) {
		GType power_main_view_power_action_type_type_id;
		power_main_view_power_action_type_type_id = power_main_view_power_action_type_get_type_once ();
		g_once_init_leave (&power_main_view_power_action_type_type_id__once, power_main_view_power_action_type_type_id);
	}
	return power_main_view_power_action_type_type_id__once;
}

PowerMainView*
power_main_view_construct (GType object_type)
{
	PowerMainView * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("preferences-system-power");
	_tmp1_ = _tmp0_;
	self = (PowerMainView*) g_object_new (object_type, "title", _ ("Power"), "icon", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

PowerMainView*
power_main_view_new (void)
{
	return power_main_view_construct (POWER_TYPE_MAIN_VIEW);
}

static void
_power_main_view_on_screen_properties_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                 GVariant* changed_properties,
                                                                                 gchar** invalidated_properties,
                                                                                 gpointer self)
{
	power_main_view_on_screen_properties_changed ((PowerMainView*) self, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
}

static void
power_main_view_on_scale_value_changed (PowerMainView* self)
{
	gint val = 0;
	GtkScale* _tmp0_;
	PowerPowerSettings* _tmp1_;
	guint _tmp2_;
	PowerPowerSettings* _tmp3_;
	PowerPowerSettings* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scale;
	val = (gint) gtk_range_get_value ((GtkRange*) _tmp0_);
	_tmp1_ = self->priv->screen;
	g_signal_parse_name ("g-properties-changed", g_dbus_proxy_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_dbus_proxy_get_type (), GDBusProxy), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _power_main_view_on_screen_properties_changed_g_dbus_proxy_g_properties_changed, self);
	_tmp3_ = self->priv->screen;
	power_power_settings_set_brightness (_tmp3_, val);
	_tmp4_ = self->priv->screen;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) _power_main_view_on_screen_properties_changed_g_dbus_proxy_g_properties_changed, self, 0);
}

static void
_power_main_view_on_scale_value_changed_gtk_range_value_changed (GtkRange* _sender,
                                                                 gpointer self)
{
	power_main_view_on_scale_value_changed ((PowerMainView*) self);
}

static void
power_main_view_on_screen_properties_changed (PowerMainView* self,
                                              GVariant* changed_properties,
                                              gchar** invalidated_properties,
                                              gint invalidated_properties_length1)
{
	GVariant* changed_brightness = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed_properties != NULL);
	_tmp0_ = g_variant_type_new ("i");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed_properties, "Brightness", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	changed_brightness = _tmp3_;
	_tmp4_ = changed_brightness;
	if (_tmp4_ != NULL) {
		gint val = 0;
		PowerPowerSettings* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GtkScale* _tmp8_;
		guint _tmp9_;
		GtkScale* _tmp10_;
		GtkScale* _tmp11_;
		_tmp5_ = self->priv->screen;
		_tmp6_ = power_power_settings_get_brightness (_tmp5_);
		_tmp7_ = _tmp6_;
		val = _tmp7_;
		_tmp8_ = self->priv->scale;
		g_signal_parse_name ("value-changed", gtk_range_get_type (), &_tmp9_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkRange*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _power_main_view_on_scale_value_changed_gtk_range_value_changed, self);
		_tmp10_ = self->priv->scale;
		gtk_range_set_value ((GtkRange*) _tmp10_, (gdouble) val);
		_tmp11_ = self->priv->scale;
		g_signal_connect_object ((GtkRange*) _tmp11_, "value-changed", (GCallback) _power_main_view_on_scale_value_changed_gtk_range_value_changed, self, 0);
	}
	_g_variant_unref0 (changed_brightness);
}

static gboolean
power_main_view_handle_scroll_event (PowerMainView* self,
                                     GdkScrollEvent* e,
                                     gdouble* dir)
{
	gdouble _vala_dir = 0.0;
	gboolean natural_scroll = FALSE;
	GdkInputSource event_source = 0;
	GdkDevice* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_vala_dir = 0.0;
	_tmp0_ = gdk_event_get_device ((GdkEvent*) e);
	event_source = gdk_device_get_source (_tmp0_);
	if (event_source == GDK_SOURCE_TOUCHPAD) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = gdk_scroll_event_get_direction (e) == GDK_SCROLL_SMOOTH;
	}
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_natural_scroll_touchpad;
		natural_scroll = _tmp2_;
	} else {
		if (event_source == GDK_SOURCE_MOUSE) {
			gboolean _tmp3_;
			_tmp3_ = self->priv->_natural_scroll_mouse;
			natural_scroll = _tmp3_;
		} else {
			natural_scroll = FALSE;
		}
	}
	switch (gdk_scroll_event_get_direction (e)) {
		case GDK_SCROLL_SMOOTH:
		{
			gdouble dx = 0.0;
			gdouble dy = 0.0;
			gdouble _tmp4_ = 0.0;
			gdouble _tmp5_ = 0.0;
			gdouble abs_x = 0.0;
			gdouble abs_y = 0.0;
			gdk_scroll_event_get_deltas (e, &_tmp4_, &_tmp5_);
			dx = _tmp4_;
			dy = _tmp5_;
			abs_x = MAX (fabs (dx), 0.0001);
			abs_y = MAX (fabs (dy), 0.0001);
			if ((abs_y / abs_x) > 2.0) {
				self->priv->total_y_delta = self->priv->total_y_delta + dy;
			} else {
				if ((abs_x / abs_y) > 2.0) {
					self->priv->total_x_delta = self->priv->total_x_delta + dx;
				}
			}
			break;
		}
		case GDK_SCROLL_UP:
		{
			self->priv->total_y_delta = -1.0;
			break;
		}
		case GDK_SCROLL_DOWN:
		{
			self->priv->total_y_delta = 1.0;
			break;
		}
		case GDK_SCROLL_LEFT:
		{
			self->priv->total_x_delta = -1.0;
			break;
		}
		case GDK_SCROLL_RIGHT:
		{
			self->priv->total_x_delta = 1.0;
			break;
		}
		default:
		{
			break;
		}
	}
	if ((fabs (self->priv->total_y_delta) * POWER_MAIN_VIEW_BRIGHTNESS_STEP) > 1.0) {
		gdouble _tmp6_ = 0.0;
		if (natural_scroll) {
			_tmp6_ = self->priv->total_y_delta;
		} else {
			_tmp6_ = -self->priv->total_y_delta;
		}
		_vala_dir = _tmp6_;
	} else {
		if ((fabs (self->priv->total_x_delta) * POWER_MAIN_VIEW_BRIGHTNESS_STEP) > 1.0) {
			gdouble _tmp7_ = 0.0;
			if (natural_scroll) {
				_tmp7_ = -self->priv->total_x_delta;
			} else {
				_tmp7_ = self->priv->total_x_delta;
			}
			_vala_dir = _tmp7_;
		}
	}
	if (fabs (_vala_dir) > 0.0) {
		self->priv->total_y_delta = 0.0;
		self->priv->total_x_delta = 0.0;
		result = TRUE;
		if (dir) {
			*dir = _vala_dir;
		}
		return result;
	}
	result = FALSE;
	if (dir) {
		*dir = _vala_dir;
	}
	return result;
}

static void
power_main_view_update_powerbutton_dropdown (PowerMainView* self)
{
	gint* map = NULL;
	gint* _tmp0_;
	gint map_length1;
	gint _map_size_;
	GtkDropDown* _tmp1_;
	GSettings* _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gint, 4);
	_tmp0_[0] = 0;
	_tmp0_[1] = 1;
	_tmp0_[2] = 1;
	_tmp0_[3] = 2;
	map = _tmp0_;
	map_length1 = 4;
	_map_size_ = map_length1;
	_tmp1_ = self->priv->powerbutton_dropdown;
	_tmp2_ = power_settings;
	_tmp3_ = map[g_settings_get_enum (_tmp2_, "power-button-action")];
	gtk_drop_down_set_selected (_tmp1_, (guint) _tmp3_);
	map = (g_free (map), NULL);
}

GtkStack*
power_main_view_get_stack (PowerMainView* self)
{
	GtkStack* result;
	GtkStack* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stack;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
power_main_view_set_stack (PowerMainView* self,
                           GtkStack* value)
{
	GtkStack* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_main_view_get_stack (self);
	if (old_value != value) {
		GtkStack* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_stack);
		self->priv->_stack = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_main_view_properties[POWER_MAIN_VIEW_STACK_PROPERTY]);
	}
}

gboolean
power_main_view_get_natural_scroll_touchpad (PowerMainView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_natural_scroll_touchpad;
	return result;
}

void
power_main_view_set_natural_scroll_touchpad (PowerMainView* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_main_view_get_natural_scroll_touchpad (self);
	if (old_value != value) {
		self->priv->_natural_scroll_touchpad = value;
		g_object_notify_by_pspec ((GObject *) self, power_main_view_properties[POWER_MAIN_VIEW_NATURAL_SCROLL_TOUCHPAD_PROPERTY]);
	}
}

gboolean
power_main_view_get_natural_scroll_mouse (PowerMainView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_natural_scroll_mouse;
	return result;
}

void
power_main_view_set_natural_scroll_mouse (PowerMainView* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_main_view_get_natural_scroll_mouse (self);
	if (old_value != value) {
		self->priv->_natural_scroll_mouse = value;
		g_object_notify_by_pspec ((GObject *) self, power_main_view_properties[POWER_MAIN_VIEW_NATURAL_SCROLL_MOUSE_PROPERTY]);
	}
}

static gboolean
_power_main_view____lambda9_ (PowerMainView* self,
                              GdkEvent* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (gdk_event_get_event_type (e) == GDK_SCROLL) {
		gdouble dir = 0.0;
		gdouble _tmp0_ = 0.0;
		gboolean _tmp1_;
		dir = 0.0;
		_tmp1_ = power_main_view_handle_scroll_event (self, G_TYPE_CHECK_INSTANCE_CAST (e, gdk_scroll_event_get_type (), GdkScrollEvent), &_tmp0_);
		dir = _tmp0_;
		if (_tmp1_) {
			GtkScale* _tmp2_;
			GtkScale* _tmp3_;
			_tmp2_ = self->priv->scale;
			_tmp3_ = self->priv->scale;
			gtk_range_set_value ((GtkRange*) _tmp2_, gtk_range_get_value ((GtkRange*) _tmp3_) + round (dir * POWER_MAIN_VIEW_BRIGHTNESS_STEP));
		}
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
__power_main_view____lambda9__gtk_event_controller_legacy_event (GtkEventControllerLegacy* _sender,
                                                                 GdkEvent* event,
                                                                 gpointer self)
{
	gboolean result;
	result = _power_main_view____lambda9_ ((PowerMainView*) self, event);
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PowerMainView* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->infobar);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_power_main_view_____lambda11_ (Block1Data* _data1_)
{
	PowerMainView* self;
	GtkInfoBar* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->infobar;
	gtk_info_bar_set_revealed (_tmp0_, TRUE);
}

static void
__power_main_view_____lambda11__power_logind_helper_iface_changed (PowerLogindHelperIface* _sender,
                                                                   gpointer self)
{
	_power_main_view_____lambda11_ (self);
}

static void
_power_main_view_update_powerbutton_dropdown_g_settings_changed (GSettings* _sender,
                                                                 const gchar* key,
                                                                 gpointer self)
{
	power_main_view_update_powerbutton_dropdown ((PowerMainView*) self);
}

static void
_power_main_view___lambda15_ (PowerMainView* self)
{
	gint* map = NULL;
	gint* _tmp0_;
	gint map_length1;
	gint _map_size_;
	GSettings* _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	GtkDropDown* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	gint _tmp6_;
	_tmp0_ = g_new0 (gint, 3);
	_tmp0_[0] = 0;
	_tmp0_[1] = 1;
	_tmp0_[2] = 3;
	map = _tmp0_;
	map_length1 = 3;
	_map_size_ = map_length1;
	_tmp1_ = power_settings;
	_tmp2_ = map;
	_tmp2__length1 = map_length1;
	_tmp3_ = self->priv->powerbutton_dropdown;
	_tmp4_ = gtk_drop_down_get_selected (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp2_[_tmp5_];
	g_settings_set_enum (_tmp1_, "power-button-action", _tmp6_);
	map = (g_free (map), NULL);
}

static void
__power_main_view___lambda15__g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	_power_main_view___lambda15_ ((PowerMainView*) self);
}

static GObject *
power_main_view_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PowerMainView * self;
	GSettings* touchpad_settings = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* mouse_settings = NULL;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GtkSizeGroup* label_size = NULL;
	GtkSizeGroup* _tmp4_;
	GSettings* _tmp5_;
	PowerPowerManager* power_manager = NULL;
	PowerPowerManager* _tmp6_;
	PowerPowerManager* _tmp7_;
	GtkBox* box = NULL;
	GtkBox* _tmp11_;
	PowerPowerManager* _tmp12_;
	GListStore* _tmp13_;
	GListStore* _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	PowerDevicesBox* devices_box = NULL;
	PowerDevicesBox* _tmp20_ = NULL;
	GtkBox* _tmp21_;
	PowerDevicesBox* _tmp22_;
	PowerPowerSettings* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	PowerPowerManager* _tmp62_;
	GtkLabel* screen_timeout_label = NULL;
	GtkLabel* _tmp93_ = NULL;
	PowerTimeoutComboBox* screen_timeout = NULL;
	GSettings* _tmp94_;
	GSettings* _tmp95_;
	PowerTimeoutComboBox* _tmp96_ = NULL;
	PowerTimeoutComboBox* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar** _tmp101_;
	gchar** _tmp102_;
	gint _tmp102__length1;
	GtkDropDown* _tmp103_ = NULL;
	GtkLabel* powerbutton_label = NULL;
	GtkDropDown* _tmp104_;
	GtkWidget* _tmp105_;
	GtkLabel* _tmp106_ = NULL;
	GtkGrid* main_grid = NULL;
	GtkGrid* _tmp107_ = NULL;
	GtkGrid* _tmp108_;
	GtkLabel* _tmp109_;
	GtkGrid* _tmp110_;
	PowerTimeoutComboBox* _tmp111_;
	GtkGrid* _tmp112_;
	GtkLabel* _tmp113_;
	GtkGrid* _tmp114_;
	GtkDropDown* _tmp115_;
	GtkLabel* sleep_timeout_label = NULL;
	GtkLabel* _tmp116_ = NULL;
	PowerTimeoutComboBox* sleep_timeout = NULL;
	GSettings* _tmp117_;
	gchar* _tmp118_;
	PowerTimeoutComboBox* _tmp119_ = NULL;
	GtkGrid* ac_grid = NULL;
	GtkGrid* _tmp120_ = NULL;
	GtkGrid* _tmp121_;
	GtkLabel* _tmp122_;
	GtkGrid* _tmp123_;
	PowerTimeoutComboBox* _tmp124_;
	PowerPowerModeButton* power_mode_button = NULL;
	PowerPowerModeButton* _tmp125_;
	gboolean _tmp126_;
	gboolean _tmp127_;
	GtkStack* _tmp130_;
	GtkStack* _tmp131_;
	GtkStack* _tmp132_;
	GtkGrid* _tmp133_;
	GtkStackSwitcher* stack_switcher = NULL;
	GtkStack* _tmp134_;
	GtkStack* _tmp135_;
	GtkStackSwitcher* _tmp136_ = NULL;
	GtkSizeGroup* size_group = NULL;
	GtkSizeGroup* _tmp137_;
	GtkSizeGroup* _tmp138_;
	GSList* _tmp139_;
	PowerPowerManager* _tmp149_;
	GListStore* _tmp150_;
	GListStore* _tmp151_;
	guint _tmp152_;
	guint _tmp153_;
	GtkGrid* _tmp197_;
	GtkStack* _tmp198_;
	GtkBox* _tmp199_;
	GtkGrid* _tmp200_;
	GtkBox* _tmp201_;
	GtkSizeGroup* _tmp202_;
	GtkLabel* _tmp203_;
	GtkSizeGroup* _tmp204_;
	GtkLabel* _tmp205_;
	GtkSizeGroup* _tmp206_;
	GtkLabel* _tmp207_;
	GtkStackSwitcher* _tmp208_;
	GtkStack* _tmp209_;
	GListModel* _tmp210_;
	GListModel* _tmp211_;
	GSettings* _tmp212_;
	GtkDropDown* _tmp213_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (power_main_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_TYPE_MAIN_VIEW, PowerMainView);
	_tmp0_ = g_settings_new ("org.gnome.desktop.peripherals.touchpad");
	touchpad_settings = _tmp0_;
	_tmp1_ = touchpad_settings;
	g_settings_bind (_tmp1_, "natural-scroll", (GObject*) self, "natural-scroll-touchpad", G_SETTINGS_BIND_GET);
	_tmp2_ = g_settings_new ("org.gnome.desktop.peripherals.mouse");
	mouse_settings = _tmp2_;
	_tmp3_ = mouse_settings;
	g_settings_bind (_tmp3_, "natural-scroll", (GObject*) self, "natural-scroll-mouse", G_SETTINGS_BIND_GET);
	_tmp4_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	label_size = _tmp4_;
	_tmp5_ = g_settings_new ("org.gnome.settings-daemon.plugins.power");
	_g_object_unref0 (power_settings);
	power_settings = _tmp5_;
	_tmp6_ = power_power_manager_get_default ();
	_tmp7_ = _g_object_ref0 (_tmp6_);
	power_manager = _tmp7_;
	{
		PowerPowerSettings* _tmp8_ = NULL;
		PowerPowerSettings* _tmp9_;
		PowerPowerSettings* _tmp10_;
		_tmp9_ = (PowerPowerSettings*) g_initable_new (POWER_TYPE_POWER_SETTINGS_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", POWER_MAIN_VIEW_SETTINGS_DAEMON_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", POWER_MAIN_VIEW_SETTINGS_DAEMON_PATH, "g-interface-name", "org.gnome.SettingsDaemon.Power.Screen", NULL);
		_tmp8_ = (PowerPowerSettings*) _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (power_manager);
			_g_object_unref0 (label_size);
			_g_object_unref0 (mouse_settings);
			_g_object_unref0 (touchpad_settings);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp10_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (self->priv->screen);
		self->priv->screen = _tmp10_;
		_g_object_unref0 (_tmp8_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("MainView.vala:70: Failed to get settings daemon for brightness setting");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (power_manager);
		_g_object_unref0 (label_size);
		_g_object_unref0 (mouse_settings);
		_g_object_unref0 (touchpad_settings);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 24);
	g_object_ref_sink (_tmp11_);
	box = _tmp11_;
	_tmp12_ = power_manager;
	_tmp13_ = power_power_manager_get_batteries (_tmp12_);
	_tmp14_ = _tmp13_;
	g_object_get (_tmp14_, "n-items", &_tmp15_, NULL);
	_tmp16_ = _tmp15_;
	if (_tmp16_ > ((guint) 0)) {
		PowerBatteryBox* battery_box = NULL;
		PowerBatteryBox* _tmp17_ = NULL;
		GtkBox* _tmp18_;
		PowerBatteryBox* _tmp19_;
		_tmp17_ = power_battery_box_new ();
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp17_, 12);
		g_object_ref_sink (_tmp17_);
		battery_box = _tmp17_;
		_tmp18_ = box;
		_tmp19_ = battery_box;
		gtk_box_append (_tmp18_, (GtkWidget*) _tmp19_);
		_g_object_unref0 (battery_box);
	}
	_tmp20_ = power_devices_box_new ();
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp20_, 12);
	g_object_ref_sink (_tmp20_);
	devices_box = _tmp20_;
	_tmp21_ = box;
	_tmp22_ = devices_box;
	gtk_box_append (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->screen;
	_tmp24_ = power_power_settings_get_brightness (_tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ != -1) {
		GtkSwitch* als_switch = NULL;
		GtkSwitch* _tmp26_ = NULL;
		GtkLabel* als_label = NULL;
		GtkSwitch* _tmp27_;
		GtkWidget* _tmp28_;
		GtkLabel* _tmp29_ = NULL;
		GSettings* _tmp30_;
		GtkSwitch* _tmp31_;
		GtkEventControllerLegacy* scale_scroll_controller = NULL;
		GtkEventControllerLegacy* _tmp32_;
		GtkScale* _tmp33_ = NULL;
		GtkScale* _tmp34_;
		GtkEventControllerLegacy* _tmp35_;
		GtkEventController* _tmp36_;
		GtkEventControllerLegacy* _tmp37_;
		GtkScale* _tmp38_;
		PowerPowerSettings* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		GtkScale* _tmp42_;
		PowerPowerSettings* _tmp43_;
		GtkLabel* brightness_label = NULL;
		GtkScale* _tmp44_;
		GtkWidget* _tmp45_;
		GtkLabel* _tmp46_ = NULL;
		GtkGrid* brightness_grid = NULL;
		GtkGrid* _tmp47_ = NULL;
		GtkGrid* _tmp48_;
		GtkLabel* _tmp49_;
		GtkGrid* _tmp50_;
		GtkScale* _tmp51_;
		GtkGrid* _tmp52_;
		GtkLabel* _tmp53_;
		GtkGrid* _tmp54_;
		GtkSwitch* _tmp55_;
		GtkBox* _tmp56_;
		GtkGrid* _tmp57_;
		GtkSizeGroup* _tmp58_;
		GtkLabel* _tmp59_;
		GtkSizeGroup* _tmp60_;
		GtkLabel* _tmp61_;
		_tmp26_ = (GtkSwitch*) gtk_switch_new ();
		gtk_widget_set_halign ((GtkWidget*) _tmp26_, GTK_ALIGN_END);
		g_object_ref_sink (_tmp26_);
		als_switch = _tmp26_;
		_tmp27_ = als_switch;
		_tmp28_ = _g_object_ref0 ((GtkWidget*) _tmp27_);
		_tmp29_ = (GtkLabel*) gtk_label_new (_ ("Automatically Adjust Brightness"));
		gtk_label_set_mnemonic_widget (_tmp29_, _tmp28_);
		_g_object_unref0 (_tmp28_);
		gtk_label_set_xalign (_tmp29_, (gfloat) 0);
		g_object_ref_sink (_tmp29_);
		als_label = _tmp29_;
		_tmp30_ = power_settings;
		_tmp31_ = als_switch;
		g_settings_bind (_tmp30_, "ambient-enabled", (GObject*) _tmp31_, "active", G_SETTINGS_BIND_DEFAULT);
		_tmp32_ = (GtkEventControllerLegacy*) gtk_event_controller_legacy_new ();
		scale_scroll_controller = _tmp32_;
		_tmp33_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 0, (gdouble) 100, (gdouble) 10);
		gtk_widget_set_hexpand ((GtkWidget*) _tmp33_, TRUE);
		g_object_ref_sink (_tmp33_);
		_g_object_unref0 (self->priv->scale);
		self->priv->scale = _tmp33_;
		_tmp34_ = self->priv->scale;
		_tmp35_ = scale_scroll_controller;
		_tmp36_ = _g_object_ref0 ((GtkEventController*) _tmp35_);
		gtk_widget_add_controller ((GtkWidget*) _tmp34_, _tmp36_);
		_tmp37_ = scale_scroll_controller;
		g_signal_connect_object (_tmp37_, "event", (GCallback) __power_main_view____lambda9__gtk_event_controller_legacy_event, self, 0);
		_tmp38_ = self->priv->scale;
		_tmp39_ = self->priv->screen;
		_tmp40_ = power_power_settings_get_brightness (_tmp39_);
		_tmp41_ = _tmp40_;
		gtk_range_set_value ((GtkRange*) _tmp38_, (gdouble) _tmp41_);
		_tmp42_ = self->priv->scale;
		g_signal_connect_object ((GtkRange*) _tmp42_, "value-changed", (GCallback) _power_main_view_on_scale_value_changed_gtk_range_value_changed, self, 0);
		_tmp43_ = self->priv->screen;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) _power_main_view_on_screen_properties_changed_g_dbus_proxy_g_properties_changed, self, 0);
		_tmp44_ = self->priv->scale;
		_tmp45_ = _g_object_ref0 ((GtkWidget*) _tmp44_);
		_tmp46_ = (GtkLabel*) gtk_label_new (_ ("Display Brightness"));
		gtk_label_set_mnemonic_widget (_tmp46_, _tmp45_);
		_g_object_unref0 (_tmp45_);
		gtk_label_set_xalign (_tmp46_, (gfloat) 0);
		g_object_ref_sink (_tmp46_);
		brightness_label = _tmp46_;
		_tmp47_ = (GtkGrid*) gtk_grid_new ();
		gtk_grid_set_column_spacing (_tmp47_, 12);
		gtk_grid_set_row_spacing (_tmp47_, 12);
		g_object_ref_sink (_tmp47_);
		brightness_grid = _tmp47_;
		_tmp48_ = brightness_grid;
		_tmp49_ = brightness_label;
		gtk_grid_attach (_tmp48_, (GtkWidget*) _tmp49_, 0, 0, 1, 1);
		_tmp50_ = brightness_grid;
		_tmp51_ = self->priv->scale;
		gtk_grid_attach (_tmp50_, (GtkWidget*) _tmp51_, 1, 0, 1, 1);
		_tmp52_ = brightness_grid;
		_tmp53_ = als_label;
		gtk_grid_attach (_tmp52_, (GtkWidget*) _tmp53_, 0, 1, 1, 1);
		_tmp54_ = brightness_grid;
		_tmp55_ = als_switch;
		gtk_grid_attach (_tmp54_, (GtkWidget*) _tmp55_, 1, 1, 1, 1);
		_tmp56_ = box;
		_tmp57_ = brightness_grid;
		gtk_box_append (_tmp56_, (GtkWidget*) _tmp57_);
		_tmp58_ = label_size;
		_tmp59_ = brightness_label;
		gtk_size_group_add_widget (_tmp58_, (GtkWidget*) _tmp59_);
		_tmp60_ = label_size;
		_tmp61_ = als_label;
		gtk_size_group_add_widget (_tmp60_, (GtkWidget*) _tmp61_);
		_g_object_unref0 (brightness_grid);
		_g_object_unref0 (brightness_label);
		_g_object_unref0 (scale_scroll_controller);
		_g_object_unref0 (als_label);
		_g_object_unref0 (als_switch);
	}
	_tmp62_ = power_manager;
	if (power_power_manager_has_lid (_tmp62_)) {
		Block1Data* _data1_;
		GtkLabel* infobar_label = NULL;
		GtkLabel* _tmp63_;
		GtkInfoBar* _tmp64_ = NULL;
		GtkInfoBar* _tmp65_;
		GtkLabel* _tmp66_;
		GtkInfoBar* _tmp67_;
		GtkLabel* lid_closed_label = NULL;
		GtkLabel* _tmp68_ = NULL;
		PowerLidCloseActionComboBox* lid_closed_box = NULL;
		PowerLidCloseActionComboBox* _tmp69_ = NULL;
		GtkLabel* lid_dock_label = NULL;
		GtkLabel* _tmp70_ = NULL;
		PowerLidCloseActionComboBox* lid_dock_box = NULL;
		PowerLidCloseActionComboBox* _tmp71_ = NULL;
		GtkSizeGroup* _tmp72_;
		GtkLabel* _tmp73_;
		GtkSizeGroup* _tmp74_;
		GtkLabel* _tmp75_;
		GtkGrid* lid_close_grid = NULL;
		GtkGrid* _tmp76_ = NULL;
		GtkGrid* _tmp77_;
		GtkLabel* _tmp78_;
		GtkGrid* _tmp79_;
		PowerLidCloseActionComboBox* _tmp80_;
		GtkGrid* _tmp81_;
		GtkLabel* _tmp82_;
		GtkGrid* _tmp83_;
		PowerLidCloseActionComboBox* _tmp84_;
		GtkGrid* _tmp85_;
		GtkInfoBar* _tmp86_;
		GtkBox* _tmp87_;
		GtkGrid* _tmp88_;
		PowerLogindHelperIface* helper = NULL;
		PowerLogindHelperIface* _tmp89_;
		PowerLogindHelperIface* _tmp90_;
		PowerLogindHelperIface* _tmp91_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = g_object_ref (self);
		_tmp63_ = (GtkLabel*) gtk_label_new (_ ("Some changes will not take effect until you restart this computer"));
		g_object_ref_sink (_tmp63_);
		infobar_label = _tmp63_;
		_tmp64_ = (GtkInfoBar*) gtk_info_bar_new ();
		gtk_info_bar_set_message_type (_tmp64_, GTK_MESSAGE_WARNING);
		gtk_info_bar_set_revealed (_tmp64_, FALSE);
		g_object_ref_sink (_tmp64_);
		_data1_->infobar = _tmp64_;
		_tmp65_ = _data1_->infobar;
		_tmp66_ = infobar_label;
		gtk_info_bar_add_child (_tmp65_, (GtkWidget*) _tmp66_);
		_tmp67_ = _data1_->infobar;
		gtk_widget_add_css_class ((GtkWidget*) _tmp67_, GRANITE_STYLE_CLASS_FRAME);
		_tmp68_ = (GtkLabel*) gtk_label_new (_ ("Lid Close Behavior"));
		gtk_label_set_xalign (_tmp68_, (gfloat) 0);
		g_object_ref_sink (_tmp68_);
		lid_closed_label = _tmp68_;
		_tmp69_ = power_lid_close_action_combo_box_new (FALSE);
		gtk_widget_set_hexpand ((GtkWidget*) _tmp69_, TRUE);
		g_object_ref_sink (_tmp69_);
		lid_closed_box = _tmp69_;
		_tmp70_ = (GtkLabel*) gtk_label_new (_ ("Lid Close With External Display"));
		gtk_label_set_xalign (_tmp70_, (gfloat) 0);
		g_object_ref_sink (_tmp70_);
		lid_dock_label = _tmp70_;
		_tmp71_ = power_lid_close_action_combo_box_new (TRUE);
		gtk_widget_set_hexpand ((GtkWidget*) _tmp71_, TRUE);
		g_object_ref_sink (_tmp71_);
		lid_dock_box = _tmp71_;
		_tmp72_ = label_size;
		_tmp73_ = lid_closed_label;
		gtk_size_group_add_widget (_tmp72_, (GtkWidget*) _tmp73_);
		_tmp74_ = label_size;
		_tmp75_ = lid_dock_label;
		gtk_size_group_add_widget (_tmp74_, (GtkWidget*) _tmp75_);
		_tmp76_ = (GtkGrid*) gtk_grid_new ();
		gtk_grid_set_row_spacing (_tmp76_, 12);
		gtk_grid_set_column_spacing (_tmp76_, 12);
		g_object_ref_sink (_tmp76_);
		lid_close_grid = _tmp76_;
		_tmp77_ = lid_close_grid;
		_tmp78_ = lid_closed_label;
		gtk_grid_attach (_tmp77_, (GtkWidget*) _tmp78_, 0, 0, 1, 1);
		_tmp79_ = lid_close_grid;
		_tmp80_ = lid_closed_box;
		gtk_grid_attach (_tmp79_, (GtkWidget*) _tmp80_, 1, 0, 1, 1);
		_tmp81_ = lid_close_grid;
		_tmp82_ = lid_dock_label;
		gtk_grid_attach (_tmp81_, (GtkWidget*) _tmp82_, 0, 1, 1, 1);
		_tmp83_ = lid_close_grid;
		_tmp84_ = lid_dock_box;
		gtk_grid_attach (_tmp83_, (GtkWidget*) _tmp84_, 1, 1, 1, 1);
		_tmp85_ = lid_close_grid;
		_tmp86_ = _data1_->infobar;
		gtk_grid_attach (_tmp85_, (GtkWidget*) _tmp86_, 0, 2, 2, 1);
		_tmp87_ = box;
		_tmp88_ = lid_close_grid;
		gtk_box_append (_tmp87_, (GtkWidget*) _tmp88_);
		_tmp89_ = power_logind_helper_get_logind_helper ();
		_tmp90_ = _g_object_ref0 (_tmp89_);
		helper = _tmp90_;
		_tmp91_ = helper;
		if (_tmp91_ != NULL) {
			PowerLogindHelperIface* _tmp92_;
			_tmp92_ = helper;
			g_signal_connect_data (_tmp92_, "changed", (GCallback) __power_main_view_____lambda11__power_logind_helper_iface_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		}
		_g_object_unref0 (helper);
		_g_object_unref0 (lid_close_grid);
		_g_object_unref0 (lid_dock_box);
		_g_object_unref0 (lid_dock_label);
		_g_object_unref0 (lid_closed_box);
		_g_object_unref0 (lid_closed_label);
		_g_object_unref0 (infobar_label);
		block1_data_unref (_data1_);
		_data1_ = NULL;
	}
	_tmp93_ = (GtkLabel*) gtk_label_new (_ ("Automatic Display Off"));
	gtk_label_set_xalign (_tmp93_, (gfloat) 0);
	g_object_ref_sink (_tmp93_);
	screen_timeout_label = _tmp93_;
	_tmp94_ = g_settings_new ("org.gnome.desktop.session");
	_tmp95_ = _tmp94_;
	_tmp96_ = power_timeout_combo_box_new (_tmp95_, "idle-delay");
	gtk_widget_set_hexpand ((GtkWidget*) _tmp96_, TRUE);
	g_object_ref_sink (_tmp96_);
	_tmp97_ = _tmp96_;
	_g_object_unref0 (_tmp95_);
	screen_timeout = _tmp97_;
	_tmp98_ = g_strdup (_ ("Do nothing"));
	_tmp99_ = g_strdup (_ ("Suspend"));
	_tmp100_ = g_strdup (_ ("Ask to shutdown"));
	_tmp101_ = g_new0 (gchar*, 3 + 1);
	_tmp101_[0] = _tmp98_;
	_tmp101_[1] = _tmp99_;
	_tmp101_[2] = _tmp100_;
	_tmp102_ = _tmp101_;
	_tmp102__length1 = 3;
	_tmp103_ = (GtkDropDown*) gtk_drop_down_new_from_strings (_tmp102_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp103_, TRUE);
	g_object_ref_sink (_tmp103_);
	_g_object_unref0 (self->priv->powerbutton_dropdown);
	self->priv->powerbutton_dropdown = _tmp103_;
	_tmp102_ = (_vala_array_free (_tmp102_, _tmp102__length1, (GDestroyNotify) g_free), NULL);
	_tmp104_ = self->priv->powerbutton_dropdown;
	_tmp105_ = _g_object_ref0 ((GtkWidget*) _tmp104_);
	_tmp106_ = (GtkLabel*) gtk_label_new (_ ("Power Button Behavior"));
	gtk_label_set_mnemonic_widget (_tmp106_, _tmp105_);
	_g_object_unref0 (_tmp105_);
	gtk_label_set_xalign (_tmp106_, (gfloat) 0);
	g_object_ref_sink (_tmp106_);
	powerbutton_label = _tmp106_;
	_tmp107_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp107_, 12);
	gtk_grid_set_row_spacing (_tmp107_, 12);
	g_object_ref_sink (_tmp107_);
	main_grid = _tmp107_;
	_tmp108_ = main_grid;
	_tmp109_ = screen_timeout_label;
	gtk_grid_attach (_tmp108_, (GtkWidget*) _tmp109_, 0, 4, 1, 1);
	_tmp110_ = main_grid;
	_tmp111_ = screen_timeout;
	gtk_grid_attach (_tmp110_, (GtkWidget*) _tmp111_, 1, 4, 1, 1);
	_tmp112_ = main_grid;
	_tmp113_ = powerbutton_label;
	gtk_grid_attach (_tmp112_, (GtkWidget*) _tmp113_, 0, 5, 1, 1);
	_tmp114_ = main_grid;
	_tmp115_ = self->priv->powerbutton_dropdown;
	gtk_grid_attach (_tmp114_, (GtkWidget*) _tmp115_, 1, 5, 1, 1);
	_tmp116_ = (GtkLabel*) gtk_label_new (_ ("Suspend When Inactive For"));
	gtk_label_set_xalign (_tmp116_, (gfloat) 0);
	g_object_ref_sink (_tmp116_);
	sleep_timeout_label = _tmp116_;
	_tmp117_ = power_settings;
	_tmp118_ = g_strdup ("sleep-inactive-ac-type");
	_tmp119_ = power_timeout_combo_box_new (_tmp117_, "sleep-inactive-ac-timeout");
	power_timeout_combo_box_set_enum_property (_tmp119_, _tmp118_);
	_g_free0 (_tmp118_);
	power_timeout_combo_box_set_enum_never_value (_tmp119_, (gint) POWER_MAIN_VIEW_POWER_ACTION_TYPE_NOTHING);
	power_timeout_combo_box_set_enum_normal_value (_tmp119_, (gint) POWER_MAIN_VIEW_POWER_ACTION_TYPE_SUSPEND);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp119_, TRUE);
	g_object_ref_sink (_tmp119_);
	sleep_timeout = _tmp119_;
	_tmp120_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp120_, 12);
	gtk_grid_set_row_spacing (_tmp120_, 12);
	g_object_ref_sink (_tmp120_);
	ac_grid = _tmp120_;
	_tmp121_ = ac_grid;
	_tmp122_ = sleep_timeout_label;
	gtk_grid_attach (_tmp121_, (GtkWidget*) _tmp122_, 0, 0, 1, 1);
	_tmp123_ = ac_grid;
	_tmp124_ = sleep_timeout;
	gtk_grid_attach (_tmp123_, (GtkWidget*) _tmp124_, 1, 0, 1, 1);
	_tmp125_ = power_power_mode_button_new (FALSE);
	g_object_ref_sink (_tmp125_);
	power_mode_button = _tmp125_;
	_tmp126_ = power_power_mode_button_get_successfully_initialized ();
	_tmp127_ = _tmp126_;
	if (_tmp127_) {
		GtkGrid* _tmp128_;
		PowerPowerModeButton* _tmp129_;
		_tmp128_ = ac_grid;
		_tmp129_ = power_mode_button;
		gtk_grid_attach (_tmp128_, (GtkWidget*) _tmp129_, 0, 1, 2, 1);
	}
	_tmp130_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp130_);
	_tmp131_ = _tmp130_;
	power_main_view_set_stack (self, _tmp131_);
	_g_object_unref0 (_tmp131_);
	_tmp132_ = self->priv->_stack;
	_tmp133_ = ac_grid;
	gtk_stack_add_titled (_tmp132_, (GtkWidget*) _tmp133_, "ac", _ ("Plugged In"));
	_tmp134_ = self->priv->_stack;
	_tmp135_ = _g_object_ref0 (_tmp134_);
	_tmp136_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
	gtk_stack_switcher_set_stack (_tmp136_, _tmp135_);
	_g_object_unref0 (_tmp135_);
	g_object_ref_sink (_tmp136_);
	stack_switcher = _tmp136_;
	_tmp137_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	size_group = _tmp137_;
	_tmp138_ = size_group;
	_tmp139_ = gtk_size_group_get_widgets (_tmp138_);
	if (g_slist_length (_tmp139_) == ((guint) 0)) {
		GListModel* children = NULL;
		GtkStackSwitcher* _tmp140_;
		GListModel* _tmp141_;
		_tmp140_ = stack_switcher;
		_tmp141_ = gtk_widget_observe_children ((GtkWidget*) _tmp140_);
		children = _tmp141_;
		{
			gint index = 0;
			index = 0;
			{
				gboolean _tmp142_ = FALSE;
				_tmp142_ = TRUE;
				while (TRUE) {
					GListModel* _tmp144_;
					GtkSizeGroup* _tmp145_;
					GListModel* _tmp146_;
					GObject* _tmp147_;
					GtkToggleButton* _tmp148_;
					if (!_tmp142_) {
						gint _tmp143_;
						_tmp143_ = index;
						index = _tmp143_ + 1;
					}
					_tmp142_ = FALSE;
					_tmp144_ = children;
					if (!(((guint) index) < g_list_model_get_n_items (_tmp144_))) {
						break;
					}
					_tmp145_ = size_group;
					_tmp146_ = children;
					_tmp147_ = g_list_model_get_item (_tmp146_, (guint) index);
					_tmp148_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, gtk_toggle_button_get_type (), GtkToggleButton);
					gtk_size_group_add_widget (_tmp145_, (GtkWidget*) _tmp148_);
					_g_object_unref0 (_tmp148_);
				}
			}
		}
		_g_object_unref0 (children);
	}
	_tmp149_ = power_manager;
	_tmp150_ = power_power_manager_get_batteries (_tmp149_);
	_tmp151_ = _tmp150_;
	g_object_get (_tmp151_, "n-items", &_tmp152_, NULL);
	_tmp153_ = _tmp152_;
	if (_tmp153_ > ((guint) 0)) {
		GtkLabel* battery_timeout_label = NULL;
		GtkLabel* _tmp154_ = NULL;
		GtkSizeGroup* _tmp155_;
		GtkLabel* _tmp156_;
		PowerTimeoutComboBox* battery_timeout = NULL;
		GSettings* _tmp157_;
		gchar* _tmp158_;
		PowerTimeoutComboBox* _tmp159_ = NULL;
		GtkGrid* battery_grid = NULL;
		GtkGrid* _tmp160_ = NULL;
		GtkGrid* _tmp161_;
		GtkLabel* _tmp162_;
		GtkGrid* _tmp163_;
		PowerTimeoutComboBox* _tmp164_;
		PowerPowerModeButton* battery_power_mode_button = NULL;
		PowerPowerModeButton* _tmp165_;
		gboolean _tmp166_;
		gboolean _tmp167_;
		GtkSwitch* auto_low_power_switch = NULL;
		GtkSwitch* _tmp170_ = NULL;
		GSettings* _tmp171_;
		GtkSwitch* _tmp172_;
		GraniteHeaderLabel* auto_low_power_label = NULL;
		GtkSwitch* _tmp173_;
		GtkWidget* _tmp174_;
		gchar* _tmp175_;
		GraniteHeaderLabel* _tmp176_ = NULL;
		GtkBox* auto_low_power_box = NULL;
		GtkBox* _tmp177_;
		GtkBox* _tmp178_;
		GraniteHeaderLabel* _tmp179_;
		GtkBox* _tmp180_;
		GtkSwitch* _tmp181_;
		GtkGrid* _tmp182_;
		GtkBox* _tmp183_;
		GtkStack* _tmp184_;
		GtkGrid* _tmp185_;
		GtkSeparator* left_sep = NULL;
		GtkSeparator* _tmp186_ = NULL;
		GtkSeparator* right_sep = NULL;
		GtkSeparator* _tmp187_ = NULL;
		GtkBox* switcher_box = NULL;
		GtkBox* _tmp188_ = NULL;
		GtkBox* _tmp189_;
		GtkSeparator* _tmp190_;
		GtkBox* _tmp191_;
		GtkStackSwitcher* _tmp192_;
		GtkBox* _tmp193_;
		GtkSeparator* _tmp194_;
		GtkGrid* _tmp195_;
		GtkBox* _tmp196_;
		_tmp154_ = (GtkLabel*) gtk_label_new (_ ("Suspend When Inactive For"));
		gtk_label_set_xalign (_tmp154_, (gfloat) 0);
		g_object_ref_sink (_tmp154_);
		battery_timeout_label = _tmp154_;
		_tmp155_ = label_size;
		_tmp156_ = battery_timeout_label;
		gtk_size_group_add_widget (_tmp155_, (GtkWidget*) _tmp156_);
		_tmp157_ = power_settings;
		_tmp158_ = g_strdup ("sleep-inactive-battery-type");
		_tmp159_ = power_timeout_combo_box_new (_tmp157_, "sleep-inactive-battery-timeout");
		power_timeout_combo_box_set_enum_property (_tmp159_, _tmp158_);
		_g_free0 (_tmp158_);
		power_timeout_combo_box_set_enum_never_value (_tmp159_, (gint) POWER_MAIN_VIEW_POWER_ACTION_TYPE_NOTHING);
		power_timeout_combo_box_set_enum_normal_value (_tmp159_, (gint) POWER_MAIN_VIEW_POWER_ACTION_TYPE_SUSPEND);
		gtk_widget_set_hexpand ((GtkWidget*) _tmp159_, TRUE);
		g_object_ref_sink (_tmp159_);
		battery_timeout = _tmp159_;
		_tmp160_ = (GtkGrid*) gtk_grid_new ();
		gtk_grid_set_column_spacing (_tmp160_, 12);
		gtk_grid_set_row_spacing (_tmp160_, 12);
		g_object_ref_sink (_tmp160_);
		battery_grid = _tmp160_;
		_tmp161_ = battery_grid;
		_tmp162_ = battery_timeout_label;
		gtk_grid_attach (_tmp161_, (GtkWidget*) _tmp162_, 0, 0, 1, 1);
		_tmp163_ = battery_grid;
		_tmp164_ = battery_timeout;
		gtk_grid_attach (_tmp163_, (GtkWidget*) _tmp164_, 1, 0, 1, 1);
		_tmp165_ = power_power_mode_button_new (TRUE);
		g_object_ref_sink (_tmp165_);
		battery_power_mode_button = _tmp165_;
		_tmp166_ = power_power_mode_button_get_successfully_initialized ();
		_tmp167_ = _tmp166_;
		if (_tmp167_) {
			GtkGrid* _tmp168_;
			PowerPowerModeButton* _tmp169_;
			_tmp168_ = battery_grid;
			_tmp169_ = battery_power_mode_button;
			gtk_grid_attach (_tmp168_, (GtkWidget*) _tmp169_, 0, 1, 2, 1);
		}
		_tmp170_ = (GtkSwitch*) gtk_switch_new ();
		gtk_widget_set_halign ((GtkWidget*) _tmp170_, GTK_ALIGN_END);
		gtk_widget_set_valign ((GtkWidget*) _tmp170_, GTK_ALIGN_CENTER);
		g_object_ref_sink (_tmp170_);
		auto_low_power_switch = _tmp170_;
		_tmp171_ = power_settings;
		_tmp172_ = auto_low_power_switch;
		g_settings_bind (_tmp171_, "power-saver-profile-on-low-battery", (GObject*) _tmp172_, "active", G_SETTINGS_BIND_DEFAULT);
		_tmp173_ = auto_low_power_switch;
		_tmp174_ = _g_object_ref0 ((GtkWidget*) _tmp173_);
		_tmp175_ = g_strdup (_ ("Power Saver mode will be used when battery is low"));
		_tmp176_ = granite_header_label_new (_ ("Automatically Save Power"));
		gtk_widget_set_hexpand ((GtkWidget*) _tmp176_, TRUE);
		granite_header_label_set_mnemonic_widget (_tmp176_, _tmp174_);
		_g_object_unref0 (_tmp174_);
		granite_header_label_set_secondary_text (_tmp176_, _tmp175_);
		_g_free0 (_tmp175_);
		g_object_ref_sink (_tmp176_);
		auto_low_power_label = _tmp176_;
		_tmp177_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
		g_object_ref_sink (_tmp177_);
		auto_low_power_box = _tmp177_;
		_tmp178_ = auto_low_power_box;
		_tmp179_ = auto_low_power_label;
		gtk_box_append (_tmp178_, (GtkWidget*) _tmp179_);
		_tmp180_ = auto_low_power_box;
		_tmp181_ = auto_low_power_switch;
		gtk_box_append (_tmp180_, (GtkWidget*) _tmp181_);
		_tmp182_ = battery_grid;
		_tmp183_ = auto_low_power_box;
		gtk_grid_attach (_tmp182_, (GtkWidget*) _tmp183_, 0, 3, 2, 1);
		_tmp184_ = self->priv->_stack;
		_tmp185_ = battery_grid;
		gtk_stack_add_titled (_tmp184_, (GtkWidget*) _tmp185_, "battery", _ ("On Battery"));
		_tmp186_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		gtk_widget_set_hexpand ((GtkWidget*) _tmp186_, TRUE);
		gtk_widget_set_valign ((GtkWidget*) _tmp186_, GTK_ALIGN_CENTER);
		g_object_ref_sink (_tmp186_);
		left_sep = _tmp186_;
		_tmp187_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		gtk_widget_set_hexpand ((GtkWidget*) _tmp187_, TRUE);
		gtk_widget_set_valign ((GtkWidget*) _tmp187_, GTK_ALIGN_CENTER);
		g_object_ref_sink (_tmp187_);
		right_sep = _tmp187_;
		_tmp188_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		gtk_widget_set_margin_top ((GtkWidget*) _tmp188_, 24);
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp188_, 12);
		g_object_ref_sink (_tmp188_);
		switcher_box = _tmp188_;
		_tmp189_ = switcher_box;
		_tmp190_ = left_sep;
		gtk_box_append (_tmp189_, (GtkWidget*) _tmp190_);
		_tmp191_ = switcher_box;
		_tmp192_ = stack_switcher;
		gtk_box_append (_tmp191_, (GtkWidget*) _tmp192_);
		_tmp193_ = switcher_box;
		_tmp194_ = right_sep;
		gtk_box_append (_tmp193_, (GtkWidget*) _tmp194_);
		_tmp195_ = main_grid;
		_tmp196_ = switcher_box;
		gtk_grid_attach (_tmp195_, (GtkWidget*) _tmp196_, 0, 8, 2, 1);
		_g_object_unref0 (switcher_box);
		_g_object_unref0 (right_sep);
		_g_object_unref0 (left_sep);
		_g_object_unref0 (auto_low_power_box);
		_g_object_unref0 (auto_low_power_label);
		_g_object_unref0 (auto_low_power_switch);
		_g_object_unref0 (battery_power_mode_button);
		_g_object_unref0 (battery_grid);
		_g_object_unref0 (battery_timeout);
		_g_object_unref0 (battery_timeout_label);
	}
	_tmp197_ = main_grid;
	_tmp198_ = self->priv->_stack;
	gtk_grid_attach (_tmp197_, (GtkWidget*) _tmp198_, 0, 9, 2, 1);
	_tmp199_ = box;
	_tmp200_ = main_grid;
	gtk_box_append (_tmp199_, (GtkWidget*) _tmp200_);
	_tmp201_ = box;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp201_);
	_tmp202_ = label_size;
	_tmp203_ = sleep_timeout_label;
	gtk_size_group_add_widget (_tmp202_, (GtkWidget*) _tmp203_);
	_tmp204_ = label_size;
	_tmp205_ = screen_timeout_label;
	gtk_size_group_add_widget (_tmp204_, (GtkWidget*) _tmp205_);
	_tmp206_ = label_size;
	_tmp207_ = powerbutton_label;
	gtk_size_group_add_widget (_tmp206_, (GtkWidget*) _tmp207_);
	_tmp208_ = stack_switcher;
	_tmp209_ = self->priv->_stack;
	_tmp210_ = gtk_widget_observe_children ((GtkWidget*) _tmp209_);
	_tmp211_ = _tmp210_;
	gtk_widget_set_visible ((GtkWidget*) _tmp208_, g_list_model_get_n_items (_tmp211_) > ((guint) 1));
	_g_object_unref0 (_tmp211_);
	power_main_view_update_powerbutton_dropdown (self);
	_tmp212_ = power_settings;
	g_signal_connect_object (_tmp212_, "changed::power-button-action", (GCallback) _power_main_view_update_powerbutton_dropdown_g_settings_changed, self, 0);
	_tmp213_ = self->priv->powerbutton_dropdown;
	g_signal_connect_object ((GObject*) _tmp213_, "notify::selected", (GCallback) __power_main_view___lambda15__g_object_notify, self, 0);
	_g_object_unref0 (size_group);
	_g_object_unref0 (stack_switcher);
	_g_object_unref0 (power_mode_button);
	_g_object_unref0 (ac_grid);
	_g_object_unref0 (sleep_timeout);
	_g_object_unref0 (sleep_timeout_label);
	_g_object_unref0 (main_grid);
	_g_object_unref0 (powerbutton_label);
	_g_object_unref0 (screen_timeout);
	_g_object_unref0 (screen_timeout_label);
	_g_object_unref0 (devices_box);
	_g_object_unref0 (box);
	_g_object_unref0 (power_manager);
	_g_object_unref0 (label_size);
	_g_object_unref0 (mouse_settings);
	_g_object_unref0 (touchpad_settings);
	return obj;
}

static void
power_main_view_class_init (PowerMainViewClass * klass,
                            gpointer klass_data)
{
	power_main_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PowerMainView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_power_main_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_power_main_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = power_main_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = power_main_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_MAIN_VIEW_STACK_PROPERTY, power_main_view_properties[POWER_MAIN_VIEW_STACK_PROPERTY] = g_param_spec_object ("stack", "stack", "stack", gtk_stack_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_MAIN_VIEW_NATURAL_SCROLL_TOUCHPAD_PROPERTY, power_main_view_properties[POWER_MAIN_VIEW_NATURAL_SCROLL_TOUCHPAD_PROPERTY] = g_param_spec_boolean ("natural-scroll-touchpad", "natural-scroll-touchpad", "natural-scroll-touchpad", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_MAIN_VIEW_NATURAL_SCROLL_MOUSE_PROPERTY, power_main_view_properties[POWER_MAIN_VIEW_NATURAL_SCROLL_MOUSE_PROPERTY] = g_param_spec_boolean ("natural-scroll-mouse", "natural-scroll-mouse", "natural-scroll-mouse", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
power_main_view_instance_init (PowerMainView * self,
                               gpointer klass)
{
	self->priv = power_main_view_get_instance_private (self);
	self->priv->total_x_delta = (gdouble) 0;
	self->priv->total_y_delta = (gdouble) 0;
}

static void
power_main_view_finalize (GObject * obj)
{
	PowerMainView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_TYPE_MAIN_VIEW, PowerMainView);
	_g_object_unref0 (self->priv->_stack);
	_g_object_unref0 (self->priv->powerbutton_dropdown);
	_g_object_unref0 (self->priv->scale);
	_g_object_unref0 (self->priv->screen);
	G_OBJECT_CLASS (power_main_view_parent_class)->finalize (obj);
}

static GType
power_main_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerMainViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_main_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerMainView), 0, (GInstanceInitFunc) power_main_view_instance_init, NULL };
	GType power_main_view_type_id;
	power_main_view_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "PowerMainView", &g_define_type_info, 0);
	PowerMainView_private_offset = g_type_add_instance_private (power_main_view_type_id, sizeof (PowerMainViewPrivate));
	return power_main_view_type_id;
}

GType
power_main_view_get_type (void)
{
	static volatile gsize power_main_view_type_id__once = 0;
	if (g_once_init_enter (&power_main_view_type_id__once)) {
		GType power_main_view_type_id;
		power_main_view_type_id = power_main_view_get_type_once ();
		g_once_init_leave (&power_main_view_type_id__once, power_main_view_type_id);
	}
	return power_main_view_type_id__once;
}

static void
_vala_power_main_view_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	PowerMainView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_TYPE_MAIN_VIEW, PowerMainView);
	switch (property_id) {
		case POWER_MAIN_VIEW_STACK_PROPERTY:
		g_value_set_object (value, power_main_view_get_stack (self));
		break;
		case POWER_MAIN_VIEW_NATURAL_SCROLL_TOUCHPAD_PROPERTY:
		g_value_set_boolean (value, power_main_view_get_natural_scroll_touchpad (self));
		break;
		case POWER_MAIN_VIEW_NATURAL_SCROLL_MOUSE_PROPERTY:
		g_value_set_boolean (value, power_main_view_get_natural_scroll_mouse (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_power_main_view_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	PowerMainView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_TYPE_MAIN_VIEW, PowerMainView);
	switch (property_id) {
		case POWER_MAIN_VIEW_STACK_PROPERTY:
		power_main_view_set_stack (self, g_value_get_object (value));
		break;
		case POWER_MAIN_VIEW_NATURAL_SCROLL_TOUCHPAD_PROPERTY:
		power_main_view_set_natural_scroll_touchpad (self, g_value_get_boolean (value));
		break;
		case POWER_MAIN_VIEW_NATURAL_SCROLL_MOUSE_PROPERTY:
		power_main_view_set_natural_scroll_mouse (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

