/* Multitasking.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Multitasking.vala, do not modify */

/*
* Copyright 2011-2019 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Tom Beckmann
*/

#include "desktop.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <granite-7.h>
#include <switchboard.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PANTHEON_SHELL_MULTITASKING_0_PROPERTY,
	PANTHEON_SHELL_MULTITASKING_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_multitasking_properties[PANTHEON_SHELL_MULTITASKING_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL (pantheon_shell_multitasking_hotcorner_control_get_type ())
#define PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControl))
#define PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControlClass))
#define PANTHEON_SHELL_MULTITASKING_IS_HOTCORNER_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL))
#define PANTHEON_SHELL_MULTITASKING_IS_HOTCORNER_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL))
#define PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControlClass))

typedef struct _PantheonShellMultitaskingHotcornerControl PantheonShellMultitaskingHotcornerControl;
typedef struct _PantheonShellMultitaskingHotcornerControlClass PantheonShellMultitaskingHotcornerControlClass;
typedef struct _PantheonShellMultitaskingHotcornerControlPrivate PantheonShellMultitaskingHotcornerControlPrivate;
enum  {
	PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_0_PROPERTY,
	PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_LABEL_PROPERTY,
	PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_POSITION_PROPERTY,
	PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_multitasking_hotcorner_control_properties[PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _PantheonShellMultitaskingPrivate {
	GSettings* behavior_settings;
};

struct _PantheonShellMultitaskingHotcornerControl {
	GtkGrid parent_instance;
	PantheonShellMultitaskingHotcornerControlPrivate * priv;
};

struct _PantheonShellMultitaskingHotcornerControlClass {
	GtkGridClass parent_class;
};

struct _PantheonShellMultitaskingHotcornerControlPrivate {
	gchar* _label;
	gchar* _position;
	GtkEntry* command_entry;
};

static gint PantheonShellMultitasking_private_offset;
static gpointer pantheon_shell_multitasking_parent_class = NULL;
static gint PantheonShellMultitaskingHotcornerControl_private_offset;
static gpointer pantheon_shell_multitasking_hotcorner_control_parent_class = NULL;
static GSettings* pantheon_shell_multitasking_hotcorner_control_settings;
static GSettings* pantheon_shell_multitasking_hotcorner_control_settings = NULL;
static GtkSizeGroup* pantheon_shell_multitasking_hotcorner_control_size_group;
static GtkSizeGroup* pantheon_shell_multitasking_hotcorner_control_size_group = NULL;

static GType pantheon_shell_multitasking_hotcorner_control_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PantheonShellMultitaskingHotcornerControl* pantheon_shell_multitasking_hotcorner_control_new (const gchar* label,
                                                                                              const gchar* position);
static PantheonShellMultitaskingHotcornerControl* pantheon_shell_multitasking_hotcorner_control_construct (GType object_type,
                                                                                                    const gchar* label,
                                                                                                    const gchar* position);
static const gchar* pantheon_shell_multitasking_hotcorner_control_get_label (PantheonShellMultitaskingHotcornerControl* self);
static void pantheon_shell_multitasking_hotcorner_control_set_label (PantheonShellMultitaskingHotcornerControl* self,
                                                              const gchar* value);
static const gchar* pantheon_shell_multitasking_hotcorner_control_get_position (PantheonShellMultitaskingHotcornerControl* self);
static void pantheon_shell_multitasking_hotcorner_control_set_position (PantheonShellMultitaskingHotcornerControl* self,
                                                                 const gchar* value);
static GObject * pantheon_shell_multitasking_hotcorner_control_constructor (GType type,
                                                                     guint n_construct_properties,
                                                                     GObjectConstructParam * construct_properties);
static gboolean _pantheon_shell_multitasking_hotcorner_control___lambda31_ (GValue* value,
                                                                     GVariant* variant,
                                                                     void* user_data);
static gboolean __pantheon_shell_multitasking_hotcorner_control___lambda31__gsettings_bind_get_mapping (GValue* value,
                                                                                                 GVariant* variant,
                                                                                                 void* user_data);
static GVariant* _pantheon_shell_multitasking_hotcorner_control___lambda32_ (GValue* value,
                                                                      const GVariantType* expected_type,
                                                                      void* user_data);
static GVariant* __pantheon_shell_multitasking_hotcorner_control___lambda32__gsettings_bind_set_mapping (GValue* value,
                                                                                                  const GVariantType* expected_type,
                                                                                                  void* user_data);
static gboolean _pantheon_shell_multitasking_hotcorner_control___lambda33_ (GValue* value,
                                                                     GVariant* variant,
                                                                     void* instance);
static gchar* _variant_get1 (GVariant* value);
static gboolean __pantheon_shell_multitasking_hotcorner_control___lambda33__gsettings_bind_get_mapping (GValue* value,
                                                                                                 GVariant* variant,
                                                                                                 void* user_data);
static GVariant* _pantheon_shell_multitasking_hotcorner_control___lambda34_ (GValue* value,
                                                                      const GVariantType* expected_type,
                                                                      void* instance);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static GVariant* __pantheon_shell_multitasking_hotcorner_control___lambda34__gsettings_bind_set_mapping (GValue* value,
                                                                                                  const GVariantType* expected_type,
                                                                                                  void* user_data);
static void pantheon_shell_multitasking_hotcorner_control_finalize (GObject * obj);
static GType pantheon_shell_multitasking_hotcorner_control_get_type_once (void);
static void _vala_pantheon_shell_multitasking_hotcorner_control_get_property (GObject * object,
                                                                       guint property_id,
                                                                       GValue * value,
                                                                       GParamSpec * pspec);
static void _vala_pantheon_shell_multitasking_hotcorner_control_set_property (GObject * object,
                                                                       guint property_id,
                                                                       const GValue * value,
                                                                       GParamSpec * pspec);
static GObject * pantheon_shell_multitasking_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void pantheon_shell_multitasking_finalize (GObject * obj);
static GType pantheon_shell_multitasking_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
pantheon_shell_multitasking_get_instance_private (PantheonShellMultitasking* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellMultitasking_private_offset);
}

PantheonShellMultitasking*
pantheon_shell_multitasking_construct (GType object_type)
{
	PantheonShellMultitasking * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("preferences-desktop-workspaces");
	_tmp1_ = _tmp0_;
	self = (PantheonShellMultitasking*) g_object_new (object_type, "title", _ ("Multitasking"), "icon", _tmp1_, "show-end-title-buttons", TRUE, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

PantheonShellMultitasking*
pantheon_shell_multitasking_new (void)
{
	return pantheon_shell_multitasking_construct (PANTHEON_SHELL_TYPE_MULTITASKING);
}

static inline gpointer
pantheon_shell_multitasking_hotcorner_control_get_instance_private (PantheonShellMultitaskingHotcornerControl* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellMultitaskingHotcornerControl_private_offset);
}

static PantheonShellMultitaskingHotcornerControl*
pantheon_shell_multitasking_hotcorner_control_construct (GType object_type,
                                                         const gchar* label,
                                                         const gchar* position)
{
	PantheonShellMultitaskingHotcornerControl * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (position != NULL, NULL);
	self = (PantheonShellMultitaskingHotcornerControl*) g_object_new (object_type, "label", label, "position", position, NULL);
	return self;
}

static PantheonShellMultitaskingHotcornerControl*
pantheon_shell_multitasking_hotcorner_control_new (const gchar* label,
                                                   const gchar* position)
{
	return pantheon_shell_multitasking_hotcorner_control_construct (PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, label, position);
}

static const gchar*
pantheon_shell_multitasking_hotcorner_control_get_label (PantheonShellMultitaskingHotcornerControl* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
pantheon_shell_multitasking_hotcorner_control_set_label (PantheonShellMultitaskingHotcornerControl* self,
                                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_multitasking_hotcorner_control_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_multitasking_hotcorner_control_properties[PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_LABEL_PROPERTY]);
	}
}

static const gchar*
pantheon_shell_multitasking_hotcorner_control_get_position (PantheonShellMultitaskingHotcornerControl* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_position;
	result = _tmp0_;
	return result;
}

static void
pantheon_shell_multitasking_hotcorner_control_set_position (PantheonShellMultitaskingHotcornerControl* self,
                                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_multitasking_hotcorner_control_get_position (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_position);
		self->priv->_position = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_multitasking_hotcorner_control_properties[PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_POSITION_PROPERTY]);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_pantheon_shell_multitasking_hotcorner_control___lambda31_ (GValue* value,
                                                            GVariant* variant,
                                                            void* user_data)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_string (variant, NULL);
	g_value_set_boolean (value, g_strcmp0 (_tmp0_, "custom-command") == 0);
	result = TRUE;
	return result;
}

static gboolean
__pantheon_shell_multitasking_hotcorner_control___lambda31__gsettings_bind_get_mapping (GValue* value,
                                                                                        GVariant* variant,
                                                                                        void* user_data)
{
	gboolean result;
	result = _pantheon_shell_multitasking_hotcorner_control___lambda31_ (value, variant, user_data);
	return result;
}

static GVariant*
_pantheon_shell_multitasking_hotcorner_control___lambda32_ (GValue* value,
                                                            const GVariantType* expected_type,
                                                            void* user_data)
{
	GVariant* _tmp0_;
	GVariant* result;
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	_tmp0_ = g_variant_new_string ("custom-command");
	g_variant_ref_sink (_tmp0_);
	result = _tmp0_;
	return result;
}

static GVariant*
__pantheon_shell_multitasking_hotcorner_control___lambda32__gsettings_bind_set_mapping (GValue* value,
                                                                                        const GVariantType* expected_type,
                                                                                        void* user_data)
{
	GVariant* result;
	result = _pantheon_shell_multitasking_hotcorner_control___lambda32_ (value, expected_type, user_data);
	return result;
}

static gchar*
_variant_get1 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
_pantheon_shell_multitasking_hotcorner_control___lambda33_ (GValue* value,
                                                            GVariant* variant,
                                                            void* instance)
{
	gchar** commands = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint commands_length1;
	gint _commands_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gboolean result;
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = _variant_get1 (variant);
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ";;", 0);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_free0 (_tmp1_);
	commands = _tmp4_;
	commands_length1 = _tmp4__length1;
	_commands_size_ = commands_length1;
	_tmp5_ = commands;
	_tmp5__length1 = commands_length1;
	{
		gchar** command_collection = NULL;
		gint command_collection_length1 = 0;
		gint _command_collection_size_ = 0;
		gint command_it = 0;
		command_collection = _tmp5_;
		command_collection_length1 = _tmp5__length1;
		for (command_it = 0; command_it < command_collection_length1; command_it = command_it + 1) {
			const gchar* command = NULL;
			command = command_collection[command_it];
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gboolean _tmp10_;
				_tmp6_ = command;
				_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (instance, PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControl)->priv->_position;
				_tmp8_ = g_strconcat ("hotcorner-", _tmp7_, NULL);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_str_has_prefix (_tmp6_, _tmp9_);
				_g_free0 (_tmp9_);
				if (_tmp10_) {
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp11_ = command;
					_tmp12_ = G_TYPE_CHECK_INSTANCE_CAST (instance, PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControl)->priv->_position;
					_tmp13_ = g_strdup_printf ("hotcorner-%s:", _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = string_replace (_tmp11_, _tmp14_, "");
					_tmp16_ = _tmp15_;
					g_value_set_string (value, _tmp16_);
					_g_free0 (_tmp16_);
					_g_free0 (_tmp14_);
					result = TRUE;
					commands = (_vala_array_free (commands, commands_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	g_value_set_string (value, "");
	result = TRUE;
	commands = (_vala_array_free (commands, commands_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gboolean
__pantheon_shell_multitasking_hotcorner_control___lambda33__gsettings_bind_get_mapping (GValue* value,
                                                                                        GVariant* variant,
                                                                                        void* user_data)
{
	gboolean result;
	result = _pantheon_shell_multitasking_hotcorner_control___lambda33_ (value, variant, user_data);
	return result;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static GVariant*
_pantheon_shell_multitasking_hotcorner_control___lambda34_ (GValue* value,
                                                            const GVariantType* expected_type,
                                                            void* instance)
{
	gchar* this_command = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* setting_string = NULL;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	gboolean found = FALSE;
	gchar** commands = NULL;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint commands_length1;
	gint _commands_size_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GVariant* _tmp25_;
	GVariant* _tmp26_;
	GVariant* result;
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (instance, PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControl)->priv->_position;
	_tmp1_ = g_value_get_string (value);
	_tmp2_ = g_strdup_printf ("hotcorner-%s:%s", _tmp0_, _tmp1_);
	this_command = _tmp2_;
	_tmp3_ = pantheon_shell_multitasking_hotcorner_control_settings;
	_tmp4_ = g_settings_get_string (_tmp3_, "hotcorner-custom-command");
	setting_string = _tmp4_;
	found = FALSE;
	_tmp5_ = setting_string;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ";;", 0);
	commands = _tmp7_;
	commands_length1 = _vala_array_length (_tmp6_);
	_commands_size_ = commands_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gchar** _tmp10_;
				gint _tmp10__length1;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gboolean _tmp16_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = commands;
				_tmp10__length1 = commands_length1;
				if (!(i < _tmp10__length1)) {
					break;
				}
				_tmp11_ = commands;
				_tmp11__length1 = commands_length1;
				_tmp12_ = _tmp11_[i];
				_tmp13_ = G_TYPE_CHECK_INSTANCE_CAST (instance, PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControl)->priv->_position;
				_tmp14_ = g_strconcat ("hotcorner-", _tmp13_, NULL);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_str_has_prefix (_tmp12_, _tmp15_);
				_g_free0 (_tmp15_);
				if (_tmp16_) {
					gchar** _tmp17_;
					gint _tmp17__length1;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					found = TRUE;
					_tmp17_ = commands;
					_tmp17__length1 = commands_length1;
					_tmp18_ = this_command;
					_tmp19_ = g_strdup (_tmp18_);
					_g_free0 (_tmp17_[i]);
					_tmp17_[i] = _tmp19_;
				}
			}
		}
	}
	if (!found) {
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp20_ = this_command;
		_tmp21_ = g_strdup (_tmp20_);
		_vala_array_add4 (&commands, &commands_length1, &_commands_size_, _tmp21_);
	}
	_tmp22_ = commands;
	_tmp22__length1 = commands_length1;
	_tmp23_ = _vala_g_strjoinv (";;", _tmp22_, (gint) _tmp22__length1);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_variant_new_string (_tmp24_);
	g_variant_ref_sink (_tmp25_);
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp24_);
	result = _tmp26_;
	commands = (_vala_array_free (commands, commands_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (setting_string);
	_g_free0 (this_command);
	return result;
}

static GVariant*
__pantheon_shell_multitasking_hotcorner_control___lambda34__gsettings_bind_set_mapping (GValue* value,
                                                                                        const GVariantType* expected_type,
                                                                                        void* user_data)
{
	GVariant* result;
	result = _pantheon_shell_multitasking_hotcorner_control___lambda34_ (value, expected_type, user_data);
	return result;
}

static GObject *
pantheon_shell_multitasking_hotcorner_control_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PantheonShellMultitaskingHotcornerControl * self;
	GtkLabel* label = NULL;
	const gchar* _tmp0_;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	const gchar* _tmp6_;
	GtkTextDirection text_direction = 0;
	GtkComboBoxText* combo = NULL;
	GtkComboBoxText* _tmp7_ = NULL;
	GtkComboBoxText* _tmp8_;
	GtkComboBoxText* _tmp9_;
	GtkComboBoxText* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	GtkComboBoxText* _tmp17_;
	GtkComboBoxText* _tmp18_;
	GtkComboBoxText* _tmp19_;
	GtkComboBoxText* _tmp20_;
	GtkComboBoxText* _tmp21_;
	gchar* _tmp22_;
	GtkEntry* _tmp23_ = NULL;
	GtkRevealer* command_revealer = NULL;
	GtkEntry* _tmp24_;
	GtkWidget* _tmp25_;
	GtkRevealer* _tmp26_ = NULL;
	GtkLabel* _tmp27_;
	GtkComboBoxText* _tmp28_;
	GtkRevealer* _tmp29_;
	GtkSizeGroup* _tmp30_;
	GtkLabel* _tmp31_;
	GSettings* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GtkComboBoxText* _tmp36_;
	GSettings* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GtkRevealer* _tmp41_;
	GSettings* _tmp42_;
	GtkEntry* _tmp43_;
	PantheonShellMultitaskingHotcornerControl* _tmp44_;
	parent_class = G_OBJECT_CLASS (pantheon_shell_multitasking_hotcorner_control_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControl);
	_tmp0_ = self->priv->_label;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	gtk_label_set_max_width_chars (_tmp1_, 12);
	gtk_label_set_wrap (_tmp1_, TRUE);
	gtk_label_set_wrap_mode (_tmp1_, PANGO_WRAP_WORD_CHAR);
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	_tmp2_ = label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_CARD);
	_tmp3_ = label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, GRANITE_STYLE_CLASS_ROUNDED);
	_tmp4_ = label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, "hotcorner");
	_tmp5_ = label;
	_tmp6_ = self->priv->_position;
	gtk_widget_add_css_class ((GtkWidget*) _tmp5_, _tmp6_);
	text_direction = gtk_widget_get_default_direction ();
	_tmp7_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp7_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp7_);
	combo = _tmp7_;
	_tmp8_ = combo;
	gtk_combo_box_text_append (_tmp8_, "none", _ ("Do nothing"));
	_tmp9_ = combo;
	gtk_combo_box_text_append (_tmp9_, "show-workspace-view", _ ("Multitasking View"));
	_tmp10_ = combo;
	gtk_combo_box_text_append (_tmp10_, "maximize-current", _ ("Maximize current window"));
	_tmp13_ = self->priv->_position;
	if (g_strcmp0 (_tmp13_, "topleft") == 0) {
		_tmp12_ = text_direction == GTK_TEXT_DIR_LTR;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		_tmp15_ = self->priv->_position;
		if (g_strcmp0 (_tmp15_, "topright") == 0) {
			_tmp14_ = text_direction == GTK_TEXT_DIR_RTL;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp11_ = _tmp14_;
	}
	if (_tmp11_) {
		GtkComboBoxText* _tmp16_;
		_tmp16_ = combo;
		gtk_combo_box_text_append (_tmp16_, "open-launcher", _ ("Show Applications Menu"));
	}
	_tmp17_ = combo;
	gtk_combo_box_text_append (_tmp17_, "window-overview-all", _ ("Show all windows"));
	_tmp18_ = combo;
	gtk_combo_box_text_append (_tmp18_, "switch-to-workspace-previous", _ ("Switch to previous workspace"));
	_tmp19_ = combo;
	gtk_combo_box_text_append (_tmp19_, "switch-to-workspace-next", _ ("Switch to next workspace"));
	_tmp20_ = combo;
	gtk_combo_box_text_append (_tmp20_, "switch-to-workspace-last", _ ("Switch to new workspace"));
	_tmp21_ = combo;
	gtk_combo_box_text_append (_tmp21_, "custom-command", _ ("Execute custom command"));
	_tmp22_ = g_strdup ("utilities-terminal-symbolic");
	_tmp23_ = (GtkEntry*) gtk_entry_new ();
	g_object_set (_tmp23_, "primary-icon-name", _tmp22_, NULL);
	_g_free0 (_tmp22_);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->command_entry);
	self->priv->command_entry = _tmp23_;
	_tmp24_ = self->priv->command_entry;
	_tmp25_ = _g_object_ref0 ((GtkWidget*) _tmp24_);
	_tmp26_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp26_, _tmp25_);
	_g_object_unref0 (_tmp25_);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp26_, 6);
	gtk_revealer_set_transition_type (_tmp26_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	g_object_ref_sink (_tmp26_);
	command_revealer = _tmp26_;
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 12);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 12);
	_tmp27_ = label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp27_, 0, 0, 1, 2);
	_tmp28_ = combo;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp28_, 1, 0, 1, 1);
	_tmp29_ = command_revealer;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp29_, 1, 1, 1, 1);
	_tmp30_ = pantheon_shell_multitasking_hotcorner_control_size_group;
	_tmp31_ = label;
	gtk_size_group_add_widget (_tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = pantheon_shell_multitasking_hotcorner_control_settings;
	_tmp33_ = self->priv->_position;
	_tmp34_ = g_strconcat ("hotcorner-", _tmp33_, NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = combo;
	g_settings_bind (_tmp32_, _tmp35_, (GObject*) _tmp36_, "active-id", G_SETTINGS_BIND_DEFAULT);
	_g_free0 (_tmp35_);
	_tmp37_ = pantheon_shell_multitasking_hotcorner_control_settings;
	_tmp38_ = self->priv->_position;
	_tmp39_ = g_strconcat ("hotcorner-", _tmp38_, NULL);
	_tmp40_ = _tmp39_;
	_tmp41_ = command_revealer;
	g_settings_bind_with_mapping (_tmp37_, _tmp40_, (GObject*) _tmp41_, "reveal-child", G_SETTINGS_BIND_GET, __pantheon_shell_multitasking_hotcorner_control___lambda31__gsettings_bind_get_mapping, __pantheon_shell_multitasking_hotcorner_control___lambda32__gsettings_bind_set_mapping, NULL, NULL);
	_g_free0 (_tmp40_);
	_tmp42_ = pantheon_shell_multitasking_hotcorner_control_settings;
	_tmp43_ = self->priv->command_entry;
	_tmp44_ = self;
	g_settings_bind_with_mapping (_tmp42_, "hotcorner-custom-command", (GObject*) _tmp43_, "text", G_SETTINGS_BIND_DEFAULT, __pantheon_shell_multitasking_hotcorner_control___lambda33__gsettings_bind_get_mapping, __pantheon_shell_multitasking_hotcorner_control___lambda34__gsettings_bind_set_mapping, _tmp44_, NULL);
	_g_object_unref0 (command_revealer);
	_g_object_unref0 (combo);
	_g_object_unref0 (label);
	return obj;
}

static void
pantheon_shell_multitasking_hotcorner_control_class_init (PantheonShellMultitaskingHotcornerControlClass * klass,
                                                          gpointer klass_data)
{
	GSettings* _tmp0_;
	GtkSizeGroup* _tmp1_;
	pantheon_shell_multitasking_hotcorner_control_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonShellMultitaskingHotcornerControl_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pantheon_shell_multitasking_hotcorner_control_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pantheon_shell_multitasking_hotcorner_control_set_property;
	G_OBJECT_CLASS (klass)->constructor = pantheon_shell_multitasking_hotcorner_control_constructor;
	G_OBJECT_CLASS (klass)->finalize = pantheon_shell_multitasking_hotcorner_control_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_LABEL_PROPERTY, pantheon_shell_multitasking_hotcorner_control_properties[PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_POSITION_PROPERTY, pantheon_shell_multitasking_hotcorner_control_properties[PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_POSITION_PROPERTY] = g_param_spec_string ("position", "position", "position", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_settings_new ("io.elementary.desktop.wm.behavior");
	_g_object_unref0 (pantheon_shell_multitasking_hotcorner_control_settings);
	pantheon_shell_multitasking_hotcorner_control_settings = _tmp0_;
	_tmp1_ = gtk_size_group_new (GTK_SIZE_GROUP_BOTH);
	_g_object_unref0 (pantheon_shell_multitasking_hotcorner_control_size_group);
	pantheon_shell_multitasking_hotcorner_control_size_group = _tmp1_;
}

static void
pantheon_shell_multitasking_hotcorner_control_instance_init (PantheonShellMultitaskingHotcornerControl * self,
                                                             gpointer klass)
{
	self->priv = pantheon_shell_multitasking_hotcorner_control_get_instance_private (self);
}

static void
pantheon_shell_multitasking_hotcorner_control_finalize (GObject * obj)
{
	PantheonShellMultitaskingHotcornerControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControl);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_position);
	_g_object_unref0 (self->priv->command_entry);
	G_OBJECT_CLASS (pantheon_shell_multitasking_hotcorner_control_parent_class)->finalize (obj);
}

static GType
pantheon_shell_multitasking_hotcorner_control_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellMultitaskingHotcornerControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_multitasking_hotcorner_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellMultitaskingHotcornerControl), 0, (GInstanceInitFunc) pantheon_shell_multitasking_hotcorner_control_instance_init, NULL };
	GType pantheon_shell_multitasking_hotcorner_control_type_id;
	pantheon_shell_multitasking_hotcorner_control_type_id = g_type_register_static (gtk_grid_get_type (), "PantheonShellMultitaskingHotcornerControl", &g_define_type_info, 0);
	PantheonShellMultitaskingHotcornerControl_private_offset = g_type_add_instance_private (pantheon_shell_multitasking_hotcorner_control_type_id, sizeof (PantheonShellMultitaskingHotcornerControlPrivate));
	return pantheon_shell_multitasking_hotcorner_control_type_id;
}

static GType
pantheon_shell_multitasking_hotcorner_control_get_type (void)
{
	static volatile gsize pantheon_shell_multitasking_hotcorner_control_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_multitasking_hotcorner_control_type_id__once)) {
		GType pantheon_shell_multitasking_hotcorner_control_type_id;
		pantheon_shell_multitasking_hotcorner_control_type_id = pantheon_shell_multitasking_hotcorner_control_get_type_once ();
		g_once_init_leave (&pantheon_shell_multitasking_hotcorner_control_type_id__once, pantheon_shell_multitasking_hotcorner_control_type_id);
	}
	return pantheon_shell_multitasking_hotcorner_control_type_id__once;
}

static void
_vala_pantheon_shell_multitasking_hotcorner_control_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec)
{
	PantheonShellMultitaskingHotcornerControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControl);
	switch (property_id) {
		case PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_LABEL_PROPERTY:
		g_value_set_string (value, pantheon_shell_multitasking_hotcorner_control_get_label (self));
		break;
		case PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_POSITION_PROPERTY:
		g_value_set_string (value, pantheon_shell_multitasking_hotcorner_control_get_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pantheon_shell_multitasking_hotcorner_control_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec)
{
	PantheonShellMultitaskingHotcornerControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControl);
	switch (property_id) {
		case PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_LABEL_PROPERTY:
		pantheon_shell_multitasking_hotcorner_control_set_label (self, g_value_get_string (value));
		break;
		case PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_POSITION_PROPERTY:
		pantheon_shell_multitasking_hotcorner_control_set_position (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
pantheon_shell_multitasking_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PantheonShellMultitasking * self;
	GraniteHeaderLabel* hotcorner_title = NULL;
	GraniteHeaderLabel* _tmp0_ = NULL;
	PantheonShellMultitaskingHotcornerControl* topleft = NULL;
	PantheonShellMultitaskingHotcornerControl* _tmp1_;
	PantheonShellMultitaskingHotcornerControl* topright = NULL;
	PantheonShellMultitaskingHotcornerControl* _tmp2_;
	PantheonShellMultitaskingHotcornerControl* bottomleft = NULL;
	PantheonShellMultitaskingHotcornerControl* _tmp3_;
	PantheonShellMultitaskingHotcornerControl* bottomright = NULL;
	PantheonShellMultitaskingHotcornerControl* _tmp4_;
	GtkSwitch* fullscreen_hotcorner_switch = NULL;
	GtkSwitch* _tmp5_ = NULL;
	GraniteHeaderLabel* fullscreen_hotcorner_header = NULL;
	gchar* _tmp6_;
	GtkSwitch* _tmp7_;
	GtkWidget* _tmp8_;
	GraniteHeaderLabel* _tmp9_ = NULL;
	GtkBox* fullscreen_hotcorner_box = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkBox* _tmp11_;
	GraniteHeaderLabel* _tmp12_;
	GtkBox* _tmp13_;
	GtkSwitch* _tmp14_;
	GraniteHeaderLabel* workspaces_label = NULL;
	GraniteHeaderLabel* _tmp15_;
	GtkCheckButton* fullscreen_checkbutton = NULL;
	GtkCheckButton* _tmp16_;
	GtkCheckButton* maximize_checkbutton = NULL;
	GtkCheckButton* _tmp17_;
	GtkBox* checkbutton_box = NULL;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	GtkCheckButton* _tmp20_;
	GtkBox* _tmp21_;
	GtkCheckButton* _tmp22_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp23_ = NULL;
	GtkGrid* _tmp24_;
	GraniteHeaderLabel* _tmp25_;
	GtkGrid* _tmp26_;
	PantheonShellMultitaskingHotcornerControl* _tmp27_;
	GtkGrid* _tmp28_;
	PantheonShellMultitaskingHotcornerControl* _tmp29_;
	GtkGrid* _tmp30_;
	PantheonShellMultitaskingHotcornerControl* _tmp31_;
	GtkGrid* _tmp32_;
	PantheonShellMultitaskingHotcornerControl* _tmp33_;
	GtkGrid* _tmp34_;
	GtkBox* _tmp35_;
	GtkGrid* _tmp36_;
	GraniteHeaderLabel* _tmp37_;
	GtkGrid* _tmp38_;
	GtkBox* _tmp39_;
	GtkGrid* _tmp40_;
	GSettings* _tmp41_;
	GSettings* _tmp42_;
	GtkSwitch* _tmp43_;
	GSettings* _tmp44_;
	GtkCheckButton* _tmp45_;
	GSettings* _tmp46_;
	GtkCheckButton* _tmp47_;
	parent_class = G_OBJECT_CLASS (pantheon_shell_multitasking_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_MULTITASKING, PantheonShellMultitasking);
	_tmp0_ = granite_header_label_new (_ ("When the pointer enters a display corner"));
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp0_, 6);
	g_object_ref_sink (_tmp0_);
	hotcorner_title = _tmp0_;
	_tmp1_ = pantheon_shell_multitasking_hotcorner_control_new (_ ("Top Left"), "topleft");
	g_object_ref_sink (_tmp1_);
	topleft = _tmp1_;
	_tmp2_ = pantheon_shell_multitasking_hotcorner_control_new (_ ("Top Right"), "topright");
	g_object_ref_sink (_tmp2_);
	topright = _tmp2_;
	_tmp3_ = pantheon_shell_multitasking_hotcorner_control_new (_ ("Bottom Left"), "bottomleft");
	g_object_ref_sink (_tmp3_);
	bottomleft = _tmp3_;
	_tmp4_ = pantheon_shell_multitasking_hotcorner_control_new (_ ("Bottom Right"), "bottomright");
	g_object_ref_sink (_tmp4_);
	bottomright = _tmp4_;
	_tmp5_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp5_);
	fullscreen_hotcorner_switch = _tmp5_;
	_tmp6_ = g_strdup (_ ("May interfere with fullscreen video games, for example"));
	_tmp7_ = fullscreen_hotcorner_switch;
	_tmp8_ = _g_object_ref0 ((GtkWidget*) _tmp7_);
	_tmp9_ = granite_header_label_new (_ ("Activate Hot Corners in fullscreen"));
	granite_header_label_set_secondary_text (_tmp9_, _tmp6_);
	_g_free0 (_tmp6_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	granite_header_label_set_mnemonic_widget (_tmp9_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	fullscreen_hotcorner_header = _tmp9_;
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp10_, 12);
	g_object_ref_sink (_tmp10_);
	fullscreen_hotcorner_box = _tmp10_;
	_tmp11_ = fullscreen_hotcorner_box;
	_tmp12_ = fullscreen_hotcorner_header;
	gtk_box_append (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = fullscreen_hotcorner_box;
	_tmp14_ = fullscreen_hotcorner_switch;
	gtk_box_append (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = granite_header_label_new (_ ("Move windows to a new workspace"));
	g_object_ref_sink (_tmp15_);
	workspaces_label = _tmp15_;
	_tmp16_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("When entering fullscreen"));
	g_object_ref_sink (_tmp16_);
	fullscreen_checkbutton = _tmp16_;
	_tmp17_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("When maximizing"));
	g_object_ref_sink (_tmp17_);
	maximize_checkbutton = _tmp17_;
	_tmp18_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp18_);
	checkbutton_box = _tmp18_;
	_tmp19_ = checkbutton_box;
	_tmp20_ = fullscreen_checkbutton;
	gtk_box_append (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = checkbutton_box;
	_tmp22_ = maximize_checkbutton;
	gtk_box_append (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp23_, 12);
	gtk_grid_set_row_spacing (_tmp23_, 6);
	g_object_ref_sink (_tmp23_);
	grid = _tmp23_;
	_tmp24_ = grid;
	_tmp25_ = hotcorner_title;
	gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 0, 0, 2, 1);
	_tmp26_ = grid;
	_tmp27_ = topleft;
	gtk_grid_attach (_tmp26_, (GtkWidget*) _tmp27_, 0, 1, 2, 1);
	_tmp28_ = grid;
	_tmp29_ = topright;
	gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 0, 2, 2, 1);
	_tmp30_ = grid;
	_tmp31_ = bottomleft;
	gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 0, 3, 2, 1);
	_tmp32_ = grid;
	_tmp33_ = bottomright;
	gtk_grid_attach (_tmp32_, (GtkWidget*) _tmp33_, 0, 4, 2, 1);
	_tmp34_ = grid;
	_tmp35_ = fullscreen_hotcorner_box;
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 0, 6, 2, 1);
	_tmp36_ = grid;
	_tmp37_ = workspaces_label;
	gtk_grid_attach (_tmp36_, (GtkWidget*) _tmp37_, 0, 7, 2, 1);
	_tmp38_ = grid;
	_tmp39_ = checkbutton_box;
	gtk_grid_attach (_tmp38_, (GtkWidget*) _tmp39_, 0, 8, 2, 1);
	_tmp40_ = grid;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp40_);
	_tmp41_ = g_settings_new ("io.elementary.desktop.wm.behavior");
	_g_object_unref0 (self->priv->behavior_settings);
	self->priv->behavior_settings = _tmp41_;
	_tmp42_ = self->priv->behavior_settings;
	_tmp43_ = fullscreen_hotcorner_switch;
	g_settings_bind (_tmp42_, "enable-hotcorners-in-fullscreen", (GObject*) _tmp43_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp44_ = self->priv->behavior_settings;
	_tmp45_ = fullscreen_checkbutton;
	g_settings_bind (_tmp44_, "move-fullscreened-workspace", (GObject*) _tmp45_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp46_ = self->priv->behavior_settings;
	_tmp47_ = maximize_checkbutton;
	g_settings_bind (_tmp46_, "move-maximized-workspace", (GObject*) _tmp47_, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (grid);
	_g_object_unref0 (checkbutton_box);
	_g_object_unref0 (maximize_checkbutton);
	_g_object_unref0 (fullscreen_checkbutton);
	_g_object_unref0 (workspaces_label);
	_g_object_unref0 (fullscreen_hotcorner_box);
	_g_object_unref0 (fullscreen_hotcorner_header);
	_g_object_unref0 (fullscreen_hotcorner_switch);
	_g_object_unref0 (bottomright);
	_g_object_unref0 (bottomleft);
	_g_object_unref0 (topright);
	_g_object_unref0 (topleft);
	_g_object_unref0 (hotcorner_title);
	return obj;
}

static void
pantheon_shell_multitasking_class_init (PantheonShellMultitaskingClass * klass,
                                        gpointer klass_data)
{
	pantheon_shell_multitasking_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonShellMultitasking_private_offset);
	G_OBJECT_CLASS (klass)->constructor = pantheon_shell_multitasking_constructor;
	G_OBJECT_CLASS (klass)->finalize = pantheon_shell_multitasking_finalize;
}

static void
pantheon_shell_multitasking_instance_init (PantheonShellMultitasking * self,
                                           gpointer klass)
{
	self->priv = pantheon_shell_multitasking_get_instance_private (self);
}

static void
pantheon_shell_multitasking_finalize (GObject * obj)
{
	PantheonShellMultitasking * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_MULTITASKING, PantheonShellMultitasking);
	_g_object_unref0 (self->priv->behavior_settings);
	G_OBJECT_CLASS (pantheon_shell_multitasking_parent_class)->finalize (obj);
}

static GType
pantheon_shell_multitasking_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellMultitaskingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_multitasking_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellMultitasking), 0, (GInstanceInitFunc) pantheon_shell_multitasking_instance_init, NULL };
	GType pantheon_shell_multitasking_type_id;
	pantheon_shell_multitasking_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "PantheonShellMultitasking", &g_define_type_info, 0);
	PantheonShellMultitasking_private_offset = g_type_add_instance_private (pantheon_shell_multitasking_type_id, sizeof (PantheonShellMultitaskingPrivate));
	return pantheon_shell_multitasking_type_id;
}

GType
pantheon_shell_multitasking_get_type (void)
{
	static volatile gsize pantheon_shell_multitasking_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_multitasking_type_id__once)) {
		GType pantheon_shell_multitasking_type_id;
		pantheon_shell_multitasking_type_id = pantheon_shell_multitasking_get_type_once ();
		g_once_init_leave (&pantheon_shell_multitasking_type_id__once, pantheon_shell_multitasking_type_id);
	}
	return pantheon_shell_multitasking_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

