/* Plug.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
* Copyright (c) 2011–2018 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
*/

#include "desktop.h"
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PANTHEON_SHELL_PLUG_0_PROPERTY,
	PANTHEON_SHELL_PLUG_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_plug_properties[PANTHEON_SHELL_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PantheonShellPlugSearchData PantheonShellPlugSearchData;

struct _PantheonShellPlugPrivate {
	GtkPaned* paned;
	GtkStack* stack;
	PantheonShellWallpaper* wallpaper_view;
};

struct _PantheonShellPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PantheonShellPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GeeTreeMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	const gchar* _tmp61_;
	const gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	const gchar* _tmp73_;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	const gchar* _tmp77_;
	const gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	const gchar* _tmp81_;
	const gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	const gchar* _tmp85_;
	const gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
};

static gint PantheonShellPlug_private_offset;
static gpointer pantheon_shell_plug_parent_class = NULL;

static GtkWidget* pantheon_shell_plug_real_get_widget (SwitchboardPlug* base);
static void pantheon_shell_plug_real_shown (SwitchboardPlug* base);
static void pantheon_shell_plug_real_hidden (SwitchboardPlug* base);
static void pantheon_shell_plug_real_search_callback (SwitchboardPlug* base,
                                               const gchar* location);
static void pantheon_shell_plug_real_search_data_free (gpointer _data);
static void pantheon_shell_plug_real_search (SwitchboardPlug* base,
                                      const gchar* search,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean pantheon_shell_plug_real_search_co (PantheonShellPlugSearchData* _data_);
static void pantheon_shell_plug_finalize (GObject * obj);
static GType pantheon_shell_plug_get_type_once (void);

static inline gpointer
pantheon_shell_plug_get_instance_private (PantheonShellPlug* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellPlug_private_offset);
}

PantheonShellPlug*
pantheon_shell_plug_construct (GType object_type)
{
	PantheonShellPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp1_;
	GdkDisplay* _tmp2_;
	bindtextdomain (CONSTANTS_GETTEXT_PACKAGE, CONSTANTS_LOCALEDIR);
	bind_textdomain_codeset (CONSTANTS_GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "desktop", NULL);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "desktop/appearance/wallpaper", "wallpaper");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "desktop/appearance", "appearance");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "desktop/dock", "dock");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "desktop/multitasking", "multitasking");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "desktop/text", "text");
	_tmp1_ = gtk_css_provider_new ();
	provider = _tmp1_;
	gtk_css_provider_load_from_resource (provider, "/io/elementary/settings/desktop/plug.css");
	_tmp2_ = gdk_display_get_default ();
	gtk_style_context_add_provider_for_display (_tmp2_, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "desktop/wallpaper", "wallpaper");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "desktop/hot-corners", "multitasking");
	self = (PantheonShellPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_PERSONAL, "code-name", "io.elementary.settings.desktop", "display-name", _ ("Desktop"), "description", _ ("Configure the dock, hot corners, and change wallpaper"), "icon", "preferences-desktop", "supported-settings", settings, NULL);
	_g_object_unref0 (provider);
	_g_object_unref0 (settings);
	return self;
}

PantheonShellPlug*
pantheon_shell_plug_new (void)
{
	return pantheon_shell_plug_construct (PANTHEON_SHELL_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
pantheon_shell_plug_real_get_widget (SwitchboardPlug* base)
{
	PantheonShellPlug * self;
	GtkPaned* _tmp0_;
	GtkPaned* _tmp32_;
	GtkWidget* _tmp33_;
	GtkWidget* result;
	self = (PantheonShellPlug*) base;
	_tmp0_ = self->priv->paned;
	if (_tmp0_ == NULL) {
		PantheonShellWallpaper* _tmp1_;
		PantheonShellDock* dock = NULL;
		PantheonShellDock* _tmp2_;
		PantheonShellMultitasking* multitasking = NULL;
		PantheonShellMultitasking* _tmp3_;
		PantheonShellAppearance* appearance = NULL;
		PantheonShellAppearance* _tmp4_;
		PantheonShellText* text = NULL;
		PantheonShellText* _tmp5_;
		GtkStack* _tmp6_;
		GtkStack* _tmp7_;
		PantheonShellWallpaper* _tmp8_;
		GtkStack* _tmp9_;
		PantheonShellAppearance* _tmp10_;
		GtkStack* _tmp11_;
		PantheonShellText* _tmp12_;
		GtkStack* _tmp13_;
		PantheonShellDock* _tmp14_;
		GtkStack* _tmp15_;
		PantheonShellMultitasking* _tmp16_;
		SwitchboardSettingsSidebar* sidebar = NULL;
		GtkStack* _tmp17_;
		SwitchboardSettingsSidebar* _tmp18_ = NULL;
		SwitchboardSettingsSidebar* _tmp19_;
		GtkWidget* _tmp20_;
		GtkStack* _tmp21_;
		GtkWidget* _tmp22_;
		GtkPaned* _tmp23_ = NULL;
		GSettingsSchema* sss = NULL;
		GSettingsSchemaSource* _tmp24_;
		GSettingsSchema* _tmp25_;
		gboolean _tmp26_ = FALSE;
		GSettingsSchema* _tmp27_;
		_tmp1_ = pantheon_shell_wallpaper_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->wallpaper_view);
		self->priv->wallpaper_view = _tmp1_;
		_tmp2_ = pantheon_shell_dock_new ();
		g_object_ref_sink (_tmp2_);
		dock = _tmp2_;
		_tmp3_ = pantheon_shell_multitasking_new ();
		g_object_ref_sink (_tmp3_);
		multitasking = _tmp3_;
		_tmp4_ = pantheon_shell_appearance_new ();
		g_object_ref_sink (_tmp4_);
		appearance = _tmp4_;
		_tmp5_ = pantheon_shell_text_new ();
		g_object_ref_sink (_tmp5_);
		text = _tmp5_;
		_tmp6_ = (GtkStack*) gtk_stack_new ();
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->stack);
		self->priv->stack = _tmp6_;
		_tmp7_ = self->priv->stack;
		_tmp8_ = self->priv->wallpaper_view;
		gtk_stack_add_titled (_tmp7_, (GtkWidget*) _tmp8_, "wallpaper", _ ("Wallpaper"));
		_tmp9_ = self->priv->stack;
		_tmp10_ = appearance;
		gtk_stack_add_titled (_tmp9_, (GtkWidget*) _tmp10_, "appearance", _ ("Appearance"));
		_tmp11_ = self->priv->stack;
		_tmp12_ = text;
		gtk_stack_add_titled (_tmp11_, (GtkWidget*) _tmp12_, "text", _ ("Text"));
		_tmp13_ = self->priv->stack;
		_tmp14_ = dock;
		gtk_stack_add_titled (_tmp13_, (GtkWidget*) _tmp14_, "dock", _ ("Dock & Panel"));
		_tmp15_ = self->priv->stack;
		_tmp16_ = multitasking;
		gtk_stack_add_titled (_tmp15_, (GtkWidget*) _tmp16_, "multitasking", _ ("Multitasking"));
		_tmp17_ = self->priv->stack;
		_tmp18_ = switchboard_settings_sidebar_new (_tmp17_);
		switchboard_settings_sidebar_set_show_title_buttons (_tmp18_, TRUE);
		g_object_ref_sink (_tmp18_);
		sidebar = _tmp18_;
		_tmp19_ = sidebar;
		_tmp20_ = _g_object_ref0 ((GtkWidget*) _tmp19_);
		_tmp21_ = self->priv->stack;
		_tmp22_ = _g_object_ref0 ((GtkWidget*) _tmp21_);
		_tmp23_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
		gtk_paned_set_start_child (_tmp23_, _tmp20_);
		_g_object_unref0 (_tmp20_);
		gtk_paned_set_end_child (_tmp23_, _tmp22_);
		_g_object_unref0 (_tmp22_);
		gtk_paned_set_shrink_start_child (_tmp23_, FALSE);
		gtk_paned_set_shrink_end_child (_tmp23_, FALSE);
		gtk_paned_set_resize_start_child (_tmp23_, FALSE);
		g_object_ref_sink (_tmp23_);
		_g_object_unref0 (self->priv->paned);
		self->priv->paned = _tmp23_;
		_tmp24_ = g_settings_schema_source_get_default ();
		_tmp25_ = g_settings_schema_source_lookup (_tmp24_, "io.elementary.settings", TRUE);
		sss = _tmp25_;
		_tmp27_ = sss;
		if (_tmp27_ != NULL) {
			GSettingsSchema* _tmp28_;
			_tmp28_ = sss;
			_tmp26_ = g_settings_schema_has_key (_tmp28_, "sidebar-position");
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			GSettings* settings = NULL;
			GSettings* _tmp29_;
			GSettings* _tmp30_;
			GtkPaned* _tmp31_;
			_tmp29_ = g_settings_new ("io.elementary.settings");
			settings = _tmp29_;
			_tmp30_ = settings;
			_tmp31_ = self->priv->paned;
			g_settings_bind (_tmp30_, "sidebar-position", (GObject*) _tmp31_, "position", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (settings);
		}
		_g_settings_schema_unref0 (sss);
		_g_object_unref0 (sidebar);
		_g_object_unref0 (text);
		_g_object_unref0 (appearance);
		_g_object_unref0 (multitasking);
		_g_object_unref0 (dock);
	}
	_tmp32_ = self->priv->paned;
	_tmp33_ = _g_object_ref0 ((GtkWidget*) _tmp32_);
	result = _tmp33_;
	return result;
}

static void
pantheon_shell_plug_real_shown (SwitchboardPlug* base)
{
	PantheonShellPlug * self;
	PantheonShellWallpaper* _tmp0_;
	self = (PantheonShellPlug*) base;
	_tmp0_ = self->priv->wallpaper_view;
	pantheon_shell_wallpaper_update_wallpaper_folder (_tmp0_);
}

static void
pantheon_shell_plug_real_hidden (SwitchboardPlug* base)
{
	PantheonShellPlug * self;
	PantheonShellWallpaper* _tmp0_;
	PantheonShellWallpaper* _tmp1_;
	self = (PantheonShellPlug*) base;
	_tmp0_ = self->priv->wallpaper_view;
	pantheon_shell_wallpaper_cancel_thumbnail_generation (_tmp0_);
	_tmp1_ = self->priv->wallpaper_view;
	pantheon_shell_wallpaper_confirm_removal (_tmp1_);
}

static void
pantheon_shell_plug_real_search_callback (SwitchboardPlug* base,
                                          const gchar* location)
{
	PantheonShellPlug * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	self = (PantheonShellPlug*) base;
	g_return_if_fail (location != NULL);
	_tmp0_ = location;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("wallpaper")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp3_;
				_tmp3_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp3_, "wallpaper");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("appearance")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp4_;
				_tmp4_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp4_, "appearance");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("dock")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp5_;
				_tmp5_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp5_, "dock");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("text")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp6_;
				_tmp6_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp6_, "text");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("multitasking")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp7_;
				_tmp7_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp7_, "multitasking");
				break;
			}
		}
	}
}

static void
pantheon_shell_plug_real_search_data_free (gpointer _data)
{
	PantheonShellPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PantheonShellPlugSearchData, _data_);
}

static void
pantheon_shell_plug_real_search (SwitchboardPlug* base,
                                 const gchar* search,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	PantheonShellPlug * self;
	PantheonShellPlugSearchData* _data_;
	PantheonShellPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (PantheonShellPlug*) base;
	_data_ = g_slice_new0 (PantheonShellPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pantheon_shell_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	pantheon_shell_plug_real_search_co (_data_);
}

static GeeTreeMap*
pantheon_shell_plug_search_finish (SwitchboardPlug* base,
                                   GAsyncResult* _res_)
{
	GeeTreeMap* result;
	PantheonShellPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
pantheon_shell_plug_real_search_co (PantheonShellPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->search_results = _data_->_tmp0_;
	_data_->_tmp1_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_strdup_printf ("%s → %s", _data_->_tmp2_, _ ("Wallpaper"));
	_data_->_tmp4_ = _data_->_tmp3_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp4_, "wallpaper");
	_g_free0 (_data_->_tmp4_);
	_data_->_tmp5_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_strdup_printf ("%s → %s", _data_->_tmp6_, _ ("Dock & Panel"));
	_data_->_tmp8_ = _data_->_tmp7_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp8_, "dock");
	_g_free0 (_data_->_tmp8_);
	_data_->_tmp9_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp10_, _ ("Dock & Panel"), _ ("Hide Mode"));
	_data_->_tmp12_ = _data_->_tmp11_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp12_, "dock");
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp13_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp14_, _ ("Dock & Panel"), _ ("Icon Size"));
	_data_->_tmp16_ = _data_->_tmp15_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp16_, "dock");
	_g_free0 (_data_->_tmp16_);
	_data_->_tmp17_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp18_, _ ("Dock & Panel"), _ ("Pressure reveal"));
	_data_->_tmp20_ = _data_->_tmp19_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp20_, "dock");
	_g_free0 (_data_->_tmp20_);
	_data_->_tmp21_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp22_, _ ("Dock & Panel"), _ ("Display"));
	_data_->_tmp24_ = _data_->_tmp23_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp24_, "dock");
	_g_free0 (_data_->_tmp24_);
	_data_->_tmp25_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp26_ = _data_->_tmp25_;
	_data_->_tmp27_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp26_, _ ("Dock & Panel"), _ ("Panel translucency"));
	_data_->_tmp28_ = _data_->_tmp27_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp28_, "dock");
	_g_free0 (_data_->_tmp28_);
	_data_->_tmp29_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp30_ = _data_->_tmp29_;
	_data_->_tmp31_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp30_, _ ("Dock & Panel"), _ ("Scroll on the panel to switch workspaces"));
	_data_->_tmp32_ = _data_->_tmp31_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp32_, "dock");
	_g_free0 (_data_->_tmp32_);
	_data_->_tmp33_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp34_ = _data_->_tmp33_;
	_data_->_tmp35_ = g_strdup_printf ("%s → %s", _data_->_tmp34_, _ ("Appearance"));
	_data_->_tmp36_ = _data_->_tmp35_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp36_, "appearance");
	_g_free0 (_data_->_tmp36_);
	_data_->_tmp37_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp38_ = _data_->_tmp37_;
	_data_->_tmp39_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp38_, _ ("Appearance"), _ ("Dark style"));
	_data_->_tmp40_ = _data_->_tmp39_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp40_, "appearance");
	_g_free0 (_data_->_tmp40_);
	_data_->_tmp41_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp42_ = _data_->_tmp41_;
	_data_->_tmp43_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp42_, _ ("Appearance"), _ ("Dim Wallpaper With Dark Style"));
	_data_->_tmp44_ = _data_->_tmp43_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp44_, "appearance");
	_g_free0 (_data_->_tmp44_);
	_data_->_tmp45_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp46_ = _data_->_tmp45_;
	_data_->_tmp47_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp46_, _ ("Appearance"), _ ("Accent Color"));
	_data_->_tmp48_ = _data_->_tmp47_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp48_, "appearance");
	_g_free0 (_data_->_tmp48_);
	_data_->_tmp49_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp50_ = _data_->_tmp49_;
	_data_->_tmp51_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp50_, _ ("Appearance"), _ ("Always Show Scrollbars"));
	_data_->_tmp52_ = _data_->_tmp51_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp52_, "appearance");
	_g_free0 (_data_->_tmp52_);
	_data_->_tmp53_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp54_ = _data_->_tmp53_;
	_data_->_tmp55_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp54_, _ ("Appearance"), _ ("Reduce Motion"));
	_data_->_tmp56_ = _data_->_tmp55_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp56_, "appearance");
	_g_free0 (_data_->_tmp56_);
	_data_->_tmp57_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp58_ = _data_->_tmp57_;
	_data_->_tmp59_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp58_, _ ("Appearance"), _ ("Window animations"));
	_data_->_tmp60_ = _data_->_tmp59_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp60_, "appearance");
	_g_free0 (_data_->_tmp60_);
	_data_->_tmp61_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp62_ = _data_->_tmp61_;
	_data_->_tmp63_ = g_strdup_printf ("%s → %s", _data_->_tmp62_, _ ("Text"));
	_data_->_tmp64_ = _data_->_tmp63_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp64_, "text");
	_g_free0 (_data_->_tmp64_);
	_data_->_tmp65_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp66_ = _data_->_tmp65_;
	_data_->_tmp67_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp66_, _ ("Text"), _ ("Size"));
	_data_->_tmp68_ = _data_->_tmp67_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp68_, "text");
	_g_free0 (_data_->_tmp68_);
	_data_->_tmp69_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp70_ = _data_->_tmp69_;
	_data_->_tmp71_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp70_, _ ("Text"), _ ("Dyslexia-friendly"));
	_data_->_tmp72_ = _data_->_tmp71_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp72_, "text");
	_g_free0 (_data_->_tmp72_);
	_data_->_tmp73_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp74_ = _data_->_tmp73_;
	_data_->_tmp75_ = g_strdup_printf ("%s → %s", _data_->_tmp74_, _ ("Multitasking"));
	_data_->_tmp76_ = _data_->_tmp75_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp76_, "multitasking");
	_g_free0 (_data_->_tmp76_);
	_data_->_tmp77_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp78_ = _data_->_tmp77_;
	_data_->_tmp79_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp78_, _ ("Multitasking"), _ ("Hot Corners"));
	_data_->_tmp80_ = _data_->_tmp79_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp80_, "multitasking");
	_g_free0 (_data_->_tmp80_);
	_data_->_tmp81_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp82_ = _data_->_tmp81_;
	_data_->_tmp83_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp82_, _ ("Multitasking"), _ ("Activate Hot Corners in fullscreen"));
	_data_->_tmp84_ = _data_->_tmp83_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp84_, "multitasking");
	_g_free0 (_data_->_tmp84_);
	_data_->_tmp85_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp86_ = _data_->_tmp85_;
	_data_->_tmp87_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp86_, _ ("Multitasking"), _ ("Move windows to a new workspace"));
	_data_->_tmp88_ = _data_->_tmp87_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp88_, "multitasking");
	_g_free0 (_data_->_tmp88_);
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pantheon_shell_plug_class_init (PantheonShellPlugClass * klass,
                                gpointer klass_data)
{
	pantheon_shell_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonShellPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) pantheon_shell_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) pantheon_shell_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) pantheon_shell_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) pantheon_shell_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) pantheon_shell_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) pantheon_shell_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = pantheon_shell_plug_finalize;
}

static void
pantheon_shell_plug_instance_init (PantheonShellPlug * self,
                                   gpointer klass)
{
	self->priv = pantheon_shell_plug_get_instance_private (self);
}

static void
pantheon_shell_plug_finalize (GObject * obj)
{
	PantheonShellPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_PLUG, PantheonShellPlug);
	_g_object_unref0 (self->priv->paned);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->wallpaper_view);
	G_OBJECT_CLASS (pantheon_shell_plug_parent_class)->finalize (obj);
}

static GType
pantheon_shell_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellPlug), 0, (GInstanceInitFunc) pantheon_shell_plug_instance_init, NULL };
	GType pantheon_shell_plug_type_id;
	pantheon_shell_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "PantheonShellPlug", &g_define_type_info, 0);
	PantheonShellPlug_private_offset = g_type_add_instance_private (pantheon_shell_plug_type_id, sizeof (PantheonShellPlugPrivate));
	return pantheon_shell_plug_type_id;
}

GType
pantheon_shell_plug_get_type (void)
{
	static volatile gsize pantheon_shell_plug_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_plug_type_id__once)) {
		GType pantheon_shell_plug_type_id;
		pantheon_shell_plug_type_id = pantheon_shell_plug_get_type_once ();
		g_once_init_leave (&pantheon_shell_plug_type_id__once, pantheon_shell_plug_type_id);
	}
	return pantheon_shell_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	PantheonShellPlug* plug = NULL;
	PantheonShellPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:152: Activating Desktop plug");
	_tmp0_ = pantheon_shell_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

