/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "roc-send"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "roc-send"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION "0.4.0"
#endif

enum enum_latency_backend { latency_backend__NULL = -1, latency_backend_arg_niq = 0 };
enum enum_latency_profile { latency_profile__NULL = -1, latency_profile_arg_responsive = 0, latency_profile_arg_gradual, latency_profile_arg_intact };
enum enum_resampler_backend { resampler_backend__NULL = -1, resampler_backend_arg_default = 0, resampler_backend_arg_builtin, resampler_backend_arg_speex, resampler_backend_arg_speexdec };
enum enum_resampler_profile { resampler_profile__NULL = -1, resampler_profile_arg_low = 0, resampler_profile_arg_medium, resampler_profile_arg_high };
enum enum_color { color__NULL = -1, color_arg_auto = 0, color_arg_always, color_arg_never };

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  unsigned int verbose_min; /**< @brief Increase verbosity level (may be used multiple times)'s minimum occurreces */
  unsigned int verbose_max; /**< @brief Increase verbosity level (may be used multiple times)'s maximum occurreces */
  const char *verbose_help; /**< @brief Increase verbosity level (may be used multiple times) help description.  */
  const char *list_supported_help; /**< @brief list supported schemes and formats help description.  */
  char * input_arg;	/**< @brief Input file or device URI.  */
  char * input_orig;	/**< @brief Input file or device URI original value given at command line.  */
  const char *input_help; /**< @brief Input file or device URI help description.  */
  char * input_format_arg;	/**< @brief Force input file format.  */
  char * input_format_orig;	/**< @brief Force input file format original value given at command line.  */
  const char *input_format_help; /**< @brief Force input file format help description.  */
  char ** source_arg;	/**< @brief Remote source endpoint.  */
  char ** source_orig;	/**< @brief Remote source endpoint original value given at command line.  */
  unsigned int source_min; /**< @brief Remote source endpoint's minimum occurreces */
  unsigned int source_max; /**< @brief Remote source endpoint's maximum occurreces */
  const char *source_help; /**< @brief Remote source endpoint help description.  */
  char ** repair_arg;	/**< @brief Remote repair endpoint.  */
  char ** repair_orig;	/**< @brief Remote repair endpoint original value given at command line.  */
  unsigned int repair_min; /**< @brief Remote repair endpoint's minimum occurreces */
  unsigned int repair_max; /**< @brief Remote repair endpoint's maximum occurreces */
  const char *repair_help; /**< @brief Remote repair endpoint help description.  */
  char ** control_arg;	/**< @brief Remote control endpoint.  */
  char ** control_orig;	/**< @brief Remote control endpoint original value given at command line.  */
  unsigned int control_min; /**< @brief Remote control endpoint's minimum occurreces */
  unsigned int control_max; /**< @brief Remote control endpoint's maximum occurreces */
  const char *control_help; /**< @brief Remote control endpoint help description.  */
  const char *reuseaddr_help; /**< @brief enable SO_REUSEADDR when binding sockets help description.  */
  char * target_latency_arg;	/**< @brief Target latency, TIME units.  */
  char * target_latency_orig;	/**< @brief Target latency, TIME units original value given at command line.  */
  const char *target_latency_help; /**< @brief Target latency, TIME units help description.  */
  char * io_latency_arg;	/**< @brief Recording target latency, TIME units.  */
  char * io_latency_orig;	/**< @brief Recording target latency, TIME units original value given at command line.  */
  const char *io_latency_help; /**< @brief Recording target latency, TIME units help description.  */
  char * latency_tolerance_arg;	/**< @brief Maximum deviation from target latency, TIME units.  */
  char * latency_tolerance_orig;	/**< @brief Maximum deviation from target latency, TIME units original value given at command line.  */
  const char *latency_tolerance_help; /**< @brief Maximum deviation from target latency, TIME units help description.  */
  int nbsrc_arg;	/**< @brief Number of source packets in FEC block.  */
  char * nbsrc_orig;	/**< @brief Number of source packets in FEC block original value given at command line.  */
  const char *nbsrc_help; /**< @brief Number of source packets in FEC block help description.  */
  int nbrpr_arg;	/**< @brief Number of repair packets in FEC block.  */
  char * nbrpr_orig;	/**< @brief Number of repair packets in FEC block original value given at command line.  */
  const char *nbrpr_help; /**< @brief Number of repair packets in FEC block help description.  */
  char * packet_len_arg;	/**< @brief Outgoing packet length, TIME units.  */
  char * packet_len_orig;	/**< @brief Outgoing packet length, TIME units original value given at command line.  */
  const char *packet_len_help; /**< @brief Outgoing packet length, TIME units help description.  */
  char * frame_len_arg;	/**< @brief Duration of the internal frames, TIME units.  */
  char * frame_len_orig;	/**< @brief Duration of the internal frames, TIME units original value given at command line.  */
  const char *frame_len_help; /**< @brief Duration of the internal frames, TIME units help description.  */
  char * max_packet_size_arg;	/**< @brief Maximum packet size, in SIZE units.  */
  char * max_packet_size_orig;	/**< @brief Maximum packet size, in SIZE units original value given at command line.  */
  const char *max_packet_size_help; /**< @brief Maximum packet size, in SIZE units help description.  */
  char * max_frame_size_arg;	/**< @brief Maximum internal frame size, in SIZE units.  */
  char * max_frame_size_orig;	/**< @brief Maximum internal frame size, in SIZE units original value given at command line.  */
  const char *max_frame_size_help; /**< @brief Maximum internal frame size, in SIZE units help description.  */
  int rate_arg;	/**< @brief Override input sample rate, Hz.  */
  char * rate_orig;	/**< @brief Override input sample rate, Hz original value given at command line.  */
  const char *rate_help; /**< @brief Override input sample rate, Hz help description.  */
  enum enum_latency_backend latency_backend_arg;	/**< @brief Which latency to use in latency tuner (default='niq').  */
  char * latency_backend_orig;	/**< @brief Which latency to use in latency tuner original value given at command line.  */
  const char *latency_backend_help; /**< @brief Which latency to use in latency tuner help description.  */
  enum enum_latency_profile latency_profile_arg;	/**< @brief Latency tuning profile (default='intact').  */
  char * latency_profile_orig;	/**< @brief Latency tuning profile original value given at command line.  */
  const char *latency_profile_help; /**< @brief Latency tuning profile help description.  */
  enum enum_resampler_backend resampler_backend_arg;	/**< @brief Resampler backend (default='default').  */
  char * resampler_backend_orig;	/**< @brief Resampler backend original value given at command line.  */
  const char *resampler_backend_help; /**< @brief Resampler backend help description.  */
  enum enum_resampler_profile resampler_profile_arg;	/**< @brief Resampler profile (default='medium').  */
  char * resampler_profile_orig;	/**< @brief Resampler profile original value given at command line.  */
  const char *resampler_profile_help; /**< @brief Resampler profile help description.  */
  int interleaving_flag;	/**< @brief Enable packet interleaving (default=off).  */
  const char *interleaving_help; /**< @brief Enable packet interleaving help description.  */
  int profiling_flag;	/**< @brief Enable self profiling (default=off).  */
  const char *profiling_help; /**< @brief Enable self profiling help description.  */
  enum enum_color color_arg;	/**< @brief Set colored logging mode for stderr output (default='auto').  */
  char * color_orig;	/**< @brief Set colored logging mode for stderr output original value given at command line.  */
  const char *color_help; /**< @brief Set colored logging mode for stderr output help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int list_supported_given ;	/**< @brief Whether list-supported was given.  */
  unsigned int input_given ;	/**< @brief Whether input was given.  */
  unsigned int input_format_given ;	/**< @brief Whether input-format was given.  */
  unsigned int source_given ;	/**< @brief Whether source was given.  */
  unsigned int repair_given ;	/**< @brief Whether repair was given.  */
  unsigned int control_given ;	/**< @brief Whether control was given.  */
  unsigned int reuseaddr_given ;	/**< @brief Whether reuseaddr was given.  */
  unsigned int target_latency_given ;	/**< @brief Whether target-latency was given.  */
  unsigned int io_latency_given ;	/**< @brief Whether io-latency was given.  */
  unsigned int latency_tolerance_given ;	/**< @brief Whether latency-tolerance was given.  */
  unsigned int nbsrc_given ;	/**< @brief Whether nbsrc was given.  */
  unsigned int nbrpr_given ;	/**< @brief Whether nbrpr was given.  */
  unsigned int packet_len_given ;	/**< @brief Whether packet-len was given.  */
  unsigned int frame_len_given ;	/**< @brief Whether frame-len was given.  */
  unsigned int max_packet_size_given ;	/**< @brief Whether max-packet-size was given.  */
  unsigned int max_frame_size_given ;	/**< @brief Whether max-frame-size was given.  */
  unsigned int rate_given ;	/**< @brief Whether rate was given.  */
  unsigned int latency_backend_given ;	/**< @brief Whether latency-backend was given.  */
  unsigned int latency_profile_given ;	/**< @brief Whether latency-profile was given.  */
  unsigned int resampler_backend_given ;	/**< @brief Whether resampler-backend was given.  */
  unsigned int resampler_profile_given ;	/**< @brief Whether resampler-profile was given.  */
  unsigned int interleaving_given ;	/**< @brief Whether interleaving was given.  */
  unsigned int profiling_given ;	/**< @brief Whether profiling was given.  */
  unsigned int color_given ;	/**< @brief Whether color was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);

extern const char *cmdline_parser_latency_backend_values[];  /**< @brief Possible values for latency-backend. */
extern const char *cmdline_parser_latency_profile_values[];  /**< @brief Possible values for latency-profile. */
extern const char *cmdline_parser_resampler_backend_values[];  /**< @brief Possible values for resampler-backend. */
extern const char *cmdline_parser_resampler_profile_values[];  /**< @brief Possible values for resampler-profile. */
extern const char *cmdline_parser_color_values[];  /**< @brief Possible values for color. */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
