// ui/display/mojom/display_layout.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/display/mojom/display_layout.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/display_layout.mojom-params-data.h"
namespace display {
namespace mojom {

NOINLINE static const char* PositionToStringHelper(Position value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Position::TOP:
      return "TOP";
    case Position::RIGHT:
      return "RIGHT";
    case Position::BOTTOM:
      return "BOTTOM";
    case Position::LEFT:
      return "LEFT";
    default:
      return nullptr;
  }
}

std::string PositionToString(Position value) {
  const char *str = PositionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Position value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Position value) {
  return os << PositionToString(value);
}

NOINLINE static const char* OffsetReferenceToStringHelper(OffsetReference value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case OffsetReference::TOP_LEFT:
      return "TOP_LEFT";
    case OffsetReference::BOTTOM_RIGHT:
      return "BOTTOM_RIGHT";
    default:
      return nullptr;
  }
}

std::string OffsetReferenceToString(OffsetReference value) {
  const char *str = OffsetReferenceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown OffsetReference value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, OffsetReference value) {
  return os << OffsetReferenceToString(value);
}

namespace internal {


// static
bool DisplayPlacement_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DisplayPlacement_Data* object =
      static_cast<const DisplayPlacement_Data*>(data);


  if (!::display::mojom::internal::Position_Data
        ::Validate(object->position, validation_context))
    return false;


  if (!::display::mojom::internal::OffsetReference_Data
        ::Validate(object->offset_reference, validation_context))
    return false;

  return true;
}

DisplayPlacement_Data::DisplayPlacement_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DisplayLayout_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DisplayLayout_Data* object =
      static_cast<const DisplayLayout_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->placement_list, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& placement_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->placement_list, validation_context,
                                         &placement_list_validate_params)) {
    return false;
  }

  return true;
}

DisplayLayout_Data::DisplayLayout_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace display

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::Position>::WriteIntoTrace(
   perfetto::TracedValue context, ::display::mojom::Position value) {
  return std::move(context).WriteString(::display::mojom::PositionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::OffsetReference>::WriteIntoTrace(
   perfetto::TracedValue context, ::display::mojom::OffsetReference value) {
  return std::move(context).WriteString(::display::mojom::OffsetReferenceToString(value));
}

} // namespace perfetto