// third_party/blink/public/mojom/manifest/manifest.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/device/public/mojom/screen_orientation_lock_types.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/capture_links.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/display_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/manifest_launch_handler.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/safe_url_pattern.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class ManifestDataView;

class ManifestShortcutItemDataView;

class ManifestImageResourceDataView;

class ManifestScreenshotDataView;

class ManifestFileFilterDataView;

class ManifestProtocolHandlerDataView;

class ManifestScopeExtensionDataView;

class ManifestLockScreenDataView;

class ManifestNoteTakingDataView;

class ManifestRelatedApplicationDataView;

class ManifestShareTargetParamsDataView;

class ManifestShareTargetDataView;

class ManifestFileHandlerDataView;

class ManifestTranslationItemDataView;

class ManifestTabStripDataView;

class HomeTabParamsDataView;

class NewTabButtonParamsDataView;

class ManifestDebugInfoDataView;

class ManifestErrorDataView;

class HomeTabUnionDataView;


}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ManifestDataView> {
  using Data = ::blink::mojom::internal::Manifest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestShortcutItemDataView> {
  using Data = ::blink::mojom::internal::ManifestShortcutItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestImageResourceDataView> {
  using Data = ::blink::mojom::internal::ManifestImageResource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestScreenshotDataView> {
  using Data = ::blink::mojom::internal::ManifestScreenshot_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestFileFilterDataView> {
  using Data = ::blink::mojom::internal::ManifestFileFilter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestProtocolHandlerDataView> {
  using Data = ::blink::mojom::internal::ManifestProtocolHandler_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestScopeExtensionDataView> {
  using Data = ::blink::mojom::internal::ManifestScopeExtension_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestLockScreenDataView> {
  using Data = ::blink::mojom::internal::ManifestLockScreen_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestNoteTakingDataView> {
  using Data = ::blink::mojom::internal::ManifestNoteTaking_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestRelatedApplicationDataView> {
  using Data = ::blink::mojom::internal::ManifestRelatedApplication_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestShareTargetParamsDataView> {
  using Data = ::blink::mojom::internal::ManifestShareTargetParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestShareTargetDataView> {
  using Data = ::blink::mojom::internal::ManifestShareTarget_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestFileHandlerDataView> {
  using Data = ::blink::mojom::internal::ManifestFileHandler_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestTranslationItemDataView> {
  using Data = ::blink::mojom::internal::ManifestTranslationItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestTabStripDataView> {
  using Data = ::blink::mojom::internal::ManifestTabStrip_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::HomeTabParamsDataView> {
  using Data = ::blink::mojom::internal::HomeTabParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::NewTabButtonParamsDataView> {
  using Data = ::blink::mojom::internal::NewTabButtonParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestDebugInfoDataView> {
  using Data = ::blink::mojom::internal::ManifestDebugInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ManifestErrorDataView> {
  using Data = ::blink::mojom::internal::ManifestError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::HomeTabUnionDataView> {
  using Data = ::blink::mojom::internal::HomeTabUnion_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class TabStripMemberVisibility : int32_t {
  
  kAuto = 0,
  
  kAbsent = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, TabStripMemberVisibility value);
inline bool IsKnownEnumValue(TabStripMemberVisibility value) {
  return internal::TabStripMemberVisibility_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ManifestRequestResult : int32_t {
  
  kUnexpectedFailure = 0,
  
  kNoManifestAllowed = 1,
  
  kNoManifestSpecified = 2,
  
  kManifestFailedToFetch = 3,
  
  kManifestFailedToParse = 4,
  
  kSuccess = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ManifestRequestResult value);
inline bool IsKnownEnumValue(ManifestRequestResult value) {
  return internal::ManifestRequestResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Manifest_TextDirection : int32_t {
  
  kAuto = 0,
  
  kLTR = 1,
  
  kRTL = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, Manifest_TextDirection value);
inline bool IsKnownEnumValue(Manifest_TextDirection value) {
  return internal::Manifest_TextDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ManifestImageResource_Purpose : int32_t {
  
  ANY = 0,
  
  MONOCHROME = 1,
  
  MASKABLE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ManifestImageResource_Purpose value);
inline bool IsKnownEnumValue(ManifestImageResource_Purpose value) {
  return internal::ManifestImageResource_Purpose_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ManifestScreenshot_FormFactor : int32_t {
  
  kUnknown = 0,
  
  kWide = 1,
  
  kNarrow = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ManifestScreenshot_FormFactor value);
inline bool IsKnownEnumValue(ManifestScreenshot_FormFactor value) {
  return internal::ManifestScreenshot_FormFactor_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ManifestShareTarget_Method : int32_t {
  
  kGet = 0,
  
  kPost = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ManifestShareTarget_Method value);
inline bool IsKnownEnumValue(ManifestShareTarget_Method value) {
  return internal::ManifestShareTarget_Method_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ManifestShareTarget_Enctype : int32_t {
  
  kFormUrlEncoded = 0,
  
  kMultipartFormData = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ManifestShareTarget_Enctype value);
inline bool IsKnownEnumValue(ManifestShareTarget_Enctype value) {
  return internal::ManifestShareTarget_Enctype_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ManifestFileHandler_LaunchType : int32_t {
  
  kSingleClient = 0,
  
  kMultipleClients = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ManifestFileHandler_LaunchType value);
inline bool IsKnownEnumValue(ManifestFileHandler_LaunchType value) {
  return internal::ManifestFileHandler_LaunchType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ManifestDataView {
 public:
  ManifestDataView() = default;

  ManifestDataView(
      internal::Manifest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetManifestUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManifestUrl(UserType* output) {
    
    auto* pointer = data_->manifest_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDir(UserType* output) const {
    auto data_value = data_->dir;
    return mojo::internal::Deserialize<::blink::mojom::Manifest_TextDirection>(
        data_value, output);
  }
  Manifest_TextDirection dir() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::Manifest_TextDirection>(data_->dir));
  }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetShortNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShortName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `short_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShortName` instead "
    "of `ReadShortName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->short_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `description` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDescription` instead "
    "of `ReadDescription if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool has_custom_id() const {
    return data_->has_custom_id;
  }
  inline void GetStartUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartUrl(UserType* output) {
    
    auto* pointer = data_->start_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool has_valid_specified_start_url() const {
    return data_->has_valid_specified_start_url;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDisplay(UserType* output) const {
    auto data_value = data_->display;
    return mojo::internal::Deserialize<::blink::mojom::DisplayMode>(
        data_value, output);
  }
  ::blink::mojom::DisplayMode display() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DisplayMode>(data_->display));
  }
  inline void GetDisplayOverrideDataView(
      mojo::ArrayDataView<::blink::mojom::DisplayMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayOverride(UserType* output) {
    
    auto* pointer = data_->display_override.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::DisplayMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOrientation(UserType* output) const {
    auto data_value = data_->orientation;
    return mojo::internal::Deserialize<::device::mojom::ScreenOrientationLockType>(
        data_value, output);
  }
  ::device::mojom::ScreenOrientationLockType orientation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::ScreenOrientationLockType>(data_->orientation));
  }
  inline void GetIconsDataView(
      mojo::ArrayDataView<ManifestImageResourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        pointer, output, message_);
  }
  inline void GetScreenshotsDataView(
      mojo::ArrayDataView<ManifestScreenshotDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScreenshots(UserType* output) {
    
    auto* pointer = data_->screenshots.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestScreenshotDataView>>(
        pointer, output, message_);
  }
  inline void GetShortcutsDataView(
      mojo::ArrayDataView<ManifestShortcutItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShortcuts(UserType* output) {
    
    auto* pointer = data_->shortcuts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestShortcutItemDataView>>(
        pointer, output, message_);
  }
  inline void GetShareTargetDataView(
      ManifestShareTargetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShareTarget(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ManifestShareTargetDataView, UserType>(),
    "Attempting to read the optional `share_target` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShareTarget` instead "
    "of `ReadShareTarget if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->share_target.Get();
    return mojo::internal::Deserialize<::blink::mojom::ManifestShareTargetDataView>(
        pointer, output, message_);
  }
  inline void GetFileHandlersDataView(
      mojo::ArrayDataView<ManifestFileHandlerDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileHandlers(UserType* output) {
    
    auto* pointer = data_->file_handlers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestFileHandlerDataView>>(
        pointer, output, message_);
  }
  inline void GetProtocolHandlersDataView(
      mojo::ArrayDataView<ManifestProtocolHandlerDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtocolHandlers(UserType* output) {
    
    auto* pointer = data_->protocol_handlers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestProtocolHandlerDataView>>(
        pointer, output, message_);
  }
  inline void GetScopeExtensionsDataView(
      mojo::ArrayDataView<ManifestScopeExtensionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScopeExtensions(UserType* output) {
    
    auto* pointer = data_->scope_extensions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestScopeExtensionDataView>>(
        pointer, output, message_);
  }
  inline void GetLockScreenDataView(
      ManifestLockScreenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLockScreen(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ManifestLockScreenDataView, UserType>(),
    "Attempting to read the optional `lock_screen` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLockScreen` instead "
    "of `ReadLockScreen if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->lock_screen.Get();
    return mojo::internal::Deserialize<::blink::mojom::ManifestLockScreenDataView>(
        pointer, output, message_);
  }
  inline void GetNoteTakingDataView(
      ManifestNoteTakingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNoteTaking(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ManifestNoteTakingDataView, UserType>(),
    "Attempting to read the optional `note_taking` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNoteTaking` instead "
    "of `ReadNoteTaking if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->note_taking.Get();
    return mojo::internal::Deserialize<::blink::mojom::ManifestNoteTakingDataView>(
        pointer, output, message_);
  }
  inline void GetRelatedApplicationsDataView(
      mojo::ArrayDataView<ManifestRelatedApplicationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelatedApplications(UserType* output) {
    
    auto* pointer = data_->related_applications.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestRelatedApplicationDataView>>(
        pointer, output, message_);
  }
  bool prefer_related_applications() const {
    return data_->prefer_related_applications;
  }
  bool has_theme_color() const {
    return data_->has_theme_color;
  }
  uint32_t theme_color() const {
    return data_->theme_color;
  }
  bool has_background_color() const {
    return data_->has_background_color;
  }
  uint32_t background_color() const {
    return data_->background_color;
  }
  inline void GetGcmSenderIdDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGcmSenderId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `gcm_sender_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGcmSenderId` instead "
    "of `ReadGcmSenderId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->gcm_sender_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetScopeDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScope(UserType* output) {
    
    auto* pointer = data_->scope.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCaptureLinks(UserType* output) const {
    auto data_value = data_->capture_links;
    return mojo::internal::Deserialize<::blink::mojom::CaptureLinks>(
        data_value, output);
  }
  ::blink::mojom::CaptureLinks capture_links() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::CaptureLinks>(data_->capture_links));
  }
  inline void GetPermissionsPolicyDataView(
      mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermissionsPolicy(UserType* output) {
    
    auto* pointer = data_->permissions_policy.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
        pointer, output, message_);
  }
  inline void GetLaunchHandlerDataView(
      ::blink::mojom::ManifestLaunchHandlerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLaunchHandler(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ManifestLaunchHandlerDataView, UserType>(),
    "Attempting to read the optional `launch_handler` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLaunchHandler` instead "
    "of `ReadLaunchHandler if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->launch_handler.Get();
    return mojo::internal::Deserialize<::blink::mojom::ManifestLaunchHandlerDataView>(
        pointer, output, message_);
  }
  inline void GetTranslationsDataView(
      mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestTranslationItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTranslations(UserType* output) {
    
    auto* pointer = data_->translations.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestTranslationItemDataView>>(
        pointer, output, message_);
  }
  bool has_dark_theme_color() const {
    return data_->has_dark_theme_color;
  }
  uint32_t dark_theme_color() const {
    return data_->dark_theme_color;
  }
  bool has_dark_background_color() const {
    return data_->has_dark_background_color;
  }
  uint32_t dark_background_color() const {
    return data_->dark_background_color;
  }
  inline void GetTabStripDataView(
      ManifestTabStripDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabStrip(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ManifestTabStripDataView, UserType>(),
    "Attempting to read the optional `tab_strip` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTabStrip` instead "
    "of `ReadTabStrip if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tab_strip.Get();
    return mojo::internal::Deserialize<::blink::mojom::ManifestTabStripDataView>(
        pointer, output, message_);
  }
  inline void GetVersionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersion(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `version` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVersion` instead "
    "of `ReadVersion if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->version.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::Manifest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestShortcutItemDataView {
 public:
  ManifestShortcutItemDataView() = default;

  ManifestShortcutItemDataView(
      internal::ManifestShortcutItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetShortNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShortName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `short_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShortName` instead "
    "of `ReadShortName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->short_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `description` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDescription` instead "
    "of `ReadDescription if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetIconsDataView(
      mojo::ArrayDataView<ManifestImageResourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ManifestShortcutItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestImageResourceDataView {
 public:
  ManifestImageResourceDataView() = default;

  ManifestImageResourceDataView(
      internal::ManifestImageResource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSrcDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrc(UserType* output) {
    
    auto* pointer = data_->src.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTypeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadType` instead "
    "of `ReadType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSizesDataView(
      mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSizes(UserType* output) {
    
    auto* pointer = data_->sizes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        pointer, output, message_);
  }
  inline void GetPurposeDataView(
      mojo::ArrayDataView<ManifestImageResource_Purpose>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPurpose(UserType* output) {
    
    auto* pointer = data_->purpose.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResource_Purpose>>(
        pointer, output, message_);
  }
 private:
  internal::ManifestImageResource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestScreenshotDataView {
 public:
  ManifestScreenshotDataView() = default;

  ManifestScreenshotDataView(
      internal::ManifestScreenshot_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageDataView(
      ManifestImageResourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImage(UserType* output) {
    
    auto* pointer = data_->image.Get();
    return mojo::internal::Deserialize<::blink::mojom::ManifestImageResourceDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFormFactor(UserType* output) const {
    auto data_value = data_->form_factor;
    return mojo::internal::Deserialize<::blink::mojom::ManifestScreenshot_FormFactor>(
        data_value, output);
  }
  ManifestScreenshot_FormFactor form_factor() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ManifestScreenshot_FormFactor>(data_->form_factor));
  }
  inline void GetLabelDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `label` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLabel` instead "
    "of `ReadLabel if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestScreenshot_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestFileFilterDataView {
 public:
  ManifestFileFilterDataView() = default;

  ManifestFileFilterDataView(
      internal::ManifestFileFilter_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAcceptDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccept(UserType* output) {
    
    auto* pointer = data_->accept.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
 private:
  internal::ManifestFileFilter_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestProtocolHandlerDataView {
 public:
  ManifestProtocolHandlerDataView() = default;

  ManifestProtocolHandlerDataView(
      internal::ManifestProtocolHandler_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProtocolDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtocol(UserType* output) {
    
    auto* pointer = data_->protocol.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestProtocolHandler_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestScopeExtensionDataView {
 public:
  ManifestScopeExtensionDataView() = default;

  ManifestScopeExtensionDataView(
      internal::ManifestScopeExtension_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool has_origin_wildcard() const {
    return data_->has_origin_wildcard;
  }
 private:
  internal::ManifestScopeExtension_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestLockScreenDataView {
 public:
  ManifestLockScreenDataView() = default;

  ManifestLockScreenDataView(
      internal::ManifestLockScreen_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStartUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartUrl(UserType* output) {
    
    auto* pointer = data_->start_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestLockScreen_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestNoteTakingDataView {
 public:
  ManifestNoteTakingDataView() = default;

  ManifestNoteTakingDataView(
      internal::ManifestNoteTaking_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNewNoteUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewNoteUrl(UserType* output) {
    
    auto* pointer = data_->new_note_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestNoteTaking_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestRelatedApplicationDataView {
 public:
  ManifestRelatedApplicationDataView() = default;

  ManifestRelatedApplicationDataView(
      internal::ManifestRelatedApplication_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPlatformDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlatform(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `platform` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPlatform` instead "
    "of `ReadPlatform if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->platform.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestRelatedApplication_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestShareTargetParamsDataView {
 public:
  ManifestShareTargetParamsDataView() = default;

  ManifestShareTargetParamsDataView(
      internal::ManifestShareTargetParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `title` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTitle` instead "
    "of `ReadTitle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `text` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadText` instead "
    "of `ReadText if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetFilesDataView(
      mojo::ArrayDataView<ManifestFileFilterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFiles(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::ManifestFileFilterDataView>, UserType>(),
    "Attempting to read the optional `files` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFiles` instead "
    "of `ReadFiles if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->files.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestFileFilterDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ManifestShareTargetParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestShareTargetDataView {
 public:
  ManifestShareTargetDataView() = default;

  ManifestShareTargetDataView(
      internal::ManifestShareTarget_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetActionDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) {
    
    auto* pointer = data_->action.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) const {
    auto data_value = data_->method;
    return mojo::internal::Deserialize<::blink::mojom::ManifestShareTarget_Method>(
        data_value, output);
  }
  ManifestShareTarget_Method method() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ManifestShareTarget_Method>(data_->method));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEnctype(UserType* output) const {
    auto data_value = data_->enctype;
    return mojo::internal::Deserialize<::blink::mojom::ManifestShareTarget_Enctype>(
        data_value, output);
  }
  ManifestShareTarget_Enctype enctype() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ManifestShareTarget_Enctype>(data_->enctype));
  }
  inline void GetParamsDataView(
      ManifestShareTargetParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::blink::mojom::ManifestShareTargetParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestShareTarget_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestFileHandlerDataView {
 public:
  ManifestFileHandlerDataView() = default;

  ManifestFileHandlerDataView(
      internal::ManifestFileHandler_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetActionDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) {
    
    auto* pointer = data_->action.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetIconsDataView(
      mojo::ArrayDataView<ManifestImageResourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        pointer, output, message_);
  }
  inline void GetAcceptDataView(
      mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccept(UserType* output) {
    
    auto* pointer = data_->accept.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLaunchType(UserType* output) const {
    auto data_value = data_->launch_type;
    return mojo::internal::Deserialize<::blink::mojom::ManifestFileHandler_LaunchType>(
        data_value, output);
  }
  ManifestFileHandler_LaunchType launch_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ManifestFileHandler_LaunchType>(data_->launch_type));
  }
 private:
  internal::ManifestFileHandler_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestTranslationItemDataView {
 public:
  ManifestTranslationItemDataView() = default;

  ManifestTranslationItemDataView(
      internal::ManifestTranslationItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetShortNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShortName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `short_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShortName` instead "
    "of `ReadShortName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->short_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `description` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDescription` instead "
    "of `ReadDescription if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestTranslationItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestTabStripDataView {
 public:
  ManifestTabStripDataView() = default;

  ManifestTabStripDataView(
      internal::ManifestTabStrip_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHomeTabDataView(
      HomeTabUnionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHomeTab(UserType* output) {
    
    auto* pointer = !data_->home_tab.is_null() ? &data_->home_tab : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::HomeTabUnionDataView>(
        pointer, output, message_);
  }
  inline void GetNewTabButtonDataView(
      NewTabButtonParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewTabButton(UserType* output) {
    
    auto* pointer = data_->new_tab_button.Get();
    return mojo::internal::Deserialize<::blink::mojom::NewTabButtonParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestTabStrip_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HomeTabParamsDataView {
 public:
  HomeTabParamsDataView() = default;

  HomeTabParamsDataView(
      internal::HomeTabParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIconsDataView(
      mojo::ArrayDataView<ManifestImageResourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        pointer, output, message_);
  }
  inline void GetScopePatternsDataView(
      mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScopePatterns(UserType* output) {
    
    auto* pointer = data_->scope_patterns.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>>(
        pointer, output, message_);
  }
 private:
  internal::HomeTabParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NewTabButtonParamsDataView {
 public:
  NewTabButtonParamsDataView() = default;

  NewTabButtonParamsDataView(
      internal::NewTabButtonParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::NewTabButtonParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestDebugInfoDataView {
 public:
  ManifestDebugInfoDataView() = default;

  ManifestDebugInfoDataView(
      internal::ManifestDebugInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetErrorsDataView(
      mojo::ArrayDataView<ManifestErrorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrors(UserType* output) {
    
    auto* pointer = data_->errors.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestErrorDataView>>(
        pointer, output, message_);
  }
  inline void GetRawManifestDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRawManifest(UserType* output) {
    
    auto* pointer = data_->raw_manifest.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestDebugInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestErrorDataView {
 public:
  ManifestErrorDataView() = default;

  ManifestErrorDataView(
      internal::ManifestError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool critical() const {
    return data_->critical;
  }
  uint32_t line() const {
    return data_->line;
  }
  uint32_t column() const {
    return data_->column;
  }
 private:
  internal::ManifestError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HomeTabUnionDataView {
 public:
  using Tag = internal::HomeTabUnion_Data::HomeTabUnion_Tag;

  HomeTabUnionDataView() = default;

  HomeTabUnionDataView(
      internal::HomeTabUnion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_visibility() const { return data_->tag == Tag::kVisibility; }
  template <typename UserType>
  [[nodiscard]] bool ReadVisibility(UserType* output) const {
    CHECK(is_visibility());
    return mojo::internal::Deserialize<::blink::mojom::TabStripMemberVisibility>(
        data_->data.f_visibility, output);
  }
  TabStripMemberVisibility visibility() const {
    CHECK(is_visibility());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::TabStripMemberVisibility>(data_->data.f_visibility));
  }
  bool is_params() const { return data_->tag == Tag::kParams; }
  inline void GetParamsDataView(
      HomeTabParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) const {
    
    CHECK(is_params());
    return mojo::internal::Deserialize<::blink::mojom::HomeTabParamsDataView>(
        data_->data.f_params.Get(), output, message_);
  }

 private:
  internal::HomeTabUnion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::TabStripMemberVisibility>
    : public mojo::internal::EnumHashImpl<::blink::mojom::TabStripMemberVisibility> {};

template <>
struct hash<::blink::mojom::ManifestRequestResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ManifestRequestResult> {};

template <>
struct hash<::blink::mojom::Manifest_TextDirection>
    : public mojo::internal::EnumHashImpl<::blink::mojom::Manifest_TextDirection> {};

template <>
struct hash<::blink::mojom::ManifestImageResource_Purpose>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ManifestImageResource_Purpose> {};

template <>
struct hash<::blink::mojom::ManifestScreenshot_FormFactor>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ManifestScreenshot_FormFactor> {};

template <>
struct hash<::blink::mojom::ManifestShareTarget_Method>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ManifestShareTarget_Method> {};

template <>
struct hash<::blink::mojom::ManifestShareTarget_Enctype>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ManifestShareTarget_Enctype> {};

template <>
struct hash<::blink::mojom::ManifestFileHandler_LaunchType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ManifestFileHandler_LaunchType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TabStripMemberVisibility, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::TabStripMemberVisibility, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::TabStripMemberVisibility>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestRequestResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ManifestRequestResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ManifestRequestResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::Manifest_TextDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::Manifest_TextDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Manifest_TextDirection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestImageResource_Purpose, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ManifestImageResource_Purpose, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ManifestImageResource_Purpose>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestScreenshot_FormFactor, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ManifestScreenshot_FormFactor, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ManifestScreenshot_FormFactor>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestShareTarget_Method, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ManifestShareTarget_Method, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ManifestShareTarget_Method>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestShareTarget_Enctype, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ManifestShareTarget_Enctype, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ManifestShareTarget_Enctype>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestFileHandler_LaunchType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ManifestFileHandler_LaunchType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ManifestFileHandler_LaunchType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::Manifest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::manifest_url(input)) in_manifest_url = Traits::manifest_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->manifest_url)::BaseType> manifest_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_manifest_url, manifest_url_fragment);
    fragment->manifest_url.Set(
        manifest_url_fragment.is_null() ? nullptr : manifest_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->manifest_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null manifest_url in Manifest struct");
    mojo::internal::Serialize<::blink::mojom::Manifest_TextDirection>(
        Traits::dir(input), &fragment->dir);
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    decltype(Traits::short_name(input)) in_short_name = Traits::short_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->short_name)::BaseType> short_name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_short_name, short_name_fragment);
    fragment->short_name.Set(
        short_name_fragment.is_null() ? nullptr : short_name_fragment.data());
    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_description, description_fragment);
    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in Manifest struct");
    fragment->has_custom_id = Traits::has_custom_id(input);
    decltype(Traits::start_url(input)) in_start_url = Traits::start_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start_url)::BaseType> start_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_start_url, start_url_fragment);
    fragment->start_url.Set(
        start_url_fragment.is_null() ? nullptr : start_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->start_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start_url in Manifest struct");
    fragment->has_valid_specified_start_url = Traits::has_valid_specified_start_url(input);
    mojo::internal::Serialize<::blink::mojom::DisplayMode>(
        Traits::display(input), &fragment->display);
    decltype(Traits::display_override(input)) in_display_override = Traits::display_override(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_override)::BaseType>
        display_override_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& display_override_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::DisplayMode_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::DisplayMode>>(
        in_display_override, display_override_fragment, &display_override_validate_params);
    fragment->display_override.Set(
        display_override_fragment.is_null() ? nullptr : display_override_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->display_override.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_override in Manifest struct");
    mojo::internal::Serialize<::device::mojom::ScreenOrientationLockType>(
        Traits::orientation(input), &fragment->orientation);
    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        in_icons, icons_fragment, &icons_validate_params);
    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->icons.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icons in Manifest struct");
    decltype(Traits::screenshots(input)) in_screenshots = Traits::screenshots(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->screenshots)::BaseType>
        screenshots_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& screenshots_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestScreenshotDataView>>(
        in_screenshots, screenshots_fragment, &screenshots_validate_params);
    fragment->screenshots.Set(
        screenshots_fragment.is_null() ? nullptr : screenshots_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->screenshots.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null screenshots in Manifest struct");
    decltype(Traits::shortcuts(input)) in_shortcuts = Traits::shortcuts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shortcuts)::BaseType>
        shortcuts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& shortcuts_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestShortcutItemDataView>>(
        in_shortcuts, shortcuts_fragment, &shortcuts_validate_params);
    fragment->shortcuts.Set(
        shortcuts_fragment.is_null() ? nullptr : shortcuts_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->shortcuts.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null shortcuts in Manifest struct");
    decltype(Traits::share_target(input)) in_share_target = Traits::share_target(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->share_target)::BaseType> share_target_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ManifestShareTargetDataView>(
        in_share_target, share_target_fragment);
    fragment->share_target.Set(
        share_target_fragment.is_null() ? nullptr : share_target_fragment.data());
    decltype(Traits::file_handlers(input)) in_file_handlers = Traits::file_handlers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_handlers)::BaseType>
        file_handlers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& file_handlers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestFileHandlerDataView>>(
        in_file_handlers, file_handlers_fragment, &file_handlers_validate_params);
    fragment->file_handlers.Set(
        file_handlers_fragment.is_null() ? nullptr : file_handlers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->file_handlers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null file_handlers in Manifest struct");
    decltype(Traits::protocol_handlers(input)) in_protocol_handlers = Traits::protocol_handlers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->protocol_handlers)::BaseType>
        protocol_handlers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& protocol_handlers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestProtocolHandlerDataView>>(
        in_protocol_handlers, protocol_handlers_fragment, &protocol_handlers_validate_params);
    fragment->protocol_handlers.Set(
        protocol_handlers_fragment.is_null() ? nullptr : protocol_handlers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->protocol_handlers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null protocol_handlers in Manifest struct");
    decltype(Traits::scope_extensions(input)) in_scope_extensions = Traits::scope_extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scope_extensions)::BaseType>
        scope_extensions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& scope_extensions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestScopeExtensionDataView>>(
        in_scope_extensions, scope_extensions_fragment, &scope_extensions_validate_params);
    fragment->scope_extensions.Set(
        scope_extensions_fragment.is_null() ? nullptr : scope_extensions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scope_extensions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scope_extensions in Manifest struct");
    decltype(Traits::lock_screen(input)) in_lock_screen = Traits::lock_screen(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lock_screen)::BaseType> lock_screen_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ManifestLockScreenDataView>(
        in_lock_screen, lock_screen_fragment);
    fragment->lock_screen.Set(
        lock_screen_fragment.is_null() ? nullptr : lock_screen_fragment.data());
    decltype(Traits::note_taking(input)) in_note_taking = Traits::note_taking(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->note_taking)::BaseType> note_taking_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ManifestNoteTakingDataView>(
        in_note_taking, note_taking_fragment);
    fragment->note_taking.Set(
        note_taking_fragment.is_null() ? nullptr : note_taking_fragment.data());
    decltype(Traits::related_applications(input)) in_related_applications = Traits::related_applications(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->related_applications)::BaseType>
        related_applications_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& related_applications_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestRelatedApplicationDataView>>(
        in_related_applications, related_applications_fragment, &related_applications_validate_params);
    fragment->related_applications.Set(
        related_applications_fragment.is_null() ? nullptr : related_applications_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->related_applications.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null related_applications in Manifest struct");
    fragment->prefer_related_applications = Traits::prefer_related_applications(input);
    fragment->has_theme_color = Traits::has_theme_color(input);
    fragment->theme_color = Traits::theme_color(input);
    fragment->has_background_color = Traits::has_background_color(input);
    fragment->background_color = Traits::background_color(input);
    decltype(Traits::gcm_sender_id(input)) in_gcm_sender_id = Traits::gcm_sender_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gcm_sender_id)::BaseType> gcm_sender_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_gcm_sender_id, gcm_sender_id_fragment);
    fragment->gcm_sender_id.Set(
        gcm_sender_id_fragment.is_null() ? nullptr : gcm_sender_id_fragment.data());
    decltype(Traits::scope(input)) in_scope = Traits::scope(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scope)::BaseType> scope_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_scope, scope_fragment);
    fragment->scope.Set(
        scope_fragment.is_null() ? nullptr : scope_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scope.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scope in Manifest struct");
    mojo::internal::Serialize<::blink::mojom::CaptureLinks>(
        Traits::capture_links(input), &fragment->capture_links);
    decltype(Traits::permissions_policy(input)) in_permissions_policy = Traits::permissions_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->permissions_policy)::BaseType>
        permissions_policy_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& permissions_policy_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
        in_permissions_policy, permissions_policy_fragment, &permissions_policy_validate_params);
    fragment->permissions_policy.Set(
        permissions_policy_fragment.is_null() ? nullptr : permissions_policy_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->permissions_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null permissions_policy in Manifest struct");
    decltype(Traits::launch_handler(input)) in_launch_handler = Traits::launch_handler(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->launch_handler)::BaseType> launch_handler_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ManifestLaunchHandlerDataView>(
        in_launch_handler, launch_handler_fragment);
    fragment->launch_handler.Set(
        launch_handler_fragment.is_null() ? nullptr : launch_handler_fragment.data());
    decltype(Traits::translations(input)) in_translations = Traits::translations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->translations)::BaseType>
        translations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& translations_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::blink::mojom::ManifestTranslationItemDataView>>(
        in_translations, translations_fragment, &translations_validate_params);
    fragment->translations.Set(
        translations_fragment.is_null() ? nullptr : translations_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->translations.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null translations in Manifest struct");
    fragment->has_dark_theme_color = Traits::has_dark_theme_color(input);
    fragment->dark_theme_color = Traits::dark_theme_color(input);
    fragment->has_dark_background_color = Traits::has_dark_background_color(input);
    fragment->dark_background_color = Traits::dark_background_color(input);
    decltype(Traits::tab_strip(input)) in_tab_strip = Traits::tab_strip(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab_strip)::BaseType> tab_strip_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ManifestTabStripDataView>(
        in_tab_strip, tab_strip_fragment);
    fragment->tab_strip.Set(
        tab_strip_fragment.is_null() ? nullptr : tab_strip_fragment.data());
    decltype(Traits::version(input)) in_version = Traits::version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->version)::BaseType> version_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_version, version_fragment);
    fragment->version.Set(
        version_fragment.is_null() ? nullptr : version_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::Manifest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestShortcutItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestShortcutItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestShortcutItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ManifestShortcutItem struct");
    decltype(Traits::short_name(input)) in_short_name = Traits::short_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->short_name)::BaseType> short_name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_short_name, short_name_fragment);
    fragment->short_name.Set(
        short_name_fragment.is_null() ? nullptr : short_name_fragment.data());
    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_description, description_fragment);
    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in ManifestShortcutItem struct");
    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        in_icons, icons_fragment, &icons_validate_params);
    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->icons.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icons in ManifestShortcutItem struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestShortcutItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestShortcutItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestImageResourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestImageResourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestImageResource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::src(input)) in_src = Traits::src(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->src)::BaseType> src_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_src, src_fragment);
    fragment->src.Set(
        src_fragment.is_null() ? nullptr : src_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->src.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null src in ManifestImageResource struct");
    decltype(Traits::type(input)) in_type = Traits::type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->type)::BaseType> type_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_type, type_fragment);
    fragment->type.Set(
        type_fragment.is_null() ? nullptr : type_fragment.data());
    decltype(Traits::sizes(input)) in_sizes = Traits::sizes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sizes)::BaseType>
        sizes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sizes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        in_sizes, sizes_fragment, &sizes_validate_params);
    fragment->sizes.Set(
        sizes_fragment.is_null() ? nullptr : sizes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sizes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sizes in ManifestImageResource struct");
    decltype(Traits::purpose(input)) in_purpose = Traits::purpose(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->purpose)::BaseType>
        purpose_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& purpose_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::ManifestImageResource_Purpose_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResource_Purpose>>(
        in_purpose, purpose_fragment, &purpose_validate_params);
    fragment->purpose.Set(
        purpose_fragment.is_null() ? nullptr : purpose_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->purpose.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null purpose in ManifestImageResource struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestImageResource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestImageResourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestScreenshotDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestScreenshotDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestScreenshot_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::image(input)) in_image = Traits::image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image)::BaseType> image_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ManifestImageResourceDataView>(
        in_image, image_fragment);
    fragment->image.Set(
        image_fragment.is_null() ? nullptr : image_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->image.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image in ManifestScreenshot struct");
    mojo::internal::Serialize<::blink::mojom::ManifestScreenshot_FormFactor>(
        Traits::form_factor(input), &fragment->form_factor);
    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_label, label_fragment);
    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::ManifestScreenshot_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestScreenshotDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestFileFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestFileFilterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestFileFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    decltype(Traits::accept(input)) in_accept = Traits::accept(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accept)::BaseType>
        accept_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& accept_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        in_accept, accept_fragment, &accept_validate_params);
    fragment->accept.Set(
        accept_fragment.is_null() ? nullptr : accept_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->accept.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accept in ManifestFileFilter struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestFileFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestFileFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestProtocolHandlerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestProtocolHandlerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestProtocolHandler_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::protocol(input)) in_protocol = Traits::protocol(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->protocol)::BaseType> protocol_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_protocol, protocol_fragment);
    fragment->protocol.Set(
        protocol_fragment.is_null() ? nullptr : protocol_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->protocol.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null protocol in ManifestProtocolHandler struct");
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in ManifestProtocolHandler struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestProtocolHandler_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestProtocolHandlerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestScopeExtensionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestScopeExtensionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestScopeExtension_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin, origin_fragment);
    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in ManifestScopeExtension struct");
    fragment->has_origin_wildcard = Traits::has_origin_wildcard(input);
  }

  static bool Deserialize(::blink::mojom::internal::ManifestScopeExtension_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestScopeExtensionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestLockScreenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestLockScreenDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestLockScreen_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::start_url(input)) in_start_url = Traits::start_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start_url)::BaseType> start_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_start_url, start_url_fragment);
    fragment->start_url.Set(
        start_url_fragment.is_null() ? nullptr : start_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->start_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start_url in ManifestLockScreen struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestLockScreen_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestLockScreenDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestNoteTakingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestNoteTakingDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestNoteTaking_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::new_note_url(input)) in_new_note_url = Traits::new_note_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->new_note_url)::BaseType> new_note_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_new_note_url, new_note_url_fragment);
    fragment->new_note_url.Set(
        new_note_url_fragment.is_null() ? nullptr : new_note_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->new_note_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_note_url in ManifestNoteTaking struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestNoteTaking_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestNoteTakingDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestRelatedApplicationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestRelatedApplicationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestRelatedApplication_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::platform(input)) in_platform = Traits::platform(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->platform)::BaseType> platform_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_platform, platform_fragment);
    fragment->platform.Set(
        platform_fragment.is_null() ? nullptr : platform_fragment.data());
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::ManifestRelatedApplication_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestRelatedApplicationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestShareTargetParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestShareTargetParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestShareTargetParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_title, title_fragment);
    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());
    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_text, text_fragment);
    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    decltype(Traits::files(input)) in_files = Traits::files(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->files)::BaseType>
        files_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestFileFilterDataView>>(
        in_files, files_fragment, &files_validate_params);
    fragment->files.Set(
        files_fragment.is_null() ? nullptr : files_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::ManifestShareTargetParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestShareTargetParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestShareTargetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestShareTargetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestShareTarget_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::action(input)) in_action = Traits::action(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->action)::BaseType> action_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_action, action_fragment);
    fragment->action.Set(
        action_fragment.is_null() ? nullptr : action_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->action.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null action in ManifestShareTarget struct");
    mojo::internal::Serialize<::blink::mojom::ManifestShareTarget_Method>(
        Traits::method(input), &fragment->method);
    mojo::internal::Serialize<::blink::mojom::ManifestShareTarget_Enctype>(
        Traits::enctype(input), &fragment->enctype);
    decltype(Traits::params(input)) in_params = Traits::params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->params)::BaseType> params_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ManifestShareTargetParamsDataView>(
        in_params, params_fragment);
    fragment->params.Set(
        params_fragment.is_null() ? nullptr : params_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in ManifestShareTarget struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestShareTarget_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestShareTargetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestFileHandlerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestFileHandlerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestFileHandler_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::action(input)) in_action = Traits::action(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->action)::BaseType> action_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_action, action_fragment);
    fragment->action.Set(
        action_fragment.is_null() ? nullptr : action_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->action.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null action in ManifestFileHandler struct");
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ManifestFileHandler struct");
    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        in_icons, icons_fragment, &icons_validate_params);
    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->icons.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icons in ManifestFileHandler struct");
    decltype(Traits::accept(input)) in_accept = Traits::accept(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accept)::BaseType>
        accept_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& accept_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>>(
        in_accept, accept_fragment, &accept_validate_params);
    fragment->accept.Set(
        accept_fragment.is_null() ? nullptr : accept_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->accept.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accept in ManifestFileHandler struct");
    mojo::internal::Serialize<::blink::mojom::ManifestFileHandler_LaunchType>(
        Traits::launch_type(input), &fragment->launch_type);
  }

  static bool Deserialize(::blink::mojom::internal::ManifestFileHandler_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestFileHandlerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestTranslationItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestTranslationItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestTranslationItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    decltype(Traits::short_name(input)) in_short_name = Traits::short_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->short_name)::BaseType> short_name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_short_name, short_name_fragment);
    fragment->short_name.Set(
        short_name_fragment.is_null() ? nullptr : short_name_fragment.data());
    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_description, description_fragment);
    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::ManifestTranslationItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestTranslationItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestTabStripDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestTabStripDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestTabStrip_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::home_tab(input)) in_home_tab = Traits::home_tab(input);
    mojo::internal::MessageFragment<decltype(fragment->home_tab)>
        home_tab_fragment(fragment.message());
    home_tab_fragment.Claim(&fragment->home_tab);
    mojo::internal::Serialize<::blink::mojom::HomeTabUnionDataView>(
        in_home_tab, home_tab_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->home_tab.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null home_tab in ManifestTabStrip struct");
    decltype(Traits::new_tab_button(input)) in_new_tab_button = Traits::new_tab_button(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->new_tab_button)::BaseType> new_tab_button_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::NewTabButtonParamsDataView>(
        in_new_tab_button, new_tab_button_fragment);
    fragment->new_tab_button.Set(
        new_tab_button_fragment.is_null() ? nullptr : new_tab_button_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->new_tab_button.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_tab_button in ManifestTabStrip struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestTabStrip_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestTabStripDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HomeTabParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::HomeTabParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::HomeTabParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        in_icons, icons_fragment, &icons_validate_params);
    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->icons.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icons in HomeTabParams struct");
    decltype(Traits::scope_patterns(input)) in_scope_patterns = Traits::scope_patterns(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scope_patterns)::BaseType>
        scope_patterns_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& scope_patterns_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>>(
        in_scope_patterns, scope_patterns_fragment, &scope_patterns_validate_params);
    fragment->scope_patterns.Set(
        scope_patterns_fragment.is_null() ? nullptr : scope_patterns_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scope_patterns.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scope_patterns in HomeTabParams struct");
  }

  static bool Deserialize(::blink::mojom::internal::HomeTabParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::HomeTabParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NewTabButtonParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::NewTabButtonParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::NewTabButtonParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::NewTabButtonParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::NewTabButtonParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestDebugInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestDebugInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestDebugInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::errors(input)) in_errors = Traits::errors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->errors)::BaseType>
        errors_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& errors_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestErrorDataView>>(
        in_errors, errors_fragment, &errors_validate_params);
    fragment->errors.Set(
        errors_fragment.is_null() ? nullptr : errors_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->errors.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null errors in ManifestDebugInfo struct");
    decltype(Traits::raw_manifest(input)) in_raw_manifest = Traits::raw_manifest(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raw_manifest)::BaseType> raw_manifest_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_raw_manifest, raw_manifest_fragment);
    fragment->raw_manifest.Set(
        raw_manifest_fragment.is_null() ? nullptr : raw_manifest_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->raw_manifest.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null raw_manifest in ManifestDebugInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::ManifestDebugInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestDebugInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ManifestErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ManifestErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ManifestError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_message, message_fragment);
    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->message.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in ManifestError struct");
    fragment->critical = Traits::critical(input);
    fragment->line = Traits::line(input);
    fragment->column = Traits::column(input);
  }

  static bool Deserialize(::blink::mojom::internal::ManifestError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ManifestErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HomeTabUnionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::HomeTabUnionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::HomeTabUnion_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::HomeTabUnionDataView::Tag::kVisibility: {
        decltype(Traits::visibility(input))
            in_visibility = Traits::visibility(input);
        mojo::internal::Serialize<::blink::mojom::TabStripMemberVisibility>(
            in_visibility, &fragment->data.f_visibility);
        break;
      }
      case ::blink::mojom::HomeTabUnionDataView::Tag::kParams: {
        decltype(Traits::params(input))
            in_params = Traits::params(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_params)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::HomeTabParamsDataView>(
            in_params, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null params in HomeTabUnion union");
        fragment->data.f_params.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::HomeTabUnion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::HomeTabUnionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void ManifestDataView::GetManifestUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->manifest_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestDataView::GetShortNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->short_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestDataView::GetDescriptionDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->description.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestDataView::GetIdDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestDataView::GetStartUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->start_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestDataView::GetDisplayOverrideDataView(
    mojo::ArrayDataView<::blink::mojom::DisplayMode>* output) {
  auto pointer = data_->display_override.Get();
  *output = mojo::ArrayDataView<::blink::mojom::DisplayMode>(pointer, message_);
}
inline void ManifestDataView::GetIconsDataView(
    mojo::ArrayDataView<ManifestImageResourceDataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::ArrayDataView<ManifestImageResourceDataView>(pointer, message_);
}
inline void ManifestDataView::GetScreenshotsDataView(
    mojo::ArrayDataView<ManifestScreenshotDataView>* output) {
  auto pointer = data_->screenshots.Get();
  *output = mojo::ArrayDataView<ManifestScreenshotDataView>(pointer, message_);
}
inline void ManifestDataView::GetShortcutsDataView(
    mojo::ArrayDataView<ManifestShortcutItemDataView>* output) {
  auto pointer = data_->shortcuts.Get();
  *output = mojo::ArrayDataView<ManifestShortcutItemDataView>(pointer, message_);
}
inline void ManifestDataView::GetShareTargetDataView(
    ManifestShareTargetDataView* output) {
  auto pointer = data_->share_target.Get();
  *output = ManifestShareTargetDataView(pointer, message_);
}
inline void ManifestDataView::GetFileHandlersDataView(
    mojo::ArrayDataView<ManifestFileHandlerDataView>* output) {
  auto pointer = data_->file_handlers.Get();
  *output = mojo::ArrayDataView<ManifestFileHandlerDataView>(pointer, message_);
}
inline void ManifestDataView::GetProtocolHandlersDataView(
    mojo::ArrayDataView<ManifestProtocolHandlerDataView>* output) {
  auto pointer = data_->protocol_handlers.Get();
  *output = mojo::ArrayDataView<ManifestProtocolHandlerDataView>(pointer, message_);
}
inline void ManifestDataView::GetScopeExtensionsDataView(
    mojo::ArrayDataView<ManifestScopeExtensionDataView>* output) {
  auto pointer = data_->scope_extensions.Get();
  *output = mojo::ArrayDataView<ManifestScopeExtensionDataView>(pointer, message_);
}
inline void ManifestDataView::GetLockScreenDataView(
    ManifestLockScreenDataView* output) {
  auto pointer = data_->lock_screen.Get();
  *output = ManifestLockScreenDataView(pointer, message_);
}
inline void ManifestDataView::GetNoteTakingDataView(
    ManifestNoteTakingDataView* output) {
  auto pointer = data_->note_taking.Get();
  *output = ManifestNoteTakingDataView(pointer, message_);
}
inline void ManifestDataView::GetRelatedApplicationsDataView(
    mojo::ArrayDataView<ManifestRelatedApplicationDataView>* output) {
  auto pointer = data_->related_applications.Get();
  *output = mojo::ArrayDataView<ManifestRelatedApplicationDataView>(pointer, message_);
}
inline void ManifestDataView::GetGcmSenderIdDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->gcm_sender_id.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestDataView::GetScopeDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->scope.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestDataView::GetPermissionsPolicyDataView(
    mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>* output) {
  auto pointer = data_->permissions_policy.Get();
  *output = mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>(pointer, message_);
}
inline void ManifestDataView::GetLaunchHandlerDataView(
    ::blink::mojom::ManifestLaunchHandlerDataView* output) {
  auto pointer = data_->launch_handler.Get();
  *output = ::blink::mojom::ManifestLaunchHandlerDataView(pointer, message_);
}
inline void ManifestDataView::GetTranslationsDataView(
    mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestTranslationItemDataView>* output) {
  auto pointer = data_->translations.Get();
  *output = mojo::MapDataView<::mojo_base::mojom::String16DataView, ManifestTranslationItemDataView>(pointer, message_);
}
inline void ManifestDataView::GetTabStripDataView(
    ManifestTabStripDataView* output) {
  auto pointer = data_->tab_strip.Get();
  *output = ManifestTabStripDataView(pointer, message_);
}
inline void ManifestDataView::GetVersionDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->version.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void ManifestShortcutItemDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestShortcutItemDataView::GetShortNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->short_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestShortcutItemDataView::GetDescriptionDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->description.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestShortcutItemDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestShortcutItemDataView::GetIconsDataView(
    mojo::ArrayDataView<ManifestImageResourceDataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::ArrayDataView<ManifestImageResourceDataView>(pointer, message_);
}


inline void ManifestImageResourceDataView::GetSrcDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->src.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestImageResourceDataView::GetTypeDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->type.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestImageResourceDataView::GetSizesDataView(
    mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output) {
  auto pointer = data_->sizes.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::SizeDataView>(pointer, message_);
}
inline void ManifestImageResourceDataView::GetPurposeDataView(
    mojo::ArrayDataView<ManifestImageResource_Purpose>* output) {
  auto pointer = data_->purpose.Get();
  *output = mojo::ArrayDataView<ManifestImageResource_Purpose>(pointer, message_);
}


inline void ManifestScreenshotDataView::GetImageDataView(
    ManifestImageResourceDataView* output) {
  auto pointer = data_->image.Get();
  *output = ManifestImageResourceDataView(pointer, message_);
}
inline void ManifestScreenshotDataView::GetLabelDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->label.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void ManifestFileFilterDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestFileFilterDataView::GetAcceptDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->accept.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(pointer, message_);
}


inline void ManifestProtocolHandlerDataView::GetProtocolDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->protocol.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestProtocolHandlerDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void ManifestScopeExtensionDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void ManifestLockScreenDataView::GetStartUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->start_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void ManifestNoteTakingDataView::GetNewNoteUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->new_note_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void ManifestRelatedApplicationDataView::GetPlatformDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->platform.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestRelatedApplicationDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestRelatedApplicationDataView::GetIdDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->id.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void ManifestShareTargetParamsDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestShareTargetParamsDataView::GetTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestShareTargetParamsDataView::GetUrlDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->url.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestShareTargetParamsDataView::GetFilesDataView(
    mojo::ArrayDataView<ManifestFileFilterDataView>* output) {
  auto pointer = data_->files.Get();
  *output = mojo::ArrayDataView<ManifestFileFilterDataView>(pointer, message_);
}


inline void ManifestShareTargetDataView::GetActionDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->action.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestShareTargetDataView::GetParamsDataView(
    ManifestShareTargetParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = ManifestShareTargetParamsDataView(pointer, message_);
}


inline void ManifestFileHandlerDataView::GetActionDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->action.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ManifestFileHandlerDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestFileHandlerDataView::GetIconsDataView(
    mojo::ArrayDataView<ManifestImageResourceDataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::ArrayDataView<ManifestImageResourceDataView>(pointer, message_);
}
inline void ManifestFileHandlerDataView::GetAcceptDataView(
    mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>* output) {
  auto pointer = data_->accept.Get();
  *output = mojo::MapDataView<::mojo_base::mojom::String16DataView, mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(pointer, message_);
}


inline void ManifestTranslationItemDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestTranslationItemDataView::GetShortNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->short_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ManifestTranslationItemDataView::GetDescriptionDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->description.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void ManifestTabStripDataView::GetHomeTabDataView(
    HomeTabUnionDataView* output) {
  auto pointer = &data_->home_tab;
  *output = HomeTabUnionDataView(pointer, message_);
}
inline void ManifestTabStripDataView::GetNewTabButtonDataView(
    NewTabButtonParamsDataView* output) {
  auto pointer = data_->new_tab_button.Get();
  *output = NewTabButtonParamsDataView(pointer, message_);
}


inline void HomeTabParamsDataView::GetIconsDataView(
    mojo::ArrayDataView<ManifestImageResourceDataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::ArrayDataView<ManifestImageResourceDataView>(pointer, message_);
}
inline void HomeTabParamsDataView::GetScopePatternsDataView(
    mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>* output) {
  auto pointer = data_->scope_patterns.Get();
  *output = mojo::ArrayDataView<::blink::mojom::SafeUrlPatternDataView>(pointer, message_);
}


inline void NewTabButtonParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void ManifestDebugInfoDataView::GetErrorsDataView(
    mojo::ArrayDataView<ManifestErrorDataView>* output) {
  auto pointer = data_->errors.Get();
  *output = mojo::ArrayDataView<ManifestErrorDataView>(pointer, message_);
}
inline void ManifestDebugInfoDataView::GetRawManifestDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->raw_manifest.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ManifestErrorDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void HomeTabUnionDataView::GetParamsDataView(
    HomeTabParamsDataView* output) const {
  CHECK(is_params());
  *output = HomeTabParamsDataView(data_->data.f_params.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::TabStripMemberVisibility> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::TabStripMemberVisibility value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ManifestRequestResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ManifestRequestResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::Manifest_TextDirection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::Manifest_TextDirection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ManifestImageResource_Purpose> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ManifestImageResource_Purpose value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ManifestScreenshot_FormFactor> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ManifestScreenshot_FormFactor value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ManifestShareTarget_Method> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ManifestShareTarget_Method value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ManifestShareTarget_Enctype> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ManifestShareTarget_Enctype value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ManifestFileHandler_LaunchType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ManifestFileHandler_LaunchType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_SHARED_H_