// services/viz/public/mojom/compositing/copy_output_request.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/copy_output_result.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace viz::mojom {
class CopyOutputRequestDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::CopyOutputRequestDataView> {
  using Data = ::viz::mojom::internal::CopyOutputRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {
// Interface base classes. They are used for type safety check.
class CopyOutputResultSenderInterfaceBase {};

using CopyOutputResultSenderPtrDataView =
    mojo::InterfacePtrDataView<CopyOutputResultSenderInterfaceBase>;
using CopyOutputResultSenderRequestDataView =
    mojo::InterfaceRequestDataView<CopyOutputResultSenderInterfaceBase>;
using CopyOutputResultSenderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CopyOutputResultSenderInterfaceBase>;
using CopyOutputResultSenderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CopyOutputResultSenderInterfaceBase>;


class CopyOutputRequestDataView {
 public:
  CopyOutputRequestDataView() = default;

  CopyOutputRequestDataView(
      internal::CopyOutputRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResultFormat(UserType* output) const {
    auto data_value = data_->result_format;
    return mojo::internal::Deserialize<::viz::mojom::CopyOutputResultFormat>(
        data_value, output);
  }
  ::viz::mojom::CopyOutputResultFormat result_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::CopyOutputResultFormat>(data_->result_format));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResultDestination(UserType* output) const {
    auto data_value = data_->result_destination;
    return mojo::internal::Deserialize<::viz::mojom::CopyOutputResultDestination>(
        data_value, output);
  }
  ::viz::mojom::CopyOutputResultDestination result_destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::CopyOutputResultDestination>(data_->result_destination));
  }
  inline void GetScaleFromDataView(
      ::gfx::mojom::Vector2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScaleFrom(UserType* output) {
    
    auto* pointer = data_->scale_from.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dDataView>(
        pointer, output, message_);
  }
  inline void GetScaleToDataView(
      ::gfx::mojom::Vector2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScaleTo(UserType* output) {
    
    auto* pointer = data_->scale_to.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dDataView>(
        pointer, output, message_);
  }
  inline void GetSourceDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `source` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSource` instead "
    "of `ReadSource if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->source.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArea(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `area` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadArea` instead "
    "of `ReadArea if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetResultSelectionDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResultSelection(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `result_selection` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResultSelection` instead "
    "of `ReadResultSelection if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->result_selection.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeResultSender() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::viz::mojom::CopyOutputResultSenderInterfaceBase>>(
            &data_->result_sender, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CopyOutputRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::CopyOutputRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CopyOutputRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::CopyOutputRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::viz::mojom::CopyOutputResultFormat>(
        Traits::result_format(input), &fragment->result_format);
    mojo::internal::Serialize<::viz::mojom::CopyOutputResultDestination>(
        Traits::result_destination(input), &fragment->result_destination);
    decltype(Traits::scale_from(input)) in_scale_from = Traits::scale_from(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scale_from)::BaseType> scale_from_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dDataView>(
        in_scale_from, scale_from_fragment);
    fragment->scale_from.Set(
        scale_from_fragment.is_null() ? nullptr : scale_from_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scale_from.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scale_from in CopyOutputRequest struct");
    decltype(Traits::scale_to(input)) in_scale_to = Traits::scale_to(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scale_to)::BaseType> scale_to_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dDataView>(
        in_scale_to, scale_to_fragment);
    fragment->scale_to.Set(
        scale_to_fragment.is_null() ? nullptr : scale_to_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scale_to.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scale_to in CopyOutputRequest struct");
    decltype(Traits::source(input)) in_source = Traits::source(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source)::BaseType> source_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_source, source_fragment);
    fragment->source.Set(
        source_fragment.is_null() ? nullptr : source_fragment.data());
    decltype(Traits::area(input)) in_area = Traits::area(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->area)::BaseType> area_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_area, area_fragment);
    fragment->area.Set(
        area_fragment.is_null() ? nullptr : area_fragment.data());
    decltype(Traits::result_selection(input)) in_result_selection = Traits::result_selection(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->result_selection)::BaseType> result_selection_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_result_selection, result_selection_fragment);
    fragment->result_selection.Set(
        result_selection_fragment.is_null() ? nullptr : result_selection_fragment.data());
    decltype(Traits::result_sender(input)) in_result_sender = Traits::result_sender(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::CopyOutputResultSenderInterfaceBase>>(
        in_result_sender, &fragment->result_sender, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->result_sender),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid result_sender in CopyOutputRequest struct");
  }

  static bool Deserialize(::viz::mojom::internal::CopyOutputRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::CopyOutputRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void CopyOutputRequestDataView::GetScaleFromDataView(
    ::gfx::mojom::Vector2dDataView* output) {
  auto pointer = data_->scale_from.Get();
  *output = ::gfx::mojom::Vector2dDataView(pointer, message_);
}
inline void CopyOutputRequestDataView::GetScaleToDataView(
    ::gfx::mojom::Vector2dDataView* output) {
  auto pointer = data_->scale_to.Get();
  *output = ::gfx::mojom::Vector2dDataView(pointer, message_);
}
inline void CopyOutputRequestDataView::GetSourceDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->source.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void CopyOutputRequestDataView::GetAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void CopyOutputRequestDataView::GetResultSelectionDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->result_selection.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_SHARED_H_