// services/device/public/mojom/geolocation_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/geolocation_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/geolocation_internals.mojom-params-data.h"
namespace device {
namespace mojom {

NOINLINE static const char* LocationProviderManagerModeToStringHelper(LocationProviderManagerMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LocationProviderManagerMode::kNetworkOnly:
      return "kNetworkOnly";
    case LocationProviderManagerMode::kPlatformOnly:
      return "kPlatformOnly";
    case LocationProviderManagerMode::kCustomOnly:
      return "kCustomOnly";
    case LocationProviderManagerMode::kHybridPlatform:
      return "kHybridPlatform";
    case LocationProviderManagerMode::kHybridFallbackNetwork:
      return "kHybridFallbackNetwork";
    case LocationProviderManagerMode::kHybridPlatform2:
      return "kHybridPlatform2";
    default:
      return nullptr;
  }
}

std::string LocationProviderManagerModeToString(LocationProviderManagerMode value) {
  const char *str = LocationProviderManagerModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LocationProviderManagerMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LocationProviderManagerMode value) {
  return os << LocationProviderManagerModeToString(value);
}

NOINLINE static const char* GeolocationDiagnostics_ProviderStateToStringHelper(GeolocationDiagnostics_ProviderState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GeolocationDiagnostics_ProviderState::kStopped:
      return "kStopped";
    case GeolocationDiagnostics_ProviderState::kHighAccuracy:
      return "kHighAccuracy";
    case GeolocationDiagnostics_ProviderState::kLowAccuracy:
      return "kLowAccuracy";
    case GeolocationDiagnostics_ProviderState::kBlockedBySystemPermission:
      return "kBlockedBySystemPermission";
    default:
      return nullptr;
  }
}

std::string GeolocationDiagnostics_ProviderStateToString(GeolocationDiagnostics_ProviderState value) {
  const char *str = GeolocationDiagnostics_ProviderStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GeolocationDiagnostics_ProviderState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GeolocationDiagnostics_ProviderState value) {
  return os << GeolocationDiagnostics_ProviderStateToString(value);
}

namespace internal {


// static
bool AccessPointData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AccessPointData_Data* object =
      static_cast<const AccessPointData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mac_address, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mac_address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mac_address, validation_context,
                                         &mac_address_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  return true;
}

AccessPointData_Data::AccessPointData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkLocationDiagnostics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkLocationDiagnostics_Data* object =
      static_cast<const NetworkLocationDiagnostics_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_point_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& access_point_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->access_point_data, validation_context,
                                         &access_point_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->wifi_timestamp, validation_context))
    return false;

  return true;
}

NetworkLocationDiagnostics_Data::NetworkLocationDiagnostics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PositionCacheDiagnostics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PositionCacheDiagnostics_Data* object =
      static_cast<const PositionCacheDiagnostics_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->last_hit, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->last_miss, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->last_network_result, validation_context))
    return false;

  return true;
}

PositionCacheDiagnostics_Data::PositionCacheDiagnostics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WifiPollingPolicyDiagnostics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WifiPollingPolicyDiagnostics_Data* object =
      static_cast<const WifiPollingPolicyDiagnostics_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->interval_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interval_duration, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->interval_duration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->polling_interval, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->polling_interval, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_interval, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_interval, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->no_change_interval, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->no_change_interval, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->two_no_change_interval, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->two_no_change_interval, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->no_wifi_interval, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->no_wifi_interval, validation_context))
    return false;

  return true;
}

WifiPollingPolicyDiagnostics_Data::WifiPollingPolicyDiagnostics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GeolocationDiagnostics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GeolocationDiagnostics_Data* object =
      static_cast<const GeolocationDiagnostics_Data*>(data);


  if (!::device::mojom::internal::GeolocationDiagnostics_ProviderState_Data
        ::Validate(object->provider_state, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->network_location_diagnostics, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->position_cache_diagnostics, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->wifi_polling_policy_diagnostics, validation_context))
    return false;


  if (!::device::mojom::internal::LocationProviderManagerMode_Data
        ::Validate(object->location_provider_manager_mode_$value, validation_context))
    return false;

  return true;
}

GeolocationDiagnostics_Data::GeolocationDiagnostics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkLocationResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkLocationResponse_Data* object =
      static_cast<const NetworkLocationResponse_Data*>(data);

  return true;
}

NetworkLocationResponse_Data::NetworkLocationResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GeolocationInternalsObserver_OnDiagnosticsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GeolocationInternalsObserver_OnDiagnosticsChanged_Params_Data* object =
      static_cast<const GeolocationInternalsObserver_OnDiagnosticsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->diagnostics, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->diagnostics, validation_context))
    return false;

  return true;
}

GeolocationInternalsObserver_OnDiagnosticsChanged_Params_Data::GeolocationInternalsObserver_OnDiagnosticsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GeolocationInternalsObserver_OnNetworkLocationRequested_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GeolocationInternalsObserver_OnNetworkLocationRequested_Params_Data* object =
      static_cast<const GeolocationInternalsObserver_OnNetworkLocationRequested_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_point_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& access_point_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->access_point_data, validation_context,
                                         &access_point_data_validate_params)) {
    return false;
  }

  return true;
}

GeolocationInternalsObserver_OnNetworkLocationRequested_Params_Data::GeolocationInternalsObserver_OnNetworkLocationRequested_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GeolocationInternalsObserver_OnNetworkLocationReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GeolocationInternalsObserver_OnNetworkLocationReceived_Params_Data* object =
      static_cast<const GeolocationInternalsObserver_OnNetworkLocationReceived_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

GeolocationInternalsObserver_OnNetworkLocationReceived_Params_Data::GeolocationInternalsObserver_OnNetworkLocationReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GeolocationInternals_AddInternalsObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GeolocationInternals_AddInternalsObserver_Params_Data* object =
      static_cast<const GeolocationInternals_AddInternalsObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

GeolocationInternals_AddInternalsObserver_Params_Data::GeolocationInternals_AddInternalsObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GeolocationInternals_AddInternalsObserver_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GeolocationInternals_AddInternalsObserver_ResponseParams_Data* object =
      static_cast<const GeolocationInternals_AddInternalsObserver_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->diagnostics, validation_context))
    return false;

  return true;
}

GeolocationInternals_AddInternalsObserver_ResponseParams_Data::GeolocationInternals_AddInternalsObserver_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::LocationProviderManagerMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::LocationProviderManagerMode value) {
  return std::move(context).WriteString(::device::mojom::LocationProviderManagerModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::GeolocationDiagnostics_ProviderState>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::GeolocationDiagnostics_ProviderState value) {
  return std::move(context).WriteString(::device::mojom::GeolocationDiagnostics_ProviderStateToString(value));
}

} // namespace perfetto