// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/devtools/protocol/dom.h"

#include "content/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace content {
namespace protocol {
namespace DOM {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "DOM";
const char Metainfo::commandPrefix[] = "DOM.";
const char Metainfo::version[] = "1.3";



CRDTP_BEGIN_DESERIALIZER(RGBA)
    CRDTP_DESERIALIZE_FIELD_OPT("a", m_a),
    CRDTP_DESERIALIZE_FIELD("b", m_b),
    CRDTP_DESERIALIZE_FIELD("g", m_g),
    CRDTP_DESERIALIZE_FIELD("r", m_r),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(RGBA)
    CRDTP_SERIALIZE_FIELD("r", m_r);
    CRDTP_SERIALIZE_FIELD("g", m_g);
    CRDTP_SERIALIZE_FIELD("b", m_b);
    CRDTP_SERIALIZE_FIELD("a", m_a);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


namespace Enable {
namespace IncludeWhitespaceEnum {
const char* None = "none";
const char* All = "all";
} // namespace IncludeWhitespaceEnum
} // namespace Enable

namespace GetElementByRelation {
namespace RelationEnum {
const char* PopoverTarget = "PopoverTarget";
} // namespace RelationEnum
} // namespace GetElementByRelation

// ------------- Frontend notifications.

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void setFileInputFiles(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("setFileInputFiles"),
          &DomainDispatcherImpl::setFileInputFiles
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct setFileInputFilesParams : public crdtp::DeserializableProtocolObject<setFileInputFilesParams> {
    std::unique_ptr<protocol::Array<String>> files;
    std::optional<int> nodeId;
    std::optional<int> backendNodeId;
    std::optional<String> objectId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setFileInputFilesParams)
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", backendNodeId),
    CRDTP_DESERIALIZE_FIELD("files", files),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("objectId", objectId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setFileInputFiles(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setFileInputFilesParams params;
    if (!setFileInputFilesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetFileInputFiles(std::move(params.files), std::move(params.nodeId), std::move(params.backendNodeId), std::move(params.objectId));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.setFileInputFiles"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
          { crdtp::SpanFrom("DOM.hideHighlight"), crdtp::SpanFrom("Overlay.hideHighlight") },
          { crdtp::SpanFrom("DOM.highlightNode"), crdtp::SpanFrom("Overlay.highlightNode") },
          { crdtp::SpanFrom("DOM.highlightRect"), crdtp::SpanFrom("Overlay.highlightRect") },
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("DOM"), SortedRedirects(), std::move(dispatcher));
}

} // DOM
} // namespace content
} // namespace protocol
