/* DockWindow.c generated by valac 0.56.17, the Vala compiler
 * generated from DockWindow.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Michal Hruby, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <gtk/gtk.h>
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include "plank-internal.h"
#include <libbamf/libbamf.h>
#include <gio/gio.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>

#define PLANK_DOCK_WINDOW_LONG_PRESS_TIME 750U
#define PLANK_DOCK_WINDOW_HOVER_DELAY_TIME 200U
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_DOCK_WINDOW_0_PROPERTY,
	PLANK_DOCK_WINDOW_CONTROLLER_PROPERTY,
	PLANK_DOCK_WINDOW_HOVERED_ITEM_PROPERTY,
	PLANK_DOCK_WINDOW_HOVERED_ITEM_PROVIDER_PROPERTY,
	PLANK_DOCK_WINDOW_NUM_PROPERTIES
};
static GParamSpec* plank_dock_window_properties[PLANK_DOCK_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block18Data Block18Data;
typedef struct _Block19Data Block19Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_region_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_region_destroy (var), NULL)))

struct _PlankDockWindowPrivate {
	PlankDockController* _controller;
	PlankDockItem* _HoveredItem;
	PlankDockItemProvider* _HoveredItemProvider;
	PlankDockItem* _ClickedItem;
	GtkMenu* menu;
	GeeArrayList* menu_items;
	guint hover_reposition_timer_id;
	guint long_press_timer_id;
	gboolean long_press_active;
	guint long_press_button;
	GdkRectangle input_rect;
	gint requested_x;
	gint requested_y;
	gint window_position_retry;
};

struct _Block18Data {
	int _ref_count_;
	PlankDockController* controller;
};

struct _Block19Data {
	int _ref_count_;
	GFile* dock_item_file;
	PlankDockItem* item;
};

static gint PlankDockWindow_private_offset;
static gpointer plank_dock_window_parent_class = NULL;

static void plank_dock_window_on_menu_show (PlankDockWindow* self);
static void _plank_dock_window_on_menu_show_gtk_widget_show (GtkWidget* _sender,
                                                      gpointer self);
static void plank_dock_window_on_menu_hide (PlankDockWindow* self);
static void _plank_dock_window_on_menu_hide_gtk_widget_hide (GtkWidget* _sender,
                                                      gpointer self);
static PlankDockController* plank_dock_window_get_controller (PlankDockWindow* self);
static void plank_dock_window_set_struts (PlankDockWindow* self);
static void _plank_dock_window_set_struts_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static gboolean plank_dock_window_real_button_press_event (GtkWidget* base,
                                                    GdkEventButton* event);
static void plank_dock_window_set_ClickedItem (PlankDockWindow* self,
                                        PlankDockItem* value);
static gboolean plank_dock_window_show_menu (PlankDockWindow* self,
                                      PlankDockItem* item,
                                      GdkEventButton* event);
static gboolean __lambda56_ (PlankDockWindow* self);
static gboolean ___lambda56__gsource_func (gpointer self);
static gboolean plank_dock_window_real_button_release_event (GtkWidget* base,
                                                      GdkEventButton* event);
static PlankDockItem* plank_dock_window_get_ClickedItem (PlankDockWindow* self);
static gboolean plank_dock_window_real_enter_notify_event (GtkWidget* base,
                                                    GdkEventCrossing* event);
static gboolean plank_dock_window_real_leave_notify_event (GtkWidget* base,
                                                    GdkEventCrossing* event);
static void plank_dock_window_set_hovered_provider (PlankDockWindow* self,
                                             PlankDockItemProvider* provider);
static void plank_dock_window_set_hovered (PlankDockWindow* self,
                                    PlankDockItem* item);
static gboolean plank_dock_window_real_motion_notify_event (GtkWidget* base,
                                                     GdkEventMotion* event);
static void plank_dock_window_real_drag_begin (GtkWidget* base,
                                        GdkDragContext* context);
static gboolean plank_dock_window_real_scroll_event (GtkWidget* base,
                                              GdkEventScroll* event);
static gboolean plank_dock_window_real_configure_event (GtkWidget* base,
                                                 GdkEventConfigure* event);
static gboolean plank_dock_window_real_draw (GtkWidget* base,
                                      cairo_t* cr);
static void plank_dock_window_set_input_mask (PlankDockWindow* self);
static gboolean plank_dock_window_real_map_event (GtkWidget* base,
                                           GdkEventAny* event);
static void plank_dock_window_set_HoveredItemProvider (PlankDockWindow* self,
                                                PlankDockItemProvider* value);
static void plank_dock_window_set_HoveredItem (PlankDockWindow* self,
                                        PlankDockItem* value);
static gboolean __lambda44_ (PlankDockWindow* self);
static gboolean ___lambda44__gsource_func (gpointer self);
VALA_EXTERN BamfApplication* plank_application_dock_item_get_App (PlankApplicationDockItem* self);
static GeeArrayList* plank_dock_window_get_dock_debug_menu_items (PlankDockController* controller);
static GeeArrayList* plank_dock_window_get_item_debug_menu_items (PlankDockItem* item);
static void plank_dock_window_position_menu (GtkMenu* menu,
                                      gint* x,
                                      gint* y,
                                      gboolean* push_in,
                                      PlankDockWindow* self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void __lambda51_ (Block18Data* _data18_);
static void ___lambda51__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda52_ (Block18Data* _data18_);
static void ___lambda52__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static void __lambda53_ (Block19Data* _data19_);
static void ___lambda53__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda54_ (Block19Data* _data19_);
static void ___lambda54__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda55_ (Block19Data* _data19_);
static void ___lambda55__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                                     const cairo_rectangle_int_t * s2);
static GObject * plank_dock_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void plank_dock_window_finalize (GObject * obj);
static GType plank_dock_window_get_type_once (void);
static void _vala_plank_dock_window_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_plank_dock_window_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
plank_dock_window_get_instance_private (PlankDockWindow* self)
{
	return G_STRUCT_MEMBER_P (self, PlankDockWindow_private_offset);
}

static void
_plank_dock_window_on_menu_show_gtk_widget_show (GtkWidget* _sender,
                                                 gpointer self)
{
	plank_dock_window_on_menu_show ((PlankDockWindow*) self);
}

static void
_plank_dock_window_on_menu_hide_gtk_widget_hide (GtkWidget* _sender,
                                                 gpointer self)
{
	plank_dock_window_on_menu_hide ((PlankDockWindow*) self);
}

static void
_plank_dock_window_set_struts_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	plank_dock_window_set_struts ((PlankDockWindow*) self);
}

/**
 * Creates a new dock window.
 */
PlankDockWindow*
plank_dock_window_construct (GType object_type,
                             PlankDockController* controller)
{
	PlankDockWindow * self = NULL;
	g_return_val_if_fail (controller != NULL, NULL);
	self = (PlankDockWindow*) g_object_new (object_type, "controller", controller, "type", GTK_WINDOW_TOPLEVEL, "type-hint", GDK_WINDOW_TYPE_HINT_DOCK, NULL);
	return self;
}

PlankDockWindow*
plank_dock_window_new (PlankDockController* controller)
{
	return plank_dock_window_construct (PLANK_TYPE_DOCK_WINDOW, controller);
}

/**
 * {@inheritDoc}
 */
static gboolean
__lambda56_ (PlankDockWindow* self)
{
	gboolean result;
	self->priv->long_press_active = TRUE;
	self->priv->long_press_timer_id = 0U;
	result = FALSE;
	return result;
}

static gboolean
___lambda56__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda56_ ((PlankDockWindow*) self);
	return result;
}

static gboolean
plank_dock_window_real_button_press_event (GtkWidget* base,
                                           GdkEventButton* event)
{
	PlankDockWindow * self;
	PlankDockController* _tmp0_;
	PlankHideManager* _tmp1_;
	PlankHideManager* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	PlankDockController* _tmp5_;
	PlankDragManager* _tmp6_;
	PlankDragManager* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	PlankDockItem* _tmp10_;
	PlankDockItem* _tmp11_;
	PlankDockItem* _tmp12_;
	gboolean result;
	self = (PlankDockWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (plank_dock_window_menu_is_visible (self)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_hide_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = plank_hide_manager_get_Hidden (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		result = GDK_EVENT_STOP;
		return result;
	}
	_tmp5_ = self->priv->_controller;
	_tmp6_ = plank_dock_controller_get_drag_manager (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = plank_drag_manager_get_InternalDragActive (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		result = GDK_EVENT_STOP;
		return result;
	}
	_tmp10_ = self->priv->_HoveredItem;
	if (_tmp10_ == NULL) {
		plank_dock_window_update_hovered (self, (gint) event->x, (gint) event->y);
	}
	_tmp11_ = self->priv->_HoveredItem;
	plank_dock_window_set_ClickedItem (self, _tmp11_);
	_tmp12_ = self->priv->_HoveredItem;
	if (plank_dock_window_show_menu (self, _tmp12_, event)) {
		result = GDK_EVENT_STOP;
		return result;
	}
	self->priv->long_press_active = FALSE;
	self->priv->long_press_button = event->button;
	if (self->priv->long_press_timer_id > 0U) {
		g_source_remove (self->priv->long_press_timer_id);
	}
	self->priv->long_press_timer_id = gdk_threads_add_timeout (PLANK_DOCK_WINDOW_LONG_PRESS_TIME, ___lambda56__gsource_func, self);
	result = GDK_EVENT_PROPAGATE;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_dock_window_real_button_release_event (GtkWidget* base,
                                             GdkEventButton* event)
{
	PlankDockWindow * self;
	PlankDockController* _tmp0_;
	PlankHideManager* _tmp1_;
	PlankHideManager* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	PlankDockController* _tmp6_;
	PlankDragManager* _tmp7_;
	PlankDragManager* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	PlankDockItem* _tmp13_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	PlankDockItem* _tmp18_;
	gboolean result;
	self = (PlankDockWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_hide_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = plank_hide_manager_get_Hidden (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		result = GDK_EVENT_STOP;
		return result;
	}
	if (self->priv->long_press_timer_id > 0U) {
		g_source_remove (self->priv->long_press_timer_id);
		self->priv->long_press_timer_id = 0U;
	}
	if (self->priv->long_press_active) {
		_tmp5_ = self->priv->long_press_button == event->button;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		self->priv->long_press_active = FALSE;
		self->priv->long_press_button = (guint) 0;
		result = GDK_EVENT_STOP;
		return result;
	}
	_tmp6_ = self->priv->_controller;
	_tmp7_ = plank_dock_controller_get_drag_manager (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = plank_drag_manager_get_InternalDragActive (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		result = GDK_EVENT_STOP;
		return result;
	}
	_tmp13_ = self->priv->_HoveredItem;
	if (_tmp13_ != NULL) {
		PlankDockItem* _tmp14_;
		_tmp14_ = self->priv->_ClickedItem;
		_tmp12_ = _tmp14_ == NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		_tmp11_ = plank_dock_window_menu_is_visible (self);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GtkMenu* _tmp15_;
		_tmp15_ = self->priv->menu;
		gtk_widget_hide ((GtkWidget*) _tmp15_);
	}
	_tmp18_ = self->priv->_ClickedItem;
	if (_tmp18_ != NULL) {
		PlankDockItem* _tmp19_;
		PlankDockItem* _tmp20_;
		_tmp19_ = self->priv->_HoveredItem;
		_tmp20_ = self->priv->_ClickedItem;
		_tmp17_ = _tmp19_ == _tmp20_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		_tmp16_ = !plank_dock_window_menu_is_visible (self);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		PlankDockController* _tmp21_;
		PlankHoverWindow* _tmp22_;
		PlankHoverWindow* _tmp23_;
		PlankDockItem* _tmp24_;
		_tmp21_ = self->priv->_controller;
		_tmp22_ = plank_dock_controller_get_hover (_tmp21_);
		_tmp23_ = _tmp22_;
		gtk_widget_hide ((GtkWidget*) _tmp23_);
		_tmp24_ = self->priv->_HoveredItem;
		plank_dock_element_clicked ((PlankDockElement*) _tmp24_, plank_popup_button_from_event_button (event), event->state, event->time);
	}
	plank_dock_window_set_ClickedItem (self, NULL);
	result = GDK_EVENT_PROPAGATE;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_dock_window_real_enter_notify_event (GtkWidget* base,
                                           GdkEventCrossing* event)
{
	PlankDockWindow * self;
	PlankDockController* _tmp0_;
	PlankDockRenderer* _tmp1_;
	PlankDockRenderer* _tmp2_;
	gboolean result;
	self = (PlankDockWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_renderer (_tmp0_);
	_tmp2_ = _tmp1_;
	plank_dock_renderer_update_local_cursor (_tmp2_, (gint) event->x, (gint) event->y);
	plank_dock_window_update_hovered (self, (gint) event->x, (gint) event->y);
	result = GDK_EVENT_STOP;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_dock_window_real_leave_notify_event (GtkWidget* base,
                                           GdkEventCrossing* event)
{
	PlankDockWindow * self;
	gboolean result;
	self = (PlankDockWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if ((gboolean) event->send_event) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	if (!plank_dock_window_menu_is_visible (self)) {
		plank_dock_window_set_hovered_provider (self, NULL);
		plank_dock_window_set_hovered (self, NULL);
	} else {
		PlankDockController* _tmp0_;
		PlankHoverWindow* _tmp1_;
		PlankHoverWindow* _tmp2_;
		_tmp0_ = self->priv->_controller;
		_tmp1_ = plank_dock_controller_get_hover (_tmp0_);
		_tmp2_ = _tmp1_;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
	}
	result = GDK_EVENT_STOP;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_dock_window_real_motion_notify_event (GtkWidget* base,
                                            GdkEventMotion* event)
{
	PlankDockWindow * self;
	PlankDockController* _tmp0_;
	PlankDockRenderer* _tmp1_;
	PlankDockRenderer* _tmp2_;
	gboolean result;
	self = (PlankDockWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (plank_dock_window_menu_is_visible (self)) {
		result = GDK_EVENT_STOP;
		return result;
	}
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_renderer (_tmp0_);
	_tmp2_ = _tmp1_;
	plank_dock_renderer_update_local_cursor (_tmp2_, (gint) event->x, (gint) event->y);
	plank_dock_window_update_hovered (self, (gint) event->x, (gint) event->y);
	result = GDK_EVENT_PROPAGATE;
	return result;
}

/**
 * {@inheritDoc}
 */
static void
plank_dock_window_real_drag_begin (GtkWidget* base,
                                   GdkDragContext* context)
{
	PlankDockWindow * self;
	self = (PlankDockWindow*) base;
	g_return_if_fail (context != NULL);
	self->priv->long_press_active = FALSE;
	if (self->priv->long_press_timer_id > 0U) {
		g_source_remove (self->priv->long_press_timer_id);
		self->priv->long_press_timer_id = 0U;
	}
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_dock_window_real_scroll_event (GtkWidget* base,
                                     GdkEventScroll* event)
{
	PlankDockWindow * self;
	PlankDockController* _tmp0_;
	PlankHideManager* _tmp1_;
	PlankHideManager* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	PlankDockController* _tmp5_;
	PlankDragManager* _tmp6_;
	PlankDragManager* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	PlankDockItem* _tmp16_;
	gboolean result;
	self = (PlankDockWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_hide_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = plank_hide_manager_get_Hidden (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		result = GDK_EVENT_STOP;
		return result;
	}
	_tmp5_ = self->priv->_controller;
	_tmp6_ = plank_dock_controller_get_drag_manager (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = plank_drag_manager_get_InternalDragActive (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		result = GDK_EVENT_STOP;
		return result;
	}
	if (event->direction >= 4) {
		result = GDK_EVENT_STOP;
		return result;
	}
	if ((event->state & GDK_CONTROL_MASK) != 0) {
		if (event->direction == GDK_SCROLL_UP) {
			PlankDockController* _tmp10_;
			PlankDockPreferences* _tmp11_;
			PlankDockPreferences* _tmp12_;
			_tmp10_ = self->priv->_controller;
			_tmp11_ = plank_dock_controller_get_prefs (_tmp10_);
			_tmp12_ = _tmp11_;
			plank_dock_preferences_increase_icon_size (_tmp12_);
		} else {
			if (event->direction == GDK_SCROLL_DOWN) {
				PlankDockController* _tmp13_;
				PlankDockPreferences* _tmp14_;
				PlankDockPreferences* _tmp15_;
				_tmp13_ = self->priv->_controller;
				_tmp14_ = plank_dock_controller_get_prefs (_tmp13_);
				_tmp15_ = _tmp14_;
				plank_dock_preferences_decrease_icon_size (_tmp15_);
			}
		}
		result = GDK_EVENT_STOP;
		return result;
	}
	_tmp16_ = self->priv->_HoveredItem;
	if (_tmp16_ != NULL) {
		PlankDockController* _tmp17_;
		PlankHoverWindow* _tmp18_;
		PlankHoverWindow* _tmp19_;
		PlankDockItem* _tmp20_;
		PlankDockController* _tmp21_;
		PlankDockRenderer* _tmp22_;
		PlankDockRenderer* _tmp23_;
		_tmp17_ = self->priv->_controller;
		_tmp18_ = plank_dock_controller_get_hover (_tmp17_);
		_tmp19_ = _tmp18_;
		gtk_widget_hide ((GtkWidget*) _tmp19_);
		_tmp20_ = self->priv->_HoveredItem;
		plank_dock_element_scrolled ((PlankDockElement*) _tmp20_, event->direction, event->state, event->time);
		_tmp21_ = self->priv->_controller;
		_tmp22_ = plank_dock_controller_get_renderer (_tmp21_);
		_tmp23_ = _tmp22_;
		plank_renderer_animated_draw ((PlankRenderer*) _tmp23_);
	}
	result = GDK_EVENT_STOP;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_dock_window_real_configure_event (GtkWidget* base,
                                        GdkEventConfigure* event)
{
	PlankDockWindow * self;
	GdkRectangle win_rect = {0};
	PlankDockController* _tmp0_;
	PlankPositionManager* _tmp1_;
	PlankPositionManager* _tmp2_;
	GdkRectangle _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GdkRectangle _tmp7_;
	gboolean needs_update = FALSE;
	gboolean result;
	self = (PlankDockWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_position_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	plank_position_manager_get_dock_window_region (_tmp2_, &_tmp3_);
	win_rect = _tmp3_;
	_tmp7_ = win_rect;
	if (_tmp7_.width != event->width) {
		_tmp6_ = TRUE;
	} else {
		GdkRectangle _tmp8_;
		_tmp8_ = win_rect;
		_tmp6_ = _tmp8_.height != event->height;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		GdkRectangle _tmp9_;
		_tmp9_ = win_rect;
		_tmp5_ = _tmp9_.x != event->x;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		GdkRectangle _tmp10_;
		_tmp10_ = win_rect;
		_tmp4_ = _tmp10_.y != event->y;
	}
	needs_update = _tmp4_;
	if (needs_update) {
		gint _tmp11_;
		self->priv->window_position_retry = self->priv->window_position_retry + 1;
		_tmp11_ = self->priv->window_position_retry;
		if (_tmp11_ < 3) {
			g_critical ("DockWindow.vala:298: Retry #%i update_size_and_position() to force req" \
"uested values!", self->priv->window_position_retry);
			plank_dock_window_update_size_and_position (self);
		}
	} else {
		self->priv->window_position_retry = 0;
	}
	result = GTK_WIDGET_CLASS (plank_dock_window_parent_class)->configure_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, PLANK_TYPE_COMPOSITED_WINDOW, PlankCompositedWindow), event);
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_dock_window_real_draw (GtkWidget* base,
                             cairo_t* cr)
{
	PlankDockWindow * self;
	gboolean result;
	self = (PlankDockWindow*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	plank_dock_window_set_input_mask (self);
	result = GDK_EVENT_STOP;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_dock_window_real_map_event (GtkWidget* base,
                                  GdkEventAny* event)
{
	PlankDockWindow * self;
	gboolean result;
	self = (PlankDockWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	plank_dock_window_set_struts (self);
	result = GTK_WIDGET_CLASS (plank_dock_window_parent_class)->map_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, PLANK_TYPE_COMPOSITED_WINDOW, PlankCompositedWindow), event);
	return result;
}

/**
 * Sets the currently hovered item-provider for this dock.
 *
 * @param provider the hovered item-provider (if any) for this dock
 */
static void
plank_dock_window_set_hovered_provider (PlankDockWindow* self,
                                        PlankDockItemProvider* provider)
{
	PlankDockItemProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_HoveredItemProvider;
	if (_tmp0_ == provider) {
		return;
	}
	plank_dock_window_set_HoveredItemProvider (self, provider);
}

/**
 * Sets the currently hovered item for this dock.
 *
 * @param item the hovered item (if any) for this dock
 */
static gboolean
__lambda44_ (PlankDockWindow* self)
{
	PlankDockItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	PlankDockController* _tmp2_;
	PlankHideManager* _tmp3_;
	PlankHideManager* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	PlankHoverWindow* hover = NULL;
	PlankDockController* _tmp12_;
	PlankHoverWindow* _tmp13_;
	PlankHoverWindow* _tmp14_;
	gint x = 0;
	gint y = 0;
	PlankHoverWindow* _tmp15_;
	PlankDockItem* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	PlankDockController* _tmp19_;
	PlankPositionManager* _tmp20_;
	PlankPositionManager* _tmp21_;
	PlankDockItem* _tmp22_;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	PlankHoverWindow* _tmp25_;
	PlankDockController* _tmp26_;
	PlankPositionManager* _tmp27_;
	PlankPositionManager* _tmp28_;
	GtkPositionType _tmp29_;
	GtkPositionType _tmp30_;
	gboolean result;
	_tmp0_ = self->priv->_HoveredItem;
	if (_tmp0_ == NULL) {
		self->priv->hover_reposition_timer_id = 0U;
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_controller;
	_tmp3_ = plank_dock_controller_get_hide_manager (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = plank_hide_manager_get_Hidden (_tmp4_);
	_tmp6_ = _tmp5_;
	if (!_tmp6_) {
		PlankDockController* _tmp7_;
		PlankDockRenderer* _tmp8_;
		PlankDockRenderer* _tmp9_;
		gdouble _tmp10_;
		gdouble _tmp11_;
		_tmp7_ = self->priv->_controller;
		_tmp8_ = plank_dock_controller_get_renderer (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = plank_dock_renderer_get_hide_progress (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp1_ = _tmp11_ > 0.0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	self->priv->hover_reposition_timer_id = 0U;
	_tmp12_ = self->priv->_controller;
	_tmp13_ = plank_dock_controller_get_hover (_tmp12_);
	_tmp14_ = _tmp13_;
	hover = _tmp14_;
	_tmp15_ = hover;
	_tmp16_ = self->priv->_HoveredItem;
	_tmp17_ = plank_dock_element_get_Text ((PlankDockElement*) _tmp16_);
	_tmp18_ = _tmp17_;
	plank_hover_window_set_text (_tmp15_, _tmp18_);
	_tmp19_ = self->priv->_controller;
	_tmp20_ = plank_dock_controller_get_position_manager (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->_HoveredItem;
	plank_position_manager_get_hover_position (_tmp21_, _tmp22_, &_tmp23_, &_tmp24_);
	x = _tmp23_;
	y = _tmp24_;
	_tmp25_ = hover;
	_tmp26_ = self->priv->_controller;
	_tmp27_ = plank_dock_controller_get_position_manager (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = plank_position_manager_get_Position (_tmp28_);
	_tmp30_ = _tmp29_;
	plank_hover_window_show_at (_tmp25_, x, y, _tmp30_);
	if (plank_dock_window_menu_is_visible (self)) {
		PlankHoverWindow* _tmp31_;
		_tmp31_ = hover;
		gtk_widget_hide ((GtkWidget*) _tmp31_);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda44__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda44_ ((PlankDockWindow*) self);
	return result;
}

static void
plank_dock_window_set_hovered (PlankDockWindow* self,
                               PlankDockItem* item)
{
	PlankDockItem* _tmp0_;
	PlankDockItem* _tmp1_;
	PlankDockController* _tmp3_;
	PlankDragManager* _tmp4_;
	PlankDragManager* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	PlankDockController* _tmp8_;
	PlankHoverWindow* _tmp9_;
	PlankHoverWindow* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	PlankDockItem* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_HoveredItem;
	if (_tmp0_ == item) {
		return;
	}
	_tmp1_ = self->priv->_HoveredItem;
	if (_tmp1_ != NULL) {
		PlankDockItem* _tmp2_;
		_tmp2_ = self->priv->_HoveredItem;
		plank_dock_element_hovered ((PlankDockElement*) _tmp2_);
	}
	if (item != NULL) {
		plank_dock_element_hovered ((PlankDockElement*) item);
	}
	plank_dock_window_set_HoveredItem (self, item);
	if (self->priv->hover_reposition_timer_id > 0U) {
		g_source_remove (self->priv->hover_reposition_timer_id);
		self->priv->hover_reposition_timer_id = 0U;
	}
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_drag_manager (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = plank_drag_manager_get_ExternalDragActive (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		return;
	}
	_tmp8_ = self->priv->_controller;
	_tmp9_ = plank_dock_controller_get_hover (_tmp8_);
	_tmp10_ = _tmp9_;
	gtk_widget_hide ((GtkWidget*) _tmp10_);
	_tmp13_ = self->priv->_HoveredItem;
	if (_tmp13_ == NULL) {
		_tmp12_ = TRUE;
	} else {
		PlankDockController* _tmp14_;
		PlankDockPreferences* _tmp15_;
		PlankDockPreferences* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp14_ = self->priv->_controller;
		_tmp15_ = plank_dock_controller_get_prefs (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = plank_dock_preferences_get_TooltipsEnabled (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp12_ = !_tmp18_;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		PlankDockController* _tmp19_;
		PlankDragManager* _tmp20_;
		PlankDragManager* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp19_ = self->priv->_controller;
		_tmp20_ = plank_dock_controller_get_drag_manager (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = plank_drag_manager_get_InternalDragActive (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp11_ = _tmp23_;
	}
	if (_tmp11_) {
		return;
	}
	self->priv->hover_reposition_timer_id = gdk_threads_add_timeout (PLANK_DOCK_WINDOW_HOVER_DELAY_TIME, ___lambda44__gsource_func, self);
}

/**
 * Determines if an item is hovered by the cursor at the x/y position.
 *
 * @param x the cursor x position
 * @param y the cursor x position
 * @return if a dock item is hovered
 */
gboolean
plank_dock_window_update_hovered (PlankDockWindow* self,
                                  gint x,
                                  gint y)
{
	PlankDockController* _tmp0_;
	PlankHideManager* _tmp1_;
	PlankHideManager* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp5_;
	PlankPositionManager* _tmp6_;
	PlankPositionManager* _tmp7_;
	PlankDockItem* drag_item = NULL;
	PlankDockController* _tmp8_;
	PlankDragManager* _tmp9_;
	PlankDragManager* _tmp10_;
	PlankDockItem* _tmp11_;
	PlankDockItem* _tmp12_;
	GdkRectangle rect = {0};
	PlankDockItem* _tmp13_;
	PlankPositionManager* _tmp31_;
	GdkRectangle _tmp32_ = {0};
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GdkRectangle _tmp36_;
	gboolean found_hovered_provider = FALSE;
	PlankDockItem* item = NULL;
	PlankDockItemProvider* provider = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_hide_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = plank_hide_manager_get_Hidden (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		plank_dock_window_set_hovered_provider (self, NULL);
		plank_dock_window_set_hovered (self, NULL);
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->_controller;
	_tmp6_ = plank_dock_controller_get_position_manager (_tmp5_);
	_tmp7_ = _tmp6_;
	position_manager = _tmp7_;
	_tmp8_ = self->priv->_controller;
	_tmp9_ = plank_dock_controller_get_drag_manager (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = plank_drag_manager_get_DragItem (_tmp10_);
	_tmp12_ = _tmp11_;
	drag_item = _tmp12_;
	_tmp13_ = self->priv->_HoveredItem;
	if (_tmp13_ != NULL) {
		PlankPositionManager* _tmp14_;
		PlankDockItem* _tmp15_;
		GdkRectangle _tmp16_ = {0};
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		GdkRectangle _tmp20_;
		_tmp14_ = position_manager;
		_tmp15_ = self->priv->_HoveredItem;
		plank_position_manager_get_hover_region_for_element (_tmp14_, (PlankDockElement*) _tmp15_, &_tmp16_);
		rect = _tmp16_;
		_tmp20_ = rect;
		if (y >= _tmp20_.y) {
			GdkRectangle _tmp21_;
			GdkRectangle _tmp22_;
			_tmp21_ = rect;
			_tmp22_ = rect;
			_tmp19_ = y < (_tmp21_.y + _tmp22_.height);
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			GdkRectangle _tmp23_;
			_tmp23_ = rect;
			_tmp18_ = x >= _tmp23_.x;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			GdkRectangle _tmp24_;
			GdkRectangle _tmp25_;
			_tmp24_ = rect;
			_tmp25_ = rect;
			_tmp17_ = x < (_tmp24_.x + _tmp25_.width);
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			PlankDockItem* _tmp26_;
			PlankDockItem* _tmp27_;
			_tmp26_ = drag_item;
			_tmp27_ = self->priv->_HoveredItem;
			if (_tmp26_ == _tmp27_) {
				PlankDockItem* _tmp28_;
				PlankDockContainer* _tmp29_;
				PlankDockContainer* _tmp30_;
				_tmp28_ = self->priv->_HoveredItem;
				_tmp29_ = plank_dock_element_get_Container ((PlankDockElement*) _tmp28_);
				_tmp30_ = _tmp29_;
				plank_dock_window_set_hovered_provider (self, PLANK_IS_DOCK_ITEM_PROVIDER (_tmp30_) ? ((PlankDockItemProvider*) _tmp30_) : NULL);
				plank_dock_window_set_hovered (self, NULL);
				result = FALSE;
				return result;
			} else {
				result = TRUE;
				return result;
			}
		}
	}
	_tmp31_ = position_manager;
	plank_position_manager_get_cursor_region (_tmp31_, &_tmp32_);
	rect = _tmp32_;
	_tmp36_ = rect;
	if (y < _tmp36_.y) {
		_tmp35_ = TRUE;
	} else {
		GdkRectangle _tmp37_;
		GdkRectangle _tmp38_;
		_tmp37_ = rect;
		_tmp38_ = rect;
		_tmp35_ = y >= (_tmp37_.y + _tmp38_.height);
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		GdkRectangle _tmp39_;
		_tmp39_ = rect;
		_tmp34_ = x < _tmp39_.x;
	}
	if (_tmp34_) {
		_tmp33_ = TRUE;
	} else {
		GdkRectangle _tmp40_;
		GdkRectangle _tmp41_;
		_tmp40_ = rect;
		_tmp41_ = rect;
		_tmp33_ = x >= (_tmp40_.x + _tmp41_.width);
	}
	if (_tmp33_) {
		plank_dock_window_set_hovered_provider (self, NULL);
		plank_dock_window_set_hovered (self, NULL);
		result = FALSE;
		return result;
	}
	found_hovered_provider = FALSE;
	item = NULL;
	provider = NULL;
	{
		GeeArrayList* _element_list = NULL;
		PlankDockController* _tmp42_;
		GeeArrayList* _tmp43_;
		GeeArrayList* _tmp44_;
		gint _element_size = 0;
		GeeArrayList* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _element_index = 0;
		_tmp42_ = self->priv->_controller;
		_tmp43_ = plank_dock_container_get_VisibleElements ((PlankDockContainer*) _tmp42_);
		_tmp44_ = _tmp43_;
		_element_list = _tmp44_;
		_tmp45_ = _element_list;
		_tmp46_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp45_);
		_tmp47_ = _tmp46_;
		_element_size = _tmp47_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp48_;
			gint _tmp49_;
			PlankDockElement* element = NULL;
			GeeArrayList* _tmp50_;
			gpointer _tmp51_;
			PlankDockElement* _tmp52_;
			PlankDockItem* _tmp53_;
			PlankDockElement* _tmp69_;
			PlankDockItemProvider* _tmp70_;
			PlankPositionManager* _tmp71_;
			PlankDockItemProvider* _tmp72_;
			GdkRectangle _tmp73_ = {0};
			gboolean _tmp74_ = FALSE;
			gboolean _tmp75_ = FALSE;
			gboolean _tmp76_ = FALSE;
			GdkRectangle _tmp77_;
			PlankDockItemProvider* _tmp83_;
			_element_index = _element_index + 1;
			_tmp48_ = _element_index;
			_tmp49_ = _element_size;
			if (!(_tmp48_ < _tmp49_)) {
				break;
			}
			_tmp50_ = _element_list;
			_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, _element_index);
			element = (PlankDockElement*) _tmp51_;
			_tmp52_ = element;
			item = PLANK_IS_DOCK_ITEM (_tmp52_) ? ((PlankDockItem*) _tmp52_) : NULL;
			_tmp53_ = item;
			if (_tmp53_ != NULL) {
				PlankPositionManager* _tmp54_;
				PlankDockItem* _tmp55_;
				GdkRectangle _tmp56_ = {0};
				gboolean _tmp57_ = FALSE;
				gboolean _tmp58_ = FALSE;
				gboolean _tmp59_ = FALSE;
				GdkRectangle _tmp60_;
				PlankDockItem* _tmp66_;
				PlankDockItem* _tmp67_;
				PlankDockItem* _tmp68_;
				_tmp54_ = position_manager;
				_tmp55_ = item;
				plank_position_manager_get_hover_region_for_element (_tmp54_, (PlankDockElement*) _tmp55_, &_tmp56_);
				rect = _tmp56_;
				_tmp60_ = rect;
				if (y < _tmp60_.y) {
					_tmp59_ = TRUE;
				} else {
					GdkRectangle _tmp61_;
					GdkRectangle _tmp62_;
					_tmp61_ = rect;
					_tmp62_ = rect;
					_tmp59_ = y >= (_tmp61_.y + _tmp62_.height);
				}
				if (_tmp59_) {
					_tmp58_ = TRUE;
				} else {
					GdkRectangle _tmp63_;
					_tmp63_ = rect;
					_tmp58_ = x < _tmp63_.x;
				}
				if (_tmp58_) {
					_tmp57_ = TRUE;
				} else {
					GdkRectangle _tmp64_;
					GdkRectangle _tmp65_;
					_tmp64_ = rect;
					_tmp65_ = rect;
					_tmp57_ = x >= (_tmp64_.x + _tmp65_.width);
				}
				if (_tmp57_) {
					_g_object_unref0 (element);
					continue;
				}
				_tmp66_ = drag_item;
				_tmp67_ = item;
				if (_tmp66_ == _tmp67_) {
					_g_object_unref0 (element);
					break;
				}
				plank_dock_window_set_hovered_provider (self, NULL);
				_tmp68_ = item;
				plank_dock_window_set_hovered (self, PLANK_IS_DOCK_ITEM (_tmp68_) ? ((PlankDockItem*) _tmp68_) : NULL);
				result = TRUE;
				_g_object_unref0 (element);
				return result;
			}
			_tmp69_ = element;
			provider = PLANK_IS_DOCK_ITEM_PROVIDER (_tmp69_) ? ((PlankDockItemProvider*) _tmp69_) : NULL;
			_tmp70_ = provider;
			if (_tmp70_ == NULL) {
				_g_object_unref0 (element);
				continue;
			}
			_tmp71_ = position_manager;
			_tmp72_ = provider;
			plank_position_manager_get_hover_region_for_element (_tmp71_, (PlankDockElement*) _tmp72_, &_tmp73_);
			rect = _tmp73_;
			_tmp77_ = rect;
			if (y < _tmp77_.y) {
				_tmp76_ = TRUE;
			} else {
				GdkRectangle _tmp78_;
				GdkRectangle _tmp79_;
				_tmp78_ = rect;
				_tmp79_ = rect;
				_tmp76_ = y >= (_tmp78_.y + _tmp79_.height);
			}
			if (_tmp76_) {
				_tmp75_ = TRUE;
			} else {
				GdkRectangle _tmp80_;
				_tmp80_ = rect;
				_tmp75_ = x < _tmp80_.x;
			}
			if (_tmp75_) {
				_tmp74_ = TRUE;
			} else {
				GdkRectangle _tmp81_;
				GdkRectangle _tmp82_;
				_tmp81_ = rect;
				_tmp82_ = rect;
				_tmp74_ = x >= (_tmp81_.x + _tmp82_.width);
			}
			if (_tmp74_) {
				_g_object_unref0 (element);
				continue;
			}
			_tmp83_ = provider;
			plank_dock_window_set_hovered_provider (self, _tmp83_);
			found_hovered_provider = TRUE;
			{
				GeeArrayList* _element2_list = NULL;
				PlankDockItemProvider* _tmp84_;
				GeeArrayList* _tmp85_;
				GeeArrayList* _tmp86_;
				gint _element2_size = 0;
				GeeArrayList* _tmp87_;
				gint _tmp88_;
				gint _tmp89_;
				gint _element2_index = 0;
				_tmp84_ = provider;
				_tmp85_ = plank_dock_container_get_VisibleElements ((PlankDockContainer*) _tmp84_);
				_tmp86_ = _tmp85_;
				_element2_list = _tmp86_;
				_tmp87_ = _element2_list;
				_tmp88_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp87_);
				_tmp89_ = _tmp88_;
				_element2_size = _tmp89_;
				_element2_index = -1;
				while (TRUE) {
					gint _tmp90_;
					gint _tmp91_;
					PlankDockElement* element2 = NULL;
					GeeArrayList* _tmp92_;
					gpointer _tmp93_;
					PlankPositionManager* _tmp94_;
					PlankDockElement* _tmp95_;
					GdkRectangle _tmp96_ = {0};
					gboolean _tmp97_ = FALSE;
					gboolean _tmp98_ = FALSE;
					gboolean _tmp99_ = FALSE;
					GdkRectangle _tmp100_;
					PlankDockItem* _tmp106_;
					PlankDockElement* _tmp107_;
					PlankDockElement* _tmp108_;
					_element2_index = _element2_index + 1;
					_tmp90_ = _element2_index;
					_tmp91_ = _element2_size;
					if (!(_tmp90_ < _tmp91_)) {
						break;
					}
					_tmp92_ = _element2_list;
					_tmp93_ = gee_abstract_list_get ((GeeAbstractList*) _tmp92_, _element2_index);
					element2 = (PlankDockElement*) _tmp93_;
					_tmp94_ = position_manager;
					_tmp95_ = element2;
					plank_position_manager_get_hover_region_for_element (_tmp94_, _tmp95_, &_tmp96_);
					rect = _tmp96_;
					_tmp100_ = rect;
					if (y < _tmp100_.y) {
						_tmp99_ = TRUE;
					} else {
						GdkRectangle _tmp101_;
						GdkRectangle _tmp102_;
						_tmp101_ = rect;
						_tmp102_ = rect;
						_tmp99_ = y >= (_tmp101_.y + _tmp102_.height);
					}
					if (_tmp99_) {
						_tmp98_ = TRUE;
					} else {
						GdkRectangle _tmp103_;
						_tmp103_ = rect;
						_tmp98_ = x < _tmp103_.x;
					}
					if (_tmp98_) {
						_tmp97_ = TRUE;
					} else {
						GdkRectangle _tmp104_;
						GdkRectangle _tmp105_;
						_tmp104_ = rect;
						_tmp105_ = rect;
						_tmp97_ = x >= (_tmp104_.x + _tmp105_.width);
					}
					if (_tmp97_) {
						_g_object_unref0 (element2);
						continue;
					}
					_tmp106_ = drag_item;
					_tmp107_ = element2;
					if (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, PLANK_TYPE_DOCK_ELEMENT, PlankDockElement) == _tmp107_) {
						_g_object_unref0 (element2);
						break;
					}
					_tmp108_ = element2;
					plank_dock_window_set_hovered (self, PLANK_IS_DOCK_ITEM (_tmp108_) ? ((PlankDockItem*) _tmp108_) : NULL);
					result = TRUE;
					_g_object_unref0 (element2);
					_g_object_unref0 (element);
					return result;
				}
			}
			_g_object_unref0 (element);
		}
	}
	if (!found_hovered_provider) {
		plank_dock_window_set_hovered_provider (self, NULL);
	}
	plank_dock_window_set_hovered (self, NULL);
	result = FALSE;
	return result;
}

/**
 * Sets the size of the dock window and repositions it if needed.
 */
void
plank_dock_window_update_size_and_position (PlankDockWindow* self)
{
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp0_;
	PlankPositionManager* _tmp1_;
	PlankPositionManager* _tmp2_;
	GdkRectangle win_rect = {0};
	PlankPositionManager* _tmp3_;
	GdkRectangle _tmp4_ = {0};
	gint width_current = 0;
	gint height_current = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	GdkRectangle _tmp8_;
	gboolean needs_resize = FALSE;
	gboolean needs_reposition = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_position_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	position_manager = _tmp2_;
	_tmp3_ = position_manager;
	plank_position_manager_get_dock_window_region (_tmp3_, &_tmp4_);
	win_rect = _tmp4_;
	gtk_widget_get_size_request ((GtkWidget*) self, &_tmp5_, &_tmp6_);
	width_current = _tmp5_;
	height_current = _tmp6_;
	_tmp8_ = win_rect;
	if (_tmp8_.width != width_current) {
		_tmp7_ = TRUE;
	} else {
		GdkRectangle _tmp9_;
		_tmp9_ = win_rect;
		_tmp7_ = _tmp9_.height != height_current;
	}
	needs_resize = _tmp7_;
	needs_reposition = TRUE;
	if (gtk_widget_get_realized ((GtkWidget*) self)) {
		gint x_current = 0;
		gint y_current = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		GdkRectangle _tmp15_;
		gtk_window_get_position ((GtkWindow*) self, &_tmp10_, &_tmp11_);
		x_current = _tmp10_;
		y_current = _tmp11_;
		_tmp15_ = win_rect;
		if (_tmp15_.x != x_current) {
			_tmp14_ = TRUE;
		} else {
			GdkRectangle _tmp16_;
			_tmp16_ = win_rect;
			_tmp14_ = _tmp16_.y != y_current;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			GdkRectangle _tmp17_;
			_tmp17_ = win_rect;
			_tmp13_ = _tmp17_.x != self->priv->requested_x;
		}
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			GdkRectangle _tmp18_;
			_tmp18_ = win_rect;
			_tmp12_ = _tmp18_.y != self->priv->requested_y;
		}
		needs_reposition = _tmp12_;
	}
	if (needs_resize) {
		GdkRectangle _tmp19_;
		GdkRectangle _tmp20_;
		GdkRectangle _tmp21_;
		GdkRectangle _tmp22_;
		PlankDockController* _tmp23_;
		PlankDockRenderer* _tmp24_;
		PlankDockRenderer* _tmp25_;
		_tmp19_ = win_rect;
		_tmp20_ = win_rect;
		plank_logger_verbose ("DockWindow.set_size_request (width = %i, height = %i)", _tmp19_.width, _tmp20_.height, NULL);
		_tmp21_ = win_rect;
		_tmp22_ = win_rect;
		gtk_widget_set_size_request ((GtkWidget*) self, _tmp21_.width, _tmp22_.height);
		_tmp23_ = self->priv->_controller;
		_tmp24_ = plank_dock_controller_get_renderer (_tmp23_);
		_tmp25_ = _tmp24_;
		plank_dock_renderer_reset_buffers (_tmp25_);
		if (!needs_reposition) {
			plank_dock_window_update_icon_regions (self);
			plank_dock_window_set_struts (self);
			plank_dock_window_set_hovered_provider (self, NULL);
			plank_dock_window_set_hovered (self, NULL);
		}
	}
	if (needs_reposition) {
		GdkRectangle _tmp26_;
		GdkRectangle _tmp27_;
		GdkRectangle _tmp28_;
		GdkRectangle _tmp29_;
		GdkRectangle _tmp30_;
		GdkRectangle _tmp31_;
		_tmp26_ = win_rect;
		_tmp27_ = win_rect;
		plank_logger_verbose ("DockWindow.move (x = %i, y = %i)", _tmp26_.x, _tmp27_.y, NULL);
		_tmp28_ = win_rect;
		self->priv->requested_x = _tmp28_.x;
		_tmp29_ = win_rect;
		self->priv->requested_y = _tmp29_.y;
		_tmp30_ = win_rect;
		_tmp31_ = win_rect;
		gtk_window_move ((GtkWindow*) self, _tmp30_.x, _tmp31_.y);
		plank_dock_window_update_icon_regions (self);
		plank_dock_window_set_struts (self);
		plank_dock_window_set_hovered_provider (self, NULL);
		plank_dock_window_set_hovered (self, NULL);
	}
}

/**
 * Updates the icon regions for all items on the dock.
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
plank_dock_window_update_icon_regions (PlankDockWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean use_hidden_region = FALSE;
	g_return_if_fail (self != NULL);
	plank_logger_verbose ("DockWindow.update_icon_regions ()", NULL);
	if (plank_dock_window_menu_is_visible (self)) {
		_tmp0_ = TRUE;
	} else {
		PlankDockController* _tmp1_;
		PlankHideManager* _tmp2_;
		PlankHideManager* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = self->priv->_controller;
		_tmp2_ = plank_dock_controller_get_hide_manager (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = plank_hide_manager_get_Hidden (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	use_hidden_region = _tmp0_;
	{
		GeeArrayList* _item_list = NULL;
		PlankDockController* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
		gint _item_size = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _item_index = 0;
		_tmp6_ = self->priv->_controller;
		_tmp7_ = plank_dock_controller_get_VisibleItems (_tmp6_);
		_tmp8_ = _tmp7_;
		_item_list = _tmp8_;
		_tmp9_ = _item_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_item_size = _tmp11_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			PlankDockItem* item = NULL;
			GeeArrayList* _tmp14_;
			gpointer _tmp15_;
			PlankDockItem* _tmp16_;
			PlankApplicationDockItem* appitem = NULL;
			PlankDockItem* _tmp17_;
			gboolean _tmp18_ = FALSE;
			PlankApplicationDockItem* _tmp19_;
			GdkRectangle region = {0};
			PlankDockController* _tmp21_;
			PlankPositionManager* _tmp22_;
			PlankPositionManager* _tmp23_;
			PlankApplicationDockItem* _tmp24_;
			GdkRectangle _tmp25_ = {0};
			PlankApplicationDockItem* _tmp26_;
			BamfApplication* _tmp27_;
			BamfApplication* _tmp28_;
			GdkRectangle _tmp29_;
			_item_index = _item_index + 1;
			_tmp12_ = _item_index;
			_tmp13_ = _item_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _item_list;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _item_index);
			_tmp16_ = _g_object_ref0 ((PlankDockItem*) _tmp15_);
			item = _tmp16_;
			_tmp17_ = item;
			appitem = PLANK_IS_APPLICATION_DOCK_ITEM (_tmp17_) ? ((PlankApplicationDockItem*) _tmp17_) : NULL;
			_tmp19_ = appitem;
			if (_tmp19_ == NULL) {
				_tmp18_ = TRUE;
			} else {
				PlankApplicationDockItem* _tmp20_;
				_tmp20_ = appitem;
				_tmp18_ = !plank_application_dock_item_is_running (_tmp20_);
			}
			if (_tmp18_) {
				_g_object_unref0 (item);
				continue;
			}
			_tmp21_ = self->priv->_controller;
			_tmp22_ = plank_dock_controller_get_position_manager (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = appitem;
			plank_position_manager_get_icon_geometry (_tmp23_, _tmp24_, use_hidden_region, &_tmp25_);
			region = _tmp25_;
			_tmp26_ = appitem;
			_tmp27_ = plank_application_dock_item_get_App (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = region;
			plank_window_control_update_icon_regions (_tmp28_, &_tmp29_);
			_g_object_unref0 (item);
		}
	}
}

/**
 * Updates the icon region for the given item.
 *
 + @param appitem the item to update the icon region for
 */
void
plank_dock_window_update_icon_region (PlankDockWindow* self,
                                      PlankApplicationDockItem* appitem)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean use_hidden_region = FALSE;
	GdkRectangle region = {0};
	PlankDockController* _tmp8_;
	PlankPositionManager* _tmp9_;
	PlankPositionManager* _tmp10_;
	GdkRectangle _tmp11_ = {0};
	BamfApplication* _tmp12_;
	BamfApplication* _tmp13_;
	GdkRectangle _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (appitem != NULL);
	if (!plank_application_dock_item_is_running (appitem)) {
		return;
	}
	_tmp0_ = plank_dock_element_get_Text ((PlankDockElement*) appitem);
	_tmp1_ = _tmp0_;
	plank_logger_verbose ("DockWindow.update_icon_region ('%s')", _tmp1_, NULL);
	if (plank_dock_window_menu_is_visible (self)) {
		_tmp2_ = TRUE;
	} else {
		PlankDockController* _tmp3_;
		PlankHideManager* _tmp4_;
		PlankHideManager* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp3_ = self->priv->_controller;
		_tmp4_ = plank_dock_controller_get_hide_manager (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = plank_hide_manager_get_Hidden (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_;
	}
	use_hidden_region = _tmp2_;
	_tmp8_ = self->priv->_controller;
	_tmp9_ = plank_dock_controller_get_position_manager (_tmp8_);
	_tmp10_ = _tmp9_;
	plank_position_manager_get_icon_geometry (_tmp10_, appitem, use_hidden_region, &_tmp11_);
	region = _tmp11_;
	_tmp12_ = plank_application_dock_item_get_App (appitem);
	_tmp13_ = _tmp12_;
	_tmp14_ = region;
	plank_window_control_update_icon_regions (_tmp13_, &_tmp14_);
}

/**
 * If the popup menu is currently visible.
 */
gboolean
plank_dock_window_menu_is_visible (PlankDockWindow* self)
{
	gboolean _tmp0_ = FALSE;
	GtkMenu* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->menu;
	if (_tmp1_ != NULL) {
		GtkMenu* _tmp2_;
		_tmp2_ = self->priv->menu;
		_tmp0_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * Shows the popup menu.
 *
 * @param item the item to show a menu for, or NULL
 * @param event the event which triggerd this request
 */
static gboolean
plank_dock_window_show_menu (PlankDockWindow* self,
                             PlankDockItem* item,
                             GdkEventButton* event)
{
	GtkMenu* _tmp0_;
	GtkMenuPositionFunc position_func = NULL;
	gpointer position_func_target;
	GDestroyNotify position_func_target_destroy_notify;
	PlankPopupButton button = 0U;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp30_ = FALSE;
	GeeArrayList* _tmp31_;
	GtkMenu* _tmp35_;
	GtkMenu* _tmp36_;
	GtkMenu* _tmp37_;
	GtkMenu* _tmp38_;
	GeeBidirListIterator* iterator = NULL;
	GeeArrayList* _tmp39_;
	GeeBidirListIterator* _tmp40_;
	PlankDockController* _tmp41_;
	PlankDockPreferences* _tmp42_;
	PlankDockPreferences* _tmp43_;
	GtkPositionType _tmp44_;
	GtkPositionType _tmp45_;
	GtkMenu* _tmp62_;
	GtkMenuPositionFunc _tmp63_;
	gpointer _tmp63__target;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->menu;
	if (_tmp0_ != NULL) {
		GtkMenu* _tmp1_;
		GList* _tmp2_;
		GtkMenu* _tmp5_;
		guint _tmp6_;
		GtkMenu* _tmp7_;
		guint _tmp8_;
		GtkMenu* _tmp9_;
		_tmp1_ = self->priv->menu;
		_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp2_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* w = NULL;
				w = (GtkWidget*) w_it->data;
				{
					GtkMenu* _tmp3_;
					GtkWidget* _tmp4_;
					_tmp3_ = self->priv->menu;
					_tmp4_ = w;
					gtk_container_remove ((GtkContainer*) _tmp3_, _tmp4_);
				}
			}
			(w_collection == NULL) ? NULL : (w_collection = (g_list_free (w_collection), NULL));
		}
		_tmp5_ = self->priv->menu;
		g_signal_parse_name ("show", gtk_widget_get_type (), &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _plank_dock_window_on_menu_show_gtk_widget_show, self);
		_tmp7_ = self->priv->menu;
		g_signal_parse_name ("hide", gtk_widget_get_type (), &_tmp8_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _plank_dock_window_on_menu_hide_gtk_widget_hide, self);
		_tmp9_ = self->priv->menu;
		gtk_menu_detach (_tmp9_);
		_g_object_unref0 (self->priv->menu);
		self->priv->menu = NULL;
	}
	_g_object_unref0 (self->priv->menu_items);
	self->priv->menu_items = NULL;
	position_func = NULL;
	position_func_target = NULL;
	position_func_target_destroy_notify = NULL;
	button = plank_popup_button_from_event_button (event);
	if ((button & PLANK_POPUP_BUTTON_RIGHT) != 0) {
		gboolean _tmp11_ = FALSE;
		if (item == NULL) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = (event->state & GDK_CONTROL_MASK) != 0;
		}
		_tmp10_ = _tmp11_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		PlankItemFactory* _tmp12_;
		PlankDockItem* _tmp13_;
		PlankDockItem* _tmp14_;
		GeeArrayList* _tmp15_;
		gboolean _tmp16_ = FALSE;
		_tmp12_ = plank_factory_item_factory;
		_tmp13_ = plank_item_factory_get_item_for_dock (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = plank_dock_element_get_menu_items ((PlankDockElement*) _tmp14_);
		_g_object_unref0 (self->priv->menu_items);
		self->priv->menu_items = _tmp15_;
		_g_object_unref0 (_tmp14_);
		if ((event->state & GDK_MOD1_MASK) != 0) {
			_tmp16_ = (event->state & GDK_SHIFT_MASK) != 0;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			GeeArrayList* _tmp17_;
			PlankDockController* _tmp18_;
			GeeArrayList* _tmp19_;
			GeeArrayList* _tmp20_;
			_tmp17_ = self->priv->menu_items;
			_tmp18_ = self->priv->_controller;
			_tmp19_ = plank_dock_window_get_dock_debug_menu_items (_tmp18_);
			_tmp20_ = _tmp19_;
			gee_array_list_add_all (_tmp17_, (GeeCollection*) _tmp20_);
			_g_object_unref0 (_tmp20_);
		}
		plank_dock_window_set_hovered_provider (self, NULL);
		plank_dock_window_set_hovered (self, NULL);
	} else {
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		if (item != NULL) {
			_tmp22_ = plank_dock_item_is_valid (item);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			PlankPopupButton _tmp23_;
			PlankPopupButton _tmp24_;
			_tmp23_ = plank_dock_element_get_Button ((PlankDockElement*) item);
			_tmp24_ = _tmp23_;
			_tmp21_ = (_tmp24_ & button) != 0;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			GeeArrayList* _tmp25_;
			gboolean _tmp26_ = FALSE;
			_tmp25_ = plank_dock_element_get_menu_items ((PlankDockElement*) item);
			_g_object_unref0 (self->priv->menu_items);
			self->priv->menu_items = _tmp25_;
			if ((event->state & GDK_MOD1_MASK) != 0) {
				_tmp26_ = (event->state & GDK_SHIFT_MASK) != 0;
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				GeeArrayList* _tmp27_;
				GeeArrayList* _tmp28_;
				GeeArrayList* _tmp29_;
				_tmp27_ = self->priv->menu_items;
				_tmp28_ = plank_dock_window_get_item_debug_menu_items (item);
				_tmp29_ = _tmp28_;
				gee_array_list_add_all (_tmp27_, (GeeCollection*) _tmp29_);
				_g_object_unref0 (_tmp29_);
			}
			(position_func_target_destroy_notify == NULL) ? NULL : (position_func_target_destroy_notify (position_func_target), NULL);
			position_func = NULL;
			position_func_target = NULL;
			position_func_target_destroy_notify = NULL;
			position_func = (GtkMenuPositionFunc) plank_dock_window_position_menu;
			position_func_target = g_object_ref (self);
			position_func_target_destroy_notify = g_object_unref;
		}
	}
	_tmp31_ = self->priv->menu_items;
	if (_tmp31_ == NULL) {
		_tmp30_ = TRUE;
	} else {
		GeeArrayList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		_tmp32_ = self->priv->menu_items;
		_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp30_ = _tmp34_ == 0;
	}
	if (_tmp30_) {
		result = FALSE;
		(position_func_target_destroy_notify == NULL) ? NULL : (position_func_target_destroy_notify (position_func_target), NULL);
		position_func = NULL;
		position_func_target = NULL;
		position_func_target_destroy_notify = NULL;
		return result;
	}
	_tmp35_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp35_;
	_tmp36_ = self->priv->menu;
	gtk_menu_attach_to_widget (_tmp36_, (GtkWidget*) self, NULL);
	_tmp37_ = self->priv->menu;
	g_signal_connect_object ((GtkWidget*) _tmp37_, "show", (GCallback) _plank_dock_window_on_menu_show_gtk_widget_show, self, 0);
	_tmp38_ = self->priv->menu;
	g_signal_connect_object ((GtkWidget*) _tmp38_, "hide", (GCallback) _plank_dock_window_on_menu_hide_gtk_widget_hide, self, 0);
	_tmp39_ = self->priv->menu_items;
	_tmp40_ = gee_abstract_bidir_list_bidir_list_iterator ((GeeAbstractBidirList*) _tmp39_);
	iterator = _tmp40_;
	_tmp41_ = self->priv->_controller;
	_tmp42_ = plank_dock_controller_get_prefs (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = plank_dock_preferences_get_Position (_tmp43_);
	_tmp45_ = _tmp44_;
	if (_tmp45_ == GTK_POS_TOP) {
		GeeBidirListIterator* _tmp46_;
		_tmp46_ = iterator;
		gee_bidir_iterator_last ((GeeBidirIterator*) _tmp46_);
		{
			gboolean _tmp47_ = FALSE;
			_tmp47_ = TRUE;
			while (TRUE) {
				GtkMenuItem* menu_item = NULL;
				GeeBidirListIterator* _tmp49_;
				gpointer _tmp50_;
				GtkMenuItem* _tmp51_;
				GtkMenu* _tmp52_;
				GtkMenuItem* _tmp53_;
				if (!_tmp47_) {
					GeeBidirListIterator* _tmp48_;
					_tmp48_ = iterator;
					if (!gee_bidir_iterator_previous ((GeeBidirIterator*) _tmp48_)) {
						break;
					}
				}
				_tmp47_ = FALSE;
				_tmp49_ = iterator;
				_tmp50_ = gee_iterator_get ((GeeIterator*) _tmp49_);
				menu_item = (GtkMenuItem*) _tmp50_;
				_tmp51_ = menu_item;
				gtk_widget_show ((GtkWidget*) _tmp51_);
				_tmp52_ = self->priv->menu;
				_tmp53_ = menu_item;
				gtk_menu_shell_append ((GtkMenuShell*) _tmp52_, _tmp53_);
				_g_object_unref0 (menu_item);
			}
		}
	} else {
		GeeBidirListIterator* _tmp54_;
		_tmp54_ = iterator;
		gee_bidir_iterator_first ((GeeBidirIterator*) _tmp54_);
		{
			gboolean _tmp55_ = FALSE;
			_tmp55_ = TRUE;
			while (TRUE) {
				GtkMenuItem* menu_item = NULL;
				GeeBidirListIterator* _tmp57_;
				gpointer _tmp58_;
				GtkMenuItem* _tmp59_;
				GtkMenu* _tmp60_;
				GtkMenuItem* _tmp61_;
				if (!_tmp55_) {
					GeeBidirListIterator* _tmp56_;
					_tmp56_ = iterator;
					if (!gee_iterator_next ((GeeIterator*) _tmp56_)) {
						break;
					}
				}
				_tmp55_ = FALSE;
				_tmp57_ = iterator;
				_tmp58_ = gee_iterator_get ((GeeIterator*) _tmp57_);
				menu_item = (GtkMenuItem*) _tmp58_;
				_tmp59_ = menu_item;
				gtk_widget_show ((GtkWidget*) _tmp59_);
				_tmp60_ = self->priv->menu;
				_tmp61_ = menu_item;
				gtk_menu_shell_append ((GtkMenuShell*) _tmp60_, _tmp61_);
				_g_object_unref0 (menu_item);
			}
		}
	}
	_tmp62_ = self->priv->menu;
	_tmp63_ = position_func;
	_tmp63__target = position_func_target;
	gtk_menu_popup (_tmp62_, NULL, NULL, _tmp63_, _tmp63__target, event->button, event->time);
	result = TRUE;
	_g_object_unref0 (iterator);
	(position_func_target_destroy_notify == NULL) ? NULL : (position_func_target_destroy_notify (position_func_target), NULL);
	position_func = NULL;
	position_func_target = NULL;
	position_func_target_destroy_notify = NULL;
	return result;
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		_g_object_unref0 (_data18_->controller);
		g_slice_free (Block18Data, _data18_);
	}
}

static void
__lambda51_ (Block18Data* _data18_)
{
	PlankSystem* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	_tmp0_ = plank_system_get_default ();
	_tmp1_ = plank_dock_controller_get_config_folder (_data18_->controller);
	_tmp2_ = _tmp1_;
	plank_system_open (_tmp0_, _tmp2_);
}

static void
___lambda51__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda51_ (self);
}

static void
__lambda52_ (Block18Data* _data18_)
{
	PlankSystem* _tmp0_;
	PlankDockRenderer* _tmp1_;
	PlankDockRenderer* _tmp2_;
	PlankDockTheme* _tmp3_;
	PlankDockTheme* _tmp4_;
	GFile* _tmp5_;
	_tmp0_ = plank_system_get_default ();
	_tmp1_ = plank_dock_controller_get_renderer (_data18_->controller);
	_tmp2_ = _tmp1_;
	_tmp3_ = plank_dock_renderer_get_theme (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = plank_preferences_get_backing_file ((PlankPreferences*) _tmp4_);
	plank_system_open (_tmp0_, _tmp5_);
}

static void
___lambda52__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda52_ (self);
}

static GeeArrayList*
plank_dock_window_get_dock_debug_menu_items (PlankDockController* controller)
{
	Block18Data* _data18_;
	PlankDockController* _tmp0_;
	GeeArrayList* debug_items = NULL;
	GeeArrayList* _tmp1_;
	GtkSeparatorMenuItem* _tmp2_;
	GtkSeparatorMenuItem* _tmp3_;
	PlankTitledSeparatorMenuItem* _tmp4_;
	PlankTitledSeparatorMenuItem* _tmp5_;
	GtkMenuItem* menu_item = NULL;
	GtkMenuItem* _tmp6_;
	GtkMenuItem* _tmp7_;
	GtkMenuItem* _tmp8_;
	GtkMenuItem* _tmp9_;
	GtkMenuItem* _tmp10_;
	GtkMenuItem* _tmp11_;
	GeeArrayList* result;
	g_return_val_if_fail (controller != NULL, NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (controller);
	_g_object_unref0 (_data18_->controller);
	_data18_->controller = _tmp0_;
	_tmp1_ = gee_array_list_new (gtk_menu_item_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	debug_items = _tmp1_;
	_tmp2_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	gee_abstract_collection_add ((GeeAbstractCollection*) debug_items, (GtkMenuItem*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = plank_titled_separator_menu_item_new_no_line ("debug this dock");
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	gee_abstract_collection_add ((GeeAbstractCollection*) debug_items, (GtkMenuItem*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic ("Open config folder");
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (menu_item);
	menu_item = _tmp6_;
	_tmp7_ = menu_item;
	g_signal_connect_data (_tmp7_, "activate", (GCallback) ___lambda51__gtk_menu_item_activate, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	_tmp8_ = menu_item;
	gee_abstract_collection_add ((GeeAbstractCollection*) debug_items, _tmp8_);
	_tmp9_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic ("Open current theme file");
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (menu_item);
	menu_item = _tmp9_;
	_tmp10_ = menu_item;
	g_signal_connect_data (_tmp10_, "activate", (GCallback) ___lambda52__gtk_menu_item_activate, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	_tmp11_ = menu_item;
	gee_abstract_collection_add ((GeeAbstractCollection*) debug_items, _tmp11_);
	result = debug_items;
	_g_object_unref0 (menu_item);
	block18_data_unref (_data18_);
	_data18_ = NULL;
	return result;
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		_g_object_unref0 (_data19_->dock_item_file);
		_g_object_unref0 (_data19_->item);
		g_slice_free (Block19Data, _data19_);
	}
}

static void
__lambda53_ (Block19Data* _data19_)
{
	gchar* _tmp0_ = NULL;
	GFile* _tmp1_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	_tmp1_ = _data19_->dock_item_file;
	if (_tmp1_ != NULL) {
		GFile* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = _data19_->dock_item_file;
		_tmp3_ = g_file_get_uri (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = plank_dock_element_get_Text ((PlankDockElement*) _data19_->item);
	_tmp6_ = _tmp5_;
	_tmp7_ = plank_dock_item_get_Icon (_data19_->item);
	_tmp8_ = _tmp7_;
	_tmp9_ = plank_dock_item_get_Launcher (_data19_->item);
	_tmp10_ = _tmp9_;
	g_print ("DockItemFile: '%s'\nText = '%s'\nIcon = '%s'\nLauncher = '%s'\n", _tmp0_, _tmp6_, _tmp8_, _tmp10_);
	_g_free0 (_tmp0_);
}

static void
___lambda53__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda53_ (self);
}

static void
__lambda54_ (Block19Data* _data19_)
{
	PlankSystem* _tmp0_;
	GFile* _tmp1_;
	_tmp0_ = plank_system_get_default ();
	_tmp1_ = _data19_->dock_item_file;
	plank_system_open (_tmp0_, _tmp1_);
}

static void
___lambda54__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda54_ (self);
}

static void
__lambda55_ (Block19Data* _data19_)
{
	PlankSystem* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	_tmp0_ = plank_system_get_default ();
	_tmp1_ = plank_dock_item_get_Launcher (_data19_->item);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	plank_system_open (_tmp0_, _tmp4_);
	_g_object_unref0 (_tmp4_);
}

static void
___lambda55__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda55_ (self);
}

static GeeArrayList*
plank_dock_window_get_item_debug_menu_items (PlankDockItem* item)
{
	Block19Data* _data19_;
	PlankDockItem* _tmp0_;
	GeeArrayList* debug_items = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GtkSeparatorMenuItem* _tmp3_;
	GtkSeparatorMenuItem* _tmp4_;
	GeeArrayList* _tmp5_;
	PlankTitledSeparatorMenuItem* _tmp6_;
	PlankTitledSeparatorMenuItem* _tmp7_;
	GtkMenuItem* menu_item = NULL;
	PlankDockItemPreferences* _tmp8_;
	PlankDockItemPreferences* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GtkMenuItem* _tmp12_;
	GtkMenuItem* _tmp13_;
	GeeArrayList* _tmp14_;
	GtkMenuItem* _tmp15_;
	GtkMenuItem* _tmp16_;
	GtkMenuItem* _tmp17_;
	gboolean _tmp18_ = FALSE;
	GFile* _tmp19_;
	GtkMenuItem* _tmp21_;
	GeeArrayList* _tmp22_;
	GtkMenuItem* _tmp23_;
	GtkMenuItem* _tmp24_;
	GtkMenuItem* _tmp25_;
	GtkMenuItem* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GeeArrayList* _tmp29_;
	GtkMenuItem* _tmp30_;
	GeeArrayList* result;
	g_return_val_if_fail (item != NULL, NULL);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (item);
	_g_object_unref0 (_data19_->item);
	_data19_->item = _tmp0_;
	_tmp1_ = gee_array_list_new (gtk_menu_item_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	debug_items = _tmp1_;
	_tmp2_ = debug_items;
	_tmp3_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, (GtkMenuItem*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = debug_items;
	_tmp6_ = plank_titled_separator_menu_item_new_no_line ("debug this item");
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, (GtkMenuItem*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = plank_dock_item_get_Prefs (_data19_->item);
	_tmp9_ = _tmp8_;
	_tmp10_ = plank_preferences_get_backing_file ((PlankPreferences*) _tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_data19_->dock_item_file = _tmp11_;
	_tmp12_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic ("Print info to stdout");
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (menu_item);
	menu_item = _tmp12_;
	_tmp13_ = menu_item;
	g_signal_connect_data (_tmp13_, "activate", (GCallback) ___lambda53__gtk_menu_item_activate, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_tmp14_ = debug_items;
	_tmp15_ = menu_item;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
	_tmp16_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic ("Open dockitem file");
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (menu_item);
	menu_item = _tmp16_;
	_tmp17_ = menu_item;
	g_signal_connect_data (_tmp17_, "activate", (GCallback) ___lambda54__gtk_menu_item_activate, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_tmp19_ = _data19_->dock_item_file;
	if (_tmp19_ != NULL) {
		GFile* _tmp20_;
		_tmp20_ = _data19_->dock_item_file;
		_tmp18_ = g_file_query_exists (_tmp20_, NULL);
	} else {
		_tmp18_ = FALSE;
	}
	_tmp21_ = menu_item;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp21_, _tmp18_);
	_tmp22_ = debug_items;
	_tmp23_ = menu_item;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
	_tmp24_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic ("Open launcher file");
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (menu_item);
	menu_item = _tmp24_;
	_tmp25_ = menu_item;
	g_signal_connect_data (_tmp25_, "activate", (GCallback) ___lambda55__gtk_menu_item_activate, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_tmp26_ = menu_item;
	_tmp27_ = plank_dock_item_get_Launcher (_data19_->item);
	_tmp28_ = _tmp27_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp26_, g_strcmp0 (_tmp28_, "") != 0);
	_tmp29_ = debug_items;
	_tmp30_ = menu_item;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, _tmp30_);
	result = debug_items;
	_g_object_unref0 (menu_item);
	block19_data_unref (_data19_);
	_data19_ = NULL;
	return result;
}

/**
 * Called when the popup menu hides.
 */
static void
plank_dock_window_on_menu_hide (PlankDockWindow* self)
{
	PlankHideManager* hide_manager = NULL;
	PlankDockController* _tmp0_;
	PlankHideManager* _tmp1_;
	PlankHideManager* _tmp2_;
	PlankHideManager* _tmp3_;
	PlankHideManager* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	plank_dock_window_update_icon_regions (self);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_hide_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	hide_manager = _tmp2_;
	_tmp3_ = hide_manager;
	plank_hide_manager_update_hovered (_tmp3_);
	_tmp4_ = hide_manager;
	_tmp5_ = plank_hide_manager_get_Hovered (_tmp4_);
	_tmp6_ = _tmp5_;
	if (!_tmp6_) {
		plank_dock_window_set_hovered_provider (self, NULL);
		plank_dock_window_set_hovered (self, NULL);
	}
	_g_object_unref0 (self->priv->menu_items);
	self->priv->menu_items = NULL;
}

/**
 * Called when the popup menu shows.
 */
static void
plank_dock_window_on_menu_show (PlankDockWindow* self)
{
	PlankDockController* _tmp0_;
	PlankHoverWindow* _tmp1_;
	PlankHoverWindow* _tmp2_;
	PlankDockController* _tmp3_;
	PlankDockRenderer* _tmp4_;
	PlankDockRenderer* _tmp5_;
	g_return_if_fail (self != NULL);
	plank_dock_window_update_icon_regions (self);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_hover (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_renderer (_tmp3_);
	_tmp5_ = _tmp4_;
	plank_renderer_animated_draw ((PlankRenderer*) _tmp5_);
}

/**
 * Positions the popup menu.
 *
 * @param menu the popup menu to show
 * @param x the x location to show the menu
 * @param y the y location to show the menu
 * @param push_in if the menu should push into the screen
 */
static void
plank_dock_window_position_menu (GtkMenu* menu,
                                 gint* x,
                                 gint* y,
                                 gboolean* push_in,
                                 PlankDockWindow* self)
{
	gboolean _vala_push_in = FALSE;
	GtkRequisition requisition = {0};
	GtkRequisition _tmp0_ = {0};
	PlankDockController* _tmp1_;
	PlankPositionManager* _tmp2_;
	PlankPositionManager* _tmp3_;
	PlankDockItem* _tmp4_;
	GtkRequisition _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	gtk_widget_get_preferred_size ((GtkWidget*) menu, NULL, &_tmp0_);
	requisition = _tmp0_;
	_tmp1_ = self->priv->_controller;
	_tmp2_ = plank_dock_controller_get_position_manager (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_HoveredItem;
	_tmp5_ = requisition;
	plank_position_manager_get_menu_position (_tmp3_, _tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
	*x = _tmp6_;
	*y = _tmp7_;
	_vala_push_in = FALSE;
	if (push_in) {
		*push_in = _vala_push_in;
	}
}

static gboolean
_cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                            const cairo_rectangle_int_t * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

static void
plank_dock_window_set_input_mask (PlankDockWindow* self)
{
	GdkRectangle cursor_rect = {0};
	PlankDockController* _tmp0_;
	PlankPositionManager* _tmp1_;
	PlankPositionManager* _tmp2_;
	GdkRectangle _tmp3_ = {0};
	GdkRectangle _tmp4_;
	GdkRectangle _tmp5_;
	GdkRectangle _tmp6_;
	GdkRectangle _tmp7_;
	g_return_if_fail (self != NULL);
	if (!gtk_widget_get_realized ((GtkWidget*) self)) {
		return;
	}
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_position_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	plank_position_manager_get_cursor_region (_tmp2_, &_tmp3_);
	cursor_rect = _tmp3_;
	_tmp4_ = cursor_rect;
	g_return_if_fail (_tmp4_.width > 0);
	_tmp5_ = cursor_rect;
	g_return_if_fail (_tmp5_.height > 0);
	_tmp6_ = cursor_rect;
	_tmp7_ = self->priv->input_rect;
	if (_cairo_rectangle_int_equal (&_tmp6_, &_tmp7_) != TRUE) {
		GdkRectangle _tmp8_;
		GdkWindow* _tmp9_;
		GdkRectangle _tmp10_;
		cairo_rectangle_int_t _tmp11_;
		cairo_region_t* _tmp12_;
		cairo_region_t* _tmp13_;
		_tmp8_ = cursor_rect;
		self->priv->input_rect = _tmp8_;
		_tmp9_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp10_ = cursor_rect;
		_tmp11_ = (cairo_rectangle_int_t) _tmp10_;
		_tmp12_ = cairo_region_create_rectangle (&_tmp11_);
		_tmp13_ = _tmp12_;
		gdk_window_input_shape_combine_region (_tmp9_, _tmp13_, 0, 0);
		_cairo_region_destroy0 (_tmp13_);
	}
}

static void
plank_dock_window_set_struts (PlankDockWindow* self)
{
	GdkX11Display* gdk_display = NULL;
	GdkDisplay* _tmp0_;
	GdkX11Display* _tmp1_;
	GdkX11Window* gdk_window = NULL;
	GdkWindow* _tmp2_;
	GdkX11Window* _tmp3_;
	gulong* struts = NULL;
	gulong* _tmp4_;
	gint struts_length1;
	gint _struts_size_;
	PlankDockController* _tmp5_;
	PlankDockPreferences* _tmp6_;
	PlankDockPreferences* _tmp7_;
	PlankHideType _tmp8_;
	PlankHideType _tmp9_;
	gulong* first_struts = NULL;
	gulong* _tmp13_;
	gint first_struts_length1;
	gint _first_struts_size_;
	Display* display = NULL;
	GdkX11Display* _tmp20_;
	Display* _tmp21_;
	Window xid = 0;
	GdkX11Window* _tmp22_;
	GdkX11Display* _tmp23_;
	Display* _tmp24_;
	Display* _tmp25_;
	gulong* _tmp26_;
	gint _tmp26__length1;
	gulong* _tmp27_;
	gint _tmp27__length1;
	Display* _tmp28_;
	Display* _tmp29_;
	gulong* _tmp30_;
	gint _tmp30__length1;
	gulong* _tmp31_;
	gint _tmp31__length1;
	GdkX11Display* _tmp32_;
	g_return_if_fail (self != NULL);
	if (!gtk_widget_get_realized ((GtkWidget*) self)) {
		return;
	}
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	gdk_display = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp0_) : NULL;
	_tmp1_ = gdk_display;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gdk_x11_window_get_type ()) ? ((GdkX11Window*) _tmp2_) : NULL;
	_tmp3_ = gdk_window;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = g_new0 (gulong, PLANK_STRUTS_N_VALUES);
	struts = _tmp4_;
	struts_length1 = PLANK_STRUTS_N_VALUES;
	_struts_size_ = struts_length1;
	_tmp5_ = self->priv->_controller;
	_tmp6_ = plank_dock_controller_get_prefs (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = plank_dock_preferences_get_HideMode (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == PLANK_HIDE_TYPE_NONE) {
		PlankDockController* _tmp10_;
		PlankPositionManager* _tmp11_;
		PlankPositionManager* _tmp12_;
		_tmp10_ = self->priv->_controller;
		_tmp11_ = plank_dock_controller_get_position_manager (_tmp10_);
		_tmp12_ = _tmp11_;
		plank_position_manager_get_struts (_tmp12_, &struts, (gint*) (&struts_length1));
		_struts_size_ = struts_length1;
	}
	_tmp13_ = g_new0 (gulong, PLANK_STRUTS_BOTTOM + 1);
	first_struts = _tmp13_;
	first_struts_length1 = PLANK_STRUTS_BOTTOM + 1;
	_first_struts_size_ = first_struts_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				gulong* _tmp16_;
				gint _tmp16__length1;
				gulong* _tmp17_;
				gint _tmp17__length1;
				gulong* _tmp18_;
				gint _tmp18__length1;
				gulong _tmp19_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = first_struts;
				_tmp16__length1 = first_struts_length1;
				if (!(i < _tmp16__length1)) {
					break;
				}
				_tmp17_ = first_struts;
				_tmp17__length1 = first_struts_length1;
				_tmp18_ = struts;
				_tmp18__length1 = struts_length1;
				_tmp19_ = _tmp18_[i];
				_tmp17_[i] = _tmp19_;
			}
		}
	}
	_tmp20_ = gdk_display;
	_tmp21_ = gdk_x11_display_get_xdisplay (_tmp20_);
	display = _tmp21_;
	_tmp22_ = gdk_window;
	xid = gdk_x11_window_get_xid (_tmp22_);
	_tmp23_ = gdk_display;
	gdk_x11_display_error_trap_push (_tmp23_);
	_tmp24_ = display;
	_tmp25_ = display;
	_tmp26_ = struts;
	_tmp26__length1 = struts_length1;
	_tmp27_ = struts;
	_tmp27__length1 = struts_length1;
	XChangeProperty (_tmp24_, xid, XInternAtom (_tmp25_, "_NET_WM_STRUT_PARTIAL", FALSE), XA_CARDINAL, 32, (gint) PropModeReplace, (guchar*) _tmp26_, _tmp27__length1);
	_tmp28_ = display;
	_tmp29_ = display;
	_tmp30_ = first_struts;
	_tmp30__length1 = first_struts_length1;
	_tmp31_ = first_struts;
	_tmp31__length1 = first_struts_length1;
	XChangeProperty (_tmp28_, xid, XInternAtom (_tmp29_, "_NET_WM_STRUT", FALSE), XA_CARDINAL, 32, (gint) PropModeReplace, (guchar*) _tmp30_, _tmp31__length1);
	_tmp32_ = gdk_display;
	if (gdk_x11_display_error_trap_pop (_tmp32_) != Success) {
		g_critical ("DockWindow.vala:803: Error while setting struts");
	}
	first_struts = (g_free (first_struts), NULL);
	struts = (g_free (struts), NULL);
}

static PlankDockController*
plank_dock_window_get_controller (PlankDockWindow* self)
{
	PlankDockController* result;
	PlankDockController* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_controller;
	result = _tmp0_;
	return result;
}

static void
plank_dock_window_set_controller (PlankDockWindow* self,
                                  PlankDockController* value)
{
	PlankDockController* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_window_get_controller (self);
	if (old_value != value) {
		PlankDockController* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_controller);
		self->priv->_controller = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_window_properties[PLANK_DOCK_WINDOW_CONTROLLER_PROPERTY]);
	}
}

PlankDockItem*
plank_dock_window_get_HoveredItem (PlankDockWindow* self)
{
	PlankDockItem* result;
	PlankDockItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_HoveredItem;
	result = _tmp0_;
	return result;
}

static void
plank_dock_window_set_HoveredItem (PlankDockWindow* self,
                                   PlankDockItem* value)
{
	PlankDockItem* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_window_get_HoveredItem (self);
	if (old_value != value) {
		PlankDockItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_HoveredItem);
		self->priv->_HoveredItem = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_window_properties[PLANK_DOCK_WINDOW_HOVERED_ITEM_PROPERTY]);
	}
}

PlankDockItemProvider*
plank_dock_window_get_HoveredItemProvider (PlankDockWindow* self)
{
	PlankDockItemProvider* result;
	PlankDockItemProvider* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_HoveredItemProvider;
	result = _tmp0_;
	return result;
}

static void
plank_dock_window_set_HoveredItemProvider (PlankDockWindow* self,
                                           PlankDockItemProvider* value)
{
	PlankDockItemProvider* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_window_get_HoveredItemProvider (self);
	if (old_value != value) {
		PlankDockItemProvider* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_HoveredItemProvider);
		self->priv->_HoveredItemProvider = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_window_properties[PLANK_DOCK_WINDOW_HOVERED_ITEM_PROVIDER_PROPERTY]);
	}
}

static PlankDockItem*
plank_dock_window_get_ClickedItem (PlankDockWindow* self)
{
	PlankDockItem* result;
	PlankDockItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ClickedItem;
	result = _tmp0_;
	return result;
}

static void
plank_dock_window_set_ClickedItem (PlankDockWindow* self,
                                   PlankDockItem* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_ClickedItem = value;
}

static GObject *
plank_dock_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankDockWindow * self;
	PlankDockController* _tmp0_;
	PlankDockPreferences* _tmp1_;
	PlankDockPreferences* _tmp2_;
	parent_class = G_OBJECT_CLASS (plank_dock_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCK_WINDOW, PlankDockWindow);
	gtk_window_set_accept_focus ((GtkWindow*) self, FALSE);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_stick ((GtkWindow*) self);
	gtk_widget_add_events ((GtkWidget*) self, (gint) ((((((GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK) | GDK_ENTER_NOTIFY_MASK) | GDK_LEAVE_NOTIFY_MASK) | GDK_POINTER_MOTION_MASK) | GDK_SCROLL_MASK) | GDK_STRUCTURE_MASK));
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_prefs (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::HideMode", (GCallback) _plank_dock_window_set_struts_g_object_notify, self, 0);
	return obj;
}

static void
plank_dock_window_class_init (PlankDockWindowClass * klass,
                              gpointer klass_data)
{
	plank_dock_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankDockWindow_private_offset);
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) plank_dock_window_real_button_press_event;
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) plank_dock_window_real_button_release_event;
	((GtkWidgetClass *) klass)->enter_notify_event = (gboolean (*) (GtkWidget*, GdkEventCrossing*)) plank_dock_window_real_enter_notify_event;
	((GtkWidgetClass *) klass)->leave_notify_event = (gboolean (*) (GtkWidget*, GdkEventCrossing*)) plank_dock_window_real_leave_notify_event;
	((GtkWidgetClass *) klass)->motion_notify_event = (gboolean (*) (GtkWidget*, GdkEventMotion*)) plank_dock_window_real_motion_notify_event;
	((GtkWidgetClass *) klass)->drag_begin = (void (*) (GtkWidget*, GdkDragContext*)) plank_dock_window_real_drag_begin;
	((GtkWidgetClass *) klass)->scroll_event = (gboolean (*) (GtkWidget*, GdkEventScroll*)) plank_dock_window_real_scroll_event;
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) plank_dock_window_real_configure_event;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) plank_dock_window_real_draw;
	((GtkWidgetClass *) klass)->map_event = (gboolean (*) (GtkWidget*, GdkEventAny*)) plank_dock_window_real_map_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_dock_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_dock_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_dock_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_dock_window_finalize;
	/**
	 * The controller for this dock.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_WINDOW_CONTROLLER_PROPERTY, plank_dock_window_properties[PLANK_DOCK_WINDOW_CONTROLLER_PROPERTY] = g_param_spec_object ("controller", "controller", "controller", PLANK_TYPE_DOCK_CONTROLLER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * The currently hovered item (if any).
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_WINDOW_HOVERED_ITEM_PROPERTY, plank_dock_window_properties[PLANK_DOCK_WINDOW_HOVERED_ITEM_PROPERTY] = g_param_spec_object ("HoveredItem", "HoveredItem", "HoveredItem", PLANK_TYPE_DOCK_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The currently hovered item-provider (if any).
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_WINDOW_HOVERED_ITEM_PROVIDER_PROPERTY, plank_dock_window_properties[PLANK_DOCK_WINDOW_HOVERED_ITEM_PROVIDER_PROPERTY] = g_param_spec_object ("HoveredItemProvider", "HoveredItemProvider", "HoveredItemProvider", PLANK_TYPE_DOCK_ITEM_PROVIDER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
plank_dock_window_instance_init (PlankDockWindow * self,
                                 gpointer klass)
{
	self->priv = plank_dock_window_get_instance_private (self);
	self->priv->hover_reposition_timer_id = 0U;
	self->priv->long_press_timer_id = 0U;
	self->priv->long_press_active = FALSE;
	self->priv->long_press_button = 0U;
	self->priv->window_position_retry = 0;
}

static void
plank_dock_window_finalize (GObject * obj)
{
	PlankDockWindow * self;
	GtkMenu* _tmp0_;
	PlankDockController* _tmp5_;
	PlankDockPreferences* _tmp6_;
	PlankDockPreferences* _tmp7_;
	guint _tmp8_;
	GQuark _tmp9_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCK_WINDOW, PlankDockWindow);
	_tmp0_ = self->priv->menu;
	if (_tmp0_ != NULL) {
		GtkMenu* _tmp1_;
		guint _tmp2_;
		GtkMenu* _tmp3_;
		guint _tmp4_;
		_tmp1_ = self->priv->menu;
		g_signal_parse_name ("show", gtk_widget_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _plank_dock_window_on_menu_show_gtk_widget_show, self);
		_tmp3_ = self->priv->menu;
		g_signal_parse_name ("hide", gtk_widget_get_type (), &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _plank_dock_window_on_menu_hide_gtk_widget_hide, self);
	}
	_tmp5_ = self->priv->_controller;
	_tmp6_ = plank_dock_controller_get_prefs (_tmp5_);
	_tmp7_ = _tmp6_;
	g_signal_parse_name ("notify::HideMode", G_TYPE_OBJECT, &_tmp8_, &_tmp9_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, _tmp9_, NULL, (GCallback) _plank_dock_window_set_struts_g_object_notify, self);
	if (self->priv->hover_reposition_timer_id > 0U) {
		g_source_remove (self->priv->hover_reposition_timer_id);
		self->priv->hover_reposition_timer_id = 0U;
	}
	_g_object_unref0 (self->priv->_controller);
	_g_object_unref0 (self->priv->_HoveredItem);
	_g_object_unref0 (self->priv->_HoveredItemProvider);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->menu_items);
	G_OBJECT_CLASS (plank_dock_window_parent_class)->finalize (obj);
}

/**
 * The main window for all docks.
 */
static GType
plank_dock_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDockWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_dock_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDockWindow), 0, (GInstanceInitFunc) plank_dock_window_instance_init, NULL };
	GType plank_dock_window_type_id;
	plank_dock_window_type_id = g_type_register_static (PLANK_TYPE_COMPOSITED_WINDOW, "PlankDockWindow", &g_define_type_info, 0);
	PlankDockWindow_private_offset = g_type_add_instance_private (plank_dock_window_type_id, sizeof (PlankDockWindowPrivate));
	return plank_dock_window_type_id;
}

GType
plank_dock_window_get_type (void)
{
	static volatile gsize plank_dock_window_type_id__once = 0;
	if (g_once_init_enter (&plank_dock_window_type_id__once)) {
		GType plank_dock_window_type_id;
		plank_dock_window_type_id = plank_dock_window_get_type_once ();
		g_once_init_leave (&plank_dock_window_type_id__once, plank_dock_window_type_id);
	}
	return plank_dock_window_type_id__once;
}

static void
_vala_plank_dock_window_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	PlankDockWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_WINDOW, PlankDockWindow);
	switch (property_id) {
		case PLANK_DOCK_WINDOW_CONTROLLER_PROPERTY:
		g_value_set_object (value, plank_dock_window_get_controller (self));
		break;
		case PLANK_DOCK_WINDOW_HOVERED_ITEM_PROPERTY:
		g_value_set_object (value, plank_dock_window_get_HoveredItem (self));
		break;
		case PLANK_DOCK_WINDOW_HOVERED_ITEM_PROVIDER_PROPERTY:
		g_value_set_object (value, plank_dock_window_get_HoveredItemProvider (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_dock_window_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	PlankDockWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_WINDOW, PlankDockWindow);
	switch (property_id) {
		case PLANK_DOCK_WINDOW_CONTROLLER_PROPERTY:
		plank_dock_window_set_controller (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_WINDOW_HOVERED_ITEM_PROPERTY:
		plank_dock_window_set_HoveredItem (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_WINDOW_HOVERED_ITEM_PROVIDER_PROPERTY:
		plank_dock_window_set_HoveredItemProvider (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

