/* Utils.c generated by valac 0.56.17, the Vala compiler
 * generated from Utils.vala, do not modify */

/**/
/*  Copyright (C) 2015 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank-internal.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

VALA_EXTERN void plank_combine_strings (gchar*** _result_,
                            gint* _result__length1,
                            const gchar* delimiter,
                            gint n,
                            gint i);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

/**
 * Creates a new {@link GLib.Settings} object with a given schema and path.
 *
 * It is fatal if no schema to the given schema_id is found!
 *
 * If path is NULL then the path from the schema is used. It is an error if
 * path is NULL and the schema has no path of its own or if path is non-NULL
 * and not equal to the path that the schema does have.
 *
 * @param schema_id a schema ID
 * @param path the path to use
 * @return a new GLib.Settings object
 */
GSettings*
plank_create_settings (const gchar* schema_id,
                       const gchar* path)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp4_;
	GSettingsSchema* _tmp5_;
	GSettings* _tmp6_;
	GSettings* result;
	g_return_val_if_fail (schema_id != NULL, NULL);
	_tmp0_ = g_get_current_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "/data", NULL);
	_tmp3_ = _tmp2_;
	g_setenv ("GSETTINGS_SCHEMA_DIR", _tmp3_, FALSE);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = g_settings_schema_source_get_default ();
	_tmp5_ = g_settings_schema_source_lookup (_tmp4_, schema_id, TRUE);
	schema = _tmp5_;
	if (schema == NULL) {
		g_error ("Utils.vala:42: GSettingsSchema '%s' not found", schema_id);
	}
	_tmp6_ = g_settings_new_full (schema, NULL, path);
	result = _tmp6_;
	_g_settings_schema_unref0 (schema);
	return result;
}

/**
 * Tries to create a new {@link GLib.Settings} object with a given schema and path.
 *
 * If path is NULL then the path from the schema is used. It is an error if
 * path is NULL and the schema has no path of its own or if path is non-NULL
 * and not equal to the path that the schema does have.
 *
 * @param schema_id a schema ID
 * @param path the path to use
 * @return a new GLib.Settings object or NULL
 */
GSettings*
plank_try_create_settings (const gchar* schema_id,
                           const gchar* path)
{
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	GSettingsSchema* _tmp3_;
	GSettings* _tmp4_;
	GSettings* result;
	g_return_val_if_fail (schema_id != NULL, NULL);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, schema_id, TRUE);
	schema = _tmp1_;
	_tmp2_ = schema;
	if (_tmp2_ == NULL) {
		g_warning ("Utils.vala:62: GSettingsSchema '%s' not found", schema_id);
		result = NULL;
		_g_settings_schema_unref0 (schema);
		return result;
	}
	_tmp3_ = schema;
	_tmp4_ = g_settings_new_full (_tmp3_, NULL, path);
	result = _tmp4_;
	_g_settings_schema_unref0 (schema);
	return result;
}

/**
 * Generates an array containing all combinations of a splitted strings parts
 * while preserving the given order of them.
 *
 * @param s a string
 * @param delimiter a delimiter string
 * @return an array of concated strings
 */
gchar**
plank_string_split_combine (const gchar* s,
                            const gchar* delimiter,
                            gint* result_length1)
{
	gchar** parts = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint parts_length1;
	gint _parts_size_;
	gint count = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _result_ = NULL;
	gchar** _tmp3_;
	gint _result__length1;
	gint __result__size_;
	gint pos = 0;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** result;
	g_return_val_if_fail (s != NULL, NULL);
	g_return_val_if_fail (delimiter != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (s, delimiter, 0);
	parts = _tmp1_;
	parts_length1 = _vala_array_length (_tmp0_);
	_parts_size_ = parts_length1;
	_tmp2_ = parts;
	_tmp2__length1 = parts_length1;
	count = _tmp2__length1;
	_tmp3_ = g_new0 (gchar*, ((count * (count + 1)) / 2) + 1);
	_result_ = _tmp3_;
	_result__length1 = (count * (count + 1)) / 2;
	__result__size_ = _result__length1;
	pos = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gchar** _tmp6_;
				gint _tmp6__length1;
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < count)) {
					break;
				}
				_tmp6_ = _result_;
				_tmp6__length1 = _result__length1;
				_tmp7_ = parts;
				_tmp7__length1 = parts_length1;
				_tmp8_ = _tmp7_[i];
				_tmp9_ = g_strdup (_tmp8_);
				_g_free0 (_tmp6_[pos]);
				_tmp6_[pos] = _tmp9_;
				pos += count - i;
			}
		}
	}
	plank_combine_strings (&_result_, (gint*) (&_result__length1), delimiter, 0, count);
	__result__size_ = _result__length1;
	_tmp10_ = _result_;
	_tmp10__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
plank_combine_strings (gchar*** _result_,
                       gint* _result__length1,
                       const gchar* delimiter,
                       gint n,
                       gint i)
{
	gint pos = 0;
	g_return_if_fail (delimiter != NULL);
	if (i <= 1) {
		return;
	}
	pos = n;
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = j;
					j = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(j < (i - 1))) {
					break;
				}
				pos += i - j;
				_tmp2_ = (*_result_)[n + j];
				_tmp3_ = (*_result_)[pos];
				_tmp4_ = g_strdup_printf ("%s%s%s", _tmp2_, delimiter, _tmp3_);
				_g_free0 ((*_result_)[(n + j) + 1]);
				(*_result_)[(n + j) + 1] = _tmp4_;
			}
		}
	}
	plank_combine_strings (_result_, (gint*) (_result__length1), delimiter, n + i, i - 1);
}

/**
 * Whether the given file looks like a valid .dockitem file
 */
inline gboolean
plank_file_is_dockitem (GFile* file)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp0_;
		gboolean _tmp1_ = FALSE;
		_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, 0, NULL, &_inner_error0_);
		info = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!g_file_info_get_is_hidden (info)) {
			const gchar* _tmp2_;
			_tmp2_ = g_file_info_get_name (info);
			_tmp1_ = g_str_has_suffix (_tmp2_, ".dockitem");
		} else {
			_tmp1_ = FALSE;
		}
		result = _tmp1_;
		_g_object_unref0 (info);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Utils.vala:119: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	result = FALSE;
	return result;
}

inline gdouble
plank_nround (gdouble d,
              guint n)
{
	gdouble _result_ = 0.0;
	gdouble result;
	if (n > 0U) {
		gdouble fac = 0.0;
		fac = pow (10.0, (gdouble) n);
		_result_ = round (d * fac) / fac;
	} else {
		_result_ = round (d);
	}
	result = _result_;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

