/* Logger.c generated by valac 0.56.17, the Vala compiler
 * generated from Logger.vala, do not modify */

/**/
/*  Copyright (C) 2011 Robert Dyer*/
/*                2015 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plank.h"
#include <glib-object.h>
#include <stdarg.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef enum  {
	PLANK_CONSOLE_COLOR_BLACK,
	PLANK_CONSOLE_COLOR_RED,
	PLANK_CONSOLE_COLOR_GREEN,
	PLANK_CONSOLE_COLOR_YELLOW,
	PLANK_CONSOLE_COLOR_BLUE,
	PLANK_CONSOLE_COLOR_MAGENTA,
	PLANK_CONSOLE_COLOR_CYAN,
	PLANK_CONSOLE_COLOR_WHITE
} PlankConsoleColor;

#define PLANK_TYPE_CONSOLE_COLOR (plank_console_color_get_type ())
enum  {
	PLANK_LOGGER_0_PROPERTY,
	PLANK_LOGGER_NUM_PROPERTIES
};
static GParamSpec* plank_logger_properties[PLANK_LOGGER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

static gpointer plank_logger_parent_class = NULL;
static PlankLogLevel plank_logger__DisplayLevel;
static PlankLogLevel plank_logger__DisplayLevel = PLANK_LOG_LEVEL_WARN;
static gchar* plank_logger_app_domain;
static gchar* plank_logger_app_domain = NULL;
static GMutex plank_logger_write_mutex;
static GMutex plank_logger_write_mutex = {0};
static GRegex* plank_logger_message_regex;
static GRegex* plank_logger_message_regex = NULL;

VALA_EXTERN GType plank_console_color_get_type (void) G_GNUC_CONST ;
static PlankLogger* plank_logger_new (void);
static PlankLogger* plank_logger_construct (GType object_type);
static void plank_logger_glib_log_func (const gchar* d,
                                 GLogLevelFlags flags,
                                 const gchar* msg);
static gchar* plank_logger_format_message (const gchar* msg);
static void plank_logger_write (PlankLogLevel level,
                         gchar* msg);
static gchar* plank_logger_get_time (void);
static void plank_logger_set_color_for_level (PlankLogLevel level);
static void plank_logger_reset_color (void);
static void plank_logger_set_foreground (PlankConsoleColor color);
static void plank_logger_set_background (PlankConsoleColor color);
static void plank_logger_set_color (PlankConsoleColor color,
                             gboolean isForeground);
static void plank_logger_finalize (GObject * obj);
static GType plank_logger_get_type_once (void);
static void _vala_plank_logger_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_plank_logger_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const gchar* PLANK_LOG_LEVEL_TO_STRING[7] = {"VERBOSE", "DEBUG", "INFO", "NOTIFY", "WARN", "CRITICAL", "ERROR"};
static GRegex* _tmp_regex_0 = NULL;

/**
 * Controls what messages show in the console log.
 */
static GType
plank_log_level_get_type_once (void)
{
	static const GEnumValue values[] = {{PLANK_LOG_LEVEL_VERBOSE, "PLANK_LOG_LEVEL_VERBOSE", "verbose"}, {PLANK_LOG_LEVEL_DEBUG, "PLANK_LOG_LEVEL_DEBUG", "debug"}, {PLANK_LOG_LEVEL_INFO, "PLANK_LOG_LEVEL_INFO", "info"}, {PLANK_LOG_LEVEL_NOTIFY, "PLANK_LOG_LEVEL_NOTIFY", "notify"}, {PLANK_LOG_LEVEL_WARN, "PLANK_LOG_LEVEL_WARN", "warn"}, {PLANK_LOG_LEVEL_CRITICAL, "PLANK_LOG_LEVEL_CRITICAL", "critical"}, {PLANK_LOG_LEVEL_ERROR, "PLANK_LOG_LEVEL_ERROR", "error"}, {0, NULL, NULL}};
	GType plank_log_level_type_id;
	plank_log_level_type_id = g_enum_register_static ("PlankLogLevel", values);
	return plank_log_level_type_id;
}

GType
plank_log_level_get_type (void)
{
	static volatile gsize plank_log_level_type_id__once = 0;
	if (g_once_init_enter (&plank_log_level_type_id__once)) {
		GType plank_log_level_type_id;
		plank_log_level_type_id = plank_log_level_get_type_once ();
		g_once_init_leave (&plank_log_level_type_id__once, plank_log_level_type_id);
	}
	return plank_log_level_type_id__once;
}

static GType
plank_console_color_get_type_once (void)
{
	static const GEnumValue values[] = {{PLANK_CONSOLE_COLOR_BLACK, "PLANK_CONSOLE_COLOR_BLACK", "black"}, {PLANK_CONSOLE_COLOR_RED, "PLANK_CONSOLE_COLOR_RED", "red"}, {PLANK_CONSOLE_COLOR_GREEN, "PLANK_CONSOLE_COLOR_GREEN", "green"}, {PLANK_CONSOLE_COLOR_YELLOW, "PLANK_CONSOLE_COLOR_YELLOW", "yellow"}, {PLANK_CONSOLE_COLOR_BLUE, "PLANK_CONSOLE_COLOR_BLUE", "blue"}, {PLANK_CONSOLE_COLOR_MAGENTA, "PLANK_CONSOLE_COLOR_MAGENTA", "magenta"}, {PLANK_CONSOLE_COLOR_CYAN, "PLANK_CONSOLE_COLOR_CYAN", "cyan"}, {PLANK_CONSOLE_COLOR_WHITE, "PLANK_CONSOLE_COLOR_WHITE", "white"}, {0, NULL, NULL}};
	GType plank_console_color_type_id;
	plank_console_color_type_id = g_enum_register_static ("PlankConsoleColor", values);
	return plank_console_color_type_id;
}

GType
plank_console_color_get_type (void)
{
	static volatile gsize plank_console_color_type_id__once = 0;
	if (g_once_init_enter (&plank_console_color_type_id__once)) {
		GType plank_console_color_type_id;
		plank_console_color_type_id = plank_console_color_get_type_once ();
		g_once_init_leave (&plank_console_color_type_id__once, plank_console_color_type_id);
	}
	return plank_console_color_type_id__once;
}

static PlankLogger*
plank_logger_construct (GType object_type)
{
	PlankLogger * self = NULL;
	self = (PlankLogger*) g_object_new (object_type, NULL);
	return self;
}

static PlankLogger*
plank_logger_new (void)
{
	return plank_logger_construct (PLANK_TYPE_LOGGER);
}

/**
 * Initializes the logger for the application.
 *
 * @param app_name the name of the application
 */
static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

void
plank_logger_initialize (const gchar* app_name)
{
	gchar* _tmp0_;
	GRegex* _tmp1_;
	g_return_if_fail (app_name != NULL);
	_tmp0_ = g_strdup (app_name);
	_g_free0 (plank_logger_app_domain);
	plank_logger_app_domain = _tmp0_;
	_tmp1_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "[(]?.*?([^\\/]*?)(\\.2)?\\.vala(:\\d+)[)]?:\\s*(.*)", 0));
	_g_regex_unref0 (plank_logger_message_regex);
	plank_logger_message_regex = _tmp1_;
	g_log_set_default_handler ((GLogFunc) plank_logger_glib_log_func, NULL);
}

static gchar*
plank_logger_format_message (const gchar* msg)
{
	gboolean _tmp0_ = FALSE;
	GRegex* _tmp1_;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp1_ = plank_logger_message_regex;
	if (_tmp1_ != NULL) {
		GRegex* _tmp2_;
		_tmp2_ = plank_logger_message_regex;
		_tmp0_ = g_regex_match (_tmp2_, msg, 0, NULL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar** parts = NULL;
		GRegex* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint parts_length1;
		gint _parts_size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp3_ = plank_logger_message_regex;
		_tmp5_ = _tmp4_ = g_regex_split (_tmp3_, msg, 0);
		parts = _tmp5_;
		parts_length1 = _vala_array_length (_tmp4_);
		_parts_size_ = parts_length1;
		_tmp6_ = parts;
		_tmp6__length1 = parts_length1;
		_tmp7_ = _tmp6_[1];
		_tmp8_ = parts;
		_tmp8__length1 = parts_length1;
		_tmp9_ = _tmp8_[3];
		_tmp10_ = parts;
		_tmp10__length1 = parts_length1;
		_tmp11_ = _tmp10_[4];
		_tmp12_ = g_strdup_printf ("[%s%s] %s", _tmp7_, _tmp9_, _tmp11_);
		result = _tmp12_;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp13_ = g_strdup (msg);
	result = _tmp13_;
	return result;
}

/**
 * Displays a log message using libnotify.  Also displays on the console.
 *
 * @param msg the log message to display
 * @param icon the icon to display in the notification
 */
void
plank_logger_notification (const gchar* msg,
                           const gchar* icon)
{
	gchar* _tmp0_;
	g_return_if_fail (msg != NULL);
	g_return_if_fail (icon != NULL);
	_tmp0_ = plank_logger_format_message (msg);
	plank_logger_write (PLANK_LOG_LEVEL_NOTIFY, _tmp0_);
}

/**
 * Displays a verbose log message to the console.
 *
 * @param msg the log message to display
 */
void
plank_logger_verbose (const gchar* msg,
                      ...)
{
	va_list _tmp0_ = {0};
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (msg != NULL);
	va_start (_tmp0_, msg);
	_tmp1_ = g_strdup_vprintf (msg, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = plank_logger_format_message (_tmp2_);
	plank_logger_write (PLANK_LOG_LEVEL_VERBOSE, _tmp3_);
	_g_free0 (_tmp2_);
	va_end (_tmp0_);
}

static gchar*
plank_logger_get_time (void)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = g_strdup_printf ("%.2d:%.2d:%.2d.%.6d", g_date_time_get_hour (now), g_date_time_get_minute (now), g_date_time_get_second (now), g_date_time_get_microsecond (now));
	result = _tmp1_;
	_g_date_time_unref0 (now);
	return result;
}

static void
plank_logger_write (PlankLogLevel level,
                    gchar* msg)
{
	PlankLogLevel _tmp0_;
	PlankLogLevel _tmp1_;
	FILE* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FILE* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = plank_logger_get_DisplayLevel ();
	_tmp1_ = _tmp0_;
	if (level < _tmp1_) {
		_g_free0 (msg);
		return;
	}
	g_mutex_lock (&plank_logger_write_mutex);
	plank_logger_set_color_for_level (level);
	_tmp2_ = stdout;
	_tmp3_ = PLANK_LOG_LEVEL_TO_STRING[level];
	_tmp4_ = plank_logger_get_time ();
	_tmp5_ = _tmp4_;
	fprintf (_tmp2_, "[%s %s]", _tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	plank_logger_reset_color ();
	_tmp6_ = stdout;
	fprintf (_tmp6_, " %s\n", msg);
	g_mutex_unlock (&plank_logger_write_mutex);
	_g_free0 (msg);
}

static void
plank_logger_set_color_for_level (PlankLogLevel level)
{
	switch (level) {
		case PLANK_LOG_LEVEL_VERBOSE:
		{
			plank_logger_set_foreground (PLANK_CONSOLE_COLOR_CYAN);
			break;
		}
		case PLANK_LOG_LEVEL_DEBUG:
		{
			plank_logger_set_foreground (PLANK_CONSOLE_COLOR_GREEN);
			break;
		}
		case PLANK_LOG_LEVEL_INFO:
		{
			plank_logger_set_foreground (PLANK_CONSOLE_COLOR_BLUE);
			break;
		}
		case PLANK_LOG_LEVEL_NOTIFY:
		{
			plank_logger_set_foreground (PLANK_CONSOLE_COLOR_MAGENTA);
			break;
		}
		default:
		case PLANK_LOG_LEVEL_WARN:
		{
			plank_logger_set_foreground (PLANK_CONSOLE_COLOR_YELLOW);
			break;
		}
		case PLANK_LOG_LEVEL_CRITICAL:
		{
			plank_logger_set_foreground (PLANK_CONSOLE_COLOR_RED);
			break;
		}
		case PLANK_LOG_LEVEL_ERROR:
		{
			plank_logger_set_background (PLANK_CONSOLE_COLOR_RED);
			plank_logger_set_foreground (PLANK_CONSOLE_COLOR_WHITE);
			break;
		}
	}
}

static void
plank_logger_reset_color (void)
{
	FILE* _tmp0_;
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\x001b[0m");
}

static void
plank_logger_set_foreground (PlankConsoleColor color)
{
	plank_logger_set_color (color, TRUE);
}

static void
plank_logger_set_background (PlankConsoleColor color)
{
	plank_logger_set_color (color, FALSE);
}

static void
plank_logger_set_color (PlankConsoleColor color,
                        gboolean isForeground)
{
	PlankConsoleColor color_code = 0;
	FILE* _tmp0_;
	color_code = (color + 30) + 60;
	if (!isForeground) {
		color_code += 10;
	}
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\x001b[%dm", (gint) color_code);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
plank_logger_glib_log_func (const gchar* d,
                            GLogLevelFlags flags,
                            const gchar* msg)
{
	gchar* domain = NULL;
	gchar* message = NULL;
	gboolean _tmp2_ = FALSE;
	PlankLogLevel level = 0;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_if_fail (msg != NULL);
	if (d != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup_printf ("[%s] ", d);
		_g_free0 (domain);
		domain = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		_g_free0 (domain);
		domain = _tmp1_;
	}
	if (string_contains (msg, "\n")) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = string_contains (msg, "\r");
	}
	if (_tmp2_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = domain;
		_tmp4_ = string_replace (msg, "\n", "");
		_tmp5_ = _tmp4_;
		_tmp6_ = string_replace (_tmp5_, "\r", "");
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%s%s", _tmp3_, _tmp7_);
		_g_free0 (message);
		message = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
	} else {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = domain;
		_tmp10_ = g_strdup_printf ("%s%s", _tmp9_, msg);
		_g_free0 (message);
		message = _tmp10_;
	}
	flags = flags & G_LOG_LEVEL_MASK;
	switch (flags) {
		case G_LOG_LEVEL_ERROR:
		{
			level = PLANK_LOG_LEVEL_ERROR;
			break;
		}
		case G_LOG_LEVEL_CRITICAL:
		{
			level = PLANK_LOG_LEVEL_CRITICAL;
			break;
		}
		case G_LOG_LEVEL_INFO:
		case G_LOG_LEVEL_MESSAGE:
		{
			level = PLANK_LOG_LEVEL_INFO;
			break;
		}
		case G_LOG_LEVEL_DEBUG:
		{
			level = PLANK_LOG_LEVEL_DEBUG;
			break;
		}
		default:
		case G_LOG_LEVEL_WARNING:
		{
			level = PLANK_LOG_LEVEL_WARN;
			break;
		}
	}
	_tmp11_ = message;
	_tmp12_ = plank_logger_format_message (_tmp11_);
	plank_logger_write (level, _tmp12_);
	_g_free0 (message);
	_g_free0 (domain);
}

PlankLogLevel
plank_logger_get_DisplayLevel (void)
{
	PlankLogLevel result;
	result = plank_logger__DisplayLevel;
	return result;
}

void
plank_logger_set_DisplayLevel (PlankLogLevel value)
{
	plank_logger__DisplayLevel = value;
}

static void
plank_logger_class_init (PlankLoggerClass * klass,
                         gpointer klass_data)
{
	plank_logger_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_logger_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_logger_set_property;
	G_OBJECT_CLASS (klass)->finalize = plank_logger_finalize;
}

static void
plank_logger_instance_init (PlankLogger * self,
                            gpointer klass)
{
}

static void
plank_logger_finalize (GObject * obj)
{
	PlankLogger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_LOGGER, PlankLogger);
	G_OBJECT_CLASS (plank_logger_parent_class)->finalize (obj);
}

/**
 * A logging class to display all console messages in a nice colored format.
 */
static GType
plank_logger_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankLogger), 0, (GInstanceInitFunc) plank_logger_instance_init, NULL };
	GType plank_logger_type_id;
	plank_logger_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankLogger", &g_define_type_info, 0);
	return plank_logger_type_id;
}

GType
plank_logger_get_type (void)
{
	static volatile gsize plank_logger_type_id__once = 0;
	if (g_once_init_enter (&plank_logger_type_id__once)) {
		GType plank_logger_type_id;
		plank_logger_type_id = plank_logger_get_type_once ();
		g_once_init_leave (&plank_logger_type_id__once, plank_logger_type_id);
	}
	return plank_logger_type_id__once;
}

static void
_vala_plank_logger_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	PlankLogger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_LOGGER, PlankLogger);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_logger_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	PlankLogger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_LOGGER, PlankLogger);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

