/* ApplicationDockItemProvider.c generated by valac 0.56.17, the Vala compiler
 * generated from ApplicationDockItemProvider.vala, do not modify */

/**/
/*  Copyright (C) 2011-2013 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <gio/gio.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libbamf/libbamf.h>
#include "plank-internal.h"
#include <libwnck/libwnck.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_APPLICATION_DOCK_ITEM_PROVIDER_0_PROPERTY,
	PLANK_APPLICATION_DOCK_ITEM_PROVIDER_LAUNCHERS_DIR_PROPERTY,
	PLANK_APPLICATION_DOCK_ITEM_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* plank_application_dock_item_provider_properties[PLANK_APPLICATION_DOCK_ITEM_PROVIDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block10Data Block10Data;
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
enum  {
	PLANK_APPLICATION_DOCK_ITEM_PROVIDER_ITEM_WINDOW_ADDED_SIGNAL,
	PLANK_APPLICATION_DOCK_ITEM_PROVIDER_NUM_SIGNALS
};
static guint plank_application_dock_item_provider_signals[PLANK_APPLICATION_DOCK_ITEM_PROVIDER_NUM_SIGNALS] = {0};

struct _PlankApplicationDockItemProviderPrivate {
	GFile* _LaunchersDir;
	GFileMonitor* items_monitor;
	gboolean delay_items_monitor_handle;
	GeeArrayList* queued_files;
};

struct _Block10Data {
	int _ref_count_;
	PlankApplicationDockItemProvider* self;
	gchar* sender_name;
	GVariant* parameters;
};

static gint PlankApplicationDockItemProvider_private_offset;
static gpointer plank_application_dock_item_provider_parent_class = NULL;
static PlankUnityClientIface * plank_application_dock_item_provider_plank_unity_client_parent_iface = NULL;

static void _plank_application_dock_item_provider_app_opened_plank_matcher_application_opened (PlankMatcher* _sender,
                                                                                        BamfApplication* app,
                                                                                        gpointer self);
static void plank_application_dock_item_provider_handle_items_dir_changed (GFile* f,
                                                                    GFile* other,
                                                                    GFileMonitorEvent event,
                                                                    PlankApplicationDockItemProvider* self);
static void _plank_application_dock_item_provider_handle_items_dir_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                            GFile* file,
                                                                                            GFile* other_file,
                                                                                            GFileMonitorEvent event_type,
                                                                                            gpointer self);
VALA_EXTERN BamfApplication* plank_application_dock_item_get_App (PlankApplicationDockItem* self);
static GFile* plank_application_dock_item_provider_desktop_file_for_application_uri (const gchar* app_uri);
static gboolean plank_application_dock_item_provider_real_add_item_with_uri (PlankDockItemProvider* base,
                                                                      const gchar* uri,
                                                                      PlankDockItem* target);
static void plank_application_dock_item_provider_real_prepare (PlankDockContainer* base);
VALA_EXTERN void plank_application_dock_item_set_App (PlankApplicationDockItem* self,
                                          BamfApplication* value);
static gchar** plank_application_dock_item_provider_real_get_dockitem_filenames (PlankDockItemProvider* base,
                                                                          gint* result_length1);
static void plank_application_dock_item_provider_real_app_opened (PlankApplicationDockItemProvider* self,
                                                           BamfApplication* app);
static void plank_application_dock_item_provider_process_queued_files (PlankApplicationDockItemProvider* self);
static void plank_application_dock_item_provider_real_connect_element (PlankDockContainer* base,
                                                                PlankDockElement* element);
static void plank_application_dock_item_provider_handle_item_app_window_added (PlankApplicationDockItemProvider* self,
                                                                        PlankApplicationDockItem* item);
static void _plank_application_dock_item_provider_handle_item_app_window_added_plank_application_dock_item_app_window_added (PlankApplicationDockItem* _sender,
                                                                                                                      gpointer self);
static void plank_application_dock_item_provider_real_disconnect_element (PlankDockContainer* base,
                                                                   PlankDockElement* element);
static void plank_application_dock_item_provider_real_remove_launcher_entry (PlankUnityClient* base,
                                                                      const gchar* sender_name);
static void plank_application_dock_item_provider_real_update_launcher_entry (PlankUnityClient* base,
                                                                      const gchar* sender_name,
                                                                      GVariant* parameters,
                                                                      gboolean is_retry);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gboolean ___lambda39_ (Block10Data* _data10_);
static gboolean ____lambda39__gsource_func (gpointer self);
static GObject * plank_application_dock_item_provider_constructor (GType type,
                                                            guint n_construct_properties,
                                                            GObjectConstructParam * construct_properties);
static void plank_application_dock_item_provider_finalize (GObject * obj);
static GType plank_application_dock_item_provider_get_type_once (void);
static void _vala_plank_application_dock_item_provider_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_plank_application_dock_item_provider_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);

static inline gpointer
plank_application_dock_item_provider_get_instance_private (PlankApplicationDockItemProvider* self)
{
	return G_STRUCT_MEMBER_P (self, PlankApplicationDockItemProvider_private_offset);
}

static void
_plank_application_dock_item_provider_app_opened_plank_matcher_application_opened (PlankMatcher* _sender,
                                                                                   BamfApplication* app,
                                                                                   gpointer self)
{
	plank_application_dock_item_provider_app_opened ((PlankApplicationDockItemProvider*) self, app);
}

static void
_plank_application_dock_item_provider_handle_items_dir_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                       GFile* file,
                                                                                       GFile* other_file,
                                                                                       GFileMonitorEvent event_type,
                                                                                       gpointer self)
{
	plank_application_dock_item_provider_handle_items_dir_changed (file, other_file, event_type, (PlankApplicationDockItemProvider*) self);
}

/**
 * Creates a new container for dock items.
 *
 * @param launchers_dir the directory where to load/save .dockitems files from/to
 */
PlankApplicationDockItemProvider*
plank_application_dock_item_provider_construct (GType object_type,
                                                GFile* launchers_dir)
{
	PlankApplicationDockItemProvider * self = NULL;
	g_return_val_if_fail (launchers_dir != NULL, NULL);
	self = (PlankApplicationDockItemProvider*) g_object_new (object_type, "LaunchersDir", launchers_dir, NULL);
	return self;
}

PlankApplicationDockItemProvider*
plank_application_dock_item_provider_new (GFile* launchers_dir)
{
	return plank_application_dock_item_provider_construct (PLANK_TYPE_APPLICATION_DOCK_ITEM_PROVIDER, launchers_dir);
}

PlankApplicationDockItem*
plank_application_dock_item_provider_item_for_application (PlankApplicationDockItemProvider* self,
                                                           BamfApplication* app)
{
	gchar* app_desktop_file = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	PlankApplicationDockItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (app != NULL, NULL);
	_tmp0_ = bamf_application_get_desktop_file (app);
	_tmp1_ = g_strdup (_tmp0_);
	app_desktop_file = _tmp1_;
	_tmp3_ = app_desktop_file;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = app_desktop_file;
		_tmp2_ = g_str_has_prefix (_tmp4_, "/");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		{
			gchar* _tmp5_ = NULL;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp6_ = app_desktop_file;
			_tmp7_ = g_filename_to_uri (_tmp6_, NULL, &_inner_error0_);
			_tmp5_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					goto __catch0_g_convert_error;
				}
				_g_free0 (app_desktop_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp8_ = _tmp5_;
			_tmp5_ = NULL;
			_g_free0 (app_desktop_file);
			app_desktop_file = _tmp8_;
			_g_free0 (_tmp5_);
		}
		goto __finally0;
		__catch0_g_convert_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("ApplicationDockItemProvider.vala:82: %s", _tmp10_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (app_desktop_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp11_;
		gint _item_size = 0;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _item_index = 0;
		_tmp11_ = ((PlankDockContainer*) self)->internal_elements;
		_item_list = _tmp11_;
		_tmp12_ = _item_list;
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_item_size = _tmp14_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			PlankDockElement* item = NULL;
			GeeArrayList* _tmp17_;
			gpointer _tmp18_;
			PlankApplicationDockItem* appitem = NULL;
			PlankDockElement* _tmp19_;
			PlankApplicationDockItem* _tmp20_;
			BamfApplication* item_app = NULL;
			PlankApplicationDockItem* _tmp21_;
			BamfApplication* _tmp22_;
			BamfApplication* _tmp23_;
			gboolean _tmp24_ = FALSE;
			BamfApplication* _tmp25_;
			const gchar* launcher = NULL;
			PlankApplicationDockItem* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gboolean _tmp31_ = FALSE;
			gboolean _tmp32_ = FALSE;
			const gchar* _tmp33_;
			_item_index = _item_index + 1;
			_tmp15_ = _item_index;
			_tmp16_ = _item_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _item_list;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _item_index);
			item = (PlankDockElement*) _tmp18_;
			_tmp19_ = item;
			appitem = PLANK_IS_APPLICATION_DOCK_ITEM (_tmp19_) ? ((PlankApplicationDockItem*) _tmp19_) : NULL;
			_tmp20_ = appitem;
			if (_tmp20_ == NULL) {
				_g_object_unref0 (item);
				continue;
			}
			_tmp21_ = appitem;
			_tmp22_ = plank_application_dock_item_get_App (_tmp21_);
			_tmp23_ = _tmp22_;
			item_app = _tmp23_;
			_tmp25_ = item_app;
			if (_tmp25_ != NULL) {
				BamfApplication* _tmp26_;
				_tmp26_ = item_app;
				_tmp24_ = _tmp26_ == app;
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				PlankApplicationDockItem* _tmp27_;
				_tmp27_ = appitem;
				result = _tmp27_;
				_g_object_unref0 (item);
				_g_free0 (app_desktop_file);
				return result;
			}
			_tmp28_ = appitem;
			_tmp29_ = plank_dock_item_get_Launcher ((PlankDockItem*) _tmp28_);
			_tmp30_ = _tmp29_;
			launcher = _tmp30_;
			_tmp33_ = launcher;
			if (g_strcmp0 (_tmp33_, "") != 0) {
				const gchar* _tmp34_;
				_tmp34_ = app_desktop_file;
				_tmp32_ = _tmp34_ != NULL;
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				_tmp35_ = launcher;
				_tmp36_ = app_desktop_file;
				_tmp31_ = g_strcmp0 (_tmp35_, _tmp36_) == 0;
			} else {
				_tmp31_ = FALSE;
			}
			if (_tmp31_) {
				PlankApplicationDockItem* _tmp37_;
				_tmp37_ = appitem;
				result = _tmp37_;
				_g_object_unref0 (item);
				_g_free0 (app_desktop_file);
				return result;
			}
			_g_object_unref0 (item);
		}
	}
	result = NULL;
	_g_free0 (app_desktop_file);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static GFile*
plank_application_dock_item_provider_desktop_file_for_application_uri (const gchar* app_uri)
{
	GFile* result;
	g_return_val_if_fail (app_uri != NULL, NULL);
	{
		GeeArrayList* _folder_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _folder_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _folder_index = 0;
		_tmp0_ = plank_paths_get_DataDirFolders ();
		_tmp1_ = _tmp0_;
		_folder_list = _tmp1_;
		_tmp2_ = _folder_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_folder_size = _tmp4_;
		_folder_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			GFile* folder = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			GFile* applications_folder = NULL;
			GFile* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			GFile* desktop_file = NULL;
			GFile* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			GFile* _tmp15_;
			GFile* _tmp16_;
			GFile* _tmp17_;
			_folder_index = _folder_index + 1;
			_tmp5_ = _folder_index;
			_tmp6_ = _folder_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _folder_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _folder_index);
			folder = (GFile*) _tmp8_;
			_tmp9_ = folder;
			_tmp10_ = g_file_get_child (_tmp9_, "applications");
			applications_folder = _tmp10_;
			_tmp11_ = applications_folder;
			if (!g_file_query_exists (_tmp11_, NULL)) {
				_g_object_unref0 (applications_folder);
				_g_object_unref0 (folder);
				continue;
			}
			_tmp12_ = applications_folder;
			_tmp13_ = string_replace (app_uri, "application://", "");
			_tmp14_ = _tmp13_;
			_tmp15_ = g_file_get_child (_tmp12_, _tmp14_);
			_tmp16_ = _tmp15_;
			_g_free0 (_tmp14_);
			desktop_file = _tmp16_;
			_tmp17_ = desktop_file;
			if (!g_file_query_exists (_tmp17_, NULL)) {
				_g_object_unref0 (desktop_file);
				_g_object_unref0 (applications_folder);
				_g_object_unref0 (folder);
				continue;
			}
			result = desktop_file;
			_g_object_unref0 (applications_folder);
			_g_object_unref0 (folder);
			return result;
		}
	}
	g_debug ("ApplicationDockItemProvider.vala:116: Matching application for '%s' no" \
"t found or not installed!", app_uri);
	result = NULL;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_application_dock_item_provider_real_add_item_with_uri (PlankDockItemProvider* base,
                                                             const gchar* uri,
                                                             PlankDockItem* target)
{
	PlankApplicationDockItemProvider * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GFile* dockitem_file = NULL;
	PlankItemFactory* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	PlankDockElement* element = NULL;
	PlankItemFactory* _tmp11_;
	GFile* _tmp12_;
	PlankDockElement* _tmp13_;
	PlankDockItem* item = NULL;
	PlankDockElement* _tmp14_;
	PlankDockItem* _tmp15_;
	PlankDockItem* _tmp16_;
	gboolean result;
	self = (PlankApplicationDockItemProvider*) base;
	g_return_val_if_fail (uri != NULL, FALSE);
	if (uri == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (uri, "") == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (target != NULL) {
		PlankPlaceholderDockItem* _tmp3_;
		_tmp3_ = plank_dock_container_placeholder_item;
		_tmp2_ = target != G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, PLANK_TYPE_DOCK_ITEM, PlankDockItem);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GeeArrayList* _tmp4_;
		_tmp4_ = ((PlankDockContainer*) self)->internal_elements;
		_tmp1_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp4_, (PlankDockElement*) target);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = plank_dock_element_get_Text ((PlankDockElement*) target);
		_tmp6_ = _tmp5_;
		g_critical ("ApplicationDockItemProvider.vala:130: Item '%s' does not exist in this" \
" DockItemProvider.", _tmp6_);
		result = FALSE;
		return result;
	}
	if (plank_dock_item_provider_item_exists_for_uri ((PlankDockItemProvider*) self, uri)) {
		g_warning ("ApplicationDockItemProvider.vala:135: Item for '%s' already exists in " \
"this DockItemProvider.", uri);
		result = FALSE;
		return result;
	}
	plank_application_dock_item_provider_delay_items_monitor (self);
	_tmp7_ = plank_factory_item_factory;
	_tmp8_ = self->priv->_LaunchersDir;
	_tmp9_ = plank_item_factory_make_dock_item (_tmp7_, uri, _tmp8_);
	dockitem_file = _tmp9_;
	_tmp10_ = dockitem_file;
	if (_tmp10_ == NULL) {
		plank_application_dock_item_provider_resume_items_monitor (self);
		result = FALSE;
		_g_object_unref0 (dockitem_file);
		return result;
	}
	_tmp11_ = plank_factory_item_factory;
	_tmp12_ = dockitem_file;
	_tmp13_ = plank_item_factory_make_element (_tmp11_, _tmp12_);
	element = _tmp13_;
	_tmp14_ = element;
	item = PLANK_IS_DOCK_ITEM (_tmp14_) ? ((PlankDockItem*) _tmp14_) : NULL;
	_tmp15_ = item;
	if (_tmp15_ == NULL) {
		plank_application_dock_item_provider_resume_items_monitor (self);
		result = FALSE;
		_g_object_unref0 (element);
		_g_object_unref0 (dockitem_file);
		return result;
	}
	_tmp16_ = item;
	plank_dock_container_add ((PlankDockContainer*) self, (PlankDockElement*) _tmp16_, (PlankDockElement*) target);
	plank_application_dock_item_provider_resume_items_monitor (self);
	result = TRUE;
	_g_object_unref0 (element);
	_g_object_unref0 (dockitem_file);
	return result;
}

/**
 * {@inheritDoc}
 */
static void
plank_application_dock_item_provider_real_prepare (PlankDockContainer* base)
{
	PlankApplicationDockItemProvider * self;
	self = (PlankApplicationDockItemProvider*) base;
	{
		GeeArrayList* _app_list = NULL;
		PlankMatcher* _tmp0_;
		PlankMatcher* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _app_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _app_index = 0;
		_tmp0_ = plank_matcher_get_default ();
		_tmp1_ = _tmp0_;
		_tmp2_ = plank_matcher_active_launchers (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_app_list = _tmp3_;
		_tmp4_ = _app_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_app_size = _tmp6_;
		_app_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BamfApplication* app = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			PlankApplicationDockItem* found = NULL;
			BamfApplication* _tmp11_;
			PlankApplicationDockItem* _tmp12_;
			PlankApplicationDockItem* _tmp13_;
			_app_index = _app_index + 1;
			_tmp7_ = _app_index;
			_tmp8_ = _app_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _app_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _app_index);
			app = (BamfApplication*) _tmp10_;
			_tmp11_ = app;
			_tmp12_ = plank_application_dock_item_provider_item_for_application (self, _tmp11_);
			found = _tmp12_;
			_tmp13_ = found;
			if (_tmp13_ != NULL) {
				PlankApplicationDockItem* _tmp14_;
				BamfApplication* _tmp15_;
				_tmp14_ = found;
				_tmp15_ = app;
				plank_application_dock_item_set_App (_tmp14_, _tmp15_);
			}
			_g_object_unref0 (app);
		}
		_g_object_unref0 (_app_list);
	}
}

/**
 * {@inheritDoc}
 */
static gchar**
plank_application_dock_item_provider_real_get_dockitem_filenames (PlankDockItemProvider* base,
                                                                  gint* result_length1)
{
	PlankApplicationDockItemProvider * self;
	GeeArrayList* item_list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp22_;
	gint _tmp23_ = 0;
	gpointer* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar** result;
	self = (PlankApplicationDockItemProvider*) base;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	item_list = _tmp0_;
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp1_;
		gint _element_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _element_index = 0;
		_tmp1_ = ((PlankDockContainer*) self)->internal_elements;
		_element_list = _tmp1_;
		_tmp2_ = _element_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_element_size = _tmp4_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			PlankDockElement* element = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			PlankDockItem* item = NULL;
			PlankDockElement* _tmp9_;
			gboolean _tmp10_ = FALSE;
			PlankDockItem* _tmp11_;
			gchar* dock_item_filename = NULL;
			PlankDockItem* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_element_index = _element_index + 1;
			_tmp5_ = _element_index;
			_tmp6_ = _element_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _element_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _element_index);
			element = (PlankDockElement*) _tmp8_;
			_tmp9_ = element;
			item = PLANK_IS_DOCK_ITEM (_tmp9_) ? ((PlankDockItem*) _tmp9_) : NULL;
			_tmp11_ = item;
			if (_tmp11_ == NULL) {
				_tmp10_ = TRUE;
			} else {
				PlankDockItem* _tmp12_;
				_tmp12_ = item;
				_tmp10_ = PLANK_IS_TRANSIENT_DOCK_ITEM (_tmp12_);
			}
			if (_tmp10_) {
				_g_object_unref0 (element);
				continue;
			}
			_tmp13_ = item;
			_tmp14_ = plank_dock_item_get_DockItemFilename (_tmp13_);
			_tmp15_ = _tmp14_;
			dock_item_filename = _tmp15_;
			_tmp16_ = dock_item_filename;
			_tmp17_ = strlen (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ > 0) {
				GeeArrayList* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp19_ = item_list;
				_tmp20_ = dock_item_filename;
				dock_item_filename = NULL;
				_tmp21_ = _tmp20_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp21_);
				_g_free0 (_tmp21_);
			}
			_g_free0 (dock_item_filename);
			_g_object_unref0 (element);
		}
	}
	_tmp22_ = item_list;
	_tmp24_ = gee_collection_to_array ((GeeCollection*) _tmp22_, &_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp25__length1 = _tmp23_;
	if (result_length1) {
		*result_length1 = _tmp25__length1;
	}
	result = _tmp25_;
	_g_object_unref0 (item_list);
	return result;
}

static void
plank_application_dock_item_provider_real_app_opened (PlankApplicationDockItemProvider* self,
                                                      BamfApplication* app)
{
	WnckScreen* _tmp0_;
	PlankApplicationDockItem* found = NULL;
	PlankApplicationDockItem* _tmp1_;
	PlankApplicationDockItem* _tmp2_;
	g_return_if_fail (app != NULL);
	_tmp0_ = wnck_screen_get_default ();
	wnck_screen_force_update (_tmp0_);
	_tmp1_ = plank_application_dock_item_provider_item_for_application (self, app);
	found = _tmp1_;
	_tmp2_ = found;
	if (_tmp2_ != NULL) {
		PlankApplicationDockItem* _tmp3_;
		_tmp3_ = found;
		plank_application_dock_item_set_App (_tmp3_, app);
	}
}

void
plank_application_dock_item_provider_app_opened (PlankApplicationDockItemProvider* self,
                                                 BamfApplication* app)
{
	PlankApplicationDockItemProviderClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_APPLICATION_DOCK_ITEM_PROVIDER_GET_CLASS (self);
	if (_klass_->app_opened) {
		_klass_->app_opened (self, app);
	}
}

void
plank_application_dock_item_provider_delay_items_monitor (PlankApplicationDockItemProvider* self)
{
	g_return_if_fail (self != NULL);
	self->priv->delay_items_monitor_handle = TRUE;
}

void
plank_application_dock_item_provider_resume_items_monitor (PlankApplicationDockItemProvider* self)
{
	g_return_if_fail (self != NULL);
	self->priv->delay_items_monitor_handle = FALSE;
	plank_application_dock_item_provider_process_queued_files (self);
}

static void
plank_application_dock_item_provider_process_queued_files (PlankApplicationDockItemProvider* self)
{
	GeeArrayList* _tmp65_;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _file_list = NULL;
		GeeArrayList* _tmp0_;
		gint _file_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _file_index = 0;
		_tmp0_ = self->priv->queued_files;
		_file_list = _tmp0_;
		_tmp1_ = _file_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_file_size = _tmp3_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GFile* file = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gchar* basename = NULL;
			GFile* _tmp8_;
			gchar* _tmp9_;
			gboolean skip = FALSE;
			const gchar* _tmp26_;
			PlankDockElement* element = NULL;
			PlankItemFactory* _tmp27_;
			GFile* _tmp28_;
			PlankDockElement* _tmp29_;
			PlankDockItem* item = NULL;
			PlankDockElement* _tmp30_;
			PlankDockItem* _tmp31_;
			PlankDockItem* dupe = NULL;
			PlankDockItem* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			PlankDockItem* _tmp35_;
			PlankDockItem* _tmp36_;
			_file_index = _file_index + 1;
			_tmp4_ = _file_index;
			_tmp5_ = _file_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _file_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _file_index);
			file = (GFile*) _tmp7_;
			_tmp8_ = file;
			_tmp9_ = g_file_get_basename (_tmp8_);
			basename = _tmp9_;
			skip = FALSE;
			{
				GeeArrayList* _element_list = NULL;
				GeeArrayList* _tmp10_;
				gint _element_size = 0;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _element_index = 0;
				_tmp10_ = ((PlankDockContainer*) self)->internal_elements;
				_element_list = _tmp10_;
				_tmp11_ = _element_list;
				_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				_element_size = _tmp13_;
				_element_index = -1;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					PlankDockElement* element = NULL;
					GeeArrayList* _tmp16_;
					gpointer _tmp17_;
					PlankDockItem* item = NULL;
					PlankDockElement* _tmp18_;
					gboolean _tmp19_ = FALSE;
					PlankDockItem* _tmp20_;
					_element_index = _element_index + 1;
					_tmp14_ = _element_index;
					_tmp15_ = _element_size;
					if (!(_tmp14_ < _tmp15_)) {
						break;
					}
					_tmp16_ = _element_list;
					_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _element_index);
					element = (PlankDockElement*) _tmp17_;
					_tmp18_ = element;
					item = PLANK_IS_DOCK_ITEM (_tmp18_) ? ((PlankDockItem*) _tmp18_) : NULL;
					_tmp20_ = item;
					if (_tmp20_ != NULL) {
						const gchar* _tmp21_;
						PlankDockItem* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						_tmp21_ = basename;
						_tmp22_ = item;
						_tmp23_ = plank_dock_item_get_DockItemFilename (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = _tmp24_;
						_tmp19_ = g_strcmp0 (_tmp21_, _tmp25_) == 0;
						_g_free0 (_tmp25_);
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						skip = TRUE;
						_g_object_unref0 (element);
						break;
					}
					_g_object_unref0 (element);
				}
			}
			if (skip) {
				_g_free0 (basename);
				_g_object_unref0 (file);
				continue;
			}
			_tmp26_ = basename;
			plank_logger_verbose ("ApplicationDockItemProvider.process_queued_files ('%s')", _tmp26_, NULL);
			_tmp27_ = plank_factory_item_factory;
			_tmp28_ = file;
			_tmp29_ = plank_item_factory_make_element (_tmp27_, _tmp28_);
			element = _tmp29_;
			_tmp30_ = element;
			item = PLANK_IS_DOCK_ITEM (_tmp30_) ? ((PlankDockItem*) _tmp30_) : NULL;
			_tmp31_ = item;
			if (_tmp31_ == NULL) {
				_g_object_unref0 (element);
				_g_free0 (basename);
				_g_object_unref0 (file);
				continue;
			}
			_tmp32_ = item;
			_tmp33_ = plank_dock_item_get_Launcher (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = plank_dock_item_provider_item_for_uri ((PlankDockItemProvider*) self, _tmp34_);
			dupe = _tmp35_;
			_tmp36_ = dupe;
			if (_tmp36_ != NULL) {
				PlankDockItem* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				GFile* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				PlankDockItem* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				PlankDockItem* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				PlankDockItem* _tmp51_;
				_tmp37_ = item;
				_tmp38_ = plank_dock_item_get_Launcher (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = file;
				_tmp41_ = g_file_get_path (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = dupe;
				_tmp44_ = plank_dock_item_get_DockItemFilename (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = _tmp45_;
				_tmp47_ = item;
				_tmp48_ = plank_dock_item_get_DockItemFilename (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = _tmp49_;
				g_warning ("ApplicationDockItemProvider.vala:241: The launcher '%s' in dock item '" \
"%s' is already managed by dock item '%s'. Removing '%s'.", _tmp39_, _tmp42_, _tmp46_, _tmp50_);
				_g_free0 (_tmp50_);
				_g_free0 (_tmp46_);
				_g_free0 (_tmp42_);
				_tmp51_ = item;
				plank_dock_item_delete (_tmp51_);
			} else {
				PlankDockItem* _tmp52_;
				_tmp52_ = item;
				if (!plank_dock_item_is_valid (_tmp52_)) {
					PlankDockItem* _tmp53_;
					const gchar* _tmp54_;
					const gchar* _tmp55_;
					GFile* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					PlankDockItem* _tmp59_;
					gchar* _tmp60_;
					gchar* _tmp61_;
					gchar* _tmp62_;
					PlankDockItem* _tmp63_;
					_tmp53_ = item;
					_tmp54_ = plank_dock_item_get_Launcher (_tmp53_);
					_tmp55_ = _tmp54_;
					_tmp56_ = file;
					_tmp57_ = g_file_get_path (_tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = item;
					_tmp60_ = plank_dock_item_get_DockItemFilename (_tmp59_);
					_tmp61_ = _tmp60_;
					_tmp62_ = _tmp61_;
					g_warning ("ApplicationDockItemProvider.vala:245: The launcher '%s' in dock item '" \
"%s' does not exist. Removing '%s'.", _tmp55_, _tmp58_, _tmp62_);
					_g_free0 (_tmp62_);
					_g_free0 (_tmp58_);
					_tmp63_ = item;
					plank_dock_item_delete (_tmp63_);
				} else {
					PlankDockItem* _tmp64_;
					_tmp64_ = item;
					plank_dock_container_add ((PlankDockContainer*) self, (PlankDockElement*) _tmp64_, NULL);
				}
			}
			_g_object_unref0 (element);
			_g_free0 (basename);
			_g_object_unref0 (file);
		}
	}
	_tmp65_ = self->priv->queued_files;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp65_);
}

static void
plank_application_dock_item_provider_handle_items_dir_changed (GFile* f,
                                                               GFile* other,
                                                               GFileMonitorEvent event,
                                                               PlankApplicationDockItemProvider* self)
{
	gchar* _tmp17_;
	gchar* _tmp18_;
	GeeArrayList* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	if (event != G_FILE_MONITOR_EVENT_CREATED) {
		return;
	}
	if (!plank_file_is_dockitem (f)) {
		return;
	}
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp0_;
		gint _element_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _element_index = 0;
		_tmp0_ = ((PlankDockContainer*) self)->internal_elements;
		_element_list = _tmp0_;
		_tmp1_ = _element_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_element_size = _tmp3_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			PlankDockElement* element = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			PlankDockItem* item = NULL;
			PlankDockElement* _tmp8_;
			gboolean _tmp9_ = FALSE;
			PlankDockItem* _tmp10_;
			_element_index = _element_index + 1;
			_tmp4_ = _element_index;
			_tmp5_ = _element_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _element_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _element_index);
			element = (PlankDockElement*) _tmp7_;
			_tmp8_ = element;
			item = PLANK_IS_DOCK_ITEM (_tmp8_) ? ((PlankDockItem*) _tmp8_) : NULL;
			_tmp10_ = item;
			if (_tmp10_ != NULL) {
				gchar* _tmp11_;
				gchar* _tmp12_;
				PlankDockItem* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp11_ = g_file_get_basename (f);
				_tmp12_ = _tmp11_;
				_tmp13_ = item;
				_tmp14_ = plank_dock_item_get_DockItemFilename (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = _tmp15_;
				_tmp9_ = g_strcmp0 (_tmp12_, _tmp16_) == 0;
				_g_free0 (_tmp16_);
				_g_free0 (_tmp12_);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				_g_object_unref0 (element);
				return;
			}
			_g_object_unref0 (element);
		}
	}
	_tmp17_ = g_file_get_path (f);
	_tmp18_ = _tmp17_;
	plank_logger_verbose ("ApplicationDockItemProvider.handle_items_dir_changed (processing '%s')", _tmp18_, NULL);
	_g_free0 (_tmp18_);
	_tmp19_ = self->priv->queued_files;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, f);
	if (!self->priv->delay_items_monitor_handle) {
		plank_application_dock_item_provider_process_queued_files (self);
	}
}

static void
_plank_application_dock_item_provider_handle_item_app_window_added_plank_application_dock_item_app_window_added (PlankApplicationDockItem* _sender,
                                                                                                                 gpointer self)
{
	plank_application_dock_item_provider_handle_item_app_window_added ((PlankApplicationDockItemProvider*) self, _sender);
}

static void
plank_application_dock_item_provider_real_connect_element (PlankDockContainer* base,
                                                           PlankDockElement* element)
{
	PlankApplicationDockItemProvider * self;
	PlankApplicationDockItem* appitem = NULL;
	PlankApplicationDockItem* _tmp0_;
	self = (PlankApplicationDockItemProvider*) base;
	g_return_if_fail (element != NULL);
	PLANK_DOCK_CONTAINER_CLASS (plank_application_dock_item_provider_parent_class)->connect_element ((PlankDockContainer*) G_TYPE_CHECK_INSTANCE_CAST (self, PLANK_TYPE_DOCK_ITEM_PROVIDER, PlankDockItemProvider), element);
	appitem = PLANK_IS_APPLICATION_DOCK_ITEM (element) ? ((PlankApplicationDockItem*) element) : NULL;
	_tmp0_ = appitem;
	if (_tmp0_ != NULL) {
		PlankApplicationDockItem* _tmp1_;
		_tmp1_ = appitem;
		g_signal_connect_object (_tmp1_, "app-window-added", (GCallback) _plank_application_dock_item_provider_handle_item_app_window_added_plank_application_dock_item_app_window_added, self, 0);
	}
}

static void
plank_application_dock_item_provider_real_disconnect_element (PlankDockContainer* base,
                                                              PlankDockElement* element)
{
	PlankApplicationDockItemProvider * self;
	PlankApplicationDockItem* appitem = NULL;
	PlankApplicationDockItem* _tmp0_;
	self = (PlankApplicationDockItemProvider*) base;
	g_return_if_fail (element != NULL);
	PLANK_DOCK_CONTAINER_CLASS (plank_application_dock_item_provider_parent_class)->disconnect_element ((PlankDockContainer*) G_TYPE_CHECK_INSTANCE_CAST (self, PLANK_TYPE_DOCK_ITEM_PROVIDER, PlankDockItemProvider), element);
	appitem = PLANK_IS_APPLICATION_DOCK_ITEM (element) ? ((PlankApplicationDockItem*) element) : NULL;
	_tmp0_ = appitem;
	if (_tmp0_ != NULL) {
		PlankApplicationDockItem* _tmp1_;
		guint _tmp2_;
		_tmp1_ = appitem;
		g_signal_parse_name ("app-window-added", PLANK_TYPE_APPLICATION_DOCK_ITEM, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _plank_application_dock_item_provider_handle_item_app_window_added_plank_application_dock_item_app_window_added, self);
	}
}

static void
plank_application_dock_item_provider_handle_item_app_window_added (PlankApplicationDockItemProvider* self,
                                                                   PlankApplicationDockItem* item)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_signal_emit (self, plank_application_dock_item_provider_signals[PLANK_APPLICATION_DOCK_ITEM_PROVIDER_ITEM_WINDOW_ADDED_SIGNAL], 0, item);
}

static void
plank_application_dock_item_provider_real_remove_launcher_entry (PlankUnityClient* base,
                                                                 const gchar* sender_name)
{
	PlankApplicationDockItemProvider * self;
	self = (PlankApplicationDockItemProvider*) base;
	g_return_if_fail (sender_name != NULL);
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp0_;
		gint _item_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _item_index = 0;
		_tmp0_ = ((PlankDockContainer*) self)->internal_elements;
		_item_list = _tmp0_;
		_tmp1_ = _item_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_item_size = _tmp3_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			PlankDockElement* item = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			PlankApplicationDockItem* app_item = NULL;
			PlankDockElement* _tmp8_;
			PlankApplicationDockItem* _tmp9_;
			PlankApplicationDockItem* _tmp10_;
			const gchar* _tmp11_;
			PlankApplicationDockItem* _tmp12_;
			PlankTransientDockItem* transient_item = NULL;
			PlankDockElement* _tmp13_;
			gboolean _tmp14_ = FALSE;
			PlankTransientDockItem* _tmp15_;
			_item_index = _item_index + 1;
			_tmp4_ = _item_index;
			_tmp5_ = _item_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _item_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _item_index);
			item = (PlankDockElement*) _tmp7_;
			_tmp8_ = item;
			app_item = PLANK_IS_APPLICATION_DOCK_ITEM (_tmp8_) ? ((PlankApplicationDockItem*) _tmp8_) : NULL;
			_tmp9_ = app_item;
			if (_tmp9_ == NULL) {
				_g_object_unref0 (item);
				continue;
			}
			_tmp10_ = app_item;
			_tmp11_ = plank_application_dock_item_get_unity_dbusname (_tmp10_);
			if (g_strcmp0 (_tmp11_, sender_name) != 0) {
				_g_object_unref0 (item);
				continue;
			}
			_tmp12_ = app_item;
			plank_application_dock_item_unity_reset (_tmp12_);
			_tmp13_ = item;
			transient_item = PLANK_IS_TRANSIENT_DOCK_ITEM (_tmp13_) ? ((PlankTransientDockItem*) _tmp13_) : NULL;
			_tmp15_ = transient_item;
			if (_tmp15_ != NULL) {
				PlankTransientDockItem* _tmp16_;
				BamfApplication* _tmp17_;
				BamfApplication* _tmp18_;
				_tmp16_ = transient_item;
				_tmp17_ = plank_application_dock_item_get_App ((PlankApplicationDockItem*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp14_ = _tmp18_ == NULL;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				PlankTransientDockItem* _tmp19_;
				_tmp19_ = transient_item;
				plank_dock_container_remove ((PlankDockContainer*) self, (PlankDockElement*) _tmp19_);
			}
			_g_object_unref0 (item);
			break;
		}
	}
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		PlankApplicationDockItemProvider* self;
		self = _data10_->self;
		_g_free0 (_data10_->sender_name);
		_g_variant_unref0 (_data10_->parameters);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
___lambda39_ (Block10Data* _data10_)
{
	PlankApplicationDockItemProvider* self;
	gboolean result;
	self = _data10_->self;
	plank_unity_client_update_launcher_entry ((PlankUnityClient*) self, _data10_->sender_name, _data10_->parameters, TRUE);
	result = FALSE;
	return result;
}

static gboolean
____lambda39__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda39_ (self);
	return result;
}

static void
plank_application_dock_item_provider_real_update_launcher_entry (PlankUnityClient* base,
                                                                 const gchar* sender_name,
                                                                 GVariant* parameters,
                                                                 gboolean is_retry)
{
	PlankApplicationDockItemProvider * self;
	Block10Data* _data10_;
	gchar* _tmp0_;
	GVariant* _tmp1_;
	gchar* app_uri = NULL;
	GVariantIter* prop_iter = NULL;
	gchar* _tmp2_ = NULL;
	GVariantIter* _tmp3_ = NULL;
	const gchar* _tmp4_;
	PlankApplicationDockItem* current_item = NULL;
	PlankApplicationDockItem* alternate_item = NULL;
	PlankApplicationDockItem* _tmp24_;
	PlankApplicationDockItem* _tmp27_;
	PlankDefaultApplicationDockItemProvider* provider = NULL;
	gboolean _tmp39_ = FALSE;
	PlankDefaultApplicationDockItemProvider* _tmp40_;
	self = (PlankApplicationDockItemProvider*) base;
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (parameters != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = g_strdup (sender_name);
	_g_free0 (_data10_->sender_name);
	_data10_->sender_name = _tmp0_;
	_tmp1_ = _g_variant_ref0 (parameters);
	_g_variant_unref0 (_data10_->parameters);
	_data10_->parameters = _tmp1_;
	g_variant_get (_data10_->parameters, "(sa{sv})", &_tmp2_, &_tmp3_, NULL);
	_g_free0 (app_uri);
	app_uri = _tmp2_;
	_g_variant_iter_free0 (prop_iter);
	prop_iter = _tmp3_;
	_tmp4_ = app_uri;
	plank_logger_verbose ("Unity.handle_update_request (processing update for %s)", _tmp4_, NULL);
	current_item = NULL;
	alternate_item = NULL;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp5_;
		gint _item_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _item_index = 0;
		_tmp5_ = ((PlankDockContainer*) self)->internal_elements;
		_item_list = _tmp5_;
		_tmp6_ = _item_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_item_size = _tmp8_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			PlankDockElement* item = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			PlankApplicationDockItem* app_item = NULL;
			PlankDockElement* _tmp13_;
			PlankApplicationDockItem* _tmp14_;
			PlankApplicationDockItem* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			PlankApplicationDockItem* _tmp20_;
			const gchar* _tmp21_;
			_item_index = _item_index + 1;
			_tmp9_ = _item_index;
			_tmp10_ = _item_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _item_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _item_index);
			item = (PlankDockElement*) _tmp12_;
			_tmp13_ = item;
			app_item = PLANK_IS_APPLICATION_DOCK_ITEM (_tmp13_) ? ((PlankApplicationDockItem*) _tmp13_) : NULL;
			_tmp14_ = app_item;
			if (_tmp14_ == NULL) {
				_g_object_unref0 (item);
				continue;
			}
			_tmp15_ = app_item;
			_tmp16_ = plank_application_dock_item_get_unity_application_uri (_tmp15_);
			_tmp17_ = app_uri;
			if (g_strcmp0 (_tmp16_, _tmp17_) == 0) {
				PlankApplicationDockItem* _tmp18_;
				PlankApplicationDockItem* _tmp19_;
				_tmp18_ = app_item;
				_tmp19_ = _g_object_ref0 (_tmp18_);
				_g_object_unref0 (current_item);
				current_item = _tmp19_;
				_g_object_unref0 (item);
				break;
			}
			_tmp20_ = app_item;
			_tmp21_ = plank_application_dock_item_get_unity_dbusname (_tmp20_);
			if (g_strcmp0 (_tmp21_, _data10_->sender_name) == 0) {
				PlankApplicationDockItem* _tmp22_;
				PlankApplicationDockItem* _tmp23_;
				_tmp22_ = app_item;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				_g_object_unref0 (alternate_item);
				alternate_item = _tmp23_;
			}
			_g_object_unref0 (item);
		}
	}
	_tmp24_ = current_item;
	if (_tmp24_ == NULL) {
		PlankApplicationDockItem* _tmp25_;
		PlankApplicationDockItem* _tmp26_;
		_tmp25_ = alternate_item;
		_tmp26_ = _g_object_ref0 (_tmp25_);
		_g_object_unref0 (current_item);
		current_item = _tmp26_;
	}
	_tmp27_ = current_item;
	if (_tmp27_ != NULL) {
		PlankApplicationDockItem* _tmp28_;
		GVariantIter* _tmp29_;
		PlankTransientDockItem* transient_item = NULL;
		PlankApplicationDockItem* _tmp30_;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		PlankTransientDockItem* _tmp33_;
		_tmp28_ = current_item;
		_tmp29_ = prop_iter;
		plank_application_dock_item_unity_update (_tmp28_, _data10_->sender_name, _tmp29_);
		_tmp30_ = current_item;
		transient_item = PLANK_IS_TRANSIENT_DOCK_ITEM (_tmp30_) ? ((PlankTransientDockItem*) _tmp30_) : NULL;
		_tmp33_ = transient_item;
		if (_tmp33_ != NULL) {
			PlankTransientDockItem* _tmp34_;
			BamfApplication* _tmp35_;
			BamfApplication* _tmp36_;
			_tmp34_ = transient_item;
			_tmp35_ = plank_application_dock_item_get_App ((PlankApplicationDockItem*) _tmp34_);
			_tmp36_ = _tmp35_;
			_tmp32_ = _tmp36_ == NULL;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			PlankTransientDockItem* _tmp37_;
			_tmp37_ = transient_item;
			_tmp31_ = !plank_application_dock_item_has_unity_info ((PlankApplicationDockItem*) _tmp37_);
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			PlankTransientDockItem* _tmp38_;
			_tmp38_ = transient_item;
			plank_dock_container_remove ((PlankDockContainer*) self, (PlankDockElement*) _tmp38_);
		}
		_g_object_unref0 (alternate_item);
		_g_object_unref0 (current_item);
		_g_variant_iter_free0 (prop_iter);
		_g_free0 (app_uri);
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	if (!is_retry) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda39__gsource_func, block10_data_ref (_data10_), block10_data_unref);
		_g_object_unref0 (alternate_item);
		_g_object_unref0 (current_item);
		_g_variant_iter_free0 (prop_iter);
		_g_free0 (app_uri);
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	provider = PLANK_IS_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER (self) ? ((PlankDefaultApplicationDockItemProvider*) self) : NULL;
	_tmp40_ = provider;
	if (_tmp40_ != NULL) {
		PlankDefaultApplicationDockItemProvider* _tmp41_;
		PlankDockPreferences* _tmp42_;
		PlankDockPreferences* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp41_ = provider;
		_tmp42_ = plank_default_application_dock_item_provider_get_Prefs (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = plank_dock_preferences_get_PinnedOnly (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp39_ = !_tmp45_;
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		GFile* desktop_file = NULL;
		const gchar* _tmp46_;
		GFile* _tmp47_;
		GFile* _tmp48_;
		PlankApplicationDockItem* _tmp57_;
		_tmp46_ = app_uri;
		_tmp47_ = plank_application_dock_item_provider_desktop_file_for_application_uri (_tmp46_);
		desktop_file = _tmp47_;
		_tmp48_ = desktop_file;
		if (_tmp48_ != NULL) {
			GFile* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			PlankTransientDockItem* _tmp52_;
			PlankApplicationDockItem* _tmp53_;
			GVariantIter* _tmp54_;
			PlankApplicationDockItem* _tmp55_;
			_tmp49_ = desktop_file;
			_tmp50_ = g_file_get_uri (_tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = plank_transient_dock_item_new_with_launcher (_tmp51_);
			_g_object_unref0 (current_item);
			current_item = (PlankApplicationDockItem*) _tmp52_;
			_g_free0 (_tmp51_);
			_tmp53_ = current_item;
			_tmp54_ = prop_iter;
			plank_application_dock_item_unity_update (_tmp53_, _data10_->sender_name, _tmp54_);
			_tmp55_ = current_item;
			if (plank_application_dock_item_has_unity_info (_tmp55_)) {
				PlankApplicationDockItem* _tmp56_;
				_tmp56_ = current_item;
				plank_dock_container_add ((PlankDockContainer*) self, (PlankDockElement*) _tmp56_, NULL);
			}
		}
		_tmp57_ = current_item;
		if (_tmp57_ == NULL) {
			const gchar* _tmp58_;
			_tmp58_ = app_uri;
			g_warning ("ApplicationDockItemProvider.vala:396: Matching application for '%s' no" \
"t found or not installed!", _tmp58_);
		}
		_g_object_unref0 (desktop_file);
	}
	_g_object_unref0 (alternate_item);
	_g_object_unref0 (current_item);
	_g_variant_iter_free0 (prop_iter);
	_g_free0 (app_uri);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

GFile*
plank_application_dock_item_provider_get_LaunchersDir (PlankApplicationDockItemProvider* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_LaunchersDir;
	result = _tmp0_;
	return result;
}

static void
plank_application_dock_item_provider_set_LaunchersDir (PlankApplicationDockItemProvider* self,
                                                       GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_application_dock_item_provider_get_LaunchersDir (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_LaunchersDir);
		self->priv->_LaunchersDir = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_application_dock_item_provider_properties[PLANK_APPLICATION_DOCK_ITEM_PROVIDER_LAUNCHERS_DIR_PROPERTY]);
	}
}

static GObject *
plank_application_dock_item_provider_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankApplicationDockItemProvider * self;
	GeeArrayList* _tmp0_;
	GFile* _tmp1_;
	PlankMatcher* _tmp2_;
	PlankMatcher* _tmp3_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (plank_application_dock_item_provider_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_APPLICATION_DOCK_ITEM_PROVIDER, PlankApplicationDockItemProvider);
	_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->queued_files);
	self->priv->queued_files = _tmp0_;
	_tmp1_ = self->priv->_LaunchersDir;
	plank_paths_ensure_directory_exists (_tmp1_);
	_tmp2_ = plank_matcher_get_default ();
	_tmp3_ = _tmp2_;
	g_signal_connect_object (_tmp3_, "application-opened", (GCallback) _plank_application_dock_item_provider_app_opened_plank_matcher_application_opened, self, 0);
	_g_object_unref0 (_tmp3_);
	{
		GFileMonitor* _tmp4_ = NULL;
		GFile* _tmp5_;
		GFileMonitor* _tmp6_;
		GFileMonitor* _tmp7_;
		GFileMonitor* _tmp8_;
		_tmp5_ = self->priv->_LaunchersDir;
		_tmp6_ = g_file_monitor_directory (_tmp5_, 0, NULL, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (self->priv->items_monitor);
		self->priv->items_monitor = _tmp7_;
		_tmp8_ = self->priv->items_monitor;
		g_signal_connect_object (_tmp8_, "changed", (GCallback) _plank_application_dock_item_provider_handle_items_dir_changed_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_critical ("ApplicationDockItemProvider.vala:58: Unable to watch the launchers dir" \
"ectory. (%s)", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
plank_application_dock_item_provider_class_init (PlankApplicationDockItemProviderClass * klass,
                                                 gpointer klass_data)
{
	plank_application_dock_item_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankApplicationDockItemProvider_private_offset);
	((PlankDockItemProviderClass *) klass)->add_item_with_uri = (gboolean (*) (PlankDockItemProvider*, const gchar*, PlankDockItem*)) plank_application_dock_item_provider_real_add_item_with_uri;
	((PlankDockContainerClass *) klass)->prepare = (void (*) (PlankDockContainer*)) plank_application_dock_item_provider_real_prepare;
	((PlankDockItemProviderClass *) klass)->get_dockitem_filenames = (gchar** (*) (PlankDockItemProvider*, gint*)) plank_application_dock_item_provider_real_get_dockitem_filenames;
	((PlankApplicationDockItemProviderClass *) klass)->app_opened = (void (*) (PlankApplicationDockItemProvider*, BamfApplication*)) plank_application_dock_item_provider_real_app_opened;
	((PlankDockContainerClass *) klass)->connect_element = (void (*) (PlankDockContainer*, PlankDockElement*)) plank_application_dock_item_provider_real_connect_element;
	((PlankDockContainerClass *) klass)->disconnect_element = (void (*) (PlankDockContainer*, PlankDockElement*)) plank_application_dock_item_provider_real_disconnect_element;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_application_dock_item_provider_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_application_dock_item_provider_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_application_dock_item_provider_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_application_dock_item_provider_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_APPLICATION_DOCK_ITEM_PROVIDER_LAUNCHERS_DIR_PROPERTY, plank_application_dock_item_provider_properties[PLANK_APPLICATION_DOCK_ITEM_PROVIDER_LAUNCHERS_DIR_PROPERTY] = g_param_spec_object ("LaunchersDir", "LaunchersDir", "LaunchersDir", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	plank_application_dock_item_provider_signals[PLANK_APPLICATION_DOCK_ITEM_PROVIDER_ITEM_WINDOW_ADDED_SIGNAL] = g_signal_new ("item-window-added", PLANK_TYPE_APPLICATION_DOCK_ITEM_PROVIDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, PLANK_TYPE_APPLICATION_DOCK_ITEM);
}

static void
plank_application_dock_item_provider_plank_unity_client_interface_init (PlankUnityClientIface * iface,
                                                                        gpointer iface_data)
{
	plank_application_dock_item_provider_plank_unity_client_parent_iface = g_type_interface_peek_parent (iface);
	iface->remove_launcher_entry = (void (*) (PlankUnityClient*, const gchar*)) plank_application_dock_item_provider_real_remove_launcher_entry;
	iface->update_launcher_entry = (void (*) (PlankUnityClient*, const gchar*, GVariant*, gboolean)) plank_application_dock_item_provider_real_update_launcher_entry;
}

static void
plank_application_dock_item_provider_instance_init (PlankApplicationDockItemProvider * self,
                                                    gpointer klass)
{
	self->priv = plank_application_dock_item_provider_get_instance_private (self);
	self->priv->items_monitor = NULL;
	self->priv->delay_items_monitor_handle = FALSE;
}

static void
plank_application_dock_item_provider_finalize (GObject * obj)
{
	PlankApplicationDockItemProvider * self;
	PlankMatcher* _tmp0_;
	PlankMatcher* _tmp1_;
	guint _tmp2_;
	GFileMonitor* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_APPLICATION_DOCK_ITEM_PROVIDER, PlankApplicationDockItemProvider);
	_g_object_unref0 (self->priv->queued_files);
	self->priv->queued_files = NULL;
	_tmp0_ = plank_matcher_get_default ();
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("application-opened", PLANK_TYPE_MATCHER, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _plank_application_dock_item_provider_app_opened_plank_matcher_application_opened, self);
	_g_object_unref0 (_tmp1_);
	_tmp3_ = self->priv->items_monitor;
	if (_tmp3_ != NULL) {
		GFileMonitor* _tmp4_;
		guint _tmp5_;
		GFileMonitor* _tmp6_;
		_tmp4_ = self->priv->items_monitor;
		g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _plank_application_dock_item_provider_handle_items_dir_changed_g_file_monitor_changed, self);
		_tmp6_ = self->priv->items_monitor;
		g_file_monitor_cancel (_tmp6_);
		_g_object_unref0 (self->priv->items_monitor);
		self->priv->items_monitor = NULL;
	}
	_g_object_unref0 (self->priv->_LaunchersDir);
	_g_object_unref0 (self->priv->items_monitor);
	_g_object_unref0 (self->priv->queued_files);
	G_OBJECT_CLASS (plank_application_dock_item_provider_parent_class)->finalize (obj);
}

/**
 * A container and controller class for managing application dock items on a dock.
 */
static GType
plank_application_dock_item_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankApplicationDockItemProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_application_dock_item_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankApplicationDockItemProvider), 0, (GInstanceInitFunc) plank_application_dock_item_provider_instance_init, NULL };
	static const GInterfaceInfo plank_unity_client_info = { (GInterfaceInitFunc) plank_application_dock_item_provider_plank_unity_client_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType plank_application_dock_item_provider_type_id;
	plank_application_dock_item_provider_type_id = g_type_register_static (PLANK_TYPE_DOCK_ITEM_PROVIDER, "PlankApplicationDockItemProvider", &g_define_type_info, 0);
	g_type_add_interface_static (plank_application_dock_item_provider_type_id, PLANK_TYPE_UNITY_CLIENT, &plank_unity_client_info);
	PlankApplicationDockItemProvider_private_offset = g_type_add_instance_private (plank_application_dock_item_provider_type_id, sizeof (PlankApplicationDockItemProviderPrivate));
	return plank_application_dock_item_provider_type_id;
}

GType
plank_application_dock_item_provider_get_type (void)
{
	static volatile gsize plank_application_dock_item_provider_type_id__once = 0;
	if (g_once_init_enter (&plank_application_dock_item_provider_type_id__once)) {
		GType plank_application_dock_item_provider_type_id;
		plank_application_dock_item_provider_type_id = plank_application_dock_item_provider_get_type_once ();
		g_once_init_leave (&plank_application_dock_item_provider_type_id__once, plank_application_dock_item_provider_type_id);
	}
	return plank_application_dock_item_provider_type_id__once;
}

static void
_vala_plank_application_dock_item_provider_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	PlankApplicationDockItemProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_APPLICATION_DOCK_ITEM_PROVIDER, PlankApplicationDockItemProvider);
	switch (property_id) {
		case PLANK_APPLICATION_DOCK_ITEM_PROVIDER_LAUNCHERS_DIR_PROPERTY:
		g_value_set_object (value, plank_application_dock_item_provider_get_LaunchersDir (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_application_dock_item_provider_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	PlankApplicationDockItemProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_APPLICATION_DOCK_ITEM_PROVIDER, PlankApplicationDockItemProvider);
	switch (property_id) {
		case PLANK_APPLICATION_DOCK_ITEM_PROVIDER_LAUNCHERS_DIR_PROPERTY:
		plank_application_dock_item_provider_set_LaunchersDir (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

