/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "mm-gdbus-call.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__INT_INT_UINT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_IntIntUintFunc)
       (void *data1,
        gint arg_old,
        gint arg_new,
        guint arg_reason,
        void *data2);
  _GDbusCodegenMarshalVoid_IntIntUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_IntIntUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_int (param_values + 1),
            g_marshal_value_peek_int (param_values + 2),
            g_marshal_value_peek_uint (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_number,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Call
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusCall
 * @title: MmGdbusCall
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Call D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Call.top_of_page">org.freedesktop.ModemManager1.Call</link> D-Bus interface in C.
 */

enum
{
  MM_GDBUS__CALL_DTMF_RECEIVED,
  MM_GDBUS__CALL_STATE_CHANGED,
};

static unsigned MM_GDBUS__CALL_SIGNALS[2] = { 0 };

/* ---- Introspection data for org.freedesktop.ModemManager1.Call ---- */

static const _ExtendedGDBusMethodInfo _mm_gdbus_call_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    NULL,
    NULL,
    NULL
  },
  "handle-start",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_call_method_info_accept =
{
  {
    -1,
    (gchar *) "Accept",
    NULL,
    NULL,
    NULL
  },
  "handle-accept",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_call_method_info_deflect_IN_ARG_number =
{
  {
    -1,
    (gchar *) "number",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_call_method_info_deflect_IN_ARG_pointers[] =
{
  &_mm_gdbus_call_method_info_deflect_IN_ARG_number.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_call_method_info_deflect =
{
  {
    -1,
    (gchar *) "Deflect",
    (GDBusArgInfo **) &_mm_gdbus_call_method_info_deflect_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-deflect",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_call_method_info_join_multiparty =
{
  {
    -1,
    (gchar *) "JoinMultiparty",
    NULL,
    NULL,
    NULL
  },
  "handle-join-multiparty",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_call_method_info_leave_multiparty =
{
  {
    -1,
    (gchar *) "LeaveMultiparty",
    NULL,
    NULL,
    NULL
  },
  "handle-leave-multiparty",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_call_method_info_hangup =
{
  {
    -1,
    (gchar *) "Hangup",
    NULL,
    NULL,
    NULL
  },
  "handle-hangup",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_call_method_info_send_dtmf_IN_ARG_dtmf =
{
  {
    -1,
    (gchar *) "dtmf",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_call_method_info_send_dtmf_IN_ARG_pointers[] =
{
  &_mm_gdbus_call_method_info_send_dtmf_IN_ARG_dtmf.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_call_method_info_send_dtmf =
{
  {
    -1,
    (gchar *) "SendDtmf",
    (GDBusArgInfo **) &_mm_gdbus_call_method_info_send_dtmf_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-send-dtmf",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_call_method_info_pointers[] =
{
  &_mm_gdbus_call_method_info_start.parent_struct,
  &_mm_gdbus_call_method_info_accept.parent_struct,
  &_mm_gdbus_call_method_info_deflect.parent_struct,
  &_mm_gdbus_call_method_info_join_multiparty.parent_struct,
  &_mm_gdbus_call_method_info_leave_multiparty.parent_struct,
  &_mm_gdbus_call_method_info_hangup.parent_struct,
  &_mm_gdbus_call_method_info_send_dtmf.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_call_signal_info_dtmf_received_ARG_dtmf =
{
  {
    -1,
    (gchar *) "dtmf",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_call_signal_info_dtmf_received_ARG_pointers[] =
{
  &_mm_gdbus_call_signal_info_dtmf_received_ARG_dtmf.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mm_gdbus_call_signal_info_dtmf_received =
{
  {
    -1,
    (gchar *) "DtmfReceived",
    (GDBusArgInfo **) &_mm_gdbus_call_signal_info_dtmf_received_ARG_pointers,
    NULL
  },
  "dtmf-received"
};

static const _ExtendedGDBusArgInfo _mm_gdbus_call_signal_info_state_changed_ARG_old =
{
  {
    -1,
    (gchar *) "old",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_call_signal_info_state_changed_ARG_new =
{
  {
    -1,
    (gchar *) "new",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_call_signal_info_state_changed_ARG_reason =
{
  {
    -1,
    (gchar *) "reason",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_call_signal_info_state_changed_ARG_pointers[] =
{
  &_mm_gdbus_call_signal_info_state_changed_ARG_old.parent_struct,
  &_mm_gdbus_call_signal_info_state_changed_ARG_new.parent_struct,
  &_mm_gdbus_call_signal_info_state_changed_ARG_reason.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mm_gdbus_call_signal_info_state_changed =
{
  {
    -1,
    (gchar *) "StateChanged",
    (GDBusArgInfo **) &_mm_gdbus_call_signal_info_state_changed_ARG_pointers,
    NULL
  },
  "state-changed"
};

static const GDBusSignalInfo * const _mm_gdbus_call_signal_info_pointers[] =
{
  &_mm_gdbus_call_signal_info_dtmf_received.parent_struct,
  &_mm_gdbus_call_signal_info_state_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_call_property_info_state =
{
  {
    -1,
    (gchar *) "State",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_call_property_info_state_reason =
{
  {
    -1,
    (gchar *) "StateReason",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state-reason",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_call_property_info_direction =
{
  {
    -1,
    (gchar *) "Direction",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "direction",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_call_property_info_number =
{
  {
    -1,
    (gchar *) "Number",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "number",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_call_property_info_multiparty =
{
  {
    -1,
    (gchar *) "Multiparty",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "multiparty",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_call_property_info_audio_port =
{
  {
    -1,
    (gchar *) "AudioPort",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "audio-port",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_call_property_info_audio_format =
{
  {
    -1,
    (gchar *) "AudioFormat",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "audio-format",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_call_property_info_pointers[] =
{
  &_mm_gdbus_call_property_info_state.parent_struct,
  &_mm_gdbus_call_property_info_state_reason.parent_struct,
  &_mm_gdbus_call_property_info_direction.parent_struct,
  &_mm_gdbus_call_property_info_number.parent_struct,
  &_mm_gdbus_call_property_info_multiparty.parent_struct,
  &_mm_gdbus_call_property_info_audio_port.parent_struct,
  &_mm_gdbus_call_property_info_audio_format.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_call_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Call",
    (GDBusMethodInfo **) &_mm_gdbus_call_method_info_pointers,
    (GDBusSignalInfo **) &_mm_gdbus_call_signal_info_pointers,
    (GDBusPropertyInfo **) &_mm_gdbus_call_property_info_pointers,
    NULL
  },
  "call",
};


/**
 * mm_gdbus_call_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Call.top_of_page">org.freedesktop.ModemManager1.Call</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_call_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_call_interface_info.parent_struct;
}

/**
 * mm_gdbus_call_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusCall interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_call_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "state");
  g_object_class_override_property (klass, property_id_begin++, "state-reason");
  g_object_class_override_property (klass, property_id_begin++, "direction");
  g_object_class_override_property (klass, property_id_begin++, "number");
  g_object_class_override_property (klass, property_id_begin++, "multiparty");
  g_object_class_override_property (klass, property_id_begin++, "audio-port");
  g_object_class_override_property (klass, property_id_begin++, "audio-format");
  return property_id_begin - 1;
}


inline static void
mm_gdbus_call_signal_marshal_dtmf_received (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_call_signal_marshal_state_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__INT_INT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_call_method_marshal_start (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_call_method_marshal_accept (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_call_method_marshal_deflect (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_call_method_marshal_join_multiparty (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_call_method_marshal_leave_multiparty (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_call_method_marshal_hangup (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_call_method_marshal_send_dtmf (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MmGdbusCall:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Call.top_of_page">org.freedesktop.ModemManager1.Call</link>.
 */

/**
 * MmGdbusCallIface:
 * @parent_iface: The parent interface.
 * @handle_accept: Handler for the #MmGdbusCall::handle-accept signal.
 * @handle_deflect: Handler for the #MmGdbusCall::handle-deflect signal.
 * @handle_hangup: Handler for the #MmGdbusCall::handle-hangup signal.
 * @handle_join_multiparty: Handler for the #MmGdbusCall::handle-join-multiparty signal.
 * @handle_leave_multiparty: Handler for the #MmGdbusCall::handle-leave-multiparty signal.
 * @handle_send_dtmf: Handler for the #MmGdbusCall::handle-send-dtmf signal.
 * @handle_start: Handler for the #MmGdbusCall::handle-start signal.
 * @get_audio_format: Getter for the #MmGdbusCall:audio-format property.
 * @get_audio_port: Getter for the #MmGdbusCall:audio-port property.
 * @get_direction: Getter for the #MmGdbusCall:direction property.
 * @get_multiparty: Getter for the #MmGdbusCall:multiparty property.
 * @get_number: Getter for the #MmGdbusCall:number property.
 * @get_state: Getter for the #MmGdbusCall:state property.
 * @get_state_reason: Getter for the #MmGdbusCall:state-reason property.
 * @dtmf_received: Handler for the #MmGdbusCall::dtmf-received signal.
 * @state_changed: Handler for the #MmGdbusCall::state-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Call.top_of_page">org.freedesktop.ModemManager1.Call</link>.
 */

typedef MmGdbusCallIface MmGdbusCallInterface;
G_DEFINE_INTERFACE (MmGdbusCall, mm_gdbus_call, G_TYPE_OBJECT)

static void
mm_gdbus_call_default_init (MmGdbusCallIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusCall::handle-start:
   * @object: A #MmGdbusCall.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_call_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusCallIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_call_method_marshal_start,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusCall::handle-accept:
   * @object: A #MmGdbusCall.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Accept">Accept()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_call_complete_accept() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-accept",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusCallIface, handle_accept),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_call_method_marshal_accept,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusCall::handle-deflect:
   * @object: A #MmGdbusCall.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_number: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Deflect">Deflect()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_call_complete_deflect() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-deflect",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusCallIface, handle_deflect),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_call_method_marshal_deflect,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MmGdbusCall::handle-join-multiparty:
   * @object: A #MmGdbusCall.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.JoinMultiparty">JoinMultiparty()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_call_complete_join_multiparty() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-join-multiparty",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusCallIface, handle_join_multiparty),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_call_method_marshal_join_multiparty,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusCall::handle-leave-multiparty:
   * @object: A #MmGdbusCall.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.LeaveMultiparty">LeaveMultiparty()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_call_complete_leave_multiparty() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-leave-multiparty",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusCallIface, handle_leave_multiparty),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_call_method_marshal_leave_multiparty,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusCall::handle-hangup:
   * @object: A #MmGdbusCall.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Hangup">Hangup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_call_complete_hangup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hangup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusCallIface, handle_hangup),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_call_method_marshal_hangup,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusCall::handle-send-dtmf:
   * @object: A #MmGdbusCall.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_dtmf: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.SendDtmf">SendDtmf()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_call_complete_send_dtmf() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-send-dtmf",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusCallIface, handle_send_dtmf),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_call_method_marshal_send_dtmf,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * MmGdbusCall::dtmf-received:
   * @object: A #MmGdbusCall.
   * @arg_dtmf: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Call.DtmfReceived">"DtmfReceived"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  MM_GDBUS__CALL_SIGNALS[MM_GDBUS__CALL_DTMF_RECEIVED] =
    g_signal_new ("dtmf-received",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MmGdbusCallIface, dtmf_received),
      NULL,
      NULL,
      mm_gdbus_call_signal_marshal_dtmf_received,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * MmGdbusCall::state-changed:
   * @object: A #MmGdbusCall.
   * @arg_old: Argument.
   * @arg_new: Argument.
   * @arg_reason: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Call.StateChanged">"StateChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  MM_GDBUS__CALL_SIGNALS[MM_GDBUS__CALL_STATE_CHANGED] =
    g_signal_new ("state-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MmGdbusCallIface, state_changed),
      NULL,
      NULL,
      mm_gdbus_call_signal_marshal_state_changed,
      G_TYPE_NONE,
      3, G_TYPE_INT, G_TYPE_INT, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusCall:state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.State">"State"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("state", "State", "State", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusCall:state-reason:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.StateReason">"StateReason"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("state-reason", "StateReason", "StateReason", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusCall:direction:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.Direction">"Direction"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("direction", "Direction", "Direction", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusCall:number:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.Number">"Number"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("number", "Number", "Number", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusCall:multiparty:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.Multiparty">"Multiparty"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("multiparty", "Multiparty", "Multiparty", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusCall:audio-port:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.AudioPort">"AudioPort"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("audio-port", "AudioPort", "AudioPort", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusCall:audio-format:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.AudioFormat">"AudioFormat"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("audio-format", "AudioFormat", "AudioFormat", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_call_get_state: (skip)
 * @object: A #MmGdbusCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.State">"State"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
mm_gdbus_call_get_state (MmGdbusCall *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_CALL (object), 0);

  return MM_GDBUS_CALL_GET_IFACE (object)->get_state (object);
}

/**
 * mm_gdbus_call_set_state: (skip)
 * @object: A #MmGdbusCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.State">"State"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_call_set_state (MmGdbusCall *object, gint value)
{
  g_object_set (G_OBJECT (object), "state", value, NULL);
}

/**
 * mm_gdbus_call_get_state_reason: (skip)
 * @object: A #MmGdbusCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.StateReason">"StateReason"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
mm_gdbus_call_get_state_reason (MmGdbusCall *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_CALL (object), 0);

  return MM_GDBUS_CALL_GET_IFACE (object)->get_state_reason (object);
}

/**
 * mm_gdbus_call_set_state_reason: (skip)
 * @object: A #MmGdbusCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.StateReason">"StateReason"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_call_set_state_reason (MmGdbusCall *object, gint value)
{
  g_object_set (G_OBJECT (object), "state-reason", value, NULL);
}

/**
 * mm_gdbus_call_get_direction: (skip)
 * @object: A #MmGdbusCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.Direction">"Direction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
mm_gdbus_call_get_direction (MmGdbusCall *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_CALL (object), 0);

  return MM_GDBUS_CALL_GET_IFACE (object)->get_direction (object);
}

/**
 * mm_gdbus_call_set_direction: (skip)
 * @object: A #MmGdbusCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.Direction">"Direction"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_call_set_direction (MmGdbusCall *object, gint value)
{
  g_object_set (G_OBJECT (object), "direction", value, NULL);
}

/**
 * mm_gdbus_call_get_number: (skip)
 * @object: A #MmGdbusCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.Number">"Number"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_call_dup_number() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_call_get_number (MmGdbusCall *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_CALL (object), NULL);

  return MM_GDBUS_CALL_GET_IFACE (object)->get_number (object);
}

/**
 * mm_gdbus_call_dup_number: (skip)
 * @object: A #MmGdbusCall.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.Number">"Number"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_call_dup_number (MmGdbusCall *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "number", &value, NULL);
  return value;
}

/**
 * mm_gdbus_call_set_number: (skip)
 * @object: A #MmGdbusCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.Number">"Number"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_call_set_number (MmGdbusCall *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "number", value, NULL);
}

/**
 * mm_gdbus_call_get_multiparty: (skip)
 * @object: A #MmGdbusCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.Multiparty">"Multiparty"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mm_gdbus_call_get_multiparty (MmGdbusCall *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_CALL (object), FALSE);

  return MM_GDBUS_CALL_GET_IFACE (object)->get_multiparty (object);
}

/**
 * mm_gdbus_call_set_multiparty: (skip)
 * @object: A #MmGdbusCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.Multiparty">"Multiparty"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_call_set_multiparty (MmGdbusCall *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "multiparty", value, NULL);
}

/**
 * mm_gdbus_call_get_audio_port: (skip)
 * @object: A #MmGdbusCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.AudioPort">"AudioPort"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_call_dup_audio_port() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_call_get_audio_port (MmGdbusCall *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_CALL (object), NULL);

  return MM_GDBUS_CALL_GET_IFACE (object)->get_audio_port (object);
}

/**
 * mm_gdbus_call_dup_audio_port: (skip)
 * @object: A #MmGdbusCall.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.AudioPort">"AudioPort"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_call_dup_audio_port (MmGdbusCall *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "audio-port", &value, NULL);
  return value;
}

/**
 * mm_gdbus_call_set_audio_port: (skip)
 * @object: A #MmGdbusCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.AudioPort">"AudioPort"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_call_set_audio_port (MmGdbusCall *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "audio-port", value, NULL);
}

/**
 * mm_gdbus_call_get_audio_format: (skip)
 * @object: A #MmGdbusCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.AudioFormat">"AudioFormat"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_call_dup_audio_format() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_call_get_audio_format (MmGdbusCall *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_CALL (object), NULL);

  return MM_GDBUS_CALL_GET_IFACE (object)->get_audio_format (object);
}

/**
 * mm_gdbus_call_dup_audio_format: (skip)
 * @object: A #MmGdbusCall.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.AudioFormat">"AudioFormat"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_call_dup_audio_format (MmGdbusCall *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "audio-format", &value, NULL);
  return value;
}

/**
 * mm_gdbus_call_set_audio_format: (skip)
 * @object: A #MmGdbusCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Call.AudioFormat">"AudioFormat"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_call_set_audio_format (MmGdbusCall *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "audio-format", value, NULL);
}

/**
 * mm_gdbus_call_emit_dtmf_received:
 * @object: A #MmGdbusCall.
 * @arg_dtmf: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Call.DtmfReceived">"DtmfReceived"</link> D-Bus signal.
 */
void
mm_gdbus_call_emit_dtmf_received (
    MmGdbusCall *object,
    const gchar *arg_dtmf)
{
  g_signal_emit (object, MM_GDBUS__CALL_SIGNALS[MM_GDBUS__CALL_DTMF_RECEIVED], 0, arg_dtmf);
}

/**
 * mm_gdbus_call_emit_state_changed:
 * @object: A #MmGdbusCall.
 * @arg_old: Argument to pass with the signal.
 * @arg_new: Argument to pass with the signal.
 * @arg_reason: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Call.StateChanged">"StateChanged"</link> D-Bus signal.
 */
void
mm_gdbus_call_emit_state_changed (
    MmGdbusCall *object,
    gint arg_old,
    gint arg_new,
    guint arg_reason)
{
  g_signal_emit (object, MM_GDBUS__CALL_SIGNALS[MM_GDBUS__CALL_STATE_CHANGED], 0, arg_old, arg_new, arg_reason);
}

/**
 * mm_gdbus_call_call_start:
 * @proxy: A #MmGdbusCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_call_call_start_finish() to get the result of the operation.
 *
 * See mm_gdbus_call_call_start_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_call_call_start (
    MmGdbusCall *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_call_call_start_finish:
 * @proxy: A #MmGdbusCallProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_call_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_call_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_call_call_start_finish (
    MmGdbusCall *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_call_call_start_sync:
 * @proxy: A #MmGdbusCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_call_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_call_call_start_sync (
    MmGdbusCall *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_call_call_accept:
 * @proxy: A #MmGdbusCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Accept">Accept()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_call_call_accept_finish() to get the result of the operation.
 *
 * See mm_gdbus_call_call_accept_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_call_call_accept (
    MmGdbusCall *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Accept",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_call_call_accept_finish:
 * @proxy: A #MmGdbusCallProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_call_call_accept().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_call_call_accept().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_call_call_accept_finish (
    MmGdbusCall *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_call_call_accept_sync:
 * @proxy: A #MmGdbusCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Accept">Accept()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_call_call_accept() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_call_call_accept_sync (
    MmGdbusCall *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Accept",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_call_call_deflect:
 * @proxy: A #MmGdbusCallProxy.
 * @arg_number: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Deflect">Deflect()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_call_call_deflect_finish() to get the result of the operation.
 *
 * See mm_gdbus_call_call_deflect_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_call_call_deflect (
    MmGdbusCall *proxy,
    const gchar *arg_number,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Deflect",
    g_variant_new ("(s)",
                   arg_number),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_call_call_deflect_finish:
 * @proxy: A #MmGdbusCallProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_call_call_deflect().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_call_call_deflect().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_call_call_deflect_finish (
    MmGdbusCall *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_call_call_deflect_sync:
 * @proxy: A #MmGdbusCallProxy.
 * @arg_number: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Deflect">Deflect()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_call_call_deflect() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_call_call_deflect_sync (
    MmGdbusCall *proxy,
    const gchar *arg_number,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Deflect",
    g_variant_new ("(s)",
                   arg_number),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_call_call_join_multiparty:
 * @proxy: A #MmGdbusCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.JoinMultiparty">JoinMultiparty()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_call_call_join_multiparty_finish() to get the result of the operation.
 *
 * See mm_gdbus_call_call_join_multiparty_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_call_call_join_multiparty (
    MmGdbusCall *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "JoinMultiparty",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_call_call_join_multiparty_finish:
 * @proxy: A #MmGdbusCallProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_call_call_join_multiparty().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_call_call_join_multiparty().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_call_call_join_multiparty_finish (
    MmGdbusCall *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_call_call_join_multiparty_sync:
 * @proxy: A #MmGdbusCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.JoinMultiparty">JoinMultiparty()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_call_call_join_multiparty() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_call_call_join_multiparty_sync (
    MmGdbusCall *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "JoinMultiparty",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_call_call_leave_multiparty:
 * @proxy: A #MmGdbusCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.LeaveMultiparty">LeaveMultiparty()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_call_call_leave_multiparty_finish() to get the result of the operation.
 *
 * See mm_gdbus_call_call_leave_multiparty_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_call_call_leave_multiparty (
    MmGdbusCall *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "LeaveMultiparty",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_call_call_leave_multiparty_finish:
 * @proxy: A #MmGdbusCallProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_call_call_leave_multiparty().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_call_call_leave_multiparty().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_call_call_leave_multiparty_finish (
    MmGdbusCall *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_call_call_leave_multiparty_sync:
 * @proxy: A #MmGdbusCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.LeaveMultiparty">LeaveMultiparty()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_call_call_leave_multiparty() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_call_call_leave_multiparty_sync (
    MmGdbusCall *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "LeaveMultiparty",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_call_call_hangup:
 * @proxy: A #MmGdbusCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Hangup">Hangup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_call_call_hangup_finish() to get the result of the operation.
 *
 * See mm_gdbus_call_call_hangup_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_call_call_hangup (
    MmGdbusCall *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Hangup",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_call_call_hangup_finish:
 * @proxy: A #MmGdbusCallProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_call_call_hangup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_call_call_hangup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_call_call_hangup_finish (
    MmGdbusCall *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_call_call_hangup_sync:
 * @proxy: A #MmGdbusCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Hangup">Hangup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_call_call_hangup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_call_call_hangup_sync (
    MmGdbusCall *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Hangup",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_call_call_send_dtmf:
 * @proxy: A #MmGdbusCallProxy.
 * @arg_dtmf: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.SendDtmf">SendDtmf()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_call_call_send_dtmf_finish() to get the result of the operation.
 *
 * See mm_gdbus_call_call_send_dtmf_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_call_call_send_dtmf (
    MmGdbusCall *proxy,
    const gchar *arg_dtmf,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SendDtmf",
    g_variant_new ("(s)",
                   arg_dtmf),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_call_call_send_dtmf_finish:
 * @proxy: A #MmGdbusCallProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_call_call_send_dtmf().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_call_call_send_dtmf().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_call_call_send_dtmf_finish (
    MmGdbusCall *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_call_call_send_dtmf_sync:
 * @proxy: A #MmGdbusCallProxy.
 * @arg_dtmf: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.SendDtmf">SendDtmf()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_call_call_send_dtmf() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_call_call_send_dtmf_sync (
    MmGdbusCall *proxy,
    const gchar *arg_dtmf,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SendDtmf",
    g_variant_new ("(s)",
                   arg_dtmf),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_call_complete_start:
 * @object: A #MmGdbusCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_call_complete_start (
    MmGdbusCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_call_complete_accept:
 * @object: A #MmGdbusCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Accept">Accept()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_call_complete_accept (
    MmGdbusCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_call_complete_deflect:
 * @object: A #MmGdbusCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Deflect">Deflect()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_call_complete_deflect (
    MmGdbusCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_call_complete_join_multiparty:
 * @object: A #MmGdbusCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.JoinMultiparty">JoinMultiparty()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_call_complete_join_multiparty (
    MmGdbusCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_call_complete_leave_multiparty:
 * @object: A #MmGdbusCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.LeaveMultiparty">LeaveMultiparty()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_call_complete_leave_multiparty (
    MmGdbusCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_call_complete_hangup:
 * @object: A #MmGdbusCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.Hangup">Hangup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_call_complete_hangup (
    MmGdbusCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_call_complete_send_dtmf:
 * @object: A #MmGdbusCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Call.SendDtmf">SendDtmf()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_call_complete_send_dtmf (
    MmGdbusCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusCallProxy:
 *
 * The #MmGdbusCallProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusCallProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusCallProxy.
 */

struct _MmGdbusCallProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_call_proxy_iface_init (MmGdbusCallIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusCallProxy, mm_gdbus_call_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusCallProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_CALL, mm_gdbus_call_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusCallProxy, mm_gdbus_call_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_CALL, mm_gdbus_call_proxy_iface_init))

#endif
static void
mm_gdbus_call_proxy_finalize (GObject *object)
{
  MmGdbusCallProxy *proxy = MM_GDBUS_CALL_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_call_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_call_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_call_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_call_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Call: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_call_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_call_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Call", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_call_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_call_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_call_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_CALL);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_CALL);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_call_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusCallProxy *proxy = MM_GDBUS_CALL_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_call_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_call_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gint 
mm_gdbus_call_proxy_get_state (MmGdbusCall *object)
{
  MmGdbusCallProxy *proxy = MM_GDBUS_CALL_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "State");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
mm_gdbus_call_proxy_get_state_reason (MmGdbusCall *object)
{
  MmGdbusCallProxy *proxy = MM_GDBUS_CALL_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "StateReason");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
mm_gdbus_call_proxy_get_direction (MmGdbusCall *object)
{
  MmGdbusCallProxy *proxy = MM_GDBUS_CALL_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Direction");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_call_proxy_get_number (MmGdbusCall *object)
{
  MmGdbusCallProxy *proxy = MM_GDBUS_CALL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Number");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mm_gdbus_call_proxy_get_multiparty (MmGdbusCall *object)
{
  MmGdbusCallProxy *proxy = MM_GDBUS_CALL_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Multiparty");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_call_proxy_get_audio_port (MmGdbusCall *object)
{
  MmGdbusCallProxy *proxy = MM_GDBUS_CALL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AudioPort");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
mm_gdbus_call_proxy_get_audio_format (MmGdbusCall *object)
{
  MmGdbusCallProxy *proxy = MM_GDBUS_CALL_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AudioFormat");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
mm_gdbus_call_proxy_init (MmGdbusCallProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_call_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_CALL_PROXY, MmGdbusCallProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_call_interface_info ());
}

static void
mm_gdbus_call_proxy_class_init (MmGdbusCallProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_call_proxy_finalize;
  gobject_class->get_property = mm_gdbus_call_proxy_get_property;
  gobject_class->set_property = mm_gdbus_call_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_call_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_call_proxy_g_properties_changed;

  mm_gdbus_call_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusCallProxyPrivate));
#endif
}

static void
mm_gdbus_call_proxy_iface_init (MmGdbusCallIface *iface)
{
  iface->get_state = mm_gdbus_call_proxy_get_state;
  iface->get_state_reason = mm_gdbus_call_proxy_get_state_reason;
  iface->get_direction = mm_gdbus_call_proxy_get_direction;
  iface->get_number = mm_gdbus_call_proxy_get_number;
  iface->get_multiparty = mm_gdbus_call_proxy_get_multiparty;
  iface->get_audio_port = mm_gdbus_call_proxy_get_audio_port;
  iface->get_audio_format = mm_gdbus_call_proxy_get_audio_format;
}

/**
 * mm_gdbus_call_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Call.top_of_page">org.freedesktop.ModemManager1.Call</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_call_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_call_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_call_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_CALL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Call", NULL);
}

/**
 * mm_gdbus_call_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_call_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_call_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusCallProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusCall *
mm_gdbus_call_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_CALL (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_call_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Call.top_of_page">org.freedesktop.ModemManager1.Call</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_call_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusCallProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusCall *
mm_gdbus_call_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_CALL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Call", NULL);
  if (ret != NULL)
    return MM_GDBUS_CALL (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_call_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_call_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_call_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_call_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_call_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_CALL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Call", NULL);
}

/**
 * mm_gdbus_call_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_call_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_call_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusCallProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusCall *
mm_gdbus_call_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_CALL (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_call_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_call_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_call_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusCallProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusCall *
mm_gdbus_call_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_CALL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Call", NULL);
  if (ret != NULL)
    return MM_GDBUS_CALL (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusCallSkeleton:
 *
 * The #MmGdbusCallSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusCallSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusCallSkeleton.
 */

struct _MmGdbusCallSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_call_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_CALL);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_CALL);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_call_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_call_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_call_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_call_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_call_skeleton_vtable =
{
  _mm_gdbus_call_skeleton_handle_method_call,
  _mm_gdbus_call_skeleton_handle_get_property,
  _mm_gdbus_call_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_call_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_call_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_call_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_call_skeleton_vtable;
}

static GVariant *
mm_gdbus_call_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_mm_gdbus_call_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_call_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_call_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_call_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Call", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_call_emit_changed (gpointer user_data);

static void
mm_gdbus_call_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_call_emit_changed (skeleton);
}

static void
_mm_gdbus_call_on_signal_dtmf_received (
    MmGdbusCall *object,
    const gchar *arg_dtmf)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_dtmf));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Call", "DtmfReceived",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_mm_gdbus_call_on_signal_state_changed (
    MmGdbusCall *object,
    gint arg_old,
    gint arg_new,
    guint arg_reason)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(iiu)",
                   arg_old,
                   arg_new,
                   arg_reason));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Call", "StateChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void mm_gdbus_call_skeleton_iface_init (MmGdbusCallIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusCallSkeleton, mm_gdbus_call_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusCallSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_CALL, mm_gdbus_call_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusCallSkeleton, mm_gdbus_call_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_CALL, mm_gdbus_call_skeleton_iface_init))

#endif
static void
mm_gdbus_call_skeleton_finalize (GObject *object)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (object);
  guint n;
  for (n = 0; n < 7; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_call_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_call_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_call_emit_changed (gpointer user_data)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Call",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_call_schedule_emit_changed (MmGdbusCallSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_call_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_call_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_call_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_call_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_call_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_call_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_call_skeleton_init (MmGdbusCallSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_call_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_CALL_SKELETON, MmGdbusCallSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 7);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_VARIANT);
}

static gint 
mm_gdbus_call_skeleton_get_state (MmGdbusCall *object)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
mm_gdbus_call_skeleton_get_state_reason (MmGdbusCall *object)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
mm_gdbus_call_skeleton_get_direction (MmGdbusCall *object)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_call_skeleton_get_number (MmGdbusCall *object)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mm_gdbus_call_skeleton_get_multiparty (MmGdbusCall *object)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_call_skeleton_get_audio_port (MmGdbusCall *object)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_call_skeleton_get_audio_format (MmGdbusCall *object)
{
  MmGdbusCallSkeleton *skeleton = MM_GDBUS_CALL_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_call_skeleton_class_init (MmGdbusCallSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_call_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_call_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_call_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_call_skeleton_notify;


  mm_gdbus_call_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_call_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_call_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_call_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_call_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusCallSkeletonPrivate));
#endif
}

static void
mm_gdbus_call_skeleton_iface_init (MmGdbusCallIface *iface)
{
  iface->dtmf_received = _mm_gdbus_call_on_signal_dtmf_received;
  iface->state_changed = _mm_gdbus_call_on_signal_state_changed;
  iface->get_state = mm_gdbus_call_skeleton_get_state;
  iface->get_state_reason = mm_gdbus_call_skeleton_get_state_reason;
  iface->get_direction = mm_gdbus_call_skeleton_get_direction;
  iface->get_number = mm_gdbus_call_skeleton_get_number;
  iface->get_multiparty = mm_gdbus_call_skeleton_get_multiparty;
  iface->get_audio_port = mm_gdbus_call_skeleton_get_audio_port;
  iface->get_audio_format = mm_gdbus_call_skeleton_get_audio_format;
}

/**
 * mm_gdbus_call_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Call.top_of_page">org.freedesktop.ModemManager1.Call</link>.
 *
 * Returns: (transfer full) (type MmGdbusCallSkeleton): The skeleton object.
 */
MmGdbusCall *
mm_gdbus_call_skeleton_new (void)
{
  return MM_GDBUS_CALL (g_object_new (MM_GDBUS_TYPE_CALL_SKELETON, NULL));
}

