/* Theme.c generated by valac 0.56.18, the Vala compiler
 * generated from Theme.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <libxml/tree.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
typedef struct _ThemePrivate ThemePrivate;
enum  {
	THEME_0_PROPERTY,
	THEME_NAME_PROPERTY,
	THEME_LABEL_PROPERTY,
	THEME_INDEX_PROPERTY,
	THEME_PREFER_DARK_PROPERTY,
	THEME_CUSTOM_PROPERTY,
	THEME_TEMPORARY_PROPERTY,
	THEME_ROTATE_PROPERTY,
	THEME_NUM_PROPERTIES
};
static GParamSpec* theme_properties[THEME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))
#define _g_rand_free0(var) ((var == NULL) ? NULL : (var = (g_rand_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _Theme {
	GObject parent_instance;
	ThemePrivate * priv;
};

struct _ThemeClass {
	GObjectClass parent_class;
};

struct _ThemePrivate {
	GeeHashMap* _colors;
	gchar* _name;
	gchar* _label;
	gint _index;
	gboolean _prefer_dark;
	gboolean _custom;
	gboolean _temporary;
	gboolean _rotate;
};

static gint Theme_private_offset;
static gpointer theme_parent_class = NULL;

VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN Theme* theme_new (void);
VALA_EXTERN Theme* theme_construct (GType object_type);
static GdkRGBA* _vala_GdkRGBA_copy (GdkRGBA* self);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN Theme* theme_new_from_theme (Theme* theme);
VALA_EXTERN Theme* theme_construct_from_theme (GType object_type,
                                   Theme* theme);
VALA_EXTERN void theme_copy (Theme* self,
                 Theme* theme);
VALA_EXTERN const gchar* theme_get_name (Theme* self);
VALA_EXTERN void theme_set_name (Theme* self,
                     const gchar* value);
VALA_EXTERN const gchar* theme_get_label (Theme* self);
VALA_EXTERN void theme_set_label (Theme* self,
                      const gchar* value);
VALA_EXTERN gint theme_get_index (Theme* self);
VALA_EXTERN void theme_set_index (Theme* self,
                      gint value);
VALA_EXTERN gboolean theme_get_prefer_dark (Theme* self);
VALA_EXTERN void theme_set_prefer_dark (Theme* self,
                            gboolean value);
VALA_EXTERN gboolean theme_get_temporary (Theme* self);
VALA_EXTERN void theme_set_temporary (Theme* self,
                          gboolean value);
VALA_EXTERN gboolean theme_get_rotate (Theme* self);
VALA_EXTERN void theme_set_rotate (Theme* self,
                       gboolean value);
VALA_EXTERN GArray* theme_colors (Theme* self);
static void _g_free0_ (gpointer var);
static void _vala_gchar_free_function_content_of (gpointer data);
VALA_EXTERN gboolean theme_matches (Theme* self,
                        Theme* theme);
VALA_EXTERN gboolean theme_get_custom (Theme* self);
VALA_EXTERN gboolean theme_set_color (Theme* self,
                          const gchar* name,
                          GdkRGBA* color);
VALA_EXTERN GdkRGBA* theme_get_color (Theme* self,
                          const gchar* name);
VALA_EXTERN GdkRGBA* theme_next_color (Theme* self);
VALA_EXTERN void theme_link_color (Theme* self,
                       gint index,
                       GdkRGBA* result);
VALA_EXTERN gint theme_num_link_colors (void);
VALA_EXTERN void theme_random_link_color (Theme* self,
                              GdkRGBA* result);
VALA_EXTERN gint theme_get_color_index (Theme* self,
                            GdkRGBA* color);
VALA_EXTERN void theme_color_from_string (Theme* self,
                              const gchar* value,
                              GdkRGBA* result);
VALA_EXTERN void utils_color_from_string (const gchar* value,
                              GdkRGBA* result);
VALA_EXTERN GtkCssProvider* theme_get_css_provider (Theme* self,
                                        gint text_size);
static void theme_set_context_color (Theme* self,
                              cairo_t* ctx,
                              GdkRGBA* color);
VALA_EXTERN gboolean theme_load (Theme* self,
                     xmlNode* n);
VALA_EXTERN xmlNode* theme_save (Theme* self);
VALA_EXTERN gchar* utils_color_from_rgba (GdkRGBA* rgba);
VALA_EXTERN cairo_surface_t* theme_make_icon (Theme* self);
VALA_EXTERN void connection_draw_arrow (cairo_t* ctx,
                            gint line_width,
                            gdouble tipx,
                            gdouble tipy,
                            gdouble tailx,
                            gdouble taily,
                            gdouble arrowLength);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
VALA_EXTERN void theme_set_custom (Theme* self,
                       gboolean value);
static void theme_finalize (GObject * obj);
static GType theme_get_type_once (void);
static void _vala_theme_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec);
static void _vala_theme_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
theme_get_instance_private (Theme* self)
{
	return G_STRUCT_MEMBER_P (self, Theme_private_offset);
}

static GdkRGBA*
_vala_GdkRGBA_copy (GdkRGBA* self)
{
	return g_boxed_copy (gdk_rgba_get_type (), self);
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

Theme*
theme_construct (GType object_type)
{
	Theme * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp6_;
	GeeHashMap* _tmp7_;
	GeeHashMap* _tmp8_;
	GeeHashMap* _tmp9_;
	GeeHashMap* _tmp10_;
	GeeHashMap* _tmp11_;
	GeeHashMap* _tmp12_;
	GeeHashMap* _tmp13_;
	GeeHashMap* _tmp14_;
	GeeHashMap* _tmp15_;
	GeeHashMap* _tmp16_;
	GeeHashMap* _tmp17_;
	GeeHashMap* _tmp18_;
	GeeHashMap* _tmp19_;
	GeeHashMap* _tmp20_;
	GeeHashMap* _tmp21_;
	GeeHashMap* _tmp22_;
	GeeHashMap* _tmp23_;
	GeeHashMap* _tmp24_;
	GeeHashMap* _tmp25_;
	GeeHashMap* _tmp26_;
	GeeHashMap* _tmp27_;
	GeeHashMap* _tmp28_;
	self = (Theme*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gdk_rgba_get_type (), (GBoxedCopyFunc) _vala_GdkRGBA_copy, (GDestroyNotify) _vala_GdkRGBA_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_colors);
	self->priv->_colors = _tmp0_;
	_tmp1_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, "background", NULL);
	_tmp2_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, "foreground", NULL);
	_tmp3_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, "root_background", NULL);
	_tmp4_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, "root_foreground", NULL);
	_tmp5_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, "nodesel_background", NULL);
	_tmp6_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, "nodesel_foreground", NULL);
	_tmp7_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, "textsel_background", NULL);
	_tmp8_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, "textsel_foreground", NULL);
	_tmp9_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, "text_cursor", NULL);
	_tmp10_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, "attachable", NULL);
	_tmp11_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, "connection_background", NULL);
	_tmp12_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, "connection_foreground", NULL);
	_tmp13_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, "url_background", NULL);
	_tmp14_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, "url_foreground", NULL);
	_tmp15_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "tag", NULL);
	_tmp16_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, "syntax", NULL);
	_tmp17_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, "match_background", NULL);
	_tmp18_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, "match_foreground", NULL);
	_tmp19_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, "markdown_listitem", NULL);
	_tmp20_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, "callout_background", NULL);
	_tmp21_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, "link_color0", NULL);
	_tmp22_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, "link_color1", NULL);
	_tmp23_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, "link_color2", NULL);
	_tmp24_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp24_, "link_color3", NULL);
	_tmp25_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, "link_color4", NULL);
	_tmp26_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, "link_color5", NULL);
	_tmp27_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, "link_color6", NULL);
	_tmp28_ = self->priv->_colors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, "link_color7", NULL);
	return self;
}

Theme*
theme_new (void)
{
	return theme_construct (TYPE_THEME);
}

Theme*
theme_construct_from_theme (GType object_type,
                            Theme* theme)
{
	Theme * self = NULL;
	g_return_val_if_fail (theme != NULL, NULL);
	self = (Theme*) g_object_new (object_type, NULL);
	theme_copy (self, theme);
	return self;
}

Theme*
theme_new_from_theme (Theme* theme)
{
	return theme_construct_from_theme (TYPE_THEME, theme);
}

void
theme_copy (Theme* self,
            Theme* theme)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GeeHashMap* _tmp6_;
	GeeMapIterator* it = NULL;
	GeeHashMap* _tmp7_;
	GeeMapIterator* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = theme->priv->_name;
	theme_set_name (self, _tmp0_);
	_tmp1_ = theme->priv->_label;
	theme_set_label (self, _tmp1_);
	_tmp2_ = theme->priv->_index;
	theme_set_index (self, _tmp2_);
	_tmp3_ = theme->priv->_prefer_dark;
	theme_set_prefer_dark (self, _tmp3_);
	_tmp4_ = theme->priv->_temporary;
	theme_set_temporary (self, _tmp4_);
	_tmp5_ = theme->priv->_rotate;
	theme_set_rotate (self, _tmp5_);
	_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gdk_rgba_get_type (), (GBoxedCopyFunc) _vala_GdkRGBA_copy, (GDestroyNotify) _vala_GdkRGBA_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_colors);
	self->priv->_colors = _tmp6_;
	_tmp7_ = theme->priv->_colors;
	_tmp8_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp7_);
	it = _tmp8_;
	while (TRUE) {
		GeeMapIterator* _tmp9_;
		GeeHashMap* _tmp10_;
		GeeMapIterator* _tmp11_;
		gpointer _tmp12_;
		gchar* _tmp13_;
		GeeMapIterator* _tmp14_;
		gpointer _tmp15_;
		GdkRGBA* _tmp16_;
		_tmp9_ = it;
		if (!gee_map_iterator_next (_tmp9_)) {
			break;
		}
		_tmp10_ = self->priv->_colors;
		_tmp11_ = it;
		_tmp12_ = gee_map_iterator_get_key (_tmp11_);
		_tmp13_ = (gchar*) _tmp12_;
		_tmp14_ = it;
		_tmp15_ = gee_map_iterator_get_value (_tmp14_);
		_tmp16_ = (GdkRGBA*) _tmp15_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp13_, _tmp16_);
		__vala_GdkRGBA_free0 (_tmp16_);
		_g_free0 (_tmp13_);
	}
	_g_object_unref0 (it);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_gchar_free_function_content_of (gpointer data)
{
	gchar* self;
	self = *((gchar**) data);
	_g_free0_ (self);
}

GArray*
theme_colors (Theme* self)
{
	GArray* cs = NULL;
	GArray* _tmp0_;
	GeeMapIterator* it = NULL;
	GeeHashMap* _tmp1_;
	GeeMapIterator* _tmp2_;
	GArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_gchar_free_function_content_of);
	cs = _tmp0_;
	_tmp1_ = self->priv->_colors;
	_tmp2_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp1_);
	it = _tmp2_;
	while (TRUE) {
		GeeMapIterator* _tmp3_;
		gchar* name = NULL;
		GeeMapIterator* _tmp4_;
		gpointer _tmp5_;
		GArray* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = it;
		if (!gee_map_iterator_next (_tmp3_)) {
			break;
		}
		_tmp4_ = it;
		_tmp5_ = gee_map_iterator_get_key (_tmp4_);
		name = (gchar*) ((gchar*) _tmp5_);
		_tmp6_ = cs;
		_tmp7_ = name;
		_tmp8_ = g_strdup (_tmp7_);
		g_array_append_val (_tmp6_, _tmp8_);
		_g_free0 (name);
	}
	result = cs;
	_g_object_unref0 (it);
	return result;
}

gboolean
theme_matches (Theme* self,
               Theme* theme)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (theme != NULL, FALSE);
	_tmp1_ = self->priv->_name;
	_tmp2_ = theme->priv->_name;
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->_label;
		_tmp4_ = theme->priv->_name;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->_custom;
		if (_tmp5_) {
			GeeMapIterator* it = NULL;
			GeeHashMap* _tmp6_;
			GeeMapIterator* _tmp7_;
			gboolean _tmp23_;
			gboolean _tmp24_;
			_tmp6_ = self->priv->_colors;
			_tmp7_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp6_);
			it = _tmp7_;
			while (TRUE) {
				GeeMapIterator* _tmp8_;
				gchar* key = NULL;
				GeeMapIterator* _tmp9_;
				gpointer _tmp10_;
				gboolean _tmp11_ = FALSE;
				GeeHashMap* _tmp12_;
				const gchar* _tmp13_;
				_tmp8_ = it;
				if (!gee_map_iterator_next (_tmp8_)) {
					break;
				}
				_tmp9_ = it;
				_tmp10_ = gee_map_iterator_get_key (_tmp9_);
				key = (gchar*) _tmp10_;
				_tmp12_ = theme->priv->_colors;
				_tmp13_ = key;
				if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp12_, _tmp13_)) {
					_tmp11_ = TRUE;
				} else {
					GeeMapIterator* _tmp14_;
					gpointer _tmp15_;
					GdkRGBA* _tmp16_;
					GeeHashMap* _tmp17_;
					const gchar* _tmp18_;
					gpointer _tmp19_;
					GdkRGBA* _tmp20_;
					GdkRGBA _tmp21_;
					GdkRGBA _tmp22_;
					_tmp14_ = it;
					_tmp15_ = gee_map_iterator_get_value (_tmp14_);
					_tmp16_ = (GdkRGBA*) _tmp15_;
					_tmp17_ = theme->priv->_colors;
					_tmp18_ = key;
					_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, _tmp18_);
					_tmp20_ = (GdkRGBA*) _tmp19_;
					_tmp21_ = *_tmp16_;
					_tmp22_ = *_tmp20_;
					_tmp11_ = !gdk_rgba_equal (&_tmp21_, &_tmp22_);
					__vala_GdkRGBA_free0 (_tmp20_);
					__vala_GdkRGBA_free0 (_tmp16_);
				}
				if (_tmp11_) {
					result = FALSE;
					_g_free0 (key);
					_g_object_unref0 (it);
					return result;
				}
				_g_free0 (key);
			}
			_tmp23_ = self->priv->_prefer_dark;
			_tmp24_ = theme->priv->_prefer_dark;
			result = _tmp23_ == _tmp24_;
			_g_object_unref0 (it);
			return result;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
theme_set_color (Theme* self,
                 const gchar* name,
                 GdkRGBA* color)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (color != NULL, FALSE);
	_tmp0_ = self->priv->_colors;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, name)) {
		GeeHashMap* _tmp1_;
		GdkRGBA _tmp2_;
		_tmp1_ = self->priv->_colors;
		_tmp2_ = *color;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, name, &_tmp2_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

GdkRGBA*
theme_get_color (Theme* self,
                 const gchar* name)
{
	GeeHashMap* _tmp0_;
	GdkRGBA* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->_colors;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, name)) {
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->_colors;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, name);
		result = (GdkRGBA*) _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}

static gpointer
__vala_GdkRGBA_copy0 (gpointer self)
{
	return self ? _vala_GdkRGBA_copy (self) : NULL;
}

GdkRGBA*
theme_next_color (Theme* self)
{
	gint _tmp0_;
	gint _tmp3_;
	GdkRGBA _tmp4_ = {0};
	GdkRGBA* _tmp5_;
	GdkRGBA* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_index;
	if (_tmp0_ == -1) {
		theme_set_index (self, 0);
	} else {
		gboolean _tmp1_;
		_tmp1_ = self->priv->_rotate;
		if (_tmp1_) {
			gint _tmp2_;
			_tmp2_ = self->priv->_index;
			theme_set_index (self, (_tmp2_ + 1) % 8);
		}
	}
	_tmp3_ = self->priv->_index;
	theme_link_color (self, _tmp3_, &_tmp4_);
	_tmp5_ = __vala_GdkRGBA_copy0 (&_tmp4_);
	result = _tmp5_;
	return result;
}

gint
theme_num_link_colors (void)
{
	gint result;
	result = 8;
	return result;
}

void
theme_link_color (Theme* self,
                  gint index,
                  GdkRGBA* result)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gpointer _tmp3_;
	GdkRGBA* _tmp4_;
	GdkRGBA _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_colors;
	_tmp1_ = g_strdup_printf ("link_color%d", index % 8);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp2_);
	_tmp4_ = (GdkRGBA*) _tmp3_;
	_tmp5_ = *_tmp4_;
	__vala_GdkRGBA_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	*result = _tmp5_;
	return;
}

void
theme_random_link_color (Theme* self,
                         GdkRGBA* result)
{
	GRand* rand = NULL;
	GRand* _tmp0_;
	GeeHashMap* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gpointer _tmp4_;
	GdkRGBA* _tmp5_;
	GdkRGBA _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_rand_new ();
	rand = _tmp0_;
	_tmp1_ = self->priv->_colors;
	_tmp2_ = g_strdup_printf ("link_color%d", (gint) g_rand_int_range (rand, (gint32) 0, (gint32) 8));
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp3_);
	_tmp5_ = (GdkRGBA*) _tmp4_;
	_tmp6_ = *_tmp5_;
	__vala_GdkRGBA_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	*result = _tmp6_;
	_g_rand_free0 (rand);
	return;
}

gint
theme_get_color_index (Theme* self,
                       GdkRGBA* color)
{
	gchar* color_str = NULL;
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (color != NULL, 0);
	_tmp0_ = gdk_rgba_to_string (color);
	color_str = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GdkRGBA* lc = NULL;
				GdkRGBA _tmp3_ = {0};
				GdkRGBA* _tmp4_;
				gboolean _tmp5_ = FALSE;
				GdkRGBA* _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 8)) {
					break;
				}
				theme_link_color (self, i, &_tmp3_);
				_tmp4_ = __vala_GdkRGBA_copy0 (&_tmp3_);
				lc = _tmp4_;
				_tmp6_ = lc;
				if (_tmp6_ != NULL) {
					GdkRGBA* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					const gchar* _tmp10_;
					_tmp7_ = lc;
					_tmp8_ = gdk_rgba_to_string (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = color_str;
					_tmp5_ = g_strcmp0 (_tmp9_, _tmp10_) == 0;
					_g_free0 (_tmp9_);
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					result = i;
					__vala_GdkRGBA_free0 (lc);
					_g_free0 (color_str);
					return result;
				}
				__vala_GdkRGBA_free0 (lc);
			}
		}
	}
	result = -1;
	_g_free0 (color_str);
	return result;
}

void
theme_color_from_string (Theme* self,
                         const gchar* value,
                         GdkRGBA* result)
{
	GdkRGBA _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	utils_color_from_string (value, &_tmp0_);
	*result = _tmp0_;
	return;
}

GtkCssProvider*
theme_get_css_provider (Theme* self,
                        gint text_size)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GError* _inner_error0_ = NULL;
	GtkCssProvider* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		gchar* tv_size = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_;
		gchar* css_data = NULL;
		GdkRGBA* _tmp7_;
		GdkRGBA* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GdkRGBA* _tmp22_;
		GdkRGBA* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		GtkCssProvider* _tmp36_;
		if (text_size == -1) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup (".textfield { font: 1em \"Sans\" } ");
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp2_;
		} else {
			gchar* _tmp3_;
			_tmp3_ = g_strdup_printf (".textfield { font: %dpx \"Sans\"; } ", text_size);
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp3_;
		}
		_tmp4_ = g_strdup (_tmp1_);
		tv_size = _tmp4_;
		_tmp6_ = self->priv->_prefer_dark;
		if (_tmp6_) {
			_tmp5_ = "0.15";
		} else {
			_tmp5_ = "1.0";
		}
		_tmp7_ = theme_get_color (self, "background");
		_tmp8_ = _tmp7_;
		_tmp9_ = gdk_rgba_to_string (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat ("@define-color colorPrimary #603461; " "@define-color textColorPrimary @SILVER_100; " "@define-color colorAccent #603461; " "@define-color tab_base_color ", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp12_, ";", NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = tv_size;
		_tmp16_ = g_strconcat (_tmp14_, _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat (_tmp17_, ".theme-selected { background: #087DFF; } ", NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, ".canvas { background: ", NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = theme_get_color (self, "background");
		_tmp23_ = _tmp22_;
		_tmp24_ = gdk_rgba_to_string (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp21_, _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp27_, "; }", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp29_, ".highlighted { background: rgba(255, 255, 129, ", NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp31_, _tmp5_, NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strconcat (_tmp33_, "); }", NULL);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		__vala_GdkRGBA_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		__vala_GdkRGBA_free0 (_tmp8_);
		css_data = _tmp35_;
		_tmp36_ = provider;
		gtk_css_provider_load_from_data (_tmp36_, css_data, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (css_data);
			_g_free0 (tv_size);
			_g_free0 (_tmp1_);
			goto __catch0_g_error;
		}
		_g_free0 (css_data);
		_g_free0 (tv_size);
		_g_free0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp37_;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp37_ = stdout;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		fprintf (_tmp37_, _ ("Unable to load background color: %s"), _tmp39_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = provider;
	return result;
}

static void
theme_set_context_color (Theme* self,
                         cairo_t* ctx,
                         GdkRGBA* color)
{
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = *color;
	_tmp1_ = *color;
	_tmp2_ = *color;
	_tmp3_ = *color;
	cairo_set_source_rgba (ctx, _tmp0_.red, _tmp1_.green, _tmp2_.blue, _tmp3_.alpha);
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

gboolean
theme_load (Theme* self,
            xmlNode* n)
{
	gboolean contains_data = FALSE;
	gchar* nn = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* ll = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* idx = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GArray* cs = NULL;
	GArray* _tmp11_;
	gchar* d = NULL;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	contains_data = FALSE;
	_tmp0_ = (gchar*) xmlGetProp (n, (xmlChar*) "name");
	nn = _tmp0_;
	_tmp1_ = nn;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = nn;
		theme_set_name (self, _tmp2_);
	}
	_tmp3_ = (gchar*) xmlGetProp (n, (xmlChar*) "label");
	ll = _tmp3_;
	_tmp4_ = ll;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = ll;
		theme_set_label (self, _tmp5_);
	} else {
		const gchar* _tmp6_;
		_tmp6_ = nn;
		if (_tmp6_ != NULL) {
			const gchar* _tmp7_;
			_tmp7_ = nn;
			theme_set_label (self, _tmp7_);
		}
	}
	_tmp8_ = (gchar*) xmlGetProp (n, (xmlChar*) "index");
	idx = _tmp8_;
	_tmp9_ = idx;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		_tmp10_ = idx;
		theme_set_index (self, atoi (_tmp10_));
	}
	_tmp11_ = theme_colors (self);
	cs = _tmp11_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				GArray* _tmp14_;
				gchar* name = NULL;
				GArray* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* s = NULL;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				const gchar* _tmp20_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = cs;
				if (!(((guint) i) < _tmp14_->len)) {
					break;
				}
				_tmp15_ = cs;
				_tmp16_ = g_array_index (_tmp15_, gchar*, (guint) i);
				_tmp17_ = g_strdup (_tmp16_);
				name = _tmp17_;
				_tmp18_ = name;
				_tmp19_ = (gchar*) xmlGetProp (n, (xmlChar*) _tmp18_);
				s = _tmp19_;
				_tmp20_ = s;
				if (_tmp20_ != NULL) {
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					GdkRGBA _tmp23_ = {0};
					_tmp21_ = name;
					_tmp22_ = s;
					theme_color_from_string (self, _tmp22_, &_tmp23_);
					theme_set_color (self, _tmp21_, &_tmp23_);
					contains_data = TRUE;
				}
				_g_free0 (s);
				_g_free0 (name);
			}
		}
	}
	_tmp24_ = (gchar*) xmlGetProp (n, (xmlChar*) "prefer_dark");
	d = _tmp24_;
	_tmp25_ = d;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_;
		_tmp26_ = d;
		theme_set_prefer_dark (self, bool_parse (_tmp26_));
		contains_data = TRUE;
	}
	result = contains_data;
	_g_free0 (d);
	_g_array_unref0 (cs);
	_g_free0 (idx);
	_g_free0 (ll);
	_g_free0 (nn);
	return result;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

xmlNode*
theme_save (Theme* self)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp1_;
	const gchar* _tmp2_;
	xmlNode* _tmp3_;
	const gchar* _tmp4_;
	xmlNode* _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	xmlNode* _tmp29_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "theme");
	n = _tmp0_;
	_tmp1_ = n;
	_tmp2_ = self->priv->_name;
	xmlNewProp (_tmp1_, (xmlChar*) "name", (xmlChar*) _tmp2_);
	_tmp3_ = n;
	_tmp4_ = self->priv->_label;
	xmlNewProp (_tmp3_, (xmlChar*) "label", (xmlChar*) _tmp4_);
	_tmp5_ = n;
	_tmp6_ = self->priv->_index;
	_tmp7_ = g_strdup_printf ("%i", _tmp6_);
	_tmp8_ = _tmp7_;
	xmlNewProp (_tmp5_, (xmlChar*) "index", (xmlChar*) _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->priv->_custom;
	if (_tmp9_) {
		GArray* cs = NULL;
		GArray* _tmp10_;
		xmlNode* _tmp25_;
		gboolean _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp10_ = theme_colors (self);
		cs = _tmp10_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					GArray* _tmp13_;
					gchar* name = NULL;
					GArray* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					xmlNode* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					GdkRGBA* _tmp20_;
					GdkRGBA* _tmp21_;
					GdkRGBA _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = cs;
					if (!(((guint) i) < _tmp13_->len)) {
						break;
					}
					_tmp14_ = cs;
					_tmp15_ = g_array_index (_tmp14_, gchar*, (guint) i);
					_tmp16_ = g_strdup (_tmp15_);
					name = _tmp16_;
					_tmp17_ = n;
					_tmp18_ = name;
					_tmp19_ = name;
					_tmp20_ = theme_get_color (self, _tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = *_tmp21_;
					_tmp23_ = utils_color_from_rgba (&_tmp22_);
					_tmp24_ = _tmp23_;
					xmlNewProp (_tmp17_, (xmlChar*) _tmp18_, (xmlChar*) _tmp24_);
					_g_free0 (_tmp24_);
					__vala_GdkRGBA_free0 (_tmp21_);
					_g_free0 (name);
				}
			}
		}
		_tmp25_ = n;
		_tmp26_ = self->priv->_prefer_dark;
		_tmp27_ = bool_to_string (_tmp26_);
		_tmp28_ = _tmp27_;
		xmlNewProp (_tmp25_, (xmlChar*) "prefer_dark", (xmlChar*) _tmp28_);
		_g_free0 (_tmp28_);
		_g_array_unref0 (cs);
	}
	_tmp29_ = n;
	result = _tmp29_;
	return result;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

cairo_surface_t*
theme_make_icon (Theme* self)
{
	gint side = 0;
	gint nrad = 0;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_;
	cairo_t* ctx = NULL;
	cairo_surface_t* _tmp1_;
	cairo_t* _tmp2_;
	gint hside = 0;
	gdouble ypos[6] = {0};
	gint width = 0;
	gint height = 0;
	PangoFontDescription* font_desc = NULL;
	PangoFontDescription* _tmp3_;
	PangoFontDescription* _tmp4_;
	PangoFontDescription* _tmp5_;
	cairo_t* _tmp6_;
	GdkRGBA* _tmp7_;
	GdkRGBA* _tmp8_;
	GdkRGBA _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	PangoLayout* root_text = NULL;
	cairo_t* _tmp12_;
	PangoLayout* _tmp13_;
	PangoLayout* _tmp14_;
	PangoFontDescription* _tmp15_;
	PangoLayout* _tmp16_;
	PangoLayout* _tmp17_;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint rrad = 0;
	gint hspace = 0;
	gint vspace = 0;
	cairo_t* _tmp20_;
	GdkRGBA* _tmp21_;
	GdkRGBA* _tmp22_;
	GdkRGBA _tmp23_;
	cairo_t* _tmp24_;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	GdkRGBA* _tmp27_;
	GdkRGBA* _tmp28_;
	GdkRGBA _tmp29_;
	cairo_t* _tmp30_;
	cairo_t* _tmp31_;
	PangoLayout* _tmp32_;
	cairo_t* _tmp41_;
	GdkRGBA* _tmp42_;
	GdkRGBA* _tmp43_;
	GdkRGBA _tmp44_;
	gdouble p[6] = {0};
	gdouble _tmp45_;
	gdouble _tmp46_;
	cairo_t* _tmp47_;
	cairo_t* _tmp48_;
	gdouble* _tmp49_;
	gdouble* _tmp50_;
	gint _tmp50__length1;
	cairo_t* _tmp51_;
	gdouble _tmp52_;
	gdouble _tmp53_;
	cairo_t* _tmp54_;
	gdouble _tmp55_;
	gdouble _tmp56_;
	gdouble _tmp57_;
	gdouble _tmp58_;
	gdouble _tmp59_;
	gdouble _tmp60_;
	gdouble _tmp61_;
	gdouble _tmp62_;
	gdouble _tmp63_;
	gdouble _tmp64_;
	cairo_t* _tmp65_;
	cairo_t* _tmp66_;
	gdouble _tmp67_;
	gdouble _tmp68_;
	gdouble _tmp69_;
	gdouble _tmp70_;
	cairo_t* _tmp71_;
	gdouble _tmp72_;
	gdouble _tmp73_;
	gdouble _tmp74_;
	gdouble _tmp75_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	side = 140;
	nrad = 15;
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, side, side);
	surface = _tmp0_;
	_tmp1_ = surface;
	_tmp2_ = cairo_create (_tmp1_);
	ctx = _tmp2_;
	hside = side / 2;
	_tmp3_ = pango_font_description_new ();
	font_desc = _tmp3_;
	_tmp4_ = font_desc;
	pango_font_description_set_family (_tmp4_, "Sans");
	_tmp5_ = font_desc;
	pango_font_description_set_size (_tmp5_, 11 * PANGO_SCALE);
	_tmp6_ = ctx;
	_tmp7_ = theme_get_color (self, "background");
	_tmp8_ = _tmp7_;
	_tmp9_ = *_tmp8_;
	theme_set_context_color (self, _tmp6_, &_tmp9_);
	__vala_GdkRGBA_free0 (_tmp8_);
	_tmp10_ = ctx;
	cairo_rectangle (_tmp10_, (gdouble) 0, (gdouble) 0, (gdouble) side, (gdouble) side);
	_tmp11_ = ctx;
	cairo_fill (_tmp11_);
	_tmp12_ = ctx;
	_tmp13_ = pango_cairo_create_layout (_tmp12_);
	root_text = _tmp13_;
	_tmp14_ = root_text;
	_tmp15_ = font_desc;
	pango_layout_set_font_description (_tmp14_, _tmp15_);
	_tmp16_ = root_text;
	pango_layout_set_text (_tmp16_, _ ("Root"), -1);
	_tmp17_ = root_text;
	pango_layout_get_pixel_size (_tmp17_, &_tmp18_, &_tmp19_);
	width = _tmp18_;
	height = _tmp19_;
	rrad = (width + 20) / 2;
	hspace = (((side - (rrad * 2)) - (nrad * 4)) / 4) + nrad;
	vspace = ((side - (nrad * 6)) / 4) + nrad;
	ypos[3] = (gdouble) vspace;
	ypos[0] = ypos[3];
	ypos[4] = (gdouble) (side / 2);
	ypos[1] = ypos[4];
	ypos[5] = (gdouble) (side - vspace);
	ypos[2] = ypos[5];
	_tmp20_ = ctx;
	_tmp21_ = theme_get_color (self, "root_background");
	_tmp22_ = _tmp21_;
	_tmp23_ = *_tmp22_;
	theme_set_context_color (self, _tmp20_, &_tmp23_);
	__vala_GdkRGBA_free0 (_tmp22_);
	_tmp24_ = ctx;
	cairo_arc (_tmp24_, (gdouble) hside, (gdouble) hside, (gdouble) rrad, (gdouble) 0, 2 * G_PI);
	_tmp25_ = ctx;
	cairo_fill (_tmp25_);
	_tmp26_ = ctx;
	_tmp27_ = theme_get_color (self, "root_foreground");
	_tmp28_ = _tmp27_;
	_tmp29_ = *_tmp28_;
	theme_set_context_color (self, _tmp26_, &_tmp29_);
	__vala_GdkRGBA_free0 (_tmp28_);
	_tmp30_ = ctx;
	cairo_move_to (_tmp30_, (gdouble) (hside - (width / 2)), (gdouble) (hside - (height / 2)));
	_tmp31_ = ctx;
	_tmp32_ = root_text;
	pango_cairo_show_layout (_tmp31_, _tmp32_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp33_ = FALSE;
			_tmp33_ = TRUE;
			while (TRUE) {
				cairo_t* _tmp35_;
				GdkRGBA _tmp36_ = {0};
				gint _tmp37_ = 0;
				cairo_t* _tmp38_;
				gdouble _tmp39_;
				cairo_t* _tmp40_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				if (!(i < 6)) {
					break;
				}
				_tmp35_ = ctx;
				theme_link_color (self, i, &_tmp36_);
				theme_set_context_color (self, _tmp35_, &_tmp36_);
				if (i < 3) {
					_tmp37_ = hspace;
				} else {
					_tmp37_ = side - hspace;
				}
				_tmp38_ = ctx;
				_tmp39_ = ypos[i];
				cairo_arc (_tmp38_, (gdouble) _tmp37_, _tmp39_, (gdouble) nrad, (gdouble) 0, 2 * G_PI);
				_tmp40_ = ctx;
				cairo_fill (_tmp40_);
			}
		}
	}
	_tmp41_ = ctx;
	_tmp42_ = theme_get_color (self, "connection_background");
	_tmp43_ = _tmp42_;
	_tmp44_ = *_tmp43_;
	theme_set_context_color (self, _tmp41_, &_tmp44_);
	__vala_GdkRGBA_free0 (_tmp43_);
	p[0] = (gdouble) ((hspace + nrad) + 2);
	p[1] = (gdouble) (vspace + 2);
	p[2] = (gdouble) hside;
	_tmp45_ = p[1];
	p[3] = _tmp45_ - nrad;
	p[4] = (gdouble) (side - ((hspace + nrad) + 2));
	_tmp46_ = p[1];
	p[5] = _tmp46_;
	_tmp47_ = ctx;
	cairo_set_line_width (_tmp47_, (gdouble) 2);
	_tmp48_ = ctx;
	_tmp49_ = g_new0 (gdouble, 2);
	_tmp49_[0] = (gdouble) 3;
	_tmp49_[1] = (gdouble) 5;
	_tmp50_ = _tmp49_;
	_tmp50__length1 = 2;
	cairo_set_dash (_tmp48_, _tmp50_, (gint) 2, (gdouble) 0);
	_tmp50_ = (g_free (_tmp50_), NULL);
	_tmp51_ = ctx;
	_tmp52_ = p[0];
	_tmp53_ = p[1];
	cairo_move_to (_tmp51_, _tmp52_, _tmp53_);
	_tmp54_ = ctx;
	_tmp55_ = p[2];
	_tmp56_ = p[0];
	_tmp57_ = p[3];
	_tmp58_ = p[1];
	_tmp59_ = p[2];
	_tmp60_ = p[4];
	_tmp61_ = p[3];
	_tmp62_ = p[5];
	_tmp63_ = p[4];
	_tmp64_ = p[5];
	cairo_curve_to (_tmp54_, ((2.0 / 3.0) * _tmp55_) + ((1.0 / 3.0) * _tmp56_), ((2.0 / 3.0) * _tmp57_) + ((1.0 / 3.0) * _tmp58_), ((2.0 / 3.0) * _tmp59_) + ((1.0 / 3.0) * _tmp60_), ((2.0 / 3.0) * _tmp61_) + ((1.0 / 3.0) * _tmp62_), _tmp63_, _tmp64_);
	_tmp65_ = ctx;
	cairo_stroke (_tmp65_);
	_tmp66_ = ctx;
	_tmp67_ = p[0];
	_tmp68_ = p[1];
	_tmp69_ = p[2];
	_tmp70_ = p[3];
	connection_draw_arrow (_tmp66_, 2, _tmp67_, _tmp68_, _tmp69_, _tmp70_, (gdouble) 7);
	_tmp71_ = ctx;
	_tmp72_ = p[4];
	_tmp73_ = p[5];
	_tmp74_ = p[2];
	_tmp75_ = p[3];
	connection_draw_arrow (_tmp71_, 2, _tmp72_, _tmp73_, _tmp74_, _tmp75_, (gdouble) 7);
	result = surface;
	_g_object_unref0 (root_text);
	__vala_PangoFontDescription_free0 (font_desc);
	_cairo_destroy0 (ctx);
	return result;
}

const gchar*
theme_get_name (Theme* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
theme_set_name (Theme* self,
                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = theme_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, theme_properties[THEME_NAME_PROPERTY]);
	}
}

const gchar*
theme_get_label (Theme* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

void
theme_set_label (Theme* self,
                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = theme_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, theme_properties[THEME_LABEL_PROPERTY]);
	}
}

gint
theme_get_index (Theme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_index;
	return result;
}

void
theme_set_index (Theme* self,
                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = theme_get_index (self);
	if (old_value != value) {
		self->priv->_index = value;
		g_object_notify_by_pspec ((GObject *) self, theme_properties[THEME_INDEX_PROPERTY]);
	}
}

gboolean
theme_get_prefer_dark (Theme* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prefer_dark;
	return result;
}

void
theme_set_prefer_dark (Theme* self,
                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = theme_get_prefer_dark (self);
	if (old_value != value) {
		self->priv->_prefer_dark = value;
		g_object_notify_by_pspec ((GObject *) self, theme_properties[THEME_PREFER_DARK_PROPERTY]);
	}
}

gboolean
theme_get_custom (Theme* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_custom;
	return result;
}

void
theme_set_custom (Theme* self,
                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = theme_get_custom (self);
	if (old_value != value) {
		self->priv->_custom = value;
		g_object_notify_by_pspec ((GObject *) self, theme_properties[THEME_CUSTOM_PROPERTY]);
	}
}

gboolean
theme_get_temporary (Theme* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_temporary;
	return result;
}

void
theme_set_temporary (Theme* self,
                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = theme_get_temporary (self);
	if (old_value != value) {
		self->priv->_temporary = value;
		g_object_notify_by_pspec ((GObject *) self, theme_properties[THEME_TEMPORARY_PROPERTY]);
	}
}

gboolean
theme_get_rotate (Theme* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_rotate;
	return result;
}

void
theme_set_rotate (Theme* self,
                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = theme_get_rotate (self);
	if (old_value != value) {
		self->priv->_rotate = value;
		g_object_notify_by_pspec ((GObject *) self, theme_properties[THEME_ROTATE_PROPERTY]);
	}
}

static void
theme_class_init (ThemeClass * klass,
                  gpointer klass_data)
{
	theme_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Theme_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_theme_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_theme_set_property;
	G_OBJECT_CLASS (klass)->finalize = theme_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_NAME_PROPERTY, theme_properties[THEME_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_LABEL_PROPERTY, theme_properties[THEME_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_INDEX_PROPERTY, theme_properties[THEME_INDEX_PROPERTY] = g_param_spec_int ("index", "index", "index", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_PREFER_DARK_PROPERTY, theme_properties[THEME_PREFER_DARK_PROPERTY] = g_param_spec_boolean ("prefer-dark", "prefer-dark", "prefer-dark", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_CUSTOM_PROPERTY, theme_properties[THEME_CUSTOM_PROPERTY] = g_param_spec_boolean ("custom", "custom", "custom", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_TEMPORARY_PROPERTY, theme_properties[THEME_TEMPORARY_PROPERTY] = g_param_spec_boolean ("temporary", "temporary", "temporary", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_ROTATE_PROPERTY, theme_properties[THEME_ROTATE_PROPERTY] = g_param_spec_boolean ("rotate", "rotate", "rotate", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
theme_instance_init (Theme * self,
                     gpointer klass)
{
	self->priv = theme_get_instance_private (self);
	self->priv->_index = -1;
	self->priv->_prefer_dark = FALSE;
	self->priv->_custom = TRUE;
	self->priv->_temporary = FALSE;
	self->priv->_rotate = TRUE;
}

static void
theme_finalize (GObject * obj)
{
	Theme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEME, Theme);
	_g_object_unref0 (self->priv->_colors);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_label);
	G_OBJECT_CLASS (theme_parent_class)->finalize (obj);
}

static GType
theme_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Theme), 0, (GInstanceInitFunc) theme_instance_init, NULL };
	GType theme_type_id;
	theme_type_id = g_type_register_static (G_TYPE_OBJECT, "Theme", &g_define_type_info, 0);
	Theme_private_offset = g_type_add_instance_private (theme_type_id, sizeof (ThemePrivate));
	return theme_type_id;
}

GType
theme_get_type (void)
{
	static volatile gsize theme_type_id__once = 0;
	if (g_once_init_enter (&theme_type_id__once)) {
		GType theme_type_id;
		theme_type_id = theme_get_type_once ();
		g_once_init_leave (&theme_type_id__once, theme_type_id);
	}
	return theme_type_id__once;
}

static void
_vala_theme_get_property (GObject * object,
                          guint property_id,
                          GValue * value,
                          GParamSpec * pspec)
{
	Theme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THEME, Theme);
	switch (property_id) {
		case THEME_NAME_PROPERTY:
		g_value_set_string (value, theme_get_name (self));
		break;
		case THEME_LABEL_PROPERTY:
		g_value_set_string (value, theme_get_label (self));
		break;
		case THEME_INDEX_PROPERTY:
		g_value_set_int (value, theme_get_index (self));
		break;
		case THEME_PREFER_DARK_PROPERTY:
		g_value_set_boolean (value, theme_get_prefer_dark (self));
		break;
		case THEME_CUSTOM_PROPERTY:
		g_value_set_boolean (value, theme_get_custom (self));
		break;
		case THEME_TEMPORARY_PROPERTY:
		g_value_set_boolean (value, theme_get_temporary (self));
		break;
		case THEME_ROTATE_PROPERTY:
		g_value_set_boolean (value, theme_get_rotate (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_theme_set_property (GObject * object,
                          guint property_id,
                          const GValue * value,
                          GParamSpec * pspec)
{
	Theme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THEME, Theme);
	switch (property_id) {
		case THEME_NAME_PROPERTY:
		theme_set_name (self, g_value_get_string (value));
		break;
		case THEME_LABEL_PROPERTY:
		theme_set_label (self, g_value_get_string (value));
		break;
		case THEME_INDEX_PROPERTY:
		theme_set_index (self, g_value_get_int (value));
		break;
		case THEME_PREFER_DARK_PROPERTY:
		theme_set_prefer_dark (self, g_value_get_boolean (value));
		break;
		case THEME_CUSTOM_PROPERTY:
		theme_set_custom (self, g_value_get_boolean (value));
		break;
		case THEME_TEMPORARY_PROPERTY:
		theme_set_temporary (self, g_value_get_boolean (value));
		break;
		case THEME_ROTATE_PROPERTY:
		theme_set_rotate (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

