/* Partitioner.c generated by valac 0.56.18, the Vala compiler
 * generated from Partitioner.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/
/*
 This class stores a pointer to a node to partition as well as its pixel size
 that is used for balancing purposes.
*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PART_NODE (part_node_get_type ())
#define PART_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PART_NODE, PartNode))
#define PART_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PART_NODE, PartNodeClass))
#define IS_PART_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PART_NODE))
#define IS_PART_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PART_NODE))
#define PART_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PART_NODE, PartNodeClass))

typedef struct _PartNode PartNode;
typedef struct _PartNodeClass PartNodeClass;
typedef struct _PartNodePrivate PartNodePrivate;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
enum  {
	PART_NODE_0_PROPERTY,
	PART_NODE_NUM_PROPERTIES
};
static GParamSpec* part_node_properties[PART_NODE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_NODE_BOUNDS (node_bounds_get_type ())
#define NODE_BOUNDS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_BOUNDS, NodeBounds))
#define NODE_BOUNDS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_BOUNDS, NodeBoundsClass))
#define IS_NODE_BOUNDS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_BOUNDS))
#define IS_NODE_BOUNDS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_BOUNDS))
#define NODE_BOUNDS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_BOUNDS, NodeBoundsClass))

typedef struct _NodeBounds NodeBounds;
typedef struct _NodeBoundsClass NodeBoundsClass;
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())
#define _node_bounds_unref0(var) ((var == NULL) ? NULL : (var = (node_bounds_unref (var), NULL)))

#define TYPE_LAYOUT (layout_get_type ())
#define LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUT, Layout))
#define LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUT, LayoutClass))
#define IS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUT))
#define IS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUT))
#define LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUT, LayoutClass))

typedef struct _Layout Layout;
typedef struct _LayoutClass LayoutClass;

#define TYPE_PARTITIONER (partitioner_get_type ())
#define PARTITIONER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARTITIONER, Partitioner))
#define PARTITIONER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARTITIONER, PartitionerClass))
#define IS_PARTITIONER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARTITIONER))
#define IS_PARTITIONER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARTITIONER))
#define PARTITIONER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARTITIONER, PartitionerClass))

typedef struct _Partitioner Partitioner;
typedef struct _PartitionerClass PartitionerClass;
typedef struct _PartitionerPrivate PartitionerPrivate;
enum  {
	PARTITIONER_0_PROPERTY,
	PARTITIONER_NUM_PROPERTIES
};
static GParamSpec* partitioner_properties[PARTITIONER_NUM_PROPERTIES];
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _Block33Data Block33Data;

struct _PartNode {
	GObject parent_instance;
	PartNodePrivate * priv;
};

struct _PartNodeClass {
	GObjectClass parent_class;
};

struct _PartNodePrivate {
	Node* _node;
	gdouble _size;
};

struct _Partitioner {
	GObject parent_instance;
	PartitionerPrivate * priv;
};

struct _PartitionerClass {
	GObjectClass parent_class;
	void (*partition) (Partitioner* self, Node* root, GSList* data);
};

struct _Block33Data {
	int _ref_count_;
	Partitioner* self;
	gdouble sum0;
	gdouble sum1;
	gint size0;
	gint last_side;
	Node* root;
};

static gint PartNode_private_offset;
static gpointer part_node_parent_class = NULL;
static gpointer partitioner_parent_class = NULL;

VALA_EXTERN GType part_node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PartNode, g_object_unref)
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN PartNode* part_node_new (Node* n);
VALA_EXTERN PartNode* part_node_construct (GType object_type,
                               Node* n);
VALA_EXTERN gpointer node_bounds_ref (gpointer instance);
VALA_EXTERN void node_bounds_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_bounds (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_node_bounds (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_node_bounds (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_node_bounds (const GValue* value);
VALA_EXTERN GType node_bounds_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeBounds, node_bounds_unref)
VALA_EXTERN NodeBounds* node_get_tree_bbox (Node* self);
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NodeSide node_get_side (Node* self);
VALA_EXTERN gdouble node_bounds_get_height (NodeBounds* self);
VALA_EXTERN gdouble node_bounds_get_width (NodeBounds* self);
VALA_EXTERN gdouble part_node_size (PartNode* self);
VALA_EXTERN Node* part_node_node (PartNode* self);
VALA_EXTERN void part_node_update_node (PartNode* self,
                            Node* root,
                            gint index,
                            gint side);
VALA_EXTERN void node_set_side (Node* self,
                    NodeSide value);
VALA_EXTERN GType layout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layout, g_object_unref)
VALA_EXTERN Layout* node_get_layout (Node* self);
VALA_EXTERN void layout_propagate_side (Layout* self,
                            Node* parent,
                            NodeSide side);
VALA_EXTERN void node_attach_init (Node* self,
                       Node* parent,
                       gint index);
static void part_node_finalize (GObject * obj);
static GType part_node_get_type_once (void);
VALA_EXTERN GType partitioner_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Partitioner, g_object_unref)
VALA_EXTERN void partitioner_partition (Partitioner* self,
                            Node* root,
                            GSList* data);
VALA_EXTERN Partitioner* partitioner_new (void);
VALA_EXTERN Partitioner* partitioner_construct (GType object_type);
VALA_EXTERN void partitioner_partition_node (Partitioner* self,
                                 Node* root);
VALA_EXTERN GArray* node_children (Node* self);
static gint ___lambda82_ (PartNode* a,
                   PartNode* b);
VALA_EXTERN gint node_id (Node* self);
static gint ____lambda82__gcompare_func (gconstpointer a,
                                  gconstpointer b);
static gint ___lambda83_ (PartNode* a,
                   PartNode* b);
static gint ____lambda83__gcompare_func (gconstpointer a,
                                  gconstpointer b);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void partitioner_real_partition (Partitioner* self,
                                 Node* root,
                                 GSList* data);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
static void __lambda84_ (Partitioner* self,
                  PartNode* item);
VALA_EXTERN void node_detach (Node* self,
                  NodeSide side);
static void ___lambda84__gfunc (gconstpointer data,
                         gpointer self);
static void __lambda85_ (Block33Data* _data33_,
                  PartNode* item);
VALA_EXTERN gboolean node_is_summarized (Node* self);
VALA_EXTERN gboolean node_first_summarized (Node* self);
static void ___lambda85__gfunc (gconstpointer data,
                         gpointer self);
static GType partitioner_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
part_node_get_instance_private (PartNode* self)
{
	return G_STRUCT_MEMBER_P (self, PartNode_private_offset);
}

static gpointer
_node_bounds_ref0 (gpointer self)
{
	return self ? node_bounds_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PartNode*
part_node_construct (GType object_type,
                     Node* n)
{
	PartNode * self = NULL;
	NodeBounds* nb = NULL;
	NodeBounds* _tmp0_;
	NodeBounds* _tmp1_;
	NodeBounds* _tmp2_;
	gboolean _tmp3_ = FALSE;
	NodeSide _tmp4_;
	NodeSide _tmp5_;
	Node* _tmp14_;
	g_return_val_if_fail (n != NULL, NULL);
	self = (PartNode*) g_object_new (object_type, NULL);
	_tmp0_ = node_get_tree_bbox (n);
	_tmp1_ = _tmp0_;
	_tmp2_ = _node_bounds_ref0 (_tmp1_);
	nb = _tmp2_;
	_tmp4_ = node_get_side (n);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NODE_SIDE_LEFT) {
		_tmp3_ = TRUE;
	} else {
		NodeSide _tmp6_;
		NodeSide _tmp7_;
		_tmp6_ = node_get_side (n);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ == NODE_SIDE_RIGHT;
	}
	if (_tmp3_) {
		NodeBounds* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		_tmp8_ = nb;
		_tmp9_ = node_bounds_get_height (_tmp8_);
		_tmp10_ = _tmp9_;
		self->priv->_size = _tmp10_;
	} else {
		NodeBounds* _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
		_tmp11_ = nb;
		_tmp12_ = node_bounds_get_width (_tmp11_);
		_tmp13_ = _tmp12_;
		self->priv->_size = _tmp13_;
	}
	_tmp14_ = _g_object_ref0 (n);
	_g_object_unref0 (self->priv->_node);
	self->priv->_node = _tmp14_;
	_node_bounds_unref0 (nb);
	return self;
}

PartNode*
part_node_new (Node* n)
{
	return part_node_construct (TYPE_PART_NODE, n);
}

gdouble
part_node_size (PartNode* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_size;
	return result;
}

Node*
part_node_node (PartNode* self)
{
	Node* _tmp0_;
	Node* _tmp1_;
	Node* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_node;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
part_node_update_node (PartNode* self,
                       Node* root,
                       gint index,
                       gint side)
{
	NodeSide orig_side = 0;
	Node* _tmp0_;
	NodeSide _tmp1_;
	NodeSide _tmp2_;
	gboolean _tmp3_ = FALSE;
	Node* _tmp4_;
	NodeSide _tmp5_;
	NodeSide _tmp6_;
	Node* _tmp14_;
	NodeSide _tmp15_;
	NodeSide _tmp16_;
	Node* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	_tmp0_ = self->priv->_node;
	_tmp1_ = node_get_side (_tmp0_);
	_tmp2_ = _tmp1_;
	orig_side = _tmp2_;
	_tmp4_ = self->priv->_node;
	_tmp5_ = node_get_side (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NODE_SIDE_LEFT) {
		_tmp3_ = TRUE;
	} else {
		Node* _tmp7_;
		NodeSide _tmp8_;
		NodeSide _tmp9_;
		_tmp7_ = self->priv->_node;
		_tmp8_ = node_get_side (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = _tmp9_ == NODE_SIDE_RIGHT;
	}
	if (_tmp3_) {
		NodeSide _tmp10_ = 0;
		Node* _tmp11_;
		if (side == 0) {
			_tmp10_ = NODE_SIDE_LEFT;
		} else {
			_tmp10_ = NODE_SIDE_RIGHT;
		}
		_tmp11_ = self->priv->_node;
		node_set_side (_tmp11_, _tmp10_);
	} else {
		NodeSide _tmp12_ = 0;
		Node* _tmp13_;
		if (side == 0) {
			_tmp12_ = NODE_SIDE_TOP;
		} else {
			_tmp12_ = NODE_SIDE_BOTTOM;
		}
		_tmp13_ = self->priv->_node;
		node_set_side (_tmp13_, _tmp12_);
	}
	_tmp14_ = self->priv->_node;
	_tmp15_ = node_get_side (_tmp14_);
	_tmp16_ = _tmp15_;
	if (orig_side != _tmp16_) {
		Node* _tmp17_;
		Layout* _tmp18_;
		Layout* _tmp19_;
		Node* _tmp20_;
		Node* _tmp21_;
		NodeSide _tmp22_;
		NodeSide _tmp23_;
		_tmp17_ = self->priv->_node;
		_tmp18_ = node_get_layout (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->_node;
		_tmp21_ = self->priv->_node;
		_tmp22_ = node_get_side (_tmp21_);
		_tmp23_ = _tmp22_;
		layout_propagate_side (_tmp19_, _tmp20_, _tmp23_);
	}
	_tmp24_ = self->priv->_node;
	node_attach_init (_tmp24_, root, index);
}

static void
part_node_class_init (PartNodeClass * klass,
                      gpointer klass_data)
{
	part_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PartNode_private_offset);
	G_OBJECT_CLASS (klass)->finalize = part_node_finalize;
}

static void
part_node_instance_init (PartNode * self,
                         gpointer klass)
{
	self->priv = part_node_get_instance_private (self);
	self->priv->_node = NULL;
}

static void
part_node_finalize (GObject * obj)
{
	PartNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PART_NODE, PartNode);
	_g_object_unref0 (self->priv->_node);
	G_OBJECT_CLASS (part_node_parent_class)->finalize (obj);
}

static GType
part_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PartNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) part_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PartNode), 0, (GInstanceInitFunc) part_node_instance_init, NULL };
	GType part_node_type_id;
	part_node_type_id = g_type_register_static (G_TYPE_OBJECT, "PartNode", &g_define_type_info, 0);
	PartNode_private_offset = g_type_add_instance_private (part_node_type_id, sizeof (PartNodePrivate));
	return part_node_type_id;
}

GType
part_node_get_type (void)
{
	static volatile gsize part_node_type_id__once = 0;
	if (g_once_init_enter (&part_node_type_id__once)) {
		GType part_node_type_id;
		part_node_type_id = part_node_get_type_once ();
		g_once_init_leave (&part_node_type_id__once, part_node_type_id);
	}
	return part_node_type_id__once;
}

Partitioner*
partitioner_construct (GType object_type)
{
	Partitioner * self = NULL;
	self = (Partitioner*) g_object_new (object_type, NULL);
	return self;
}

Partitioner*
partitioner_new (void)
{
	return partitioner_construct (TYPE_PARTITIONER);
}

static gint
___lambda82_ (PartNode* a,
              PartNode* b)
{
	gint _tmp0_ = 0;
	Node* _tmp1_;
	Node* _tmp2_;
	Node* _tmp3_;
	Node* _tmp4_;
	gboolean _tmp5_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp1_ = part_node_node (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = part_node_node (b);
	_tmp4_ = _tmp3_;
	_tmp5_ = node_id (_tmp2_) < node_id (_tmp4_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = -1;
	}
	result = _tmp0_;
	return result;
}

static gint
____lambda82__gcompare_func (gconstpointer a,
                             gconstpointer b)
{
	gint result;
	result = ___lambda82_ ((PartNode*) a, (PartNode*) b);
	return result;
}

static gint
___lambda83_ (PartNode* a,
              PartNode* b)
{
	gint _tmp0_ = 0;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (part_node_size (a) < part_node_size (b)) {
		_tmp0_ = 1;
	} else {
		gint _tmp1_ = 0;
		if (part_node_size (a) == part_node_size (b)) {
			_tmp1_ = 0;
		} else {
			_tmp1_ = -1;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}

static gint
____lambda83__gcompare_func (gconstpointer a,
                             gconstpointer b)
{
	gint result;
	result = ___lambda83_ ((PartNode*) a, (PartNode*) b);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
partitioner_partition_node (Partitioner* self,
                            Node* root)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	_tmp0_ = node_children (root);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->len > ((guint) 2);
	_g_array_unref0 (_tmp1_);
	if (_tmp2_) {
		GSList* data = NULL;
		GCompareFunc pn_cmp1 = NULL;
		GCompareFunc pn_cmp2 = NULL;
		GCompareFunc _tmp17_;
		GCompareFunc _tmp18_;
		GSList* _tmp19_;
		data = NULL;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					GArray* _tmp5_;
					GArray* _tmp6_;
					gboolean _tmp7_;
					Node* node = NULL;
					GArray* _tmp8_;
					GArray* _tmp9_;
					Node* _tmp10_;
					Node* _tmp11_;
					Node* _tmp12_;
					PartNode* pn = NULL;
					Node* _tmp13_;
					PartNode* _tmp14_;
					PartNode* _tmp15_;
					PartNode* _tmp16_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = node_children (root);
					_tmp6_ = _tmp5_;
					_tmp7_ = !(((guint) i) < _tmp6_->len);
					_g_array_unref0 (_tmp6_);
					if (_tmp7_) {
						break;
					}
					_tmp8_ = node_children (root);
					_tmp9_ = _tmp8_;
					_tmp10_ = g_array_index (_tmp9_, Node*, (guint) i);
					_tmp11_ = _g_object_ref0 (_tmp10_);
					_tmp12_ = _tmp11_;
					_g_array_unref0 (_tmp9_);
					node = _tmp12_;
					_tmp13_ = node;
					_tmp14_ = part_node_new (_tmp13_);
					pn = _tmp14_;
					_tmp15_ = pn;
					_tmp16_ = _g_object_ref0 (_tmp15_);
					data = g_slist_append (data, _tmp16_);
					_g_object_unref0 (pn);
					_g_object_unref0 (node);
				}
			}
		}
		pn_cmp1 = ____lambda82__gcompare_func;
		pn_cmp2 = ____lambda83__gcompare_func;
		_tmp17_ = pn_cmp1;
		data = g_slist_sort (data, _tmp17_);
		_tmp18_ = pn_cmp2;
		data = g_slist_sort (data, _tmp18_);
		_tmp19_ = data;
		partitioner_partition (self, root, _tmp19_);
		(data == NULL) ? NULL : (data = (_g_slist_free__g_object_unref0_ (data), NULL));
	}
}

static Block33Data*
block33_data_ref (Block33Data* _data33_)
{
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}

static void
block33_data_unref (void * _userdata_)
{
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		Partitioner* self;
		self = _data33_->self;
		_g_object_unref0 (_data33_->root);
		_g_object_unref0 (self);
		g_slice_free (Block33Data, _data33_);
	}
}

static void
__lambda84_ (Partitioner* self,
             PartNode* item)
{
	Node* _tmp0_;
	Node* _tmp1_;
	Node* _tmp2_;
	Node* _tmp3_;
	NodeSide _tmp4_;
	NodeSide _tmp5_;
	g_return_if_fail (item != NULL);
	_tmp0_ = part_node_node (item);
	_tmp1_ = _tmp0_;
	_tmp2_ = part_node_node (item);
	_tmp3_ = _tmp2_;
	_tmp4_ = node_get_side (_tmp3_);
	_tmp5_ = _tmp4_;
	node_detach (_tmp1_, _tmp5_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
}

static void
___lambda84__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda84_ ((Partitioner*) self, (PartNode*) data);
}

static void
__lambda85_ (Block33Data* _data33_,
             PartNode* item)
{
	Partitioner* self;
	gboolean _tmp0_ = FALSE;
	Node* _tmp1_;
	Node* _tmp2_;
	gboolean _tmp3_;
	gboolean place_node = FALSE;
	gboolean _tmp6_ = FALSE;
	self = _data33_->self;
	g_return_if_fail (item != NULL);
	_tmp1_ = part_node_node (item);
	_tmp2_ = _tmp1_;
	_tmp3_ = !node_is_summarized (_tmp2_);
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Node* _tmp4_;
		Node* _tmp5_;
		_tmp4_ = part_node_node (item);
		_tmp5_ = _tmp4_;
		_tmp0_ = node_first_summarized (_tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	place_node = _tmp0_;
	if (place_node) {
		_tmp6_ = _data33_->sum0 < _data33_->sum1;
	} else {
		_tmp6_ = _data33_->last_side == 0;
	}
	if (_tmp6_) {
		gint _tmp7_;
		_data33_->sum0 += part_node_size (item);
		part_node_update_node (item, _data33_->root, _data33_->size0, 0);
		_tmp7_ = _data33_->size0;
		_data33_->size0 = _tmp7_ + 1;
		_data33_->last_side = 0;
	} else {
		_data33_->sum1 += part_node_size (item);
		part_node_update_node (item, _data33_->root, -1, 1);
		_data33_->last_side = 1;
	}
}

static void
___lambda85__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda85_ (self, (PartNode*) data);
}

static void
partitioner_real_partition (Partitioner* self,
                            Node* root,
                            GSList* data)
{
	Block33Data* _data33_;
	Node* _tmp0_;
	g_return_if_fail (root != NULL);
	_data33_ = g_slice_new0 (Block33Data);
	_data33_->_ref_count_ = 1;
	_data33_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (root);
	_g_object_unref0 (_data33_->root);
	_data33_->root = _tmp0_;
	_data33_->sum0 = (gdouble) 0;
	_data33_->sum1 = (gdouble) 0;
	_data33_->size0 = 0;
	g_slist_foreach (data, ___lambda84__gfunc, self);
	_data33_->last_side = -1;
	g_slist_foreach (data, ___lambda85__gfunc, _data33_);
	block33_data_unref (_data33_);
	_data33_ = NULL;
}

void
partitioner_partition (Partitioner* self,
                       Node* root,
                       GSList* data)
{
	PartitionerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PARTITIONER_GET_CLASS (self);
	if (_klass_->partition) {
		_klass_->partition (self, root, data);
	}
}

static void
partitioner_class_init (PartitionerClass * klass,
                        gpointer klass_data)
{
	partitioner_parent_class = g_type_class_peek_parent (klass);
	((PartitionerClass *) klass)->partition = (void (*) (Partitioner*, Node*, GSList*)) partitioner_real_partition;
}

static void
partitioner_instance_init (Partitioner * self,
                           gpointer klass)
{
}

static GType
partitioner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PartitionerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) partitioner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Partitioner), 0, (GInstanceInitFunc) partitioner_instance_init, NULL };
	GType partitioner_type_id;
	partitioner_type_id = g_type_register_static (G_TYPE_OBJECT, "Partitioner", &g_define_type_info, 0);
	return partitioner_type_id;
}

GType
partitioner_get_type (void)
{
	static volatile gsize partitioner_type_id__once = 0;
	if (g_once_init_enter (&partitioner_type_id__once)) {
		GType partitioner_type_id;
		partitioner_type_id = partitioner_get_type_once ();
		g_once_init_leave (&partitioner_type_id__once, partitioner_type_id);
	}
	return partitioner_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

