/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the RISCV target                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 89;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(RISCVInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(RISCVInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static RISCVInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static RISCVInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(4),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_p0s32,
  GILLT_p0s64,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_nxv1s1,
  GILLT_nxv1s8,
  GILLT_nxv1s16,
  GILLT_nxv1s32,
  GILLT_nxv1s64,
  GILLT_nxv2s1,
  GILLT_nxv2s8,
  GILLT_nxv2s16,
  GILLT_nxv2s32,
  GILLT_nxv2s64,
  GILLT_nxv4s1,
  GILLT_nxv4s8,
  GILLT_nxv4s16,
  GILLT_nxv4s32,
  GILLT_nxv4s64,
  GILLT_nxv8s1,
  GILLT_nxv8s8,
  GILLT_nxv8s16,
  GILLT_nxv8s32,
  GILLT_nxv8s64,
  GILLT_nxv16s1,
  GILLT_nxv16s8,
  GILLT_nxv16s16,
  GILLT_nxv16s32,
  GILLT_nxv32s1,
  GILLT_nxv32s8,
  GILLT_nxv32s16,
  GILLT_nxv64s1,
  GILLT_nxv64s8,
};
const static size_t NumTypeObjects = 34;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 32),
  LLT::pointer(0, 64),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getScalable(1), 1),
  LLT::vector(ElementCount::getScalable(1), 8),
  LLT::vector(ElementCount::getScalable(1), 16),
  LLT::vector(ElementCount::getScalable(1), 32),
  LLT::vector(ElementCount::getScalable(1), 64),
  LLT::vector(ElementCount::getScalable(2), 1),
  LLT::vector(ElementCount::getScalable(2), 8),
  LLT::vector(ElementCount::getScalable(2), 16),
  LLT::vector(ElementCount::getScalable(2), 32),
  LLT::vector(ElementCount::getScalable(2), 64),
  LLT::vector(ElementCount::getScalable(4), 1),
  LLT::vector(ElementCount::getScalable(4), 8),
  LLT::vector(ElementCount::getScalable(4), 16),
  LLT::vector(ElementCount::getScalable(4), 32),
  LLT::vector(ElementCount::getScalable(4), 64),
  LLT::vector(ElementCount::getScalable(8), 1),
  LLT::vector(ElementCount::getScalable(8), 8),
  LLT::vector(ElementCount::getScalable(8), 16),
  LLT::vector(ElementCount::getScalable(8), 32),
  LLT::vector(ElementCount::getScalable(8), 64),
  LLT::vector(ElementCount::getScalable(16), 1),
  LLT::vector(ElementCount::getScalable(16), 8),
  LLT::vector(ElementCount::getScalable(16), 16),
  LLT::vector(ElementCount::getScalable(16), 32),
  LLT::vector(ElementCount::getScalable(32), 1),
  LLT::vector(ElementCount::getScalable(32), 8),
  LLT::vector(ElementCount::getScalable(32), 16),
  LLT::vector(ElementCount::getScalable(64), 1),
  LLT::vector(ElementCount::getScalable(64), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasStdExtZicbopBit = 64,
  Feature_HasStdExtZicondBit = 65,
  Feature_HasStdExtZimopBit = 63,
  Feature_HasStdExtZicfilpBit = 2,
  Feature_NoStdExtZicfilpBit = 1,
  Feature_HasStdExtZmmulBit = 22,
  Feature_HasStdExtMBit = 23,
  Feature_HasStdExtABit = 25,
  Feature_HasStdExtZtsoBit = 27,
  Feature_NotHasStdExtZtsoBit = 26,
  Feature_HasStdExtZabhaBit = 30,
  Feature_HasStdExtZacasBit = 29,
  Feature_NoStdExtZacasBit = 28,
  Feature_HasStdExtZalasrBit = 31,
  Feature_HasStdExtFBit = 5,
  Feature_HasStdExtDBit = 7,
  Feature_HasStdExtZfhminBit = 12,
  Feature_HasStdExtZfhBit = 10,
  Feature_HasStdExtZfaBit = 32,
  Feature_NoStdExtZfaBit = 8,
  Feature_HasStdExtZfinxBit = 6,
  Feature_HasStdExtZdinxBit = 9,
  Feature_HasStdExtZhinxminBit = 13,
  Feature_HasStdExtZhinxBit = 11,
  Feature_HasStdExtCBit = 18,
  Feature_HasStdExtCOrZcaBit = 20,
  Feature_HasStdExtZbaBit = 38,
  Feature_NotHasStdExtZbaBit = 21,
  Feature_HasStdExtZbbBit = 35,
  Feature_NoStdExtZbbBit = 37,
  Feature_HasStdExtZbcBit = 40,
  Feature_HasStdExtZbsBit = 34,
  Feature_HasStdExtZbkbBit = 36,
  Feature_NoStdExtZbkbBit = 86,
  Feature_HasStdExtZbkxBit = 41,
  Feature_HasStdExtZbbOrZbkbBit = 33,
  Feature_HasStdExtZbcOrZbkcBit = 39,
  Feature_HasStdExtZkndBit = 42,
  Feature_HasStdExtZkneBit = 44,
  Feature_HasStdExtZkndOrZkneBit = 43,
  Feature_HasStdExtZknhBit = 45,
  Feature_HasStdExtZksedBit = 46,
  Feature_HasStdExtZkshBit = 47,
  Feature_HasStdExtZvkbBit = 55,
  Feature_HasStdExtZvbbBit = 54,
  Feature_HasStdExtZvbcBit = 59,
  Feature_HasStdExtZvkgBit = 56,
  Feature_HasStdExtZvknedBit = 57,
  Feature_HasStdExtZvknhaBit = 60,
  Feature_HasStdExtZvknhbBit = 61,
  Feature_HasStdExtZvksedBit = 62,
  Feature_HasStdExtZvkshBit = 58,
  Feature_HasVInstructionsBit = 14,
  Feature_HasVInstructionsI64Bit = 50,
  Feature_HasVInstructionsAnyFBit = 49,
  Feature_HasVInstructionsF16MinimalBit = 52,
  Feature_HasVInstructionsF16Bit = 48,
  Feature_HasVInstructionsF64Bit = 53,
  Feature_HasVInstructionsFullMultiplyBit = 51,
  Feature_HasVendorXVentanaCondOpsBit = 66,
  Feature_HasVendorXTHeadBaBit = 67,
  Feature_HasVendorXTHeadBbBit = 68,
  Feature_HasVendorXTHeadBsBit = 69,
  Feature_HasVendorXTHeadCondMovBit = 70,
  Feature_HasVendorXTHeadFMemIdxBit = 75,
  Feature_HasVendorXTHeadMacBit = 71,
  Feature_HasVendorXTHeadMemIdxBit = 74,
  Feature_HasVendorXTHeadMemPairBit = 73,
  Feature_HasVendorXTHeadVdotBit = 72,
  Feature_HasVendorXSfvcpBit = 76,
  Feature_HasVendorXSfvqmaccdodBit = 77,
  Feature_HasVendorXSfvqmaccqoqBit = 78,
  Feature_HasVendorXSfvfnrclipxfqfBit = 79,
  Feature_HasVendorXCVbitmanipBit = 81,
  Feature_HasVendorXCVmacBit = 84,
  Feature_HasVendorXCVmemBit = 80,
  Feature_HasVendorXCValuBit = 82,
  Feature_HasVendorXCVbiBit = 83,
  Feature_UseCCMovInsnBit = 85,
  Feature_IsRV64Bit = 4,
  Feature_IsRV32Bit = 3,
  Feature_HasShortForwardBranchOptBit = 15,
  Feature_NoShortForwardBranchOptBit = 17,
  Feature_HasConditionalMoveFusionBit = 16,
  Feature_NoConditionalMoveFusionBit = 0,
  Feature_HasAtomicLdStBit = 24,
  Feature_OptForMinSizeBit = 19,
  Feature_HwMode1Bit = 88,
  Feature_HwMode0Bit = 87,
};

PredicateBitset RISCVInstructionSelector::
computeAvailableModuleFeatures(const RISCVSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (Subtarget->hasStdExtZicbop())
    Features.set(Feature_HasStdExtZicbopBit);
  if (Subtarget->hasStdExtZicond())
    Features.set(Feature_HasStdExtZicondBit);
  if (Subtarget->hasStdExtZimop())
    Features.set(Feature_HasStdExtZimopBit);
  if (Subtarget->hasStdExtZicfilp())
    Features.set(Feature_HasStdExtZicfilpBit);
  if (!Subtarget->hasStdExtZicfilp())
    Features.set(Feature_NoStdExtZicfilpBit);
  if (Subtarget->hasStdExtZmmul())
    Features.set(Feature_HasStdExtZmmulBit);
  if (Subtarget->hasStdExtM())
    Features.set(Feature_HasStdExtMBit);
  if (Subtarget->hasStdExtA())
    Features.set(Feature_HasStdExtABit);
  if (Subtarget->hasStdExtZtso())
    Features.set(Feature_HasStdExtZtsoBit);
  if (!Subtarget->hasStdExtZtso())
    Features.set(Feature_NotHasStdExtZtsoBit);
  if (Subtarget->hasStdExtZabha())
    Features.set(Feature_HasStdExtZabhaBit);
  if (Subtarget->hasStdExtZacas())
    Features.set(Feature_HasStdExtZacasBit);
  if (!Subtarget->hasStdExtZacas())
    Features.set(Feature_NoStdExtZacasBit);
  if (Subtarget->hasStdExtZalasr())
    Features.set(Feature_HasStdExtZalasrBit);
  if (Subtarget->hasStdExtF())
    Features.set(Feature_HasStdExtFBit);
  if (Subtarget->hasStdExtD())
    Features.set(Feature_HasStdExtDBit);
  if (Subtarget->hasStdExtZfhmin())
    Features.set(Feature_HasStdExtZfhminBit);
  if (Subtarget->hasStdExtZfh())
    Features.set(Feature_HasStdExtZfhBit);
  if (Subtarget->hasStdExtZfa())
    Features.set(Feature_HasStdExtZfaBit);
  if (!Subtarget->hasStdExtZfa())
    Features.set(Feature_NoStdExtZfaBit);
  if (Subtarget->hasStdExtZfinx())
    Features.set(Feature_HasStdExtZfinxBit);
  if (Subtarget->hasStdExtZdinx())
    Features.set(Feature_HasStdExtZdinxBit);
  if (Subtarget->hasStdExtZhinxmin())
    Features.set(Feature_HasStdExtZhinxminBit);
  if (Subtarget->hasStdExtZhinx())
    Features.set(Feature_HasStdExtZhinxBit);
  if (Subtarget->hasStdExtC())
    Features.set(Feature_HasStdExtCBit);
  if (Subtarget->hasStdExtCOrZca())
    Features.set(Feature_HasStdExtCOrZcaBit);
  if (Subtarget->hasStdExtZba())
    Features.set(Feature_HasStdExtZbaBit);
  if (!Subtarget->hasStdExtZba())
    Features.set(Feature_NotHasStdExtZbaBit);
  if (Subtarget->hasStdExtZbb())
    Features.set(Feature_HasStdExtZbbBit);
  if (!Subtarget->hasStdExtZbb())
    Features.set(Feature_NoStdExtZbbBit);
  if (Subtarget->hasStdExtZbc())
    Features.set(Feature_HasStdExtZbcBit);
  if (Subtarget->hasStdExtZbs())
    Features.set(Feature_HasStdExtZbsBit);
  if (Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbkbBit);
  if (!Subtarget->hasStdExtZbkb())
    Features.set(Feature_NoStdExtZbkbBit);
  if (Subtarget->hasStdExtZbkx())
    Features.set(Feature_HasStdExtZbkxBit);
  if (Subtarget->hasStdExtZbb() || Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbbOrZbkbBit);
  if (Subtarget->hasStdExtZbc() || Subtarget->hasStdExtZbkc())
    Features.set(Feature_HasStdExtZbcOrZbkcBit);
  if (Subtarget->hasStdExtZknd())
    Features.set(Feature_HasStdExtZkndBit);
  if (Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkneBit);
  if (Subtarget->hasStdExtZknd() || Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkndOrZkneBit);
  if (Subtarget->hasStdExtZknh())
    Features.set(Feature_HasStdExtZknhBit);
  if (Subtarget->hasStdExtZksed())
    Features.set(Feature_HasStdExtZksedBit);
  if (Subtarget->hasStdExtZksh())
    Features.set(Feature_HasStdExtZkshBit);
  if (Subtarget->hasStdExtZvkb())
    Features.set(Feature_HasStdExtZvkbBit);
  if (Subtarget->hasStdExtZvbb())
    Features.set(Feature_HasStdExtZvbbBit);
  if (Subtarget->hasStdExtZvbc())
    Features.set(Feature_HasStdExtZvbcBit);
  if (Subtarget->hasStdExtZvkg())
    Features.set(Feature_HasStdExtZvkgBit);
  if (Subtarget->hasStdExtZvkned())
    Features.set(Feature_HasStdExtZvknedBit);
  if (Subtarget->hasStdExtZvknha())
    Features.set(Feature_HasStdExtZvknhaBit);
  if (Subtarget->hasStdExtZvknhb())
    Features.set(Feature_HasStdExtZvknhbBit);
  if (Subtarget->hasStdExtZvksed())
    Features.set(Feature_HasStdExtZvksedBit);
  if (Subtarget->hasStdExtZvksh())
    Features.set(Feature_HasStdExtZvkshBit);
  if (Subtarget->hasVInstructions())
    Features.set(Feature_HasVInstructionsBit);
  if (Subtarget->hasVInstructionsI64())
    Features.set(Feature_HasVInstructionsI64Bit);
  if (Subtarget->hasVInstructionsAnyF())
    Features.set(Feature_HasVInstructionsAnyFBit);
  if (Subtarget->hasVInstructionsF16Minimal())
    Features.set(Feature_HasVInstructionsF16MinimalBit);
  if (Subtarget->hasVInstructionsF16())
    Features.set(Feature_HasVInstructionsF16Bit);
  if (Subtarget->hasVInstructionsF64())
    Features.set(Feature_HasVInstructionsF64Bit);
  if (Subtarget->hasVInstructionsFullMultiply())
    Features.set(Feature_HasVInstructionsFullMultiplyBit);
  if (Subtarget->hasVendorXVentanaCondOps())
    Features.set(Feature_HasVendorXVentanaCondOpsBit);
  if (Subtarget->hasVendorXTHeadBa())
    Features.set(Feature_HasVendorXTHeadBaBit);
  if (Subtarget->hasVendorXTHeadBb())
    Features.set(Feature_HasVendorXTHeadBbBit);
  if (Subtarget->hasVendorXTHeadBs())
    Features.set(Feature_HasVendorXTHeadBsBit);
  if (Subtarget->hasVendorXTHeadCondMov())
    Features.set(Feature_HasVendorXTHeadCondMovBit);
  if (Subtarget->hasVendorXTHeadFMemIdx())
    Features.set(Feature_HasVendorXTHeadFMemIdxBit);
  if (Subtarget->hasVendorXTHeadMac())
    Features.set(Feature_HasVendorXTHeadMacBit);
  if (Subtarget->hasVendorXTHeadMemIdx())
    Features.set(Feature_HasVendorXTHeadMemIdxBit);
  if (Subtarget->hasVendorXTHeadMemPair())
    Features.set(Feature_HasVendorXTHeadMemPairBit);
  if (Subtarget->hasVendorXTHeadVdot())
    Features.set(Feature_HasVendorXTHeadVdotBit);
  if (Subtarget->hasVendorXSfvcp())
    Features.set(Feature_HasVendorXSfvcpBit);
  if (Subtarget->hasVendorXSfvqmaccdod())
    Features.set(Feature_HasVendorXSfvqmaccdodBit);
  if (Subtarget->hasVendorXSfvqmaccqoq())
    Features.set(Feature_HasVendorXSfvqmaccqoqBit);
  if (Subtarget->hasVendorXSfvfnrclipxfqf())
    Features.set(Feature_HasVendorXSfvfnrclipxfqfBit);
  if (Subtarget->hasVendorXCVbitmanip())
    Features.set(Feature_HasVendorXCVbitmanipBit);
  if (Subtarget->hasVendorXCVmac())
    Features.set(Feature_HasVendorXCVmacBit);
  if (Subtarget->hasVendorXCVmem())
    Features.set(Feature_HasVendorXCVmemBit);
  if (Subtarget->hasVendorXCValu())
    Features.set(Feature_HasVendorXCValuBit);
  if (Subtarget->hasVendorXCVbi())
    Features.set(Feature_HasVendorXCVbiBit);
  if (Subtarget->useCCMovInsn())
    Features.set(Feature_UseCCMovInsnBit);
  if (Subtarget->is64Bit())
    Features.set(Feature_IsRV64Bit);
  if (!Subtarget->is64Bit())
    Features.set(Feature_IsRV32Bit);
  if (Subtarget->hasShortForwardBranchOpt())
    Features.set(Feature_HasShortForwardBranchOptBit);
  if (!Subtarget->hasShortForwardBranchOpt())
    Features.set(Feature_NoShortForwardBranchOptBit);
  if (Subtarget->hasConditionalMoveFusion())
    Features.set(Feature_HasConditionalMoveFusionBit);
  if (!Subtarget->hasConditionalMoveFusion())
    Features.set(Feature_NoConditionalMoveFusionBit);
  if (Subtarget->hasStdExtA() || Subtarget->hasForcedAtomics())
    Features.set(Feature_HasAtomicLdStBit);
  if (MF ? MF->getFunction().hasMinSize() : false)
    Features.set(Feature_OptForMinSizeBit);
  if (!((Subtarget->is64Bit())))
    Features.set(Feature_HwMode1Bit);
  if ((Subtarget->is64Bit()))
    Features.set(Feature_HwMode0Bit);
  return Features;
}

void RISCVInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const RISCVSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset RISCVInstructionSelector::
computeAvailableFunctionFeatures(const RISCVSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HwMode0,
  GIFBS_HwMode1,
  GIFBS_HasAtomicLdSt_HwMode0,
  GIFBS_HasAtomicLdSt_HwMode1,
  GIFBS_HasShortForwardBranchOpt_HwMode0,
  GIFBS_HasShortForwardBranchOpt_HwMode1,
  GIFBS_HasStdExtA_HwMode0,
  GIFBS_HasStdExtA_HwMode1,
  GIFBS_HasStdExtD,
  GIFBS_HasStdExtD_HwMode0,
  GIFBS_HasStdExtD_HwMode1,
  GIFBS_HasStdExtF,
  GIFBS_HasStdExtF_HwMode0,
  GIFBS_HasStdExtF_HwMode1,
  GIFBS_HasStdExtM_HwMode0,
  GIFBS_HasStdExtM_HwMode1,
  GIFBS_HasStdExtZalasr_HwMode0,
  GIFBS_HasStdExtZalasr_HwMode1,
  GIFBS_HasStdExtZba_HwMode0,
  GIFBS_HasStdExtZba_HwMode1,
  GIFBS_HasStdExtZbb_HwMode0,
  GIFBS_HasStdExtZbb_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_HwMode0,
  GIFBS_HasStdExtZbbOrZbkb_HwMode1,
  GIFBS_HasStdExtZbkb_HwMode0,
  GIFBS_HasStdExtZbkb_HwMode1,
  GIFBS_HasStdExtZbkx_HwMode0,
  GIFBS_HasStdExtZbkx_HwMode1,
  GIFBS_HasStdExtZbs_HwMode0,
  GIFBS_HasStdExtZbs_HwMode1,
  GIFBS_HasStdExtZfa,
  GIFBS_HasStdExtZfa_HwMode0,
  GIFBS_HasStdExtZfa_HwMode1,
  GIFBS_HasStdExtZfh,
  GIFBS_HasStdExtZfh_HwMode0,
  GIFBS_HasStdExtZfh_HwMode1,
  GIFBS_HasStdExtZfhmin_HwMode0,
  GIFBS_HasStdExtZfhmin_HwMode1,
  GIFBS_HasStdExtZfinx,
  GIFBS_HasStdExtZfinx_HwMode0,
  GIFBS_HasStdExtZfinx_HwMode1,
  GIFBS_HasStdExtZhinx,
  GIFBS_HasStdExtZhinx_HwMode0,
  GIFBS_HasStdExtZhinx_HwMode1,
  GIFBS_HasStdExtZhinxmin_HwMode0,
  GIFBS_HasStdExtZhinxmin_HwMode1,
  GIFBS_HasStdExtZmmul_HwMode0,
  GIFBS_HasStdExtZmmul_HwMode1,
  GIFBS_HasStdExtZvbb_HwMode0,
  GIFBS_HasStdExtZvbb_HwMode1,
  GIFBS_HasStdExtZvbc_HwMode0,
  GIFBS_HasStdExtZvbc_HwMode1,
  GIFBS_HasStdExtZvkb_HwMode0,
  GIFBS_HasStdExtZvkb_HwMode1,
  GIFBS_HasStdExtZvkg_HwMode0,
  GIFBS_HasStdExtZvkg_HwMode1,
  GIFBS_HasStdExtZvkned_HwMode0,
  GIFBS_HasStdExtZvkned_HwMode1,
  GIFBS_HasStdExtZvknha_HwMode0,
  GIFBS_HasStdExtZvknha_HwMode1,
  GIFBS_HasStdExtZvknhb_HwMode0,
  GIFBS_HasStdExtZvknhb_HwMode1,
  GIFBS_HasStdExtZvksed_HwMode0,
  GIFBS_HasStdExtZvksed_HwMode1,
  GIFBS_HasStdExtZvksh_HwMode0,
  GIFBS_HasStdExtZvksh_HwMode1,
  GIFBS_HasVInstructions_HwMode0,
  GIFBS_HasVInstructions_HwMode1,
  GIFBS_HasVInstructionsAnyF_HwMode0,
  GIFBS_HasVInstructionsAnyF_HwMode1,
  GIFBS_HasVInstructionsF16_HwMode0,
  GIFBS_HasVInstructionsF16_HwMode1,
  GIFBS_HasVInstructionsF16Minimal_HwMode0,
  GIFBS_HasVInstructionsF16Minimal_HwMode1,
  GIFBS_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructionsFullMultiply_HwMode0,
  GIFBS_HasVInstructionsFullMultiply_HwMode1,
  GIFBS_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsI64_HwMode1,
  GIFBS_HasVendorXCVmac_HwMode0,
  GIFBS_HasVendorXCVmac_HwMode1,
  GIFBS_HasVendorXSfvcp_HwMode0,
  GIFBS_HasVendorXSfvcp_HwMode1,
  GIFBS_HasVendorXSfvfnrclipxfqf_HwMode0,
  GIFBS_HasVendorXSfvfnrclipxfqf_HwMode1,
  GIFBS_HasVendorXSfvqmaccdod_HwMode0,
  GIFBS_HasVendorXSfvqmaccdod_HwMode1,
  GIFBS_HasVendorXSfvqmaccqoq_HwMode0,
  GIFBS_HasVendorXSfvqmaccqoq_HwMode1,
  GIFBS_HasVendorXTHeadBa_HwMode0,
  GIFBS_HasVendorXTHeadBa_HwMode1,
  GIFBS_HasVendorXTHeadBb_HwMode0,
  GIFBS_HasVendorXTHeadBb_HwMode1,
  GIFBS_HasVendorXTHeadBs_HwMode0,
  GIFBS_HasVendorXTHeadBs_HwMode1,
  GIFBS_HasVendorXTHeadCondMov_HwMode0,
  GIFBS_HasVendorXTHeadCondMov_HwMode1,
  GIFBS_HasVendorXTHeadMac_HwMode0,
  GIFBS_HasVendorXTHeadMac_HwMode1,
  GIFBS_HasVendorXTHeadVdot_HwMode0,
  GIFBS_HasVendorXTHeadVdot_HwMode1,
  GIFBS_IsRV32_HwMode0,
  GIFBS_IsRV32_HwMode1,
  GIFBS_IsRV64_HwMode0,
  GIFBS_IsRV64_HwMode1,
  GIFBS_UseCCMovInsn_HwMode0,
  GIFBS_UseCCMovInsn_HwMode1,
  GIFBS_HasAtomicLdSt_IsRV64_HwMode0,
  GIFBS_HasAtomicLdSt_IsRV64_HwMode1,
  GIFBS_HasStdExtA_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtA_IsRV64_HwMode0,
  GIFBS_HasStdExtA_NoStdExtZacas_HwMode0,
  GIFBS_HasStdExtA_NoStdExtZacas_HwMode1,
  GIFBS_HasStdExtA_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtD_HasStdExtZfa,
  GIFBS_HasStdExtD_HasStdExtZfa_HwMode0,
  GIFBS_HasStdExtD_HasStdExtZfa_HwMode1,
  GIFBS_HasStdExtD_HasStdExtZfhmin_HwMode0,
  GIFBS_HasStdExtD_HasStdExtZfhmin_HwMode1,
  GIFBS_HasStdExtD_IsRV32_HwMode0,
  GIFBS_HasStdExtD_IsRV32_HwMode1,
  GIFBS_HasStdExtD_IsRV64_HwMode0,
  GIFBS_HasStdExtF_IsRV32_HwMode0,
  GIFBS_HasStdExtF_IsRV32_HwMode1,
  GIFBS_HasStdExtF_IsRV64_HwMode0,
  GIFBS_HasStdExtM_IsRV64_HwMode0,
  GIFBS_HasStdExtZacas_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZacas_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZacas_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZacas_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZalasr_IsRV64_HwMode0,
  GIFBS_HasStdExtZalasr_IsRV64_HwMode1,
  GIFBS_HasStdExtZba_IsRV64_HwMode0,
  GIFBS_HasStdExtZbb_IsRV32_HwMode0,
  GIFBS_HasStdExtZbb_IsRV32_HwMode1,
  GIFBS_HasStdExtZbb_IsRV64_HwMode0,
  GIFBS_HasStdExtZbb_IsRV64_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_IsRV32_HwMode0,
  GIFBS_HasStdExtZbbOrZbkb_IsRV32_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV32_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV32_HwMode1,
  GIFBS_HasStdExtZbkb_IsRV64_HwMode0,
  GIFBS_HasStdExtZdinx_IsRV32,
  GIFBS_HasStdExtZdinx_IsRV32_HwMode0,
  GIFBS_HasStdExtZdinx_IsRV32_HwMode1,
  GIFBS_HasStdExtZdinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZfa_HasStdExtZfh,
  GIFBS_HasStdExtZfa_HasStdExtZfh_HwMode0,
  GIFBS_HasStdExtZfa_HasStdExtZfh_HwMode1,
  GIFBS_HasStdExtZfh_IsRV32_HwMode0,
  GIFBS_HasStdExtZfh_IsRV32_HwMode1,
  GIFBS_HasStdExtZfh_IsRV64_HwMode0,
  GIFBS_HasStdExtZfinx_IsRV32_HwMode0,
  GIFBS_HasStdExtZfinx_IsRV32_HwMode1,
  GIFBS_HasStdExtZfinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZhinx_IsRV32_HwMode0,
  GIFBS_HasStdExtZhinx_IsRV32_HwMode1,
  GIFBS_HasStdExtZhinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZknd_IsRV32_HwMode1,
  GIFBS_HasStdExtZknd_IsRV64_HwMode0,
  GIFBS_HasStdExtZkndOrZkne_IsRV64_HwMode0,
  GIFBS_HasStdExtZkne_IsRV32_HwMode1,
  GIFBS_HasStdExtZkne_IsRV64_HwMode0,
  GIFBS_HasStdExtZknh_IsRV32_HwMode1,
  GIFBS_HasStdExtZknh_IsRV64_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructions_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructions_HwMode1,
  GIFBS_HasStdExtZvbb_HasVInstructionsI64_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructionsI64_HwMode1,
  GIFBS_HasStdExtZvkb_HasVInstructions_HwMode0,
  GIFBS_HasStdExtZvkb_HasVInstructions_HwMode1,
  GIFBS_HasStdExtZvkb_HasVInstructionsI64_HwMode0,
  GIFBS_HasStdExtZvkb_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsAnyF_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsAnyF_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsF16_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsF16_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF16_HwMode0,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF16_HwMode1,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructionsF64_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsF64_HasVInstructionsI64_HwMode1,
  GIFBS_HasVendorXCValu_IsRV32_HwMode0,
  GIFBS_HasVendorXCValu_IsRV32_HwMode1,
  GIFBS_HasVendorXCVbitmanip_IsRV32_HwMode0,
  GIFBS_HasVendorXCVbitmanip_IsRV32_HwMode1,
  GIFBS_HasVendorXTHeadBb_IsRV64_HwMode0,
  GIFBS_IsRV32_NoStdExtZbb_HwMode0,
  GIFBS_IsRV32_NoStdExtZbb_HwMode1,
  GIFBS_IsRV64_NoStdExtZbb_HwMode0,
  GIFBS_IsRV64_NoStdExtZbb_HwMode1,
  GIFBS_IsRV64_NotHasStdExtZba_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZabha_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZabha_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtA_HasStdExtZabha_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZabha_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtA_HasStdExtZtso_IsRV64_HwMode0,
  GIFBS_HasStdExtA_IsRV64_NoStdExtZacas_HwMode0,
  GIFBS_HasStdExtA_IsRV64_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtD_HasStdExtZfa_IsRV32_HwMode0,
  GIFBS_HasStdExtD_HasStdExtZfa_IsRV32_HwMode1,
  GIFBS_HasStdExtD_IsRV32_NoStdExtZfa_HwMode0,
  GIFBS_HasStdExtD_IsRV32_NoStdExtZfa_HwMode1,
  GIFBS_HasStdExtZabha_HasStdExtZacas_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZabha_HasStdExtZacas_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZabha_HasStdExtZacas_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZabha_HasStdExtZacas_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZacas_HasStdExtZtso_IsRV64_HwMode0,
  GIFBS_HasStdExtZacas_IsRV64_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV32_NoStdExtZbb_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV32_NoStdExtZbb_HwMode1,
  GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode1,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV32_HwMode0,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV32_HwMode1,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV64_HwMode0,
  GIFBS_HasStdExtZmmul_IsRV64_NotHasStdExtZba_HwMode0,
  GIFBS_IsRV32_NoStdExtZbb_NoStdExtZbkb_HwMode0,
  GIFBS_IsRV32_NoStdExtZbb_NoStdExtZbkb_HwMode1,
  GIFBS_IsRV64_NoStdExtZbb_NoStdExtZbkb_HwMode0,
  GIFBS_IsRV64_NoStdExtZbb_NoStdExtZbkb_HwMode1,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HwMode0Bit, },
  {Feature_HwMode1Bit, },
  {Feature_HasAtomicLdStBit, Feature_HwMode0Bit, },
  {Feature_HasAtomicLdStBit, Feature_HwMode1Bit, },
  {Feature_HasShortForwardBranchOptBit, Feature_HwMode0Bit, },
  {Feature_HasShortForwardBranchOptBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, },
  {Feature_HasStdExtDBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtFBit, },
  {Feature_HasStdExtFBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtFBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtMBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZalasrBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZalasrBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbkbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbkxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtZfaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfhminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfinxBit, },
  {Feature_HasStdExtZfinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfinxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZhinxBit, },
  {Feature_HasStdExtZhinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZmmulBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZmmulBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvbcBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbcBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkgBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkgBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvknedBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvknedBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvknhaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvknhaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvknhbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvknhbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvksedBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvksedBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkshBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkshBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF16Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF16MinimalBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF16MinimalBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsFullMultiplyBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsFullMultiplyBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXCVmacBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXCVmacBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXSfvcpBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXSfvcpBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXSfvfnrclipxfqfBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXSfvfnrclipxfqfBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXSfvqmaccdodBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXSfvqmaccdodBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXSfvqmaccqoqBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXSfvqmaccqoqBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBaBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBaBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBsBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBsBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadCondMovBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadCondMovBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadVdotBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadVdotBit, Feature_HwMode1Bit, },
  {Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_UseCCMovInsnBit, Feature_HwMode0Bit, },
  {Feature_UseCCMovInsnBit, Feature_HwMode1Bit, },
  {Feature_HasAtomicLdStBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasAtomicLdStBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_NoStdExtZacasBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_NoStdExtZacasBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfhminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfhminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZalasrBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZalasrBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZkndOrZkneBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsAnyFBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsAnyFBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF16Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF16Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXCValuBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXCValuBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXCVbitmanipBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXCVbitmanipBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, Feature_NoStdExtZacasBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV32Bit, Feature_NoStdExtZfaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV32Bit, Feature_NoStdExtZfaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_IsRV64Bit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZmmulBit, Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, Feature_HwMode0Bit, },
  {Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_NoStdExtZbkbBit, Feature_HwMode0Bit, },
  {Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_NoStdExtZbkbBit, Feature_HwMode1Bit, },
  {Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_NoStdExtZbkbBit, Feature_HwMode0Bit, },
  {Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_NoStdExtZbkbBit, Feature_HwMode1Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_GIAddrRegImm,
  GICP_GIShiftMask32,
  GICP_GIShiftMaskXLen,
  GICP_GIVLOp,
  GICP_gi_sexti32,
  GICP_gi_sh1add_op,
  GICP_gi_sh1add_uw_op,
  GICP_gi_sh2add_op,
  GICP_gi_sh2add_uw_op,
  GICP_gi_sh3add_op,
  GICP_gi_sh3add_uw_op,
  GICP_gi_zexti16,
  GICP_gi_zexti32,
  GICP_gi_zexti8,
};
// See constructor for table contents

RISCVInstructionSelector::ComplexMatcherMemFn
RISCVInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &RISCVInstructionSelector::selectAddrRegImm, // GIAddrRegImm
  &RISCVInstructionSelector::selectShiftMask32, // GIShiftMask32
  &RISCVInstructionSelector::selectShiftMaskXLen, // GIShiftMaskXLen
  &RISCVInstructionSelector::renderVLOp, // GIVLOp
  &RISCVInstructionSelector::selectSExtBits<32>, // gi_sexti32
  &RISCVInstructionSelector::selectSHXADDOp<1>, // gi_sh1add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<1>, // gi_sh1add_uw_op
  &RISCVInstructionSelector::selectSHXADDOp<2>, // gi_sh2add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<2>, // gi_sh2add_uw_op
  &RISCVInstructionSelector::selectSHXADDOp<3>, // gi_sh3add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<3>, // gi_sh3add_uw_op
  &RISCVInstructionSelector::selectZExtBits<16>, // gi_zexti16
  &RISCVInstructionSelector::selectZExtBits<32>, // gi_zexti32
  &RISCVInstructionSelector::selectZExtBits<8>, // gi_zexti8
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_add_like_non_imm12 = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_add_non_imm12,
  GICXXPred_MI_Predicate_anonymous_9501,
  GICXXPred_MI_Predicate_anonymous_9503,
  GICXXPred_MI_Predicate_anonymous_9591,
  GICXXPred_MI_Predicate_anonymous_9632,
};
bool RISCVInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_add_like_non_imm12: {
    
        const MachineOperand &ImmOp = *Operands[1];
    
        if (ImmOp.isReg() && ImmOp.getReg())
          if (auto Val = getIConstantVRegValWithLookThrough(ImmOp.getReg(), MRI)) {
            // We do NOT want immediates that fit in 12 bits.
            return !isInt<12>(Val->Value.getSExtValue());
          }
    
        return true;
      
    llvm_unreachable("add_like_non_imm12 should have returned");
  }
  case GICXXPred_MI_Predicate_add_non_imm12: {
    
        const MachineOperand &ImmOp = *Operands[1];
    
        if (ImmOp.isReg() && ImmOp.getReg())
          if (auto Val = getIConstantVRegValWithLookThrough(ImmOp.getReg(), MRI)) {
            // We do NOT want immediates that fit in 12 bits.
            return !isInt<12>(Val->Value.getSExtValue());
          }
    
        return true;
      
    llvm_unreachable("add_non_imm12 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_9501: {
    
        return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
      
  }
  case GICXXPred_MI_Predicate_anonymous_9503: {
    
        return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
      
  }
  case GICXXPred_MI_Predicate_anonymous_9591: {
    
        return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
      
  }
  case GICXXPred_MI_Predicate_anonymous_9632: {
    
        return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
      
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_AddiPair = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_BCLRMask,
  GICXXPred_I64_Predicate_LeadingOnesMask,
  GICXXPred_I64_Predicate_LeadingOnesWMask,
  GICXXPred_I64_Predicate_SingleBitSetMask,
  GICXXPred_I64_Predicate_byteselect,
  GICXXPred_I64_Predicate_c_lui_imm,
  GICXXPred_I64_Predicate_csr_sysreg,
  GICXXPred_I64_Predicate_cv_tuimm2,
  GICXXPred_I64_Predicate_cv_tuimm5,
  GICXXPred_I64_Predicate_cv_uimm10,
  GICXXPred_I64_Predicate_immzero,
  GICXXPred_I64_Predicate_payload1,
  GICXXPred_I64_Predicate_payload2,
  GICXXPred_I64_Predicate_payload5,
  GICXXPred_I64_Predicate_powerOf2Minus1,
  GICXXPred_I64_Predicate_rnum,
  GICXXPred_I64_Predicate_simm5,
  GICXXPred_I64_Predicate_simm5_plus1,
  GICXXPred_I64_Predicate_simm5_plus1_nonzero,
  GICXXPred_I64_Predicate_simm6,
  GICXXPred_I64_Predicate_simm6nonzero,
  GICXXPred_I64_Predicate_simm9_lsb0,
  GICXXPred_I64_Predicate_simm10_lsb0000nonzero,
  GICXXPred_I64_Predicate_simm12,
  GICXXPred_I64_Predicate_simm12Minus1Nonzero,
  GICXXPred_I64_Predicate_simm12Minus1NonzeroNonNeg1,
  GICXXPred_I64_Predicate_simm12Plus1,
  GICXXPred_I64_Predicate_simm12Plus1i32,
  GICXXPred_I64_Predicate_simm12_lsb0,
  GICXXPred_I64_Predicate_simm12_lsb00000,
  GICXXPred_I64_Predicate_simm12_no6,
  GICXXPred_I64_Predicate_simm12_plus1,
  GICXXPred_I64_Predicate_simm26,
  GICXXPred_I64_Predicate_tsimm5,
  GICXXPred_I64_Predicate_tuimm5,
  GICXXPred_I64_Predicate_u32simm12,
  GICXXPred_I64_Predicate_uimm1,
  GICXXPred_I64_Predicate_uimm2,
  GICXXPred_I64_Predicate_uimm2_3,
  GICXXPred_I64_Predicate_uimm2_4,
  GICXXPred_I64_Predicate_uimm2_lsb0,
  GICXXPred_I64_Predicate_uimm4,
  GICXXPred_I64_Predicate_uimm5,
  GICXXPred_I64_Predicate_uimm5_lsb0,
  GICXXPred_I64_Predicate_uimm5gt3,
  GICXXPred_I64_Predicate_uimm5i32,
  GICXXPred_I64_Predicate_uimm5nonzero,
  GICXXPred_I64_Predicate_uimm6,
  GICXXPred_I64_Predicate_uimm6_lsb0,
  GICXXPred_I64_Predicate_uimm6gt32,
  GICXXPred_I64_Predicate_uimm7_lsb00,
  GICXXPred_I64_Predicate_uimm7_lsb000,
  GICXXPred_I64_Predicate_uimm8_lsb00,
  GICXXPred_I64_Predicate_uimm8_lsb000,
  GICXXPred_I64_Predicate_uimm9_lsb000,
  GICXXPred_I64_Predicate_uimm10,
  GICXXPred_I64_Predicate_uimm10_lsb00nonzero,
  GICXXPred_I64_Predicate_uimm11,
  GICXXPred_I64_Predicate_uimmlog2xlen,
  GICXXPred_I64_Predicate_uimmlog2xlennonzero,
};
bool RISCVInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_AddiPair: {
    
      // The immediate operand must be in range [-4096,-2049] or [2048,4094].
      return (-4096 <= Imm && Imm <= -2049) || (2048 <= Imm && Imm <= 4094);
    
    llvm_unreachable("AddiPair should have returned");
  }
  case GICXXPred_I64_Predicate_BCLRMask: {
    
      if (Subtarget->is64Bit())
        return !isInt<12>(Imm) && isPowerOf2_64(~Imm);
      return !isInt<12>(Imm) && isPowerOf2_32(~Imm);
    
    llvm_unreachable("BCLRMask should have returned");
  }
  case GICXXPred_I64_Predicate_LeadingOnesMask: {
    
      return !isInt<32>(Imm) && isMask_64(~Imm);
    
  }
  case GICXXPred_I64_Predicate_LeadingOnesWMask: {
    
      // If the value is a uint32 but not an int32, it must have bit 31 set and
      // bits 63:32 cleared. After that we're looking for a shifted mask but not
      // an all ones mask.
      return !isInt<32>(Imm) && isUInt<32>(Imm) && isShiftedMask_64(Imm) &&
             Imm != UINT64_C(0xffffffff);
    
    llvm_unreachable("LeadingOnesWMask should have returned");
  }
  case GICXXPred_I64_Predicate_SingleBitSetMask: {
    
      if (Subtarget->is64Bit())
        return !isInt<12>(Imm) && isPowerOf2_64(Imm);
      return !isInt<12>(Imm) && isPowerOf2_32(Imm);
    
    llvm_unreachable("SingleBitSetMask should have returned");
  }
  case GICXXPred_I64_Predicate_byteselect: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_c_lui_imm: {
    return (Imm != 0) &&
                                     (isUInt<5>(Imm) ||
                                      (Imm >= 0xfffe0 && Imm <= 0xfffff));
  }
  case GICXXPred_I64_Predicate_csr_sysreg: {
    return isUInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_cv_tuimm2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_cv_tuimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_cv_uimm10: {
    return isUInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_immzero: {
    return (Imm == 0);
  }
  case GICXXPred_I64_Predicate_payload1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_payload2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_payload5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_powerOf2Minus1: {
     return isPowerOf2_32(Imm+1); 
  }
  case GICXXPred_I64_Predicate_rnum: {
    return (Imm >= 0 && Imm <= 10);
  }
  case GICXXPred_I64_Predicate_simm5: {
    return isInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_simm5_plus1: {
    return (isInt<5>(Imm) && Imm != -16) || Imm == 16;
  }
  case GICXXPred_I64_Predicate_simm5_plus1_nonzero: {
    return Imm != 0 && ((isInt<5>(Imm) && Imm != -16) || Imm == 16);
  }
  case GICXXPred_I64_Predicate_simm6: {
    return isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_simm6nonzero: {
    return (Imm != 0) && isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_simm9_lsb0: {
    return isShiftedInt<8, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_simm10_lsb0000nonzero: {
    return (Imm != 0) && isShiftedInt<6, 4>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12: {
    return isInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12Minus1Nonzero: {
    
      return (Imm >= -2049 && Imm < 0) || (Imm > 0 && Imm <= 2046);
  }
  case GICXXPred_I64_Predicate_simm12Minus1NonzeroNonNeg1: {
    
      return (Imm >= -2049 && Imm < -1) || (Imm > 0 && Imm <= 2046);
  }
  case GICXXPred_I64_Predicate_simm12Plus1: {
    
        return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
  }
  case GICXXPred_I64_Predicate_simm12Plus1i32: {
    
        return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
  }
  case GICXXPred_I64_Predicate_simm12_lsb0: {
    return isShiftedInt<11, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12_lsb00000: {
    return isShiftedInt<7, 5>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12_no6: {
    
      return isInt<12>(Imm) && !isInt<6>(Imm) && isInt<12>(-Imm);
  }
  case GICXXPred_I64_Predicate_simm12_plus1: {
    return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
  }
  case GICXXPred_I64_Predicate_simm26: {
    return isInt<26>(Imm);
  }
  case GICXXPred_I64_Predicate_tsimm5: {
    return isInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_tuimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_u32simm12: {
    
      return isUInt<32>(Imm) && isInt<12>(SignExtend64<32>(Imm));
    
  }
  case GICXXPred_I64_Predicate_uimm1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm2_3: {
    
      return isShiftedUInt<2, 3>(Imm);
    
  }
  case GICXXPred_I64_Predicate_uimm2_4: {
    
      return isShiftedUInt<2, 4>(Imm);
    
  }
  case GICXXPred_I64_Predicate_uimm2_lsb0: {
    return isShiftedUInt<1, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm4: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5_lsb0: {
    return isShiftedUInt<4, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5gt3: {
    return (Imm > 3) && isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5i32: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5nonzero: {
    return (Imm != 0) && isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm6: {
    return isUInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm6_lsb0: {
    return isShiftedUInt<5, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm6gt32: {
    
      return isUInt<6>(Imm) && Imm > 32;
    
  }
  case GICXXPred_I64_Predicate_uimm7_lsb00: {
    return isShiftedUInt<5, 2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm7_lsb000: {
    return isShiftedUInt<4, 3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm8_lsb00: {
    return isShiftedUInt<6, 2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm8_lsb000: {
    return isShiftedUInt<5, 3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm9_lsb000: {
    return isShiftedUInt<6, 3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm10: {
    return isUInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm10_lsb00nonzero: {
    return isShiftedUInt<8, 2>(Imm) && (Imm != 0);
  }
  case GICXXPred_I64_Predicate_uimm11: {
    return isUInt<11>(Imm);
  }
  case GICXXPred_I64_Predicate_uimmlog2xlen: {
    
      if (Subtarget->is64Bit())
        return isUInt<6>(Imm);
      return isUInt<5>(Imm);
    
    llvm_unreachable("uimmlog2xlen should have returned");
  }
  case GICXXPred_I64_Predicate_uimmlog2xlennonzero: {
    
      if (Subtarget->is64Bit())
        return isUInt<6>(Imm) && (Imm != 0);
      return isUInt<5>(Imm) && (Imm != 0);
    
    llvm_unreachable("uimmlog2xlennonzero should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool RISCVInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_Shifted32OnesMask = GICXXPred_Invalid + 1,
  GICXXPred_APInt_Predicate_TrailingOnesMask,
};
bool RISCVInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_Shifted32OnesMask: {
    
      if (!Imm.isShiftedMask())
        return false;
    
      unsigned TrailingZeros = Imm.countr_zero();
      return TrailingZeros > 0 && TrailingZeros < 32 &&
             Imm == UINT64_C(0xFFFFFFFF) << TrailingZeros;
    
    llvm_unreachable("Shifted32OnesMask should have returned");
  }
  case GICXXPred_APInt_Predicate_TrailingOnesMask: {
    
      return !isInt<12>(Imm.getSExtValue()) && isMask_64(Imm.getZExtValue());
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("RISCVInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderAddiPairImmLarge,
  GICR_renderAddiPairImmSmall,
  GICR_renderFrameIndex,
  GICR_renderImmPlus1,
  GICR_renderImmSubFrom32,
  GICR_renderImmSubFromXLen,
  GICR_renderNegImm,
  GICR_renderTrailingZeros,
  GICR_renderXLenSubTrailingOnes,
};
RISCVInstructionSelector::CustomRendererFn
RISCVInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &RISCVInstructionSelector::renderAddiPairImmLarge,
  &RISCVInstructionSelector::renderAddiPairImmSmall,
  &RISCVInstructionSelector::renderFrameIndex,
  &RISCVInstructionSelector::renderImmPlus1,
  &RISCVInstructionSelector::renderImmSubFrom32,
  &RISCVInstructionSelector::renderImmSubFromXLen,
  &RISCVInstructionSelector::renderNegImm,
  &RISCVInstructionSelector::renderTrailingZeros,
  &RISCVInstructionSelector::renderXLenSubTrailingOnes,
};

bool RISCVInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool RISCVInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("RISCVInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *RISCVInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(329), /*)*//*default:*//*Label 121*/ GIMT_Encode4(2546159),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(1114),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(9468),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(12320),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(15189),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(17923),
    /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(20657),
    /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(23436), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(26170),
    /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(35454),
    /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(47419), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FRAME_INDEX*//*Label 10*/ GIMT_Encode4(62214), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UNMERGE_VALUES*//*Label 11*/ GIMT_Encode4(62275), GIMT_Encode4(0),
    /*TargetOpcode::G_MERGE_VALUES*//*Label 12*/ GIMT_Encode4(62336), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 13*/ GIMT_Encode4(62427), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 14*/ GIMT_Encode4(62794),
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 15*/ GIMT_Encode4(62992),
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 16*/ GIMT_Encode4(63190),
    /*TargetOpcode::G_INTRINSIC_LLRINT*//*Label 17*/ GIMT_Encode4(63770),
    /*TargetOpcode::G_INTRINSIC_ROUNDEVEN*//*Label 18*/ GIMT_Encode4(63980),
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 19*/ GIMT_Encode4(64178),
    /*TargetOpcode::G_READSTEADYCOUNTER*//*Label 20*/ GIMT_Encode4(64217),
    /*TargetOpcode::G_LOAD*//*Label 21*/ GIMT_Encode4(64256),
    /*TargetOpcode::G_SEXTLOAD*//*Label 22*/ GIMT_Encode4(72718),
    /*TargetOpcode::G_ZEXTLOAD*//*Label 23*/ GIMT_Encode4(73013), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STORE*//*Label 24*/ GIMT_Encode4(73308), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 25*/ GIMT_Encode4(80106),
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 26*/ GIMT_Encode4(84992),
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 27*/ GIMT_Encode4(87902), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 28*/ GIMT_Encode4(90812),
    /*TargetOpcode::G_ATOMICRMW_NAND*//*Label 29*/ GIMT_Encode4(93722),
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 30*/ GIMT_Encode4(94634),
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 31*/ GIMT_Encode4(97544),
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 32*/ GIMT_Encode4(100454),
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 33*/ GIMT_Encode4(103364),
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 34*/ GIMT_Encode4(106274),
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 35*/ GIMT_Encode4(109184), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FENCE*//*Label 36*/ GIMT_Encode4(112094), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 37*/ GIMT_Encode4(112312),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 38*/ GIMT_Encode4(2305851), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 39*/ GIMT_Encode4(2307367), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 40*/ GIMT_Encode4(2310488),
    /*TargetOpcode::G_SEXT_INREG*//*Label 41*/ GIMT_Encode4(2313963),
    /*TargetOpcode::G_ZEXT*//*Label 42*/ GIMT_Encode4(2314512),
    /*TargetOpcode::G_SHL*//*Label 43*/ GIMT_Encode4(2318199),
    /*TargetOpcode::G_LSHR*//*Label 44*/ GIMT_Encode4(2321273),
    /*TargetOpcode::G_ASHR*//*Label 45*/ GIMT_Encode4(2324179), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ROTR*//*Label 46*/ GIMT_Encode4(2327118),
    /*TargetOpcode::G_ROTL*//*Label 47*/ GIMT_Encode4(2330058),
    /*TargetOpcode::G_ICMP*//*Label 48*/ GIMT_Encode4(2332968),
    /*TargetOpcode::G_FCMP*//*Label 49*/ GIMT_Encode4(2359631), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SELECT*//*Label 50*/ GIMT_Encode4(2367093), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 51*/ GIMT_Encode4(2373805),
    /*TargetOpcode::G_SMULH*//*Label 52*/ GIMT_Encode4(2376539),
    /*TargetOpcode::G_UADDSAT*//*Label 53*/ GIMT_Encode4(2379273),
    /*TargetOpcode::G_SADDSAT*//*Label 54*/ GIMT_Encode4(2382059),
    /*TargetOpcode::G_USUBSAT*//*Label 55*/ GIMT_Encode4(2384845),
    /*TargetOpcode::G_SSUBSAT*//*Label 56*/ GIMT_Encode4(2387631), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 57*/ GIMT_Encode4(2390417),
    /*TargetOpcode::G_FSUB*//*Label 58*/ GIMT_Encode4(2392845),
    /*TargetOpcode::G_FMUL*//*Label 59*/ GIMT_Encode4(2395273),
    /*TargetOpcode::G_FMA*//*Label 60*/ GIMT_Encode4(2397701), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 61*/ GIMT_Encode4(2414346), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 62*/ GIMT_Encode4(2416774),
    /*TargetOpcode::G_FPEXT*//*Label 63*/ GIMT_Encode4(2418745),
    /*TargetOpcode::G_FPTRUNC*//*Label 64*/ GIMT_Encode4(2419198),
    /*TargetOpcode::G_FPTOSI*//*Label 65*/ GIMT_Encode4(2420734),
    /*TargetOpcode::G_FPTOUI*//*Label 66*/ GIMT_Encode4(2425620),
    /*TargetOpcode::G_SITOFP*//*Label 67*/ GIMT_Encode4(2430506),
    /*TargetOpcode::G_UITOFP*//*Label 68*/ GIMT_Encode4(2435792), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FABS*//*Label 69*/ GIMT_Encode4(2441078),
    /*TargetOpcode::G_FCOPYSIGN*//*Label 70*/ GIMT_Encode4(2443049), GIMT_Encode4(0),
    /*TargetOpcode::G_FCANONICALIZE*//*Label 71*/ GIMT_Encode4(2449111),
    /*TargetOpcode::G_FMINNUM*//*Label 72*/ GIMT_Encode4(2449301),
    /*TargetOpcode::G_FMAXNUM*//*Label 73*/ GIMT_Encode4(2451386), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINIMUM*//*Label 74*/ GIMT_Encode4(2453471),
    /*TargetOpcode::G_FMAXIMUM*//*Label 75*/ GIMT_Encode4(2453597), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 76*/ GIMT_Encode4(2453723),
    /*TargetOpcode::G_SMAX*//*Label 77*/ GIMT_Encode4(2456499),
    /*TargetOpcode::G_UMIN*//*Label 78*/ GIMT_Encode4(2459275),
    /*TargetOpcode::G_UMAX*//*Label 79*/ GIMT_Encode4(2462051),
    /*TargetOpcode::G_ABS*//*Label 80*/ GIMT_Encode4(2464827),
    /*TargetOpcode::G_LROUND*//*Label 81*/ GIMT_Encode4(2464985),
    /*TargetOpcode::G_LLROUND*//*Label 82*/ GIMT_Encode4(2465565),
    /*TargetOpcode::G_BR*//*Label 83*/ GIMT_Encode4(2465775), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTTZ*//*Label 84*/ GIMT_Encode4(2465791), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ*//*Label 85*/ GIMT_Encode4(2468311), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 86*/ GIMT_Encode4(2470969),
    /*TargetOpcode::G_BSWAP*//*Label 87*/ GIMT_Encode4(2473520),
    /*TargetOpcode::G_BITREVERSE*//*Label 88*/ GIMT_Encode4(2476055),
    /*TargetOpcode::G_FCEIL*//*Label 89*/ GIMT_Encode4(2478549), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 90*/ GIMT_Encode4(2478747),
    /*TargetOpcode::G_FFLOOR*//*Label 91*/ GIMT_Encode4(2480923),
    /*TargetOpcode::G_FRINT*//*Label 92*/ GIMT_Encode4(2481121),
    /*TargetOpcode::G_FNEARBYINT*//*Label 93*/ GIMT_Encode4(2481319), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FADD*//*Label 94*/ GIMT_Encode4(2481517),
    /*TargetOpcode::G_STRICT_FSUB*//*Label 95*/ GIMT_Encode4(2483945),
    /*TargetOpcode::G_STRICT_FMUL*//*Label 96*/ GIMT_Encode4(2486373),
    /*TargetOpcode::G_STRICT_FDIV*//*Label 97*/ GIMT_Encode4(2488801), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FMA*//*Label 98*/ GIMT_Encode4(2491229),
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 99*/ GIMT_Encode4(2507874), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_TRAP*//*Label 100*/ GIMT_Encode4(2510050),
    /*TargetOpcode::G_DEBUGTRAP*//*Label 101*/ GIMT_Encode4(2510063), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*RISCV::G_CLZW*//*Label 102*/ GIMT_Encode4(2510076),
    /*RISCV::G_CTZW*//*Label 103*/ GIMT_Encode4(2510171),
    /*RISCV::G_DIVUW*//*Label 104*/ GIMT_Encode4(2510201),
    /*RISCV::G_DIVW*//*Label 105*/ GIMT_Encode4(2510238),
    /*RISCV::G_FCLASS*//*Label 106*/ GIMT_Encode4(2510275),
    /*RISCV::G_FCVT_WU_RV64*//*Label 107*/ GIMT_Encode4(2510635),
    /*RISCV::G_FCVT_W_RV64*//*Label 108*/ GIMT_Encode4(2510833),
    /*RISCV::G_READ_VLENB*//*Label 109*/ GIMT_Encode4(2511031),
    /*RISCV::G_REMUW*//*Label 110*/ GIMT_Encode4(2511091),
    /*RISCV::G_ROLW*//*Label 111*/ GIMT_Encode4(2511128),
    /*RISCV::G_RORW*//*Label 112*/ GIMT_Encode4(2511253),
    /*RISCV::G_SLLW*//*Label 113*/ GIMT_Encode4(2511374), GIMT_Encode4(0),
    /*RISCV::G_SRAW*//*Label 114*/ GIMT_Encode4(2511421),
    /*RISCV::G_SRLW*//*Label 115*/ GIMT_Encode4(2511468),
    /*RISCV::G_VMCLR_VL*//*Label 116*/ GIMT_Encode4(2511515),
    /*RISCV::G_VMSET_VL*//*Label 117*/ GIMT_Encode4(2512164),
    /*RISCV::G_VMV_V_V_VL*//*Label 118*/ GIMT_Encode4(2512813),
    /*RISCV::G_VSLIDEDOWN_VL*//*Label 119*/ GIMT_Encode4(2517071),
    /*RISCV::G_VSLIDEUP_VL*//*Label 120*/ GIMT_Encode4(2531615),
    // Label 0: @1114
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 146*/ GIMT_Encode4(9467),
    /*GILLT_s32*//*Label 122*/ GIMT_Encode4(1249),
    /*GILLT_s64*//*Label 123*/ GIMT_Encode4(2734), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 124*/ GIMT_Encode4(6937),
    /*GILLT_nxv1s16*//*Label 125*/ GIMT_Encode4(7052),
    /*GILLT_nxv1s32*//*Label 126*/ GIMT_Encode4(7167),
    /*GILLT_nxv1s64*//*Label 127*/ GIMT_Encode4(7282), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 128*/ GIMT_Encode4(7397),
    /*GILLT_nxv2s16*//*Label 129*/ GIMT_Encode4(7512),
    /*GILLT_nxv2s32*//*Label 130*/ GIMT_Encode4(7627),
    /*GILLT_nxv2s64*//*Label 131*/ GIMT_Encode4(7742), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 132*/ GIMT_Encode4(7857),
    /*GILLT_nxv4s16*//*Label 133*/ GIMT_Encode4(7972),
    /*GILLT_nxv4s32*//*Label 134*/ GIMT_Encode4(8087),
    /*GILLT_nxv4s64*//*Label 135*/ GIMT_Encode4(8202), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 136*/ GIMT_Encode4(8317),
    /*GILLT_nxv8s16*//*Label 137*/ GIMT_Encode4(8432),
    /*GILLT_nxv8s32*//*Label 138*/ GIMT_Encode4(8547),
    /*GILLT_nxv8s64*//*Label 139*/ GIMT_Encode4(8662), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 140*/ GIMT_Encode4(8777),
    /*GILLT_nxv16s16*//*Label 141*/ GIMT_Encode4(8892),
    /*GILLT_nxv16s32*//*Label 142*/ GIMT_Encode4(9007), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 143*/ GIMT_Encode4(9122),
    /*GILLT_nxv32s16*//*Label 144*/ GIMT_Encode4(9237), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 145*/ GIMT_Encode4(9352),
    // Label 122: @1249
    GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(2733),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(1308), // Rule ID 2428 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:2:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:2:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1:$pred:2:x, GPR:{ *:[i32] }:$rs2:$pred:2:y)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2428,
        GIR_EraseRootFromParent_Done,
      // Label 148: @1308
      GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(1356), // Rule ID 2438 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1:$pred:4:x, GPR:{ *:[i32] }:$rs2:$pred:4:y)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2438,
        GIR_EraseRootFromParent_Done,
      // Label 149: @1356
      GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(1404), // Rule ID 2448 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1:$pred:6:x, GPR:{ *:[i32] }:$rs2:$pred:6:y)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2448,
        GIR_EraseRootFromParent_Done,
      // Label 150: @1404
      GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(1455), // Rule ID 61943 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:24:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:24:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs2:$pred:24:x, GPR:{ *:[i32] }:$rs1:$pred:24:y)<<P:24:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, sh1add_op:{ *:[i32] }:$rs2, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 61943,
        GIR_EraseRootFromParent_Done,
      // Label 151: @1455
      GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(1506), // Rule ID 61947 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:25:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:25:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs2:$pred:25:x, GPR:{ *:[i32] }:$rs1:$pred:25:y)<<P:25:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, sh2add_op:{ *:[i32] }:$rs2, 2:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 61947,
        GIR_EraseRootFromParent_Done,
      // Label 152: @1506
      GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(1557), // Rule ID 61951 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:26:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:26:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs2:$pred:26:x, GPR:{ *:[i32] }:$rs1:$pred:26:y)<<P:26:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, sh3add_op:{ *:[i32] }:$rs2, 3:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 61951,
        GIR_EraseRootFromParent_Done,
      // Label 153: @1557
      GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(1605), // Rule ID 64208 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:2:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:2:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:2:y, sh1add_op:{ *:[i32] }:$rs1:$pred:2:x)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64208,
        GIR_EraseRootFromParent_Done,
      // Label 154: @1605
      GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(1653), // Rule ID 64216 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:4:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:4:y, sh2add_op:{ *:[i32] }:$rs1:$pred:4:x)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64216,
        GIR_EraseRootFromParent_Done,
      // Label 155: @1653
      GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(1701), // Rule ID 64224 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:6:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:6:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:6:y, sh3add_op:{ *:[i32] }:$rs1:$pred:6:x)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64224,
        GIR_EraseRootFromParent_Done,
      // Label 156: @1701
      GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(1752), // Rule ID 72762 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:24:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:24:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1:$pred:24:y, sh1add_op:{ *:[i32] }:$rs2:$pred:24:x)<<P:24:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, sh1add_op:{ *:[i32] }:$rs2, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72762,
        GIR_EraseRootFromParent_Done,
      // Label 157: @1752
      GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(1803), // Rule ID 72766 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:25:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:25:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1:$pred:25:y, sh2add_op:{ *:[i32] }:$rs2:$pred:25:x)<<P:25:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, sh2add_op:{ *:[i32] }:$rs2, 2:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72766,
        GIR_EraseRootFromParent_Done,
      // Label 158: @1803
      GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(1854), // Rule ID 72770 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:26:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:26:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1:$pred:26:y, sh3add_op:{ *:[i32] }:$rs2:$pred:26:x)<<P:26:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, sh3add_op:{ *:[i32] }:$rs2, 3:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72770,
        GIR_EraseRootFromParent_Done,
      // Label 159: @1854
      GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(1922), // Rule ID 2422 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }):$pred:1:x, GPR:{ *:[i32] }:$rs2:$pred:1:y)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2422,
        GIR_EraseRootFromParent_Done,
      // Label 160: @1922
      GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(1990), // Rule ID 2432 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i32] }):$pred:3:x, GPR:{ *:[i32] }:$rs2:$pred:3:y)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2432,
        GIR_EraseRootFromParent_Done,
      // Label 161: @1990
      GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(2058), // Rule ID 2442 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i32] }):$pred:5:x, GPR:{ *:[i32] }:$rs2:$pred:5:y)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2442,
        GIR_EraseRootFromParent_Done,
      // Label 162: @2058
      GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(2126), // Rule ID 64204 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:1:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }):$pred:1:x)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64204,
        GIR_EraseRootFromParent_Done,
      // Label 163: @2126
      GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(2194), // Rule ID 64212 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:3:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:3:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i32] }):$pred:3:x)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64212,
        GIR_EraseRootFromParent_Done,
      // Label 164: @2194
      GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(2262), // Rule ID 64220 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:5:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i32] }):$pred:5:x)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64220,
        GIR_EraseRootFromParent_Done,
      // Label 165: @2262
      GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(2341), // Rule ID 61937 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:23:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:23:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2):$pred:23:x, GPR:{ *:[i32] }:$rs1:$pred:23:y)<<P:23:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 61937,
        GIR_EraseRootFromParent_Done,
      // Label 166: @2341
      GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(2420), // Rule ID 72758 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:23:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:23:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1:$pred:23:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2):$pred:23:x)<<P:23:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72758,
        GIR_EraseRootFromParent_Done,
      // Label 167: @2420
      GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(2469), // Rule ID 115 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FRAME_INDEX),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } (frameindex:{ *:[i32] }):$fi, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$offset)  =>  (ADDI:{ *:[i32] } (to_tframeindex:{ *:[iPTR] } ?:{ *:[i32] }:$fi), (imm:{ *:[i32] })<<P:Predicate_simm12>>:$offset)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderFrameIndex), // fi
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // offset
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 115,
        GIR_EraseRootFromParent_Done,
      // Label 168: @2469
      GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(2511), // Rule ID 75 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 75,
        GIR_EraseRootFromParent_Done,
      // Label 169: @2511
      GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(2583), // Rule ID 285 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_AddiPair),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_9632),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_AddiPair>><<P:Predicate_anonymous_9632>>:$rs2)  =>  (ADDI:{ *:[i32] } (ADDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (AddiPairImmLarge:{ *:[i32] } (imm:{ *:[i32] }):$rs2)), (AddiPairImmSmall:{ *:[i32] } (imm:{ *:[i32] }):$rs2))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderAddiPairImmLarge), // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderAddiPairImmSmall), // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 285,
        GIR_EraseRootFromParent_Done,
      // Label 170: @2583
      GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(2644), // Rule ID 72772 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rd)  =>  (TH_MULA:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/2, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72772,
        GIR_EraseRootFromParent_Done,
      // Label 171: @2644
      GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(2705), // Rule ID 62005 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULA:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 62005,
        GIR_EraseRootFromParent_Done,
      // Label 172: @2705
      GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(2732), // Rule ID 73 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73,
        GIR_Done,
      // Label 173: @2732
      GIM_Reject,
    // Label 147: @2733
    GIM_Reject,
    // Label 123: @2734
    GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(6936),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(2840), // Rule ID 2472 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:11:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934591),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:11:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), 8589934591:{ *:[i64] }):$pred:11:x, GPR:{ *:[i64] }:$rs2:$pred:11:y)<<P:11:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2472,
        GIR_EraseRootFromParent_Done,
      // Label 175: @2840
      GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(2935), // Rule ID 2474 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:12:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 2,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869183),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:12:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), 17179869183:{ *:[i64] }):$pred:12:x, GPR:{ *:[i64] }:$rs2:$pred:12:y)<<P:12:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2474,
        GIR_EraseRootFromParent_Done,
      // Label 176: @2935
      GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(3030), // Rule ID 2476 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:13:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 3,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738367),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:13:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), 34359738367:{ *:[i64] }):$pred:13:x, GPR:{ *:[i64] }:$rs2:$pred:13:y)<<P:13:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2476,
        GIR_EraseRootFromParent_Done,
      // Label 177: @3030
      GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(3125), // Rule ID 2463 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 1:{ *:[i64] }):$pred:8:x, GPR:{ *:[i64] }:$rs2:$pred:8:y)<<P:8:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2463,
        GIR_EraseRootFromParent_Done,
      // Label 178: @3125
      GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(3220), // Rule ID 2466 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 2:{ *:[i64] }):$pred:9:x, GPR:{ *:[i64] }:$rs2:$pred:9:y)<<P:9:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2466,
        GIR_EraseRootFromParent_Done,
      // Label 179: @3220
      GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(3315), // Rule ID 2469 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 3:{ *:[i64] }):$pred:10:x, GPR:{ *:[i64] }:$rs2:$pred:10:y)<<P:10:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2469,
        GIR_EraseRootFromParent_Done,
      // Label 180: @3315
      GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(3410), // Rule ID 64234 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:11:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:11:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934591),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:11:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), 8589934591:{ *:[i64] }):$pred:11:x)<<P:11:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64234,
        GIR_EraseRootFromParent_Done,
      // Label 181: @3410
      GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(3505), // Rule ID 64236 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:12:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:12:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 2,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869183),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:12:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), 17179869183:{ *:[i64] }):$pred:12:x)<<P:12:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64236,
        GIR_EraseRootFromParent_Done,
      // Label 182: @3505
      GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(3600), // Rule ID 64238 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:13:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:13:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 3,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738367),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:13:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), 34359738367:{ *:[i64] }):$pred:13:x)<<P:13:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64238,
        GIR_EraseRootFromParent_Done,
      // Label 183: @3600
      GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(3695), // Rule ID 64228 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:8:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:8:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:8:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 1:{ *:[i64] }):$pred:8:x)<<P:8:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64228,
        GIR_EraseRootFromParent_Done,
      // Label 184: @3695
      GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(3790), // Rule ID 64230 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:9:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:9:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:9:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 2:{ *:[i64] }):$pred:9:x)<<P:9:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64230,
        GIR_EraseRootFromParent_Done,
      // Label 185: @3790
      GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(3885), // Rule ID 64232 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:10:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:10:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:10:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 3:{ *:[i64] }):$pred:10:x)<<P:10:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64232,
        GIR_EraseRootFromParent_Done,
      // Label 186: @3885
      GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(3933), // Rule ID 2427 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:2:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:2:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1:$pred:2:x, GPR:{ *:[i64] }:$rs2:$pred:2:y)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2427,
        GIR_EraseRootFromParent_Done,
      // Label 187: @3933
      GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(3981), // Rule ID 2437 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1:$pred:4:x, GPR:{ *:[i64] }:$rs2:$pred:4:y)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2437,
        GIR_EraseRootFromParent_Done,
      // Label 188: @3981
      GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(4029), // Rule ID 2447 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1:$pred:6:x, GPR:{ *:[i64] }:$rs2:$pred:6:y)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2447,
        GIR_EraseRootFromParent_Done,
      // Label 189: @4029
      GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(4077), // Rule ID 2478 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:14:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:14:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_uw_op),
        // (add:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1:$pred:14:x, GPR:{ *:[i64] }:$rs2:$pred:14:y)<<P:14:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2478,
        GIR_EraseRootFromParent_Done,
      // Label 190: @4077
      GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(4125), // Rule ID 2480 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:15:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:15:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_uw_op),
        // (add:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1:$pred:15:x, GPR:{ *:[i64] }:$rs2:$pred:15:y)<<P:15:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2480,
        GIR_EraseRootFromParent_Done,
      // Label 191: @4125
      GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(4173), // Rule ID 2482 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:16:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:16:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_uw_op),
        // (add:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1:$pred:16:x, GPR:{ *:[i64] }:$rs2:$pred:16:y)<<P:16:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2482,
        GIR_EraseRootFromParent_Done,
      // Label 192: @4173
      GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(4224), // Rule ID 61942 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:24:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:24:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs2:$pred:24:x, GPR:{ *:[i64] }:$rs1:$pred:24:y)<<P:24:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, sh1add_op:{ *:[i64] }:$rs2, 1:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 61942,
        GIR_EraseRootFromParent_Done,
      // Label 193: @4224
      GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(4275), // Rule ID 61946 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:25:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:25:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs2:$pred:25:x, GPR:{ *:[i64] }:$rs1:$pred:25:y)<<P:25:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, sh2add_op:{ *:[i64] }:$rs2, 2:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 61946,
        GIR_EraseRootFromParent_Done,
      // Label 194: @4275
      GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(4326), // Rule ID 61950 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:26:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:26:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs2:$pred:26:x, GPR:{ *:[i64] }:$rs1:$pred:26:y)<<P:26:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, sh3add_op:{ *:[i64] }:$rs2, 3:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 61950,
        GIR_EraseRootFromParent_Done,
      // Label 195: @4326
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(4374), // Rule ID 64207 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:2:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:2:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:2:y, sh1add_op:{ *:[i64] }:$rs1:$pred:2:x)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64207,
        GIR_EraseRootFromParent_Done,
      // Label 196: @4374
      GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(4422), // Rule ID 64215 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:4:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:4:y, sh2add_op:{ *:[i64] }:$rs1:$pred:4:x)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64215,
        GIR_EraseRootFromParent_Done,
      // Label 197: @4422
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(4470), // Rule ID 64223 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:6:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:6:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:6:y, sh3add_op:{ *:[i64] }:$rs1:$pred:6:x)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64223,
        GIR_EraseRootFromParent_Done,
      // Label 198: @4470
      GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(4518), // Rule ID 64240 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:14:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:14:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_uw_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:14:y, sh1add_uw_op:{ *:[i64] }:$rs1:$pred:14:x)<<P:14:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64240,
        GIR_EraseRootFromParent_Done,
      // Label 199: @4518
      GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(4566), // Rule ID 64242 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:15:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:15:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_uw_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:15:y, sh2add_uw_op:{ *:[i64] }:$rs1:$pred:15:x)<<P:15:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64242,
        GIR_EraseRootFromParent_Done,
      // Label 200: @4566
      GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(4614), // Rule ID 64244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:16:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:16:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_uw_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:16:y, sh3add_uw_op:{ *:[i64] }:$rs1:$pred:16:x)<<P:16:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64244,
        GIR_EraseRootFromParent_Done,
      // Label 201: @4614
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(4665), // Rule ID 72761 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:24:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:24:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1:$pred:24:y, sh1add_op:{ *:[i64] }:$rs2:$pred:24:x)<<P:24:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, sh1add_op:{ *:[i64] }:$rs2, 1:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72761,
        GIR_EraseRootFromParent_Done,
      // Label 202: @4665
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(4716), // Rule ID 72765 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:25:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:25:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1:$pred:25:y, sh2add_op:{ *:[i64] }:$rs2:$pred:25:x)<<P:25:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, sh2add_op:{ *:[i64] }:$rs2, 2:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72765,
        GIR_EraseRootFromParent_Done,
      // Label 203: @4716
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(4767), // Rule ID 72769 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:26:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:26:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1:$pred:26:y, sh3add_op:{ *:[i64] }:$rs2:$pred:26:x)<<P:26:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, sh3add_op:{ *:[i64] }:$rs2, 3:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72769,
        GIR_EraseRootFromParent_Done,
      // Label 204: @4767
      GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(4842), // Rule ID 2460 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }):$pred:7:x, GPR:{ *:[i64] }:$rs2:$pred:7:y)<<P:7:Predicate_add_like_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2460,
        GIR_EraseRootFromParent_Done,
      // Label 205: @4842
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(4937), // Rule ID 2484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:17:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967294),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:17:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967294:{ *:[i64] }):$pred:17:x, GPR:{ *:[i64] }:$rs2:$pred:17:y)<<P:17:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2484,
        GIR_EraseRootFromParent_Done,
      // Label 206: @4937
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(5032), // Rule ID 2486 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:18:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967292),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:18:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967292:{ *:[i64] }):$pred:18:x, GPR:{ *:[i64] }:$rs2:$pred:18:y)<<P:18:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2486,
        GIR_EraseRootFromParent_Done,
      // Label 207: @5032
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(5127), // Rule ID 2488 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:19:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:19:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:19:x, GPR:{ *:[i64] }:$rs2:$pred:19:y)<<P:19:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2488,
        GIR_EraseRootFromParent_Done,
      // Label 208: @5127
      GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(5222), // Rule ID 2490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:20:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934590),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:20:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 8589934590:{ *:[i64] }):$pred:20:x, GPR:{ *:[i64] }:$rs2:$pred:20:y)<<P:20:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2490,
        GIR_EraseRootFromParent_Done,
      // Label 209: @5222
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(5317), // Rule ID 2492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:21:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869180),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:21:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 17179869180:{ *:[i64] }):$pred:21:x, GPR:{ *:[i64] }:$rs2:$pred:21:y)<<P:21:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2492,
        GIR_EraseRootFromParent_Done,
      // Label 210: @5317
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(5412), // Rule ID 2494 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:22:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738360),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:22:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 34359738360:{ *:[i64] }):$pred:22:x, GPR:{ *:[i64] }:$rs2:$pred:22:y)<<P:22:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2494,
        GIR_EraseRootFromParent_Done,
      // Label 211: @5412
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(5480), // Rule ID 2421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }):$pred:1:x, GPR:{ *:[i64] }:$rs2:$pred:1:y)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2421,
        GIR_EraseRootFromParent_Done,
      // Label 212: @5480
      GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(5548), // Rule ID 2431 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }):$pred:3:x, GPR:{ *:[i64] }:$rs2:$pred:3:y)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2431,
        GIR_EraseRootFromParent_Done,
      // Label 213: @5548
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(5616), // Rule ID 2441 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }):$pred:5:x, GPR:{ *:[i64] }:$rs2:$pred:5:y)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2441,
        GIR_EraseRootFromParent_Done,
      // Label 214: @5616
      GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(5691), // Rule ID 64226 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:7:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:7:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }):$pred:7:x)<<P:7:Predicate_add_like_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64226,
        GIR_EraseRootFromParent_Done,
      // Label 215: @5691
      GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(5786), // Rule ID 64246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:17:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:17:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967294),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:17:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967294:{ *:[i64] }):$pred:17:x)<<P:17:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64246,
        GIR_EraseRootFromParent_Done,
      // Label 216: @5786
      GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(5881), // Rule ID 64248 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:18:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:18:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967292),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:18:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967292:{ *:[i64] }):$pred:18:x)<<P:18:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64248,
        GIR_EraseRootFromParent_Done,
      // Label 217: @5881
      GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(5976), // Rule ID 64250 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:19:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:19:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:19:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:19:x)<<P:19:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64250,
        GIR_EraseRootFromParent_Done,
      // Label 218: @5976
      GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(6071), // Rule ID 64252 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:20:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:20:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934590),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:20:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 8589934590:{ *:[i64] }):$pred:20:x)<<P:20:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64252,
        GIR_EraseRootFromParent_Done,
      // Label 219: @6071
      GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(6166), // Rule ID 64254 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:21:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:21:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869180),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:21:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 17179869180:{ *:[i64] }):$pred:21:x)<<P:21:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64254,
        GIR_EraseRootFromParent_Done,
      // Label 220: @6166
      GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(6261), // Rule ID 64256 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:22:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:22:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738360),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:22:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 34359738360:{ *:[i64] }):$pred:22:x)<<P:22:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64256,
        GIR_EraseRootFromParent_Done,
      // Label 221: @6261
      GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(6329), // Rule ID 64203 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:1:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }):$pred:1:x)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64203,
        GIR_EraseRootFromParent_Done,
      // Label 222: @6329
      GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(6397), // Rule ID 64211 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:3:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:3:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }):$pred:3:x)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64211,
        GIR_EraseRootFromParent_Done,
      // Label 223: @6397
      GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(6465), // Rule ID 64219 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:5:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }):$pred:5:x)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64219,
        GIR_EraseRootFromParent_Done,
      // Label 224: @6465
      GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(6544), // Rule ID 61936 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:23:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:23:y
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2):$pred:23:x, GPR:{ *:[i64] }:$rs1:$pred:23:y)<<P:23:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 61936,
        GIR_EraseRootFromParent_Done,
      // Label 225: @6544
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(6623), // Rule ID 72757 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:23:y
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:23:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1:$pred:23:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2):$pred:23:x)<<P:23:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72757,
        GIR_EraseRootFromParent_Done,
      // Label 226: @6623
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(6672), // Rule ID 114 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FRAME_INDEX),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (frameindex:{ *:[i64] }):$fi, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$offset)  =>  (ADDI:{ *:[i64] } (to_tframeindex:{ *:[iPTR] } ?:{ *:[i64] }:$fi), (imm:{ *:[i64] })<<P:Predicate_simm12>>:$offset)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderFrameIndex), // fi
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // offset
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 114,
        GIR_EraseRootFromParent_Done,
      // Label 227: @6672
      GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(6714), // Rule ID 74 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 74,
        GIR_EraseRootFromParent_Done,
      // Label 228: @6714
      GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(6786), // Rule ID 284 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_AddiPair),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_9632),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_AddiPair>><<P:Predicate_anonymous_9632>>:$rs2)  =>  (ADDI:{ *:[i64] } (ADDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (AddiPairImmLarge:{ *:[i64] } (imm:{ *:[i64] }):$rs2)), (AddiPairImmSmall:{ *:[i64] } (imm:{ *:[i64] }):$rs2))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderAddiPairImmLarge), // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderAddiPairImmSmall), // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 284,
        GIR_EraseRootFromParent_Done,
      // Label 229: @6786
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(6847), // Rule ID 72771 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rd)  =>  (TH_MULA:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/2, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72771,
        GIR_EraseRootFromParent_Done,
      // Label 230: @6847
      GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(6908), // Rule ID 62004 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rd, (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (TH_MULA:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 62004,
        GIR_EraseRootFromParent_Done,
      // Label 231: @6908
      GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(6935), // Rule ID 72 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72,
        GIR_Done,
      // Label 232: @6935
      GIM_Reject,
    // Label 174: @6936
    GIM_Reject,
    // Label 124: @6937
    GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(7051),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(7005), // Rule ID 45528 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45528,
        GIR_EraseRootFromParent_Done,
      // Label 234: @7005
      GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(7050), // Rule ID 45529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45529,
        GIR_EraseRootFromParent_Done,
      // Label 235: @7050
      GIM_Reject,
    // Label 233: @7051
    GIM_Reject,
    // Label 125: @7052
    GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(7166),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(7120), // Rule ID 45888 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45888,
        GIR_EraseRootFromParent_Done,
      // Label 237: @7120
      GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(7165), // Rule ID 45889 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45889,
        GIR_EraseRootFromParent_Done,
      // Label 238: @7165
      GIM_Reject,
    // Label 236: @7166
    GIM_Reject,
    // Label 126: @7167
    GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(7281),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(7235), // Rule ID 45896 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45896,
        GIR_EraseRootFromParent_Done,
      // Label 240: @7235
      GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(7280), // Rule ID 45897 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45897,
        GIR_EraseRootFromParent_Done,
      // Label 241: @7280
      GIM_Reject,
    // Label 239: @7281
    GIM_Reject,
    // Label 127: @7282
    GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(7396),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(7350), // Rule ID 45912 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45912,
        GIR_EraseRootFromParent_Done,
      // Label 243: @7350
      GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(7395), // Rule ID 45913 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45913,
        GIR_EraseRootFromParent_Done,
      // Label 244: @7395
      GIM_Reject,
    // Label 242: @7396
    GIM_Reject,
    // Label 128: @7397
    GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(7511),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(7465), // Rule ID 45880 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45880,
        GIR_EraseRootFromParent_Done,
      // Label 246: @7465
      GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(7510), // Rule ID 45881 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45881,
        GIR_EraseRootFromParent_Done,
      // Label 247: @7510
      GIM_Reject,
    // Label 245: @7511
    GIM_Reject,
    // Label 129: @7512
    GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(7626),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(7580), // Rule ID 45892 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45892,
        GIR_EraseRootFromParent_Done,
      // Label 249: @7580
      GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(7625), // Rule ID 45893 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45893,
        GIR_EraseRootFromParent_Done,
      // Label 250: @7625
      GIM_Reject,
    // Label 248: @7626
    GIM_Reject,
    // Label 130: @7627
    GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(7741),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(7695), // Rule ID 45908 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45908,
        GIR_EraseRootFromParent_Done,
      // Label 252: @7695
      GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(7740), // Rule ID 45909 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45909,
        GIR_EraseRootFromParent_Done,
      // Label 253: @7740
      GIM_Reject,
    // Label 251: @7741
    GIM_Reject,
    // Label 131: @7742
    GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(7856),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(7810), // Rule ID 45952 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45952,
        GIR_EraseRootFromParent_Done,
      // Label 255: @7810
      GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(7855), // Rule ID 45953 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45953,
        GIR_EraseRootFromParent_Done,
      // Label 256: @7855
      GIM_Reject,
    // Label 254: @7856
    GIM_Reject,
    // Label 132: @7857
    GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(7971),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(7925), // Rule ID 45884 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45884,
        GIR_EraseRootFromParent_Done,
      // Label 258: @7925
      GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(7970), // Rule ID 45885 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45885,
        GIR_EraseRootFromParent_Done,
      // Label 259: @7970
      GIM_Reject,
    // Label 257: @7971
    GIM_Reject,
    // Label 133: @7972
    GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(8086),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(8040), // Rule ID 45904 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45904,
        GIR_EraseRootFromParent_Done,
      // Label 261: @8040
      GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(8085), // Rule ID 45905 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45905,
        GIR_EraseRootFromParent_Done,
      // Label 262: @8085
      GIM_Reject,
    // Label 260: @8086
    GIM_Reject,
    // Label 134: @8087
    GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(8201),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(8155), // Rule ID 45940 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45940,
        GIR_EraseRootFromParent_Done,
      // Label 264: @8155
      GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(8200), // Rule ID 45941 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45941,
        GIR_EraseRootFromParent_Done,
      // Label 265: @8200
      GIM_Reject,
    // Label 263: @8201
    GIM_Reject,
    // Label 135: @8202
    GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(8316),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(8270), // Rule ID 45956 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45956,
        GIR_EraseRootFromParent_Done,
      // Label 267: @8270
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(8315), // Rule ID 45957 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45957,
        GIR_EraseRootFromParent_Done,
      // Label 268: @8315
      GIM_Reject,
    // Label 266: @8316
    GIM_Reject,
    // Label 136: @8317
    GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(8431),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(8385), // Rule ID 45900 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45900,
        GIR_EraseRootFromParent_Done,
      // Label 270: @8385
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(8430), // Rule ID 45901 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45901,
        GIR_EraseRootFromParent_Done,
      // Label 271: @8430
      GIM_Reject,
    // Label 269: @8431
    GIM_Reject,
    // Label 137: @8432
    GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(8546),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(8500), // Rule ID 45928 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45928,
        GIR_EraseRootFromParent_Done,
      // Label 273: @8500
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(8545), // Rule ID 45929 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45929,
        GIR_EraseRootFromParent_Done,
      // Label 274: @8545
      GIM_Reject,
    // Label 272: @8546
    GIM_Reject,
    // Label 138: @8547
    GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(8661),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(8615), // Rule ID 45944 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45944,
        GIR_EraseRootFromParent_Done,
      // Label 276: @8615
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(8660), // Rule ID 45945 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45945,
        GIR_EraseRootFromParent_Done,
      // Label 277: @8660
      GIM_Reject,
    // Label 275: @8661
    GIM_Reject,
    // Label 139: @8662
    GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(8776),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(8730), // Rule ID 45960 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45960,
        GIR_EraseRootFromParent_Done,
      // Label 279: @8730
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(8775), // Rule ID 45961 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45961,
        GIR_EraseRootFromParent_Done,
      // Label 280: @8775
      GIM_Reject,
    // Label 278: @8776
    GIM_Reject,
    // Label 140: @8777
    GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(8891),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(8845), // Rule ID 45916 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45916,
        GIR_EraseRootFromParent_Done,
      // Label 282: @8845
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(8890), // Rule ID 45917 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45917,
        GIR_EraseRootFromParent_Done,
      // Label 283: @8890
      GIM_Reject,
    // Label 281: @8891
    GIM_Reject,
    // Label 141: @8892
    GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(9006),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(8960), // Rule ID 45932 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45932,
        GIR_EraseRootFromParent_Done,
      // Label 285: @8960
      GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(9005), // Rule ID 45933 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45933,
        GIR_EraseRootFromParent_Done,
      // Label 286: @9005
      GIM_Reject,
    // Label 284: @9006
    GIM_Reject,
    // Label 142: @9007
    GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(9121),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(9075), // Rule ID 45948 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45948,
        GIR_EraseRootFromParent_Done,
      // Label 288: @9075
      GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(9120), // Rule ID 45949 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45949,
        GIR_EraseRootFromParent_Done,
      // Label 289: @9120
      GIM_Reject,
    // Label 287: @9121
    GIM_Reject,
    // Label 143: @9122
    GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(9236),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(9190), // Rule ID 45920 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45920,
        GIR_EraseRootFromParent_Done,
      // Label 291: @9190
      GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(9235), // Rule ID 45921 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45921,
        GIR_EraseRootFromParent_Done,
      // Label 292: @9235
      GIM_Reject,
    // Label 290: @9236
    GIM_Reject,
    // Label 144: @9237
    GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(9351),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(9305), // Rule ID 45936 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45936,
        GIR_EraseRootFromParent_Done,
      // Label 294: @9305
      GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(9350), // Rule ID 45937 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45937,
        GIR_EraseRootFromParent_Done,
      // Label 295: @9350
      GIM_Reject,
    // Label 293: @9351
    GIM_Reject,
    // Label 145: @9352
    GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(9466),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(9420), // Rule ID 45924 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45924,
        GIR_EraseRootFromParent_Done,
      // Label 297: @9420
      GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(9465), // Rule ID 45925 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45925,
        GIR_EraseRootFromParent_Done,
      // Label 298: @9465
      GIM_Reject,
    // Label 296: @9466
    GIM_Reject,
    // Label 146: @9467
    GIM_Reject,
    // Label 1: @9468
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 323*/ GIMT_Encode4(12319),
    /*GILLT_s32*//*Label 299*/ GIMT_Encode4(9603),
    /*GILLT_s64*//*Label 300*/ GIMT_Encode4(9696), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 301*/ GIMT_Encode4(9789),
    /*GILLT_nxv1s16*//*Label 302*/ GIMT_Encode4(9904),
    /*GILLT_nxv1s32*//*Label 303*/ GIMT_Encode4(10019),
    /*GILLT_nxv1s64*//*Label 304*/ GIMT_Encode4(10134), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 305*/ GIMT_Encode4(10249),
    /*GILLT_nxv2s16*//*Label 306*/ GIMT_Encode4(10364),
    /*GILLT_nxv2s32*//*Label 307*/ GIMT_Encode4(10479),
    /*GILLT_nxv2s64*//*Label 308*/ GIMT_Encode4(10594), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 309*/ GIMT_Encode4(10709),
    /*GILLT_nxv4s16*//*Label 310*/ GIMT_Encode4(10824),
    /*GILLT_nxv4s32*//*Label 311*/ GIMT_Encode4(10939),
    /*GILLT_nxv4s64*//*Label 312*/ GIMT_Encode4(11054), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 313*/ GIMT_Encode4(11169),
    /*GILLT_nxv8s16*//*Label 314*/ GIMT_Encode4(11284),
    /*GILLT_nxv8s32*//*Label 315*/ GIMT_Encode4(11399),
    /*GILLT_nxv8s64*//*Label 316*/ GIMT_Encode4(11514), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 317*/ GIMT_Encode4(11629),
    /*GILLT_nxv16s16*//*Label 318*/ GIMT_Encode4(11744),
    /*GILLT_nxv16s32*//*Label 319*/ GIMT_Encode4(11859), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 320*/ GIMT_Encode4(11974),
    /*GILLT_nxv32s16*//*Label 321*/ GIMT_Encode4(12089), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 322*/ GIMT_Encode4(12204),
    // Label 299: @9603
    GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(9695),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(9675), // Rule ID 62007 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULS:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 62007,
        GIR_EraseRootFromParent_Done,
      // Label 325: @9675
      GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(9694), // Rule ID 77 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (SUB:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SUB),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 77,
        GIR_Done,
      // Label 326: @9694
      GIM_Reject,
    // Label 324: @9695
    GIM_Reject,
    // Label 300: @9696
    GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(9788),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(9768), // Rule ID 62006 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rd, (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (TH_MULS:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
        GIR_RootToRootCopy, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 62006,
        GIR_EraseRootFromParent_Done,
      // Label 328: @9768
      GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(9787), // Rule ID 76 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (SUB:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SUB),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 76,
        GIR_Done,
      // Label 329: @9787
      GIM_Reject,
    // Label 327: @9788
    GIM_Reject,
    // Label 301: @9789
    GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(9903),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(9857), // Rule ID 46006 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46006,
        GIR_EraseRootFromParent_Done,
      // Label 331: @9857
      GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(9902), // Rule ID 46007 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46007,
        GIR_EraseRootFromParent_Done,
      // Label 332: @9902
      GIM_Reject,
    // Label 330: @9903
    GIM_Reject,
    // Label 302: @9904
    GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(10018),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(9972), // Rule ID 46018 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46018,
        GIR_EraseRootFromParent_Done,
      // Label 334: @9972
      GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(10017), // Rule ID 46019 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46019,
        GIR_EraseRootFromParent_Done,
      // Label 335: @10017
      GIM_Reject,
    // Label 333: @10018
    GIM_Reject,
    // Label 303: @10019
    GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(10133),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(10087), // Rule ID 46026 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46026,
        GIR_EraseRootFromParent_Done,
      // Label 337: @10087
      GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(10132), // Rule ID 46027 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46027,
        GIR_EraseRootFromParent_Done,
      // Label 338: @10132
      GIM_Reject,
    // Label 336: @10133
    GIM_Reject,
    // Label 304: @10134
    GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(10248),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(10202), // Rule ID 46042 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46042,
        GIR_EraseRootFromParent_Done,
      // Label 340: @10202
      GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(10247), // Rule ID 46043 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46043,
        GIR_EraseRootFromParent_Done,
      // Label 341: @10247
      GIM_Reject,
    // Label 339: @10248
    GIM_Reject,
    // Label 305: @10249
    GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(10363),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(10317), // Rule ID 46010 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46010,
        GIR_EraseRootFromParent_Done,
      // Label 343: @10317
      GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(10362), // Rule ID 46011 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46011,
        GIR_EraseRootFromParent_Done,
      // Label 344: @10362
      GIM_Reject,
    // Label 342: @10363
    GIM_Reject,
    // Label 306: @10364
    GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(10478),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(10432), // Rule ID 46022 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46022,
        GIR_EraseRootFromParent_Done,
      // Label 346: @10432
      GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(10477), // Rule ID 46023 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46023,
        GIR_EraseRootFromParent_Done,
      // Label 347: @10477
      GIM_Reject,
    // Label 345: @10478
    GIM_Reject,
    // Label 307: @10479
    GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(10593),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(10547), // Rule ID 46038 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46038,
        GIR_EraseRootFromParent_Done,
      // Label 349: @10547
      GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(10592), // Rule ID 46039 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46039,
        GIR_EraseRootFromParent_Done,
      // Label 350: @10592
      GIM_Reject,
    // Label 348: @10593
    GIM_Reject,
    // Label 308: @10594
    GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(10708),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(10662), // Rule ID 46082 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46082,
        GIR_EraseRootFromParent_Done,
      // Label 352: @10662
      GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(10707), // Rule ID 46083 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46083,
        GIR_EraseRootFromParent_Done,
      // Label 353: @10707
      GIM_Reject,
    // Label 351: @10708
    GIM_Reject,
    // Label 309: @10709
    GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(10823),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(10777), // Rule ID 46014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46014,
        GIR_EraseRootFromParent_Done,
      // Label 355: @10777
      GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(10822), // Rule ID 46015 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46015,
        GIR_EraseRootFromParent_Done,
      // Label 356: @10822
      GIM_Reject,
    // Label 354: @10823
    GIM_Reject,
    // Label 310: @10824
    GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(10938),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(10892), // Rule ID 46034 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46034,
        GIR_EraseRootFromParent_Done,
      // Label 358: @10892
      GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(10937), // Rule ID 46035 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46035,
        GIR_EraseRootFromParent_Done,
      // Label 359: @10937
      GIM_Reject,
    // Label 357: @10938
    GIM_Reject,
    // Label 311: @10939
    GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(11053),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(11007), // Rule ID 46070 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46070,
        GIR_EraseRootFromParent_Done,
      // Label 361: @11007
      GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(11052), // Rule ID 46071 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46071,
        GIR_EraseRootFromParent_Done,
      // Label 362: @11052
      GIM_Reject,
    // Label 360: @11053
    GIM_Reject,
    // Label 312: @11054
    GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(11168),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(11122), // Rule ID 46086 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46086,
        GIR_EraseRootFromParent_Done,
      // Label 364: @11122
      GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(11167), // Rule ID 46087 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46087,
        GIR_EraseRootFromParent_Done,
      // Label 365: @11167
      GIM_Reject,
    // Label 363: @11168
    GIM_Reject,
    // Label 313: @11169
    GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(11283),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(11237), // Rule ID 46030 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46030,
        GIR_EraseRootFromParent_Done,
      // Label 367: @11237
      GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(11282), // Rule ID 46031 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46031,
        GIR_EraseRootFromParent_Done,
      // Label 368: @11282
      GIM_Reject,
    // Label 366: @11283
    GIM_Reject,
    // Label 314: @11284
    GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(11398),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(11352), // Rule ID 46058 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46058,
        GIR_EraseRootFromParent_Done,
      // Label 370: @11352
      GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(11397), // Rule ID 46059 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46059,
        GIR_EraseRootFromParent_Done,
      // Label 371: @11397
      GIM_Reject,
    // Label 369: @11398
    GIM_Reject,
    // Label 315: @11399
    GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(11513),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(11467), // Rule ID 46074 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46074,
        GIR_EraseRootFromParent_Done,
      // Label 373: @11467
      GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(11512), // Rule ID 46075 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46075,
        GIR_EraseRootFromParent_Done,
      // Label 374: @11512
      GIM_Reject,
    // Label 372: @11513
    GIM_Reject,
    // Label 316: @11514
    GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(11628),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(11582), // Rule ID 46090 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46090,
        GIR_EraseRootFromParent_Done,
      // Label 376: @11582
      GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(11627), // Rule ID 46091 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46091,
        GIR_EraseRootFromParent_Done,
      // Label 377: @11627
      GIM_Reject,
    // Label 375: @11628
    GIM_Reject,
    // Label 317: @11629
    GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(11743),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(11697), // Rule ID 46046 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46046,
        GIR_EraseRootFromParent_Done,
      // Label 379: @11697
      GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(11742), // Rule ID 46047 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46047,
        GIR_EraseRootFromParent_Done,
      // Label 380: @11742
      GIM_Reject,
    // Label 378: @11743
    GIM_Reject,
    // Label 318: @11744
    GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(11858),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(11812), // Rule ID 46062 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46062,
        GIR_EraseRootFromParent_Done,
      // Label 382: @11812
      GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(11857), // Rule ID 46063 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46063,
        GIR_EraseRootFromParent_Done,
      // Label 383: @11857
      GIM_Reject,
    // Label 381: @11858
    GIM_Reject,
    // Label 319: @11859
    GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(11973),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(11927), // Rule ID 46078 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46078,
        GIR_EraseRootFromParent_Done,
      // Label 385: @11927
      GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(11972), // Rule ID 46079 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46079,
        GIR_EraseRootFromParent_Done,
      // Label 386: @11972
      GIM_Reject,
    // Label 384: @11973
    GIM_Reject,
    // Label 320: @11974
    GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(12088),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(12042), // Rule ID 46050 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46050,
        GIR_EraseRootFromParent_Done,
      // Label 388: @12042
      GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(12087), // Rule ID 46051 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46051,
        GIR_EraseRootFromParent_Done,
      // Label 389: @12087
      GIM_Reject,
    // Label 387: @12088
    GIM_Reject,
    // Label 321: @12089
    GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(12203),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(12157), // Rule ID 46066 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46066,
        GIR_EraseRootFromParent_Done,
      // Label 391: @12157
      GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(12202), // Rule ID 46067 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46067,
        GIR_EraseRootFromParent_Done,
      // Label 392: @12202
      GIM_Reject,
    // Label 390: @12203
    GIM_Reject,
    // Label 322: @12204
    GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(12318),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(12272), // Rule ID 46054 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46054,
        GIR_EraseRootFromParent_Done,
      // Label 394: @12272
      GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(12317), // Rule ID 46055 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46055,
        GIR_EraseRootFromParent_Done,
      // Label 395: @12317
      GIM_Reject,
    // Label 393: @12318
    GIM_Reject,
    // Label 323: @12319
    GIM_Reject,
    // Label 2: @12320
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 420*/ GIMT_Encode4(15188),
    /*GILLT_s32*//*Label 396*/ GIMT_Encode4(12455),
    /*GILLT_s64*//*Label 397*/ GIMT_Encode4(12489), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 398*/ GIMT_Encode4(12658),
    /*GILLT_nxv1s16*//*Label 399*/ GIMT_Encode4(12773),
    /*GILLT_nxv1s32*//*Label 400*/ GIMT_Encode4(12888),
    /*GILLT_nxv1s64*//*Label 401*/ GIMT_Encode4(13003), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 402*/ GIMT_Encode4(13118),
    /*GILLT_nxv2s16*//*Label 403*/ GIMT_Encode4(13233),
    /*GILLT_nxv2s32*//*Label 404*/ GIMT_Encode4(13348),
    /*GILLT_nxv2s64*//*Label 405*/ GIMT_Encode4(13463), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 406*/ GIMT_Encode4(13578),
    /*GILLT_nxv4s16*//*Label 407*/ GIMT_Encode4(13693),
    /*GILLT_nxv4s32*//*Label 408*/ GIMT_Encode4(13808),
    /*GILLT_nxv4s64*//*Label 409*/ GIMT_Encode4(13923), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 410*/ GIMT_Encode4(14038),
    /*GILLT_nxv8s16*//*Label 411*/ GIMT_Encode4(14153),
    /*GILLT_nxv8s32*//*Label 412*/ GIMT_Encode4(14268),
    /*GILLT_nxv8s64*//*Label 413*/ GIMT_Encode4(14383), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 414*/ GIMT_Encode4(14498),
    /*GILLT_nxv16s16*//*Label 415*/ GIMT_Encode4(14613),
    /*GILLT_nxv16s32*//*Label 416*/ GIMT_Encode4(14728), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 417*/ GIMT_Encode4(14843),
    /*GILLT_nxv32s16*//*Label 418*/ GIMT_Encode4(14958), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 419*/ GIMT_Encode4(15073),
    // Label 396: @12455
    GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(12488), // Rule ID 288 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZmmul_HwMode1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (MUL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MUL),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 288,
      GIR_Done,
    // Label 421: @12488
    GIM_Reject,
    // Label 397: @12489
    GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(12657),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(12633), // Rule ID 310 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZmmul_IsRV64_NotHasStdExtZba_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 4294967295:{ *:[i64] }))  =>  (MULHU:{ *:[i64] } (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 32:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/2, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::MULHU),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 310,
        GIR_EraseRootFromParent_Done,
      // Label 423: @12633
      GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(12656), // Rule ID 287 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZmmul_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (MUL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MUL),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 287,
        GIR_Done,
      // Label 424: @12656
      GIM_Reject,
    // Label 422: @12657
    GIM_Reject,
    // Label 398: @12658
    GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(12772),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(12726), // Rule ID 50410 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50410,
        GIR_EraseRootFromParent_Done,
      // Label 426: @12726
      GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(12771), // Rule ID 50411 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50411,
        GIR_EraseRootFromParent_Done,
      // Label 427: @12771
      GIM_Reject,
    // Label 425: @12772
    GIM_Reject,
    // Label 399: @12773
    GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(12887),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(12841), // Rule ID 50422 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50422,
        GIR_EraseRootFromParent_Done,
      // Label 429: @12841
      GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(12886), // Rule ID 50423 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50423,
        GIR_EraseRootFromParent_Done,
      // Label 430: @12886
      GIM_Reject,
    // Label 428: @12887
    GIM_Reject,
    // Label 400: @12888
    GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(13002),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(12956), // Rule ID 50430 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50430,
        GIR_EraseRootFromParent_Done,
      // Label 432: @12956
      GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(13001), // Rule ID 50431 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50431,
        GIR_EraseRootFromParent_Done,
      // Label 433: @13001
      GIM_Reject,
    // Label 431: @13002
    GIM_Reject,
    // Label 401: @13003
    GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(13117),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(13071), // Rule ID 50446 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50446,
        GIR_EraseRootFromParent_Done,
      // Label 435: @13071
      GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(13116), // Rule ID 50447 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50447,
        GIR_EraseRootFromParent_Done,
      // Label 436: @13116
      GIM_Reject,
    // Label 434: @13117
    GIM_Reject,
    // Label 402: @13118
    GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(13232),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(13186), // Rule ID 50414 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50414,
        GIR_EraseRootFromParent_Done,
      // Label 438: @13186
      GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(13231), // Rule ID 50415 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50415,
        GIR_EraseRootFromParent_Done,
      // Label 439: @13231
      GIM_Reject,
    // Label 437: @13232
    GIM_Reject,
    // Label 403: @13233
    GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(13347),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(13301), // Rule ID 50426 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50426,
        GIR_EraseRootFromParent_Done,
      // Label 441: @13301
      GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(13346), // Rule ID 50427 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50427,
        GIR_EraseRootFromParent_Done,
      // Label 442: @13346
      GIM_Reject,
    // Label 440: @13347
    GIM_Reject,
    // Label 404: @13348
    GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(13462),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(13416), // Rule ID 50442 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50442,
        GIR_EraseRootFromParent_Done,
      // Label 444: @13416
      GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(13461), // Rule ID 50443 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50443,
        GIR_EraseRootFromParent_Done,
      // Label 445: @13461
      GIM_Reject,
    // Label 443: @13462
    GIM_Reject,
    // Label 405: @13463
    GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(13577),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(13531), // Rule ID 50486 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50486,
        GIR_EraseRootFromParent_Done,
      // Label 447: @13531
      GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(13576), // Rule ID 50487 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50487,
        GIR_EraseRootFromParent_Done,
      // Label 448: @13576
      GIM_Reject,
    // Label 446: @13577
    GIM_Reject,
    // Label 406: @13578
    GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(13692),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(13646), // Rule ID 50418 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50418,
        GIR_EraseRootFromParent_Done,
      // Label 450: @13646
      GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(13691), // Rule ID 50419 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50419,
        GIR_EraseRootFromParent_Done,
      // Label 451: @13691
      GIM_Reject,
    // Label 449: @13692
    GIM_Reject,
    // Label 407: @13693
    GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(13807),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(13761), // Rule ID 50438 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50438,
        GIR_EraseRootFromParent_Done,
      // Label 453: @13761
      GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(13806), // Rule ID 50439 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50439,
        GIR_EraseRootFromParent_Done,
      // Label 454: @13806
      GIM_Reject,
    // Label 452: @13807
    GIM_Reject,
    // Label 408: @13808
    GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(13922),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(13876), // Rule ID 50474 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50474,
        GIR_EraseRootFromParent_Done,
      // Label 456: @13876
      GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(13921), // Rule ID 50475 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50475,
        GIR_EraseRootFromParent_Done,
      // Label 457: @13921
      GIM_Reject,
    // Label 455: @13922
    GIM_Reject,
    // Label 409: @13923
    GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(14037),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(13991), // Rule ID 50490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50490,
        GIR_EraseRootFromParent_Done,
      // Label 459: @13991
      GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(14036), // Rule ID 50491 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50491,
        GIR_EraseRootFromParent_Done,
      // Label 460: @14036
      GIM_Reject,
    // Label 458: @14037
    GIM_Reject,
    // Label 410: @14038
    GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(14152),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(14106), // Rule ID 50434 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50434,
        GIR_EraseRootFromParent_Done,
      // Label 462: @14106
      GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(14151), // Rule ID 50435 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50435,
        GIR_EraseRootFromParent_Done,
      // Label 463: @14151
      GIM_Reject,
    // Label 461: @14152
    GIM_Reject,
    // Label 411: @14153
    GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(14267),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(14221), // Rule ID 50462 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50462,
        GIR_EraseRootFromParent_Done,
      // Label 465: @14221
      GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(14266), // Rule ID 50463 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50463,
        GIR_EraseRootFromParent_Done,
      // Label 466: @14266
      GIM_Reject,
    // Label 464: @14267
    GIM_Reject,
    // Label 412: @14268
    GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(14382),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(14336), // Rule ID 50478 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50478,
        GIR_EraseRootFromParent_Done,
      // Label 468: @14336
      GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(14381), // Rule ID 50479 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50479,
        GIR_EraseRootFromParent_Done,
      // Label 469: @14381
      GIM_Reject,
    // Label 467: @14382
    GIM_Reject,
    // Label 413: @14383
    GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(14497),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(14451), // Rule ID 50494 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50494,
        GIR_EraseRootFromParent_Done,
      // Label 471: @14451
      GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(14496), // Rule ID 50495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50495,
        GIR_EraseRootFromParent_Done,
      // Label 472: @14496
      GIM_Reject,
    // Label 470: @14497
    GIM_Reject,
    // Label 414: @14498
    GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(14612),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(14566), // Rule ID 50450 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50450,
        GIR_EraseRootFromParent_Done,
      // Label 474: @14566
      GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(14611), // Rule ID 50451 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50451,
        GIR_EraseRootFromParent_Done,
      // Label 475: @14611
      GIM_Reject,
    // Label 473: @14612
    GIM_Reject,
    // Label 415: @14613
    GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(14727),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(14681), // Rule ID 50466 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50466,
        GIR_EraseRootFromParent_Done,
      // Label 477: @14681
      GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(14726), // Rule ID 50467 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50467,
        GIR_EraseRootFromParent_Done,
      // Label 478: @14726
      GIM_Reject,
    // Label 476: @14727
    GIM_Reject,
    // Label 416: @14728
    GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(14842),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(14796), // Rule ID 50482 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50482,
        GIR_EraseRootFromParent_Done,
      // Label 480: @14796
      GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(14841), // Rule ID 50483 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50483,
        GIR_EraseRootFromParent_Done,
      // Label 481: @14841
      GIM_Reject,
    // Label 479: @14842
    GIM_Reject,
    // Label 417: @14843
    GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(14957),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(14911), // Rule ID 50454 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50454,
        GIR_EraseRootFromParent_Done,
      // Label 483: @14911
      GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(14956), // Rule ID 50455 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50455,
        GIR_EraseRootFromParent_Done,
      // Label 484: @14956
      GIM_Reject,
    // Label 482: @14957
    GIM_Reject,
    // Label 418: @14958
    GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(15072),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(15026), // Rule ID 50470 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50470,
        GIR_EraseRootFromParent_Done,
      // Label 486: @15026
      GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(15071), // Rule ID 50471 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50471,
        GIR_EraseRootFromParent_Done,
      // Label 487: @15071
      GIM_Reject,
    // Label 485: @15072
    GIM_Reject,
    // Label 419: @15073
    GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(15187),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(15141), // Rule ID 50458 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50458,
        GIR_EraseRootFromParent_Done,
      // Label 489: @15141
      GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(15186), // Rule ID 50459 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50459,
        GIR_EraseRootFromParent_Done,
      // Label 490: @15186
      GIM_Reject,
    // Label 488: @15187
    GIM_Reject,
    // Label 420: @15188
    GIM_Reject,
    // Label 3: @15189
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 515*/ GIMT_Encode4(17922),
    /*GILLT_s32*//*Label 491*/ GIMT_Encode4(15324),
    /*GILLT_s64*//*Label 492*/ GIMT_Encode4(15358), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 493*/ GIMT_Encode4(15392),
    /*GILLT_nxv1s16*//*Label 494*/ GIMT_Encode4(15507),
    /*GILLT_nxv1s32*//*Label 495*/ GIMT_Encode4(15622),
    /*GILLT_nxv1s64*//*Label 496*/ GIMT_Encode4(15737), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 497*/ GIMT_Encode4(15852),
    /*GILLT_nxv2s16*//*Label 498*/ GIMT_Encode4(15967),
    /*GILLT_nxv2s32*//*Label 499*/ GIMT_Encode4(16082),
    /*GILLT_nxv2s64*//*Label 500*/ GIMT_Encode4(16197), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 501*/ GIMT_Encode4(16312),
    /*GILLT_nxv4s16*//*Label 502*/ GIMT_Encode4(16427),
    /*GILLT_nxv4s32*//*Label 503*/ GIMT_Encode4(16542),
    /*GILLT_nxv4s64*//*Label 504*/ GIMT_Encode4(16657), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 505*/ GIMT_Encode4(16772),
    /*GILLT_nxv8s16*//*Label 506*/ GIMT_Encode4(16887),
    /*GILLT_nxv8s32*//*Label 507*/ GIMT_Encode4(17002),
    /*GILLT_nxv8s64*//*Label 508*/ GIMT_Encode4(17117), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 509*/ GIMT_Encode4(17232),
    /*GILLT_nxv16s16*//*Label 510*/ GIMT_Encode4(17347),
    /*GILLT_nxv16s32*//*Label 511*/ GIMT_Encode4(17462), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 512*/ GIMT_Encode4(17577),
    /*GILLT_nxv32s16*//*Label 513*/ GIMT_Encode4(17692), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 514*/ GIMT_Encode4(17807),
    // Label 491: @15324
    GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(15357), // Rule ID 296 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIV:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIV),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 296,
      GIR_Done,
    // Label 516: @15357
    GIM_Reject,
    // Label 492: @15358
    GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(15391), // Rule ID 295 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (sdiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIV:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIV),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 295,
      GIR_Done,
    // Label 517: @15391
    GIM_Reject,
    // Label 493: @15392
    GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(15506),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(15460), // Rule ID 50762 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50762,
        GIR_EraseRootFromParent_Done,
      // Label 519: @15460
      GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(15505), // Rule ID 50763 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50763,
        GIR_EraseRootFromParent_Done,
      // Label 520: @15505
      GIM_Reject,
    // Label 518: @15506
    GIM_Reject,
    // Label 494: @15507
    GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(15621),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(15575), // Rule ID 50774 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50774,
        GIR_EraseRootFromParent_Done,
      // Label 522: @15575
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(15620), // Rule ID 50775 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50775,
        GIR_EraseRootFromParent_Done,
      // Label 523: @15620
      GIM_Reject,
    // Label 521: @15621
    GIM_Reject,
    // Label 495: @15622
    GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(15736),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(15690), // Rule ID 50782 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50782,
        GIR_EraseRootFromParent_Done,
      // Label 525: @15690
      GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(15735), // Rule ID 50783 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50783,
        GIR_EraseRootFromParent_Done,
      // Label 526: @15735
      GIM_Reject,
    // Label 524: @15736
    GIM_Reject,
    // Label 496: @15737
    GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(15851),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(15805), // Rule ID 50798 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50798,
        GIR_EraseRootFromParent_Done,
      // Label 528: @15805
      GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(15850), // Rule ID 50799 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50799,
        GIR_EraseRootFromParent_Done,
      // Label 529: @15850
      GIM_Reject,
    // Label 527: @15851
    GIM_Reject,
    // Label 497: @15852
    GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(15966),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(15920), // Rule ID 50766 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50766,
        GIR_EraseRootFromParent_Done,
      // Label 531: @15920
      GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(15965), // Rule ID 50767 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50767,
        GIR_EraseRootFromParent_Done,
      // Label 532: @15965
      GIM_Reject,
    // Label 530: @15966
    GIM_Reject,
    // Label 498: @15967
    GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(16081),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(16035), // Rule ID 50778 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50778,
        GIR_EraseRootFromParent_Done,
      // Label 534: @16035
      GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(16080), // Rule ID 50779 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50779,
        GIR_EraseRootFromParent_Done,
      // Label 535: @16080
      GIM_Reject,
    // Label 533: @16081
    GIM_Reject,
    // Label 499: @16082
    GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(16196),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(16150), // Rule ID 50794 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50794,
        GIR_EraseRootFromParent_Done,
      // Label 537: @16150
      GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(16195), // Rule ID 50795 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50795,
        GIR_EraseRootFromParent_Done,
      // Label 538: @16195
      GIM_Reject,
    // Label 536: @16196
    GIM_Reject,
    // Label 500: @16197
    GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(16311),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(16265), // Rule ID 50838 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50838,
        GIR_EraseRootFromParent_Done,
      // Label 540: @16265
      GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(16310), // Rule ID 50839 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50839,
        GIR_EraseRootFromParent_Done,
      // Label 541: @16310
      GIM_Reject,
    // Label 539: @16311
    GIM_Reject,
    // Label 501: @16312
    GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(16426),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(16380), // Rule ID 50770 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50770,
        GIR_EraseRootFromParent_Done,
      // Label 543: @16380
      GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(16425), // Rule ID 50771 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50771,
        GIR_EraseRootFromParent_Done,
      // Label 544: @16425
      GIM_Reject,
    // Label 542: @16426
    GIM_Reject,
    // Label 502: @16427
    GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(16541),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(16495), // Rule ID 50790 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50790,
        GIR_EraseRootFromParent_Done,
      // Label 546: @16495
      GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(16540), // Rule ID 50791 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50791,
        GIR_EraseRootFromParent_Done,
      // Label 547: @16540
      GIM_Reject,
    // Label 545: @16541
    GIM_Reject,
    // Label 503: @16542
    GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(16656),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(16610), // Rule ID 50826 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50826,
        GIR_EraseRootFromParent_Done,
      // Label 549: @16610
      GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(16655), // Rule ID 50827 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50827,
        GIR_EraseRootFromParent_Done,
      // Label 550: @16655
      GIM_Reject,
    // Label 548: @16656
    GIM_Reject,
    // Label 504: @16657
    GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(16771),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(16725), // Rule ID 50842 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50842,
        GIR_EraseRootFromParent_Done,
      // Label 552: @16725
      GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(16770), // Rule ID 50843 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50843,
        GIR_EraseRootFromParent_Done,
      // Label 553: @16770
      GIM_Reject,
    // Label 551: @16771
    GIM_Reject,
    // Label 505: @16772
    GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(16886),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(16840), // Rule ID 50786 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50786,
        GIR_EraseRootFromParent_Done,
      // Label 555: @16840
      GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(16885), // Rule ID 50787 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50787,
        GIR_EraseRootFromParent_Done,
      // Label 556: @16885
      GIM_Reject,
    // Label 554: @16886
    GIM_Reject,
    // Label 506: @16887
    GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(17001),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(16955), // Rule ID 50814 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50814,
        GIR_EraseRootFromParent_Done,
      // Label 558: @16955
      GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(17000), // Rule ID 50815 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50815,
        GIR_EraseRootFromParent_Done,
      // Label 559: @17000
      GIM_Reject,
    // Label 557: @17001
    GIM_Reject,
    // Label 507: @17002
    GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(17116),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(17070), // Rule ID 50830 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50830,
        GIR_EraseRootFromParent_Done,
      // Label 561: @17070
      GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(17115), // Rule ID 50831 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50831,
        GIR_EraseRootFromParent_Done,
      // Label 562: @17115
      GIM_Reject,
    // Label 560: @17116
    GIM_Reject,
    // Label 508: @17117
    GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(17231),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(17185), // Rule ID 50846 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50846,
        GIR_EraseRootFromParent_Done,
      // Label 564: @17185
      GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(17230), // Rule ID 50847 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50847,
        GIR_EraseRootFromParent_Done,
      // Label 565: @17230
      GIM_Reject,
    // Label 563: @17231
    GIM_Reject,
    // Label 509: @17232
    GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(17346),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(17300), // Rule ID 50802 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50802,
        GIR_EraseRootFromParent_Done,
      // Label 567: @17300
      GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(17345), // Rule ID 50803 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50803,
        GIR_EraseRootFromParent_Done,
      // Label 568: @17345
      GIM_Reject,
    // Label 566: @17346
    GIM_Reject,
    // Label 510: @17347
    GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(17461),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(17415), // Rule ID 50818 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50818,
        GIR_EraseRootFromParent_Done,
      // Label 570: @17415
      GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(17460), // Rule ID 50819 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50819,
        GIR_EraseRootFromParent_Done,
      // Label 571: @17460
      GIM_Reject,
    // Label 569: @17461
    GIM_Reject,
    // Label 511: @17462
    GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(17576),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(17530), // Rule ID 50834 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50834,
        GIR_EraseRootFromParent_Done,
      // Label 573: @17530
      GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(17575), // Rule ID 50835 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50835,
        GIR_EraseRootFromParent_Done,
      // Label 574: @17575
      GIM_Reject,
    // Label 572: @17576
    GIM_Reject,
    // Label 512: @17577
    GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(17691),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(17645), // Rule ID 50806 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50806,
        GIR_EraseRootFromParent_Done,
      // Label 576: @17645
      GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(17690), // Rule ID 50807 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50807,
        GIR_EraseRootFromParent_Done,
      // Label 577: @17690
      GIM_Reject,
    // Label 575: @17691
    GIM_Reject,
    // Label 513: @17692
    GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(17806),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(17760), // Rule ID 50822 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50822,
        GIR_EraseRootFromParent_Done,
      // Label 579: @17760
      GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(17805), // Rule ID 50823 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50823,
        GIR_EraseRootFromParent_Done,
      // Label 580: @17805
      GIM_Reject,
    // Label 578: @17806
    GIM_Reject,
    // Label 514: @17807
    GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(17921),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(17875), // Rule ID 50810 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50810,
        GIR_EraseRootFromParent_Done,
      // Label 582: @17875
      GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(17920), // Rule ID 50811 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50811,
        GIR_EraseRootFromParent_Done,
      // Label 583: @17920
      GIM_Reject,
    // Label 581: @17921
    GIM_Reject,
    // Label 515: @17922
    GIM_Reject,
    // Label 4: @17923
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 608*/ GIMT_Encode4(20656),
    /*GILLT_s32*//*Label 584*/ GIMT_Encode4(18058),
    /*GILLT_s64*//*Label 585*/ GIMT_Encode4(18092), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 586*/ GIMT_Encode4(18126),
    /*GILLT_nxv1s16*//*Label 587*/ GIMT_Encode4(18241),
    /*GILLT_nxv1s32*//*Label 588*/ GIMT_Encode4(18356),
    /*GILLT_nxv1s64*//*Label 589*/ GIMT_Encode4(18471), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 590*/ GIMT_Encode4(18586),
    /*GILLT_nxv2s16*//*Label 591*/ GIMT_Encode4(18701),
    /*GILLT_nxv2s32*//*Label 592*/ GIMT_Encode4(18816),
    /*GILLT_nxv2s64*//*Label 593*/ GIMT_Encode4(18931), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 594*/ GIMT_Encode4(19046),
    /*GILLT_nxv4s16*//*Label 595*/ GIMT_Encode4(19161),
    /*GILLT_nxv4s32*//*Label 596*/ GIMT_Encode4(19276),
    /*GILLT_nxv4s64*//*Label 597*/ GIMT_Encode4(19391), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 598*/ GIMT_Encode4(19506),
    /*GILLT_nxv8s16*//*Label 599*/ GIMT_Encode4(19621),
    /*GILLT_nxv8s32*//*Label 600*/ GIMT_Encode4(19736),
    /*GILLT_nxv8s64*//*Label 601*/ GIMT_Encode4(19851), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 602*/ GIMT_Encode4(19966),
    /*GILLT_nxv16s16*//*Label 603*/ GIMT_Encode4(20081),
    /*GILLT_nxv16s32*//*Label 604*/ GIMT_Encode4(20196), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 605*/ GIMT_Encode4(20311),
    /*GILLT_nxv32s16*//*Label 606*/ GIMT_Encode4(20426), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 607*/ GIMT_Encode4(20541),
    // Label 584: @18058
    GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(18091), // Rule ID 298 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 298,
      GIR_Done,
    // Label 609: @18091
    GIM_Reject,
    // Label 585: @18092
    GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(18125), // Rule ID 297 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (udiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIVU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 297,
      GIR_Done,
    // Label 610: @18125
    GIM_Reject,
    // Label 586: @18126
    GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(18240),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(18194), // Rule ID 50674 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50674,
        GIR_EraseRootFromParent_Done,
      // Label 612: @18194
      GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(18239), // Rule ID 50675 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50675,
        GIR_EraseRootFromParent_Done,
      // Label 613: @18239
      GIM_Reject,
    // Label 611: @18240
    GIM_Reject,
    // Label 587: @18241
    GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(18355),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(18309), // Rule ID 50686 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50686,
        GIR_EraseRootFromParent_Done,
      // Label 615: @18309
      GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(18354), // Rule ID 50687 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50687,
        GIR_EraseRootFromParent_Done,
      // Label 616: @18354
      GIM_Reject,
    // Label 614: @18355
    GIM_Reject,
    // Label 588: @18356
    GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(18470),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(18424), // Rule ID 50694 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50694,
        GIR_EraseRootFromParent_Done,
      // Label 618: @18424
      GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(18469), // Rule ID 50695 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50695,
        GIR_EraseRootFromParent_Done,
      // Label 619: @18469
      GIM_Reject,
    // Label 617: @18470
    GIM_Reject,
    // Label 589: @18471
    GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(18585),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(18539), // Rule ID 50710 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50710,
        GIR_EraseRootFromParent_Done,
      // Label 621: @18539
      GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(18584), // Rule ID 50711 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50711,
        GIR_EraseRootFromParent_Done,
      // Label 622: @18584
      GIM_Reject,
    // Label 620: @18585
    GIM_Reject,
    // Label 590: @18586
    GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(18700),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(18654), // Rule ID 50678 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50678,
        GIR_EraseRootFromParent_Done,
      // Label 624: @18654
      GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(18699), // Rule ID 50679 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50679,
        GIR_EraseRootFromParent_Done,
      // Label 625: @18699
      GIM_Reject,
    // Label 623: @18700
    GIM_Reject,
    // Label 591: @18701
    GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(18815),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(18769), // Rule ID 50690 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50690,
        GIR_EraseRootFromParent_Done,
      // Label 627: @18769
      GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(18814), // Rule ID 50691 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50691,
        GIR_EraseRootFromParent_Done,
      // Label 628: @18814
      GIM_Reject,
    // Label 626: @18815
    GIM_Reject,
    // Label 592: @18816
    GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(18930),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(18884), // Rule ID 50706 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50706,
        GIR_EraseRootFromParent_Done,
      // Label 630: @18884
      GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(18929), // Rule ID 50707 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50707,
        GIR_EraseRootFromParent_Done,
      // Label 631: @18929
      GIM_Reject,
    // Label 629: @18930
    GIM_Reject,
    // Label 593: @18931
    GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(19045),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(18999), // Rule ID 50750 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50750,
        GIR_EraseRootFromParent_Done,
      // Label 633: @18999
      GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(19044), // Rule ID 50751 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50751,
        GIR_EraseRootFromParent_Done,
      // Label 634: @19044
      GIM_Reject,
    // Label 632: @19045
    GIM_Reject,
    // Label 594: @19046
    GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(19160),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(19114), // Rule ID 50682 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50682,
        GIR_EraseRootFromParent_Done,
      // Label 636: @19114
      GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(19159), // Rule ID 50683 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50683,
        GIR_EraseRootFromParent_Done,
      // Label 637: @19159
      GIM_Reject,
    // Label 635: @19160
    GIM_Reject,
    // Label 595: @19161
    GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(19275),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(19229), // Rule ID 50702 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50702,
        GIR_EraseRootFromParent_Done,
      // Label 639: @19229
      GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(19274), // Rule ID 50703 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50703,
        GIR_EraseRootFromParent_Done,
      // Label 640: @19274
      GIM_Reject,
    // Label 638: @19275
    GIM_Reject,
    // Label 596: @19276
    GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(19390),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(19344), // Rule ID 50738 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50738,
        GIR_EraseRootFromParent_Done,
      // Label 642: @19344
      GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(19389), // Rule ID 50739 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50739,
        GIR_EraseRootFromParent_Done,
      // Label 643: @19389
      GIM_Reject,
    // Label 641: @19390
    GIM_Reject,
    // Label 597: @19391
    GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(19505),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(19459), // Rule ID 50754 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50754,
        GIR_EraseRootFromParent_Done,
      // Label 645: @19459
      GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(19504), // Rule ID 50755 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50755,
        GIR_EraseRootFromParent_Done,
      // Label 646: @19504
      GIM_Reject,
    // Label 644: @19505
    GIM_Reject,
    // Label 598: @19506
    GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(19620),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(19574), // Rule ID 50698 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50698,
        GIR_EraseRootFromParent_Done,
      // Label 648: @19574
      GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(19619), // Rule ID 50699 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50699,
        GIR_EraseRootFromParent_Done,
      // Label 649: @19619
      GIM_Reject,
    // Label 647: @19620
    GIM_Reject,
    // Label 599: @19621
    GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(19735),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(19689), // Rule ID 50726 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50726,
        GIR_EraseRootFromParent_Done,
      // Label 651: @19689
      GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(19734), // Rule ID 50727 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50727,
        GIR_EraseRootFromParent_Done,
      // Label 652: @19734
      GIM_Reject,
    // Label 650: @19735
    GIM_Reject,
    // Label 600: @19736
    GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(19850),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(19804), // Rule ID 50742 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50742,
        GIR_EraseRootFromParent_Done,
      // Label 654: @19804
      GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(19849), // Rule ID 50743 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50743,
        GIR_EraseRootFromParent_Done,
      // Label 655: @19849
      GIM_Reject,
    // Label 653: @19850
    GIM_Reject,
    // Label 601: @19851
    GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(19965),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(19919), // Rule ID 50758 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50758,
        GIR_EraseRootFromParent_Done,
      // Label 657: @19919
      GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(19964), // Rule ID 50759 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50759,
        GIR_EraseRootFromParent_Done,
      // Label 658: @19964
      GIM_Reject,
    // Label 656: @19965
    GIM_Reject,
    // Label 602: @19966
    GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(20080),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(20034), // Rule ID 50714 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50714,
        GIR_EraseRootFromParent_Done,
      // Label 660: @20034
      GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(20079), // Rule ID 50715 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50715,
        GIR_EraseRootFromParent_Done,
      // Label 661: @20079
      GIM_Reject,
    // Label 659: @20080
    GIM_Reject,
    // Label 603: @20081
    GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(20195),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(20149), // Rule ID 50730 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50730,
        GIR_EraseRootFromParent_Done,
      // Label 663: @20149
      GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(20194), // Rule ID 50731 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50731,
        GIR_EraseRootFromParent_Done,
      // Label 664: @20194
      GIM_Reject,
    // Label 662: @20195
    GIM_Reject,
    // Label 604: @20196
    GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(20310),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(20264), // Rule ID 50746 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50746,
        GIR_EraseRootFromParent_Done,
      // Label 666: @20264
      GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(20309), // Rule ID 50747 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50747,
        GIR_EraseRootFromParent_Done,
      // Label 667: @20309
      GIM_Reject,
    // Label 665: @20310
    GIM_Reject,
    // Label 605: @20311
    GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(20425),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(20379), // Rule ID 50718 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50718,
        GIR_EraseRootFromParent_Done,
      // Label 669: @20379
      GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(20424), // Rule ID 50719 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50719,
        GIR_EraseRootFromParent_Done,
      // Label 670: @20424
      GIM_Reject,
    // Label 668: @20425
    GIM_Reject,
    // Label 606: @20426
    GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(20540),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(20494), // Rule ID 50734 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50734,
        GIR_EraseRootFromParent_Done,
      // Label 672: @20494
      GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(20539), // Rule ID 50735 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50735,
        GIR_EraseRootFromParent_Done,
      // Label 673: @20539
      GIM_Reject,
    // Label 671: @20540
    GIM_Reject,
    // Label 607: @20541
    GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(20655),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(20609), // Rule ID 50722 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50722,
        GIR_EraseRootFromParent_Done,
      // Label 675: @20609
      GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(20654), // Rule ID 50723 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50723,
        GIR_EraseRootFromParent_Done,
      // Label 676: @20654
      GIM_Reject,
    // Label 674: @20655
    GIM_Reject,
    // Label 608: @20656
    GIM_Reject,
    // Label 5: @20657
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 701*/ GIMT_Encode4(23435),
    /*GILLT_s32*//*Label 677*/ GIMT_Encode4(20792),
    /*GILLT_s64*//*Label 678*/ GIMT_Encode4(20826), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 679*/ GIMT_Encode4(20905),
    /*GILLT_nxv1s16*//*Label 680*/ GIMT_Encode4(21020),
    /*GILLT_nxv1s32*//*Label 681*/ GIMT_Encode4(21135),
    /*GILLT_nxv1s64*//*Label 682*/ GIMT_Encode4(21250), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 683*/ GIMT_Encode4(21365),
    /*GILLT_nxv2s16*//*Label 684*/ GIMT_Encode4(21480),
    /*GILLT_nxv2s32*//*Label 685*/ GIMT_Encode4(21595),
    /*GILLT_nxv2s64*//*Label 686*/ GIMT_Encode4(21710), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 687*/ GIMT_Encode4(21825),
    /*GILLT_nxv4s16*//*Label 688*/ GIMT_Encode4(21940),
    /*GILLT_nxv4s32*//*Label 689*/ GIMT_Encode4(22055),
    /*GILLT_nxv4s64*//*Label 690*/ GIMT_Encode4(22170), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 691*/ GIMT_Encode4(22285),
    /*GILLT_nxv8s16*//*Label 692*/ GIMT_Encode4(22400),
    /*GILLT_nxv8s32*//*Label 693*/ GIMT_Encode4(22515),
    /*GILLT_nxv8s64*//*Label 694*/ GIMT_Encode4(22630), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 695*/ GIMT_Encode4(22745),
    /*GILLT_nxv16s16*//*Label 696*/ GIMT_Encode4(22860),
    /*GILLT_nxv16s32*//*Label 697*/ GIMT_Encode4(22975), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 698*/ GIMT_Encode4(23090),
    /*GILLT_nxv32s16*//*Label 699*/ GIMT_Encode4(23205), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 700*/ GIMT_Encode4(23320),
    // Label 677: @20792
    GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(20825), // Rule ID 300 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (srem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REM:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 300,
      GIR_Done,
    // Label 702: @20825
    GIM_Reject,
    // Label 678: @20826
    GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(20904),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(20880), // Rule ID 309 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode0),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sexti32),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_sexti32),
        // (srem:{ *:[i64] } (sexti32:{ *:[i64] } GPR:{ *:[i64] }:$rs1), (sexti32:{ *:[i64] } GPR:{ *:[i64] }:$rs2))  =>  (REMW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::REMW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 309,
        GIR_EraseRootFromParent_Done,
      // Label 704: @20880
      GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(20903), // Rule ID 299 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (srem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REM:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 299,
        GIR_Done,
      // Label 705: @20903
      GIM_Reject,
    // Label 703: @20904
    GIM_Reject,
    // Label 679: @20905
    GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(21019),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(20973), // Rule ID 50938 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50938,
        GIR_EraseRootFromParent_Done,
      // Label 707: @20973
      GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(21018), // Rule ID 50939 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50939,
        GIR_EraseRootFromParent_Done,
      // Label 708: @21018
      GIM_Reject,
    // Label 706: @21019
    GIM_Reject,
    // Label 680: @21020
    GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(21134),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(21088), // Rule ID 50950 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50950,
        GIR_EraseRootFromParent_Done,
      // Label 710: @21088
      GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(21133), // Rule ID 50951 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50951,
        GIR_EraseRootFromParent_Done,
      // Label 711: @21133
      GIM_Reject,
    // Label 709: @21134
    GIM_Reject,
    // Label 681: @21135
    GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(21249),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(21203), // Rule ID 50958 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50958,
        GIR_EraseRootFromParent_Done,
      // Label 713: @21203
      GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(21248), // Rule ID 50959 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50959,
        GIR_EraseRootFromParent_Done,
      // Label 714: @21248
      GIM_Reject,
    // Label 712: @21249
    GIM_Reject,
    // Label 682: @21250
    GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(21364),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(21318), // Rule ID 50974 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50974,
        GIR_EraseRootFromParent_Done,
      // Label 716: @21318
      GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(21363), // Rule ID 50975 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50975,
        GIR_EraseRootFromParent_Done,
      // Label 717: @21363
      GIM_Reject,
    // Label 715: @21364
    GIM_Reject,
    // Label 683: @21365
    GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(21479),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(21433), // Rule ID 50942 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50942,
        GIR_EraseRootFromParent_Done,
      // Label 719: @21433
      GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(21478), // Rule ID 50943 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50943,
        GIR_EraseRootFromParent_Done,
      // Label 720: @21478
      GIM_Reject,
    // Label 718: @21479
    GIM_Reject,
    // Label 684: @21480
    GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(21594),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(21548), // Rule ID 50954 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50954,
        GIR_EraseRootFromParent_Done,
      // Label 722: @21548
      GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(21593), // Rule ID 50955 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50955,
        GIR_EraseRootFromParent_Done,
      // Label 723: @21593
      GIM_Reject,
    // Label 721: @21594
    GIM_Reject,
    // Label 685: @21595
    GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(21709),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(21663), // Rule ID 50970 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50970,
        GIR_EraseRootFromParent_Done,
      // Label 725: @21663
      GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(21708), // Rule ID 50971 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50971,
        GIR_EraseRootFromParent_Done,
      // Label 726: @21708
      GIM_Reject,
    // Label 724: @21709
    GIM_Reject,
    // Label 686: @21710
    GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(21824),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(21778), // Rule ID 51014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51014,
        GIR_EraseRootFromParent_Done,
      // Label 728: @21778
      GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(21823), // Rule ID 51015 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51015,
        GIR_EraseRootFromParent_Done,
      // Label 729: @21823
      GIM_Reject,
    // Label 727: @21824
    GIM_Reject,
    // Label 687: @21825
    GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(21939),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(21893), // Rule ID 50946 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50946,
        GIR_EraseRootFromParent_Done,
      // Label 731: @21893
      GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(21938), // Rule ID 50947 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50947,
        GIR_EraseRootFromParent_Done,
      // Label 732: @21938
      GIM_Reject,
    // Label 730: @21939
    GIM_Reject,
    // Label 688: @21940
    GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(22054),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(22008), // Rule ID 50966 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50966,
        GIR_EraseRootFromParent_Done,
      // Label 734: @22008
      GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(22053), // Rule ID 50967 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50967,
        GIR_EraseRootFromParent_Done,
      // Label 735: @22053
      GIM_Reject,
    // Label 733: @22054
    GIM_Reject,
    // Label 689: @22055
    GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(22169),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(22123), // Rule ID 51002 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51002,
        GIR_EraseRootFromParent_Done,
      // Label 737: @22123
      GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(22168), // Rule ID 51003 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51003,
        GIR_EraseRootFromParent_Done,
      // Label 738: @22168
      GIM_Reject,
    // Label 736: @22169
    GIM_Reject,
    // Label 690: @22170
    GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(22284),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(22238), // Rule ID 51018 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51018,
        GIR_EraseRootFromParent_Done,
      // Label 740: @22238
      GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(22283), // Rule ID 51019 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51019,
        GIR_EraseRootFromParent_Done,
      // Label 741: @22283
      GIM_Reject,
    // Label 739: @22284
    GIM_Reject,
    // Label 691: @22285
    GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(22399),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(22353), // Rule ID 50962 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50962,
        GIR_EraseRootFromParent_Done,
      // Label 743: @22353
      GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(22398), // Rule ID 50963 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50963,
        GIR_EraseRootFromParent_Done,
      // Label 744: @22398
      GIM_Reject,
    // Label 742: @22399
    GIM_Reject,
    // Label 692: @22400
    GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(22514),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(22468), // Rule ID 50990 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50990,
        GIR_EraseRootFromParent_Done,
      // Label 746: @22468
      GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(22513), // Rule ID 50991 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50991,
        GIR_EraseRootFromParent_Done,
      // Label 747: @22513
      GIM_Reject,
    // Label 745: @22514
    GIM_Reject,
    // Label 693: @22515
    GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(22629),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(22583), // Rule ID 51006 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51006,
        GIR_EraseRootFromParent_Done,
      // Label 749: @22583
      GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(22628), // Rule ID 51007 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51007,
        GIR_EraseRootFromParent_Done,
      // Label 750: @22628
      GIM_Reject,
    // Label 748: @22629
    GIM_Reject,
    // Label 694: @22630
    GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(22744),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(22698), // Rule ID 51022 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51022,
        GIR_EraseRootFromParent_Done,
      // Label 752: @22698
      GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(22743), // Rule ID 51023 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51023,
        GIR_EraseRootFromParent_Done,
      // Label 753: @22743
      GIM_Reject,
    // Label 751: @22744
    GIM_Reject,
    // Label 695: @22745
    GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(22859),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(22813), // Rule ID 50978 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50978,
        GIR_EraseRootFromParent_Done,
      // Label 755: @22813
      GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(22858), // Rule ID 50979 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50979,
        GIR_EraseRootFromParent_Done,
      // Label 756: @22858
      GIM_Reject,
    // Label 754: @22859
    GIM_Reject,
    // Label 696: @22860
    GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(22974),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(22928), // Rule ID 50994 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50994,
        GIR_EraseRootFromParent_Done,
      // Label 758: @22928
      GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(22973), // Rule ID 50995 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50995,
        GIR_EraseRootFromParent_Done,
      // Label 759: @22973
      GIM_Reject,
    // Label 757: @22974
    GIM_Reject,
    // Label 697: @22975
    GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(23089),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(23043), // Rule ID 51010 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51010,
        GIR_EraseRootFromParent_Done,
      // Label 761: @23043
      GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(23088), // Rule ID 51011 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51011,
        GIR_EraseRootFromParent_Done,
      // Label 762: @23088
      GIM_Reject,
    // Label 760: @23089
    GIM_Reject,
    // Label 698: @23090
    GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(23204),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(23158), // Rule ID 50982 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50982,
        GIR_EraseRootFromParent_Done,
      // Label 764: @23158
      GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(23203), // Rule ID 50983 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50983,
        GIR_EraseRootFromParent_Done,
      // Label 765: @23203
      GIM_Reject,
    // Label 763: @23204
    GIM_Reject,
    // Label 699: @23205
    GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(23319),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(23273), // Rule ID 50998 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50998,
        GIR_EraseRootFromParent_Done,
      // Label 767: @23273
      GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(23318), // Rule ID 50999 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50999,
        GIR_EraseRootFromParent_Done,
      // Label 768: @23318
      GIM_Reject,
    // Label 766: @23319
    GIM_Reject,
    // Label 700: @23320
    GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(23434),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(23388), // Rule ID 50986 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50986,
        GIR_EraseRootFromParent_Done,
      // Label 770: @23388
      GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(23433), // Rule ID 50987 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50987,
        GIR_EraseRootFromParent_Done,
      // Label 771: @23433
      GIM_Reject,
    // Label 769: @23434
    GIM_Reject,
    // Label 701: @23435
    GIM_Reject,
    // Label 6: @23436
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 796*/ GIMT_Encode4(26169),
    /*GILLT_s32*//*Label 772*/ GIMT_Encode4(23571),
    /*GILLT_s64*//*Label 773*/ GIMT_Encode4(23605), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 774*/ GIMT_Encode4(23639),
    /*GILLT_nxv1s16*//*Label 775*/ GIMT_Encode4(23754),
    /*GILLT_nxv1s32*//*Label 776*/ GIMT_Encode4(23869),
    /*GILLT_nxv1s64*//*Label 777*/ GIMT_Encode4(23984), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 778*/ GIMT_Encode4(24099),
    /*GILLT_nxv2s16*//*Label 779*/ GIMT_Encode4(24214),
    /*GILLT_nxv2s32*//*Label 780*/ GIMT_Encode4(24329),
    /*GILLT_nxv2s64*//*Label 781*/ GIMT_Encode4(24444), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 782*/ GIMT_Encode4(24559),
    /*GILLT_nxv4s16*//*Label 783*/ GIMT_Encode4(24674),
    /*GILLT_nxv4s32*//*Label 784*/ GIMT_Encode4(24789),
    /*GILLT_nxv4s64*//*Label 785*/ GIMT_Encode4(24904), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 786*/ GIMT_Encode4(25019),
    /*GILLT_nxv8s16*//*Label 787*/ GIMT_Encode4(25134),
    /*GILLT_nxv8s32*//*Label 788*/ GIMT_Encode4(25249),
    /*GILLT_nxv8s64*//*Label 789*/ GIMT_Encode4(25364), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 790*/ GIMT_Encode4(25479),
    /*GILLT_nxv16s16*//*Label 791*/ GIMT_Encode4(25594),
    /*GILLT_nxv16s32*//*Label 792*/ GIMT_Encode4(25709), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 793*/ GIMT_Encode4(25824),
    /*GILLT_nxv32s16*//*Label 794*/ GIMT_Encode4(25939), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 795*/ GIMT_Encode4(26054),
    // Label 772: @23571
    GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(23604), // Rule ID 302 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (urem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 302,
      GIR_Done,
    // Label 797: @23604
    GIM_Reject,
    // Label 773: @23605
    GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(23638), // Rule ID 301 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (urem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REMU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 301,
      GIR_Done,
    // Label 798: @23638
    GIM_Reject,
    // Label 774: @23639
    GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(23753),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(23707), // Rule ID 50850 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50850,
        GIR_EraseRootFromParent_Done,
      // Label 800: @23707
      GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(23752), // Rule ID 50851 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50851,
        GIR_EraseRootFromParent_Done,
      // Label 801: @23752
      GIM_Reject,
    // Label 799: @23753
    GIM_Reject,
    // Label 775: @23754
    GIM_Try, /*On fail goto*//*Label 802*/ GIMT_Encode4(23868),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 803*/ GIMT_Encode4(23822), // Rule ID 50862 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50862,
        GIR_EraseRootFromParent_Done,
      // Label 803: @23822
      GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(23867), // Rule ID 50863 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50863,
        GIR_EraseRootFromParent_Done,
      // Label 804: @23867
      GIM_Reject,
    // Label 802: @23868
    GIM_Reject,
    // Label 776: @23869
    GIM_Try, /*On fail goto*//*Label 805*/ GIMT_Encode4(23983),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 806*/ GIMT_Encode4(23937), // Rule ID 50870 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50870,
        GIR_EraseRootFromParent_Done,
      // Label 806: @23937
      GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(23982), // Rule ID 50871 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50871,
        GIR_EraseRootFromParent_Done,
      // Label 807: @23982
      GIM_Reject,
    // Label 805: @23983
    GIM_Reject,
    // Label 777: @23984
    GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(24098),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(24052), // Rule ID 50886 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50886,
        GIR_EraseRootFromParent_Done,
      // Label 809: @24052
      GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(24097), // Rule ID 50887 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50887,
        GIR_EraseRootFromParent_Done,
      // Label 810: @24097
      GIM_Reject,
    // Label 808: @24098
    GIM_Reject,
    // Label 778: @24099
    GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(24213),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(24167), // Rule ID 50854 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50854,
        GIR_EraseRootFromParent_Done,
      // Label 812: @24167
      GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(24212), // Rule ID 50855 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50855,
        GIR_EraseRootFromParent_Done,
      // Label 813: @24212
      GIM_Reject,
    // Label 811: @24213
    GIM_Reject,
    // Label 779: @24214
    GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(24328),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(24282), // Rule ID 50866 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50866,
        GIR_EraseRootFromParent_Done,
      // Label 815: @24282
      GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(24327), // Rule ID 50867 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50867,
        GIR_EraseRootFromParent_Done,
      // Label 816: @24327
      GIM_Reject,
    // Label 814: @24328
    GIM_Reject,
    // Label 780: @24329
    GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(24443),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(24397), // Rule ID 50882 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50882,
        GIR_EraseRootFromParent_Done,
      // Label 818: @24397
      GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(24442), // Rule ID 50883 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50883,
        GIR_EraseRootFromParent_Done,
      // Label 819: @24442
      GIM_Reject,
    // Label 817: @24443
    GIM_Reject,
    // Label 781: @24444
    GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(24558),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(24512), // Rule ID 50926 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50926,
        GIR_EraseRootFromParent_Done,
      // Label 821: @24512
      GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(24557), // Rule ID 50927 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50927,
        GIR_EraseRootFromParent_Done,
      // Label 822: @24557
      GIM_Reject,
    // Label 820: @24558
    GIM_Reject,
    // Label 782: @24559
    GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(24673),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(24627), // Rule ID 50858 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50858,
        GIR_EraseRootFromParent_Done,
      // Label 824: @24627
      GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(24672), // Rule ID 50859 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50859,
        GIR_EraseRootFromParent_Done,
      // Label 825: @24672
      GIM_Reject,
    // Label 823: @24673
    GIM_Reject,
    // Label 783: @24674
    GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(24788),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(24742), // Rule ID 50878 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50878,
        GIR_EraseRootFromParent_Done,
      // Label 827: @24742
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(24787), // Rule ID 50879 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50879,
        GIR_EraseRootFromParent_Done,
      // Label 828: @24787
      GIM_Reject,
    // Label 826: @24788
    GIM_Reject,
    // Label 784: @24789
    GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(24903),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(24857), // Rule ID 50914 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50914,
        GIR_EraseRootFromParent_Done,
      // Label 830: @24857
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(24902), // Rule ID 50915 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50915,
        GIR_EraseRootFromParent_Done,
      // Label 831: @24902
      GIM_Reject,
    // Label 829: @24903
    GIM_Reject,
    // Label 785: @24904
    GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(25018),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(24972), // Rule ID 50930 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50930,
        GIR_EraseRootFromParent_Done,
      // Label 833: @24972
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(25017), // Rule ID 50931 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50931,
        GIR_EraseRootFromParent_Done,
      // Label 834: @25017
      GIM_Reject,
    // Label 832: @25018
    GIM_Reject,
    // Label 786: @25019
    GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(25133),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(25087), // Rule ID 50874 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50874,
        GIR_EraseRootFromParent_Done,
      // Label 836: @25087
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(25132), // Rule ID 50875 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50875,
        GIR_EraseRootFromParent_Done,
      // Label 837: @25132
      GIM_Reject,
    // Label 835: @25133
    GIM_Reject,
    // Label 787: @25134
    GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(25248),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(25202), // Rule ID 50902 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50902,
        GIR_EraseRootFromParent_Done,
      // Label 839: @25202
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(25247), // Rule ID 50903 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50903,
        GIR_EraseRootFromParent_Done,
      // Label 840: @25247
      GIM_Reject,
    // Label 838: @25248
    GIM_Reject,
    // Label 788: @25249
    GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(25363),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(25317), // Rule ID 50918 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50918,
        GIR_EraseRootFromParent_Done,
      // Label 842: @25317
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(25362), // Rule ID 50919 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50919,
        GIR_EraseRootFromParent_Done,
      // Label 843: @25362
      GIM_Reject,
    // Label 841: @25363
    GIM_Reject,
    // Label 789: @25364
    GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(25478),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(25432), // Rule ID 50934 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50934,
        GIR_EraseRootFromParent_Done,
      // Label 845: @25432
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(25477), // Rule ID 50935 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50935,
        GIR_EraseRootFromParent_Done,
      // Label 846: @25477
      GIM_Reject,
    // Label 844: @25478
    GIM_Reject,
    // Label 790: @25479
    GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(25593),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(25547), // Rule ID 50890 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50890,
        GIR_EraseRootFromParent_Done,
      // Label 848: @25547
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(25592), // Rule ID 50891 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50891,
        GIR_EraseRootFromParent_Done,
      // Label 849: @25592
      GIM_Reject,
    // Label 847: @25593
    GIM_Reject,
    // Label 791: @25594
    GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(25708),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(25662), // Rule ID 50906 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50906,
        GIR_EraseRootFromParent_Done,
      // Label 851: @25662
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(25707), // Rule ID 50907 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50907,
        GIR_EraseRootFromParent_Done,
      // Label 852: @25707
      GIM_Reject,
    // Label 850: @25708
    GIM_Reject,
    // Label 792: @25709
    GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(25823),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(25777), // Rule ID 50922 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50922,
        GIR_EraseRootFromParent_Done,
      // Label 854: @25777
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(25822), // Rule ID 50923 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50923,
        GIR_EraseRootFromParent_Done,
      // Label 855: @25822
      GIM_Reject,
    // Label 853: @25823
    GIM_Reject,
    // Label 793: @25824
    GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(25938),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(25892), // Rule ID 50894 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50894,
        GIR_EraseRootFromParent_Done,
      // Label 857: @25892
      GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(25937), // Rule ID 50895 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50895,
        GIR_EraseRootFromParent_Done,
      // Label 858: @25937
      GIM_Reject,
    // Label 856: @25938
    GIM_Reject,
    // Label 794: @25939
    GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(26053),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(26007), // Rule ID 50910 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50910,
        GIR_EraseRootFromParent_Done,
      // Label 860: @26007
      GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(26052), // Rule ID 50911 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50911,
        GIR_EraseRootFromParent_Done,
      // Label 861: @26052
      GIM_Reject,
    // Label 859: @26053
    GIM_Reject,
    // Label 795: @26054
    GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(26168),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(26122), // Rule ID 50898 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50898,
        GIR_EraseRootFromParent_Done,
      // Label 863: @26122
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(26167), // Rule ID 50899 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50899,
        GIR_EraseRootFromParent_Done,
      // Label 864: @26167
      GIM_Reject,
    // Label 862: @26168
    GIM_Reject,
    // Label 796: @26169
    GIM_Reject,
    // Label 7: @26170
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 896*/ GIMT_Encode4(35453),
    /*GILLT_s32*//*Label 865*/ GIMT_Encode4(26305),
    /*GILLT_s64*//*Label 866*/ GIMT_Encode4(27363),
    /*GILLT_nxv1s1*//*Label 867*/ GIMT_Encode4(28646),
    /*GILLT_nxv1s8*//*Label 868*/ GIMT_Encode4(29257),
    /*GILLT_nxv1s16*//*Label 869*/ GIMT_Encode4(29372),
    /*GILLT_nxv1s32*//*Label 870*/ GIMT_Encode4(29487),
    /*GILLT_nxv1s64*//*Label 871*/ GIMT_Encode4(29602),
    /*GILLT_nxv2s1*//*Label 872*/ GIMT_Encode4(29717),
    /*GILLT_nxv2s8*//*Label 873*/ GIMT_Encode4(30328),
    /*GILLT_nxv2s16*//*Label 874*/ GIMT_Encode4(30443),
    /*GILLT_nxv2s32*//*Label 875*/ GIMT_Encode4(30558),
    /*GILLT_nxv2s64*//*Label 876*/ GIMT_Encode4(30673),
    /*GILLT_nxv4s1*//*Label 877*/ GIMT_Encode4(30788),
    /*GILLT_nxv4s8*//*Label 878*/ GIMT_Encode4(31399),
    /*GILLT_nxv4s16*//*Label 879*/ GIMT_Encode4(31514),
    /*GILLT_nxv4s32*//*Label 880*/ GIMT_Encode4(31629),
    /*GILLT_nxv4s64*//*Label 881*/ GIMT_Encode4(31744),
    /*GILLT_nxv8s1*//*Label 882*/ GIMT_Encode4(31859),
    /*GILLT_nxv8s8*//*Label 883*/ GIMT_Encode4(32470),
    /*GILLT_nxv8s16*//*Label 884*/ GIMT_Encode4(32585),
    /*GILLT_nxv8s32*//*Label 885*/ GIMT_Encode4(32700),
    /*GILLT_nxv8s64*//*Label 886*/ GIMT_Encode4(32815),
    /*GILLT_nxv16s1*//*Label 887*/ GIMT_Encode4(32930),
    /*GILLT_nxv16s8*//*Label 888*/ GIMT_Encode4(33541),
    /*GILLT_nxv16s16*//*Label 889*/ GIMT_Encode4(33656),
    /*GILLT_nxv16s32*//*Label 890*/ GIMT_Encode4(33771),
    /*GILLT_nxv32s1*//*Label 891*/ GIMT_Encode4(33886),
    /*GILLT_nxv32s8*//*Label 892*/ GIMT_Encode4(34497),
    /*GILLT_nxv32s16*//*Label 893*/ GIMT_Encode4(34612),
    /*GILLT_nxv64s1*//*Label 894*/ GIMT_Encode4(34727),
    /*GILLT_nxv64s8*//*Label 895*/ GIMT_Encode4(35338),
    // Label 865: @26305
    GIM_Try, /*On fail goto*//*Label 897*/ GIMT_Encode4(27362),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 898*/ GIMT_Encode4(26405), // Rule ID 64178 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        // (and:{ *:[i32] } (or:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$rs1), (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 8:{ *:[i32] })), 65535:{ *:[i32] })  =>  (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64178,
        GIR_EraseRootFromParent_Done,
      // Label 898: @26405
      GIM_Try, /*On fail goto*//*Label 899*/ GIMT_Encode4(26490), // Rule ID 2402 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        // (and:{ *:[i32] } (or:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 8:{ *:[i32] }), (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$rs1)), 65535:{ *:[i32] })  =>  (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2402,
        GIR_EraseRootFromParent_Done,
      // Label 899: @26490
      GIM_Try, /*On fail goto*//*Label 900*/ GIMT_Encode4(26565), // Rule ID 2329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2329,
        GIR_EraseRootFromParent_Done,
      // Label 900: @26565
      GIM_Try, /*On fail goto*//*Label 901*/ GIMT_Encode4(26640), // Rule ID 64166 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), -1:{ *:[i32] }))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64166,
        GIR_EraseRootFromParent_Done,
      // Label 901: @26640
      GIM_Try, /*On fail goto*//*Label 902*/ GIMT_Encode4(26701), // Rule ID 2349 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })  =>  (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXTI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2349,
        GIR_EraseRootFromParent_Done,
      // Label 902: @26701
      GIM_Try, /*On fail goto*//*Label 903*/ GIMT_Encode4(26762), // Rule ID 61983 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })  =>  (TH_TST:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_TST),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 61983,
        GIR_EraseRootFromParent_Done,
      // Label 903: @26762
      GIM_Try, /*On fail goto*//*Label 904*/ GIMT_Encode4(26820), // Rule ID 2337 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), 1:{ *:[i32] })  =>  (BEXT:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2337,
        GIR_EraseRootFromParent_Done,
      // Label 904: @26820
      GIM_Try, /*On fail goto*//*Label 905*/ GIMT_Encode4(26872), // Rule ID 2331 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2331,
        GIR_EraseRootFromParent_Done,
      // Label 905: @26872
      GIM_Try, /*On fail goto*//*Label 906*/ GIMT_Encode4(26924), // Rule ID 64152 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64152,
        GIR_EraseRootFromParent_Done,
      // Label 906: @26924
      GIM_Try, /*On fail goto*//*Label 907*/ GIMT_Encode4(26976), // Rule ID 64168 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64168,
        GIR_EraseRootFromParent_Done,
      // Label 907: @26976
      GIM_Try, /*On fail goto*//*Label 908*/ GIMT_Encode4(27028), // Rule ID 2305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2305,
        GIR_EraseRootFromParent_Done,
      // Label 908: @27028
      GIM_Try, /*On fail goto*//*Label 909*/ GIMT_Encode4(27060), // Rule ID 63887 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXCValu_IsRV32_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 65535:{ *:[i32] })  =>  (CV_EXTHZ:{ *:[i32] } GPR:{ *:[i32] }:$rs1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::CV_EXTHZ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63887,
        GIR_EraseRootFromParent_Done,
      // Label 909: @27060
      GIM_Try, /*On fail goto*//*Label 910*/ GIMT_Encode4(27092), // Rule ID 63889 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXCValu_IsRV32_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 255:{ *:[i32] })  =>  (CV_EXTBZ:{ *:[i32] } GPR:{ *:[i32] }:$rs1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::CV_EXTBZ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63889,
        GIR_EraseRootFromParent_Done,
      // Label 910: @27092
      GIM_Try, /*On fail goto*//*Label 911*/ GIMT_Encode4(27124), // Rule ID 2413 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV32_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV32:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2413,
        GIR_EraseRootFromParent_Done,
      // Label 911: @27124
      GIM_Try, /*On fail goto*//*Label 912*/ GIMT_Encode4(27156), // Rule ID 2414 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV32_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV32:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2414,
        GIR_EraseRootFromParent_Done,
      // Label 912: @27156
      GIM_Try, /*On fail goto*//*Label 913*/ GIMT_Encode4(27194), // Rule ID 2416 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_NoStdExtZbb_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (PACK:{ *:[i32] } GPR:{ *:[i32] }:$rs, X0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2416,
        GIR_EraseRootFromParent_Done,
      // Label 913: @27194
      GIM_Try, /*On fail goto*//*Label 914*/ GIMT_Encode4(27232), // Rule ID 2417 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_NoStdExtZbb_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (PACK:{ *:[i32] } GPR:{ *:[i32] }:$rs, X0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2417,
        GIR_EraseRootFromParent_Done,
      // Label 914: @27232
      GIM_Try, /*On fail goto*//*Label 915*/ GIMT_Encode4(27270), // Rule ID 85 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 85,
        GIR_EraseRootFromParent_Done,
      // Label 915: @27270
      GIM_Try, /*On fail goto*//*Label 916*/ GIMT_Encode4(27338), // Rule ID 103 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_TrailingOnesMask),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_9503),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_TrailingOnesMask>><<P:Predicate_anonymous_9503>><<X:XLenSubTrailingOnes>>:$mask)  =>  (SRLI:{ *:[i32] } (SLLI:{ *:[i32] } ?:{ *:[i32] }:$rs, (XLenSubTrailingOnes:{ *:[i32] } (imm:{ *:[i32] }):$mask)), (XLenSubTrailingOnes:{ *:[i32] } (imm:{ *:[i32] }):$mask))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderXLenSubTrailingOnes), // mask
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderXLenSubTrailingOnes), // mask
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 103,
        GIR_EraseRootFromParent_Done,
      // Label 916: @27338
      GIM_Try, /*On fail goto*//*Label 917*/ GIMT_Encode4(27361), // Rule ID 83 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (AND:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::AND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 83,
        GIR_Done,
      // Label 917: @27361
      GIM_Reject,
    // Label 897: @27362
    GIM_Reject,
    // Label 866: @27363
    GIM_Try, /*On fail goto*//*Label 918*/ GIMT_Encode4(28645),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 919*/ GIMT_Encode4(27463), // Rule ID 64177 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        // (and:{ *:[i64] } (or:{ *:[i64] } (zexti8:{ *:[i64] } GPR:{ *:[i64] }:$rs1), (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 8:{ *:[i64] })), 65535:{ *:[i64] })  =>  (PACKH:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64177,
        GIR_EraseRootFromParent_Done,
      // Label 919: @27463
      GIM_Try, /*On fail goto*//*Label 920*/ GIMT_Encode4(27548), // Rule ID 2401 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        // (and:{ *:[i64] } (or:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 8:{ *:[i64] }), (zexti8:{ *:[i64] } GPR:{ *:[i64] }:$rs1)), 65535:{ *:[i64] })  =>  (PACKH:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2401,
        GIR_EraseRootFromParent_Done,
      // Label 920: @27548
      GIM_Try, /*On fail goto*//*Label 921*/ GIMT_Encode4(27623), // Rule ID 2328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } (xor:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2328,
        GIR_EraseRootFromParent_Done,
      // Label 921: @27623
      GIM_Try, /*On fail goto*//*Label 922*/ GIMT_Encode4(27698), // Rule ID 64165 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), -1:{ *:[i64] }))  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64165,
        GIR_EraseRootFromParent_Done,
      // Label 922: @27698
      GIM_Try, /*On fail goto*//*Label 923*/ GIMT_Encode4(27759), // Rule ID 2348 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })  =>  (BEXTI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXTI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2348,
        GIR_EraseRootFromParent_Done,
      // Label 923: @27759
      GIM_Try, /*On fail goto*//*Label 924*/ GIMT_Encode4(27820), // Rule ID 61982 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })  =>  (TH_TST:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_TST),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 61982,
        GIR_EraseRootFromParent_Done,
      // Label 924: @27820
      GIM_Try, /*On fail goto*//*Label 925*/ GIMT_Encode4(27878), // Rule ID 2336 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), 1:{ *:[i64] })  =>  (BEXT:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2336,
        GIR_EraseRootFromParent_Done,
      // Label 925: @27878
      GIM_Try, /*On fail goto*//*Label 926*/ GIMT_Encode4(27930), // Rule ID 2330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rs1)  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2330,
        GIR_EraseRootFromParent_Done,
      // Label 926: @27930
      GIM_Try, /*On fail goto*//*Label 927*/ GIMT_Encode4(27982), // Rule ID 64151 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64151,
        GIR_EraseRootFromParent_Done,
      // Label 927: @27982
      GIM_Try, /*On fail goto*//*Label 928*/ GIMT_Encode4(28034), // Rule ID 64167 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2))  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64167,
        GIR_EraseRootFromParent_Done,
      // Label 928: @28034
      GIM_Try, /*On fail goto*//*Label 929*/ GIMT_Encode4(28086), // Rule ID 2304 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2304,
        GIR_EraseRootFromParent_Done,
      // Label 929: @28086
      GIM_Try, /*On fail goto*//*Label 930*/ GIMT_Encode4(28118), // Rule ID 63886 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXCValu_IsRV32_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 65535:{ *:[i64] })  =>  (CV_EXTHZ:{ *:[i64] } GPR:{ *:[i64] }:$rs1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::CV_EXTHZ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63886,
        GIR_EraseRootFromParent_Done,
      // Label 930: @28118
      GIM_Try, /*On fail goto*//*Label 931*/ GIMT_Encode4(28150), // Rule ID 63888 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXCValu_IsRV32_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 255:{ *:[i64] })  =>  (CV_EXTBZ:{ *:[i64] } GPR:{ *:[i64] }:$rs1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::CV_EXTBZ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63888,
        GIR_EraseRootFromParent_Done,
      // Label 931: @28150
      GIM_Try, /*On fail goto*//*Label 932*/ GIMT_Encode4(28207), // Rule ID 252 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_NotHasStdExtZba_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294967295),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] })  =>  (SRLI:{ *:[i64] } (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), 32:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/32,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 252,
        GIR_EraseRootFromParent_Done,
      // Label 932: @28207
      GIM_Try, /*On fail goto*//*Label 933*/ GIMT_Encode4(28239), // Rule ID 2415 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 65535:{ *:[i64] })  =>  (ZEXT_H_RV64:{ *:[i64] } GPR:{ *:[i64] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2415,
        GIR_EraseRootFromParent_Done,
      // Label 933: @28239
      GIM_Try, /*On fail goto*//*Label 934*/ GIMT_Encode4(28277), // Rule ID 2418 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 65535:{ *:[i64] })  =>  (PACKW:{ *:[i64] } GPR:{ *:[i64] }:$rs, X0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2418,
        GIR_EraseRootFromParent_Done,
      // Label 934: @28277
      GIM_Try, /*On fail goto*//*Label 935*/ GIMT_Encode4(28315), // Rule ID 2461 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294967295),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 4294967295:{ *:[i64] })  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs, X0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2461,
        GIR_EraseRootFromParent_Done,
      // Label 935: @28315
      GIM_Try, /*On fail goto*//*Label 936*/ GIMT_Encode4(28353), // Rule ID 84 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ANDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 84,
        GIR_EraseRootFromParent_Done,
      // Label 936: @28353
      GIM_Try, /*On fail goto*//*Label 937*/ GIMT_Encode4(28421), // Rule ID 101 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_LeadingOnesMask),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_9501),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, (imm:{ *:[i64] })<<P:Predicate_LeadingOnesMask>><<P:Predicate_anonymous_9501>><<X:TrailingZeros>>:$mask)  =>  (SLLI:{ *:[i64] } (SRLI:{ *:[i64] } ?:{ *:[i64] }:$rs, (TrailingZeros:{ *:[i64] } (imm:{ *:[i64] }):$mask)), (TrailingZeros:{ *:[i64] } (imm:{ *:[i64] }):$mask))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderTrailingZeros), // mask
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderTrailingZeros), // mask
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 101,
        GIR_EraseRootFromParent_Done,
      // Label 937: @28421
      GIM_Try, /*On fail goto*//*Label 938*/ GIMT_Encode4(28489), // Rule ID 102 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_TrailingOnesMask),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_9503),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, (imm:{ *:[i64] })<<P:Predicate_TrailingOnesMask>><<P:Predicate_anonymous_9503>><<X:XLenSubTrailingOnes>>:$mask)  =>  (SRLI:{ *:[i64] } (SLLI:{ *:[i64] } ?:{ *:[i64] }:$rs, (XLenSubTrailingOnes:{ *:[i64] } (imm:{ *:[i64] }):$mask)), (XLenSubTrailingOnes:{ *:[i64] } (imm:{ *:[i64] }):$mask))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderXLenSubTrailingOnes), // mask
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderXLenSubTrailingOnes), // mask
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 102,
        GIR_EraseRootFromParent_Done,
      // Label 938: @28489
      GIM_Try, /*On fail goto*//*Label 939*/ GIMT_Encode4(28557), // Rule ID 254 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_LeadingOnesWMask),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_9591),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, (imm:{ *:[i64] })<<P:Predicate_LeadingOnesWMask>><<P:Predicate_anonymous_9591>><<X:TrailingZeros>>:$mask)  =>  (SLLI:{ *:[i64] } (SRLIW:{ *:[i64] } ?:{ *:[i64] }:$rs, (TrailingZeros:{ *:[i64] } (imm:{ *:[i64] }):$mask)), (TrailingZeros:{ *:[i64] } (imm:{ *:[i64] }):$mask))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderTrailingZeros), // mask
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderTrailingZeros), // mask
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 254,
        GIR_EraseRootFromParent_Done,
      // Label 939: @28557
      GIM_Try, /*On fail goto*//*Label 940*/ GIMT_Encode4(28621), // Rule ID 2458 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_Shifted32OnesMask),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_Shifted32OnesMask>><<X:TrailingZeros>>:$mask)  =>  (SLLI_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (TrailingZeros:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_Shifted32OnesMask>>:$mask)), (TrailingZeros:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_Shifted32OnesMask>>:$mask))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderTrailingZeros), // mask
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SLLI_UW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderTrailingZeros), // mask
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2458,
        GIR_EraseRootFromParent_Done,
      // Label 940: @28621
      GIM_Try, /*On fail goto*//*Label 941*/ GIMT_Encode4(28644), // Rule ID 82 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (AND:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::AND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 82,
        GIR_Done,
      // Label 941: @28644
      GIM_Reject,
    // Label 918: @28645
    GIM_Reject,
    // Label 867: @28646
    GIM_Try, /*On fail goto*//*Label 942*/ GIMT_Encode4(29256),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 943*/ GIMT_Encode4(28727), // Rule ID 70217 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } (xor:{ *:[nxv1i1] } (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv1i1] }:$rs2), VR:{ *:[nxv1i1] }:$rs1)  =>  (PseudoVMANDN_MM_B64:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70217,
        GIR_EraseRootFromParent_Done,
      // Label 943: @28727
      GIM_Try, /*On fail goto*//*Label 944*/ GIMT_Encode4(28793), // Rule ID 70218 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } (xor:{ *:[nxv1i1] } (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv1i1] }:$rs2), VR:{ *:[nxv1i1] }:$rs1)  =>  (PseudoVMANDN_MM_B64:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70218,
        GIR_EraseRootFromParent_Done,
      // Label 944: @28793
      GIM_Try, /*On fail goto*//*Label 945*/ GIMT_Encode4(28859), // Rule ID 70215 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv1i1] }:$rs1)  =>  (PseudoVMANDN_MM_B64:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70215,
        GIR_EraseRootFromParent_Done,
      // Label 945: @28859
      GIM_Try, /*On fail goto*//*Label 946*/ GIMT_Encode4(28925), // Rule ID 70216 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv1i1] }:$rs1)  =>  (PseudoVMANDN_MM_B64:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70216,
        GIR_EraseRootFromParent_Done,
      // Label 946: @28925
      GIM_Try, /*On fail goto*//*Label 947*/ GIMT_Encode4(28991), // Rule ID 70213 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, (xor:{ *:[nxv1i1] } (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv1i1] }:$rs2))  =>  (PseudoVMANDN_MM_B64:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70213,
        GIR_EraseRootFromParent_Done,
      // Label 947: @28991
      GIM_Try, /*On fail goto*//*Label 948*/ GIMT_Encode4(29057), // Rule ID 70214 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, (xor:{ *:[nxv1i1] } (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv1i1] }:$rs2))  =>  (PseudoVMANDN_MM_B64:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70214,
        GIR_EraseRootFromParent_Done,
      // Label 948: @29057
      GIM_Try, /*On fail goto*//*Label 949*/ GIMT_Encode4(29123), // Rule ID 52726 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_B64:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52726,
        GIR_EraseRootFromParent_Done,
      // Label 949: @29123
      GIM_Try, /*On fail goto*//*Label 950*/ GIMT_Encode4(29189), // Rule ID 52727 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv1i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_B64:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52727,
        GIR_EraseRootFromParent_Done,
      // Label 950: @29189
      GIM_Try, /*On fail goto*//*Label 951*/ GIMT_Encode4(29222), // Rule ID 52714 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_B64:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52714,
        GIR_EraseRootFromParent_Done,
      // Label 951: @29222
      GIM_Try, /*On fail goto*//*Label 952*/ GIMT_Encode4(29255), // Rule ID 52715 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_B64:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52715,
        GIR_EraseRootFromParent_Done,
      // Label 952: @29255
      GIM_Reject,
    // Label 942: @29256
    GIM_Reject,
    // Label 868: @29257
    GIM_Try, /*On fail goto*//*Label 953*/ GIMT_Encode4(29371),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 954*/ GIMT_Encode4(29325), // Rule ID 47210 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47210,
        GIR_EraseRootFromParent_Done,
      // Label 954: @29325
      GIM_Try, /*On fail goto*//*Label 955*/ GIMT_Encode4(29370), // Rule ID 47211 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47211,
        GIR_EraseRootFromParent_Done,
      // Label 955: @29370
      GIM_Reject,
    // Label 953: @29371
    GIM_Reject,
    // Label 869: @29372
    GIM_Try, /*On fail goto*//*Label 956*/ GIMT_Encode4(29486),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 957*/ GIMT_Encode4(29440), // Rule ID 47222 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47222,
        GIR_EraseRootFromParent_Done,
      // Label 957: @29440
      GIM_Try, /*On fail goto*//*Label 958*/ GIMT_Encode4(29485), // Rule ID 47223 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47223,
        GIR_EraseRootFromParent_Done,
      // Label 958: @29485
      GIM_Reject,
    // Label 956: @29486
    GIM_Reject,
    // Label 870: @29487
    GIM_Try, /*On fail goto*//*Label 959*/ GIMT_Encode4(29601),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 960*/ GIMT_Encode4(29555), // Rule ID 47230 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47230,
        GIR_EraseRootFromParent_Done,
      // Label 960: @29555
      GIM_Try, /*On fail goto*//*Label 961*/ GIMT_Encode4(29600), // Rule ID 47231 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47231,
        GIR_EraseRootFromParent_Done,
      // Label 961: @29600
      GIM_Reject,
    // Label 959: @29601
    GIM_Reject,
    // Label 871: @29602
    GIM_Try, /*On fail goto*//*Label 962*/ GIMT_Encode4(29716),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 963*/ GIMT_Encode4(29670), // Rule ID 47246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47246,
        GIR_EraseRootFromParent_Done,
      // Label 963: @29670
      GIM_Try, /*On fail goto*//*Label 964*/ GIMT_Encode4(29715), // Rule ID 47247 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47247,
        GIR_EraseRootFromParent_Done,
      // Label 964: @29715
      GIM_Reject,
    // Label 962: @29716
    GIM_Reject,
    // Label 872: @29717
    GIM_Try, /*On fail goto*//*Label 965*/ GIMT_Encode4(30327),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 966*/ GIMT_Encode4(29798), // Rule ID 70245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } (xor:{ *:[nxv2i1] } (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv2i1] }:$rs2), VR:{ *:[nxv2i1] }:$rs1)  =>  (PseudoVMANDN_MM_B32:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70245,
        GIR_EraseRootFromParent_Done,
      // Label 966: @29798
      GIM_Try, /*On fail goto*//*Label 967*/ GIMT_Encode4(29864), // Rule ID 70246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } (xor:{ *:[nxv2i1] } (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv2i1] }:$rs2), VR:{ *:[nxv2i1] }:$rs1)  =>  (PseudoVMANDN_MM_B32:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70246,
        GIR_EraseRootFromParent_Done,
      // Label 967: @29864
      GIM_Try, /*On fail goto*//*Label 968*/ GIMT_Encode4(29930), // Rule ID 70243 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv2i1] }:$rs1)  =>  (PseudoVMANDN_MM_B32:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70243,
        GIR_EraseRootFromParent_Done,
      // Label 968: @29930
      GIM_Try, /*On fail goto*//*Label 969*/ GIMT_Encode4(29996), // Rule ID 70244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv2i1] }:$rs1)  =>  (PseudoVMANDN_MM_B32:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70244,
        GIR_EraseRootFromParent_Done,
      // Label 969: @29996
      GIM_Try, /*On fail goto*//*Label 970*/ GIMT_Encode4(30062), // Rule ID 70241 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, (xor:{ *:[nxv2i1] } (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv2i1] }:$rs2))  =>  (PseudoVMANDN_MM_B32:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70241,
        GIR_EraseRootFromParent_Done,
      // Label 970: @30062
      GIM_Try, /*On fail goto*//*Label 971*/ GIMT_Encode4(30128), // Rule ID 70242 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, (xor:{ *:[nxv2i1] } (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv2i1] }:$rs2))  =>  (PseudoVMANDN_MM_B32:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70242,
        GIR_EraseRootFromParent_Done,
      // Label 971: @30128
      GIM_Try, /*On fail goto*//*Label 972*/ GIMT_Encode4(30194), // Rule ID 52744 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_B32:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52744,
        GIR_EraseRootFromParent_Done,
      // Label 972: @30194
      GIM_Try, /*On fail goto*//*Label 973*/ GIMT_Encode4(30260), // Rule ID 52745 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv2i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_B32:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52745,
        GIR_EraseRootFromParent_Done,
      // Label 973: @30260
      GIM_Try, /*On fail goto*//*Label 974*/ GIMT_Encode4(30293), // Rule ID 52732 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_B32:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52732,
        GIR_EraseRootFromParent_Done,
      // Label 974: @30293
      GIM_Try, /*On fail goto*//*Label 975*/ GIMT_Encode4(30326), // Rule ID 52733 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_B32:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52733,
        GIR_EraseRootFromParent_Done,
      // Label 975: @30326
      GIM_Reject,
    // Label 965: @30327
    GIM_Reject,
    // Label 873: @30328
    GIM_Try, /*On fail goto*//*Label 976*/ GIMT_Encode4(30442),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 977*/ GIMT_Encode4(30396), // Rule ID 47214 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47214,
        GIR_EraseRootFromParent_Done,
      // Label 977: @30396
      GIM_Try, /*On fail goto*//*Label 978*/ GIMT_Encode4(30441), // Rule ID 47215 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47215,
        GIR_EraseRootFromParent_Done,
      // Label 978: @30441
      GIM_Reject,
    // Label 976: @30442
    GIM_Reject,
    // Label 874: @30443
    GIM_Try, /*On fail goto*//*Label 979*/ GIMT_Encode4(30557),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 980*/ GIMT_Encode4(30511), // Rule ID 47226 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47226,
        GIR_EraseRootFromParent_Done,
      // Label 980: @30511
      GIM_Try, /*On fail goto*//*Label 981*/ GIMT_Encode4(30556), // Rule ID 47227 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47227,
        GIR_EraseRootFromParent_Done,
      // Label 981: @30556
      GIM_Reject,
    // Label 979: @30557
    GIM_Reject,
    // Label 875: @30558
    GIM_Try, /*On fail goto*//*Label 982*/ GIMT_Encode4(30672),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 983*/ GIMT_Encode4(30626), // Rule ID 47242 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47242,
        GIR_EraseRootFromParent_Done,
      // Label 983: @30626
      GIM_Try, /*On fail goto*//*Label 984*/ GIMT_Encode4(30671), // Rule ID 47243 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47243,
        GIR_EraseRootFromParent_Done,
      // Label 984: @30671
      GIM_Reject,
    // Label 982: @30672
    GIM_Reject,
    // Label 876: @30673
    GIM_Try, /*On fail goto*//*Label 985*/ GIMT_Encode4(30787),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 986*/ GIMT_Encode4(30741), // Rule ID 47286 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47286,
        GIR_EraseRootFromParent_Done,
      // Label 986: @30741
      GIM_Try, /*On fail goto*//*Label 987*/ GIMT_Encode4(30786), // Rule ID 47287 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47287,
        GIR_EraseRootFromParent_Done,
      // Label 987: @30786
      GIM_Reject,
    // Label 985: @30787
    GIM_Reject,
    // Label 877: @30788
    GIM_Try, /*On fail goto*//*Label 988*/ GIMT_Encode4(31398),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 989*/ GIMT_Encode4(30869), // Rule ID 70273 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } (xor:{ *:[nxv4i1] } (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv4i1] }:$rs2), VR:{ *:[nxv4i1] }:$rs1)  =>  (PseudoVMANDN_MM_B16:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70273,
        GIR_EraseRootFromParent_Done,
      // Label 989: @30869
      GIM_Try, /*On fail goto*//*Label 990*/ GIMT_Encode4(30935), // Rule ID 70274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } (xor:{ *:[nxv4i1] } (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv4i1] }:$rs2), VR:{ *:[nxv4i1] }:$rs1)  =>  (PseudoVMANDN_MM_B16:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70274,
        GIR_EraseRootFromParent_Done,
      // Label 990: @30935
      GIM_Try, /*On fail goto*//*Label 991*/ GIMT_Encode4(31001), // Rule ID 70271 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv4i1] }:$rs1)  =>  (PseudoVMANDN_MM_B16:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70271,
        GIR_EraseRootFromParent_Done,
      // Label 991: @31001
      GIM_Try, /*On fail goto*//*Label 992*/ GIMT_Encode4(31067), // Rule ID 70272 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv4i1] }:$rs1)  =>  (PseudoVMANDN_MM_B16:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70272,
        GIR_EraseRootFromParent_Done,
      // Label 992: @31067
      GIM_Try, /*On fail goto*//*Label 993*/ GIMT_Encode4(31133), // Rule ID 70269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, (xor:{ *:[nxv4i1] } (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv4i1] }:$rs2))  =>  (PseudoVMANDN_MM_B16:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70269,
        GIR_EraseRootFromParent_Done,
      // Label 993: @31133
      GIM_Try, /*On fail goto*//*Label 994*/ GIMT_Encode4(31199), // Rule ID 70270 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, (xor:{ *:[nxv4i1] } (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv4i1] }:$rs2))  =>  (PseudoVMANDN_MM_B16:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70270,
        GIR_EraseRootFromParent_Done,
      // Label 994: @31199
      GIM_Try, /*On fail goto*//*Label 995*/ GIMT_Encode4(31265), // Rule ID 52762 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_B16:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52762,
        GIR_EraseRootFromParent_Done,
      // Label 995: @31265
      GIM_Try, /*On fail goto*//*Label 996*/ GIMT_Encode4(31331), // Rule ID 52763 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv4i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_B16:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52763,
        GIR_EraseRootFromParent_Done,
      // Label 996: @31331
      GIM_Try, /*On fail goto*//*Label 997*/ GIMT_Encode4(31364), // Rule ID 52750 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_B16:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_B16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52750,
        GIR_EraseRootFromParent_Done,
      // Label 997: @31364
      GIM_Try, /*On fail goto*//*Label 998*/ GIMT_Encode4(31397), // Rule ID 52751 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_B16:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_B16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52751,
        GIR_EraseRootFromParent_Done,
      // Label 998: @31397
      GIM_Reject,
    // Label 988: @31398
    GIM_Reject,
    // Label 878: @31399
    GIM_Try, /*On fail goto*//*Label 999*/ GIMT_Encode4(31513),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1000*/ GIMT_Encode4(31467), // Rule ID 47218 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47218,
        GIR_EraseRootFromParent_Done,
      // Label 1000: @31467
      GIM_Try, /*On fail goto*//*Label 1001*/ GIMT_Encode4(31512), // Rule ID 47219 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47219,
        GIR_EraseRootFromParent_Done,
      // Label 1001: @31512
      GIM_Reject,
    // Label 999: @31513
    GIM_Reject,
    // Label 879: @31514
    GIM_Try, /*On fail goto*//*Label 1002*/ GIMT_Encode4(31628),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1003*/ GIMT_Encode4(31582), // Rule ID 47238 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47238,
        GIR_EraseRootFromParent_Done,
      // Label 1003: @31582
      GIM_Try, /*On fail goto*//*Label 1004*/ GIMT_Encode4(31627), // Rule ID 47239 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47239,
        GIR_EraseRootFromParent_Done,
      // Label 1004: @31627
      GIM_Reject,
    // Label 1002: @31628
    GIM_Reject,
    // Label 880: @31629
    GIM_Try, /*On fail goto*//*Label 1005*/ GIMT_Encode4(31743),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 1006*/ GIMT_Encode4(31697), // Rule ID 47274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47274,
        GIR_EraseRootFromParent_Done,
      // Label 1006: @31697
      GIM_Try, /*On fail goto*//*Label 1007*/ GIMT_Encode4(31742), // Rule ID 47275 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47275,
        GIR_EraseRootFromParent_Done,
      // Label 1007: @31742
      GIM_Reject,
    // Label 1005: @31743
    GIM_Reject,
    // Label 881: @31744
    GIM_Try, /*On fail goto*//*Label 1008*/ GIMT_Encode4(31858),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1009*/ GIMT_Encode4(31812), // Rule ID 47290 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47290,
        GIR_EraseRootFromParent_Done,
      // Label 1009: @31812
      GIM_Try, /*On fail goto*//*Label 1010*/ GIMT_Encode4(31857), // Rule ID 47291 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47291,
        GIR_EraseRootFromParent_Done,
      // Label 1010: @31857
      GIM_Reject,
    // Label 1008: @31858
    GIM_Reject,
    // Label 882: @31859
    GIM_Try, /*On fail goto*//*Label 1011*/ GIMT_Encode4(32469),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1012*/ GIMT_Encode4(31940), // Rule ID 70301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } (xor:{ *:[nxv8i1] } (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv8i1] }:$rs2), VR:{ *:[nxv8i1] }:$rs1)  =>  (PseudoVMANDN_MM_B8:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70301,
        GIR_EraseRootFromParent_Done,
      // Label 1012: @31940
      GIM_Try, /*On fail goto*//*Label 1013*/ GIMT_Encode4(32006), // Rule ID 70302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } (xor:{ *:[nxv8i1] } (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv8i1] }:$rs2), VR:{ *:[nxv8i1] }:$rs1)  =>  (PseudoVMANDN_MM_B8:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70302,
        GIR_EraseRootFromParent_Done,
      // Label 1013: @32006
      GIM_Try, /*On fail goto*//*Label 1014*/ GIMT_Encode4(32072), // Rule ID 70299 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv8i1] }:$rs1)  =>  (PseudoVMANDN_MM_B8:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70299,
        GIR_EraseRootFromParent_Done,
      // Label 1014: @32072
      GIM_Try, /*On fail goto*//*Label 1015*/ GIMT_Encode4(32138), // Rule ID 70300 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv8i1] }:$rs1)  =>  (PseudoVMANDN_MM_B8:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70300,
        GIR_EraseRootFromParent_Done,
      // Label 1015: @32138
      GIM_Try, /*On fail goto*//*Label 1016*/ GIMT_Encode4(32204), // Rule ID 70297 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, (xor:{ *:[nxv8i1] } (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv8i1] }:$rs2))  =>  (PseudoVMANDN_MM_B8:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70297,
        GIR_EraseRootFromParent_Done,
      // Label 1016: @32204
      GIM_Try, /*On fail goto*//*Label 1017*/ GIMT_Encode4(32270), // Rule ID 70298 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, (xor:{ *:[nxv8i1] } (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv8i1] }:$rs2))  =>  (PseudoVMANDN_MM_B8:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70298,
        GIR_EraseRootFromParent_Done,
      // Label 1017: @32270
      GIM_Try, /*On fail goto*//*Label 1018*/ GIMT_Encode4(32336), // Rule ID 52780 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_B8:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52780,
        GIR_EraseRootFromParent_Done,
      // Label 1018: @32336
      GIM_Try, /*On fail goto*//*Label 1019*/ GIMT_Encode4(32402), // Rule ID 52781 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv8i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_B8:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52781,
        GIR_EraseRootFromParent_Done,
      // Label 1019: @32402
      GIM_Try, /*On fail goto*//*Label 1020*/ GIMT_Encode4(32435), // Rule ID 52768 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_B8:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_B8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52768,
        GIR_EraseRootFromParent_Done,
      // Label 1020: @32435
      GIM_Try, /*On fail goto*//*Label 1021*/ GIMT_Encode4(32468), // Rule ID 52769 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_B8:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_B8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52769,
        GIR_EraseRootFromParent_Done,
      // Label 1021: @32468
      GIM_Reject,
    // Label 1011: @32469
    GIM_Reject,
    // Label 883: @32470
    GIM_Try, /*On fail goto*//*Label 1022*/ GIMT_Encode4(32584),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1023*/ GIMT_Encode4(32538), // Rule ID 47234 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47234,
        GIR_EraseRootFromParent_Done,
      // Label 1023: @32538
      GIM_Try, /*On fail goto*//*Label 1024*/ GIMT_Encode4(32583), // Rule ID 47235 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47235,
        GIR_EraseRootFromParent_Done,
      // Label 1024: @32583
      GIM_Reject,
    // Label 1022: @32584
    GIM_Reject,
    // Label 884: @32585
    GIM_Try, /*On fail goto*//*Label 1025*/ GIMT_Encode4(32699),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 1026*/ GIMT_Encode4(32653), // Rule ID 47262 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47262,
        GIR_EraseRootFromParent_Done,
      // Label 1026: @32653
      GIM_Try, /*On fail goto*//*Label 1027*/ GIMT_Encode4(32698), // Rule ID 47263 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47263,
        GIR_EraseRootFromParent_Done,
      // Label 1027: @32698
      GIM_Reject,
    // Label 1025: @32699
    GIM_Reject,
    // Label 885: @32700
    GIM_Try, /*On fail goto*//*Label 1028*/ GIMT_Encode4(32814),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1029*/ GIMT_Encode4(32768), // Rule ID 47278 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47278,
        GIR_EraseRootFromParent_Done,
      // Label 1029: @32768
      GIM_Try, /*On fail goto*//*Label 1030*/ GIMT_Encode4(32813), // Rule ID 47279 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47279,
        GIR_EraseRootFromParent_Done,
      // Label 1030: @32813
      GIM_Reject,
    // Label 1028: @32814
    GIM_Reject,
    // Label 886: @32815
    GIM_Try, /*On fail goto*//*Label 1031*/ GIMT_Encode4(32929),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1032*/ GIMT_Encode4(32883), // Rule ID 47294 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47294,
        GIR_EraseRootFromParent_Done,
      // Label 1032: @32883
      GIM_Try, /*On fail goto*//*Label 1033*/ GIMT_Encode4(32928), // Rule ID 47295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47295,
        GIR_EraseRootFromParent_Done,
      // Label 1033: @32928
      GIM_Reject,
    // Label 1031: @32929
    GIM_Reject,
    // Label 887: @32930
    GIM_Try, /*On fail goto*//*Label 1034*/ GIMT_Encode4(33540),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1035*/ GIMT_Encode4(33011), // Rule ID 70329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } (xor:{ *:[nxv16i1] } (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv16i1] }:$rs2), VR:{ *:[nxv16i1] }:$rs1)  =>  (PseudoVMANDN_MM_B4:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70329,
        GIR_EraseRootFromParent_Done,
      // Label 1035: @33011
      GIM_Try, /*On fail goto*//*Label 1036*/ GIMT_Encode4(33077), // Rule ID 70330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } (xor:{ *:[nxv16i1] } (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv16i1] }:$rs2), VR:{ *:[nxv16i1] }:$rs1)  =>  (PseudoVMANDN_MM_B4:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70330,
        GIR_EraseRootFromParent_Done,
      // Label 1036: @33077
      GIM_Try, /*On fail goto*//*Label 1037*/ GIMT_Encode4(33143), // Rule ID 70327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv16i1] }:$rs1)  =>  (PseudoVMANDN_MM_B4:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70327,
        GIR_EraseRootFromParent_Done,
      // Label 1037: @33143
      GIM_Try, /*On fail goto*//*Label 1038*/ GIMT_Encode4(33209), // Rule ID 70328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv16i1] }:$rs1)  =>  (PseudoVMANDN_MM_B4:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70328,
        GIR_EraseRootFromParent_Done,
      // Label 1038: @33209
      GIM_Try, /*On fail goto*//*Label 1039*/ GIMT_Encode4(33275), // Rule ID 70325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, (xor:{ *:[nxv16i1] } (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv16i1] }:$rs2))  =>  (PseudoVMANDN_MM_B4:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70325,
        GIR_EraseRootFromParent_Done,
      // Label 1039: @33275
      GIM_Try, /*On fail goto*//*Label 1040*/ GIMT_Encode4(33341), // Rule ID 70326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, (xor:{ *:[nxv16i1] } (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv16i1] }:$rs2))  =>  (PseudoVMANDN_MM_B4:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70326,
        GIR_EraseRootFromParent_Done,
      // Label 1040: @33341
      GIM_Try, /*On fail goto*//*Label 1041*/ GIMT_Encode4(33407), // Rule ID 52798 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_B4:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52798,
        GIR_EraseRootFromParent_Done,
      // Label 1041: @33407
      GIM_Try, /*On fail goto*//*Label 1042*/ GIMT_Encode4(33473), // Rule ID 52799 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv16i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_B4:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52799,
        GIR_EraseRootFromParent_Done,
      // Label 1042: @33473
      GIM_Try, /*On fail goto*//*Label 1043*/ GIMT_Encode4(33506), // Rule ID 52786 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_B4:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_B4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52786,
        GIR_EraseRootFromParent_Done,
      // Label 1043: @33506
      GIM_Try, /*On fail goto*//*Label 1044*/ GIMT_Encode4(33539), // Rule ID 52787 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_B4:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_B4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52787,
        GIR_EraseRootFromParent_Done,
      // Label 1044: @33539
      GIM_Reject,
    // Label 1034: @33540
    GIM_Reject,
    // Label 888: @33541
    GIM_Try, /*On fail goto*//*Label 1045*/ GIMT_Encode4(33655),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 1046*/ GIMT_Encode4(33609), // Rule ID 47250 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47250,
        GIR_EraseRootFromParent_Done,
      // Label 1046: @33609
      GIM_Try, /*On fail goto*//*Label 1047*/ GIMT_Encode4(33654), // Rule ID 47251 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47251,
        GIR_EraseRootFromParent_Done,
      // Label 1047: @33654
      GIM_Reject,
    // Label 1045: @33655
    GIM_Reject,
    // Label 889: @33656
    GIM_Try, /*On fail goto*//*Label 1048*/ GIMT_Encode4(33770),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1049*/ GIMT_Encode4(33724), // Rule ID 47266 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47266,
        GIR_EraseRootFromParent_Done,
      // Label 1049: @33724
      GIM_Try, /*On fail goto*//*Label 1050*/ GIMT_Encode4(33769), // Rule ID 47267 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47267,
        GIR_EraseRootFromParent_Done,
      // Label 1050: @33769
      GIM_Reject,
    // Label 1048: @33770
    GIM_Reject,
    // Label 890: @33771
    GIM_Try, /*On fail goto*//*Label 1051*/ GIMT_Encode4(33885),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1052*/ GIMT_Encode4(33839), // Rule ID 47282 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47282,
        GIR_EraseRootFromParent_Done,
      // Label 1052: @33839
      GIM_Try, /*On fail goto*//*Label 1053*/ GIMT_Encode4(33884), // Rule ID 47283 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47283,
        GIR_EraseRootFromParent_Done,
      // Label 1053: @33884
      GIM_Reject,
    // Label 1051: @33885
    GIM_Reject,
    // Label 891: @33886
    GIM_Try, /*On fail goto*//*Label 1054*/ GIMT_Encode4(34496),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1055*/ GIMT_Encode4(33967), // Rule ID 70357 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } (xor:{ *:[nxv32i1] } (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv32i1] }:$rs2), VR:{ *:[nxv32i1] }:$rs1)  =>  (PseudoVMANDN_MM_B2:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70357,
        GIR_EraseRootFromParent_Done,
      // Label 1055: @33967
      GIM_Try, /*On fail goto*//*Label 1056*/ GIMT_Encode4(34033), // Rule ID 70358 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } (xor:{ *:[nxv32i1] } (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv32i1] }:$rs2), VR:{ *:[nxv32i1] }:$rs1)  =>  (PseudoVMANDN_MM_B2:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70358,
        GIR_EraseRootFromParent_Done,
      // Label 1056: @34033
      GIM_Try, /*On fail goto*//*Label 1057*/ GIMT_Encode4(34099), // Rule ID 70355 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv32i1] }:$rs1)  =>  (PseudoVMANDN_MM_B2:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70355,
        GIR_EraseRootFromParent_Done,
      // Label 1057: @34099
      GIM_Try, /*On fail goto*//*Label 1058*/ GIMT_Encode4(34165), // Rule ID 70356 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv32i1] }:$rs1)  =>  (PseudoVMANDN_MM_B2:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70356,
        GIR_EraseRootFromParent_Done,
      // Label 1058: @34165
      GIM_Try, /*On fail goto*//*Label 1059*/ GIMT_Encode4(34231), // Rule ID 70353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, (xor:{ *:[nxv32i1] } (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv32i1] }:$rs2))  =>  (PseudoVMANDN_MM_B2:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70353,
        GIR_EraseRootFromParent_Done,
      // Label 1059: @34231
      GIM_Try, /*On fail goto*//*Label 1060*/ GIMT_Encode4(34297), // Rule ID 70354 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, (xor:{ *:[nxv32i1] } (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv32i1] }:$rs2))  =>  (PseudoVMANDN_MM_B2:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70354,
        GIR_EraseRootFromParent_Done,
      // Label 1060: @34297
      GIM_Try, /*On fail goto*//*Label 1061*/ GIMT_Encode4(34363), // Rule ID 52816 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_B2:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52816,
        GIR_EraseRootFromParent_Done,
      // Label 1061: @34363
      GIM_Try, /*On fail goto*//*Label 1062*/ GIMT_Encode4(34429), // Rule ID 52817 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv32i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_B2:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52817,
        GIR_EraseRootFromParent_Done,
      // Label 1062: @34429
      GIM_Try, /*On fail goto*//*Label 1063*/ GIMT_Encode4(34462), // Rule ID 52804 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_B2:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_B2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52804,
        GIR_EraseRootFromParent_Done,
      // Label 1063: @34462
      GIM_Try, /*On fail goto*//*Label 1064*/ GIMT_Encode4(34495), // Rule ID 52805 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_B2:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_B2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52805,
        GIR_EraseRootFromParent_Done,
      // Label 1064: @34495
      GIM_Reject,
    // Label 1054: @34496
    GIM_Reject,
    // Label 892: @34497
    GIM_Try, /*On fail goto*//*Label 1065*/ GIMT_Encode4(34611),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1066*/ GIMT_Encode4(34565), // Rule ID 47254 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47254,
        GIR_EraseRootFromParent_Done,
      // Label 1066: @34565
      GIM_Try, /*On fail goto*//*Label 1067*/ GIMT_Encode4(34610), // Rule ID 47255 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47255,
        GIR_EraseRootFromParent_Done,
      // Label 1067: @34610
      GIM_Reject,
    // Label 1065: @34611
    GIM_Reject,
    // Label 893: @34612
    GIM_Try, /*On fail goto*//*Label 1068*/ GIMT_Encode4(34726),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1069*/ GIMT_Encode4(34680), // Rule ID 47270 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47270,
        GIR_EraseRootFromParent_Done,
      // Label 1069: @34680
      GIM_Try, /*On fail goto*//*Label 1070*/ GIMT_Encode4(34725), // Rule ID 47271 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47271,
        GIR_EraseRootFromParent_Done,
      // Label 1070: @34725
      GIM_Reject,
    // Label 1068: @34726
    GIM_Reject,
    // Label 894: @34727
    GIM_Try, /*On fail goto*//*Label 1071*/ GIMT_Encode4(35337),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1072*/ GIMT_Encode4(34808), // Rule ID 70385 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } (xor:{ *:[nxv64i1] } (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv64i1] }:$rs2), VR:{ *:[nxv64i1] }:$rs1)  =>  (PseudoVMANDN_MM_B1:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70385,
        GIR_EraseRootFromParent_Done,
      // Label 1072: @34808
      GIM_Try, /*On fail goto*//*Label 1073*/ GIMT_Encode4(34874), // Rule ID 70386 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } (xor:{ *:[nxv64i1] } (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv64i1] }:$rs2), VR:{ *:[nxv64i1] }:$rs1)  =>  (PseudoVMANDN_MM_B1:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70386,
        GIR_EraseRootFromParent_Done,
      // Label 1073: @34874
      GIM_Try, /*On fail goto*//*Label 1074*/ GIMT_Encode4(34940), // Rule ID 70383 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i64] })), VR:{ *:[nxv64i1] }:$rs1)  =>  (PseudoVMANDN_MM_B1:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70383,
        GIR_EraseRootFromParent_Done,
      // Label 1074: @34940
      GIM_Try, /*On fail goto*//*Label 1075*/ GIMT_Encode4(35006), // Rule ID 70384 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i32] })), VR:{ *:[nxv64i1] }:$rs1)  =>  (PseudoVMANDN_MM_B1:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70384,
        GIR_EraseRootFromParent_Done,
      // Label 1075: @35006
      GIM_Try, /*On fail goto*//*Label 1076*/ GIMT_Encode4(35072), // Rule ID 70381 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, (xor:{ *:[nxv64i1] } (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i64] }), VR:{ *:[nxv64i1] }:$rs2))  =>  (PseudoVMANDN_MM_B1:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70381,
        GIR_EraseRootFromParent_Done,
      // Label 1076: @35072
      GIM_Try, /*On fail goto*//*Label 1077*/ GIMT_Encode4(35138), // Rule ID 70382 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, (xor:{ *:[nxv64i1] } (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i32] }), VR:{ *:[nxv64i1] }:$rs2))  =>  (PseudoVMANDN_MM_B1:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 70382,
        GIR_EraseRootFromParent_Done,
      // Label 1077: @35138
      GIM_Try, /*On fail goto*//*Label 1078*/ GIMT_Encode4(35204), // Rule ID 52834 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i64] })))  =>  (PseudoVMANDN_MM_B1:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52834,
        GIR_EraseRootFromParent_Done,
      // Label 1078: @35204
      GIM_Try, /*On fail goto*//*Label 1079*/ GIMT_Encode4(35270), // Rule ID 52835 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(RISCV::G_VMSET_VL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs2, (riscv_vmset_vl:{ *:[nxv64i1] } srcvalue:{ *:[i32] })))  =>  (PseudoVMANDN_MM_B1:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMANDN_MM_B1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52835,
        GIR_EraseRootFromParent_Done,
      // Label 1079: @35270
      GIM_Try, /*On fail goto*//*Label 1080*/ GIMT_Encode4(35303), // Rule ID 52822 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_B1:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_B1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52822,
        GIR_EraseRootFromParent_Done,
      // Label 1080: @35303
      GIM_Try, /*On fail goto*//*Label 1081*/ GIMT_Encode4(35336), // Rule ID 52823 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_B1:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_B1),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52823,
        GIR_EraseRootFromParent_Done,
      // Label 1081: @35336
      GIM_Reject,
    // Label 1071: @35337
    GIM_Reject,
    // Label 895: @35338
    GIM_Try, /*On fail goto*//*Label 1082*/ GIMT_Encode4(35452),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1083*/ GIMT_Encode4(35406), // Rule ID 47258 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47258,
        GIR_EraseRootFromParent_Done,
      // Label 1083: @35406
      GIM_Try, /*On fail goto*//*Label 1084*/ GIMT_Encode4(35451), // Rule ID 47259 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // rs1
        GIR_RootToRootCopy, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47259,
        GIR_EraseRootFromParent_Done,
      // Label 1084: @35451
      GIM_Reject,
    // Label 1082: @35452
    GIM_Reject,
    // Label 896: @35453
    GIM_Reject,
    // Label 8: @35454
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 1116*/ GIMT_Encode4(47418),
    /*GILLT_s32*//*Label 1085*/ GIMT_Encode4(35589),
    /*GILLT_s64*//*Label 1086*/ GIMT_Encode4(38019),
    /*GILLT_nxv1s1*//*Label 1087*/ GIMT_Encode4(40611),
    /*GILLT_nxv1s8*//*Label 1088*/ GIMT_Encode4(41222),
    /*GILLT_nxv1s16*//*Label 1089*/ GIMT_Encode4(41337),
    /*GILLT_nxv1s32*//*Label 1090*/ GIMT_Encode4(41452),
    /*GILLT_nxv1s64*//*Label 1091*/ GIMT_Encode4(41567),
    /*GILLT_nxv2s1*//*Label 1092*/ GIMT_Encode4(41682),
    /*GILLT_nxv2s8*//*Label 1093*/ GIMT_Encode4(42293),
    /*GILLT_nxv2s16*//*Label 1094*/ GIMT_Encode4(42408),
    /*GILLT_nxv2s32*//*Label 1095*/ GIMT_Encode4(42523),
    /*GILLT_nxv2s64*//*Label 1096*/ GIMT_Encode4(42638),
    /*GILLT_nxv4s1*//*Label 1097*/ GIMT_Encode4(42753),
    /*GILLT_nxv4s8*//*Label 1098*/ GIMT_Encode4(43364),
    /*GILLT_nxv4s16*//*Label 1099*/ GIMT_Encode4(43479),
    /*GILLT_nxv4s32*//*Label 1100*/ GIMT_Encode4(43594),
    /*GILLT_nxv4s64*//*Label 1101*/ GIMT_Encode4(43709),
    /*GILLT_nxv8s1*//*Label 1102*/ GIMT_Encode4(43824),
    /*GILLT_nxv8s8*//*Label 1103*/ GIMT_Encode4(44435),
    /*GILLT_nxv8s16*//*Label 1104*/ GIMT_Encode4(44550),
    /*GILLT_nxv8s32*//*Label 1105*/ GIMT_Encode4(44665),
    /*GILLT_nxv8s64*//*Label 1106*/ GIMT_Encode4(44780),
    /*GILLT_nxv16s1*//*Label 1107*/ GIMT_Encode4(44895),
    /*GILLT_nxv16s8*//*Label 1108*/ GIMT_Encode4(45506),
    /*GILLT_nxv16s16*//*Label 1109*/ GIMT_Encode4(45621),
    /*GILLT_nxv16s32*//*Label 1110*/ GIMT_Encode4(45736),
    /*GILLT_nxv32s1*//*Label 1111*/ GIMT_Encode4(45851),
    /*GILLT_nxv32s8*//*Label 1112*/ GIMT_Encode4(46462),
    /*GILLT_nxv32s16*//*Label 1113*/ GIMT_Encode4(46577),
    /*GILLT_nxv64s1*//*Label 1114*/ GIMT_Encode4(46692),
    /*GILLT_nxv64s8*//*Label 1115*/ GIMT_Encode4(47303),
    // Label 1085: @35589
    GIM_Try, /*On fail goto*//*Label 1117*/ GIMT_Encode4(38018),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1118*/ GIMT_Encode4(35795), // Rule ID 64195 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/3, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/5,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/4, /*Op*/1, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/5, /*Op*/1, /*Renderer*/GIMT_Encode2(3), GIMT_Encode2(GICP_gi_zexti8),
        // (or:{ *:[i32] } (or:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs2), 8:{ *:[i32] })), (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs2), 24:{ *:[i32] }), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1), 16:{ *:[i32] })))  =>  (PACK:{ *:[i32] } (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1, GPR:{ *:[i32] }:$op0rs2), (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1, GPR:{ *:[i32] }:$op1rs2))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(3), /*SubOperand*/0, // op1rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // op1rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // op0rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // op0rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64195,
        GIR_EraseRootFromParent_Done,
      // Label 1118: @35795
      GIM_Try, /*On fail goto*//*Label 1119*/ GIMT_Encode4(35986), // Rule ID 64197 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/3, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/5,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/4, /*Op*/1, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/5, /*Op*/1, /*Renderer*/GIMT_Encode2(3), GIMT_Encode2(GICP_gi_zexti8),
        // (or:{ *:[i32] } (or:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs2), 8:{ *:[i32] })), (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1), 16:{ *:[i32] }), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs2), 24:{ *:[i32] })))  =>  (PACK:{ *:[i32] } (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1, GPR:{ *:[i32] }:$op0rs2), (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1, GPR:{ *:[i32] }:$op1rs2))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // op1rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(3), /*SubOperand*/0, // op1rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // op0rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // op0rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64197,
        GIR_EraseRootFromParent_Done,
      // Label 1119: @35986
      GIM_Try, /*On fail goto*//*Label 1120*/ GIMT_Encode4(36177), // Rule ID 64191 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/3, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/5,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/4, /*Op*/1, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/5, /*Op*/1, /*Renderer*/GIMT_Encode2(3), GIMT_Encode2(GICP_gi_zexti8),
        // (or:{ *:[i32] } (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs2), 8:{ *:[i32] }), (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1)), (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs2), 24:{ *:[i32] }), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1), 16:{ *:[i32] })))  =>  (PACK:{ *:[i32] } (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1, GPR:{ *:[i32] }:$op0rs2), (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1, GPR:{ *:[i32] }:$op1rs2))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(3), /*SubOperand*/0, // op1rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // op1rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // op0rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // op0rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64191,
        GIR_EraseRootFromParent_Done,
      // Label 1120: @36177
      GIM_Try, /*On fail goto*//*Label 1121*/ GIMT_Encode4(36368), // Rule ID 64193 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/3, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/5,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/4, /*Op*/1, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/5, /*Op*/1, /*Renderer*/GIMT_Encode2(3), GIMT_Encode2(GICP_gi_zexti8),
        // (or:{ *:[i32] } (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs2), 8:{ *:[i32] }), (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1)), (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1), 16:{ *:[i32] }), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs2), 24:{ *:[i32] })))  =>  (PACK:{ *:[i32] } (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1, GPR:{ *:[i32] }:$op0rs2), (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1, GPR:{ *:[i32] }:$op1rs2))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // op1rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(3), /*SubOperand*/0, // op1rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // op0rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // op0rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64193,
        GIR_EraseRootFromParent_Done,
      // Label 1121: @36368
      GIM_Try, /*On fail goto*//*Label 1122*/ GIMT_Encode4(36559), // Rule ID 64185 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
        GIM_CheckIsSafeToFold, /*NumInsns*/5,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/3, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/4, /*Op*/1, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/5, /*Op*/1, /*Renderer*/GIMT_Encode2(3), GIMT_Encode2(GICP_gi_zexti8),
        // (or:{ *:[i32] } (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs2), 24:{ *:[i32] }), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1), 16:{ *:[i32] })), (or:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs2), 8:{ *:[i32] })))  =>  (PACK:{ *:[i32] } (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1, GPR:{ *:[i32] }:$op0rs2), (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1, GPR:{ *:[i32] }:$op1rs2))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // op1rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // op1rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // op0rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(3), /*SubOperand*/0, // op0rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64185,
        GIR_EraseRootFromParent_Done,
      // Label 1122: @36559
      GIM_Try, /*On fail goto*//*Label 1123*/ GIMT_Encode4(36750), // Rule ID 64189 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
        GIM_CheckIsSafeToFold, /*NumInsns*/5,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/3, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/4, /*Op*/1, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/5, /*Op*/1, /*Renderer*/GIMT_Encode2(3), GIMT_Encode2(GICP_gi_zexti8),
        // (or:{ *:[i32] } (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1), 16:{ *:[i32] }), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs2), 24:{ *:[i32] })), (or:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs2), 8:{ *:[i32] })))  =>  (PACK:{ *:[i32] } (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1, GPR:{ *:[i32] }:$op0rs2), (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1, GPR:{ *:[i32] }:$op1rs2))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // op1rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // op1rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // op0rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(3), /*SubOperand*/0, // op0rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64189,
        GIR_EraseRootFromParent_Done,
      // Label 1123: @36750
      GIM_Try, /*On fail goto*//*Label 1124*/ GIMT_Encode4(36941), // Rule ID 2409 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
        GIM_CheckIsSafeToFold, /*NumInsns*/5,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/3, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/4, /*Op*/2, /*Renderer*/GIMT_Encode2(3), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/5, /*Op*/1, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_zexti8),
        // (or:{ *:[i32] } (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs2), 24:{ *:[i32] }), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1), 16:{ *:[i32] })), (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs2), 8:{ *:[i32] }), (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1)))  =>  (PACK:{ *:[i32] } (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1, GPR:{ *:[i32] }:$op0rs2), (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1, GPR:{ *:[i32] }:$op1rs2))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // op1rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // op1rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(3), /*SubOperand*/0, // op0rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // op0rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2409,
        GIR_EraseRootFromParent_Done,
      // Label 1124: @36941
      GIM_Try, /*On fail goto*//*Label 1125*/ GIMT_Encode4(37132), // Rule ID 64187 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
        GIM_CheckIsSafeToFold, /*NumInsns*/5,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/3, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/4, /*Op*/2, /*Renderer*/GIMT_Encode2(3), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/5, /*Op*/1, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_zexti8),
        // (or:{ *:[i32] } (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1), 16:{ *:[i32] }), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op1rs2), 24:{ *:[i32] })), (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs2), 8:{ *:[i32] }), (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1)))  =>  (PACK:{ *:[i32] } (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op0rs1, GPR:{ *:[i32] }:$op0rs2), (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$op1rs1, GPR:{ *:[i32] }:$op1rs2))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // op1rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/2, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // op1rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(3), /*SubOperand*/0, // op0rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // op0rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64187,
        GIR_EraseRootFromParent_Done,
      // Label 1125: @37132
      GIM_Try, /*On fail goto*//*Label 1126*/ GIMT_Encode4(37233), // Rule ID 2404 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_zexti8),
        // (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$rs2), 24:{ *:[i32] }), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$rs1), 16:{ *:[i32] }))  =>  (SLLI:{ *:[i32] } (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), 16:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2404,
        GIR_EraseRootFromParent_Done,
      // Label 1126: @37233
      GIM_Try, /*On fail goto*//*Label 1127*/ GIMT_Encode4(37334), // Rule ID 64180 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_zexti8),
        // (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$rs1), 16:{ *:[i32] }), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$rs2), 24:{ *:[i32] }))  =>  (SLLI:{ *:[i32] } (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), 16:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64180,
        GIR_EraseRootFromParent_Done,
      // Label 1127: @37334
      GIM_Try, /*On fail goto*//*Label 1128*/ GIMT_Encode4(37419), // Rule ID 64174 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        // (or:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$rs1), (and:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 8:{ *:[i32] }), 65535:{ *:[i32] }))  =>  (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64174,
        GIR_EraseRootFromParent_Done,
      // Label 1128: @37419
      GIM_Try, /*On fail goto*//*Label 1129*/ GIMT_Encode4(37504), // Rule ID 2398 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 8:{ *:[i32] }), 65535:{ *:[i32] }), (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$rs1))  =>  (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2398,
        GIR_EraseRootFromParent_Done,
      // Label 1129: @37504
      GIM_Try, /*On fail goto*//*Label 1130*/ GIMT_Encode4(37565), // Rule ID 64176 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_zexti8),
        // (or:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$rs1), (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$rs2), 8:{ *:[i32] }))  =>  (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64176,
        GIR_EraseRootFromParent_Done,
      // Label 1130: @37565
      GIM_Try, /*On fail goto*//*Label 1131*/ GIMT_Encode4(37626), // Rule ID 2400 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_zexti8),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti8),
        // (or:{ *:[i32] } (shl:{ *:[i32] } (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$rs2), 8:{ *:[i32] }), (zexti8:{ *:[i32] } GPR:{ *:[i32] }:$rs1))  =>  (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACKH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2400,
        GIR_EraseRootFromParent_Done,
      // Label 1131: @37626
      GIM_Try, /*On fail goto*//*Label 1132*/ GIMT_Encode4(37684), // Rule ID 2407 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti16),
        // (or:{ *:[i32] } (zexti16:{ *:[i32] } GPR:{ *:[i32] }:$rs1), (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 16:{ *:[i32] }))  =>  (PACK:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2407,
        GIR_EraseRootFromParent_Done,
      // Label 1132: @37684
      GIM_Try, /*On fail goto*//*Label 1133*/ GIMT_Encode4(37742), // Rule ID 64183 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbkb_IsRV32_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_zexti16),
        // (or:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 16:{ *:[i32] }), (zexti16:{ *:[i32] } GPR:{ *:[i32] }:$rs1))  =>  (PACK:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PACK),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*Renderer