/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Matcher Source Fragment                                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: Sparc.td                                                             *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  FeatureBitset ComputeAvailableFeatures(const FeatureBitset &FB) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                FeatureBitset &MissingFeatures,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0);
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0) {
    FeatureBitset MissingFeatures;
    return MatchInstructionImpl(Operands, Inst, ErrorInfo, MissingFeatures,
                                matchingInlineAsm, VariantID);
  }

  ParseStatus MatchOperandParserImpl(
    OperandVector &Operands,
    StringRef Mnemonic,
    bool ParseForAllFeatures = false);
  ParseStatus tryCustomParseOperand(
    OperandVector &Operands,
    unsigned MCK);

#endif // GET_ASSEMBLER_HEADER


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_UseSoftMulDivBit = 6,
  Feature_HasV9Bit = 2,
  Feature_HasVISBit = 3,
  Feature_HasVIS2Bit = 4,
  Feature_HasVIS3Bit = 5,
  Feature_HasCASABit = 0,
  Feature_HasPWRPSRBit = 1,
};

static MCRegister MatchRegisterName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 1 string to match.
    if (Name[0] != 'y')
      break;
    return SP::Y;	 // "y"
  case 2:	 // 86 strings to match.
    switch (Name[0]) {
    default: break;
    case 'c':	 // 16 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return SP::C0;	 // "c0"
      case '1':	 // 1 string to match.
        return SP::C1;	 // "c1"
      case '2':	 // 2 strings to match.
        return SP::C2;	 // "c2"
      case '3':	 // 1 string to match.
        return SP::C3;	 // "c3"
      case '4':	 // 2 strings to match.
        return SP::C4;	 // "c4"
      case '5':	 // 1 string to match.
        return SP::C5;	 // "c5"
      case '6':	 // 2 strings to match.
        return SP::C6;	 // "c6"
      case '7':	 // 1 string to match.
        return SP::C7;	 // "c7"
      case '8':	 // 2 strings to match.
        return SP::C8;	 // "c8"
      case '9':	 // 1 string to match.
        return SP::C9;	 // "c9"
      case 'q':	 // 1 string to match.
        return SP::CPQ;	 // "cq"
      }
      break;
    case 'f':	 // 20 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 3 strings to match.
        return SP::D0;	 // "f0"
      case '1':	 // 1 string to match.
        return SP::F1;	 // "f1"
      case '2':	 // 2 strings to match.
        return SP::D1;	 // "f2"
      case '3':	 // 1 string to match.
        return SP::F3;	 // "f3"
      case '4':	 // 3 strings to match.
        return SP::D2;	 // "f4"
      case '5':	 // 1 string to match.
        return SP::F5;	 // "f5"
      case '6':	 // 2 strings to match.
        return SP::D3;	 // "f6"
      case '7':	 // 1 string to match.
        return SP::F7;	 // "f7"
      case '8':	 // 3 strings to match.
        return SP::D4;	 // "f8"
      case '9':	 // 1 string to match.
        return SP::F9;	 // "f9"
      case 'p':	 // 1 string to match.
        return SP::I6;	 // "fp"
      case 'q':	 // 1 string to match.
        return SP::FQ;	 // "fq"
      }
      break;
    case 'g':	 // 13 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return SP::G0;	 // "g0"
      case '1':	 // 1 string to match.
        return SP::G1;	 // "g1"
      case '2':	 // 2 strings to match.
        return SP::G2;	 // "g2"
      case '3':	 // 1 string to match.
        return SP::G3;	 // "g3"
      case '4':	 // 2 strings to match.
        return SP::G4;	 // "g4"
      case '5':	 // 1 string to match.
        return SP::G5;	 // "g5"
      case '6':	 // 2 strings to match.
        return SP::G6;	 // "g6"
      case '7':	 // 1 string to match.
        return SP::G7;	 // "g7"
      case 'l':	 // 1 string to match.
        return SP::GL;	 // "gl"
      }
      break;
    case 'i':	 // 11 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return SP::I0;	 // "i0"
      case '1':	 // 1 string to match.
        return SP::I1;	 // "i1"
      case '2':	 // 2 strings to match.
        return SP::I2;	 // "i2"
      case '3':	 // 1 string to match.
        return SP::I3;	 // "i3"
      case '4':	 // 2 strings to match.
        return SP::I4;	 // "i4"
      case '5':	 // 1 string to match.
        return SP::I5;	 // "i5"
      case '6':	 // 1 string to match.
        return SP::I6_I7;	 // "i6"
      case '7':	 // 1 string to match.
        return SP::I7;	 // "i7"
      }
      break;
    case 'l':	 // 12 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return SP::L0;	 // "l0"
      case '1':	 // 1 string to match.
        return SP::L1;	 // "l1"
      case '2':	 // 2 strings to match.
        return SP::L2;	 // "l2"
      case '3':	 // 1 string to match.
        return SP::L3;	 // "l3"
      case '4':	 // 2 strings to match.
        return SP::L4;	 // "l4"
      case '5':	 // 1 string to match.
        return SP::L5;	 // "l5"
      case '6':	 // 2 strings to match.
        return SP::L6;	 // "l6"
      case '7':	 // 1 string to match.
        return SP::L7;	 // "l7"
      }
      break;
    case 'o':	 // 11 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return SP::O0;	 // "o0"
      case '1':	 // 1 string to match.
        return SP::O1;	 // "o1"
      case '2':	 // 2 strings to match.
        return SP::O2;	 // "o2"
      case '3':	 // 1 string to match.
        return SP::O3;	 // "o3"
      case '4':	 // 2 strings to match.
        return SP::O4;	 // "o4"
      case '5':	 // 1 string to match.
        return SP::O5;	 // "o5"
      case '6':	 // 1 string to match.
        return SP::O6_O7;	 // "o6"
      case '7':	 // 1 string to match.
        return SP::O7;	 // "o7"
      }
      break;
    case 's':	 // 1 string to match.
      if (Name[1] != 'p')
        break;
      return SP::O6;	 // "sp"
    case 't':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        return SP::TL;	 // "tl"
      case 't':	 // 1 string to match.
        return SP::TT;	 // "tt"
      }
      break;
    }
    break;
  case 3:	 // 106 strings to match.
    switch (Name[0]) {
    default: break;
    case 'c':	 // 35 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 15 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return SP::C10;	 // "c10"
        case '1':	 // 1 string to match.
          return SP::C11;	 // "c11"
        case '2':	 // 2 strings to match.
          return SP::C12;	 // "c12"
        case '3':	 // 1 string to match.
          return SP::C13;	 // "c13"
        case '4':	 // 2 strings to match.
          return SP::C14;	 // "c14"
        case '5':	 // 1 string to match.
          return SP::C15;	 // "c15"
        case '6':	 // 2 strings to match.
          return SP::C16;	 // "c16"
        case '7':	 // 1 string to match.
          return SP::C17;	 // "c17"
        case '8':	 // 2 strings to match.
          return SP::C18;	 // "c18"
        case '9':	 // 1 string to match.
          return SP::C19;	 // "c19"
        }
        break;
      case '2':	 // 15 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return SP::C20;	 // "c20"
        case '1':	 // 1 string to match.
          return SP::C21;	 // "c21"
        case '2':	 // 2 strings to match.
          return SP::C22;	 // "c22"
        case '3':	 // 1 string to match.
          return SP::C23;	 // "c23"
        case '4':	 // 2 strings to match.
          return SP::C24;	 // "c24"
        case '5':	 // 1 string to match.
          return SP::C25;	 // "c25"
        case '6':	 // 2 strings to match.
          return SP::C26;	 // "c26"
        case '7':	 // 1 string to match.
          return SP::C27;	 // "c27"
        case '8':	 // 2 strings to match.
          return SP::C28;	 // "c28"
        case '9':	 // 1 string to match.
          return SP::C29;	 // "c29"
        }
        break;
      case '3':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return SP::C30;	 // "c30"
        case '1':	 // 1 string to match.
          return SP::C31;	 // "c31"
        }
        break;
      case 's':	 // 1 string to match.
        if (Name[2] != 'r')
          break;
        return SP::CPSR;	 // "csr"
      case 'w':	 // 1 string to match.
        if (Name[2] != 'p')
          break;
        return SP::CWP;	 // "cwp"
      }
      break;
    case 'f':	 // 63 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 17 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return SP::D5;	 // "f10"
        case '1':	 // 1 string to match.
          return SP::F11;	 // "f11"
        case '2':	 // 3 strings to match.
          return SP::D6;	 // "f12"
        case '3':	 // 1 string to match.
          return SP::F13;	 // "f13"
        case '4':	 // 2 strings to match.
          return SP::D7;	 // "f14"
        case '5':	 // 1 string to match.
          return SP::F15;	 // "f15"
        case '6':	 // 3 strings to match.
          return SP::D8;	 // "f16"
        case '7':	 // 1 string to match.
          return SP::F17;	 // "f17"
        case '8':	 // 2 strings to match.
          return SP::D9;	 // "f18"
        case '9':	 // 1 string to match.
          return SP::F19;	 // "f19"
        }
        break;
      case '2':	 // 18 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return SP::D10;	 // "f20"
        case '1':	 // 1 string to match.
          return SP::F21;	 // "f21"
        case '2':	 // 2 strings to match.
          return SP::D11;	 // "f22"
        case '3':	 // 1 string to match.
          return SP::F23;	 // "f23"
        case '4':	 // 3 strings to match.
          return SP::D12;	 // "f24"
        case '5':	 // 1 string to match.
          return SP::F25;	 // "f25"
        case '6':	 // 2 strings to match.
          return SP::D13;	 // "f26"
        case '7':	 // 1 string to match.
          return SP::F27;	 // "f27"
        case '8':	 // 3 strings to match.
          return SP::D14;	 // "f28"
        case '9':	 // 1 string to match.
          return SP::F29;	 // "f29"
        }
        break;
      case '3':	 // 9 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return SP::D15;	 // "f30"
        case '1':	 // 1 string to match.
          return SP::F31;	 // "f31"
        case '2':	 // 2 strings to match.
          return SP::D16;	 // "f32"
        case '4':	 // 1 string to match.
          return SP::D17;	 // "f34"
        case '6':	 // 2 strings to match.
          return SP::D18;	 // "f36"
        case '8':	 // 1 string to match.
          return SP::D19;	 // "f38"
        }
        break;
      case '4':	 // 8 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return SP::D20;	 // "f40"
        case '2':	 // 1 string to match.
          return SP::D21;	 // "f42"
        case '4':	 // 2 strings to match.
          return SP::D22;	 // "f44"
        case '6':	 // 1 string to match.
          return SP::D23;	 // "f46"
        case '8':	 // 2 strings to match.
          return SP::D24;	 // "f48"
        }
        break;
      case '5':	 // 7 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return SP::D25;	 // "f50"
        case '2':	 // 2 strings to match.
          return SP::D26;	 // "f52"
        case '4':	 // 1 string to match.
          return SP::D27;	 // "f54"
        case '6':	 // 2 strings to match.
          return SP::D28;	 // "f56"
        case '8':	 // 1 string to match.
          return SP::D29;	 // "f58"
        }
        break;
      case '6':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return SP::D30;	 // "f60"
        case '2':	 // 1 string to match.
          return SP::D31;	 // "f62"
        }
        break;
      case 's':	 // 1 string to match.
        if (Name[2] != 'r')
          break;
        return SP::FSR;	 // "fsr"
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(Name.data()+1, "cc", 2) != 0)
        break;
      return SP::ICC;	 // "icc"
    case 'p':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return SP::PIL;	 // "pil"
      case 's':	 // 1 string to match.
        if (Name[2] != 'r')
          break;
        return SP::PSR;	 // "psr"
      }
      break;
    case 't':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'b':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'a':	 // 1 string to match.
          return SP::TBA;	 // "tba"
        case 'r':	 // 1 string to match.
          return SP::TBR;	 // "tbr"
        }
        break;
      case 'p':	 // 1 string to match.
        if (Name[2] != 'c')
          break;
        return SP::TPC;	 // "tpc"
      }
      break;
    case 'v':	 // 1 string to match.
      if (memcmp(Name.data()+1, "er", 2) != 0)
        break;
      return SP::VER;	 // "ver"
    case 'w':	 // 1 string to match.
      if (memcmp(Name.data()+1, "im", 2) != 0)
        break;
      return SP::WIM;	 // "wim"
    }
    break;
  case 4:	 // 15 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 9 strings to match.
      if (memcmp(Name.data()+1, "sr", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 1 string to match.
        return SP::ASR1;	 // "asr1"
      case '2':	 // 1 string to match.
        return SP::ASR2;	 // "asr2"
      case '3':	 // 1 string to match.
        return SP::ASR3;	 // "asr3"
      case '4':	 // 1 string to match.
        return SP::ASR4;	 // "asr4"
      case '5':	 // 1 string to match.
        return SP::ASR5;	 // "asr5"
      case '6':	 // 1 string to match.
        return SP::ASR6;	 // "asr6"
      case '7':	 // 1 string to match.
        return SP::ASR7;	 // "asr7"
      case '8':	 // 1 string to match.
        return SP::ASR8;	 // "asr8"
      case '9':	 // 1 string to match.
        return SP::ASR9;	 // "asr9"
      }
      break;
    case 'f':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "cc", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return SP::FCC0;	 // "fcc0"
      case '1':	 // 1 string to match.
        return SP::FCC1;	 // "fcc1"
      case '2':	 // 1 string to match.
        return SP::FCC2;	 // "fcc2"
      case '3':	 // 1 string to match.
        return SP::FCC3;	 // "fcc3"
      }
      break;
    case 't':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+2, "ck", 2) != 0)
          break;
        return SP::TICK;	 // "tick"
      case 'n':	 // 1 string to match.
        if (memcmp(Name.data()+2, "pc", 2) != 0)
          break;
        return SP::TNPC;	 // "tnpc"
      }
      break;
    }
    break;
  case 5:	 // 22 strings to match.
    if (memcmp(Name.data()+0, "asr", 3) != 0)
      break;
    switch (Name[3]) {
    default: break;
    case '1':	 // 10 strings to match.
      switch (Name[4]) {
      default: break;
      case '0':	 // 1 string to match.
        return SP::ASR10;	 // "asr10"
      case '1':	 // 1 string to match.
        return SP::ASR11;	 // "asr11"
      case '2':	 // 1 string to match.
        return SP::ASR12;	 // "asr12"
      case '3':	 // 1 string to match.
        return SP::ASR13;	 // "asr13"
      case '4':	 // 1 string to match.
        return SP::ASR14;	 // "asr14"
      case '5':	 // 1 string to match.
        return SP::ASR15;	 // "asr15"
      case '6':	 // 1 string to match.
        return SP::ASR16;	 // "asr16"
      case '7':	 // 1 string to match.
        return SP::ASR17;	 // "asr17"
      case '8':	 // 1 string to match.
        return SP::ASR18;	 // "asr18"
      case '9':	 // 1 string to match.
        return SP::ASR19;	 // "asr19"
      }
      break;
    case '2':	 // 10 strings to match.
      switch (Name[4]) {
      default: break;
      case '0':	 // 1 string to match.
        return SP::ASR20;	 // "asr20"
      case '1':	 // 1 string to match.
        return SP::ASR21;	 // "asr21"
      case '2':	 // 1 string to match.
        return SP::ASR22;	 // "asr22"
      case '3':	 // 1 string to match.
        return SP::ASR23;	 // "asr23"
      case '4':	 // 1 string to match.
        return SP::ASR24;	 // "asr24"
      case '5':	 // 1 string to match.
        return SP::ASR25;	 // "asr25"
      case '6':	 // 1 string to match.
        return SP::ASR26;	 // "asr26"
      case '7':	 // 1 string to match.
        return SP::ASR27;	 // "asr27"
      case '8':	 // 1 string to match.
        return SP::ASR28;	 // "asr28"
      case '9':	 // 1 string to match.
        return SP::ASR29;	 // "asr29"
      }
      break;
    case '3':	 // 2 strings to match.
      switch (Name[4]) {
      default: break;
      case '0':	 // 1 string to match.
        return SP::ASR30;	 // "asr30"
      case '1':	 // 1 string to match.
        return SP::ASR31;	 // "asr31"
      }
      break;
    }
    break;
  case 6:	 // 3 strings to match.
    switch (Name[0]) {
    default: break;
    case 'p':	 // 1 string to match.
      if (memcmp(Name.data()+1, "state", 5) != 0)
        break;
      return SP::PSTATE;	 // "pstate"
    case 't':	 // 1 string to match.
      if (memcmp(Name.data()+1, "state", 5) != 0)
        break;
      return SP::TSTATE;	 // "tstate"
    case 'w':	 // 1 string to match.
      if (memcmp(Name.data()+1, "state", 5) != 0)
        break;
      return SP::WSTATE;	 // "wstate"
    }
    break;
  case 7:	 // 1 string to match.
    if (memcmp(Name.data()+0, "cansave", 7) != 0)
      break;
    return SP::CANSAVE;	 // "cansave"
  case 8:	 // 2 strings to match.
    switch (Name[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(Name.data()+1, "leanwin", 7) != 0)
        break;
      return SP::CLEANWIN;	 // "cleanwin"
    case 'o':	 // 1 string to match.
      if (memcmp(Name.data()+1, "therwin", 7) != 0)
        break;
      return SP::OTHERWIN;	 // "otherwin"
    }
    break;
  case 10:	 // 1 string to match.
    if (memcmp(Name.data()+0, "canrestore", 10) != 0)
      break;
    return SP::CANRESTORE;	 // "canrestore"
  }
  return SP::NoRegister;
}

static MCRegister MatchRegisterAltName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 2:	 // 1 string to match.
    if (memcmp(Name.data()+0, "pc", 2) != 0)
      break;
    return SP::ASR5;	 // "pc"
  case 3:	 // 2 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+1, "si", 2) != 0)
        break;
      return SP::ASR3;	 // "asi"
    case 'c':	 // 1 string to match.
      if (memcmp(Name.data()+1, "cr", 2) != 0)
        break;
      return SP::ASR2;	 // "ccr"
    }
    break;
  case 4:	 // 2 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "prs", 3) != 0)
        break;
      return SP::ASR6;	 // "fprs"
    case 't':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ick", 3) != 0)
        break;
      return SP::ASR4;	 // "tick"
    }
    break;
  }
  return SP::NoRegister;
}

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(uint64_t Val) {
  switch(Val) {
  case Feature_UseSoftMulDivBit: return "";
  case Feature_HasV9Bit: return "";
  case Feature_HasVISBit: return "";
  case Feature_HasVIS2Bit: return "";
  case Feature_HasVIS3Bit: return "";
  case Feature_HasCASABit: return "";
  case Feature_HasPWRPSRBit: return "";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, const FeatureBitset &Features, unsigned VariantID) {
  switch (VariantID) {
  case 0:
      switch (Mnemonic.size()) {
      default: break;
      case 3:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "stw", 3) != 0)
          break;
        if (Features.test(Feature_HasV9Bit))	 // "stw"
          Mnemonic = "st";
        return;
      case 4:	 // 10 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ddc", 3) != 0)
            break;
          if (Features.test(Feature_HasV9Bit))	 // "addc"
            Mnemonic = "addx";
          return;
        case 'l':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "duw", 3) != 0)
            break;
          if (Features.test(Feature_HasV9Bit))	 // "lduw"
            Mnemonic = "ld";
          return;
        case 's':	 // 8 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 't':	 // 7 strings to match.
            switch (Mnemonic[2]) {
            default: break;
            case 's':	 // 3 strings to match.
              switch (Mnemonic[3]) {
              default: break;
              case 'b':	 // 1 string to match.
                Mnemonic = "stb";	 // "stsb"
                return;
              case 'h':	 // 1 string to match.
                Mnemonic = "sth";	 // "stsh"
                return;
              case 'w':	 // 1 string to match.
                if (Features.test(Feature_HasV9Bit))	 // "stsw"
                  Mnemonic = "st";
                return;
              }
              break;
            case 'u':	 // 3 strings to match.
              switch (Mnemonic[3]) {
              default: break;
              case 'b':	 // 1 string to match.
                Mnemonic = "stb";	 // "stub"
                return;
              case 'h':	 // 1 string to match.
                Mnemonic = "sth";	 // "stuh"
                return;
              case 'w':	 // 1 string to match.
                if (Features.test(Feature_HasV9Bit))	 // "stuw"
                  Mnemonic = "st";
                return;
              }
              break;
            case 'w':	 // 1 string to match.
              if (Mnemonic[3] != 'a')
                break;
              if (Features.test(Feature_HasV9Bit))	 // "stwa"
                Mnemonic = "sta";
              return;
            }
            break;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "bc", 2) != 0)
              break;
            if (Features.test(Feature_HasV9Bit))	 // "subc"
              Mnemonic = "subx";
            return;
          }
          break;
        }
        break;
      case 5:	 // 7 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'l':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "duwa", 4) != 0)
            break;
          if (Features.test(Feature_HasV9Bit))	 // "lduwa"
            Mnemonic = "lda";
          return;
        case 's':	 // 6 strings to match.
          if (Mnemonic[1] != 't')
            break;
          switch (Mnemonic[2]) {
          default: break;
          case 's':	 // 3 strings to match.
            switch (Mnemonic[3]) {
            default: break;
            case 'b':	 // 1 string to match.
              if (Mnemonic[4] != 'a')
                break;
              Mnemonic = "stba";	 // "stsba"
              return;
            case 'h':	 // 1 string to match.
              if (Mnemonic[4] != 'a')
                break;
              Mnemonic = "stha";	 // "stsha"
              return;
            case 'w':	 // 1 string to match.
              if (Mnemonic[4] != 'a')
                break;
              if (Features.test(Feature_HasV9Bit))	 // "stswa"
                Mnemonic = "sta";
              return;
            }
            break;
          case 'u':	 // 3 strings to match.
            switch (Mnemonic[3]) {
            default: break;
            case 'b':	 // 1 string to match.
              if (Mnemonic[4] != 'a')
                break;
              Mnemonic = "stba";	 // "stuba"
              return;
            case 'h':	 // 1 string to match.
              if (Mnemonic[4] != 'a')
                break;
              Mnemonic = "stha";	 // "stuha"
              return;
            case 'w':	 // 1 string to match.
              if (Mnemonic[4] != 'a')
                break;
              if (Features.test(Feature_HasV9Bit))	 // "stuwa"
                Mnemonic = "sta";
              return;
            }
            break;
          }
          break;
        }
        break;
      case 6:	 // 4 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ddccc", 5) != 0)
            break;
          if (Features.test(Feature_HasV9Bit))	 // "addccc"
            Mnemonic = "addxcc";
          return;
        case 'i':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "flush", 5) != 0)
            break;
          Mnemonic = "flush";	 // "iflush"
          return;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "eturn", 5) != 0)
            break;
          if (Features.test(Feature_HasV9Bit))	 // "return"
            Mnemonic = "rett";
          return;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ubccc", 5) != 0)
            break;
          if (Features.test(Feature_HasV9Bit))	 // "subccc"
            Mnemonic = "subxcc";
          return;
        }
        break;
      }
    break;
  }
  switch (Mnemonic.size()) {
  default: break;
  case 3:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "stw", 3) != 0)
      break;
    if (Features.test(Feature_HasV9Bit))	 // "stw"
      Mnemonic = "st";
    return;
  case 4:	 // 10 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "ddc", 3) != 0)
        break;
      if (Features.test(Feature_HasV9Bit))	 // "addc"
        Mnemonic = "addx";
      return;
    case 'l':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "duw", 3) != 0)
        break;
      if (Features.test(Feature_HasV9Bit))	 // "lduw"
        Mnemonic = "ld";
      return;
    case 's':	 // 8 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 't':	 // 7 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 's':	 // 3 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            Mnemonic = "stb";	 // "stsb"
            return;
          case 'h':	 // 1 string to match.
            Mnemonic = "sth";	 // "stsh"
            return;
          case 'w':	 // 1 string to match.
            if (Features.test(Feature_HasV9Bit))	 // "stsw"
              Mnemonic = "st";
            return;
          }
          break;
        case 'u':	 // 3 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            Mnemonic = "stb";	 // "stub"
            return;
          case 'h':	 // 1 string to match.
            Mnemonic = "sth";	 // "stuh"
            return;
          case 'w':	 // 1 string to match.
            if (Features.test(Feature_HasV9Bit))	 // "stuw"
              Mnemonic = "st";
            return;
          }
          break;
        case 'w':	 // 1 string to match.
          if (Mnemonic[3] != 'a')
            break;
          if (Features.test(Feature_HasV9Bit))	 // "stwa"
            Mnemonic = "sta";
          return;
        }
        break;
      case 'u':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "bc", 2) != 0)
          break;
        if (Features.test(Feature_HasV9Bit))	 // "subc"
          Mnemonic = "subx";
        return;
      }
      break;
    }
    break;
  case 5:	 // 7 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'l':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "duwa", 4) != 0)
        break;
      if (Features.test(Feature_HasV9Bit))	 // "lduwa"
        Mnemonic = "lda";
      return;
    case 's':	 // 6 strings to match.
      if (Mnemonic[1] != 't')
        break;
      switch (Mnemonic[2]) {
      default: break;
      case 's':	 // 3 strings to match.
        switch (Mnemonic[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          if (Mnemonic[4] != 'a')
            break;
          Mnemonic = "stba";	 // "stsba"
          return;
        case 'h':	 // 1 string to match.
          if (Mnemonic[4] != 'a')
            break;
          Mnemonic = "stha";	 // "stsha"
          return;
        case 'w':	 // 1 string to match.
          if (Mnemonic[4] != 'a')
            break;
          if (Features.test(Feature_HasV9Bit))	 // "stswa"
            Mnemonic = "sta";
          return;
        }
        break;
      case 'u':	 // 3 strings to match.
        switch (Mnemonic[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          if (Mnemonic[4] != 'a')
            break;
          Mnemonic = "stba";	 // "stuba"
          return;
        case 'h':	 // 1 string to match.
          if (Mnemonic[4] != 'a')
            break;
          Mnemonic = "stha";	 // "stuha"
          return;
        case 'w':	 // 1 string to match.
          if (Mnemonic[4] != 'a')
            break;
          if (Features.test(Feature_HasV9Bit))	 // "stuwa"
            Mnemonic = "sta";
          return;
        }
        break;
      }
      break;
    }
    break;
  case 6:	 // 4 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "ddccc", 5) != 0)
        break;
      if (Features.test(Feature_HasV9Bit))	 // "addccc"
        Mnemonic = "addxcc";
      return;
    case 'i':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "flush", 5) != 0)
        break;
      Mnemonic = "flush";	 // "iflush"
      return;
    case 'r':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "eturn", 5) != 0)
        break;
      if (Features.test(Feature_HasV9Bit))	 // "return"
        Mnemonic = "rett";
      return;
    case 's':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "ubccc", 5) != 0)
        break;
      if (Features.test(Feature_HasV9Bit))	 // "subccc"
        Mnemonic = "subxcc";
      return;
    }
    break;
  }
}

enum {
  Tie0_1_1,
  Tie0_3_3,
  Tie0_5_5,
};

static const uint8_t TiedAsmOperandTable[][3] = {
  /* Tie0_1_1 */ { 0, 1, 1 },
  /* Tie0_3_3 */ { 0, 3, 3 },
  /* Tie0_5_5 */ { 0, 5, 5 },
};

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_95_Reg,
  CVT_95_addImmOperands,
  CVT_95_addTailRelocSymOperands,
  CVT_imm_95_8,
  CVT_imm_95_13,
  CVT_imm_95_5,
  CVT_imm_95_1,
  CVT_imm_95_10,
  CVT_imm_95_11,
  CVT_imm_95_12,
  CVT_imm_95_3,
  CVT_imm_95_2,
  CVT_imm_95_4,
  CVT_imm_95_0,
  CVT_imm_95_9,
  CVT_imm_95_6,
  CVT_imm_95_14,
  CVT_imm_95_7,
  CVT_regG0,
  CVT_imm_95_15,
  CVT_95_addCallTargetOperands,
  CVT_regO7,
  CVT_95_addMEMriOperands,
  CVT_95_addMEMrrOperands,
  CVT_imm_95_128,
  CVT_95_addASITagOperands,
  CVT_imm_95_136,
  CVT_regFCC0,
  CVT_95_addMembarTagOperands,
  CVT_95_addPrefetchTagOperands,
  CVT_95_addShiftAmtImm5Operands,
  CVT_95_addShiftAmtImm6Operands,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert__Reg1_2__Reg1_0__Reg1_1,
  Convert__Reg1_2__Reg1_0__Imm1_1,
  Convert__Reg1_2__Reg1_0__Reg1_1__TailRelocSymAdd_TLS1_3,
  Convert__Reg1_2__Reg1_1__Imm1_0,
  Convert__Imm1_0__imm_95_8,
  Convert__Imm1_1__imm_95_8,
  Convert__Imm1_1__Imm1_0,
  Convert__Imm1_2__imm_95_8,
  Convert__Imm1_2__Imm1_0,
  Convert__Imm1_3__imm_95_8,
  Convert__Imm1_3__Imm1_0,
  Convert__Imm1_4__Imm1_0,
  Convert__Imm1_0,
  Convert__Imm1_0__imm_95_13,
  Convert__Imm1_1__imm_95_13,
  Convert__Imm1_2__imm_95_13,
  Convert__Imm1_3__imm_95_13,
  Convert__Reg1_1__Reg1_1__Reg1_0,
  Convert__Reg1_1__Reg1_1__Imm1_0,
  Convert__Imm1_0__imm_95_5,
  Convert__Imm1_1__imm_95_5,
  Convert__Imm1_2__imm_95_5,
  Convert__Imm1_3__imm_95_5,
  Convert__Imm1_0__imm_95_1,
  Convert__Imm1_1__imm_95_1,
  Convert__Imm1_2__imm_95_1,
  Convert__Imm1_3__imm_95_1,
  Convert__Imm1_0__imm_95_10,
  Convert__Imm1_1__imm_95_10,
  Convert__Imm1_2__imm_95_10,
  Convert__Imm1_3__imm_95_10,
  Convert__Imm1_0__imm_95_11,
  Convert__Imm1_1__imm_95_11,
  Convert__Imm1_2__imm_95_11,
  Convert__Imm1_3__imm_95_11,
  Convert__Imm1_0__imm_95_12,
  Convert__Imm1_1__imm_95_12,
  Convert__Imm1_2__imm_95_12,
  Convert__Imm1_3__imm_95_12,
  Convert__Imm1_0__imm_95_3,
  Convert__Imm1_1__imm_95_3,
  Convert__Imm1_2__imm_95_3,
  Convert__Imm1_3__imm_95_3,
  Convert__Imm1_0__imm_95_2,
  Convert__Imm1_1__imm_95_2,
  Convert__Imm1_2__imm_95_2,
  Convert__Imm1_3__imm_95_2,
  Convert__Imm1_0__imm_95_4,
  Convert__Imm1_1__imm_95_4,
  Convert__Imm1_2__imm_95_4,
  Convert__Imm1_3__imm_95_4,
  Convert__Imm1_0__imm_95_0,
  Convert__Imm1_1__imm_95_0,
  Convert__Imm1_2__imm_95_0,
  Convert__Imm1_3__imm_95_0,
  Convert__Imm1_0__imm_95_9,
  Convert__Imm1_1__imm_95_9,
  Convert__Imm1_2__imm_95_9,
  Convert__Imm1_3__imm_95_9,
  Convert__Imm1_0__imm_95_6,
  Convert__Imm1_1__imm_95_6,
  Convert__Imm1_2__imm_95_6,
  Convert__Imm1_3__imm_95_6,
  Convert__Imm1_0__imm_95_14,
  Convert__Imm1_1__imm_95_14,
  Convert__Imm1_2__imm_95_14,
  Convert__Imm1_3__imm_95_14,
  Convert__Imm1_2__Imm1_0__Reg1_1,
  Convert__Imm1_3__Imm1_0__Reg1_2,
  Convert__Imm1_4__Imm1_0__Reg1_3,
  Convert__Imm1_1__imm_95_1__Reg1_0,
  Convert__Imm1_2__imm_95_1__Reg1_1,
  Convert__Imm1_3__imm_95_1__Reg1_2,
  Convert__Imm1_1__imm_95_7__Reg1_0,
  Convert__Imm1_2__imm_95_7__Reg1_1,
  Convert__Imm1_3__imm_95_7__Reg1_2,
  Convert__Imm1_1__imm_95_6__Reg1_0,
  Convert__Imm1_2__imm_95_6__Reg1_1,
  Convert__Imm1_3__imm_95_6__Reg1_2,
  Convert__Imm1_1__imm_95_2__Reg1_0,
  Convert__Imm1_2__imm_95_2__Reg1_1,
  Convert__Imm1_3__imm_95_2__Reg1_2,
  Convert__Imm1_1__imm_95_3__Reg1_0,
  Convert__Imm1_2__imm_95_3__Reg1_1,
  Convert__Imm1_3__imm_95_3__Reg1_2,
  Convert__Imm1_1__imm_95_5__Reg1_0,
  Convert__Imm1_2__imm_95_5__Reg1_1,
  Convert__Imm1_3__imm_95_5__Reg1_2,
  Convert__regG0__Reg1_1__Reg1_0,
  Convert__regG0__Reg1_1__Imm1_0,
  Convert__Imm1_0__imm_95_15,
  Convert__Imm1_1__imm_95_15,
  Convert__Imm1_2__imm_95_15,
  Convert__Imm1_3__imm_95_15,
  Convert__Imm1_0__imm_95_7,
  Convert__Imm1_1__imm_95_7,
  Convert__Imm1_2__imm_95_7,
  Convert__Imm1_3__imm_95_7,
  Convert__CallTarget1_0,
  Convert__regO7__MEMri2_0,
  Convert__regO7__MEMrr2_0,
  Convert__CallTarget1_0__TailRelocSymCall_TLS1_1,
  Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_128,
  Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1,
  Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1__ASITag1_3,
  Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_136,
  Convert__Reg1_0__regG0__regG0,
  Convert__MEMri2_1__regG0,
  Convert__MEMrr2_1__regG0,
  Convert__Reg1_0,
  Convert__regG0__Reg1_0__Reg1_1,
  Convert__regG0__Reg1_0__Imm1_1,
  Convert__Reg1_0__Reg1_0__imm_95_1,
  Convert_NoOperands,
  Convert__Reg1_1__Reg1_0,
  Convert__Imm1_1__imm_95_8__Reg1_0,
  Convert__Imm1_2__imm_95_8__Reg1_1,
  Convert__Imm1_3__imm_95_8__Reg1_2,
  Convert__Imm1_1__imm_95_9__Reg1_0,
  Convert__Imm1_2__imm_95_9__Reg1_1,
  Convert__Imm1_3__imm_95_9__Reg1_2,
  Convert__Imm1_1__imm_95_11__Reg1_0,
  Convert__Imm1_2__imm_95_11__Reg1_1,
  Convert__Imm1_3__imm_95_11__Reg1_2,
  Convert__Imm1_1__imm_95_4__Reg1_0,
  Convert__Imm1_2__imm_95_4__Reg1_1,
  Convert__Imm1_3__imm_95_4__Reg1_2,
  Convert__Imm1_1__imm_95_13__Reg1_0,
  Convert__Imm1_2__imm_95_13__Reg1_1,
  Convert__Imm1_3__imm_95_13__Reg1_2,
  Convert__Imm1_1__imm_95_0__Reg1_0,
  Convert__Imm1_2__imm_95_0__Reg1_1,
  Convert__Imm1_3__imm_95_0__Reg1_2,
  Convert__Imm1_1__imm_95_15__Reg1_0,
  Convert__Imm1_2__imm_95_15__Reg1_1,
  Convert__Imm1_3__imm_95_15__Reg1_2,
  Convert__Imm1_1__imm_95_10__Reg1_0,
  Convert__Imm1_2__imm_95_10__Reg1_1,
  Convert__Imm1_3__imm_95_10__Reg1_2,
  Convert__Imm1_1__imm_95_12__Reg1_0,
  Convert__Imm1_2__imm_95_12__Reg1_1,
  Convert__Imm1_3__imm_95_12__Reg1_2,
  Convert__Imm1_1__imm_95_14__Reg1_0,
  Convert__Imm1_2__imm_95_14__Reg1_1,
  Convert__Imm1_3__imm_95_14__Reg1_2,
  Convert__regFCC0__Reg1_0__Reg1_1,
  Convert__Reg1_0__Reg1_1__Reg1_2,
  Convert__MEMri2_0,
  Convert__MEMrr2_0,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8,
  Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0,
  Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_11,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_4,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_13,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_0,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_15,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_10,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_12,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_14,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7,
  Convert__Reg1_0__Tie0_1_1,
  Convert__regG0__MEMri2_0,
  Convert__regG0__MEMrr2_0,
  Convert__Reg1_1__MEMri2_0,
  Convert__Reg1_1__MEMrr2_0,
  Convert__MEMri2_1,
  Convert__Reg1_3__MEMri2_1,
  Convert__MEMrr2_1,
  Convert__Reg1_3__MEMrr2_1,
  Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_GOT1_4,
  Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_TLS1_4,
  Convert__Reg1_4__MEMri2_1,
  Convert__Reg1_4__MEMrr2_1__ASITag1_3,
  Convert__MembarTag1_0,
  Convert__Reg1_1,
  Convert__regG0__Reg1_0,
  Convert__Reg1_1__regG0__Reg1_0,
  Convert__regG0__Imm1_0,
  Convert__Reg1_1__regG0__Imm1_0,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_8,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_8,
  Convert__Reg1_3__Imm1_2__Tie0_1_1__Imm1_0,
  Convert__Reg1_3__Reg1_1__Imm1_2__Tie0_1_1__Imm1_0,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_13,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_5,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_9,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_10,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_6,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_11,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_11,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_12,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_3,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_4,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_2,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_13,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_4,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_2,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_0,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_0,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_9,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_1,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_6,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_15,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_14,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_7,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_3,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_5,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_10,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_12,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_14,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_15,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_7,
  Convert__Reg1_0__regG0__Reg1_0,
  Convert__Reg1_0__Reg1_0__regG0,
  Convert__Reg1_1__Reg1_0__regG0,
  Convert__MEMri2_1__PrefetchTag1_3,
  Convert__MEMrr2_1__PrefetchTag1_3,
  Convert__MEMri2_1__PrefetchTag1_4,
  Convert__MEMrr2_1__ASITag1_3__PrefetchTag1_4,
  Convert__Reg1_0__Reg1_1,
  Convert__Reg1_0__Imm1_1,
  Convert__regG0__regG0__regG0,
  Convert__imm_95_8,
  Convert__Reg1_1__Imm1_0,
  Convert__Reg1_2__Imm1_0__Reg1_1,
  Convert__imm_95_0,
  Convert__Reg1_2__Reg1_0__ShiftAmtImm51_1,
  Convert__Reg1_2__Reg1_0__ShiftAmtImm61_1,
  Convert__Reg1_2__Reg1_0__Reg1_1__imm_95_0,
  Convert__Reg1_2__Reg1_0__Imm1_1__imm_95_0,
  Convert__MEMri2_2,
  Convert__MEMrr2_2,
  Convert__MEMri2_2__Reg1_0,
  Convert__MEMrr2_2__Reg1_0,
  Convert__MEMrr2_2__Reg1_0__ASITag1_4,
  Convert__Reg1_3__MEMri2_1__Tie0_1_1,
  Convert__Reg1_3__MEMrr2_1__Tie0_1_1,
  Convert__Reg1_4__MEMri2_1__Tie0_1_1,
  Convert__Reg1_4__MEMrr2_1__ASITag1_3__Tie0_1_1,
  Convert__regG0__Reg1_0__imm_95_8,
  Convert__regG0__Imm1_0__imm_95_8,
  Convert__regG0__Reg1_1__imm_95_8,
  Convert__regG0__Imm1_1__imm_95_8,
  Convert__Reg1_0__Reg1_2__imm_95_8,
  Convert__Reg1_0__Imm1_2__imm_95_8,
  Convert__Reg1_1__Reg1_3__imm_95_8,
  Convert__Reg1_1__Imm1_3__imm_95_8,
  Convert__Reg1_1__Reg1_3__Imm1_0,
  Convert__Reg1_1__Imm1_3__Imm1_0,
  Convert__Reg1_2__Reg1_4__Imm1_0,
  Convert__Reg1_2__Imm1_4__Imm1_0,
  Convert__regG0__Reg1_0__imm_95_13,
  Convert__regG0__Imm1_0__imm_95_13,
  Convert__regG0__Reg1_1__imm_95_13,
  Convert__regG0__Imm1_1__imm_95_13,
  Convert__Reg1_0__Reg1_2__imm_95_13,
  Convert__Reg1_0__Imm1_2__imm_95_13,
  Convert__Reg1_1__Reg1_3__imm_95_13,
  Convert__Reg1_1__Imm1_3__imm_95_13,
  Convert__regG0__Reg1_0__imm_95_5,
  Convert__regG0__Imm1_0__imm_95_5,
  Convert__regG0__Reg1_1__imm_95_5,
  Convert__regG0__Imm1_1__imm_95_5,
  Convert__Reg1_0__Reg1_2__imm_95_5,
  Convert__Reg1_0__Imm1_2__imm_95_5,
  Convert__Reg1_1__Reg1_3__imm_95_5,
  Convert__Reg1_1__Imm1_3__imm_95_5,
  Convert__regG0__Reg1_0__imm_95_1,
  Convert__regG0__Imm1_0__imm_95_1,
  Convert__regG0__Reg1_1__imm_95_1,
  Convert__regG0__Imm1_1__imm_95_1,
  Convert__Reg1_0__Reg1_2__imm_95_1,
  Convert__Reg1_0__Imm1_2__imm_95_1,
  Convert__Reg1_1__Reg1_3__imm_95_1,
  Convert__Reg1_1__Imm1_3__imm_95_1,
  Convert__regG0__Reg1_0__imm_95_10,
  Convert__regG0__Imm1_0__imm_95_10,
  Convert__regG0__Reg1_1__imm_95_10,
  Convert__regG0__Imm1_1__imm_95_10,
  Convert__Reg1_0__Reg1_2__imm_95_10,
  Convert__Reg1_0__Imm1_2__imm_95_10,
  Convert__Reg1_1__Reg1_3__imm_95_10,
  Convert__Reg1_1__Imm1_3__imm_95_10,
  Convert__regG0__Reg1_0__imm_95_11,
  Convert__regG0__Imm1_0__imm_95_11,
  Convert__regG0__Reg1_1__imm_95_11,
  Convert__regG0__Imm1_1__imm_95_11,
  Convert__Reg1_0__Reg1_2__imm_95_11,
  Convert__Reg1_0__Imm1_2__imm_95_11,
  Convert__Reg1_1__Reg1_3__imm_95_11,
  Convert__Reg1_1__Imm1_3__imm_95_11,
  Convert__regG0__Reg1_0__imm_95_12,
  Convert__regG0__Imm1_0__imm_95_12,
  Convert__regG0__Reg1_1__imm_95_12,
  Convert__regG0__Imm1_1__imm_95_12,
  Convert__Reg1_0__Reg1_2__imm_95_12,
  Convert__Reg1_0__Imm1_2__imm_95_12,
  Convert__Reg1_1__Reg1_3__imm_95_12,
  Convert__Reg1_1__Imm1_3__imm_95_12,
  Convert__regG0__Reg1_0__imm_95_3,
  Convert__regG0__Imm1_0__imm_95_3,
  Convert__regG0__Reg1_1__imm_95_3,
  Convert__regG0__Imm1_1__imm_95_3,
  Convert__Reg1_0__Reg1_2__imm_95_3,
  Convert__Reg1_0__Imm1_2__imm_95_3,
  Convert__Reg1_1__Reg1_3__imm_95_3,
  Convert__Reg1_1__Imm1_3__imm_95_3,
  Convert__regG0__Reg1_0__imm_95_2,
  Convert__regG0__Imm1_0__imm_95_2,
  Convert__regG0__Reg1_1__imm_95_2,
  Convert__regG0__Imm1_1__imm_95_2,
  Convert__Reg1_0__Reg1_2__imm_95_2,
  Convert__Reg1_0__Imm1_2__imm_95_2,
  Convert__Reg1_1__Reg1_3__imm_95_2,
  Convert__Reg1_1__Imm1_3__imm_95_2,
  Convert__regG0__Reg1_0__imm_95_4,
  Convert__regG0__Imm1_0__imm_95_4,
  Convert__regG0__Reg1_1__imm_95_4,
  Convert__regG0__Imm1_1__imm_95_4,
  Convert__Reg1_0__Reg1_2__imm_95_4,
  Convert__Reg1_0__Imm1_2__imm_95_4,
  Convert__Reg1_1__Reg1_3__imm_95_4,
  Convert__Reg1_1__Imm1_3__imm_95_4,
  Convert__regG0__Reg1_0__imm_95_0,
  Convert__regG0__Imm1_0__imm_95_0,
  Convert__regG0__Reg1_1__imm_95_0,
  Convert__regG0__Imm1_1__imm_95_0,
  Convert__Reg1_0__Reg1_2__imm_95_0,
  Convert__Reg1_0__Imm1_2__imm_95_0,
  Convert__Reg1_1__Reg1_3__imm_95_0,
  Convert__Reg1_1__Imm1_3__imm_95_0,
  Convert__regG0__Reg1_0__imm_95_9,
  Convert__regG0__Imm1_0__imm_95_9,
  Convert__regG0__Reg1_1__imm_95_9,
  Convert__regG0__Imm1_1__imm_95_9,
  Convert__Reg1_0__Reg1_2__imm_95_9,
  Convert__Reg1_0__Imm1_2__imm_95_9,
  Convert__Reg1_1__Reg1_3__imm_95_9,
  Convert__Reg1_1__Imm1_3__imm_95_9,
  Convert__regG0__Reg1_0__imm_95_6,
  Convert__regG0__Imm1_0__imm_95_6,
  Convert__regG0__Reg1_1__imm_95_6,
  Convert__regG0__Imm1_1__imm_95_6,
  Convert__Reg1_0__Reg1_2__imm_95_6,
  Convert__Reg1_0__Imm1_2__imm_95_6,
  Convert__Reg1_1__Reg1_3__imm_95_6,
  Convert__Reg1_1__Imm1_3__imm_95_6,
  Convert__regG0__Reg1_0__imm_95_14,
  Convert__regG0__Imm1_0__imm_95_14,
  Convert__regG0__Reg1_1__imm_95_14,
  Convert__regG0__Imm1_1__imm_95_14,
  Convert__Reg1_0__Reg1_2__imm_95_14,
  Convert__Reg1_0__Imm1_2__imm_95_14,
  Convert__Reg1_1__Reg1_3__imm_95_14,
  Convert__Reg1_1__Imm1_3__imm_95_14,
  Convert__regG0__Reg1_0__regG0,
  Convert__regG0__Reg1_0__imm_95_15,
  Convert__regG0__Imm1_0__imm_95_15,
  Convert__regG0__Reg1_1__imm_95_15,
  Convert__regG0__Imm1_1__imm_95_15,
  Convert__Reg1_0__Reg1_2__imm_95_15,
  Convert__Reg1_0__Imm1_2__imm_95_15,
  Convert__Reg1_1__Reg1_3__imm_95_15,
  Convert__Reg1_1__Imm1_3__imm_95_15,
  Convert__regG0__Reg1_0__imm_95_7,
  Convert__regG0__Imm1_0__imm_95_7,
  Convert__regG0__Reg1_1__imm_95_7,
  Convert__regG0__Imm1_1__imm_95_7,
  Convert__Reg1_0__Reg1_2__imm_95_7,
  Convert__Reg1_0__Imm1_2__imm_95_7,
  Convert__Reg1_1__Reg1_3__imm_95_7,
  Convert__Reg1_1__Imm1_3__imm_95_7,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][11] = {
  // Convert__Reg1_2__Reg1_0__Reg1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__TailRelocSymAdd_TLS1_3
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addTailRelocSymOperands, 4, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_0__imm_95_8
  { CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_8
  { CVT_95_addImmOperands, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Imm1_1__Imm1_0
  { CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_8
  { CVT_95_addImmOperands, 3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Imm1_2__Imm1_0
  { CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_3__imm_95_8
  { CVT_95_addImmOperands, 4, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Imm1_3__Imm1_0
  { CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_4__Imm1_0
  { CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_0__imm_95_13
  { CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_13
  { CVT_95_addImmOperands, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_13
  { CVT_95_addImmOperands, 3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_13
  { CVT_95_addImmOperands, 4, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Reg1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Imm1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_0__imm_95_5
  { CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_5
  { CVT_95_addImmOperands, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_5
  { CVT_95_addImmOperands, 3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_5
  { CVT_95_addImmOperands, 4, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_1
  { CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_1
  { CVT_95_addImmOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_1
  { CVT_95_addImmOperands, 4, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_10
  { CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_10
  { CVT_95_addImmOperands, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_10
  { CVT_95_addImmOperands, 3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_10
  { CVT_95_addImmOperands, 4, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_11
  { CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_11
  { CVT_95_addImmOperands, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_11
  { CVT_95_addImmOperands, 3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_11
  { CVT_95_addImmOperands, 4, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_12
  { CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_12
  { CVT_95_addImmOperands, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_12
  { CVT_95_addImmOperands, 3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_12
  { CVT_95_addImmOperands, 4, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_3
  { CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_3
  { CVT_95_addImmOperands, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_3
  { CVT_95_addImmOperands, 3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_3
  { CVT_95_addImmOperands, 4, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_2
  { CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_2
  { CVT_95_addImmOperands, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_2
  { CVT_95_addImmOperands, 3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_4
  { CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_4
  { CVT_95_addImmOperands, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_4
  { CVT_95_addImmOperands, 3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_4
  { CVT_95_addImmOperands, 4, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_0
  { CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_0
  { CVT_95_addImmOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_0
  { CVT_95_addImmOperands, 4, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_9
  { CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_9
  { CVT_95_addImmOperands, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_9
  { CVT_95_addImmOperands, 3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_9
  { CVT_95_addImmOperands, 4, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_6
  { CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_6
  { CVT_95_addImmOperands, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_6
  { CVT_95_addImmOperands, 3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_6
  { CVT_95_addImmOperands, 4, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_14
  { CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_14
  { CVT_95_addImmOperands, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_14
  { CVT_95_addImmOperands, 3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_14
  { CVT_95_addImmOperands, 4, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Imm1_2__Imm1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__Imm1_0__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 1, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_4__Imm1_0__Reg1_3
  { CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 1, CVT_95_Reg, 4, CVT_Done },
  // Convert__Imm1_1__imm_95_1__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_1, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_1__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_1, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_1__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_1, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_7__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_7, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_7__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_7, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_7__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_7, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_6__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_6, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_6__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_6, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_6__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_6, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_2__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_2, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_2__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_2, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_2__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_2, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_3__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_3, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_3__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_3, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_3__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_3, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_5__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_5, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_5__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_5, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_5__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_5, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__regG0__Reg1_1__Reg1_0
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__regG0__Reg1_1__Imm1_0
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_0__imm_95_15
  { CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_15
  { CVT_95_addImmOperands, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_15
  { CVT_95_addImmOperands, 3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_15
  { CVT_95_addImmOperands, 4, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_7
  { CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_7
  { CVT_95_addImmOperands, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_7
  { CVT_95_addImmOperands, 3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_7
  { CVT_95_addImmOperands, 4, CVT_imm_95_7, 0, CVT_Done },
  // Convert__CallTarget1_0
  { CVT_95_addCallTargetOperands, 1, CVT_Done },
  // Convert__regO7__MEMri2_0
  { CVT_regO7, 0, CVT_95_addMEMriOperands, 1, CVT_Done },
  // Convert__regO7__MEMrr2_0
  { CVT_regO7, 0, CVT_95_addMEMrrOperands, 1, CVT_Done },
  // Convert__CallTarget1_0__TailRelocSymCall_TLS1_1
  { CVT_95_addCallTargetOperands, 1, CVT_95_addTailRelocSymOperands, 2, CVT_Done },
  // Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_128
  { CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_5_5, CVT_imm_95_128, 0, CVT_Done },
  // Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1
  { CVT_95_Reg, 6, CVT_95_Reg, 2, CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1__ASITag1_3
  { CVT_95_Reg, 6, CVT_95_Reg, 2, CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_addASITagOperands, 4, CVT_Done },
  // Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_136
  { CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_5_5, CVT_imm_95_136, 0, CVT_Done },
  // Convert__Reg1_0__regG0__regG0
  { CVT_95_Reg, 1, CVT_regG0, 0, CVT_regG0, 0, CVT_Done },
  // Convert__MEMri2_1__regG0
  { CVT_95_addMEMriOperands, 2, CVT_regG0, 0, CVT_Done },
  // Convert__MEMrr2_1__regG0
  { CVT_95_addMEMrrOperands, 2, CVT_regG0, 0, CVT_Done },
  // Convert__Reg1_0
  { CVT_95_Reg, 1, CVT_Done },
  // Convert__regG0__Reg1_0__Reg1_1
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__regG0__Reg1_0__Imm1_1
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert_NoOperands
  { CVT_Done },
  // Convert__Reg1_1__Reg1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_1__imm_95_8__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_8, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_8__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_8, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_8__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_8, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_9__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_9, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_9__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_9, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_9__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_9, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_11__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_11, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_11__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_11, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_11__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_11, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_4__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_4, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_4__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_4, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_4__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_4, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_13__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_13, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_13__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_13, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_13__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_13, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_0__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_0, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_0, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_0__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_0, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_15__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_15, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_15__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_15, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_15__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_15, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_10__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_10, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_10__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_10, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_10__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_10, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_12__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_12, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_12__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_12, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_12__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_12, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_14__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_14, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_14__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_14, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_14__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_14, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__regFCC0__Reg1_0__Reg1_1
  { CVT_regFCC0, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__MEMri2_0
  { CVT_95_addMEMriOperands, 1, CVT_Done },
  // Convert__MEMrr2_0
  { CVT_95_addMEMrrOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_11
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_4
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_13
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_15
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_10
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_12
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_14
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__regG0__MEMri2_0
  { CVT_regG0, 0, CVT_95_addMEMriOperands, 1, CVT_Done },
  // Convert__regG0__MEMrr2_0
  { CVT_regG0, 0, CVT_95_addMEMrrOperands, 1, CVT_Done },
  // Convert__Reg1_1__MEMri2_0
  { CVT_95_Reg, 2, CVT_95_addMEMriOperands, 1, CVT_Done },
  // Convert__Reg1_1__MEMrr2_0
  { CVT_95_Reg, 2, CVT_95_addMEMrrOperands, 1, CVT_Done },
  // Convert__MEMri2_1
  { CVT_95_addMEMriOperands, 2, CVT_Done },
  // Convert__Reg1_3__MEMri2_1
  { CVT_95_Reg, 4, CVT_95_addMEMriOperands, 2, CVT_Done },
  // Convert__MEMrr2_1
  { CVT_95_addMEMrrOperands, 2, CVT_Done },
  // Convert__Reg1_3__MEMrr2_1
  { CVT_95_Reg, 4, CVT_95_addMEMrrOperands, 2, CVT_Done },
  // Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_GOT1_4
  { CVT_95_Reg, 4, CVT_95_addMEMrrOperands, 2, CVT_95_addTailRelocSymOperands, 5, CVT_Done },
  // Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_TLS1_4
  { CVT_95_Reg, 4, CVT_95_addMEMrrOperands, 2, CVT_95_addTailRelocSymOperands, 5, CVT_Done },
  // Convert__Reg1_4__MEMri2_1
  { CVT_95_Reg, 5, CVT_95_addMEMriOperands, 2, CVT_Done },
  // Convert__Reg1_4__MEMrr2_1__ASITag1_3
  { CVT_95_Reg, 5, CVT_95_addMEMrrOperands, 2, CVT_95_addASITagOperands, 4, CVT_Done },
  // Convert__MembarTag1_0
  { CVT_95_addMembarTagOperands, 1, CVT_Done },
  // Convert__Reg1_1
  { CVT_95_Reg, 2, CVT_Done },
  // Convert__regG0__Reg1_0
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__regG0__Reg1_0
  { CVT_95_Reg, 2, CVT_regG0, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__regG0__Imm1_0
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__regG0__Imm1_0
  { CVT_95_Reg, 2, CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_8
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_8
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_3__Imm1_2__Tie0_1_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_addImmOperands, 3, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_1__Imm1_2__Tie0_1_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_13
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_5
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_9
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_10
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_6
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_11
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_11
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_12
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_4
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_2
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_13
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_4
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_2
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_9
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_6
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_15
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_14
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_7
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_3
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_5
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_10
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_12
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_14
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_15
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_7
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__regG0__Reg1_0
  { CVT_95_Reg, 1, CVT_regG0, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_0__regG0
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_regG0, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__regG0
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_regG0, 0, CVT_Done },
  // Convert__MEMri2_1__PrefetchTag1_3
  { CVT_95_addMEMriOperands, 2, CVT_95_addPrefetchTagOperands, 4, CVT_Done },
  // Convert__MEMrr2_1__PrefetchTag1_3
  { CVT_95_addMEMrrOperands, 2, CVT_95_addPrefetchTagOperands, 4, CVT_Done },
  // Convert__MEMri2_1__PrefetchTag1_4
  { CVT_95_addMEMriOperands, 2, CVT_95_addPrefetchTagOperands, 5, CVT_Done },
  // Convert__MEMrr2_1__ASITag1_3__PrefetchTag1_4
  { CVT_95_addMEMrrOperands, 2, CVT_95_addASITagOperands, 4, CVT_95_addPrefetchTagOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Imm1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regG0__regG0__regG0
  { CVT_regG0, 0, CVT_regG0, 0, CVT_regG0, 0, CVT_Done },
  // Convert__imm_95_8
  { CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Imm1_0__Reg1_1
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__imm_95_0
  { CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__ShiftAmtImm51_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addShiftAmtImm5Operands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_0__ShiftAmtImm61_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addShiftAmtImm6Operands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__MEMri2_2
  { CVT_95_addMEMriOperands, 3, CVT_Done },
  // Convert__MEMrr2_2
  { CVT_95_addMEMrrOperands, 3, CVT_Done },
  // Convert__MEMri2_2__Reg1_0
  { CVT_95_addMEMriOperands, 3, CVT_95_Reg, 1, CVT_Done },
  // Convert__MEMrr2_2__Reg1_0
  { CVT_95_addMEMrrOperands, 3, CVT_95_Reg, 1, CVT_Done },
  // Convert__MEMrr2_2__Reg1_0__ASITag1_4
  { CVT_95_addMEMrrOperands, 3, CVT_95_Reg, 1, CVT_95_addASITagOperands, 5, CVT_Done },
  // Convert__Reg1_3__MEMri2_1__Tie0_1_1
  { CVT_95_Reg, 4, CVT_95_addMEMriOperands, 2, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__Reg1_3__MEMrr2_1__Tie0_1_1
  { CVT_95_Reg, 4, CVT_95_addMEMrrOperands, 2, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__Reg1_4__MEMri2_1__Tie0_1_1
  { CVT_95_Reg, 5, CVT_95_addMEMriOperands, 2, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__Reg1_4__MEMrr2_1__ASITag1_3__Tie0_1_1
  { CVT_95_Reg, 5, CVT_95_addMEMrrOperands, 2, CVT_95_addASITagOperands, 4, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_8
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_8
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_8
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_8
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_8
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_8
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_8
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Imm1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm1_3__Imm1_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Imm1_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_13
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_13
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_13
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_13
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_13
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_13
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_13
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_13
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_13, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_5
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_5
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_5
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_5
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_5
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_5
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_5
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_5, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_1
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_1
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_1
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_1
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_1
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_1
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_1, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_10
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_10
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_10
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_10
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_10
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_10
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_10
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_10
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_10, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_11
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_11
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_11
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_11
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_11
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_11
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_11
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_11
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_11, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_12
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_12
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_12
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_12
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_12
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_12
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_12
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_12
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_12, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_3
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_3
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_3
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_3
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_3
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_3
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_3, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_2
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_2
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_2
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_2
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_2
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_2
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_2
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_2, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_4
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_4
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_4
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_4
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_4
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_4
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_4
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_4, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_0
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_0
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_0
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_0
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_9
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_9
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_9
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_9
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_9
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_9
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_9
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_9
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_9, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_6
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_6
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_6
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_6
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_6
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_6
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_6
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_6, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_14
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_14
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_14
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_14
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_14
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_14
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_14
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_14
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_14, 0, CVT_Done },
  // Convert__regG0__Reg1_0__regG0
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_regG0, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_15
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_15
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_15
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_15
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_15
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_15
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_15
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_15
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_15, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_7
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_7
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_7
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_7
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_7
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_7
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_7
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_7, 0, CVT_Done },
};

void SparcAsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p += 2) {
    unsigned OpIdx = *(p + 1);
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied: {
      assert(*(p + 1) < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned TiedResOpnd = TiedAsmOperandTable[*(p + 1)][0];
      if (TiedResOpnd != (uint8_t)-1)
        Inst.addOperand(Inst.getOperand(TiedResOpnd));
      break;
    }
    case CVT_95_Reg:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_95_addImmOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addImmOperands(Inst, 1);
      break;
    case CVT_95_addTailRelocSymOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addTailRelocSymOperands(Inst, 1);
      break;
    case CVT_imm_95_8:
      Inst.addOperand(MCOperand::createImm(8));
      break;
    case CVT_imm_95_13:
      Inst.addOperand(MCOperand::createImm(13));
      break;
    case CVT_imm_95_5:
      Inst.addOperand(MCOperand::createImm(5));
      break;
    case CVT_imm_95_1:
      Inst.addOperand(MCOperand::createImm(1));
      break;
    case CVT_imm_95_10:
      Inst.addOperand(MCOperand::createImm(10));
      break;
    case CVT_imm_95_11:
      Inst.addOperand(MCOperand::createImm(11));
      break;
    case CVT_imm_95_12:
      Inst.addOperand(MCOperand::createImm(12));
      break;
    case CVT_imm_95_3:
      Inst.addOperand(MCOperand::createImm(3));
      break;
    case CVT_imm_95_2:
      Inst.addOperand(MCOperand::createImm(2));
      break;
    case CVT_imm_95_4:
      Inst.addOperand(MCOperand::createImm(4));
      break;
    case CVT_imm_95_0:
      Inst.addOperand(MCOperand::createImm(0));
      break;
    case CVT_imm_95_9:
      Inst.addOperand(MCOperand::createImm(9));
      break;
    case CVT_imm_95_6:
      Inst.addOperand(MCOperand::createImm(6));
      break;
    case CVT_imm_95_14:
      Inst.addOperand(MCOperand::createImm(14));
      break;
    case CVT_imm_95_7:
      Inst.addOperand(MCOperand::createImm(7));
      break;
    case CVT_regG0:
      Inst.addOperand(MCOperand::createReg(SP::G0));
      break;
    case CVT_imm_95_15:
      Inst.addOperand(MCOperand::createImm(15));
      break;
    case CVT_95_addCallTargetOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addCallTargetOperands(Inst, 1);
      break;
    case CVT_regO7:
      Inst.addOperand(MCOperand::createReg(SP::O7));
      break;
    case CVT_95_addMEMriOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addMEMriOperands(Inst, 2);
      break;
    case CVT_95_addMEMrrOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addMEMrrOperands(Inst, 2);
      break;
    case CVT_imm_95_128:
      Inst.addOperand(MCOperand::createImm(128));
      break;
    case CVT_95_addASITagOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addASITagOperands(Inst, 1);
      break;
    case CVT_imm_95_136:
      Inst.addOperand(MCOperand::createImm(136));
      break;
    case CVT_regFCC0:
      Inst.addOperand(MCOperand::createReg(SP::FCC0));
      break;
    case CVT_95_addMembarTagOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addMembarTagOperands(Inst, 1);
      break;
    case CVT_95_addPrefetchTagOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addPrefetchTagOperands(Inst, 1);
      break;
    case CVT_95_addShiftAmtImm5Operands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addShiftAmtImm5Operands(Inst, 1);
      break;
    case CVT_95_addShiftAmtImm6Operands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addShiftAmtImm6Operands(Inst, 1);
      break;
    }
  }
}

void SparcAsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_95_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      NumMCOperands += 1;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addTailRelocSymOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_8:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_13:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_5:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_10:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_11:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_12:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_2:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_4:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_9:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_6:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_14:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_7:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_regG0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_imm_95_15:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addCallTargetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_regO7:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addMEMriOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMEMrrOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_imm_95_128:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addASITagOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_136:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_regFCC0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addMembarTagOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addPrefetchTagOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addShiftAmtImm5Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addShiftAmtImm6Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  OptionalMatchClass = 1,
  MCK__PCT_asi, // '%asi'
  MCK__PCT_xcc, // '%xcc'
  MCK__43_, // '+'
  MCK_1, // '1'
  MCK_3, // '3'
  MCK_5, // '5'
  MCK__91_, // '['
  MCK__93_, // ']'
  MCK_a, // 'a'
  MCK_pn, // 'pn'
  MCK_pt, // 'pt'
  MCK_LAST_TOKEN = MCK_pt,
  MCK_Reg12, // derived register class
  MCK_CPQ, // register class 'CPQ'
  MCK_CPSR, // register class 'CPSR'
  MCK_FCC0, // register class 'FCC0'
  MCK_FQ, // register class 'FQ'
  MCK_FSR, // register class 'FSR'
  MCK_G0, // register class 'G0'
  MCK_ICC, // register class 'ICC'
  MCK_PSR, // register class 'PSR'
  MCK_TBR, // register class 'TBR'
  MCK_WIM, // register class 'WIM'
  MCK_Reg25, // derived register class
  MCK_Reg24, // derived register class
  MCK_FCCRegs, // register class 'FCCRegs'
  MCK_GPRIncomingArg, // register class 'GPRIncomingArg'
  MCK_GPROutgoingArg, // register class 'GPROutgoingArg'
  MCK_LowQFPRegs, // register class 'LowQFPRegs'
  MCK_CoprocPair, // register class 'CoprocPair'
  MCK_IntPair, // register class 'IntPair'
  MCK_LowDFPRegs, // register class 'LowDFPRegs'
  MCK_QFPRegs, // register class 'QFPRegs'
  MCK_PRRegs, // register class 'PRRegs'
  MCK_CoprocRegs, // register class 'CoprocRegs'
  MCK_DFPRegs, // register class 'DFPRegs'
  MCK_FPRegs, // register class 'FPRegs'
  MCK_IntRegs, // register class 'IntRegs,I64Regs'
  MCK_ASRRegs, // register class 'ASRRegs'
  MCK_LAST_REGISTER = MCK_ASRRegs,
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_ASITag, // user defined class 'SparcASITagAsmOperand'
  MCK_CallTarget, // user defined class 'SparcCallTargetAsmOperand'
  MCK_MEMri, // user defined class 'SparcMEMriAsmOperand'
  MCK_MEMrr, // user defined class 'SparcMEMrrAsmOperand'
  MCK_MembarTag, // user defined class 'SparcMembarTagAsmOperand'
  MCK_PrefetchTag, // user defined class 'SparcPrefetchTagAsmOperand'
  MCK_ShiftAmtImm5, // user defined class 'anonymous_8113'
  MCK_ShiftAmtImm6, // user defined class 'anonymous_8114'
  MCK_TailRelocSymLoad_GOT, // user defined class 'anonymous_8115'
  MCK_TailRelocSymAdd_TLS, // user defined class 'anonymous_8116'
  MCK_TailRelocSymLoad_TLS, // user defined class 'anonymous_8117'
  MCK_TailRelocSymCall_TLS, // user defined class 'anonymous_8118'
  NumMatchClassKinds
};

} // end anonymous namespace

static unsigned getDiagKindFromRegisterClass(MatchClassKind RegisterClass) {
  return MCTargetAsmParser::Match_InvalidOperand;
}

static MatchClassKind matchTokenString(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 7 strings to match.
    switch (Name[0]) {
    default: break;
    case '+':	 // 1 string to match.
      return MCK__43_;	 // "+"
    case '1':	 // 1 string to match.
      return MCK_1;	 // "1"
    case '3':	 // 1 string to match.
      return MCK_3;	 // "3"
    case '5':	 // 1 string to match.
      return MCK_5;	 // "5"
    case '[':	 // 1 string to match.
      return MCK__91_;	 // "["
    case ']':	 // 1 string to match.
      return MCK__93_;	 // "]"
    case 'a':	 // 1 string to match.
      return MCK_a;	 // "a"
    }
    break;
  case 2:	 // 2 strings to match.
    if (Name[0] != 'p')
      break;
    switch (Name[1]) {
    default: break;
    case 'n':	 // 1 string to match.
      return MCK_pn;	 // "pn"
    case 't':	 // 1 string to match.
      return MCK_pt;	 // "pt"
    }
    break;
  case 4:	 // 2 strings to match.
    if (Name[0] != '%')
      break;
    switch (Name[1]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+2, "si", 2) != 0)
        break;
      return MCK__PCT_asi;	 // "%asi"
    case 'x':	 // 1 string to match.
      if (memcmp(Name.data()+2, "cc", 2) != 0)
        break;
      return MCK__PCT_xcc;	 // "%xcc"
    }
    break;
  }
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  switch (A) {
  default:
    return false;

  case MCK_Reg12:
    switch (B) {
    default: return false;
    case MCK_PRRegs: return true;
    case MCK_ASRRegs: return true;
    }

  case MCK_FCC0:
    return B == MCK_FCCRegs;

  case MCK_G0:
    return B == MCK_IntRegs;

  case MCK_Reg25:
    return B == MCK_IntPair;

  case MCK_Reg24:
    return B == MCK_IntPair;

  case MCK_GPRIncomingArg:
    return B == MCK_IntRegs;

  case MCK_GPROutgoingArg:
    return B == MCK_IntRegs;

  case MCK_LowQFPRegs:
    return B == MCK_QFPRegs;

  case MCK_LowDFPRegs:
    return B == MCK_DFPRegs;
  }
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  SparcOperand &Operand = (SparcOperand &)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken() && Kind <= MCK_LAST_TOKEN)
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  switch (Kind) {
  default: break;
  // 'Imm' class
  case MCK_Imm: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ASITag' class
  case MCK_ASITag: {
    DiagnosticPredicate DP(Operand.isASITag());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'CallTarget' class
  case MCK_CallTarget: {
    DiagnosticPredicate DP(Operand.isCallTarget());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MEMri' class
  case MCK_MEMri: {
    DiagnosticPredicate DP(Operand.isMEMri());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MEMrr' class
  case MCK_MEMrr: {
    DiagnosticPredicate DP(Operand.isMEMrr());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MembarTag' class
  case MCK_MembarTag: {
    DiagnosticPredicate DP(Operand.isMembarTag());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'PrefetchTag' class
  case MCK_PrefetchTag: {
    DiagnosticPredicate DP(Operand.isPrefetchTag());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ShiftAmtImm5' class
  case MCK_ShiftAmtImm5: {
    DiagnosticPredicate DP(Operand.isShiftAmtImm5());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ShiftAmtImm6' class
  case MCK_ShiftAmtImm6: {
    DiagnosticPredicate DP(Operand.isShiftAmtImm6());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'TailRelocSymLoad_GOT' class
  case MCK_TailRelocSymLoad_GOT: {
    DiagnosticPredicate DP(Operand.isTailRelocSym());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'TailRelocSymAdd_TLS' class
  case MCK_TailRelocSymAdd_TLS: {
    DiagnosticPredicate DP(Operand.isTailRelocSym());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'TailRelocSymLoad_TLS' class
  case MCK_TailRelocSymLoad_TLS: {
    DiagnosticPredicate DP(Operand.isTailRelocSym());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'TailRelocSymCall_TLS' class
  case MCK_TailRelocSymCall_TLS: {
    DiagnosticPredicate DP(Operand.isTailRelocSym());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  } // end switch (Kind)

  if (Operand.isReg()) {
    MatchClassKind OpKind;
    switch (Operand.getReg().id()) {
    default: OpKind = InvalidMatchClass; break;
    case SP::ICC: OpKind = MCK_ICC; break;
    case SP::FCC0: OpKind = MCK_FCC0; break;
    case SP::FCC1: OpKind = MCK_FCCRegs; break;
    case SP::FCC2: OpKind = MCK_FCCRegs; break;
    case SP::FCC3: OpKind = MCK_FCCRegs; break;
    case SP::FSR: OpKind = MCK_FSR; break;
    case SP::FQ: OpKind = MCK_FQ; break;
    case SP::CPSR: OpKind = MCK_CPSR; break;
    case SP::CPQ: OpKind = MCK_CPQ; break;
    case SP::Y: OpKind = MCK_ASRRegs; break;
    case SP::ASR1: OpKind = MCK_ASRRegs; break;
    case SP::ASR2: OpKind = MCK_ASRRegs; break;
    case SP::ASR3: OpKind = MCK_ASRRegs; break;
    case SP::ASR4: OpKind = MCK_ASRRegs; break;
    case SP::ASR5: OpKind = MCK_ASRRegs; break;
    case SP::ASR6: OpKind = MCK_ASRRegs; break;
    case SP::ASR7: OpKind = MCK_ASRRegs; break;
    case SP::ASR8: OpKind = MCK_ASRRegs; break;
    case SP::ASR9: OpKind = MCK_ASRRegs; break;
    case SP::ASR10: OpKind = MCK_ASRRegs; break;
    case SP::ASR11: OpKind = MCK_ASRRegs; break;
    case SP::ASR12: OpKind = MCK_ASRRegs; break;
    case SP::ASR13: OpKind = MCK_ASRRegs; break;
    case SP::ASR14: OpKind = MCK_ASRRegs; break;
    case SP::ASR15: OpKind = MCK_ASRRegs; break;
    case SP::ASR16: OpKind = MCK_ASRRegs; break;
    case SP::ASR17: OpKind = MCK_ASRRegs; break;
    case SP::ASR18: OpKind = MCK_ASRRegs; break;
    case SP::ASR19: OpKind = MCK_ASRRegs; break;
    case SP::ASR20: OpKind = MCK_ASRRegs; break;
    case SP::ASR21: OpKind = MCK_ASRRegs; break;
    case SP::ASR22: OpKind = MCK_ASRRegs; break;
    case SP::ASR23: OpKind = MCK_ASRRegs; break;
    case SP::ASR24: OpKind = MCK_ASRRegs; break;
    case SP::ASR25: OpKind = MCK_ASRRegs; break;
    case SP::ASR26: OpKind = MCK_ASRRegs; break;
    case SP::ASR27: OpKind = MCK_ASRRegs; break;
    case SP::ASR28: OpKind = MCK_ASRRegs; break;
    case SP::ASR29: OpKind = MCK_ASRRegs; break;
    case SP::ASR30: OpKind = MCK_ASRRegs; break;
    case SP::ASR31: OpKind = MCK_ASRRegs; break;
    case SP::PSR: OpKind = MCK_PSR; break;
    case SP::WIM: OpKind = MCK_WIM; break;
    case SP::TBR: OpKind = MCK_TBR; break;
    case SP::TPC: OpKind = MCK_PRRegs; break;
    case SP::TNPC: OpKind = MCK_PRRegs; break;
    case SP::TSTATE: OpKind = MCK_PRRegs; break;
    case SP::TT: OpKind = MCK_PRRegs; break;
    case SP::TICK: OpKind = MCK_Reg12; break;
    case SP::TBA: OpKind = MCK_PRRegs; break;
    case SP::PSTATE: OpKind = MCK_PRRegs; break;
    case SP::TL: OpKind = MCK_PRRegs; break;
    case SP::PIL: OpKind = MCK_PRRegs; break;
    case SP::CWP: OpKind = MCK_PRRegs; break;
    case SP::CANSAVE: OpKind = MCK_PRRegs; break;
    case SP::CANRESTORE: OpKind = MCK_PRRegs; break;
    case SP::CLEANWIN: OpKind = MCK_PRRegs; break;
    case SP::OTHERWIN: OpKind = MCK_PRRegs; break;
    case SP::WSTATE: OpKind = MCK_PRRegs; break;
    case SP::GL: OpKind = MCK_PRRegs; break;
    case SP::VER: OpKind = MCK_PRRegs; break;
    case SP::G0: OpKind = MCK_G0; break;
    case SP::G1: OpKind = MCK_IntRegs; break;
    case SP::G2: OpKind = MCK_IntRegs; break;
    case SP::G3: OpKind = MCK_IntRegs; break;
    case SP::G4: OpKind = MCK_IntRegs; break;
    case SP::G5: OpKind = MCK_IntRegs; break;
    case SP::G6: OpKind = MCK_IntRegs; break;
    case SP::G7: OpKind = MCK_IntRegs; break;
    case SP::O0: OpKind = MCK_GPROutgoingArg; break;
    case SP::O1: OpKind = MCK_GPROutgoingArg; break;
    case SP::O2: OpKind = MCK_GPROutgoingArg; break;
    case SP::O3: OpKind = MCK_GPROutgoingArg; break;
    case SP::O4: OpKind = MCK_GPROutgoingArg; break;
    case SP::O5: OpKind = MCK_GPROutgoingArg; break;
    case SP::O6: OpKind = MCK_IntRegs; break;
    case SP::O7: OpKind = MCK_IntRegs; break;
    case SP::L0: OpKind = MCK_IntRegs; break;
    case SP::L1: OpKind = MCK_IntRegs; break;
    case SP::L2: OpKind = MCK_IntRegs; break;
    case SP::L3: OpKind = MCK_IntRegs; break;
    case SP::L4: OpKind = MCK_IntRegs; break;
    case SP::L5: OpKind = MCK_IntRegs; break;
    case SP::L6: OpKind = MCK_IntRegs; break;
    case SP::L7: OpKind = MCK_IntRegs; break;
    case SP::I0: OpKind = MCK_GPRIncomingArg; break;
    case SP::I1: OpKind = MCK_GPRIncomingArg; break;
    case SP::I2: OpKind = MCK_GPRIncomingArg; break;
    case SP::I3: OpKind = MCK_GPRIncomingArg; break;
    case SP::I4: OpKind = MCK_GPRIncomingArg; break;
    case SP::I5: OpKind = MCK_GPRIncomingArg; break;
    case SP::I6: OpKind = MCK_IntRegs; break;
    case SP::I7: OpKind = MCK_IntRegs; break;
    case SP::F0: OpKind = MCK_FPRegs; break;
    case SP::F1: OpKind = MCK_FPRegs; break;
    case SP::F2: OpKind = MCK_FPRegs; break;
    case SP::F3: OpKind = MCK_FPRegs; break;
    case SP::F4: OpKind = MCK_FPRegs; break;
    case SP::F5: OpKind = MCK_FPRegs; break;
    case SP::F6: OpKind = MCK_FPRegs; break;
    case SP::F7: OpKind = MCK_FPRegs; break;
    case SP::F8: OpKind = MCK_FPRegs; break;
    case SP::F9: OpKind = MCK_FPRegs; break;
    case SP::F10: OpKind = MCK_FPRegs; break;
    case SP::F11: OpKind = MCK_FPRegs; break;
    case SP::F12: OpKind = MCK_FPRegs; break;
    case SP::F13: OpKind = MCK_FPRegs; break;
    case SP::F14: OpKind = MCK_FPRegs; break;
    case SP::F15: OpKind = MCK_FPRegs; break;
    case SP::F16: OpKind = MCK_FPRegs; break;
    case SP::F17: OpKind = MCK_FPRegs; break;
    case SP::F18: OpKind = MCK_FPRegs; break;
    case SP::F19: OpKind = MCK_FPRegs; break;
    case SP::F20: OpKind = MCK_FPRegs; break;
    case SP::F21: OpKind = MCK_FPRegs; break;
    case SP::F22: OpKind = MCK_FPRegs; break;
    case SP::F23: OpKind = MCK_FPRegs; break;
    case SP::F24: OpKind = MCK_FPRegs; break;
    case SP::F25: OpKind = MCK_FPRegs; break;
    case SP::F26: OpKind = MCK_FPRegs; break;
    case SP::F27: OpKind = MCK_FPRegs; break;
    case SP::F28: OpKind = MCK_FPRegs; break;
    case SP::F29: OpKind = MCK_FPRegs; break;
    case SP::F30: OpKind = MCK_FPRegs; break;
    case SP::F31: OpKind = MCK_FPRegs; break;
    case SP::D0: OpKind = MCK_LowDFPRegs; break;
    case SP::D1: OpKind = MCK_LowDFPRegs; break;
    case SP::D2: OpKind = MCK_LowDFPRegs; break;
    case SP::D3: OpKind = MCK_LowDFPRegs; break;
    case SP::D4: OpKind = MCK_LowDFPRegs; break;
    case SP::D5: OpKind = MCK_LowDFPRegs; break;
    case SP::D6: OpKind = MCK_LowDFPRegs; break;
    case SP::D7: OpKind = MCK_LowDFPRegs; break;
    case SP::D8: OpKind = MCK_LowDFPRegs; break;
    case SP::D9: OpKind = MCK_LowDFPRegs; break;
    case SP::D10: OpKind = MCK_LowDFPRegs; break;
    case SP::D11: OpKind = MCK_LowDFPRegs; break;
    case SP::D12: OpKind = MCK_LowDFPRegs; break;
    case SP::D13: OpKind = MCK_LowDFPRegs; break;
    case SP::D14: OpKind = MCK_LowDFPRegs; break;
    case SP::D15: OpKind = MCK_LowDFPRegs; break;
    case SP::C0: OpKind = MCK_CoprocRegs; break;
    case SP::C1: OpKind = MCK_CoprocRegs; break;
    case SP::C2: OpKind = MCK_CoprocRegs; break;
    case SP::C3: OpKind = MCK_CoprocRegs; break;
    case SP::C4: OpKind = MCK_CoprocRegs; break;
    case SP::C5: OpKind = MCK_CoprocRegs; break;
    case SP::C6: OpKind = MCK_CoprocRegs; break;
    case SP::C7: OpKind = MCK_CoprocRegs; break;
    case SP::C8: OpKind = MCK_CoprocRegs; break;
    case SP::C9: OpKind = MCK_CoprocRegs; break;
    case SP::C10: OpKind = MCK_CoprocRegs; break;
    case SP::C11: OpKind = MCK_CoprocRegs; break;
    case SP::C12: OpKind = MCK_CoprocRegs; break;
    case SP::C13: OpKind = MCK_CoprocRegs; break;
    case SP::C14: OpKind = MCK_CoprocRegs; break;
    case SP::C15: OpKind = MCK_CoprocRegs; break;
    case SP::C16: OpKind = MCK_CoprocRegs; break;
    case SP::C17: OpKind = MCK_CoprocRegs; break;
    case SP::C18: OpKind = MCK_CoprocRegs; break;
    case SP::C19: OpKind = MCK_CoprocRegs; break;
    case SP::C20: OpKind = MCK_CoprocRegs; break;
    case SP::C21: OpKind = MCK_CoprocRegs; break;
    case SP::C22: OpKind = MCK_CoprocRegs; break;
    case SP::C23: OpKind = MCK_CoprocRegs; break;
    case SP::C24: OpKind = MCK_CoprocRegs; break;
    case SP::C25: OpKind = MCK_CoprocRegs; break;
    case SP::C26: OpKind = MCK_CoprocRegs; break;
    case SP::C27: OpKind = MCK_CoprocRegs; break;
    case SP::C28: OpKind = MCK_CoprocRegs; break;
    case SP::C29: OpKind = MCK_CoprocRegs; break;
    case SP::C30: OpKind = MCK_CoprocRegs; break;
    case SP::C31: OpKind = MCK_CoprocRegs; break;
    case SP::D16: OpKind = MCK_DFPRegs; break;
    case SP::D17: OpKind = MCK_DFPRegs; break;
    case SP::D18: OpKind = MCK_DFPRegs; break;
    case SP::D19: OpKind = MCK_DFPRegs; break;
    case SP::D20: OpKind = MCK_DFPRegs; break;
    case SP::D21: OpKind = MCK_DFPRegs; break;
    case SP::D22: OpKind = MCK_DFPRegs; break;
    case SP::D23: OpKind = MCK_DFPRegs; break;
    case SP::D24: OpKind = MCK_DFPRegs; break;
    case SP::D25: OpKind = MCK_DFPRegs; break;
    case SP::D26: OpKind = MCK_DFPRegs; break;
    case SP::D27: OpKind = MCK_DFPRegs; break;
    case SP::D28: OpKind = MCK_DFPRegs; break;
    case SP::D29: OpKind = MCK_DFPRegs; break;
    case SP::D30: OpKind = MCK_DFPRegs; break;
    case SP::D31: OpKind = MCK_DFPRegs; break;
    case SP::Q0: OpKind = MCK_LowQFPRegs; break;
    case SP::Q1: OpKind = MCK_LowQFPRegs; break;
    case SP::Q2: OpKind = MCK_LowQFPRegs; break;
    case SP::Q3: OpKind = MCK_LowQFPRegs; break;
    case SP::Q4: OpKind = MCK_LowQFPRegs; break;
    case SP::Q5: OpKind = MCK_LowQFPRegs; break;
    case SP::Q6: OpKind = MCK_LowQFPRegs; break;
    case SP::Q7: OpKind = MCK_LowQFPRegs; break;
    case SP::Q8: OpKind = MCK_QFPRegs; break;
    case SP::Q9: OpKind = MCK_QFPRegs; break;
    case SP::Q10: OpKind = MCK_QFPRegs; break;
    case SP::Q11: OpKind = MCK_QFPRegs; break;
    case SP::Q12: OpKind = MCK_QFPRegs; break;
    case SP::Q13: OpKind = MCK_QFPRegs; break;
    case SP::Q14: OpKind = MCK_QFPRegs; break;
    case SP::Q15: OpKind = MCK_QFPRegs; break;
    case SP::G0_G1: OpKind = MCK_IntPair; break;
    case SP::G2_G3: OpKind = MCK_IntPair; break;
    case SP::G4_G5: OpKind = MCK_IntPair; break;
    case SP::G6_G7: OpKind = MCK_IntPair; break;
    case SP::O0_O1: OpKind = MCK_Reg24; break;
    case SP::O2_O3: OpKind = MCK_Reg24; break;
    case SP::O4_O5: OpKind = MCK_Reg24; break;
    case SP::O6_O7: OpKind = MCK_IntPair; break;
    case SP::L0_L1: OpKind = MCK_IntPair; break;
    case SP::L2_L3: OpKind = MCK_IntPair; break;
    case SP::L4_L5: OpKind = MCK_IntPair; break;
    case SP::L6_L7: OpKind = MCK_IntPair; break;
    case SP::I0_I1: OpKind = MCK_Reg25; break;
    case SP::I2_I3: OpKind = MCK_Reg25; break;
    case SP::I4_I5: OpKind = MCK_Reg25; break;
    case SP::I6_I7: OpKind = MCK_IntPair; break;
    case SP::C0_C1: OpKind = MCK_CoprocPair; break;
    case SP::C2_C3: OpKind = MCK_CoprocPair; break;
    case SP::C4_C5: OpKind = MCK_CoprocPair; break;
    case SP::C6_C7: OpKind = MCK_CoprocPair; break;
    case SP::C8_C9: OpKind = MCK_CoprocPair; break;
    case SP::C10_C11: OpKind = MCK_CoprocPair; break;
    case SP::C12_C13: OpKind = MCK_CoprocPair; break;
    case SP::C14_C15: OpKind = MCK_CoprocPair; break;
    case SP::C16_C17: OpKind = MCK_CoprocPair; break;
    case SP::C18_C19: OpKind = MCK_CoprocPair; break;
    case SP::C20_C21: OpKind = MCK_CoprocPair; break;
    case SP::C22_C23: OpKind = MCK_CoprocPair; break;
    case SP::C24_C25: OpKind = MCK_CoprocPair; break;
    case SP::C26_C27: OpKind = MCK_CoprocPair; break;
    case SP::C28_C29: OpKind = MCK_CoprocPair; break;
    case SP::C30_C31: OpKind = MCK_CoprocPair; break;
    }
    return isSubclass(OpKind, Kind) ? (unsigned)MCTargetAsmParser::Match_Success :
                                      getDiagKindFromRegisterClass(Kind);
  }

  if (Kind > MCK_LAST_TOKEN && Kind <= MCK_LAST_REGISTER)
    return getDiagKindFromRegisterClass(Kind);

  return MCTargetAsmParser::Match_InvalidOperand;
}

#ifndef NDEBUG
const char *getMatchClassName(MatchClassKind Kind) {
  switch (Kind) {
  case InvalidMatchClass: return "InvalidMatchClass";
  case OptionalMatchClass: return "OptionalMatchClass";
  case MCK__PCT_asi: return "MCK__PCT_asi";
  case MCK__PCT_xcc: return "MCK__PCT_xcc";
  case MCK__43_: return "MCK__43_";
  case MCK_1: return "MCK_1";
  case MCK_3: return "MCK_3";
  case MCK_5: return "MCK_5";
  case MCK__91_: return "MCK__91_";
  case MCK__93_: return "MCK__93_";
  case MCK_a: return "MCK_a";
  case MCK_pn: return "MCK_pn";
  case MCK_pt: return "MCK_pt";
  case MCK_Reg12: return "MCK_Reg12";
  case MCK_CPQ: return "MCK_CPQ";
  case MCK_CPSR: return "MCK_CPSR";
  case MCK_FCC0: return "MCK_FCC0";
  case MCK_FQ: return "MCK_FQ";
  case MCK_FSR: return "MCK_FSR";
  case MCK_G0: return "MCK_G0";
  case MCK_ICC: return "MCK_ICC";
  case MCK_PSR: return "MCK_PSR";
  case MCK_TBR: return "MCK_TBR";
  case MCK_WIM: return "MCK_WIM";
  case MCK_Reg25: return "MCK_Reg25";
  case MCK_Reg24: return "MCK_Reg24";
  case MCK_FCCRegs: return "MCK_FCCRegs";
  case MCK_GPRIncomingArg: return "MCK_GPRIncomingArg";
  case MCK_GPROutgoingArg: return "MCK_GPROutgoingArg";
  case MCK_LowQFPRegs: return "MCK_LowQFPRegs";
  case MCK_CoprocPair: return "MCK_CoprocPair";
  case MCK_IntPair: return "MCK_IntPair";
  case MCK_LowDFPRegs: return "MCK_LowDFPRegs";
  case MCK_QFPRegs: return "MCK_QFPRegs";
  case MCK_PRRegs: return "MCK_PRRegs";
  case MCK_CoprocRegs: return "MCK_CoprocRegs";
  case MCK_DFPRegs: return "MCK_DFPRegs";
  case MCK_FPRegs: return "MCK_FPRegs";
  case MCK_IntRegs: return "MCK_IntRegs";
  case MCK_ASRRegs: return "MCK_ASRRegs";
  case MCK_Imm: return "MCK_Imm";
  case MCK_ASITag: return "MCK_ASITag";
  case MCK_CallTarget: return "MCK_CallTarget";
  case MCK_MEMri: return "MCK_MEMri";
  case MCK_MEMrr: return "MCK_MEMrr";
  case MCK_MembarTag: return "MCK_MembarTag";
  case MCK_PrefetchTag: return "MCK_PrefetchTag";
  case MCK_ShiftAmtImm5: return "MCK_ShiftAmtImm5";
  case MCK_ShiftAmtImm6: return "MCK_ShiftAmtImm6";
  case MCK_TailRelocSymLoad_GOT: return "MCK_TailRelocSymLoad_GOT";
  case MCK_TailRelocSymAdd_TLS: return "MCK_TailRelocSymAdd_TLS";
  case MCK_TailRelocSymLoad_TLS: return "MCK_TailRelocSymLoad_TLS";
  case MCK_TailRelocSymCall_TLS: return "MCK_TailRelocSymCall_TLS";
  case NumMatchClassKinds: return "NumMatchClassKinds";
  }
  llvm_unreachable("unhandled MatchClassKind!");
}

#endif // NDEBUG
FeatureBitset SparcAsmParser::
ComputeAvailableFeatures(const FeatureBitset &FB) const {
  FeatureBitset Features;
  if (FB[Sparc::FeatureSoftMulDiv])
    Features.set(Feature_UseSoftMulDivBit);
  if (FB[Sparc::FeatureV9])
    Features.set(Feature_HasV9Bit);
  if (FB[Sparc::FeatureVIS])
    Features.set(Feature_HasVISBit);
  if (FB[Sparc::FeatureVIS2])
    Features.set(Feature_HasVIS2Bit);
  if (FB[Sparc::FeatureVIS3])
    Features.set(Feature_HasVIS3Bit);
  if (FB[Sparc::LeonCASA] || FB[Sparc::FeatureV9])
    Features.set(Feature_HasCASABit);
  if (FB[Sparc::FeaturePWRPSR])
    Features.set(Feature_HasPWRPSRBit);
  return Features;
}

static bool checkAsmTiedOperandConstraints(const SparcAsmParser&AsmParser,
                               unsigned Kind, const OperandVector &Operands,
                               uint64_t &ErrorInfo) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    case CVT_Tied: {
      unsigned OpIdx = *(p + 1);
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned OpndNum1 = TiedAsmOperandTable[OpIdx][1];
      unsigned OpndNum2 = TiedAsmOperandTable[OpIdx][2];
      if (OpndNum1 != OpndNum2) {
        auto &SrcOp1 = Operands[OpndNum1];
        auto &SrcOp2 = Operands[OpndNum2];
        if (!AsmParser.areEqualRegs(*SrcOp1, *SrcOp2)) {
          ErrorInfo = OpndNum2;
          return false;
        }
      }
      break;
    }
    default:
      break;
    }
  }
  return true;
}

static const char MnemonicTable[] =
    "\003add\005addcc\004addx\005addxc\006addxcc\007addxccc\talignaddr\nalig"
    "naddrl\003and\005andcc\004andn\006andncc\007array16\007array32\006array"
    "8\001b\002ba\003bcc\004bclr\003bcs\002be\003beq\002bg\003bge\004bgeu\003"
    "bgt\003bgu\002bl\003ble\004bleu\003blt\003blu\005bmask\002bn\003bne\004"
    "bneg\003bnz\004bpos\002br\003bre\005brgez\004brgz\005brlez\004brlz\004b"
    "rne\004brnz\003brz\004bset\010bshuffle\004btog\004btst\003bvc\003bvs\002"
    "bz\004call\003cas\004casa\004casl\004casx\005casxa\005casxl\002cb\003cb"
    "0\004cb01\005cb012\005cb013\004cb02\005cb023\004cb03\003cb1\004cb12\005"
    "cb123\004cb13\003cb2\004cb23\003cb3\003cba\003cbn\003clr\004clrb\004clr"
    "h\007cmask16\007cmask32\006cmask8\003cmp\003dec\005deccc\004done\006edg"
    "e16\007edge16l\010edge16ln\007edge16n\006edge32\007edge32l\010edge32ln\007"
    "edge32n\005edge8\006edge8l\007edge8ln\006edge8n\005fabsd\005fabsq\005fa"
    "bss\005faddd\005faddq\005fadds\nfaligndata\004fand\010fandnot1\tfandnot"
    "1s\010fandnot2\tfandnot2s\005fands\002fb\003fba\003fbe\003fbg\004fbge\003"
    "fbl\004fble\004fblg\003fbn\004fbne\004fbnz\003fbo\003fbu\004fbue\004fbu"
    "g\005fbuge\004fbul\005fbule\003fbz\010fchksm16\005fcmpd\006fcmped\006fc"
    "mpeq\010fcmpeq16\010fcmpeq32\006fcmpes\010fcmpgt16\010fcmpgt32\010fcmpl"
    "e16\010fcmple32\010fcmpne16\010fcmpne32\005fcmpq\005fcmps\005fdivd\005f"
    "divq\005fdivs\006fdmulq\005fdtoi\005fdtoq\005fdtos\005fdtox\007fexpand\006"
    "fhaddd\006fhadds\006fhsubd\006fhsubs\005fitod\005fitoq\005fitos\006flcm"
    "pd\006flcmps\005flush\006flushw\007fmean16\005fmovd\006fmovda\007fmovdc"
    "c\007fmovdcs\006fmovde\007fmovdeq\006fmovdg\007fmovdge\010fmovdgeu\007f"
    "movdgt\007fmovdgu\006fmovdl\007fmovdle\010fmovdleu\007fmovdlg\007fmovdl"
    "t\007fmovdlu\006fmovdn\007fmovdne\010fmovdneg\007fmovdnz\006fmovdo\010f"
    "movdpos\006fmovdu\007fmovdue\007fmovdug\010fmovduge\007fmovdul\010fmovd"
    "ule\007fmovdvc\007fmovdvs\006fmovdz\005fmovq\006fmovqa\007fmovqcc\007fm"
    "ovqcs\006fmovqe\007fmovqeq\006fmovqg\007fmovqge\010fmovqgeu\007fmovqgt\007"
    "fmovqgu\006fmovql\007fmovqle\010fmovqleu\007fmovqlg\007fmovqlt\007fmovq"
    "lu\006fmovqn\007fmovqne\010fmovqneg\007fmovqnz\006fmovqo\010fmovqpos\006"
    "fmovqu\007fmovque\007fmovqug\010fmovquge\007fmovqul\010fmovqule\007fmov"
    "qvc\007fmovqvs\006fmovqz\006fmovrd\007fmovrde\tfmovrdgez\010fmovrdgz\tf"
    "movrdlez\010fmovrdlz\010fmovrdne\010fmovrdnz\007fmovrdz\006fmovrq\007fm"
    "ovrqe\tfmovrqgez\010fmovrqgz\tfmovrqlez\010fmovrqlz\010fmovrqne\010fmov"
    "rqnz\007fmovrqz\006fmovrs\007fmovrse\tfmovrsgez\010fmovrsgz\tfmovrslez\010"
    "fmovrslz\010fmovrsne\010fmovrsnz\007fmovrsz\005fmovs\006fmovsa\007fmovs"
    "cc\007fmovscs\006fmovse\007fmovseq\006fmovsg\007fmovsge\010fmovsgeu\007"
    "fmovsgt\007fmovsgu\006fmovsl\007fmovsle\010fmovsleu\007fmovslg\007fmovs"
    "lt\007fmovslu\006fmovsn\007fmovsne\010fmovsneg\007fmovsnz\006fmovso\010"
    "fmovspos\006fmovsu\007fmovsue\007fmovsug\010fmovsuge\007fmovsul\010fmov"
    "sule\007fmovsvc\007fmovsvs\006fmovsz\nfmul8sux16\nfmul8ulx16\010fmul8x1"
    "6\nfmul8x16al\nfmul8x16au\005fmuld\013fmuld8sux16\013fmuld8ulx16\005fmu"
    "lq\005fmuls\006fnaddd\006fnadds\005fnand\006fnands\005fnegd\005fnegq\005"
    "fnegs\007fnhaddd\007fnhadds\004fnor\005fnors\005fnot1\006fnot1s\005fnot"
    "2\006fnot2s\004fone\005fones\003for\007fornot1\010fornot1s\007fornot2\010"
    "fornot2s\004fors\007fpack16\007fpack32\010fpackfix\007fpadd16\010fpadd1"
    "6s\007fpadd32\010fpadd32s\007fpadd64\007fpmerge\007fpsub16\010fpsub16s\007"
    "fpsub32\010fpsub32s\005fqtod\005fqtoi\005fqtos\005fqtox\007fslas16\007f"
    "slas32\006fsll16\006fsll32\006fsmuld\006fsqrtd\006fsqrtq\006fsqrts\006f"
    "sra16\006fsra32\005fsrc1\006fsrc1s\005fsrc2\006fsrc2s\006fsrl16\006fsrl"
    "32\005fstod\005fstoi\005fstoq\005fstox\005fsubd\005fsubq\005fsubs\005fx"
    "nor\006fxnors\004fxor\005fxors\005fxtod\005fxtoq\005fxtos\005fzero\006f"
    "zeros\003inc\005inccc\003jmp\004jmpl\002ld\003lda\003ldd\004ldda\003ldq"
    "\004ldqa\004ldsb\005ldsba\004ldsh\005ldsha\006ldstub\007ldstuba\004ldsw"
    "\005ldswa\004ldub\005lduba\004lduh\005lduha\003ldx\004ldxa\005lzcnt\006"
    "membar\003mov\004mova\005movcc\005movcs\007movdtox\004move\005moveq\004"
    "movg\005movge\006movgeu\005movgt\005movgu\004movl\005movle\006movleu\005"
    "movlg\005movlt\005movlu\004movn\005movne\006movneg\005movnz\004movo\006"
    "movpos\004movr\005movre\007movrgez\006movrgz\007movrlez\006movrlz\006mo"
    "vrne\006movrnz\005movrz\010movstosw\010movstouw\004movu\005movue\005mov"
    "ug\006movuge\005movul\006movule\005movvc\005movvs\004movz\006mulscc\004"
    "mulx\003neg\003nop\003not\002or\004orcc\003orn\005orncc\005pdist\006pdi"
    "stn\004popc\010prefetch\tprefetcha\003pwr\002rd\004rdpr\007restore\010r"
    "estored\003ret\004retl\005retry\004rett\004save\005saved\004sdiv\006sdi"
    "vcc\005sdivx\003set\005sethi\004setx\010shutdown\004siam\005signx\003si"
    "r\003sll\004sllx\004smac\004smul\006smulcc\003sra\004srax\003srl\004srl"
    "x\002st\003sta\003stb\004stba\005stbar\003std\004stda\003sth\004stha\003"
    "stq\004stqa\003stx\004stxa\003sub\005subcc\004subx\006subxcc\004swap\005"
    "swapa\001t\002ta\006taddcc\010taddcctv\003tcc\003tcs\002te\003teq\002tg"
    "\003tge\004tgeu\003tgt\003tgu\002tl\003tle\004tleu\003tlt\003tlu\002tn\003"
    "tne\004tneg\003tnz\004tpos\003tst\006tsubcc\010tsubcctv\003tvc\003tvs\002"
    "tz\004udiv\006udivcc\005udivx\004umac\004umul\006umulcc\007umulxhi\005u"
    "nimp\002wr\004wrpr\005xmulx\007xmulxhi\004xnor\006xnorcc\003xor\005xorc"
    "c";

// Feature bitsets.
enum : uint8_t {
  AMFBS_None,
  AMFBS_HasCASA,
  AMFBS_HasPWRPSR,
  AMFBS_HasV9,
  AMFBS_HasVIS,
  AMFBS_HasVIS2,
  AMFBS_HasVIS3,
};

static constexpr FeatureBitset FeatureBitsets[] = {
  {}, // AMFBS_None
  {Feature_HasCASABit, },
  {Feature_HasPWRPSRBit, },
  {Feature_HasV9Bit, },
  {Feature_HasVISBit, },
  {Feature_HasVIS2Bit, },
  {Feature_HasVIS3Bit, },
};

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint16_t ConvertFn;
    uint8_t RequiredFeaturesIdx;
    uint8_t Classes[6];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const MatchEntry MatchTable0[] = {
  { 0 /* add */, SP::ADDrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 0 /* add */, SP::ADDri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 0 /* add */, SP::TLS_ADDrr, Convert__Reg1_2__Reg1_0__Reg1_1__TailRelocSymAdd_TLS1_3, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs, MCK_TailRelocSymAdd_TLS }, },
  { 4 /* addcc */, SP::ADDCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4 /* addcc */, SP::ADDCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 10 /* addx */, SP::ADDCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 10 /* addx */, SP::ADDCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 10 /* addx */, SP::ADDCri, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK_IntRegs }, },
  { 15 /* addxc */, SP::ADDXC, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 21 /* addxcc */, SP::ADDErr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 21 /* addxcc */, SP::ADDEri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 28 /* addxccc */, SP::ADDXCCC, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 36 /* alignaddr */, SP::ALIGNADDR, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 46 /* alignaddrl */, SP::ALIGNADDRL, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 57 /* and */, SP::ANDrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 57 /* and */, SP::ANDri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 61 /* andcc */, SP::ANDCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 61 /* andcc */, SP::ANDCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 67 /* andn */, SP::ANDNrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 67 /* andn */, SP::ANDNri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 72 /* andncc */, SP::ANDNCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 72 /* andncc */, SP::ANDNCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 79 /* array16 */, SP::ARRAY16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 87 /* array32 */, SP::ARRAY32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 95 /* array8 */, SP::ARRAY8, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 102 /* b */, SP::BCOND, Convert__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 102 /* b */, SP::BPXCC, Convert__Imm1_1__imm_95_8, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 102 /* b */, SP::BCONDA, Convert__Imm1_1__imm_95_8, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 102 /* b */, SP::BPICC, Convert__Imm1_1__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 102 /* b */, SP::BCOND, Convert__Imm1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Imm }, },
  { 102 /* b */, SP::BPXCCA, Convert__Imm1_2__imm_95_8, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 102 /* b */, SP::BPICCA, Convert__Imm1_2__imm_95_8, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 102 /* b */, SP::BPXCCNT, Convert__Imm1_2__imm_95_8, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 102 /* b */, SP::BPICCNT, Convert__Imm1_2__imm_95_8, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 102 /* b */, SP::BPXCC, Convert__Imm1_2__imm_95_8, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 102 /* b */, SP::BPICC, Convert__Imm1_2__imm_95_8, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 102 /* b */, SP::BPXCC, Convert__Imm1_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK__PCT_xcc, MCK_Imm }, },
  { 102 /* b */, SP::BCONDA, Convert__Imm1_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_a, MCK_Imm }, },
  { 102 /* b */, SP::BPICC, Convert__Imm1_2__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_Imm }, },
  { 102 /* b */, SP::BPXCCANT, Convert__Imm1_3__imm_95_8, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 102 /* b */, SP::BPICCANT, Convert__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 102 /* b */, SP::BPXCCA, Convert__Imm1_3__imm_95_8, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 102 /* b */, SP::BPICCA, Convert__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 102 /* b */, SP::BPXCCA, Convert__Imm1_3__Imm1_0, AMFBS_None, { MCK_Imm, MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 102 /* b */, SP::BPICCA, Convert__Imm1_3__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_a, MCK_ICC, MCK_Imm }, },
  { 102 /* b */, SP::BPXCCNT, Convert__Imm1_3__Imm1_0, AMFBS_None, { MCK_Imm, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 102 /* b */, SP::BPICCNT, Convert__Imm1_3__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 102 /* b */, SP::BPXCCANT, Convert__Imm1_4__Imm1_0, AMFBS_None, { MCK_Imm, MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 102 /* b */, SP::BPICCANT, Convert__Imm1_4__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 104 /* ba */, SP::BA, Convert__Imm1_0, AMFBS_None, { MCK_Imm }, },
  { 104 /* ba */, SP::BCOND, Convert__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 104 /* ba */, SP::BPXCC, Convert__Imm1_1__imm_95_8, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 104 /* ba */, SP::BCONDA, Convert__Imm1_1__imm_95_8, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 104 /* ba */, SP::BPICC, Convert__Imm1_1__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 104 /* ba */, SP::BPXCCA, Convert__Imm1_2__imm_95_8, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 104 /* ba */, SP::BPICCA, Convert__Imm1_2__imm_95_8, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 104 /* ba */, SP::BPXCCNT, Convert__Imm1_2__imm_95_8, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 104 /* ba */, SP::BPICCNT, Convert__Imm1_2__imm_95_8, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 104 /* ba */, SP::BPXCC, Convert__Imm1_2__imm_95_8, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 104 /* ba */, SP::BPICC, Convert__Imm1_2__imm_95_8, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 104 /* ba */, SP::BPXCCANT, Convert__Imm1_3__imm_95_8, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 104 /* ba */, SP::BPICCANT, Convert__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 104 /* ba */, SP::BPXCCA, Convert__Imm1_3__imm_95_8, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 104 /* ba */, SP::BPICCA, Convert__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 107 /* bcc */, SP::BCOND, Convert__Imm1_0__imm_95_13, AMFBS_None, { MCK_Imm }, },
  { 107 /* bcc */, SP::BPXCC, Convert__Imm1_1__imm_95_13, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 107 /* bcc */, SP::BCONDA, Convert__Imm1_1__imm_95_13, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 107 /* bcc */, SP::BPICC, Convert__Imm1_1__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 107 /* bcc */, SP::BPXCCA, Convert__Imm1_2__imm_95_13, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 107 /* bcc */, SP::BPICCA, Convert__Imm1_2__imm_95_13, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 107 /* bcc */, SP::BPXCCNT, Convert__Imm1_2__imm_95_13, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 107 /* bcc */, SP::BPICCNT, Convert__Imm1_2__imm_95_13, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 107 /* bcc */, SP::BPXCC, Convert__Imm1_2__imm_95_13, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 107 /* bcc */, SP::BPICC, Convert__Imm1_2__imm_95_13, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 107 /* bcc */, SP::BPXCCANT, Convert__Imm1_3__imm_95_13, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 107 /* bcc */, SP::BPICCANT, Convert__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 107 /* bcc */, SP::BPXCCA, Convert__Imm1_3__imm_95_13, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 107 /* bcc */, SP::BPICCA, Convert__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 111 /* bclr */, SP::ANDNrr, Convert__Reg1_1__Reg1_1__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 111 /* bclr */, SP::ANDNri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 116 /* bcs */, SP::BCOND, Convert__Imm1_0__imm_95_5, AMFBS_None, { MCK_Imm }, },
  { 116 /* bcs */, SP::BPXCC, Convert__Imm1_1__imm_95_5, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 116 /* bcs */, SP::BCONDA, Convert__Imm1_1__imm_95_5, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 116 /* bcs */, SP::BPICC, Convert__Imm1_1__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 116 /* bcs */, SP::BPXCCA, Convert__Imm1_2__imm_95_5, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 116 /* bcs */, SP::BPICCA, Convert__Imm1_2__imm_95_5, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 116 /* bcs */, SP::BPXCCNT, Convert__Imm1_2__imm_95_5, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 116 /* bcs */, SP::BPICCNT, Convert__Imm1_2__imm_95_5, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 116 /* bcs */, SP::BPXCC, Convert__Imm1_2__imm_95_5, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 116 /* bcs */, SP::BPICC, Convert__Imm1_2__imm_95_5, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 116 /* bcs */, SP::BPXCCANT, Convert__Imm1_3__imm_95_5, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 116 /* bcs */, SP::BPICCANT, Convert__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 116 /* bcs */, SP::BPXCCA, Convert__Imm1_3__imm_95_5, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 116 /* bcs */, SP::BPICCA, Convert__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 120 /* be */, SP::BCOND, Convert__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 120 /* be */, SP::BPXCC, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 120 /* be */, SP::BCONDA, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 120 /* be */, SP::BPICC, Convert__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 120 /* be */, SP::BPXCCA, Convert__Imm1_2__imm_95_1, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 120 /* be */, SP::BPICCA, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 120 /* be */, SP::BPXCCNT, Convert__Imm1_2__imm_95_1, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 120 /* be */, SP::BPICCNT, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 120 /* be */, SP::BPXCC, Convert__Imm1_2__imm_95_1, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 120 /* be */, SP::BPICC, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 120 /* be */, SP::BPXCCANT, Convert__Imm1_3__imm_95_1, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 120 /* be */, SP::BPICCANT, Convert__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 120 /* be */, SP::BPXCCA, Convert__Imm1_3__imm_95_1, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 120 /* be */, SP::BPICCA, Convert__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 123 /* beq */, SP::BCOND, Convert__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 123 /* beq */, SP::BPXCC, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 123 /* beq */, SP::BCONDA, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 123 /* beq */, SP::BPICC, Convert__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 123 /* beq */, SP::BPXCCA, Convert__Imm1_2__imm_95_1, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 123 /* beq */, SP::BPICCA, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 123 /* beq */, SP::BPXCCNT, Convert__Imm1_2__imm_95_1, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 123 /* beq */, SP::BPICCNT, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 123 /* beq */, SP::BPXCC, Convert__Imm1_2__imm_95_1, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 123 /* beq */, SP::BPICC, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 123 /* beq */, SP::BPXCCANT, Convert__Imm1_3__imm_95_1, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 123 /* beq */, SP::BPICCANT, Convert__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 123 /* beq */, SP::BPXCCA, Convert__Imm1_3__imm_95_1, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 123 /* beq */, SP::BPICCA, Convert__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 127 /* bg */, SP::BCOND, Convert__Imm1_0__imm_95_10, AMFBS_None, { MCK_Imm }, },
  { 127 /* bg */, SP::BPXCC, Convert__Imm1_1__imm_95_10, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 127 /* bg */, SP::BCONDA, Convert__Imm1_1__imm_95_10, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 127 /* bg */, SP::BPICC, Convert__Imm1_1__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 127 /* bg */, SP::BPXCCA, Convert__Imm1_2__imm_95_10, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 127 /* bg */, SP::BPICCA, Convert__Imm1_2__imm_95_10, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 127 /* bg */, SP::BPXCCNT, Convert__Imm1_2__imm_95_10, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 127 /* bg */, SP::BPICCNT, Convert__Imm1_2__imm_95_10, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 127 /* bg */, SP::BPXCC, Convert__Imm1_2__imm_95_10, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 127 /* bg */, SP::BPICC, Convert__Imm1_2__imm_95_10, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 127 /* bg */, SP::BPXCCANT, Convert__Imm1_3__imm_95_10, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 127 /* bg */, SP::BPICCANT, Convert__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 127 /* bg */, SP::BPXCCA, Convert__Imm1_3__imm_95_10, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 127 /* bg */, SP::BPICCA, Convert__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 130 /* bge */, SP::BCOND, Convert__Imm1_0__imm_95_11, AMFBS_None, { MCK_Imm }, },
  { 130 /* bge */, SP::BPXCC, Convert__Imm1_1__imm_95_11, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 130 /* bge */, SP::BCONDA, Convert__Imm1_1__imm_95_11, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 130 /* bge */, SP::BPICC, Convert__Imm1_1__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 130 /* bge */, SP::BPXCCA, Convert__Imm1_2__imm_95_11, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 130 /* bge */, SP::BPICCA, Convert__Imm1_2__imm_95_11, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 130 /* bge */, SP::BPXCCNT, Convert__Imm1_2__imm_95_11, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 130 /* bge */, SP::BPICCNT, Convert__Imm1_2__imm_95_11, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 130 /* bge */, SP::BPXCC, Convert__Imm1_2__imm_95_11, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 130 /* bge */, SP::BPICC, Convert__Imm1_2__imm_95_11, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 130 /* bge */, SP::BPXCCANT, Convert__Imm1_3__imm_95_11, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 130 /* bge */, SP::BPICCANT, Convert__Imm1_3__imm_95_11, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 130 /* bge */, SP::BPXCCA, Convert__Imm1_3__imm_95_11, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 130 /* bge */, SP::BPICCA, Convert__Imm1_3__imm_95_11, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 134 /* bgeu */, SP::BCOND, Convert__Imm1_0__imm_95_13, AMFBS_None, { MCK_Imm }, },
  { 134 /* bgeu */, SP::BPXCC, Convert__Imm1_1__imm_95_13, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 134 /* bgeu */, SP::BCONDA, Convert__Imm1_1__imm_95_13, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 134 /* bgeu */, SP::BPICC, Convert__Imm1_1__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 134 /* bgeu */, SP::BPXCCA, Convert__Imm1_2__imm_95_13, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 134 /* bgeu */, SP::BPICCA, Convert__Imm1_2__imm_95_13, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 134 /* bgeu */, SP::BPXCCNT, Convert__Imm1_2__imm_95_13, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 134 /* bgeu */, SP::BPICCNT, Convert__Imm1_2__imm_95_13, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 134 /* bgeu */, SP::BPXCC, Convert__Imm1_2__imm_95_13, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 134 /* bgeu */, SP::BPICC, Convert__Imm1_2__imm_95_13, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 134 /* bgeu */, SP::BPXCCANT, Convert__Imm1_3__imm_95_13, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 134 /* bgeu */, SP::BPICCANT, Convert__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 134 /* bgeu */, SP::BPXCCA, Convert__Imm1_3__imm_95_13, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 134 /* bgeu */, SP::BPICCA, Convert__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 139 /* bgt */, SP::BCOND, Convert__Imm1_0__imm_95_10, AMFBS_None, { MCK_Imm }, },
  { 139 /* bgt */, SP::BPXCC, Convert__Imm1_1__imm_95_10, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 139 /* bgt */, SP::BCONDA, Convert__Imm1_1__imm_95_10, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 139 /* bgt */, SP::BPICC, Convert__Imm1_1__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 139 /* bgt */, SP::BPXCCA, Convert__Imm1_2__imm_95_10, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 139 /* bgt */, SP::BPICCA, Convert__Imm1_2__imm_95_10, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 139 /* bgt */, SP::BPXCCNT, Convert__Imm1_2__imm_95_10, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 139 /* bgt */, SP::BPICCNT, Convert__Imm1_2__imm_95_10, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 139 /* bgt */, SP::BPXCC, Convert__Imm1_2__imm_95_10, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 139 /* bgt */, SP::BPICC, Convert__Imm1_2__imm_95_10, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 139 /* bgt */, SP::BPXCCANT, Convert__Imm1_3__imm_95_10, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 139 /* bgt */, SP::BPICCANT, Convert__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 139 /* bgt */, SP::BPXCCA, Convert__Imm1_3__imm_95_10, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 139 /* bgt */, SP::BPICCA, Convert__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 143 /* bgu */, SP::BCOND, Convert__Imm1_0__imm_95_12, AMFBS_None, { MCK_Imm }, },
  { 143 /* bgu */, SP::BPXCC, Convert__Imm1_1__imm_95_12, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 143 /* bgu */, SP::BCONDA, Convert__Imm1_1__imm_95_12, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 143 /* bgu */, SP::BPICC, Convert__Imm1_1__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 143 /* bgu */, SP::BPXCCA, Convert__Imm1_2__imm_95_12, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 143 /* bgu */, SP::BPICCA, Convert__Imm1_2__imm_95_12, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 143 /* bgu */, SP::BPXCCNT, Convert__Imm1_2__imm_95_12, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 143 /* bgu */, SP::BPICCNT, Convert__Imm1_2__imm_95_12, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 143 /* bgu */, SP::BPXCC, Convert__Imm1_2__imm_95_12, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 143 /* bgu */, SP::BPICC, Convert__Imm1_2__imm_95_12, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 143 /* bgu */, SP::BPXCCANT, Convert__Imm1_3__imm_95_12, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 143 /* bgu */, SP::BPICCANT, Convert__Imm1_3__imm_95_12, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 143 /* bgu */, SP::BPXCCA, Convert__Imm1_3__imm_95_12, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 143 /* bgu */, SP::BPICCA, Convert__Imm1_3__imm_95_12, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 147 /* bl */, SP::BCOND, Convert__Imm1_0__imm_95_3, AMFBS_None, { MCK_Imm }, },
  { 147 /* bl */, SP::BPXCC, Convert__Imm1_1__imm_95_3, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 147 /* bl */, SP::BCONDA, Convert__Imm1_1__imm_95_3, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 147 /* bl */, SP::BPICC, Convert__Imm1_1__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 147 /* bl */, SP::BPXCCA, Convert__Imm1_2__imm_95_3, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 147 /* bl */, SP::BPICCA, Convert__Imm1_2__imm_95_3, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 147 /* bl */, SP::BPXCCNT, Convert__Imm1_2__imm_95_3, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 147 /* bl */, SP::BPICCNT, Convert__Imm1_2__imm_95_3, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 147 /* bl */, SP::BPXCC, Convert__Imm1_2__imm_95_3, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 147 /* bl */, SP::BPICC, Convert__Imm1_2__imm_95_3, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 147 /* bl */, SP::BPXCCANT, Convert__Imm1_3__imm_95_3, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 147 /* bl */, SP::BPICCANT, Convert__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 147 /* bl */, SP::BPXCCA, Convert__Imm1_3__imm_95_3, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 147 /* bl */, SP::BPICCA, Convert__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 150 /* ble */, SP::BCOND, Convert__Imm1_0__imm_95_2, AMFBS_None, { MCK_Imm }, },
  { 150 /* ble */, SP::BPXCC, Convert__Imm1_1__imm_95_2, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 150 /* ble */, SP::BCONDA, Convert__Imm1_1__imm_95_2, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 150 /* ble */, SP::BPICC, Convert__Imm1_1__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 150 /* ble */, SP::BPXCCA, Convert__Imm1_2__imm_95_2, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 150 /* ble */, SP::BPICCA, Convert__Imm1_2__imm_95_2, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 150 /* ble */, SP::BPXCCNT, Convert__Imm1_2__imm_95_2, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 150 /* ble */, SP::BPICCNT, Convert__Imm1_2__imm_95_2, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 150 /* ble */, SP::BPXCC, Convert__Imm1_2__imm_95_2, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 150 /* ble */, SP::BPICC, Convert__Imm1_2__imm_95_2, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 150 /* ble */, SP::BPXCCANT, Convert__Imm1_3__imm_95_2, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 150 /* ble */, SP::BPICCANT, Convert__Imm1_3__imm_95_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 150 /* ble */, SP::BPXCCA, Convert__Imm1_3__imm_95_2, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 150 /* ble */, SP::BPICCA, Convert__Imm1_3__imm_95_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 154 /* bleu */, SP::BCOND, Convert__Imm1_0__imm_95_4, AMFBS_None, { MCK_Imm }, },
  { 154 /* bleu */, SP::BPXCC, Convert__Imm1_1__imm_95_4, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 154 /* bleu */, SP::BCONDA, Convert__Imm1_1__imm_95_4, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 154 /* bleu */, SP::BPICC, Convert__Imm1_1__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 154 /* bleu */, SP::BPXCCA, Convert__Imm1_2__imm_95_4, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 154 /* bleu */, SP::BPICCA, Convert__Imm1_2__imm_95_4, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 154 /* bleu */, SP::BPXCCNT, Convert__Imm1_2__imm_95_4, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 154 /* bleu */, SP::BPICCNT, Convert__Imm1_2__imm_95_4, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 154 /* bleu */, SP::BPXCC, Convert__Imm1_2__imm_95_4, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 154 /* bleu */, SP::BPICC, Convert__Imm1_2__imm_95_4, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 154 /* bleu */, SP::BPXCCANT, Convert__Imm1_3__imm_95_4, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 154 /* bleu */, SP::BPICCANT, Convert__Imm1_3__imm_95_4, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 154 /* bleu */, SP::BPXCCA, Convert__Imm1_3__imm_95_4, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 154 /* bleu */, SP::BPICCA, Convert__Imm1_3__imm_95_4, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 159 /* blt */, SP::BCOND, Convert__Imm1_0__imm_95_3, AMFBS_None, { MCK_Imm }, },
  { 159 /* blt */, SP::BPXCC, Convert__Imm1_1__imm_95_3, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 159 /* blt */, SP::BCONDA, Convert__Imm1_1__imm_95_3, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 159 /* blt */, SP::BPICC, Convert__Imm1_1__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 159 /* blt */, SP::BPXCCA, Convert__Imm1_2__imm_95_3, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 159 /* blt */, SP::BPICCA, Convert__Imm1_2__imm_95_3, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 159 /* blt */, SP::BPXCCNT, Convert__Imm1_2__imm_95_3, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 159 /* blt */, SP::BPICCNT, Convert__Imm1_2__imm_95_3, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 159 /* blt */, SP::BPXCC, Convert__Imm1_2__imm_95_3, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 159 /* blt */, SP::BPICC, Convert__Imm1_2__imm_95_3, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 159 /* blt */, SP::BPXCCANT, Convert__Imm1_3__imm_95_3, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 159 /* blt */, SP::BPICCANT, Convert__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 159 /* blt */, SP::BPXCCA, Convert__Imm1_3__imm_95_3, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 159 /* blt */, SP::BPICCA, Convert__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 163 /* blu */, SP::BCOND, Convert__Imm1_0__imm_95_5, AMFBS_None, { MCK_Imm }, },
  { 163 /* blu */, SP::BPXCC, Convert__Imm1_1__imm_95_5, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 163 /* blu */, SP::BCONDA, Convert__Imm1_1__imm_95_5, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 163 /* blu */, SP::BPICC, Convert__Imm1_1__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 163 /* blu */, SP::BPXCCA, Convert__Imm1_2__imm_95_5, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 163 /* blu */, SP::BPICCA, Convert__Imm1_2__imm_95_5, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 163 /* blu */, SP::BPXCCNT, Convert__Imm1_2__imm_95_5, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 163 /* blu */, SP::BPICCNT, Convert__Imm1_2__imm_95_5, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 163 /* blu */, SP::BPXCC, Convert__Imm1_2__imm_95_5, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 163 /* blu */, SP::BPICC, Convert__Imm1_2__imm_95_5, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 163 /* blu */, SP::BPXCCANT, Convert__Imm1_3__imm_95_5, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 163 /* blu */, SP::BPICCANT, Convert__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 163 /* blu */, SP::BPXCCA, Convert__Imm1_3__imm_95_5, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 163 /* blu */, SP::BPICCA, Convert__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 167 /* bmask */, SP::BMASK, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 173 /* bn */, SP::BCOND, Convert__Imm1_0__imm_95_0, AMFBS_None, { MCK_Imm }, },
  { 173 /* bn */, SP::BPXCC, Convert__Imm1_1__imm_95_0, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 173 /* bn */, SP::BCONDA, Convert__Imm1_1__imm_95_0, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 173 /* bn */, SP::BPICC, Convert__Imm1_1__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 173 /* bn */, SP::BPXCCA, Convert__Imm1_2__imm_95_0, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 173 /* bn */, SP::BPICCA, Convert__Imm1_2__imm_95_0, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 173 /* bn */, SP::BPXCCNT, Convert__Imm1_2__imm_95_0, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 173 /* bn */, SP::BPICCNT, Convert__Imm1_2__imm_95_0, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 173 /* bn */, SP::BPXCC, Convert__Imm1_2__imm_95_0, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 173 /* bn */, SP::BPICC, Convert__Imm1_2__imm_95_0, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 173 /* bn */, SP::BPXCCANT, Convert__Imm1_3__imm_95_0, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 173 /* bn */, SP::BPICCANT, Convert__Imm1_3__imm_95_0, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 173 /* bn */, SP::BPXCCA, Convert__Imm1_3__imm_95_0, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 173 /* bn */, SP::BPICCA, Convert__Imm1_3__imm_95_0, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 176 /* bne */, SP::BCOND, Convert__Imm1_0__imm_95_9, AMFBS_None, { MCK_Imm }, },
  { 176 /* bne */, SP::BPXCC, Convert__Imm1_1__imm_95_9, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 176 /* bne */, SP::BCONDA, Convert__Imm1_1__imm_95_9, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 176 /* bne */, SP::BPICC, Convert__Imm1_1__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 176 /* bne */, SP::BPXCCA, Convert__Imm1_2__imm_95_9, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 176 /* bne */, SP::BPICCA, Convert__Imm1_2__imm_95_9, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 176 /* bne */, SP::BPXCCNT, Convert__Imm1_2__imm_95_9, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 176 /* bne */, SP::BPICCNT, Convert__Imm1_2__imm_95_9, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 176 /* bne */, SP::BPXCC, Convert__Imm1_2__imm_95_9, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 176 /* bne */, SP::BPICC, Convert__Imm1_2__imm_95_9, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 176 /* bne */, SP::BPXCCANT, Convert__Imm1_3__imm_95_9, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 176 /* bne */, SP::BPICCANT, Convert__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 176 /* bne */, SP::BPXCCA, Convert__Imm1_3__imm_95_9, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 176 /* bne */, SP::BPICCA, Convert__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 180 /* bneg */, SP::BCOND, Convert__Imm1_0__imm_95_6, AMFBS_None, { MCK_Imm }, },
  { 180 /* bneg */, SP::BPXCC, Convert__Imm1_1__imm_95_6, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 180 /* bneg */, SP::BCONDA, Convert__Imm1_1__imm_95_6, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 180 /* bneg */, SP::BPICC, Convert__Imm1_1__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 180 /* bneg */, SP::BPXCCA, Convert__Imm1_2__imm_95_6, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 180 /* bneg */, SP::BPICCA, Convert__Imm1_2__imm_95_6, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 180 /* bneg */, SP::BPXCCNT, Convert__Imm1_2__imm_95_6, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 180 /* bneg */, SP::BPICCNT, Convert__Imm1_2__imm_95_6, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 180 /* bneg */, SP::BPXCC, Convert__Imm1_2__imm_95_6, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 180 /* bneg */, SP::BPICC, Convert__Imm1_2__imm_95_6, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 180 /* bneg */, SP::BPXCCANT, Convert__Imm1_3__imm_95_6, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 180 /* bneg */, SP::BPICCANT, Convert__Imm1_3__imm_95_6, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 180 /* bneg */, SP::BPXCCA, Convert__Imm1_3__imm_95_6, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 180 /* bneg */, SP::BPICCA, Convert__Imm1_3__imm_95_6, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 185 /* bnz */, SP::BCOND, Convert__Imm1_0__imm_95_9, AMFBS_None, { MCK_Imm }, },
  { 185 /* bnz */, SP::BPXCC, Convert__Imm1_1__imm_95_9, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 185 /* bnz */, SP::BCONDA, Convert__Imm1_1__imm_95_9, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 185 /* bnz */, SP::BPICC, Convert__Imm1_1__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 185 /* bnz */, SP::BPXCCA, Convert__Imm1_2__imm_95_9, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 185 /* bnz */, SP::BPICCA, Convert__Imm1_2__imm_95_9, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 185 /* bnz */, SP::BPXCCNT, Convert__Imm1_2__imm_95_9, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 185 /* bnz */, SP::BPICCNT, Convert__Imm1_2__imm_95_9, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 185 /* bnz */, SP::BPXCC, Convert__Imm1_2__imm_95_9, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 185 /* bnz */, SP::BPICC, Convert__Imm1_2__imm_95_9, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 185 /* bnz */, SP::BPXCCANT, Convert__Imm1_3__imm_95_9, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 185 /* bnz */, SP::BPICCANT, Convert__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 185 /* bnz */, SP::BPXCCA, Convert__Imm1_3__imm_95_9, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 185 /* bnz */, SP::BPICCA, Convert__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 189 /* bpos */, SP::BCOND, Convert__Imm1_0__imm_95_14, AMFBS_None, { MCK_Imm }, },
  { 189 /* bpos */, SP::BPXCC, Convert__Imm1_1__imm_95_14, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 189 /* bpos */, SP::BCONDA, Convert__Imm1_1__imm_95_14, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 189 /* bpos */, SP::BPICC, Convert__Imm1_1__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 189 /* bpos */, SP::BPXCCA, Convert__Imm1_2__imm_95_14, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 189 /* bpos */, SP::BPICCA, Convert__Imm1_2__imm_95_14, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 189 /* bpos */, SP::BPXCCNT, Convert__Imm1_2__imm_95_14, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 189 /* bpos */, SP::BPICCNT, Convert__Imm1_2__imm_95_14, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 189 /* bpos */, SP::BPXCC, Convert__Imm1_2__imm_95_14, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 189 /* bpos */, SP::BPICC, Convert__Imm1_2__imm_95_14, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 189 /* bpos */, SP::BPXCCANT, Convert__Imm1_3__imm_95_14, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 189 /* bpos */, SP::BPICCANT, Convert__Imm1_3__imm_95_14, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 189 /* bpos */, SP::BPXCCA, Convert__Imm1_3__imm_95_14, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 189 /* bpos */, SP::BPICCA, Convert__Imm1_3__imm_95_14, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 194 /* br */, SP::BPR, Convert__Imm1_2__Imm1_0__Reg1_1, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK_Imm }, },
  { 194 /* br */, SP::BPRA, Convert__Imm1_3__Imm1_0__Reg1_2, AMFBS_None, { MCK_Imm, MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 194 /* br */, SP::BPRNT, Convert__Imm1_3__Imm1_0__Reg1_2, AMFBS_None, { MCK_Imm, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 194 /* br */, SP::BPRANT, Convert__Imm1_4__Imm1_0__Reg1_3, AMFBS_None, { MCK_Imm, MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 197 /* bre */, SP::BPR, Convert__Imm1_1__imm_95_1__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_Imm }, },
  { 197 /* bre */, SP::BPRA, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_None, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 197 /* bre */, SP::BPRNT, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_None, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 197 /* bre */, SP::BPR, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_None, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 197 /* bre */, SP::BPRANT, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_None, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 197 /* bre */, SP::BPRA, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_None, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 201 /* brgez */, SP::BPR, Convert__Imm1_1__imm_95_7__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_Imm }, },
  { 201 /* brgez */, SP::BPRA, Convert__Imm1_2__imm_95_7__Reg1_1, AMFBS_None, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 201 /* brgez */, SP::BPRNT, Convert__Imm1_2__imm_95_7__Reg1_1, AMFBS_None, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 201 /* brgez */, SP::BPR, Convert__Imm1_2__imm_95_7__Reg1_1, AMFBS_None, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 201 /* brgez */, SP::BPRANT, Convert__Imm1_3__imm_95_7__Reg1_2, AMFBS_None, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 201 /* brgez */, SP::BPRA, Convert__Imm1_3__imm_95_7__Reg1_2, AMFBS_None, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 207 /* brgz */, SP::BPR, Convert__Imm1_1__imm_95_6__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_Imm }, },
  { 207 /* brgz */, SP::BPRA, Convert__Imm1_2__imm_95_6__Reg1_1, AMFBS_None, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 207 /* brgz */, SP::BPRNT, Convert__Imm1_2__imm_95_6__Reg1_1, AMFBS_None, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 207 /* brgz */, SP::BPR, Convert__Imm1_2__imm_95_6__Reg1_1, AMFBS_None, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 207 /* brgz */, SP::BPRANT, Convert__Imm1_3__imm_95_6__Reg1_2, AMFBS_None, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 207 /* brgz */, SP::BPRA, Convert__Imm1_3__imm_95_6__Reg1_2, AMFBS_None, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 212 /* brlez */, SP::BPR, Convert__Imm1_1__imm_95_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_Imm }, },
  { 212 /* brlez */, SP::BPRA, Convert__Imm1_2__imm_95_2__Reg1_1, AMFBS_None, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 212 /* brlez */, SP::BPRNT, Convert__Imm1_2__imm_95_2__Reg1_1, AMFBS_None, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 212 /* brlez */, SP::BPR, Convert__Imm1_2__imm_95_2__Reg1_1, AMFBS_None, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 212 /* brlez */, SP::BPRANT, Convert__Imm1_3__imm_95_2__Reg1_2, AMFBS_None, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 212 /* brlez */, SP::BPRA, Convert__Imm1_3__imm_95_2__Reg1_2, AMFBS_None, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 218 /* brlz */, SP::BPR, Convert__Imm1_1__imm_95_3__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_Imm }, },
  { 218 /* brlz */, SP::BPRA, Convert__Imm1_2__imm_95_3__Reg1_1, AMFBS_None, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 218 /* brlz */, SP::BPRNT, Convert__Imm1_2__imm_95_3__Reg1_1, AMFBS_None, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 218 /* brlz */, SP::BPR, Convert__Imm1_2__imm_95_3__Reg1_1, AMFBS_None, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 218 /* brlz */, SP::BPRANT, Convert__Imm1_3__imm_95_3__Reg1_2, AMFBS_None, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 218 /* brlz */, SP::BPRA, Convert__Imm1_3__imm_95_3__Reg1_2, AMFBS_None, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 223 /* brne */, SP::BPR, Convert__Imm1_1__imm_95_5__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_Imm }, },
  { 223 /* brne */, SP::BPRA, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_None, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 223 /* brne */, SP::BPRNT, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_None, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 223 /* brne */, SP::BPR, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_None, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 223 /* brne */, SP::BPRANT, Convert__Imm1_3__imm_95_5__Reg1_2, AMFBS_None, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 223 /* brne */, SP::BPRA, Convert__Imm1_3__imm_95_5__Reg1_2, AMFBS_None, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 228 /* brnz */, SP::BPR, Convert__Imm1_1__imm_95_5__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_Imm }, },
  { 228 /* brnz */, SP::BPRA, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_None, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 228 /* brnz */, SP::BPRNT, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_None, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 228 /* brnz */, SP::BPR, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_None, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 228 /* brnz */, SP::BPRANT, Convert__Imm1_3__imm_95_5__Reg1_2, AMFBS_None, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 228 /* brnz */, SP::BPRA, Convert__Imm1_3__imm_95_5__Reg1_2, AMFBS_None, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 233 /* brz */, SP::BPR, Convert__Imm1_1__imm_95_1__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_Imm }, },
  { 233 /* brz */, SP::BPRA, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_None, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 233 /* brz */, SP::BPRNT, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_None, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 233 /* brz */, SP::BPR, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_None, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 233 /* brz */, SP::BPRANT, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_None, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 233 /* brz */, SP::BPRA, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_None, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 237 /* bset */, SP::ORrr, Convert__Reg1_1__Reg1_1__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 237 /* bset */, SP::ORri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 242 /* bshuffle */, SP::BSHUFFLE, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 251 /* btog */, SP::XORrr, Convert__Reg1_1__Reg1_1__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 251 /* btog */, SP::XORri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 256 /* btst */, SP::ANDCCrr, Convert__regG0__Reg1_1__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 256 /* btst */, SP::ANDCCri, Convert__regG0__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 261 /* bvc */, SP::BCOND, Convert__Imm1_0__imm_95_15, AMFBS_None, { MCK_Imm }, },
  { 261 /* bvc */, SP::BPXCC, Convert__Imm1_1__imm_95_15, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 261 /* bvc */, SP::BCONDA, Convert__Imm1_1__imm_95_15, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 261 /* bvc */, SP::BPICC, Convert__Imm1_1__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 261 /* bvc */, SP::BPXCCA, Convert__Imm1_2__imm_95_15, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 261 /* bvc */, SP::BPICCA, Convert__Imm1_2__imm_95_15, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 261 /* bvc */, SP::BPXCCNT, Convert__Imm1_2__imm_95_15, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 261 /* bvc */, SP::BPICCNT, Convert__Imm1_2__imm_95_15, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 261 /* bvc */, SP::BPXCC, Convert__Imm1_2__imm_95_15, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 261 /* bvc */, SP::BPICC, Convert__Imm1_2__imm_95_15, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 261 /* bvc */, SP::BPXCCANT, Convert__Imm1_3__imm_95_15, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 261 /* bvc */, SP::BPICCANT, Convert__Imm1_3__imm_95_15, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 261 /* bvc */, SP::BPXCCA, Convert__Imm1_3__imm_95_15, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 261 /* bvc */, SP::BPICCA, Convert__Imm1_3__imm_95_15, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 265 /* bvs */, SP::BCOND, Convert__Imm1_0__imm_95_7, AMFBS_None, { MCK_Imm }, },
  { 265 /* bvs */, SP::BPXCC, Convert__Imm1_1__imm_95_7, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 265 /* bvs */, SP::BCONDA, Convert__Imm1_1__imm_95_7, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 265 /* bvs */, SP::BPICC, Convert__Imm1_1__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 265 /* bvs */, SP::BPXCCA, Convert__Imm1_2__imm_95_7, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 265 /* bvs */, SP::BPICCA, Convert__Imm1_2__imm_95_7, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 265 /* bvs */, SP::BPXCCNT, Convert__Imm1_2__imm_95_7, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 265 /* bvs */, SP::BPICCNT, Convert__Imm1_2__imm_95_7, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 265 /* bvs */, SP::BPXCC, Convert__Imm1_2__imm_95_7, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 265 /* bvs */, SP::BPICC, Convert__Imm1_2__imm_95_7, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 265 /* bvs */, SP::BPXCCANT, Convert__Imm1_3__imm_95_7, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 265 /* bvs */, SP::BPICCANT, Convert__Imm1_3__imm_95_7, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 265 /* bvs */, SP::BPXCCA, Convert__Imm1_3__imm_95_7, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 265 /* bvs */, SP::BPICCA, Convert__Imm1_3__imm_95_7, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 269 /* bz */, SP::BCOND, Convert__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 269 /* bz */, SP::BPXCC, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_Imm }, },
  { 269 /* bz */, SP::BCONDA, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 269 /* bz */, SP::BPICC, Convert__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 269 /* bz */, SP::BPXCCA, Convert__Imm1_2__imm_95_1, AMFBS_None, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 269 /* bz */, SP::BPICCA, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 269 /* bz */, SP::BPXCCNT, Convert__Imm1_2__imm_95_1, AMFBS_None, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 269 /* bz */, SP::BPICCNT, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 269 /* bz */, SP::BPXCC, Convert__Imm1_2__imm_95_1, AMFBS_None, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 269 /* bz */, SP::BPICC, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 269 /* bz */, SP::BPXCCANT, Convert__Imm1_3__imm_95_1, AMFBS_None, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 269 /* bz */, SP::BPICCANT, Convert__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 269 /* bz */, SP::BPXCCA, Convert__Imm1_3__imm_95_1, AMFBS_None, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 269 /* bz */, SP::BPICCA, Convert__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 272 /* call */, SP::CALL, Convert__CallTarget1_0, AMFBS_None, { MCK_CallTarget }, },
  { 272 /* call */, SP::JMPLri, Convert__regO7__MEMri2_0, AMFBS_None, { MCK_MEMri }, },
  { 272 /* call */, SP::JMPLrr, Convert__regO7__MEMrr2_0, AMFBS_None, { MCK_MEMrr }, },
  { 272 /* call */, SP::TLS_CALL, Convert__CallTarget1_0__TailRelocSymCall_TLS1_1, AMFBS_None, { MCK_CallTarget, MCK_TailRelocSymCall_TLS }, },
  { 277 /* cas */, SP::CASArr, Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_128, AMFBS_HasV9, { MCK__91_, MCK_IntRegs, MCK__93_, MCK_IntRegs, MCK_IntRegs }, },
  { 281 /* casa */, SP::CASAri, Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1, AMFBS_HasV9, { MCK__91_, MCK_IntRegs, MCK__93_, MCK__PCT_asi, MCK_IntRegs, MCK_IntRegs }, },
  { 281 /* casa */, SP::CASArr, Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1__ASITag1_3, AMFBS_HasCASA, { MCK__91_, MCK_IntRegs, MCK__93_, MCK_ASITag, MCK_IntRegs, MCK_IntRegs }, },
  { 286 /* casl */, SP::CASArr, Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_136, AMFBS_HasV9, { MCK__91_, MCK_IntRegs, MCK__93_, MCK_IntRegs, MCK_IntRegs }, },
  { 291 /* casx */, SP::CASXArr, Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_128, AMFBS_HasV9, { MCK__91_, MCK_IntRegs, MCK__93_, MCK_IntRegs, MCK_IntRegs }, },
  { 296 /* casxa */, SP::CASXAri, Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1, AMFBS_HasV9, { MCK__91_, MCK_IntRegs, MCK__93_, MCK__PCT_asi, MCK_IntRegs, MCK_IntRegs }, },
  { 296 /* casxa */, SP::CASXArr, Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1__ASITag1_3, AMFBS_HasV9, { MCK__91_, MCK_IntRegs, MCK__93_, MCK_ASITag, MCK_IntRegs, MCK_IntRegs }, },
  { 302 /* casxl */, SP::CASXArr, Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_136, AMFBS_HasV9, { MCK__91_, MCK_IntRegs, MCK__93_, MCK_IntRegs, MCK_IntRegs }, },
  { 308 /* cb */, SP::CBCOND, Convert__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 308 /* cb */, SP::CBCONDA, Convert__Imm1_1__imm_95_8, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 308 /* cb */, SP::CBCOND, Convert__Imm1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Imm }, },
  { 308 /* cb */, SP::CBCONDA, Convert__Imm1_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_a, MCK_Imm }, },
  { 311 /* cb0 */, SP::CBCOND, Convert__Imm1_0__imm_95_9, AMFBS_None, { MCK_Imm }, },
  { 311 /* cb0 */, SP::CBCONDA, Convert__Imm1_1__imm_95_9, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 315 /* cb01 */, SP::CBCOND, Convert__Imm1_0__imm_95_13, AMFBS_None, { MCK_Imm }, },
  { 315 /* cb01 */, SP::CBCONDA, Convert__Imm1_1__imm_95_13, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 320 /* cb012 */, SP::CBCOND, Convert__Imm1_0__imm_95_15, AMFBS_None, { MCK_Imm }, },
  { 320 /* cb012 */, SP::CBCONDA, Convert__Imm1_1__imm_95_15, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 326 /* cb013 */, SP::CBCOND, Convert__Imm1_0__imm_95_14, AMFBS_None, { MCK_Imm }, },
  { 326 /* cb013 */, SP::CBCONDA, Convert__Imm1_1__imm_95_14, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 332 /* cb02 */, SP::CBCOND, Convert__Imm1_0__imm_95_11, AMFBS_None, { MCK_Imm }, },
  { 332 /* cb02 */, SP::CBCONDA, Convert__Imm1_1__imm_95_11, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 337 /* cb023 */, SP::CBCOND, Convert__Imm1_0__imm_95_12, AMFBS_None, { MCK_Imm }, },
  { 337 /* cb023 */, SP::CBCONDA, Convert__Imm1_1__imm_95_12, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 343 /* cb03 */, SP::CBCOND, Convert__Imm1_0__imm_95_10, AMFBS_None, { MCK_Imm }, },
  { 343 /* cb03 */, SP::CBCONDA, Convert__Imm1_1__imm_95_10, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 348 /* cb1 */, SP::CBCOND, Convert__Imm1_0__imm_95_4, AMFBS_None, { MCK_Imm }, },
  { 348 /* cb1 */, SP::CBCONDA, Convert__Imm1_1__imm_95_4, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 352 /* cb12 */, SP::CBCOND, Convert__Imm1_0__imm_95_2, AMFBS_None, { MCK_Imm }, },
  { 352 /* cb12 */, SP::CBCONDA, Convert__Imm1_1__imm_95_2, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 357 /* cb123 */, SP::CBCOND, Convert__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 357 /* cb123 */, SP::CBCONDA, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 363 /* cb13 */, SP::CBCOND, Convert__Imm1_0__imm_95_3, AMFBS_None, { MCK_Imm }, },
  { 363 /* cb13 */, SP::CBCONDA, Convert__Imm1_1__imm_95_3, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 368 /* cb2 */, SP::CBCOND, Convert__Imm1_0__imm_95_6, AMFBS_None, { MCK_Imm }, },
  { 368 /* cb2 */, SP::CBCONDA, Convert__Imm1_1__imm_95_6, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 372 /* cb23 */, SP::CBCOND, Convert__Imm1_0__imm_95_5, AMFBS_None, { MCK_Imm }, },
  { 372 /* cb23 */, SP::CBCONDA, Convert__Imm1_1__imm_95_5, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 377 /* cb3 */, SP::CBCOND, Convert__Imm1_0__imm_95_7, AMFBS_None, { MCK_Imm }, },
  { 377 /* cb3 */, SP::CBCONDA, Convert__Imm1_1__imm_95_7, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 381 /* cba */, SP::CBCOND, Convert__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 381 /* cba */, SP::CBCONDA, Convert__Imm1_1__imm_95_8, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 385 /* cbn */, SP::CBCOND, Convert__Imm1_0__imm_95_0, AMFBS_None, { MCK_Imm }, },
  { 385 /* cbn */, SP::CBCONDA, Convert__Imm1_1__imm_95_0, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 389 /* clr */, SP::ORrr, Convert__Reg1_0__regG0__regG0, AMFBS_None, { MCK_IntRegs }, },
  { 389 /* clr */, SP::STri, Convert__MEMri2_1__regG0, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 389 /* clr */, SP::STrr, Convert__MEMrr2_1__regG0, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 393 /* clrb */, SP::STBri, Convert__MEMri2_1__regG0, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 393 /* clrb */, SP::STBrr, Convert__MEMrr2_1__regG0, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 398 /* clrh */, SP::STHri, Convert__MEMri2_1__regG0, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 398 /* clrh */, SP::STHrr, Convert__MEMrr2_1__regG0, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 403 /* cmask16 */, SP::CMASK16, Convert__Reg1_0, AMFBS_HasVIS3, { MCK_IntRegs }, },
  { 411 /* cmask32 */, SP::CMASK32, Convert__Reg1_0, AMFBS_HasVIS3, { MCK_IntRegs }, },
  { 419 /* cmask8 */, SP::CMASK8, Convert__Reg1_0, AMFBS_HasVIS3, { MCK_IntRegs }, },
  { 426 /* cmp */, SP::SUBCCrr, Convert__regG0__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 426 /* cmp */, SP::SUBCCri, Convert__regG0__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm }, },
  { 430 /* dec */, SP::SUBri, Convert__Reg1_0__Reg1_0__imm_95_1, AMFBS_None, { MCK_IntRegs }, },
  { 430 /* dec */, SP::SUBri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 434 /* deccc */, SP::SUBCCri, Convert__Reg1_0__Reg1_0__imm_95_1, AMFBS_None, { MCK_IntRegs }, },
  { 434 /* deccc */, SP::SUBCCri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 440 /* done */, SP::DONE, Convert_NoOperands, AMFBS_HasV9, {  }, },
  { 445 /* edge16 */, SP::EDGE16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 452 /* edge16l */, SP::EDGE16L, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 460 /* edge16ln */, SP::EDGE16LN, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 469 /* edge16n */, SP::EDGE16N, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 477 /* edge32 */, SP::EDGE32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 484 /* edge32l */, SP::EDGE32L, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 492 /* edge32ln */, SP::EDGE32LN, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 501 /* edge32n */, SP::EDGE32N, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 509 /* edge8 */, SP::EDGE8, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 515 /* edge8l */, SP::EDGE8L, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 522 /* edge8ln */, SP::EDGE8LN, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 530 /* edge8n */, SP::EDGE8N, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 537 /* fabsd */, SP::FABSD, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 543 /* fabsq */, SP::FABSQ, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_QFPRegs, MCK_QFPRegs }, },
  { 549 /* fabss */, SP::FABSS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 555 /* faddd */, SP::FADDD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 561 /* faddq */, SP::FADDQ, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_QFPRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 567 /* fadds */, SP::FADDS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 573 /* faligndata */, SP::FALIGNADATA, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 584 /* fand */, SP::FAND, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 589 /* fandnot1 */, SP::FANDNOT1, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 598 /* fandnot1s */, SP::FANDNOT1S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 608 /* fandnot2 */, SP::FANDNOT2, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 617 /* fandnot2s */, SP::FANDNOT2S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 627 /* fands */, SP::FANDS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 633 /* fb */, SP::FBCOND, Convert__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 633 /* fb */, SP::FBCONDA, Convert__Imm1_1__imm_95_8, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 633 /* fb */, SP::BPFCC, Convert__Imm1_1__imm_95_8__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 633 /* fb */, SP::FBCOND, Convert__Imm1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Imm }, },
  { 633 /* fb */, SP::BPFCCA, Convert__Imm1_2__imm_95_8__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 633 /* fb */, SP::BPFCCNT, Convert__Imm1_2__imm_95_8__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 633 /* fb */, SP::BPFCC, Convert__Imm1_2__imm_95_8__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 633 /* fb */, SP::FBCONDA, Convert__Imm1_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_a, MCK_Imm }, },
  { 633 /* fb */, SP::FBCOND_V9, Convert__Imm1_2__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCC0, MCK_Imm }, },
  { 633 /* fb */, SP::BPFCC, Convert__Imm1_2__Imm1_0__Reg1_1, AMFBS_HasV9, { MCK_Imm, MCK_FCCRegs, MCK_Imm }, },
  { 633 /* fb */, SP::BPFCCANT, Convert__Imm1_3__imm_95_8__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 633 /* fb */, SP::BPFCCA, Convert__Imm1_3__imm_95_8__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 633 /* fb */, SP::FBCONDA_V9, Convert__Imm1_3__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_a, MCK_FCC0, MCK_Imm }, },
  { 633 /* fb */, SP::BPFCCA, Convert__Imm1_3__Imm1_0__Reg1_2, AMFBS_HasV9, { MCK_Imm, MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 633 /* fb */, SP::BPFCCNT, Convert__Imm1_3__Imm1_0__Reg1_2, AMFBS_HasV9, { MCK_Imm, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 633 /* fb */, SP::BPFCCANT, Convert__Imm1_4__Imm1_0__Reg1_3, AMFBS_HasV9, { MCK_Imm, MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 636 /* fba */, SP::FBCOND, Convert__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 636 /* fba */, SP::FBCONDA, Convert__Imm1_1__imm_95_8, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 636 /* fba */, SP::BPFCC, Convert__Imm1_1__imm_95_8__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 636 /* fba */, SP::BPFCCA, Convert__Imm1_2__imm_95_8__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 636 /* fba */, SP::BPFCCNT, Convert__Imm1_2__imm_95_8__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 636 /* fba */, SP::BPFCC, Convert__Imm1_2__imm_95_8__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 636 /* fba */, SP::BPFCCANT, Convert__Imm1_3__imm_95_8__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 636 /* fba */, SP::BPFCCA, Convert__Imm1_3__imm_95_8__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 640 /* fbe */, SP::FBCOND, Convert__Imm1_0__imm_95_9, AMFBS_None, { MCK_Imm }, },
  { 640 /* fbe */, SP::FBCONDA, Convert__Imm1_1__imm_95_9, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 640 /* fbe */, SP::BPFCC, Convert__Imm1_1__imm_95_9__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 640 /* fbe */, SP::BPFCCA, Convert__Imm1_2__imm_95_9__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 640 /* fbe */, SP::BPFCCNT, Convert__Imm1_2__imm_95_9__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 640 /* fbe */, SP::BPFCC, Convert__Imm1_2__imm_95_9__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 640 /* fbe */, SP::BPFCCANT, Convert__Imm1_3__imm_95_9__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 640 /* fbe */, SP::BPFCCA, Convert__Imm1_3__imm_95_9__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 644 /* fbg */, SP::FBCOND, Convert__Imm1_0__imm_95_6, AMFBS_None, { MCK_Imm }, },
  { 644 /* fbg */, SP::FBCONDA, Convert__Imm1_1__imm_95_6, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 644 /* fbg */, SP::BPFCC, Convert__Imm1_1__imm_95_6__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 644 /* fbg */, SP::BPFCCA, Convert__Imm1_2__imm_95_6__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 644 /* fbg */, SP::BPFCCNT, Convert__Imm1_2__imm_95_6__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 644 /* fbg */, SP::BPFCC, Convert__Imm1_2__imm_95_6__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 644 /* fbg */, SP::BPFCCANT, Convert__Imm1_3__imm_95_6__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 644 /* fbg */, SP::BPFCCA, Convert__Imm1_3__imm_95_6__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 648 /* fbge */, SP::FBCOND, Convert__Imm1_0__imm_95_11, AMFBS_None, { MCK_Imm }, },
  { 648 /* fbge */, SP::FBCONDA, Convert__Imm1_1__imm_95_11, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 648 /* fbge */, SP::BPFCC, Convert__Imm1_1__imm_95_11__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 648 /* fbge */, SP::BPFCCA, Convert__Imm1_2__imm_95_11__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 648 /* fbge */, SP::BPFCCNT, Convert__Imm1_2__imm_95_11__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 648 /* fbge */, SP::BPFCC, Convert__Imm1_2__imm_95_11__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 648 /* fbge */, SP::BPFCCANT, Convert__Imm1_3__imm_95_11__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 648 /* fbge */, SP::BPFCCA, Convert__Imm1_3__imm_95_11__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 653 /* fbl */, SP::FBCOND, Convert__Imm1_0__imm_95_4, AMFBS_None, { MCK_Imm }, },
  { 653 /* fbl */, SP::FBCONDA, Convert__Imm1_1__imm_95_4, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 653 /* fbl */, SP::BPFCC, Convert__Imm1_1__imm_95_4__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 653 /* fbl */, SP::BPFCCA, Convert__Imm1_2__imm_95_4__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 653 /* fbl */, SP::BPFCCNT, Convert__Imm1_2__imm_95_4__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 653 /* fbl */, SP::BPFCC, Convert__Imm1_2__imm_95_4__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 653 /* fbl */, SP::BPFCCANT, Convert__Imm1_3__imm_95_4__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 653 /* fbl */, SP::BPFCCA, Convert__Imm1_3__imm_95_4__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 657 /* fble */, SP::FBCOND, Convert__Imm1_0__imm_95_13, AMFBS_None, { MCK_Imm }, },
  { 657 /* fble */, SP::FBCONDA, Convert__Imm1_1__imm_95_13, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 657 /* fble */, SP::BPFCC, Convert__Imm1_1__imm_95_13__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 657 /* fble */, SP::BPFCCA, Convert__Imm1_2__imm_95_13__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 657 /* fble */, SP::BPFCCNT, Convert__Imm1_2__imm_95_13__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 657 /* fble */, SP::BPFCC, Convert__Imm1_2__imm_95_13__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 657 /* fble */, SP::BPFCCANT, Convert__Imm1_3__imm_95_13__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 657 /* fble */, SP::BPFCCA, Convert__Imm1_3__imm_95_13__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 662 /* fblg */, SP::FBCOND, Convert__Imm1_0__imm_95_2, AMFBS_None, { MCK_Imm }, },
  { 662 /* fblg */, SP::FBCONDA, Convert__Imm1_1__imm_95_2, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 662 /* fblg */, SP::BPFCC, Convert__Imm1_1__imm_95_2__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 662 /* fblg */, SP::BPFCCA, Convert__Imm1_2__imm_95_2__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 662 /* fblg */, SP::BPFCCNT, Convert__Imm1_2__imm_95_2__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 662 /* fblg */, SP::BPFCC, Convert__Imm1_2__imm_95_2__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 662 /* fblg */, SP::BPFCCANT, Convert__Imm1_3__imm_95_2__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 662 /* fblg */, SP::BPFCCA, Convert__Imm1_3__imm_95_2__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 667 /* fbn */, SP::FBCOND, Convert__Imm1_0__imm_95_0, AMFBS_None, { MCK_Imm }, },
  { 667 /* fbn */, SP::FBCONDA, Convert__Imm1_1__imm_95_0, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 667 /* fbn */, SP::BPFCC, Convert__Imm1_1__imm_95_0__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 667 /* fbn */, SP::BPFCCA, Convert__Imm1_2__imm_95_0__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 667 /* fbn */, SP::BPFCCNT, Convert__Imm1_2__imm_95_0__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 667 /* fbn */, SP::BPFCC, Convert__Imm1_2__imm_95_0__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 667 /* fbn */, SP::BPFCCANT, Convert__Imm1_3__imm_95_0__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 667 /* fbn */, SP::BPFCCA, Convert__Imm1_3__imm_95_0__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 671 /* fbne */, SP::FBCOND, Convert__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 671 /* fbne */, SP::FBCONDA, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 671 /* fbne */, SP::BPFCC, Convert__Imm1_1__imm_95_1__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 671 /* fbne */, SP::BPFCCA, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 671 /* fbne */, SP::BPFCCNT, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 671 /* fbne */, SP::BPFCC, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 671 /* fbne */, SP::BPFCCANT, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 671 /* fbne */, SP::BPFCCA, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 676 /* fbnz */, SP::FBCOND, Convert__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 676 /* fbnz */, SP::FBCONDA, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 676 /* fbnz */, SP::BPFCC, Convert__Imm1_1__imm_95_1__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 676 /* fbnz */, SP::BPFCCA, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 676 /* fbnz */, SP::BPFCCNT, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 676 /* fbnz */, SP::BPFCC, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 676 /* fbnz */, SP::BPFCCANT, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 676 /* fbnz */, SP::BPFCCA, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 681 /* fbo */, SP::FBCOND, Convert__Imm1_0__imm_95_15, AMFBS_None, { MCK_Imm }, },
  { 681 /* fbo */, SP::FBCONDA, Convert__Imm1_1__imm_95_15, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 681 /* fbo */, SP::BPFCC, Convert__Imm1_1__imm_95_15__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 681 /* fbo */, SP::BPFCCA, Convert__Imm1_2__imm_95_15__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 681 /* fbo */, SP::BPFCCNT, Convert__Imm1_2__imm_95_15__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 681 /* fbo */, SP::BPFCC, Convert__Imm1_2__imm_95_15__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 681 /* fbo */, SP::BPFCCANT, Convert__Imm1_3__imm_95_15__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 681 /* fbo */, SP::BPFCCA, Convert__Imm1_3__imm_95_15__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 685 /* fbu */, SP::FBCOND, Convert__Imm1_0__imm_95_7, AMFBS_None, { MCK_Imm }, },
  { 685 /* fbu */, SP::FBCONDA, Convert__Imm1_1__imm_95_7, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 685 /* fbu */, SP::BPFCC, Convert__Imm1_1__imm_95_7__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 685 /* fbu */, SP::BPFCCA, Convert__Imm1_2__imm_95_7__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 685 /* fbu */, SP::BPFCCNT, Convert__Imm1_2__imm_95_7__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 685 /* fbu */, SP::BPFCC, Convert__Imm1_2__imm_95_7__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 685 /* fbu */, SP::BPFCCANT, Convert__Imm1_3__imm_95_7__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 685 /* fbu */, SP::BPFCCA, Convert__Imm1_3__imm_95_7__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 689 /* fbue */, SP::FBCOND, Convert__Imm1_0__imm_95_10, AMFBS_None, { MCK_Imm }, },
  { 689 /* fbue */, SP::FBCONDA, Convert__Imm1_1__imm_95_10, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 689 /* fbue */, SP::BPFCC, Convert__Imm1_1__imm_95_10__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 689 /* fbue */, SP::BPFCCA, Convert__Imm1_2__imm_95_10__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 689 /* fbue */, SP::BPFCCNT, Convert__Imm1_2__imm_95_10__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 689 /* fbue */, SP::BPFCC, Convert__Imm1_2__imm_95_10__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 689 /* fbue */, SP::BPFCCANT, Convert__Imm1_3__imm_95_10__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 689 /* fbue */, SP::BPFCCA, Convert__Imm1_3__imm_95_10__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 694 /* fbug */, SP::FBCOND, Convert__Imm1_0__imm_95_5, AMFBS_None, { MCK_Imm }, },
  { 694 /* fbug */, SP::FBCONDA, Convert__Imm1_1__imm_95_5, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 694 /* fbug */, SP::BPFCC, Convert__Imm1_1__imm_95_5__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 694 /* fbug */, SP::BPFCCA, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 694 /* fbug */, SP::BPFCCNT, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 694 /* fbug */, SP::BPFCC, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 694 /* fbug */, SP::BPFCCANT, Convert__Imm1_3__imm_95_5__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 694 /* fbug */, SP::BPFCCA, Convert__Imm1_3__imm_95_5__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 699 /* fbuge */, SP::FBCOND, Convert__Imm1_0__imm_95_12, AMFBS_None, { MCK_Imm }, },
  { 699 /* fbuge */, SP::FBCONDA, Convert__Imm1_1__imm_95_12, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 699 /* fbuge */, SP::BPFCC, Convert__Imm1_1__imm_95_12__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 699 /* fbuge */, SP::BPFCCA, Convert__Imm1_2__imm_95_12__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 699 /* fbuge */, SP::BPFCCNT, Convert__Imm1_2__imm_95_12__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 699 /* fbuge */, SP::BPFCC, Convert__Imm1_2__imm_95_12__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 699 /* fbuge */, SP::BPFCCANT, Convert__Imm1_3__imm_95_12__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 699 /* fbuge */, SP::BPFCCA, Convert__Imm1_3__imm_95_12__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 705 /* fbul */, SP::FBCOND, Convert__Imm1_0__imm_95_3, AMFBS_None, { MCK_Imm }, },
  { 705 /* fbul */, SP::FBCONDA, Convert__Imm1_1__imm_95_3, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 705 /* fbul */, SP::BPFCC, Convert__Imm1_1__imm_95_3__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 705 /* fbul */, SP::BPFCCA, Convert__Imm1_2__imm_95_3__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 705 /* fbul */, SP::BPFCCNT, Convert__Imm1_2__imm_95_3__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 705 /* fbul */, SP::BPFCC, Convert__Imm1_2__imm_95_3__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 705 /* fbul */, SP::BPFCCANT, Convert__Imm1_3__imm_95_3__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 705 /* fbul */, SP::BPFCCA, Convert__Imm1_3__imm_95_3__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 710 /* fbule */, SP::FBCOND, Convert__Imm1_0__imm_95_14, AMFBS_None, { MCK_Imm }, },
  { 710 /* fbule */, SP::FBCONDA, Convert__Imm1_1__imm_95_14, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 710 /* fbule */, SP::BPFCC, Convert__Imm1_1__imm_95_14__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 710 /* fbule */, SP::BPFCCA, Convert__Imm1_2__imm_95_14__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 710 /* fbule */, SP::BPFCCNT, Convert__Imm1_2__imm_95_14__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 710 /* fbule */, SP::BPFCC, Convert__Imm1_2__imm_95_14__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 710 /* fbule */, SP::BPFCCANT, Convert__Imm1_3__imm_95_14__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 710 /* fbule */, SP::BPFCCA, Convert__Imm1_3__imm_95_14__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 716 /* fbz */, SP::FBCOND, Convert__Imm1_0__imm_95_9, AMFBS_None, { MCK_Imm }, },
  { 716 /* fbz */, SP::FBCONDA, Convert__Imm1_1__imm_95_9, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 716 /* fbz */, SP::BPFCC, Convert__Imm1_1__imm_95_9__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 716 /* fbz */, SP::BPFCCA, Convert__Imm1_2__imm_95_9__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 716 /* fbz */, SP::BPFCCNT, Convert__Imm1_2__imm_95_9__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 716 /* fbz */, SP::BPFCC, Convert__Imm1_2__imm_95_9__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 716 /* fbz */, SP::BPFCCANT, Convert__Imm1_3__imm_95_9__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 716 /* fbz */, SP::BPFCCA, Convert__Imm1_3__imm_95_9__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 720 /* fchksm16 */, SP::FCHKSM16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 729 /* fcmpd */, SP::V9FCMPD, Convert__regFCC0__Reg1_0__Reg1_1, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 729 /* fcmpd */, SP::V9FCMPD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 735 /* fcmped */, SP::V9FCMPED, Convert__regFCC0__Reg1_0__Reg1_1, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 735 /* fcmped */, SP::V9FCMPED, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 742 /* fcmpeq */, SP::V9FCMPEQ, Convert__regFCC0__Reg1_0__Reg1_1, AMFBS_None, { MCK_QFPRegs, MCK_QFPRegs }, },
  { 742 /* fcmpeq */, SP::V9FCMPEQ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 749 /* fcmpeq16 */, SP::FCMPEQ16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 758 /* fcmpeq32 */, SP::FCMPEQ32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 767 /* fcmpes */, SP::V9FCMPES, Convert__regFCC0__Reg1_0__Reg1_1, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 767 /* fcmpes */, SP::V9FCMPES, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 774 /* fcmpgt16 */, SP::FCMPGT16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 783 /* fcmpgt32 */, SP::FCMPGT32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 792 /* fcmple16 */, SP::FCMPLE16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 801 /* fcmple32 */, SP::FCMPLE32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 810 /* fcmpne16 */, SP::FCMPNE16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 819 /* fcmpne32 */, SP::FCMPNE32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 828 /* fcmpq */, SP::V9FCMPQ, Convert__regFCC0__Reg1_0__Reg1_1, AMFBS_None, { MCK_QFPRegs, MCK_QFPRegs }, },
  { 828 /* fcmpq */, SP::V9FCMPQ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 834 /* fcmps */, SP::V9FCMPS, Convert__regFCC0__Reg1_0__Reg1_1, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 834 /* fcmps */, SP::V9FCMPS, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 840 /* fdivd */, SP::FDIVD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 846 /* fdivq */, SP::FDIVQ, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_QFPRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 852 /* fdivs */, SP::FDIVS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 858 /* fdmulq */, SP::FDMULQ, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs, MCK_QFPRegs }, },
  { 865 /* fdtoi */, SP::FDTOI, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK_FPRegs }, },
  { 871 /* fdtoq */, SP::FDTOQ, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK_QFPRegs }, },
  { 877 /* fdtos */, SP::FDTOS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK_FPRegs }, },
  { 883 /* fdtox */, SP::FDTOX, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 889 /* fexpand */, SP::FEXPAND, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 897 /* fhaddd */, SP::FHADDD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 904 /* fhadds */, SP::FHADDS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 911 /* fhsubd */, SP::FHSUBD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 918 /* fhsubs */, SP::FHSUBS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 925 /* fitod */, SP::FITOD, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_DFPRegs }, },
  { 931 /* fitoq */, SP::FITOQ, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_QFPRegs }, },
  { 937 /* fitos */, SP::FITOS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 943 /* flcmpd */, SP::FLCMPD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVIS3, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 950 /* flcmps */, SP::FLCMPS, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVIS3, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 957 /* flush */, SP::FLUSH, Convert_NoOperands, AMFBS_None, {  }, },
  { 957 /* flush */, SP::FLUSH, Convert_NoOperands, AMFBS_None, { MCK_G0 }, },
  { 957 /* flush */, SP::FLUSHri, Convert__MEMri2_0, AMFBS_None, { MCK_MEMri }, },
  { 957 /* flush */, SP::FLUSHrr, Convert__MEMrr2_0, AMFBS_None, { MCK_MEMrr }, },
  { 963 /* flushw */, SP::FLUSHW, Convert_NoOperands, AMFBS_HasV9, {  }, },
  { 970 /* fmean16 */, SP::FMEAN16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 978 /* fmovd */, SP::FMOVD, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 978 /* fmovd */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 978 /* fmovd */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 978 /* fmovd */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 978 /* fmovd */, SP::FMOVD_XCC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 978 /* fmovd */, SP::FMOVD_FCC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCC0, MCK_DFPRegs, MCK_DFPRegs }, },
  { 978 /* fmovd */, SP::FMOVD_ICC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 978 /* fmovd */, SP::V9FMOVD_FCC, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 984 /* fmovda */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 984 /* fmovda */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 984 /* fmovda */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 991 /* fmovdcc */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 991 /* fmovdcc */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 999 /* fmovdcs */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 999 /* fmovdcs */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1007 /* fmovde */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1007 /* fmovde */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1007 /* fmovde */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1014 /* fmovdeq */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1014 /* fmovdeq */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1022 /* fmovdg */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1022 /* fmovdg */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1022 /* fmovdg */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1029 /* fmovdge */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1029 /* fmovdge */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1029 /* fmovdge */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1037 /* fmovdgeu */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1037 /* fmovdgeu */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1046 /* fmovdgt */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1046 /* fmovdgt */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1054 /* fmovdgu */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1054 /* fmovdgu */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1062 /* fmovdl */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1062 /* fmovdl */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1062 /* fmovdl */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1069 /* fmovdle */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1069 /* fmovdle */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1069 /* fmovdle */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1077 /* fmovdleu */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1077 /* fmovdleu */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1086 /* fmovdlg */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1094 /* fmovdlt */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1094 /* fmovdlt */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1102 /* fmovdlu */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1102 /* fmovdlu */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1110 /* fmovdn */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1110 /* fmovdn */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1110 /* fmovdn */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1117 /* fmovdne */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1117 /* fmovdne */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1117 /* fmovdne */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1125 /* fmovdneg */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1125 /* fmovdneg */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1134 /* fmovdnz */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1134 /* fmovdnz */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1134 /* fmovdnz */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1142 /* fmovdo */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1149 /* fmovdpos */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1149 /* fmovdpos */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1158 /* fmovdu */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1165 /* fmovdue */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1173 /* fmovdug */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1181 /* fmovduge */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1190 /* fmovdul */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1198 /* fmovdule */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1207 /* fmovdvc */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1207 /* fmovdvc */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1215 /* fmovdvs */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1215 /* fmovdvs */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1223 /* fmovdz */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1223 /* fmovdz */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1223 /* fmovdz */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1230 /* fmovq */, SP::FMOVQ, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_QFPRegs, MCK_QFPRegs }, },
  { 1230 /* fmovq */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1230 /* fmovq */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1230 /* fmovq */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1230 /* fmovq */, SP::FMOVQ_XCC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1230 /* fmovq */, SP::FMOVQ_FCC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCC0, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1230 /* fmovq */, SP::FMOVQ_ICC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1230 /* fmovq */, SP::V9FMOVQ_FCC, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1236 /* fmovqa */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1236 /* fmovqa */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1236 /* fmovqa */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1243 /* fmovqcc */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1243 /* fmovqcc */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1251 /* fmovqcs */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1251 /* fmovqcs */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1259 /* fmovqe */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1259 /* fmovqe */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1259 /* fmovqe */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1266 /* fmovqeq */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1266 /* fmovqeq */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1274 /* fmovqg */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1274 /* fmovqg */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1274 /* fmovqg */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1281 /* fmovqge */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1281 /* fmovqge */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1281 /* fmovqge */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1289 /* fmovqgeu */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1289 /* fmovqgeu */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1298 /* fmovqgt */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1298 /* fmovqgt */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1306 /* fmovqgu */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1306 /* fmovqgu */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1314 /* fmovql */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1314 /* fmovql */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1314 /* fmovql */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1321 /* fmovqle */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1321 /* fmovqle */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1321 /* fmovqle */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1329 /* fmovqleu */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1329 /* fmovqleu */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1338 /* fmovqlg */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1346 /* fmovqlt */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1346 /* fmovqlt */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1354 /* fmovqlu */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1354 /* fmovqlu */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1362 /* fmovqn */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1362 /* fmovqn */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1362 /* fmovqn */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1369 /* fmovqne */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1369 /* fmovqne */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1369 /* fmovqne */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1377 /* fmovqneg */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1377 /* fmovqneg */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1386 /* fmovqnz */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1386 /* fmovqnz */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1386 /* fmovqnz */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1394 /* fmovqo */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1401 /* fmovqpos */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1401 /* fmovqpos */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1410 /* fmovqu */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1417 /* fmovque */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1425 /* fmovqug */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1433 /* fmovquge */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1442 /* fmovqul */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1450 /* fmovqule */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1459 /* fmovqvc */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1459 /* fmovqvc */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1467 /* fmovqvs */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1467 /* fmovqvs */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1475 /* fmovqz */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1475 /* fmovqz */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1475 /* fmovqz */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1482 /* fmovrd */, SP::FMOVRD, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1489 /* fmovrde */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1497 /* fmovrdgez */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_None, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1507 /* fmovrdgz */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_None, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1516 /* fmovrdlez */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_None, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1526 /* fmovrdlz */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1535 /* fmovrdne */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1544 /* fmovrdnz */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1553 /* fmovrdz */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1561 /* fmovrq */, SP::FMOVRQ, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1568 /* fmovrqe */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1576 /* fmovrqgez */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_None, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1586 /* fmovrqgz */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_None, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1595 /* fmovrqlez */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_None, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1605 /* fmovrqlz */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1614 /* fmovrqne */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1623 /* fmovrqnz */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1632 /* fmovrqz */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1640 /* fmovrs */, SP::FMOVRS, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1647 /* fmovrse */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1655 /* fmovrsgez */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_None, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1665 /* fmovrsgz */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_None, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1674 /* fmovrslez */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_None, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1684 /* fmovrslz */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1693 /* fmovrsne */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1702 /* fmovrsnz */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1711 /* fmovrsz */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1719 /* fmovs */, SP::FMOVS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 1719 /* fmovs */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1719 /* fmovs */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1719 /* fmovs */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1719 /* fmovs */, SP::FMOVS_XCC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1719 /* fmovs */, SP::FMOVS_FCC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCC0, MCK_FPRegs, MCK_FPRegs }, },
  { 1719 /* fmovs */, SP::FMOVS_ICC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1719 /* fmovs */, SP::V9FMOVS_FCC, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1725 /* fmovsa */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1725 /* fmovsa */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1725 /* fmovsa */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1732 /* fmovscc */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1732 /* fmovscc */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1740 /* fmovscs */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1740 /* fmovscs */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1748 /* fmovse */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1748 /* fmovse */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1748 /* fmovse */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1755 /* fmovseq */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1755 /* fmovseq */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1763 /* fmovsg */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1763 /* fmovsg */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1763 /* fmovsg */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1770 /* fmovsge */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1770 /* fmovsge */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1770 /* fmovsge */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1778 /* fmovsgeu */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1778 /* fmovsgeu */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1787 /* fmovsgt */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1787 /* fmovsgt */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1795 /* fmovsgu */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1795 /* fmovsgu */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1803 /* fmovsl */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1803 /* fmovsl */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1803 /* fmovsl */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1810 /* fmovsle */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1810 /* fmovsle */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1810 /* fmovsle */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1818 /* fmovsleu */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1818 /* fmovsleu */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1827 /* fmovslg */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1835 /* fmovslt */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1835 /* fmovslt */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1843 /* fmovslu */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1843 /* fmovslu */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1851 /* fmovsn */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1851 /* fmovsn */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1851 /* fmovsn */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1858 /* fmovsne */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1858 /* fmovsne */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1858 /* fmovsne */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1866 /* fmovsneg */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1866 /* fmovsneg */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1875 /* fmovsnz */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1875 /* fmovsnz */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1875 /* fmovsnz */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1883 /* fmovso */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1890 /* fmovspos */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1890 /* fmovspos */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1899 /* fmovsu */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1906 /* fmovsue */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1914 /* fmovsug */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1922 /* fmovsuge */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1931 /* fmovsul */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1939 /* fmovsule */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1948 /* fmovsvc */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1948 /* fmovsvc */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1956 /* fmovsvs */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1956 /* fmovsvs */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1964 /* fmovsz */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 1964 /* fmovsz */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 1964 /* fmovsz */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1971 /* fmul8sux16 */, SP::FMUL8SUX16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1982 /* fmul8ulx16 */, SP::FMUL8ULX16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1993 /* fmul8x16 */, SP::FMUL8X16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2002 /* fmul8x16al */, SP::FMUL8X16AL, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2013 /* fmul8x16au */, SP::FMUL8X16AU, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2024 /* fmuld */, SP::FMULD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2030 /* fmuld8sux16 */, SP::FMULD8SUX16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2042 /* fmuld8ulx16 */, SP::FMULD8ULX16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2054 /* fmulq */, SP::FMULQ, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_QFPRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 2060 /* fmuls */, SP::FMULS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2066 /* fnaddd */, SP::FNADDD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2073 /* fnadds */, SP::FNADDS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2080 /* fnand */, SP::FNAND, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2086 /* fnands */, SP::FNANDS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2093 /* fnegd */, SP::FNEGD, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2099 /* fnegq */, SP::FNEGQ, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_QFPRegs, MCK_QFPRegs }, },
  { 2105 /* fnegs */, SP::FNEGS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 2111 /* fnhaddd */, SP::FNHADDD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2111 /* fnhaddd */, SP::FNMULD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2119 /* fnhadds */, SP::FNHADDS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2119 /* fnhadds */, SP::FNMULS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2119 /* fnhadds */, SP::FNSMULD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2127 /* fnor */, SP::FNOR, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2132 /* fnors */, SP::FNORS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2138 /* fnot1 */, SP::FNOT1, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2144 /* fnot1s */, SP::FNOT1S, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs }, },
  { 2151 /* fnot2 */, SP::FNOT2, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2157 /* fnot2s */, SP::FNOT2S, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs }, },
  { 2164 /* fone */, SP::FONE, Convert__Reg1_0__Tie0_1_1, AMFBS_HasVIS, { MCK_DFPRegs }, },
  { 2169 /* fones */, SP::FONES, Convert__Reg1_0__Tie0_1_1, AMFBS_HasVIS, { MCK_FPRegs }, },
  { 2175 /* for */, SP::FOR, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2179 /* fornot1 */, SP::FORNOT1, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2187 /* fornot1s */, SP::FORNOT1S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2196 /* fornot2 */, SP::FORNOT2, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2204 /* fornot2s */, SP::FORNOT2S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2213 /* fors */, SP::FORS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2218 /* fpack16 */, SP::FPACK16, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2226 /* fpack32 */, SP::FPACK32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2234 /* fpackfix */, SP::FPACKFIX, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2243 /* fpadd16 */, SP::FPADD16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2251 /* fpadd16s */, SP::FPADD16S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2260 /* fpadd32 */, SP::FPADD32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2268 /* fpadd32s */, SP::FPADD32S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2277 /* fpadd64 */, SP::FPADD64, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2285 /* fpmerge */, SP::FPMERGE, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2293 /* fpsub16 */, SP::FPSUB16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2301 /* fpsub16S */, SP::FPSUB16S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2310 /* fpsub32 */, SP::FPSUB32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2318 /* fpsub32S */, SP::FPSUB32S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2327 /* fqtod */, SP::FQTOD, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_QFPRegs, MCK_DFPRegs }, },
  { 2333 /* fqtoi */, SP::FQTOI, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_QFPRegs, MCK_FPRegs }, },
  { 2339 /* fqtos */, SP::FQTOS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_QFPRegs, MCK_FPRegs }, },
  { 2345 /* fqtox */, SP::FQTOX, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_QFPRegs, MCK_DFPRegs }, },
  { 2351 /* fslas16 */, SP::FSLAS16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2359 /* fslas32 */, SP::FSLAS32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2367 /* fsll16 */, SP::FSLL16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2374 /* fsll32 */, SP::FSLL32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2381 /* fsmuld */, SP::FSMULD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_FPRegs, MCK_FPRegs, MCK_DFPRegs }, },
  { 2388 /* fsqrtd */, SP::FSQRTD, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2395 /* fsqrtq */, SP::FSQRTQ, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_QFPRegs, MCK_QFPRegs }, },
  { 2402 /* fsqrts */, SP::FSQRTS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 2409 /* fsra16 */, SP::FSRA16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2416 /* fsra32 */, SP::FSRA32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2423 /* fsrc1 */, SP::FSRC1, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2429 /* fsrc1s */, SP::FSRC1S, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs }, },
  { 2436 /* fsrc2 */, SP::FSRC2, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2442 /* fsrc2s */, SP::FSRC2S, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs }, },
  { 2449 /* fsrl16 */, SP::FSRL16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2456 /* fsrl32 */, SP::FSRL32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2463 /* fstod */, SP::FSTOD, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_DFPRegs }, },
  { 2469 /* fstoi */, SP::FSTOI, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 2475 /* fstoq */, SP::FSTOQ, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_QFPRegs }, },
  { 2481 /* fstox */, SP::FSTOX, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_DFPRegs }, },
  { 2487 /* fsubd */, SP::FSUBD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2493 /* fsubq */, SP::FSUBQ, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_QFPRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 2499 /* fsubs */, SP::FSUBS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2505 /* fxnor */, SP::FXNOR, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2511 /* fxnors */, SP::FXNORS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2518 /* fxor */, SP::FXOR, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2523 /* fxors */, SP::FXORS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2529 /* fxtod */, SP::FXTOD, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2535 /* fxtoq */, SP::FXTOQ, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK_QFPRegs }, },
  { 2541 /* fxtos */, SP::FXTOS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK_FPRegs }, },
  { 2547 /* fzero */, SP::FZERO, Convert__Reg1_0__Tie0_1_1, AMFBS_HasVIS, { MCK_DFPRegs }, },
  { 2553 /* fzeros */, SP::FZEROS, Convert__Reg1_0__Tie0_1_1, AMFBS_HasVIS, { MCK_FPRegs }, },
  { 2560 /* inc */, SP::ADDri, Convert__Reg1_0__Reg1_0__imm_95_1, AMFBS_None, { MCK_IntRegs }, },
  { 2560 /* inc */, SP::ADDri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 2564 /* inccc */, SP::ADDCCri, Convert__Reg1_0__Reg1_0__imm_95_1, AMFBS_None, { MCK_IntRegs }, },
  { 2564 /* inccc */, SP::ADDCCri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 2570 /* jmp */, SP::JMPLri, Convert__regG0__MEMri2_0, AMFBS_None, { MCK_MEMri }, },
  { 2570 /* jmp */, SP::JMPLrr, Convert__regG0__MEMrr2_0, AMFBS_None, { MCK_MEMrr }, },
  { 2574 /* jmpl */, SP::JMPLri, Convert__Reg1_1__MEMri2_0, AMFBS_None, { MCK_MEMri, MCK_IntRegs }, },
  { 2574 /* jmpl */, SP::JMPLrr, Convert__Reg1_1__MEMrr2_0, AMFBS_None, { MCK_MEMrr, MCK_IntRegs }, },
  { 2579 /* ld */, SP::LDCSRri, Convert__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_CPSR }, },
  { 2579 /* ld */, SP::LDFSRri, Convert__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_FSR }, },
  { 2579 /* ld */, SP::LDCri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_CoprocRegs }, },
  { 2579 /* ld */, SP::LDFri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_FPRegs }, },
  { 2579 /* ld */, SP::LDri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 2579 /* ld */, SP::LDCSRrr, Convert__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_CPSR }, },
  { 2579 /* ld */, SP::LDFSRrr, Convert__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_FSR }, },
  { 2579 /* ld */, SP::LDCrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_CoprocRegs }, },
  { 2579 /* ld */, SP::LDFrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_FPRegs }, },
  { 2579 /* ld */, SP::LDrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 2579 /* ld */, SP::GDOP_LDrr, Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_GOT1_4, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs, MCK_TailRelocSymLoad_GOT }, },
  { 2579 /* ld */, SP::TLS_LDrr, Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_TLS1_4, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs, MCK_TailRelocSymLoad_TLS }, },
  { 2582 /* lda */, SP::LDFAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_FPRegs }, },
  { 2582 /* lda */, SP::LDAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 2582 /* lda */, SP::LDFArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_HasV9, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_FPRegs }, },
  { 2582 /* lda */, SP::LDArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 2586 /* ldd */, SP::LDDCri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_CoprocPair }, },
  { 2586 /* ldd */, SP::LDDri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntPair }, },
  { 2586 /* ldd */, SP::LDDFri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_DFPRegs }, },
  { 2586 /* ldd */, SP::LDDCrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_CoprocPair }, },
  { 2586 /* ldd */, SP::LDDrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntPair }, },
  { 2586 /* ldd */, SP::LDDFrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_DFPRegs }, },
  { 2590 /* ldda */, SP::LDDAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntPair }, },
  { 2590 /* ldda */, SP::LDDFAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_DFPRegs }, },
  { 2590 /* ldda */, SP::LDDArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntPair }, },
  { 2590 /* ldda */, SP::LDDFArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_HasV9, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_DFPRegs }, },
  { 2595 /* ldq */, SP::LDQFri, Convert__Reg1_3__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK_QFPRegs }, },
  { 2595 /* ldq */, SP::LDQFrr, Convert__Reg1_3__MEMrr2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_QFPRegs }, },
  { 2599 /* ldqa */, SP::LDQFAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_QFPRegs }, },
  { 2599 /* ldqa */, SP::LDQFArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_HasV9, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_QFPRegs }, },
  { 2604 /* ldsb */, SP::LDSBri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 2604 /* ldsb */, SP::LDSBrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 2609 /* ldsba */, SP::LDSBAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 2609 /* ldsba */, SP::LDSBArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 2615 /* ldsh */, SP::LDSHri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 2615 /* ldsh */, SP::LDSHrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 2620 /* ldsha */, SP::LDSHAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 2620 /* ldsha */, SP::LDSHArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 2626 /* ldstub */, SP::LDSTUBri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 2626 /* ldstub */, SP::LDSTUBrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 2633 /* ldstuba */, SP::LDSTUBAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 2633 /* ldstuba */, SP::LDSTUBArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 2641 /* ldsw */, SP::LDSWri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 2641 /* ldsw */, SP::LDSWrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 2646 /* ldswa */, SP::LDSWAri, Convert__Reg1_4__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 2646 /* ldswa */, SP::LDSWArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 2652 /* ldub */, SP::LDUBri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 2652 /* ldub */, SP::LDUBrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 2657 /* lduba */, SP::LDUBAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 2657 /* lduba */, SP::LDUBArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 2663 /* lduh */, SP::LDUHri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 2663 /* lduh */, SP::LDUHrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 2668 /* lduha */, SP::LDUHAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 2668 /* lduha */, SP::LDUHArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 2674 /* ldx */, SP::LDXFSRri, Convert__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK_FSR }, },
  { 2674 /* ldx */, SP::LDXri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 2674 /* ldx */, SP::LDXFSRrr, Convert__MEMrr2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_FSR }, },
  { 2674 /* ldx */, SP::LDXrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 2674 /* ldx */, SP::GDOP_LDXrr, Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_GOT1_4, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs, MCK_TailRelocSymLoad_GOT }, },
  { 2674 /* ldx */, SP::TLS_LDXrr, Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_TLS1_4, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs, MCK_TailRelocSymLoad_TLS }, },
  { 2678 /* ldxa */, SP::LDXAri, Convert__Reg1_4__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 2678 /* ldxa */, SP::LDXArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 2683 /* lzcnt */, SP::LZCNT, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS3, { MCK_IntRegs, MCK_IntRegs }, },
  { 2689 /* membar */, SP::MEMBARi, Convert__MembarTag1_0, AMFBS_HasV9, { MCK_MembarTag }, },
  { 2696 /* mov */, SP::RDPSR, Convert__Reg1_1, AMFBS_None, { MCK_PSR, MCK_IntRegs }, },
  { 2696 /* mov */, SP::RDTBR, Convert__Reg1_1, AMFBS_None, { MCK_TBR, MCK_IntRegs }, },
  { 2696 /* mov */, SP::RDWIM, Convert__Reg1_1, AMFBS_None, { MCK_WIM, MCK_IntRegs }, },
  { 2696 /* mov */, SP::WRPSRrr, Convert__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_PSR }, },
  { 2696 /* mov */, SP::WRTBRrr, Convert__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_TBR }, },
  { 2696 /* mov */, SP::WRWIMrr, Convert__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_WIM }, },
  { 2696 /* mov */, SP::ORrr, Convert__Reg1_1__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 2696 /* mov */, SP::WRASRrr, Convert__Reg1_1__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_ASRRegs }, },
  { 2696 /* mov */, SP::RDASR, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_ASRRegs, MCK_IntRegs }, },
  { 2696 /* mov */, SP::WRPSRri, Convert__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_PSR }, },
  { 2696 /* mov */, SP::WRTBRri, Convert__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_TBR }, },
  { 2696 /* mov */, SP::WRWIMri, Convert__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_WIM }, },
  { 2696 /* mov */, SP::ORri, Convert__Reg1_1__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 2696 /* mov */, SP::WRASRri, Convert__Reg1_1__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_ASRRegs }, },
  { 2696 /* mov */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2696 /* mov */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_8, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2696 /* mov */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2696 /* mov */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2696 /* mov */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2696 /* mov */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2696 /* mov */, SP::MOVXCCrr, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2696 /* mov */, SP::MOVXCCri, Convert__Reg1_3__Imm1_2__Tie0_1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2696 /* mov */, SP::MOVFCCrr, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCC0, MCK_IntRegs, MCK_IntRegs }, },
  { 2696 /* mov */, SP::MOVFCCri, Convert__Reg1_3__Imm1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCC0, MCK_Imm, MCK_IntRegs }, },
  { 2696 /* mov */, SP::MOVICCrr, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2696 /* mov */, SP::MOVICCri, Convert__Reg1_3__Imm1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2696 /* mov */, SP::V9MOVFCCrr, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2696 /* mov */, SP::V9MOVFCCri, Convert__Reg1_3__Reg1_1__Imm1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2700 /* mova */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2700 /* mova */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_8, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2700 /* mova */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2700 /* mova */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2700 /* mova */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2700 /* mova */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2705 /* movcc */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2705 /* movcc */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_13, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2705 /* movcc */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2705 /* movcc */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2711 /* movcs */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2711 /* movcs */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2711 /* movcs */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2711 /* movcs */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2717 /* movdtox */, SP::MOVDTOX, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_IntRegs }, },
  { 2717 /* movdtox */, SP::MOVWTOS, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS3, { MCK_IntRegs, MCK_DFPRegs }, },
  { 2717 /* movdtox */, SP::MOVXTOD, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS3, { MCK_IntRegs, MCK_DFPRegs }, },
  { 2725 /* move */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2725 /* move */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2725 /* move */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2725 /* move */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2725 /* move */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2725 /* move */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2730 /* moveq */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2730 /* moveq */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2730 /* moveq */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2730 /* moveq */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2736 /* movg */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2736 /* movg */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_10, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2736 /* movg */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2736 /* movg */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2736 /* movg */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2736 /* movg */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2741 /* movge */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2741 /* movge */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_11, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2741 /* movge */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2741 /* movge */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2741 /* movge */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2741 /* movge */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2747 /* movgeu */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2747 /* movgeu */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_13, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2747 /* movgeu */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2747 /* movgeu */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2754 /* movgt */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2754 /* movgt */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_10, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2754 /* movgt */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2754 /* movgt */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2760 /* movgu */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2760 /* movgu */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_12, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2760 /* movgu */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2760 /* movgu */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2766 /* movl */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2766 /* movl */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2766 /* movl */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2766 /* movl */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2766 /* movl */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2766 /* movl */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2771 /* movle */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2771 /* movle */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_2, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2771 /* movle */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2771 /* movle */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2771 /* movle */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2771 /* movle */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2777 /* movleu */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2777 /* movleu */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_4, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2777 /* movleu */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2777 /* movleu */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2784 /* movlg */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2784 /* movlg */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2790 /* movlt */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2790 /* movlt */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2790 /* movlt */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2790 /* movlt */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2796 /* movlu */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2796 /* movlu */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2796 /* movlu */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2796 /* movlu */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2802 /* movn */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2802 /* movn */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_0, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2802 /* movn */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2802 /* movn */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2802 /* movn */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2802 /* movn */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2807 /* movne */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2807 /* movne */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_9, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2807 /* movne */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2807 /* movne */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2807 /* movne */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2807 /* movne */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2813 /* movneg */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2813 /* movneg */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_6, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2813 /* movneg */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2813 /* movneg */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2820 /* movnz */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2820 /* movnz */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_9, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2820 /* movnz */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2820 /* movnz */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2820 /* movnz */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2820 /* movnz */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2826 /* movo */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2826 /* movo */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2831 /* movpos */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2831 /* movpos */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_14, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2831 /* movpos */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2831 /* movpos */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2838 /* movr */, SP::MOVRrr, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2838 /* movr */, SP::MOVRri, Convert__Reg1_3__Reg1_1__Imm1_2__Tie0_1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 2843 /* movre */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2843 /* movre */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 2849 /* movrgez */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2849 /* movrgez */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_7, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 2857 /* movrgz */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2857 /* movrgz */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_6, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 2864 /* movrlez */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2864 /* movrlez */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_2, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 2872 /* movrlz */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2872 /* movrlz */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_3, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 2879 /* movrne */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2879 /* movrne */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 2886 /* movrnz */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2886 /* movrnz */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 2893 /* movrz */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2893 /* movrz */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 2899 /* movstosw */, SP::MOVSTOSW, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_IntRegs }, },
  { 2908 /* movstouw */, SP::MOVSTOUW, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_IntRegs }, },
  { 2917 /* movu */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2917 /* movu */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2922 /* movue */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2922 /* movue */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2928 /* movug */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2928 /* movug */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2934 /* movuge */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2934 /* movuge */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2941 /* movul */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2941 /* movul */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2947 /* movule */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2947 /* movule */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2954 /* movvc */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2954 /* movvc */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_15, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2954 /* movvc */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2954 /* movvc */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2960 /* movvs */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2960 /* movvs */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_7, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2960 /* movvs */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2960 /* movvs */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2966 /* movz */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 2966 /* movz */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_None, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 2966 /* movz */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 2966 /* movz */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 2966 /* movz */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2966 /* movz */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 2971 /* mulscc */, SP::MULSCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2971 /* mulscc */, SP::MULSCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 2978 /* mulx */, SP::MULXrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2978 /* mulx */, SP::MULXri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 2983 /* neg */, SP::SUBrr, Convert__Reg1_0__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs }, },
  { 2983 /* neg */, SP::SUBrr, Convert__Reg1_1__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 2987 /* nop */, SP::NOP, Convert_NoOperands, AMFBS_None, {  }, },
  { 2991 /* not */, SP::XNORrr, Convert__Reg1_0__Reg1_0__regG0, AMFBS_None, { MCK_IntRegs }, },
  { 2991 /* not */, SP::XNORrr, Convert__Reg1_1__Reg1_0__regG0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 2995 /* or */, SP::ORrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2995 /* or */, SP::ORri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 2995 /* or */, SP::ORri, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK_IntRegs }, },
  { 2998 /* orcc */, SP::ORCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 2998 /* orcc */, SP::ORCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3003 /* orn */, SP::ORNrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3003 /* orn */, SP::ORNri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3007 /* orncc */, SP::ORNCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3007 /* orncc */, SP::ORNCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3013 /* pdist */, SP::PDIST, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 3019 /* pdistn */, SP::PDISTN, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 3026 /* popc */, SP::POPCrr, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_IntRegs, MCK_IntRegs }, },
  { 3031 /* prefetch */, SP::PREFETCHi, Convert__MEMri2_1__PrefetchTag1_3, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK_PrefetchTag }, },
  { 3031 /* prefetch */, SP::PREFETCHr, Convert__MEMrr2_1__PrefetchTag1_3, AMFBS_HasV9, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_PrefetchTag }, },
  { 3040 /* prefetcha */, SP::PREFETCHAi, Convert__MEMri2_1__PrefetchTag1_4, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_PrefetchTag }, },
  { 3040 /* prefetcha */, SP::PREFETCHAr, Convert__MEMrr2_1__ASITag1_3__PrefetchTag1_4, AMFBS_HasV9, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_PrefetchTag }, },
  { 3050 /* pwr */, SP::PWRPSRrr, Convert__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_PSR }, },
  { 3050 /* pwr */, SP::PWRPSRri, Convert__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_PSR }, },
  { 3050 /* pwr */, SP::PWRPSRrr, Convert__Reg1_0__Reg1_1, AMFBS_HasPWRPSR, { MCK_IntRegs, MCK_IntRegs, MCK_PSR }, },
  { 3050 /* pwr */, SP::PWRPSRri, Convert__Reg1_0__Imm1_1, AMFBS_HasPWRPSR, { MCK_IntRegs, MCK_Imm, MCK_PSR }, },
  { 3054 /* rd */, SP::RDPSR, Convert__Reg1_1, AMFBS_None, { MCK_PSR, MCK_IntRegs }, },
  { 3054 /* rd */, SP::RDTBR, Convert__Reg1_1, AMFBS_None, { MCK_TBR, MCK_IntRegs }, },
  { 3054 /* rd */, SP::RDWIM, Convert__Reg1_1, AMFBS_None, { MCK_WIM, MCK_IntRegs }, },
  { 3054 /* rd */, SP::RDASR, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_ASRRegs, MCK_IntRegs }, },
  { 3057 /* rdpr */, SP::RDFQ, Convert__Reg1_1, AMFBS_HasV9, { MCK_FQ, MCK_IntRegs }, },
  { 3057 /* rdpr */, SP::RDPR, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_PRRegs, MCK_IntRegs }, },
  { 3062 /* restore */, SP::RESTORErr, Convert__regG0__regG0__regG0, AMFBS_None, {  }, },
  { 3062 /* restore */, SP::RESTORErr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3062 /* restore */, SP::RESTOREri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3070 /* restored */, SP::RESTORED, Convert_NoOperands, AMFBS_HasV9, {  }, },
  { 3079 /* ret */, SP::RET, Convert__imm_95_8, AMFBS_None, {  }, },
  { 3083 /* retl */, SP::RETL, Convert__imm_95_8, AMFBS_None, {  }, },
  { 3088 /* retry */, SP::RETRY, Convert_NoOperands, AMFBS_HasV9, {  }, },
  { 3094 /* rett */, SP::RETTri, Convert__MEMri2_0, AMFBS_None, { MCK_MEMri }, },
  { 3094 /* rett */, SP::RETTrr, Convert__MEMrr2_0, AMFBS_None, { MCK_MEMrr }, },
  { 3099 /* save */, SP::SAVErr, Convert__regG0__regG0__regG0, AMFBS_None, {  }, },
  { 3099 /* save */, SP::SAVErr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3099 /* save */, SP::SAVEri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3104 /* saved */, SP::SAVED, Convert_NoOperands, AMFBS_HasV9, {  }, },
  { 3110 /* sdiv */, SP::SDIVrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3110 /* sdiv */, SP::SDIVri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3115 /* sdivcc */, SP::SDIVCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3115 /* sdivcc */, SP::SDIVCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3122 /* sdivx */, SP::SDIVXrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3122 /* sdivx */, SP::SDIVXri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3128 /* set */, SP::SET, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 3132 /* sethi */, SP::SETHIi, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 3138 /* setx */, SP::SETX, Convert__Reg1_2__Imm1_0__Reg1_1, AMFBS_HasV9, { MCK_Imm, MCK_IntRegs, MCK_IntRegs }, },
  { 3143 /* shutdown */, SP::SHUTDOWN, Convert_NoOperands, AMFBS_HasVIS, {  }, },
  { 3152 /* siam */, SP::SIAM, Convert_NoOperands, AMFBS_HasVIS2, {  }, },
  { 3157 /* signx */, SP::SRArr, Convert__Reg1_0__Reg1_0__regG0, AMFBS_HasV9, { MCK_IntRegs }, },
  { 3157 /* signx */, SP::SRArr, Convert__Reg1_1__Reg1_0__regG0, AMFBS_HasV9, { MCK_IntRegs, MCK_IntRegs }, },
  { 3163 /* sir */, SP::SIR, Convert__imm_95_0, AMFBS_None, {  }, },
  { 3163 /* sir */, SP::SIR, Convert__Imm1_0, AMFBS_HasV9, { MCK_Imm }, },
  { 3167 /* sll */, SP::SLLrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3167 /* sll */, SP::SLLri, Convert__Reg1_2__Reg1_0__ShiftAmtImm51_1, AMFBS_None, { MCK_IntRegs, MCK_ShiftAmtImm5, MCK_IntRegs }, },
  { 3171 /* sllx */, SP::SLLXrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3171 /* sllx */, SP::SLLXri, Convert__Reg1_2__Reg1_0__ShiftAmtImm61_1, AMFBS_None, { MCK_IntRegs, MCK_ShiftAmtImm6, MCK_IntRegs }, },
  { 3176 /* smac */, SP::SMACrr, Convert__Reg1_2__Reg1_0__Reg1_1__imm_95_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3176 /* smac */, SP::SMACri, Convert__Reg1_2__Reg1_0__Imm1_1__imm_95_0, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3181 /* smul */, SP::SMULrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3181 /* smul */, SP::SMULri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3186 /* smulcc */, SP::SMULCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3186 /* smulcc */, SP::SMULCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3193 /* sra */, SP::SRArr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3193 /* sra */, SP::SRAri, Convert__Reg1_2__Reg1_0__ShiftAmtImm51_1, AMFBS_None, { MCK_IntRegs, MCK_ShiftAmtImm5, MCK_IntRegs }, },
  { 3197 /* srax */, SP::SRAXrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3197 /* srax */, SP::SRAXri, Convert__Reg1_2__Reg1_0__ShiftAmtImm61_1, AMFBS_None, { MCK_IntRegs, MCK_ShiftAmtImm6, MCK_IntRegs }, },
  { 3202 /* srl */, SP::SRLrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3202 /* srl */, SP::SRLri, Convert__Reg1_2__Reg1_0__ShiftAmtImm51_1, AMFBS_None, { MCK_IntRegs, MCK_ShiftAmtImm5, MCK_IntRegs }, },
  { 3206 /* srlx */, SP::SRLXrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3206 /* srlx */, SP::SRLXri, Convert__Reg1_2__Reg1_0__ShiftAmtImm61_1, AMFBS_None, { MCK_IntRegs, MCK_ShiftAmtImm6, MCK_IntRegs }, },
  { 3211 /* st */, SP::STCSRri, Convert__MEMri2_2, AMFBS_None, { MCK_CPSR, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3211 /* st */, SP::STCSRrr, Convert__MEMrr2_2, AMFBS_None, { MCK_CPSR, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3211 /* st */, SP::STFSRri, Convert__MEMri2_2, AMFBS_None, { MCK_FSR, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3211 /* st */, SP::STFSRrr, Convert__MEMrr2_2, AMFBS_None, { MCK_FSR, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3211 /* st */, SP::STCri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_CoprocRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3211 /* st */, SP::STCrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_CoprocRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3211 /* st */, SP::STFri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3211 /* st */, SP::STFrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3211 /* st */, SP::STri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3211 /* st */, SP::STrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3214 /* sta */, SP::STFAri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_FPRegs, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3214 /* sta */, SP::STFArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_HasV9, { MCK_FPRegs, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3214 /* sta */, SP::STAri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3214 /* sta */, SP::STArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3218 /* stb */, SP::STBri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3218 /* stb */, SP::STBrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3222 /* stba */, SP::STBAri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3222 /* stba */, SP::STBArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3227 /* stbar */, SP::STBAR, Convert_NoOperands, AMFBS_None, {  }, },
  { 3233 /* std */, SP::STDCQri, Convert__MEMri2_2, AMFBS_None, { MCK_CPQ, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3233 /* std */, SP::STDCQrr, Convert__MEMrr2_2, AMFBS_None, { MCK_CPQ, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3233 /* std */, SP::STDFQri, Convert__MEMri2_2, AMFBS_None, { MCK_FQ, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3233 /* std */, SP::STDFQrr, Convert__MEMrr2_2, AMFBS_None, { MCK_FQ, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3233 /* std */, SP::STDCri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_CoprocPair, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3233 /* std */, SP::STDCrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_CoprocPair, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3233 /* std */, SP::STDri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_IntPair, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3233 /* std */, SP::STDrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_IntPair, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3233 /* std */, SP::STDFri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3233 /* std */, SP::STDFrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3237 /* stda */, SP::STDAri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_IntPair, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3237 /* stda */, SP::STDArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_None, { MCK_IntPair, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3237 /* stda */, SP::STDFAri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_DFPRegs, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3237 /* stda */, SP::STDFArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_HasV9, { MCK_DFPRegs, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3242 /* sth */, SP::STHri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3242 /* sth */, SP::STHrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3246 /* stha */, SP::STHAri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3246 /* stha */, SP::STHArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3251 /* stq */, SP::STQFri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_QFPRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3251 /* stq */, SP::STQFrr, Convert__MEMrr2_2__Reg1_0, AMFBS_HasV9, { MCK_QFPRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3255 /* stqa */, SP::STQFAri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_QFPRegs, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3255 /* stqa */, SP::STQFArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_HasV9, { MCK_QFPRegs, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3260 /* stx */, SP::STXFSRri, Convert__MEMri2_2, AMFBS_HasV9, { MCK_FSR, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3260 /* stx */, SP::STXFSRrr, Convert__MEMrr2_2, AMFBS_HasV9, { MCK_FSR, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3260 /* stx */, SP::STXri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3260 /* stx */, SP::STXrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3264 /* stxa */, SP::STXAri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3264 /* stxa */, SP::STXArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3269 /* sub */, SP::SUBrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3269 /* sub */, SP::SUBri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3273 /* subcc */, SP::SUBCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3273 /* subcc */, SP::SUBCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3279 /* subx */, SP::SUBCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3279 /* subx */, SP::SUBCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3284 /* subxcc */, SP::SUBErr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3284 /* subxcc */, SP::SUBEri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3291 /* swap */, SP::SWAPri, Convert__Reg1_3__MEMri2_1__Tie0_1_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 3291 /* swap */, SP::SWAPrr, Convert__Reg1_3__MEMrr2_1__Tie0_1_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 3296 /* swapa */, SP::SWAPAri, Convert__Reg1_4__MEMri2_1__Tie0_1_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 3296 /* swapa */, SP::SWAPArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3__Tie0_1_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 3302 /* t */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_8, AMFBS_None, { MCK_IntRegs }, },
  { 3302 /* t */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 3302 /* t */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3302 /* t */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3302 /* t */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3302 /* t */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3302 /* t */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_8, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3302 /* t */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_8, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3302 /* t */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3302 /* t */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3302 /* t */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3302 /* t */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3302 /* t */, SP::TRAPrr, Convert__Reg1_1__Reg1_3__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3302 /* t */, SP::TRAPri, Convert__Reg1_1__Imm1_3__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3302 /* t */, SP::TXCCrr, Convert__Reg1_2__Reg1_4__Imm1_0, AMFBS_None, { MCK_Imm, MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3302 /* t */, SP::TXCCri, Convert__Reg1_2__Imm1_4__Imm1_0, AMFBS_None, { MCK_Imm, MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3302 /* t */, SP::TICCrr, Convert__Reg1_2__Reg1_4__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3302 /* t */, SP::TICCri, Convert__Reg1_2__Imm1_4__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3304 /* ta */, SP::TA1, Convert_NoOperands, AMFBS_None, { MCK_1 }, },
  { 3304 /* ta */, SP::TA3, Convert_NoOperands, AMFBS_None, { MCK_3 }, },
  { 3304 /* ta */, SP::TA5, Convert_NoOperands, AMFBS_None, { MCK_5 }, },
  { 3304 /* ta */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_8, AMFBS_None, { MCK_IntRegs }, },
  { 3304 /* ta */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 3304 /* ta */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3304 /* ta */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3304 /* ta */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3304 /* ta */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3304 /* ta */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_8, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3304 /* ta */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_8, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3304 /* ta */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3304 /* ta */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3304 /* ta */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3304 /* ta */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3307 /* taddcc */, SP::TADDCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3307 /* taddcc */, SP::TADDCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3314 /* taddcctv */, SP::TADDCCTVrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3314 /* taddcctv */, SP::TADDCCTVri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3323 /* tcc */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_13, AMFBS_None, { MCK_IntRegs }, },
  { 3323 /* tcc */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_13, AMFBS_None, { MCK_Imm }, },
  { 3323 /* tcc */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3323 /* tcc */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3323 /* tcc */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3323 /* tcc */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3323 /* tcc */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_13, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3323 /* tcc */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_13, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3323 /* tcc */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3323 /* tcc */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3323 /* tcc */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3323 /* tcc */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3327 /* tcs */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_5, AMFBS_None, { MCK_IntRegs }, },
  { 3327 /* tcs */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_5, AMFBS_None, { MCK_Imm }, },
  { 3327 /* tcs */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3327 /* tcs */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3327 /* tcs */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3327 /* tcs */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3327 /* tcs */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3327 /* tcs */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3327 /* tcs */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3327 /* tcs */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3327 /* tcs */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3327 /* tcs */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3331 /* te */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_1, AMFBS_None, { MCK_IntRegs }, },
  { 3331 /* te */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 3331 /* te */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3331 /* te */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3331 /* te */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3331 /* te */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3331 /* te */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3331 /* te */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3331 /* te */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3331 /* te */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3331 /* te */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3331 /* te */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3334 /* teq */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_1, AMFBS_None, { MCK_IntRegs }, },
  { 3334 /* teq */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 3334 /* teq */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3334 /* teq */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3334 /* teq */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3334 /* teq */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3334 /* teq */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3334 /* teq */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3334 /* teq */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3334 /* teq */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3334 /* teq */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3334 /* teq */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3338 /* tg */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_10, AMFBS_None, { MCK_IntRegs }, },
  { 3338 /* tg */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_10, AMFBS_None, { MCK_Imm }, },
  { 3338 /* tg */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3338 /* tg */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3338 /* tg */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3338 /* tg */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3338 /* tg */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_10, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3338 /* tg */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_10, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3338 /* tg */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3338 /* tg */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3338 /* tg */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3338 /* tg */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3341 /* tge */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_11, AMFBS_None, { MCK_IntRegs }, },
  { 3341 /* tge */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_11, AMFBS_None, { MCK_Imm }, },
  { 3341 /* tge */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_11, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3341 /* tge */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_11, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3341 /* tge */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3341 /* tge */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3341 /* tge */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_11, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3341 /* tge */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_11, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3341 /* tge */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_11, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3341 /* tge */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_11, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3341 /* tge */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3341 /* tge */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3345 /* tgeu */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_13, AMFBS_None, { MCK_IntRegs }, },
  { 3345 /* tgeu */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_13, AMFBS_None, { MCK_Imm }, },
  { 3345 /* tgeu */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3345 /* tgeu */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3345 /* tgeu */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3345 /* tgeu */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3345 /* tgeu */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_13, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3345 /* tgeu */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_13, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3345 /* tgeu */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3345 /* tgeu */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3345 /* tgeu */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3345 /* tgeu */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3350 /* tgt */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_10, AMFBS_None, { MCK_IntRegs }, },
  { 3350 /* tgt */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_10, AMFBS_None, { MCK_Imm }, },
  { 3350 /* tgt */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3350 /* tgt */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3350 /* tgt */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3350 /* tgt */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3350 /* tgt */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_10, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3350 /* tgt */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_10, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3350 /* tgt */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3350 /* tgt */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3350 /* tgt */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3350 /* tgt */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3354 /* tgu */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_12, AMFBS_None, { MCK_IntRegs }, },
  { 3354 /* tgu */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_12, AMFBS_None, { MCK_Imm }, },
  { 3354 /* tgu */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_12, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3354 /* tgu */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_12, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3354 /* tgu */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3354 /* tgu */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3354 /* tgu */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_12, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3354 /* tgu */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_12, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3354 /* tgu */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_12, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3354 /* tgu */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_12, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3354 /* tgu */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3354 /* tgu */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3358 /* tl */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_3, AMFBS_None, { MCK_IntRegs }, },
  { 3358 /* tl */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_3, AMFBS_None, { MCK_Imm }, },
  { 3358 /* tl */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3358 /* tl */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3358 /* tl */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3358 /* tl */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3358 /* tl */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_3, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3358 /* tl */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_3, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3358 /* tl */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3358 /* tl */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3358 /* tl */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3358 /* tl */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3361 /* tle */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_2, AMFBS_None, { MCK_IntRegs }, },
  { 3361 /* tle */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_2, AMFBS_None, { MCK_Imm }, },
  { 3361 /* tle */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_2, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3361 /* tle */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_2, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3361 /* tle */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3361 /* tle */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3361 /* tle */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_2, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3361 /* tle */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_2, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3361 /* tle */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_2, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3361 /* tle */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_2, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3361 /* tle */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3361 /* tle */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3365 /* tleu */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_4, AMFBS_None, { MCK_IntRegs }, },
  { 3365 /* tleu */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_4, AMFBS_None, { MCK_Imm }, },
  { 3365 /* tleu */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_4, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3365 /* tleu */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_4, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3365 /* tleu */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3365 /* tleu */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3365 /* tleu */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_4, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3365 /* tleu */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_4, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3365 /* tleu */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_4, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3365 /* tleu */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_4, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3365 /* tleu */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3365 /* tleu */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3370 /* tlt */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_3, AMFBS_None, { MCK_IntRegs }, },
  { 3370 /* tlt */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_3, AMFBS_None, { MCK_Imm }, },
  { 3370 /* tlt */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3370 /* tlt */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3370 /* tlt */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3370 /* tlt */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3370 /* tlt */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_3, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3370 /* tlt */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_3, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3370 /* tlt */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3370 /* tlt */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3370 /* tlt */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3370 /* tlt */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3374 /* tlu */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_5, AMFBS_None, { MCK_IntRegs }, },
  { 3374 /* tlu */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_5, AMFBS_None, { MCK_Imm }, },
  { 3374 /* tlu */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3374 /* tlu */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3374 /* tlu */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3374 /* tlu */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3374 /* tlu */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3374 /* tlu */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3374 /* tlu */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3374 /* tlu */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3374 /* tlu */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3374 /* tlu */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3378 /* tn */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_0, AMFBS_None, { MCK_IntRegs }, },
  { 3378 /* tn */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_0, AMFBS_None, { MCK_Imm }, },
  { 3378 /* tn */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_0, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3378 /* tn */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_0, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3378 /* tn */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3378 /* tn */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3378 /* tn */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3378 /* tn */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_0, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3378 /* tn */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_0, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3378 /* tn */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_0, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3378 /* tn */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3378 /* tn */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3381 /* tne */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_9, AMFBS_None, { MCK_IntRegs }, },
  { 3381 /* tne */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_9, AMFBS_None, { MCK_Imm }, },
  { 3381 /* tne */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3381 /* tne */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3381 /* tne */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3381 /* tne */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3381 /* tne */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_9, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3381 /* tne */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_9, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3381 /* tne */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3381 /* tne */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3381 /* tne */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3381 /* tne */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3385 /* tneg */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_6, AMFBS_None, { MCK_IntRegs }, },
  { 3385 /* tneg */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_6, AMFBS_None, { MCK_Imm }, },
  { 3385 /* tneg */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_6, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3385 /* tneg */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_6, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3385 /* tneg */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3385 /* tneg */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3385 /* tneg */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_6, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3385 /* tneg */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_6, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3385 /* tneg */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_6, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3385 /* tneg */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_6, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3385 /* tneg */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3385 /* tneg */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3390 /* tnz */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_9, AMFBS_None, { MCK_IntRegs }, },
  { 3390 /* tnz */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_9, AMFBS_None, { MCK_Imm }, },
  { 3390 /* tnz */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3390 /* tnz */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3390 /* tnz */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3390 /* tnz */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3390 /* tnz */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_9, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3390 /* tnz */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_9, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3390 /* tnz */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3390 /* tnz */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3390 /* tnz */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3390 /* tnz */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3394 /* tpos */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_14, AMFBS_None, { MCK_IntRegs }, },
  { 3394 /* tpos */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_14, AMFBS_None, { MCK_Imm }, },
  { 3394 /* tpos */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_14, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3394 /* tpos */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_14, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3394 /* tpos */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3394 /* tpos */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3394 /* tpos */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_14, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3394 /* tpos */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_14, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3394 /* tpos */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_14, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3394 /* tpos */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_14, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3394 /* tpos */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3394 /* tpos */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3399 /* tst */, SP::ORCCrr, Convert__regG0__Reg1_0__regG0, AMFBS_None, { MCK_IntRegs }, },
  { 3403 /* tsubcc */, SP::TSUBCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3403 /* tsubcc */, SP::TSUBCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3410 /* tsubcctv */, SP::TSUBCCTVrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3410 /* tsubcctv */, SP::TSUBCCTVri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3419 /* tvc */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_15, AMFBS_None, { MCK_IntRegs }, },
  { 3419 /* tvc */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_15, AMFBS_None, { MCK_Imm }, },
  { 3419 /* tvc */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_15, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3419 /* tvc */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_15, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3419 /* tvc */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3419 /* tvc */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3419 /* tvc */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_15, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3419 /* tvc */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_15, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3419 /* tvc */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_15, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3419 /* tvc */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_15, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3419 /* tvc */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3419 /* tvc */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3423 /* tvs */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_7, AMFBS_None, { MCK_IntRegs }, },
  { 3423 /* tvs */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_7, AMFBS_None, { MCK_Imm }, },
  { 3423 /* tvs */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_7, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3423 /* tvs */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_7, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3423 /* tvs */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3423 /* tvs */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3423 /* tvs */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_7, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3423 /* tvs */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_7, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3423 /* tvs */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_7, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3423 /* tvs */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_7, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3423 /* tvs */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3423 /* tvs */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3427 /* tz */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_1, AMFBS_None, { MCK_IntRegs }, },
  { 3427 /* tz */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 3427 /* tz */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3427 /* tz */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3427 /* tz */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3427 /* tz */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3427 /* tz */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3427 /* tz */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3427 /* tz */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3427 /* tz */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3427 /* tz */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3427 /* tz */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3430 /* udiv */, SP::UDIVrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3430 /* udiv */, SP::UDIVri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3435 /* udivcc */, SP::UDIVCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3435 /* udivcc */, SP::UDIVCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3442 /* udivx */, SP::UDIVXrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3442 /* udivx */, SP::UDIVXri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3448 /* umac */, SP::UMACrr, Convert__Reg1_2__Reg1_0__Reg1_1__imm_95_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3448 /* umac */, SP::UMACri, Convert__Reg1_2__Reg1_0__Imm1_1__imm_95_0, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3453 /* umul */, SP::UMULrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3453 /* umul */, SP::UMULri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3458 /* umulcc */, SP::UMULCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3458 /* umulcc */, SP::UMULCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3465 /* umulxhi */, SP::UMULXHI, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3473 /* unimp */, SP::UNIMP, Convert__imm_95_0, AMFBS_None, {  }, },
  { 3473 /* unimp */, SP::UNIMP, Convert__Imm1_0, AMFBS_None, { MCK_Imm }, },
  { 3479 /* wr */, SP::WRPSRrr, Convert__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_PSR }, },
  { 3479 /* wr */, SP::WRTBRrr, Convert__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_TBR }, },
  { 3479 /* wr */, SP::WRWIMrr, Convert__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_WIM }, },
  { 3479 /* wr */, SP::WRASRrr, Convert__Reg1_1__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_ASRRegs }, },
  { 3479 /* wr */, SP::WRPSRri, Convert__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_PSR }, },
  { 3479 /* wr */, SP::WRTBRri, Convert__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_TBR }, },
  { 3479 /* wr */, SP::WRWIMri, Convert__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_WIM }, },
  { 3479 /* wr */, SP::WRASRri, Convert__Reg1_1__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_ASRRegs }, },
  { 3479 /* wr */, SP::WRPSRrr, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_PSR }, },
  { 3479 /* wr */, SP::WRTBRrr, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_TBR }, },
  { 3479 /* wr */, SP::WRWIMrr, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_WIM }, },
  { 3479 /* wr */, SP::WRASRrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_ASRRegs }, },
  { 3479 /* wr */, SP::WRPSRri, Convert__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_PSR }, },
  { 3479 /* wr */, SP::WRTBRri, Convert__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_TBR }, },
  { 3479 /* wr */, SP::WRWIMri, Convert__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_WIM }, },
  { 3479 /* wr */, SP::WRASRri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_ASRRegs }, },
  { 3482 /* wrpr */, SP::WRPRrr, Convert__Reg1_1__Reg1_0__regG0, AMFBS_HasV9, { MCK_IntRegs, MCK_PRRegs }, },
  { 3482 /* wrpr */, SP::WRPRri, Convert__Reg1_1__regG0__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_PRRegs }, },
  { 3482 /* wrpr */, SP::WRPRrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasV9, { MCK_IntRegs, MCK_IntRegs, MCK_PRRegs }, },
  { 3482 /* wrpr */, SP::WRPRri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_HasV9, { MCK_IntRegs, MCK_Imm, MCK_PRRegs }, },
  { 3487 /* xmulx */, SP::XMULX, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3493 /* xmulxhi */, SP::XMULXHI, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3501 /* xnor */, SP::XNORrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3501 /* xnor */, SP::XNORri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3506 /* xnorcc */, SP::XNORCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3506 /* xnorcc */, SP::XNORCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3513 /* xor */, SP::XORrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3513 /* xor */, SP::XORri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3517 /* xorcc */, SP::XORCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3517 /* xorcc */, SP::XORCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
};

#include "llvm/Support/Debug.h"
#include "llvm/Support/Format.h"

unsigned SparcAsmParser::
MatchInstructionImpl(const OperandVector &Operands,
                     MCInst &Inst,
                     uint64_t &ErrorInfo,
                     FeatureBitset &MissingFeatures,
                     bool matchingInlineAsm, unsigned VariantID) {
  // Eliminate obvious mismatches.
  if (Operands.size() > 7) {
    ErrorInfo = 7;
    return Match_InvalidOperand;
  }

  // Get the current feature set.
  const FeatureBitset &AvailableFeatures = getAvailableFeatures();

  // Get the instruction mnemonic, which is the first token.
  StringRef Mnemonic = ((SparcOperand &)*Operands[0]).getToken();

  // Process all MnemonicAliases to remap the mnemonic.
  applyMnemonicAliases(Mnemonic, AvailableFeatures, VariantID);

  // Some state to try to produce better error messages.
  bool HadMatchOtherThanFeatures = false;
  bool HadMatchOtherThanPredicate = false;
  unsigned RetCode = Match_InvalidOperand;
  MissingFeatures.set();
  // Set ErrorInfo to the operand that mismatches if it is
  // wrong for all instances of the instruction.
  ErrorInfo = ~0ULL;
  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }
  // Search the table.
  auto MnemonicRange = std::equal_range(Start, End, Mnemonic, LessOpcode());

  DEBUG_WITH_TYPE("asm-matcher", dbgs() << "AsmMatcher: found " <<
  std::distance(MnemonicRange.first, MnemonicRange.second) <<
  " encodings with mnemonic '" << Mnemonic << "'\n");

  // Return a more specific error code if no mnemonics match.
  if (MnemonicRange.first == MnemonicRange.second)
    return Match_MnemonicFail;

  for (const MatchEntry *it = MnemonicRange.first, *ie = MnemonicRange.second;
       it != ie; ++it) {
    const FeatureBitset &RequiredFeatures = FeatureBitsets[it->RequiredFeaturesIdx];
    bool HasRequiredFeatures =
      (AvailableFeatures & RequiredFeatures) == RequiredFeatures;
    DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Trying to match opcode "
                                          << MII.getName(it->Opcode) << "\n");
    // equal_range guarantees that instruction mnemonic matches.
    assert(Mnemonic == it->getMnemonic());
    bool OperandsValid = true;
    for (unsigned FormalIdx = 0, ActualIdx = 1; FormalIdx != 6; ++FormalIdx) {
      auto Formal = static_cast<MatchClassKind>(it->Classes[FormalIdx]);
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "  Matching formal operand class " << getMatchClassName(Formal)
                             << " against actual operand at index " << ActualIdx);
      if (ActualIdx < Operands.size())
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << " (";
                        Operands[ActualIdx]->print(dbgs()); dbgs() << "): ");
      else
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << ": ");
      if (ActualIdx >= Operands.size()) {
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "actual operand index out of range\n");
        if (Formal == InvalidMatchClass) {
          break;
        }
        if (isSubclass(Formal, OptionalMatchClass)) {
          continue;
        }
        OperandsValid = false;
        ErrorInfo = ActualIdx;
        break;
      }
      MCParsedAsmOperand &Actual = *Operands[ActualIdx];
      unsigned Diag = validateOperandClass(Actual, Formal);
      if (Diag == Match_Success) {
        DEBUG_WITH_TYPE("asm-matcher",
                        dbgs() << "match success using generic matcher\n");
        ++ActualIdx;
        continue;
      }
      // If the generic handler indicates an invalid operand
      // failure, check for a special case.
      if (Diag != Match_Success) {
        unsigned TargetDiag = validateTargetOperandClass(Actual, Formal);
        if (TargetDiag == Match_Success) {
          DEBUG_WITH_TYPE("asm-matcher",
                          dbgs() << "match success using target matcher\n");
          ++ActualIdx;
          continue;
        }
        // If the target matcher returned a specific error code use
        // that, else use the one from the generic matcher.
        if (TargetDiag != Match_InvalidOperand && HasRequiredFeatures)
          Diag = TargetDiag;
      }
      // If current formal operand wasn't matched and it is optional
      // then try to match next formal operand
      if (Diag == Match_InvalidOperand && isSubclass(Formal, OptionalMatchClass)) {
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "ignoring optional operand\n");
        continue;
      }
      // If this operand is broken for all of the instances of this
      // mnemonic, keep track of it so we can report loc info.
      // If we already had a match that only failed due to a
      // target predicate, that diagnostic is preferred.
      if (!HadMatchOtherThanPredicate &&
          (it == MnemonicRange.first || ErrorInfo <= ActualIdx)) {
        if (HasRequiredFeatures && (ErrorInfo != ActualIdx || Diag != Match_InvalidOperand))
          RetCode = Diag;
        ErrorInfo = ActualIdx;
      }
      // Otherwise, just reject this instance of the mnemonic.
      OperandsValid = false;
      break;
    }

    if (!OperandsValid) {
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Opcode result: multiple "
                                               "operand mismatches, ignoring "
                                               "this opcode\n");
      continue;
    }
    if (!HasRequiredFeatures) {
      HadMatchOtherThanFeatures = true;
      FeatureBitset NewMissingFeatures = RequiredFeatures & ~AvailableFeatures;
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Missing target features:";
                      for (unsigned I = 0, E = NewMissingFeatures.size(); I != E; ++I)
                        if (NewMissingFeatures[I])
                          dbgs() << ' ' << I;
                      dbgs() << "\n");
      if (NewMissingFeatures.count() <=
          MissingFeatures.count())
        MissingFeatures = NewMissingFeatures;
      continue;
    }

    Inst.clear();

    Inst.setOpcode(it->Opcode);
    // We have a potential match but have not rendered the operands.
    // Check the target predicate to handle any context sensitive
    // constraints.
    // For example, Ties that are referenced multiple times must be
    // checked here to ensure the input is the same for each match
    // constraints. If we leave it any later the ties will have been
    // canonicalized
    unsigned MatchResult;
    if ((MatchResult = checkEarlyTargetMatchPredicate(Inst, Operands)) != Match_Success) {
      Inst.clear();
      DEBUG_WITH_TYPE(
          "asm-matcher",
          dbgs() << "Early target match predicate failed with diag code "
                 << MatchResult << "\n");
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    if (matchingInlineAsm) {
      convertToMapAndConstraints(it->ConvertFn, Operands);
      if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands,
                                          ErrorInfo))
        return Match_InvalidTiedOperand;

      return Match_Success;
    }

    // We have selected a definite instruction, convert the parsed
    // operands into the appropriate MCInst.
    convertToMCInst(it->ConvertFn, Inst, it->Opcode, Operands);

    // We have a potential match. Check the target predicate to
    // handle any context sensitive constraints.
    if ((MatchResult = checkTargetMatchPredicate(Inst)) != Match_Success) {
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "Target match predicate failed with diag code "
                             << MatchResult << "\n");
      Inst.clear();
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands,
                                         ErrorInfo))
      return Match_InvalidTiedOperand;

    DEBUG_WITH_TYPE(
        "asm-matcher",
        dbgs() << "Opcode result: complete match, selecting this opcode\n");
    return Match_Success;
  }

  // Okay, we had no match.  Try to return a useful error code.
  if (HadMatchOtherThanPredicate || !HadMatchOtherThanFeatures)
    return RetCode;

  ErrorInfo = 0;
  return Match_MissingFeature;
}

namespace {
  struct OperandMatchEntry {
    uint16_t Mnemonic;
    uint8_t OperandMask;
    uint8_t Class;
    uint8_t RequiredFeaturesIdx;

    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcodeOperand {
    bool operator()(const OperandMatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic()  < RHS;
    }
    bool operator()(StringRef LHS, const OperandMatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const OperandMatchEntry &LHS, const OperandMatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const OperandMatchEntry OperandMatchTable[175] = {
  /* Operand List Mnemonic, Mask, Operand Class, Features */
  { 0 /* add */, 8 /* 3 */, MCK_TailRelocSymAdd_TLS, AMFBS_None },
  { 272 /* call */, 1 /* 0 */, MCK_CallTarget, AMFBS_None },
  { 272 /* call */, 1 /* 0 */, MCK_MEMri, AMFBS_None },
  { 272 /* call */, 1 /* 0 */, MCK_MEMrr, AMFBS_None },
  { 272 /* call */, 1 /* 0 */, MCK_CallTarget, AMFBS_None },
  { 272 /* call */, 2 /* 1 */, MCK_TailRelocSymCall_TLS, AMFBS_None },
  { 281 /* casa */, 8 /* 3 */, MCK_ASITag, AMFBS_HasCASA },
  { 296 /* casxa */, 8 /* 3 */, MCK_ASITag, AMFBS_HasV9 },
  { 389 /* clr */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 389 /* clr */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 393 /* clrb */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 393 /* clrb */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 398 /* clrh */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 398 /* clrh */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 957 /* flush */, 1 /* 0 */, MCK_MEMri, AMFBS_None },
  { 957 /* flush */, 1 /* 0 */, MCK_MEMrr, AMFBS_None },
  { 2570 /* jmp */, 1 /* 0 */, MCK_MEMri, AMFBS_None },
  { 2570 /* jmp */, 1 /* 0 */, MCK_MEMrr, AMFBS_None },
  { 2574 /* jmpl */, 1 /* 0 */, MCK_MEMri, AMFBS_None },
  { 2574 /* jmpl */, 1 /* 0 */, MCK_MEMrr, AMFBS_None },
  { 2579 /* ld */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2579 /* ld */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2579 /* ld */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2579 /* ld */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2579 /* ld */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2579 /* ld */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2579 /* ld */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2579 /* ld */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2579 /* ld */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2579 /* ld */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2579 /* ld */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2579 /* ld */, 16 /* 4 */, MCK_TailRelocSymLoad_GOT, AMFBS_None },
  { 2579 /* ld */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2579 /* ld */, 16 /* 4 */, MCK_TailRelocSymLoad_TLS, AMFBS_None },
  { 2582 /* lda */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 2582 /* lda */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 2582 /* lda */, 8 /* 3 */, MCK_ASITag, AMFBS_HasV9 },
  { 2582 /* lda */, 2 /* 1 */, MCK_MEMrr, AMFBS_HasV9 },
  { 2582 /* lda */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 2582 /* lda */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2586 /* ldd */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2586 /* ldd */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2586 /* ldd */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2586 /* ldd */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2586 /* ldd */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2586 /* ldd */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2590 /* ldda */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 2590 /* ldda */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 2590 /* ldda */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 2590 /* ldda */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2590 /* ldda */, 8 /* 3 */, MCK_ASITag, AMFBS_HasV9 },
  { 2590 /* ldda */, 2 /* 1 */, MCK_MEMrr, AMFBS_HasV9 },
  { 2595 /* ldq */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 2595 /* ldq */, 2 /* 1 */, MCK_MEMrr, AMFBS_HasV9 },
  { 2599 /* ldqa */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 2599 /* ldqa */, 8 /* 3 */, MCK_ASITag, AMFBS_HasV9 },
  { 2599 /* ldqa */, 2 /* 1 */, MCK_MEMrr, AMFBS_HasV9 },
  { 2604 /* ldsb */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2604 /* ldsb */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2609 /* ldsba */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 2609 /* ldsba */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 2609 /* ldsba */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2615 /* ldsh */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2615 /* ldsh */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2620 /* ldsha */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 2620 /* ldsha */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 2620 /* ldsha */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2626 /* ldstub */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2626 /* ldstub */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2633 /* ldstuba */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 2633 /* ldstuba */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 2633 /* ldstuba */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2641 /* ldsw */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2641 /* ldsw */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2646 /* ldswa */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2646 /* ldswa */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 2646 /* ldswa */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2652 /* ldub */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2652 /* ldub */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2657 /* lduba */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 2657 /* lduba */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 2657 /* lduba */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2663 /* lduh */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2663 /* lduh */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2668 /* lduha */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 2668 /* lduha */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 2668 /* lduha */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2674 /* ldx */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 2674 /* ldx */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2674 /* ldx */, 2 /* 1 */, MCK_MEMrr, AMFBS_HasV9 },
  { 2674 /* ldx */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2674 /* ldx */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2674 /* ldx */, 16 /* 4 */, MCK_TailRelocSymLoad_GOT, AMFBS_None },
  { 2674 /* ldx */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2674 /* ldx */, 16 /* 4 */, MCK_TailRelocSymLoad_TLS, AMFBS_None },
  { 2678 /* ldxa */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 2678 /* ldxa */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 2678 /* ldxa */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 2689 /* membar */, 1 /* 0 */, MCK_MembarTag, AMFBS_HasV9 },
  { 3031 /* prefetch */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3031 /* prefetch */, 8 /* 3 */, MCK_PrefetchTag, AMFBS_HasV9 },
  { 3031 /* prefetch */, 2 /* 1 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3031 /* prefetch */, 8 /* 3 */, MCK_PrefetchTag, AMFBS_HasV9 },
  { 3040 /* prefetcha */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3040 /* prefetcha */, 16 /* 4 */, MCK_PrefetchTag, AMFBS_HasV9 },
  { 3040 /* prefetcha */, 8 /* 3 */, MCK_ASITag, AMFBS_HasV9 },
  { 3040 /* prefetcha */, 2 /* 1 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3040 /* prefetcha */, 16 /* 4 */, MCK_PrefetchTag, AMFBS_HasV9 },
  { 3094 /* rett */, 1 /* 0 */, MCK_MEMri, AMFBS_None },
  { 3094 /* rett */, 1 /* 0 */, MCK_MEMrr, AMFBS_None },
  { 3167 /* sll */, 2 /* 1 */, MCK_ShiftAmtImm5, AMFBS_None },
  { 3171 /* sllx */, 2 /* 1 */, MCK_ShiftAmtImm6, AMFBS_None },
  { 3193 /* sra */, 2 /* 1 */, MCK_ShiftAmtImm5, AMFBS_None },
  { 3197 /* srax */, 2 /* 1 */, MCK_ShiftAmtImm6, AMFBS_None },
  { 3202 /* srl */, 2 /* 1 */, MCK_ShiftAmtImm5, AMFBS_None },
  { 3206 /* srlx */, 2 /* 1 */, MCK_ShiftAmtImm6, AMFBS_None },
  { 3211 /* st */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3211 /* st */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3211 /* st */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3211 /* st */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3211 /* st */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3211 /* st */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3211 /* st */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3211 /* st */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3211 /* st */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3211 /* st */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3214 /* sta */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3214 /* sta */, 16 /* 4 */, MCK_ASITag, AMFBS_HasV9 },
  { 3214 /* sta */, 4 /* 2 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3214 /* sta */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3214 /* sta */, 16 /* 4 */, MCK_ASITag, AMFBS_None },
  { 3214 /* sta */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3218 /* stb */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3218 /* stb */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3222 /* stba */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3222 /* stba */, 16 /* 4 */, MCK_ASITag, AMFBS_None },
  { 3222 /* stba */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3233 /* std */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3233 /* std */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3233 /* std */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3233 /* std */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3233 /* std */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3233 /* std */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3233 /* std */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3233 /* std */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3233 /* std */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3233 /* std */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3237 /* stda */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3237 /* stda */, 16 /* 4 */, MCK_ASITag, AMFBS_None },
  { 3237 /* stda */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3237 /* stda */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3237 /* stda */, 16 /* 4 */, MCK_ASITag, AMFBS_HasV9 },
  { 3237 /* stda */, 4 /* 2 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3242 /* sth */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3242 /* sth */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3246 /* stha */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3246 /* stha */, 16 /* 4 */, MCK_ASITag, AMFBS_None },
  { 3246 /* stha */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3251 /* stq */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3251 /* stq */, 4 /* 2 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3255 /* stqa */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3255 /* stqa */, 16 /* 4 */, MCK_ASITag, AMFBS_HasV9 },
  { 3255 /* stqa */, 4 /* 2 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3260 /* stx */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3260 /* stx */, 4 /* 2 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3260 /* stx */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3260 /* stx */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3264 /* stxa */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3264 /* stxa */, 16 /* 4 */, MCK_ASITag, AMFBS_None },
  { 3264 /* stxa */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3291 /* swap */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3291 /* swap */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3296 /* swapa */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3296 /* swapa */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 3296 /* swapa */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
};

ParseStatus SparcAsmParser::
tryCustomParseOperand(OperandVector &Operands,
                      unsigned MCK) {

  switch(MCK) {
  case MCK_ASITag:
    return parseASITag(Operands);
  case MCK_CallTarget:
    return parseCallTarget(Operands);
  case MCK_MEMri:
    return parseMEMOperand(Operands);
  case MCK_MEMrr:
    return parseMEMOperand(Operands);
  case MCK_MembarTag:
    return parseMembarTag(Operands);
  case MCK_PrefetchTag:
    return parsePrefetchTag(Operands);
  case MCK_ShiftAmtImm5:
    return parseShiftAmtImm<5>(Operands);
  case MCK_ShiftAmtImm6:
    return parseShiftAmtImm<6>(Operands);
  case MCK_TailRelocSymLoad_GOT:
    return parseTailRelocSym<TailRelocKind::Load_GOT>(Operands);
  case MCK_TailRelocSymAdd_TLS:
    return parseTailRelocSym<TailRelocKind::Add_TLS>(Operands);
  case MCK_TailRelocSymLoad_TLS:
    return parseTailRelocSym<TailRelocKind::Load_TLS>(Operands);
  case MCK_TailRelocSymCall_TLS:
    return parseTailRelocSym<TailRelocKind::Call_TLS>(Operands);
  default:
    return ParseStatus::NoMatch;
  }
  return ParseStatus::NoMatch;
}

ParseStatus SparcAsmParser::
MatchOperandParserImpl(OperandVector &Operands,
                       StringRef Mnemonic,
                       bool ParseForAllFeatures) {
  // Get the current feature set.
  const FeatureBitset &AvailableFeatures = getAvailableFeatures();

  // Get the next operand index.
  unsigned NextOpNum = Operands.size() - 1;
  // Search the table.
  auto MnemonicRange =
    std::equal_range(std::begin(OperandMatchTable), std::end(OperandMatchTable),
                     Mnemonic, LessOpcodeOperand());

  if (MnemonicRange.first == MnemonicRange.second)
    return ParseStatus::NoMatch;

  for (const OperandMatchEntry *it = MnemonicRange.first,
       *ie = MnemonicRange.second; it != ie; ++it) {
    // equal_range guarantees that instruction mnemonic matches.
    assert(Mnemonic == it->getMnemonic());

    // check if the available features match
    const FeatureBitset &RequiredFeatures = FeatureBitsets[it->RequiredFeaturesIdx];
    if (!ParseForAllFeatures && (AvailableFeatures & RequiredFeatures) != RequiredFeatures)
      continue;

    // check if the operand in question has a custom parser.
    if (!(it->OperandMask & (1 << NextOpNum)))
      continue;

    // call custom parse method to handle the operand
    ParseStatus Result = tryCustomParseOperand(Operands, it->Class);
    if (!Result.isNoMatch())
      return Result;
  }

  // Okay, we had no match.
  return ParseStatus::NoMatch;
}

#endif // GET_MATCHER_IMPLEMENTATION


#ifdef GET_MNEMONIC_SPELL_CHECKER
#undef GET_MNEMONIC_SPELL_CHECKER

static std::string SparcMnemonicSpellCheck(StringRef S, const FeatureBitset &FBS, unsigned VariantID) {
  const unsigned MaxEditDist = 2;
  std::vector<StringRef> Candidates;
  StringRef Prev = "";

  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }

  for (auto I = Start; I < End; I++) {
    // Ignore unsupported instructions.
    const FeatureBitset &RequiredFeatures = FeatureBitsets[I->RequiredFeaturesIdx];
    if ((FBS & RequiredFeatures) != RequiredFeatures)
      continue;

    StringRef T = I->getMnemonic();
    // Avoid recomputing the edit distance for the same string.
    if (T == Prev)
      continue;

    Prev = T;
    unsigned Dist = S.edit_distance(T, false, MaxEditDist);
    if (Dist <= MaxEditDist)
      Candidates.push_back(T);
  }

  if (Candidates.empty())
    return "";

  std::string Res = ", did you mean: ";
  unsigned i = 0;
  for (; i < Candidates.size() - 1; i++)
    Res += Candidates[i].str() + ", ";
  return Res + Candidates[i].str() + "?";
}

#endif // GET_MNEMONIC_SPELL_CHECKER


#ifdef GET_MNEMONIC_CHECKER
#undef GET_MNEMONIC_CHECKER

static bool SparcCheckMnemonic(StringRef Mnemonic,
                                const FeatureBitset &AvailableFeatures,
                                unsigned VariantID) {
  // Process all MnemonicAliases to remap the mnemonic.
  applyMnemonicAliases(Mnemonic, AvailableFeatures, VariantID);

  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }

  // Search the table.
  auto MnemonicRange = std::equal_range(Start, End, Mnemonic, LessOpcode());

  if (MnemonicRange.first == MnemonicRange.second)
    return false;

  for (const MatchEntry *it = MnemonicRange.first, *ie = MnemonicRange.second;
       it != ie; ++it) {
    const FeatureBitset &RequiredFeatures =
      FeatureBitsets[it->RequiredFeaturesIdx];
    if ((AvailableFeatures & RequiredFeatures) == RequiredFeatures)
      return true;
  }
  return false;
}

#endif // GET_MNEMONIC_CHECKER

