/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_01 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 2101, "epsg", 2101,
        "Lake / Maracaibo Grid M1", 0, 0,
        "International 1924", "Greenwich",
        "Lake", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-71.60561777777777 +k_0=1 +x_0=0 +y_0=-52684.");
    add_proj4text (p, 2,
        "972 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Lake / Maracaibo Grid M1\",GEOGCS[\"Lake\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Lake\",SPHEROID[\"International 1924\",6378388,297,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6249\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4249\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 6,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 7,
        "n\",10.1666666666667],PARAMETER[\"central_meridian\",-71");
    add_srs_wkt (p, 8,
        ".6056177777778],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",0],PARAMETER[\"false_northing\",-52684");
    add_srs_wkt (p, 10,
        ".972],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"2101\"]]");
    p = add_epsg_def_ex (filter, first, last, 2102, "epsg", 2102,
        "Lake / Maracaibo Grid", 0, 0,
        "International 1924", "Greenwich",
        "Lake", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-71.60561777777777 +k_0=1 +x_0=200000 +y_0=14");
    add_proj4text (p, 2,
        "7315.028 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Lake / Maracaibo Grid\",GEOGCS[\"Lake\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Lake\",SPHEROID[\"International 1924\",6378388,297,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6249\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AUTHORITY[\"EPSG\",\"4249\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 6,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "10.1666666666667],PARAMETER[\"central_meridian\",-71.605");
    add_srs_wkt (p, 8,
        "6177777778],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",200000],PARAMETER[\"false_northing\",14731");
    add_srs_wkt (p, 10,
        "5.028],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"2102\"]]");
    p = add_epsg_def_ex (filter, first, last, 2103, "epsg", 2103,
        "Lake / Maracaibo Grid M3", 0, 0,
        "International 1924", "Greenwich",
        "Lake", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-71.60561777777777 +k_0=1 +x_0=500000 +y_0=44");
    add_proj4text (p, 2,
        "7315.028 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Lake / Maracaibo Grid M3\",GEOGCS[\"Lake\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Lake\",SPHEROID[\"International 1924\",6378388,297,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6249\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4249\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 6,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 7,
        "n\",10.1666666666667],PARAMETER[\"central_meridian\",-71");
    add_srs_wkt (p, 8,
        ".6056177777778],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",4");
    add_srs_wkt (p, 10,
        "47315.028],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"2103\"]]");
    p = add_epsg_def_ex (filter, first, last, 2104, "epsg", 2104,
        "Lake / Maracaibo La Rosa Grid", 0, 0,
        "International 1924", "Greenwich",
        "Lake", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-71.60561777777777 +k_0=1 +x_0=-17044 +y_0=-2");
    add_proj4text (p, 2,
        "3139.97 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Lake / Maracaibo La Rosa Grid\",GEOGCS[\"Lake\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Lake\",SPHEROID[\"International 1924\",6378388,");
    add_srs_wkt (p, 2,
        "297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "249\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4249\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",10.1666666666667],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-71.6056177777778],PARAMETER[\"scale_factor\",1],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_easting\",-17044],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",-23139.97],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2104\"]]");
    p = add_epsg_def_ex (filter, first, last, 2105, "epsg", 2105,
        "NZGD2000 / Mount Eden 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-36.87972222222222 +lon_0=174.7641666");
    add_proj4text (p, 1,
        "666667 +k=0.9999 +x_0=400000 +y_0=800000 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Mount Eden 2000\",GEOGCS[\"NZGD2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-36.8797222222222],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",174.764166666667],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9999],PARAMETER[\"false_easting\",400000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",800000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2105\"]]");
    p = add_epsg_def_ex (filter, first, last, 2106, "epsg", 2106,
        "NZGD2000 / Bay of Plenty 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-37.76111111111111 +lon_0=176.4661111");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Bay of Plenty 2000\",GEOGCS[\"NZGD20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-37.7611111111111],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",176.466111111111],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",400000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2106\"]]");
    p = add_epsg_def_ex (filter, first, last, 2107, "epsg", 2107,
        "NZGD2000 / Poverty Bay 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-38.62444444444444 +lon_0=177.8855555");
    add_proj4text (p, 1,
        "555556 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Poverty Bay 2000\",GEOGCS[\"NZGD2000");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",-38.6244444444444],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",177.885555555556],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1],PARAMETER[\"false_easting\",400000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"2107\"]]");
    p = add_epsg_def_ex (filter, first, last, 2108, "epsg", 2108,
        "NZGD2000 / Hawkes Bay 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.65083333333333 +lon_0=176.6736111");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Hawkes Bay 2000\",GEOGCS[\"NZGD2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-39.6508333333333],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",176.673611111111],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",400000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"2108\"]]");
    p = add_epsg_def_ex (filter, first, last, 2109, "epsg", 2109,
        "NZGD2000 / Taranaki 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.13555555555556 +lon_0=174.2277777");
    add_proj4text (p, 1,
        "777778 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Taranaki 2000\",GEOGCS[\"NZGD2000\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-39.1355555555556],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",174.227777777778],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",400000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"2109\"]]");
    p = add_epsg_def_ex (filter, first, last, 2110, "epsg", 2110,
        "NZGD2000 / Tuhirangi 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.51222222222222 +lon_0=175.64 +k=1");
    add_proj4text (p, 1,
        " +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Tuhirangi 2000\",GEOGCS[\"NZGD2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-39.5122222222222],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",175.64],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",1],PARAMETER[\"false_easting\",400000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"2110\"]]");
    p = add_epsg_def_ex (filter, first, last, 2111, "epsg", 2111,
        "NZGD2000 / Wanganui 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.24194444444444 +lon_0=175.4880555");
    add_proj4text (p, 1,
        "555555 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Wanganui 2000\",GEOGCS[\"NZGD2000\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-40.2419444444444],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",175.488055555556],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",400000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"2111\"]]");
    p = add_epsg_def_ex (filter, first, last, 2112, "epsg", 2112,
        "NZGD2000 / Wairarapa 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.92527777777777 +lon_0=175.6472222");
    add_proj4text (p, 1,
        "222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Wairarapa 2000\",GEOGCS[\"NZGD2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-40.9252777777778],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",175.647222222222],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",400000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"2112\"]]");
    p = add_epsg_def_ex (filter, first, last, 2113, "epsg", 2113,
        "NZGD2000 / Wellington 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.3011111111111 +lon_0=174.77638888");
    add_proj4text (p, 1,
        "88889 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Wellington 2000\",GEOGCS[\"NZGD2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-41.3011111111111],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",174.776388888889],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",400000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"2113\"]]");
    p = add_epsg_def_ex (filter, first, last, 2114, "epsg", 2114,
        "NZGD2000 / Collingwood 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.71472222222223 +lon_0=172.6719444");
    add_proj4text (p, 1,
        "444444 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Collingwood 2000\",GEOGCS[\"NZGD2000");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",-40.7147222222222],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",172.671944444444],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1],PARAMETER[\"false_easting\",400000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"2114\"]]");
    p = add_epsg_def_ex (filter, first, last, 2115, "epsg", 2115,
        "NZGD2000 / Nelson 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.27444444444444 +lon_0=173.2991666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Nelson 2000\",GEOGCS[\"NZGD2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-41.2744444444444],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",173.299166666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",400000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"2115\"]]");
    p = add_epsg_def_ex (filter, first, last, 2116, "epsg", 2116,
        "NZGD2000 / Karamea 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.28972222222222 +lon_0=172.1088888");
    add_proj4text (p, 1,
        "888889 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Karamea 2000\",GEOGCS[\"NZGD2000\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-41.2897222222222],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",172.108888888889],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",400000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"2116\"]]");
    p = add_epsg_def_ex (filter, first, last, 2117, "epsg", 2117,
        "NZGD2000 / Buller 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.81055555555555 +lon_0=171.5811111");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Buller 2000\",GEOGCS[\"NZGD2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-41.8105555555556],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",171.581111111111],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",400000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"2117\"]]");
    p = add_epsg_def_ex (filter, first, last, 2118, "epsg", 2118,
        "NZGD2000 / Grey 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.33361111111111 +lon_0=171.5497222");
    add_proj4text (p, 1,
        "222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Grey 2000\",GEOGCS[\"NZGD2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-42.3336111111111],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",171.549722222222],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",400000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",800000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2118\"]]");
    p = add_epsg_def_ex (filter, first, last, 2119, "epsg", 2119,
        "NZGD2000 / Amuri 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.68888888888888 +lon_0=173.01 +k=1");
    add_proj4text (p, 1,
        " +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Amuri 2000\",GEOGCS[\"NZGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",-42.6888888888889],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",173.01],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",400000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"2119\"]]");
    p = add_epsg_def_ex (filter, first, last, 2120, "epsg", 2120,
        "NZGD2000 / Marlborough 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.54444444444444 +lon_0=173.8019444");
    add_proj4text (p, 1,
        "444444 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Marlborough 2000\",GEOGCS[\"NZGD2000");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",-41.5444444444444],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",173.801944444444],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1],PARAMETER[\"false_easting\",400000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"2120\"]]");
    p = add_epsg_def_ex (filter, first, last, 2121, "epsg", 2121,
        "NZGD2000 / Hokitika 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.88611111111111 +lon_0=170.9797222");
    add_proj4text (p, 1,
        "222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Hokitika 2000\",GEOGCS[\"NZGD2000\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-42.8861111111111],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",170.979722222222],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",400000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"2121\"]]");
    p = add_epsg_def_ex (filter, first, last, 2122, "epsg", 2122,
        "NZGD2000 / Okarito 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.11 +lon_0=170.2608333333333 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Okarito 2000\",GEOGCS[\"NZGD2000\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-43.11],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",170.260833333333],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",400000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"2122\"]]");
    p = add_epsg_def_ex (filter, first, last, 2123, "epsg", 2123,
        "NZGD2000 / Jacksons Bay 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.97777777777778 +lon_0=168.6061111");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Jacksons Bay 2000\",GEOGCS[\"NZGD200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",-43.9777777777778],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",168.606111111111],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1],PARAMETER[\"false_easting\",400000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"2123\"]]");
    p = add_epsg_def_ex (filter, first, last, 2124, "epsg", 2124,
        "NZGD2000 / Mount Pleasant 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.59055555555556 +lon_0=172.7269444");
    add_proj4text (p, 1,
        "444445 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Mount Pleasant 2000\",GEOGCS[\"NZGD2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-43.5905555555556],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",172.726944444444],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",400000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2124\"]]");
    p = add_epsg_def_ex (filter, first, last, 2125, "epsg", 2125,
        "NZGD2000 / Gawler 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.74861111111111 +lon_0=171.3605555");
    add_proj4text (p, 1,
        "555555 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Gawler 2000\",GEOGCS[\"NZGD2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-43.7486111111111],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",171.360555555556],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",400000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"2125\"]]");
    p = add_epsg_def_ex (filter, first, last, 2126, "epsg", 2126,
        "NZGD2000 / Timaru 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44.40194444444445 +lon_0=171.0572222");
    add_proj4text (p, 1,
        "222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Timaru 2000\",GEOGCS[\"NZGD2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-44.4019444444444],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",171.057222222222],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",400000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"2126\"]]");
    p = add_epsg_def_ex (filter, first, last, 2127, "epsg", 2127,
        "NZGD2000 / Lindis Peak 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44.735 +lon_0=169.4675 +k=1 +x_0=400");
    add_proj4text (p, 1,
        "000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Lindis Peak 2000\",GEOGCS[\"NZGD2000");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",-44.735],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",169.4675],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",400000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2127\"]]");
    p = add_epsg_def_ex (filter, first, last, 2128, "epsg", 2128,
        "NZGD2000 / Mount Nicholas 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.13277777777778 +lon_0=168.3986111");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Mount Nicholas 2000\",GEOGCS[\"NZGD2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-45.1327777777778],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",168.398611111111],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",400000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2128\"]]");
    p = add_epsg_def_ex (filter, first, last, 2129, "epsg", 2129,
        "NZGD2000 / Mount York 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.56361111111111 +lon_0=167.7386111");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Mount York 2000\",GEOGCS[\"NZGD2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-45.5636111111111],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",167.738611111111],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",400000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"2129\"]]");
    p = add_epsg_def_ex (filter, first, last, 2130, "epsg", 2130,
        "NZGD2000 / Observation Point 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.81611111111111 +lon_0=170.6283333");
    add_proj4text (p, 1,
        "333333 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Observation Point 2000\",GEOGCS[\"NZ");
    add_srs_wkt (p, 1,
        "GD2000\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",-45.8161111111111],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",170.628333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",1],PARAMETER[\"false_easting\",400000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",800000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2130\"]]");
    p = add_epsg_def_ex (filter, first, last, 2131, "epsg", 2131,
        "NZGD2000 / North Taieri 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.86138888888889 +lon_0=170.2825 +k");
    add_proj4text (p, 1,
        "=0.99996 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / North Taieri 2000\",GEOGCS[\"NZGD200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",-45.8613888888889],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",170.2825],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.99996],PARAMETER[\"false_easting\",400000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AUTHORITY[\"EPSG\",\"2131\"]]");
    p = add_epsg_def_ex (filter, first, last, 2132, "epsg", 2132,
        "NZGD2000 / Bluff 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-46.6 +lon_0=168.3427777777778 +k=1 +");
    add_proj4text (p, 1,
        "x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Bluff 2000\",GEOGCS[\"NZGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",-46.6],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",168.342777777778],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",400000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"2132\"]]");
    p = add_epsg_def_ex (filter, first, last, 2133, "epsg", 2133,
        "NZGD2000 / UTM zone 58S", 0, 0,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / UTM zone 58S\",GEOGCS[\"NZGD2000\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",165],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"2133\"]]");
    p = add_epsg_def_ex (filter, first, last, 2134, "epsg", 2134,
        "NZGD2000 / UTM zone 59S", 0, 0,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / UTM zone 59S\",GEOGCS[\"NZGD2000\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",171],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"2134\"]]");
    p = add_epsg_def_ex (filter, first, last, 2135, "epsg", 2135,
        "NZGD2000 / UTM zone 60S", 0, 0,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / UTM zone 60S\",GEOGCS[\"NZGD2000\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4167\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",177],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"2135\"]]");
    p = add_epsg_def_ex (filter, first, last, 2136, "epsg", 2136,
        "Accra / Ghana National Grid", 0, 0,
        "War Office", "Greenwich",
        "Accra", "Transverse_Mercator", "Gold Coast foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.666666666666667 +lon_0=-1 +k=0.9997");
    add_proj4text (p, 1,
        "5 +x_0=274319.7391633579 +y_0=0 +a=6378300 +b=6356751.68");
    add_proj4text (p, 2,
        "9189189 +towgs84=-199,32,322,0,0,0,0 +to_meter=0.3047997");
    add_proj4text (p, 3,
        "101815088 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Accra / Ghana National Grid\",GEOGCS[\"Accra\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Accra\",SPHEROID[\"War Office\",6378300,296,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7029\"]],AUTHORITY[\"EPSG\",\"6168\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4168\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 6,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",4.66666");
    add_srs_wkt (p, 7,
        "666666667],PARAMETER[\"central_meridian\",-1],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.99975],PARAMETER[\"false_easting\",90");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"Gold Coast ");
    add_srs_wkt (p, 10,
        "foot\",0.304799710181509,AUTHORITY[\"EPSG\",\"9094\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"2136\"]]");
    p = add_epsg_def_ex (filter, first, last, 2137, "epsg", 2137,
        "Accra / TM 1 NW", 0, 0,
        "War Office", "Greenwich",
        "Accra", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-1 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322");
    add_proj4text (p, 2,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Accra / TM 1 NW\",GEOGCS[\"Accra\",DATUM[\"Accr");
    add_srs_wkt (p, 1,
        "a\",SPHEROID[\"War Office\",6378300,296,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 2,
        "\",\"7029\"]],AUTHORITY[\"EPSG\",\"6168\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 3,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"4168\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 6,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 7,
        "ral_meridian\",-1],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 9,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 10,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"2137\"]]");
    p = add_epsg_def_ex (filter, first, last, 2138, "epsg", 2138,
        "NAD27(CGQ77) / Quebec Lambert", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / Quebec Lambert\",GEOGCS[\"NAD27(");
    add_srs_wkt (p, 1,
        "CGQ77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",44],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-68.5],PARAMETER[\"standa");
    add_srs_wkt (p, 9,
        "rd_parallel_1\",60],PARAMETER[\"standard_parallel_2\",46");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"2138\"]]");
    p = add_epsg_def_ex (filter, first, last, 2139, "epsg", 2139,
        "NAD83(CSRS98) / SCoPQ zone 2 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / SCoPQ zone 2 (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadia");
    add_srs_wkt (p, 2,
        "n_Spatial_Reference_System\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree minute second hemisphere");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-55.5],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "9],PARAMETER[\"false_easting\",304800],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"2139\"]]");
    p = add_epsg_def_ex (filter, first, last, 2140, "epsg", 2140,
        "NAD83(CSRS98) / MTM zone 3 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / MTM zone 3 (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadian_");
    add_srs_wkt (p, 2,
        "Spatial_Reference_System\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree minute second hemisphere\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-58.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"2140\"]]");
    p = add_epsg_def_ex (filter, first, last, 2141, "epsg", 2141,
        "NAD83(CSRS98) / MTM zone 4 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / MTM zone 4 (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadian_");
    add_srs_wkt (p, 2,
        "Spatial_Reference_System\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree minute second hemisphere\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-61.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"2141\"]]");
    p = add_epsg_def_ex (filter, first, last, 2142, "epsg", 2142,
        "NAD83(CSRS98) / MTM zone 5 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / MTM zone 5 (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadian_");
    add_srs_wkt (p, 2,
        "Spatial_Reference_System\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree minute second hemisphere\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-64.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"2142\"]]");
    p = add_epsg_def_ex (filter, first, last, 2143, "epsg", 2143,
        "NAD83(CSRS98) / MTM zone 6 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / MTM zone 6 (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadian_");
    add_srs_wkt (p, 2,
        "Spatial_Reference_System\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree minute second hemisphere\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-67.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"2143\"]]");
    p = add_epsg_def_ex (filter, first, last, 2144, "epsg", 2144,
        "NAD83(CSRS98) / MTM zone 7 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / MTM zone 7 (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadian_");
    add_srs_wkt (p, 2,
        "Spatial_Reference_System\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree minute second hemisphere\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-70.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"2144\"]]");
    p = add_epsg_def_ex (filter, first, last, 2145, "epsg", 2145,
        "NAD83(CSRS98) / MTM zone 8 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / MTM zone 8 (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadian_");
    add_srs_wkt (p, 2,
        "Spatial_Reference_System\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree minute second hemisphere\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-73.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"2145\"]]");
    p = add_epsg_def_ex (filter, first, last, 2146, "epsg", 2146,
        "NAD83(CSRS98) / MTM zone 9 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / MTM zone 9 (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadian_");
    add_srs_wkt (p, 2,
        "Spatial_Reference_System\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree minute second hemisphere\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-76.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"2146\"]]");
    p = add_epsg_def_ex (filter, first, last, 2147, "epsg", 2147,
        "NAD83(CSRS98) / MTM zone 10 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / MTM zone 10 (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadian");
    add_srs_wkt (p, 2,
        "_Spatial_Reference_System\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree minute second hemisphere\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",-79.5],PARAMETER[\"scale_factor\",0.9999]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",304800],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"2147\"]]");
    p = add_epsg_def_ex (filter, first, last, 2148, "epsg", 2148,
        "NAD83(CSRS98) / UTM zone 21N (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / UTM zone 21N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadia");
    add_srs_wkt (p, 2,
        "n_Spatial_Reference_System\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree minute second hemisphere");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-57],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"2148\"]]");
    p = add_epsg_def_ex (filter, first, last, 2149, "epsg", 2149,
        "NAD83(CSRS98) / UTM zone 18N (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / UTM zone 18N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadia");
    add_srs_wkt (p, 2,
        "n_Spatial_Reference_System\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree minute second hemisphere");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-75],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"2149\"]]");
    p = add_epsg_def_ex (filter, first, last, 2150, "epsg", 2150,
        "NAD83(CSRS98) / UTM zone 17N (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / UTM zone 17N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadia");
    add_srs_wkt (p, 2,
        "n_Spatial_Reference_System\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree minute second hemisphere");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-81],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"2150\"]]");
    p = add_epsg_def_ex (filter, first, last, 2151, "epsg", 2151,
        "NAD83(CSRS98) / UTM zone 13N (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / UTM zone 13N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadia");
    add_srs_wkt (p, 2,
        "n_Spatial_Reference_System\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree minute second hemisphere");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-105],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"2151\"]]");
    p = add_epsg_def_ex (filter, first, last, 2152, "epsg", 2152,
        "NAD83(CSRS98) / UTM zone 12N (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / UTM zone 12N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadia");
    add_srs_wkt (p, 2,
        "n_Spatial_Reference_System\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree minute second hemisphere");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-111],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"2152\"]]");
    p = add_epsg_def_ex (filter, first, last, 2153, "epsg", 2153,
        "NAD83(CSRS98) / UTM zone 11N (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / UTM zone 11N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadia");
    add_srs_wkt (p, 2,
        "n_Spatial_Reference_System\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree minute second hemisphere");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-117],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"2153\"]]");
    p = add_epsg_def_ex (filter, first, last, 2154, "epsg", 2154,
        "RGF93 v1 / Lambert-93", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v1", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 +x_0=");
    add_proj4text (p, 1,
        "700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v1 / Lambert-93\",GEOGCS[\"RGF93 v1\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Reseau_Geodesique_Francais_1993_v1\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4171\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",46.5],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",3],PARAMETER[\"standard_parallel_1\",49],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",44],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",700000],PARAMETER[\"false_northing\",6600000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"2154\"]]");
    p = add_epsg_def_ex (filter, first, last, 2155, "epsg", 2155,
        "American Samoa 1962 / American Samoa Lambert (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "American_Samoa_1962", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.266666666");
    add_proj4text (p, 1,
        "66667 +lon_0=170 +k_0=1 +x_0=152400.3048006096 +y_0=0 +e");
    add_proj4text (p, 2,
        "llps=clrk66 +towgs84=-115,118,426,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"American Samoa 1962 / American Samoa Lambert (d");
    add_srs_wkt (p, 1,
        "eprecated)\",GEOGCS[\"American Samoa 1962\",DATUM[\"Amer");
    add_srs_wkt (p, 2,
        "ican_Samoa_1962\",SPHEROID[\"Clarke 1866\",6378206.4,294");
    add_srs_wkt (p, 3,
        ".978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6169\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4169\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",-14.2666666666667],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",170],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"2155\"]]");
    p = add_epsg_def_ex (filter, first, last, 2156, "epsg", 2156,
        "NAD83(HARN) / UTM zone 59S (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / UTM zone 59S (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_");
    add_srs_wkt (p, 2,
        "Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",171],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"2156\"]]");
    p = add_epsg_def_ex (filter, first, last, 2157, "epsg", 2157,
        "IRENET95 / Irish Transverse Mercator", 0, 0,
        "GRS 1980", "Greenwich",
        "IRENET95", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=0.99982 +x_0=600000");
    add_proj4text (p, 1,
        " +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IRENET95 / Irish Transverse Mercator\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "IRENET95\",DATUM[\"IRENET95\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6173\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4173\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",53.5],PARAMETER[\"central_meridian\",-8],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.99982],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",600000],PARAMETER[\"false_northing\",750000],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "2157\"]]");
    p = add_epsg_def_ex (filter, first, last, 2158, "epsg", 2158,
        "IRENET95 / UTM zone 29N", 0, 0,
        "GRS 1980", "Greenwich",
        "IRENET95", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IRENET95 / UTM zone 29N\",GEOGCS[\"IRENET95\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"IRENET95\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6173\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4173\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",-9],PARAMETER[\"scale");
    add_srs_wkt (p, 8,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"2158\"]]");
    p = add_epsg_def_ex (filter, first, last, 2159, "epsg", 2159,
        "Sierra Leone 1924 / New Colony Grid", 0, 0,
        "War Office", "Greenwich",
        "Sierra_Leone_Colony_1924", "Transverse_Mercator", "Gold Coast foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=6.666666666666667 +lon_0=-12 +k=1 +x_");
    add_proj4text (p, 1,
        "0=152399.8550907544 +y_0=0 +a=6378300 +b=6356751.6891891");
    add_proj4text (p, 2,
        "89 +to_meter=0.3047997101815088 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sierra Leone 1924 / New Colony Grid\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Sierra Leone 1924\",DATUM[\"Sierra_Leone_Colony_1924\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"War Office\",6378300,296,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7029\"]],AUTHORITY[\"EPSG\",\"6174\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4174\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",6.66666666666667],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-12],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"Gold Coast foot\",0.30479971018150");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9094\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2159\"]]");
    p = add_epsg_def_ex (filter, first, last, 2160, "epsg", 2160,
        "Sierra Leone 1924 / New War Office Grid", 0, 0,
        "War Office", "Greenwich",
        "Sierra_Leone_Colony_1924", "Transverse_Mercator", "Gold Coast foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=6.666666666666667 +lon_0=-12 +k=1 +x_");
    add_proj4text (p, 1,
        "0=243839.7681452071 +y_0=182879.8261089053 +a=6378300 +b");
    add_proj4text (p, 2,
        "=6356751.689189189 +to_meter=0.3047997101815088 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sierra Leone 1924 / New War Office Grid\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Sierra Leone 1924\",DATUM[\"Sierra_Leone_Colony_1924");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"War Office\",6378300,296,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7029\"]],AUTHORITY[\"EPSG\",\"6174\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4174\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",6.66666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-12],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",800000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",600000],UNIT[\"Gold Coast foot\",0.30479");
    add_srs_wkt (p, 11,
        "9710181509,AUTHORITY[\"EPSG\",\"9094\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"216");
    add_srs_wkt (p, 13,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 2161, "epsg", 2161,
        "Sierra Leone 1968 / UTM zone 28N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Sierra_Leone_1968", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=clrk80 +towgs84=-88,4,101,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sierra Leone 1968 / UTM zone 28N\",GEOGCS[\"Sie");
    add_srs_wkt (p, 1,
        "rra Leone 1968\",DATUM[\"Sierra_Leone_1968\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7012\"]],AUTHORITY[\"EPSG\",\"6175\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4175\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-15],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"2161\"]]");
    p = add_epsg_def_ex (filter, first, last, 2162, "epsg", 2162,
        "Sierra Leone 1968 / UTM zone 29N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Sierra_Leone_1968", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=clrk80 +towgs84=-88,4,101,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sierra Leone 1968 / UTM zone 29N\",GEOGCS[\"Sie");
    add_srs_wkt (p, 1,
        "rra Leone 1968\",DATUM[\"Sierra_Leone_1968\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7012\"]],AUTHORITY[\"EPSG\",\"6175\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4175\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-9],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"2162\"]]");
    p = add_epsg_def_ex (filter, first, last, 2163, "epsg", 2163,
        "US National Atlas Equal Area (deprecated)", 0, 0,
        "Clarke 1866 Authalic Sphere", "Greenwich",
        "Not_specified_based_on_Clarke_1866_Authalic_Sphere", "Lambert_Azimuthal_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=45 +lon_0=-100 +x_0=0 +y_0=0 +a=637099");
    add_proj4text (p, 1,
        "7 +b=6370997 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"US National Atlas Equal Area (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Unspecified datum based upon the Clarke 1866 Autha");
    add_srs_wkt (p, 2,
        "lic Sphere (deprecated)\",DATUM[\"Not_specified_based_on");
    add_srs_wkt (p, 3,
        "_Clarke_1866_Authalic_Sphere\",SPHEROID[\"Clarke 1866 Au");
    add_srs_wkt (p, 4,
        "thalic Sphere\",6370997,0,AUTHORITY[\"EPSG\",\"7052\"]],");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"6052\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 7,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4052\"]],PROJECTION[\"Lambert_Azimuthal_Equal_Area\"],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_center\",45],PARAMETER[\"longitude");
    add_srs_wkt (p, 10,
        "_of_center\",-100],PARAMETER[\"false_easting\",0],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"2163\"]]");
    p = add_epsg_def_ex (filter, first, last, 2164, "epsg", 2164,
        "Locodjo 1965 / TM 5 NW", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Locodjo_1965", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-5 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Locodjo 1965 / TM 5 NW\",GEOGCS[\"Locodjo 1965\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Locodjo_1965\",SPHEROID[\"Clarke 1880 (RGS)\",6");
    add_srs_wkt (p, 2,
        "378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6142\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4142\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2164\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2165, "epsg", 2165,
        "Abidjan 1987 / TM 5 NW", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Abidjan_1987", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-5 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Abidjan 1987 / TM 5 NW\",GEOGCS[\"Abidjan 1987\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Abidjan_1987\",SPHEROID[\"Clarke 1880 (RGS)\",6");
    add_srs_wkt (p, 2,
        "378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6143\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4143\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2165\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2166, "epsg", 2166,
        "Pulkovo 1942(83) / Gauss Kruger zone 3 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / Gauss Kruger zone 3 (depreca");
    add_srs_wkt (p, 1,
        "ted)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_");
    add_srs_wkt (p, 2,
        "83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6178\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4178\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",9],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",3500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"2166\"]]");
    p = add_epsg_def_ex (filter, first, last, 2167, "epsg", 2167,
        "Pulkovo 1942(83) / Gauss Kruger zone 4 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / Gauss Kruger zone 4 (depreca");
    add_srs_wkt (p, 1,
        "ted)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_");
    add_srs_wkt (p, 2,
        "83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6178\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4178\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",12],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",4500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2167\"]]");
    p = add_epsg_def_ex (filter, first, last, 2168, "epsg", 2168,
        "Pulkovo 1942(83) / Gauss Kruger zone 5 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / Gauss Kruger zone 5 (depreca");
    add_srs_wkt (p, 1,
        "ted)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_");
    add_srs_wkt (p, 2,
        "83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6178\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4178\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",15],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",5500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2168\"]]");
    p = add_epsg_def_ex (filter, first, last, 2169, "epsg", 2169,
        "LUREF / Luxembourg TM", 0, 1,
        "International 1924", "Greenwich",
        "Luxembourg_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=49.83333333333334 +lon_0=6.1666666666");
    add_proj4text (p, 1,
        "66667 +k=1 +x_0=80000 +y_0=100000 +ellps=intl +towgs84=-");
    add_proj4text (p, 2,
        "189.6806,18.3463,-42.7695,-0.33746,-3.09264,2.53861,0.45");
    add_proj4text (p, 3,
        "98 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LUREF / Luxembourg TM\",GEOGCS[\"LUREF\",DATUM[");
    add_srs_wkt (p, 1,
        "\"Luxembourg_Reference_Frame\",SPHEROID[\"International ");
    add_srs_wkt (p, 2,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6181\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4181\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",49.8333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",6.16666666666667],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",80000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",100000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"2169\"]]");
    p = add_epsg_def_ex (filter, first, last, 2170, "epsg", 2170,
        "MGI / Slovenia Grid (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,");
    add_proj4text (p, 2,
        "1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Slovenia Grid (deprecated)\",GEOGCS[\"MGI");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Militar-Geographische_Institut\",SPHEROID[\"B");
    add_srs_wkt (p, 2,
        "essel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",15],PARAMETER[\"scale_factor\",0.9999],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"2170\"]]");
    p = add_epsg_def_ex (filter, first, last, 2171, "epsg", 2171,
        "Pulkovo 1942(58) / Poland zone I (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Oblique_Stereographic", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=50.625 +lon_0=21.08333333333333 +k=0");
    add_proj4text (p, 1,
        ".9998 +x_0=4637000 +y_0=5647000 +ellps=krass +towgs84=33");
    add_proj4text (p, 2,
        ".4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Poland zone I (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4179\"]],PROJECTION[\"Oblique_Stereogra");
    add_srs_wkt (p, 7,
        "phic\"],PARAMETER[\"latitude_of_origin\",50.625],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",21.0833333333333],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.9998],PARAMETER[\"false_easting\",4637000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",5647000],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2171\"]]");
    p = add_epsg_def_ex (filter, first, last, 2172, "epsg", 2172,
        "Pulkovo 1942(58) / Poland zone II", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Oblique_Stereographic", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=53.00194444444445 +lon_0=21.50277777");
    add_proj4text (p, 1,
        "777778 +k=0.9998 +x_0=4603000 +y_0=5806000 +ellps=krass ");
    add_proj4text (p, 2,
        "+towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +un");
    add_proj4text (p, 3,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Poland zone II\",GEOGCS[\"Pu");
    add_srs_wkt (p, 1,
        "lkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4179\"]],PROJECTION[\"Oblique_Stereographic\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",53.0019444444444],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",21.5027777777778],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9998],PARAMETER[\"false_easting\",4603000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",5806000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2172\"]]");
    p = add_epsg_def_ex (filter, first, last, 2173, "epsg", 2173,
        "Pulkovo 1942(58) / Poland zone III", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Oblique_Stereographic", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=53.58333333333334 +lon_0=17.00833333");
    add_proj4text (p, 1,
        "333333 +k=0.9998 +x_0=3501000 +y_0=5999000 +ellps=krass ");
    add_proj4text (p, 2,
        "+towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +un");
    add_proj4text (p, 3,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Poland zone III\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4179\"]],PROJECTION[\"Oblique_Stereographic\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",53.5833333333333],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",17.0083333333333],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9998],PARAMETER[\"false_easting\",3501000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",5999000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2173\"]]");
    p = add_epsg_def_ex (filter, first, last, 2174, "epsg", 2174,
        "Pulkovo 1942(58) / Poland zone IV", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Oblique_Stereographic", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=51.67083333333333 +lon_0=16.67222222");
    add_proj4text (p, 1,
        "222222 +k=0.9998 +x_0=3703000 +y_0=5627000 +ellps=krass ");
    add_proj4text (p, 2,
        "+towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +un");
    add_proj4text (p, 3,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Poland zone IV\",GEOGCS[\"Pu");
    add_srs_wkt (p, 1,
        "lkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4179\"]],PROJECTION[\"Oblique_Stereographic\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",51.6708333333333],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",16.6722222222222],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9998],PARAMETER[\"false_easting\",3703000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",5627000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2174\"]]");
    p = add_epsg_def_ex (filter, first, last, 2175, "epsg", 2175,
        "Pulkovo 1942(58) / Poland zone V", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18.95833333333333 +k=0.99998");
    add_proj4text (p, 1,
        "3 +x_0=237000 +y_0=-4700000 +ellps=krass +towgs84=33.4,-");
    add_proj4text (p, 2,
        "146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Poland zone V\",GEOGCS[\"Pul");
    add_srs_wkt (p, 1,
        "kovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID[\"Kra");
    add_srs_wkt (p, 2,
        "ssowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4179\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",18.9583333333333],PARAMETER[\"scale_factor\",0.999983");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",237000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",-4700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"2175\"]]");
    p = add_epsg_def_ex (filter, first, last, 2176, "epsg", 2176,
        "ETRF2000-PL / CS2000/15", 0, 1,
        "GRS 1980", "Greenwich",
        "ETRF2000_Poland", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.999923 +x_0=5500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRF2000-PL / CS2000/15\",GEOGCS[\"ETRF2000-PL\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"ETRF2000_Poland\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1305\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9702\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",15],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",0.999923],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",5500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2176\"]]");
    p = add_epsg_def_ex (filter, first, last, 2177, "epsg", 2177,
        "ETRF2000-PL / CS2000/18", 0, 1,
        "GRS 1980", "Greenwich",
        "ETRF2000_Poland", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=0.999923 +x_0=6500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRF2000-PL / CS2000/18\",GEOGCS[\"ETRF2000-PL\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"ETRF2000_Poland\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1305\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9702\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",18],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",0.999923],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",6500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2177\"]]");
    p = add_epsg_def_ex (filter, first, last, 2178, "epsg", 2178,
        "ETRF2000-PL / CS2000/21", 0, 1,
        "GRS 1980", "Greenwich",
        "ETRF2000_Poland", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.999923 +x_0=7500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRF2000-PL / CS2000/21\",GEOGCS[\"ETRF2000-PL\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"ETRF2000_Poland\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1305\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9702\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",21],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",0.999923],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",7500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2178\"]]");
    p = add_epsg_def_ex (filter, first, last, 2179, "epsg", 2179,
        "ETRF2000-PL / CS2000/24", 0, 1,
        "GRS 1980", "Greenwich",
        "ETRF2000_Poland", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.999923 +x_0=8500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRF2000-PL / CS2000/24\",GEOGCS[\"ETRF2000-PL\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"ETRF2000_Poland\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1305\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9702\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",24],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",0.999923],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",8500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2179\"]]");
    p = add_epsg_def_ex (filter, first, last, 2180, "epsg", 2180,
        "ETRF2000-PL / CS92", 0, 1,
        "GRS 1980", "Greenwich",
        "ETRF2000_Poland", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=19 +k=0.9993 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=-5300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRF2000-PL / CS92\",GEOGCS[\"ETRF2000-PL\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"ETRF2000_Poland\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1305\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9702\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",19],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9993],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",-5300000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 11,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2180\"]]");
    p = add_epsg_def_ex (filter, first, last, 2188, "epsg", 2188,
        "Azores Occidental 1939 / UTM zone 25N", 0, 0,
        "International 1924", "Greenwich",
        "Azores_Occidental_Islands_1939", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +ellps=intl +towgs84=-425,-169,81,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Azores Occidental 1939 / UTM zone 25N\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Azores Occidental 1939\",DATUM[\"Azores_Occidental_Isl");
    add_srs_wkt (p, 2,
        "ands_1939\",SPHEROID[\"International 1924\",6378388,297,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6182\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4182\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-33],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"2188\"]]");
    p = add_epsg_def_ex (filter, first, last, 2189, "epsg", 2189,
        "Azores Central 1948 / UTM zone 26N", 0, 0,
        "International 1924", "Greenwich",
        "Azores_Central_Islands_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +ellps=intl +towgs84=-104,167,-38,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Azores Central 1948 / UTM zone 26N\",GEOGCS[\"A");
    add_srs_wkt (p, 1,
        "zores Central 1948\",DATUM[\"Azores_Central_Islands_1948");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6183\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4183\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-27],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"2189\"]]");
    p = add_epsg_def_ex (filter, first, last, 2190, "epsg", 2190,
        "Azores Oriental 1940 / UTM zone 26N", 0, 0,
        "International 1924", "Greenwich",
        "Azores_Oriental_Islands_1940", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +ellps=intl +towgs84=-203,141,53,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Azores Oriental 1940 / UTM zone 26N\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Azores Oriental 1940\",DATUM[\"Azores_Oriental_Islands_1");
    add_srs_wkt (p, 2,
        "940\",SPHEROID[\"International 1924\",6378388,297,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6184\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4184\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-27],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"2190\"]]");
    p = add_epsg_def_ex (filter, first, last, 2191, "epsg", 2191,
        "Madeira 1936 / UTM zone 28N (deprecated)", 0, 0,
        "International 1924", "Greenwich",
        "Madeira_1936", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Madeira 1936 / UTM zone 28N (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Madeira 1936 (deprecated)\",DATUM[\"Madeira_1936\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6185\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e minute second hemisphere\",0.0174532925199433,AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"4185\"]],PROJ");
    add_srs_wkt (p, 7,
        "ECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 8,
        "origin\",0],PARAMETER[\"central_meridian\",-15],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2191\"]]");
    p = add_epsg_def_ex (filter, first, last, 2192, "epsg", 2192,
        "ED50 / France EuroLambert (deprecated)", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=2.3372291666666");
    add_proj4text (p, 1,
        "67 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +ellps=intl ");
    add_proj4text (p, 2,
        "+towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / France EuroLambert (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4230\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",46.8],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",2.33722916666667],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.99987742],PARAMETER[\"false_easting\",600000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",2200000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2192\"]]");
    p = add_epsg_def_ex (filter, first, last, 2193, "epsg", 2193,
        "NZGD2000 / New Zealand Transverse Mercator 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=173 +k=0.9996 +x_0=1600000 +");
    add_proj4text (p, 1,
        "y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / New Zealand Transverse Mercator 2000");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NZGD2000\",DATUM[\"New_Zealand_Geodetic_Datu");
    add_srs_wkt (p, 2,
        "m_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6167\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",173],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9996],PARAMETER[\"false_easting\",1600000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"2193\"]]");
    p = add_epsg_def_ex (filter, first, last, 2194, "epsg", 2194,
        "American Samoa 1962 / American Samoa Lambert (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "American_Samoa_1962", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.266666666");
    add_proj4text (p, 1,
        "66667 +lon_0=-170 +k_0=1 +x_0=152400.3048006096 +y_0=0 +");
    add_proj4text (p, 2,
        "ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +units=us-ft ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"American Samoa 1962 / American Samoa Lambert (d");
    add_srs_wkt (p, 1,
        "eprecated)\",GEOGCS[\"American Samoa 1962\",DATUM[\"Amer");
    add_srs_wkt (p, 2,
        "ican_Samoa_1962\",SPHEROID[\"Clarke 1866\",6378206.4,294");
    add_srs_wkt (p, 3,
        ".978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6169\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4169\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",-14.2666666666667],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-170],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"2194\"]]");
    p = add_epsg_def_ex (filter, first, last, 2195, "epsg", 2195,
        "NAD83(HARN) / UTM zone 2S", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +south +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / UTM zone 2S\",GEOGCS[\"NAD83(HARN");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-171],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"2195\"]]");
    p = add_epsg_def_ex (filter, first, last, 2196, "epsg", 2196,
        "ETRS89 / Kp2000 Jutland", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9.5 +k=0.99995 +x_0=200000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Kp2000 Jutland\",GEOGCS[\"ETRS89\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"European_Terrestrial_Reference_System_1989\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",9.5],PARAMETER[\"scale_factor\",0.99995],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",200000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"2196\"]]");
    p = add_epsg_def_ex (filter, first, last, 2197, "epsg", 2197,
        "ETRS89 / Kp2000 Zealand", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.99995 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Kp2000 Zealand\",GEOGCS[\"ETRS89\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"European_Terrestrial_Reference_System_1989\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",12],PARAMETER[\"scale_factor\",0.99995],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2197\"]]");
    p = add_epsg_def_ex (filter, first, last, 2198, "epsg", 2198,
        "ETRS89 / Kp2000 Bornholm", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=900000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Kp2000 Bornholm\",GEOGCS[\"ETRS89\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"European_Terrestrial_Reference_System_1989\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",15],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",900000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"2198\"]]");
    p = add_epsg_def_ex (filter, first, last, 2199, "epsg", 2199,
        "Albanian 1987 / Gauss Kruger zone 4 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Albanian_1987", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=-44.183,-0.58,-38.489,2.3867,2.707");
    add_proj4text (p, 2,
        "2,-3.5196,-8.2703 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Albanian 1987 / Gauss Kruger zone 4 (deprecated");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"Albanian 1987\",DATUM[\"Albanian_1987\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7024\"]],AUTHORITY[\"EPSG\",\"6191\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4191\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",21],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",4500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"2199\"]]");
    p = add_epsg_def_ex (filter, first, last, 2200, "epsg", 2200,
        "ATS77 / New Brunswick Stereographic (ATS77)", 0, 1,
        "Average Terrestrial System 1977", "Greenwich",
        "Average_Terrestrial_System_1977", "Oblique_Stereographic", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=3");
    add_proj4text (p, 1,
        "00000 +y_0=800000 +a=6378135 +b=6356750.304921594 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ATS77 / New Brunswick Stereographic (ATS77)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"ATS77\",DATUM[\"Average_Terrestrial_System_1977\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Average Terrestrial System 1977\",6378135,29");
    add_srs_wkt (p, 3,
        "8.257,AUTHORITY[\"EPSG\",\"7041\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6122\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4122\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Oblique_Stereographic\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",46.5],PARAMETER[\"central_meridian\",-66.5],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.999912],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",300000],PARAMETER[\"false_northing\",800000],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2200\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2201, "epsg", 2201,
        "REGVEN / UTM zone 18N", 0, 0,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_Venezolana", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"REGVEN / UTM zone 18N\",GEOGCS[\"REGVEN\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Red_Geodesica_Venezolana\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6189\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4189\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-75],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2201\"]]");
    p = add_epsg_def_ex (filter, first, last, 2202, "epsg", 2202,
        "REGVEN / UTM zone 19N", 0, 0,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_Venezolana", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"REGVEN / UTM zone 19N\",GEOGCS[\"REGVEN\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Red_Geodesica_Venezolana\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6189\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4189\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-69],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2202\"]]");
    p = add_epsg_def_ex (filter, first, last, 2203, "epsg", 2203,
        "REGVEN / UTM zone 20N", 0, 0,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_Venezolana", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"REGVEN / UTM zone 20N\",GEOGCS[\"REGVEN\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Red_Geodesica_Venezolana\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6189\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4189\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-63],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2203\"]]");
    p = add_epsg_def_ex (filter, first, last, 2204, "epsg", 2204,
        "NAD27 / Tennessee", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.25 +lat_2=36.41666666666666 +lat_0=3");
    add_proj4text (p, 1,
        "4.66666666666666 +lon_0=-86 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "30480.06096012192 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Tennessee\",GEOGCS[\"NAD27\",DATUM[\"No");
    add_srs_wkt (p, 1,
        "rth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",63782");
    add_srs_wkt (p, 2,
        "06.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "7\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",34.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-86],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",35.25],PARAMETER[\"standard_parallel_2\",36.41666666666");
    add_srs_wkt (p, 10,
        "67],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",100000],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2204\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2205, "epsg", 2205,
        "NAD83 / Kentucky North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kentucky North\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",37.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",-84.25],PARAMETER[\"standard_parallel_1\",37.966666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"standard_parallel_2\",38.9666666666");
    add_srs_wkt (p, 10,
        "667],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"2205\"]]");
    p = add_epsg_def_ex (filter, first, last, 2206, "epsg", 2206,
        "ED50 / 3-degree Gauss-Kruger zone 9", 0, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / 3-degree Gauss-Kruger zone 9\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4230\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",9500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2206\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2207, "epsg", 2207,
        "ED50 / 3-degree Gauss-Kruger zone 10", 0, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / 3-degree Gauss-Kruger zone 10\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4230\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",10500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2207\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2208, "epsg", 2208,
        "ED50 / 3-degree Gauss-Kruger zone 11", 0, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / 3-degree Gauss-Kruger zone 11\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4230\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",11500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2208\"");
    add_srs_wkt (p, 12,
        "]]");
}

#endif /* full EPSG initialization enabled/disabled */

