/* key-event.c generated by valac 0.56.17, the Vala compiler
 * generated from key-event.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "libskk/libskk.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SKK_KEY_EVENT_0_PROPERTY,
	SKK_KEY_EVENT_NAME_PROPERTY,
	SKK_KEY_EVENT_CODE_PROPERTY,
	SKK_KEY_EVENT_MODIFIERS_PROPERTY,
	SKK_KEY_EVENT_NUM_PROPERTIES
};
static GParamSpec* skk_key_event_properties[SKK_KEY_EVENT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SkkKeyEventPrivate {
	gchar* _name;
	gunichar _code;
	SkkModifierType _modifiers;
};

static gint SkkKeyEvent_private_offset;
static gpointer skk_key_event_parent_class = NULL;

static void skk_key_event_set_name (SkkKeyEvent* self,
                             const gchar* value);
static void skk_key_event_set_code (SkkKeyEvent* self,
                             gunichar value);
VALA_EXTERN guint skk_key_event_utils_keyval_from_name (const gchar* name);
VALA_EXTERN gchar* skk_key_event_utils_keyval_name (guint keyval);
VALA_EXTERN gunichar skk_key_event_utils_keyval_unicode (guint keyval);
static void skk_key_event_finalize (GObject * obj);
static GType skk_key_event_get_type_once (void);
static void _vala_skk_key_event_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_skk_key_event_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
skk_key_event_format_error_quark (void)
{
	return g_quark_from_static_string ("skk-key-event-format-error-quark");
}

static GType
skk_key_event_format_error_get_type_once (void)
{
	static const GEnumValue values[] = {{SKK_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "SKK_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED", "parse-failed"}, {SKK_KEY_EVENT_FORMAT_ERROR_KEYSYM_NOT_FOUND, "SKK_KEY_EVENT_FORMAT_ERROR_KEYSYM_NOT_FOUND", "keysym-not-found"}, {0, NULL, NULL}};
	GType skk_key_event_format_error_type_id;
	skk_key_event_format_error_type_id = g_enum_register_static ("SkkKeyEventFormatError", values);
	return skk_key_event_format_error_type_id;
}

GType
skk_key_event_format_error_get_type (void)
{
	static volatile gsize skk_key_event_format_error_type_id__once = 0;
	if (g_once_init_enter (&skk_key_event_format_error_type_id__once)) {
		GType skk_key_event_format_error_type_id;
		skk_key_event_format_error_type_id = skk_key_event_format_error_get_type_once ();
		g_once_init_leave (&skk_key_event_format_error_type_id__once, skk_key_event_format_error_type_id);
	}
	return skk_key_event_format_error_type_id__once;
}

/**
     * A set of bit-flags to indicate the state of modifier keys.
     */
static GType
skk_modifier_type_get_type_once (void)
{
	static const GFlagsValue values[] = {{SKK_MODIFIER_TYPE_NONE, "SKK_MODIFIER_TYPE_NONE", "none"}, {SKK_MODIFIER_TYPE_SHIFT_MASK, "SKK_MODIFIER_TYPE_SHIFT_MASK", "shift-mask"}, {SKK_MODIFIER_TYPE_LOCK_MASK, "SKK_MODIFIER_TYPE_LOCK_MASK", "lock-mask"}, {SKK_MODIFIER_TYPE_CONTROL_MASK, "SKK_MODIFIER_TYPE_CONTROL_MASK", "control-mask"}, {SKK_MODIFIER_TYPE_MOD1_MASK, "SKK_MODIFIER_TYPE_MOD1_MASK", "mod1-mask"}, {SKK_MODIFIER_TYPE_MOD2_MASK, "SKK_MODIFIER_TYPE_MOD2_MASK", "mod2-mask"}, {SKK_MODIFIER_TYPE_MOD3_MASK, "SKK_MODIFIER_TYPE_MOD3_MASK", "mod3-mask"}, {SKK_MODIFIER_TYPE_MOD4_MASK, "SKK_MODIFIER_TYPE_MOD4_MASK", "mod4-mask"}, {SKK_MODIFIER_TYPE_MOD5_MASK, "SKK_MODIFIER_TYPE_MOD5_MASK", "mod5-mask"}, {SKK_MODIFIER_TYPE_LSHIFT_MASK, "SKK_MODIFIER_TYPE_LSHIFT_MASK", "lshift-mask"}, {SKK_MODIFIER_TYPE_RSHIFT_MASK, "SKK_MODIFIER_TYPE_RSHIFT_MASK", "rshift-mask"}, {SKK_MODIFIER_TYPE_USLEEP_MASK, "SKK_MODIFIER_TYPE_USLEEP_MASK", "usleep-mask"}, {SKK_MODIFIER_TYPE_SUPER_MASK, "SKK_MODIFIER_TYPE_SUPER_MASK", "super-mask"}, {SKK_MODIFIER_TYPE_HYPER_MASK, "SKK_MODIFIER_TYPE_HYPER_MASK", "hyper-mask"}, {SKK_MODIFIER_TYPE_META_MASK, "SKK_MODIFIER_TYPE_META_MASK", "meta-mask"}, {SKK_MODIFIER_TYPE_RELEASE_MASK, "SKK_MODIFIER_TYPE_RELEASE_MASK", "release-mask"}, {0, NULL, NULL}};
	GType skk_modifier_type_type_id;
	skk_modifier_type_type_id = g_flags_register_static ("SkkModifierType", values);
	return skk_modifier_type_type_id;
}

GType
skk_modifier_type_get_type (void)
{
	static volatile gsize skk_modifier_type_type_id__once = 0;
	if (g_once_init_enter (&skk_modifier_type_type_id__once)) {
		GType skk_modifier_type_type_id;
		skk_modifier_type_type_id = skk_modifier_type_get_type_once ();
		g_once_init_leave (&skk_modifier_type_type_id__once, skk_modifier_type_type_id);
	}
	return skk_modifier_type_type_id__once;
}

static inline gpointer
skk_key_event_get_instance_private (SkkKeyEvent* self)
{
	return G_STRUCT_MEMBER_P (self, SkkKeyEvent_private_offset);
}

/**
         * Create a key event.
         *
         * @param name a key name
         * @param code a character code
         * @param modifiers state of modifier keys
         *
         * @return a new KeyEvent
         */
SkkKeyEvent*
skk_key_event_construct (GType object_type,
                         const gchar* name,
                         gunichar code,
                         SkkModifierType modifiers)
{
	SkkKeyEvent * self = NULL;
	self = (SkkKeyEvent*) g_object_new (object_type, NULL);
	skk_key_event_set_name (self, name);
	skk_key_event_set_code (self, code);
	skk_key_event_set_modifiers (self, modifiers);
	return self;
}

SkkKeyEvent*
skk_key_event_new (const gchar* name,
                   gunichar code,
                   SkkModifierType modifiers)
{
	return skk_key_event_construct (SKK_TYPE_KEY_EVENT, name, code, modifiers);
}

/**
         * Create a copy of the key event.
         *
         * @return a new KeyEvent
         */
SkkKeyEvent*
skk_key_event_copy (SkkKeyEvent* self)
{
	const gchar* _tmp0_;
	gunichar _tmp1_;
	SkkModifierType _tmp2_;
	SkkKeyEvent* _tmp3_;
	SkkKeyEvent* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = self->priv->_code;
	_tmp2_ = self->priv->_modifiers;
	_tmp3_ = skk_key_event_new (_tmp0_, _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}

/**
         * Create a key event from string.
         *
         * @param key a string representation of a key event
         *
         * @return a new KeyEvent
         */
static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

SkkKeyEvent*
skk_key_event_construct_from_string (GType object_type,
                                     const gchar* key,
                                     GError** error)
{
	SkkKeyEvent * self = NULL;
	SkkModifierType _modifiers = 0U;
	guint _keyval = 0U;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	self = (SkkKeyEvent*) g_object_new (object_type, NULL);
	_modifiers = 0;
	_keyval = SKK_KEYSYMS_VoidSymbol;
	if (g_str_has_prefix (key, "(usleep ")) {
		_tmp0_ = g_str_has_suffix (key, ")");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar** strv = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gint strv_length1;
		gint _strv_size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		SkkModifierType _tmp10_;
		_tmp1_ = string_slice (key, (glong) 1, (glong) -1);
		_tmp2_ = _tmp1_;
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _vala_array_length (_tmp3_);
		_g_free0 (_tmp2_);
		strv = _tmp5_;
		strv_length1 = _tmp5__length1;
		_strv_size_ = strv_length1;
		_tmp6_ = strv;
		_tmp6__length1 = strv_length1;
		if (_tmp6__length1 != 2) {
			GError* _tmp7_;
			_tmp7_ = g_error_new_literal (SKK_KEY_EVENT_FORMAT_ERROR, SKK_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "usleep requires duration");
			_inner_error0_ = _tmp7_;
			if (_inner_error0_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
				g_propagate_error (error, _inner_error0_);
				strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (self);
				return NULL;
			} else {
				strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp8_ = strv;
		_tmp8__length1 = strv_length1;
		_tmp9_ = _tmp8_[1];
		skk_key_event_set_name (self, _tmp9_);
		skk_key_event_set_code (self, (gunichar) '\0');
		_tmp10_ = self->priv->_modifiers;
		skk_key_event_set_modifiers (self, _tmp10_ | SKK_MODIFIER_TYPE_USLEEP_MASK);
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	} else {
		gboolean _tmp11_ = FALSE;
		if (g_str_has_prefix (key, "(")) {
			_tmp11_ = g_str_has_suffix (key, ")");
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gchar** strv = NULL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar** _tmp14_;
			gchar** _tmp15_;
			gchar** _tmp16_;
			gint _tmp16__length1;
			gint strv_length1;
			gint _strv_size_;
			gint index = 0;
			gboolean _tmp41_ = FALSE;
			gchar** _tmp42_;
			gint _tmp42__length1;
			const gchar* _tmp43_;
			_tmp12_ = string_slice (key, (glong) 1, (glong) -1);
			_tmp13_ = _tmp12_;
			_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, " ", 0);
			_tmp16_ = _tmp15_;
			_tmp16__length1 = _vala_array_length (_tmp14_);
			_g_free0 (_tmp13_);
			strv = _tmp16_;
			strv_length1 = _tmp16__length1;
			_strv_size_ = strv_length1;
			index = 0;
			{
				gboolean _tmp17_ = FALSE;
				_tmp17_ = TRUE;
				while (TRUE) {
					gchar** _tmp19_;
					gint _tmp19__length1;
					gchar** _tmp20_;
					gint _tmp20__length1;
					const gchar* _tmp21_;
					if (!_tmp17_) {
						gint _tmp18_;
						_tmp18_ = index;
						index = _tmp18_ + 1;
					}
					_tmp17_ = FALSE;
					_tmp19_ = strv;
					_tmp19__length1 = strv_length1;
					if (!(index < (_tmp19__length1 - 1))) {
						break;
					}
					_tmp20_ = strv;
					_tmp20__length1 = strv_length1;
					_tmp21_ = _tmp20_[index];
					if (g_strcmp0 (_tmp21_, "shift") == 0) {
						_modifiers |= SKK_MODIFIER_TYPE_SHIFT_MASK;
					} else {
						gchar** _tmp22_;
						gint _tmp22__length1;
						const gchar* _tmp23_;
						_tmp22_ = strv;
						_tmp22__length1 = strv_length1;
						_tmp23_ = _tmp22_[index];
						if (g_strcmp0 (_tmp23_, "control") == 0) {
							_modifiers |= SKK_MODIFIER_TYPE_CONTROL_MASK;
						} else {
							gchar** _tmp24_;
							gint _tmp24__length1;
							const gchar* _tmp25_;
							_tmp24_ = strv;
							_tmp24__length1 = strv_length1;
							_tmp25_ = _tmp24_[index];
							if (g_strcmp0 (_tmp25_, "meta") == 0) {
								_modifiers |= SKK_MODIFIER_TYPE_META_MASK;
							} else {
								gchar** _tmp26_;
								gint _tmp26__length1;
								const gchar* _tmp27_;
								_tmp26_ = strv;
								_tmp26__length1 = strv_length1;
								_tmp27_ = _tmp26_[index];
								if (g_strcmp0 (_tmp27_, "hyper") == 0) {
									_modifiers |= SKK_MODIFIER_TYPE_HYPER_MASK;
								} else {
									gchar** _tmp28_;
									gint _tmp28__length1;
									const gchar* _tmp29_;
									_tmp28_ = strv;
									_tmp28__length1 = strv_length1;
									_tmp29_ = _tmp28_[index];
									if (g_strcmp0 (_tmp29_, "super") == 0) {
										_modifiers |= SKK_MODIFIER_TYPE_SUPER_MASK;
									} else {
										gchar** _tmp30_;
										gint _tmp30__length1;
										const gchar* _tmp31_;
										_tmp30_ = strv;
										_tmp30__length1 = strv_length1;
										_tmp31_ = _tmp30_[index];
										if (g_strcmp0 (_tmp31_, "alt") == 0) {
											_modifiers |= SKK_MODIFIER_TYPE_MOD1_MASK;
										} else {
											gchar** _tmp32_;
											gint _tmp32__length1;
											const gchar* _tmp33_;
											_tmp32_ = strv;
											_tmp32__length1 = strv_length1;
											_tmp33_ = _tmp32_[index];
											if (g_strcmp0 (_tmp33_, "lshift") == 0) {
												_modifiers |= SKK_MODIFIER_TYPE_LSHIFT_MASK;
											} else {
												gchar** _tmp34_;
												gint _tmp34__length1;
												const gchar* _tmp35_;
												_tmp34_ = strv;
												_tmp34__length1 = strv_length1;
												_tmp35_ = _tmp34_[index];
												if (g_strcmp0 (_tmp35_, "rshift") == 0) {
													_modifiers |= SKK_MODIFIER_TYPE_RSHIFT_MASK;
												} else {
													gchar** _tmp36_;
													gint _tmp36__length1;
													const gchar* _tmp37_;
													_tmp36_ = strv;
													_tmp36__length1 = strv_length1;
													_tmp37_ = _tmp36_[index];
													if (g_strcmp0 (_tmp37_, "release") == 0) {
														_modifiers |= SKK_MODIFIER_TYPE_RELEASE_MASK;
													} else {
														gchar** _tmp38_;
														gint _tmp38__length1;
														const gchar* _tmp39_;
														GError* _tmp40_;
														_tmp38_ = strv;
														_tmp38__length1 = strv_length1;
														_tmp39_ = _tmp38_[index];
														_tmp40_ = g_error_new (SKK_KEY_EVENT_FORMAT_ERROR, SKK_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "unknown modifier %s", _tmp39_);
														_inner_error0_ = _tmp40_;
														if (_inner_error0_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
															g_propagate_error (error, _inner_error0_);
															strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
															_g_object_unref0 (self);
															return NULL;
														} else {
															strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
															g_clear_error (&_inner_error0_);
															return NULL;
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp42_ = strv;
			_tmp42__length1 = strv_length1;
			_tmp43_ = _tmp42_[index];
			if (g_strcmp0 (_tmp43_, "lshift") == 0) {
				_tmp41_ = TRUE;
			} else {
				gchar** _tmp44_;
				gint _tmp44__length1;
				const gchar* _tmp45_;
				_tmp44_ = strv;
				_tmp44__length1 = strv_length1;
				_tmp45_ = _tmp44_[index];
				_tmp41_ = g_strcmp0 (_tmp45_, "rshift") == 0;
			}
			if (_tmp41_) {
				gchar** _tmp46_;
				gint _tmp46__length1;
				const gchar* _tmp47_;
				_tmp46_ = strv;
				_tmp46__length1 = strv_length1;
				_tmp47_ = _tmp46_[index];
				skk_key_event_set_name (self, _tmp47_);
				skk_key_event_set_code (self, (gunichar) '\0');
				skk_key_event_set_modifiers (self, SKK_MODIFIER_TYPE_NONE);
			} else {
				gchar** _tmp48_;
				gint _tmp48__length1;
				const gchar* _tmp49_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp48_ = strv;
				_tmp48__length1 = strv_length1;
				_tmp49_ = _tmp48_[index];
				_keyval = skk_key_event_utils_keyval_from_name (_tmp49_);
				if (_keyval == SKK_KEYSYMS_VoidSymbol) {
					gchar** _tmp50_;
					gint _tmp50__length1;
					const gchar* _tmp51_;
					GError* _tmp52_;
					_tmp50_ = strv;
					_tmp50__length1 = strv_length1;
					_tmp51_ = _tmp50_[index];
					_tmp52_ = g_error_new (SKK_KEY_EVENT_FORMAT_ERROR, SKK_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "unknown keyval %s", _tmp51_);
					_inner_error0_ = _tmp52_;
					if (_inner_error0_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
						g_propagate_error (error, _inner_error0_);
						strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (self);
						return NULL;
					} else {
						strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp53_ = skk_key_event_utils_keyval_name (_keyval);
				_tmp54_ = _tmp53_;
				skk_key_event_set_name (self, _tmp54_);
				_g_free0 (_tmp54_);
				skk_key_event_set_code (self, skk_key_event_utils_keyval_unicode (_keyval));
				skk_key_event_set_modifiers (self, _modifiers);
			}
			strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
		} else {
			gboolean _tmp55_ = FALSE;
			gboolean _tmp56_ = FALSE;
			if (g_str_has_prefix (key, "[")) {
				_tmp56_ = g_str_has_suffix (key, "]");
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				_tmp55_ = g_utf8_strlen (key, (gssize) -1) == 4;
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				skk_key_event_set_name (self, key);
				skk_key_event_set_code (self, (gunichar) '\0');
				skk_key_event_set_modifiers (self, SKK_MODIFIER_TYPE_NONE);
			} else {
				gint index = 0;
				gchar* _name = NULL;
				const gchar* _tmp71_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				index = string_last_index_of (key, "-", 0);
				_name = NULL;
				if (index > 0) {
					gchar** mods = NULL;
					gchar* _tmp57_;
					gchar* _tmp58_;
					gchar** _tmp59_;
					gchar** _tmp60_;
					gchar** _tmp61_;
					gint _tmp61__length1;
					gint mods_length1;
					gint _mods_size_;
					gchar** _tmp62_;
					gint _tmp62__length1;
					gchar* _tmp69_;
					_tmp57_ = string_substring (key, (glong) 0, (glong) index);
					_tmp58_ = _tmp57_;
					_tmp60_ = _tmp59_ = g_strsplit (_tmp58_, "-", 0);
					_tmp61_ = _tmp60_;
					_tmp61__length1 = _vala_array_length (_tmp59_);
					_g_free0 (_tmp58_);
					mods = _tmp61_;
					mods_length1 = _tmp61__length1;
					_mods_size_ = mods_length1;
					_tmp62_ = mods;
					_tmp62__length1 = mods_length1;
					{
						gchar** mod_collection = NULL;
						gint mod_collection_length1 = 0;
						gint _mod_collection_size_ = 0;
						gint mod_it = 0;
						mod_collection = _tmp62_;
						mod_collection_length1 = _tmp62__length1;
						for (mod_it = 0; mod_it < mod_collection_length1; mod_it = mod_it + 1) {
							gchar* _tmp63_;
							gchar* mod = NULL;
							_tmp63_ = g_strdup (mod_collection[mod_it]);
							mod = _tmp63_;
							{
								const gchar* _tmp64_;
								_tmp64_ = mod;
								if (g_strcmp0 (_tmp64_, "S") == 0) {
									_modifiers |= SKK_MODIFIER_TYPE_SHIFT_MASK;
								} else {
									const gchar* _tmp65_;
									_tmp65_ = mod;
									if (g_strcmp0 (_tmp65_, "C") == 0) {
										_modifiers |= SKK_MODIFIER_TYPE_CONTROL_MASK;
									} else {
										const gchar* _tmp66_;
										_tmp66_ = mod;
										if (g_strcmp0 (_tmp66_, "A") == 0) {
											_modifiers |= SKK_MODIFIER_TYPE_MOD1_MASK;
										} else {
											const gchar* _tmp67_;
											_tmp67_ = mod;
											if (g_strcmp0 (_tmp67_, "M") == 0) {
												_modifiers |= SKK_MODIFIER_TYPE_META_MASK;
											} else {
												const gchar* _tmp68_;
												_tmp68_ = mod;
												if (g_strcmp0 (_tmp68_, "G") == 0) {
													_modifiers |= SKK_MODIFIER_TYPE_MOD5_MASK;
												}
											}
										}
									}
								}
								_g_free0 (mod);
							}
						}
					}
					_tmp69_ = string_substring (key, (glong) (index + 1), (glong) -1);
					_g_free0 (_name);
					_name = _tmp69_;
					mods = (_vala_array_free (mods, mods_length1, (GDestroyNotify) g_free), NULL);
				} else {
					gchar* _tmp70_;
					_modifiers = SKK_MODIFIER_TYPE_NONE;
					_tmp70_ = g_strdup (key);
					_g_free0 (_name);
					_name = _tmp70_;
				}
				_tmp71_ = _name;
				_keyval = skk_key_event_utils_keyval_from_name (_tmp71_);
				if (_keyval == SKK_KEYSYMS_VoidSymbol) {
					const gchar* _tmp72_;
					GError* _tmp73_;
					_tmp72_ = _name;
					_tmp73_ = g_error_new (SKK_KEY_EVENT_FORMAT_ERROR, SKK_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "unknown keyval %s", _tmp72_);
					_inner_error0_ = _tmp73_;
					if (_inner_error0_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (_name);
						_g_object_unref0 (self);
						return NULL;
					} else {
						_g_free0 (_name);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp74_ = skk_key_event_utils_keyval_name (_keyval);
				_tmp75_ = _tmp74_;
				skk_key_event_set_name (self, _tmp75_);
				_g_free0 (_tmp75_);
				skk_key_event_set_code (self, skk_key_event_utils_keyval_unicode (_keyval));
				skk_key_event_set_modifiers (self, _modifiers);
				_g_free0 (_name);
			}
		}
	}
	return self;
}

SkkKeyEvent*
skk_key_event_new_from_string (const gchar* key,
                               GError** error)
{
	return skk_key_event_construct_from_string (SKK_TYPE_KEY_EVENT, key, error);
}

/**
         * Convert the KeyEvent to string.
         *
         * @return a string representing the KeyEvent
         */
static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
skk_key_event_to_string (SkkKeyEvent* self)
{
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _base = NULL;
	gchar* _tmp6_;
	SkkModifierType _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_name;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_name;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gunichar _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->_code;
		_tmp5_ = g_unichar_to_string (_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp0_);
	_base = _tmp6_;
	_tmp7_ = self->priv->_modifiers;
	if (_tmp7_ != 0) {
		GeeArrayList* elements = NULL;
		GeeArrayList* _tmp8_;
		SkkModifierType _tmp9_;
		SkkModifierType _tmp11_;
		SkkModifierType _tmp13_;
		SkkModifierType _tmp15_;
		SkkModifierType _tmp17_;
		SkkModifierType _tmp19_;
		SkkModifierType _tmp21_;
		SkkModifierType _tmp23_;
		SkkModifierType _tmp25_;
		GeeArrayList* _tmp27_;
		const gchar* _tmp28_;
		GeeArrayList* _tmp29_;
		gchar** array = NULL;
		GeeArrayList* _tmp30_;
		gint _tmp31_ = 0;
		gpointer* _tmp32_;
		gint array_length1;
		gint _array_size_;
		gint old_length = 0;
		gchar** _tmp33_;
		gint _tmp33__length1;
		gchar* key_string = NULL;
		gchar** _tmp34_;
		gint _tmp34__length1;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		elements = _tmp8_;
		_tmp9_ = self->priv->_modifiers;
		if ((_tmp9_ & SKK_MODIFIER_TYPE_CONTROL_MASK) != 0) {
			GeeArrayList* _tmp10_;
			_tmp10_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, "control");
		}
		_tmp11_ = self->priv->_modifiers;
		if ((_tmp11_ & SKK_MODIFIER_TYPE_META_MASK) != 0) {
			GeeArrayList* _tmp12_;
			_tmp12_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, "meta");
		}
		_tmp13_ = self->priv->_modifiers;
		if ((_tmp13_ & SKK_MODIFIER_TYPE_HYPER_MASK) != 0) {
			GeeArrayList* _tmp14_;
			_tmp14_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, "hyper");
		}
		_tmp15_ = self->priv->_modifiers;
		if ((_tmp15_ & SKK_MODIFIER_TYPE_SUPER_MASK) != 0) {
			GeeArrayList* _tmp16_;
			_tmp16_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, "super");
		}
		_tmp17_ = self->priv->_modifiers;
		if ((_tmp17_ & SKK_MODIFIER_TYPE_MOD1_MASK) != 0) {
			GeeArrayList* _tmp18_;
			_tmp18_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, "alt");
		}
		_tmp19_ = self->priv->_modifiers;
		if ((_tmp19_ & SKK_MODIFIER_TYPE_LSHIFT_MASK) != 0) {
			GeeArrayList* _tmp20_;
			_tmp20_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, "lshift");
		}
		_tmp21_ = self->priv->_modifiers;
		if ((_tmp21_ & SKK_MODIFIER_TYPE_RSHIFT_MASK) != 0) {
			GeeArrayList* _tmp22_;
			_tmp22_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, "rshift");
		}
		_tmp23_ = self->priv->_modifiers;
		if ((_tmp23_ & SKK_MODIFIER_TYPE_USLEEP_MASK) != 0) {
			GeeArrayList* _tmp24_;
			_tmp24_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, "usleep");
		}
		_tmp25_ = self->priv->_modifiers;
		if ((_tmp25_ & SKK_MODIFIER_TYPE_RELEASE_MASK) != 0) {
			GeeArrayList* _tmp26_;
			_tmp26_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, "release");
		}
		_tmp27_ = elements;
		_tmp28_ = _base;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
		_tmp29_ = elements;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, NULL);
		_tmp30_ = elements;
		_tmp32_ = gee_collection_to_array ((GeeCollection*) _tmp30_, &_tmp31_);
		array = _tmp32_;
		array_length1 = _tmp31_;
		_array_size_ = array_length1;
		_tmp33_ = array;
		_tmp33__length1 = array_length1;
		old_length = _tmp33__length1;
		array_length1 = -1;
		_tmp34_ = array;
		_tmp34__length1 = array_length1;
		_tmp35_ = _vala_g_strjoinv (" ", _tmp34_, (gint) _tmp34__length1);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat ("(", _tmp36_, NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat (_tmp38_, ")", NULL);
		_tmp40_ = _tmp39_;
		_g_free0 (_tmp38_);
		_g_free0 (_tmp36_);
		key_string = _tmp40_;
		array_length1 = old_length;
		result = key_string;
		array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (elements);
		_g_free0 (_base);
		_g_free0 (_tmp0_);
		return result;
	} else {
		result = _base;
		_g_free0 (_tmp0_);
		return result;
	}
}

/**
         * Create a key event from an X keysym and modifiers.
         *
         * @param keyval an X keysym
         * @param modifiers modifier mask
         *
         * @return a new KeyEvent
         */
SkkKeyEvent*
skk_key_event_construct_from_x_keysym (GType object_type,
                                       guint keyval,
                                       SkkModifierType modifiers,
                                       GError** error)
{
	SkkKeyEvent * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SkkKeyEvent*) g_object_new (object_type, NULL);
	_tmp0_ = skk_key_event_utils_keyval_name (keyval);
	_tmp1_ = _tmp0_;
	skk_key_event_set_name (self, _tmp1_);
	_g_free0 (_tmp1_);
	skk_key_event_set_code (self, skk_key_event_utils_keyval_unicode (keyval));
	skk_key_event_set_modifiers (self, modifiers);
	return self;
}

SkkKeyEvent*
skk_key_event_new_from_x_keysym (guint keyval,
                                 SkkModifierType modifiers,
                                 GError** error)
{
	return skk_key_event_construct_from_x_keysym (SKK_TYPE_KEY_EVENT, keyval, modifiers, error);
}

/**
         * Compare two key events ignoring modifiers.
         *
         * @param key a KeyEvent
         *
         * @return `true` if those base components are equal, `false` otherwise
         */
gboolean
skk_key_event_base_equal (SkkKeyEvent* self,
                          SkkKeyEvent* key)
{
	gboolean _tmp0_ = FALSE;
	gunichar _tmp1_;
	gunichar _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp1_ = self->priv->_code;
	_tmp2_ = key->priv->_code;
	if (_tmp1_ == _tmp2_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->_name;
		_tmp4_ = key->priv->_name;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

const gchar*
skk_key_event_get_name (SkkKeyEvent* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
skk_key_event_set_name (SkkKeyEvent* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = skk_key_event_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, skk_key_event_properties[SKK_KEY_EVENT_NAME_PROPERTY]);
	}
}

gunichar
skk_key_event_get_code (SkkKeyEvent* self)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_code;
	return result;
}

static void
skk_key_event_set_code (SkkKeyEvent* self,
                        gunichar value)
{
	gunichar old_value;
	g_return_if_fail (self != NULL);
	old_value = skk_key_event_get_code (self);
	if (old_value != value) {
		self->priv->_code = value;
		g_object_notify_by_pspec ((GObject *) self, skk_key_event_properties[SKK_KEY_EVENT_CODE_PROPERTY]);
	}
}

SkkModifierType
skk_key_event_get_modifiers (SkkKeyEvent* self)
{
	SkkModifierType result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_modifiers;
	return result;
}

void
skk_key_event_set_modifiers (SkkKeyEvent* self,
                             SkkModifierType value)
{
	SkkModifierType old_value;
	g_return_if_fail (self != NULL);
	old_value = skk_key_event_get_modifiers (self);
	if (old_value != value) {
		self->priv->_modifiers = value;
		g_object_notify_by_pspec ((GObject *) self, skk_key_event_properties[SKK_KEY_EVENT_MODIFIERS_PROPERTY]);
	}
}

static void
skk_key_event_class_init (SkkKeyEventClass * klass,
                          gpointer klass_data)
{
	skk_key_event_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkKeyEvent_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_key_event_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_skk_key_event_set_property;
	G_OBJECT_CLASS (klass)->finalize = skk_key_event_finalize;
	/**
	         * The base name of the KeyEvent.
	         *
	         * This is exclusive to {@link code}.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_KEY_EVENT_NAME_PROPERTY, skk_key_event_properties[SKK_KEY_EVENT_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * The base code of the KeyEvent.
	         *
	         * This is exclusive to {@link name}.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_KEY_EVENT_CODE_PROPERTY, skk_key_event_properties[SKK_KEY_EVENT_CODE_PROPERTY] = g_param_spec_uint ("code", "code", "code", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * Modifier mask.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_KEY_EVENT_MODIFIERS_PROPERTY, skk_key_event_properties[SKK_KEY_EVENT_MODIFIERS_PROPERTY] = g_param_spec_flags ("modifiers", "modifiers", "modifiers", SKK_TYPE_MODIFIER_TYPE, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
skk_key_event_instance_init (SkkKeyEvent * self,
                             gpointer klass)
{
	self->priv = skk_key_event_get_instance_private (self);
}

static void
skk_key_event_finalize (GObject * obj)
{
	SkkKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_KEY_EVENT, SkkKeyEvent);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (skk_key_event_parent_class)->finalize (obj);
}

/**
     * Object representing a key event.
     */
static GType
skk_key_event_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkKeyEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_key_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkKeyEvent), 0, (GInstanceInitFunc) skk_key_event_instance_init, NULL };
	GType skk_key_event_type_id;
	skk_key_event_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkKeyEvent", &g_define_type_info, 0);
	SkkKeyEvent_private_offset = g_type_add_instance_private (skk_key_event_type_id, sizeof (SkkKeyEventPrivate));
	return skk_key_event_type_id;
}

GType
skk_key_event_get_type (void)
{
	static volatile gsize skk_key_event_type_id__once = 0;
	if (g_once_init_enter (&skk_key_event_type_id__once)) {
		GType skk_key_event_type_id;
		skk_key_event_type_id = skk_key_event_get_type_once ();
		g_once_init_leave (&skk_key_event_type_id__once, skk_key_event_type_id);
	}
	return skk_key_event_type_id__once;
}

static void
_vala_skk_key_event_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	SkkKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_KEY_EVENT, SkkKeyEvent);
	switch (property_id) {
		case SKK_KEY_EVENT_NAME_PROPERTY:
		g_value_set_string (value, skk_key_event_get_name (self));
		break;
		case SKK_KEY_EVENT_CODE_PROPERTY:
		g_value_set_uint (value, skk_key_event_get_code (self));
		break;
		case SKK_KEY_EVENT_MODIFIERS_PROPERTY:
		g_value_set_flags (value, skk_key_event_get_modifiers (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_skk_key_event_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	SkkKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_KEY_EVENT, SkkKeyEvent);
	switch (property_id) {
		case SKK_KEY_EVENT_NAME_PROPERTY:
		skk_key_event_set_name (self, g_value_get_string (value));
		break;
		case SKK_KEY_EVENT_CODE_PROPERTY:
		skk_key_event_set_code (self, g_value_get_uint (value));
		break;
		case SKK_KEY_EVENT_MODIFIERS_PROPERTY:
		skk_key_event_set_modifiers (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

