// Don't modify, generated file from /build/libresprite/src/libresprite/data/pref.xml

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "app/pref/option_io.h"
#include "app/pref/preferences.h"

namespace app {
namespace gen {

GlobalPref::GlobalPref(const std::string& name)
  : Section(name)
  , general(name)
  , undo(name)
  , editor(name)
  , preview(name)
  , theme(name)
  , experimental(name)
  , touchBar(name)
  , statusBar(name)
  , colorBar(name)
  , brush(name)
  , saveBrush(name)
  , selection(name)
  , quantization(name)
  , eyedropper(name)
  , shared(name)
  , newFile(name)
  , textTool(name)
  , symmetryMode(name)
{
}

void GlobalPref::load()
{
  general.load();
  undo.load();
  editor.load();
  preview.load();
  theme.load();
  experimental.load();
  touchBar.load();
  statusBar.load();
  colorBar.load();
  brush.load();
  saveBrush.load();
  selection.load();
  quantization.load();
  eyedropper.load();
  shared.load();
  newFile.load();
  textTool.load();
  symmetryMode.load();
}

void GlobalPref::save()
{
  general.save();
  undo.save();
  editor.save();
  preview.save();
  theme.save();
  experimental.save();
  touchBar.save();
  statusBar.save();
  colorBar.save();
  brush.save();
  saveBrush.save();
  selection.save();
  quantization.save();
  eyedropper.save();
  shared.save();
  newFile.save();
  textTool.save();
  symmetryMode.save();
}

GlobalPref::General::General(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "general")
  , language(this, "language", "en")
  , screenScale(this, "screen_scale", 0)
  , gpuAcceleration(this, "gpu_acceleration", true)
  , visibleTimeline(this, "visible_timeline", false)
  , verticalTimeline(this, "vertical_timeline", false)
  , autoshowTimeline(this, "autoshow_timeline", true)
  , leftToolBar(this, "left_tool_bar", false)
  , rewindOnStop(this, "rewind_on_stop", false)
  , expandMenubarOnMouseover(this, "expand_menubar_on_mouseover", false)
  , dataRecovery(this, "data_recovery", true)
  , dataRecoveryPeriod(this, "data_recovery_period", 2)
  , showFullPath(this, "show_full_path", true)
{
}

void GlobalPref::General::load()
{
  load_option(language);
  load_option(screenScale);
  load_option(gpuAcceleration);
  load_option(visibleTimeline);
  load_option(verticalTimeline);
  load_option_with_migration(autoshowTimeline, "Options", "AutoShowTimeline");
  load_option(leftToolBar);
  load_option(rewindOnStop);
  load_option_with_migration(expandMenubarOnMouseover, "Options", "ExpandMenuBarOnMouseover");
  load_option(dataRecovery);
  load_option(dataRecoveryPeriod);
  load_option(showFullPath);
}

void GlobalPref::General::save()
{
  save_option(language);
  save_option(screenScale);
  save_option(gpuAcceleration);
  save_option(visibleTimeline);
  save_option(verticalTimeline);
  save_option(autoshowTimeline);
  save_option(leftToolBar);
  save_option(rewindOnStop);
  save_option(expandMenubarOnMouseover);
  save_option(dataRecovery);
  save_option(dataRecoveryPeriod);
  save_option(showFullPath);
}

GlobalPref::Undo::Undo(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "undo")
  , sizeLimit(this, "size_limit", 64)
  , gotoModified(this, "goto_modified", true)
  , allowNonlinearHistory(this, "allow_nonlinear_history", false)
{
}

void GlobalPref::Undo::load()
{
  load_option(sizeLimit);
  load_option(gotoModified);
  load_option(allowNonlinearHistory);
}

void GlobalPref::Undo::save()
{
  save_option(sizeLimit);
  save_option(gotoModified);
  save_option(allowNonlinearHistory);
}

GlobalPref::Editor::Editor(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "editor")
  , zoomWithWheel(this, "zoom_with_wheel", true)
  , zoomWithSlide(this, "zoom_with_slide", false)
  , zoomFromCenterWithWheel(this, "zoom_from_center_with_wheel", false)
  , zoomFromCenterWithKeys(this, "zoom_from_center_with_keys", false)
  , showScrollbars(this, "show_scrollbars", true)
  , rightClickMode(this, "right_click_mode", RightClickMode::PAINT_BGCOLOR)
  , autoSelectLayer(this, "auto_select_layer", false)
  , cursorColor(this, "cursor_color", app::Color::fromMask())
  , brushPreview(this, "brush_preview", BrushPreview::FULL)
  , playOnce(this, "play_once", false)
{
}

void GlobalPref::Editor::load()
{
  load_option_with_migration(zoomWithWheel, "Options", "ZoomWithMouseWheel");
  load_option(zoomWithSlide);
  load_option(zoomFromCenterWithWheel);
  load_option(zoomFromCenterWithKeys);
  load_option_with_migration(showScrollbars, "Options", "ShowScrollbars");
  load_option_with_migration(rightClickMode, "Options", "RightClickMode");
  load_option_with_migration(autoSelectLayer, "Options", "AutoSelectLayer");
  load_option_with_migration(cursorColor, "Tools", "CursorColor");
  load_option(brushPreview);
  load_option(playOnce);
}

void GlobalPref::Editor::save()
{
  save_option(zoomWithWheel);
  save_option(zoomWithSlide);
  save_option(zoomFromCenterWithWheel);
  save_option(zoomFromCenterWithKeys);
  save_option(showScrollbars);
  save_option(rightClickMode);
  save_option(autoSelectLayer);
  save_option(cursorColor);
  save_option(brushPreview);
  save_option(playOnce);
}

GlobalPref::Preview::Preview(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "preview")
  , playOnce(this, "play_once", false)
{
}

void GlobalPref::Preview::load()
{
  load_option(playOnce);
}

void GlobalPref::Preview::save()
{
  save_option(playOnce);
}

GlobalPref::Theme::Theme(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "theme")
  , selected(this, "selected", "default")
  , font(this, "font")
  , miniFont(this, "mini_font")
{
}

void GlobalPref::Theme::load()
{
  load_option_with_migration(selected, "Skin", "Selected");
  load_option_with_migration(font, "Options", "UserFont");
  load_option_with_migration(miniFont, "Options", "UserMiniFont");
}

void GlobalPref::Theme::save()
{
  save_option(selected);
  save_option(font);
  save_option(miniFont);
}

GlobalPref::Experimental::Experimental(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "experimental")
  , uiScale(this, "ui_scale", 0)
  , useNativeCursor(this, "use_native_cursor", true)
  , useNativeFileDialog(this, "use_native_file_dialog", false)
  , flashLayer(this, "flash_layer", false)
{
}

void GlobalPref::Experimental::load()
{
  load_option(uiScale);
  load_option_with_migration(useNativeCursor, "Options", "NativeCursor");
  load_option(useNativeFileDialog);
  load_option_with_migration(flashLayer, "Options", "FlashLayer");
}

void GlobalPref::Experimental::save()
{
  save_option(uiScale);
  save_option(useNativeCursor);
  save_option(useNativeFileDialog);
  save_option(flashLayer);
}

GlobalPref::TouchBar::TouchBar(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "touch_bar")
  , visible(this, "visible", false)
  , alternatePosition(this, "alternate_position", false)
{
}

void GlobalPref::TouchBar::load()
{
  load_option(visible);
  load_option(alternatePosition);
}

void GlobalPref::TouchBar::save()
{
  save_option(visible);
  save_option(alternatePosition);
}

GlobalPref::StatusBar::StatusBar(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "status_bar")
  , focusFrameFieldOnMouseover(this, "focus_frame_field_on_mouseover", false)
{
}

void GlobalPref::StatusBar::load()
{
  load_option(focusFrameFieldOnMouseover);
}

void GlobalPref::StatusBar::save()
{
  save_option(focusFrameFieldOnMouseover);
}

GlobalPref::ColorBar::ColorBar(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "color_bar")
  , boxSize(this, "box_size", 11)
  , fgColor(this, "fg_color", app::Color::fromRgb(255, 255, 255))
  , bgColor(this, "bg_color", app::Color::fromRgb(0, 0, 0))
  , selector(this, "selector", app::ColorBar::ColorSelector::TINT_SHADE_TONE)
  , discreteWheel(this, "discrete_wheel", false)
  , wheelModel(this, "wheel_model", 0)
  , harmony(this, "harmony", 0)
{
}

void GlobalPref::ColorBar::load()
{
  load_option(boxSize);
  load_option(fgColor);
  load_option(bgColor);
  load_option(selector);
  load_option(discreteWheel);
  load_option(wheelModel);
  load_option(harmony);
}

void GlobalPref::ColorBar::save()
{
  save_option(boxSize);
  save_option(fgColor);
  save_option(bgColor);
  save_option(selector);
  save_option(discreteWheel);
  save_option(wheelModel);
  save_option(harmony);
}

GlobalPref::Brush::Brush(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "brush")
  , pattern(this, "pattern", doc::BrushPattern::DEFAULT)
{
}

void GlobalPref::Brush::load()
{
  load_option(pattern);
}

void GlobalPref::Brush::save()
{
  save_option(pattern);
}

GlobalPref::SaveBrush::SaveBrush(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "save_brush")
  , brushType(this, "brush_type", true)
  , brushSize(this, "brush_size", true)
  , brushAngle(this, "brush_angle", true)
  , fgColor(this, "fg_color", false)
  , bgColor(this, "bg_color", false)
  , inkType(this, "ink_type", true)
  , inkOpacity(this, "ink_opacity", true)
  , shade(this, "shade", true)
  , pixelPerfect(this, "pixel_perfect", false)
{
}

void GlobalPref::SaveBrush::load()
{
  load_option(brushType);
  load_option(brushSize);
  load_option(brushAngle);
  load_option(fgColor);
  load_option(bgColor);
  load_option(inkType);
  load_option(inkOpacity);
  load_option(shade);
  load_option(pixelPerfect);
}

void GlobalPref::SaveBrush::save()
{
  save_option(brushType);
  save_option(brushSize);
  save_option(brushAngle);
  save_option(fgColor);
  save_option(bgColor);
  save_option(inkType);
  save_option(inkOpacity);
  save_option(shade);
  save_option(pixelPerfect);
}

GlobalPref::Selection::Selection(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "selection")
  , mode(this, "mode", SelectionMode::DEFAULT)
  , pivotVisibility(this, "pivot_visibility", false)
  , pivotPosition(this, "pivot_position", PivotPosition::CENTER)
  , opaque(this, "opaque", false)
  , autoOpaque(this, "auto_opaque", true)
  , keepSelectionAfterClear(this, "keep_selection_after_clear", false)
  , transparentColor(this, "transparent_color")
  , rotationAlgorithm(this, "rotation_algorithm", app::tools::RotationAlgorithm::DEFAULT)
  , modifySelectionQuantity(this, "modify_selection_quantity", 1)
  , modifySelectionBrush(this, "modify_selection_brush", BrushType::CIRCLE)
{
}

void GlobalPref::Selection::load()
{
  load_option(mode);
  load_option(pivotVisibility);
  load_option(pivotPosition);
  load_option(opaque);
  load_option(autoOpaque);
  load_option(keepSelectionAfterClear);
  load_option(transparentColor);
  load_option(rotationAlgorithm);
  load_option(modifySelectionQuantity);
  load_option(modifySelectionBrush);
}

void GlobalPref::Selection::save()
{
  save_option(mode);
  save_option(pivotVisibility);
  save_option(pivotPosition);
  save_option(opaque);
  save_option(autoOpaque);
  save_option(keepSelectionAfterClear);
  save_option(transparentColor);
  save_option(rotationAlgorithm);
  save_option(modifySelectionQuantity);
  save_option(modifySelectionBrush);
}

GlobalPref::Quantization::Quantization(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "quantization")
  , withAlpha(this, "with_alpha", true)
{
}

void GlobalPref::Quantization::load()
{
  load_option(withAlpha);
}

void GlobalPref::Quantization::save()
{
  save_option(withAlpha);
}

GlobalPref::Eyedropper::Eyedropper(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "eyedropper")
  , channel(this, "channel", EyedropperChannel::COLOR_ALPHA)
  , sample(this, "sample", EyedropperSample::ALL_LAYERS)
{
}

void GlobalPref::Eyedropper::load()
{
  load_option(channel);
  load_option(sample);
}

void GlobalPref::Eyedropper::save()
{
  save_option(channel);
  save_option(sample);
}

GlobalPref::Shared::Shared(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "shared")
  , shareInk(this, "share_ink", false)
  , ink(this, "ink", app::tools::InkType::DEFAULT)
{
}

void GlobalPref::Shared::load()
{
  load_option(shareInk);
  load_option(ink);
}

void GlobalPref::Shared::save()
{
  save_option(shareInk);
  save_option(ink);
}

GlobalPref::NewFile::NewFile(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "new_file")
  , width(this, "width", 32)
  , height(this, "height", 32)
  , colorMode(this, "color_mode", doc::IMAGE_RGB)
  , backgroundColor(this, "background_color", 0)
{
}

void GlobalPref::NewFile::load()
{
  load_option(width);
  load_option(height);
  load_option(colorMode);
  load_option(backgroundColor);
}

void GlobalPref::NewFile::save()
{
  save_option(width);
  save_option(height);
  save_option(colorMode);
  save_option(backgroundColor);
}

GlobalPref::TextTool::TextTool(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "text_tool")
  , fontFace(this, "font_face")
  , fontSize(this, "font_size", 12)
  , antialias(this, "antialias", false)
{
}

void GlobalPref::TextTool::load()
{
  load_option(fontFace);
  load_option(fontSize);
  load_option(antialias);
}

void GlobalPref::TextTool::save()
{
  save_option(fontFace);
  save_option(fontSize);
  save_option(antialias);
}

GlobalPref::SymmetryMode::SymmetryMode(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "symmetry_mode")
  , enabled(this, "enabled", true)
{
}

void GlobalPref::SymmetryMode::load()
{
  load_option(enabled);
}

void GlobalPref::SymmetryMode::save()
{
  save_option(enabled);
}

ToolPref::ToolPref(const std::string& name)
  : Section(name)
  , opacity(this, "opacity", 255)
  , tolerance(this, "tolerance", 0)
  , contiguous(this, "contiguous", true)
  , filled(this, "filled", false)
  , filledPreview(this, "filled_preview", false)
  , ink(this, "ink", app::tools::InkType::DEFAULT)
  , freehandAlgorithm(this, "freehand_algorithm", app::tools::FreehandAlgorithm::DEFAULT)
  , brush(name)
  , spray(name)
  , floodfill(name)
{
}

void ToolPref::load()
{
  load_option(opacity);
  load_option(tolerance);
  load_option(contiguous);
  load_option(filled);
  load_option(filledPreview);
  load_option(ink);
  load_option(freehandAlgorithm);
  brush.load();
  spray.load();
  floodfill.load();
}

void ToolPref::save()
{
  save_option(opacity);
  save_option(tolerance);
  save_option(contiguous);
  save_option(filled);
  save_option(filledPreview);
  save_option(ink);
  save_option(freehandAlgorithm);
  brush.save();
  spray.save();
  floodfill.save();
}

ToolPref::Brush::Brush(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "brush")
  , type(this, "type", BrushType::CIRCLE)
  , size(this, "size", 1)
  , angle(this, "angle", 0)
{
}

void ToolPref::Brush::load()
{
  load_option(type);
  load_option(size);
  load_option(angle);
}

void ToolPref::Brush::save()
{
  save_option(type);
  save_option(size);
  save_option(angle);
}

ToolPref::Spray::Spray(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "spray")
  , width(this, "width", 16)
  , speed(this, "speed", 32)
{
}

void ToolPref::Spray::load()
{
  load_option(width);
  load_option(speed);
}

void ToolPref::Spray::save()
{
  save_option(width);
  save_option(speed);
}

ToolPref::Floodfill::Floodfill(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "floodfill")
  , stopAtGrid(this, "stop_at_grid", StopAtGrid::IF_VISIBLE)
  , referTo(this, "refer_to", FillReferTo::ACTIVE_LAYER)
{
}

void ToolPref::Floodfill::load()
{
  load_option(stopAtGrid);
  load_option(referTo);
}

void ToolPref::Floodfill::save()
{
  save_option(stopAtGrid);
  save_option(referTo);
}

DocPref::DocPref(const std::string& name)
  : Section(name)
  , site(name)
  , tiled(name)
  , symmetry(name)
  , grid(name)
  , pixelGrid(name)
  , bg(name)
  , onionskin(name)
  , saveCopy(name)
  , spriteSheet(name)
  , importSpriteSheet(name)
  , preview(name)
  , show(name)
{
}

void DocPref::load()
{
  site.load();
  tiled.load();
  symmetry.load();
  grid.load();
  pixelGrid.load();
  bg.load();
  onionskin.load();
  saveCopy.load();
  spriteSheet.load();
  importSpriteSheet.load();
  preview.load();
  show.load();
}

void DocPref::save()
{
  site.save();
  tiled.save();
  symmetry.save();
  grid.save();
  pixelGrid.save();
  bg.save();
  onionskin.save();
  saveCopy.save();
  spriteSheet.save();
  importSpriteSheet.save();
  preview.save();
  show.save();
}

DocPref::Site::Site(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "site")
  , frame(this, "frame", doc::frame_t(0))
  , layer(this, "layer")
{
}

void DocPref::Site::load()
{
  load_option(frame);
  load_option(layer);
}

void DocPref::Site::save()
{
  save_option(frame);
  save_option(layer);
}

DocPref::Tiled::Tiled(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "tiled")
  , mode(this, "mode", filters::TiledMode::NONE)
{
}

void DocPref::Tiled::load()
{
  load_option_with_migration(mode, "Tools", "Tiled");
}

void DocPref::Tiled::save()
{
  save_option(mode);
}

DocPref::Symmetry::Symmetry(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "symmetry")
  , mode(this, "mode", SymmetryMode::NONE)
  , xAxis(this, "x_axis", 0)
  , yAxis(this, "y_axis", 0)
{
}

void DocPref::Symmetry::load()
{
  load_option(mode);
  load_option(xAxis);
  load_option(yAxis);
}

void DocPref::Symmetry::save()
{
  save_option(mode);
  save_option(xAxis);
  save_option(yAxis);
}

DocPref::Grid::Grid(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "grid")
  , snap(this, "snap", false)
  , bounds(this, "bounds", gfx::Rect(0, 0, 16, 16))
  , color(this, "color", app::Color::fromRgb(0, 0, 255))
  , opacity(this, "opacity", 160)
  , autoOpacity(this, "auto_opacity", true)
{
}

void DocPref::Grid::load()
{
  load_option_with_migration(snap, "Grid", "SnapTo");
  load_option_with_migration(bounds, "Grid", "Bounds");
  load_option_with_migration(color, "Grid", "Color");
  load_option_with_migration(opacity, "Grid", "Opacity");
  load_option_with_migration(autoOpacity, "Grid", "AutoOpacity");
}

void DocPref::Grid::save()
{
  save_option(snap);
  save_option(bounds);
  save_option(color);
  save_option(opacity);
  save_option(autoOpacity);
}

DocPref::PixelGrid::PixelGrid(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "pixel_grid")
  , color(this, "color", app::Color::fromRgb(200, 200, 200))
  , opacity(this, "opacity", 160)
  , autoOpacity(this, "auto_opacity", true)
{
}

void DocPref::PixelGrid::load()
{
  load_option_with_migration(color, "PixelGrid", "Color");
  load_option_with_migration(opacity, "PixelGrid", "Opacity");
  load_option_with_migration(autoOpacity, "PixelGrid", "AutoOpacity");
}

void DocPref::PixelGrid::save()
{
  save_option(color);
  save_option(opacity);
  save_option(autoOpacity);
}

DocPref::Bg::Bg(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "bg")
  , type(this, "type", BgType::CHECKED_16x16)
  , zoom(this, "zoom", true)
  , color1(this, "color1", app::Color::fromRgb(128, 128, 128))
  , color2(this, "color2", app::Color::fromRgb(192, 192, 192))
{
}

void DocPref::Bg::load()
{
  load_option_with_migration(type, "Option", "CheckedBgType");
  load_option_with_migration(zoom, "Option", "CheckedBgZoom");
  load_option_with_migration(color1, "Option", "CheckedBgColor1");
  load_option_with_migration(color2, "Option", "CheckedBgColor2");
}

void DocPref::Bg::save()
{
  save_option(type);
  save_option(zoom);
  save_option(color1);
  save_option(color2);
}

DocPref::Onionskin::Onionskin(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "onionskin")
  , active(this, "active", false)
  , prevFrames(this, "prev_frames", 1)
  , nextFrames(this, "next_frames", 1)
  , opacityBase(this, "opacity_base", 68)
  , opacityStep(this, "opacity_step", 28)
  , type(this, "type", OnionskinType::MERGE)
  , loopTag(this, "loop_tag", true)
  , currentLayer(this, "current_layer", false)
  , position(this, "position", render::OnionskinPosition::BEHIND)
{
}

void DocPref::Onionskin::load()
{
  load_option_with_migration(active, "Onionskin", "Enabled");
  load_option_with_migration(prevFrames, "Onionskin", "PrevFrames");
  load_option_with_migration(nextFrames, "Onionskin", "NextFrames");
  load_option_with_migration(opacityBase, "Onionskin", "OpacityBase");
  load_option_with_migration(opacityStep, "Onionskin", "OpacityStep");
  load_option_with_migration(type, "Onionskin", "Type");
  load_option(loopTag);
  load_option(currentLayer);
  load_option(position);
}

void DocPref::Onionskin::save()
{
  save_option(active);
  save_option(prevFrames);
  save_option(nextFrames);
  save_option(opacityBase);
  save_option(opacityStep);
  save_option(type);
  save_option(loopTag);
  save_option(currentLayer);
  save_option(position);
}

DocPref::SaveCopy::SaveCopy(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "save_copy")
  , filename(this, "filename")
  , resizeScale(this, "resize_scale", 1)
{
}

void DocPref::SaveCopy::load()
{
  load_option(filename);
  load_option(resizeScale);
}

void DocPref::SaveCopy::save()
{
  save_option(filename);
  save_option(resizeScale);
}

DocPref::SpriteSheet::SpriteSheet(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "sprite_sheet")
  , type(this, "type", app::SpriteSheetType::None)
  , columns(this, "columns", 0)
  , rows(this, "rows", 0)
  , width(this, "width", 0)
  , height(this, "height", 0)
  , bestFit(this, "best_fit", false)
  , textureFilename(this, "texture_filename")
  , dataFilename(this, "data_filename")
  , dataFormat(this, "data_format", DocumentExporter::DefaultDataFormat)
  , borderPadding(this, "border_padding", 0)
  , shapePadding(this, "shape_padding", 0)
  , innerPadding(this, "inner_padding", 0)
  , openGenerated(this, "open_generated", false)
  , pertagEnabled(this, "pertag_enabled", false)
  , layer(this, "layer")
  , frameTag(this, "frame_tag")
  , listLayers(this, "list_layers", true)
  , listFrameTags(this, "list_frame_tags", true)
{
}

void DocPref::SpriteSheet::load()
{
  load_option(type);
  load_option(columns);
  load_option(rows);
  load_option(width);
  load_option(height);
  load_option(bestFit);
  load_option(textureFilename);
  load_option(dataFilename);
  load_option(dataFormat);
  load_option(borderPadding);
  load_option(shapePadding);
  load_option(innerPadding);
  load_option(openGenerated);
  load_option(pertagEnabled);
  load_option(layer);
  load_option(frameTag);
  load_option(listLayers);
  load_option(listFrameTags);
}

void DocPref::SpriteSheet::save()
{
  save_option(type);
  save_option(columns);
  save_option(rows);
  save_option(width);
  save_option(height);
  save_option(bestFit);
  save_option(textureFilename);
  save_option(dataFilename);
  save_option(dataFormat);
  save_option(borderPadding);
  save_option(shapePadding);
  save_option(innerPadding);
  save_option(openGenerated);
  save_option(pertagEnabled);
  save_option(layer);
  save_option(frameTag);
  save_option(listLayers);
  save_option(listFrameTags);
}

DocPref::ImportSpriteSheet::ImportSpriteSheet(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "import_sprite_sheet")
  , type(this, "type", app::SpriteSheetType::Rows)
  , bounds(this, "bounds", gfx::Rect(0, 0, 0, 0))
  , partialTiles(this, "partial_tiles", false)
{
}

void DocPref::ImportSpriteSheet::load()
{
  load_option(type);
  load_option(bounds);
  load_option(partialTiles);
}

void DocPref::ImportSpriteSheet::save()
{
  save_option(type);
  save_option(bounds);
  save_option(partialTiles);
}

DocPref::Preview::Preview(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "preview")
  , zoom(this, "zoom", 1.0)
  , scroll(this, "scroll")
  , autoScroll(this, "auto_scroll", true)
{
}

void DocPref::Preview::load()
{
  load_option(zoom);
  load_option(scroll);
  load_option(autoScroll);
}

void DocPref::Preview::save()
{
  save_option(zoom);
  save_option(scroll);
  save_option(autoScroll);
}

DocPref::Show::Show(const std::string& name)
  : Section(std::string(!name.empty() ? name + ".": "") + "show")
  , layerEdges(this, "layer_edges", false)
  , selectionEdges(this, "selection_edges", true)
  , grid(this, "grid", false)
  , pixelGrid(this, "pixel_grid", false)
  , brushPreview(this, "brush_preview", true)
{
}

void DocPref::Show::load()
{
  load_option(layerEdges);
  load_option(selectionEdges);
  load_option_with_migration(grid, "grid", "visible");
  load_option_with_migration(pixelGrid, "pixel_grid", "visible");
  load_option(brushPreview);
}

void DocPref::Show::save()
{
  save_option(layerEdges);
  save_option(selectionEdges);
  save_option(grid);
  save_option(pixelGrid);
  save_option(brushPreview);
}

} // namespace gen
} // namespace app
