/* Generated by wayland-scanner 1.24.0 */

#ifndef KDE_OUTPUT_MANAGEMENT_V2_CLIENT_PROTOCOL_H
#define KDE_OUTPUT_MANAGEMENT_V2_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_kde_output_management_v2 The kde_output_management_v2 protocol
 * @section page_ifaces_kde_output_management_v2 Interfaces
 * - @subpage page_iface_kde_output_management_v2 - configuration of server outputs through clients
 * - @subpage page_iface_kde_output_configuration_v2 - configure single output devices
 * @section page_copyright_kde_output_management_v2 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2008-2011 Kristian Høgsberg
 * SPDX-FileCopyrightText: 2010-2011 Intel Corporation
 * SPDX-FileCopyrightText: 2012-2013 Collabora, Ltd.
 * SPDX-FileCopyrightText: 2015 Sebastian Kügler <sebas@kde.org>
 * SPDX-FileCopyrightText: 2021 Méven Car <meven.car@enioka.com>
 * SPDX-FileCopyrightText: 2023 Xaver Hugl <xaver.hugl@kde.org>
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct kde_output_configuration_v2;
struct kde_output_device_mode_v2;
struct kde_output_device_v2;
struct kde_output_management_v2;

#ifndef KDE_OUTPUT_MANAGEMENT_V2_INTERFACE
#define KDE_OUTPUT_MANAGEMENT_V2_INTERFACE
/**
 * @page page_iface_kde_output_management_v2 kde_output_management_v2
 * @section page_iface_kde_output_management_v2_desc Description
 *
 * This interface enables clients to set properties of output devices for screen
 * configuration purposes via the server. To this end output devices are referenced
 * by global kde_output_device_v2 objects.
 *
 * outputmanagement (wl_global)
 * --------------------------
 * request:
 * * create_configuration -> outputconfiguration (wl_resource)
 *
 * outputconfiguration (wl_resource)
 * --------------------------
 * requests:
 * * enable(outputdevice, bool)
 * * mode(outputdevice, mode)
 * * transformation(outputdevice, flag)
 * * position(outputdevice, x, y)
 * * apply
 *
 * events:
 * * applied
 * * failed
 *
 * The server registers one outputmanagement object as a global object. In order
 * to configure outputs a client requests create_configuration, which provides a
 * resource referencing an outputconfiguration for one-time configuration. That
 * way the server knows which requests belong together and can group them by that.
 *
 * On the outputconfiguration object the client calls for each output whether the
 * output should be enabled, which mode should be set (by referencing the mode from
 * the list of announced modes) and the output's global position. Once all outputs
 * are configured that way, the client calls apply.
 * At that point and not earlier the server should try to apply the configuration.
 * If this succeeds the server emits the applied signal, otherwise the failed
 * signal, such that the configuring client is noticed about the success of its
 * configuration request.
 *
 * Through this design the interface enables atomic output configuration changes if
 * internally supported by the server.
 *
 * Warning! The protocol described in this file is a desktop environment implementation
 * detail. Regular clients must not use this protocol. Backward incompatible
 * changes may be added without bumping the major version of the extension.
 * @section page_iface_kde_output_management_v2_api API
 * See @ref iface_kde_output_management_v2.
 */
/**
 * @defgroup iface_kde_output_management_v2 The kde_output_management_v2 interface
 *
 * This interface enables clients to set properties of output devices for screen
 * configuration purposes via the server. To this end output devices are referenced
 * by global kde_output_device_v2 objects.
 *
 * outputmanagement (wl_global)
 * --------------------------
 * request:
 * * create_configuration -> outputconfiguration (wl_resource)
 *
 * outputconfiguration (wl_resource)
 * --------------------------
 * requests:
 * * enable(outputdevice, bool)
 * * mode(outputdevice, mode)
 * * transformation(outputdevice, flag)
 * * position(outputdevice, x, y)
 * * apply
 *
 * events:
 * * applied
 * * failed
 *
 * The server registers one outputmanagement object as a global object. In order
 * to configure outputs a client requests create_configuration, which provides a
 * resource referencing an outputconfiguration for one-time configuration. That
 * way the server knows which requests belong together and can group them by that.
 *
 * On the outputconfiguration object the client calls for each output whether the
 * output should be enabled, which mode should be set (by referencing the mode from
 * the list of announced modes) and the output's global position. Once all outputs
 * are configured that way, the client calls apply.
 * At that point and not earlier the server should try to apply the configuration.
 * If this succeeds the server emits the applied signal, otherwise the failed
 * signal, such that the configuring client is noticed about the success of its
 * configuration request.
 *
 * Through this design the interface enables atomic output configuration changes if
 * internally supported by the server.
 *
 * Warning! The protocol described in this file is a desktop environment implementation
 * detail. Regular clients must not use this protocol. Backward incompatible
 * changes may be added without bumping the major version of the extension.
 */
extern const struct wl_interface kde_output_management_v2_interface;
#endif
#ifndef KDE_OUTPUT_CONFIGURATION_V2_INTERFACE
#define KDE_OUTPUT_CONFIGURATION_V2_INTERFACE
/**
 * @page page_iface_kde_output_configuration_v2 kde_output_configuration_v2
 * @section page_iface_kde_output_configuration_v2_desc Description
 *
 * outputconfiguration is a client-specific resource that can be used to ask
 * the server to apply changes to available output devices.
 *
 * The client receives a list of output devices from the registry. When it wants
 * to apply new settings, it creates a configuration object from the
 * outputmanagement global, writes changes through this object's enable, scale,
 * transform and mode calls. It then asks the server to apply these settings in
 * an atomic fashion, for example through Linux' DRM interface.
 *
 * The server signals back whether the new settings have applied successfully
 * or failed to apply. outputdevice objects are updated after the changes have been
 * applied to the hardware and before the server side sends the applied event.
 * @section page_iface_kde_output_configuration_v2_api API
 * See @ref iface_kde_output_configuration_v2.
 */
/**
 * @defgroup iface_kde_output_configuration_v2 The kde_output_configuration_v2 interface
 *
 * outputconfiguration is a client-specific resource that can be used to ask
 * the server to apply changes to available output devices.
 *
 * The client receives a list of output devices from the registry. When it wants
 * to apply new settings, it creates a configuration object from the
 * outputmanagement global, writes changes through this object's enable, scale,
 * transform and mode calls. It then asks the server to apply these settings in
 * an atomic fashion, for example through Linux' DRM interface.
 *
 * The server signals back whether the new settings have applied successfully
 * or failed to apply. outputdevice objects are updated after the changes have been
 * applied to the hardware and before the server side sends the applied event.
 */
extern const struct wl_interface kde_output_configuration_v2_interface;
#endif

#define KDE_OUTPUT_MANAGEMENT_V2_CREATE_CONFIGURATION 0


/**
 * @ingroup iface_kde_output_management_v2
 */
#define KDE_OUTPUT_MANAGEMENT_V2_CREATE_CONFIGURATION_SINCE_VERSION 1

/** @ingroup iface_kde_output_management_v2 */
static inline void
kde_output_management_v2_set_user_data(struct kde_output_management_v2 *kde_output_management_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) kde_output_management_v2, user_data);
}

/** @ingroup iface_kde_output_management_v2 */
static inline void *
kde_output_management_v2_get_user_data(struct kde_output_management_v2 *kde_output_management_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) kde_output_management_v2);
}

static inline uint32_t
kde_output_management_v2_get_version(struct kde_output_management_v2 *kde_output_management_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) kde_output_management_v2);
}

/** @ingroup iface_kde_output_management_v2 */
static inline void
kde_output_management_v2_destroy(struct kde_output_management_v2 *kde_output_management_v2)
{
	wl_proxy_destroy((struct wl_proxy *) kde_output_management_v2);
}

/**
 * @ingroup iface_kde_output_management_v2
 *
 * Request an outputconfiguration object through which the client can configure
 * output devices.
 */
static inline struct kde_output_configuration_v2 *
kde_output_management_v2_create_configuration(struct kde_output_management_v2 *kde_output_management_v2)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) kde_output_management_v2,
			 KDE_OUTPUT_MANAGEMENT_V2_CREATE_CONFIGURATION, &kde_output_configuration_v2_interface, wl_proxy_get_version((struct wl_proxy *) kde_output_management_v2), 0, NULL);

	return (struct kde_output_configuration_v2 *) id;
}

#ifndef KDE_OUTPUT_CONFIGURATION_V2_ERROR_ENUM
#define KDE_OUTPUT_CONFIGURATION_V2_ERROR_ENUM
/**
 * @ingroup iface_kde_output_configuration_v2
 * kde_output_configuration_v2 error values
 *
 * These error can be emitted in response to kde_output_configuration_v2 requests.
 */
enum kde_output_configuration_v2_error {
	/**
	 * the config is already applied
	 */
	KDE_OUTPUT_CONFIGURATION_V2_ERROR_ALREADY_APPLIED = 0,
};
#endif /* KDE_OUTPUT_CONFIGURATION_V2_ERROR_ENUM */

#ifndef KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_ENUM
#define KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_ENUM
/**
 * @ingroup iface_kde_output_configuration_v2
 * describes vrr policy
 *
 * Describes when the compositor may employ variable refresh rate
 */
enum kde_output_configuration_v2_vrr_policy {
	KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_NEVER = 0,
	KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_ALWAYS = 1,
	KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_AUTOMATIC = 2,
};
#endif /* KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_ENUM */

#ifndef KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_ENUM
#define KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_ENUM
/**
 * @ingroup iface_kde_output_configuration_v2
 * describes RGB range policy
 *
 * Whether this output should use full or limited rgb.
 */
enum kde_output_configuration_v2_rgb_range {
	KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_AUTOMATIC = 0,
	KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_FULL = 1,
	KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_LIMITED = 2,
};
#endif /* KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_ENUM */

#ifndef KDE_OUTPUT_CONFIGURATION_V2_AUTO_ROTATE_POLICY_ENUM
#define KDE_OUTPUT_CONFIGURATION_V2_AUTO_ROTATE_POLICY_ENUM
/**
 * @ingroup iface_kde_output_configuration_v2
 * describes when auto rotate should be used
 */
enum kde_output_configuration_v2_auto_rotate_policy {
	KDE_OUTPUT_CONFIGURATION_V2_AUTO_ROTATE_POLICY_NEVER = 0,
	KDE_OUTPUT_CONFIGURATION_V2_AUTO_ROTATE_POLICY_IN_TABLET_MODE = 1,
	KDE_OUTPUT_CONFIGURATION_V2_AUTO_ROTATE_POLICY_ALWAYS = 2,
};
#endif /* KDE_OUTPUT_CONFIGURATION_V2_AUTO_ROTATE_POLICY_ENUM */

#ifndef KDE_OUTPUT_CONFIGURATION_V2_COLOR_PROFILE_SOURCE_ENUM
#define KDE_OUTPUT_CONFIGURATION_V2_COLOR_PROFILE_SOURCE_ENUM
/**
 * @ingroup iface_kde_output_configuration_v2
 * which source the compositor should use for the color profile on an output
 */
enum kde_output_configuration_v2_color_profile_source {
	KDE_OUTPUT_CONFIGURATION_V2_COLOR_PROFILE_SOURCE_SRGB = 0,
	KDE_OUTPUT_CONFIGURATION_V2_COLOR_PROFILE_SOURCE_ICC = 1,
	KDE_OUTPUT_CONFIGURATION_V2_COLOR_PROFILE_SOURCE_EDID = 2,
};
#endif /* KDE_OUTPUT_CONFIGURATION_V2_COLOR_PROFILE_SOURCE_ENUM */

#ifndef KDE_OUTPUT_CONFIGURATION_V2_COLOR_POWER_TRADEOFF_ENUM
#define KDE_OUTPUT_CONFIGURATION_V2_COLOR_POWER_TRADEOFF_ENUM
/**
 * @ingroup iface_kde_output_configuration_v2
 * tradeoff between power and accuracy
 *
 * The compositor can do a lot of things that trade between
 * performance, power and color accuracy. This setting describes
 * a high level preference from the user about in which direction
 * that tradeoff should be made.
 */
enum kde_output_configuration_v2_color_power_tradeoff {
	/**
	 * prefer efficiency and performance
	 */
	KDE_OUTPUT_CONFIGURATION_V2_COLOR_POWER_TRADEOFF_EFFICIENCY = 0,
	/**
	 * prefer accuracy
	 */
	KDE_OUTPUT_CONFIGURATION_V2_COLOR_POWER_TRADEOFF_ACCURACY = 1,
};
#endif /* KDE_OUTPUT_CONFIGURATION_V2_COLOR_POWER_TRADEOFF_ENUM */

#ifndef KDE_OUTPUT_CONFIGURATION_V2_EDR_POLICY_ENUM
#define KDE_OUTPUT_CONFIGURATION_V2_EDR_POLICY_ENUM
/**
 * @ingroup iface_kde_output_configuration_v2
 * when the compositor may make use of EDR
 */
enum kde_output_configuration_v2_edr_policy {
	KDE_OUTPUT_CONFIGURATION_V2_EDR_POLICY_NEVER = 0,
	KDE_OUTPUT_CONFIGURATION_V2_EDR_POLICY_ALWAYS = 1,
};
#endif /* KDE_OUTPUT_CONFIGURATION_V2_EDR_POLICY_ENUM */

/**
 * @ingroup iface_kde_output_configuration_v2
 * @struct kde_output_configuration_v2_listener
 */
struct kde_output_configuration_v2_listener {
	/**
	 * configuration changes have been applied
	 *
	 * Sent after the server has successfully applied the changes. .
	 */
	void (*applied)(void *data,
			struct kde_output_configuration_v2 *kde_output_configuration_v2);
	/**
	 * configuration changes failed to apply
	 *
	 * Sent if the server rejects the changes or failed to apply
	 * them.
	 */
	void (*failed)(void *data,
		       struct kde_output_configuration_v2 *kde_output_configuration_v2);
	/**
	 * reason for failure
	 *
	 * Describes why applying the output configuration failed. Is
	 * only sent before the failure event.
	 * @param reason reason for failure
	 * @since 12
	 */
	void (*failure_reason)(void *data,
			       struct kde_output_configuration_v2 *kde_output_configuration_v2,
			       const char *reason);
};

/**
 * @ingroup iface_kde_output_configuration_v2
 */
static inline int
kde_output_configuration_v2_add_listener(struct kde_output_configuration_v2 *kde_output_configuration_v2,
					 const struct kde_output_configuration_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) kde_output_configuration_v2,
				     (void (**)(void)) listener, data);
}

#define KDE_OUTPUT_CONFIGURATION_V2_ENABLE 0
#define KDE_OUTPUT_CONFIGURATION_V2_MODE 1
#define KDE_OUTPUT_CONFIGURATION_V2_TRANSFORM 2
#define KDE_OUTPUT_CONFIGURATION_V2_POSITION 3
#define KDE_OUTPUT_CONFIGURATION_V2_SCALE 4
#define KDE_OUTPUT_CONFIGURATION_V2_APPLY 5
#define KDE_OUTPUT_CONFIGURATION_V2_DESTROY 6
#define KDE_OUTPUT_CONFIGURATION_V2_OVERSCAN 7
#define KDE_OUTPUT_CONFIGURATION_V2_SET_VRR_POLICY 8
#define KDE_OUTPUT_CONFIGURATION_V2_SET_RGB_RANGE 9
#define KDE_OUTPUT_CONFIGURATION_V2_SET_PRIMARY_OUTPUT 10
#define KDE_OUTPUT_CONFIGURATION_V2_SET_PRIORITY 11
#define KDE_OUTPUT_CONFIGURATION_V2_SET_HIGH_DYNAMIC_RANGE 12
#define KDE_OUTPUT_CONFIGURATION_V2_SET_SDR_BRIGHTNESS 13
#define KDE_OUTPUT_CONFIGURATION_V2_SET_WIDE_COLOR_GAMUT 14
#define KDE_OUTPUT_CONFIGURATION_V2_SET_AUTO_ROTATE_POLICY 15
#define KDE_OUTPUT_CONFIGURATION_V2_SET_ICC_PROFILE_PATH 16
#define KDE_OUTPUT_CONFIGURATION_V2_SET_BRIGHTNESS_OVERRIDES 17
#define KDE_OUTPUT_CONFIGURATION_V2_SET_SDR_GAMUT_WIDENESS 18
#define KDE_OUTPUT_CONFIGURATION_V2_SET_COLOR_PROFILE_SOURCE 19
#define KDE_OUTPUT_CONFIGURATION_V2_SET_BRIGHTNESS 20
#define KDE_OUTPUT_CONFIGURATION_V2_SET_COLOR_POWER_TRADEOFF 21
#define KDE_OUTPUT_CONFIGURATION_V2_SET_DIMMING 22
#define KDE_OUTPUT_CONFIGURATION_V2_SET_REPLICATION_SOURCE 23
#define KDE_OUTPUT_CONFIGURATION_V2_SET_DDC_CI_ALLOWED 24
#define KDE_OUTPUT_CONFIGURATION_V2_SET_MAX_BITS_PER_COLOR 25
#define KDE_OUTPUT_CONFIGURATION_V2_SET_EDR_POLICY 26
#define KDE_OUTPUT_CONFIGURATION_V2_SET_SHARPNESS 27

/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_APPLIED_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_FAILED_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_FAILURE_REASON_SINCE_VERSION 12

/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_ENABLE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_TRANSFORM_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SCALE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_APPLY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_OVERSCAN_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_VRR_POLICY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_RGB_RANGE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_PRIMARY_OUTPUT_SINCE_VERSION 2
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_PRIORITY_SINCE_VERSION 3
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_HIGH_DYNAMIC_RANGE_SINCE_VERSION 4
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_SDR_BRIGHTNESS_SINCE_VERSION 4
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_WIDE_COLOR_GAMUT_SINCE_VERSION 4
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_AUTO_ROTATE_POLICY_SINCE_VERSION 5
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_ICC_PROFILE_PATH_SINCE_VERSION 6
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_BRIGHTNESS_OVERRIDES_SINCE_VERSION 7
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_SDR_GAMUT_WIDENESS_SINCE_VERSION 7
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_COLOR_PROFILE_SOURCE_SINCE_VERSION 8
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_BRIGHTNESS_SINCE_VERSION 9
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_COLOR_POWER_TRADEOFF_SINCE_VERSION 10
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_DIMMING_SINCE_VERSION 11
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_REPLICATION_SOURCE_SINCE_VERSION 13
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_DDC_CI_ALLOWED_SINCE_VERSION 14
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_MAX_BITS_PER_COLOR_SINCE_VERSION 15
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_EDR_POLICY_SINCE_VERSION 16
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_SHARPNESS_SINCE_VERSION 17

/** @ingroup iface_kde_output_configuration_v2 */
static inline void
kde_output_configuration_v2_set_user_data(struct kde_output_configuration_v2 *kde_output_configuration_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) kde_output_configuration_v2, user_data);
}

/** @ingroup iface_kde_output_configuration_v2 */
static inline void *
kde_output_configuration_v2_get_user_data(struct kde_output_configuration_v2 *kde_output_configuration_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) kde_output_configuration_v2);
}

static inline uint32_t
kde_output_configuration_v2_get_version(struct kde_output_configuration_v2 *kde_output_configuration_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Mark the output as enabled or disabled.
 */
static inline void
kde_output_configuration_v2_enable(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, int32_t enable)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_ENABLE, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, enable);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Sets the mode for a given output.
 */
static inline void
kde_output_configuration_v2_mode(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, struct kde_output_device_mode_v2 *mode)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_MODE, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, mode);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Sets the transformation for a given output.
 */
static inline void
kde_output_configuration_v2_transform(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, int32_t transform)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_TRANSFORM, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, transform);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Sets the position for this output device. (x,y) describe the top-left corner
 * of the output in global space, whereby the origin (0,0) of the global space
 * has to be aligned with the top-left corner of the most left and in case this
 * does not define a single one the top output.
 *
 * There may be no gaps or overlaps between outputs, i.e. the outputs are
 * stacked horizontally, vertically, or both on each other.
 */
static inline void
kde_output_configuration_v2_position(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, int32_t x, int32_t y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_POSITION, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, x, y);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Sets the scaling factor for this output device.
 */
static inline void
kde_output_configuration_v2_scale(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, wl_fixed_t scale)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SCALE, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, scale);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Asks the server to apply property changes requested through this outputconfiguration
 * object to all outputs on the server side.
 *
 * The output configuration can be applied only once. The already_applied protocol error
 * will be posted if the apply request is called the second time.
 */
static inline void
kde_output_configuration_v2_apply(struct kde_output_configuration_v2 *kde_output_configuration_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_APPLY, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 */
static inline void
kde_output_configuration_v2_destroy(struct kde_output_configuration_v2 *kde_output_configuration_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Set the overscan value of this output device with a value in percent.
 */
static inline void
kde_output_configuration_v2_overscan(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t overscan)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_OVERSCAN, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, overscan);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Set what policy the compositor should employ regarding its use of
 * variable refresh rate.
 */
static inline void
kde_output_configuration_v2_set_vrr_policy(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t policy)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_VRR_POLICY, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, policy);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Whether full or limited color range should be used
 */
static inline void
kde_output_configuration_v2_set_rgb_range(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t rgb_range)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_RGB_RANGE, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, rgb_range);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 */
static inline void
kde_output_configuration_v2_set_primary_output(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_PRIMARY_OUTPUT, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, output);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * The order of outputs can be used to assign desktop environment components to a specific screen,
 * see kde_output_order_v1 for details. The priority is 1-based for outputs that will be enabled after
 * this changeset is applied, all outputs that are disabled need to have the index set to zero.
 */
static inline void
kde_output_configuration_v2_set_priority(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t priority)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_PRIORITY, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, priority);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Sets whether or not the output should be set to HDR mode.
 */
static inline void
kde_output_configuration_v2_set_high_dynamic_range(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t enable_hdr)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_HIGH_DYNAMIC_RANGE, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, enable_hdr);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Sets the brightness of standard dynamic range content in nits. Only has an effect while the output is in HDR mode.
 * Note that while the value is in nits, that doesn't necessarily translate to the same brightness on the screen.
 */
static inline void
kde_output_configuration_v2_set_sdr_brightness(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t sdr_brightness)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_SDR_BRIGHTNESS, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, sdr_brightness);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Whether or not the output should use a wide color gamut
 */
static inline void
kde_output_configuration_v2_set_wide_color_gamut(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t enable_wcg)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_WIDE_COLOR_GAMUT, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, enable_wcg);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 */
static inline void
kde_output_configuration_v2_set_auto_rotate_policy(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t policy)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_AUTO_ROTATE_POLICY, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, policy);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 */
static inline void
kde_output_configuration_v2_set_icc_profile_path(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, const char *profile_path)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_ICC_PROFILE_PATH, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, profile_path);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 */
static inline void
kde_output_configuration_v2_set_brightness_overrides(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, int32_t max_peak_brightness, int32_t max_frame_average_brightness, int32_t min_brightness)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_BRIGHTNESS_OVERRIDES, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, max_peak_brightness, max_frame_average_brightness, min_brightness);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * This can be used to provide the colors users assume sRGB applications should have based on the
 * default experience on many modern sRGB screens.
 */
static inline void
kde_output_configuration_v2_set_sdr_gamut_wideness(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t gamut_wideness)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_SDR_GAMUT_WIDENESS, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, gamut_wideness);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 */
static inline void
kde_output_configuration_v2_set_color_profile_source(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t color_profile_source)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_COLOR_PROFILE_SOURCE, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, color_profile_source);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Set the brightness modifier of the output. It doesn't specify
 * any absolute values, but is merely a multiplier on top of other
 * brightness values, like sdr_brightness and brightness_metadata.
 * 0 is the minimum brightness (not completely dark) and 10000 is
 * the maximum brightness.
 * This is supported while HDR is active in versions 8 and below,
 * or when the device supports the "brightness" capability in
 * versions 9 and above.
 */
static inline void
kde_output_configuration_v2_set_brightness(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t brightness)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_BRIGHTNESS, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, brightness);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 */
static inline void
kde_output_configuration_v2_set_color_power_tradeoff(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t preference)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_COLOR_POWER_TRADEOFF, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, preference);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Set the dimming multiplier of the output. This is similar to the
 * brightness setting, except it's meant to be a temporary setting
 * only, not persistent and may be implemented differently depending
 * on the display.
 * 0 is the minimum dimming factor (not completely dark) and 10000
 * means the output is not dimmed.
 *
 * This is supported only when the "brightness" capability is
 * also supported.
 */
static inline void
kde_output_configuration_v2_set_dimming(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t multiplier)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_DIMMING, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, multiplier);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Set the source output that the outputdevice should mirror its
 * viewport from.
 */
static inline void
kde_output_configuration_v2_set_replication_source(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, const char *source)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_REPLICATION_SOURCE, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, source);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 */
static inline void
kde_output_configuration_v2_set_ddc_ci_allowed(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t allowed)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_DDC_CI_ALLOWED, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, allowed);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * This limits the amount of bits per color that are sent to the display.
 */
static inline void
kde_output_configuration_v2_set_max_bits_per_color(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t max_bpc)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_MAX_BITS_PER_COLOR, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, max_bpc);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * When EDR is enabled, the compositor may increase the backlight beyond
 * the user-specified setting, in order to present HDR content on displays
 * without native HDR support.
 * This will usually result in better visuals, but also increases battery
 * usage.
 */
static inline void
kde_output_configuration_v2_set_edr_policy(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t policy)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_EDR_POLICY, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, policy);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * This is the sharpness modifier of the output.
 * 0 is sharpness disabled and 10000 is the maximum sharpness
 */
static inline void
kde_output_configuration_v2_set_sharpness(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t sharpness)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_SHARPNESS, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, sharpness);
}

#ifdef  __cplusplus
}
#endif

#endif
