// Copyright (c) 2005-2023 Code Synthesis.
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis gives permission
// to link this program with the Xerces-C++ library (or with modified
// versions of Xerces-C++ that use the same license as Xerces-C++), and
// distribute linked combinations including the two. You must obey the GNU
// General Public License version 2 in all respects for all of the code
// used other than Xerces-C++. If you modify this copy of the program, you
// may extend this exception to your version of the program, but you are
// not obligated to do so. If you do not wish to do so, delete this
// exception statement from your version.
//
// Furthermore, Code Synthesis makes a special exception for the Free/Libre
// and Open Source Software (FLOSS) which is described in the accompanying
// FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "kolabformat-xcard.hxx"

namespace vcard_4_0
{
  // KolabVersion
  //

  const KolabVersion::text_type& KolabVersion::
  text () const
  {
    return this->text_.get ();
  }

  KolabVersion::text_type& KolabVersion::
  text ()
  {
    return this->text_.get ();
  }

  void KolabVersion::
  text (const text_type& x)
  {
    this->text_.set (x);
  }

  void KolabVersion::
  text (::std::unique_ptr< text_type > x)
  {
    this->text_.set (std::move (x));
  }

  const KolabVersion::text_type& KolabVersion::
  text_default_value ()
  {
    return text_default_value_;
  }


  // CustomType
  //

  const CustomType::identifier_type& CustomType::
  identifier () const
  {
    return this->identifier_.get ();
  }

  CustomType::identifier_type& CustomType::
  identifier ()
  {
    return this->identifier_.get ();
  }

  void CustomType::
  identifier (const identifier_type& x)
  {
    this->identifier_.set (x);
  }

  void CustomType::
  identifier (::std::unique_ptr< identifier_type > x)
  {
    this->identifier_.set (std::move (x));
  }

  const CustomType::value_type& CustomType::
  value () const
  {
    return this->value_.get ();
  }

  CustomType::value_type& CustomType::
  value ()
  {
    return this->value_.get ();
  }

  void CustomType::
  value (const value_type& x)
  {
    this->value_.set (x);
  }

  void CustomType::
  value (::std::unique_ptr< value_type > x)
  {
    this->value_.set (std::move (x));
  }


  // CryptoTypeValueType
  //

  CryptoTypeValueType::
  CryptoTypeValueType (value v)
  : ::xml_schema::token (_xsd_CryptoTypeValueType_literals_[v])
  {
  }

  CryptoTypeValueType::
  CryptoTypeValueType (const char* v)
  : ::xml_schema::token (v)
  {
  }

  CryptoTypeValueType::
  CryptoTypeValueType (const ::std::string& v)
  : ::xml_schema::token (v)
  {
  }

  CryptoTypeValueType::
  CryptoTypeValueType (const ::xml_schema::token& v)
  : ::xml_schema::token (v)
  {
  }

  CryptoTypeValueType::
  CryptoTypeValueType (const CryptoTypeValueType& v,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::xml_schema::token (v, f, c)
  {
  }

  CryptoTypeValueType& CryptoTypeValueType::
  operator= (value v)
  {
    static_cast< ::xml_schema::token& > (*this) = 
    ::xml_schema::token (_xsd_CryptoTypeValueType_literals_[v]);

    return *this;
  }


  // PrefTypeValueType
  //

  PrefTypeValueType::
  PrefTypeValueType (value v)
  : ::xml_schema::token (_xsd_PrefTypeValueType_literals_[v])
  {
  }

  PrefTypeValueType::
  PrefTypeValueType (const char* v)
  : ::xml_schema::token (v)
  {
  }

  PrefTypeValueType::
  PrefTypeValueType (const ::std::string& v)
  : ::xml_schema::token (v)
  {
  }

  PrefTypeValueType::
  PrefTypeValueType (const ::xml_schema::token& v)
  : ::xml_schema::token (v)
  {
  }

  PrefTypeValueType::
  PrefTypeValueType (const PrefTypeValueType& v,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::token (v, f, c)
  {
  }

  PrefTypeValueType& PrefTypeValueType::
  operator= (value v)
  {
    static_cast< ::xml_schema::token& > (*this) = 
    ::xml_schema::token (_xsd_PrefTypeValueType_literals_[v]);

    return *this;
  }


  // CryptoType
  //

  const CryptoType::allowed_optional& CryptoType::
  allowed () const
  {
    return this->allowed_;
  }

  CryptoType::allowed_optional& CryptoType::
  allowed ()
  {
    return this->allowed_;
  }

  void CryptoType::
  allowed (const allowed_type& x)
  {
    this->allowed_.set (x);
  }

  void CryptoType::
  allowed (const allowed_optional& x)
  {
    this->allowed_ = x;
  }

  void CryptoType::
  allowed (::std::unique_ptr< allowed_type > x)
  {
    this->allowed_.set (std::move (x));
  }

  const CryptoType::signpref_optional& CryptoType::
  signpref () const
  {
    return this->signpref_;
  }

  CryptoType::signpref_optional& CryptoType::
  signpref ()
  {
    return this->signpref_;
  }

  void CryptoType::
  signpref (const signpref_type& x)
  {
    this->signpref_.set (x);
  }

  void CryptoType::
  signpref (const signpref_optional& x)
  {
    this->signpref_ = x;
  }

  void CryptoType::
  signpref (::std::unique_ptr< signpref_type > x)
  {
    this->signpref_.set (std::move (x));
  }

  const CryptoType::encryptpref_optional& CryptoType::
  encryptpref () const
  {
    return this->encryptpref_;
  }

  CryptoType::encryptpref_optional& CryptoType::
  encryptpref ()
  {
    return this->encryptpref_;
  }

  void CryptoType::
  encryptpref (const encryptpref_type& x)
  {
    this->encryptpref_.set (x);
  }

  void CryptoType::
  encryptpref (const encryptpref_optional& x)
  {
    this->encryptpref_ = x;
  }

  void CryptoType::
  encryptpref (::std::unique_ptr< encryptpref_type > x)
  {
    this->encryptpref_.set (std::move (x));
  }


  // VcardsType
  //

  const VcardsType::vcard_type& VcardsType::
  vcard () const
  {
    return this->vcard_.get ();
  }

  VcardsType::vcard_type& VcardsType::
  vcard ()
  {
    return this->vcard_.get ();
  }

  void VcardsType::
  vcard (const vcard_type& x)
  {
    this->vcard_.set (x);
  }

  void VcardsType::
  vcard (::std::unique_ptr< vcard_type > x)
  {
    this->vcard_.set (std::move (x));
  }


  // allowed
  //

  const allowed::text_sequence& allowed::
  text () const
  {
    return this->text_;
  }

  allowed::text_sequence& allowed::
  text ()
  {
    return this->text_;
  }

  void allowed::
  text (const text_sequence& s)
  {
    this->text_ = s;
  }


  // signpref
  //

  const signpref::text_type& signpref::
  text () const
  {
    return this->text_.get ();
  }

  signpref::text_type& signpref::
  text ()
  {
    return this->text_.get ();
  }

  void signpref::
  text (const text_type& x)
  {
    this->text_.set (x);
  }

  void signpref::
  text (::std::unique_ptr< text_type > x)
  {
    this->text_.set (std::move (x));
  }


  // encryptpref
  //

  const encryptpref::text_type& encryptpref::
  text () const
  {
    return this->text_.get ();
  }

  encryptpref::text_type& encryptpref::
  text ()
  {
    return this->text_.get ();
  }

  void encryptpref::
  text (const text_type& x)
  {
    this->text_.set (x);
  }

  void encryptpref::
  text (::std::unique_ptr< text_type > x)
  {
    this->text_.set (std::move (x));
  }


  // vcard
  //

  const vcard::uid_type& vcard::
  uid () const
  {
    return this->uid_.get ();
  }

  vcard::uid_type& vcard::
  uid ()
  {
    return this->uid_.get ();
  }

  void vcard::
  uid (const uid_type& x)
  {
    this->uid_.set (x);
  }

  void vcard::
  uid (::std::unique_ptr< uid_type > x)
  {
    this->uid_.set (std::move (x));
  }

  const vcard::x_kolab_version_type& vcard::
  x_kolab_version () const
  {
    return this->x_kolab_version_.get ();
  }

  vcard::x_kolab_version_type& vcard::
  x_kolab_version ()
  {
    return this->x_kolab_version_.get ();
  }

  void vcard::
  x_kolab_version (const x_kolab_version_type& x)
  {
    this->x_kolab_version_.set (x);
  }

  void vcard::
  x_kolab_version (::std::unique_ptr< x_kolab_version_type > x)
  {
    this->x_kolab_version_.set (std::move (x));
  }

  const vcard::prodid_type& vcard::
  prodid () const
  {
    return this->prodid_.get ();
  }

  vcard::prodid_type& vcard::
  prodid ()
  {
    return this->prodid_.get ();
  }

  void vcard::
  prodid (const prodid_type& x)
  {
    this->prodid_.set (x);
  }

  void vcard::
  prodid (::std::unique_ptr< prodid_type > x)
  {
    this->prodid_.set (std::move (x));
  }

  const vcard::rev_type& vcard::
  rev () const
  {
    return this->rev_.get ();
  }

  vcard::rev_type& vcard::
  rev ()
  {
    return this->rev_.get ();
  }

  void vcard::
  rev (const rev_type& x)
  {
    this->rev_.set (x);
  }

  void vcard::
  rev (::std::unique_ptr< rev_type > x)
  {
    this->rev_.set (std::move (x));
  }

  const vcard::categories_optional& vcard::
  categories () const
  {
    return this->categories_;
  }

  vcard::categories_optional& vcard::
  categories ()
  {
    return this->categories_;
  }

  void vcard::
  categories (const categories_type& x)
  {
    this->categories_.set (x);
  }

  void vcard::
  categories (const categories_optional& x)
  {
    this->categories_ = x;
  }

  void vcard::
  categories (::std::unique_ptr< categories_type > x)
  {
    this->categories_.set (std::move (x));
  }

  const vcard::kind_type& vcard::
  kind () const
  {
    return this->kind_.get ();
  }

  vcard::kind_type& vcard::
  kind ()
  {
    return this->kind_.get ();
  }

  void vcard::
  kind (const kind_type& x)
  {
    this->kind_.set (x);
  }

  void vcard::
  kind (::std::unique_ptr< kind_type > x)
  {
    this->kind_.set (std::move (x));
  }

  const vcard::fn_type& vcard::
  fn () const
  {
    return this->fn_.get ();
  }

  vcard::fn_type& vcard::
  fn ()
  {
    return this->fn_.get ();
  }

  void vcard::
  fn (const fn_type& x)
  {
    this->fn_.set (x);
  }

  void vcard::
  fn (::std::unique_ptr< fn_type > x)
  {
    this->fn_.set (std::move (x));
  }

  const vcard::n_optional& vcard::
  n () const
  {
    return this->n_;
  }

  vcard::n_optional& vcard::
  n ()
  {
    return this->n_;
  }

  void vcard::
  n (const n_type& x)
  {
    this->n_.set (x);
  }

  void vcard::
  n (const n_optional& x)
  {
    this->n_ = x;
  }

  void vcard::
  n (::std::unique_ptr< n_type > x)
  {
    this->n_.set (std::move (x));
  }

  const vcard::note_optional& vcard::
  note () const
  {
    return this->note_;
  }

  vcard::note_optional& vcard::
  note ()
  {
    return this->note_;
  }

  void vcard::
  note (const note_type& x)
  {
    this->note_.set (x);
  }

  void vcard::
  note (const note_optional& x)
  {
    this->note_ = x;
  }

  void vcard::
  note (::std::unique_ptr< note_type > x)
  {
    this->note_.set (std::move (x));
  }

  const vcard::fburl_optional& vcard::
  fburl () const
  {
    return this->fburl_;
  }

  vcard::fburl_optional& vcard::
  fburl ()
  {
    return this->fburl_;
  }

  void vcard::
  fburl (const fburl_type& x)
  {
    this->fburl_.set (x);
  }

  void vcard::
  fburl (const fburl_optional& x)
  {
    this->fburl_ = x;
  }

  void vcard::
  fburl (::std::unique_ptr< fburl_type > x)
  {
    this->fburl_.set (std::move (x));
  }

  const vcard::title_sequence& vcard::
  title () const
  {
    return this->title_;
  }

  vcard::title_sequence& vcard::
  title ()
  {
    return this->title_;
  }

  void vcard::
  title (const title_sequence& s)
  {
    this->title_ = s;
  }

  const vcard::group_sequence& vcard::
  group () const
  {
    return this->group_;
  }

  vcard::group_sequence& vcard::
  group ()
  {
    return this->group_;
  }

  void vcard::
  group (const group_sequence& s)
  {
    this->group_ = s;
  }

  const vcard::url_sequence& vcard::
  url () const
  {
    return this->url_;
  }

  vcard::url_sequence& vcard::
  url ()
  {
    return this->url_;
  }

  void vcard::
  url (const url_sequence& s)
  {
    this->url_ = s;
  }

  const vcard::adr_sequence& vcard::
  adr () const
  {
    return this->adr_;
  }

  vcard::adr_sequence& vcard::
  adr ()
  {
    return this->adr_;
  }

  void vcard::
  adr (const adr_sequence& s)
  {
    this->adr_ = s;
  }

  const vcard::nickname_optional& vcard::
  nickname () const
  {
    return this->nickname_;
  }

  vcard::nickname_optional& vcard::
  nickname ()
  {
    return this->nickname_;
  }

  void vcard::
  nickname (const nickname_type& x)
  {
    this->nickname_.set (x);
  }

  void vcard::
  nickname (const nickname_optional& x)
  {
    this->nickname_ = x;
  }

  void vcard::
  nickname (::std::unique_ptr< nickname_type > x)
  {
    this->nickname_.set (std::move (x));
  }

  const vcard::related_sequence& vcard::
  related () const
  {
    return this->related_;
  }

  vcard::related_sequence& vcard::
  related ()
  {
    return this->related_;
  }

  void vcard::
  related (const related_sequence& s)
  {
    this->related_ = s;
  }

  const vcard::bday_optional& vcard::
  bday () const
  {
    return this->bday_;
  }

  vcard::bday_optional& vcard::
  bday ()
  {
    return this->bday_;
  }

  void vcard::
  bday (const bday_type& x)
  {
    this->bday_.set (x);
  }

  void vcard::
  bday (const bday_optional& x)
  {
    this->bday_ = x;
  }

  void vcard::
  bday (::std::unique_ptr< bday_type > x)
  {
    this->bday_.set (std::move (x));
  }

  const vcard::anniversary_optional& vcard::
  anniversary () const
  {
    return this->anniversary_;
  }

  vcard::anniversary_optional& vcard::
  anniversary ()
  {
    return this->anniversary_;
  }

  void vcard::
  anniversary (const anniversary_type& x)
  {
    this->anniversary_.set (x);
  }

  void vcard::
  anniversary (const anniversary_optional& x)
  {
    this->anniversary_ = x;
  }

  void vcard::
  anniversary (::std::unique_ptr< anniversary_type > x)
  {
    this->anniversary_.set (std::move (x));
  }

  const vcard::photo_optional& vcard::
  photo () const
  {
    return this->photo_;
  }

  vcard::photo_optional& vcard::
  photo ()
  {
    return this->photo_;
  }

  void vcard::
  photo (const photo_type& x)
  {
    this->photo_.set (x);
  }

  void vcard::
  photo (const photo_optional& x)
  {
    this->photo_ = x;
  }

  void vcard::
  photo (::std::unique_ptr< photo_type > x)
  {
    this->photo_.set (std::move (x));
  }

  const vcard::gender_optional& vcard::
  gender () const
  {
    return this->gender_;
  }

  vcard::gender_optional& vcard::
  gender ()
  {
    return this->gender_;
  }

  void vcard::
  gender (const gender_type& x)
  {
    this->gender_.set (x);
  }

  void vcard::
  gender (const gender_optional& x)
  {
    this->gender_ = x;
  }

  void vcard::
  gender (::std::unique_ptr< gender_type > x)
  {
    this->gender_.set (std::move (x));
  }

  const vcard::lang_sequence& vcard::
  lang () const
  {
    return this->lang_;
  }

  vcard::lang_sequence& vcard::
  lang ()
  {
    return this->lang_;
  }

  void vcard::
  lang (const lang_sequence& s)
  {
    this->lang_ = s;
  }

  const vcard::tel_sequence& vcard::
  tel () const
  {
    return this->tel_;
  }

  vcard::tel_sequence& vcard::
  tel ()
  {
    return this->tel_;
  }

  void vcard::
  tel (const tel_sequence& s)
  {
    this->tel_ = s;
  }

  const vcard::impp_sequence& vcard::
  impp () const
  {
    return this->impp_;
  }

  vcard::impp_sequence& vcard::
  impp ()
  {
    return this->impp_;
  }

  void vcard::
  impp (const impp_sequence& s)
  {
    this->impp_ = s;
  }

  const vcard::email_sequence& vcard::
  email () const
  {
    return this->email_;
  }

  vcard::email_sequence& vcard::
  email ()
  {
    return this->email_;
  }

  void vcard::
  email (const email_sequence& s)
  {
    this->email_ = s;
  }

  const vcard::geo_sequence& vcard::
  geo () const
  {
    return this->geo_;
  }

  vcard::geo_sequence& vcard::
  geo ()
  {
    return this->geo_;
  }

  void vcard::
  geo (const geo_sequence& s)
  {
    this->geo_ = s;
  }

  const vcard::key_sequence& vcard::
  key () const
  {
    return this->key_;
  }

  vcard::key_sequence& vcard::
  key ()
  {
    return this->key_;
  }

  void vcard::
  key (const key_sequence& s)
  {
    this->key_ = s;
  }

  const vcard::x_crypto_optional& vcard::
  x_crypto () const
  {
    return this->x_crypto_;
  }

  vcard::x_crypto_optional& vcard::
  x_crypto ()
  {
    return this->x_crypto_;
  }

  void vcard::
  x_crypto (const x_crypto_type& x)
  {
    this->x_crypto_.set (x);
  }

  void vcard::
  x_crypto (const x_crypto_optional& x)
  {
    this->x_crypto_ = x;
  }

  void vcard::
  x_crypto (::std::unique_ptr< x_crypto_type > x)
  {
    this->x_crypto_.set (std::move (x));
  }

  const vcard::member_sequence& vcard::
  member () const
  {
    return this->member_;
  }

  vcard::member_sequence& vcard::
  member ()
  {
    return this->member_;
  }

  void vcard::
  member (const member_sequence& s)
  {
    this->member_ = s;
  }

  const vcard::x_custom_sequence& vcard::
  x_custom () const
  {
    return this->x_custom_;
  }

  vcard::x_custom_sequence& vcard::
  x_custom ()
  {
    return this->x_custom_;
  }

  void vcard::
  x_custom (const x_custom_sequence& s)
  {
    this->x_custom_ = s;
  }
}

#include <xsd/cxx/xml/dom/parsing-source.hxx>

#include <xsd/cxx/tree/type-factory-map.hxx>

namespace _xsd
{
  static
  const ::xsd::cxx::tree::type_factory_plate< 0, char >
  type_factory_plate_init;
}

namespace vcard_4_0
{
  // KolabVersion
  //

  const KolabVersion::text_type KolabVersion::text_default_value_ (
    "3.0");

  KolabVersion::
  KolabVersion (const text_type& text)
  : ::vcard_4_0::BasePropertyType (),
    text_ (text, this)
  {
  }

  KolabVersion::
  KolabVersion (const KolabVersion& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (x, f, c),
    text_ (x.text_, f, this)
  {
  }

  KolabVersion::
  KolabVersion (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    text_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void KolabVersion::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::vcard_4_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        if (!text_.present ())
        {
          this->text_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!text_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "text",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  KolabVersion* KolabVersion::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class KolabVersion (*this, f, c);
  }

  KolabVersion& KolabVersion::
  operator= (const KolabVersion& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BasePropertyType& > (*this) = x;
      this->text_ = x.text_;
    }

    return *this;
  }

  KolabVersion::
  ~KolabVersion ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, KolabVersion >
  _xsd_KolabVersion_type_factory_init (
    "KolabVersion",
    "urn:ietf:params:xml:ns:vcard-4.0");

  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_x_kolab_version_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "x-kolab-version",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::factory_impl< ::vcard_4_0::KolabVersion >);


  // CustomType
  //

  CustomType::
  CustomType (const identifier_type& identifier,
              const value_type& value)
  : ::vcard_4_0::BasePropertyType (),
    identifier_ (identifier, this),
    value_ (value, this)
  {
  }

  CustomType::
  CustomType (const CustomType& x,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (x, f, c),
    identifier_ (x.identifier_, f, this),
    value_ (x.value_, f, this)
  {
  }

  CustomType::
  CustomType (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    identifier_ (this),
    value_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void CustomType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::vcard_4_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // identifier
      //
      if (n.name () == "identifier" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< identifier_type > r (
          identifier_traits::create (i, f, this));

        if (!identifier_.present ())
        {
          this->identifier_.set (::std::move (r));
          continue;
        }
      }

      // value
      //
      if (n.name () == "value" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< value_type > r (
          value_traits::create (i, f, this));

        if (!value_.present ())
        {
          this->value_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!identifier_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "identifier",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }

    if (!value_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "value",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  CustomType* CustomType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CustomType (*this, f, c);
  }

  CustomType& CustomType::
  operator= (const CustomType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BasePropertyType& > (*this) = x;
      this->identifier_ = x.identifier_;
      this->value_ = x.value_;
    }

    return *this;
  }

  CustomType::
  ~CustomType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, CustomType >
  _xsd_CustomType_type_factory_init (
    "CustomType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_x_custom_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "x-custom",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::factory_impl< ::vcard_4_0::CustomType >);


  // CryptoTypeValueType
  //

  CryptoTypeValueType::
  CryptoTypeValueType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::xml_schema::token (e, f, c)
  {
    _xsd_CryptoTypeValueType_convert ();
  }

  CryptoTypeValueType::
  CryptoTypeValueType (const ::xercesc::DOMAttr& a,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::xml_schema::token (a, f, c)
  {
    _xsd_CryptoTypeValueType_convert ();
  }

  CryptoTypeValueType::
  CryptoTypeValueType (const ::std::string& s,
                       const ::xercesc::DOMElement* e,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::xml_schema::token (s, e, f, c)
  {
    _xsd_CryptoTypeValueType_convert ();
  }

  CryptoTypeValueType* CryptoTypeValueType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CryptoTypeValueType (*this, f, c);
  }

  CryptoTypeValueType::value CryptoTypeValueType::
  _xsd_CryptoTypeValueType_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_CryptoTypeValueType_literals_);
    const value* i (::std::lower_bound (
                      _xsd_CryptoTypeValueType_indexes_,
                      _xsd_CryptoTypeValueType_indexes_ + 4,
                      *this,
                      c));

    if (i == _xsd_CryptoTypeValueType_indexes_ + 4 || _xsd_CryptoTypeValueType_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const CryptoTypeValueType::
  _xsd_CryptoTypeValueType_literals_[4] =
  {
    "PGP/INLINE",
    "PGP/MIME",
    "S/MIME",
    "S/MIMEOpaque"
  };

  const CryptoTypeValueType::value CryptoTypeValueType::
  _xsd_CryptoTypeValueType_indexes_[4] =
  {
    ::vcard_4_0::CryptoTypeValueType::PGP_INLINE,
    ::vcard_4_0::CryptoTypeValueType::PGP_MIME,
    ::vcard_4_0::CryptoTypeValueType::S_MIME,
    ::vcard_4_0::CryptoTypeValueType::S_MIMEOpaque
  };

  // PrefTypeValueType
  //

  PrefTypeValueType::
  PrefTypeValueType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::token (e, f, c)
  {
    _xsd_PrefTypeValueType_convert ();
  }

  PrefTypeValueType::
  PrefTypeValueType (const ::xercesc::DOMAttr& a,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::token (a, f, c)
  {
    _xsd_PrefTypeValueType_convert ();
  }

  PrefTypeValueType::
  PrefTypeValueType (const ::std::string& s,
                     const ::xercesc::DOMElement* e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::token (s, e, f, c)
  {
    _xsd_PrefTypeValueType_convert ();
  }

  PrefTypeValueType* PrefTypeValueType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class PrefTypeValueType (*this, f, c);
  }

  PrefTypeValueType::value PrefTypeValueType::
  _xsd_PrefTypeValueType_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_PrefTypeValueType_literals_);
    const value* i (::std::lower_bound (
                      _xsd_PrefTypeValueType_indexes_,
                      _xsd_PrefTypeValueType_indexes_ + 4,
                      *this,
                      c));

    if (i == _xsd_PrefTypeValueType_indexes_ + 4 || _xsd_PrefTypeValueType_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const PrefTypeValueType::
  _xsd_PrefTypeValueType_literals_[4] =
  {
    "Never",
    "Always",
    "IfPossible",
    "Ask"
  };

  const PrefTypeValueType::value PrefTypeValueType::
  _xsd_PrefTypeValueType_indexes_[4] =
  {
    ::vcard_4_0::PrefTypeValueType::Always,
    ::vcard_4_0::PrefTypeValueType::Ask,
    ::vcard_4_0::PrefTypeValueType::IfPossible,
    ::vcard_4_0::PrefTypeValueType::Never
  };

  // CryptoType
  //

  CryptoType::
  CryptoType ()
  : ::vcard_4_0::BasePropertyType (),
    allowed_ (this),
    signpref_ (this),
    encryptpref_ (this)
  {
  }

  CryptoType::
  CryptoType (const CryptoType& x,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (x, f, c),
    allowed_ (x.allowed_, f, this),
    signpref_ (x.signpref_, f, this),
    encryptpref_ (x.encryptpref_, f, this)
  {
  }

  CryptoType::
  CryptoType (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    allowed_ (this),
    signpref_ (this),
    encryptpref_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void CryptoType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::vcard_4_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // allowed
      //
      if (n.name () == "allowed" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< allowed_type > r (
          allowed_traits::create (i, f, this));

        if (!this->allowed_)
        {
          this->allowed_.set (::std::move (r));
          continue;
        }
      }

      // signpref
      //
      if (n.name () == "signpref" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< signpref_type > r (
          signpref_traits::create (i, f, this));

        if (!this->signpref_)
        {
          this->signpref_.set (::std::move (r));
          continue;
        }
      }

      // encryptpref
      //
      if (n.name () == "encryptpref" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< encryptpref_type > r (
          encryptpref_traits::create (i, f, this));

        if (!this->encryptpref_)
        {
          this->encryptpref_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  CryptoType* CryptoType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CryptoType (*this, f, c);
  }

  CryptoType& CryptoType::
  operator= (const CryptoType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BasePropertyType& > (*this) = x;
      this->allowed_ = x.allowed_;
      this->signpref_ = x.signpref_;
      this->encryptpref_ = x.encryptpref_;
    }

    return *this;
  }

  CryptoType::
  ~CryptoType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, CryptoType >
  _xsd_CryptoType_type_factory_init (
    "CryptoType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_x_crypto_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "x-crypto",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::factory_impl< ::vcard_4_0::CryptoType >);


  // VcardsType
  //

  VcardsType::
  VcardsType (const vcard_type& vcard)
  : ::xml_schema::type (),
    vcard_ (vcard, this)
  {
  }

  VcardsType::
  VcardsType (::std::unique_ptr< vcard_type > vcard)
  : ::xml_schema::type (),
    vcard_ (std::move (vcard), this)
  {
  }

  VcardsType::
  VcardsType (const VcardsType& x,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    vcard_ (x.vcard_, f, this)
  {
  }

  VcardsType::
  VcardsType (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    vcard_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void VcardsType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // vcard
      //
      if (n.name () == "vcard" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< vcard_type > r (
          vcard_traits::create (i, f, this));

        if (!vcard_.present ())
        {
          this->vcard_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!vcard_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "vcard",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  VcardsType* VcardsType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class VcardsType (*this, f, c);
  }

  VcardsType& VcardsType::
  operator= (const VcardsType& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->vcard_ = x.vcard_;
    }

    return *this;
  }

  VcardsType::
  ~VcardsType ()
  {
  }

  // allowed
  //

  allowed::
  allowed ()
  : ::xml_schema::type (),
    text_ (this)
  {
  }

  allowed::
  allowed (const allowed& x,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    text_ (x.text_, f, this)
  {
  }

  allowed::
  allowed (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    text_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void allowed::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        this->text_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  allowed* allowed::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class allowed (*this, f, c);
  }

  allowed& allowed::
  operator= (const allowed& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->text_ = x.text_;
    }

    return *this;
  }

  allowed::
  ~allowed ()
  {
  }

  // signpref
  //

  signpref::
  signpref (const text_type& text)
  : ::xml_schema::type (),
    text_ (text, this)
  {
  }

  signpref::
  signpref (const signpref& x,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    text_ (x.text_, f, this)
  {
  }

  signpref::
  signpref (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    text_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void signpref::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        if (!text_.present ())
        {
          this->text_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!text_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "text",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  signpref* signpref::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class signpref (*this, f, c);
  }

  signpref& signpref::
  operator= (const signpref& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->text_ = x.text_;
    }

    return *this;
  }

  signpref::
  ~signpref ()
  {
  }

  // encryptpref
  //

  encryptpref::
  encryptpref (const text_type& text)
  : ::xml_schema::type (),
    text_ (text, this)
  {
  }

  encryptpref::
  encryptpref (const encryptpref& x,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    text_ (x.text_, f, this)
  {
  }

  encryptpref::
  encryptpref (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    text_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void encryptpref::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        if (!text_.present ())
        {
          this->text_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!text_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "text",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  encryptpref* encryptpref::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class encryptpref (*this, f, c);
  }

  encryptpref& encryptpref::
  operator= (const encryptpref& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->text_ = x.text_;
    }

    return *this;
  }

  encryptpref::
  ~encryptpref ()
  {
  }

  // vcard
  //

  vcard::
  vcard (const uid_type& uid,
         const x_kolab_version_type& x_kolab_version,
         const prodid_type& prodid,
         const rev_type& rev,
         const kind_type& kind,
         const fn_type& fn)
  : ::xml_schema::type (),
    uid_ (uid, this),
    x_kolab_version_ (x_kolab_version, this),
    prodid_ (prodid, this),
    rev_ (rev, this),
    categories_ (this),
    kind_ (kind, this),
    fn_ (fn, this),
    n_ (this),
    note_ (this),
    fburl_ (this),
    title_ (this),
    group_ (this),
    url_ (this),
    adr_ (this),
    nickname_ (this),
    related_ (this),
    bday_ (this),
    anniversary_ (this),
    photo_ (this),
    gender_ (this),
    lang_ (this),
    tel_ (this),
    impp_ (this),
    email_ (this),
    geo_ (this),
    key_ (this),
    x_crypto_ (this),
    member_ (this),
    x_custom_ (this)
  {
  }

  vcard::
  vcard (::std::unique_ptr< uid_type > uid,
         ::std::unique_ptr< x_kolab_version_type > x_kolab_version,
         ::std::unique_ptr< prodid_type > prodid,
         ::std::unique_ptr< rev_type > rev,
         ::std::unique_ptr< kind_type > kind,
         ::std::unique_ptr< fn_type > fn)
  : ::xml_schema::type (),
    uid_ (std::move (uid), this),
    x_kolab_version_ (std::move (x_kolab_version), this),
    prodid_ (std::move (prodid), this),
    rev_ (std::move (rev), this),
    categories_ (this),
    kind_ (std::move (kind), this),
    fn_ (std::move (fn), this),
    n_ (this),
    note_ (this),
    fburl_ (this),
    title_ (this),
    group_ (this),
    url_ (this),
    adr_ (this),
    nickname_ (this),
    related_ (this),
    bday_ (this),
    anniversary_ (this),
    photo_ (this),
    gender_ (this),
    lang_ (this),
    tel_ (this),
    impp_ (this),
    email_ (this),
    geo_ (this),
    key_ (this),
    x_crypto_ (this),
    member_ (this),
    x_custom_ (this)
  {
  }

  vcard::
  vcard (const vcard& x,
         ::xml_schema::flags f,
         ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    uid_ (x.uid_, f, this),
    x_kolab_version_ (x.x_kolab_version_, f, this),
    prodid_ (x.prodid_, f, this),
    rev_ (x.rev_, f, this),
    categories_ (x.categories_, f, this),
    kind_ (x.kind_, f, this),
    fn_ (x.fn_, f, this),
    n_ (x.n_, f, this),
    note_ (x.note_, f, this),
    fburl_ (x.fburl_, f, this),
    title_ (x.title_, f, this),
    group_ (x.group_, f, this),
    url_ (x.url_, f, this),
    adr_ (x.adr_, f, this),
    nickname_ (x.nickname_, f, this),
    related_ (x.related_, f, this),
    bday_ (x.bday_, f, this),
    anniversary_ (x.anniversary_, f, this),
    photo_ (x.photo_, f, this),
    gender_ (x.gender_, f, this),
    lang_ (x.lang_, f, this),
    tel_ (x.tel_, f, this),
    impp_ (x.impp_, f, this),
    email_ (x.email_, f, this),
    geo_ (x.geo_, f, this),
    key_ (x.key_, f, this),
    x_crypto_ (x.x_crypto_, f, this),
    member_ (x.member_, f, this),
    x_custom_ (x.x_custom_, f, this)
  {
  }

  vcard::
  vcard (const ::xercesc::DOMElement& e,
         ::xml_schema::flags f,
         ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    uid_ (this),
    x_kolab_version_ (this),
    prodid_ (this),
    rev_ (this),
    categories_ (this),
    kind_ (this),
    fn_ (this),
    n_ (this),
    note_ (this),
    fburl_ (this),
    title_ (this),
    group_ (this),
    url_ (this),
    adr_ (this),
    nickname_ (this),
    related_ (this),
    bday_ (this),
    anniversary_ (this),
    photo_ (this),
    gender_ (this),
    lang_ (this),
    tel_ (this),
    impp_ (this),
    email_ (this),
    geo_ (this),
    key_ (this),
    x_crypto_ (this),
    member_ (this),
    x_custom_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void vcard::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // uid
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "uid",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< uid_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!uid_.present ())
          {
            ::std::unique_ptr< uid_type > r (
              dynamic_cast< uid_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->uid_.set (::std::move (r));
            continue;
          }
        }
      }

      // x-kolab-version
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "x-kolab-version",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< x_kolab_version_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!x_kolab_version_.present ())
          {
            ::std::unique_ptr< x_kolab_version_type > r (
              dynamic_cast< x_kolab_version_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->x_kolab_version_.set (::std::move (r));
            continue;
          }
        }
      }

      // prodid
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "prodid",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< prodid_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!prodid_.present ())
          {
            ::std::unique_ptr< prodid_type > r (
              dynamic_cast< prodid_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->prodid_.set (::std::move (r));
            continue;
          }
        }
      }

      // rev
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "rev",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< rev_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!rev_.present ())
          {
            ::std::unique_ptr< rev_type > r (
              dynamic_cast< rev_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->rev_.set (::std::move (r));
            continue;
          }
        }
      }

      // categories
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "categories",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< categories_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->categories_)
          {
            ::std::unique_ptr< categories_type > r (
              dynamic_cast< categories_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->categories_.set (::std::move (r));
            continue;
          }
        }
      }

      // kind
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "kind",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< kind_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!kind_.present ())
          {
            ::std::unique_ptr< kind_type > r (
              dynamic_cast< kind_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->kind_.set (::std::move (r));
            continue;
          }
        }
      }

      // fn
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "fn",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< fn_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!fn_.present ())
          {
            ::std::unique_ptr< fn_type > r (
              dynamic_cast< fn_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->fn_.set (::std::move (r));
            continue;
          }
        }
      }

      // n
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "n",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< n_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->n_)
          {
            ::std::unique_ptr< n_type > r (
              dynamic_cast< n_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->n_.set (::std::move (r));
            continue;
          }
        }
      }

      // note
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "note",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< note_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->note_)
          {
            ::std::unique_ptr< note_type > r (
              dynamic_cast< note_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->note_.set (::std::move (r));
            continue;
          }
        }
      }

      // fburl
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "fburl",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< fburl_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->fburl_)
          {
            ::std::unique_ptr< fburl_type > r (
              dynamic_cast< fburl_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->fburl_.set (::std::move (r));
            continue;
          }
        }
      }

      // title
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "title",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< title_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< title_type > r (
            dynamic_cast< title_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->title_.push_back (::std::move (r));
          continue;
        }
      }

      // group
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "group",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< group_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< group_type > r (
            dynamic_cast< group_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->group_.push_back (::std::move (r));
          continue;
        }
      }

      // url
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "url",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< url_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< url_type > r (
            dynamic_cast< url_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->url_.push_back (::std::move (r));
          continue;
        }
      }

      // adr
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "adr",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< adr_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< adr_type > r (
            dynamic_cast< adr_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->adr_.push_back (::std::move (r));
          continue;
        }
      }

      // nickname
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "nickname",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< nickname_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->nickname_)
          {
            ::std::unique_ptr< nickname_type > r (
              dynamic_cast< nickname_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->nickname_.set (::std::move (r));
            continue;
          }
        }
      }

      // related
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "related",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< related_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< related_type > r (
            dynamic_cast< related_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->related_.push_back (::std::move (r));
          continue;
        }
      }

      // bday
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "bday",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< bday_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->bday_)
          {
            ::std::unique_ptr< bday_type > r (
              dynamic_cast< bday_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->bday_.set (::std::move (r));
            continue;
          }
        }
      }

      // anniversary
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "anniversary",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< anniversary_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->anniversary_)
          {
            ::std::unique_ptr< anniversary_type > r (
              dynamic_cast< anniversary_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->anniversary_.set (::std::move (r));
            continue;
          }
        }
      }

      // photo
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "photo",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< photo_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->photo_)
          {
            ::std::unique_ptr< photo_type > r (
              dynamic_cast< photo_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->photo_.set (::std::move (r));
            continue;
          }
        }
      }

      // gender
      //
      if (n.name () == "gender" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< gender_type > r (
          gender_traits::create (i, f, this));

        if (!this->gender_)
        {
          this->gender_.set (::std::move (r));
          continue;
        }
      }

      // lang
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "lang",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< lang_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< lang_type > r (
            dynamic_cast< lang_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->lang_.push_back (::std::move (r));
          continue;
        }
      }

      // tel
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "tel",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< tel_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< tel_type > r (
            dynamic_cast< tel_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->tel_.push_back (::std::move (r));
          continue;
        }
      }

      // impp
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "impp",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< impp_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< impp_type > r (
            dynamic_cast< impp_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->impp_.push_back (::std::move (r));
          continue;
        }
      }

      // email
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "email",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< email_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< email_type > r (
            dynamic_cast< email_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->email_.push_back (::std::move (r));
          continue;
        }
      }

      // geo
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "geo",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< geo_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< geo_type > r (
            dynamic_cast< geo_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->geo_.push_back (::std::move (r));
          continue;
        }
      }

      // key
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "key",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< key_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< key_type > r (
            dynamic_cast< key_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->key_.push_back (::std::move (r));
          continue;
        }
      }

      // x-crypto
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "x-crypto",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< x_crypto_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->x_crypto_)
          {
            ::std::unique_ptr< x_crypto_type > r (
              dynamic_cast< x_crypto_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->x_crypto_.set (::std::move (r));
            continue;
          }
        }
      }

      // member
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "member",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< member_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< member_type > r (
            dynamic_cast< member_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->member_.push_back (::std::move (r));
          continue;
        }
      }

      // x-custom
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "x-custom",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< x_custom_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< x_custom_type > r (
            dynamic_cast< x_custom_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->x_custom_.push_back (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!uid_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "uid",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }

    if (!x_kolab_version_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "x-kolab-version",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }

    if (!prodid_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "prodid",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }

    if (!rev_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "rev",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }

    if (!kind_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "kind",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }

    if (!fn_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "fn",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  vcard* vcard::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class vcard (*this, f, c);
  }

  vcard& vcard::
  operator= (const vcard& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->uid_ = x.uid_;
      this->x_kolab_version_ = x.x_kolab_version_;
      this->prodid_ = x.prodid_;
      this->rev_ = x.rev_;
      this->categories_ = x.categories_;
      this->kind_ = x.kind_;
      this->fn_ = x.fn_;
      this->n_ = x.n_;
      this->note_ = x.note_;
      this->fburl_ = x.fburl_;
      this->title_ = x.title_;
      this->group_ = x.group_;
      this->url_ = x.url_;
      this->adr_ = x.adr_;
      this->nickname_ = x.nickname_;
      this->related_ = x.related_;
      this->bday_ = x.bday_;
      this->anniversary_ = x.anniversary_;
      this->photo_ = x.photo_;
      this->gender_ = x.gender_;
      this->lang_ = x.lang_;
      this->tel_ = x.tel_;
      this->impp_ = x.impp_;
      this->email_ = x.email_;
      this->geo_ = x.geo_;
      this->key_ = x.key_;
      this->x_crypto_ = x.x_crypto_;
      this->member_ = x.member_;
      this->x_custom_ = x.x_custom_;
    }

    return *this;
  }

  vcard::
  ~vcard ()
  {
  }
}

#include <istream>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace vcard_4_0
{
  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (const ::std::string& u,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::vcard_4_0::VcardsType > (
      ::vcard_4_0::vcards (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (const ::std::string& u,
          ::xml_schema::error_handler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::vcard_4_0::VcardsType > (
      ::vcard_4_0::vcards (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (const ::std::string& u,
          ::xercesc::DOMErrorHandler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::vcard_4_0::VcardsType > (
      ::vcard_4_0::vcards (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::std::istream& is,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::vcard_4_0::vcards (isrc, f, p);
  }

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::std::istream& is,
          ::xml_schema::error_handler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::vcard_4_0::vcards (isrc, h, f, p);
  }

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::std::istream& is,
          ::xercesc::DOMErrorHandler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::vcard_4_0::vcards (isrc, h, f, p);
  }

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::std::istream& is,
          const ::std::string& sid,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::vcard_4_0::vcards (isrc, f, p);
  }

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::std::istream& is,
          const ::std::string& sid,
          ::xml_schema::error_handler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::vcard_4_0::vcards (isrc, h, f, p);
  }

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::std::istream& is,
          const ::std::string& sid,
          ::xercesc::DOMErrorHandler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::vcard_4_0::vcards (isrc, h, f, p);
  }

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::xercesc::InputSource& i,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::vcard_4_0::VcardsType > (
      ::vcard_4_0::vcards (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::xercesc::InputSource& i,
          ::xml_schema::error_handler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::vcard_4_0::VcardsType > (
      ::vcard_4_0::vcards (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::xercesc::InputSource& i,
          ::xercesc::DOMErrorHandler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::vcard_4_0::VcardsType > (
      ::vcard_4_0::vcards (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (const ::xercesc::DOMDocument& doc,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    if (f & ::xml_schema::flags::keep_dom)
    {
      ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
        static_cast< ::xercesc::DOMDocument* > (doc.cloneNode (true)));

      return ::std::unique_ptr< ::vcard_4_0::VcardsType > (
        ::vcard_4_0::vcards (
          std::move (d), f | ::xml_schema::flags::own_dom, p));
    }

    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "vcards" &&
        n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
    {
      ::std::unique_ptr< ::vcard_4_0::VcardsType > r (
        ::xsd::cxx::tree::traits< ::vcard_4_0::VcardsType, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "vcards",
      "urn:ietf:params:xml:ns:vcard-4.0");
  }

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
          ::xml_schema::flags f,
          const ::xml_schema::properties&)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > c (
      ((f & ::xml_schema::flags::keep_dom) &&
       !(f & ::xml_schema::flags::own_dom))
      ? static_cast< ::xercesc::DOMDocument* > (d->cloneNode (true))
      : 0);

    ::xercesc::DOMDocument& doc (c.get () ? *c : *d);
    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());

    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (f & ::xml_schema::flags::keep_dom)
      doc.setUserData (::xml_schema::dom::tree_node_key,
                       (c.get () ? &c : &d),
                       0);

    if (n.name () == "vcards" &&
        n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
    {
      ::std::unique_ptr< ::vcard_4_0::VcardsType > r (
        ::xsd::cxx::tree::traits< ::vcard_4_0::VcardsType, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "vcards",
      "urn:ietf:params:xml:ns:vcard-4.0");
  }
}

#include <ostream>
#include <xsd/cxx/tree/error-handler.hxx>
#include <xsd/cxx/xml/dom/serialization-source.hxx>

#include <xsd/cxx/tree/type-serializer-map.hxx>

namespace _xsd
{
  static
  const ::xsd::cxx::tree::type_serializer_plate< 0, char >
  type_serializer_plate_init;
}

namespace vcard_4_0
{
  void
  operator<< (::xercesc::DOMElement& e, const KolabVersion& i)
  {
    e << static_cast< const ::vcard_4_0::BasePropertyType& > (i);

    // text
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.text ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, KolabVersion >
  _xsd_KolabVersion_type_serializer_init (
    "KolabVersion",
    "urn:ietf:params:xml:ns:vcard-4.0");


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::vcard_4_0::KolabVersion >
  _xsd_x_kolab_version_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "x-kolab-version",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::serializer_impl< ::vcard_4_0::KolabVersion >);


  void
  operator<< (::xercesc::DOMElement& e, const CustomType& i)
  {
    e << static_cast< const ::vcard_4_0::BasePropertyType& > (i);

    // identifier
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "identifier",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.identifier ();
    }

    // value
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "value",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.value ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, CustomType >
  _xsd_CustomType_type_serializer_init (
    "CustomType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::vcard_4_0::CustomType >
  _xsd_x_custom_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "x-custom",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::serializer_impl< ::vcard_4_0::CustomType >);


  void
  operator<< (::xercesc::DOMElement& e, const CryptoTypeValueType& i)
  {
    e << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const CryptoTypeValueType& i)
  {
    a << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const CryptoTypeValueType& i)
  {
    l << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const PrefTypeValueType& i)
  {
    e << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const PrefTypeValueType& i)
  {
    a << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const PrefTypeValueType& i)
  {
    l << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const CryptoType& i)
  {
    e << static_cast< const ::vcard_4_0::BasePropertyType& > (i);

    // allowed
    //
    if (i.allowed ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "allowed",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << *i.allowed ();
    }

    // signpref
    //
    if (i.signpref ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "signpref",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << *i.signpref ();
    }

    // encryptpref
    //
    if (i.encryptpref ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "encryptpref",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << *i.encryptpref ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, CryptoType >
  _xsd_CryptoType_type_serializer_init (
    "CryptoType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::vcard_4_0::CryptoType >
  _xsd_x_crypto_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "x-crypto",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::serializer_impl< ::vcard_4_0::CryptoType >);


  void
  operator<< (::xercesc::DOMElement& e, const VcardsType& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // vcard
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "vcard",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.vcard ();
    }
  }

  void
  vcards (::std::ostream& o,
          const ::vcard_4_0::VcardsType& s,
          const ::xml_schema::namespace_infomap& m,
          const ::std::string& e,
          ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::vcard_4_0::vcards (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  vcards (::std::ostream& o,
          const ::vcard_4_0::VcardsType& s,
          ::xml_schema::error_handler& h,
          const ::xml_schema::namespace_infomap& m,
          const ::std::string& e,
          ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::vcard_4_0::vcards (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  vcards (::std::ostream& o,
          const ::vcard_4_0::VcardsType& s,
          ::xercesc::DOMErrorHandler& h,
          const ::xml_schema::namespace_infomap& m,
          const ::std::string& e,
          ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::vcard_4_0::vcards (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  vcards (::xercesc::XMLFormatTarget& t,
          const ::vcard_4_0::VcardsType& s,
          const ::xml_schema::namespace_infomap& m,
          const ::std::string& e,
          ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::vcard_4_0::vcards (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  vcards (::xercesc::XMLFormatTarget& t,
          const ::vcard_4_0::VcardsType& s,
          ::xml_schema::error_handler& h,
          const ::xml_schema::namespace_infomap& m,
          const ::std::string& e,
          ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::vcard_4_0::vcards (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  vcards (::xercesc::XMLFormatTarget& t,
          const ::vcard_4_0::VcardsType& s,
          ::xercesc::DOMErrorHandler& h,
          const ::xml_schema::namespace_infomap& m,
          const ::std::string& e,
          ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::vcard_4_0::vcards (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  vcards (::xercesc::DOMDocument& d,
          const ::vcard_4_0::VcardsType& s,
          ::xml_schema::flags)
  {
    ::xercesc::DOMElement& e (*d.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "vcards" &&
        n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
    {
      e << s;
    }
    else
    {
      throw ::xsd::cxx::tree::unexpected_element < char > (
        n.name (),
        n.namespace_ (),
        "vcards",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  vcards (const ::vcard_4_0::VcardsType& s,
          const ::xml_schema::namespace_infomap& m,
          ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::serialize< char > (
        "vcards",
        "urn:ietf:params:xml:ns:vcard-4.0",
        m, f));

    ::vcard_4_0::vcards (*d, s, f);
    return d;
  }

  void
  operator<< (::xercesc::DOMElement& e, const allowed& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // text
    //
    for (allowed::text_const_iterator
         b (i.text ().begin ()), n (i.text ().end ());
         b != n; ++b)
    {
      const allowed::text_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << x;
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const signpref& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // text
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.text ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const encryptpref& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // text
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.text ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const vcard& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // uid
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      const vcard::uid_type& x (i.uid ());
      if (typeid (vcard::uid_type) == typeid (x))
      {
        ::xercesc::DOMElement& s (
          ::xsd::cxx::xml::dom::create_element (
            "uid",
            "urn:ietf:params:xml:ns:vcard-4.0",
            e));

        s << x;
      }
      else
        tsm.serialize (
          "uid",
          "urn:ietf:params:xml:ns:vcard-4.0",
          false, true, e, x);
    }

    // x-kolab-version
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      const vcard::x_kolab_version_type& x (i.x_kolab_version ());
      if (typeid (vcard::x_kolab_version_type) == typeid (x))
      {
        ::xercesc::DOMElement& s (
          ::xsd::cxx::xml::dom::create_element (
            "x-kolab-version",
            "urn:ietf:params:xml:ns:vcard-4.0",
            e));

        s << x;
      }
      else
        tsm.serialize (
          "x-kolab-version",
          "urn:ietf:params:xml:ns:vcard-4.0",
          false, true, e, x);
    }

    // prodid
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      const vcard::prodid_type& x (i.prodid ());
      if (typeid (vcard::prodid_type) == typeid (x))
      {
        ::xercesc::DOMElement& s (
          ::xsd::cxx::xml::dom::create_element (
            "prodid",
            "urn:ietf:params:xml:ns:vcard-4.0",
            e));

        s << x;
      }
      else
        tsm.serialize (
          "prodid",
          "urn:ietf:params:xml:ns:vcard-4.0",
          false, true, e, x);
    }

    // rev
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      const vcard::rev_type& x (i.rev ());
      if (typeid (vcard::rev_type) == typeid (x))
      {
        ::xercesc::DOMElement& s (
          ::xsd::cxx::xml::dom::create_element (
            "rev",
            "urn:ietf:params:xml:ns:vcard-4.0",
            e));

        s << x;
      }
      else
        tsm.serialize (
          "rev",
          "urn:ietf:params:xml:ns:vcard-4.0",
          false, true, e, x);
    }

    // categories
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.categories ())
      {
        const vcard::categories_type& x (*i.categories ());
        if (typeid (vcard::categories_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "categories",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "categories",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // kind
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      const vcard::kind_type& x (i.kind ());
      if (typeid (vcard::kind_type) == typeid (x))
      {
        ::xercesc::DOMElement& s (
          ::xsd::cxx::xml::dom::create_element (
            "kind",
            "urn:ietf:params:xml:ns:vcard-4.0",
            e));

        s << x;
      }
      else
        tsm.serialize (
          "kind",
          "urn:ietf:params:xml:ns:vcard-4.0",
          false, true, e, x);
    }

    // fn
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      const vcard::fn_type& x (i.fn ());
      if (typeid (vcard::fn_type) == typeid (x))
      {
        ::xercesc::DOMElement& s (
          ::xsd::cxx::xml::dom::create_element (
            "fn",
            "urn:ietf:params:xml:ns:vcard-4.0",
            e));

        s << x;
      }
      else
        tsm.serialize (
          "fn",
          "urn:ietf:params:xml:ns:vcard-4.0",
          false, true, e, x);
    }

    // n
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.n ())
      {
        const vcard::n_type& x (*i.n ());
        if (typeid (vcard::n_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "n",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "n",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // note
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.note ())
      {
        const vcard::note_type& x (*i.note ());
        if (typeid (vcard::note_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "note",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "note",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // fburl
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.fburl ())
      {
        const vcard::fburl_type& x (*i.fburl ());
        if (typeid (vcard::fburl_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "fburl",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "fburl",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // title
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (vcard::title_const_iterator
           b (i.title ().begin ()), n (i.title ().end ());
           b != n; ++b)
      {
        const vcard::title_type& x (*b);

        if (typeid (vcard::title_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "title",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "title",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // group
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (vcard::group_const_iterator
           b (i.group ().begin ()), n (i.group ().end ());
           b != n; ++b)
      {
        const vcard::group_type& x (*b);

        if (typeid (vcard::group_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "group",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "group",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // url
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (vcard::url_const_iterator
           b (i.url ().begin ()), n (i.url ().end ());
           b != n; ++b)
      {
        const vcard::url_type& x (*b);

        if (typeid (vcard::url_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "url",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "url",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // adr
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (vcard::adr_const_iterator
           b (i.adr ().begin ()), n (i.adr ().end ());
           b != n; ++b)
      {
        const vcard::adr_type& x (*b);

        if (typeid (vcard::adr_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "adr",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "adr",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // nickname
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.nickname ())
      {
        const vcard::nickname_type& x (*i.nickname ());
        if (typeid (vcard::nickname_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "nickname",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "nickname",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // related
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (vcard::related_const_iterator
           b (i.related ().begin ()), n (i.related ().end ());
           b != n; ++b)
      {
        const vcard::related_type& x (*b);

        if (typeid (vcard::related_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "related",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "related",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // bday
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.bday ())
      {
        const vcard::bday_type& x (*i.bday ());
        if (typeid (vcard::bday_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "bday",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "bday",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // anniversary
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.anniversary ())
      {
        const vcard::anniversary_type& x (*i.anniversary ());
        if (typeid (vcard::anniversary_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "anniversary",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "anniversary",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // photo
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.photo ())
      {
        const vcard::photo_type& x (*i.photo ());
        if (typeid (vcard::photo_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "photo",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "photo",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // gender
    //
    if (i.gender ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "gender",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << *i.gender ();
    }

    // lang
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (vcard::lang_const_iterator
           b (i.lang ().begin ()), n (i.lang ().end ());
           b != n; ++b)
      {
        const vcard::lang_type& x (*b);

        if (typeid (vcard::lang_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "lang",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "lang",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // tel
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (vcard::tel_const_iterator
           b (i.tel ().begin ()), n (i.tel ().end ());
           b != n; ++b)
      {
        const vcard::tel_type& x (*b);

        if (typeid (vcard::tel_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "tel",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "tel",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // impp
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (vcard::impp_const_iterator
           b (i.impp ().begin ()), n (i.impp ().end ());
           b != n; ++b)
      {
        const vcard::impp_type& x (*b);

        if (typeid (vcard::impp_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "impp",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "impp",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // email
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (vcard::email_const_iterator
           b (i.email ().begin ()), n (i.email ().end ());
           b != n; ++b)
      {
        const vcard::email_type& x (*b);

        if (typeid (vcard::email_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "email",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "email",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // geo
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (vcard::geo_const_iterator
           b (i.geo ().begin ()), n (i.geo ().end ());
           b != n; ++b)
      {
        const vcard::geo_type& x (*b);

        if (typeid (vcard::geo_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "geo",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "geo",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // key
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (vcard::key_const_iterator
           b (i.key ().begin ()), n (i.key ().end ());
           b != n; ++b)
      {
        const vcard::key_type& x (*b);

        if (typeid (vcard::key_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "key",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "key",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // x-crypto
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.x_crypto ())
      {
        const vcard::x_crypto_type& x (*i.x_crypto ());
        if (typeid (vcard::x_crypto_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "x-crypto",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "x-crypto",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // member
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (vcard::member_const_iterator
           b (i.member ().begin ()), n (i.member ().end ());
           b != n; ++b)
      {
        const vcard::member_type& x (*b);

        if (typeid (vcard::member_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "member",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "member",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // x-custom
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (vcard::x_custom_const_iterator
           b (i.x_custom ().begin ()), n (i.x_custom ().end ());
           b != n; ++b)
      {
        const vcard::x_custom_type& x (*b);

        if (typeid (vcard::x_custom_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "x-custom",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "x-custom",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }
  }
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

