{-# LANGUAGE PatternSynonyms, ScopedTypeVariables, ViewPatterns #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Constants
    ( 
    pattern VERSION_STRING                  ,
    pattern VERSION_MINOR                   ,
    pattern VERSION_MICRO                   ,
    pattern VERSION_MAJOR                   ,
    pattern SCALE                           ,
    pattern GLYPH_UNKNOWN_FLAG              ,
    pattern GLYPH_INVALID_INPUT             ,
    pattern GLYPH_EMPTY                     ,
    pattern ATTR_INDEX_TO_TEXT_END          ,
    pattern ATTR_INDEX_FROM_TEXT_BEGINNING  ,
    pattern ANALYSIS_FLAG_NEED_HYPHEN       ,
    pattern ANALYSIS_FLAG_IS_ELLIPSIS       ,
    pattern ANALYSIS_FLAG_CENTERED_BASELINE ,

    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | A string literal containing the version of Pango available at compile-time.
pattern VERSION_STRING = "1.57.0" :: T.Text

-- | The minor component of the version of Pango available at compile-time.
pattern VERSION_MINOR = 57 :: Int32

-- | The micro component of the version of Pango available at compile-time.
pattern VERSION_MICRO = 0 :: Int32

-- | The major component of the version of Pango available at compile-time.
pattern VERSION_MAJOR = 1 :: Int32

-- | The scale between dimensions used for Pango distances and device units.
-- 
-- The definition of device units is dependent on the output device; it will
-- typically be pixels for a screen, and points for a printer. 'GI.Pango.Constants.SCALE' is
-- currently 1024, but this may be changed in the future.
-- 
-- When setting font sizes, device units are always considered to be
-- points (as in \"12 point font\"), rather than pixels.
pattern SCALE = 1024 :: Int32

-- | Flag used in @PangoGlyph@ to turn a @gunichar@ value of a valid Unicode
-- character into an unknown-character glyph for that @gunichar@.
-- 
-- Such unknown-character glyphs may be rendered as a \'hex box\'.
pattern GLYPH_UNKNOWN_FLAG = 268435456 :: Word32

-- | A @PangoGlyph@ value for invalid input.
-- 
-- @PangoLayout@ produces one such glyph per invalid input UTF-8 byte and such
-- a glyph is rendered as a crossed box.
-- 
-- Note that this value is defined such that it has the 'GI.Pango.Constants.GLYPH_UNKNOWN_FLAG'
-- set.
-- 
-- /Since: 1.20/
pattern GLYPH_INVALID_INPUT = 4294967295 :: Word32

-- | A @PangoGlyph@ value that indicates a zero-width empty glpyh.
-- 
-- This is useful for example in shaper modules, to use as the glyph for
-- various zero-width Unicode characters (those passing [func/@isZeroWidth@/]).
pattern GLYPH_EMPTY = 268435455 :: Word32

-- | Value for /@endIndex@/ in @PangoAttribute@ that indicates
-- the end of the text.
-- 
-- /Since: 1.24/
pattern ATTR_INDEX_TO_TEXT_END = 4294967295 :: Word32

-- | Value for /@startIndex@/ in @PangoAttribute@ that indicates
-- the beginning of the text.
-- 
-- /Since: 1.24/
pattern ATTR_INDEX_FROM_TEXT_BEGINNING = 0 :: Word32

-- | Whether to add a hyphen at the end of the run during shaping.
-- 
-- /Since: 1.44/
pattern ANALYSIS_FLAG_NEED_HYPHEN = 4 :: Int32

-- | Whether this run holds ellipsized text.
-- 
-- /Since: 1.36.7/
pattern ANALYSIS_FLAG_IS_ELLIPSIS = 2 :: Int32

-- | Whether the segment should be shifted to center around the baseline.
-- 
-- This is mainly used in vertical writing directions.
-- 
-- /Since: 1.16/
pattern ANALYSIS_FLAG_CENTERED_BASELINE = 1 :: Int32


