{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Buffered input stream implements t'GI.Gio.Objects.FilterInputStream.FilterInputStream' and provides
-- for buffered reads.
-- 
-- By default, @GBufferedInputStream@\'s buffer size is set at 4 kilobytes.
-- 
-- To create a buffered input stream, use 'GI.Gio.Objects.BufferedInputStream.bufferedInputStreamNew',
-- or 'GI.Gio.Objects.BufferedInputStream.bufferedInputStreamNewSized' to specify the buffer\'s size at
-- construction.
-- 
-- To get the size of a buffer within a buffered input stream, use
-- 'GI.Gio.Objects.BufferedInputStream.bufferedInputStreamGetBufferSize'. To change the size of a
-- buffered input stream\'s buffer, use 'GI.Gio.Objects.BufferedInputStream.bufferedInputStreamSetBufferSize'.
-- Note that the buffer\'s size cannot be reduced below the size of the data within the buffer.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.BufferedInputStream
    ( 

-- * Exported types
    BufferedInputStream(..)                 ,
    IsBufferedInputStream                   ,
    toBufferedInputStream                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [canSeek]("GI.Gio.Interfaces.Seekable#g:method:canSeek"), [canTruncate]("GI.Gio.Interfaces.Seekable#g:method:canTruncate"), [clearPending]("GI.Gio.Objects.InputStream#g:method:clearPending"), [close]("GI.Gio.Objects.InputStream#g:method:close"), [closeAsync]("GI.Gio.Objects.InputStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.InputStream#g:method:closeFinish"), [fill]("GI.Gio.Objects.BufferedInputStream#g:method:fill"), [fillAsync]("GI.Gio.Objects.BufferedInputStream#g:method:fillAsync"), [fillFinish]("GI.Gio.Objects.BufferedInputStream#g:method:fillFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.InputStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.InputStream#g:method:isClosed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [peek]("GI.Gio.Objects.BufferedInputStream#g:method:peek"), [peekBuffer]("GI.Gio.Objects.BufferedInputStream#g:method:peekBuffer"), [read]("GI.Gio.Objects.InputStream#g:method:read"), [readAll]("GI.Gio.Objects.InputStream#g:method:readAll"), [readAllAsync]("GI.Gio.Objects.InputStream#g:method:readAllAsync"), [readAllFinish]("GI.Gio.Objects.InputStream#g:method:readAllFinish"), [readAsync]("GI.Gio.Objects.InputStream#g:method:readAsync"), [readByte]("GI.Gio.Objects.BufferedInputStream#g:method:readByte"), [readBytes]("GI.Gio.Objects.InputStream#g:method:readBytes"), [readBytesAsync]("GI.Gio.Objects.InputStream#g:method:readBytesAsync"), [readBytesFinish]("GI.Gio.Objects.InputStream#g:method:readBytesFinish"), [readFinish]("GI.Gio.Objects.InputStream#g:method:readFinish"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [seek]("GI.Gio.Interfaces.Seekable#g:method:seek"), [skip]("GI.Gio.Objects.InputStream#g:method:skip"), [skipAsync]("GI.Gio.Objects.InputStream#g:method:skipAsync"), [skipFinish]("GI.Gio.Objects.InputStream#g:method:skipFinish"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [tell]("GI.Gio.Interfaces.Seekable#g:method:tell"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [truncate]("GI.Gio.Interfaces.Seekable#g:method:truncate"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAvailable]("GI.Gio.Objects.BufferedInputStream#g:method:getAvailable"), [getBaseStream]("GI.Gio.Objects.FilterInputStream#g:method:getBaseStream"), [getBufferSize]("GI.Gio.Objects.BufferedInputStream#g:method:getBufferSize"), [getCloseBaseStream]("GI.Gio.Objects.FilterInputStream#g:method:getCloseBaseStream"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setBufferSize]("GI.Gio.Objects.BufferedInputStream#g:method:setBufferSize"), [setCloseBaseStream]("GI.Gio.Objects.FilterInputStream#g:method:setCloseBaseStream"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.InputStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveBufferedInputStreamMethod        ,
#endif

-- ** fill #method:fill#

#if defined(ENABLE_OVERLOADING)
    BufferedInputStreamFillMethodInfo       ,
#endif
    bufferedInputStreamFill                 ,


-- ** fillAsync #method:fillAsync#

#if defined(ENABLE_OVERLOADING)
    BufferedInputStreamFillAsyncMethodInfo  ,
#endif
    bufferedInputStreamFillAsync            ,


-- ** fillFinish #method:fillFinish#

#if defined(ENABLE_OVERLOADING)
    BufferedInputStreamFillFinishMethodInfo ,
#endif
    bufferedInputStreamFillFinish           ,


-- ** getAvailable #method:getAvailable#

#if defined(ENABLE_OVERLOADING)
    BufferedInputStreamGetAvailableMethodInfo,
#endif
    bufferedInputStreamGetAvailable         ,


-- ** getBufferSize #method:getBufferSize#

#if defined(ENABLE_OVERLOADING)
    BufferedInputStreamGetBufferSizeMethodInfo,
#endif
    bufferedInputStreamGetBufferSize        ,


-- ** new #method:new#

    bufferedInputStreamNew                  ,


-- ** newSized #method:newSized#

    bufferedInputStreamNewSized             ,


-- ** peek #method:peek#

#if defined(ENABLE_OVERLOADING)
    BufferedInputStreamPeekMethodInfo       ,
#endif
    bufferedInputStreamPeek                 ,


-- ** peekBuffer #method:peekBuffer#

#if defined(ENABLE_OVERLOADING)
    BufferedInputStreamPeekBufferMethodInfo ,
#endif
    bufferedInputStreamPeekBuffer           ,


-- ** readByte #method:readByte#

#if defined(ENABLE_OVERLOADING)
    BufferedInputStreamReadByteMethodInfo   ,
#endif
    bufferedInputStreamReadByte             ,


-- ** setBufferSize #method:setBufferSize#

#if defined(ENABLE_OVERLOADING)
    BufferedInputStreamSetBufferSizeMethodInfo,
#endif
    bufferedInputStreamSetBufferSize        ,




 -- * Properties


-- ** bufferSize #attr:bufferSize#
-- | The size of the backend buffer, in bytes.

#if defined(ENABLE_OVERLOADING)
    BufferedInputStreamBufferSizePropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    bufferedInputStreamBufferSize           ,
#endif
    constructBufferedInputStreamBufferSize  ,
    getBufferedInputStreamBufferSize        ,
    setBufferedInputStreamBufferSize        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FilterInputStream as Gio.FilterInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FilterInputStream as Gio.FilterInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream

#endif

-- | Memory-managed wrapper type.
newtype BufferedInputStream = BufferedInputStream (SP.ManagedPtr BufferedInputStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype BufferedInputStream where
    toManagedPtr (BufferedInputStream p) = p

foreign import ccall "g_buffered_input_stream_get_type"
    c_g_buffered_input_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject BufferedInputStream where
    glibType = c_g_buffered_input_stream_get_type

instance B.Types.GObject BufferedInputStream

-- | Type class for types which can be safely cast to t'BufferedInputStream', for instance with `toBufferedInputStream`.
class (SP.GObject o, O.IsDescendantOf BufferedInputStream o) => IsBufferedInputStream o
instance (SP.GObject o, O.IsDescendantOf BufferedInputStream o) => IsBufferedInputStream o

instance O.HasParentTypes BufferedInputStream
type instance O.ParentTypes BufferedInputStream = '[Gio.FilterInputStream.FilterInputStream, Gio.InputStream.InputStream, GObject.Object.Object, Gio.Seekable.Seekable]

-- | Cast to t'BufferedInputStream', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toBufferedInputStream :: (MIO.MonadIO m, IsBufferedInputStream o) => o -> m BufferedInputStream
toBufferedInputStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo BufferedInputStream

-- | Convert t'BufferedInputStream' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe BufferedInputStream) where
    gvalueGType_ = c_g_buffered_input_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr BufferedInputStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr BufferedInputStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject BufferedInputStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveBufferedInputStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveBufferedInputStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveBufferedInputStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveBufferedInputStreamMethod "canSeek" o = Gio.Seekable.SeekableCanSeekMethodInfo
    ResolveBufferedInputStreamMethod "canTruncate" o = Gio.Seekable.SeekableCanTruncateMethodInfo
    ResolveBufferedInputStreamMethod "clearPending" o = Gio.InputStream.InputStreamClearPendingMethodInfo
    ResolveBufferedInputStreamMethod "close" o = Gio.InputStream.InputStreamCloseMethodInfo
    ResolveBufferedInputStreamMethod "closeAsync" o = Gio.InputStream.InputStreamCloseAsyncMethodInfo
    ResolveBufferedInputStreamMethod "closeFinish" o = Gio.InputStream.InputStreamCloseFinishMethodInfo
    ResolveBufferedInputStreamMethod "fill" o = BufferedInputStreamFillMethodInfo
    ResolveBufferedInputStreamMethod "fillAsync" o = BufferedInputStreamFillAsyncMethodInfo
    ResolveBufferedInputStreamMethod "fillFinish" o = BufferedInputStreamFillFinishMethodInfo
    ResolveBufferedInputStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveBufferedInputStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveBufferedInputStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveBufferedInputStreamMethod "hasPending" o = Gio.InputStream.InputStreamHasPendingMethodInfo
    ResolveBufferedInputStreamMethod "isClosed" o = Gio.InputStream.InputStreamIsClosedMethodInfo
    ResolveBufferedInputStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveBufferedInputStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveBufferedInputStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveBufferedInputStreamMethod "peek" o = BufferedInputStreamPeekMethodInfo
    ResolveBufferedInputStreamMethod "peekBuffer" o = BufferedInputStreamPeekBufferMethodInfo
    ResolveBufferedInputStreamMethod "read" o = Gio.InputStream.InputStreamReadMethodInfo
    ResolveBufferedInputStreamMethod "readAll" o = Gio.InputStream.InputStreamReadAllMethodInfo
    ResolveBufferedInputStreamMethod "readAllAsync" o = Gio.InputStream.InputStreamReadAllAsyncMethodInfo
    ResolveBufferedInputStreamMethod "readAllFinish" o = Gio.InputStream.InputStreamReadAllFinishMethodInfo
    ResolveBufferedInputStreamMethod "readAsync" o = Gio.InputStream.InputStreamReadAsyncMethodInfo
    ResolveBufferedInputStreamMethod "readByte" o = BufferedInputStreamReadByteMethodInfo
    ResolveBufferedInputStreamMethod "readBytes" o = Gio.InputStream.InputStreamReadBytesMethodInfo
    ResolveBufferedInputStreamMethod "readBytesAsync" o = Gio.InputStream.InputStreamReadBytesAsyncMethodInfo
    ResolveBufferedInputStreamMethod "readBytesFinish" o = Gio.InputStream.InputStreamReadBytesFinishMethodInfo
    ResolveBufferedInputStreamMethod "readFinish" o = Gio.InputStream.InputStreamReadFinishMethodInfo
    ResolveBufferedInputStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveBufferedInputStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveBufferedInputStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveBufferedInputStreamMethod "seek" o = Gio.Seekable.SeekableSeekMethodInfo
    ResolveBufferedInputStreamMethod "skip" o = Gio.InputStream.InputStreamSkipMethodInfo
    ResolveBufferedInputStreamMethod "skipAsync" o = Gio.InputStream.InputStreamSkipAsyncMethodInfo
    ResolveBufferedInputStreamMethod "skipFinish" o = Gio.InputStream.InputStreamSkipFinishMethodInfo
    ResolveBufferedInputStreamMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveBufferedInputStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveBufferedInputStreamMethod "tell" o = Gio.Seekable.SeekableTellMethodInfo
    ResolveBufferedInputStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveBufferedInputStreamMethod "truncate" o = Gio.Seekable.SeekableTruncateMethodInfo
    ResolveBufferedInputStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveBufferedInputStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveBufferedInputStreamMethod "getAvailable" o = BufferedInputStreamGetAvailableMethodInfo
    ResolveBufferedInputStreamMethod "getBaseStream" o = Gio.FilterInputStream.FilterInputStreamGetBaseStreamMethodInfo
    ResolveBufferedInputStreamMethod "getBufferSize" o = BufferedInputStreamGetBufferSizeMethodInfo
    ResolveBufferedInputStreamMethod "getCloseBaseStream" o = Gio.FilterInputStream.FilterInputStreamGetCloseBaseStreamMethodInfo
    ResolveBufferedInputStreamMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveBufferedInputStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveBufferedInputStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveBufferedInputStreamMethod "setBufferSize" o = BufferedInputStreamSetBufferSizeMethodInfo
    ResolveBufferedInputStreamMethod "setCloseBaseStream" o = Gio.FilterInputStream.FilterInputStreamSetCloseBaseStreamMethodInfo
    ResolveBufferedInputStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveBufferedInputStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveBufferedInputStreamMethod "setPending" o = Gio.InputStream.InputStreamSetPendingMethodInfo
    ResolveBufferedInputStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveBufferedInputStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveBufferedInputStreamMethod t BufferedInputStream, O.OverloadedMethod info BufferedInputStream p) => OL.IsLabel t (BufferedInputStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveBufferedInputStreamMethod t BufferedInputStream, O.OverloadedMethod info BufferedInputStream p, R.HasField t BufferedInputStream p) => R.HasField t BufferedInputStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveBufferedInputStreamMethod t BufferedInputStream, O.OverloadedMethodInfo info BufferedInputStream) => OL.IsLabel t (O.MethodProxy info BufferedInputStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "buffer-size"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@buffer-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' bufferedInputStream #bufferSize
-- @
getBufferedInputStreamBufferSize :: (MonadIO m, IsBufferedInputStream o) => o -> m Word32
getBufferedInputStreamBufferSize obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "buffer-size"

-- | Set the value of the “@buffer-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' bufferedInputStream [ #bufferSize 'Data.GI.Base.Attributes.:=' value ]
-- @
setBufferedInputStreamBufferSize :: (MonadIO m, IsBufferedInputStream o) => o -> Word32 -> m ()
setBufferedInputStreamBufferSize obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "buffer-size" val

-- | Construct a t'GValueConstruct' with valid value for the “@buffer-size@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBufferedInputStreamBufferSize :: (IsBufferedInputStream o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructBufferedInputStreamBufferSize val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "buffer-size" val

#if defined(ENABLE_OVERLOADING)
data BufferedInputStreamBufferSizePropertyInfo
instance AttrInfo BufferedInputStreamBufferSizePropertyInfo where
    type AttrAllowedOps BufferedInputStreamBufferSizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint BufferedInputStreamBufferSizePropertyInfo = IsBufferedInputStream
    type AttrSetTypeConstraint BufferedInputStreamBufferSizePropertyInfo = (~) Word32
    type AttrTransferTypeConstraint BufferedInputStreamBufferSizePropertyInfo = (~) Word32
    type AttrTransferType BufferedInputStreamBufferSizePropertyInfo = Word32
    type AttrGetType BufferedInputStreamBufferSizePropertyInfo = Word32
    type AttrLabel BufferedInputStreamBufferSizePropertyInfo = "buffer-size"
    type AttrOrigin BufferedInputStreamBufferSizePropertyInfo = BufferedInputStream
    attrGet = getBufferedInputStreamBufferSize
    attrSet = setBufferedInputStreamBufferSize
    attrPut = setBufferedInputStreamBufferSize
    attrTransfer _ v = do
        return v
    attrConstruct = constructBufferedInputStreamBufferSize
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedInputStream.bufferSize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedInputStream.html#g:attr:bufferSize"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList BufferedInputStream
type instance O.AttributeList BufferedInputStream = BufferedInputStreamAttributeList
type BufferedInputStreamAttributeList = ('[ '("baseStream", Gio.FilterInputStream.FilterInputStreamBaseStreamPropertyInfo), '("bufferSize", BufferedInputStreamBufferSizePropertyInfo), '("closeBaseStream", Gio.FilterInputStream.FilterInputStreamCloseBaseStreamPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
bufferedInputStreamBufferSize :: AttrLabelProxy "bufferSize"
bufferedInputStreamBufferSize = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList BufferedInputStream = BufferedInputStreamSignalList
type BufferedInputStreamSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method BufferedInputStream::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "base_stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.InputStream]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "BufferedInputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_buffered_input_stream_new" g_buffered_input_stream_new :: 
    Ptr Gio.InputStream.InputStream ->      -- base_stream : TInterface (Name {namespace = "Gio", name = "InputStream"})
    IO (Ptr BufferedInputStream)

-- | Creates a new t'GI.Gio.Objects.InputStream.InputStream' from the given /@baseStream@/, with
-- a buffer set to the default size (4 kilobytes).
bufferedInputStreamNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a) =>
    a
    -- ^ /@baseStream@/: a t'GI.Gio.Objects.InputStream.InputStream'
    -> m BufferedInputStream
    -- ^ __Returns:__ a t'GI.Gio.Objects.InputStream.InputStream' for the given /@baseStream@/.
bufferedInputStreamNew baseStream = liftIO $ do
    baseStream' <- unsafeManagedPtrCastPtr baseStream
    result <- g_buffered_input_stream_new baseStream'
    checkUnexpectedReturnNULL "bufferedInputStreamNew" result
    result' <- (wrapObject BufferedInputStream) result
    touchManagedPtr baseStream
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method BufferedInputStream::new_sized
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "base_stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.InputStream]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gsize" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "BufferedInputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_buffered_input_stream_new_sized" g_buffered_input_stream_new_sized :: 
    Ptr Gio.InputStream.InputStream ->      -- base_stream : TInterface (Name {namespace = "Gio", name = "InputStream"})
    FCT.CSize ->                            -- size : TBasicType TSize
    IO (Ptr BufferedInputStream)

-- | Creates a new t'GI.Gio.Objects.BufferedInputStream.BufferedInputStream' from the given /@baseStream@/,
-- with a buffer set to /@size@/.
bufferedInputStreamNewSized ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a) =>
    a
    -- ^ /@baseStream@/: a t'GI.Gio.Objects.InputStream.InputStream'
    -> FCT.CSize
    -- ^ /@size@/: a @/gsize/@
    -> m BufferedInputStream
    -- ^ __Returns:__ a t'GI.Gio.Objects.InputStream.InputStream'.
bufferedInputStreamNewSized baseStream size = liftIO $ do
    baseStream' <- unsafeManagedPtrCastPtr baseStream
    result <- g_buffered_input_stream_new_sized baseStream' size
    checkUnexpectedReturnNULL "bufferedInputStreamNewSized" result
    result' <- (wrapObject BufferedInputStream) result
    touchManagedPtr baseStream
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method BufferedInputStream::fill
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BufferedInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.BufferedInputStream]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of bytes that will be read from the stream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional [class@Gio.Cancellable] object, `NULL` to ignore"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSSize)
-- throws : True
-- Skip return : False

foreign import ccall "g_buffered_input_stream_fill" g_buffered_input_stream_fill :: 
    Ptr BufferedInputStream ->              -- stream : TInterface (Name {namespace = "Gio", name = "BufferedInputStream"})
    DI.Int64 ->                             -- count : TBasicType TSSize
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO DI.Int64

-- | Tries to read /@count@/ bytes from the stream into the buffer.
-- Will block during this read.
-- 
-- If /@count@/ is zero, returns zero and does nothing. A value of /@count@/
-- larger than @G_MAXSSIZE@ will cause a
-- [error/@gio@/.IOErrorEnum.INVALID_ARGUMENT] error.
-- 
-- On success, the number of bytes read into the buffer is returned.
-- It is not an error if this is not the same as the requested size, as it
-- can happen e.g. near the end of a file. Zero is returned on end of file
-- (or if /@count@/ is zero),  but never otherwise.
-- 
-- If /@count@/ is -1 then the attempted read size is equal to the number of
-- bytes that are required to fill the buffer.
-- 
-- If /@cancellable@/ is not @NULL@, then the operation can be cancelled by
-- triggering the cancellable object from another thread. If the operation
-- was cancelled, the error [error/@gio@/.IOErrorEnum.CANCELLED] will be returned.
-- If an operation was partially finished when the operation was cancelled the
-- partial result will be returned, without an error.
-- 
-- On error @-1@ is returned and /@error@/ is set accordingly.
-- 
-- For the asynchronous, non-blocking, version of this function, see
-- 'GI.Gio.Objects.BufferedInputStream.bufferedInputStreamFillAsync'.
bufferedInputStreamFill ::
    (B.CallStack.HasCallStack, MonadIO m, IsBufferedInputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.BufferedInputStream.BufferedInputStream'
    -> DI.Int64
    -- ^ /@count@/: the number of bytes that will be read from the stream
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, @NULL@ to ignore
    -> m DI.Int64
    -- ^ __Returns:__ the number of bytes read into /@stream@/\'s buffer, up to /@count@/,
    --     or @-1@ on error. /(Can throw 'Data.GI.Base.GError.GError')/
bufferedInputStreamFill stream count cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_buffered_input_stream_fill stream' count maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        return result
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data BufferedInputStreamFillMethodInfo
instance (signature ~ (DI.Int64 -> Maybe (b) -> m DI.Int64), MonadIO m, IsBufferedInputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod BufferedInputStreamFillMethodInfo a signature where
    overloadedMethod = bufferedInputStreamFill

instance O.OverloadedMethodInfo BufferedInputStreamFillMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedInputStream.bufferedInputStreamFill",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedInputStream.html#v:bufferedInputStreamFill"
        })


#endif

-- method BufferedInputStream::fill_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BufferedInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.BufferedInputStream]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of bytes that will be read from the stream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the [I/O priority](iface.AsyncResult.html#io-priority) of the request"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "optional [class@Gio.Cancellable] object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [callback@Gio.AsyncReadyCallback]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gpointer" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_buffered_input_stream_fill_async" g_buffered_input_stream_fill_async :: 
    Ptr BufferedInputStream ->              -- stream : TInterface (Name {namespace = "Gio", name = "BufferedInputStream"})
    DI.Int64 ->                             -- count : TBasicType TSSize
    Int32 ->                                -- io_priority : TBasicType TInt
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Reads data into /@stream@/\'s buffer asynchronously, up to /@count@/ size.
-- /@ioPriority@/ can be used to prioritize reads. For the synchronous
-- version of this function, see 'GI.Gio.Objects.BufferedInputStream.bufferedInputStreamFill'.
-- 
-- If /@count@/ is @-1@ then the attempted read size is equal to the number
-- of bytes that are required to fill the buffer.
bufferedInputStreamFillAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsBufferedInputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.BufferedInputStream.BufferedInputStream'
    -> DI.Int64
    -- ^ /@count@/: the number of bytes that will be read from the stream
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority> of the request
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a [callback/@gio@/.AsyncReadyCallback]
    -> m ()
bufferedInputStreamFillAsync stream count ioPriority cancellable callback = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_buffered_input_stream_fill_async stream' count ioPriority maybeCancellable maybeCallback userData
    touchManagedPtr stream
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data BufferedInputStreamFillAsyncMethodInfo
instance (signature ~ (DI.Int64 -> Int32 -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsBufferedInputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod BufferedInputStreamFillAsyncMethodInfo a signature where
    overloadedMethod = bufferedInputStreamFillAsync

instance O.OverloadedMethodInfo BufferedInputStreamFillAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedInputStream.bufferedInputStreamFillAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedInputStream.html#v:bufferedInputStreamFillAsync"
        })


#endif

-- method BufferedInputStream::fill_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BufferedInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.BufferedInputStream]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [iface@Gio.AsyncResult]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSSize)
-- throws : True
-- Skip return : False

foreign import ccall "g_buffered_input_stream_fill_finish" g_buffered_input_stream_fill_finish :: 
    Ptr BufferedInputStream ->              -- stream : TInterface (Name {namespace = "Gio", name = "BufferedInputStream"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO DI.Int64

-- | Finishes an asynchronous read.
bufferedInputStreamFillFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsBufferedInputStream a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.BufferedInputStream.BufferedInputStream'
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'
    -> m DI.Int64
    -- ^ __Returns:__ a @/gssize/@ of the read stream, or @-1@ on an error. /(Can throw 'Data.GI.Base.GError.GError')/
bufferedInputStreamFillFinish stream result_ = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ g_buffered_input_stream_fill_finish stream' result_'
        touchManagedPtr stream
        touchManagedPtr result_
        return result
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data BufferedInputStreamFillFinishMethodInfo
instance (signature ~ (b -> m DI.Int64), MonadIO m, IsBufferedInputStream a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod BufferedInputStreamFillFinishMethodInfo a signature where
    overloadedMethod = bufferedInputStreamFillFinish

instance O.OverloadedMethodInfo BufferedInputStreamFillFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedInputStream.bufferedInputStreamFillFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedInputStream.html#v:bufferedInputStreamFillFinish"
        })


#endif

-- method BufferedInputStream::get_available
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BufferedInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "[class@Gio.BufferedInputStream]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_buffered_input_stream_get_available" g_buffered_input_stream_get_available :: 
    Ptr BufferedInputStream ->              -- stream : TInterface (Name {namespace = "Gio", name = "BufferedInputStream"})
    IO FCT.CSize

-- | Gets the size of the available data within the stream.
bufferedInputStreamGetAvailable ::
    (B.CallStack.HasCallStack, MonadIO m, IsBufferedInputStream a) =>
    a
    -- ^ /@stream@/: t'GI.Gio.Objects.BufferedInputStream.BufferedInputStream'
    -> m FCT.CSize
    -- ^ __Returns:__ size of the available stream.
bufferedInputStreamGetAvailable stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_buffered_input_stream_get_available stream'
    touchManagedPtr stream
    return result

#if defined(ENABLE_OVERLOADING)
data BufferedInputStreamGetAvailableMethodInfo
instance (signature ~ (m FCT.CSize), MonadIO m, IsBufferedInputStream a) => O.OverloadedMethod BufferedInputStreamGetAvailableMethodInfo a signature where
    overloadedMethod = bufferedInputStreamGetAvailable

instance O.OverloadedMethodInfo BufferedInputStreamGetAvailableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedInputStream.bufferedInputStreamGetAvailable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedInputStream.html#v:bufferedInputStreamGetAvailable"
        })


#endif

-- method BufferedInputStream::get_buffer_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BufferedInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.BufferedInputStream]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_buffered_input_stream_get_buffer_size" g_buffered_input_stream_get_buffer_size :: 
    Ptr BufferedInputStream ->              -- stream : TInterface (Name {namespace = "Gio", name = "BufferedInputStream"})
    IO FCT.CSize

-- | Gets the size of the input buffer.
bufferedInputStreamGetBufferSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsBufferedInputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.BufferedInputStream.BufferedInputStream'
    -> m FCT.CSize
    -- ^ __Returns:__ the current buffer size.
bufferedInputStreamGetBufferSize stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_buffered_input_stream_get_buffer_size stream'
    touchManagedPtr stream
    return result

#if defined(ENABLE_OVERLOADING)
data BufferedInputStreamGetBufferSizeMethodInfo
instance (signature ~ (m FCT.CSize), MonadIO m, IsBufferedInputStream a) => O.OverloadedMethod BufferedInputStreamGetBufferSizeMethodInfo a signature where
    overloadedMethod = bufferedInputStreamGetBufferSize

instance O.OverloadedMethodInfo BufferedInputStreamGetBufferSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedInputStream.bufferedInputStreamGetBufferSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedInputStream.html#v:bufferedInputStreamGetBufferSize"
        })


#endif

-- method BufferedInputStream::peek
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BufferedInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.BufferedInputStream]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buffer"
--           , argType = TCArray False (-1) 3 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to\n  an allocated chunk of memory"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "offset"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gsize" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gsize" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "count"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "a #gsize" , sinceVersion = Nothing }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_buffered_input_stream_peek" g_buffered_input_stream_peek :: 
    Ptr BufferedInputStream ->              -- stream : TInterface (Name {namespace = "Gio", name = "BufferedInputStream"})
    Ptr Word8 ->                            -- buffer : TCArray False (-1) 3 (TBasicType TUInt8)
    FCT.CSize ->                            -- offset : TBasicType TSize
    FCT.CSize ->                            -- count : TBasicType TSize
    IO FCT.CSize

-- | Peeks in the buffer, copying data of size /@count@/ into /@buffer@/,
-- offset /@offset@/ bytes.
bufferedInputStreamPeek ::
    (B.CallStack.HasCallStack, MonadIO m, IsBufferedInputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.BufferedInputStream.BufferedInputStream'
    -> ByteString
    -- ^ /@buffer@/: a pointer to
    --   an allocated chunk of memory
    -> FCT.CSize
    -- ^ /@offset@/: a @/gsize/@
    -> m FCT.CSize
    -- ^ __Returns:__ a @/gsize/@ of the number of bytes peeked, or @-1@ on error.
bufferedInputStreamPeek stream buffer offset = liftIO $ do
    let count = fromIntegral $ B.length buffer
    stream' <- unsafeManagedPtrCastPtr stream
    buffer' <- packByteString buffer
    result <- g_buffered_input_stream_peek stream' buffer' offset count
    touchManagedPtr stream
    freeMem buffer'
    return result

#if defined(ENABLE_OVERLOADING)
data BufferedInputStreamPeekMethodInfo
instance (signature ~ (ByteString -> FCT.CSize -> m FCT.CSize), MonadIO m, IsBufferedInputStream a) => O.OverloadedMethod BufferedInputStreamPeekMethodInfo a signature where
    overloadedMethod = bufferedInputStreamPeek

instance O.OverloadedMethodInfo BufferedInputStreamPeekMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedInputStream.bufferedInputStreamPeek",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedInputStream.html#v:bufferedInputStreamPeek"
        })


#endif

-- method BufferedInputStream::peek_buffer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BufferedInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.BufferedInputStream]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #gsize to get the number of bytes available in the buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "count"
--              , argType = TBasicType TSize
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "a #gsize to get the number of bytes available in the buffer"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TCArray False (-1) 1 (TBasicType TUInt8))
-- throws : False
-- Skip return : False

foreign import ccall "g_buffered_input_stream_peek_buffer" g_buffered_input_stream_peek_buffer :: 
    Ptr BufferedInputStream ->              -- stream : TInterface (Name {namespace = "Gio", name = "BufferedInputStream"})
    Ptr FCT.CSize ->                        -- count : TBasicType TSize
    IO (Ptr Word8)

-- | Returns the buffer with the currently available bytes. The returned
-- buffer must not be modified and will become invalid when reading from
-- the stream or filling the buffer.
bufferedInputStreamPeekBuffer ::
    (B.CallStack.HasCallStack, MonadIO m, IsBufferedInputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.BufferedInputStream.BufferedInputStream'
    -> m ByteString
    -- ^ __Returns:__ 
    --          read-only buffer
bufferedInputStreamPeekBuffer stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    count <- allocMem :: IO (Ptr FCT.CSize)
    result <- g_buffered_input_stream_peek_buffer stream' count
    count' <- peek count
    checkUnexpectedReturnNULL "bufferedInputStreamPeekBuffer" result
    result' <- (unpackByteStringWithLength count') result
    touchManagedPtr stream
    freeMem count
    return result'

#if defined(ENABLE_OVERLOADING)
data BufferedInputStreamPeekBufferMethodInfo
instance (signature ~ (m ByteString), MonadIO m, IsBufferedInputStream a) => O.OverloadedMethod BufferedInputStreamPeekBufferMethodInfo a signature where
    overloadedMethod = bufferedInputStreamPeekBuffer

instance O.OverloadedMethodInfo BufferedInputStreamPeekBufferMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedInputStream.bufferedInputStreamPeekBuffer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedInputStream.html#v:bufferedInputStreamPeekBuffer"
        })


#endif

-- method BufferedInputStream::read_byte
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BufferedInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.BufferedInputStream]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional [class@Gio.Cancellable] object, `NULL` to ignore"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : True
-- Skip return : False

foreign import ccall "g_buffered_input_stream_read_byte" g_buffered_input_stream_read_byte :: 
    Ptr BufferedInputStream ->              -- stream : TInterface (Name {namespace = "Gio", name = "BufferedInputStream"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO Int32

-- | Tries to read a single byte from the stream or the buffer. Will block
-- during this read.
-- 
-- On success, the byte read from the stream is returned. On end of stream
-- @-1@ is returned but it\'s not an exceptional error and /@error@/ is not set.
-- 
-- If /@cancellable@/ is not @NULL@, then the operation can be cancelled by
-- triggering the cancellable object from another thread. If the operation
-- was cancelled, the error [error/@gio@/.IOErrorEnum.CANCELLED] will be returned.
-- If an operation was partially finished when the operation was cancelled the
-- partial result will be returned, without an error.
-- 
-- On error @-1@ is returned and /@error@/ is set accordingly.
bufferedInputStreamReadByte ::
    (B.CallStack.HasCallStack, MonadIO m, IsBufferedInputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.BufferedInputStream.BufferedInputStream'
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, @NULL@ to ignore
    -> m Int32
    -- ^ __Returns:__ the byte read from the /@stream@/, or @-1@ on end of stream or error. /(Can throw 'Data.GI.Base.GError.GError')/
bufferedInputStreamReadByte stream cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_buffered_input_stream_read_byte stream' maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        return result
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data BufferedInputStreamReadByteMethodInfo
instance (signature ~ (Maybe (b) -> m Int32), MonadIO m, IsBufferedInputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod BufferedInputStreamReadByteMethodInfo a signature where
    overloadedMethod = bufferedInputStreamReadByte

instance O.OverloadedMethodInfo BufferedInputStreamReadByteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedInputStream.bufferedInputStreamReadByte",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedInputStream.html#v:bufferedInputStreamReadByte"
        })


#endif

-- method BufferedInputStream::set_buffer_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BufferedInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.BufferedInputStream]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gsize" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_buffered_input_stream_set_buffer_size" g_buffered_input_stream_set_buffer_size :: 
    Ptr BufferedInputStream ->              -- stream : TInterface (Name {namespace = "Gio", name = "BufferedInputStream"})
    FCT.CSize ->                            -- size : TBasicType TSize
    IO ()

-- | Sets the size of the internal buffer of /@stream@/ to /@size@/, or to the
-- size of the contents of the buffer. The buffer can never be resized
-- smaller than its current contents.
bufferedInputStreamSetBufferSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsBufferedInputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.BufferedInputStream.BufferedInputStream'
    -> FCT.CSize
    -- ^ /@size@/: a @/gsize/@
    -> m ()
bufferedInputStreamSetBufferSize stream size = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    g_buffered_input_stream_set_buffer_size stream' size
    touchManagedPtr stream
    return ()

#if defined(ENABLE_OVERLOADING)
data BufferedInputStreamSetBufferSizeMethodInfo
instance (signature ~ (FCT.CSize -> m ()), MonadIO m, IsBufferedInputStream a) => O.OverloadedMethod BufferedInputStreamSetBufferSizeMethodInfo a signature where
    overloadedMethod = bufferedInputStreamSetBufferSize

instance O.OverloadedMethodInfo BufferedInputStreamSetBufferSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedInputStream.bufferedInputStreamSetBufferSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedInputStream.html#v:bufferedInputStreamSetBufferSize"
        })


#endif


