{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Deserializes content received via inter-application data transfers.
-- 
-- The @GdkContentDeserializer@ transforms serialized content that is
-- identified by a mime type into an object identified by a GType.
-- 
-- GTK provides serializers and deserializers for common data types
-- such as text, colors, images or file lists. To register your own
-- deserialization functions, use [func/@contentRegisterDeserializer@/].
-- 
-- Also see t'GI.Gdk.Objects.ContentSerializer.ContentSerializer'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.ContentDeserializer
    ( 

-- * Exported types
    ContentDeserializer(..)                 ,
    IsContentDeserializer                   ,
    toContentDeserializer                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isTagged]("GI.Gio.Interfaces.AsyncResult#g:method:isTagged"), [legacyPropagateError]("GI.Gio.Interfaces.AsyncResult#g:method:legacyPropagateError"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [returnError]("GI.Gdk.Objects.ContentDeserializer#g:method:returnError"), [returnSuccess]("GI.Gdk.Objects.ContentDeserializer#g:method:returnSuccess"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCancellable]("GI.Gdk.Objects.ContentDeserializer#g:method:getCancellable"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getGtype]("GI.Gdk.Objects.ContentDeserializer#g:method:getGtype"), [getInputStream]("GI.Gdk.Objects.ContentDeserializer#g:method:getInputStream"), [getMimeType]("GI.Gdk.Objects.ContentDeserializer#g:method:getMimeType"), [getPriority]("GI.Gdk.Objects.ContentDeserializer#g:method:getPriority"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSourceObject]("GI.Gio.Interfaces.AsyncResult#g:method:getSourceObject"), [getTaskData]("GI.Gdk.Objects.ContentDeserializer#g:method:getTaskData"), [getUserData]("GI.Gdk.Objects.ContentDeserializer#g:method:getUserData"), [getValue]("GI.Gdk.Objects.ContentDeserializer#g:method:getValue").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setTaskData]("GI.Gdk.Objects.ContentDeserializer#g:method:setTaskData").

#if defined(ENABLE_OVERLOADING)
    ResolveContentDeserializerMethod        ,
#endif

-- ** getCancellable #method:getCancellable#

#if defined(ENABLE_OVERLOADING)
    ContentDeserializerGetCancellableMethodInfo,
#endif
    contentDeserializerGetCancellable       ,


-- ** getGtype #method:getGtype#

#if defined(ENABLE_OVERLOADING)
    ContentDeserializerGetGtypeMethodInfo   ,
#endif
    contentDeserializerGetGtype             ,


-- ** getInputStream #method:getInputStream#

#if defined(ENABLE_OVERLOADING)
    ContentDeserializerGetInputStreamMethodInfo,
#endif
    contentDeserializerGetInputStream       ,


-- ** getMimeType #method:getMimeType#

#if defined(ENABLE_OVERLOADING)
    ContentDeserializerGetMimeTypeMethodInfo,
#endif
    contentDeserializerGetMimeType          ,


-- ** getPriority #method:getPriority#

#if defined(ENABLE_OVERLOADING)
    ContentDeserializerGetPriorityMethodInfo,
#endif
    contentDeserializerGetPriority          ,


-- ** getTaskData #method:getTaskData#

#if defined(ENABLE_OVERLOADING)
    ContentDeserializerGetTaskDataMethodInfo,
#endif
    contentDeserializerGetTaskData          ,


-- ** getUserData #method:getUserData#

#if defined(ENABLE_OVERLOADING)
    ContentDeserializerGetUserDataMethodInfo,
#endif
    contentDeserializerGetUserData          ,


-- ** getValue #method:getValue#

#if defined(ENABLE_OVERLOADING)
    ContentDeserializerGetValueMethodInfo   ,
#endif
    contentDeserializerGetValue             ,


-- ** returnError #method:returnError#

#if defined(ENABLE_OVERLOADING)
    ContentDeserializerReturnErrorMethodInfo,
#endif
    contentDeserializerReturnError          ,


-- ** returnSuccess #method:returnSuccess#

#if defined(ENABLE_OVERLOADING)
    ContentDeserializerReturnSuccessMethodInfo,
#endif
    contentDeserializerReturnSuccess        ,


-- ** setTaskData #method:setTaskData#

#if defined(ENABLE_OVERLOADING)
    ContentDeserializerSetTaskDataMethodInfo,
#endif
    contentDeserializerSetTaskData          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream

#endif

-- | Memory-managed wrapper type.
newtype ContentDeserializer = ContentDeserializer (SP.ManagedPtr ContentDeserializer)
    deriving (Eq)

instance SP.ManagedPtrNewtype ContentDeserializer where
    toManagedPtr (ContentDeserializer p) = p

foreign import ccall "gdk_content_deserializer_get_type"
    c_gdk_content_deserializer_get_type :: IO B.Types.GType

instance B.Types.TypedObject ContentDeserializer where
    glibType = c_gdk_content_deserializer_get_type

instance B.Types.GObject ContentDeserializer

-- | Type class for types which can be safely cast to t'ContentDeserializer', for instance with `toContentDeserializer`.
class (SP.GObject o, O.IsDescendantOf ContentDeserializer o) => IsContentDeserializer o
instance (SP.GObject o, O.IsDescendantOf ContentDeserializer o) => IsContentDeserializer o

instance O.HasParentTypes ContentDeserializer
type instance O.ParentTypes ContentDeserializer = '[GObject.Object.Object, Gio.AsyncResult.AsyncResult]

-- | Cast to t'ContentDeserializer', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toContentDeserializer :: (MIO.MonadIO m, IsContentDeserializer o) => o -> m ContentDeserializer
toContentDeserializer = MIO.liftIO . B.ManagedPtr.unsafeCastTo ContentDeserializer

-- | Convert t'ContentDeserializer' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ContentDeserializer) where
    gvalueGType_ = c_gdk_content_deserializer_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ContentDeserializer)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ContentDeserializer)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ContentDeserializer ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveContentDeserializerMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveContentDeserializerMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveContentDeserializerMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveContentDeserializerMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveContentDeserializerMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveContentDeserializerMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveContentDeserializerMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveContentDeserializerMethod "isTagged" o = Gio.AsyncResult.AsyncResultIsTaggedMethodInfo
    ResolveContentDeserializerMethod "legacyPropagateError" o = Gio.AsyncResult.AsyncResultLegacyPropagateErrorMethodInfo
    ResolveContentDeserializerMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveContentDeserializerMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveContentDeserializerMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveContentDeserializerMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveContentDeserializerMethod "returnError" o = ContentDeserializerReturnErrorMethodInfo
    ResolveContentDeserializerMethod "returnSuccess" o = ContentDeserializerReturnSuccessMethodInfo
    ResolveContentDeserializerMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveContentDeserializerMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveContentDeserializerMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveContentDeserializerMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveContentDeserializerMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveContentDeserializerMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveContentDeserializerMethod "getCancellable" o = ContentDeserializerGetCancellableMethodInfo
    ResolveContentDeserializerMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveContentDeserializerMethod "getGtype" o = ContentDeserializerGetGtypeMethodInfo
    ResolveContentDeserializerMethod "getInputStream" o = ContentDeserializerGetInputStreamMethodInfo
    ResolveContentDeserializerMethod "getMimeType" o = ContentDeserializerGetMimeTypeMethodInfo
    ResolveContentDeserializerMethod "getPriority" o = ContentDeserializerGetPriorityMethodInfo
    ResolveContentDeserializerMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveContentDeserializerMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveContentDeserializerMethod "getSourceObject" o = Gio.AsyncResult.AsyncResultGetSourceObjectMethodInfo
    ResolveContentDeserializerMethod "getTaskData" o = ContentDeserializerGetTaskDataMethodInfo
    ResolveContentDeserializerMethod "getUserData" o = ContentDeserializerGetUserDataMethodInfo
    ResolveContentDeserializerMethod "getValue" o = ContentDeserializerGetValueMethodInfo
    ResolveContentDeserializerMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveContentDeserializerMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveContentDeserializerMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveContentDeserializerMethod "setTaskData" o = ContentDeserializerSetTaskDataMethodInfo
    ResolveContentDeserializerMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveContentDeserializerMethod t ContentDeserializer, O.OverloadedMethod info ContentDeserializer p) => OL.IsLabel t (ContentDeserializer -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveContentDeserializerMethod t ContentDeserializer, O.OverloadedMethod info ContentDeserializer p, R.HasField t ContentDeserializer p) => R.HasField t ContentDeserializer p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveContentDeserializerMethod t ContentDeserializer, O.OverloadedMethodInfo info ContentDeserializer) => OL.IsLabel t (O.MethodProxy info ContentDeserializer) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ContentDeserializer
type instance O.AttributeList ContentDeserializer = ContentDeserializerAttributeList
type ContentDeserializerAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ContentDeserializer = ContentDeserializerSignalList
type ContentDeserializerSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ContentDeserializer::get_cancellable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "deserializer"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "ContentDeserializer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentDeserializer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Cancellable" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_deserializer_get_cancellable" gdk_content_deserializer_get_cancellable :: 
    Ptr ContentDeserializer ->              -- deserializer : TInterface (Name {namespace = "Gdk", name = "ContentDeserializer"})
    IO (Ptr Gio.Cancellable.Cancellable)

-- | Gets the cancellable for the current operation.
-- 
-- This is the @GCancellable@ that was passed to 'GI.Gdk.Functions.contentDeserializeAsync'.
contentDeserializerGetCancellable ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentDeserializer a) =>
    a
    -- ^ /@deserializer@/: a @GdkContentDeserializer@
    -> m (Maybe Gio.Cancellable.Cancellable)
    -- ^ __Returns:__ the cancellable for the current operation
contentDeserializerGetCancellable deserializer = liftIO $ do
    deserializer' <- unsafeManagedPtrCastPtr deserializer
    result <- gdk_content_deserializer_get_cancellable deserializer'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.Cancellable.Cancellable) result'
        return result''
    touchManagedPtr deserializer
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ContentDeserializerGetCancellableMethodInfo
instance (signature ~ (m (Maybe Gio.Cancellable.Cancellable)), MonadIO m, IsContentDeserializer a) => O.OverloadedMethod ContentDeserializerGetCancellableMethodInfo a signature where
    overloadedMethod = contentDeserializerGetCancellable

instance O.OverloadedMethodInfo ContentDeserializerGetCancellableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentDeserializer.contentDeserializerGetCancellable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentDeserializer.html#v:contentDeserializerGetCancellable"
        })


#endif

-- method ContentDeserializer::get_gtype
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "deserializer"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "ContentDeserializer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentDeserializer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_deserializer_get_gtype" gdk_content_deserializer_get_gtype :: 
    Ptr ContentDeserializer ->              -- deserializer : TInterface (Name {namespace = "Gdk", name = "ContentDeserializer"})
    IO CGType

-- | Gets the @GType@ to create an instance of.
contentDeserializerGetGtype ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentDeserializer a) =>
    a
    -- ^ /@deserializer@/: a @GdkContentDeserializer@
    -> m GType
    -- ^ __Returns:__ the @GType@ for the current operation
contentDeserializerGetGtype deserializer = liftIO $ do
    deserializer' <- unsafeManagedPtrCastPtr deserializer
    result <- gdk_content_deserializer_get_gtype deserializer'
    let result' = GType result
    touchManagedPtr deserializer
    return result'

#if defined(ENABLE_OVERLOADING)
data ContentDeserializerGetGtypeMethodInfo
instance (signature ~ (m GType), MonadIO m, IsContentDeserializer a) => O.OverloadedMethod ContentDeserializerGetGtypeMethodInfo a signature where
    overloadedMethod = contentDeserializerGetGtype

instance O.OverloadedMethodInfo ContentDeserializerGetGtypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentDeserializer.contentDeserializerGetGtype",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentDeserializer.html#v:contentDeserializerGetGtype"
        })


#endif

-- method ContentDeserializer::get_input_stream
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "deserializer"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "ContentDeserializer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentDeserializer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "InputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_deserializer_get_input_stream" gdk_content_deserializer_get_input_stream :: 
    Ptr ContentDeserializer ->              -- deserializer : TInterface (Name {namespace = "Gdk", name = "ContentDeserializer"})
    IO (Ptr Gio.InputStream.InputStream)

-- | Gets the input stream for the current operation.
-- 
-- This is the stream that was passed to 'GI.Gdk.Functions.contentDeserializeAsync'.
contentDeserializerGetInputStream ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentDeserializer a) =>
    a
    -- ^ /@deserializer@/: a @GdkContentDeserializer@
    -> m Gio.InputStream.InputStream
    -- ^ __Returns:__ the input stream for the current operation
contentDeserializerGetInputStream deserializer = liftIO $ do
    deserializer' <- unsafeManagedPtrCastPtr deserializer
    result <- gdk_content_deserializer_get_input_stream deserializer'
    checkUnexpectedReturnNULL "contentDeserializerGetInputStream" result
    result' <- (newObject Gio.InputStream.InputStream) result
    touchManagedPtr deserializer
    return result'

#if defined(ENABLE_OVERLOADING)
data ContentDeserializerGetInputStreamMethodInfo
instance (signature ~ (m Gio.InputStream.InputStream), MonadIO m, IsContentDeserializer a) => O.OverloadedMethod ContentDeserializerGetInputStreamMethodInfo a signature where
    overloadedMethod = contentDeserializerGetInputStream

instance O.OverloadedMethodInfo ContentDeserializerGetInputStreamMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentDeserializer.contentDeserializerGetInputStream",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentDeserializer.html#v:contentDeserializerGetInputStream"
        })


#endif

-- method ContentDeserializer::get_mime_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "deserializer"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "ContentDeserializer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentDeserializer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_deserializer_get_mime_type" gdk_content_deserializer_get_mime_type :: 
    Ptr ContentDeserializer ->              -- deserializer : TInterface (Name {namespace = "Gdk", name = "ContentDeserializer"})
    IO CString

-- | Gets the mime type to deserialize from.
contentDeserializerGetMimeType ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentDeserializer a) =>
    a
    -- ^ /@deserializer@/: a @GdkContentDeserializer@
    -> m T.Text
    -- ^ __Returns:__ the mime type for the current operation
contentDeserializerGetMimeType deserializer = liftIO $ do
    deserializer' <- unsafeManagedPtrCastPtr deserializer
    result <- gdk_content_deserializer_get_mime_type deserializer'
    checkUnexpectedReturnNULL "contentDeserializerGetMimeType" result
    result' <- cstringToText result
    touchManagedPtr deserializer
    return result'

#if defined(ENABLE_OVERLOADING)
data ContentDeserializerGetMimeTypeMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsContentDeserializer a) => O.OverloadedMethod ContentDeserializerGetMimeTypeMethodInfo a signature where
    overloadedMethod = contentDeserializerGetMimeType

instance O.OverloadedMethodInfo ContentDeserializerGetMimeTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentDeserializer.contentDeserializerGetMimeType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentDeserializer.html#v:contentDeserializerGetMimeType"
        })


#endif

-- method ContentDeserializer::get_priority
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "deserializer"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "ContentDeserializer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentDeserializer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_deserializer_get_priority" gdk_content_deserializer_get_priority :: 
    Ptr ContentDeserializer ->              -- deserializer : TInterface (Name {namespace = "Gdk", name = "ContentDeserializer"})
    IO Int32

-- | Gets the I\/O priority for the current operation.
-- 
-- This is the priority that was passed to 'GI.Gdk.Functions.contentDeserializeAsync'.
contentDeserializerGetPriority ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentDeserializer a) =>
    a
    -- ^ /@deserializer@/: a @GdkContentDeserializer@
    -> m Int32
    -- ^ __Returns:__ the I\/O priority for the current operation
contentDeserializerGetPriority deserializer = liftIO $ do
    deserializer' <- unsafeManagedPtrCastPtr deserializer
    result <- gdk_content_deserializer_get_priority deserializer'
    touchManagedPtr deserializer
    return result

#if defined(ENABLE_OVERLOADING)
data ContentDeserializerGetPriorityMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsContentDeserializer a) => O.OverloadedMethod ContentDeserializerGetPriorityMethodInfo a signature where
    overloadedMethod = contentDeserializerGetPriority

instance O.OverloadedMethodInfo ContentDeserializerGetPriorityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentDeserializer.contentDeserializerGetPriority",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentDeserializer.html#v:contentDeserializerGetPriority"
        })


#endif

-- method ContentDeserializer::get_task_data
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "deserializer"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "ContentDeserializer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentDeserializer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_deserializer_get_task_data" gdk_content_deserializer_get_task_data :: 
    Ptr ContentDeserializer ->              -- deserializer : TInterface (Name {namespace = "Gdk", name = "ContentDeserializer"})
    IO (Ptr ())

-- | Gets the data that was associated with the current operation.
-- 
-- See 'GI.Gdk.Objects.ContentDeserializer.contentDeserializerSetTaskData'.
contentDeserializerGetTaskData ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentDeserializer a) =>
    a
    -- ^ /@deserializer@/: a @GdkContentDeserializer@
    -> m (Ptr ())
    -- ^ __Returns:__ the task data for /@deserializer@/
contentDeserializerGetTaskData deserializer = liftIO $ do
    deserializer' <- unsafeManagedPtrCastPtr deserializer
    result <- gdk_content_deserializer_get_task_data deserializer'
    touchManagedPtr deserializer
    return result

#if defined(ENABLE_OVERLOADING)
data ContentDeserializerGetTaskDataMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m, IsContentDeserializer a) => O.OverloadedMethod ContentDeserializerGetTaskDataMethodInfo a signature where
    overloadedMethod = contentDeserializerGetTaskData

instance O.OverloadedMethodInfo ContentDeserializerGetTaskDataMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentDeserializer.contentDeserializerGetTaskData",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentDeserializer.html#v:contentDeserializerGetTaskData"
        })


#endif

-- method ContentDeserializer::get_user_data
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "deserializer"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "ContentDeserializer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentDeserializer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_deserializer_get_user_data" gdk_content_deserializer_get_user_data :: 
    Ptr ContentDeserializer ->              -- deserializer : TInterface (Name {namespace = "Gdk", name = "ContentDeserializer"})
    IO (Ptr ())

-- | Gets the user data that was passed when the deserializer was registered.
contentDeserializerGetUserData ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentDeserializer a) =>
    a
    -- ^ /@deserializer@/: a @GdkContentDeserializer@
    -> m (Ptr ())
    -- ^ __Returns:__ the user data for this deserializer
contentDeserializerGetUserData deserializer = liftIO $ do
    deserializer' <- unsafeManagedPtrCastPtr deserializer
    result <- gdk_content_deserializer_get_user_data deserializer'
    touchManagedPtr deserializer
    return result

#if defined(ENABLE_OVERLOADING)
data ContentDeserializerGetUserDataMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m, IsContentDeserializer a) => O.OverloadedMethod ContentDeserializerGetUserDataMethodInfo a signature where
    overloadedMethod = contentDeserializerGetUserData

instance O.OverloadedMethodInfo ContentDeserializerGetUserDataMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentDeserializer.contentDeserializerGetUserData",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentDeserializer.html#v:contentDeserializerGetUserData"
        })


#endif

-- method ContentDeserializer::get_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "deserializer"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "ContentDeserializer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentDeserializer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TGValue
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_deserializer_get_value" gdk_content_deserializer_get_value :: 
    Ptr ContentDeserializer ->              -- deserializer : TInterface (Name {namespace = "Gdk", name = "ContentDeserializer"})
    IO (Ptr GValue)

-- | Gets the @GValue@ to store the deserialized object in.
contentDeserializerGetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentDeserializer a) =>
    a
    -- ^ /@deserializer@/: a @GdkContentDeserializer@
    -> m GValue
    -- ^ __Returns:__ the @GValue@ for the current operation
contentDeserializerGetValue deserializer = liftIO $ do
    deserializer' <- unsafeManagedPtrCastPtr deserializer
    result <- gdk_content_deserializer_get_value deserializer'
    checkUnexpectedReturnNULL "contentDeserializerGetValue" result
    result' <- B.GValue.newGValueFromPtr result
    touchManagedPtr deserializer
    return result'

#if defined(ENABLE_OVERLOADING)
data ContentDeserializerGetValueMethodInfo
instance (signature ~ (m GValue), MonadIO m, IsContentDeserializer a) => O.OverloadedMethod ContentDeserializerGetValueMethodInfo a signature where
    overloadedMethod = contentDeserializerGetValue

instance O.OverloadedMethodInfo ContentDeserializerGetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentDeserializer.contentDeserializerGetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentDeserializer.html#v:contentDeserializerGetValue"
        })


#endif

-- method ContentDeserializer::return_error
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "deserializer"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "ContentDeserializer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentDeserializer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GError`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_deserializer_return_error" gdk_content_deserializer_return_error :: 
    Ptr ContentDeserializer ->              -- deserializer : TInterface (Name {namespace = "Gdk", name = "ContentDeserializer"})
    Ptr GError ->                           -- error : TError
    IO ()

-- | Indicate that the deserialization has ended with an error.
-- 
-- This function consumes /@error@/.
contentDeserializerReturnError ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentDeserializer a) =>
    a
    -- ^ /@deserializer@/: a @GdkContentDeserializer@
    -> GError
    -- ^ /@error@/: a @GError@
    -> m ()
contentDeserializerReturnError deserializer error_ = liftIO $ do
    deserializer' <- unsafeManagedPtrCastPtr deserializer
    error_' <- B.ManagedPtr.disownBoxed error_
    gdk_content_deserializer_return_error deserializer' error_'
    touchManagedPtr deserializer
    touchManagedPtr error_
    return ()

#if defined(ENABLE_OVERLOADING)
data ContentDeserializerReturnErrorMethodInfo
instance (signature ~ (GError -> m ()), MonadIO m, IsContentDeserializer a) => O.OverloadedMethod ContentDeserializerReturnErrorMethodInfo a signature where
    overloadedMethod = contentDeserializerReturnError

instance O.OverloadedMethodInfo ContentDeserializerReturnErrorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentDeserializer.contentDeserializerReturnError",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentDeserializer.html#v:contentDeserializerReturnError"
        })


#endif

-- method ContentDeserializer::return_success
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "deserializer"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "ContentDeserializer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentDeserializer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_deserializer_return_success" gdk_content_deserializer_return_success :: 
    Ptr ContentDeserializer ->              -- deserializer : TInterface (Name {namespace = "Gdk", name = "ContentDeserializer"})
    IO ()

-- | Indicate that the deserialization has been successfully completed.
contentDeserializerReturnSuccess ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentDeserializer a) =>
    a
    -- ^ /@deserializer@/: a @GdkContentDeserializer@
    -> m ()
contentDeserializerReturnSuccess deserializer = liftIO $ do
    deserializer' <- unsafeManagedPtrCastPtr deserializer
    gdk_content_deserializer_return_success deserializer'
    touchManagedPtr deserializer
    return ()

#if defined(ENABLE_OVERLOADING)
data ContentDeserializerReturnSuccessMethodInfo
instance (signature ~ (m ()), MonadIO m, IsContentDeserializer a) => O.OverloadedMethod ContentDeserializerReturnSuccessMethodInfo a signature where
    overloadedMethod = contentDeserializerReturnSuccess

instance O.OverloadedMethodInfo ContentDeserializerReturnSuccessMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentDeserializer.contentDeserializerReturnSuccess",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentDeserializer.html#v:contentDeserializerReturnSuccess"
        })


#endif

-- method ContentDeserializer::set_task_data
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "deserializer"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "ContentDeserializer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentDeserializer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to associate with this operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notify for @data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_deserializer_set_task_data" gdk_content_deserializer_set_task_data :: 
    Ptr ContentDeserializer ->              -- deserializer : TInterface (Name {namespace = "Gdk", name = "ContentDeserializer"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Associate data with the current deserialization operation.
contentDeserializerSetTaskData ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentDeserializer a) =>
    a
    -- ^ /@deserializer@/: a @GdkContentDeserializer@
    -> Ptr ()
    -- ^ /@data@/: data to associate with this operation
    -> GLib.Callbacks.DestroyNotify
    -- ^ /@notify@/: destroy notify for /@data@/
    -> m ()
contentDeserializerSetTaskData deserializer data_ notify = liftIO $ do
    deserializer' <- unsafeManagedPtrCastPtr deserializer
    ptrnotify <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
    notify' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptrnotify) notify)
    poke ptrnotify notify'
    gdk_content_deserializer_set_task_data deserializer' data_ notify'
    touchManagedPtr deserializer
    return ()

#if defined(ENABLE_OVERLOADING)
data ContentDeserializerSetTaskDataMethodInfo
instance (signature ~ (Ptr () -> GLib.Callbacks.DestroyNotify -> m ()), MonadIO m, IsContentDeserializer a) => O.OverloadedMethod ContentDeserializerSetTaskDataMethodInfo a signature where
    overloadedMethod = contentDeserializerSetTaskData

instance O.OverloadedMethodInfo ContentDeserializerSetTaskDataMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentDeserializer.contentDeserializerSetTaskData",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentDeserializer.html#v:contentDeserializerSetTaskData"
        })


#endif


