/* gsound-play.c generated by valac 0.56.8, the Vala compiler
 * generated from gsound-play.vala, do not modify */

/* gsound-play.vala
 *
 * Copyright (C) 2014 Tristan Brindle <t.c.brindle@gmail.com>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include "gsound.h"
#include <gio/gio.h>
#include <locale.h>
#include <glib-object.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef struct _PlayData PlayData;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _PlayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gint _tmp0_;
	GSoundContext* _tmp1_;
	GHashTable* _tmp2_;
	GError* _inner_error0_;
};

VALA_EXTERN gchar* event_id;
gchar* event_id = NULL;
VALA_EXTERN gchar* filename;
gchar* filename = NULL;
VALA_EXTERN gchar* desc;
gchar* desc = NULL;
VALA_EXTERN gchar* cache;
gchar* cache = NULL;
VALA_EXTERN gint loops;
gint loops = 0;
VALA_EXTERN gdouble volume;
gdouble volume = 0.0;
VALA_EXTERN gchar* driver;
gchar* driver = NULL;
VALA_EXTERN GMainLoop* main_loop;
GMainLoop* main_loop = NULL;
VALA_EXTERN GSoundContext* gs_ctx;
GSoundContext* gs_ctx = NULL;
VALA_EXTERN GHashTable* attrs;
GHashTable* attrs = NULL;

static void play_data_free (gpointer _data);
VALA_EXTERN void play (GAsyncReadyCallback _callback_,
           gpointer _user_data_);
VALA_EXTERN void play_finish (GAsyncResult* _res_,
                  GError** error);
static gboolean play_co (PlayData* _data_);
static void play_ready (GObject* source_object,
                 GAsyncResult* _res_,
                 gpointer _user_data_);
static gint _vala_main (gchar** args,
                 gint args_length1);
static void _g_free0_ (gpointer var);
static void ___lambda4_ (GObject* obj,
                  GAsyncResult* res);
static void ____lambda4__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);

const GOptionEntry opts[8] = {{"id", 'i', (gint) 0, G_OPTION_ARG_STRING, &event_id, "Event sound identifier", "STRING"}, {"file", 'f', (gint) 0, G_OPTION_ARG_FILENAME, &filename, "Play file", "PATH"}, {"description", 'd', (gint) 0, G_OPTION_ARG_STRING, &desc, "Event sound description", "STRING"}, {"cache-control", 'c', (gint) 0, G_OPTION_ARG_STRING, &cache, "Cache control (permanent, volatile, never", "STRING"}, {"loop", 'l', (gint) 0, G_OPTION_ARG_INT, &loops, "Loop many times (default: 1)", "INTEGER"}, {"volume", 'V', (gint) 0, G_OPTION_ARG_DOUBLE, &volume, "A floating point dB value for the sample volume (ex: 0.0)", "STRING"}, {"backend", 'b', (gint) 0, G_OPTION_ARG_STRING, &driver, "libcanberra backend to use", "STRING"}, {NULL}};

static void
play_data_free (gpointer _data)
{
	PlayData* _data_;
	_data_ = _data;
	g_slice_free (PlayData, _data_);
}

void
play (GAsyncReadyCallback _callback_,
      gpointer _user_data_)
{
	PlayData* _data_;
	_data_ = g_slice_new0 (PlayData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, play_data_free);
	play_co (_data_);
}

void
play_finish (GAsyncResult* _res_,
             GError** error)
{
	PlayData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
play_ready (GObject* source_object,
            GAsyncResult* _res_,
            gpointer _user_data_)
{
	PlayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	play_co (_data_);
}

static gboolean
play_co (PlayData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	while (TRUE) {
		_data_->_tmp0_ = loops;
		loops = _data_->_tmp0_ - 1;
		if (!(_data_->_tmp0_ > 0)) {
			break;
		}
		_data_->_tmp1_ = gs_ctx;
		_data_->_tmp2_ = attrs;
		_data_->_state_ = 1;
		gsound_context_play_fullv (_data_->_tmp1_, _data_->_tmp2_, NULL, play_ready, _data_);
		return FALSE;
		_state_1:
		gsound_context_play_full_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static void
___lambda4_ (GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		play_finish (res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_print ("Error: %s\n", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		GMainLoop* _tmp2_;
		_tmp2_ = main_loop;
		g_main_loop_quit (_tmp2_);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda4__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	___lambda4_ (source_object, res);
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	GOptionContext* opt_ctx = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GError* _inner_error0_ = NULL;
	gint result;
	setlocale (LC_ALL, "");
	g_set_application_name ("gsound-play");
	_tmp0_ = g_option_context_new (NULL);
	opt_ctx = _tmp0_;
	_tmp1_ = opt_ctx;
	g_option_context_add_main_entries (_tmp1_, opts, NULL);
	{
		GOptionContext* _tmp2_;
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
		GSoundContext* _tmp6_ = NULL;
		GSoundContext* _tmp7_;
		GSoundContext* _tmp8_;
		GSoundContext* _tmp9_;
		const gchar* _tmp10_;
		GHashFunc _tmp13_;
		GEqualFunc _tmp14_;
		GHashTable* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp21_;
		const gchar* _tmp26_;
		GMainLoop* _tmp34_;
		GMainLoop* _tmp35_;
		_tmp2_ = opt_ctx;
		g_option_context_parse (_tmp2_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = event_id;
		if (_tmp4_ == NULL) {
			const gchar* _tmp5_;
			_tmp5_ = filename;
			_tmp3_ = _tmp5_ == NULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			g_print ("No event id or file specified.\n");
			result = 1;
			_g_option_context_free0 (opt_ctx);
			return result;
		}
		_tmp7_ = gsound_context_new (NULL, &_inner_error0_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (gs_ctx);
		gs_ctx = _tmp8_;
		_tmp9_ = gs_ctx;
		gsound_context_set_attributes (_tmp9_, &_inner_error0_, GSOUND_ATTR_APPLICATION_ID, "org.gnome.gsound-test", NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp6_);
			goto __catch0_g_error;
		}
		_tmp10_ = driver;
		if (_tmp10_ != NULL) {
			GSoundContext* _tmp11_;
			const gchar* _tmp12_;
			_tmp11_ = gs_ctx;
			_tmp12_ = driver;
			gsound_context_set_driver (_tmp11_, _tmp12_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp6_);
				goto __catch0_g_error;
			}
		}
		_tmp13_ = g_str_hash;
		_tmp14_ = g_str_equal;
		_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, _g_free0_, _g_free0_);
		_g_hash_table_unref0 (attrs);
		attrs = _tmp15_;
		_tmp16_ = event_id;
		if (_tmp16_ != NULL) {
			GHashTable* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp17_ = attrs;
			_tmp18_ = g_strdup (GSOUND_ATTR_EVENT_ID);
			_tmp19_ = event_id;
			_tmp20_ = g_strdup (_tmp19_);
			g_hash_table_insert (_tmp17_, _tmp18_, _tmp20_);
		}
		_tmp21_ = filename;
		if (_tmp21_ != NULL) {
			GHashTable* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp22_ = attrs;
			_tmp23_ = g_strdup (GSOUND_ATTR_MEDIA_FILENAME);
			_tmp24_ = filename;
			_tmp25_ = g_strdup (_tmp24_);
			g_hash_table_insert (_tmp22_, _tmp23_, _tmp25_);
		}
		_tmp26_ = cache;
		if (_tmp26_ != NULL) {
			GHashTable* _tmp27_;
			gchar* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			_tmp27_ = attrs;
			_tmp28_ = g_strdup (GSOUND_ATTR_CANBERRA_CACHE_CONTROL);
			_tmp29_ = cache;
			_tmp30_ = g_strdup (_tmp29_);
			g_hash_table_insert (_tmp27_, _tmp28_, _tmp30_);
		}
		if (volume != 0.0) {
			GHashTable* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp31_ = attrs;
			_tmp32_ = g_strdup (GSOUND_ATTR_CANBERRA_VOLUME);
			_tmp33_ = double_to_string (volume);
			g_hash_table_insert (_tmp31_, _tmp32_, _tmp33_);
		}
		if (loops == 0) {
			loops = 1;
		}
		play (____lambda4__gasync_ready_callback, NULL);
		_tmp34_ = g_main_loop_new (NULL, FALSE);
		_g_main_loop_unref0 (main_loop);
		main_loop = _tmp34_;
		_tmp35_ = main_loop;
		g_main_loop_run (_tmp35_);
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp36_;
		const gchar* _tmp37_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		g_print ("Error: %s\n", _tmp37_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (opt_ctx);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp38_ = -1;
		_g_option_context_free0 (opt_ctx);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp38_;
	}
	result = 0;
	_g_option_context_free0 (opt_ctx);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

