/* Avatar.c generated by valac 0.56.17, the Vala compiler
 * generated from Avatar.vala, do not modify */

/*
 * Copyright 2015–2017 elementary, Inc. (https://elementary.io)
 * Copyright 2015–2017 Felipe Escoto <felescoto95@hotmail.com>
 * Copyright 2015–2017 Rico Tzschichholz <ricotz@ubuntu.com>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <float.h>
#include <math.h>

#define GRANITE_WIDGETS_AVATAR_DEFAULT_ICON "avatar-default"
#define GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN 4
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_WIDGETS_AVATAR_0_PROPERTY,
	GRANITE_WIDGETS_AVATAR_PIXBUF_PROPERTY,
	GRANITE_WIDGETS_AVATAR_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_avatar_properties[GRANITE_WIDGETS_AVATAR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GraniteWidgetsAvatarPrivate {
	gboolean draw_theme_background;
	gboolean is_default;
	gchar* orig_filename;
	gint* orig_pixel_size;
	GdkPixbuf* _pixbuf;
};

static gint GraniteWidgetsAvatar_private_offset;
static gpointer granite_widgets_avatar_parent_class = NULL;

static void granite_widgets_avatar_refresh_size_request (GraniteWidgetsAvatar* self);
static void _granite_widgets_avatar_refresh_size_request_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void granite_widgets_avatar_dpi_change (GraniteWidgetsAvatar* self);
static void _granite_widgets_avatar_dpi_change_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                     gpointer self);
static void granite_widgets_avatar_load_image (GraniteWidgetsAvatar* self,
                                        const gchar* filepath,
                                        gint pixel_size);
static gint* _int_dup (gint* self);
static gboolean granite_widgets_avatar_real_draw (GtkWidget* base,
                                           cairo_t* cr);
static GObject * granite_widgets_avatar_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void granite_widgets_avatar_finalize (GObject * obj);
static GType granite_widgets_avatar_get_type_once (void);
static void _vala_granite_widgets_avatar_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_granite_widgets_avatar_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
granite_widgets_avatar_get_instance_private (GraniteWidgetsAvatar* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsAvatar_private_offset);
}

static void
_granite_widgets_avatar_refresh_size_request_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	granite_widgets_avatar_refresh_size_request ((GraniteWidgetsAvatar*) self);
}

static void
_granite_widgets_avatar_dpi_change_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                gpointer self)
{
	granite_widgets_avatar_dpi_change ((GraniteWidgetsAvatar*) self);
}

GdkPixbuf*
granite_widgets_avatar_get_pixbuf (GraniteWidgetsAvatar* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pixbuf;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
granite_widgets_avatar_set_pixbuf (GraniteWidgetsAvatar* self,
                                   GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_avatar_get_pixbuf (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_pixbuf);
		self->priv->_pixbuf = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_avatar_properties[GRANITE_WIDGETS_AVATAR_PIXBUF_PROPERTY]);
	}
}

/**
     * Makes new Avatar widget
     *
     */
GraniteWidgetsAvatar*
granite_widgets_avatar_construct (GType object_type)
{
	GraniteWidgetsAvatar * self = NULL;
	self = (GraniteWidgetsAvatar*) g_object_new (object_type, NULL);
	return self;
}

GraniteWidgetsAvatar*
granite_widgets_avatar_new (void)
{
	return granite_widgets_avatar_construct (GRANITE_WIDGETS_TYPE_AVATAR);
}

/**
    * Creates a new Avatar from the specified pixbuf
    *
    * @param pixbuf image to be used
    */
GraniteWidgetsAvatar*
granite_widgets_avatar_construct_from_pixbuf (GType object_type,
                                              GdkPixbuf* pixbuf)
{
	GraniteWidgetsAvatar * self = NULL;
	g_return_val_if_fail (pixbuf != NULL, NULL);
	self = (GraniteWidgetsAvatar*) g_object_new (object_type, "pixbuf", pixbuf, NULL);
	return self;
}

GraniteWidgetsAvatar*
granite_widgets_avatar_new_from_pixbuf (GdkPixbuf* pixbuf)
{
	return granite_widgets_avatar_construct_from_pixbuf (GRANITE_WIDGETS_TYPE_AVATAR, pixbuf);
}

/**
     * Creates a new Avatar from the specified filepath and icon size
     *
     * @param filepath image to be used
     * @param pixel_size to scale the image
     */
static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

GraniteWidgetsAvatar*
granite_widgets_avatar_construct_from_file (GType object_type,
                                            const gchar* filepath,
                                            gint pixel_size)
{
	GraniteWidgetsAvatar * self = NULL;
	gchar* _tmp0_;
	gint* _tmp1_;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (GraniteWidgetsAvatar*) g_object_new (object_type, NULL);
	granite_widgets_avatar_load_image (self, filepath, pixel_size);
	_tmp0_ = g_strdup (filepath);
	_g_free0 (self->priv->orig_filename);
	self->priv->orig_filename = _tmp0_;
	_tmp1_ = __int_dup0 (&pixel_size);
	_g_free0 (self->priv->orig_pixel_size);
	self->priv->orig_pixel_size = _tmp1_;
	return self;
}

GraniteWidgetsAvatar*
granite_widgets_avatar_new_from_file (const gchar* filepath,
                                      gint pixel_size)
{
	return granite_widgets_avatar_construct_from_file (GRANITE_WIDGETS_TYPE_AVATAR, filepath, pixel_size);
}

static void
granite_widgets_avatar_load_image (GraniteWidgetsAvatar* self,
                                   const gchar* filepath,
                                   gint pixel_size)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filepath != NULL);
	{
		gint size = 0;
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_;
		size = pixel_size * gtk_widget_get_scale_factor ((GtkWidget*) self);
		_tmp1_ = gdk_pixbuf_new_from_file_at_size (filepath, size, size, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		granite_widgets_avatar_set_pixbuf (self, _tmp0_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		granite_widgets_avatar_show_default (self, pixel_size);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
     * Creates a new Avatar with the default icon from theme without applying the css style
     *
     * @param pixel_size size of the icon to be loaded
     */
GraniteWidgetsAvatar*
granite_widgets_avatar_construct_with_default_icon (GType object_type,
                                                    gint pixel_size)
{
	GraniteWidgetsAvatar * self = NULL;
	gint* _tmp0_;
	self = (GraniteWidgetsAvatar*) g_object_new (object_type, NULL);
	granite_widgets_avatar_show_default (self, pixel_size);
	_tmp0_ = __int_dup0 (&pixel_size);
	_g_free0 (self->priv->orig_pixel_size);
	self->priv->orig_pixel_size = _tmp0_;
	return self;
}

GraniteWidgetsAvatar*
granite_widgets_avatar_new_with_default_icon (gint pixel_size)
{
	return granite_widgets_avatar_construct_with_default_icon (GRANITE_WIDGETS_TYPE_AVATAR, pixel_size);
}

static void
granite_widgets_avatar_refresh_size_request (GraniteWidgetsAvatar* self)
{
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_pixbuf;
	if (_tmp0_ != NULL) {
		gint scale_factor = 0;
		GdkPixbuf* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		GdkPixbuf* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		scale_factor = gtk_widget_get_scale_factor ((GtkWidget*) self);
		_tmp1_ = self->priv->_pixbuf;
		_tmp2_ = gdk_pixbuf_get_width (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->_pixbuf;
		_tmp5_ = gdk_pixbuf_get_height (_tmp4_);
		_tmp6_ = _tmp5_;
		gtk_widget_set_size_request ((GtkWidget*) self, (_tmp3_ / scale_factor) + (GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN * 2), (_tmp6_ / scale_factor) + (GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN * 2));
		self->priv->draw_theme_background = TRUE;
	} else {
		gtk_widget_set_size_request ((GtkWidget*) self, 0, 0);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
granite_widgets_avatar_dpi_change (GraniteWidgetsAvatar* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->is_default) {
		gint* _tmp1_;
		_tmp1_ = self->priv->orig_pixel_size;
		_tmp0_ = _tmp1_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint* _tmp2_;
		_tmp2_ = self->priv->orig_pixel_size;
		granite_widgets_avatar_show_default (self, *_tmp2_);
	} else {
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
		_tmp4_ = self->priv->orig_filename;
		if (_tmp4_ != NULL) {
			gint* _tmp5_;
			_tmp5_ = self->priv->orig_pixel_size;
			_tmp3_ = _tmp5_ != NULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			const gchar* _tmp6_;
			gint* _tmp7_;
			_tmp6_ = self->priv->orig_filename;
			_tmp7_ = self->priv->orig_pixel_size;
			granite_widgets_avatar_load_image (self, _tmp6_, *_tmp7_);
		}
	}
}

/**
     * Load the default avatar icon from theme into the widget without applying the css style
     *
     * @param pixel_size size of the icon to be loaded
     */
void
granite_widgets_avatar_show_default (GraniteWidgetsAvatar* self,
                                     gint pixel_size)
{
	GtkIconTheme* icon_theme = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	icon_theme = _tmp1_;
	{
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_;
		_tmp3_ = gtk_icon_theme_load_icon_for_scale (icon_theme, GRANITE_WIDGETS_AVATAR_DEFAULT_ICON, pixel_size, gtk_widget_get_scale_factor ((GtkWidget*) self), 0, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		granite_widgets_avatar_set_pixbuf (self, _tmp2_);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "Error setting default avatar icon: %s ", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (icon_theme);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	self->priv->draw_theme_background = FALSE;
	self->priv->is_default = TRUE;
	_g_object_unref0 (icon_theme);
}

static gboolean
granite_widgets_avatar_real_draw (GtkWidget* base,
                                  cairo_t* cr)
{
	GraniteWidgetsAvatar * self;
	GdkPixbuf* _tmp0_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp1_;
	gint width = 0;
	gint height = 0;
	gint scale_factor = 0;
	gboolean result;
	self = (GraniteWidgetsAvatar*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->_pixbuf;
	if (_tmp0_ == NULL) {
		result = GTK_WIDGET_CLASS (granite_widgets_avatar_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_event_box_get_type (), GtkEventBox), cr);
		return result;
	}
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	style_context = _tmp1_;
	width = gtk_widget_get_allocated_width ((GtkWidget*) self) - (GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN * 2);
	height = gtk_widget_get_allocated_height ((GtkWidget*) self) - (GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN * 2);
	scale_factor = gtk_widget_get_scale_factor ((GtkWidget*) self);
	if (self->priv->draw_theme_background) {
		gint border_radius = 0;
		GtkStyleContext* _tmp2_;
		GtkStyleContext* _tmp3_;
		GValue _tmp4_ = {0};
		GValue _tmp5_;
		gint _tmp6_;
		gint crop_radius = 0;
		GdkPixbuf* _tmp7_;
		GtkStyleContext* _tmp8_;
		GtkStyleContext* _tmp9_;
		_tmp2_ = style_context;
		_tmp3_ = style_context;
		gtk_style_context_get_property (_tmp2_, GTK_STYLE_PROPERTY_BORDER_RADIUS, gtk_style_context_get_state (_tmp3_), &_tmp4_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_value_get_int (&_tmp5_);
		G_IS_VALUE (&_tmp5_) ? (g_value_unset (&_tmp5_), NULL) : NULL;
		border_radius = _tmp6_;
		crop_radius = MIN (width / 2, (border_radius * width) / 100);
		granite_drawing_utilities_cairo_rounded_rectangle (cr, (gdouble) GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN, (gdouble) GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN, (gdouble) width, (gdouble) height, (gdouble) crop_radius);
		cairo_save (cr);
		cairo_scale (cr, 1.0 / scale_factor, 1.0 / scale_factor);
		_tmp7_ = self->priv->_pixbuf;
		gdk_cairo_set_source_pixbuf (cr, _tmp7_, (gdouble) (GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN * scale_factor), (gdouble) (GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN * scale_factor));
		cairo_fill_preserve (cr);
		cairo_restore (cr);
		_tmp8_ = style_context;
		gtk_render_background (_tmp8_, cr, (gdouble) GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN, (gdouble) GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN, (gdouble) width, (gdouble) height);
		_tmp9_ = style_context;
		gtk_render_frame (_tmp9_, cr, (gdouble) GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN, (gdouble) GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN, (gdouble) width, (gdouble) height);
	} else {
		GtkStyleContext* _tmp10_;
		GdkPixbuf* _tmp11_;
		cairo_save (cr);
		cairo_scale (cr, 1.0 / scale_factor, 1.0 / scale_factor);
		_tmp10_ = style_context;
		_tmp11_ = self->priv->_pixbuf;
		gtk_render_icon (_tmp10_, cr, _tmp11_, (gdouble) GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN, (gdouble) GRANITE_WIDGETS_AVATAR_EXTRA_MARGIN);
		cairo_restore (cr);
	}
	result = GDK_EVENT_STOP;
	return result;
}

static GObject *
granite_widgets_avatar_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsAvatar * self;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GdkScreen* _tmp3_;
	parent_class = G_OBJECT_CLASS (granite_widgets_avatar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_AVATAR, GraniteWidgetsAvatar);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_context = _tmp1_;
	_tmp2_ = style_context;
	gtk_style_context_add_class (_tmp2_, GRANITE_STYLE_CLASS_AVATAR);
	g_signal_connect_object ((GObject*) self, "notify::pixbuf", (GCallback) _granite_widgets_avatar_refresh_size_request_g_object_notify, self, 0);
	_tmp3_ = gdk_screen_get_default ();
	g_signal_connect_object (_tmp3_, "monitors-changed", (GCallback) _granite_widgets_avatar_dpi_change_gdk_screen_monitors_changed, self, 0);
	_g_object_unref0 (style_context);
	return obj;
}

static void
granite_widgets_avatar_class_init (GraniteWidgetsAvatarClass * klass,
                                   gpointer klass_data)
{
	granite_widgets_avatar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsAvatar_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) granite_widgets_avatar_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_avatar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_avatar_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_avatar_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_avatar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_AVATAR_PIXBUF_PROPERTY, granite_widgets_avatar_properties[GRANITE_WIDGETS_AVATAR_PIXBUF_PROPERTY] = g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
granite_widgets_avatar_instance_init (GraniteWidgetsAvatar * self,
                                      gpointer klass)
{
	self->priv = granite_widgets_avatar_get_instance_private (self);
	self->priv->draw_theme_background = TRUE;
	self->priv->is_default = FALSE;
	self->priv->orig_filename = NULL;
	self->priv->orig_pixel_size = NULL;
}

static void
granite_widgets_avatar_finalize (GObject * obj)
{
	GraniteWidgetsAvatar * self;
	guint _tmp0_;
	GQuark _tmp1_;
	GdkScreen* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_AVATAR, GraniteWidgetsAvatar);
	g_signal_parse_name ("notify::pixbuf", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _granite_widgets_avatar_refresh_size_request_g_object_notify, self);
	_tmp2_ = gdk_screen_get_default ();
	g_signal_parse_name ("monitors-changed", gdk_screen_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _granite_widgets_avatar_dpi_change_gdk_screen_monitors_changed, self);
	_g_free0 (self->priv->orig_filename);
	_g_free0 (self->priv->orig_pixel_size);
	_g_object_unref0 (self->priv->_pixbuf);
	G_OBJECT_CLASS (granite_widgets_avatar_parent_class)->finalize (obj);
}

/**
 * The Avatar widget allowes to theme & crop images with css BORDER_RADIUS property in the .avatar class.
 *
 * ''Example''<<BR>>
 * {{{
 * public class AvatarView : Gtk.Grid {
 *     construct {
 *         var username = GLib.Environment.get_user_name ();
 *         var iconfile = @"/var/lib/AccountsService/icons/$username";
 *
 *         var avatar_dialog = new Granite.Widgets.Avatar.from_file (iconfile, 48);
 *
 *         var avatar_default_dialog = new Granite.Widgets.Avatar.with_default_icon (48);
 *
 *         row_spacing = 6;
 *         halign = Gtk.Align.CENTER;
 *         valign = Gtk.Align.CENTER;
 *         attach (avatar_dialog, 0, 0, 1, 1);
 *         attach (avatar_default_dialog, 0, 1, 1, 1);
 *     }
 * }
 * }}}
 */
static GType
granite_widgets_avatar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsAvatarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_avatar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsAvatar), 0, (GInstanceInitFunc) granite_widgets_avatar_instance_init, NULL };
	GType granite_widgets_avatar_type_id;
	granite_widgets_avatar_type_id = g_type_register_static (gtk_event_box_get_type (), "GraniteWidgetsAvatar", &g_define_type_info, 0);
	GraniteWidgetsAvatar_private_offset = g_type_add_instance_private (granite_widgets_avatar_type_id, sizeof (GraniteWidgetsAvatarPrivate));
	return granite_widgets_avatar_type_id;
}

GType
granite_widgets_avatar_get_type (void)
{
	static volatile gsize granite_widgets_avatar_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_avatar_type_id__once)) {
		GType granite_widgets_avatar_type_id;
		granite_widgets_avatar_type_id = granite_widgets_avatar_get_type_once ();
		g_once_init_leave (&granite_widgets_avatar_type_id__once, granite_widgets_avatar_type_id);
	}
	return granite_widgets_avatar_type_id__once;
}

static void
_vala_granite_widgets_avatar_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GraniteWidgetsAvatar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_AVATAR, GraniteWidgetsAvatar);
	switch (property_id) {
		case GRANITE_WIDGETS_AVATAR_PIXBUF_PROPERTY:
		g_value_set_object (value, granite_widgets_avatar_get_pixbuf (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_avatar_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GraniteWidgetsAvatar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_AVATAR, GraniteWidgetsAvatar);
	switch (property_id) {
		case GRANITE_WIDGETS_AVATAR_PIXBUF_PROPERTY:
		granite_widgets_avatar_set_pixbuf (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

