/* retro-gamepad.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from retro-gamepad.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <retro-gtk.h>
#include <libmanette.h>
#include <glib.h>
#include "linux/input-event-codes.h"
#include <float.h>
#include <math.h>
#include <string.h>
#include "gnome-games.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_RETRO_GAMEPAD (games_retro_gamepad_get_type ())
#define GAMES_RETRO_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad))
#define GAMES_RETRO_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepadClass))
#define GAMES_IS_RETRO_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_GAMEPAD))
#define GAMES_IS_RETRO_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_GAMEPAD))
#define GAMES_RETRO_GAMEPAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepadClass))

typedef struct _GamesRetroGamepad GamesRetroGamepad;
typedef struct _GamesRetroGamepadClass GamesRetroGamepadClass;
typedef struct _GamesRetroGamepadPrivate GamesRetroGamepadPrivate;
enum  {
	GAMES_RETRO_GAMEPAD_0_PROPERTY,
	GAMES_RETRO_GAMEPAD_DEVICE_PROPERTY,
	GAMES_RETRO_GAMEPAD_NUM_PROPERTIES
};
static GParamSpec* games_retro_gamepad_properties[GAMES_RETRO_GAMEPAD_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GamesRetroGamepad {
	GObject parent_instance;
	GamesRetroGamepadPrivate * priv;
};

struct _GamesRetroGamepadClass {
	GObjectClass parent_class;
};

struct _GamesRetroGamepadPrivate {
	ManetteDevice* _device;
	gboolean* buttons;
	gint buttons_length1;
	gint _buttons_size_;
	gint16* axes;
	gint axes_length1;
	gint _axes_size_;
	guint16 rumble_effect[2];
};

static gint GamesRetroGamepad_private_offset;
static gpointer games_retro_gamepad_parent_class = NULL;
static RetroControllerInterface * games_retro_gamepad_retro_controller_parent_iface = NULL;

VALA_EXTERN GType games_retro_gamepad_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesRetroGamepad* games_retro_gamepad_new (ManetteDevice* device);
VALA_EXTERN GamesRetroGamepad* games_retro_gamepad_construct (GType object_type,
                                                  ManetteDevice* device);
static gint16 games_retro_gamepad_real_get_input_state (RetroController* base,
                                                 RetroInput* input);
static gboolean games_retro_gamepad_get_button_pressed (GamesRetroGamepad* self,
                                                 RetroJoypadId button);
static gint16 games_retro_gamepad_get_analog_value (GamesRetroGamepad* self,
                                             RetroAnalogIndex index,
                                             RetroAnalogId id);
static RetroControllerType games_retro_gamepad_real_get_controller_type (RetroController* base);
static guint64 games_retro_gamepad_real_get_capabilities (RetroController* base);
static gboolean games_retro_gamepad_real_get_supports_rumble (RetroController* base);
VALA_EXTERN ManetteDevice* games_retro_gamepad_get_device (GamesRetroGamepad* self);
static void games_retro_gamepad_real_set_rumble_state (RetroController* base,
                                                RetroRumbleEffect effect,
                                                guint16 strength);
static void games_retro_gamepad_on_button_press_event (GamesRetroGamepad* self,
                                                ManetteEvent* event);
static void games_retro_gamepad_on_button_release_event (GamesRetroGamepad* self,
                                                  ManetteEvent* event);
static void games_retro_gamepad_on_absolute_axis_event (GamesRetroGamepad* self,
                                                 ManetteEvent* event);
static void games_retro_gamepad_set_device (GamesRetroGamepad* self,
                                     ManetteDevice* value);
static GObject * games_retro_gamepad_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _games_retro_gamepad_on_button_press_event_manette_device_button_press_event (ManetteDevice* _sender,
                                                                                   ManetteEvent* event,
                                                                                   gpointer self);
static void _games_retro_gamepad_on_button_release_event_manette_device_button_release_event (ManetteDevice* _sender,
                                                                                       ManetteEvent* event,
                                                                                       gpointer self);
static void _games_retro_gamepad_on_absolute_axis_event_manette_device_absolute_axis_event (ManetteDevice* _sender,
                                                                                     ManetteEvent* event,
                                                                                     gpointer self);
static void games_retro_gamepad_finalize (GObject * obj);
static GType games_retro_gamepad_get_type_once (void);
static void _vala_games_retro_gamepad_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_games_retro_gamepad_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_retro_gamepad_get_instance_private (GamesRetroGamepad* self)
{
	return G_STRUCT_MEMBER_P (self, GamesRetroGamepad_private_offset);
}

GamesRetroGamepad*
games_retro_gamepad_construct (GType object_type,
                               ManetteDevice* device)
{
	GamesRetroGamepad * self = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	self = (GamesRetroGamepad*) g_object_new (object_type, "device", device, NULL);
	return self;
}

GamesRetroGamepad*
games_retro_gamepad_new (ManetteDevice* device)
{
	return games_retro_gamepad_construct (GAMES_TYPE_RETRO_GAMEPAD, device);
}

static gint16
games_retro_gamepad_real_get_input_state (RetroController* base,
                                          RetroInput* input)
{
	GamesRetroGamepad * self;
	gint16 result;
	self = (GamesRetroGamepad*) base;
	g_return_val_if_fail (input != NULL, 0);
	switch (retro_input_get_controller_type (input)) {
		case RETRO_CONTROLLER_TYPE_JOYPAD:
		{
			RetroJoypadId id = 0;
			RetroJoypadId _tmp0_ = 0;
			gboolean _tmp1_;
			gint16 _tmp2_ = 0;
			_tmp1_ = retro_input_get_joypad (input, &_tmp0_);
			id = _tmp0_;
			if (!_tmp1_) {
				result = (gint16) 0;
				return result;
			}
			if (games_retro_gamepad_get_button_pressed (self, id)) {
				_tmp2_ = G_MAXINT16;
			} else {
				_tmp2_ = (gint16) 0;
			}
			result = _tmp2_;
			return result;
		}
		case RETRO_CONTROLLER_TYPE_ANALOG:
		{
			RetroAnalogId id = 0;
			RetroAnalogIndex index = 0;
			RetroAnalogId _tmp3_ = 0;
			RetroAnalogIndex _tmp4_ = 0;
			gboolean _tmp5_;
			_tmp5_ = retro_input_get_analog (input, &_tmp3_, &_tmp4_);
			id = _tmp3_;
			index = _tmp4_;
			if (!_tmp5_) {
				result = (gint16) 0;
				return result;
			}
			result = games_retro_gamepad_get_analog_value (self, index, id);
			return result;
		}
		default:
		{
			result = (gint16) 0;
			return result;
		}
	}
}

static RetroControllerType
games_retro_gamepad_real_get_controller_type (RetroController* base)
{
	GamesRetroGamepad * self;
	RetroControllerType result;
	self = (GamesRetroGamepad*) base;
	result = RETRO_CONTROLLER_TYPE_JOYPAD;
	return result;
}

static guint64
games_retro_gamepad_real_get_capabilities (RetroController* base)
{
	GamesRetroGamepad * self;
	guint64 result;
	self = (GamesRetroGamepad*) base;
	result = (guint64) ((1 << RETRO_CONTROLLER_TYPE_JOYPAD) | (1 << RETRO_CONTROLLER_TYPE_ANALOG));
	return result;
}

static gboolean
games_retro_gamepad_real_get_supports_rumble (RetroController* base)
{
	GamesRetroGamepad * self;
	ManetteDevice* _tmp0_;
	gboolean result;
	self = (GamesRetroGamepad*) base;
	_tmp0_ = self->priv->_device;
	result = manette_device_has_rumble (_tmp0_);
	return result;
}

static void
games_retro_gamepad_real_set_rumble_state (RetroController* base,
                                           RetroRumbleEffect effect,
                                           guint16 strength)
{
	GamesRetroGamepad * self;
	ManetteDevice* _tmp0_;
	guint16 _tmp1_;
	guint16 _tmp2_;
	self = (GamesRetroGamepad*) base;
	self->priv->rumble_effect[effect] = strength;
	_tmp0_ = self->priv->_device;
	_tmp1_ = self->priv->rumble_effect[RETRO_RUMBLE_EFFECT_STRONG];
	_tmp2_ = self->priv->rumble_effect[RETRO_RUMBLE_EFFECT_WEAK];
	manette_device_rumble (_tmp0_, _tmp1_, _tmp2_, G_MAXUINT16);
}

static gboolean
games_retro_gamepad_get_button_pressed (GamesRetroGamepad* self,
                                        RetroJoypadId button)
{
	guint16 button_code = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	button_code = retro_joypad_id_to_button_code (button);
	if (button_code != EV_MAX) {
		gboolean* _tmp1_;
		gint _tmp1__length1;
		gboolean _tmp2_;
		_tmp1_ = self->priv->buttons;
		_tmp1__length1 = self->priv->buttons_length1;
		_tmp2_ = _tmp1_[button_code];
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gint16
games_retro_gamepad_get_analog_value (GamesRetroGamepad* self,
                                      RetroAnalogIndex index,
                                      RetroAnalogId id)
{
	gint16 result;
	g_return_val_if_fail (self != NULL, 0);
	switch (index) {
		case RETRO_ANALOG_INDEX_LEFT:
		{
			switch (id) {
				case RETRO_ANALOG_ID_X:
				{
					gint16* _tmp0_;
					gint _tmp0__length1;
					gint16 _tmp1_;
					_tmp0_ = self->priv->axes;
					_tmp0__length1 = self->priv->axes_length1;
					_tmp1_ = _tmp0_[ABS_X];
					result = _tmp1_;
					return result;
				}
				case RETRO_ANALOG_ID_Y:
				{
					gint16* _tmp2_;
					gint _tmp2__length1;
					gint16 _tmp3_;
					_tmp2_ = self->priv->axes;
					_tmp2__length1 = self->priv->axes_length1;
					_tmp3_ = _tmp2_[ABS_Y];
					result = _tmp3_;
					return result;
				}
				default:
				{
					result = (gint16) 0;
					return result;
				}
			}
		}
		case RETRO_ANALOG_INDEX_RIGHT:
		{
			switch (id) {
				case RETRO_ANALOG_ID_X:
				{
					gint16* _tmp4_;
					gint _tmp4__length1;
					gint16 _tmp5_;
					_tmp4_ = self->priv->axes;
					_tmp4__length1 = self->priv->axes_length1;
					_tmp5_ = _tmp4_[ABS_RX];
					result = _tmp5_;
					return result;
				}
				case RETRO_ANALOG_ID_Y:
				{
					gint16* _tmp6_;
					gint _tmp6__length1;
					gint16 _tmp7_;
					_tmp6_ = self->priv->axes;
					_tmp6__length1 = self->priv->axes_length1;
					_tmp7_ = _tmp6_[ABS_RY];
					result = _tmp7_;
					return result;
				}
				default:
				{
					result = (gint16) 0;
					return result;
				}
			}
		}
		default:
		{
			result = (gint16) 0;
			return result;
		}
	}
}

static void
games_retro_gamepad_on_button_press_event (GamesRetroGamepad* self,
                                           ManetteEvent* event)
{
	guint16 button = 0U;
	guint16 _tmp0_ = 0U;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp1_ = manette_event_get_button (event, &_tmp0_);
	button = _tmp0_;
	if (_tmp1_) {
		gboolean* _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = self->priv->buttons;
		_tmp2__length1 = self->priv->buttons_length1;
		_tmp2_[button] = TRUE;
		retro_controller_emit_state_changed ((RetroController*) self);
	}
}

static void
games_retro_gamepad_on_button_release_event (GamesRetroGamepad* self,
                                             ManetteEvent* event)
{
	guint16 button = 0U;
	guint16 _tmp0_ = 0U;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp1_ = manette_event_get_button (event, &_tmp0_);
	button = _tmp0_;
	if (_tmp1_) {
		gboolean* _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = self->priv->buttons;
		_tmp2__length1 = self->priv->buttons_length1;
		_tmp2_[button] = FALSE;
		retro_controller_emit_state_changed ((RetroController*) self);
	}
}

static void
games_retro_gamepad_on_absolute_axis_event (GamesRetroGamepad* self,
                                            ManetteEvent* event)
{
	guint16 axis = 0U;
	gdouble value = 0.0;
	guint16 _tmp0_ = 0U;
	gdouble _tmp1_ = 0.0;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp2_ = manette_event_get_absolute (event, &_tmp0_, &_tmp1_);
	axis = _tmp0_;
	value = _tmp1_;
	if (_tmp2_) {
		gint16* _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = self->priv->axes;
		_tmp3__length1 = self->priv->axes_length1;
		_tmp3_[axis] = (gint16) (value * G_MAXINT16);
		retro_controller_emit_state_changed ((RetroController*) self);
	}
}

ManetteDevice*
games_retro_gamepad_get_device (GamesRetroGamepad* self)
{
	ManetteDevice* result;
	ManetteDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_retro_gamepad_set_device (GamesRetroGamepad* self,
                                ManetteDevice* value)
{
	ManetteDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_retro_gamepad_get_device (self);
	if (old_value != value) {
		ManetteDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_device);
		self->priv->_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_retro_gamepad_properties[GAMES_RETRO_GAMEPAD_DEVICE_PROPERTY]);
	}
}

static void
_games_retro_gamepad_on_button_press_event_manette_device_button_press_event (ManetteDevice* _sender,
                                                                              ManetteEvent* event,
                                                                              gpointer self)
{
	games_retro_gamepad_on_button_press_event ((GamesRetroGamepad*) self, event);
}

static void
_games_retro_gamepad_on_button_release_event_manette_device_button_release_event (ManetteDevice* _sender,
                                                                                  ManetteEvent* event,
                                                                                  gpointer self)
{
	games_retro_gamepad_on_button_release_event ((GamesRetroGamepad*) self, event);
}

static void
_games_retro_gamepad_on_absolute_axis_event_manette_device_absolute_axis_event (ManetteDevice* _sender,
                                                                                ManetteEvent* event,
                                                                                gpointer self)
{
	games_retro_gamepad_on_absolute_axis_event ((GamesRetroGamepad*) self, event);
}

static GObject *
games_retro_gamepad_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GamesRetroGamepad * self;
	gboolean* _tmp0_;
	gint16* _tmp1_;
	ManetteDevice* _tmp2_;
	ManetteDevice* _tmp3_;
	ManetteDevice* _tmp4_;
	parent_class = G_OBJECT_CLASS (games_retro_gamepad_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad);
	_tmp0_ = g_new0 (gboolean, KEY_MAX + 1);
	self->priv->buttons = (g_free (self->priv->buttons), NULL);
	self->priv->buttons = _tmp0_;
	self->priv->buttons_length1 = KEY_MAX + 1;
	self->priv->_buttons_size_ = self->priv->buttons_length1;
	_tmp1_ = g_new0 (gint16, ABS_MAX + 1);
	self->priv->axes = (g_free (self->priv->axes), NULL);
	self->priv->axes = _tmp1_;
	self->priv->axes_length1 = ABS_MAX + 1;
	self->priv->_axes_size_ = self->priv->axes_length1;
	_tmp2_ = self->priv->_device;
	g_signal_connect_object (_tmp2_, "button-press-event", (GCallback) _games_retro_gamepad_on_button_press_event_manette_device_button_press_event, self, 0);
	_tmp3_ = self->priv->_device;
	g_signal_connect_object (_tmp3_, "button-release-event", (GCallback) _games_retro_gamepad_on_button_release_event_manette_device_button_release_event, self, 0);
	_tmp4_ = self->priv->_device;
	g_signal_connect_object (_tmp4_, "absolute-axis-event", (GCallback) _games_retro_gamepad_on_absolute_axis_event_manette_device_absolute_axis_event, self, 0);
	return obj;
}

static void
games_retro_gamepad_class_init (GamesRetroGamepadClass * klass,
                                gpointer klass_data)
{
	games_retro_gamepad_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesRetroGamepad_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_retro_gamepad_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_retro_gamepad_set_property;
	G_OBJECT_CLASS (klass)->constructor = games_retro_gamepad_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_retro_gamepad_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_GAMEPAD_DEVICE_PROPERTY, games_retro_gamepad_properties[GAMES_RETRO_GAMEPAD_DEVICE_PROPERTY] = g_param_spec_object ("device", "device", "device", manette_device_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
games_retro_gamepad_retro_controller_interface_init (RetroControllerInterface * iface,
                                                     gpointer iface_data)
{
	games_retro_gamepad_retro_controller_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_input_state = (gint16 (*) (RetroController*, RetroInput*)) games_retro_gamepad_real_get_input_state;
	iface->get_controller_type = (RetroControllerType (*) (RetroController*)) games_retro_gamepad_real_get_controller_type;
	iface->get_capabilities = (guint64 (*) (RetroController*)) games_retro_gamepad_real_get_capabilities;
	iface->get_supports_rumble = (gboolean (*) (RetroController*)) games_retro_gamepad_real_get_supports_rumble;
	iface->set_rumble_state = (void (*) (RetroController*, RetroRumbleEffect, guint16)) games_retro_gamepad_real_set_rumble_state;
}

static void
games_retro_gamepad_instance_init (GamesRetroGamepad * self,
                                   gpointer klass)
{
	self->priv = games_retro_gamepad_get_instance_private (self);
}

static void
games_retro_gamepad_finalize (GObject * obj)
{
	GamesRetroGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad);
	_g_object_unref0 (self->priv->_device);
	self->priv->buttons = (g_free (self->priv->buttons), NULL);
	self->priv->axes = (g_free (self->priv->axes), NULL);
	G_OBJECT_CLASS (games_retro_gamepad_parent_class)->finalize (obj);
}

static GType
games_retro_gamepad_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesRetroGamepadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_retro_gamepad_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesRetroGamepad), 0, (GInstanceInitFunc) games_retro_gamepad_instance_init, NULL };
	static const GInterfaceInfo retro_controller_info = { (GInterfaceInitFunc) games_retro_gamepad_retro_controller_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType games_retro_gamepad_type_id;
	games_retro_gamepad_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesRetroGamepad", &g_define_type_info, 0);
	g_type_add_interface_static (games_retro_gamepad_type_id, retro_controller_get_type (), &retro_controller_info);
	GamesRetroGamepad_private_offset = g_type_add_instance_private (games_retro_gamepad_type_id, sizeof (GamesRetroGamepadPrivate));
	return games_retro_gamepad_type_id;
}

GType
games_retro_gamepad_get_type (void)
{
	static volatile gsize games_retro_gamepad_type_id__once = 0;
	if (g_once_init_enter (&games_retro_gamepad_type_id__once)) {
		GType games_retro_gamepad_type_id;
		games_retro_gamepad_type_id = games_retro_gamepad_get_type_once ();
		g_once_init_leave (&games_retro_gamepad_type_id__once, games_retro_gamepad_type_id);
	}
	return games_retro_gamepad_type_id__once;
}

static void
_vala_games_retro_gamepad_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GamesRetroGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad);
	switch (property_id) {
		case GAMES_RETRO_GAMEPAD_DEVICE_PROPERTY:
		g_value_set_object (value, games_retro_gamepad_get_device (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_retro_gamepad_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GamesRetroGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad);
	switch (property_id) {
		case GAMES_RETRO_GAMEPAD_DEVICE_PROPERTY:
		games_retro_gamepad_set_device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

