/* WaterfallSettings.c generated by valac 0.56.18, the Vala compiler
 * generated from WaterfallSettings.vala, do not modify */

/* WaterfallSettings.vala
 *
 * Copyright (C) 2022-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include "vala-common.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include "font-manager.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FONT_MANAGER_WATERFALL_SETTINGS_0_PROPERTY,
	FONT_MANAGER_WATERFALL_SETTINGS_SETTINGS_PROPERTY,
	FONT_MANAGER_WATERFALL_SETTINGS_PREDEFINED_SIZE_PROPERTY,
	FONT_MANAGER_WATERFALL_SETTINGS_MINIMUM_PROPERTY,
	FONT_MANAGER_WATERFALL_SETTINGS_MAXIMUM_PROPERTY,
	FONT_MANAGER_WATERFALL_SETTINGS_RATIO_PROPERTY,
	FONT_MANAGER_WATERFALL_SETTINGS_SHOW_LINE_SIZE_PROPERTY,
	FONT_MANAGER_WATERFALL_SETTINGS_LINE_SPACING_PROPERTY,
	FONT_MANAGER_WATERFALL_SETTINGS_CONTEXT_MENU_PROPERTY,
	FONT_MANAGER_WATERFALL_SETTINGS_PREFERENCE_ROW_PROPERTY,
	FONT_MANAGER_WATERFALL_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

struct _FontManagerWaterfallSettingsPrivate {
	GSettings* _settings;
	gint _predefined_size;
	gdouble _minimum;
	gdouble _maximum;
	gdouble _ratio;
	gboolean _show_line_size;
	gint _line_spacing;
	GtkSpinButton* min;
	GtkSpinButton* max;
	GtkSpinButton* rat;
	GtkDropDown* selection;
	GtkPopoverMenu* menu;
	FontManagerPreferenceRow* row;
};

static gint FontManagerWaterfallSettings_private_offset;
static gpointer font_manager_waterfall_settings_parent_class = NULL;

static void font_manager_waterfall_settings_bind_settings (FontManagerWaterfallSettings* self);
static void font_manager_waterfall_settings_create_preference_row (FontManagerWaterfallSettings* self);
static void _g_free0_ (gpointer var);
static void _vala_gchar_free_function_content_of (gpointer data);
static void __lambda6_ (FontManagerWaterfallSettings* self);
static void ___lambda6__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda7_ (FontManagerWaterfallSettings* self);
static void ___lambda7__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static GMenuModel* font_manager_waterfall_settings_get_context_menu_model (FontManagerWaterfallSettings* self);
static void font_manager_waterfall_settings_finalize (GObject * obj);
static GType font_manager_waterfall_settings_get_type_once (void);
static void _vala_font_manager_waterfall_settings_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_font_manager_waterfall_settings_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);

gchar*
font_manager_predefined_waterfall_size_to_string (FontManagerPredefinedWaterfallSize self)
{
	gchar* result;
	switch (self) {
		case FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_LINEAR_48:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Up to 48 points (Linear Scaling)"));
			result = _tmp0_;
			return result;
		}
		case FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_72_11:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Up to 72 points (1.1 Common Ratio)"));
			result = _tmp1_;
			return result;
		}
		case FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_LINEAR_96:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Up to 96 points (Linear Scaling)"));
			result = _tmp2_;
			return result;
		}
		case FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_96_11:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Up to 96 points (1.1 Common Ratio)"));
			result = _tmp3_;
			return result;
		}
		case FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_120_12:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Up to 120 points (1.2 Common Ratio)"));
			result = _tmp4_;
			return result;
		}
		case FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_144_13:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Up to 144 points (1.3 Common Ratio)"));
			result = _tmp5_;
			return result;
		}
		case FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_192_14:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("Up to 192 points (1.4 Common Ratio)"));
			result = _tmp6_;
			return result;
		}
		default:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup (_ ("Custom Size Settings"));
			result = _tmp7_;
			return result;
		}
	}
}

gdouble*
font_manager_predefined_waterfall_size_to_size_array (FontManagerPredefinedWaterfallSize self,
                                                      gint* result_length1)
{
	gdouble* result;
	switch (self) {
		case FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_LINEAR_48:
		{
			gdouble* _tmp0_;
			gdouble* _tmp1_;
			gint _tmp1__length1;
			_tmp0_ = g_new0 (gdouble, 3);
			_tmp0_[0] = 8.0;
			_tmp0_[1] = 48.0;
			_tmp0_[2] = 1.0;
			_tmp1_ = _tmp0_;
			_tmp1__length1 = 3;
			if (result_length1) {
				*result_length1 = _tmp1__length1;
			}
			result = _tmp1_;
			return result;
		}
		case FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_72_11:
		{
			gdouble* _tmp2_;
			gdouble* _tmp3_;
			gint _tmp3__length1;
			_tmp2_ = g_new0 (gdouble, 3);
			_tmp2_[0] = 8.0;
			_tmp2_[1] = 72.0;
			_tmp2_[2] = 1.1;
			_tmp3_ = _tmp2_;
			_tmp3__length1 = 3;
			if (result_length1) {
				*result_length1 = _tmp3__length1;
			}
			result = _tmp3_;
			return result;
		}
		case FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_LINEAR_96:
		{
			gdouble* _tmp4_;
			gdouble* _tmp5_;
			gint _tmp5__length1;
			_tmp4_ = g_new0 (gdouble, 3);
			_tmp4_[0] = 8.0;
			_tmp4_[1] = 96.0;
			_tmp4_[2] = 1.0;
			_tmp5_ = _tmp4_;
			_tmp5__length1 = 3;
			if (result_length1) {
				*result_length1 = _tmp5__length1;
			}
			result = _tmp5_;
			return result;
		}
		case FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_96_11:
		{
			gdouble* _tmp6_;
			gdouble* _tmp7_;
			gint _tmp7__length1;
			_tmp6_ = g_new0 (gdouble, 3);
			_tmp6_[0] = 8.0;
			_tmp6_[1] = 96.0;
			_tmp6_[2] = 1.1;
			_tmp7_ = _tmp6_;
			_tmp7__length1 = 3;
			if (result_length1) {
				*result_length1 = _tmp7__length1;
			}
			result = _tmp7_;
			return result;
		}
		case FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_120_12:
		{
			gdouble* _tmp8_;
			gdouble* _tmp9_;
			gint _tmp9__length1;
			_tmp8_ = g_new0 (gdouble, 3);
			_tmp8_[0] = 8.0;
			_tmp8_[1] = 120.0;
			_tmp8_[2] = 1.2;
			_tmp9_ = _tmp8_;
			_tmp9__length1 = 3;
			if (result_length1) {
				*result_length1 = _tmp9__length1;
			}
			result = _tmp9_;
			return result;
		}
		case FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_144_13:
		{
			gdouble* _tmp10_;
			gdouble* _tmp11_;
			gint _tmp11__length1;
			_tmp10_ = g_new0 (gdouble, 3);
			_tmp10_[0] = 8.0;
			_tmp10_[1] = 144.0;
			_tmp10_[2] = 1.3;
			_tmp11_ = _tmp10_;
			_tmp11__length1 = 3;
			if (result_length1) {
				*result_length1 = _tmp11__length1;
			}
			result = _tmp11_;
			return result;
		}
		case FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_192_14:
		{
			gdouble* _tmp12_;
			gdouble* _tmp13_;
			gint _tmp13__length1;
			_tmp12_ = g_new0 (gdouble, 3);
			_tmp12_[0] = 8.0;
			_tmp12_[1] = 192.0;
			_tmp12_[2] = 1.4;
			_tmp13_ = _tmp12_;
			_tmp13__length1 = 3;
			if (result_length1) {
				*result_length1 = _tmp13__length1;
			}
			result = _tmp13_;
			return result;
		}
		default:
		{
			gdouble* _tmp14_;
			gdouble* _tmp15_;
			gint _tmp15__length1;
			_tmp14_ = g_new0 (gdouble, 3);
			_tmp14_[0] = 0.0;
			_tmp14_[1] = 0.0;
			_tmp14_[2] = 0.0;
			_tmp15_ = _tmp14_;
			_tmp15__length1 = 3;
			if (result_length1) {
				*result_length1 = _tmp15__length1;
			}
			result = _tmp15_;
			return result;
		}
	}
}

GVariant*
font_manager_predefined_waterfall_size_to_setting (GValue* val,
                                                   const GVariantType* type)
{
	GVariant* result;
	g_return_val_if_fail (val != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	switch (g_value_get_int (val)) {
		case 0:
		{
			GVariant* _tmp0_;
			_tmp0_ = g_variant_new_string ("48 Points Linear");
			g_variant_ref_sink (_tmp0_);
			result = _tmp0_;
			return result;
		}
		case 1:
		{
			GVariant* _tmp1_;
			_tmp1_ = g_variant_new_string ("72 Points 1.1 Ratio");
			g_variant_ref_sink (_tmp1_);
			result = _tmp1_;
			return result;
		}
		case 2:
		{
			GVariant* _tmp2_;
			_tmp2_ = g_variant_new_string ("96 Points Linear");
			g_variant_ref_sink (_tmp2_);
			result = _tmp2_;
			return result;
		}
		case 3:
		{
			GVariant* _tmp3_;
			_tmp3_ = g_variant_new_string ("96 Points 1.1 Ratio");
			g_variant_ref_sink (_tmp3_);
			result = _tmp3_;
			return result;
		}
		case 4:
		{
			GVariant* _tmp4_;
			_tmp4_ = g_variant_new_string ("120 Points 1.2 Ratio");
			g_variant_ref_sink (_tmp4_);
			result = _tmp4_;
			return result;
		}
		case 5:
		{
			GVariant* _tmp5_;
			_tmp5_ = g_variant_new_string ("144 Points 1.3 Ratio");
			g_variant_ref_sink (_tmp5_);
			result = _tmp5_;
			return result;
		}
		case 6:
		{
			GVariant* _tmp6_;
			_tmp6_ = g_variant_new_string ("192 Points 1.4 Ratio");
			g_variant_ref_sink (_tmp6_);
			result = _tmp6_;
			return result;
		}
		default:
		{
			GVariant* _tmp7_;
			_tmp7_ = g_variant_new_string ("Custom");
			g_variant_ref_sink (_tmp7_);
			result = _tmp7_;
			return result;
		}
	}
}

gboolean
font_manager_predefined_waterfall_size_from_setting (GValue* val,
                                                     GVariant* variant)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	gboolean result;
	g_return_val_if_fail (val != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_string (variant, NULL);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("48 Points Linear")))) {
		switch (0) {
			default:
			{
				g_value_set_int (val, 0);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("72 Points 1.1 Ratio")))) {
		switch (0) {
			default:
			{
				g_value_set_int (val, 1);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("96 Points Linear")))) {
		switch (0) {
			default:
			{
				g_value_set_int (val, 2);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("96 Points 1.1 Ratio")))) {
		switch (0) {
			default:
			{
				g_value_set_int (val, 3);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("120 Points 1.2 Ratio")))) {
		switch (0) {
			default:
			{
				g_value_set_int (val, 4);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("144 Points 1.3 Ratio")))) {
		switch (0) {
			default:
			{
				g_value_set_int (val, 5);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("192 Points 1.4 Ratio")))) {
		switch (0) {
			default:
			{
				g_value_set_int (val, 6);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_value_set_int (val, 7);
				break;
			}
		}
	}
	result = TRUE;
	return result;
}

 G_GNUC_NO_INLINE static GType
font_manager_predefined_waterfall_size_get_type_once (void)
{
	static const GEnumValue values[] = {{FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_LINEAR_48, "FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_LINEAR_48", "linear-48"}, {FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_72_11, "FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_72_11", "72-11"}, {FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_LINEAR_96, "FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_LINEAR_96", "linear-96"}, {FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_96_11, "FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_96_11", "96-11"}, {FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_120_12, "FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_120_12", "120-12"}, {FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_144_13, "FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_144_13", "144-13"}, {FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_192_14, "FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_192_14", "192-14"}, {FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_CUSTOM, "FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_CUSTOM", "custom"}, {0, NULL, NULL}};
	GType font_manager_predefined_waterfall_size_type_id;
	font_manager_predefined_waterfall_size_type_id = g_enum_register_static ("FontManagerPredefinedWaterfallSize", values);
	return font_manager_predefined_waterfall_size_type_id;
}

GType
font_manager_predefined_waterfall_size_get_type (void)
{
	static volatile gsize font_manager_predefined_waterfall_size_type_id__once = 0;
	if (g_once_init_enter (&font_manager_predefined_waterfall_size_type_id__once)) {
		GType font_manager_predefined_waterfall_size_type_id;
		font_manager_predefined_waterfall_size_type_id = font_manager_predefined_waterfall_size_get_type_once ();
		g_once_init_leave (&font_manager_predefined_waterfall_size_type_id__once, font_manager_predefined_waterfall_size_type_id);
	}
	return font_manager_predefined_waterfall_size_type_id__once;
}

static inline gpointer
font_manager_waterfall_settings_get_instance_private (FontManagerWaterfallSettings* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerWaterfallSettings_private_offset);
}

FontManagerWaterfallSettings*
font_manager_waterfall_settings_construct (GType object_type,
                                           GSettings* settings)
{
	FontManagerWaterfallSettings * self = NULL;
	self = (FontManagerWaterfallSettings*) g_object_new (object_type, NULL);
	font_manager_waterfall_settings_set_settings (self, settings);
	font_manager_waterfall_settings_bind_settings (self);
	return self;
}

FontManagerWaterfallSettings*
font_manager_waterfall_settings_new (GSettings* settings)
{
	return font_manager_waterfall_settings_construct (FONT_MANAGER_TYPE_WATERFALL_SETTINGS, settings);
}

static void
font_manager_waterfall_settings_bind_settings (FontManagerWaterfallSettings* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp3_;
	GSettingsBindFlags flags = 0U;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	if (_tmp0_ == NULL) {
		GSettings* _tmp1_;
		GSettings* _tmp2_;
		_tmp1_ = font_manager_get_gsettings (FONT_MANAGER_BUS_ID);
		_tmp2_ = _tmp1_;
		font_manager_waterfall_settings_set_settings (self, _tmp2_);
		_g_object_unref0 (_tmp2_);
	}
	_tmp3_ = self->priv->_settings;
	g_return_if_fail (_tmp3_ != NULL);
	flags = G_SETTINGS_BIND_DEFAULT;
	_tmp4_ = self->priv->_settings;
	g_settings_bind (_tmp4_, "waterfall-show-line-size", (GObject*) self, "show-line-size", flags);
	_tmp5_ = self->priv->_settings;
	g_settings_bind (_tmp5_, "min-waterfall-size", (GObject*) self, "minimum", flags);
	_tmp6_ = self->priv->_settings;
	g_settings_bind (_tmp6_, "max-waterfall-size", (GObject*) self, "maximum", flags);
	_tmp7_ = self->priv->_settings;
	g_settings_bind (_tmp7_, "waterfall-size-ratio", (GObject*) self, "ratio", flags);
	_tmp8_ = self->priv->_settings;
	g_settings_bind (_tmp8_, "waterfall-line-spacing", (GObject*) self, "line-spacing", flags);
	_tmp9_ = self->priv->_settings;
	g_settings_bind_with_mapping (_tmp9_, "predefined-waterfall-size", (GObject*) self, "predefined-size", flags, (GSettingsBindGetMapping) font_manager_predefined_waterfall_size_from_setting, (GSettingsBindSetMapping) font_manager_predefined_waterfall_size_to_setting, NULL, NULL);
	return;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_gchar_free_function_content_of (gpointer data)
{
	gchar* self;
	self = *((gchar**) data);
	_g_free0_ (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda6_ (FontManagerWaterfallSettings* self)
{
	GtkDropDown* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	_tmp0_ = self->priv->selection;
	_tmp1_ = gtk_drop_down_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	font_manager_waterfall_settings_set_predefined_size (self, (gint) _tmp2_);
}

static void
___lambda6__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda6_ ((FontManagerWaterfallSettings*) self);
}

static void
__lambda7_ (FontManagerWaterfallSettings* self)
{
	font_manager_waterfall_settings_on_selection_changed (self);
}

static void
___lambda7__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda7_ ((FontManagerWaterfallSettings*) self);
}

static void
font_manager_waterfall_settings_create_preference_row (FontManagerWaterfallSettings* self)
{
	GArray* selections = NULL;
	GArray* _tmp0_;
	GtkStringList* selection_list = NULL;
	GArray* _tmp5_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	GtkStringList* _tmp7_;
	GListModel* _tmp8_;
	GtkDropDown* _tmp9_;
	GtkDropDown* _tmp10_;
	FontManagerPreferenceRow* _tmp11_;
	GtkSpinButton* _tmp12_ = NULL;
	gchar* _tmp13_;
	GtkSpinButton* _tmp14_ = NULL;
	GtkSpinButton* _tmp15_ = NULL;
	FontManagerPreferenceRow* child = NULL;
	GtkSpinButton* _tmp16_;
	FontManagerPreferenceRow* _tmp17_;
	FontManagerPreferenceRow* _tmp18_;
	FontManagerPreferenceRow* _tmp19_;
	GtkSpinButton* _tmp20_;
	FontManagerPreferenceRow* _tmp21_;
	FontManagerPreferenceRow* _tmp22_;
	FontManagerPreferenceRow* _tmp23_;
	GtkSpinButton* _tmp24_;
	FontManagerPreferenceRow* _tmp25_;
	FontManagerPreferenceRow* _tmp26_;
	FontManagerPreferenceRow* _tmp27_;
	FontManagerPreferenceRow* _tmp28_;
	gint _tmp29_;
	GtkDropDown* _tmp30_;
	GBindingFlags flags = 0U;
	GtkSpinButton* _tmp31_;
	GtkSpinButton* _tmp32_;
	GtkSpinButton* _tmp33_;
	GtkDropDown* _tmp34_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_gchar_free_function_content_of);
	selections = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				gchar* _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i <= ((gint) FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_CUSTOM))) {
					break;
				}
				_tmp3_ = selections;
				_tmp4_ = font_manager_predefined_waterfall_size_to_string ((FontManagerPredefinedWaterfallSize) i);
				g_array_append_val (_tmp3_, _tmp4_);
			}
		}
	}
	_tmp5_ = selections;
	_tmp6_ = _tmp5_->data;
	_tmp6__length1 = _tmp5_->len;
	_tmp7_ = gtk_string_list_new (_tmp6_);
	selection_list = _tmp7_;
	_tmp8_ = _g_object_ref0 ((GListModel*) selection_list);
	_tmp9_ = (GtkDropDown*) gtk_drop_down_new (_tmp8_, NULL);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->selection);
	self->priv->selection = _tmp9_;
	_tmp10_ = self->priv->selection;
	_tmp11_ = (FontManagerPreferenceRow*) font_manager_preference_row_new (_ ("Waterfall Preview Size Settings"), NULL, NULL, (GtkWidget*) _tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->row);
	self->priv->row = _tmp11_;
	_tmp12_ = (GtkSpinButton*) gtk_spin_button_new_with_range (6.0, 48.0, 1.0);
	gtk_spin_button_set_value (_tmp12_, 8.0);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->min);
	self->priv->min = _tmp12_;
	_tmp13_ = g_strdup (_ ("Higher values may adversely affect performance"));
	_tmp14_ = (GtkSpinButton*) gtk_spin_button_new_with_range (24.0, 192.0, 1.0);
	gtk_spin_button_set_value (_tmp14_, 48.0);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp14_, _tmp13_);
	_g_free0 (_tmp13_);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->max);
	self->priv->max = _tmp14_;
	_tmp15_ = (GtkSpinButton*) gtk_spin_button_new_with_range (1.0, 24.0, 0.10);
	gtk_spin_button_set_value (_tmp15_, 48.0);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->rat);
	self->priv->rat = _tmp15_;
	_tmp16_ = self->priv->min;
	_tmp17_ = (FontManagerPreferenceRow*) font_manager_preference_row_new (_ ("Minimum Waterfall Preview Point Size"), NULL, NULL, (GtkWidget*) _tmp16_);
	g_object_ref_sink (_tmp17_);
	child = _tmp17_;
	_tmp18_ = self->priv->row;
	_tmp19_ = child;
	font_manager_preference_row_append_child (_tmp18_, _tmp19_);
	_tmp20_ = self->priv->rat;
	_tmp21_ = (FontManagerPreferenceRow*) font_manager_preference_row_new (_ ("Waterfall Preview Point Size Common Ratio"), NULL, NULL, (GtkWidget*) _tmp20_);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (child);
	child = _tmp21_;
	_tmp22_ = self->priv->row;
	_tmp23_ = child;
	font_manager_preference_row_append_child (_tmp22_, _tmp23_);
	_tmp24_ = self->priv->max;
	_tmp25_ = (FontManagerPreferenceRow*) font_manager_preference_row_new (_ ("Maximum Waterfall Preview Point Size"), NULL, NULL, (GtkWidget*) _tmp24_);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (child);
	child = _tmp25_;
	_tmp26_ = self->priv->row;
	_tmp27_ = child;
	font_manager_preference_row_append_child (_tmp26_, _tmp27_);
	_tmp28_ = self->priv->row;
	_tmp29_ = self->priv->_predefined_size;
	font_manager_preference_row_set_reveal_child (_tmp28_, _tmp29_ == ((gint) FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_CUSTOM));
	_tmp30_ = self->priv->selection;
	g_signal_connect_object ((GObject*) _tmp30_, "notify::selected", (GCallback) ___lambda6__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::predefined-size", (GCallback) ___lambda7__g_object_notify, self, G_CONNECT_AFTER);
	flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp31_ = self->priv->min;
	g_object_bind_property_with_closures ((GObject*) self, "minimum", (GObject*) _tmp31_, "value", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp32_ = self->priv->max;
	g_object_bind_property_with_closures ((GObject*) self, "maximum", (GObject*) _tmp32_, "value", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp33_ = self->priv->rat;
	g_object_bind_property_with_closures ((GObject*) self, "ratio", (GObject*) _tmp33_, "value", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp34_ = self->priv->selection;
	g_object_bind_property_with_closures ((GObject*) self, "predefined-size", (GObject*) _tmp34_, "selected", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (child);
	_g_object_unref0 (selection_list);
	_g_array_unref0 (selections);
	return;
}

void
font_manager_waterfall_settings_on_selection_changed (FontManagerWaterfallSettings* self)
{
	FontManagerPreferenceRow* _tmp0_;
	gint _tmp3_;
	gdouble* selected = NULL;
	gint _tmp4_;
	gint _tmp5_ = 0;
	gdouble* _tmp6_;
	gint selected_length1;
	gint _selected_size_;
	gdouble* _tmp7_;
	gint _tmp7__length1;
	gdouble _tmp8_;
	gdouble* _tmp9_;
	gint _tmp9__length1;
	gdouble _tmp10_;
	gdouble* _tmp11_;
	gint _tmp11__length1;
	gdouble _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->row;
	if (_tmp0_ != NULL) {
		FontManagerPreferenceRow* _tmp1_;
		gint _tmp2_;
		_tmp1_ = self->priv->row;
		_tmp2_ = self->priv->_predefined_size;
		font_manager_preference_row_set_reveal_child (_tmp1_, _tmp2_ == ((gint) FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_CUSTOM));
	}
	_tmp3_ = self->priv->_predefined_size;
	if (_tmp3_ == ((gint) FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_CUSTOM)) {
		return;
	}
	_tmp4_ = self->priv->_predefined_size;
	_tmp6_ = font_manager_predefined_waterfall_size_to_size_array ((FontManagerPredefinedWaterfallSize) _tmp4_, &_tmp5_);
	selected = _tmp6_;
	selected_length1 = _tmp5_;
	_selected_size_ = selected_length1;
	_tmp7_ = selected;
	_tmp7__length1 = selected_length1;
	_tmp8_ = _tmp7_[0];
	font_manager_waterfall_settings_set_minimum (self, _tmp8_);
	_tmp9_ = selected;
	_tmp9__length1 = selected_length1;
	_tmp10_ = _tmp9_[1];
	font_manager_waterfall_settings_set_maximum (self, _tmp10_);
	_tmp11_ = selected;
	_tmp11__length1 = selected_length1;
	_tmp12_ = _tmp11_[2];
	font_manager_waterfall_settings_set_ratio (self, _tmp12_);
	selected = (g_free (selected), NULL);
	return;
}

static GMenuModel*
font_manager_waterfall_settings_get_context_menu_model (FontManagerWaterfallSettings* self)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	GMenu* line_size = NULL;
	GMenu* _tmp1_;
	GMenuItem* line_size_menu_item = NULL;
	GMenuItem* _tmp2_;
	GMenu* _tmp3_;
	GMenuItem* _tmp4_;
	GMenu* _tmp5_;
	GMenu* _tmp6_;
	GMenu* size_section = NULL;
	GMenu* _tmp7_;
	GMenu* _tmp17_;
	GMenu* _tmp18_;
	GMenu* _tmp19_;
	GMenuModel* _tmp20_;
	GMenuModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	_tmp1_ = g_menu_new ();
	line_size = _tmp1_;
	_tmp2_ = g_menu_item_new (_ ("Show line size"), "show-line-size");
	line_size_menu_item = _tmp2_;
	_tmp3_ = line_size;
	_tmp4_ = line_size_menu_item;
	g_menu_append_item (_tmp3_, _tmp4_);
	_tmp5_ = section;
	_tmp6_ = line_size;
	g_menu_prepend_section (_tmp5_, NULL, (GMenuModel*) _tmp6_);
	_tmp7_ = g_menu_new ();
	size_section = _tmp7_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				GMenuItem* item = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_;
				GMenuItem* _tmp12_;
				GMenuItem* _tmp13_;
				GMenuItem* _tmp14_;
				GMenu* _tmp15_;
				GMenuItem* _tmp16_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				if (!(i < ((gint) FONT_MANAGER_PREDEFINED_WATERFALL_SIZE_CUSTOM))) {
					break;
				}
				_tmp10_ = font_manager_predefined_waterfall_size_to_string ((FontManagerPredefinedWaterfallSize) i);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_menu_item_new (_tmp11_, NULL);
				_tmp13_ = _tmp12_;
				_g_free0 (_tmp11_);
				item = _tmp13_;
				_tmp14_ = item;
				g_menu_item_set_action_and_target (_tmp14_, "predefined-size", "i", i, NULL);
				_tmp15_ = size_section;
				_tmp16_ = item;
				g_menu_append_item (_tmp15_, _tmp16_);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp17_ = section;
	_tmp18_ = size_section;
	g_menu_append_section (_tmp17_, NULL, (GMenuModel*) _tmp18_);
	_tmp19_ = section;
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, g_menu_model_get_type (), GMenuModel));
	result = _tmp20_;
	_g_object_unref0 (size_section);
	_g_object_unref0 (line_size_menu_item);
	_g_object_unref0 (line_size);
	_g_object_unref0 (section);
	return result;
}

GSettings*
font_manager_waterfall_settings_get_settings (FontManagerWaterfallSettings* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

void
font_manager_waterfall_settings_set_settings (FontManagerWaterfallSettings* self,
                                              GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_waterfall_settings_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_SETTINGS_PROPERTY]);
	}
}

gint
font_manager_waterfall_settings_get_predefined_size (FontManagerWaterfallSettings* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_predefined_size;
	return result;
}

void
font_manager_waterfall_settings_set_predefined_size (FontManagerWaterfallSettings* self,
                                                     gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_waterfall_settings_get_predefined_size (self);
	if (old_value != value) {
		self->priv->_predefined_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_PREDEFINED_SIZE_PROPERTY]);
	}
}

gdouble
font_manager_waterfall_settings_get_minimum (FontManagerWaterfallSettings* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_minimum;
	return result;
}

void
font_manager_waterfall_settings_set_minimum (FontManagerWaterfallSettings* self,
                                             gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_waterfall_settings_get_minimum (self);
	if (old_value != value) {
		self->priv->_minimum = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_MINIMUM_PROPERTY]);
	}
}

gdouble
font_manager_waterfall_settings_get_maximum (FontManagerWaterfallSettings* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_maximum;
	return result;
}

void
font_manager_waterfall_settings_set_maximum (FontManagerWaterfallSettings* self,
                                             gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_waterfall_settings_get_maximum (self);
	if (old_value != value) {
		self->priv->_maximum = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_MAXIMUM_PROPERTY]);
	}
}

gdouble
font_manager_waterfall_settings_get_ratio (FontManagerWaterfallSettings* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_ratio;
	return result;
}

void
font_manager_waterfall_settings_set_ratio (FontManagerWaterfallSettings* self,
                                           gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_waterfall_settings_get_ratio (self);
	if (old_value != value) {
		self->priv->_ratio = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_RATIO_PROPERTY]);
	}
}

gboolean
font_manager_waterfall_settings_get_show_line_size (FontManagerWaterfallSettings* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_line_size;
	return result;
}

void
font_manager_waterfall_settings_set_show_line_size (FontManagerWaterfallSettings* self,
                                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_waterfall_settings_get_show_line_size (self);
	if (old_value != value) {
		self->priv->_show_line_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_SHOW_LINE_SIZE_PROPERTY]);
	}
}

gint
font_manager_waterfall_settings_get_line_spacing (FontManagerWaterfallSettings* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_line_spacing;
	return result;
}

void
font_manager_waterfall_settings_set_line_spacing (FontManagerWaterfallSettings* self,
                                                  gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_waterfall_settings_get_line_spacing (self);
	if (old_value != value) {
		self->priv->_line_spacing = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_LINE_SPACING_PROPERTY]);
	}
}

GtkPopoverMenu*
font_manager_waterfall_settings_get_context_menu (FontManagerWaterfallSettings* self)
{
	GtkPopoverMenu* result;
	GtkPopoverMenu* _tmp0_;
	GtkPopoverMenu* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->menu;
	if (_tmp0_ == NULL) {
		GMenuModel* _tmp1_;
		GMenuModel* _tmp2_;
		GtkPopoverMenu* _tmp3_;
		_tmp1_ = font_manager_waterfall_settings_get_context_menu_model (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = (GtkPopoverMenu*) gtk_popover_menu_new_from_model (_tmp2_);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->menu);
		self->priv->menu = _tmp3_;
		_g_object_unref0 (_tmp2_);
	}
	_tmp4_ = self->priv->menu;
	result = _tmp4_;
	return result;
}

FontManagerPreferenceRow*
font_manager_waterfall_settings_get_preference_row (FontManagerWaterfallSettings* self)
{
	FontManagerPreferenceRow* result;
	FontManagerPreferenceRow* _tmp0_;
	FontManagerPreferenceRow* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->row;
	if (_tmp0_ == NULL) {
		font_manager_waterfall_settings_create_preference_row (self);
	}
	_tmp1_ = self->priv->row;
	result = _tmp1_;
	return result;
}

static void
font_manager_waterfall_settings_class_init (FontManagerWaterfallSettingsClass * klass,
                                            gpointer klass_data)
{
	font_manager_waterfall_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerWaterfallSettings_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_waterfall_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_waterfall_settings_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_waterfall_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_WATERFALL_SETTINGS_SETTINGS_PROPERTY, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_WATERFALL_SETTINGS_PREDEFINED_SIZE_PROPERTY, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_PREDEFINED_SIZE_PROPERTY] = g_param_spec_int ("predefined-size", "predefined-size", "predefined-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_WATERFALL_SETTINGS_MINIMUM_PROPERTY, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_MINIMUM_PROPERTY] = g_param_spec_double ("minimum", "minimum", "minimum", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_WATERFALL_SETTINGS_MAXIMUM_PROPERTY, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_MAXIMUM_PROPERTY] = g_param_spec_double ("maximum", "maximum", "maximum", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_WATERFALL_SETTINGS_RATIO_PROPERTY, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_RATIO_PROPERTY] = g_param_spec_double ("ratio", "ratio", "ratio", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_WATERFALL_SETTINGS_SHOW_LINE_SIZE_PROPERTY, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_SHOW_LINE_SIZE_PROPERTY] = g_param_spec_boolean ("show-line-size", "show-line-size", "show-line-size", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_WATERFALL_SETTINGS_LINE_SPACING_PROPERTY, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_LINE_SPACING_PROPERTY] = g_param_spec_int ("line-spacing", "line-spacing", "line-spacing", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_WATERFALL_SETTINGS_CONTEXT_MENU_PROPERTY, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_CONTEXT_MENU_PROPERTY] = g_param_spec_object ("context-menu", "context-menu", "context-menu", gtk_popover_menu_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_WATERFALL_SETTINGS_PREFERENCE_ROW_PROPERTY, font_manager_waterfall_settings_properties[FONT_MANAGER_WATERFALL_SETTINGS_PREFERENCE_ROW_PROPERTY] = g_param_spec_object ("preference-row", "preference-row", "preference-row", font_manager_preference_row_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
font_manager_waterfall_settings_instance_init (FontManagerWaterfallSettings * self,
                                               gpointer klass)
{
	self->priv = font_manager_waterfall_settings_get_instance_private (self);
	self->priv->_settings = NULL;
	self->priv->_show_line_size = TRUE;
	self->priv->_line_spacing = 0;
	self->priv->menu = NULL;
	self->priv->row = NULL;
}

static void
font_manager_waterfall_settings_finalize (GObject * obj)
{
	FontManagerWaterfallSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_WATERFALL_SETTINGS, FontManagerWaterfallSettings);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->min);
	_g_object_unref0 (self->priv->max);
	_g_object_unref0 (self->priv->rat);
	_g_object_unref0 (self->priv->selection);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->row);
	G_OBJECT_CLASS (font_manager_waterfall_settings_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_waterfall_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerWaterfallSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_waterfall_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerWaterfallSettings), 0, (GInstanceInitFunc) font_manager_waterfall_settings_instance_init, NULL };
	GType font_manager_waterfall_settings_type_id;
	font_manager_waterfall_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerWaterfallSettings", &g_define_type_info, 0);
	FontManagerWaterfallSettings_private_offset = g_type_add_instance_private (font_manager_waterfall_settings_type_id, sizeof (FontManagerWaterfallSettingsPrivate));
	return font_manager_waterfall_settings_type_id;
}

GType
font_manager_waterfall_settings_get_type (void)
{
	static volatile gsize font_manager_waterfall_settings_type_id__once = 0;
	if (g_once_init_enter (&font_manager_waterfall_settings_type_id__once)) {
		GType font_manager_waterfall_settings_type_id;
		font_manager_waterfall_settings_type_id = font_manager_waterfall_settings_get_type_once ();
		g_once_init_leave (&font_manager_waterfall_settings_type_id__once, font_manager_waterfall_settings_type_id);
	}
	return font_manager_waterfall_settings_type_id__once;
}

static void
_vala_font_manager_waterfall_settings_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	FontManagerWaterfallSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_WATERFALL_SETTINGS, FontManagerWaterfallSettings);
	switch (property_id) {
		case FONT_MANAGER_WATERFALL_SETTINGS_SETTINGS_PROPERTY:
		g_value_set_object (value, font_manager_waterfall_settings_get_settings (self));
		break;
		case FONT_MANAGER_WATERFALL_SETTINGS_PREDEFINED_SIZE_PROPERTY:
		g_value_set_int (value, font_manager_waterfall_settings_get_predefined_size (self));
		break;
		case FONT_MANAGER_WATERFALL_SETTINGS_MINIMUM_PROPERTY:
		g_value_set_double (value, font_manager_waterfall_settings_get_minimum (self));
		break;
		case FONT_MANAGER_WATERFALL_SETTINGS_MAXIMUM_PROPERTY:
		g_value_set_double (value, font_manager_waterfall_settings_get_maximum (self));
		break;
		case FONT_MANAGER_WATERFALL_SETTINGS_RATIO_PROPERTY:
		g_value_set_double (value, font_manager_waterfall_settings_get_ratio (self));
		break;
		case FONT_MANAGER_WATERFALL_SETTINGS_SHOW_LINE_SIZE_PROPERTY:
		g_value_set_boolean (value, font_manager_waterfall_settings_get_show_line_size (self));
		break;
		case FONT_MANAGER_WATERFALL_SETTINGS_LINE_SPACING_PROPERTY:
		g_value_set_int (value, font_manager_waterfall_settings_get_line_spacing (self));
		break;
		case FONT_MANAGER_WATERFALL_SETTINGS_CONTEXT_MENU_PROPERTY:
		g_value_set_object (value, font_manager_waterfall_settings_get_context_menu (self));
		break;
		case FONT_MANAGER_WATERFALL_SETTINGS_PREFERENCE_ROW_PROPERTY:
		g_value_set_object (value, font_manager_waterfall_settings_get_preference_row (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_waterfall_settings_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	FontManagerWaterfallSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_WATERFALL_SETTINGS, FontManagerWaterfallSettings);
	switch (property_id) {
		case FONT_MANAGER_WATERFALL_SETTINGS_SETTINGS_PROPERTY:
		font_manager_waterfall_settings_set_settings (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_WATERFALL_SETTINGS_PREDEFINED_SIZE_PROPERTY:
		font_manager_waterfall_settings_set_predefined_size (self, g_value_get_int (value));
		break;
		case FONT_MANAGER_WATERFALL_SETTINGS_MINIMUM_PROPERTY:
		font_manager_waterfall_settings_set_minimum (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_WATERFALL_SETTINGS_MAXIMUM_PROPERTY:
		font_manager_waterfall_settings_set_maximum (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_WATERFALL_SETTINGS_RATIO_PROPERTY:
		font_manager_waterfall_settings_set_ratio (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_WATERFALL_SETTINGS_SHOW_LINE_SIZE_PROPERTY:
		font_manager_waterfall_settings_set_show_line_size (self, g_value_get_boolean (value));
		break;
		case FONT_MANAGER_WATERFALL_SETTINGS_LINE_SPACING_PROPERTY:
		font_manager_waterfall_settings_set_line_spacing (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

