
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "searchenginesmanager_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

// inner classes
#include "searchenginesmanager_engine_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_SearchEnginesManager_Type = nullptr;
static PyTypeObject *Sbk_SearchEnginesManager_TypeF(void)
{
    return _Sbk_SearchEnginesManager_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void SearchEnginesManagerWrapper::pysideInitQtMetaTypes()
{
}

void SearchEnginesManagerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

SearchEnginesManagerWrapper::SearchEnginesManagerWrapper(::QObject * parent) : SearchEnginesManager(parent)
{
}

void SearchEnginesManagerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SearchEnginesManager_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("SearchEnginesManager", funcName, gil, pyOverride, event);
}

void SearchEnginesManagerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SearchEnginesManager_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("SearchEnginesManager", funcName, gil, pyOverride, signal);
}

void SearchEnginesManagerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SearchEnginesManager_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("SearchEnginesManager", funcName, gil, pyOverride, event);
}

void SearchEnginesManagerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SearchEnginesManager_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("SearchEnginesManager", funcName, gil, pyOverride, signal);
}

bool SearchEnginesManagerWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SearchEnginesManager_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("SearchEnginesManager", funcName, gil, pyOverride, event);
}

bool SearchEnginesManagerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SearchEnginesManager_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("SearchEnginesManager", funcName, gil, pyOverride, watched, event);
}

void SearchEnginesManagerWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SearchEnginesManager_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("SearchEnginesManager", funcName, gil, pyOverride, event);
}

const QMetaObject *SearchEnginesManagerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return SearchEnginesManager::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int SearchEnginesManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = SearchEnginesManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *SearchEnginesManagerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< SearchEnginesManagerWrapper *>(this));
    }
    return SearchEnginesManager::qt_metacast(_clname);
}

SearchEnginesManagerWrapper::~SearchEnginesManagerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_SearchEnginesManager_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_SearchEnginesManager_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::SearchEnginesManager >()))
        return -1;

    SearchEnginesManagerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:SearchEnginesManager", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: SearchEnginesManager::SearchEnginesManager(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // SearchEnginesManager(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // SearchEnginesManager(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // SearchEnginesManager(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) SearchEnginesManagerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new SearchEnginesManagerWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< SearchEnginesManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);
    };


    return 1;
}

static PyObject *Sbk_SearchEnginesManagerFunc_activeEngine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // activeEngine()const
        SearchEnginesManager::Engine cppResult = const_cast<const SearchEnginesManagerWrapper *>(cppSelf)->activeEngine();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SearchEnginesManagerFunc_addEngine(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SearchEnginesManager::addEngine(QUrl)
    // 1: SearchEnginesManager::addEngine(SearchEnginesManager::Engine)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), (pyArg)))) {
        overloadId = 1; // addEngine(SearchEnginesManager::Engine)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // addEngine(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addEngine", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // addEngine(const QUrl &url)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (pythonToCpp.isValue())
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // addEngine(QUrl)
                cppSelf->addEngine(*cppArg0);
            }
            break;
        }
        case 1: // addEngine(const SearchEnginesManager::Engine &engine)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::SearchEnginesManager::Engine cppArg0_local;
            ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
            if (pythonToCpp.isValue())
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // addEngine(SearchEnginesManager::Engine)
                cppSelf->addEngine(*cppArg0);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SearchEnginesManagerFunc_addEngineFromForm(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addEngineFromForm", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: SearchEnginesManager::addEngineFromForm(QMap<QString,QVariant>,WebView*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QString_QVariant_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]), (pyArgs[1])))) {
        overloadId = 0; // addEngineFromForm(QMap<QString,QVariant>,WebView*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addEngineFromForm", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);

    // Call function/method
    {
        ::QMap<QString,QVariant> cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::WebView *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addEngineFromForm(QMap<QString,QVariant>,WebView*)
            cppSelf->addEngineFromForm(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SearchEnginesManagerFunc_allEngines(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // allEngines()
        QList<SearchEnginesManager::Engine> cppResult = cppSelf->allEngines();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_SearchEnginesManager_Engine_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SearchEnginesManagerFunc_defaultEngine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // defaultEngine()const
        SearchEnginesManager::Engine cppResult = const_cast<const SearchEnginesManagerWrapper *>(cppSelf)->defaultEngine();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SearchEnginesManagerFunc_editEngine(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "editEngine", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: SearchEnginesManager::editEngine(SearchEnginesManager::Engine,SearchEnginesManager::Engine)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), (pyArgs[1])))) {
        overloadId = 0; // editEngine(SearchEnginesManager::Engine,SearchEnginesManager::Engine)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "editEngine", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::SearchEnginesManager::Engine cppArg0_local;
        ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::SearchEnginesManager::Engine cppArg1_local;
        ::SearchEnginesManager::Engine *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (Shiboken::Errors::occurred() == nullptr) {
            // editEngine(SearchEnginesManager::Engine,SearchEnginesManager::Engine)
            cppSelf->editEngine(*cppArg0, *cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SearchEnginesManagerFunc_engineForShortcut(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SearchEnginesManager::engineForShortcut(QString)->SearchEnginesManager::Engine
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // engineForShortcut(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "engineForShortcut", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // engineForShortcut(QString)
            SearchEnginesManager::Engine cppResult = cppSelf->engineForShortcut(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SearchEnginesManagerFunc_iconForSearchEngine(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static SearchEnginesManager::iconForSearchEngine(QUrl)->QIcon
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // iconForSearchEngine(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "iconForSearchEngine", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // iconForSearchEngine(QUrl)
            QIcon cppResult = ::SearchEnginesManager::iconForSearchEngine(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SearchEnginesManagerFunc_removeEngine(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SearchEnginesManager::removeEngine(SearchEnginesManager::Engine)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), (pyArg)))) {
        overloadId = 0; // removeEngine(SearchEnginesManager::Engine)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeEngine", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::SearchEnginesManager::Engine cppArg0_local;
        ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // removeEngine(SearchEnginesManager::Engine)
            cppSelf->removeEngine(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SearchEnginesManagerFunc_restoreDefaults(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // restoreDefaults()
        cppSelf->restoreDefaults();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SearchEnginesManagerFunc_saveSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // saveSettings()
        cppSelf->saveSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SearchEnginesManagerFunc_searchResult(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "searchResult", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: SearchEnginesManager::searchResult(QString)->LoadRequest
    // 1: SearchEnginesManager::searchResult(SearchEnginesManager::Engine,QString)->LoadRequest
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 1; // searchResult(SearchEnginesManager::Engine,QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 0; // searchResult(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "searchResult", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // searchResult(const QString &string)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // searchResult(QString)
                LoadRequest cppResult = cppSelf->searchResult(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), &cppResult);
            }
            break;
        }
        case 1: // searchResult(const SearchEnginesManager::Engine &engine, const QString &string)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::SearchEnginesManager::Engine cppArg0_local;
            ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // searchResult(SearchEnginesManager::Engine,QString)
                LoadRequest cppResult = cppSelf->searchResult(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SearchEnginesManagerFunc_setActiveEngine(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SearchEnginesManager::setActiveEngine(SearchEnginesManager::Engine)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), (pyArg)))) {
        overloadId = 0; // setActiveEngine(SearchEnginesManager::Engine)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setActiveEngine", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::SearchEnginesManager::Engine cppArg0_local;
        ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setActiveEngine(SearchEnginesManager::Engine)
            cppSelf->setActiveEngine(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SearchEnginesManagerFunc_setAllEngines(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SearchEnginesManager::setAllEngines(QList<SearchEnginesManager::Engine>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_SearchEnginesManager_Engine_IDX], (pyArg)))) {
        overloadId = 0; // setAllEngines(QList<SearchEnginesManager::Engine>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAllEngines", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);

    // Call function/method
    {
        ::QList<SearchEnginesManager::Engine> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAllEngines(QList<SearchEnginesManager::Engine>)
            cppSelf->setAllEngines(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SearchEnginesManagerFunc_setDefaultEngine(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SearchEnginesManager::setDefaultEngine(SearchEnginesManager::Engine)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), (pyArg)))) {
        overloadId = 0; // setDefaultEngine(SearchEnginesManager::Engine)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDefaultEngine", errInfo, SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::SearchEnginesManager::Engine cppArg0_local;
        ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setDefaultEngine(SearchEnginesManager::Engine)
            cppSelf->setDefaultEngine(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SearchEnginesManagerFunc_startingEngineName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // startingEngineName()
        QString cppResult = cppSelf->startingEngineName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_SearchEnginesManager_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_SearchEnginesManager_methods[] = {
    {"activeEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_activeEngine), METH_NOARGS, nullptr},
    {"addEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_addEngine), METH_O, nullptr},
    {"addEngineFromForm", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_addEngineFromForm), METH_VARARGS, nullptr},
    {"allEngines", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_allEngines), METH_NOARGS, nullptr},
    {"defaultEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_defaultEngine), METH_NOARGS, nullptr},
    {"editEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_editEngine), METH_VARARGS, nullptr},
    {"engineForShortcut", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_engineForShortcut), METH_O, nullptr},
    {"iconForSearchEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_iconForSearchEngine), METH_O|METH_STATIC, nullptr},
    {"removeEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_removeEngine), METH_O, nullptr},
    {"restoreDefaults", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_restoreDefaults), METH_NOARGS, nullptr},
    {"saveSettings", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_saveSettings), METH_NOARGS, nullptr},
    {"searchResult", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_searchResult), METH_VARARGS, nullptr},
    {"setActiveEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_setActiveEngine), METH_O, nullptr},
    {"setAllEngines", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_setAllEngines), METH_O, nullptr},
    {"setDefaultEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_setDefaultEngine), METH_O, nullptr},
    {"startingEngineName", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_startingEngineName), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_SearchEnginesManager_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<SearchEnginesManagerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_SearchEnginesManager_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_SearchEnginesManager_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_SearchEnginesManager_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_SearchEnginesManager_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_SearchEnginesManager_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_SearchEnginesManager_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_SearchEnginesManager_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_SearchEnginesManager_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_SearchEnginesManager_spec = {
    "1:PyFalkon.SearchEnginesManager",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_SearchEnginesManager_slots
};

} //extern "C"

static void *Sbk_SearchEnginesManager_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::SearchEnginesManager *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void SearchEnginesManager_PythonToCpp_SearchEnginesManager_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_SearchEnginesManager_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_SearchEnginesManager_PythonToCpp_SearchEnginesManager_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_SearchEnginesManager_TypeF()))
        return SearchEnginesManager_PythonToCpp_SearchEnginesManager_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *SearchEnginesManager_PTR_CppToPython_SearchEnginesManager(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::SearchEnginesManager *>(const_cast<void *>(cppIn)), Sbk_SearchEnginesManager_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *SearchEnginesManager_SignatureStrings[] = {
    "PyFalkon.SearchEnginesManager(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.SearchEnginesManager.activeEngine(self)->PyFalkon.SearchEnginesManager.Engine",
    "1:PyFalkon.SearchEnginesManager.addEngine(self,url:typing.Union[PySide6.QtCore.QUrl, QString])",
    "0:PyFalkon.SearchEnginesManager.addEngine(self,engine:PyFalkon.SearchEnginesManager.Engine)",
    "PyFalkon.SearchEnginesManager.addEngineFromForm(self,formData:QMap[QString, QVariant],view:PyFalkon.WebView)",
    "PyFalkon.SearchEnginesManager.allEngines(self)->QList[PyFalkon.SearchEnginesManager.Engine]",
    "PyFalkon.SearchEnginesManager.defaultEngine(self)->PyFalkon.SearchEnginesManager.Engine",
    "PyFalkon.SearchEnginesManager.editEngine(self,before:PyFalkon.SearchEnginesManager.Engine,after:PyFalkon.SearchEnginesManager.Engine)",
    "PyFalkon.SearchEnginesManager.engineForShortcut(self,shortcut:QString)->PyFalkon.SearchEnginesManager.Engine",
    "PyFalkon.SearchEnginesManager.iconForSearchEngine(url:typing.Union[PySide6.QtCore.QUrl, QString])->PySide6.QtGui.QIcon",
    "PyFalkon.SearchEnginesManager.removeEngine(self,engine:PyFalkon.SearchEnginesManager.Engine)",
    "PyFalkon.SearchEnginesManager.restoreDefaults(self)",
    "PyFalkon.SearchEnginesManager.saveSettings(self)",
    "1:PyFalkon.SearchEnginesManager.searchResult(self,string:QString)->PyFalkon.LoadRequest",
    "0:PyFalkon.SearchEnginesManager.searchResult(self,engine:PyFalkon.SearchEnginesManager.Engine,string:QString)->PyFalkon.LoadRequest",
    "PyFalkon.SearchEnginesManager.setActiveEngine(self,engine:PyFalkon.SearchEnginesManager.Engine)",
    "PyFalkon.SearchEnginesManager.setAllEngines(self,engines:QList[PyFalkon.SearchEnginesManager.Engine])",
    "PyFalkon.SearchEnginesManager.setDefaultEngine(self,engine:PyFalkon.SearchEnginesManager.Engine)",
    "PyFalkon.SearchEnginesManager.startingEngineName(self)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t SearchEnginesManager_SignatureByteSize = 397;
static constexpr uint8_t SearchEnginesManager_SignatureBytes[397] = {
    0x78, 0xda, 0xad, 0x54, 0xcb, 0x4e, 0xc3, 0x30, 0x10, 0xbc, 0xf7, 0x2b, 0x38, 0xb6, 0x52, 0x88,
    0xe0, 0xc2, 0x21, 0x12, 0x48, 0x88, 0x52, 0x84, 0xd4, 0x42, 0xd3, 0xa8, 0xe5, 0x50, 0xf5, 0xb0,
    0x4d, 0x36, 0xad, 0xc1, 0xb1, 0x83, 0xbd, 0x29, 0xea, 0xdf, 0xe3, 0x3c, 0x0a, 0x7d, 0xa0, 0x3a,
    0x41, 0xb9, 0xd9, 0x6b, 0x7b, 0x76, 0x76, 0x66, 0xbd, 0xe3, 0xed, 0x00, 0xf8, 0x87, 0x14, 0x6e,
    0x80, 0xa0, 0xc2, 0xf5, 0xa3, 0x58, 0x31, 0x81, 0x7a, 0x04, 0x02, 0x56, 0xa8, 0xba, 0x1a, 0x79,
    0xec, 0xa4, 0xa0, 0x50, 0x90, 0x37, 0xde, 0x06, 0x2c, 0xc2, 0x1b, 0xd7, 0xa7, 0x07, 0xa9, 0xd0,
    0xf5, 0x5f, 0x97, 0xef, 0x18, 0xd2, 0xad, 0xc8, 0x38, 0x4f, 0x49, 0xf5, 0x3a, 0xe3, 0x73, 0x48,
    0x2e, 0x84, 0xc4, 0x36, 0x58, 0x06, 0x0b, 0xd8, 0xde, 0xe5, 0xdd, 0xf9, 0x17, 0xe5, 0xb6, 0x73,
    0xed, 0x59, 0x80, 0xa3, 0x68, 0x0f, 0xd5, 0xc9, 0x14, 0xf7, 0x68, 0x9b, 0x32, 0xb1, 0x72, 0xa7,
    0x82, 0x49, 0x31, 0x3f, 0xa6, 0x3d, 0x55, 0xdc, 0xb9, 0xf0, 0x03, 0x52, 0xe6, 0xca, 0xa2, 0xd7,
    0xb9, 0x6a, 0x06, 0x8f, 0xc5, 0xda, 0xab, 0xc3, 0xdc, 0xaa, 0xc8, 0x0e, 0x79, 0xa0, 0x64, 0x32,
    0x90, 0x2a, 0x29, 0x33, 0xc4, 0x66, 0xd5, 0x07, 0x02, 0xcf, 0x1f, 0x41, 0x3a, 0xaf, 0x88, 0x1a,
    0xc6, 0x33, 0x50, 0x0c, 0x04, 0x2d, 0x9c, 0x0d, 0xc3, 0xaf, 0x5f, 0x02, 0x6f, 0xb8, 0x9c, 0x99,
    0x80, 0x35, 0x19, 0xe7, 0x55, 0x64, 0x27, 0xbe, 0x3f, 0x64, 0x9a, 0xe6, 0x75, 0x0a, 0x59, 0x58,
    0xb0, 0x23, 0x8c, 0x21, 0xe3, 0xf4, 0x0f, 0x6f, 0xcf, 0x5f, 0xc2, 0x88, 0xed, 0x83, 0x3a, 0x4b,
    0x34, 0xda, 0xd4, 0xd3, 0xde, 0x81, 0x98, 0x50, 0xb5, 0x62, 0x53, 0xe9, 0xb8, 0xf1, 0x27, 0x58,
    0x4b, 0x45, 0x61, 0x46, 0x25, 0x19, 0x5d, 0xed, 0xbc, 0xca, 0xa1, 0x76, 0x4a, 0x66, 0xa1, 0x14,
    0x79, 0xaa, 0xbd, 0xb3, 0x6e, 0xc3, 0x8e, 0xce, 0x79, 0xec, 0xce, 0x9f, 0x32, 0xe6, 0xfa, 0xcf,
    0x06, 0xd3, 0x92, 0x56, 0x61, 0x22, 0x0f, 0x3e, 0x67, 0x9b, 0x7d, 0xae, 0x50, 0x93, 0xe1, 0xd9,
    0x2f, 0xbb, 0xa4, 0xea, 0x3f, 0xcb, 0x1b, 0x0d, 0x1b, 0x0c, 0x90, 0xc8, 0x54, 0xb4, 0x7b, 0x60,
    0x9b, 0x03, 0xba, 0x08, 0x4e, 0x50, 0x9b, 0x24, 0x95, 0x45, 0x85, 0x22, 0x7f, 0x19, 0x34, 0x94,
    0x10, 0x4d, 0xf0, 0x33, 0x33, 0xcc, 0xac, 0x03, 0xe0, 0x14, 0xb7, 0x81, 0x36, 0x35, 0x39, 0xd8,
    0x18, 0xd0, 0xfd, 0xf1, 0xf4, 0x6c, 0xd3, 0xa0, 0x1c, 0xff, 0x70, 0x3c, 0x54, 0xe8, 0xda, 0x6b,
    0x30, 0x24, 0x6a, 0x64, 0xe9, 0x9f, 0x0c, 0x8a, 0x56, 0xcb, 0x20, 0x50, 0x79, 0xc3, 0x94, 0xe1,
    0x17, 0x48, 0x7e, 0x66, 0x51, 0xa5, 0x7e, 0xe7, 0x1b, 0xf4, 0x72, 0x92, 0x02
};
#endif

PyTypeObject *init_SearchEnginesManager(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX].type;

    Shiboken::AutoDecRef Sbk_SearchEnginesManager_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_SearchEnginesManager_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "SearchEnginesManager",
        "SearchEnginesManager*",
        &Sbk_SearchEnginesManager_spec,
        &Shiboken::callCppDestructor< SearchEnginesManager >,
        Sbk_SearchEnginesManager_Type_bases.object(),
        0);
    auto *pyType = _Sbk_SearchEnginesManager_Type; // references _Sbk_SearchEnginesManager_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, SearchEnginesManager_SignatureStrings);
#else
    InitSignatureBytes(pyType, SearchEnginesManager_SignatureBytes, SearchEnginesManager_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_SearchEnginesManager_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        SearchEnginesManager_PythonToCpp_SearchEnginesManager_PTR,
        is_SearchEnginesManager_PythonToCpp_SearchEnginesManager_PTR_Convertible,
        SearchEnginesManager_PTR_CppToPython_SearchEnginesManager);

    Shiboken::Conversions::registerConverterName(converter, "SearchEnginesManager");
    Shiboken::Conversions::registerConverterName(converter, "SearchEnginesManager*");
    Shiboken::Conversions::registerConverterName(converter, "SearchEnginesManager&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::SearchEnginesManager).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(SearchEnginesManagerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_SearchEnginesManager_TypeF(), &Sbk_SearchEnginesManager_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::SearchEnginesManager::staticMetaObject);
    SearchEnginesManagerWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::SearchEnginesManager::staticMetaObject, sizeof(SearchEnginesManagerWrapper));

    return pyType;
}
