// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"errors"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"time"
)

// Describes one or more of your secondary subnets.
func (c *Client) DescribeSecondarySubnets(ctx context.Context, params *DescribeSecondarySubnetsInput, optFns ...func(*Options)) (*DescribeSecondarySubnetsOutput, error) {
	if params == nil {
		params = &DescribeSecondarySubnetsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeSecondarySubnets", params, optFns, c.addOperationDescribeSecondarySubnetsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeSecondarySubnetsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeSecondarySubnetsInput struct {

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The filters.
	//
	//   - ipv4-cidr-block-association.association-id - The association ID for an IPv4
	//   CIDR block associated with the secondary subnet.
	//
	//   - ipv4-cidr-block-association.cidr-block - An IPv4 CIDR block associated with
	//   the secondary subnet.
	//
	//   - ipv4-cidr-block-association.state - The state of an IPv4 CIDR block
	//   associated with the secondary subnet.
	//
	//   - owner-id - The ID of the Amazon Web Services account that owns the secondary
	//   subnet.
	//
	//   - secondary-network-id - The ID of the secondary network.
	//
	//   - secondary-network-type - The type of the secondary network ( rdma ).
	//
	//   - secondary-subnet-id - The ID of the secondary subnet.
	//
	//   - secondary-subnet-arn - The ARN of the secondary subnet.
	//
	//   - state - The state of the secondary subnet ( create-in-progress |
	//   create-complete | create-failed | delete-in-progress | delete-complete |
	//   delete-failed ).
	//
	//   - tag : - The key/value combination of a tag assigned to the resource. Use the
	//   tag key in the filter name and the tag value as the filter value. For example,
	//   to find all resources that have a tag with the key Owner and the value TeamA ,
	//   specify tag:Owner for the filter name and TeamA for the filter value.
	//
	//   - tag-key - The key of a tag assigned to the resource. Use this filter to find
	//   all resources assigned a tag with a specific key, regardless of the tag value.
	Filters []types.Filter

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	// The IDs of the secondary subnets.
	SecondarySubnetIds []string

	noSmithyDocumentSerde
}

type DescribeSecondarySubnetsOutput struct {

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Information about the secondary subnets.
	SecondarySubnets []types.SecondarySubnet

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeSecondarySubnetsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeSecondarySubnets{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeSecondarySubnets{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeSecondarySubnets"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeSecondarySubnets(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// SecondarySubnetCreateCompleteWaiterOptions are waiter options for
// SecondarySubnetCreateCompleteWaiter
type SecondarySubnetCreateCompleteWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// SecondarySubnetCreateCompleteWaiter will use default minimum delay of 10
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, SecondarySubnetCreateCompleteWaiter will use default max delay of
	// 120 seconds. Note that MaxDelay must resolve to value greater than or equal to
	// the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeSecondarySubnetsInput, *DescribeSecondarySubnetsOutput, error) (bool, error)
}

// SecondarySubnetCreateCompleteWaiter defines the waiters for
// SecondarySubnetCreateComplete
type SecondarySubnetCreateCompleteWaiter struct {
	client DescribeSecondarySubnetsAPIClient

	options SecondarySubnetCreateCompleteWaiterOptions
}

// NewSecondarySubnetCreateCompleteWaiter constructs a
// SecondarySubnetCreateCompleteWaiter.
func NewSecondarySubnetCreateCompleteWaiter(client DescribeSecondarySubnetsAPIClient, optFns ...func(*SecondarySubnetCreateCompleteWaiterOptions)) *SecondarySubnetCreateCompleteWaiter {
	options := SecondarySubnetCreateCompleteWaiterOptions{}
	options.MinDelay = 10 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = secondarySubnetCreateCompleteStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &SecondarySubnetCreateCompleteWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for SecondarySubnetCreateComplete waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *SecondarySubnetCreateCompleteWaiter) Wait(ctx context.Context, params *DescribeSecondarySubnetsInput, maxWaitDur time.Duration, optFns ...func(*SecondarySubnetCreateCompleteWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for SecondarySubnetCreateComplete
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *SecondarySubnetCreateCompleteWaiter) WaitForOutput(ctx context.Context, params *DescribeSecondarySubnetsInput, maxWaitDur time.Duration, optFns ...func(*SecondarySubnetCreateCompleteWaiterOptions)) (*DescribeSecondarySubnetsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeSecondarySubnets(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for SecondarySubnetCreateComplete waiter")
}

func secondarySubnetCreateCompleteStateRetryable(ctx context.Context, input *DescribeSecondarySubnetsInput, output *DescribeSecondarySubnetsOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.SecondarySubnets
		var v2 []types.SecondarySubnetState
		for _, v := range v1 {
			v3 := v.State
			v2 = append(v2, v3)
		}
		expectedValue := "create-complete"
		match := len(v2) > 0
		for _, v := range v2 {
			if string(v) != expectedValue {
				match = false
				break
			}
		}

		if match {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.SecondarySubnets
		var v2 []types.SecondarySubnetState
		for _, v := range v1 {
			v3 := v.State
			v2 = append(v2, v3)
		}
		expectedValue := "delete-failed"
		var match bool
		for _, v := range v2 {
			if string(v) == expectedValue {
				match = true
				break
			}
		}

		if match {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err != nil {
		var apiErr smithy.APIError
		ok := errors.As(err, &apiErr)
		if !ok {
			return false, fmt.Errorf("expected err to be of type smithy.APIError, got %w", err)
		}

		if "InvalidSecondarySubnetId.NotFound" == apiErr.ErrorCode() {
			return true, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// SecondarySubnetDeleteCompleteWaiterOptions are waiter options for
// SecondarySubnetDeleteCompleteWaiter
type SecondarySubnetDeleteCompleteWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// SecondarySubnetDeleteCompleteWaiter will use default minimum delay of 10
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, SecondarySubnetDeleteCompleteWaiter will use default max delay of
	// 120 seconds. Note that MaxDelay must resolve to value greater than or equal to
	// the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeSecondarySubnetsInput, *DescribeSecondarySubnetsOutput, error) (bool, error)
}

// SecondarySubnetDeleteCompleteWaiter defines the waiters for
// SecondarySubnetDeleteComplete
type SecondarySubnetDeleteCompleteWaiter struct {
	client DescribeSecondarySubnetsAPIClient

	options SecondarySubnetDeleteCompleteWaiterOptions
}

// NewSecondarySubnetDeleteCompleteWaiter constructs a
// SecondarySubnetDeleteCompleteWaiter.
func NewSecondarySubnetDeleteCompleteWaiter(client DescribeSecondarySubnetsAPIClient, optFns ...func(*SecondarySubnetDeleteCompleteWaiterOptions)) *SecondarySubnetDeleteCompleteWaiter {
	options := SecondarySubnetDeleteCompleteWaiterOptions{}
	options.MinDelay = 10 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = secondarySubnetDeleteCompleteStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &SecondarySubnetDeleteCompleteWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for SecondarySubnetDeleteComplete waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *SecondarySubnetDeleteCompleteWaiter) Wait(ctx context.Context, params *DescribeSecondarySubnetsInput, maxWaitDur time.Duration, optFns ...func(*SecondarySubnetDeleteCompleteWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for SecondarySubnetDeleteComplete
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *SecondarySubnetDeleteCompleteWaiter) WaitForOutput(ctx context.Context, params *DescribeSecondarySubnetsInput, maxWaitDur time.Duration, optFns ...func(*SecondarySubnetDeleteCompleteWaiterOptions)) (*DescribeSecondarySubnetsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeSecondarySubnets(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for SecondarySubnetDeleteComplete waiter")
}

func secondarySubnetDeleteCompleteStateRetryable(ctx context.Context, input *DescribeSecondarySubnetsInput, output *DescribeSecondarySubnetsOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.SecondarySubnets
		var v2 []types.SecondarySubnetState
		for _, v := range v1 {
			v3 := v.State
			v2 = append(v2, v3)
		}
		expectedValue := "delete-complete"
		match := len(v2) > 0
		for _, v := range v2 {
			if string(v) != expectedValue {
				match = false
				break
			}
		}

		if match {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.SecondarySubnets
		var v2 []types.SecondarySubnetState
		for _, v := range v1 {
			v3 := v.State
			v2 = append(v2, v3)
		}
		expectedValue := "delete-failed"
		var match bool
		for _, v := range v2 {
			if string(v) == expectedValue {
				match = true
				break
			}
		}

		if match {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// DescribeSecondarySubnetsPaginatorOptions is the paginator options for
// DescribeSecondarySubnets
type DescribeSecondarySubnetsPaginatorOptions struct {
	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeSecondarySubnetsPaginator is a paginator for DescribeSecondarySubnets
type DescribeSecondarySubnetsPaginator struct {
	options   DescribeSecondarySubnetsPaginatorOptions
	client    DescribeSecondarySubnetsAPIClient
	params    *DescribeSecondarySubnetsInput
	nextToken *string
	firstPage bool
}

// NewDescribeSecondarySubnetsPaginator returns a new
// DescribeSecondarySubnetsPaginator
func NewDescribeSecondarySubnetsPaginator(client DescribeSecondarySubnetsAPIClient, params *DescribeSecondarySubnetsInput, optFns ...func(*DescribeSecondarySubnetsPaginatorOptions)) *DescribeSecondarySubnetsPaginator {
	if params == nil {
		params = &DescribeSecondarySubnetsInput{}
	}

	options := DescribeSecondarySubnetsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeSecondarySubnetsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeSecondarySubnetsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeSecondarySubnets page.
func (p *DescribeSecondarySubnetsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeSecondarySubnetsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeSecondarySubnets(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeSecondarySubnetsAPIClient is a client that implements the
// DescribeSecondarySubnets operation.
type DescribeSecondarySubnetsAPIClient interface {
	DescribeSecondarySubnets(context.Context, *DescribeSecondarySubnetsInput, ...func(*Options)) (*DescribeSecondarySubnetsOutput, error)
}

var _ DescribeSecondarySubnetsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeSecondarySubnets(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeSecondarySubnets",
	}
}
