/*********************                                                        */
/** type_enumerator.cpp
 **
 ** Copyright 2010-2014  New York University and The University of Iowa,
 ** and as below.
 **
 ** This header file automatically generated by:
 **
 **     /build/cvc4/src/cvc5-1.8/src/theory/mktheorytraits /build/cvc4/src/cvc5-1.8/src/theory/type_enumerator_template.cpp /build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds /build/cvc4/src/cvc5-1.8/src/theory/booleans/kinds /build/cvc4/src/cvc5-1.8/src/theory/uf/kinds /build/cvc4/src/cvc5-1.8/src/theory/arith/kinds /build/cvc4/src/cvc5-1.8/src/theory/bv/kinds /build/cvc4/src/cvc5-1.8/src/theory/fp/kinds /build/cvc4/src/cvc5-1.8/src/theory/arrays/kinds /build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds /build/cvc4/src/cvc5-1.8/src/theory/sep/kinds /build/cvc4/src/cvc5-1.8/src/theory/sets/kinds /build/cvc4/src/cvc5-1.8/src/theory/strings/kinds /build/cvc4/src/cvc5-1.8/src/theory/quantifiers/kinds
 **
 ** for the CVC4 project.
 **/

/*********************                                                        */
/*! \file type_enumerator_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner, Tim King
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Enumerators for types
 **
 ** Enumerators for types.
 **/

#include <sstream>

#include "base/check.h"
#include "expr/kind.h"
#include "theory/type_enumerator.h"



#line 271 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
#include "theory/builtin/type_enumerator.h"
#line 316 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
#include "theory/builtin/type_enumerator.h"
#line 27 "/build/cvc4/src/cvc5-1.8/src/theory/booleans/kinds"
#include "theory/booleans/type_enumerator.h"
#line 71 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
#include "theory/arith/type_enumerator.h"
#line 74 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
#include "theory/arith/type_enumerator.h"
#line 30 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
#include "theory/bv/type_enumerator.h"
#line 41 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
#include "theory/fp/type_enumerator.h"
#line 57 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
#include "theory/fp/type_enumerator.h"
#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/arrays/kinds"
#include "theory/arrays/type_enumerator.h"
#line 54 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
#include "theory/datatypes/type_enumerator.h"
#line 67 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
#include "theory/datatypes/type_enumerator.h"
#line 33 "/build/cvc4/src/cvc5-1.8/src/theory/sets/kinds"
#include "theory/sets/theory_sets_type_enumerator.h"
#line 55 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
#include "theory/strings/type_enumerator.h"
#line 74 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
#include "theory/strings/type_enumerator.h"
#line 26 "/build/cvc4/src/cvc5-1.8/src/theory/type_enumerator_template.cpp"

using namespace std;

namespace CVC4 {
namespace theory {

TypeEnumeratorInterface* TypeEnumerator::mkTypeEnumerator(
    TypeNode type, TypeEnumeratorProperties* tep)
{
  switch (type.getKind())
  {
    case kind::TYPE_CONSTANT:
      switch (type.getConst<TypeConstant>())
      {
        
#line 27 "/build/cvc4/src/cvc5-1.8/src/theory/booleans/kinds"
    case BOOLEAN_TYPE:
#line 27 "/build/cvc4/src/cvc5-1.8/src/theory/booleans/kinds"
      return new ::CVC4::theory::booleans::BooleanEnumerator(type, tep);

#line 71 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
    case REAL_TYPE:
#line 71 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
      return new ::CVC4::theory::arith::RationalEnumerator(type, tep);

#line 74 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
    case INTEGER_TYPE:
#line 74 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
      return new ::CVC4::theory::arith::IntegerEnumerator(type, tep);

#line 41 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    case ROUNDINGMODE_TYPE:
#line 41 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
      return new ::CVC4::theory::fp::RoundingModeEnumerator(type, tep);

#line 55 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    case STRING_TYPE:
#line 55 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
      return new ::CVC4::theory::strings::StringEnumerator(type, tep);

        default: Unhandled() << "No type enumerator for type `" << type << "'";
      }
      Unreachable();
      
#line 271 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
  case kind::SORT_TYPE:
#line 271 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    return new ::CVC4::theory::builtin::UninterpretedSortEnumerator(type, tep);

#line 316 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
  case kind::FUNCTION_TYPE:
#line 316 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    return new ::CVC4::theory::builtin::FunctionEnumerator(type, tep);

#line 30 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  case kind::BITVECTOR_TYPE:
#line 30 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    return new ::CVC4::theory::bv::BitVectorEnumerator(type, tep);

#line 57 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  case kind::FLOATINGPOINT_TYPE:
#line 57 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    return new ::CVC4::theory::fp::FloatingPointEnumerator(type, tep);

#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/arrays/kinds"
  case kind::ARRAY_TYPE:
#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/arrays/kinds"
    return new ::CVC4::theory::arrays::ArrayEnumerator(type, tep);

#line 54 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
  case kind::DATATYPE_TYPE:
#line 54 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    return new ::CVC4::theory::datatypes::DatatypesEnumerator(type, tep);

#line 67 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
  case kind::PARAMETRIC_DATATYPE:
#line 67 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    return new ::CVC4::theory::datatypes::DatatypesEnumerator(type, tep);

#line 33 "/build/cvc4/src/cvc5-1.8/src/theory/sets/kinds"
  case kind::SET_TYPE:
#line 33 "/build/cvc4/src/cvc5-1.8/src/theory/sets/kinds"
    return new ::CVC4::theory::sets::SetEnumerator(type, tep);

#line 74 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
  case kind::SEQUENCE_TYPE:
#line 74 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    return new ::CVC4::theory::strings::SequenceEnumerator(type, tep);

#line 46 "/build/cvc4/src/cvc5-1.8/src/theory/type_enumerator_template.cpp"
    default: Unhandled() << "No type enumerator for type `" << type << "'";
  }
  Unreachable();
}

}/* CVC4::theory namespace */
}/* CVC4 namespace */
