/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__DATATYPES_H
#define CVC4__OPTIONS__DATATYPES_H

#include "options/options.h"




#define CVC4_OPTIONS__DATATYPES__FOR_OPTION_HOLDER \
  cdtBisimilar__option_t::type cdtBisimilar;\
  bool cdtBisimilar__setByUser__; \
  dtBinarySplit__option_t::type dtBinarySplit;\
  bool dtBinarySplit__setByUser__; \
  dtBlastSplits__option_t::type dtBlastSplits;\
  bool dtBlastSplits__setByUser__; \
  dtCyclic__option_t::type dtCyclic;\
  bool dtCyclic__setByUser__; \
  dtForceAssignment__option_t::type dtForceAssignment;\
  bool dtForceAssignment__setByUser__; \
  dtInferAsLemmas__option_t::type dtInferAsLemmas;\
  bool dtInferAsLemmas__setByUser__; \
  dtNestedRec__option_t::type dtNestedRec;\
  bool dtNestedRec__setByUser__; \
  dtRewriteErrorSel__option_t::type dtRewriteErrorSel;\
  bool dtRewriteErrorSel__setByUser__; \
  dtSharedSelectors__option_t::type dtSharedSelectors;\
  bool dtSharedSelectors__setByUser__; \
  sygusAbortSize__option_t::type sygusAbortSize;\
  bool sygusAbortSize__setByUser__; \
  sygusFairMax__option_t::type sygusFairMax;\
  bool sygusFairMax__setByUser__; \
  sygusFair__option_t::type sygusFair;\
  bool sygusFair__setByUser__; \
  sygusSymBreak__option_t::type sygusSymBreak;\
  bool sygusSymBreak__setByUser__; \
  sygusSymBreakAgg__option_t::type sygusSymBreakAgg;\
  bool sygusSymBreakAgg__setByUser__; \
  sygusSymBreakDynamic__option_t::type sygusSymBreakDynamic;\
  bool sygusSymBreakDynamic__setByUser__; \
  sygusSymBreakLazy__option_t::type sygusSymBreakLazy;\
  bool sygusSymBreakLazy__setByUser__; \
  sygusSymBreakPbe__option_t::type sygusSymBreakPbe;\
  bool sygusSymBreakPbe__setByUser__; \
  sygusSymBreakRlv__option_t::type sygusSymBreakRlv;\
  bool sygusSymBreakRlv__setByUser__;


namespace CVC4 {

namespace options {


enum class SygusFairMode
{
  DIRECT,
  DT_SIZE,
  DT_HEIGHT_PRED,
  DT_SIZE_PRED,
  NONE
};
std::ostream&
operator<<(std::ostream& os, SygusFairMode mode) CVC4_PUBLIC;
SygusFairMode
stringToSygusFairMode(const std::string& option, const std::string& optarg);

extern struct CVC4_PUBLIC cdtBisimilar__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cdtBisimilar CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtBinarySplit__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtBinarySplit CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtBlastSplits__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtBlastSplits CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtCyclic__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtCyclic CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtForceAssignment__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} dtForceAssignment CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtInferAsLemmas__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtInferAsLemmas CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtNestedRec__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtNestedRec CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtRewriteErrorSel__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} dtRewriteErrorSel CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtSharedSelectors__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtSharedSelectors CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusAbortSize__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusAbortSize CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusFairMax__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusFairMax CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusFair__option_t
{
  typedef SygusFairMode type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusFair CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSymBreak__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusSymBreak CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSymBreakAgg__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusSymBreakAgg CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSymBreakDynamic__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusSymBreakDynamic CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSymBreakLazy__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusSymBreakLazy CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSymBreakPbe__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusSymBreakPbe CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSymBreakRlv__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusSymBreakRlv CVC4_PUBLIC;

}  // namespace options

template <> const options::cdtBisimilar__option_t::type& Options::operator[](
    options::cdtBisimilar__option_t) const;
template <> bool Options::wasSetByUser(options::cdtBisimilar__option_t) const;
template <> void Options::assignBool(
    options::cdtBisimilar__option_t,
    std::string option,
    bool value);
template <> const options::dtBinarySplit__option_t::type& Options::operator[](
    options::dtBinarySplit__option_t) const;
template <> bool Options::wasSetByUser(options::dtBinarySplit__option_t) const;
template <> void Options::assignBool(
    options::dtBinarySplit__option_t,
    std::string option,
    bool value);
template <> const options::dtBlastSplits__option_t::type& Options::operator[](
    options::dtBlastSplits__option_t) const;
template <> bool Options::wasSetByUser(options::dtBlastSplits__option_t) const;
template <> void Options::assignBool(
    options::dtBlastSplits__option_t,
    std::string option,
    bool value);
template <> const options::dtCyclic__option_t::type& Options::operator[](
    options::dtCyclic__option_t) const;
template <> bool Options::wasSetByUser(options::dtCyclic__option_t) const;
template <> void Options::assignBool(
    options::dtCyclic__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::dtForceAssignment__option_t,
    const options::dtForceAssignment__option_t::type& x);
template <> const options::dtForceAssignment__option_t::type& Options::operator[](
    options::dtForceAssignment__option_t) const;
template <> bool Options::wasSetByUser(options::dtForceAssignment__option_t) const;
template <> void Options::assignBool(
    options::dtForceAssignment__option_t,
    std::string option,
    bool value);
template <> const options::dtInferAsLemmas__option_t::type& Options::operator[](
    options::dtInferAsLemmas__option_t) const;
template <> bool Options::wasSetByUser(options::dtInferAsLemmas__option_t) const;
template <> void Options::assignBool(
    options::dtInferAsLemmas__option_t,
    std::string option,
    bool value);
template <> const options::dtNestedRec__option_t::type& Options::operator[](
    options::dtNestedRec__option_t) const;
template <> bool Options::wasSetByUser(options::dtNestedRec__option_t) const;
template <> void Options::assignBool(
    options::dtNestedRec__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::dtRewriteErrorSel__option_t,
    const options::dtRewriteErrorSel__option_t::type& x);
template <> const options::dtRewriteErrorSel__option_t::type& Options::operator[](
    options::dtRewriteErrorSel__option_t) const;
template <> bool Options::wasSetByUser(options::dtRewriteErrorSel__option_t) const;
template <> void Options::assignBool(
    options::dtRewriteErrorSel__option_t,
    std::string option,
    bool value);
template <> const options::dtSharedSelectors__option_t::type& Options::operator[](
    options::dtSharedSelectors__option_t) const;
template <> bool Options::wasSetByUser(options::dtSharedSelectors__option_t) const;
template <> void Options::assignBool(
    options::dtSharedSelectors__option_t,
    std::string option,
    bool value);
template <> const options::sygusAbortSize__option_t::type& Options::operator[](
    options::sygusAbortSize__option_t) const;
template <> bool Options::wasSetByUser(options::sygusAbortSize__option_t) const;
template <> void Options::assign(
    options::sygusAbortSize__option_t,
    std::string option,
    std::string value);
template <> const options::sygusFairMax__option_t::type& Options::operator[](
    options::sygusFairMax__option_t) const;
template <> bool Options::wasSetByUser(options::sygusFairMax__option_t) const;
template <> void Options::assignBool(
    options::sygusFairMax__option_t,
    std::string option,
    bool value);
template <> const options::sygusFair__option_t::type& Options::operator[](
    options::sygusFair__option_t) const;
template <> bool Options::wasSetByUser(options::sygusFair__option_t) const;
template <> void Options::assign(
    options::sygusFair__option_t,
    std::string option,
    std::string value);
template <> const options::sygusSymBreak__option_t::type& Options::operator[](
    options::sygusSymBreak__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSymBreak__option_t) const;
template <> void Options::assignBool(
    options::sygusSymBreak__option_t,
    std::string option,
    bool value);
template <> const options::sygusSymBreakAgg__option_t::type& Options::operator[](
    options::sygusSymBreakAgg__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSymBreakAgg__option_t) const;
template <> void Options::assignBool(
    options::sygusSymBreakAgg__option_t,
    std::string option,
    bool value);
template <> const options::sygusSymBreakDynamic__option_t::type& Options::operator[](
    options::sygusSymBreakDynamic__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSymBreakDynamic__option_t) const;
template <> void Options::assignBool(
    options::sygusSymBreakDynamic__option_t,
    std::string option,
    bool value);
template <> const options::sygusSymBreakLazy__option_t::type& Options::operator[](
    options::sygusSymBreakLazy__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSymBreakLazy__option_t) const;
template <> void Options::assignBool(
    options::sygusSymBreakLazy__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusSymBreakPbe__option_t,
    const options::sygusSymBreakPbe__option_t::type& x);
template <> const options::sygusSymBreakPbe__option_t::type& Options::operator[](
    options::sygusSymBreakPbe__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSymBreakPbe__option_t) const;
template <> void Options::assignBool(
    options::sygusSymBreakPbe__option_t,
    std::string option,
    bool value);
template <> const options::sygusSymBreakRlv__option_t::type& Options::operator[](
    options::sygusSymBreakRlv__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSymBreakRlv__option_t) const;
template <> void Options::assignBool(
    options::sygusSymBreakRlv__option_t,
    std::string option,
    bool value);


namespace options {

inline cdtBisimilar__option_t::type cdtBisimilar__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cdtBisimilar__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtBinarySplit__option_t::type dtBinarySplit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtBinarySplit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtBlastSplits__option_t::type dtBlastSplits__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtBlastSplits__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtCyclic__option_t::type dtCyclic__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtCyclic__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtForceAssignment__option_t::type dtForceAssignment__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtForceAssignment__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void dtForceAssignment__option_t::set(const dtForceAssignment__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline dtInferAsLemmas__option_t::type dtInferAsLemmas__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtInferAsLemmas__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtNestedRec__option_t::type dtNestedRec__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtNestedRec__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtRewriteErrorSel__option_t::type dtRewriteErrorSel__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtRewriteErrorSel__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void dtRewriteErrorSel__option_t::set(const dtRewriteErrorSel__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline dtSharedSelectors__option_t::type dtSharedSelectors__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtSharedSelectors__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusAbortSize__option_t::type sygusAbortSize__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusAbortSize__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusFairMax__option_t::type sygusFairMax__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusFairMax__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusFair__option_t::type sygusFair__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusFair__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusSymBreak__option_t::type sygusSymBreak__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSymBreak__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusSymBreakAgg__option_t::type sygusSymBreakAgg__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSymBreakAgg__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusSymBreakDynamic__option_t::type sygusSymBreakDynamic__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSymBreakDynamic__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusSymBreakLazy__option_t::type sygusSymBreakLazy__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSymBreakLazy__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusSymBreakPbe__option_t::type sygusSymBreakPbe__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSymBreakPbe__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusSymBreakPbe__option_t::set(const sygusSymBreakPbe__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusSymBreakRlv__option_t::type sygusSymBreakRlv__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSymBreakRlv__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__DATATYPES_H */
