// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <bpkg/types-parsers.hxx>
//
// End prologue.

#include <bpkg/cfg-create-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace bpkg
{
  namespace cli
  {
    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (X& b, const X& a)
      {
        b = a;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (bool& b, const bool&)
      {
        b = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::string& b, const std::string& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }

      static void
      merge (std::pair<X, std::size_t>& b, const std::pair<X, std::size_t>& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }

      static void
      merge (std::vector<X>& b, const std::vector<X>& a)
      {
        b.insert (b.end (), a.begin (), a.end ());
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }

      static void
      merge (std::set<X, C>& b, const std::set<X, C>& a)
      {
        b.insert (a.begin (), a.end ());
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::map<K, V, C>& b, const std::map<K, V, C>& a)
      {
        for (typename std::map<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b[i->first] = i->second;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::multimap<K, V, C>& b, const std::multimap<K, V, C>& a)
      {
        for (typename std::multimap<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b.insert (typename std::multimap<K, V, C>::value_type (i->first,
                                                                 i->second));
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace bpkg
{
  // cfg_create_options
  //

  cfg_create_options::
  cfg_create_options ()
  : directory_ ("."),
    directory_specified_ (false),
    existing_ (),
    wipe_ (),
    host_config_ (),
    host_config_specified_ (false),
    no_host_config_ (),
    build2_config_ (),
    build2_config_specified_ (false),
    no_build2_config_ (),
    name_ (),
    name_specified_ (false),
    type_ ("target"),
    type_specified_ (false),
    uuid_ (),
    uuid_specified_ (false)
  {
  }

  bool cfg_create_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    ::bpkg::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cfg_create_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    ::bpkg::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cfg_create_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    ::bpkg::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cfg_create_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    ::bpkg::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cfg_create_options::
  parse (::bpkg::cli::scanner& s,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cfg_create_options::
  merge (const cfg_create_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    // common_options base
    //
    ::bpkg::common_options::merge (a);

    if (a.directory_specified_)
    {
      ::bpkg::cli::parser< dir_path>::merge (
        this->directory_, a.directory_);
      this->directory_specified_ = true;
    }

    if (a.existing_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->existing_, a.existing_);
    }

    if (a.wipe_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->wipe_, a.wipe_);
    }

    if (a.host_config_specified_)
    {
      ::bpkg::cli::parser< dir_path>::merge (
        this->host_config_, a.host_config_);
      this->host_config_specified_ = true;
    }

    if (a.no_host_config_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->no_host_config_, a.no_host_config_);
    }

    if (a.build2_config_specified_)
    {
      ::bpkg::cli::parser< dir_path>::merge (
        this->build2_config_, a.build2_config_);
      this->build2_config_specified_ = true;
    }

    if (a.no_build2_config_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->no_build2_config_, a.no_build2_config_);
    }

    if (a.name_specified_)
    {
      ::bpkg::cli::parser< string>::merge (
        this->name_, a.name_);
      this->name_specified_ = true;
    }

    if (a.type_specified_)
    {
      ::bpkg::cli::parser< string>::merge (
        this->type_, a.type_);
      this->type_specified_ = true;
    }

    if (a.uuid_specified_)
    {
      ::bpkg::cli::parser< uuid_type>::merge (
        this->uuid_, a.uuid_);
      this->uuid_specified_ = true;
    }
  }

  ::bpkg::cli::usage_para cfg_create_options::
  print_usage (::std::ostream& os, ::bpkg::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bpkg::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mCFG-CREATE OPTIONS\033[0m" << ::std::endl;

    os << std::endl
       << "\033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mdir\033[0m        Create the configuration in \033[4mdir\033[0m rather than in the" << ::std::endl
       << "                          current working directory." << ::std::endl;

    os << std::endl
       << "\033[1m--existing\033[0m|\033[1m-e\033[0m             Initialize a \033[1mbpkg\033[0m configuration based on an existing" << ::std::endl
       << "                          build system configuration." << ::std::endl;

    os << std::endl
       << "\033[1m--wipe\033[0m                    Wipe the configuration directory clean before" << ::std::endl
       << "                          creating the new configuration. For safety, this" << ::std::endl
       << "                          option requires that you specify the configuration" << ::std::endl
       << "                          directory explicitly with \033[1m--directory|-d\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--host-config\033[0m \033[4mdir\033[0m         Link the specified host configuration with the" << ::std::endl
       << "                          configuration being created as if by running the" << ::std::endl
       << "                          \033[1mbpkg-cfg-link(1)\033[0m command." << ::std::endl;

    os << std::endl
       << "\033[1m--no-host-config\033[0m          Ignore any specified \033[1m--host-config\033[0m options." << ::std::endl;

    os << std::endl
       << "\033[1m--build2-config\033[0m \033[4mdir\033[0m       Link the specified build system module configuration" << ::std::endl
       << "                          with the configuration being created as if by running" << ::std::endl
       << "                          the \033[1mbpkg-cfg-link(1)\033[0m command." << ::std::endl;

    os << std::endl
       << "\033[1m--no-build2-config\033[0m        Ignore any specified \033[1m--build2-config\033[0m options." << ::std::endl;

    os << std::endl
       << "\033[1m--name\033[0m \033[4mname\033[0m               The name of the configuration being created. If this" << ::std::endl
       << "                          configuration is linked with another configuration" << ::std::endl
       << "                          using \033[1mbpkg-cfg-link(1)\033[0m, this name will be used as the" << ::std::endl
       << "                          link name unless overridden. By default the" << ::std::endl
       << "                          configuration is created unnamed." << ::std::endl;

    os << std::endl
       << "\033[1m--type\033[0m \033[4mtype\033[0m               The type of the configuration being created. By" << ::std::endl
       << "                          default, configuration of type \033[1mtarget\033[0m is created." << ::std::endl;

    os << std::endl
       << "\033[1m--uuid\033[0m \033[4muuid\033[0m               Use the specified UUID as the configuration id" << ::std::endl
       << "                          instead of generating one automatically." << ::std::endl;

    p = ::bpkg::cli::usage_para::option;

    // common_options base
    //
    p = ::bpkg::common_options::print_usage (os, p);

    return p;
  }

  typedef
  std::map<std::string, void (*) (cfg_create_options&, ::bpkg::cli::scanner&)>
  _cli_cfg_create_options_map;

  static _cli_cfg_create_options_map _cli_cfg_create_options_map_;

  struct _cli_cfg_create_options_map_init
  {
    _cli_cfg_create_options_map_init ()
    {
      _cli_cfg_create_options_map_["--directory"] =
      &::bpkg::cli::thunk< cfg_create_options, dir_path, &cfg_create_options::directory_,
        &cfg_create_options::directory_specified_ >;
      _cli_cfg_create_options_map_["-d"] =
      &::bpkg::cli::thunk< cfg_create_options, dir_path, &cfg_create_options::directory_,
        &cfg_create_options::directory_specified_ >;
      _cli_cfg_create_options_map_["--existing"] =
      &::bpkg::cli::thunk< cfg_create_options, &cfg_create_options::existing_ >;
      _cli_cfg_create_options_map_["-e"] =
      &::bpkg::cli::thunk< cfg_create_options, &cfg_create_options::existing_ >;
      _cli_cfg_create_options_map_["--wipe"] =
      &::bpkg::cli::thunk< cfg_create_options, &cfg_create_options::wipe_ >;
      _cli_cfg_create_options_map_["--host-config"] =
      &::bpkg::cli::thunk< cfg_create_options, dir_path, &cfg_create_options::host_config_,
        &cfg_create_options::host_config_specified_ >;
      _cli_cfg_create_options_map_["--no-host-config"] =
      &::bpkg::cli::thunk< cfg_create_options, &cfg_create_options::no_host_config_ >;
      _cli_cfg_create_options_map_["--build2-config"] =
      &::bpkg::cli::thunk< cfg_create_options, dir_path, &cfg_create_options::build2_config_,
        &cfg_create_options::build2_config_specified_ >;
      _cli_cfg_create_options_map_["--no-build2-config"] =
      &::bpkg::cli::thunk< cfg_create_options, &cfg_create_options::no_build2_config_ >;
      _cli_cfg_create_options_map_["--name"] =
      &::bpkg::cli::thunk< cfg_create_options, string, &cfg_create_options::name_,
        &cfg_create_options::name_specified_ >;
      _cli_cfg_create_options_map_["--type"] =
      &::bpkg::cli::thunk< cfg_create_options, string, &cfg_create_options::type_,
        &cfg_create_options::type_specified_ >;
      _cli_cfg_create_options_map_["--uuid"] =
      &::bpkg::cli::thunk< cfg_create_options, uuid_type, &cfg_create_options::uuid_,
        &cfg_create_options::uuid_specified_ >;
    }
  };

  static _cli_cfg_create_options_map_init _cli_cfg_create_options_map_init_;

  bool cfg_create_options::
  _parse (const char* o, ::bpkg::cli::scanner& s)
  {
    _cli_cfg_create_options_map::const_iterator i (_cli_cfg_create_options_map_.find (o));

    if (i != _cli_cfg_create_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    // common_options base
    //
    if (::bpkg::common_options::_parse (o, s))
      return true;

    return false;
  }

  bool cfg_create_options::
  _parse (::bpkg::cli::scanner& s,
          ::bpkg::cli::unknown_mode opt_mode,
          ::bpkg::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bpkg::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bpkg::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bpkg::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bpkg::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bpkg::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bpkg::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bpkg::cli::unknown_mode::fail:
            {
              throw ::bpkg::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bpkg::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bpkg::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bpkg::cli::unknown_mode::fail:
        {
          throw ::bpkg::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }
}

namespace bpkg
{
  ::bpkg::cli::usage_para
  print_bpkg_cfg_create_usage (::std::ostream& os, ::bpkg::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bpkg::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mbpkg cfg-create\033[0m|\033[1mcreate\033[0m [\033[4moptions\033[0m] [\033[4mcfg-args\033[0m]" << ::std::endl
       << "\033[1mbpkg cfg-create\033[0m|\033[1mcreate\033[0m [\033[4moptions\033[0m] \033[1m--existing|-e\033[0m\033[0m" << ::std::endl
       << ::std::endl
       << "\033[4mcfg-args\033[0m = (\033[4mmodule\033[0m | \033[4mcfg-var\033[0m)...\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mDESCRIPTION\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mcfg-create\033[0m command creates a new \033[1mbpkg\033[0m configuration with the specified" << ::std::endl
       << "\033[1mbuild2\033[0m modules and configuration variables (the first form) or initializes one" << ::std::endl
       << "based on an existing build system configuration (the second form). The \033[1mbpkg\033[0m" << ::std::endl
       << "configuration itself is a build system configuration; see build system driver" << ::std::endl
       << "(\033[1mb(1)\033[0m) \033[1mcreate\033[0m meta-operation for details." << ::std::endl
       << ::std::endl
       << "Unless the \033[1m--existing|-e\033[0m or \033[1m--wipe\033[0m option is specified, \033[1mcfg-create\033[0m expects the" << ::std::endl
       << "configuration directory to be empty or to not exist (in which case it will be" << ::std::endl
       << "created)." << ::std::endl
       << ::std::endl
       << "By default, the configuration created with the first form loads the \033[1mconfig\033[0m," << ::std::endl
       << "\033[1mtest\033[0m, \033[1mdist\033[0m, and \033[1minstall\033[0m modules. However, additional modules and, if required," << ::std::endl
       << "their configuration variables can be specified as the \033[1mcfg-create\033[0m arguments. For" << ::std::endl
       << "example:" << ::std::endl
       << ::std::endl
       << "bpkg create cxx config.cxx=clang++ config.install.root=/usr/local" << ::std::endl
       << ::std::endl
       << "By default, \033[1mbpkg\033[0m appends \033[1m.config\033[0m to the names of the modules that you specify" << ::std::endl
       << "so that only their configurations are loaded. You can override this behavior by" << ::std::endl
       << "specifying the period (\033[1m.\033[0m) after the module name. You can also instruct \033[1mbpkg\033[0m to" << ::std::endl
       << "use the optional module load by prefixing the module name with the question" << ::std::endl
       << "mark (\033[1m?\033[0m). For example:" << ::std::endl
       << ::std::endl
       << "bpkg create cxx. \"?cli\"" << ::std::endl
       << ::std::endl
       << "Configurations can be linked with each other to allow a package to be built in" << ::std::endl
       << "one configuration while its dependencies in one or more linked configurations." << ::std::endl
       << "This can be used to create a \"base\" configuration with common dependencies that" << ::std::endl
       << "are shared between multiple configurations. This mechanism is also used to" << ::std::endl
       << "provide a host configuration that is used to build build-time dependencies." << ::std::endl
       << ::std::endl
       << "Each configuration is assigned an automatically-generated UUID unless one is" << ::std::endl
       << "specified with the \033[1m--uuid\033[0m option. This UUID is used to check the integrity of" << ::std::endl
       << "configuration links. For convenience of referring to linked configurations, a" << ::std::endl
       << "configuration can also be assigned a name with the \033[1m--name\033[0m option." << ::std::endl
       << ::std::endl
       << "A configuration also has a type specified with the \033[1m--type\033[0m option. Three" << ::std::endl
       << "predefined types are \033[1mtarget\033[0m, \033[1mhost\033[0m, and \033[1mbuild2\033[0m. If the type is not specified" << ::std::endl
       << "explicitly, then \033[1mtarget\033[0m is assumed. When satisfying a dependency of one package" << ::std::endl
       << "on another, a linked configuration will only be considered if (1) it has the" << ::std::endl
       << "same type as the other configuration for run-time dependencies, (2) it has the" << ::std::endl
       << "\033[1mhost\033[0m type for regular build-time dependencies, and (3) it has the \033[1mbuild2\033[0m type" << ::std::endl
       << "for build system module build-time dependencies. Note that a host configuration" << ::std::endl
       << "is a target configuration for the host machine. So to create a self-hosted" << ::std::endl
       << "configuration, use type \033[1mhost\033[0m." << ::std::endl
       << ::std::endl
       << "To link a configuration we use the \033[1mbpkg-cfg-link(1)\033[0m command. As a shortcut," << ::std::endl
       << "host and build system module configurations can also be linked during the" << ::std::endl
       << "configuration creation with the \033[1m--host-config\033[0m and \033[1m--build2-config\033[0m options," << ::std::endl
       << "respectively. If a build-time dependency is encountered in a configuration that" << ::std::endl
       << "has no linked configuration of a suitable type (\033[1mhost\033[0m or \033[1mbuild2\033[0m, nor is itself" << ::std::endl
       << "of a suitable type), then a private host or build system module configuration" << ::std::endl
       << "named \033[1mhost\033[0m or \033[1mbuild2\033[0m, respectively, is created automatically inside the" << ::std::endl
       << "configuration's .bpkg/\033[0m subdirectory." << ::std::endl;

    p = ::bpkg::cfg_create_options::print_usage (os, ::bpkg::cli::usage_para::text);

    if (p != ::bpkg::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mDEFAULT OPTIONS FILES\033[0m" << ::std::endl
       << ::std::endl
       << "See \033[1mbpkg-default-options-files(1)\033[0m for an overview of the default options files." << ::std::endl
       << "For the \033[1mcfg-create\033[0m command the search start directory is the parent directory" << ::std::endl
       << "of the new configuration. The following options files are searched for in each" << ::std::endl
       << "directory and, if found, loaded in the order listed:" << ::std::endl
       << ::std::endl
       << "bpkg.options" << ::std::endl
       << "bpkg-cfg-create.options" << ::std::endl
       << ::std::endl
       << "The following \033[1mcfg-create\033[0m command options cannot be specified in the default" << ::std::endl
       << "options files:" << ::std::endl
       << ::std::endl
       << "--directory|-d" << ::std::endl
       << "--wipe" << ::std::endl;

    p = ::bpkg::cli::usage_para::text;

    return p;
  }
}

// Begin epilogue.
//
//
// End epilogue.

