/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 2)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned short *)((p) + 0 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k1(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 1) {
		unsigned short ova0;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k1_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->prec = 8;
	g->id = 1;
	g->od = 1;
	g->irep = 1;
	g->orep = 1;
	g->in.bpch[0] = 8;
	g->in.chi[0] = 1;
	g->in.bpv[0] = 8;
	g->in.pint = 1;
	g->out.bpch[0] = 8;
	g->out.chi[0] = 1;
	g->out.bpv[0] = 8;
	g->out.pint = 1;
	g->opt = 17;
	g->itres = 255;
	g->stres = 1;
	g->kkeys[0] = 67;
	g->kkeys[1] = 111;
	g->kkeys[2] = 112;
	g->kkeys[3] = 121;
	g->kkeys[4] = 114;
	g->kkeys[5] = 105;
	g->kkeys[6] = 103;
	g->kkeys[7] = 104;
	g->kkeys[8] = 116;
	g->kkeys[9] = 32;
	g->kkeys[10] = 50;
	g->kkeys[11] = 48;
	g->kkeys[12] = 48;
	g->kkeys[13] = 52;
	g->kkeys[14] = 32;
	g->kkeys[15] = 71;
	g->kkeys[16] = 114;
	g->kkeys[17] = 97;
	g->kkeys[18] = 101;
	g->kkeys[19] = 109;
	g->kkeys[20] = 101;
	g->kkeys[21] = 32;
	g->kkeys[22] = 87;
	g->kkeys[23] = 46;
	g->kkeys[24] = 32;
	g->kkeys[25] = 71;
	g->kkeys[26] = 105;
	g->kkeys[27] = 108;
	g->kkeys[28] = 108;
	g->kdesc[0] = 49;
	g->kdesc[1] = 95;
	g->kdesc[2] = 49;
	g->kdesc[3] = 95;
	g->kdesc[4] = 105;
	g->kdesc[5] = 56;
	g->kdesc[6] = 95;
	g->kdesc[7] = 105;
	g->kdesc[8] = 56;
	g->kdesc[9] = 95;
	g->kdesc[10] = 102;
	g->kname[0] = 105;
	g->kname[1] = 109;
	g->kname[2] = 100;
	g->kname[3] = 105;
	g->kname[4] = 95;
	g->kname[5] = 107;
	g->kname[6] = 49;
	t->it_ix = 1;
	t->it_ab = 8;
	t->it_ts = 1;
	t->ix_ab = 8;
	t->sm_ts = 4;
	t->wo_ab = 16;
	t->wo_es = 2;
	t->we_ab = 9;
	t->vo_ab = 7;
	t->vo_om = 1;
	t->im_cd = 1;
	t->im_ts = 2;
	t->im_oc = 2;
	t->im_fs = 8;
	t->im_fv = 4;
	t->im_ps = 2;
	t->im_pn = 1;
	t->im_pv = 1;
	t->ot_ts = 1;
	t->ot_bits[0] = 8;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 0
   Interpolation table index bits = 16
   Interpolation table max resolution = 65535

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 2)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned short *)((p) + 0 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k2(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 1) {
		unsigned short ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = (ti & 0xffff);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 16);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7f);	/* Extract offset value */
				wo0 = (wo0 >> 7);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo0;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k2_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 65535;
	g->stres = 0;
	g->kname[6] = 50;
	t->sort = 1;
	t->it_ab = 32;
	t->it_ts = 4;
	t->ix_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 2)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned short *)((p) + 0 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k3(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 1) {
		unsigned short ova0;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k3_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 3;
	g->in.chi[0] = 3;
	g->in.bpch[1] = 8;
	g->in.chi[1] = 3;
	g->in.bpv[1] = 8;
	g->in.bpch[2] = 8;
	g->in.chi[2] = 3;
	g->in.bpv[2] = 8;
	g->itres = 101;
	g->stres = 16;
	g->kdesc[0] = 51;
	g->kname[6] = 51;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 20;
	t->sx_ab = 12;
	t->sm_ts = 16;
	t->wo_es = 4;
	t->we_ab = 16;
	t->we_es = 2;
	t->vo_ab = 16;
	t->vo_es = 2;
	t->vo_eo = 2;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 12
   Interpolation table index bits = 30
   Interpolation table max resolution = 1024

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 2)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned short *)((p) + 0 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k4(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 1) {
		unsigned short ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo1, wo2);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x1ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 25);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x1ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 25);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x1ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 25);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo2;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k4_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 1024;
	g->stres = 0;
	g->kname[6] = 52;
	t->sort = 1;
	t->wo_xs = 0;
	t->it_ab = 64;
	t->it_ts = 8;
	t->ix_ab = 30;
	t->wo_ab = 34;
	t->we_ab = 9;
	t->vo_ab = 25;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 39

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 2)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned short *)((p) + 0 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k5(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 1) {
		unsigned short ova0;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned longlong ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				ti += IT_IT(it3, ip0[3]);
				
				imp = im_base + IM_O(ti >> 32);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xffffffff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k5_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 4;
	g->in.chi[0] = 4;
	g->in.chi[1] = 4;
	g->in.chi[2] = 4;
	g->in.bpch[3] = 8;
	g->in.chi[3] = 4;
	g->in.bpv[3] = 8;
	g->itres = 39;
	g->stres = 255;
	g->kdesc[0] = 52;
	g->kname[6] = 53;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 32;
	t->sx_ab = 32;
	t->sm_ts = 20;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 30
   Interpolation table max resolution = 181

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 2)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned short *)((p) + 0 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k6(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 1) {
		unsigned short ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x1ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 25);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x1ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 25);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x1ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 25);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x1ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 25);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo3;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k6_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 181;
	g->stres = 0;
	g->kname[6] = 54;
	t->sort = 1;
	t->wo_xs = 0;
	t->ix_ab = 30;
	t->we_ab = 9;
	t->vo_ab = 25;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 55

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 2)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned short *)((p) + 0 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k7(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 5, op0 += 1) {
		unsigned short ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k7_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 5;
	g->in.chi[0] = 5;
	g->in.chi[1] = 5;
	g->in.chi[2] = 5;
	g->in.chi[3] = 5;
	g->in.bpch[4] = 8;
	g->in.chi[4] = 5;
	g->in.bpv[4] = 8;
	g->opt = 1;
	g->itres = 55;
	g->stres = 0;
	g->kdesc[0] = 53;
	g->kname[6] = 55;
	t->ix_ab = 29;
	t->wo_ab = 35;
	t->vo_ab = 26;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 28

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 2)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned short *)((p) + 0 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k8(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 6, op0 += 1) {
		unsigned short ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k8_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 6;
	g->in.chi[0] = 6;
	g->in.chi[1] = 6;
	g->in.chi[2] = 6;
	g->in.chi[3] = 6;
	g->in.chi[4] = 6;
	g->in.bpch[5] = 8;
	g->in.chi[5] = 6;
	g->in.bpv[5] = 8;
	g->opt = 1;
	g->itres = 28;
	g->stres = 0;
	g->kdesc[0] = 54;
	g->kname[6] = 56;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 17

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 2)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned short *)((p) + 0 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k9(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 7, op0 += 1) {
		unsigned short ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k9_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 7;
	g->in.chi[0] = 7;
	g->in.chi[1] = 7;
	g->in.chi[2] = 7;
	g->in.chi[3] = 7;
	g->in.chi[4] = 7;
	g->in.chi[5] = 7;
	g->in.bpch[6] = 8;
	g->in.chi[6] = 7;
	g->in.bpv[6] = 8;
	g->opt = 1;
	g->itres = 17;
	g->stres = 0;
	g->kdesc[0] = 55;
	g->kname[6] = 57;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 12

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 2)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned short *)((p) + 0 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k10(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 8, op0 += 1) {
		unsigned short ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x3ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 26);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k10_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 8;
	g->in.chi[0] = 8;
	g->in.chi[1] = 8;
	g->in.chi[2] = 8;
	g->in.chi[3] = 8;
	g->in.chi[4] = 8;
	g->in.chi[5] = 8;
	g->in.chi[6] = 8;
	g->in.bpch[7] = 8;
	g->in.chi[7] = 8;
	g->in.bpv[7] = 8;
	g->opt = 1;
	g->itres = 12;
	g->stres = 0;
	g->kdesc[0] = 56;
	g->kname[6] = 49;
	g->kname[7] = 48;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 9
   Input channel 0 bits = 8
   Input channel 0 increment = 9
   Input channel 1 bits = 8
   Input channel 1 increment = 9
   Input channel 2 bits = 8
   Input channel 2 increment = 9
   Input channel 3 bits = 8
   Input channel 3 increment = 9
   Input channel 4 bits = 8
   Input channel 4 increment = 9
   Input channel 5 bits = 8
   Input channel 5 increment = 9
   Input channel 6 bits = 8
   Input channel 6 increment = 9
   Input channel 7 bits = 8
   Input channel 7 increment = 9
   Input channel 8 bits = 8
   Input channel 8 increment = 9
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 9

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 2)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned short *)((p) + 0 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k11(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 9 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 9, op0 += 1) {
		unsigned short ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x3ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 26);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0x3ffffff);	/* Extract offset value */
				wo8 = (wo8 >> 26);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo8;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k11_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 9;
	g->in.chi[0] = 9;
	g->in.chi[1] = 9;
	g->in.chi[2] = 9;
	g->in.chi[3] = 9;
	g->in.chi[4] = 9;
	g->in.chi[5] = 9;
	g->in.chi[6] = 9;
	g->in.chi[7] = 9;
	g->in.bpch[8] = 8;
	g->in.chi[8] = 9;
	g->in.bpv[8] = 8;
	g->opt = 1;
	g->itres = 9;
	g->stres = 0;
	g->kdesc[0] = 57;
	g->kname[7] = 49;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 10
   Input channel 0 bits = 8
   Input channel 0 increment = 10
   Input channel 1 bits = 8
   Input channel 1 increment = 10
   Input channel 2 bits = 8
   Input channel 2 increment = 10
   Input channel 3 bits = 8
   Input channel 3 increment = 10
   Input channel 4 bits = 8
   Input channel 4 increment = 10
   Input channel 5 bits = 8
   Input channel 5 increment = 10
   Input channel 6 bits = 8
   Input channel 6 increment = 10
   Input channel 7 bits = 8
   Input channel 7 increment = 10
   Input channel 8 bits = 8
   Input channel 8 increment = 10
   Input channel 9 bits = 8
   Input channel 9 increment = 10
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 7

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 2)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned short *)((p) + 0 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k12(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 10 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer it9 = (pointer)p->in_tables[9];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 10, op0 += 1) {
		unsigned short ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			unsigned longlong wo9;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it9, ip0[9]);
				wo9   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
					XFR(wot, wo9);
					CJ(wo8, wot, shs9);
					XFR(wo9, wo8);
					CXJ(wo7, wot, wo8, shs9);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs9);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs9);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs9);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs9);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs9);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs9);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs9);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs9:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x3ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 26);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0x3ffffff);	/* Extract offset value */
				wo8 = (wo8 >> 26);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo9 & 0x3ffffff);	/* Extract offset value */
				wo9 = (wo9 >> 26);		/* Extract weighting value */
				vwe = wo8 - wo9;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo9;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k12_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 10;
	g->in.chi[0] = 10;
	g->in.chi[1] = 10;
	g->in.chi[2] = 10;
	g->in.chi[3] = 10;
	g->in.chi[4] = 10;
	g->in.chi[5] = 10;
	g->in.chi[6] = 10;
	g->in.chi[7] = 10;
	g->in.chi[8] = 10;
	g->in.bpch[9] = 8;
	g->in.chi[9] = 10;
	g->in.bpv[9] = 8;
	g->opt = 1;
	g->itres = 7;
	g->stres = 0;
	g->kdesc[0] = 49;
	g->kdesc[1] = 48;
	g->kdesc[2] = 95;
	g->kdesc[3] = 49;
	g->kdesc[4] = 95;
	g->kdesc[5] = 105;
	g->kdesc[6] = 56;
	g->kdesc[7] = 95;
	g->kdesc[8] = 105;
	g->kdesc[9] = 56;
	g->kdesc[10] = 95;
	g->kdesc[11] = 102;
	g->kname[7] = 50;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned longlong *)((p) + 0 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k13(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 3) {
		unsigned longlong ova0;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k13_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 1;
	g->od = 3;
	g->in.chi[0] = 1;
	g->out.chi[0] = 3;
	g->out.bpch[1] = 8;
	g->out.chi[1] = 3;
	g->out.bpv[1] = 8;
	g->out.bpch[2] = 8;
	g->out.chi[2] = 3;
	g->out.bpv[2] = 8;
	g->opt = 17;
	g->itres = 255;
	g->kdesc[1] = 95;
	g->kdesc[2] = 51;
	g->kdesc[3] = 95;
	g->kdesc[4] = 105;
	g->kdesc[5] = 56;
	g->kdesc[6] = 95;
	g->kdesc[7] = 105;
	g->kdesc[8] = 56;
	g->kdesc[9] = 95;
	g->kdesc[10] = 102;
	g->kdesc[11] = 0;
	g->kname[7] = 51;
	t->sort = 0;
	t->it_ab = 8;
	t->it_ts = 1;
	t->ix_ab = 8;
	t->sx_ab = 0;
	t->sm_ts = 4;
	t->wo_ab = 16;
	t->wo_es = 2;
	t->vo_ab = 7;
	t->im_ts = 8;
	t->im_oc = 8;
	t->im_ps = 8;
	t->im_pv = 3;
	t->ot_bits[1] = 8;
	t->ot_bits[2] = 8;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 0
   Interpolation table index bits = 16
   Interpolation table max resolution = 65535

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned longlong *)((p) + 0 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k14(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 3) {
		unsigned longlong ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = (ti & 0xffff);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 16);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7f);	/* Extract offset value */
				wo0 = (wo0 >> 7);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo0;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k14_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 65535;
	g->stres = 0;
	g->kname[7] = 52;
	t->sort = 1;
	t->it_ab = 32;
	t->it_ts = 4;
	t->ix_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned longlong *)((p) + 0 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k15(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 3) {
		unsigned longlong ova0;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k15_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 3;
	g->in.chi[0] = 3;
	g->in.chi[1] = 3;
	g->in.chi[2] = 3;
	g->itres = 101;
	g->stres = 16;
	g->kdesc[0] = 51;
	g->kname[7] = 53;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 20;
	t->sx_ab = 12;
	t->sm_ts = 16;
	t->wo_es = 4;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 12
   Interpolation table index bits = 30
   Interpolation table max resolution = 1024

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned longlong *)((p) + 0 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k16(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 3) {
		unsigned longlong ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo1, wo2);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x1ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 25);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x1ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 25);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x1ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 25);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo2;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k16_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 1024;
	g->stres = 0;
	g->kname[7] = 54;
	t->sort = 1;
	t->wo_xs = 0;
	t->it_ab = 64;
	t->it_ts = 8;
	t->ix_ab = 30;
	t->wo_ab = 34;
	t->we_ab = 9;
	t->vo_ab = 25;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 39

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned longlong *)((p) + 0 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k17(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 3) {
		unsigned longlong ova0;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned longlong ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				ti += IT_IT(it3, ip0[3]);
				
				imp = im_base + IM_O(ti >> 32);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xffffffff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k17_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 4;
	g->in.chi[0] = 4;
	g->in.chi[1] = 4;
	g->in.chi[2] = 4;
	g->in.chi[3] = 4;
	g->itres = 39;
	g->stres = 255;
	g->kdesc[0] = 52;
	g->kname[7] = 55;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 32;
	t->sx_ab = 32;
	t->sm_ts = 20;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 30
   Interpolation table max resolution = 181

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned longlong *)((p) + 0 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k18(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 3) {
		unsigned longlong ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x1ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 25);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x1ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 25);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x1ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 25);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x1ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 25);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo3;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k18_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 181;
	g->stres = 0;
	g->kname[7] = 56;
	t->sort = 1;
	t->wo_xs = 0;
	t->ix_ab = 30;
	t->we_ab = 9;
	t->vo_ab = 25;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 55

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned longlong *)((p) + 0 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k19(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 5, op0 += 3) {
		unsigned longlong ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k19_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 5;
	g->in.chi[0] = 5;
	g->in.chi[1] = 5;
	g->in.chi[2] = 5;
	g->in.chi[3] = 5;
	g->in.chi[4] = 5;
	g->opt = 1;
	g->itres = 55;
	g->stres = 0;
	g->kdesc[0] = 53;
	g->kname[7] = 57;
	t->ix_ab = 29;
	t->wo_ab = 35;
	t->vo_ab = 26;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 28

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned longlong *)((p) + 0 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k20(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 6, op0 += 3) {
		unsigned longlong ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k20_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 6;
	g->in.chi[0] = 6;
	g->in.chi[1] = 6;
	g->in.chi[2] = 6;
	g->in.chi[3] = 6;
	g->in.chi[4] = 6;
	g->in.chi[5] = 6;
	g->opt = 1;
	g->itres = 28;
	g->stres = 0;
	g->kdesc[0] = 54;
	g->kname[6] = 50;
	g->kname[7] = 48;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 17

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned longlong *)((p) + 0 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k21(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 7, op0 += 3) {
		unsigned longlong ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k21_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 7;
	g->in.chi[0] = 7;
	g->in.chi[1] = 7;
	g->in.chi[2] = 7;
	g->in.chi[3] = 7;
	g->in.chi[4] = 7;
	g->in.chi[5] = 7;
	g->in.chi[6] = 7;
	g->opt = 1;
	g->itres = 17;
	g->stres = 0;
	g->kdesc[0] = 55;
	g->kname[7] = 49;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 12

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned longlong *)((p) + 0 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k22(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 8, op0 += 3) {
		unsigned longlong ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x3ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 26);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k22_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 8;
	g->in.chi[0] = 8;
	g->in.chi[1] = 8;
	g->in.chi[2] = 8;
	g->in.chi[3] = 8;
	g->in.chi[4] = 8;
	g->in.chi[5] = 8;
	g->in.chi[6] = 8;
	g->in.chi[7] = 8;
	g->opt = 1;
	g->itres = 12;
	g->stres = 0;
	g->kdesc[0] = 56;
	g->kname[7] = 50;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 9
   Input channel 0 bits = 8
   Input channel 0 increment = 9
   Input channel 1 bits = 8
   Input channel 1 increment = 9
   Input channel 2 bits = 8
   Input channel 2 increment = 9
   Input channel 3 bits = 8
   Input channel 3 increment = 9
   Input channel 4 bits = 8
   Input channel 4 increment = 9
   Input channel 5 bits = 8
   Input channel 5 increment = 9
   Input channel 6 bits = 8
   Input channel 6 increment = 9
   Input channel 7 bits = 8
   Input channel 7 increment = 9
   Input channel 8 bits = 8
   Input channel 8 increment = 9
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 9

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned longlong *)((p) + 0 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k23(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 9 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 9, op0 += 3) {
		unsigned longlong ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x3ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 26);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0x3ffffff);	/* Extract offset value */
				wo8 = (wo8 >> 26);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo8;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k23_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 9;
	g->in.chi[0] = 9;
	g->in.chi[1] = 9;
	g->in.chi[2] = 9;
	g->in.chi[3] = 9;
	g->in.chi[4] = 9;
	g->in.chi[5] = 9;
	g->in.chi[6] = 9;
	g->in.chi[7] = 9;
	g->in.chi[8] = 9;
	g->opt = 1;
	g->itres = 9;
	g->stres = 0;
	g->kdesc[0] = 57;
	g->kname[7] = 51;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 10
   Input channel 0 bits = 8
   Input channel 0 increment = 10
   Input channel 1 bits = 8
   Input channel 1 increment = 10
   Input channel 2 bits = 8
   Input channel 2 increment = 10
   Input channel 3 bits = 8
   Input channel 3 increment = 10
   Input channel 4 bits = 8
   Input channel 4 increment = 10
   Input channel 5 bits = 8
   Input channel 5 increment = 10
   Input channel 6 bits = 8
   Input channel 6 increment = 10
   Input channel 7 bits = 8
   Input channel 7 increment = 10
   Input channel 8 bits = 8
   Input channel 8 increment = 10
   Input channel 9 bits = 8
   Input channel 9 increment = 10
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 7

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned longlong *)((p) + 0 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k24(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 10 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer it9 = (pointer)p->in_tables[9];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 10, op0 += 3) {
		unsigned longlong ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			unsigned longlong wo9;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it9, ip0[9]);
				wo9   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
					XFR(wot, wo9);
					CJ(wo8, wot, shs9);
					XFR(wo9, wo8);
					CXJ(wo7, wot, wo8, shs9);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs9);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs9);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs9);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs9);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs9);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs9);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs9);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs9:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x3ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 26);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0x3ffffff);	/* Extract offset value */
				wo8 = (wo8 >> 26);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo9 & 0x3ffffff);	/* Extract offset value */
				wo9 = (wo9 >> 26);		/* Extract weighting value */
				vwe = wo8 - wo9;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo9;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

void
imdi_k24_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 10;
	g->in.chi[0] = 10;
	g->in.chi[1] = 10;
	g->in.chi[2] = 10;
	g->in.chi[3] = 10;
	g->in.chi[4] = 10;
	g->in.chi[5] = 10;
	g->in.chi[6] = 10;
	g->in.chi[7] = 10;
	g->in.chi[8] = 10;
	g->opt = 1;
	g->itres = 7;
	g->stres = 0;
	g->kdesc[0] = 49;
	g->kdesc[1] = 48;
	g->kdesc[2] = 95;
	g->kdesc[3] = 51;
	g->kdesc[4] = 95;
	g->kdesc[5] = 105;
	g->kdesc[6] = 56;
	g->kdesc[7] = 95;
	g->kdesc[8] = 105;
	g->kdesc[9] = 56;
	g->kdesc[10] = 95;
	g->kdesc[11] = 102;
	g->kname[7] = 52;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k25(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 4) {
		unsigned longlong ova0;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k25_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 1;
	g->od = 4;
	g->in.chi[0] = 1;
	g->out.chi[0] = 4;
	g->out.chi[1] = 4;
	g->out.chi[2] = 4;
	g->out.bpch[3] = 8;
	g->out.chi[3] = 4;
	g->out.bpv[3] = 8;
	g->opt = 17;
	g->itres = 255;
	g->kdesc[1] = 95;
	g->kdesc[2] = 52;
	g->kdesc[3] = 95;
	g->kdesc[4] = 105;
	g->kdesc[5] = 56;
	g->kdesc[6] = 95;
	g->kdesc[7] = 105;
	g->kdesc[8] = 56;
	g->kdesc[9] = 95;
	g->kdesc[10] = 102;
	g->kdesc[11] = 0;
	g->kname[7] = 53;
	t->sort = 0;
	t->it_ab = 8;
	t->it_ts = 1;
	t->ix_ab = 8;
	t->sx_ab = 0;
	t->sm_ts = 4;
	t->wo_ab = 16;
	t->wo_es = 2;
	t->vo_ab = 7;
	t->im_fn = 1;
	t->im_ps = 0;
	t->im_pn = 0;
	t->im_pv = 0;
	t->ot_bits[3] = 8;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 0
   Interpolation table index bits = 16
   Interpolation table max resolution = 65535

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k26(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 4) {
		unsigned longlong ova0;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = (ti & 0xffff);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 16);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7f);	/* Extract offset value */
				wo0 = (wo0 >> 7);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo0;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k26_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 65535;
	g->stres = 0;
	g->kname[7] = 54;
	t->sort = 1;
	t->it_ab = 32;
	t->it_ts = 4;
	t->ix_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k27(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 4) {
		unsigned longlong ova0;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k27_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 3;
	g->in.chi[0] = 3;
	g->in.chi[1] = 3;
	g->in.chi[2] = 3;
	g->itres = 101;
	g->stres = 16;
	g->kdesc[0] = 51;
	g->kname[7] = 55;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 20;
	t->sx_ab = 12;
	t->sm_ts = 16;
	t->wo_es = 4;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 12
   Interpolation table index bits = 30
   Interpolation table max resolution = 1024

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k28(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 4) {
		unsigned longlong ova0;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo1, wo2);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x1ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 25);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x1ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 25);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x1ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 25);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo2;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k28_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 1024;
	g->stres = 0;
	g->kname[7] = 56;
	t->sort = 1;
	t->wo_xs = 0;
	t->it_ab = 64;
	t->it_ts = 8;
	t->ix_ab = 30;
	t->wo_ab = 34;
	t->we_ab = 9;
	t->vo_ab = 25;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 39

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k29(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 4) {
		unsigned longlong ova0;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned longlong ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				ti += IT_IT(it3, ip0[3]);
				
				imp = im_base + IM_O(ti >> 32);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xffffffff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k29_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 4;
	g->in.chi[0] = 4;
	g->in.chi[1] = 4;
	g->in.chi[2] = 4;
	g->in.chi[3] = 4;
	g->itres = 39;
	g->stres = 255;
	g->kdesc[0] = 52;
	g->kname[7] = 57;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 32;
	t->sx_ab = 32;
	t->sm_ts = 20;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 30
   Interpolation table max resolution = 181

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k30(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 4) {
		unsigned longlong ova0;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x1ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 25);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x1ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 25);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x1ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 25);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x1ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 25);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo3;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k30_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 181;
	g->stres = 0;
	g->kname[6] = 51;
	g->kname[7] = 48;
	t->sort = 1;
	t->wo_xs = 0;
	t->ix_ab = 30;
	t->we_ab = 9;
	t->vo_ab = 25;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 55

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k31(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 5, op0 += 4) {
		unsigned longlong ova0;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k31_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 5;
	g->in.chi[0] = 5;
	g->in.chi[1] = 5;
	g->in.chi[2] = 5;
	g->in.chi[3] = 5;
	g->in.chi[4] = 5;
	g->opt = 1;
	g->itres = 55;
	g->stres = 0;
	g->kdesc[0] = 53;
	g->kname[7] = 49;
	t->ix_ab = 29;
	t->wo_ab = 35;
	t->vo_ab = 26;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 28

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k32(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 6, op0 += 4) {
		unsigned longlong ova0;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k32_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 6;
	g->in.chi[0] = 6;
	g->in.chi[1] = 6;
	g->in.chi[2] = 6;
	g->in.chi[3] = 6;
	g->in.chi[4] = 6;
	g->in.chi[5] = 6;
	g->opt = 1;
	g->itres = 28;
	g->stres = 0;
	g->kdesc[0] = 54;
	g->kname[7] = 50;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 17

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k33(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 7, op0 += 4) {
		unsigned longlong ova0;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k33_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 7;
	g->in.chi[0] = 7;
	g->in.chi[1] = 7;
	g->in.chi[2] = 7;
	g->in.chi[3] = 7;
	g->in.chi[4] = 7;
	g->in.chi[5] = 7;
	g->in.chi[6] = 7;
	g->opt = 1;
	g->itres = 17;
	g->stres = 0;
	g->kdesc[0] = 55;
	g->kname[7] = 51;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 12

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k34(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 8, op0 += 4) {
		unsigned longlong ova0;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x3ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 26);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k34_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 8;
	g->in.chi[0] = 8;
	g->in.chi[1] = 8;
	g->in.chi[2] = 8;
	g->in.chi[3] = 8;
	g->in.chi[4] = 8;
	g->in.chi[5] = 8;
	g->in.chi[6] = 8;
	g->in.chi[7] = 8;
	g->opt = 1;
	g->itres = 12;
	g->stres = 0;
	g->kdesc[0] = 56;
	g->kname[7] = 52;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 9
   Input channel 0 bits = 8
   Input channel 0 increment = 9
   Input channel 1 bits = 8
   Input channel 1 increment = 9
   Input channel 2 bits = 8
   Input channel 2 increment = 9
   Input channel 3 bits = 8
   Input channel 3 increment = 9
   Input channel 4 bits = 8
   Input channel 4 increment = 9
   Input channel 5 bits = 8
   Input channel 5 increment = 9
   Input channel 6 bits = 8
   Input channel 6 increment = 9
   Input channel 7 bits = 8
   Input channel 7 increment = 9
   Input channel 8 bits = 8
   Input channel 8 increment = 9
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 9

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k35(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 9 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 9, op0 += 4) {
		unsigned longlong ova0;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x3ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 26);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0x3ffffff);	/* Extract offset value */
				wo8 = (wo8 >> 26);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo8;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k35_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 9;
	g->in.chi[0] = 9;
	g->in.chi[1] = 9;
	g->in.chi[2] = 9;
	g->in.chi[3] = 9;
	g->in.chi[4] = 9;
	g->in.chi[5] = 9;
	g->in.chi[6] = 9;
	g->in.chi[7] = 9;
	g->in.chi[8] = 9;
	g->opt = 1;
	g->itres = 9;
	g->stres = 0;
	g->kdesc[0] = 57;
	g->kname[7] = 53;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 10
   Input channel 0 bits = 8
   Input channel 0 increment = 10
   Input channel 1 bits = 8
   Input channel 1 increment = 10
   Input channel 2 bits = 8
   Input channel 2 increment = 10
   Input channel 3 bits = 8
   Input channel 3 increment = 10
   Input channel 4 bits = 8
   Input channel 4 increment = 10
   Input channel 5 bits = 8
   Input channel 5 increment = 10
   Input channel 6 bits = 8
   Input channel 6 increment = 10
   Input channel 7 bits = 8
   Input channel 7 increment = 10
   Input channel 8 bits = 8
   Input channel 8 increment = 10
   Input channel 9 bits = 8
   Input channel 9 increment = 10
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 7

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k36(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 10 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer it9 = (pointer)p->in_tables[9];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 10, op0 += 4) {
		unsigned longlong ova0;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			unsigned longlong wo9;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it9, ip0[9]);
				wo9   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
					XFR(wot, wo9);
					CJ(wo8, wot, shs9);
					XFR(wo9, wo8);
					CXJ(wo7, wot, wo8, shs9);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs9);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs9);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs9);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs9);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs9);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs9);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs9);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs9:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x3ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 26);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0x3ffffff);	/* Extract offset value */
				wo8 = (wo8 >> 26);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo9 & 0x3ffffff);	/* Extract offset value */
				wo9 = (wo9 >> 26);		/* Extract weighting value */
				vwe = wo8 - wo9;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo9;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k36_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 10;
	g->in.chi[0] = 10;
	g->in.chi[1] = 10;
	g->in.chi[2] = 10;
	g->in.chi[3] = 10;
	g->in.chi[4] = 10;
	g->in.chi[5] = 10;
	g->in.chi[6] = 10;
	g->in.chi[7] = 10;
	g->in.chi[8] = 10;
	g->opt = 1;
	g->itres = 7;
	g->stres = 0;
	g->kdesc[0] = 49;
	g->kdesc[1] = 48;
	g->kdesc[2] = 95;
	g->kdesc[3] = 52;
	g->kdesc[4] = 95;
	g->kdesc[5] = 105;
	g->kdesc[6] = 56;
	g->kdesc[7] = 95;
	g->kdesc[8] = 105;
	g->kdesc[9] = 56;
	g->kdesc[10] = 95;
	g->kdesc[11] = 102;
	g->kname[7] = 54;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 10)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 8 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k37(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 5) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned short ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k37_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 1;
	g->od = 5;
	g->in.chi[0] = 1;
	g->out.chi[0] = 5;
	g->out.chi[1] = 5;
	g->out.chi[2] = 5;
	g->out.chi[3] = 5;
	g->out.bpch[4] = 8;
	g->out.chi[4] = 5;
	g->out.bpv[4] = 8;
	g->opt = 17;
	g->itres = 255;
	g->kdesc[1] = 95;
	g->kdesc[2] = 53;
	g->kdesc[3] = 95;
	g->kdesc[4] = 105;
	g->kdesc[5] = 56;
	g->kdesc[6] = 95;
	g->kdesc[7] = 105;
	g->kdesc[8] = 56;
	g->kdesc[9] = 95;
	g->kdesc[10] = 102;
	g->kdesc[11] = 0;
	g->kname[7] = 55;
	t->sort = 0;
	t->it_ab = 8;
	t->it_ts = 1;
	t->ix_ab = 8;
	t->sx_ab = 0;
	t->sm_ts = 4;
	t->wo_ab = 16;
	t->wo_es = 2;
	t->vo_ab = 7;
	t->vo_om = 5;
	t->im_ts = 10;
	t->im_oc = 2;
	t->im_ps = 2;
	t->im_pn = 1;
	t->im_pv = 1;
	t->ot_bits[4] = 8;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 0
   Interpolation table index bits = 14
   Interpolation table max resolution = 16383

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 10)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 8 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k38(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 5) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned short ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = (ti & 0x3ffff);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 18);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x1ff);	/* Extract offset value */
				wo0 = (wo0 >> 9);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo0;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k38_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 16383;
	g->stres = 0;
	g->kname[7] = 56;
	t->sort = 1;
	t->it_ab = 32;
	t->it_ts = 4;
	t->ix_ab = 14;
	t->wo_ab = 18;
	t->vo_ab = 9;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 10)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 8 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k39(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 5) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned short ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k39_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 3;
	g->in.chi[0] = 3;
	g->in.chi[1] = 3;
	g->in.chi[2] = 3;
	g->itres = 101;
	g->stres = 16;
	g->kdesc[0] = 51;
	g->kname[7] = 57;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 20;
	t->sx_ab = 12;
	t->sm_ts = 16;
	t->wo_es = 4;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 12
   Interpolation table index bits = 29
   Interpolation table max resolution = 812

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 10)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 8 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k40(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 5) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned short ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo1, wo2);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo2;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k40_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 812;
	g->stres = 0;
	g->kname[6] = 52;
	g->kname[7] = 48;
	t->sort = 1;
	t->wo_xs = 0;
	t->it_ab = 64;
	t->it_ts = 8;
	t->ix_ab = 29;
	t->wo_ab = 35;
	t->we_ab = 9;
	t->vo_ab = 26;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 23

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 10)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 8 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k41(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 5) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned short ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned longlong ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				ti += IT_IT(it3, ip0[3]);
				
				imp = im_base + IM_O(ti >> 32);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xffffffff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k41_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 4;
	g->in.chi[0] = 4;
	g->in.chi[1] = 4;
	g->in.chi[2] = 4;
	g->in.chi[3] = 4;
	g->itres = 23;
	g->stres = 255;
	g->kdesc[0] = 52;
	g->kname[7] = 49;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 32;
	t->sx_ab = 32;
	t->sm_ts = 20;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 152

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 10)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 8 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k42(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 5) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned short ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo3;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k42_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 152;
	g->stres = 0;
	g->kname[7] = 50;
	t->sort = 1;
	t->wo_xs = 0;
	t->ix_ab = 29;
	t->we_ab = 9;
	t->vo_ab = 26;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 48

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 10)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 8 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k43(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 5, op0 += 5) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned short ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k43_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 5;
	g->in.chi[0] = 5;
	g->in.chi[1] = 5;
	g->in.chi[2] = 5;
	g->in.chi[3] = 5;
	g->in.chi[4] = 5;
	g->opt = 1;
	g->itres = 48;
	g->stres = 0;
	g->kdesc[0] = 53;
	g->kname[7] = 51;
	t->ix_ab = 28;
	t->wo_ab = 36;
	t->vo_ab = 27;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 25

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 10)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 8 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k44(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 6, op0 += 5) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned short ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k44_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 6;
	g->in.chi[0] = 6;
	g->in.chi[1] = 6;
	g->in.chi[2] = 6;
	g->in.chi[3] = 6;
	g->in.chi[4] = 6;
	g->in.chi[5] = 6;
	g->opt = 1;
	g->itres = 25;
	g->stres = 0;
	g->kdesc[0] = 54;
	g->kname[7] = 52;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 16

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 10)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 8 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k45(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 7, op0 += 5) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned short ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 27);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k45_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 7;
	g->in.chi[0] = 7;
	g->in.chi[1] = 7;
	g->in.chi[2] = 7;
	g->in.chi[3] = 7;
	g->in.chi[4] = 7;
	g->in.chi[5] = 7;
	g->in.chi[6] = 7;
	g->opt = 1;
	g->itres = 16;
	g->stres = 0;
	g->kdesc[0] = 55;
	g->kname[7] = 53;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 11

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 10)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 8 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k46(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 8, op0 += 5) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned short ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 27);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 27);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k46_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 8;
	g->in.chi[0] = 8;
	g->in.chi[1] = 8;
	g->in.chi[2] = 8;
	g->in.chi[3] = 8;
	g->in.chi[4] = 8;
	g->in.chi[5] = 8;
	g->in.chi[6] = 8;
	g->in.chi[7] = 8;
	g->opt = 1;
	g->itres = 11;
	g->stres = 0;
	g->kdesc[0] = 56;
	g->kname[7] = 54;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 9
   Input channel 0 bits = 8
   Input channel 0 increment = 9
   Input channel 1 bits = 8
   Input channel 1 increment = 9
   Input channel 2 bits = 8
   Input channel 2 increment = 9
   Input channel 3 bits = 8
   Input channel 3 increment = 9
   Input channel 4 bits = 8
   Input channel 4 increment = 9
   Input channel 5 bits = 8
   Input channel 5 increment = 9
   Input channel 6 bits = 8
   Input channel 6 increment = 9
   Input channel 7 bits = 8
   Input channel 7 increment = 9
   Input channel 8 bits = 8
   Input channel 8 increment = 9
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 8

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 10)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 8 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k47(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 9 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 9, op0 += 5) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned short ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 27);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 27);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0x7ffffff);	/* Extract offset value */
				wo8 = (wo8 >> 27);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo8;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k47_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 9;
	g->in.chi[0] = 9;
	g->in.chi[1] = 9;
	g->in.chi[2] = 9;
	g->in.chi[3] = 9;
	g->in.chi[4] = 9;
	g->in.chi[5] = 9;
	g->in.chi[6] = 9;
	g->in.chi[7] = 9;
	g->in.chi[8] = 9;
	g->opt = 1;
	g->itres = 8;
	g->stres = 0;
	g->kdesc[0] = 57;
	g->kname[7] = 55;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 10
   Input channel 0 bits = 8
   Input channel 0 increment = 10
   Input channel 1 bits = 8
   Input channel 1 increment = 10
   Input channel 2 bits = 8
   Input channel 2 increment = 10
   Input channel 3 bits = 8
   Input channel 3 increment = 10
   Input channel 4 bits = 8
   Input channel 4 increment = 10
   Input channel 5 bits = 8
   Input channel 5 increment = 10
   Input channel 6 bits = 8
   Input channel 6 increment = 10
   Input channel 7 bits = 8
   Input channel 7 increment = 10
   Input channel 8 bits = 8
   Input channel 8 increment = 10
   Input channel 9 bits = 8
   Input channel 9 increment = 10
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 6

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 10)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 8 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k48(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 10 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer it9 = (pointer)p->in_tables[9];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 10, op0 += 5) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned short ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			unsigned longlong wo9;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it9, ip0[9]);
				wo9   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
					XFR(wot, wo9);
					CJ(wo8, wot, shs9);
					XFR(wo9, wo8);
					CXJ(wo7, wot, wo8, shs9);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs9);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs9);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs9);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs9);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs9);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs9);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs9);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs9:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 27);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 27);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0x7ffffff);	/* Extract offset value */
				wo8 = (wo8 >> 27);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo9 & 0x7ffffff);	/* Extract offset value */
				wo9 = (wo9 >> 27);		/* Extract weighting value */
				vwe = wo8 - wo9;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo9;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k48_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 10;
	g->in.chi[0] = 10;
	g->in.chi[1] = 10;
	g->in.chi[2] = 10;
	g->in.chi[3] = 10;
	g->in.chi[4] = 10;
	g->in.chi[5] = 10;
	g->in.chi[6] = 10;
	g->in.chi[7] = 10;
	g->in.chi[8] = 10;
	g->opt = 1;
	g->stres = 0;
	g->kdesc[0] = 49;
	g->kdesc[1] = 48;
	g->kdesc[2] = 95;
	g->kdesc[3] = 53;
	g->kdesc[4] = 95;
	g->kdesc[5] = 105;
	g->kdesc[6] = 56;
	g->kdesc[7] = 95;
	g->kdesc[8] = 105;
	g->kdesc[9] = 56;
	g->kdesc[10] = 95;
	g->kdesc[11] = 102;
	g->kname[7] = 56;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k49(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 6) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k49_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 1;
	g->od = 6;
	g->in.chi[0] = 1;
	g->out.chi[0] = 6;
	g->out.chi[1] = 6;
	g->out.chi[2] = 6;
	g->out.chi[3] = 6;
	g->out.chi[4] = 6;
	g->out.bpch[5] = 8;
	g->out.chi[5] = 6;
	g->out.bpv[5] = 8;
	g->opt = 17;
	g->itres = 255;
	g->kdesc[1] = 95;
	g->kdesc[2] = 54;
	g->kdesc[3] = 95;
	g->kdesc[4] = 105;
	g->kdesc[5] = 56;
	g->kdesc[6] = 95;
	g->kdesc[7] = 105;
	g->kdesc[8] = 56;
	g->kdesc[9] = 95;
	g->kdesc[10] = 102;
	g->kdesc[11] = 0;
	g->kname[7] = 57;
	t->sort = 0;
	t->it_ab = 8;
	t->it_ts = 1;
	t->ix_ab = 8;
	t->sx_ab = 0;
	t->sm_ts = 4;
	t->wo_ab = 16;
	t->wo_es = 2;
	t->vo_ab = 7;
	t->vo_om = 3;
	t->im_ts = 12;
	t->im_oc = 4;
	t->im_ps = 4;
	t->im_pv = 2;
	t->ot_bits[5] = 8;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 0
   Interpolation table index bits = 15
   Interpolation table max resolution = 32767

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k50(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 6) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = (ti & 0x1ffff);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 17);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0xff);	/* Extract offset value */
				wo0 = (wo0 >> 8);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo0;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k50_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 32767;
	g->stres = 0;
	g->kname[6] = 53;
	g->kname[7] = 48;
	t->sort = 1;
	t->it_ab = 32;
	t->it_ts = 4;
	t->ix_ab = 15;
	t->wo_ab = 17;
	t->vo_ab = 8;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k51(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 6) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k51_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 3;
	g->in.chi[0] = 3;
	g->in.chi[1] = 3;
	g->in.chi[2] = 3;
	g->itres = 101;
	g->stres = 16;
	g->kdesc[0] = 51;
	g->kname[7] = 49;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 20;
	t->sx_ab = 12;
	t->sm_ts = 16;
	t->wo_es = 4;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 12
   Interpolation table index bits = 30
   Interpolation table max resolution = 1024

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k52(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 6) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo1, wo2);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x1ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 25);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x1ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 25);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x1ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 25);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo2;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k52_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 1024;
	g->stres = 0;
	g->kname[7] = 50;
	t->sort = 1;
	t->wo_xs = 0;
	t->it_ab = 64;
	t->it_ts = 8;
	t->ix_ab = 30;
	t->wo_ab = 34;
	t->we_ab = 9;
	t->vo_ab = 25;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 27

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k53(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 6) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned longlong ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				ti += IT_IT(it3, ip0[3]);
				
				imp = im_base + IM_O(ti >> 32);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xffffffff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k53_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 4;
	g->in.chi[0] = 4;
	g->in.chi[1] = 4;
	g->in.chi[2] = 4;
	g->in.chi[3] = 4;
	g->itres = 27;
	g->stres = 255;
	g->kdesc[0] = 52;
	g->kname[7] = 51;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 32;
	t->sx_ab = 32;
	t->sm_ts = 20;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 152

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k54(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 6) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo3;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k54_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 152;
	g->stres = 0;
	g->kname[7] = 52;
	t->sort = 1;
	t->wo_xs = 0;
	t->ix_ab = 29;
	t->wo_ab = 35;
	t->we_ab = 9;
	t->vo_ab = 26;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 55

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k55(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 5, op0 += 6) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k55_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 5;
	g->in.chi[0] = 5;
	g->in.chi[1] = 5;
	g->in.chi[2] = 5;
	g->in.chi[3] = 5;
	g->in.chi[4] = 5;
	g->opt = 1;
	g->itres = 55;
	g->stres = 0;
	g->kdesc[0] = 53;
	g->kname[7] = 53;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 28

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k56(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 6, op0 += 6) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k56_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 6;
	g->in.chi[0] = 6;
	g->in.chi[1] = 6;
	g->in.chi[2] = 6;
	g->in.chi[3] = 6;
	g->in.chi[4] = 6;
	g->in.chi[5] = 6;
	g->opt = 1;
	g->itres = 28;
	g->stres = 0;
	g->kdesc[0] = 54;
	g->kname[7] = 54;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 16

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k57(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 7, op0 += 6) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 27);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k57_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 7;
	g->in.chi[0] = 7;
	g->in.chi[1] = 7;
	g->in.chi[2] = 7;
	g->in.chi[3] = 7;
	g->in.chi[4] = 7;
	g->in.chi[5] = 7;
	g->in.chi[6] = 7;
	g->opt = 1;
	g->itres = 16;
	g->stres = 0;
	g->kdesc[0] = 55;
	g->kname[7] = 55;
	t->ix_ab = 28;
	t->wo_ab = 36;
	t->vo_ab = 27;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 11

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k58(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 8, op0 += 6) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 27);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 27);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k58_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 8;
	g->in.chi[0] = 8;
	g->in.chi[1] = 8;
	g->in.chi[2] = 8;
	g->in.chi[3] = 8;
	g->in.chi[4] = 8;
	g->in.chi[5] = 8;
	g->in.chi[6] = 8;
	g->in.chi[7] = 8;
	g->opt = 1;
	g->itres = 11;
	g->stres = 0;
	g->kdesc[0] = 56;
	g->kname[7] = 56;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 9
   Input channel 0 bits = 8
   Input channel 0 increment = 9
   Input channel 1 bits = 8
   Input channel 1 increment = 9
   Input channel 2 bits = 8
   Input channel 2 increment = 9
   Input channel 3 bits = 8
   Input channel 3 increment = 9
   Input channel 4 bits = 8
   Input channel 4 increment = 9
   Input channel 5 bits = 8
   Input channel 5 increment = 9
   Input channel 6 bits = 8
   Input channel 6 increment = 9
   Input channel 7 bits = 8
   Input channel 7 increment = 9
   Input channel 8 bits = 8
   Input channel 8 increment = 9
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 8

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k59(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 9 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 9, op0 += 6) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 27);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 27);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0x7ffffff);	/* Extract offset value */
				wo8 = (wo8 >> 27);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo8;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k59_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 9;
	g->in.chi[0] = 9;
	g->in.chi[1] = 9;
	g->in.chi[2] = 9;
	g->in.chi[3] = 9;
	g->in.chi[4] = 9;
	g->in.chi[5] = 9;
	g->in.chi[6] = 9;
	g->in.chi[7] = 9;
	g->in.chi[8] = 9;
	g->opt = 1;
	g->itres = 8;
	g->stres = 0;
	g->kdesc[0] = 57;
	g->kname[7] = 57;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 10
   Input channel 0 bits = 8
   Input channel 0 increment = 10
   Input channel 1 bits = 8
   Input channel 1 increment = 10
   Input channel 2 bits = 8
   Input channel 2 increment = 10
   Input channel 3 bits = 8
   Input channel 3 increment = 10
   Input channel 4 bits = 8
   Input channel 4 increment = 10
   Input channel 5 bits = 8
   Input channel 5 increment = 10
   Input channel 6 bits = 8
   Input channel 6 increment = 10
   Input channel 7 bits = 8
   Input channel 7 increment = 10
   Input channel 8 bits = 8
   Input channel 8 increment = 10
   Input channel 9 bits = 8
   Input channel 9 increment = 10
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 6

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k60(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 10 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer it9 = (pointer)p->in_tables[9];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 10, op0 += 6) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			unsigned longlong wo9;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it9, ip0[9]);
				wo9   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
					XFR(wot, wo9);
					CJ(wo8, wot, shs9);
					XFR(wo9, wo8);
					CXJ(wo7, wot, wo8, shs9);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs9);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs9);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs9);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs9);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs9);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs9);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs9);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs9:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 27);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 27);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0x7ffffff);	/* Extract offset value */
				wo8 = (wo8 >> 27);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo9 & 0x7ffffff);	/* Extract offset value */
				wo9 = (wo9 >> 27);		/* Extract weighting value */
				vwe = wo8 - wo9;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo9;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k60_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 10;
	g->in.chi[0] = 10;
	g->in.chi[1] = 10;
	g->in.chi[2] = 10;
	g->in.chi[3] = 10;
	g->in.chi[4] = 10;
	g->in.chi[5] = 10;
	g->in.chi[6] = 10;
	g->in.chi[7] = 10;
	g->in.chi[8] = 10;
	g->opt = 1;
	g->stres = 0;
	g->kdesc[0] = 49;
	g->kdesc[1] = 48;
	g->kdesc[2] = 95;
	g->kdesc[3] = 54;
	g->kdesc[4] = 95;
	g->kdesc[5] = 105;
	g->kdesc[6] = 56;
	g->kdesc[7] = 95;
	g->kdesc[8] = 105;
	g->kdesc[9] = 56;
	g->kdesc[10] = 95;
	g->kdesc[11] = 102;
	g->kname[6] = 54;
	g->kname[7] = 48;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))
#define IM_PE(p, v) *((unsigned longlong *)((p) + 8 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k61(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 7) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k61_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 1;
	g->od = 7;
	g->in.chi[0] = 1;
	g->out.chi[0] = 7;
	g->out.chi[1] = 7;
	g->out.chi[2] = 7;
	g->out.chi[3] = 7;
	g->out.chi[4] = 7;
	g->out.chi[5] = 7;
	g->out.bpch[6] = 8;
	g->out.chi[6] = 7;
	g->out.bpv[6] = 8;
	g->opt = 17;
	g->itres = 255;
	g->kdesc[1] = 95;
	g->kdesc[2] = 55;
	g->kdesc[3] = 95;
	g->kdesc[4] = 105;
	g->kdesc[5] = 56;
	g->kdesc[6] = 95;
	g->kdesc[7] = 105;
	g->kdesc[8] = 56;
	g->kdesc[9] = 95;
	g->kdesc[10] = 102;
	g->kdesc[11] = 0;
	g->kname[7] = 49;
	t->sort = 0;
	t->it_ab = 8;
	t->it_ts = 1;
	t->ix_ab = 8;
	t->sx_ab = 0;
	t->sm_ts = 4;
	t->wo_ab = 16;
	t->wo_es = 2;
	t->vo_ab = 7;
	t->vo_om = 2;
	t->im_ts = 16;
	t->im_oc = 8;
	t->im_ps = 8;
	t->im_pv = 3;
	t->ot_bits[6] = 8;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 0
   Interpolation table index bits = 15
   Interpolation table max resolution = 32767

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))
#define IM_PE(p, v) *((unsigned longlong *)((p) + 8 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k62(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 7) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = (ti & 0x1ffff);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 17);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0xff);	/* Extract offset value */
				wo0 = (wo0 >> 8);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo0;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k62_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 32767;
	g->stres = 0;
	g->kname[7] = 50;
	t->sort = 1;
	t->it_ab = 32;
	t->it_ts = 4;
	t->ix_ab = 15;
	t->wo_ab = 17;
	t->vo_ab = 8;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))
#define IM_PE(p, v) *((unsigned longlong *)((p) + 8 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k63(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 7) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k63_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 3;
	g->in.chi[0] = 3;
	g->in.chi[1] = 3;
	g->in.chi[2] = 3;
	g->itres = 101;
	g->stres = 16;
	g->kdesc[0] = 51;
	g->kname[7] = 51;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 20;
	t->sx_ab = 12;
	t->sm_ts = 16;
	t->wo_es = 4;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 12
   Interpolation table index bits = 30
   Interpolation table max resolution = 1024

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))
#define IM_PE(p, v) *((unsigned longlong *)((p) + 8 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k64(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 7) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo1, wo2);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x1ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 25);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x1ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 25);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x1ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 25);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo2;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k64_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 1024;
	g->stres = 0;
	g->kname[7] = 52;
	t->sort = 1;
	t->wo_xs = 0;
	t->it_ab = 64;
	t->it_ts = 8;
	t->ix_ab = 30;
	t->wo_ab = 34;
	t->we_ab = 9;
	t->vo_ab = 25;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 31

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))
#define IM_PE(p, v) *((unsigned longlong *)((p) + 8 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k65(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 7) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned longlong ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				ti += IT_IT(it3, ip0[3]);
				
				imp = im_base + IM_O(ti >> 32);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xffffffff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k65_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 4;
	g->in.chi[0] = 4;
	g->in.chi[1] = 4;
	g->in.chi[2] = 4;
	g->in.chi[3] = 4;
	g->itres = 31;
	g->stres = 255;
	g->kdesc[0] = 52;
	g->kname[7] = 53;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 32;
	t->sx_ab = 32;
	t->sm_ts = 20;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 152

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))
#define IM_PE(p, v) *((unsigned longlong *)((p) + 8 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k66(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 7) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo3;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k66_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 152;
	g->stres = 0;
	g->kname[7] = 54;
	t->sort = 1;
	t->wo_xs = 0;
	t->ix_ab = 29;
	t->wo_ab = 35;
	t->we_ab = 9;
	t->vo_ab = 26;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 55

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))
#define IM_PE(p, v) *((unsigned longlong *)((p) + 8 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k67(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 5, op0 += 7) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k67_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 5;
	g->in.chi[0] = 5;
	g->in.chi[1] = 5;
	g->in.chi[2] = 5;
	g->in.chi[3] = 5;
	g->in.chi[4] = 5;
	g->opt = 1;
	g->itres = 55;
	g->stres = 0;
	g->kdesc[0] = 53;
	g->kname[7] = 55;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 28

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))
#define IM_PE(p, v) *((unsigned longlong *)((p) + 8 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k68(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 6, op0 += 7) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k68_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 6;
	g->in.chi[0] = 6;
	g->in.chi[1] = 6;
	g->in.chi[2] = 6;
	g->in.chi[3] = 6;
	g->in.chi[4] = 6;
	g->in.chi[5] = 6;
	g->opt = 1;
	g->itres = 28;
	g->stres = 0;
	g->kdesc[0] = 54;
	g->kname[7] = 56;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 16

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))
#define IM_PE(p, v) *((unsigned longlong *)((p) + 8 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k69(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 7, op0 += 7) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 27);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k69_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 7;
	g->in.chi[0] = 7;
	g->in.chi[1] = 7;
	g->in.chi[2] = 7;
	g->in.chi[3] = 7;
	g->in.chi[4] = 7;
	g->in.chi[5] = 7;
	g->in.chi[6] = 7;
	g->opt = 1;
	g->itres = 16;
	g->stres = 0;
	g->kdesc[0] = 55;
	g->kname[7] = 57;
	t->ix_ab = 28;
	t->wo_ab = 36;
	t->vo_ab = 27;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 11

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))
#define IM_PE(p, v) *((unsigned longlong *)((p) + 8 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k70(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 8, op0 += 7) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x3ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 26);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k70_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 8;
	g->in.chi[0] = 8;
	g->in.chi[1] = 8;
	g->in.chi[2] = 8;
	g->in.chi[3] = 8;
	g->in.chi[4] = 8;
	g->in.chi[5] = 8;
	g->in.chi[6] = 8;
	g->in.chi[7] = 8;
	g->opt = 1;
	g->itres = 11;
	g->stres = 0;
	g->kdesc[0] = 56;
	g->kname[6] = 55;
	g->kname[7] = 48;
	t->ix_ab = 29;
	t->wo_ab = 35;
	t->vo_ab = 26;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 9
   Input channel 0 bits = 8
   Input channel 0 increment = 9
   Input channel 1 bits = 8
   Input channel 1 increment = 9
   Input channel 2 bits = 8
   Input channel 2 increment = 9
   Input channel 3 bits = 8
   Input channel 3 increment = 9
   Input channel 4 bits = 8
   Input channel 4 increment = 9
   Input channel 5 bits = 8
   Input channel 5 increment = 9
   Input channel 6 bits = 8
   Input channel 6 increment = 9
   Input channel 7 bits = 8
   Input channel 7 increment = 9
   Input channel 8 bits = 8
   Input channel 8 increment = 9
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 8

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))
#define IM_PE(p, v) *((unsigned longlong *)((p) + 8 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k71(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 9 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 9, op0 += 7) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x3ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 26);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0x3ffffff);	/* Extract offset value */
				wo8 = (wo8 >> 26);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo8;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k71_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 9;
	g->in.chi[0] = 9;
	g->in.chi[1] = 9;
	g->in.chi[2] = 9;
	g->in.chi[3] = 9;
	g->in.chi[4] = 9;
	g->in.chi[5] = 9;
	g->in.chi[6] = 9;
	g->in.chi[7] = 9;
	g->in.chi[8] = 9;
	g->opt = 1;
	g->itres = 8;
	g->stres = 0;
	g->kdesc[0] = 57;
	g->kname[7] = 49;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 10
   Input channel 0 bits = 8
   Input channel 0 increment = 10
   Input channel 1 bits = 8
   Input channel 1 increment = 10
   Input channel 2 bits = 8
   Input channel 2 increment = 10
   Input channel 3 bits = 8
   Input channel 3 increment = 10
   Input channel 4 bits = 8
   Input channel 4 increment = 10
   Input channel 5 bits = 8
   Input channel 5 increment = 10
   Input channel 6 bits = 8
   Input channel 6 increment = 10
   Input channel 7 bits = 8
   Input channel 7 increment = 10
   Input channel 8 bits = 8
   Input channel 8 increment = 10
   Input channel 9 bits = 8
   Input channel 9 increment = 10
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 6

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))
#define IM_PE(p, v) *((unsigned longlong *)((p) + 8 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k72(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 10 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer it9 = (pointer)p->in_tables[9];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 10, op0 += 7) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			unsigned longlong wo9;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it9, ip0[9]);
				wo9   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
					XFR(wot, wo9);
					CJ(wo8, wot, shs9);
					XFR(wo9, wo8);
					CXJ(wo7, wot, wo8, shs9);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs9);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs9);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs9);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs9);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs9);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs9);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs9);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs9:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 27);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 27);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0x7ffffff);	/* Extract offset value */
				wo8 = (wo8 >> 27);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo9 & 0x7ffffff);	/* Extract offset value */
				wo9 = (wo9 >> 27);		/* Extract weighting value */
				vwe = wo8 - wo9;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo9;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k72_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 10;
	g->in.chi[0] = 10;
	g->in.chi[1] = 10;
	g->in.chi[2] = 10;
	g->in.chi[3] = 10;
	g->in.chi[4] = 10;
	g->in.chi[5] = 10;
	g->in.chi[6] = 10;
	g->in.chi[7] = 10;
	g->in.chi[8] = 10;
	g->opt = 1;
	g->stres = 0;
	g->kdesc[0] = 49;
	g->kdesc[1] = 48;
	g->kdesc[2] = 95;
	g->kdesc[3] = 55;
	g->kdesc[4] = 95;
	g->kdesc[5] = 105;
	g->kdesc[6] = 56;
	g->kdesc[7] = 95;
	g->kdesc[8] = 105;
	g->kdesc[9] = 56;
	g->kdesc[10] = 95;
	g->kdesc[11] = 102;
	g->kname[7] = 50;
	t->ix_ab = 28;
	t->wo_ab = 36;
	t->vo_ab = 27;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k73(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 8) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k73_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 1;
	g->od = 8;
	g->in.chi[0] = 1;
	g->out.chi[0] = 8;
	g->out.chi[1] = 8;
	g->out.chi[2] = 8;
	g->out.chi[3] = 8;
	g->out.chi[4] = 8;
	g->out.chi[5] = 8;
	g->out.chi[6] = 8;
	g->out.bpch[7] = 8;
	g->out.chi[7] = 8;
	g->out.bpv[7] = 8;
	g->opt = 17;
	g->itres = 255;
	g->kdesc[1] = 95;
	g->kdesc[2] = 56;
	g->kdesc[3] = 95;
	g->kdesc[4] = 105;
	g->kdesc[5] = 56;
	g->kdesc[6] = 95;
	g->kdesc[7] = 105;
	g->kdesc[8] = 56;
	g->kdesc[9] = 95;
	g->kdesc[10] = 102;
	g->kdesc[11] = 0;
	g->kname[7] = 51;
	t->sort = 0;
	t->it_ab = 8;
	t->it_ts = 1;
	t->ix_ab = 8;
	t->sx_ab = 0;
	t->sm_ts = 4;
	t->wo_ab = 16;
	t->wo_es = 2;
	t->vo_ab = 7;
	t->im_fn = 2;
	t->im_ps = 0;
	t->im_pn = 0;
	t->im_pv = 0;
	t->ot_bits[7] = 8;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 0
   Interpolation table index bits = 15
   Interpolation table max resolution = 32767

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k74(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 8) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = (ti & 0x1ffff);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 17);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0xff);	/* Extract offset value */
				wo0 = (wo0 >> 8);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo0;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k74_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 32767;
	g->stres = 0;
	g->kname[7] = 52;
	t->sort = 1;
	t->it_ab = 32;
	t->it_ts = 4;
	t->ix_ab = 15;
	t->wo_ab = 17;
	t->vo_ab = 8;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k75(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 8) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k75_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 3;
	g->in.chi[0] = 3;
	g->in.chi[1] = 3;
	g->in.chi[2] = 3;
	g->itres = 101;
	g->stres = 16;
	g->kdesc[0] = 51;
	g->kname[7] = 53;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 20;
	t->sx_ab = 12;
	t->sm_ts = 16;
	t->wo_es = 4;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 12
   Interpolation table index bits = 30
   Interpolation table max resolution = 1024

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k76(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 8) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 30) >> 30);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 34);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo1, wo2);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x1ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 25);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x1ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 25);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x1ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 25);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo2;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k76_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 1024;
	g->stres = 0;
	g->kname[7] = 54;
	t->sort = 1;
	t->wo_xs = 0;
	t->it_ab = 64;
	t->it_ts = 8;
	t->ix_ab = 30;
	t->wo_ab = 34;
	t->we_ab = 9;
	t->vo_ab = 25;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 31

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k77(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 8) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned longlong ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				ti += IT_IT(it3, ip0[3]);
				
				imp = im_base + IM_O(ti >> 32);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xffffffff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k77_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 4;
	g->in.chi[0] = 4;
	g->in.chi[1] = 4;
	g->in.chi[2] = 4;
	g->in.chi[3] = 4;
	g->itres = 31;
	g->stres = 255;
	g->kdesc[0] = 52;
	g->kname[7] = 55;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 32;
	t->sx_ab = 32;
	t->sm_ts = 20;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 152

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k78(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 8) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo3;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k78_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 152;
	g->stres = 0;
	g->kname[7] = 56;
	t->sort = 1;
	t->wo_xs = 0;
	t->ix_ab = 29;
	t->wo_ab = 35;
	t->we_ab = 9;
	t->vo_ab = 26;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 55

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k79(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 5, op0 += 8) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k79_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 5;
	g->in.chi[0] = 5;
	g->in.chi[1] = 5;
	g->in.chi[2] = 5;
	g->in.chi[3] = 5;
	g->in.chi[4] = 5;
	g->opt = 1;
	g->itres = 55;
	g->stres = 0;
	g->kdesc[0] = 53;
	g->kname[7] = 57;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 28

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k80(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 6, op0 += 8) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k80_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 6;
	g->in.chi[0] = 6;
	g->in.chi[1] = 6;
	g->in.chi[2] = 6;
	g->in.chi[3] = 6;
	g->in.chi[4] = 6;
	g->in.chi[5] = 6;
	g->opt = 1;
	g->itres = 28;
	g->stres = 0;
	g->kdesc[0] = 54;
	g->kname[6] = 56;
	g->kname[7] = 48;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 16

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k81(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 7, op0 += 8) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 27);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k81_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 7;
	g->in.chi[0] = 7;
	g->in.chi[1] = 7;
	g->in.chi[2] = 7;
	g->in.chi[3] = 7;
	g->in.chi[4] = 7;
	g->in.chi[5] = 7;
	g->in.chi[6] = 7;
	g->opt = 1;
	g->itres = 16;
	g->stres = 0;
	g->kdesc[0] = 55;
	g->kname[7] = 49;
	t->ix_ab = 28;
	t->wo_ab = 36;
	t->vo_ab = 27;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 11

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k82(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 8, op0 += 8) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x3ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 26);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k82_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 8;
	g->in.chi[0] = 8;
	g->in.chi[1] = 8;
	g->in.chi[2] = 8;
	g->in.chi[3] = 8;
	g->in.chi[4] = 8;
	g->in.chi[5] = 8;
	g->in.chi[6] = 8;
	g->in.chi[7] = 8;
	g->opt = 1;
	g->itres = 11;
	g->stres = 0;
	g->kdesc[0] = 56;
	g->kname[7] = 50;
	t->ix_ab = 29;
	t->wo_ab = 35;
	t->vo_ab = 26;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 9
   Input channel 0 bits = 8
   Input channel 0 increment = 9
   Input channel 1 bits = 8
   Input channel 1 increment = 9
   Input channel 2 bits = 8
   Input channel 2 increment = 9
   Input channel 3 bits = 8
   Input channel 3 increment = 9
   Input channel 4 bits = 8
   Input channel 4 increment = 9
   Input channel 5 bits = 8
   Input channel 5 increment = 9
   Input channel 6 bits = 8
   Input channel 6 increment = 9
   Input channel 7 bits = 8
   Input channel 7 increment = 9
   Input channel 8 bits = 8
   Input channel 8 increment = 9
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 8

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k83(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 9 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 9, op0 += 8) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x3ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 26);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x3ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 26);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x3ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 26);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x3ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 26);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0x3ffffff);	/* Extract offset value */
				wo8 = (wo8 >> 26);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo8;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k83_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 9;
	g->in.chi[0] = 9;
	g->in.chi[1] = 9;
	g->in.chi[2] = 9;
	g->in.chi[3] = 9;
	g->in.chi[4] = 9;
	g->in.chi[5] = 9;
	g->in.chi[6] = 9;
	g->in.chi[7] = 9;
	g->in.chi[8] = 9;
	g->opt = 1;
	g->itres = 8;
	g->stres = 0;
	g->kdesc[0] = 57;
	g->kname[7] = 51;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 10
   Input channel 0 bits = 8
   Input channel 0 increment = 10
   Input channel 1 bits = 8
   Input channel 1 increment = 10
   Input channel 2 bits = 8
   Input channel 2 increment = 10
   Input channel 3 bits = 8
   Input channel 3 increment = 10
   Input channel 4 bits = 8
   Input channel 4 increment = 10
   Input channel 5 bits = 8
   Input channel 5 increment = 10
   Input channel 6 bits = 8
   Input channel 6 increment = 10
   Input channel 7 bits = 8
   Input channel 7 increment = 10
   Input channel 8 bits = 8
   Input channel 8 increment = 10
   Input channel 9 bits = 8
   Input channel 9 increment = 10
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 6

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 8 + (c) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k84(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 10 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer it9 = (pointer)p->in_tables[9];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 10, op0 += 8) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			unsigned longlong wo9;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it9, ip0[9]);
				wo9   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
					XFR(wot, wo9);
					CJ(wo8, wot, shs9);
					XFR(wo9, wo8);
					CXJ(wo7, wot, wo8, shs9);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs9);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs9);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs9);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs9);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs9);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs9);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs9);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs9:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7ffffff);	/* Extract offset value */
				wo6 = (wo6 >> 27);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7ffffff);	/* Extract offset value */
				wo7 = (wo7 >> 27);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0x7ffffff);	/* Extract offset value */
				wo8 = (wo8 >> 27);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo9 & 0x7ffffff);	/* Extract offset value */
				wo9 = (wo9 >> 27);		/* Extract weighting value */
				vwe = wo8 - wo9;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo9;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

void
imdi_k84_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 10;
	g->in.chi[0] = 10;
	g->in.chi[1] = 10;
	g->in.chi[2] = 10;
	g->in.chi[3] = 10;
	g->in.chi[4] = 10;
	g->in.chi[5] = 10;
	g->in.chi[6] = 10;
	g->in.chi[7] = 10;
	g->in.chi[8] = 10;
	g->opt = 1;
	g->stres = 0;
	g->kdesc[0] = 49;
	g->kdesc[1] = 48;
	g->kdesc[2] = 95;
	g->kdesc[3] = 56;
	g->kdesc[4] = 95;
	g->kdesc[5] = 105;
	g->kdesc[6] = 56;
	g->kdesc[7] = 95;
	g->kdesc[8] = 105;
	g->kdesc[9] = 56;
	g->kdesc[10] = 95;
	g->kdesc[11] = 102;
	g->kname[7] = 52;
	t->ix_ab = 28;
	t->wo_ab = 36;
	t->vo_ab = 27;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 9
   Output channel 0 bits = 8
   Output channel 0 increment = 9
   Output channel 1 bits = 8
   Output channel 1 increment = 9
   Output channel 2 bits = 8
   Output channel 2 increment = 9
   Output channel 3 bits = 8
   Output channel 3 increment = 9
   Output channel 4 bits = 8
   Output channel 4 increment = 9
   Output channel 5 bits = 8
   Output channel 5 increment = 9
   Output channel 6 bits = 8
   Output channel 6 increment = 9
   Output channel 7 bits = 8
   Output channel 7 increment = 9
   Output channel 8 bits = 8
   Output channel 8 increment = 9
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 18)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 16 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k85(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 9) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned short ova2;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k85_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 1;
	g->od = 9;
	g->in.chi[0] = 1;
	g->out.chi[0] = 9;
	g->out.chi[1] = 9;
	g->out.chi[2] = 9;
	g->out.chi[3] = 9;
	g->out.chi[4] = 9;
	g->out.chi[5] = 9;
	g->out.chi[6] = 9;
	g->out.chi[7] = 9;
	g->out.bpch[8] = 8;
	g->out.chi[8] = 9;
	g->out.bpv[8] = 8;
	g->opt = 17;
	g->itres = 255;
	g->kdesc[1] = 95;
	g->kdesc[2] = 57;
	g->kdesc[3] = 95;
	g->kdesc[4] = 105;
	g->kdesc[5] = 56;
	g->kdesc[6] = 95;
	g->kdesc[7] = 105;
	g->kdesc[8] = 56;
	g->kdesc[9] = 95;
	g->kdesc[10] = 102;
	g->kdesc[11] = 0;
	g->kname[7] = 53;
	t->sort = 0;
	t->it_ab = 8;
	t->it_ts = 1;
	t->ix_ab = 8;
	t->sx_ab = 0;
	t->sm_ts = 4;
	t->wo_ab = 16;
	t->wo_es = 2;
	t->vo_ab = 7;
	t->vo_om = 9;
	t->im_ts = 18;
	t->im_oc = 2;
	t->im_ps = 2;
	t->im_pn = 1;
	t->im_pv = 1;
	t->ot_bits[8] = 8;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 9
   Output channel 0 bits = 8
   Output channel 0 increment = 9
   Output channel 1 bits = 8
   Output channel 1 increment = 9
   Output channel 2 bits = 8
   Output channel 2 increment = 9
   Output channel 3 bits = 8
   Output channel 3 increment = 9
   Output channel 4 bits = 8
   Output channel 4 increment = 9
   Output channel 5 bits = 8
   Output channel 5 increment = 9
   Output channel 6 bits = 8
   Output channel 6 increment = 9
   Output channel 7 bits = 8
   Output channel 7 increment = 9
   Output channel 8 bits = 8
   Output channel 8 increment = 9
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 0
   Interpolation table index bits = 14
   Interpolation table max resolution = 16383

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 18)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 16 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k86(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 9) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned short ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = (ti & 0x3ffff);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 18);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x1ff);	/* Extract offset value */
				wo0 = (wo0 >> 9);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo0;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k86_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 16383;
	g->stres = 0;
	g->kname[7] = 54;
	t->sort = 1;
	t->it_ab = 32;
	t->it_ts = 4;
	t->ix_ab = 14;
	t->wo_ab = 18;
	t->vo_ab = 9;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 9
   Output channel 0 bits = 8
   Output channel 0 increment = 9
   Output channel 1 bits = 8
   Output channel 1 increment = 9
   Output channel 2 bits = 8
   Output channel 2 increment = 9
   Output channel 3 bits = 8
   Output channel 3 increment = 9
   Output channel 4 bits = 8
   Output channel 4 increment = 9
   Output channel 5 bits = 8
   Output channel 5 increment = 9
   Output channel 6 bits = 8
   Output channel 6 increment = 9
   Output channel 7 bits = 8
   Output channel 7 increment = 9
   Output channel 8 bits = 8
   Output channel 8 increment = 9
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 84

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 18)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 16 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k87(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 9) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned short ova2;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k87_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 3;
	g->in.chi[0] = 3;
	g->in.chi[1] = 3;
	g->in.chi[2] = 3;
	g->itres = 84;
	g->stres = 16;
	g->kdesc[0] = 51;
	g->kname[7] = 55;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 20;
	t->sx_ab = 12;
	t->sm_ts = 16;
	t->wo_es = 4;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 9
   Output channel 0 bits = 8
   Output channel 0 increment = 9
   Output channel 1 bits = 8
   Output channel 1 increment = 9
   Output channel 2 bits = 8
   Output channel 2 increment = 9
   Output channel 3 bits = 8
   Output channel 3 increment = 9
   Output channel 4 bits = 8
   Output channel 4 increment = 9
   Output channel 5 bits = 8
   Output channel 5 increment = 9
   Output channel 6 bits = 8
   Output channel 6 increment = 9
   Output channel 7 bits = 8
   Output channel 7 increment = 9
   Output channel 8 bits = 8
   Output channel 8 increment = 9
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 12
   Interpolation table index bits = 29
   Interpolation table max resolution = 812

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 18)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 16 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k88(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 9) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned short ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo1, wo2);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo2;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k88_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 812;
	g->stres = 0;
	g->kname[7] = 56;
	t->sort = 1;
	t->wo_xs = 0;
	t->it_ab = 64;
	t->it_ts = 8;
	t->ix_ab = 29;
	t->wo_ab = 35;
	t->we_ab = 9;
	t->vo_ab = 26;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 9
   Output channel 0 bits = 8
   Output channel 0 increment = 9
   Output channel 1 bits = 8
   Output channel 1 increment = 9
   Output channel 2 bits = 8
   Output channel 2 increment = 9
   Output channel 3 bits = 8
   Output channel 3 increment = 9
   Output channel 4 bits = 8
   Output channel 4 increment = 9
   Output channel 5 bits = 8
   Output channel 5 increment = 9
   Output channel 6 bits = 8
   Output channel 6 increment = 9
   Output channel 7 bits = 8
   Output channel 7 increment = 9
   Output channel 8 bits = 8
   Output channel 8 increment = 9
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 19

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 18)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 16 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k89(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 9) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned short ova2;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned longlong ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				ti += IT_IT(it3, ip0[3]);
				
				imp = im_base + IM_O(ti >> 32);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xffffffff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k89_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 4;
	g->in.chi[0] = 4;
	g->in.chi[1] = 4;
	g->in.chi[2] = 4;
	g->in.chi[3] = 4;
	g->itres = 19;
	g->stres = 255;
	g->kdesc[0] = 52;
	g->kname[7] = 57;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 32;
	t->sx_ab = 32;
	t->sm_ts = 20;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 9
   Output channel 0 bits = 8
   Output channel 0 increment = 9
   Output channel 1 bits = 8
   Output channel 1 increment = 9
   Output channel 2 bits = 8
   Output channel 2 increment = 9
   Output channel 3 bits = 8
   Output channel 3 increment = 9
   Output channel 4 bits = 8
   Output channel 4 increment = 9
   Output channel 5 bits = 8
   Output channel 5 increment = 9
   Output channel 6 bits = 8
   Output channel 6 increment = 9
   Output channel 7 bits = 8
   Output channel 7 increment = 9
   Output channel 8 bits = 8
   Output channel 8 increment = 9
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 127

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 18)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 16 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k90(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 9) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned short ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo3;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k90_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 127;
	g->stres = 0;
	g->kname[6] = 57;
	g->kname[7] = 48;
	t->sort = 1;
	t->wo_xs = 0;
	t->ix_ab = 28;
	t->wo_ab = 36;
	t->we_ab = 9;
	t->vo_ab = 27;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 9
   Output channel 0 bits = 8
   Output channel 0 increment = 9
   Output channel 1 bits = 8
   Output channel 1 increment = 9
   Output channel 2 bits = 8
   Output channel 2 increment = 9
   Output channel 3 bits = 8
   Output channel 3 increment = 9
   Output channel 4 bits = 8
   Output channel 4 increment = 9
   Output channel 5 bits = 8
   Output channel 5 increment = 9
   Output channel 6 bits = 8
   Output channel 6 increment = 9
   Output channel 7 bits = 8
   Output channel 7 increment = 9
   Output channel 8 bits = 8
   Output channel 8 increment = 9
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 48

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 18)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 16 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k91(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 5, op0 += 9) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned short ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k91_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 5;
	g->in.chi[0] = 5;
	g->in.chi[1] = 5;
	g->in.chi[2] = 5;
	g->in.chi[3] = 5;
	g->in.chi[4] = 5;
	g->opt = 1;
	g->itres = 48;
	g->stres = 0;
	g->kdesc[0] = 53;
	g->kname[7] = 49;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 9
   Output channel 0 bits = 8
   Output channel 0 increment = 9
   Output channel 1 bits = 8
   Output channel 1 increment = 9
   Output channel 2 bits = 8
   Output channel 2 increment = 9
   Output channel 3 bits = 8
   Output channel 3 increment = 9
   Output channel 4 bits = 8
   Output channel 4 increment = 9
   Output channel 5 bits = 8
   Output channel 5 increment = 9
   Output channel 6 bits = 8
   Output channel 6 increment = 9
   Output channel 7 bits = 8
   Output channel 7 increment = 9
   Output channel 8 bits = 8
   Output channel 8 increment = 9
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 25

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 18)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 16 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k92(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 6, op0 += 9) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned short ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k92_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 6;
	g->in.chi[0] = 6;
	g->in.chi[1] = 6;
	g->in.chi[2] = 6;
	g->in.chi[3] = 6;
	g->in.chi[4] = 6;
	g->in.chi[5] = 6;
	g->opt = 1;
	g->itres = 25;
	g->stres = 0;
	g->kdesc[0] = 54;
	g->kname[7] = 50;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 9
   Output channel 0 bits = 8
   Output channel 0 increment = 9
   Output channel 1 bits = 8
   Output channel 1 increment = 9
   Output channel 2 bits = 8
   Output channel 2 increment = 9
   Output channel 3 bits = 8
   Output channel 3 increment = 9
   Output channel 4 bits = 8
   Output channel 4 increment = 9
   Output channel 5 bits = 8
   Output channel 5 increment = 9
   Output channel 6 bits = 8
   Output channel 6 increment = 9
   Output channel 7 bits = 8
   Output channel 7 increment = 9
   Output channel 8 bits = 8
   Output channel 8 increment = 9
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 27
   Interpolation table max resolution = 14

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 18)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 16 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k93(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 7, op0 += 9) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned short ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0xfffffff);	/* Extract offset value */
				wo0 = (wo0 >> 28);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0xfffffff);	/* Extract offset value */
				wo1 = (wo1 >> 28);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0xfffffff);	/* Extract offset value */
				wo2 = (wo2 >> 28);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0xfffffff);	/* Extract offset value */
				wo3 = (wo3 >> 28);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0xfffffff);	/* Extract offset value */
				wo4 = (wo4 >> 28);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0xfffffff);	/* Extract offset value */
				wo5 = (wo5 >> 28);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0xfffffff);	/* Extract offset value */
				wo6 = (wo6 >> 28);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k93_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 7;
	g->in.chi[0] = 7;
	g->in.chi[1] = 7;
	g->in.chi[2] = 7;
	g->in.chi[3] = 7;
	g->in.chi[4] = 7;
	g->in.chi[5] = 7;
	g->in.chi[6] = 7;
	g->opt = 1;
	g->itres = 14;
	g->stres = 0;
	g->kdesc[0] = 55;
	g->kname[7] = 51;
	t->ix_ab = 27;
	t->wo_ab = 37;
	t->vo_ab = 28;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 9
   Output channel 0 bits = 8
   Output channel 0 increment = 9
   Output channel 1 bits = 8
   Output channel 1 increment = 9
   Output channel 2 bits = 8
   Output channel 2 increment = 9
   Output channel 3 bits = 8
   Output channel 3 increment = 9
   Output channel 4 bits = 8
   Output channel 4 increment = 9
   Output channel 5 bits = 8
   Output channel 5 increment = 9
   Output channel 6 bits = 8
   Output channel 6 increment = 9
   Output channel 7 bits = 8
   Output channel 7 increment = 9
   Output channel 8 bits = 8
   Output channel 8 increment = 9
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 27
   Interpolation table max resolution = 10

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 18)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 16 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k94(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 8, op0 += 9) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned short ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0xfffffff);	/* Extract offset value */
				wo0 = (wo0 >> 28);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0xfffffff);	/* Extract offset value */
				wo1 = (wo1 >> 28);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0xfffffff);	/* Extract offset value */
				wo2 = (wo2 >> 28);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0xfffffff);	/* Extract offset value */
				wo3 = (wo3 >> 28);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0xfffffff);	/* Extract offset value */
				wo4 = (wo4 >> 28);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0xfffffff);	/* Extract offset value */
				wo5 = (wo5 >> 28);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0xfffffff);	/* Extract offset value */
				wo6 = (wo6 >> 28);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0xfffffff);	/* Extract offset value */
				wo7 = (wo7 >> 28);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k94_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 8;
	g->in.chi[0] = 8;
	g->in.chi[1] = 8;
	g->in.chi[2] = 8;
	g->in.chi[3] = 8;
	g->in.chi[4] = 8;
	g->in.chi[5] = 8;
	g->in.chi[6] = 8;
	g->in.chi[7] = 8;
	g->opt = 1;
	g->itres = 10;
	g->stres = 0;
	g->kdesc[0] = 56;
	g->kname[7] = 52;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 9
   Input channel 0 bits = 8
   Input channel 0 increment = 9
   Input channel 1 bits = 8
   Input channel 1 increment = 9
   Input channel 2 bits = 8
   Input channel 2 increment = 9
   Input channel 3 bits = 8
   Input channel 3 increment = 9
   Input channel 4 bits = 8
   Input channel 4 increment = 9
   Input channel 5 bits = 8
   Input channel 5 increment = 9
   Input channel 6 bits = 8
   Input channel 6 increment = 9
   Input channel 7 bits = 8
   Input channel 7 increment = 9
   Input channel 8 bits = 8
   Input channel 8 increment = 9
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 9
   Output channel 0 bits = 8
   Output channel 0 increment = 9
   Output channel 1 bits = 8
   Output channel 1 increment = 9
   Output channel 2 bits = 8
   Output channel 2 increment = 9
   Output channel 3 bits = 8
   Output channel 3 increment = 9
   Output channel 4 bits = 8
   Output channel 4 increment = 9
   Output channel 5 bits = 8
   Output channel 5 increment = 9
   Output channel 6 bits = 8
   Output channel 6 increment = 9
   Output channel 7 bits = 8
   Output channel 7 increment = 9
   Output channel 8 bits = 8
   Output channel 8 increment = 9
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 27
   Interpolation table max resolution = 8

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 18)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 16 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k95(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 9 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 9, op0 += 9) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned short ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0xfffffff);	/* Extract offset value */
				wo0 = (wo0 >> 28);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0xfffffff);	/* Extract offset value */
				wo1 = (wo1 >> 28);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0xfffffff);	/* Extract offset value */
				wo2 = (wo2 >> 28);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0xfffffff);	/* Extract offset value */
				wo3 = (wo3 >> 28);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0xfffffff);	/* Extract offset value */
				wo4 = (wo4 >> 28);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0xfffffff);	/* Extract offset value */
				wo5 = (wo5 >> 28);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0xfffffff);	/* Extract offset value */
				wo6 = (wo6 >> 28);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0xfffffff);	/* Extract offset value */
				wo7 = (wo7 >> 28);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0xfffffff);	/* Extract offset value */
				wo8 = (wo8 >> 28);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo8;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k95_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 9;
	g->in.chi[0] = 9;
	g->in.chi[1] = 9;
	g->in.chi[2] = 9;
	g->in.chi[3] = 9;
	g->in.chi[4] = 9;
	g->in.chi[5] = 9;
	g->in.chi[6] = 9;
	g->in.chi[7] = 9;
	g->in.chi[8] = 9;
	g->opt = 1;
	g->itres = 8;
	g->stres = 0;
	g->kdesc[0] = 57;
	g->kname[7] = 53;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 10
   Input channel 0 bits = 8
   Input channel 0 increment = 10
   Input channel 1 bits = 8
   Input channel 1 increment = 10
   Input channel 2 bits = 8
   Input channel 2 increment = 10
   Input channel 3 bits = 8
   Input channel 3 increment = 10
   Input channel 4 bits = 8
   Input channel 4 increment = 10
   Input channel 5 bits = 8
   Input channel 5 increment = 10
   Input channel 6 bits = 8
   Input channel 6 increment = 10
   Input channel 7 bits = 8
   Input channel 7 increment = 10
   Input channel 8 bits = 8
   Input channel 8 increment = 10
   Input channel 9 bits = 8
   Input channel 9 increment = 10
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 9
   Output channel 0 bits = 8
   Output channel 0 increment = 9
   Output channel 1 bits = 8
   Output channel 1 increment = 9
   Output channel 2 bits = 8
   Output channel 2 increment = 9
   Output channel 3 bits = 8
   Output channel 3 increment = 9
   Output channel 4 bits = 8
   Output channel 4 increment = 9
   Output channel 5 bits = 8
   Output channel 5 increment = 9
   Output channel 6 bits = 8
   Output channel 6 increment = 9
   Output channel 7 bits = 8
   Output channel 7 increment = 9
   Output channel 8 bits = 8
   Output channel 8 increment = 9
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 27
   Interpolation table max resolution = 6

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 18)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 2 + (c) * 8))
#define IM_PE(p, v) *((unsigned short *)((p) + 16 + (v) * 2))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k96(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 10 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer it8 = (pointer)p->in_tables[8];
	pointer it9 = (pointer)p->in_tables[9];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 10, op0 += 9) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned short ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			unsigned longlong wo6;	/* Weighting value and vertex offset variable */
			unsigned longlong wo7;	/* Weighting value and vertex offset variable */
			unsigned longlong wo8;	/* Weighting value and vertex offset variable */
			unsigned longlong wo9;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it6, ip0[6]);
				wo6   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it7, ip0[7]);
				wo7   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it8, ip0[8]);
				wo8   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				ti = IT_IT(it9, ip0[9]);
				wo9   = ((ti << 27) >> 27);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 37);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
					XFR(wot, wo6);
					CJ(wo5, wot, shs6);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs6);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs6);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs6);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs6);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs6);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs6:;
					XFR(wot, wo7);
					CJ(wo6, wot, shs7);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs7);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs7);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs7);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs7);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs7);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs7);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs7:;
					XFR(wot, wo8);
					CJ(wo7, wot, shs8);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs8);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs8);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs8);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs8);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs8);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs8);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs8);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs8:;
					XFR(wot, wo9);
					CJ(wo8, wot, shs9);
					XFR(wo9, wo8);
					CXJ(wo7, wot, wo8, shs9);
					XFR(wo8, wo7);
					CXJ(wo6, wot, wo7, shs9);
					XFR(wo7, wo6);
					CXJ(wo5, wot, wo6, shs9);
					XFR(wo6, wo5);
					CXJ(wo4, wot, wo5, shs9);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs9);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs9);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs9);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs9);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs9:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0xfffffff);	/* Extract offset value */
				wo0 = (wo0 >> 28);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0xfffffff);	/* Extract offset value */
				wo1 = (wo1 >> 28);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0xfffffff);	/* Extract offset value */
				wo2 = (wo2 >> 28);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0xfffffff);	/* Extract offset value */
				wo3 = (wo3 >> 28);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0xfffffff);	/* Extract offset value */
				wo4 = (wo4 >> 28);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0xfffffff);	/* Extract offset value */
				wo5 = (wo5 >> 28);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0xfffffff);	/* Extract offset value */
				wo6 = (wo6 >> 28);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0xfffffff);	/* Extract offset value */
				wo7 = (wo7 >> 28);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo8 & 0xfffffff);	/* Extract offset value */
				wo8 = (wo8 >> 28);		/* Extract weighting value */
				vwe = wo7 - wo8;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo9 & 0xfffffff);	/* Extract offset value */
				wo9 = (wo9 >> 28);		/* Extract weighting value */
				vwe = wo8 - wo9;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo9;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k96_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 10;
	g->in.chi[0] = 10;
	g->in.chi[1] = 10;
	g->in.chi[2] = 10;
	g->in.chi[3] = 10;
	g->in.chi[4] = 10;
	g->in.chi[5] = 10;
	g->in.chi[6] = 10;
	g->in.chi[7] = 10;
	g->in.chi[8] = 10;
	g->opt = 1;
	g->stres = 0;
	g->kdesc[0] = 49;
	g->kdesc[1] = 48;
	g->kdesc[2] = 95;
	g->kdesc[3] = 57;
	g->kdesc[4] = 95;
	g->kdesc[5] = 105;
	g->kdesc[6] = 56;
	g->kdesc[7] = 95;
	g->kdesc[8] = 105;
	g->kdesc[9] = 56;
	g->kdesc[10] = 95;
	g->kdesc[11] = 102;
	g->kname[7] = 54;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 10
   Output channel 0 bits = 8
   Output channel 0 increment = 10
   Output channel 1 bits = 8
   Output channel 1 increment = 10
   Output channel 2 bits = 8
   Output channel 2 increment = 10
   Output channel 3 bits = 8
   Output channel 3 increment = 10
   Output channel 4 bits = 8
   Output channel 4 increment = 10
   Output channel 5 bits = 8
   Output channel 5 increment = 10
   Output channel 6 bits = 8
   Output channel 6 increment = 10
   Output channel 7 bits = 8
   Output channel 7 increment = 10
   Output channel 8 bits = 8
   Output channel 8 increment = 10
   Output channel 9 bits = 8
   Output channel 9 increment = 10
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 20)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 16 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k97(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer ot9 = (pointer)p->out_tables[9];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 10) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[9] = OT_E(ot9, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k97_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 1;
	g->od = 10;
	g->in.chi[0] = 1;
	g->out.chi[0] = 10;
	g->out.chi[1] = 10;
	g->out.chi[2] = 10;
	g->out.chi[3] = 10;
	g->out.chi[4] = 10;
	g->out.chi[5] = 10;
	g->out.chi[6] = 10;
	g->out.chi[7] = 10;
	g->out.chi[8] = 10;
	g->out.bpch[9] = 8;
	g->out.chi[9] = 10;
	g->out.bpv[9] = 8;
	g->opt = 17;
	g->itres = 255;
	g->kdesc[1] = 95;
	g->kdesc[2] = 49;
	g->kdesc[3] = 48;
	g->kname[7] = 55;
	t->sort = 0;
	t->it_ab = 8;
	t->it_ts = 1;
	t->ix_ab = 8;
	t->sx_ab = 0;
	t->sm_ts = 4;
	t->wo_ab = 16;
	t->wo_es = 2;
	t->vo_ab = 7;
	t->vo_om = 5;
	t->im_ts = 20;
	t->im_oc = 4;
	t->im_ps = 4;
	t->im_pv = 2;
	t->ot_bits[9] = 8;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 10
   Output channel 0 bits = 8
   Output channel 0 increment = 10
   Output channel 1 bits = 8
   Output channel 1 increment = 10
   Output channel 2 bits = 8
   Output channel 2 increment = 10
   Output channel 3 bits = 8
   Output channel 3 increment = 10
   Output channel 4 bits = 8
   Output channel 4 increment = 10
   Output channel 5 bits = 8
   Output channel 5 increment = 10
   Output channel 6 bits = 8
   Output channel 6 increment = 10
   Output channel 7 bits = 8
   Output channel 7 increment = 10
   Output channel 8 bits = 8
   Output channel 8 increment = 10
   Output channel 9 bits = 8
   Output channel 9 increment = 10
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 0
   Interpolation table index bits = 14
   Interpolation table max resolution = 16383

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 20)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 16 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k98(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer ot9 = (pointer)p->out_tables[9];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 1, op0 += 10) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = (ti & 0x3ffff);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 18);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x1ff);	/* Extract offset value */
				wo0 = (wo0 >> 9);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo0;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[9] = OT_E(ot9, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k98_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 16383;
	g->stres = 0;
	g->kname[7] = 56;
	t->sort = 1;
	t->it_ab = 32;
	t->it_ts = 4;
	t->ix_ab = 14;
	t->wo_ab = 18;
	t->vo_ab = 9;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 10
   Output channel 0 bits = 8
   Output channel 0 increment = 10
   Output channel 1 bits = 8
   Output channel 1 increment = 10
   Output channel 2 bits = 8
   Output channel 2 increment = 10
   Output channel 3 bits = 8
   Output channel 3 increment = 10
   Output channel 4 bits = 8
   Output channel 4 increment = 10
   Output channel 5 bits = 8
   Output channel 5 increment = 10
   Output channel 6 bits = 8
   Output channel 6 increment = 10
   Output channel 7 bits = 8
   Output channel 7 increment = 10
   Output channel 8 bits = 8
   Output channel 8 increment = 10
   Output channel 9 bits = 8
   Output channel 9 increment = 10
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 20)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 16 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k99(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer ot9 = (pointer)p->out_tables[9];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 10) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[9] = OT_E(ot9, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k99_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 3;
	g->in.chi[0] = 3;
	g->in.chi[1] = 3;
	g->in.chi[2] = 3;
	g->itres = 101;
	g->stres = 16;
	g->kdesc[0] = 51;
	g->kname[7] = 57;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 20;
	t->sx_ab = 12;
	t->sm_ts = 16;
	t->wo_es = 4;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 10
   Output channel 0 bits = 8
   Output channel 0 increment = 10
   Output channel 1 bits = 8
   Output channel 1 increment = 10
   Output channel 2 bits = 8
   Output channel 2 increment = 10
   Output channel 3 bits = 8
   Output channel 3 increment = 10
   Output channel 4 bits = 8
   Output channel 4 increment = 10
   Output channel 5 bits = 8
   Output channel 5 increment = 10
   Output channel 6 bits = 8
   Output channel 6 increment = 10
   Output channel 7 bits = 8
   Output channel 7 increment = 10
   Output channel 8 bits = 8
   Output channel 8 increment = 10
   Output channel 9 bits = 8
   Output channel 9 increment = 10
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 12
   Interpolation table index bits = 29
   Interpolation table max resolution = 812

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 20)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 16 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k100(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer ot9 = (pointer)p->out_tables[9];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 3, op0 += 10) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo1, wo2);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo2;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[9] = OT_E(ot9, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k100_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 812;
	g->stres = 0;
	g->kname[6] = 49;
	g->kname[7] = 48;
	g->kname[8] = 48;
	t->sort = 1;
	t->wo_xs = 0;
	t->it_ab = 64;
	t->it_ts = 8;
	t->ix_ab = 29;
	t->wo_ab = 35;
	t->we_ab = 9;
	t->vo_ab = 26;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 10
   Output channel 0 bits = 8
   Output channel 0 increment = 10
   Output channel 1 bits = 8
   Output channel 1 increment = 10
   Output channel 2 bits = 8
   Output channel 2 increment = 10
   Output channel 3 bits = 8
   Output channel 3 increment = 10
   Output channel 4 bits = 8
   Output channel 4 increment = 10
   Output channel 5 bits = 8
   Output channel 5 increment = 10
   Output channel 6 bits = 8
   Output channel 6 increment = 10
   Output channel 7 bits = 8
   Output channel 7 increment = 10
   Output channel 8 bits = 8
   Output channel 8 increment = 10
   Output channel 9 bits = 8
   Output channel 9 increment = 10
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 23

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 20)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 16 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k101(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer ot9 = (pointer)p->out_tables[9];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 10) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned longlong ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				ti += IT_IT(it3, ip0[3]);
				
				imp = im_base + IM_O(ti >> 32);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xffffffff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[9] = OT_E(ot9, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k101_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 4;
	g->in.chi[0] = 4;
	g->in.chi[1] = 4;
	g->in.chi[2] = 4;
	g->in.chi[3] = 4;
	g->itres = 23;
	g->stres = 255;
	g->kdesc[0] = 52;
	g->kname[8] = 49;
	t->sort = 0;
	t->wo_xs = 1;
	t->ix_ab = 32;
	t->sx_ab = 32;
	t->sm_ts = 20;
	t->we_ab = 16;
	t->vo_ab = 16;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 10
   Output channel 0 bits = 8
   Output channel 0 increment = 10
   Output channel 1 bits = 8
   Output channel 1 increment = 10
   Output channel 2 bits = 8
   Output channel 2 increment = 10
   Output channel 3 bits = 8
   Output channel 3 increment = 10
   Output channel 4 bits = 8
   Output channel 4 increment = 10
   Output channel 5 bits = 8
   Output channel 5 increment = 10
   Output channel 6 bits = 8
   Output channel 6 increment = 10
   Output channel 7 bits = 8
   Output channel 7 increment = 10
   Output channel 8 bits = 8
   Output channel 8 increment = 10
   Output channel 9 bits = 8
   Output channel 9 increment = 10
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 29
   Interpolation table max resolution = 152

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 20)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 16 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k102(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer ot9 = (pointer)p->out_tables[9];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 4, op0 += 10) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 29) >> 29);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 35);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x3ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 26);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x3ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 26);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x3ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 26);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x3ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 26);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo3;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[9] = OT_E(ot9, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k102_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->opt = 17;
	g->itres = 152;
	g->stres = 0;
	g->kname[8] = 50;
	t->sort = 1;
	t->wo_xs = 0;
	t->ix_ab = 29;
	t->we_ab = 9;
	t->vo_ab = 26;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 10
   Output channel 0 bits = 8
   Output channel 0 increment = 10
   Output channel 1 bits = 8
   Output channel 1 increment = 10
   Output channel 2 bits = 8
   Output channel 2 increment = 10
   Output channel 3 bits = 8
   Output channel 3 increment = 10
   Output channel 4 bits = 8
   Output channel 4 increment = 10
   Output channel 5 bits = 8
   Output channel 5 increment = 10
   Output channel 6 bits = 8
   Output channel 6 increment = 10
   Output channel 7 bits = 8
   Output channel 7 increment = 10
   Output channel 8 bits = 8
   Output channel 8 increment = 10
   Output channel 9 bits = 8
   Output channel 9 increment = 10
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 48

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 20)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 16 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k103(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer ot9 = (pointer)p->out_tables[9];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 5, op0 += 10) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova1 >> 40) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova1 >> 56) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[8] = OT_E(ot8, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[9] = OT_E(ot9, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef CXJ
#undef CJ
#undef XFR
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

void
imdi_k103_gentab(
genspec *g,		/* structure to be updated */
tabspec *t		/* structure to be updated */
) {
	g->id = 5;
	g->in.chi[0] = 5;
	g->in.chi[1] = 5;
	g->in.chi[2] = 5;
	g->in.chi[3] = 5;
	g->in.chi[4] = 5;
	g->opt = 1;
	g->itres = 48;
	g->stres = 0;
	g->kdesc[0] = 53;
	g->kname[8] = 51;
	t->ix_ab = 28;
	t->wo_ab = 36;
	t->vo_ab = 27;
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2007 Graeme W. Gill */
/* All rights reserved. */
/* This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :- */

/* see the License.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 10
   Output channel 0 bits = 8
   Output channel 0 increment = 10
   Output channel 1 bits = 8
   Output channel 1 increment = 10
   Output channel 2 bits = 8
   Output channel 2 increment = 10
   Output channel 3 bits = 8
   Output channel 3 increment = 10
   Output channel 4 bits = 8
   Output channel 4 increment = 10
   Output channel 5 bits = 8
   Output channel 5 increment = 10
   Output channel 6 bits = 8
   Output channel 6 increment = 10
   Output channel 7 bits = 8
   Output channel 7 increment = 10
   Output channel 8 bits = 8
   Output channel 8 increment = 10
   Output channel 9 bits = 8
   Output channel 9 increment = 10
   Output is channel interleaved
   Output channels are separate words

   Basic Internal precision bits  = 8
   Weight+voffset bits       = 32
   Interpolation table index bits = 28
   Interpolation table max resolution = 25

   Processing direction is forwards
   Input stride is not supported
   Output stride is not supported
   Prefer simplex over sort algorithm
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 64 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Ordinal size 64 bits is known as 'unsigned longlong'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Integer size 64 bits is known as 'longlong'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_utl.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp index, weighting and vertex offset */
#define IT_IT(p, off) *((unsigned longlong *)((p) + 0 + (off) * 8))

/* Sorting macros */
#define XFR(A, B) A = B;
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }
#define CXJ(A, B, D, L) if (A >= B) { D = B; goto L; }
#define CJ(A, B, L) if (A >= B) goto L;

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 20)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned longlong *)((p) + (v) * 4 + (c) * 8))
#define IM_PE(p, v) *((unsigned int *)((p) + 16 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

void
imdi_k104(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
int  ostride,		/* optional input component stride */
void **inp,		/* pointer to input pointers */
int  istride,		/* optional input component stride */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = (unsigned char *)inp[0] + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer ot8 = (pointer)p->out_tables[8];
	pointer ot9 = (pointer)p->out_tables[9];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 != ep; ip0 += 6, op0 += 10) {
		unsigned longlong ova0;	/* Output value accumulator */
		unsigned longlong ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned longlong wo0;	/* Weighting value and vertex offset variable */
			unsigned longlong wo1;	/* Weighting value and vertex offset variable */
			unsigned longlong wo2;	/* Weighting value and vertex offset variable */
			unsigned longlong wo3;	/* Weighting value and vertex offset variable */
			unsigned longlong wo4;	/* Weighting value and vertex offset variable */
			unsigned longlong wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned longlong ti;		/* Input table entry variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti = IT_IT(it0, ip0[0]);
				wo0   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i  = (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it1, ip0[1]);
				wo1   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it2, ip0[2]);
				wo2   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it3, ip0[3]);
				wo3   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it4, ip0[4]);
				wo4   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				ti = IT_IT(it5, ip0[5]);
				wo5   = ((ti << 28) >> 28);	/* Extract weighting/vertex offset value */
				ti_i += (ti >> 36);	/* Extract interpolation table value */
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				{
					unsigned longlong wot;	/* Sort temp variable */
					
					CEX(wo0, wo1);
					XFR(wot, wo2);
					CJ(wo1, wot, shs2);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs2);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs2:;
					XFR(wot, wo3);
					CJ(wo2, wot, shs3);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs3);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs3);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs3:;
					XFR(wot, wo4);
					CJ(wo3, wot, shs4);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs4);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs4);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs4);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs4:;
					XFR(wot, wo5);
					CJ(wo4, wot, shs5);
					XFR(wo5, wo4);
					CXJ(wo3, wot, wo4, shs5);
					XFR(wo4, wo3);
					CXJ(wo2, wot, wo3, shs5);
					XFR(wo3, wo2);
					CXJ(wo1, wot, wo2, shs5);
					XFR(wo2, wo1);
					CXJ(wo0, wot, wo1, shs5);
					XFR(wo1, wo0);
					XFR(wo0, wot);
shs5:;
				}
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7ffffff);	/* Extract offset value */
				wo0 = (wo0 >> 27);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7ffffff);	/* Extract offset value */
				wo1 = (wo1 >> 27);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7ffffff);	/* Extract offset value */
				wo2 = (wo2 >> 27);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7ffffff);	/* Extract offset value */
				wo3 = (wo3 >> 27);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7ffffff);	/* Extract offset value */
				wo4 = (wo4 >> 27);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7ffffff);	/* Extract offset value */
				wo5 = (wo5 >> 27);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova0 >> 40) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova0 >> 56) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
