#include <assert.h>
#include <string.h>
#include <stdio.h>

#include <rtosc/rtosc-version.h>

int rtosc_version_cmp(rtosc_version v1, rtosc_version v2)
{
    unsigned char v1_str[3] = { v1.major, v1.minor, v1.revision };
    unsigned char v2_str[3] = { v2.major, v2.minor, v2.revision };
    return memcmp(v1_str, v2_str, 3);
}

rtosc_version rtosc_current_version()
{
    return ((rtosc_version) { 0,
                              3,
                              1 } );
}

void rtosc_version_print_to_12byte_str(const rtosc_version* v,
                                       char* _12bytes)
{
    snprintf(_12bytes, 12, "%u.%u.%u",
             (unsigned)v->major, (unsigned)v->minor, (unsigned)v->revision);
}

