#ifndef __2xBRZ_INCLUDE_H__
#define __2xBRZ_INCLUDE_H__
static const GLchar Yglprg_blit_2xbrz_v[] =
"#version 310 es \n"
" layout (location = 0) in vec2 VertexCoord;\n"
" layout (location = 1) in vec2 TexCoord;\n"
" uniform vec2 TextureSize;\n"
"out vec2 vTexCoord;\n"
"out vec4 t1;\n"
"out vec4 t2;\n"
"out vec4 t3;\n"
"out vec4 t4;\n"
"out vec4 t5;\n"
"out vec4 t6;\n"
"out vec4 t7;\n"
"\n"
"#define SourceSize vec4(TextureSize, 1.0 / TextureSize)\n"
"\n"
"void main()\n"
"{\n"
"    gl_Position = vec4(VertexCoord, 0.0, 1.0);\n"
"    vTexCoord = TexCoord;\n"
"	vec2 ps = vec2(SourceSize.z, SourceSize.w);\n"
"	float dx = ps.x;\n"
"	float dy = ps.y;\n"
"\n"
"	 //  A1 B1 C1\n"
"	// A0 A  B  C C4\n"
"	// D0 D  E  F F4\n"
"	// G0 G  H  I I4\n"
"	 //  G5 H5 I5\n"
"\n"
"	t1 = TexCoord.xxxy + vec4( -dx, 0.0, dx,-2.0*dy); // A1 B1 C1\n"
"	t2 = TexCoord.xxxy + vec4( -dx, 0.0, dx, -dy);    //  A  B  C\n"
"	t3 = TexCoord.xxxy + vec4( -dx, 0.0, dx, 0.0);    //  D  E  F\n"
"	t4 = TexCoord.xxxy + vec4( -dx, 0.0, dx, dy);     //  G  H  I\n"
"	t5 = TexCoord.xxxy + vec4( -dx, 0.0, dx, 2.0*dy); // G5 H5 I5\n"
"	t6 = TexCoord.xyyy + vec4(-2.0*dx,-dy, 0.0, dy);  // A0 D0 G0\n"
"	t7 = TexCoord.xyyy + vec4( 2.0*dx,-dy, 0.0, dy);  // C4 F4 I4\n"
"}\n";

static const GLchar Yglprg_blit_2xbrz_f[] =
"#version 310 es \n"

"\n"
"#ifdef GL_ES\n"
"#ifdef GL_FRAGMENT_PRECISION_HIGH\n"
"precision highp float;\n"
"#else\n"
"precision mediump float;\n"
"#endif\n"
"#endif\n"
"#define BLEND_NONE 0\n"
"#define BLEND_NORMAL 1\n"
"#define BLEND_DOMINANT 2\n"
"#define LUMINANCE_WEIGHT 1.0\n"
"#define EQUAL_COLOR_TOLERANCE 30.0/255.0\n"
"#define STEEP_DIRECTION_THRESHOLD 2.2\n"
"#define DOMINANT_DIRECTION_THRESHOLD 3.6\n"
"#define M_PI 3.1415926535897932384626433832795\n"
"\n"
"uniform vec2 TextureSize;\n"
"uniform sampler2D Texture;\n"
"out vec4 fragColor;\n"
"in vec2 vTexCoord;\n"
"in vec4 t1;\n"
"in vec4 t2;\n"
"in vec4 t3;\n"
"in vec4 t4;\n"
"in vec4 t5;\n"
"in vec4 t6;\n"
"in vec4 t7;\n"
"\n"
"#define SourceSize vec4(TextureSize, 1.0 / TextureSize)"
"\n"
"	const float  one_sixth = 1.0 / 6.0;\n"
"	const float  two_sixth = 2.0 / 6.0;\n"
"	const float four_sixth = 4.0 / 6.0;\n"
"	const float five_sixth = 5.0 / 6.0;\n"
"\n"
"	float reduce(const vec3 color)\n"
"	{\n"
"		return dot(color, vec3(65536.0, 256.0, 1.0));\n"
"	}\n"
"	\n"
"	float DistYCbCr(const vec3 pixA, const vec3 pixB)\n"
"	{\n"
"		const vec3 w = vec3(0.2627, 0.6780, 0.0593);\n"
"		const float scaleB = 0.5 / (1.0 - w.b);\n"
"		const float scaleR = 0.5 / (1.0 - w.r);\n"
"		vec3 diff = pixA - pixB;\n"
"		float Y = dot(diff, w);\n"
"		float Cb = scaleB * (diff.b - Y);\n"
"		float Cr = scaleR * (diff.r - Y);\n"
"		\n"
"		return sqrt( ((LUMINANCE_WEIGHT * Y) * (LUMINANCE_WEIGHT * Y)) + (Cb * Cb) + (Cr * Cr) );\n"
"	}\n"
"	\n"
"	bool IsPixEqual(const vec3 pixA, const vec3 pixB)\n"
"	{\n"
"		return (DistYCbCr(pixA, pixB) < EQUAL_COLOR_TOLERANCE);\n"
"	}\n"
"	\n"
"	bool IsBlendingNeeded(const ivec4 blend)\n"
"	{\n"
"		return any(notEqual(blend, ivec4(BLEND_NONE)));\n"
"	}\n"
"	\n"
"	void ScalePixel(const ivec4 blend, const vec3 k[9], vec3 dst[4])\n"
"	{\n"
"		float v0 = reduce(k[0]);\n"
"		float v4 = reduce(k[4]);\n"
"		float v5 = reduce(k[5]);\n"
"		float v7 = reduce(k[7]);\n"
"		float v8 = reduce(k[8]);\n"
		
"		float dist_01_04 = DistYCbCr(k[1], k[4]);\n"
"		float dist_03_08 = DistYCbCr(k[3], k[8]);\n"
"		bool haveShallowLine = (STEEP_DIRECTION_THRESHOLD * dist_01_04 <= dist_03_08) && (v0 != v4) && (v5 != v4);\n"
"		bool haveSteepLine   = (STEEP_DIRECTION_THRESHOLD * dist_03_08 <= dist_01_04) && (v0 != v8) && (v7 != v8);\n"
"		bool needBlend = (blend[2] != BLEND_NONE);\n"
"		bool doLineBlend = (  blend[2] >= BLEND_DOMINANT ||\n"
"					       !((blend[1] != BLEND_NONE && !IsPixEqual(k[0], k[4])) ||\n"
"					         (blend[3] != BLEND_NONE && !IsPixEqual(k[0], k[8])) ||\n"
"					         (IsPixEqual(k[4], k[3]) && IsPixEqual(k[3], k[2]) && IsPixEqual(k[2], k[1]) && IsPixEqual(k[1], k[8]) && !IsPixEqual(k[0], k[2])) ) );\n"
"			\n"
"		vec3 blendPix = ( DistYCbCr(k[0], k[1]) <= DistYCbCr(k[0], k[3]) ) ? k[1] : k[3];\n"
"		dst[1] = mix(dst[1], blendPix, (needBlend && doLineBlend && haveSteepLine) ? 0.25 : 0.00);\n"
"		dst[2] = mix(dst[2], blendPix, (needBlend) ? ((doLineBlend) ? ((haveShallowLine) ? ((haveSteepLine) ? 5.0/6.0 : 0.75) : ((haveSteepLine) ? 0.75 : 0.50)) : 1.0 - (M_PI/4.0)) : 0.00);\n"
"		dst[3] = mix(dst[3], blendPix, (needBlend && doLineBlend && haveShallowLine) ? 0.25 : 0.00);\n"
"	}\n"
"\n"
"void main()\n"
"{\n"
"\n"
"	//---------------------------------------\n"
"	// Input Pixel Mapping:  20|21|22|23|24\n"
"	//                       19|06|07|08|09\n"
"	//                       18|05|00|01|10\n"
"	//                       17|04|03|02|11\n"
"	//                       16|15|14|13|12\n"
"  \n"
"	vec3 src[25];\n"
"  \n"
"	src[21] = texture(Texture, t1.xw).rgb;\n"
"	src[22] = texture(Texture, t1.yw).rgb;\n"
"	src[23] = texture(Texture, t1.zw).rgb;\n"
"	src[ 6] = texture(Texture, t2.xw).rgb;\n"
"	src[ 7] = texture(Texture, t2.yw).rgb;\n"
"	src[ 8] = texture(Texture, t2.zw).rgb;\n"
"	src[ 5] = texture(Texture, t3.xw).rgb;\n"
"	src[ 0] = texture(Texture, t3.yw).rgb;\n"
"	src[ 1] = texture(Texture, t3.zw).rgb;\n"
"	src[ 4] = texture(Texture, t4.xw).rgb;\n"
"	src[ 3] = texture(Texture, t4.yw).rgb;\n"
"	src[ 2] = texture(Texture, t4.zw).rgb;\n"
"	src[15] = texture(Texture, t5.xw).rgb;\n"
"	src[14] = texture(Texture, t5.yw).rgb;\n"
"	src[13] = texture(Texture, t5.zw).rgb;\n"
"	src[19] = texture(Texture, t6.xy).rgb;\n"
"	src[18] = texture(Texture, t6.xz).rgb;\n"
"	src[17] = texture(Texture, t6.xw).rgb;\n"
"	src[ 9] = texture(Texture, t7.xy).rgb;\n"
"	src[10] = texture(Texture, t7.xz).rgb;\n"
"	src[11] = texture(Texture, t7.xw).rgb;\n"
"	\n"
"		float v[9];\n"
"		v[0] = reduce(src[0]);\n"
"		v[1] = reduce(src[1]);\n"
"		v[2] = reduce(src[2]);\n"
"		v[3] = reduce(src[3]);\n"
"		v[4] = reduce(src[4]);\n"
"		v[5] = reduce(src[5]);\n"
"		v[6] = reduce(src[6]);\n"
"		v[7] = reduce(src[7]);\n"
"		v[8] = reduce(src[8]);\n"
"		\n"
"		ivec4 blendResult = ivec4(BLEND_NONE);\n"
"		\n"
"		// Preprocess corners\n"
"		// Pixel Tap Mapping: --|--|--|--|--\n"
"		//                    --|--|07|08|--\n"
"		//                    --|05|00|01|10\n"
"		//                    --|04|03|02|11\n"
"		//                    --|--|14|13|--\n"
"		// Corner (1, 1)\n"
"		if ( ((v[0] == v[1] && v[3] == v[2]) || (v[0] == v[3] && v[1] == v[2])) == false)\n"
"		{\n"
"			float dist_03_01 = DistYCbCr(src[ 4], src[ 0]) + DistYCbCr(src[ 0], src[ 8]) + DistYCbCr(src[14], src[ 2]) + DistYCbCr(src[ 2], src[10]) + (4.0 * DistYCbCr(src[ 3], src[ 1]));\n"
"			float dist_00_02 = DistYCbCr(src[ 5], src[ 3]) + DistYCbCr(src[ 3], src[13]) + DistYCbCr(src[ 7], src[ 1]) + DistYCbCr(src[ 1], src[11]) + (4.0 * DistYCbCr(src[ 0], src[ 2]));\n"
"			bool dominantGradient = (DOMINANT_DIRECTION_THRESHOLD * dist_03_01) < dist_00_02;\n"
"			blendResult[2] = ((dist_03_01 < dist_00_02) && (v[0] != v[1]) && (v[0] != v[3])) ? ((dominantGradient) ? BLEND_DOMINANT : BLEND_NORMAL) : BLEND_NONE;\n"
"		}\n"
"\n"
"		// Pixel Tap Mapping: --|--|--|--|--\n"
"		//                    --|06|07|--|--\n"
"		//                    18|05|00|01|--\n"
"		//                    17|04|03|02|--\n"
"		//                    --|15|14|--|--\n"
"		// Corner (0, 1)\n"
"		if ( ((v[5] == v[0] && v[4] == v[3]) || (v[5] == v[4] && v[0] == v[3])) == false)\n"
"		{\n"
"			float dist_04_00 = DistYCbCr(src[17], src[ 5]) + DistYCbCr(src[ 5], src[ 7]) + DistYCbCr(src[15], src[ 3]) + DistYCbCr(src[ 3], src[ 1]) + (4.0 * DistYCbCr(src[ 4], src[ 0]));\n"
"			float dist_05_03 = DistYCbCr(src[18], src[ 4]) + DistYCbCr(src[ 4], src[14]) + DistYCbCr(src[ 6], src[ 0]) + DistYCbCr(src[ 0], src[ 2]) + (4.0 * DistYCbCr(src[ 5], src[ 3]));\n"
"			bool dominantGradient = (DOMINANT_DIRECTION_THRESHOLD * dist_05_03) < dist_04_00;\n"
"			blendResult[3] = ((dist_04_00 > dist_05_03) && (v[0] != v[5]) && (v[0] != v[3])) ? ((dominantGradient) ? BLEND_DOMINANT : BLEND_NORMAL) : BLEND_NONE;\n"
"		}\n"
"		\n"
"		// Pixel Tap Mapping: --|--|22|23|--\n"
"		//                    --|06|07|08|09\n"
"		//                    --|05|00|01|10\n"
"		//                    --|--|03|02|--\n"
"		//                    --|--|--|--|--\n"
"		// Corner (1, 0)\n"
"		if ( ((v[7] == v[8] && v[0] == v[1]) || (v[7] == v[0] && v[8] == v[1])) == false)\n"
"		{\n"
"			float dist_00_08 = DistYCbCr(src[ 5], src[ 7]) + DistYCbCr(src[ 7], src[23]) + DistYCbCr(src[ 3], src[ 1]) + DistYCbCr(src[ 1], src[ 9]) + (4.0 * DistYCbCr(src[ 0], src[ 8]));\n"
"			float dist_07_01 = DistYCbCr(src[ 6], src[ 0]) + DistYCbCr(src[ 0], src[ 2]) + DistYCbCr(src[22], src[ 8]) + DistYCbCr(src[ 8], src[10]) + (4.0 * DistYCbCr(src[ 7], src[ 1]));\n"
"			bool dominantGradient = (DOMINANT_DIRECTION_THRESHOLD * dist_07_01) < dist_00_08;\n"
"			blendResult[1] = ((dist_00_08 > dist_07_01) && (v[0] != v[7]) && (v[0] != v[1])) ? ((dominantGradient) ? BLEND_DOMINANT : BLEND_NORMAL) : BLEND_NONE;\n"
"		}\n"
"		\n"
"		// Pixel Tap Mapping: --|21|22|--|--\n"
"		//                    19|06|07|08|--\n"
"		//                    18|05|00|01|--\n"
"		//                    --|04|03|--|--\n"
"		//                    --|--|--|--|--\n"
"		// Corner (0, 0)\n"
"		if ( ((v[6] == v[7] && v[5] == v[0]) || (v[6] == v[5] && v[7] == v[0])) == false)\n"
"		{\n"
"			float dist_05_07 = DistYCbCr(src[18], src[ 6]) + DistYCbCr(src[ 6], src[22]) + DistYCbCr(src[ 4], src[ 0]) + DistYCbCr(src[ 0], src[ 8]) + (4.0 * DistYCbCr(src[ 5], src[ 7]));\n"
"			float dist_06_00 = DistYCbCr(src[19], src[ 5]) + DistYCbCr(src[ 5], src[ 3]) + DistYCbCr(src[21], src[ 7]) + DistYCbCr(src[ 7], src[ 1]) + (4.0 * DistYCbCr(src[ 6], src[ 0]));\n"
"			bool dominantGradient = (DOMINANT_DIRECTION_THRESHOLD * dist_05_07) < dist_06_00;\n"
"			blendResult[0] = ((dist_05_07 < dist_06_00) && (v[0] != v[5]) && (v[0] != v[7])) ? ((dominantGradient) ? BLEND_DOMINANT : BLEND_NORMAL) : BLEND_NONE;\n"
"		}\n"
"		\n"

"		vec3 dst[4];\n"
"		dst[0] = src[0];\n"
"		dst[1] = src[0];\n"
"		dst[2] = src[0];\n"
"		dst[3] = src[0];\n"
	
"		// Scale pixel\n"
"		if (IsBlendingNeeded(blendResult))\n"
"		{\n"
"			vec3 k[9];\n"
"			vec3 tempDst3;\n"
		
"			k[0] = src[0];\n"
"			k[1] = src[1];\n"
"			k[2] = src[2];\n"
"			k[3] = src[3];\n"
"			k[4] = src[4];\n"
"			k[5] = src[5];\n"
"			k[6] = src[6];\n"
"			k[7] = src[7];\n"
"			k[8] = src[8];\n"
"			ScalePixel(blendResult.xyzw, k, dst);\n"
		
"			k[1] = src[7]; \n"
"			k[2] = src[8]; \n"
"			k[3] = src[1]; \n"
"			k[4] = src[2]; \n"
"			k[5] = src[3]; \n"
"			k[6] = src[4]; \n"
"			k[7] = src[5]; \n"
"			k[8] = src[6]; \n"
"			tempDst3 = dst[3]; \n"
"			dst[3] = dst[2]; \n"
"			dst[2] = dst[1]; \n"
"			dst[1] = dst[0]; \n"
"			dst[0] = tempDst3; \n"
"			ScalePixel(blendResult.wxyz, k, dst); \n"
		
"			k[1] = src[5]; \n"
"			k[2] = src[6]; \n"
"			k[3] = src[7]; \n"
"			k[4] = src[8]; \n"
"			k[5] = src[1]; \n"
"			k[6] = src[2]; \n"
"			k[7] = src[3]; \n"
"			k[8] = src[4]; \n"
"			tempDst3 = dst[3]; \n"
"			dst[3] = dst[2]; \n"
"			dst[2] = dst[1]; \n"
"			dst[1] = dst[0]; \n"
"			dst[0] = tempDst3; \n"
"			ScalePixel(blendResult.zwxy, k, dst); \n"
		
"			k[1] = src[3]; \n"
"			k[2] = src[4]; \n"
"			k[3] = src[5]; \n"
"			k[4] = src[6]; \n"
"			k[5] = src[7]; \n"
"			k[6] = src[8]; \n"
"			k[7] = src[1]; \n"
"			k[8] = src[2]; \n"
"			tempDst3 = dst[3]; \n"
"			dst[3] = dst[2]; \n"
"			dst[2] = dst[1]; \n"
"			dst[1] = dst[0]; \n"
"			dst[0] = tempDst3; \n"
"			ScalePixel(blendResult.yzwx, k, dst); \n"
		
"			// Rotate the destination pixels back to 0 degrees. \n"
"			tempDst3 = dst[3]; \n"
"			dst[3] = dst[2]; \n"
"			dst[2] = dst[1]; \n"
"			dst[1] = dst[0]; \n"
"			dst[0] = tempDst3; \n"
"		} \n"
		
"		vec2 f = step(0.5, fract(vTexCoord*SourceSize.xy)); \n"
"		vec3 res = mix( mix(dst[0], dst[1], f.x), \n"
"		                        mix(dst[3], dst[2], f.x), f.y ); \n"

"								 \n"
"   fragColor = vec4(res, 1.0);\n"
"} \n";

#endif
