/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison interface for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

#ifndef YY_YY_BUILD_ISPC_SRC_BUILD_PARSE_HH_INCLUDED
# define YY_YY_BUILD_ISPC_SRC_BUILD_PARSE_HH_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif
#if YYDEBUG
extern int yydebug;
#endif
/* "%code requires" blocks.  */
#line 33 "src/parse.yy"


#define yytnamerr lYYTNameErr


#define YYLTYPE SourcePos

# define YYLLOC_DEFAULT(Current, Rhs, N)                               \
    do                                                                 \
      if (N)                                                           \
        {                                                              \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;       \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;     \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;        \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;      \
          (Current).name         = YYRHSLOC (Rhs, 1).name    ;         \
        }                                                              \
      else                                                             \
        { /* empty RHS */                                              \
          (Current).first_line   = (Current).last_line   =             \
            YYRHSLOC (Rhs, 0).last_line;                               \
          (Current).first_column = (Current).last_column =             \
            YYRHSLOC (Rhs, 0).last_column;                             \
          (Current).name = nullptr;                        /* new */ \
        }                                                              \
    while (0)

struct ForeachDimension;

struct PragmaAttributes {
    enum class AttributeType { none, pragmaloop, pragmawarning };
    PragmaAttributes() {
        aType = AttributeType::none;
        unrollType =  Globals::pragmaUnrollType::none;
        count = -1;
    }
    AttributeType aType;
    Globals::pragmaUnrollType unrollType;
    int count;

    std::string GetString() {
        std::string s;
        if (aType == PragmaAttributes::AttributeType::pragmaloop) {
            s += "loop";
        }
        if (aType == PragmaAttributes::AttributeType::pragmawarning) {
            s += "warning";
        }
        if (unrollType == Globals::pragmaUnrollType::nounroll) {
            s += " nounroll";
        }
        if (unrollType == Globals::pragmaUnrollType::unroll) {
            s += " unroll";
        }
        if (unrollType == Globals::pragmaUnrollType::count) {
            s += " count(" + std::to_string(count) + ")";
        }
        return s;
    }
};

typedef std::pair<Declarator *, TemplateArgs *> SimpleTemplateIDType;


#line 114 "/build/ispc/src/build/./parse.hh"

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    TOKEN_INT8_CONSTANT = 258,     /* TOKEN_INT8_CONSTANT  */
    TOKEN_UINT8_CONSTANT = 259,    /* TOKEN_UINT8_CONSTANT  */
    TOKEN_INT16_CONSTANT = 260,    /* TOKEN_INT16_CONSTANT  */
    TOKEN_UINT16_CONSTANT = 261,   /* TOKEN_UINT16_CONSTANT  */
    TOKEN_INT32_CONSTANT = 262,    /* TOKEN_INT32_CONSTANT  */
    TOKEN_UINT32_CONSTANT = 263,   /* TOKEN_UINT32_CONSTANT  */
    TOKEN_INT64_CONSTANT = 264,    /* TOKEN_INT64_CONSTANT  */
    TOKEN_UINT64_CONSTANT = 265,   /* TOKEN_UINT64_CONSTANT  */
    TOKEN_INT32DOTDOTDOT_CONSTANT = 266, /* TOKEN_INT32DOTDOTDOT_CONSTANT  */
    TOKEN_UINT32DOTDOTDOT_CONSTANT = 267, /* TOKEN_UINT32DOTDOTDOT_CONSTANT  */
    TOKEN_INT64DOTDOTDOT_CONSTANT = 268, /* TOKEN_INT64DOTDOTDOT_CONSTANT  */
    TOKEN_UINT64DOTDOTDOT_CONSTANT = 269, /* TOKEN_UINT64DOTDOTDOT_CONSTANT  */
    TOKEN_FLOAT16_CONSTANT = 270,  /* TOKEN_FLOAT16_CONSTANT  */
    TOKEN_FLOAT_CONSTANT = 271,    /* TOKEN_FLOAT_CONSTANT  */
    TOKEN_DOUBLE_CONSTANT = 272,   /* TOKEN_DOUBLE_CONSTANT  */
    TOKEN_STRING_C_LITERAL = 273,  /* TOKEN_STRING_C_LITERAL  */
    TOKEN_STRING_SYCL_LITERAL = 274, /* TOKEN_STRING_SYCL_LITERAL  */
    TOKEN_IDENTIFIER = 275,        /* TOKEN_IDENTIFIER  */
    TOKEN_STRING_LITERAL = 276,    /* TOKEN_STRING_LITERAL  */
    TOKEN_TYPE_NAME = 277,         /* TOKEN_TYPE_NAME  */
    TOKEN_PRAGMA = 278,            /* TOKEN_PRAGMA  */
    TOKEN_NULL = 279,              /* TOKEN_NULL  */
    TOKEN_TEMPLATE_NAME = 280,     /* TOKEN_TEMPLATE_NAME  */
    TOKEN_TEMPLATE = 281,          /* TOKEN_TEMPLATE  */
    TOKEN_TYPENAME = 282,          /* TOKEN_TYPENAME  */
    TOKEN_PTR_OP = 283,            /* TOKEN_PTR_OP  */
    TOKEN_INC_OP = 284,            /* TOKEN_INC_OP  */
    TOKEN_DEC_OP = 285,            /* TOKEN_DEC_OP  */
    TOKEN_LEFT_OP = 286,           /* TOKEN_LEFT_OP  */
    TOKEN_RIGHT_OP = 287,          /* TOKEN_RIGHT_OP  */
    TOKEN_LE_OP = 288,             /* TOKEN_LE_OP  */
    TOKEN_GE_OP = 289,             /* TOKEN_GE_OP  */
    TOKEN_EQ_OP = 290,             /* TOKEN_EQ_OP  */
    TOKEN_NE_OP = 291,             /* TOKEN_NE_OP  */
    TOKEN_AND_OP = 292,            /* TOKEN_AND_OP  */
    TOKEN_OR_OP = 293,             /* TOKEN_OR_OP  */
    TOKEN_MUL_ASSIGN = 294,        /* TOKEN_MUL_ASSIGN  */
    TOKEN_DIV_ASSIGN = 295,        /* TOKEN_DIV_ASSIGN  */
    TOKEN_MOD_ASSIGN = 296,        /* TOKEN_MOD_ASSIGN  */
    TOKEN_ADD_ASSIGN = 297,        /* TOKEN_ADD_ASSIGN  */
    TOKEN_SUB_ASSIGN = 298,        /* TOKEN_SUB_ASSIGN  */
    TOKEN_LEFT_ASSIGN = 299,       /* TOKEN_LEFT_ASSIGN  */
    TOKEN_RIGHT_ASSIGN = 300,      /* TOKEN_RIGHT_ASSIGN  */
    TOKEN_AND_ASSIGN = 301,        /* TOKEN_AND_ASSIGN  */
    TOKEN_OR_ASSIGN = 302,         /* TOKEN_OR_ASSIGN  */
    TOKEN_XOR_ASSIGN = 303,        /* TOKEN_XOR_ASSIGN  */
    TOKEN_SIZEOF = 304,            /* TOKEN_SIZEOF  */
    TOKEN_NEW = 305,               /* TOKEN_NEW  */
    TOKEN_DELETE = 306,            /* TOKEN_DELETE  */
    TOKEN_IN = 307,                /* TOKEN_IN  */
    TOKEN_ALLOCA = 308,            /* TOKEN_ALLOCA  */
    TOKEN_INTRINSIC_CALL = 309,    /* TOKEN_INTRINSIC_CALL  */
    TOKEN_EXTERN = 310,            /* TOKEN_EXTERN  */
    TOKEN_EXPORT = 311,            /* TOKEN_EXPORT  */
    TOKEN_STATIC = 312,            /* TOKEN_STATIC  */
    TOKEN_INLINE = 313,            /* TOKEN_INLINE  */
    TOKEN_NOINLINE = 314,          /* TOKEN_NOINLINE  */
    TOKEN_VECTORCALL = 315,        /* TOKEN_VECTORCALL  */
    TOKEN_REGCALL = 316,           /* TOKEN_REGCALL  */
    TOKEN_TASK = 317,              /* TOKEN_TASK  */
    TOKEN_DECLSPEC = 318,          /* TOKEN_DECLSPEC  */
    TOKEN_UNIFORM = 319,           /* TOKEN_UNIFORM  */
    TOKEN_VARYING = 320,           /* TOKEN_VARYING  */
    TOKEN_TYPEDEF = 321,           /* TOKEN_TYPEDEF  */
    TOKEN_SOA = 322,               /* TOKEN_SOA  */
    TOKEN_UNMASKED = 323,          /* TOKEN_UNMASKED  */
    TOKEN_INT = 324,               /* TOKEN_INT  */
    TOKEN_SIGNED = 325,            /* TOKEN_SIGNED  */
    TOKEN_UNSIGNED = 326,          /* TOKEN_UNSIGNED  */
    TOKEN_FLOAT16 = 327,           /* TOKEN_FLOAT16  */
    TOKEN_FLOAT = 328,             /* TOKEN_FLOAT  */
    TOKEN_DOUBLE = 329,            /* TOKEN_DOUBLE  */
    TOKEN_INT8 = 330,              /* TOKEN_INT8  */
    TOKEN_INT16 = 331,             /* TOKEN_INT16  */
    TOKEN_INT64 = 332,             /* TOKEN_INT64  */
    TOKEN_CONST = 333,             /* TOKEN_CONST  */
    TOKEN_VOID = 334,              /* TOKEN_VOID  */
    TOKEN_BOOL = 335,              /* TOKEN_BOOL  */
    TOKEN_UINT8 = 336,             /* TOKEN_UINT8  */
    TOKEN_UINT16 = 337,            /* TOKEN_UINT16  */
    TOKEN_UINT = 338,              /* TOKEN_UINT  */
    TOKEN_UINT64 = 339,            /* TOKEN_UINT64  */
    TOKEN_ENUM = 340,              /* TOKEN_ENUM  */
    TOKEN_STRUCT = 341,            /* TOKEN_STRUCT  */
    TOKEN_TRUE = 342,              /* TOKEN_TRUE  */
    TOKEN_FALSE = 343,             /* TOKEN_FALSE  */
    TOKEN_CASE = 344,              /* TOKEN_CASE  */
    TOKEN_DEFAULT = 345,           /* TOKEN_DEFAULT  */
    TOKEN_IF = 346,                /* TOKEN_IF  */
    TOKEN_ELSE = 347,              /* TOKEN_ELSE  */
    TOKEN_SWITCH = 348,            /* TOKEN_SWITCH  */
    TOKEN_WHILE = 349,             /* TOKEN_WHILE  */
    TOKEN_DO = 350,                /* TOKEN_DO  */
    TOKEN_LAUNCH = 351,            /* TOKEN_LAUNCH  */
    TOKEN_FOREACH = 352,           /* TOKEN_FOREACH  */
    TOKEN_FOREACH_TILED = 353,     /* TOKEN_FOREACH_TILED  */
    TOKEN_FOREACH_UNIQUE = 354,    /* TOKEN_FOREACH_UNIQUE  */
    TOKEN_FOREACH_ACTIVE = 355,    /* TOKEN_FOREACH_ACTIVE  */
    TOKEN_DOTDOTDOT = 356,         /* TOKEN_DOTDOTDOT  */
    TOKEN_FOR = 357,               /* TOKEN_FOR  */
    TOKEN_GOTO = 358,              /* TOKEN_GOTO  */
    TOKEN_CONTINUE = 359,          /* TOKEN_CONTINUE  */
    TOKEN_BREAK = 360,             /* TOKEN_BREAK  */
    TOKEN_RETURN = 361,            /* TOKEN_RETURN  */
    TOKEN_CIF = 362,               /* TOKEN_CIF  */
    TOKEN_CDO = 363,               /* TOKEN_CDO  */
    TOKEN_CFOR = 364,              /* TOKEN_CFOR  */
    TOKEN_CWHILE = 365,            /* TOKEN_CWHILE  */
    TOKEN_SYNC = 366,              /* TOKEN_SYNC  */
    TOKEN_PRINT = 367,             /* TOKEN_PRINT  */
    TOKEN_ASSERT = 368,            /* TOKEN_ASSERT  */
    TOKEN_INVOKE_SYCL = 369,       /* TOKEN_INVOKE_SYCL  */
    TOKEN_ATTRIBUTE = 370,         /* TOKEN_ATTRIBUTE  */
    STRUCT_WITHOUT_ATTRIBUTE = 371 /* STRUCT_WITHOUT_ATTRIBUTE  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 188 "src/parse.yy"

    uint64_t intVal;
    float  floatVal;
    double doubleVal;
    std::string *stringVal;
    const char *constCharPtr;

    Expr *expr;
    ExprList *exprList;
    const Type *type;
    std::vector<std::pair<const Type *, SourcePos> > *typeList;
    int typeQualifier;
    StorageClass *storageClass;
    Stmt *stmt;
    DeclSpecs *declSpecs;
    AttributeList *attributeList;
    Attribute *attr;
    AttrArgument *attrArg;
    Declaration *declaration;
    std::vector<Declarator *> *declarators;
    std::vector<Declaration *> *declarationList;
    Declarator *declarator;
    std::vector<Declarator *> *structDeclaratorList;
    StructDeclaration *structDeclaration;
    std::vector<StructDeclaration *> *structDeclarationList;
    const EnumType *enumType;
    Symbol *symbol;
    std::vector<Symbol *> *symbolList;
    ForeachDimension *foreachDimension;
    std::vector<ForeachDimension *> *foreachDimensionList;
    std::pair<std::string, SourcePos> *declspecPair;
    std::vector<std::pair<std::string, SourcePos> > *declspecList;
    PragmaAttributes *pragmaAttributes;
    const TemplateArg *templateArg;
    const TemplateArgs *templateArgs;
    const TemplateParam *templateParm;
    TemplateParms *templateParmList;
    const TemplateTypeParmType *templateTypeParm;
    TemplateSymbol *functionTemplateSym;
    SimpleTemplateIDType *simpleTemplateID;

#line 289 "/build/ispc/src/build/./parse.hh"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


extern YYSTYPE yylval;
extern YYLTYPE yylloc;

int yyparse (void);


#endif /* !YY_YY_BUILD_ISPC_SRC_BUILD_PARSE_HH_INCLUDED  */
