/*=========================================================================

  Program: GDCM (Grassroots DICOM). A DICOM library

  Copyright (c) 2006-2011 Mathieu Malaterre
  All rights reserved.
  See Copyright.txt or http://gdcm.sourceforge.net/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "mec_mr3_dict.h"

// #define MEC_MR3_DICT_DEBUG

#include <assert.h>
#include <stddef.h>
#ifdef MEC_MR3_DICT_DEBUG
#include <stdio.h>
#endif

struct mec_mr3_dict {
  uint8_t group;
  uint32_t key;
  uint32_t type;
  const char *name;
};

static const struct mec_mr3_dict dict[] = {
    {0x01, 0x00000001, 0xfff00200, ""},                                 //
    {0x01, 0x0000006d, 0xff002400, ""},                                 //
    {0x01, 0x00001004, 0xff002400, ""},                                 //
    {0x01, 0x00001005, 0xff002400, ""},                                 //
    {0x01, 0x000013ec, 0xff002900, "Imaging Frequency"},                //
    {0x01, 0x00004e23, 0xff002c00, "Software Version"},                 //
    {0x01, 0x000055f0, 0x0007d000, ""},                                 //
    {0x01, 0x000055f1, 0x00000300, "Patient ID"},                       //
    {0x01, 0x000055f2, 0x00000300, "Patient Name Ideographic"},         //
    {0x01, 0x000055f3, 0x00000300, "Patient Name Alphabetic"},          //
    {0x01, 0x000055f6, 0x00000200, ""},                                 //
    {0x01, 0x000055f7, 0xff000400, ""},                                 //
    {0x01, 0x000055f8, 0xff000800, "Patient Size (cm)"},                //
    {0x01, 0x000055f9, 0xff000800, "Patient Weight"},                   //
    {0x01, 0x000055fa, 0x00000300, "Patient Comments"},                 //
    {0x01, 0x000055fb, 0x00000300, "Name of Physician Reading Study"},  //
    {0x01, 0x000055fc, 0x00000300, "Referring Physician Name"},         //
    {0x01, 0x000055fd, 0x00000300, "Department Name (surgery)"},        //
    {0x01, 0x000055fe, 0x00000300, "Operator Name"},                    //
    {0x01, 0x000055ff, 0x00000100, ""},                                 //
    {0x01, 0x00005601, 0x00000300, "Study Description"},                //
    {0x01, 0x00005602, 0x00000300, ""},                                 //
    {0x01, 0x00005603, 0x00000100, ""},                                 //
    {0x01, 0x00005604, 0xff000400, ""},                                 //
    {0x01, 0x00005606, 0x00000300, "Institution Name"},                 //
    {0x01, 0x0000560a, 0xff002c00, "Patient Age"},                      //
    {0x01, 0x0000560b, 0xff002c00, "Patient ID"},                       //
    {0x01, 0x0000560c, 0xff002c00, "Patient Name Ideographic"},         //
    {0x01, 0x0000560d, 0xff002c00, "Patient Name Alphabetic"},          //
    {0x01, 0x00005610, 0xff002c00, "Patient Comments"},                 //
    {0x01, 0x00005611, 0xff002c00, "Name of Physician Reading Study"},  //
    {0x01, 0x00005612, 0xff002c00, "Referring Physician Name"},         //
    {0x01, 0x00005613, 0xff002c00, "Department Name (surgery)"},        //
    {0x01, 0x00005614, 0xff002c00, "Operator Name"},                    //
    {0x01, 0x00005616, 0xff002c00, "Study Description"},                //
    {0x01, 0x00005617, 0xff002c00, ""},                                 //
    {0x01, 0x00005618, 0xff002c00, "Institution Name"},                 //
    {0x01, 0x00005619, 0xff002c00, ""},                                 //
    {0x01, 0x0000561a, 0x00000e00, "Study DateTime"},                   //
    {0x01, 0x0000561b, 0x00000e00, "Study Date"},                       //
    {0x01, 0x000059d8, 0xff002400, ""},                                 //
    {0x01, 0x00006d61, 0xff002c00, "Requested Procedure ID"},           //
    {0x01, 0x00006d62, 0xff002c00, ""},                                 //
    {0x01, 0x00006d63, 0xff002c00, "Procedure Code Sequence: Coding Scheme Designator"},                    //
    {0x01, 0x00006d64, 0xff002c00, "Procedure Code Sequence: Code Meaning"},  //
    {0x01, 0x00006d65, 0xff002c00, "Study Instance UID"},                     //
    {0x01, 0x00006d66, 0xff002c00, "Stentor Remote AETitle Element"},         //
    {0x01, 0x00006d67, 0xff002c00, "Scheduled Procedure Step Description"},   //
    {0x01, 0x00006d68, 0xff002c00, "Scheduled Procedure Step ID"},            //
    {0x01, 0x00006d69, 0xff002c00, "Requested Procedure ID"},                 //
    {0x01, 0x00006d71, 0xff002c00, ""},                                       //
    {0x01, 0x00006d72, 0xff002c00, "Procedure Code Sequence: Code Value"},    //
    {0x01, 0x00006d73, 0xff002c00, "Procedure Code Sequence: Coding Scheme Designator"},                    //
    {0x01, 0x00006d74, 0xff002c00, "Procedure Code Sequence: Code Meaning"},  //
    {0x01, 0x00006d75, 0xff002c00, ""},                                       //
    {0x01, 0x00006d76, 0xff002c00, "Scheduled Procedure Step Description"},   //
    {0x01, 0x00006d77, 0xff002c00, "Referring Physician Name"},               //
    {0x01, 0x00006d78, 0xff002c00, "DetachedStudyManagement UID"},            //
    {0x01, 0x00006d79, 0xff002c00, "Referenced Study Instance UID"},          //
    {0x01, 0x00006d80, 0x001f4400, ""},                                       //
    {0x01, 0x00006d81, 0x001f4000, ""},                                       //
    {0x01, 0x00006d82, 0x001f4100, ""},                                       //
    {0x01, 0x00006d83, 0x001f4300, ""},                                       //
    {0x01, 0x00006d84, 0x001f4000, ""},                                       //
    {0x01, 0x00006d87, 0xff002400, ""},                                       //
    {0x01, 0x00006d8a, 0x001f4600, ""},                                       //
    {0x01, 0x00006d8b, 0xff002400, ""},                                       //
    {0x01, 0x0000ac09, 0xff002400, ""},                                       //
    {0x02, 0x00000002, 0xfff00200, ""},                                       //
    {0x02, 0x00000007, 0xfff00200, ""},                                       //
    {0x02, 0x0000000b, 0xfff00200, ""},                                       //
    {0x02, 0x0000006e, 0xff002400, ""},                                       //
    {0x02, 0x00000070, 0xff002400, ""},                                       //
    {0x02, 0x00001006, 0xff002800, ""},                                       //
    {0x02, 0x00001007, 0xff002800, ""},                                       //
    {0x02, 0x000017d4, 0xff002a00, ""},                                       //
    {0x02, 0x000017d5, 0xff002a00, ""},                                       //
    {0x02, 0x000017d6, 0xff002a00, ""},                                       //
    {0x02, 0x000017d7, 0xff002a00, ""},                                       //
    {0x02, 0x000017d8, 0xff002a00, ""},                                       //
    {0x02, 0x000017d9, 0xff002a00, ""},                                       //
    {0x02, 0x000017da, 0xff002a00, ""},                                       //
    {0x02, 0x000017db, 0xff002a00, ""},                                       //
    {0x02, 0x000017dc, 0xff002a00, ""},                                       //
    {0x02, 0x000017dd, 0xff002a00, ""},                                       //
    {0x02, 0x000017de, 0xff002400, ""},                                       //
    {0x02, 0x000017df, 0x00177000, ""},                                       //
    {0x02, 0x000017e0, 0x00177000, ""},                                       //
    {0x02, 0x000017e1, 0x00177000, ""},                                       //
    {0x02, 0x000017e2, 0xff002a00, ""},                                       //
    {0x02, 0x000017e3, 0xff002a00, ""},                                       //
    {0x02, 0x000017e4, 0x00177200, ""},                                       //
    {0x02, 0x000017e5, 0xff002400, ""},                                       //
    {0x02, 0x000017e6, 0xff002400, ""},                                       //
    {0x02, 0x000017e7, 0xff002400, ""},                                       //
    {0x02, 0x000017e8, 0xff002400, ""},                                       //
    {0x02, 0x000017e9, 0xff002400, ""},                                       //
    {0x02, 0x000017ea, 0xff002400, ""},                                       //
    {0x02, 0x000017eb, 0xff002400, ""},                                       //
    {0x02, 0x000017ec, 0xff002400, ""},                                       //
    {0x02, 0x000017ed, 0xff002400, ""},                                       //
    {0x02, 0x000017ee, 0xff002400, ""},                                       //
    {0x02, 0x000017f0, 0xff002400, ""},                                       //
    {0x02, 0x000017f1, 0xff002a00, ""},                                       //
    {0x02, 0x000017f2, 0xff002300, ""},                                       //
    {0x02, 0x000017f4, 0xff002400, ""},                                       //
    {0x02, 0x000017f5, 0xff002400, ""},                                       //
    {0x02, 0x000017f6, 0xff002400, ""},                                       //
    {0x02, 0x000017f7, 0xff003200, ""},                                       //
    {0x02, 0x000017f8, 0xff002800, ""},                                       //
    {0x02, 0x000017f9, 0xff002800, ""},                                       //
    {0x02, 0x000017fa, 0xff003200, ""},                                       //
    {0x02, 0x000017fc, 0xff003200, ""},                                       //
    {0x02, 0x000017fd, 0xff002800, ""},                                       //
    {0x02, 0x000017fe, 0xff002800, ""},                                       //
    {0x02, 0x000017ff, 0xff002800, ""},                                       //
    {0x02, 0x00001800, 0xff002800, ""},                                       //
    {0x02, 0x00001816, 0xff002400, ""},                                       //
    {0x02, 0x00001817, 0xff002400, ""},                                       //
    {0x02, 0x00001818, 0xff002400, ""},                                       //
    {0x02, 0x00001838, 0xff002400, ""},                                       //
    {0x02, 0x00001839, 0xff002400, ""},                                       //
    {0x02, 0x0000183a, 0xff002800, ""},                                       //
    {0x02, 0x0000183b, 0xff002400, ""},                                       //
    {0x02, 0x0000183c, 0xff002800, ""},                                       //
    {0x02, 0x0000183d, 0xff002800, ""},                                       //
    {0x02, 0x0000183e, 0xff002800, ""},                                       //
    {0x02, 0x0000183f, 0xff002800, ""},                                       //
    {0x02, 0x00001840, 0xff002800, ""},                                       //
    {0x02, 0x00001841, 0xff002800, ""},                                       //
    {0x02, 0x00001842, 0xff002800, ""},                                       //
    {0x02, 0x00001843, 0xff002a00, ""},                                       //
    {0x02, 0x00001844, 0xff002400, ""},                                       //
    {0x02, 0x00001845, 0xff002400, ""},                                       //
    {0x02, 0x00001848, 0xff002a00, ""},                                       //
    {0x02, 0x00001849, 0xff002a00, ""},                                       //
    {0x02, 0x0000184a, 0xff002800, ""},                                       //
    {0x02, 0x0000185f, 0xff002400, ""},                                       //
    {0x02, 0x00001860, 0xff002400, ""},                                       //
    {0x02, 0x00001861, 0xff003200, ""},                                       //
    {0x02, 0x00001862, 0xff002400, ""},                                       //
    {0x02, 0x00001863, 0xff002400, ""},                                       //
    {0x02, 0x00001864, 0xff002400, ""},                                       //
    {0x02, 0x00001865, 0xff002400, ""},                                       //
    {0x02, 0x00001866, 0xff002400, ""},                                       //
    {0x02, 0x00001867, 0xff002400, ""},                                       //
    {0x02, 0x00005600, 0x00000300, ""},                                       //
    {0x02, 0x00005615, 0xff002c00, ""},                                       //
    {0x02, 0x00009c41, 0xff002c00, "Manufacturer Model Name"},                //
    {0x02, 0x0000a7f8, 0xff002c00, "Sequence Name"},                          //
    {0x02, 0x0000a7f9, 0xff002c00, "Sequence Name Extended"},                 //
    {0x02, 0x0000a7fb, 0xff002400, ""},                                       //
    {0x02, 0x0000a7fd, 0xff003200, ""},                                       //
    {0x02, 0x0000a7fe, 0xff002400, ""},                                       //
    {0x02, 0x0000a7ff, 0xff002800, "Echo Time (/1000)"},                      //
    {0x02, 0x0000a800, 0xff002400, ""},                                       //
    {0x02, 0x0000a801, 0xff002800, "Spacing Between Slices (/1000)"},         //
    {0x02, 0x0000a802, 0xff002800, ""},                                       //
    {0x02, 0x0000a803, 0xff002400, ""},                                       //
    {0x02, 0x0000a804, 0xff002400, ""},                                       //
    {0x02, 0x0000a805, 0xff003200, ""},                                       //
    {0x02, 0x0000a806, 0x00000500, "FOV"},                                    //
    {0x02, 0x0000a807, 0x00000500, "Image Matrix"},                           //
    {0x02, 0x0000a808, 0xff002400, ""},                                       //
    {0x02, 0x0000a809, 0xff003200, ""},                                       //
    {0x02, 0x0000a80a, 0x000bb800, ""},                                       //
    {0x02, 0x0000a80b, 0x000bb900, ""},                                       //
    {0x02, 0x0000a80c, 0xff002a00, ""},                                       //
    {0x02, 0x0000a80d, 0xff002800, "Repetition Time (/1000)"},                //
    {0x02, 0x0000a80e, 0xff002800, ""},                                       //
    {0x02, 0x0000a80f, 0xff002400, ""},                                       //
    {0x02, 0x0000a810, 0xff002400, ""},                                       //
    {0x02, 0x0000a813, 0xff002400, ""},                                       //
    {0x02, 0x0000a814, 0xff002800, ""},                                       //
    {0x02, 0x0000a815, 0xff002400, ""},                                       //
    {0x02, 0x0000a816, 0xff002400, ""},                                       //
    {0x02, 0x0000a817, 0xff002400, ""},                                       //
    {0x02, 0x0000a819, 0xff002400, ""},                                       //
    {0x02, 0x0000a81b, 0xff002400, ""},                                       //
    {0x02, 0x0000a81c, 0xff003200, ""},                                       //
    {0x02, 0x0000a81d, 0xff002a00, ""},                                       //
    {0x02, 0x0000a822, 0x00000500, ""},                                       //
    {0x02, 0x0000a823, 0xff002c00, "MR Acquisition Type"},                    //
    {0x02, 0x0000a824, 0xff002400, ""},                                       //
    {0x02, 0x0000a825, 0xff002400, ""},                                       //
    {0x02, 0x0000a826, 0xff003200, ""},                                       //
    {0x02, 0x0000a827, 0xff002400, ""},                                       //
    {0x02, 0x0000a828, 0xff002400, ""},                                       //
    {0x02, 0x0000a82c, 0xff002400, ""},                                       //
    {0x02, 0x0000a82d, 0x000bbb00, ""},                                       //
    {0x02, 0x0000a82e, 0xff002400, ""},                                       //
    {0x02, 0x0000a82f, 0xff002a00, ""},                                       //
    {0x02, 0x0000a830, 0xff002800, ""},                                       //
    {0x02, 0x0000a832, 0xff002a00, ""},                                       //
    {0x02, 0x0000a834, 0xff002800, ""},                                       //
    {0x02, 0x0000a835, 0xff003200, ""},                                       //
    {0x02, 0x0000a836, 0xff002400, ""},                                       //
    {0x02, 0x0000a837, 0xff002400, "Echo Train Length"},                      //
    {0x02, 0x0000a838, 0xff002400, ""},                                       //
    {0x02, 0x0000a839, 0xff002400, ""},                                       //
    {0x02, 0x0000a83a, 0xff002400, ""},                                       //
    {0x02, 0x0000a83b, 0xff002400, ""},                                       //
    {0x02, 0x0000a83c, 0xff002400, ""},                                       //
    {0x02, 0x0000a83d, 0xff002400, ""},                                       //
    {0x02, 0x0000a844, 0xff002c00, ""},                                       //
    {0x02, 0x0000a846, 0xff002400, ""},                                       //
    {0x02, 0x0000a847, 0xff002400, ""},                                       //
    {0x02, 0x0000a848, 0xff002800, ""},                                       //
    {0x02, 0x0000a849, 0xff002800, ""},                                       //
    {0x02, 0x0000a84a, 0xff002a00, ""},                                       //
    {0x02, 0x0000a84b, 0xff002400, ""},                                       //
    {0x02, 0x0000a84c, 0xff002400, ""},                                       //
    {0x02, 0x0000a84d, 0xff002400, ""},                                       //
    {0x02, 0x0000a84e, 0xff002400, ""},                                       //
    {0x02, 0x0000a84f, 0xff002800, ""},                                       //
    {0x02, 0x0000a850, 0xff002800, ""},                                       //
    {0x02, 0x0000a851, 0xff002800, ""},                                       //
    {0x02, 0x0000a852, 0xff002400, ""},                                       //
    {0x02, 0x0000a853, 0xff002400, ""},                                       //
    {0x02, 0x0000a854, 0xff002400, ""},                                       //
    {0x02, 0x0000a85d, 0xff002a00, ""},                                       //
    {0x02, 0x0000a85e, 0xff003200, ""},                                       //
    {0x02, 0x0000a864, 0xff002400, ""},                                       //
    {0x02, 0x0000a865, 0xff002400, ""},                                       //
    {0x02, 0x0000a866, 0xff002800, ""},                                       //
    {0x02, 0x0000a867, 0xff002800, ""},                                       //
    {0x02, 0x0000a868, 0xff002800, ""},                                       //
    {0x02, 0x0000a869, 0xff002400, ""},                                       //
    {0x02, 0x0000a86a, 0xff002400, ""},                                       //
    {0x02, 0x0000a86b, 0xff002400, ""},                                       //
    {0x02, 0x0000a86c, 0xff002400, ""},                                       //
    {0x02, 0x0000a86d, 0xff002400, ""},                                       //
    {0x02, 0x0000a86e, 0xff002400, ""},                                       //
    {0x02, 0x0000a86f, 0xff002800, ""},                                       //
    {0x02, 0x0000a870, 0xff002400, ""},                                       //
    {0x02, 0x0000a8c1, 0xff002c00, "Protocol Name"},                          //
    {0x02, 0x0000a8c2, 0xff002a00, ""},                                       //
    {0x02, 0x0000a8c3, 0xff003200, ""},                                       //
    {0x02, 0x0000a8c4, 0xff002400, ""},                                       //
    {0x02, 0x0000a8c5, 0xff002400, ""},                                       //
    {0x02, 0x0000a8c6, 0xff002400, ""},                                       //
    {0x02, 0x0000a8c7, 0x000bba00, ""},                                       //
    {0x02, 0x0000a8c8, 0x00000400, ""},                                       //
    {0x02, 0x0000a8c9, 0xff002400, ""},                                       //
    {0x02, 0x0000a8ca, 0xff002400, ""},                                       //
    {0x02, 0x0000a8cb, 0x00000400, ""},                                       //
    {0x02, 0x0000a8cc, 0x00000400, ""},                                       //
    {0x02, 0x0000a8cd, 0x00000400, ""},                                       //
    {0x02, 0x0000a8ce, 0x00000400, ""},                                       //
    {0x02, 0x0000a8cf, 0x00000400, ""},                                       //
    {0x02, 0x0000a8d0, 0xff002400, ""},                                       //
    {0x02, 0x0000a8d1, 0xff002400, ""},                                       //
    {0x02, 0x0000a8d6, 0xff002400, ""},                                       //
    {0x02, 0x0000a8d7, 0xff002400, ""},                                       //
    {0x02, 0x0000a8d8, 0xff002a00, ""},                                       //
    {0x02, 0x0000a8d9, 0xff002400, ""},                                       //
    {0x02, 0x0000a8da, 0xff002c00, "Protocol Name"},                          //
    {0x02, 0x0000a8db, 0xff002400, ""},                                       //
    {0x02, 0x0000a8dc, 0xff002400, ""},                                       //
    {0x02, 0x0000a8dd, 0xff002800, ""},                                       //
    {0x02, 0x0000a8de, 0xff002400, ""},                                       //
    {0x02, 0x0000a8df, 0xff002800, ""},                                       //
    {0x02, 0x0000a8e0, 0xff002400, ""},                                       //
    {0x02, 0x0000a8e1, 0xff002400, ""},                                       //
    {0x02, 0x0000a8e2, 0xff002800, ""},                                       //
    {0x02, 0x0000a8e3, 0xff002800, ""},                                       //
    {0x02, 0x0000a8e4, 0xff002800, ""},                                       //
    {0x02, 0x0000a8e6, 0xff002400, ""},                                       //
    {0x02, 0x0000a8e7, 0xff002400, ""},                                       //
    {0x02, 0x0000a8e8, 0xff002400, ""},                                       //
    {0x02, 0x0000a8e9, 0xff003200, ""},                                       //
    {0x02, 0x0000a8ea, 0xff003200, ""},                                       //
    {0x02, 0x0000a8eb, 0xff002400, ""},                                       //
    {0x02, 0x0000a8ef, 0xff002800, ""},                                       //
    {0x02, 0x0000a8f2, 0xff002400, ""},                                       //
    {0x02, 0x0000a8f3, 0xff002400, ""},                                       //
    {0x02, 0x0000a8f5, 0xff003200, ""},                                       //
    {0x02, 0x0000a8f6, 0xff002400, ""},                                       //
    {0x02, 0x0000a8f7, 0xff002400, ""},                                       //
    {0x02, 0x0000a8f8, 0xff002400, ""},                                       //
    {0x02, 0x0000a8fa, 0xff002400, ""},                                       //
    {0x02, 0x0000a8fb, 0xff002400, ""},                                       //
    {0x02, 0x0000a8fd, 0x00000600, ""},                                       //
    {0x02, 0x0000a8fe, 0x00000600, ""},                                       //
    {0x02, 0x0000a8ff, 0xff003200, ""},                                       //
    {0x02, 0x0000a900, 0xff002400, ""},                                       //
    {0x02, 0x0000a901, 0xff002400, ""},                                       //
    {0x02, 0x0000a902, 0xff002400, ""},                                       //
    {0x02, 0x0000a903, 0xff002400, ""},                                       //
    {0x02, 0x0000a904, 0xff002400, ""},                                       //
    {0x02, 0x0000a905, 0xff002800, ""},                                       //
    {0x02, 0x0000a906, 0xff002400, ""},                                       //
    {0x02, 0x0000a907, 0xff002400, ""},                                       //
    {0x02, 0x0000a908, 0xff002400, ""},                                       //
    {0x02, 0x0000a909, 0xff002400, ""},                                       //
    {0x02, 0x0000a90a, 0xff002400, ""},                                       //
    {0x02, 0x0000a90b, 0xff002400, ""},                                       //
    {0x02, 0x0000a90c, 0xff002400, ""},                                       //
    {0x02, 0x0000a90e, 0xff002a00, ""},                                       //
    {0x02, 0x0000a915, 0xff002400, ""},                                       //
    {0x02, 0x0000a916, 0xff002400, ""},                                       //
    {0x02, 0x0000a917, 0xff002400, ""},                                       //
    {0x02, 0x0000a918, 0xff003200, ""},                                       //
    {0x02, 0x0000a919, 0xff003200, ""},                                       //
    {0x02, 0x0000a91a, 0xff002400, ""},                                       //
    {0x02, 0x0000a91b, 0xff002400, ""},                                       //
    {0x02, 0x0000a91c, 0x000bbb00, ""},                                       //
    {0x02, 0x0000a91d, 0xff002400, ""},                                       //
    {0x02, 0x0000a920, 0xff002400, ""},                                       //
    {0x02, 0x0000a921, 0xff002400, ""},                                       //
    {0x02, 0x0000a922, 0xff002400, ""},                                       //
    {0x02, 0x0000a923, 0xff002400, ""},                                       //
    {0x02, 0x0000a924, 0xff002400, ""},                                       //
    {0x02, 0x0000a925, 0xff002400, ""},                                       //
    {0x02, 0x0000a926, 0xff002400, ""},                                       //
    {0x02, 0x0000a927, 0xff002400, ""},                                       //
    {0x02, 0x0000a928, 0xff002400, ""},                                       //
    {0x02, 0x0000a929, 0xff002400, ""},                                       //
    {0x02, 0x0000a92a, 0xff002400, ""},                                       //
    {0x02, 0x0000a92b, 0xff002400, ""},                                       //
    {0x02, 0x0000a92c, 0x000bbb00, ""},                                       //
    {0x02, 0x0000a92d, 0x00000600, ""},                                       //
    {0x02, 0x0000a92f, 0xff002400, ""},                                       //
    {0x02, 0x0000a930, 0xff002400, ""},                                       //
    {0x02, 0x0000a931, 0xff002400, ""},                                       //
    {0x02, 0x0000a932, 0xff002400, ""},                                       //
    {0x02, 0x0000a934, 0xff002a00, ""},                                       //
    {0x02, 0x0000a935, 0xff002400, ""},                                       //
    {0x02, 0x0000a936, 0xff002400, ""},                                       //
    {0x02, 0x0000a937, 0xff002800, ""},                                       //
    {0x02, 0x0000a938, 0x00000600, ""},                                       //
    {0x02, 0x0000a93a, 0xff002400, ""},                                       //
    {0x02, 0x0000a93c, 0xff002400, ""},                                       //
    {0x02, 0x0000a93d, 0xff002400, ""},                                       //
    {0x02, 0x0000a93e, 0xff002800, ""},                                       //
    {0x02, 0x0000a940, 0xff002800, ""},                                       //
    {0x02, 0x0000a941, 0xff002400, ""},                                       //
    {0x02, 0x0000a942, 0xff002400, ""},                                       //
    {0x02, 0x0000a943, 0xff002400, ""},                                       //
    {0x02, 0x0000a944, 0xff002400, ""},                                       //
    {0x02, 0x0000a945, 0xff002400, ""},                                       //
    {0x02, 0x0000a946, 0xff002400, ""},                                       //
    {0x02, 0x0000a947, 0xff002800, ""},                                       //
    {0x02, 0x0000a948, 0xff002400, ""},                                       //
    {0x02, 0x0000a949, 0xff002400, ""},                                       //
    {0x02, 0x0000a94a, 0xff002400, ""},                                       //
    {0x02, 0x0000a94b, 0xff002800, ""},                                       //
    {0x02, 0x0000a94c, 0xff002400, ""},                                       //
    {0x02, 0x0000a94d, 0xff002400, ""},                                       //
    {0x02, 0x0000a94e, 0xff002800, ""},                                       //
    {0x02, 0x0000a94f, 0xff002400, ""},                                       //
    {0x02, 0x0000a95b, 0xff002800, ""},                                       //
    {0x02, 0x0000a95c, 0xff002400, ""},                                       //
    {0x02, 0x0000a95d, 0xff002400, ""},                                       //
    {0x02, 0x0000a95e, 0xff002400, ""},                                       //
    {0x02, 0x0000a95f, 0xff002400, ""},                                       //
    {0x02, 0x0000a960, 0xff002800, ""},                                       //
    {0x02, 0x0000a961, 0xff002400, ""},                                       //
    {0x02, 0x0000a962, 0xff002400, ""},                                       //
    {0x02, 0x0000a964, 0xff002400, ""},                                       //
    {0x02, 0x0000a965, 0x000bc100, ""},                                       //
    {0x02, 0x0000a966, 0x000bc200, ""},                                       //
    {0x02, 0x0000a96a, 0x000bc300, ""},                                       //
    {0x02, 0x0000a96b, 0xff002400, ""},                                       //
    {0x02, 0x0000a96c, 0xff002400, ""},                                       //
    {0x02, 0x0000a96d, 0xff002a00, ""},                                       //
    {0x02, 0x0000a96e, 0x000bc200, ""},                                       //
    {0x02, 0x0000a96f, 0xff002400, ""},                                       //
    {0x02, 0x0000a970, 0xff002400, ""},                                       //
    {0x02, 0x0000a971, 0xff002400, ""},                                       //
    {0x02, 0x0000a972, 0xff002400, ""},                                       //
    {0x02, 0x0000a973, 0xff002800, ""},                                       //
    {0x02, 0x0000a974, 0xff002c00, "Body Part Examined"},                     //
    {0x02, 0x0000a975, 0x00000600, ""},                                       //
    {0x02, 0x0000a976, 0xff002400, ""},                                       //
    {0x02, 0x0000a977, 0xff002400, ""},                                       //
    {0x02, 0x0000a978, 0xff002400, ""},                                       //
    {0x02, 0x0000a979, 0xff002400, ""},                                       //
    {0x02, 0x0000a980, 0xff002800, ""},                                       //
    {0x02, 0x0000a987, 0xff002400, ""},                                       //
    {0x02, 0x0000a988, 0xff002400, ""},                                       //
    {0x02, 0x0000a989, 0xff002400, ""},                                       //
    {0x02, 0x0000a98a, 0x00000f00, ""},                                       //
    {0x02, 0x0000a98b, 0xff002400, ""},                                       //
    {0x02, 0x0000a98c, 0xff002400, ""},                                       //
    {0x02, 0x0000a98d, 0x000bc100, ""},                                       //
    {0x02, 0x0000a98e, 0x000bc200, ""},                                       //
    {0x02, 0x0000a98f, 0xff002400, ""},                                       //
    {0x02, 0x0000a990, 0xff002400, ""},                                       //
    {0x02, 0x0000a991, 0xff002400, ""},                                       //
    {0x02, 0x0000a992, 0xff002400, ""},                                       //
    {0x02, 0x0000a993, 0xff002400, ""},                                       //
    {0x02, 0x0000abe0, 0xff002c00, ""},                                       //
    {0x02, 0x0000abe1, 0xff002c00, ""},                                       //
    {0x02, 0x0000abe2, 0xff002c00, ""},                                       //
    {0x02, 0x0000abe3, 0xff002400, ""},                                       //
    {0x02, 0x0000abe4, 0xff002800, ""},                                       //
    {0x02, 0x0000abe5, 0xff002c00, ""},                                       //
    {0x02, 0x0000abe6, 0xff002c00, ""},                                       //
    {0x02, 0x0000abe8, 0xff002c00, ""},                                       //
    {0x02, 0x0000abe9, 0xff002c00, ""},                                       //
    {0x02, 0x0000abeb, 0xff002800, "Repetition Time (/1000)"},                //
    {0x02, 0x0000abec, 0xff002800, ""},                                       //
    {0x02, 0x0000abed, 0xff002800, ""},                                       //
    {0x02, 0x0000abee, 0xff002400, ""},                                       //
    {0x02, 0x0000abf2, 0xff002400, ""},                                       //
    {0x02, 0x0000abf3, 0xff002400, ""},                                       //
    {0x02, 0x0000abf5, 0xff002a00, ""},                                       //
    {0x02, 0x0000abf6, 0xff002400, ""},                                       //
    {0x02, 0x0000abf7, 0xff002400, ""},                                       //
    {0x02, 0x0000abf8, 0xff002400, ""},                                       //
    {0x02, 0x0000abf9, 0xff002400, ""},                                       //
    {0x02, 0x0000abfa, 0xff002400, ""},                                       //
    {0x02, 0x0000abfb, 0xff002400, ""},                                       //
    {0x02, 0x0000abfc, 0xff002400, ""},                                       //
    {0x02, 0x0000abfd, 0xff002400, ""},                                       //
    {0x02, 0x0000abfe, 0xff002400, ""},                                       //
    {0x02, 0x0000ac00, 0xff002800, ""},                                       //
    {0x02, 0x0000ac01, 0xff002800, ""},                                       //
    {0x02, 0x0000ac09, 0xff002400, ""},                                       //
    {0x02, 0x0000ac0a, 0xff002a00, ""},                                       //
    {0x02, 0x0000ac0b, 0x00000500, "Image Matrix"},                           //
    {0x02, 0x0000ac0c, 0x00000400, ""},                                       //
    {0x02, 0x0000ac0d, 0xff002a00, ""},                                       //
    {0x02, 0x0000ac0e, 0xff002800, "Repetition Time (/1000)"},                //
    {0x02, 0x0000ac0f, 0xff002400, ""},                                       //
    {0x02, 0x0000ac10, 0xff002400, ""},                                       //
    {0x02, 0x0000ac11, 0xff002400, ""},                                       //
    {0x02, 0x0000ac12, 0xff002400, ""},                                       //
    {0x02, 0x0000ac13, 0xff002400, ""},                                       //
    {0x02, 0x0000ac14, 0xff002400, ""},                                       //
    {0x02, 0x0000ac15, 0xff002400, ""},                                       //
    {0x02, 0x0000ac16, 0xff002400, ""},                                       //
    {0x02, 0x0000ac17, 0xff002400, ""},                                       //
    {0x02, 0x0000ac18, 0xff002400, ""},                                       //
    {0x02, 0x0000ac19, 0x00000400, ""},                                       //
    {0x02, 0x0000ac1a, 0xff002400, ""},                                       //
    {0x02, 0x0000ac1b, 0xff002400, ""},                                       //
    {0x02, 0x0000ac1c, 0xff002400, ""},                                       //
    {0x02, 0x0000ac1d, 0xff002400, ""},                                       //
    {0x02, 0x0000ac1e, 0xff002400, ""},                                       //
    {0x02, 0x0000ac1f, 0xff002400, ""},                                       //
    {0x02, 0x0000ac20, 0xff003100, ""},                                       //
    {0x02, 0x0000ac21, 0xff002800, ""},                                       //
    {0x02, 0x0000ac22, 0xff002400, ""},                                       //
    {0x02, 0x0000ac23, 0xff002800, ""},                                       //
    {0x02, 0x0000ac24, 0xff002800, ""},                                       //
    {0x02, 0x0000ac25, 0xff002400, ""},                                       //
    {0x02, 0x0000ac26, 0xff003100, ""},                                       //
    {0x02, 0x0000ac27, 0xff002400, ""},                                       //
    {0x02, 0x0000ac28, 0xff003100, ""},                                       //
    {0x02, 0x0000ac29, 0xff002800, ""},                                       //
    {0x02, 0x0000ac2a, 0xff002400, ""},                                       //
    {0x02, 0x0000ac2b, 0xff002400, ""},                                       //
    {0x02, 0x0000ac2d, 0xff002800, ""},                                       //
    {0x02, 0x0000ac2e, 0xff002400, ""},                                       //
    {0x02, 0x0000ac2f, 0x00000600, ""},                                       //
    {0x02, 0x0000ac30, 0xff002400, ""},                                       //
    {0x02, 0x0000ac31, 0xff002400, ""},                                       //
    {0x02, 0x0000ac32, 0xff002400, ""},                                       //
    {0x02, 0x0000ac33, 0xff002400, ""},                                       //
    {0x02, 0x0000ac34, 0xff002400, ""},                                       //
    {0x02, 0x0000ac35, 0xff002800, ""},                                       //
    {0x02, 0x0000ac36, 0xff002400, ""},                                       //
    {0x02, 0x0000ac37, 0xff002400, ""},                                       //
    {0x02, 0x0000ac38, 0xff002800, ""},                                       //
    {0x02, 0x0000ac39, 0xff002400, ""},                                       //
    {0x02, 0x0000ac3a, 0xff002400, ""},                                       //
    {0x02, 0x0000ac3c, 0xff002800, ""},                                       //
    {0x02, 0x0000ac3d, 0xff002400, ""},                                       //
    {0x02, 0x0000ac3e, 0xff002800, ""},                                       //
    {0x02, 0x0000ac3f, 0xff002400, ""},                                       //
    {0x02, 0x0000ac40, 0xff002400, ""},                                       //
    {0x02, 0x0000ac41, 0xff002400, ""},                                       //
    {0x02, 0x0000ac42, 0xff002800, ""},                                       //
    {0x02, 0x0000ac43, 0xff002400, ""},                                       //
    {0x02, 0x0000ac44, 0xff002c00, ""},                                       //
    {0x02, 0x0000afc8, 0xff002400, ""},                                       //
    {0x02, 0x0000afc9, 0xff002900, "Imaging Frequency"},                      //
    {0x02, 0x0000afca, 0xff002400, ""},                                       //
    {0x02, 0x0000afcc, 0xff002800, ""},                                       //
    {0x02, 0x0000afce, 0xff002800, ""},                                       //
    {0x02, 0x0000afcf, 0xff002400, ""},                                       //
    {0x02, 0x0000afd0, 0xff002c00, ""},                                       //
    {0x02, 0x0000afd1, 0xff002800, ""},                                       //
    {0x02, 0x0000afd2, 0xff002800, ""},                                       //
    {0x02, 0x0000afd5, 0xff002400, ""},                                       //
    {0x02, 0x0000afd6, 0xff002400, "Frame of Reference Index"},               //
    {0x02, 0x0000afd8, 0xff002a00, ""},                                       //
    {0x02, 0x0000afd9, 0xff002200, ""},                                       //
    {0x02, 0x0000afda, 0xff002800, ""},                                       //
    {0x02, 0x0000afde, 0xff002400, ""},                                       //
    {0x02, 0x0000afdf, 0xff002800, ""},                                       //
    {0x02, 0x0000afe0, 0xff002c00, ""},                                       //
    {0x02, 0x0000afe1, 0xff002400, ""},                                       //
    {0x02, 0x0000afe2, 0xff002800, ""},                                       //
    {0x02, 0x0000afe4, 0xff002400, ""},                                       //
    {0x02, 0x0000afe5, 0xff002800, ""},                                       //
    {0x02, 0x0000afe6, 0xff002800, ""},                                       //
    {0x02, 0x0000afe7, 0xff002800, ""},                                       //
    {0x02, 0x0000afe8, 0xff002800, ""},                                       //
    {0x02, 0x0000afe9, 0xff002400, ""},                                       //
    {0x02, 0x0000afea, 0xff002800, ""},                                       //
    {0x02, 0x0000afeb, 0xff002800, ""},                                       //
    {0x02, 0x0000aff0, 0xff002400, ""},                                       //
    {0x02, 0x0000aff5, 0xff002800, ""},                                       //
    {0x02, 0x0000aff6, 0xff002800, ""},                                       //
    {0x02, 0x0000aff7, 0xff002400, ""},                                       //
    {0x02, 0x0000affa, 0xff002500, ""},                                       //
    {0x02, 0x0000affc, 0xff002400, ""},                                       //
    {0x02, 0x0000affd, 0xff002400, ""},                                       //
    {0x02, 0x0000afff, 0xff002200, ""},                                       //
    {0x02, 0x0000b002, 0xff002400, ""},                                       //
    {0x02, 0x0000b004, 0xff002400, ""},                                       //
    {0x02, 0x0000b005, 0xff002400, ""},                                       //
    {0x02, 0x0000b006, 0x00000500, ""},                                       //
    {0x02, 0x0000b007, 0xff002800, ""},                                       //
    {0x02, 0x0000b008, 0xff002800, ""},                                       //
    {0x02, 0x0000b009, 0xff002800, ""},                                       //
    {0x02, 0x0000b00a, 0xff002800, ""},                                       //
    {0x02, 0x0000b010, 0x00000f00, ""},                                       //
    {0x02, 0x0000b011, 0xff002800, ""},                                       //
    {0x02, 0x0000b012, 0xff002800, ""},                                       //
    {0x02, 0x0000b3b0, 0xff002800, ""},                                       //
    {0x02, 0x0000b3b1, 0xff002400, ""},                                       //
    {0x02, 0x0000b3b2, 0xff002400, ""},                                       //
    {0x02, 0x0000b3b3, 0xff002300, ""},                                       //
    {0x02, 0x0000b3b4, 0x00000b00, ""},                                       //
    {0x02, 0x0000b3b5, 0xff002400, ""},                                       //
    {0x02, 0x0000b3b7, 0xff002400, ""},                                       //
    {0x02, 0x0000b3b9, 0xff002500, ""},                                       //
    {0x02, 0x0000b3ba, 0xff002800, ""},                                       //
    {0x02, 0x0000b3bb, 0xff002400, ""},                                       //
    {0x02, 0x0000b3c2, 0xff002400, ""},                                       //
    {0x02, 0x0000b3c3, 0xff002400, ""},                                       //
    {0x02, 0x0000b3c4, 0xff002800, ""},                                       //
    {0x02, 0x0000b3c5, 0xff002400, ""},                                       //
    {0x02, 0x0000b3c6, 0xff002400, ""},                                       //
    {0x02, 0x0000b3c7, 0xff002800, ""},                                       //
    {0x02, 0x0000b3c8, 0xff002400, ""},                                       //
    {0x02, 0x0000b3c9, 0xff002400, ""},                                       //
    {0x02, 0x0000b3ca, 0xff003200, ""},                                       //
    {0x02, 0x0000b3cb, 0xff003200, ""},                                       //
    {0x02, 0x0000b3cc, 0xff003200, ""},                                       //
    {0x02, 0x0000b3cd, 0xff002400, ""},                                       //
    {0x02, 0x0000b3ce, 0xff002400, ""},                                       //
    {0x02, 0x0000b3d0, 0xff002500, ""},                                       //
    {0x02, 0x0000b3d1, 0xff002400, ""},                                       //
    {0x02, 0x0000b3d2, 0xff002800, ""},                                       //
    {0x02, 0x0000b3d3, 0xff002800, ""},                                       //
    {0x02, 0x0000b3d4, 0xff002800, ""},                                       //
    {0x02, 0x0000b3d5, 0xff002c00, ""},                                       //
    {0x02, 0x0000b3d6, 0xff002800, ""},                                       //
    {0x02, 0x0000b3d7, 0xff002400, ""},                                       //
    {0x02, 0x0000b3d9, 0xff002400, ""},                                       //
    {0x02, 0x0000b3da, 0xff002400, ""},                                       //
    {0x02, 0x0000b3db, 0xff003200, ""},                                       //
    {0x02, 0x0000b3dd, 0xff002400, ""},                                       //
    {0x02, 0x0000b3de, 0x00000600, ""},                                       //
    {0x02, 0x0000b3df, 0xff002400, ""},                                       //
    {0x02, 0x0000b3e0, 0xff002800, ""},                                       //
    {0x02, 0x0000b3e1, 0xff003200, ""},                                       //
    {0x02, 0x0000b3e2, 0xff002400, ""},                                       //
    {0x02, 0x0000b3e3, 0xff002800, ""},                                       //
    {0x02, 0x0000b3e4, 0xff002400, ""},                                       //
    {0x02, 0x0000b3e5, 0xff002400, ""},                                       //
    {0x02, 0x0000b3e6, 0xff002400, ""},                                       //
    {0x02, 0x0000b3e7, 0xff002400, ""},                                       //
    {0x02, 0x0000b3e8, 0xff002400, ""},                                       //
    {0x02, 0x0000b3e9, 0xff002400, ""},                                       //
    {0x02, 0x0000b3ea, 0xff002400, ""},                                       //
    {0x02, 0x0000b3eb, 0xff002400, ""},                                       //
    {0x02, 0x0000b3ec, 0xff002400, ""},                                       //
    {0x02, 0x0000b3ee, 0xff002400, ""},                                       //
    {0x02, 0x0000b3ef, 0xff002400, ""},                                       //
    {0x02, 0x0000b3f0, 0xff002400, ""},                                       //
    {0x02, 0x0000b3f1, 0xff002400, ""},                                       //
    {0x02, 0x0000b3f2, 0xff002800, ""},                                       //
    {0x02, 0x0000b3f3, 0xff002800, ""},                                       //
    {0x02, 0x0000b3f4, 0xff002800, ""},                                       //
    {0x02, 0x0000b3f5, 0xff003200, ""},                                       //
    {0x02, 0x0000b3f6, 0xff002400, ""},                                       //
    {0x02, 0x0000b3f7, 0xff002400, ""},                                       //
    {0x02, 0x0000b3f8, 0xff002400, ""},                                       //
    {0x02, 0x0000b3f9, 0xff002400, ""},                                       //
    {0x02, 0x0000b3fa, 0xff002400, ""},                                       //
    {0x02, 0x0000b3fd, 0xff002400, ""},                                       //
    {0x02, 0x0000b3fe, 0xff002400, ""},                                       //
    {0x02, 0x0000b3ff, 0xff002400, ""},                                       //
    {0x02, 0x0000b400, 0xff002800, ""},                                       //
    {0x02, 0x0000b401, 0xff002400, ""},                                       //
    {0x02, 0x0000b404, 0xff002400, ""},                                       //
    {0x02, 0x0000b405, 0xff002400, ""},                                       //
    {0x02, 0x0000b406, 0xff002400, ""},                                       //
    {0x02, 0x0000b407, 0xff002400, ""},                                       //
    {0x02, 0x0000b798, 0xff002c00, ""},                                       //
    {0x02, 0x0000b799, 0xff002c00, "Coil"},                                   //
    {0x02, 0x0000b79a, 0xff002c00, "Coil"},                                   //
    {0x02, 0x0000fa09, 0xff002800, ""},                                       //
    {0x02, 0x0000fa0b, 0xff002800, ""},                                       //
    {0x02, 0x0000fa0d, 0xff002800, ""},                                       //
    {0x02, 0x0000fa13, 0xff002800, ""},                                       //
    {0x02, 0x0000fa14, 0xff003100, ""},                                       //
    {0x02, 0x0000fa15, 0xff003100, ""},                                       //
    {0x02, 0x0000fa16, 0xff003100, ""},                                       //
    {0x02, 0x0000fa17, 0xff003100, ""},                                       //
    {0x02, 0x0000fa1a, 0xff002800, ""},                                       //
    {0x02, 0x0000fa1b, 0xff003100, ""},                                       //
    {0x02, 0x0000fa22, 0xff002800, ""},                                       //
    {0x02, 0x0000fa23, 0xff003100, ""},                                       //
    {0x02, 0x0000fa25, 0xff003100, ""},                                       //
    {0x02, 0x0000fa26, 0xff002800, ""},                                       //
    {0x02, 0x0000fa29, 0xff003100, ""},                                       //
    {0x02, 0x0000fa2a, 0xff002800, ""},                                       //
    {0x02, 0x0000fa2d, 0xff003100, ""},                                       //
    {0x02, 0x0000fa2e, 0xff002800, ""},                                       //
    {0x02, 0x0000fa37, 0xff002800, ""},                                       //
    {0x02, 0x0000fa38, 0xff003100, ""},                                       //
    {0x02, 0x0000fa3c, 0xff002800, ""},                                       //
    {0x02, 0x0000fa3d, 0xff002800, ""},                                       //
    {0x02, 0x0000fa3e, 0xff003100, ""},                                       //
    {0x02, 0x0000fa3f, 0xff003100, ""},                                       //
    {0x02, 0x0000fa4b, 0xff002800, ""},                                       //
    {0x02, 0x0000fa4c, 0xff002800, ""},                                       //
    {0x02, 0x0000fa4d, 0xff003100, ""},                                       //
    {0x02, 0x0000fa4e, 0xff003100, ""},                                       //
    {0x02, 0x00023283, 0x00000400, ""},                                       //
    {0x03, 0x00000008, 0xfff00200, ""},                                       //
    {0x03, 0x00000065, 0xff002400, ""},                                       //
    {0x03, 0x00000066, 0xff002400, ""},                                       //
    {0x03, 0x0000006f, 0xff002400, ""},                                       //
    {0x03, 0x000017d5, 0xff002a00, ""},                                       //
    {0x03, 0x000017d7, 0xff002a00, ""},                                       //
    {0x03, 0x000017d8, 0xff002a00, ""},                                       //
    {0x03, 0x000017da, 0xff002a00, ""},                                       //
    {0x03, 0x000017db, 0xff002a00, ""},                                       //
    {0x03, 0x000017dd, 0xff002a00, ""},                                       //
    {0x03, 0x000017de, 0xff002400, ""},                                       //
    {0x03, 0x000017df, 0x00177000, ""},                                       //
    {0x03, 0x000017e0, 0x00177000, ""},                                       //
    {0x03, 0x000017e1, 0x00177000, ""},                                       //
    {0x03, 0x000017e2, 0xff002a00, ""},                                       //
    {0x03, 0x000017ef, 0xff002c00, ""},                                       //
    {0x03, 0x000017f0, 0xff002400, ""},                                       //
    {0x03, 0x000017f4, 0xff002400, ""},                                       //
    {0x03, 0x000017f5, 0xff002400, ""},                                       //
    {0x03, 0x0000180a, 0xff002100, ""},                                       //
    {0x03, 0x00001838, 0xff002400, ""},                                       //
    {0x03, 0x00001839, 0xff002400, ""},                                       //
    {0x03, 0x0000183b, 0xff002400, ""},                                       //
    {0x03, 0x0000183d, 0xff002800, ""},                                       //
    {0x03, 0x00001843, 0xff002a00, ""},                                       //
    {0x03, 0x00001844, 0xff002400, ""},                                       //
    {0x03, 0x00001845, 0xff002400, ""},                                       //
    {0x03, 0x00001862, 0xff002400, ""},                                       //
    {0x03, 0x00001863, 0xff002400, ""},                                       //
    {0x03, 0x00001864, 0xff002400, ""},                                       //
    {0x03, 0x00001865, 0xff002400, ""},                                       //
    {0x03, 0x0000a832, 0xff002a00, ""},                                       //
    {0x03, 0x0000afd1, 0xff002800, ""},                                       //
    {0x03, 0x0000afea, 0xff002800, ""},                                       //
    {0x03, 0x0000afeb, 0xff002800, ""},                                       //
    {0x03, 0x0000aff5, 0xff002800, ""},                                       //
    {0x03, 0x0000aff6, 0xff002800, ""},                                       //
    {0x03, 0x0000b3c1, 0xff002400, ""},                                       //
    {0x03, 0x0000b3cf, 0xff002400, ""},                                       //
    {0x03, 0x0000b3e4, 0xff002400, ""},                                       //
    {0x03, 0x0000b3ee, 0xff002400, ""},                                       //
    {0x03, 0x0000b3ef, 0xff002400, ""},                                       //
    {0x03, 0x0000b3f0, 0xff002400, ""},                                       //
    {0x03, 0x0000b3f1, 0xff002400, ""},                                       //
    {0x03, 0x0000fde8, 0x00000100, ""},                                       //
    {0x03, 0x0000fe02, 0x00000e00, "Series DateTime"},                        //
    {0x03, 0x00023a50, 0xff002400, ""},                                       //
    {0x03, 0x00023a5c, 0xff002400, ""},                                       //
    {0x03, 0x00023a5d, 0xff002400, ""},                                       //
    {0x03, 0x00023a5e, 0xff002100, ""},                                       //
    {0x03, 0x00023a60, 0xff002c00, ""},                                       //
    {0x03, 0x00023a61, 0xff002400, ""},                                       //
    {0x03, 0x00023a62, 0xff002c00, ""},                                       //
    {0x03, 0x00023a79, 0xff002400, ""},                                       //
    {0x03, 0x00023a7a, 0xff002400, ""},                                       //
    {0x03, 0x00023a7b, 0xff002400, ""},                                       //
    {0x03, 0x00023a7c, 0xff002400, ""},                                       //
    {0x04, 0x00000009, 0xfff00200, ""},                                       //
    {0x04, 0x00000067, 0xff002400, "Rows,Columns"},                           //
    {0x04, 0x00000068, 0xff002400, ""},                                       //
    {0x04, 0x0000006b, 0xff002800, ""},                                       //
    {0x04, 0x0000006c, 0xff002800, ""},                                       //
    {0x04, 0x000017e3, 0xff002400, ""},                                       //
    {0x04, 0x00001808, 0xff002400, ""},                                       //
    {0x04, 0x00001809, 0xff002400, ""},                                       //
    {0x04, 0x00001bc4, 0xff002400, ""},                                       //
    {0x04, 0x00001bc5, 0xff002400, ""},                                       //
    {0x04, 0x00001bca, 0xff002800, ""},                                      //
    {0x04, 0x00001bcb, 0xff002800, ""},                                      //
    {0x04, 0x00001bcc, 0xff002c00, ""},                                       //
    {0x04, 0x0000a806, 0x00000500, "FOV"},                                    //
    {0x04, 0x0000b3b4, 0x00000b00, ""},                                       //
    {0x04, 0x0000fa06, 0xff002400, ""},                                       //
    {0x04, 0x00014438, 0x00000600, "Orientation Vector 1"},                   //
    {0x04, 0x00014439, 0x00000600, "Orientation Vector 2"},                   //
    {0x04, 0x0001443a, 0x00000600, "Orientation Vector 3"},                   //
    {0x04, 0x0001443b, 0xff002800, "Slice Thickness (meter)"},                //
    {0x04, 0x0001e078, 0xff002800, "Echo Time (/1000)"},                      //
    {0x04, 0x0001e464, 0xff002400, ""},                                       //
    {0x04, 0x0001e465, 0xff002400, ""},                                       //
    {0x04, 0x0001e466, 0xff002400, ""},                                       //
    {0x04, 0x00023a5a, 0xff002400, ""},                                       //
    {0x04, 0x00028873, 0xff002800, "Spacing Between Slices (meter)"},         //
    {0x04, 0x00028876, 0x00000400, ""},                                       //
    {0x04, 0x00028877, 0xff002800, "FOV"},                                    //
    {0x04, 0x00028878, 0xff002400, ""},                                       //
    {0x04, 0x00028879, 0xff002400, ""},                                       //
    {0x04, 0x0002887a, 0xff002a00, ""},                                       //
    {0x04, 0x0002887b, 0xff002400, ""},                                       //
    {0x04, 0x0002887c, 0xff002400, ""},                                       //
    {0x05, 0x00000069, 0xff002800, ""},                                       //
    {0x05, 0x0000006b, 0xff002800, ""},                                       //
    {0x05, 0x0000006c, 0xff002800, ""},                                       //
    {0x05, 0x00001bc3, 0xff002200, ""},                                       //
    {0x05, 0x00005603, 0x00000100, ""},                                       //
    {0x05, 0x0000a819, 0xff002400, ""},                                       //
    {0x05, 0x0000fdea, 0xff002400, ""},                                       //
    {0x05, 0x0002bf20, 0xff002a00, ""},                                       //
    {0x05, 0x0002c6f0, 0x00000100, ""},                                       //
    {0x05, 0x0002d691, 0xff002800, "Slice Location (/1000)"},                 //
    {0x05, 0x0002d695, 0xff002400, "Instance Number"},                        //
    {0x05, 0x0002d696, 0xff002400, "Instance Number"},                        //
    {0x05, 0x0002da78, 0x001b5e00, ""},                                       //
    {0x05, 0x0002da79, 0x001b5f00, ""},                                       //
    {0x05, 0x0002da7a, 0xff002000, ""},                                       //
    {0x06, 0x00000c1d, 0xff002400, "Item Index"},                             //
    {0x06, 0x00036718, 0xff002400, ""},                                       //
    {0x06, 0x00036719, 0x00000600, "Orientation Vector 1"},                   //
    {0x06, 0x0003671a, 0x00000600, "Orientation Vector 2"},                   //
    {0x06, 0x0003671b, 0x00000600, "Orientation Vector 3"},                   //
    {0x06, 0x00036721, 0xff002400, ""},                                       //
    {0x06, 0x00036722, 0xff002a00, ""},                                       //
    {0x06, 0x00036725, 0xff002400, ""},                                       //
    {0x06, 0x0003672a, 0xff002400, ""},                                       //
    {0x07, 0x00000c1d, 0xff002400, ""},                                       //
    {0x07, 0x00036718, 0xff002400, ""},                                       //
    {0x07, 0x00036719, 0x00000600, ""},                                       //
    {0x07, 0x0003671a, 0x00000600, ""},                                       //
    {0x07, 0x0003671b, 0x00000600, ""},                                       //
    {0x07, 0x0003671c, 0xff002800, ""},                                       //
    {0x07, 0x0003671e, 0xff002a00, ""},                                       //
    {0x07, 0x00036721, 0xff002400, ""},                                       //
    {0x07, 0x00036722, 0xff002a00, ""},                                       //
    {0x07, 0x00036723, 0x00000600, ""},                                       //
    {0x07, 0x00036724, 0x00000600, ""},                                       //
    {0x07, 0x00036725, 0xff002400, ""},                                       //
    {0x07, 0x00036727, 0xff002400, ""},                                       //
    {0x07, 0x00036728, 0xff002400, ""},                                       //
    {0x07, 0x0003672a, 0xff002400, ""},                                       //
    {0x07, 0x0003672b, 0x00000600, ""},                                       //
    {0x08, 0x00000c1d, 0xff002400, ""},                                       //
    {0x08, 0x00036718, 0xff002400, ""},                                       //
    {0x08, 0x00036719, 0x00000600, ""},                                       //
    {0x08, 0x0003671a, 0x00000600, ""},                                       //
    {0x08, 0x0003671b, 0x00000600, ""},                                       //
    {0x08, 0x0003671c, 0xff002800, ""},                                       //
    {0x08, 0x0003671e, 0xff002a00, ""},                                       //
    {0x08, 0x00036721, 0xff002400, ""},                                       //
    {0x08, 0x00036722, 0xff002a00, ""},                                       //
    {0x08, 0x00036723, 0x00000600, ""},                                       //
    {0x08, 0x00036724, 0x00000600, ""},                                       //
    {0x08, 0x00036725, 0xff002400, ""},                                       //
    {0x08, 0x00036727, 0xff002400, ""},                                       //
    {0x08, 0x00036728, 0xff002400, ""},                                       //
    {0x08, 0x0003672a, 0xff002400, ""},                                       //
    {0x08, 0x0003672b, 0x00000600, ""},                                       //
    {0x09, 0x00000c1d, 0xff002400, ""},                                       //
    {0x09, 0x00036718, 0xff002400, ""},                                       //
    {0x09, 0x00036719, 0x00000600, ""},                                       //
    {0x09, 0x0003671a, 0x00000600, ""},                                       //
    {0x09, 0x0003671b, 0x00000600, ""},                                       //
    {0x09, 0x0003671c, 0xff002800, ""},                                       //
    {0x09, 0x0003671e, 0xff002a00, ""},                                       //
    {0x09, 0x00036721, 0xff002400, ""},                                       //
    {0x09, 0x00036722, 0xff002a00, ""},                                       //
    {0x09, 0x00036723, 0x00000600, ""},                                       //
    {0x09, 0x00036724, 0x00000600, ""},                                       //
    {0x09, 0x00036725, 0xff002400, ""},                                       //
    {0x09, 0x00036727, 0xff002400, ""},                                       //
    {0x09, 0x00036728, 0xff002400, ""},                                       //
    {0x09, 0x0003672a, 0xff002400, ""},                                       //
    {0x09, 0x0003672b, 0x00000600, ""},                                       //
    {0x0a, 0x00000c1d, 0xff002400, ""}, //
    {0x0a, 0x00036718, 0xff002400, ""}, //
    {0x0a, 0x00036719, 0x00000600, ""}, //
    {0x0a, 0x0003671a, 0x00000600, ""}, //
    {0x0a, 0x0003671b, 0x00000600, ""}, //
    {0x0a, 0x0003671c, 0xff002800, ""}, //
    {0x0a, 0x0003671e, 0xff002a00, ""}, //
    {0x0a, 0x00036721, 0xff002400, ""}, //
    {0x0a, 0x00036722, 0xff002a00, ""}, //
    {0x0a, 0x00036723, 0x00000600, ""},                                       //
    {0x0a, 0x00036724, 0x00000600, ""},                                       //
    {0x0a, 0x00036725, 0xff002400, ""}, //
    {0x0a, 0x00036727, 0xff002400, ""}, //
    {0x0a, 0x00036728, 0xff002400, ""}, //
    {0x0a, 0x0003672a, 0xff002400, ""},                                       //
    {0x0a, 0x0003672b, 0x00000600, ""},                                       //
    {0x0b, 0x0003671c, 0xff002800, ""}, //
    {0x0b, 0x0003671e, 0xff002a00, ""}, //
    {0x0b, 0x00036722, 0xff002a00, ""}, //
    {0x0b, 0x00036723, 0x00000600, ""}, //
    {0x0b, 0x00036724, 0x00000600, ""}, //
    {0x0b, 0x00036727, 0xff002400, ""}, //
    {0x0b, 0x00036728, 0xff002400, ""}, //
    {0x0b, 0x0003672a, 0xff002400, ""}, //
    {0x0b, 0x0003672b, 0x00000600, ""}, //
};

static const uint32_t dict_size = sizeof(dict) / sizeof(*dict);

void check_mec_mr3_dict(void) {
  const struct mec_mr3_dict *prev = dict + 0;
  for (uint32_t i = 1; i < dict_size; ++i) {
    const struct mec_mr3_dict *next = dict + i;
    if (next->group == prev->group)
      assert(next->key > prev->key);
    else
      assert(next->group > prev->group);
    prev = next;
  }
}

bool check_mec_mr3_info(const uint8_t group, const uint32_t key,
                        const uint32_t type) {
  assert(group > 0x0 && group < 0xc);
  assert((key & 0xfff00000) == 0x0);
  assert((type & 0x000000ff) == 0x0);
  const uint32_t sign = type >> 24u;
  assert(sign == 0x0 || sign == 0xff);
  bool found = false;
  for (uint32_t i = 0; i < dict_size; ++i) {
    const struct mec_mr3_dict *d = dict + i;
    if (group == d->group && key == d->key) {
      assert(d->type == type);
      found = true;
    }
  }
#ifdef MEC_MR3_DICT_DEBUG
  if (!found) {
    fprintf(stderr, "{0x%02x, 0x%08x, 0x%08x, \"\"}, //\n", group, key, type);
    //    assert(0);
  }
#endif
  return found;
}

const char *get_mec_mr3_info_name(const uint8_t group, const uint32_t key) {
  const char *ret = NULL;
  for (uint32_t i = 0; i < dict_size; ++i) {
    const struct mec_mr3_dict *d = dict + i;
    if (group == d->group && key == d->key) {
      ret = d->name;
    }
  }
  return ret;
}
