/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.namespace;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Random;

public class QName
implements Serializable {
    private static final long serialVersionUID;
    private static final long defaultSerialVersionUID = -9120448754896609940L;
    private static final long compatabilitySerialVersionUID = 4418622981026545151L;
    private static final int MULTIPLIERS_SIZE = 32;
    private static final int MULTIPLIERS_MASK = 31;
    private static final int[] hashMultipliers;
    private static final boolean useDefaultHashCodeAlgorithm;
    private final String namespaceURI;
    private final String localPart;
    private String prefix;
    private transient int hashCode;
    private transient String qNameAsString;

    public QName(String string, String string2) {
        this(string, string2, "");
    }

    public QName(String string, String string2, String string3) {
        this.namespaceURI = string == null ? "" : string;
        if (string2 == null) {
            throw new IllegalArgumentException("local part cannot be \"null\" when creating a QName");
        }
        this.localPart = string2;
        if (string3 == null) {
            throw new IllegalArgumentException("prefix cannot be \"null\" when creating a QName");
        }
        this.prefix = string3;
    }

    public QName(String string) {
        this("", string, "");
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof QName) {
            QName qName = (QName)object;
            return this.localPart.equals(qName.localPart) && this.namespaceURI.equals(qName.namespaceURI);
        }
        return false;
    }

    public final int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = useDefaultHashCodeAlgorithm ? QName.hash(this.localPart) + QName.hash(this.namespaceURI) * hashMultipliers[32] : this.namespaceURI.hashCode() ^ this.localPart.hashCode();
            this.hashCode = n;
        }
        return n;
    }

    public String toString() {
        String string = this.qNameAsString;
        if (string == null) {
            int n = this.namespaceURI.length();
            if (n == 0) {
                string = this.localPart;
            } else {
                StringBuffer stringBuffer = new StringBuffer(n + this.localPart.length() + 2);
                stringBuffer.append('{');
                stringBuffer.append(this.namespaceURI);
                stringBuffer.append('}');
                stringBuffer.append(this.localPart);
                string = stringBuffer.toString();
            }
            this.qNameAsString = string;
        }
        return string;
    }

    public static QName valueOf(String string) {
        if (string == null) {
            throw new IllegalArgumentException("cannot create QName from \"null\" or \"\" String");
        }
        if (string.length() == 0) {
            return new QName("", string, "");
        }
        if (string.charAt(0) != '{') {
            return new QName("", string, "");
        }
        if (string.startsWith("{}")) {
            throw new IllegalArgumentException("Namespace URI .equals(XMLConstants.NULL_NS_URI), .equals(\"\"), only the local part, \"" + string.substring(2 + "".length()) + "\", " + "should be provided.");
        }
        int n = string.indexOf(125);
        if (n == -1) {
            throw new IllegalArgumentException("cannot create QName from \"" + string + "\", missing closing \"}\"");
        }
        return new QName(string.substring(1, n), string.substring(n + 1), "");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.prefix == null) {
            this.prefix = "";
        }
    }

    private static int hash(String string) {
        int n = 0;
        int n2 = string.length();
        int[] nArray = hashMultipliers;
        for (int i = 0; i < n2; ++i) {
            n = n * nArray[i & 0x1F] + string.charAt(i);
        }
        return n;
    }

    static {
        boolean bl;
        Object object;
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("org.apache.xml.namespace.QName.useCompatibleSerialVersionUID");
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        serialVersionUID = !"1.0".equals(string) ? -9120448754896609940L : 4418622981026545151L;
        try {
            object = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("javax.xml.namespace.QName.useCompatibleHashCodeAlgorithm");
                }
            });
            bl = object == null || !((String)object).equals("1.0");
        }
        catch (Exception exception) {
            bl = true;
        }
        useDefaultHashCodeAlgorithm = bl;
        if (useDefaultHashCodeAlgorithm) {
            hashMultipliers = new int[33];
            object = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727};
            Random random = new Random();
            for (int i = 0; i < hashMultipliers.length; ++i) {
                QName.hashMultipliers[i] = (int)object[random.nextInt(((Object)object).length)];
            }
        } else {
            hashMultipliers = null;
        }
    }
}

